#ifndef INCLUDED_OFFICECFG_OFFICE_DATAACCESS_HXX
#define INCLUDED_OFFICECFG_OFFICE_DATAACCESS_HXX

#include "sal/config.h"

#include <optional>
#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace DataAccess {

struct Policies: public comphelper::ConfigurationGroup< Policies> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies"_ustr); return PATH; }

struct Features: public comphelper::ConfigurationGroup< Features> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies/Features"_ustr); return PATH; }

struct Base: public comphelper::ConfigurationGroup< Base> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies/Features/Base"_ustr); return PATH; }

struct CreateLocalDatabase: public comphelper::ConfigurationProperty<CreateLocalDatabase, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies/Features/Base/CreateLocalDatabase"_ustr); return PATH; }
private:
    CreateLocalDatabase(); // not defined
    ~CreateLocalDatabase(); // not defined
};

private:
    Base(); // not defined
    ~Base(); // not defined
};

struct Writer: public comphelper::ConfigurationGroup< Writer> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies/Features/Writer"_ustr); return PATH; }

struct DatabaseFields: public comphelper::ConfigurationProperty<DatabaseFields, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies/Features/Writer/DatabaseFields"_ustr); return PATH; }
private:
    DatabaseFields(); // not defined
    ~DatabaseFields(); // not defined
};

private:
    Writer(); // not defined
    ~Writer(); // not defined
};

struct Common: public comphelper::ConfigurationGroup< Common> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies/Features/Common"_ustr); return PATH; }

struct EditDatabaseFromDataSourceView: public comphelper::ConfigurationProperty<EditDatabaseFromDataSourceView, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Policies/Features/Common/EditDatabaseFromDataSourceView"_ustr); return PATH; }
private:
    EditDatabaseFromDataSourceView(); // not defined
    ~EditDatabaseFromDataSourceView(); // not defined
};

private:
    Common(); // not defined
    ~Common(); // not defined
};

private:
    Features(); // not defined
    ~Features(); // not defined
};

private:
    Policies(); // not defined
    ~Policies(); // not defined
};

struct ReportEngines: public comphelper::ConfigurationGroup< ReportEngines> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/ReportEngines"_ustr); return PATH; }

struct DefaultReportEngine: public comphelper::ConfigurationProperty<DefaultReportEngine, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/ReportEngines/DefaultReportEngine"_ustr); return PATH; }
private:
    DefaultReportEngine(); // not defined
    ~DefaultReportEngine(); // not defined
};

struct ReportEngineNames: public comphelper::ConfigurationSet< ReportEngineNames> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/ReportEngines/ReportEngineNames"_ustr); return PATH; }
private:
    ReportEngineNames(); // not defined
    ~ReportEngineNames(); // not defined
};

private:
    ReportEngines(); // not defined
    ~ReportEngines(); // not defined
};

struct DriverManager: public comphelper::ConfigurationGroup< DriverManager> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverManager"_ustr); return PATH; }

struct DriverPrecedence: public comphelper::ConfigurationProperty<DriverPrecedence, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverManager/DriverPrecedence"_ustr); return PATH; }
private:
    DriverPrecedence(); // not defined
    ~DriverPrecedence(); // not defined
};

private:
    DriverManager(); // not defined
    ~DriverManager(); // not defined
};

struct ConnectionPool: public comphelper::ConfigurationGroup< ConnectionPool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/ConnectionPool"_ustr); return PATH; }

struct EnablePooling: public comphelper::ConfigurationProperty<EnablePooling, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/ConnectionPool/EnablePooling"_ustr); return PATH; }
private:
    EnablePooling(); // not defined
    ~EnablePooling(); // not defined
};

struct DriverSettings: public comphelper::ConfigurationSet< DriverSettings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/ConnectionPool/DriverSettings"_ustr); return PATH; }
private:
    DriverSettings(); // not defined
    ~DriverSettings(); // not defined
};

private:
    ConnectionPool(); // not defined
    ~ConnectionPool(); // not defined
};

struct JDBC: public comphelper::ConfigurationGroup< JDBC> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/JDBC"_ustr); return PATH; }

struct DriverClassPaths: public comphelper::ConfigurationSet< DriverClassPaths> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/JDBC/DriverClassPaths"_ustr); return PATH; }
private:
    DriverClassPaths(); // not defined
    ~DriverClassPaths(); // not defined
};

private:
    JDBC(); // not defined
    ~JDBC(); // not defined
};

struct RegisteredNames: public comphelper::ConfigurationSet< RegisteredNames> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/RegisteredNames"_ustr); return PATH; }
private:
    RegisteredNames(); // not defined
    ~RegisteredNames(); // not defined
};

struct AddressBook: public comphelper::ConfigurationGroup< AddressBook> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/AddressBook"_ustr); return PATH; }

struct DataSourceName: public comphelper::ConfigurationProperty<DataSourceName, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/AddressBook/DataSourceName"_ustr); return PATH; }
private:
    DataSourceName(); // not defined
    ~DataSourceName(); // not defined
};

struct Command: public comphelper::ConfigurationProperty<Command, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/AddressBook/Command"_ustr); return PATH; }
private:
    Command(); // not defined
    ~Command(); // not defined
};

struct CommandType: public comphelper::ConfigurationProperty<CommandType, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/AddressBook/CommandType"_ustr); return PATH; }
private:
    CommandType(); // not defined
    ~CommandType(); // not defined
};

struct AutoPilotCompleted: public comphelper::ConfigurationProperty<AutoPilotCompleted, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/AddressBook/AutoPilotCompleted"_ustr); return PATH; }
private:
    AutoPilotCompleted(); // not defined
    ~AutoPilotCompleted(); // not defined
};

struct Fields: public comphelper::ConfigurationSet< Fields> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/AddressBook/Fields"_ustr); return PATH; }
private:
    Fields(); // not defined
    ~Fields(); // not defined
};

private:
    AddressBook(); // not defined
    ~AddressBook(); // not defined
};

struct Bibliography: public comphelper::ConfigurationGroup< Bibliography> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Bibliography"_ustr); return PATH; }

struct BeamerHeight: public comphelper::ConfigurationProperty<BeamerHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Bibliography/BeamerHeight"_ustr); return PATH; }
private:
    BeamerHeight(); // not defined
    ~BeamerHeight(); // not defined
};

struct ViewHeight: public comphelper::ConfigurationProperty<ViewHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Bibliography/ViewHeight"_ustr); return PATH; }
private:
    ViewHeight(); // not defined
    ~ViewHeight(); // not defined
};

struct QueryText: public comphelper::ConfigurationProperty<QueryText, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Bibliography/QueryText"_ustr); return PATH; }
private:
    QueryText(); // not defined
    ~QueryText(); // not defined
};

struct QueryField: public comphelper::ConfigurationProperty<QueryField, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Bibliography/QueryField"_ustr); return PATH; }
private:
    QueryField(); // not defined
    ~QueryField(); // not defined
};

struct ShowColumnAssignmentWarning: public comphelper::ConfigurationProperty<ShowColumnAssignmentWarning, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Bibliography/ShowColumnAssignmentWarning"_ustr); return PATH; }
private:
    ShowColumnAssignmentWarning(); // not defined
    ~ShowColumnAssignmentWarning(); // not defined
};

struct DataSourceHistory: public comphelper::ConfigurationSet< DataSourceHistory> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/Bibliography/DataSourceHistory"_ustr); return PATH; }
private:
    DataSourceHistory(); // not defined
    ~DataSourceHistory(); // not defined
};

private:
    Bibliography(); // not defined
    ~Bibliography(); // not defined
};

struct DriverSettings: public comphelper::ConfigurationGroup< DriverSettings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings"_ustr); return PATH; }

struct com_sun_star_comp_sdbc_evoab_OEvoabDriver: public comphelper::ConfigurationGroup< com_sun_star_comp_sdbc_evoab_OEvoabDriver> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver"_ustr); return PATH; }

struct ColumnAliases: public comphelper::ConfigurationGroup< ColumnAliases> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases"_ustr); return PATH; }

struct FirstName: public comphelper::ConfigurationProperty<FirstName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/FirstName"_ustr); return PATH; }
private:
    FirstName(); // not defined
    ~FirstName(); // not defined
};

struct LastName: public comphelper::ConfigurationProperty<LastName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/LastName"_ustr); return PATH; }
private:
    LastName(); // not defined
    ~LastName(); // not defined
};

struct DisplayName: public comphelper::ConfigurationProperty<DisplayName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/DisplayName"_ustr); return PATH; }
private:
    DisplayName(); // not defined
    ~DisplayName(); // not defined
};

struct NickName: public comphelper::ConfigurationProperty<NickName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/NickName"_ustr); return PATH; }
private:
    NickName(); // not defined
    ~NickName(); // not defined
};

struct PrimaryEmail: public comphelper::ConfigurationProperty<PrimaryEmail, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/PrimaryEmail"_ustr); return PATH; }
private:
    PrimaryEmail(); // not defined
    ~PrimaryEmail(); // not defined
};

struct SecondEmail: public comphelper::ConfigurationProperty<SecondEmail, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/SecondEmail"_ustr); return PATH; }
private:
    SecondEmail(); // not defined
    ~SecondEmail(); // not defined
};

struct PreferMailFormat: public comphelper::ConfigurationProperty<PreferMailFormat, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/PreferMailFormat"_ustr); return PATH; }
private:
    PreferMailFormat(); // not defined
    ~PreferMailFormat(); // not defined
};

struct WorkPhone: public comphelper::ConfigurationProperty<WorkPhone, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WorkPhone"_ustr); return PATH; }
private:
    WorkPhone(); // not defined
    ~WorkPhone(); // not defined
};

struct HomePhone: public comphelper::ConfigurationProperty<HomePhone, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/HomePhone"_ustr); return PATH; }
private:
    HomePhone(); // not defined
    ~HomePhone(); // not defined
};

struct FaxNumber: public comphelper::ConfigurationProperty<FaxNumber, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/FaxNumber"_ustr); return PATH; }
private:
    FaxNumber(); // not defined
    ~FaxNumber(); // not defined
};

struct PagerNumber: public comphelper::ConfigurationProperty<PagerNumber, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/PagerNumber"_ustr); return PATH; }
private:
    PagerNumber(); // not defined
    ~PagerNumber(); // not defined
};

struct CellularNumber: public comphelper::ConfigurationProperty<CellularNumber, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/CellularNumber"_ustr); return PATH; }
private:
    CellularNumber(); // not defined
    ~CellularNumber(); // not defined
};

struct HomeAddress: public comphelper::ConfigurationProperty<HomeAddress, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/HomeAddress"_ustr); return PATH; }
private:
    HomeAddress(); // not defined
    ~HomeAddress(); // not defined
};

struct HomeAddress2: public comphelper::ConfigurationProperty<HomeAddress2, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/HomeAddress2"_ustr); return PATH; }
private:
    HomeAddress2(); // not defined
    ~HomeAddress2(); // not defined
};

struct HomeCity: public comphelper::ConfigurationProperty<HomeCity, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/HomeCity"_ustr); return PATH; }
private:
    HomeCity(); // not defined
    ~HomeCity(); // not defined
};

struct HomeState: public comphelper::ConfigurationProperty<HomeState, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/HomeState"_ustr); return PATH; }
private:
    HomeState(); // not defined
    ~HomeState(); // not defined
};

struct HomeZipCode: public comphelper::ConfigurationProperty<HomeZipCode, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/HomeZipCode"_ustr); return PATH; }
private:
    HomeZipCode(); // not defined
    ~HomeZipCode(); // not defined
};

struct HomeCountry: public comphelper::ConfigurationProperty<HomeCountry, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/HomeCountry"_ustr); return PATH; }
private:
    HomeCountry(); // not defined
    ~HomeCountry(); // not defined
};

struct WorkAddress: public comphelper::ConfigurationProperty<WorkAddress, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WorkAddress"_ustr); return PATH; }
private:
    WorkAddress(); // not defined
    ~WorkAddress(); // not defined
};

struct WorkAddress2: public comphelper::ConfigurationProperty<WorkAddress2, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WorkAddress2"_ustr); return PATH; }
private:
    WorkAddress2(); // not defined
    ~WorkAddress2(); // not defined
};

struct WorkCity: public comphelper::ConfigurationProperty<WorkCity, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WorkCity"_ustr); return PATH; }
private:
    WorkCity(); // not defined
    ~WorkCity(); // not defined
};

struct WorkState: public comphelper::ConfigurationProperty<WorkState, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WorkState"_ustr); return PATH; }
private:
    WorkState(); // not defined
    ~WorkState(); // not defined
};

struct WorkZipCode: public comphelper::ConfigurationProperty<WorkZipCode, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WorkZipCode"_ustr); return PATH; }
private:
    WorkZipCode(); // not defined
    ~WorkZipCode(); // not defined
};

struct WorkCountry: public comphelper::ConfigurationProperty<WorkCountry, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WorkCountry"_ustr); return PATH; }
private:
    WorkCountry(); // not defined
    ~WorkCountry(); // not defined
};

struct JobTitle: public comphelper::ConfigurationProperty<JobTitle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/JobTitle"_ustr); return PATH; }
private:
    JobTitle(); // not defined
    ~JobTitle(); // not defined
};

struct Department: public comphelper::ConfigurationProperty<Department, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/Department"_ustr); return PATH; }
private:
    Department(); // not defined
    ~Department(); // not defined
};

struct Company: public comphelper::ConfigurationProperty<Company, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/Company"_ustr); return PATH; }
private:
    Company(); // not defined
    ~Company(); // not defined
};

struct WebPage1: public comphelper::ConfigurationProperty<WebPage1, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WebPage1"_ustr); return PATH; }
private:
    WebPage1(); // not defined
    ~WebPage1(); // not defined
};

struct WebPage2: public comphelper::ConfigurationProperty<WebPage2, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/WebPage2"_ustr); return PATH; }
private:
    WebPage2(); // not defined
    ~WebPage2(); // not defined
};

struct BirthYear: public comphelper::ConfigurationProperty<BirthYear, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/BirthYear"_ustr); return PATH; }
private:
    BirthYear(); // not defined
    ~BirthYear(); // not defined
};

struct BirthMonth: public comphelper::ConfigurationProperty<BirthMonth, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/BirthMonth"_ustr); return PATH; }
private:
    BirthMonth(); // not defined
    ~BirthMonth(); // not defined
};

struct BirthDay: public comphelper::ConfigurationProperty<BirthDay, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/BirthDay"_ustr); return PATH; }
private:
    BirthDay(); // not defined
    ~BirthDay(); // not defined
};

struct Notes: public comphelper::ConfigurationProperty<Notes, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/DriverSettings/com.sun.star.comp.sdbc.evoab.OEvoabDriver/ColumnAliases/Notes"_ustr); return PATH; }
private:
    Notes(); // not defined
    ~Notes(); // not defined
};

private:
    ColumnAliases(); // not defined
    ~ColumnAliases(); // not defined
};

private:
    com_sun_star_comp_sdbc_evoab_OEvoabDriver(); // not defined
    ~com_sun_star_comp_sdbc_evoab_OEvoabDriver(); // not defined
};

private:
    DriverSettings(); // not defined
    ~DriverSettings(); // not defined
};

struct FormSearchOptions: public comphelper::ConfigurationGroup< FormSearchOptions> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions"_ustr); return PATH; }

struct SearchType: public comphelper::ConfigurationProperty<SearchType, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/SearchType"_ustr); return PATH; }
private:
    SearchType(); // not defined
    ~SearchType(); // not defined
};

struct SearchPosition: public comphelper::ConfigurationProperty<SearchPosition, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/SearchPosition"_ustr); return PATH; }
private:
    SearchPosition(); // not defined
    ~SearchPosition(); // not defined
};

struct SearchHistory: public comphelper::ConfigurationProperty<SearchHistory, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/SearchHistory"_ustr); return PATH; }
private:
    SearchHistory(); // not defined
    ~SearchHistory(); // not defined
};

struct IsSearchAllFields: public comphelper::ConfigurationProperty<IsSearchAllFields, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsSearchAllFields"_ustr); return PATH; }
private:
    IsSearchAllFields(); // not defined
    ~IsSearchAllFields(); // not defined
};

struct IsUseFormatter: public comphelper::ConfigurationProperty<IsUseFormatter, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsUseFormatter"_ustr); return PATH; }
private:
    IsUseFormatter(); // not defined
    ~IsUseFormatter(); // not defined
};

struct IsBackwards: public comphelper::ConfigurationProperty<IsBackwards, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsBackwards"_ustr); return PATH; }
private:
    IsBackwards(); // not defined
    ~IsBackwards(); // not defined
};

struct IsWildcardSearch: public comphelper::ConfigurationProperty<IsWildcardSearch, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsWildcardSearch"_ustr); return PATH; }
private:
    IsWildcardSearch(); // not defined
    ~IsWildcardSearch(); // not defined
};

struct IsUseRegularExpression: public comphelper::ConfigurationProperty<IsUseRegularExpression, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsUseRegularExpression"_ustr); return PATH; }
private:
    IsUseRegularExpression(); // not defined
    ~IsUseRegularExpression(); // not defined
};

struct IsSimilaritySearch: public comphelper::ConfigurationProperty<IsSimilaritySearch, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsSimilaritySearch"_ustr); return PATH; }
private:
    IsSimilaritySearch(); // not defined
    ~IsSimilaritySearch(); // not defined
};

struct IsLevenshteinRelaxed: public comphelper::ConfigurationProperty<IsLevenshteinRelaxed, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsLevenshteinRelaxed"_ustr); return PATH; }
private:
    IsLevenshteinRelaxed(); // not defined
    ~IsLevenshteinRelaxed(); // not defined
};

struct LevenshteinOther: public comphelper::ConfigurationProperty<LevenshteinOther, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/LevenshteinOther"_ustr); return PATH; }
private:
    LevenshteinOther(); // not defined
    ~LevenshteinOther(); // not defined
};

struct LevenshteinShorter: public comphelper::ConfigurationProperty<LevenshteinShorter, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/LevenshteinShorter"_ustr); return PATH; }
private:
    LevenshteinShorter(); // not defined
    ~LevenshteinShorter(); // not defined
};

struct LevenshteinLonger: public comphelper::ConfigurationProperty<LevenshteinLonger, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/LevenshteinLonger"_ustr); return PATH; }
private:
    LevenshteinLonger(); // not defined
    ~LevenshteinLonger(); // not defined
};

struct IsMatchCase: public comphelper::ConfigurationProperty<IsMatchCase, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsMatchCase"_ustr); return PATH; }
private:
    IsMatchCase(); // not defined
    ~IsMatchCase(); // not defined
};

struct IsIgnoreDiacritics_CTL: public comphelper::ConfigurationProperty<IsIgnoreDiacritics_CTL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsIgnoreDiacritics_CTL"_ustr); return PATH; }
private:
    IsIgnoreDiacritics_CTL(); // not defined
    ~IsIgnoreDiacritics_CTL(); // not defined
};

struct IsIgnoreKashida_CTL: public comphelper::ConfigurationProperty<IsIgnoreKashida_CTL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsIgnoreKashida_CTL"_ustr); return PATH; }
private:
    IsIgnoreKashida_CTL(); // not defined
    ~IsIgnoreKashida_CTL(); // not defined
};

struct IsUseAsianOptions: public comphelper::ConfigurationProperty<IsUseAsianOptions, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/IsUseAsianOptions"_ustr); return PATH; }
private:
    IsUseAsianOptions(); // not defined
    ~IsUseAsianOptions(); // not defined
};

struct Japanese: public comphelper::ConfigurationGroup< Japanese> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese"_ustr); return PATH; }

struct IsMatchFullHalfWidthForms: public comphelper::ConfigurationProperty<IsMatchFullHalfWidthForms, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatchFullHalfWidthForms"_ustr); return PATH; }
private:
    IsMatchFullHalfWidthForms(); // not defined
    ~IsMatchFullHalfWidthForms(); // not defined
};

struct IsMatchHiraganaKatakana: public comphelper::ConfigurationProperty<IsMatchHiraganaKatakana, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatchHiraganaKatakana"_ustr); return PATH; }
private:
    IsMatchHiraganaKatakana(); // not defined
    ~IsMatchHiraganaKatakana(); // not defined
};

struct IsMatchContractions: public comphelper::ConfigurationProperty<IsMatchContractions, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatchContractions"_ustr); return PATH; }
private:
    IsMatchContractions(); // not defined
    ~IsMatchContractions(); // not defined
};

struct IsMatchMinusDashCho_on: public comphelper::ConfigurationProperty<IsMatchMinusDashCho_on, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatchMinusDashCho-on"_ustr); return PATH; }
private:
    IsMatchMinusDashCho_on(); // not defined
    ~IsMatchMinusDashCho_on(); // not defined
};

struct IsMatchRepeatCharMarks: public comphelper::ConfigurationProperty<IsMatchRepeatCharMarks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatchRepeatCharMarks"_ustr); return PATH; }
private:
    IsMatchRepeatCharMarks(); // not defined
    ~IsMatchRepeatCharMarks(); // not defined
};

struct IsMatchVariantFormKanji: public comphelper::ConfigurationProperty<IsMatchVariantFormKanji, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatchVariantFormKanji"_ustr); return PATH; }
private:
    IsMatchVariantFormKanji(); // not defined
    ~IsMatchVariantFormKanji(); // not defined
};

struct IsMatchOldKanaForms: public comphelper::ConfigurationProperty<IsMatchOldKanaForms, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatchOldKanaForms"_ustr); return PATH; }
private:
    IsMatchOldKanaForms(); // not defined
    ~IsMatchOldKanaForms(); // not defined
};

struct IsMatch_DiZi_DuZu: public comphelper::ConfigurationProperty<IsMatch_DiZi_DuZu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatch_DiZi_DuZu"_ustr); return PATH; }
private:
    IsMatch_DiZi_DuZu(); // not defined
    ~IsMatch_DiZi_DuZu(); // not defined
};

struct IsMatch_BaVa_HaFa: public comphelper::ConfigurationProperty<IsMatch_BaVa_HaFa, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatch_BaVa_HaFa"_ustr); return PATH; }
private:
    IsMatch_BaVa_HaFa(); // not defined
    ~IsMatch_BaVa_HaFa(); // not defined
};

struct IsMatch_TsiThiChi_DhiZi: public comphelper::ConfigurationProperty<IsMatch_TsiThiChi_DhiZi, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatch_TsiThiChi_DhiZi"_ustr); return PATH; }
private:
    IsMatch_TsiThiChi_DhiZi(); // not defined
    ~IsMatch_TsiThiChi_DhiZi(); // not defined
};

struct IsMatch_HyuIyu_ByuVyu: public comphelper::ConfigurationProperty<IsMatch_HyuIyu_ByuVyu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatch_HyuIyu_ByuVyu"_ustr); return PATH; }
private:
    IsMatch_HyuIyu_ByuVyu(); // not defined
    ~IsMatch_HyuIyu_ByuVyu(); // not defined
};

struct IsMatch_SeShe_ZeJe: public comphelper::ConfigurationProperty<IsMatch_SeShe_ZeJe, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatch_SeShe_ZeJe"_ustr); return PATH; }
private:
    IsMatch_SeShe_ZeJe(); // not defined
    ~IsMatch_SeShe_ZeJe(); // not defined
};

struct IsMatch_IaIya: public comphelper::ConfigurationProperty<IsMatch_IaIya, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatch_IaIya"_ustr); return PATH; }
private:
    IsMatch_IaIya(); // not defined
    ~IsMatch_IaIya(); // not defined
};

struct IsMatch_KiKu: public comphelper::ConfigurationProperty<IsMatch_KiKu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsMatch_KiKu"_ustr); return PATH; }
private:
    IsMatch_KiKu(); // not defined
    ~IsMatch_KiKu(); // not defined
};

struct IsIgnorePunctuation: public comphelper::ConfigurationProperty<IsIgnorePunctuation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsIgnorePunctuation"_ustr); return PATH; }
private:
    IsIgnorePunctuation(); // not defined
    ~IsIgnorePunctuation(); // not defined
};

struct IsIgnoreWhitespace: public comphelper::ConfigurationProperty<IsIgnoreWhitespace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsIgnoreWhitespace"_ustr); return PATH; }
private:
    IsIgnoreWhitespace(); // not defined
    ~IsIgnoreWhitespace(); // not defined
};

struct IsIgnoreProlongedSoundMark: public comphelper::ConfigurationProperty<IsIgnoreProlongedSoundMark, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsIgnoreProlongedSoundMark"_ustr); return PATH; }
private:
    IsIgnoreProlongedSoundMark(); // not defined
    ~IsIgnoreProlongedSoundMark(); // not defined
};

struct IsIgnoreMiddleDot: public comphelper::ConfigurationProperty<IsIgnoreMiddleDot, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.DataAccess/FormSearchOptions/Japanese/IsIgnoreMiddleDot"_ustr); return PATH; }
private:
    IsIgnoreMiddleDot(); // not defined
    ~IsIgnoreMiddleDot(); // not defined
};

private:
    Japanese(); // not defined
    ~Japanese(); // not defined
};

private:
    FormSearchOptions(); // not defined
    ~FormSearchOptions(); // not defined
};

} } }

#endif
