/* profile.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from profile.vala, do not modify */

/*      profile.vala*/
/*      */
/*      Copyright 2011 Hong Jen Yee (PCMan) <pcman.tw@pcman.tw@gmail.com>*/
/*      */
/*      This program is free software; you can redistribute it and/or modify*/
/*      it under the terms of the GNU General Public License as published by*/
/*      the Free Software Foundation; either version 2 of the License, or*/
/*      (at your option) any later version.*/
/*      */
/*      This program is distributed in the hope that it will be useful,*/
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*      GNU General Public License for more details.*/
/*      */
/*      You should have received a copy of the GNU General Public License*/
/*      along with this program; if not, write to the Free Software*/
/*      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,*/
/*      MA 02110-1301, USA.*/
/*      */
/*      */

#include "fm-actions.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <fm-file-info.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _fm_file_action_condition_free0(var) ((var == NULL) ? NULL : (var = (fm_file_action_condition_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

static void fm_file_action_profile_instance_init (FmFileActionProfile * self);
VALA_EXTERN gchar* utils_key_file_get_string (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  const gchar* def_val);
VALA_EXTERN gboolean utils_key_file_get_bool (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  gboolean def_val);
static gboolean fm_file_action_profile_launch_once (FmFileActionProfile* self,
                                             GAppLaunchContext* ctx,
                                             FmFileInfo* first_file,
                                             GList* files,
                                             gchar** output);

static GType
fm_file_action_exec_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{FM_FILE_ACTION_EXEC_MODE_NORMAL, "FM_FILE_ACTION_EXEC_MODE_NORMAL", "normal"}, {FM_FILE_ACTION_EXEC_MODE_TERMINAL, "FM_FILE_ACTION_EXEC_MODE_TERMINAL", "terminal"}, {FM_FILE_ACTION_EXEC_MODE_EMBEDDED, "FM_FILE_ACTION_EXEC_MODE_EMBEDDED", "embedded"}, {FM_FILE_ACTION_EXEC_MODE_DISPLAY_OUTPUT, "FM_FILE_ACTION_EXEC_MODE_DISPLAY_OUTPUT", "display-output"}, {0, NULL, NULL}};
	GType fm_file_action_exec_mode_type_id;
	fm_file_action_exec_mode_type_id = g_enum_register_static ("FmFileActionExecMode", values);
	return fm_file_action_exec_mode_type_id;
}

GType
fm_file_action_exec_mode_get_type (void)
{
	static volatile gsize fm_file_action_exec_mode_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_exec_mode_type_id__once)) {
		GType fm_file_action_exec_mode_type_id;
		fm_file_action_exec_mode_type_id = fm_file_action_exec_mode_get_type_once ();
		g_once_init_leave (&fm_file_action_exec_mode_type_id__once, fm_file_action_exec_mode_type_id);
	}
	return fm_file_action_exec_mode_type_id__once;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

FmFileActionProfile*
fm_file_action_profile_new (GKeyFile* kf,
                            const gchar* profile_name)
{
	FmFileActionProfile* self;
	gchar* _tmp0_;
	gchar* group_name = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* s = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	FmFileActionCondition* _tmp21_;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (profile_name != NULL, NULL);
	self = g_slice_new0 (FmFileActionProfile);
	fm_file_action_profile_instance_init (self);
	_tmp0_ = g_strdup (profile_name);
	_g_free0 (self->id);
	self->id = _tmp0_;
	_tmp1_ = string_to_string (profile_name);
	_tmp2_ = g_strconcat ("X-Action-Profile ", _tmp1_, NULL);
	group_name = _tmp2_;
	_tmp3_ = group_name;
	_tmp4_ = utils_key_file_get_string (kf, _tmp3_, "Name", NULL);
	_g_free0 (self->name);
	self->name = _tmp4_;
	_tmp5_ = group_name;
	_tmp6_ = utils_key_file_get_string (kf, _tmp5_, "Exec", NULL);
	_g_free0 (self->exec);
	self->exec = _tmp6_;
	_tmp7_ = group_name;
	_tmp8_ = utils_key_file_get_string (kf, _tmp7_, "Path", NULL);
	_g_free0 (self->path);
	self->path = _tmp8_;
	_tmp9_ = group_name;
	_tmp10_ = utils_key_file_get_string (kf, _tmp9_, "ExecutionMode", NULL);
	s = _tmp10_;
	_tmp11_ = s;
	if (g_strcmp0 (_tmp11_, "Normal") == 0) {
		self->exec_mode = FM_FILE_ACTION_EXEC_MODE_NORMAL;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = s;
		if (g_strcmp0 (_tmp12_, "Terminal") == 0) {
			self->exec_mode = FM_FILE_ACTION_EXEC_MODE_TERMINAL;
		} else {
			const gchar* _tmp13_;
			_tmp13_ = s;
			if (g_strcmp0 (_tmp13_, "Embedded") == 0) {
				self->exec_mode = FM_FILE_ACTION_EXEC_MODE_EMBEDDED;
			} else {
				const gchar* _tmp14_;
				_tmp14_ = s;
				if (g_strcmp0 (_tmp14_, "DisplayOutput") == 0) {
					self->exec_mode = FM_FILE_ACTION_EXEC_MODE_DISPLAY_OUTPUT;
				} else {
					self->exec_mode = FM_FILE_ACTION_EXEC_MODE_NORMAL;
				}
			}
		}
	}
	_tmp15_ = group_name;
	self->startup_notify = utils_key_file_get_bool (kf, _tmp15_, "StartupNotify", FALSE);
	_tmp16_ = group_name;
	_tmp17_ = utils_key_file_get_string (kf, _tmp16_, "StartupWMClass", NULL);
	_g_free0 (self->startup_wm_class);
	self->startup_wm_class = _tmp17_;
	_tmp18_ = group_name;
	_tmp19_ = utils_key_file_get_string (kf, _tmp18_, "ExecuteAs", NULL);
	_g_free0 (self->exec_as);
	self->exec_as = _tmp19_;
	_tmp20_ = group_name;
	_tmp21_ = fm_file_action_condition_new (kf, _tmp20_);
	_fm_file_action_condition_free0 (self->condition);
	self->condition = _tmp21_;
	_g_free0 (s);
	_g_free0 (group_name);
	return self;
}

static gboolean
fm_file_action_profile_launch_once (FmFileActionProfile* self,
                                    GAppLaunchContext* ctx,
                                    FmFileInfo* first_file,
                                    GList* files,
                                    gchar** output)
{
	gchar* _vala_output = NULL;
	const gchar* _tmp0_;
	gchar* exec_cmd = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->exec;
	if (_tmp0_ == NULL) {
		result = FALSE;
		if (output) {
			*output = _vala_output;
		} else {
			_g_free0 (_vala_output);
		}
		return result;
	}
	_tmp1_ = self->exec;
	_tmp2_ = fm_file_action_parameters_expand (_tmp1_, files, FALSE, first_file);
	exec_cmd = _tmp2_;
	_tmp3_ = stdout;
	_tmp4_ = self->id;
	_tmp5_ = exec_cmd;
	fprintf (_tmp3_, "Profile: %s\nlaunch command: %s\n\n", _tmp4_, _tmp5_);
	ret = FALSE;
	if (self->exec_mode == FM_FILE_ACTION_EXEC_MODE_DISPLAY_OUTPUT) {
		{
			gint exit_status = 0;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gboolean _tmp10_;
			_tmp7_ = exec_cmd;
			_tmp10_ = g_spawn_command_line_sync (_tmp7_, &_tmp8_, NULL, &_tmp9_, &_inner_error0_);
			_g_free0 (_vala_output);
			_vala_output = _tmp8_;
			exit_status = _tmp9_;
			_tmp6_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp11_ = FALSE;
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (exec_cmd);
				_g_free0 (_vala_output);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp11_;
			}
			ret = _tmp6_;
			if (ret) {
				ret = exit_status == 0;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp12_ = FALSE;
			_g_free0 (exec_cmd);
			_g_free0 (_vala_output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp12_;
		}
	} else {
		{
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = exec_cmd;
			_tmp13_ = g_spawn_command_line_async (_tmp14_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp15_ = FALSE;
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch1_g_spawn_error;
				}
				_g_free0 (exec_cmd);
				_g_free0 (_vala_output);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp15_;
			}
			ret = _tmp13_;
		}
		goto __finally1;
		__catch1_g_spawn_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			_g_free0 (exec_cmd);
			_g_free0 (_vala_output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	}
	result = ret;
	_g_free0 (exec_cmd);
	if (output) {
		*output = _vala_output;
	} else {
		_g_free0 (_vala_output);
	}
	return result;
}

gboolean
fm_file_action_profile_launch (FmFileActionProfile* self,
                               GAppLaunchContext* ctx,
                               GList* files,
                               gchar** output)
{
	gchar* _vala_output = NULL;
	gboolean plural_form = FALSE;
	const gchar* _tmp0_;
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->exec;
	plural_form = fm_file_action_parameters_is_plural (_tmp0_);
	if (plural_form) {
		GList* _tmp1_;
		gconstpointer _tmp2_;
		gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp1_ = g_list_first (files);
		_tmp2_ = _tmp1_->data;
		_tmp4_ = fm_file_action_profile_launch_once (self, ctx, (FmFileInfo*) _tmp2_, files, &_tmp3_);
		_g_free0 (_vala_output);
		_vala_output = _tmp3_;
		ret = _tmp4_;
	} else {
		GString* all_output = NULL;
		const gchar* _tmp5_;
		gboolean _tmp15_ = FALSE;
		GString* _tmp16_;
		all_output = NULL;
		_tmp5_ = _vala_output;
		if (_tmp5_ != NULL) {
			GString* _tmp6_;
			_tmp6_ = g_string_new ("");
			_g_string_free0 (all_output);
			all_output = _tmp6_;
		}
		{
			GList* fi_collection = NULL;
			GList* fi_it = NULL;
			fi_collection = files;
			for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
				FmFileInfo* fi = NULL;
				fi = (FmFileInfo*) fi_it->data;
				{
					gchar* one_output = NULL;
					FmFileInfo* _tmp7_;
					gchar* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
					GString* _tmp10_;
					_tmp7_ = fi;
					fm_file_action_profile_launch_once (self, ctx, _tmp7_, files, &_tmp8_);
					_g_free0 (one_output);
					one_output = _tmp8_;
					_tmp10_ = all_output;
					if (_tmp10_ != NULL) {
						const gchar* _tmp11_;
						_tmp11_ = one_output;
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						GString* _tmp12_;
						const gchar* _tmp13_;
						GString* _tmp14_;
						_tmp12_ = all_output;
						_tmp13_ = one_output;
						g_string_append (_tmp12_, _tmp13_);
						_tmp14_ = all_output;
						g_string_append (_tmp14_, "\n");
					}
					_g_free0 (one_output);
				}
			}
		}
		_tmp16_ = all_output;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_;
			_tmp17_ = _vala_output;
			_tmp15_ = _tmp17_ != NULL;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GString* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = all_output;
			_tmp19_ = _tmp18_->str;
			_tmp18_->str = NULL;
			_g_free0 (_vala_output);
			_vala_output = _tmp19_;
		}
		ret = TRUE;
		_g_string_free0 (all_output);
	}
	result = ret;
	if (output) {
		*output = _vala_output;
	} else {
		_g_free0 (_vala_output);
	}
	return result;
}

gboolean
fm_file_action_profile_match (FmFileActionProfile* self,
                              GList* files)
{
	FILE* _tmp0_;
	const gchar* _tmp1_;
	FmFileActionCondition* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = stdout;
	_tmp1_ = self->id;
	fprintf (_tmp0_, "  match profile: %s\n", _tmp1_);
	_tmp2_ = self->condition;
	result = fm_file_action_condition_match (_tmp2_, files);
	return result;
}

static void
fm_file_action_profile_instance_init (FmFileActionProfile * self)
{
}

void
fm_file_action_profile_free (FmFileActionProfile * self)
{
	_g_free0 (self->id);
	_g_free0 (self->name);
	_g_free0 (self->exec);
	_g_free0 (self->path);
	_g_free0 (self->startup_wm_class);
	_g_free0 (self->exec_as);
	_fm_file_action_condition_free0 (self->condition);
	g_slice_free (FmFileActionProfile, self);
}

