#include "nv_push_clb1c0.h"

#include <stdio.h>





const char *P_PARSE_NVB0C0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVB0C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVB1C0_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVB0C0_MTHD(idx);

                                                                                                                                                                                                                                                            case NVB1C0_SET_GWC_SCG_TYPE:
        return "NVB1C0_SET_GWC_SCG_TYPE";
    case NVB1C0_SET_SCG_CONTROL:
        return "NVB1C0_SET_SCG_CONTROL";
                            case NVB1C0_SET_WFI_CONFIG:
        return "NVB1C0_SET_WFI_CONFIG";
        case NVB1C0_WAIT_FOR_IDLE_SCG_TYPE:
        return "NVB1C0_WAIT_FOR_IDLE_SCG_TYPE";
    case NVB1C0_INVALIDATE_SKED_CACHES:
        return "NVB1C0_INVALIDATE_SKED_CACHES";
    case NVB1C0_SET_SCG_RENDER_ENABLE_CONTROL:
        return "NVB1C0_SET_SCG_RENDER_ENABLE_CONTROL";
                                                                                                                                                                                                                                                                    case NVB1C0_INVALIDATE_SAMPLER_CACHE_ALL:
        return "NVB1C0_INVALIDATE_SAMPLER_CACHE_ALL";
    case NVB1C0_INVALIDATE_TEXTURE_HEADER_CACHE_ALL:
        return "NVB1C0_INVALIDATE_TEXTURE_HEADER_CACHE_ALL";
                                                                                                                                                                
    }
}

void
P_DUMP_NVB1C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVB0C0_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                                                                                                                                                                                                                          
    case NVB1C0_SET_GWC_SCG_TYPE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCG_TYPE = ", prefix);
        switch (parsed) {
        case NVB1C0_SET_GWC_SCG_TYPE_SCG_TYPE_GRAPHICS_COMPUTE0:
            fprintf(fp, "GRAPHICS_COMPUTE0\n");
            break;
        case NVB1C0_SET_GWC_SCG_TYPE_SCG_TYPE_COMPUTE1:
            fprintf(fp, "COMPUTE1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVB1C0_SET_SCG_CONTROL:

    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.COMPUTE1_MAX_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                          
    case NVB1C0_SET_WFI_CONFIG:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE_SCG_TYPE_WFI = ", prefix);
        switch (parsed) {
        case NVB1C0_SET_WFI_CONFIG_ENABLE_SCG_TYPE_WFI_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB1C0_SET_WFI_CONFIG_ENABLE_SCG_TYPE_WFI_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NVB1C0_WAIT_FOR_IDLE_SCG_TYPE:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB1C0_INVALIDATE_SKED_CACHES:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB1C0_SET_SCG_RENDER_ENABLE_CONTROL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.COMPUTE1_USES_RENDER_ENABLE = ", prefix);
        switch (parsed) {
        case NVB1C0_SET_SCG_RENDER_ENABLE_CONTROL_COMPUTE1_USES_RENDER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVB1C0_SET_SCG_RENDER_ENABLE_CONTROL_COMPUTE1_USES_RENDER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                  
    case NVB1C0_INVALIDATE_SAMPLER_CACHE_ALL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVB1C0_INVALIDATE_TEXTURE_HEADER_CACHE_ALL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                    }
}
