// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_transform_guest
//
// (impl) generated by ../mesa-25.3.2/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.2/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.2/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/lib32-mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_transform_guest.h"
#include "goldfish_vk_extension_structs_guest.h"
#include "goldfish_vk_private_defs.h"

#include <cstring>

#include "ResourceTracker.h"

namespace gfxstream {
namespace vk {

void transform_tohost_extension_struct(
    ResourceTracker* resourceTracker,
    void* structExtension_out);

void transform_fromhost_extension_struct(
    ResourceTracker* resourceTracker,
    void* structExtension_out);

#ifdef VK_VERSION_1_0
void transform_tohost_VkExtent2D(
    ResourceTracker* resourceTracker,
    VkExtent2D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExtent2D(
    ResourceTracker* resourceTracker,
    VkExtent2D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkExtent3D(
    ResourceTracker* resourceTracker,
    VkExtent3D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExtent3D(
    ResourceTracker* resourceTracker,
    VkExtent3D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkOffset2D(
    ResourceTracker* resourceTracker,
    VkOffset2D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkOffset2D(
    ResourceTracker* resourceTracker,
    VkOffset2D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkOffset3D(
    ResourceTracker* resourceTracker,
    VkOffset3D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkOffset3D(
    ResourceTracker* resourceTracker,
    VkOffset3D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkRect2D(
    ResourceTracker* resourceTracker,
    VkRect2D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_tohost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_fromhost_VkRect2D(
    ResourceTracker* resourceTracker,
    VkRect2D* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_fromhost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_tohost_VkBaseInStructure(
    ResourceTracker* resourceTracker,
    VkBaseInStructure* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBaseInStructure(
    ResourceTracker* resourceTracker,
    VkBaseInStructure* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBaseOutStructure(
    ResourceTracker* resourceTracker,
    VkBaseOutStructure* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBaseOutStructure(
    ResourceTracker* resourceTracker,
    VkBaseOutStructure* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDispatchIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDispatchIndirectCommand* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDispatchIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDispatchIndirectCommand* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDrawIndexedIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndexedIndirectCommand* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDrawIndexedIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndexedIndirectCommand* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDrawIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndirectCommand* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDrawIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndirectCommand* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageSubresourceRange(
    ResourceTracker* resourceTracker,
    VkImageSubresourceRange* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkImageSubresourceRange(
    ResourceTracker* resourceTracker,
    VkImageSubresourceRange* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_fromhost_VkImageMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_tohost_VkMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineCacheHeaderVersionOne(
    ResourceTracker* resourceTracker,
    VkPipelineCacheHeaderVersionOne* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineCacheHeaderVersionOne(
    ResourceTracker* resourceTracker,
    VkPipelineCacheHeaderVersionOne* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkAllocationCallbacks(
    ResourceTracker* resourceTracker,
    VkAllocationCallbacks* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkAllocationCallbacks(
    ResourceTracker* resourceTracker,
    VkAllocationCallbacks* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkApplicationInfo(
    ResourceTracker* resourceTracker,
    VkApplicationInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkApplicationInfo(
    ResourceTracker* resourceTracker,
    VkApplicationInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFormatProperties(
    ResourceTracker* resourceTracker,
    VkFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkFormatProperties(
    ResourceTracker* resourceTracker,
    VkFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->maxExtent));
}

void transform_fromhost_VkImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->maxExtent));
}

void transform_tohost_VkInstanceCreateInfo(
    ResourceTracker* resourceTracker,
    VkInstanceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pApplicationInfo)
    {
        transform_tohost_VkApplicationInfo(resourceTracker, (VkApplicationInfo*)(toTransform->pApplicationInfo));
    }
}

void transform_fromhost_VkInstanceCreateInfo(
    ResourceTracker* resourceTracker,
    VkInstanceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pApplicationInfo)
    {
        transform_fromhost_VkApplicationInfo(resourceTracker, (VkApplicationInfo*)(toTransform->pApplicationInfo));
    }
}

void transform_tohost_VkMemoryHeap(
    ResourceTracker* resourceTracker,
    VkMemoryHeap* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkMemoryHeap(
    ResourceTracker* resourceTracker,
    VkMemoryHeap* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkMemoryType(
    ResourceTracker* resourceTracker,
    VkMemoryType* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkMemoryType(
    ResourceTracker* resourceTracker,
    VkMemoryType* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPhysicalDeviceFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceLimits(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLimits* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPhysicalDeviceLimits(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLimits* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i)
    {
        transform_tohost_VkMemoryType(resourceTracker, (VkMemoryType*)(toTransform->memoryTypes + i));
    }
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i)
    {
        transform_tohost_VkMemoryHeap(resourceTracker, (VkMemoryHeap*)(toTransform->memoryHeaps + i));
    }
}

void transform_fromhost_VkPhysicalDeviceMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i)
    {
        transform_fromhost_VkMemoryType(resourceTracker, (VkMemoryType*)(toTransform->memoryTypes + i));
    }
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i)
    {
        transform_fromhost_VkMemoryHeap(resourceTracker, (VkMemoryHeap*)(toTransform->memoryHeaps + i));
    }
}

void transform_tohost_VkPhysicalDeviceSparseProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPhysicalDeviceSparseProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkPhysicalDeviceLimits(resourceTracker, (VkPhysicalDeviceLimits*)(&toTransform->limits));
    transform_tohost_VkPhysicalDeviceSparseProperties(resourceTracker, (VkPhysicalDeviceSparseProperties*)(&toTransform->sparseProperties));
}

void transform_fromhost_VkPhysicalDeviceProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkPhysicalDeviceLimits(resourceTracker, (VkPhysicalDeviceLimits*)(&toTransform->limits));
    transform_fromhost_VkPhysicalDeviceSparseProperties(resourceTracker, (VkPhysicalDeviceSparseProperties*)(&toTransform->sparseProperties));
}

void transform_tohost_VkQueueFamilyProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->minImageTransferGranularity));
}

void transform_fromhost_VkQueueFamilyProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->minImageTransferGranularity));
}

void transform_tohost_VkDeviceQueueCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceQueueCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pQueueCreateInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->queueCreateInfoCount; ++i)
            {
                transform_tohost_VkDeviceQueueCreateInfo(resourceTracker, (VkDeviceQueueCreateInfo*)(toTransform->pQueueCreateInfos + i));
            }
        }
    }
    if (toTransform->pEnabledFeatures)
    {
        transform_tohost_VkPhysicalDeviceFeatures(resourceTracker, (VkPhysicalDeviceFeatures*)(toTransform->pEnabledFeatures));
    }
}

void transform_fromhost_VkDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pQueueCreateInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->queueCreateInfoCount; ++i)
            {
                transform_fromhost_VkDeviceQueueCreateInfo(resourceTracker, (VkDeviceQueueCreateInfo*)(toTransform->pQueueCreateInfos + i));
            }
        }
    }
    if (toTransform->pEnabledFeatures)
    {
        transform_fromhost_VkPhysicalDeviceFeatures(resourceTracker, (VkPhysicalDeviceFeatures*)(toTransform->pEnabledFeatures));
    }
}

void transform_tohost_VkExtensionProperties(
    ResourceTracker* resourceTracker,
    VkExtensionProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExtensionProperties(
    ResourceTracker* resourceTracker,
    VkExtensionProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkLayerProperties(
    ResourceTracker* resourceTracker,
    VkLayerProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkLayerProperties(
    ResourceTracker* resourceTracker,
    VkLayerProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMappedMemoryRange(
    ResourceTracker* resourceTracker,
    VkMappedMemoryRange* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->offset, 1, (VkDeviceSize*)&toTransform->size, 1, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMappedMemoryRange(
    ResourceTracker* resourceTracker,
    VkMappedMemoryRange* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->offset, 1, (VkDeviceSize*)&toTransform->size, 1, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (uint32_t*)&toTransform->memoryTypeIndex, 1, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (uint32_t*)&toTransform->memoryTypeIndex, 1, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)&toTransform->memoryTypeBits, 1);
}

void transform_fromhost_VkMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)&toTransform->memoryTypeBits, 1);
}

void transform_tohost_VkSparseMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseMemoryBind* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
}

void transform_fromhost_VkSparseMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseMemoryBind* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
}

void transform_tohost_VkSparseBufferMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseBufferMemoryBindInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i)
            {
                transform_tohost_VkSparseMemoryBind(resourceTracker, (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_fromhost_VkSparseBufferMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseBufferMemoryBindInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i)
            {
                transform_fromhost_VkSparseMemoryBind(resourceTracker, (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_tohost_VkSparseImageOpaqueMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageOpaqueMemoryBindInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i)
            {
                transform_tohost_VkSparseMemoryBind(resourceTracker, (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_fromhost_VkSparseImageOpaqueMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageOpaqueMemoryBindInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i)
            {
                transform_fromhost_VkSparseMemoryBind(resourceTracker, (VkSparseMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_tohost_VkImageSubresource(
    ResourceTracker* resourceTracker,
    VkImageSubresource* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkImageSubresource(
    ResourceTracker* resourceTracker,
    VkImageSubresource* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkSparseImageMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBind* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    transform_tohost_VkImageSubresource(resourceTracker, (VkImageSubresource*)(&toTransform->subresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->offset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkSparseImageMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBind* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    transform_fromhost_VkImageSubresource(resourceTracker, (VkImageSubresource*)(&toTransform->subresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->offset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkSparseImageMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBindInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i)
            {
                transform_tohost_VkSparseImageMemoryBind(resourceTracker, (VkSparseImageMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_fromhost_VkSparseImageMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBindInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindCount; ++i)
            {
                transform_fromhost_VkSparseImageMemoryBind(resourceTracker, (VkSparseImageMemoryBind*)(toTransform->pBinds + i));
            }
        }
    }
}

void transform_tohost_VkBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkBindSparseInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pBufferBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferBindCount; ++i)
            {
                transform_tohost_VkSparseBufferMemoryBindInfo(resourceTracker, (VkSparseBufferMemoryBindInfo*)(toTransform->pBufferBinds + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pImageOpaqueBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageOpaqueBindCount; ++i)
            {
                transform_tohost_VkSparseImageOpaqueMemoryBindInfo(resourceTracker, (VkSparseImageOpaqueMemoryBindInfo*)(toTransform->pImageOpaqueBinds + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pImageBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageBindCount; ++i)
            {
                transform_tohost_VkSparseImageMemoryBindInfo(resourceTracker, (VkSparseImageMemoryBindInfo*)(toTransform->pImageBinds + i));
            }
        }
    }
}

void transform_fromhost_VkBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkBindSparseInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pBufferBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferBindCount; ++i)
            {
                transform_fromhost_VkSparseBufferMemoryBindInfo(resourceTracker, (VkSparseBufferMemoryBindInfo*)(toTransform->pBufferBinds + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pImageOpaqueBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageOpaqueBindCount; ++i)
            {
                transform_fromhost_VkSparseImageOpaqueMemoryBindInfo(resourceTracker, (VkSparseImageOpaqueMemoryBindInfo*)(toTransform->pImageOpaqueBinds + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pImageBinds)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageBindCount; ++i)
            {
                transform_fromhost_VkSparseImageMemoryBindInfo(resourceTracker, (VkSparseImageMemoryBindInfo*)(toTransform->pImageBinds + i));
            }
        }
    }
}

void transform_tohost_VkSparseImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageGranularity));
}

void transform_fromhost_VkSparseImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageGranularity));
}

void transform_tohost_VkSparseImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkSparseImageFormatProperties(resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->formatProperties));
}

void transform_fromhost_VkSparseImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkSparseImageFormatProperties(resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->formatProperties));
}

void transform_tohost_VkFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkFenceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkFenceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkEventCreateInfo(
    ResourceTracker* resourceTracker,
    VkEventCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkEventCreateInfo(
    ResourceTracker* resourceTracker,
    VkEventCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkQueryPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkQueryPoolCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkQueryPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkQueryPoolCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferViewCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferViewCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkSubresourceLayout(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkSubresourceLayout(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkComponentMapping(
    ResourceTracker* resourceTracker,
    VkComponentMapping* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkComponentMapping(
    ResourceTracker* resourceTracker,
    VkComponentMapping* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkComponentMapping(resourceTracker, (VkComponentMapping*)(&toTransform->components));
    transform_tohost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_fromhost_VkImageViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkComponentMapping(resourceTracker, (VkComponentMapping*)(&toTransform->components));
    transform_fromhost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_tohost_VkShaderModuleCreateInfo(
    ResourceTracker* resourceTracker,
    VkShaderModuleCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkShaderModuleCreateInfo(
    ResourceTracker* resourceTracker,
    VkShaderModuleCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineCacheCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCacheCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineCacheCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCacheCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSpecializationMapEntry(
    ResourceTracker* resourceTracker,
    VkSpecializationMapEntry* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkSpecializationMapEntry(
    ResourceTracker* resourceTracker,
    VkSpecializationMapEntry* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkSpecializationInfo(
    ResourceTracker* resourceTracker,
    VkSpecializationInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pMapEntries)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->mapEntryCount; ++i)
            {
                transform_tohost_VkSpecializationMapEntry(resourceTracker, (VkSpecializationMapEntry*)(toTransform->pMapEntries + i));
            }
        }
    }
}

void transform_fromhost_VkSpecializationInfo(
    ResourceTracker* resourceTracker,
    VkSpecializationInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pMapEntries)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->mapEntryCount; ++i)
            {
                transform_fromhost_VkSpecializationMapEntry(resourceTracker, (VkSpecializationMapEntry*)(toTransform->pMapEntries + i));
            }
        }
    }
}

void transform_tohost_VkPipelineShaderStageCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pSpecializationInfo)
    {
        transform_tohost_VkSpecializationInfo(resourceTracker, (VkSpecializationInfo*)(toTransform->pSpecializationInfo));
    }
}

void transform_fromhost_VkPipelineShaderStageCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pSpecializationInfo)
    {
        transform_fromhost_VkSpecializationInfo(resourceTracker, (VkSpecializationInfo*)(toTransform->pSpecializationInfo));
    }
}

void transform_tohost_VkComputePipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkComputePipelineCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPipelineShaderStageCreateInfo(resourceTracker, (VkPipelineShaderStageCreateInfo*)(&toTransform->stage));
}

void transform_fromhost_VkComputePipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkComputePipelineCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPipelineShaderStageCreateInfo(resourceTracker, (VkPipelineShaderStageCreateInfo*)(&toTransform->stage));
}

void transform_tohost_VkVertexInputBindingDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkVertexInputBindingDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkVertexInputAttributeDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputAttributeDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkVertexInputAttributeDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputAttributeDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineVertexInputStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pVertexBindingDescriptions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexBindingDescriptionCount; ++i)
            {
                transform_tohost_VkVertexInputBindingDescription(resourceTracker, (VkVertexInputBindingDescription*)(toTransform->pVertexBindingDescriptions + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pVertexAttributeDescriptions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexAttributeDescriptionCount; ++i)
            {
                transform_tohost_VkVertexInputAttributeDescription(resourceTracker, (VkVertexInputAttributeDescription*)(toTransform->pVertexAttributeDescriptions + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineVertexInputStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pVertexBindingDescriptions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexBindingDescriptionCount; ++i)
            {
                transform_fromhost_VkVertexInputBindingDescription(resourceTracker, (VkVertexInputBindingDescription*)(toTransform->pVertexBindingDescriptions + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pVertexAttributeDescriptions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexAttributeDescriptionCount; ++i)
            {
                transform_fromhost_VkVertexInputAttributeDescription(resourceTracker, (VkVertexInputAttributeDescription*)(toTransform->pVertexAttributeDescriptions + i));
            }
        }
    }
}

void transform_tohost_VkPipelineInputAssemblyStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineInputAssemblyStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineInputAssemblyStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineInputAssemblyStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineTessellationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineTessellationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkViewport(
    ResourceTracker* resourceTracker,
    VkViewport* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkViewport(
    ResourceTracker* resourceTracker,
    VkViewport* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineViewportStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineViewportStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pViewports)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->viewportCount; ++i)
            {
                transform_tohost_VkViewport(resourceTracker, (VkViewport*)(toTransform->pViewports + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pScissors)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->scissorCount; ++i)
            {
                transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(toTransform->pScissors + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineViewportStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineViewportStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pViewports)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->viewportCount; ++i)
            {
                transform_fromhost_VkViewport(resourceTracker, (VkViewport*)(toTransform->pViewports + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pScissors)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->scissorCount; ++i)
            {
                transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(toTransform->pScissors + i));
            }
        }
    }
}

void transform_tohost_VkPipelineRasterizationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineMultisampleStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineMultisampleStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineMultisampleStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineMultisampleStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkStencilOpState(
    ResourceTracker* resourceTracker,
    VkStencilOpState* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkStencilOpState(
    ResourceTracker* resourceTracker,
    VkStencilOpState* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineDepthStencilStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDepthStencilStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->front));
    transform_tohost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->back));
}

void transform_fromhost_VkPipelineDepthStencilStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDepthStencilStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->front));
    transform_fromhost_VkStencilOpState(resourceTracker, (VkStencilOpState*)(&toTransform->back));
}

void transform_tohost_VkPipelineColorBlendAttachmentState(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendAttachmentState* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineColorBlendAttachmentState(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendAttachmentState* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineColorBlendStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i)
            {
                transform_tohost_VkPipelineColorBlendAttachmentState(resourceTracker, (VkPipelineColorBlendAttachmentState*)(toTransform->pAttachments + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineColorBlendStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i)
            {
                transform_fromhost_VkPipelineColorBlendAttachmentState(resourceTracker, (VkPipelineColorBlendAttachmentState*)(toTransform->pAttachments + i));
            }
        }
    }
}

void transform_tohost_VkPipelineDynamicStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDynamicStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineDynamicStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDynamicStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkGraphicsPipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pStages)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->stageCount; ++i)
            {
                transform_tohost_VkPipelineShaderStageCreateInfo(resourceTracker, (VkPipelineShaderStageCreateInfo*)(toTransform->pStages + i));
            }
        }
    }
    if (toTransform->pVertexInputState)
    {
        transform_tohost_VkPipelineVertexInputStateCreateInfo(resourceTracker, (VkPipelineVertexInputStateCreateInfo*)(toTransform->pVertexInputState));
    }
    if (toTransform->pInputAssemblyState)
    {
        transform_tohost_VkPipelineInputAssemblyStateCreateInfo(resourceTracker, (VkPipelineInputAssemblyStateCreateInfo*)(toTransform->pInputAssemblyState));
    }
    if (toTransform->pTessellationState)
    {
        transform_tohost_VkPipelineTessellationStateCreateInfo(resourceTracker, (VkPipelineTessellationStateCreateInfo*)(toTransform->pTessellationState));
    }
    if (toTransform->pViewportState)
    {
        transform_tohost_VkPipelineViewportStateCreateInfo(resourceTracker, (VkPipelineViewportStateCreateInfo*)(toTransform->pViewportState));
    }
    if (toTransform->pRasterizationState)
    {
        transform_tohost_VkPipelineRasterizationStateCreateInfo(resourceTracker, (VkPipelineRasterizationStateCreateInfo*)(toTransform->pRasterizationState));
    }
    if (toTransform->pMultisampleState)
    {
        transform_tohost_VkPipelineMultisampleStateCreateInfo(resourceTracker, (VkPipelineMultisampleStateCreateInfo*)(toTransform->pMultisampleState));
    }
    if (toTransform->pDepthStencilState)
    {
        transform_tohost_VkPipelineDepthStencilStateCreateInfo(resourceTracker, (VkPipelineDepthStencilStateCreateInfo*)(toTransform->pDepthStencilState));
    }
    if (toTransform->pColorBlendState)
    {
        transform_tohost_VkPipelineColorBlendStateCreateInfo(resourceTracker, (VkPipelineColorBlendStateCreateInfo*)(toTransform->pColorBlendState));
    }
    if (toTransform->pDynamicState)
    {
        transform_tohost_VkPipelineDynamicStateCreateInfo(resourceTracker, (VkPipelineDynamicStateCreateInfo*)(toTransform->pDynamicState));
    }
}

void transform_fromhost_VkGraphicsPipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pStages)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->stageCount; ++i)
            {
                transform_fromhost_VkPipelineShaderStageCreateInfo(resourceTracker, (VkPipelineShaderStageCreateInfo*)(toTransform->pStages + i));
            }
        }
    }
    if (toTransform->pVertexInputState)
    {
        transform_fromhost_VkPipelineVertexInputStateCreateInfo(resourceTracker, (VkPipelineVertexInputStateCreateInfo*)(toTransform->pVertexInputState));
    }
    if (toTransform->pInputAssemblyState)
    {
        transform_fromhost_VkPipelineInputAssemblyStateCreateInfo(resourceTracker, (VkPipelineInputAssemblyStateCreateInfo*)(toTransform->pInputAssemblyState));
    }
    if (toTransform->pTessellationState)
    {
        transform_fromhost_VkPipelineTessellationStateCreateInfo(resourceTracker, (VkPipelineTessellationStateCreateInfo*)(toTransform->pTessellationState));
    }
    if (toTransform->pViewportState)
    {
        transform_fromhost_VkPipelineViewportStateCreateInfo(resourceTracker, (VkPipelineViewportStateCreateInfo*)(toTransform->pViewportState));
    }
    if (toTransform->pRasterizationState)
    {
        transform_fromhost_VkPipelineRasterizationStateCreateInfo(resourceTracker, (VkPipelineRasterizationStateCreateInfo*)(toTransform->pRasterizationState));
    }
    if (toTransform->pMultisampleState)
    {
        transform_fromhost_VkPipelineMultisampleStateCreateInfo(resourceTracker, (VkPipelineMultisampleStateCreateInfo*)(toTransform->pMultisampleState));
    }
    if (toTransform->pDepthStencilState)
    {
        transform_fromhost_VkPipelineDepthStencilStateCreateInfo(resourceTracker, (VkPipelineDepthStencilStateCreateInfo*)(toTransform->pDepthStencilState));
    }
    if (toTransform->pColorBlendState)
    {
        transform_fromhost_VkPipelineColorBlendStateCreateInfo(resourceTracker, (VkPipelineColorBlendStateCreateInfo*)(toTransform->pColorBlendState));
    }
    if (toTransform->pDynamicState)
    {
        transform_fromhost_VkPipelineDynamicStateCreateInfo(resourceTracker, (VkPipelineDynamicStateCreateInfo*)(toTransform->pDynamicState));
    }
}

void transform_tohost_VkPushConstantRange(
    ResourceTracker* resourceTracker,
    VkPushConstantRange* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPushConstantRange(
    ResourceTracker* resourceTracker,
    VkPushConstantRange* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineLayoutCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pPushConstantRanges)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pushConstantRangeCount; ++i)
            {
                transform_tohost_VkPushConstantRange(resourceTracker, (VkPushConstantRange*)(toTransform->pPushConstantRanges + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineLayoutCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pPushConstantRanges)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pushConstantRangeCount; ++i)
            {
                transform_fromhost_VkPushConstantRange(resourceTracker, (VkPushConstantRange*)(toTransform->pPushConstantRanges + i));
            }
        }
    }
}

void transform_tohost_VkSamplerCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCopyDescriptorSet(
    ResourceTracker* resourceTracker,
    VkCopyDescriptorSet* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCopyDescriptorSet(
    ResourceTracker* resourceTracker,
    VkCopyDescriptorSet* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorBufferInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorBufferInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorBufferInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorBufferInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorImageInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorImageInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorPoolSize(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolSize* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorPoolSize(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolSize* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pPoolSizes)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->poolSizeCount; ++i)
            {
                transform_tohost_VkDescriptorPoolSize(resourceTracker, (VkDescriptorPoolSize*)(toTransform->pPoolSizes + i));
            }
        }
    }
}

void transform_fromhost_VkDescriptorPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pPoolSizes)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->poolSizeCount; ++i)
            {
                transform_fromhost_VkDescriptorPoolSize(resourceTracker, (VkDescriptorPoolSize*)(toTransform->pPoolSizes + i));
            }
        }
    }
}

void transform_tohost_VkDescriptorSetAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetLayoutBinding(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBinding* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorSetLayoutBinding(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBinding* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorSetLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pBindings)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindingCount; ++i)
            {
                transform_tohost_VkDescriptorSetLayoutBinding(resourceTracker, (VkDescriptorSetLayoutBinding*)(toTransform->pBindings + i));
            }
        }
    }
}

void transform_fromhost_VkDescriptorSetLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pBindings)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bindingCount; ++i)
            {
                transform_fromhost_VkDescriptorSetLayoutBinding(resourceTracker, (VkDescriptorSetLayoutBinding*)(toTransform->pBindings + i));
            }
        }
    }
}

void transform_tohost_VkWriteDescriptorSet(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSet* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pImageInfo)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i)
            {
                transform_tohost_VkDescriptorImageInfo(resourceTracker, (VkDescriptorImageInfo*)(toTransform->pImageInfo + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pBufferInfo)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i)
            {
                transform_tohost_VkDescriptorBufferInfo(resourceTracker, (VkDescriptorBufferInfo*)(toTransform->pBufferInfo + i));
            }
        }
    }
}

void transform_fromhost_VkWriteDescriptorSet(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSet* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pImageInfo)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i)
            {
                transform_fromhost_VkDescriptorImageInfo(resourceTracker, (VkDescriptorImageInfo*)(toTransform->pImageInfo + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pBufferInfo)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorCount; ++i)
            {
                transform_fromhost_VkDescriptorBufferInfo(resourceTracker, (VkDescriptorBufferInfo*)(toTransform->pBufferInfo + i));
            }
        }
    }
}

void transform_tohost_VkAttachmentDescription(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkAttachmentDescription(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkAttachmentReference(
    ResourceTracker* resourceTracker,
    VkAttachmentReference* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkAttachmentReference(
    ResourceTracker* resourceTracker,
    VkAttachmentReference* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkFramebufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFramebufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassDescription(
    ResourceTracker* resourceTracker,
    VkSubpassDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pInputAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i)
            {
                transform_tohost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pColorAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_tohost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pResolveAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_tohost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment)
    {
        transform_tohost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_fromhost_VkSubpassDescription(
    ResourceTracker* resourceTracker,
    VkSubpassDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pInputAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pColorAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pResolveAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment)
    {
        transform_fromhost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_tohost_VkSubpassDependency(
    ResourceTracker* resourceTracker,
    VkSubpassDependency* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkSubpassDependency(
    ResourceTracker* resourceTracker,
    VkSubpassDependency* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkRenderPassCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i)
            {
                transform_tohost_VkAttachmentDescription(resourceTracker, (VkAttachmentDescription*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pSubpasses)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i)
            {
                transform_tohost_VkSubpassDescription(resourceTracker, (VkSubpassDescription*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pDependencies)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i)
            {
                transform_tohost_VkSubpassDependency(resourceTracker, (VkSubpassDependency*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentDescription(resourceTracker, (VkAttachmentDescription*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pSubpasses)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i)
            {
                transform_fromhost_VkSubpassDescription(resourceTracker, (VkSubpassDescription*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pDependencies)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i)
            {
                transform_fromhost_VkSubpassDependency(resourceTracker, (VkSubpassDependency*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_tohost_VkCommandPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkCommandPoolCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkCommandPoolCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferAllocateInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferAllocateInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferInheritanceInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferInheritanceInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pInheritanceInfo)
    {
        transform_tohost_VkCommandBufferInheritanceInfo(resourceTracker, (VkCommandBufferInheritanceInfo*)(toTransform->pInheritanceInfo));
    }
}

void transform_fromhost_VkCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pInheritanceInfo)
    {
        transform_fromhost_VkCommandBufferInheritanceInfo(resourceTracker, (VkCommandBufferInheritanceInfo*)(toTransform->pInheritanceInfo));
    }
}

void transform_tohost_VkBufferCopy(
    ResourceTracker* resourceTracker,
    VkBufferCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkBufferCopy(
    ResourceTracker* resourceTracker,
    VkBufferCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkImageSubresourceLayers(
    ResourceTracker* resourceTracker,
    VkImageSubresourceLayers* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkImageSubresourceLayers(
    ResourceTracker* resourceTracker,
    VkImageSubresourceLayers* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkBufferImageCopy(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_fromhost_VkBufferImageCopy(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_tohost_VkClearColorValue(
    ResourceTracker* resourceTracker,
    VkClearColorValue* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkClearColorValue(
    ResourceTracker* resourceTracker,
    VkClearColorValue* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkClearDepthStencilValue(
    ResourceTracker* resourceTracker,
    VkClearDepthStencilValue* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkClearDepthStencilValue(
    ResourceTracker* resourceTracker,
    VkClearDepthStencilValue* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkClearValue(
    ResourceTracker* resourceTracker,
    VkClearValue* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkClearColorValue(resourceTracker, (VkClearColorValue*)(&toTransform->color));
    transform_tohost_VkClearDepthStencilValue(resourceTracker, (VkClearDepthStencilValue*)(&toTransform->depthStencil));
}

void transform_fromhost_VkClearValue(
    ResourceTracker* resourceTracker,
    VkClearValue* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkClearColorValue(resourceTracker, (VkClearColorValue*)(&toTransform->color));
    transform_fromhost_VkClearDepthStencilValue(resourceTracker, (VkClearDepthStencilValue*)(&toTransform->depthStencil));
}

void transform_tohost_VkClearAttachment(
    ResourceTracker* resourceTracker,
    VkClearAttachment* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_fromhost_VkClearAttachment(
    ResourceTracker* resourceTracker,
    VkClearAttachment* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_tohost_VkClearRect(
    ResourceTracker* resourceTracker,
    VkClearRect* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->rect));
}

void transform_fromhost_VkClearRect(
    ResourceTracker* resourceTracker,
    VkClearRect* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->rect));
}

void transform_tohost_VkImageBlit(
    ResourceTracker* resourceTracker,
    VkImageBlit* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_fromhost_VkImageBlit(
    ResourceTracker* resourceTracker,
    VkImageBlit* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_tohost_VkImageCopy(
    ResourceTracker* resourceTracker,
    VkImageCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageCopy(
    ResourceTracker* resourceTracker,
    VkImageCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkImageResolve(
    ResourceTracker* resourceTracker,
    VkImageResolve* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageResolve(
    ResourceTracker* resourceTracker,
    VkImageResolve* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform)
    {
        if (toTransform->pClearValues)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->clearValueCount; ++i)
            {
                transform_tohost_VkClearValue(resourceTracker, (VkClearValue*)(toTransform->pClearValues + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform)
    {
        if (toTransform->pClearValues)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->clearValueCount; ++i)
            {
                transform_fromhost_VkClearValue(resourceTracker, (VkClearValue*)(toTransform->pClearValues + i));
            }
        }
    }
}

#endif
#ifdef VK_VERSION_1_1
void transform_tohost_VkPhysicalDeviceSubgroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSubgroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindBufferMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindBufferMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindImageMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindImageMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)&toTransform->memoryOffset, 1, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevice16BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice16BitStorageFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevice16BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice16BitStorageFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryDedicatedRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryDedicatedRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryDedicatedAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryDedicatedAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryAllocateFlagsInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateFlagsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryAllocateFlagsInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateFlagsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupRenderPassBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDeviceRenderAreas)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->deviceRenderAreaCount; ++i)
            {
                transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(toTransform->pDeviceRenderAreas + i));
            }
        }
    }
}

void transform_fromhost_VkDeviceGroupRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupRenderPassBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDeviceRenderAreas)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->deviceRenderAreaCount; ++i)
            {
                transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(toTransform->pDeviceRenderAreas + i));
            }
        }
    }
}

void transform_tohost_VkDeviceGroupCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupCommandBufferBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupCommandBufferBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupSubmitInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupSubmitInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupBindSparseInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupBindSparseInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindBufferMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryDeviceGroupInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindBufferMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryDeviceGroupInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindImageMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryDeviceGroupInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pSplitInstanceBindRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->splitInstanceBindRegionCount; ++i)
            {
                transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(toTransform->pSplitInstanceBindRegions + i));
            }
        }
    }
}

void transform_fromhost_VkBindImageMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryDeviceGroupInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pSplitInstanceBindRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->splitInstanceBindRegionCount; ++i)
            {
                transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(toTransform->pSplitInstanceBindRegions + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceGroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGroupProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceGroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGroupProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceGroupDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupDeviceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceGroupDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupDeviceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryRequirementsInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryRequirementsInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageMemoryRequirementsInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageMemoryRequirementsInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageSparseMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageSparseMemoryRequirementsInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageSparseMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageSparseMemoryRequirementsInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkMemoryRequirements(resourceTracker, (VkMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_fromhost_VkMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkMemoryRequirements(resourceTracker, (VkMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_tohost_VkSparseImageMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkSparseImageMemoryRequirements(resourceTracker, (VkSparseImageMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_fromhost_VkSparseImageMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkSparseImageMemoryRequirements(resourceTracker, (VkSparseImageMemoryRequirements*)(&toTransform->memoryRequirements));
}

void transform_tohost_VkPhysicalDeviceFeatures2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPhysicalDeviceFeatures(resourceTracker, (VkPhysicalDeviceFeatures*)(&toTransform->features));
}

void transform_fromhost_VkPhysicalDeviceFeatures2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPhysicalDeviceFeatures(resourceTracker, (VkPhysicalDeviceFeatures*)(&toTransform->features));
}

void transform_tohost_VkPhysicalDeviceProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPhysicalDeviceProperties(resourceTracker, (VkPhysicalDeviceProperties*)(&toTransform->properties));
}

void transform_fromhost_VkPhysicalDeviceProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPhysicalDeviceProperties(resourceTracker, (VkPhysicalDeviceProperties*)(&toTransform->properties));
}

void transform_tohost_VkFormatProperties2(
    ResourceTracker* resourceTracker,
    VkFormatProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkFormatProperties(resourceTracker, (VkFormatProperties*)(&toTransform->formatProperties));
}

void transform_fromhost_VkFormatProperties2(
    ResourceTracker* resourceTracker,
    VkFormatProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkFormatProperties(resourceTracker, (VkFormatProperties*)(&toTransform->formatProperties));
}

void transform_tohost_VkImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageFormatProperties(resourceTracker, (VkImageFormatProperties*)(&toTransform->imageFormatProperties));
}

void transform_fromhost_VkImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageFormatProperties(resourceTracker, (VkImageFormatProperties*)(&toTransform->imageFormatProperties));
}

void transform_tohost_VkPhysicalDeviceImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageFormatInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageFormatInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkQueueFamilyProperties2(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkQueueFamilyProperties(resourceTracker, (VkQueueFamilyProperties*)(&toTransform->queueFamilyProperties));
}

void transform_fromhost_VkQueueFamilyProperties2(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkQueueFamilyProperties(resourceTracker, (VkQueueFamilyProperties*)(&toTransform->queueFamilyProperties));
}

void transform_tohost_VkPhysicalDeviceMemoryProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPhysicalDeviceMemoryProperties(resourceTracker, (VkPhysicalDeviceMemoryProperties*)(&toTransform->memoryProperties));
}

void transform_fromhost_VkPhysicalDeviceMemoryProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPhysicalDeviceMemoryProperties(resourceTracker, (VkPhysicalDeviceMemoryProperties*)(&toTransform->memoryProperties));
}

void transform_tohost_VkSparseImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkSparseImageFormatProperties(resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->properties));
}

void transform_fromhost_VkSparseImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkSparseImageFormatProperties(resourceTracker, (VkSparseImageFormatProperties*)(&toTransform->properties));
}

void transform_tohost_VkPhysicalDeviceSparseImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseImageFormatInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSparseImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseImageFormatInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePointClippingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePointClippingProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePointClippingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePointClippingProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkInputAttachmentAspectReference(
    ResourceTracker* resourceTracker,
    VkInputAttachmentAspectReference* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkInputAttachmentAspectReference(
    ResourceTracker* resourceTracker,
    VkInputAttachmentAspectReference* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkRenderPassInputAttachmentAspectCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassInputAttachmentAspectCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAspectReferences)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->aspectReferenceCount; ++i)
            {
                transform_tohost_VkInputAttachmentAspectReference(resourceTracker, (VkInputAttachmentAspectReference*)(toTransform->pAspectReferences + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassInputAttachmentAspectCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassInputAttachmentAspectCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAspectReferences)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->aspectReferenceCount; ++i)
            {
                transform_fromhost_VkInputAttachmentAspectReference(resourceTracker, (VkInputAttachmentAspectReference*)(toTransform->pAspectReferences + i));
            }
        }
    }
}

void transform_tohost_VkImageViewUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewUsageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageViewUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewUsageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineTessellationDomainOriginStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationDomainOriginStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineTessellationDomainOriginStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationDomainOriginStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderPassMultiviewCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassMultiviewCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderPassMultiviewCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassMultiviewCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMultiviewFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMultiviewFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMultiviewProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMultiviewProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVariablePointersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVariablePointersFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVariablePointersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVariablePointersFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceProtectedMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProtectedMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceProtectedMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProtectedMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceQueueInfo2(
    ResourceTracker* resourceTracker,
    VkDeviceQueueInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceQueueInfo2(
    ResourceTracker* resourceTracker,
    VkDeviceQueueInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkProtectedSubmitInfo(
    ResourceTracker* resourceTracker,
    VkProtectedSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkProtectedSubmitInfo(
    ResourceTracker* resourceTracker,
    VkProtectedSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSamplerYcbcrConversionCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkComponentMapping(resourceTracker, (VkComponentMapping*)(&toTransform->components));
}

void transform_fromhost_VkSamplerYcbcrConversionCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkComponentMapping(resourceTracker, (VkComponentMapping*)(&toTransform->components));
}

void transform_tohost_VkSamplerYcbcrConversionInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerYcbcrConversionInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindImagePlaneMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImagePlaneMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindImagePlaneMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImagePlaneMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImagePlaneMemoryRequirementsInfo(
    ResourceTracker* resourceTracker,
    VkImagePlaneMemoryRequirementsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImagePlaneMemoryRequirementsInfo(
    ResourceTracker* resourceTracker,
    VkImagePlaneMemoryRequirementsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSamplerYcbcrConversionImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerYcbcrConversionImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorUpdateTemplateEntry(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateEntry* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDescriptorUpdateTemplateEntry(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateEntry* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDescriptorUpdateTemplateCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDescriptorUpdateEntries)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorUpdateEntryCount; ++i)
            {
                transform_tohost_VkDescriptorUpdateTemplateEntry(resourceTracker, (VkDescriptorUpdateTemplateEntry*)(toTransform->pDescriptorUpdateEntries + i));
            }
        }
    }
}

void transform_fromhost_VkDescriptorUpdateTemplateCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDescriptorUpdateEntries)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorUpdateEntryCount; ++i)
            {
                transform_fromhost_VkDescriptorUpdateTemplateEntry(resourceTracker, (VkDescriptorUpdateTemplateEntry*)(toTransform->pDescriptorUpdateEntries + i));
            }
        }
    }
}

void transform_tohost_VkExternalMemoryProperties(
    ResourceTracker* resourceTracker,
    VkExternalMemoryProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkExternalMemoryProperties(
    ResourceTracker* resourceTracker,
    VkExternalMemoryProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceExternalImageFormatInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalImageFormatInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalImageFormatInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalImageFormatInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkExternalImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_tohost(&toTransform->externalMemoryProperties, 1);
    transform_tohost_VkExternalMemoryProperties(resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_fromhost_VkExternalImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkExternalImageFormatProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_fromhost(&toTransform->externalMemoryProperties, 1);
    transform_fromhost_VkExternalMemoryProperties(resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_tohost_VkPhysicalDeviceExternalBufferInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalBufferInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalBufferInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalBufferInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalBufferProperties(
    ResourceTracker* resourceTracker,
    VkExternalBufferProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_tohost(&toTransform->externalMemoryProperties, 1);
    transform_tohost_VkExternalMemoryProperties(resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_fromhost_VkExternalBufferProperties(
    ResourceTracker* resourceTracker,
    VkExternalBufferProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    resourceTracker->transformImpl_VkExternalMemoryProperties_fromhost(&toTransform->externalMemoryProperties, 1);
    transform_fromhost_VkExternalMemoryProperties(resourceTracker, (VkExternalMemoryProperties*)(&toTransform->externalMemoryProperties));
}

void transform_tohost_VkPhysicalDeviceIDProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIDProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceIDProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIDProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalMemoryImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryImageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalMemoryImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryImageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalMemoryBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryBufferCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalMemoryBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryBufferCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExportMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkExportMemoryAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExportMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkExportMemoryAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceExternalFenceInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalFenceInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalFenceInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalFenceInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalFenceProperties(
    ResourceTracker* resourceTracker,
    VkExternalFenceProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalFenceProperties(
    ResourceTracker* resourceTracker,
    VkExternalFenceProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExportFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportFenceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExportFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportFenceCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExportSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportSemaphoreCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExportSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportSemaphoreCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceExternalSemaphoreInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalSemaphoreInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExternalSemaphoreInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalSemaphoreInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkExternalSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkExternalSemaphoreProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkExternalSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkExternalSemaphoreProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance3Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance3Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance3Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance3Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutSupport* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutSupport* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderDrawParametersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDrawParametersFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderDrawParametersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDrawParametersFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_VERSION_1_2
void transform_tohost_VkPhysicalDeviceVulkan11Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan11Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkan11Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan11Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkan12Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan12Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkConformanceVersion(
    ResourceTracker* resourceTracker,
    VkConformanceVersion* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkConformanceVersion(
    ResourceTracker* resourceTracker,
    VkConformanceVersion* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPhysicalDeviceVulkan12Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkConformanceVersion(resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_fromhost_VkPhysicalDeviceVulkan12Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkConformanceVersion(resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_tohost_VkImageFormatListCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageFormatListCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageFormatListCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageFormatListCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentDescription2(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentDescription2(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentReference2(
    ResourceTracker* resourceTracker,
    VkAttachmentReference2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentReference2(
    ResourceTracker* resourceTracker,
    VkAttachmentReference2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassDescription2(
    ResourceTracker* resourceTracker,
    VkSubpassDescription2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pInputAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i)
            {
                transform_tohost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pColorAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_tohost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pResolveAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_tohost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment)
    {
        transform_tohost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_fromhost_VkSubpassDescription2(
    ResourceTracker* resourceTracker,
    VkSubpassDescription2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pInputAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->inputAttachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pInputAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pColorAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pResolveAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pResolveAttachments + i));
            }
        }
    }
    if (toTransform->pDepthStencilAttachment)
    {
        transform_fromhost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pDepthStencilAttachment));
    }
}

void transform_tohost_VkSubpassDependency2(
    ResourceTracker* resourceTracker,
    VkSubpassDependency2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubpassDependency2(
    ResourceTracker* resourceTracker,
    VkSubpassDependency2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderPassCreateInfo2(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i)
            {
                transform_tohost_VkAttachmentDescription2(resourceTracker, (VkAttachmentDescription2*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pSubpasses)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i)
            {
                transform_tohost_VkSubpassDescription2(resourceTracker, (VkSubpassDescription2*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pDependencies)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i)
            {
                transform_tohost_VkSubpassDependency2(resourceTracker, (VkSubpassDependency2*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_fromhost_VkRenderPassCreateInfo2(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentCount; ++i)
            {
                transform_fromhost_VkAttachmentDescription2(resourceTracker, (VkAttachmentDescription2*)(toTransform->pAttachments + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pSubpasses)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->subpassCount; ++i)
            {
                transform_fromhost_VkSubpassDescription2(resourceTracker, (VkSubpassDescription2*)(toTransform->pSubpasses + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pDependencies)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->dependencyCount; ++i)
            {
                transform_fromhost_VkSubpassDependency2(resourceTracker, (VkSubpassDependency2*)(toTransform->pDependencies + i));
            }
        }
    }
}

void transform_tohost_VkSubpassBeginInfo(
    ResourceTracker* resourceTracker,
    VkSubpassBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubpassBeginInfo(
    ResourceTracker* resourceTracker,
    VkSubpassBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassEndInfo(
    ResourceTracker* resourceTracker,
    VkSubpassEndInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubpassEndInfo(
    ResourceTracker* resourceTracker,
    VkSubpassEndInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevice8BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice8BitStorageFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevice8BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice8BitStorageFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDriverProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDriverProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkConformanceVersion(resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_fromhost_VkPhysicalDeviceDriverProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDriverProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkConformanceVersion(resourceTracker, (VkConformanceVersion*)(&toTransform->conformanceVersion));
}

void transform_tohost_VkPhysicalDeviceShaderAtomicInt64Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderAtomicInt64Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderAtomicInt64Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderAtomicInt64Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderFloat16Int8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloat16Int8Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderFloat16Int8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloat16Int8Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceFloatControlsProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFloatControlsProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceFloatControlsProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFloatControlsProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDescriptorIndexingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDescriptorIndexingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDescriptorIndexingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDescriptorIndexingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubpassDescriptionDepthStencilResolve(
    ResourceTracker* resourceTracker,
    VkSubpassDescriptionDepthStencilResolve* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pDepthStencilResolveAttachment)
    {
        transform_tohost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pDepthStencilResolveAttachment));
    }
}

void transform_fromhost_VkSubpassDescriptionDepthStencilResolve(
    ResourceTracker* resourceTracker,
    VkSubpassDescriptionDepthStencilResolve* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pDepthStencilResolveAttachment)
    {
        transform_fromhost_VkAttachmentReference2(resourceTracker, (VkAttachmentReference2*)(toTransform->pDepthStencilResolveAttachment));
    }
}

void transform_tohost_VkPhysicalDeviceDepthStencilResolveProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthStencilResolveProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDepthStencilResolveProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthStencilResolveProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceScalarBlockLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceScalarBlockLayoutFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceScalarBlockLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceScalarBlockLayoutFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageStencilUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageStencilUsageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageStencilUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageStencilUsageCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSamplerReductionModeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerReductionModeCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSamplerReductionModeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerReductionModeCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkanMemoryModelFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkanMemoryModelFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkanMemoryModelFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkanMemoryModelFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceImagelessFramebufferFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImagelessFramebufferFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImagelessFramebufferFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImagelessFramebufferFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFramebufferAttachmentImageInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFramebufferAttachmentImageInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFramebufferAttachmentsCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentsCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachmentImageInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentImageInfoCount; ++i)
            {
                transform_tohost_VkFramebufferAttachmentImageInfo(resourceTracker, (VkFramebufferAttachmentImageInfo*)(toTransform->pAttachmentImageInfos + i));
            }
        }
    }
}

void transform_fromhost_VkFramebufferAttachmentsCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentsCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pAttachmentImageInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->attachmentImageInfoCount; ++i)
            {
                transform_fromhost_VkFramebufferAttachmentImageInfo(resourceTracker, (VkFramebufferAttachmentImageInfo*)(toTransform->pAttachmentImageInfos + i));
            }
        }
    }
}

void transform_tohost_VkRenderPassAttachmentBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassAttachmentBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderPassAttachmentBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassAttachmentBeginInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentReferenceStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentReferenceStencilLayout* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentReferenceStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentReferenceStencilLayout* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkAttachmentDescriptionStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentDescriptionStencilLayout* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkAttachmentDescriptionStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentDescriptionStencilLayout* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceHostQueryResetFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostQueryResetFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceHostQueryResetFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostQueryResetFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTimelineSemaphoreFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTimelineSemaphoreFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTimelineSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTimelineSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreTypeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreTypeCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreTypeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreTypeCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkTimelineSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkTimelineSemaphoreSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkTimelineSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkTimelineSemaphoreSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreWaitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreWaitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreWaitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreWaitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreSignalInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSignalInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreSignalInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSignalInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceBufferDeviceAddressFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceBufferDeviceAddressFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceBufferDeviceAddressFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceBufferDeviceAddressFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferDeviceAddressInfo(
    ResourceTracker* resourceTracker,
    VkBufferDeviceAddressInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferDeviceAddressInfo(
    ResourceTracker* resourceTracker,
    VkBufferDeviceAddressInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferOpaqueCaptureAddressCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferOpaqueCaptureAddressCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferOpaqueCaptureAddressCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferOpaqueCaptureAddressCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryOpaqueCaptureAddressAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryOpaqueCaptureAddressAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryOpaqueCaptureAddressAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryOpaqueCaptureAddressAllocateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceMemoryOpaqueCaptureAddressInfo(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryOpaqueCaptureAddressInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_tohost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceMemoryOpaqueCaptureAddressInfo(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryOpaqueCaptureAddressInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    resourceTracker->deviceMemoryTransform_fromhost((VkDeviceMemory*)&toTransform->memory, 1, (VkDeviceSize*)nullptr, 0, (VkDeviceSize*)nullptr, 0, (uint32_t*)nullptr, 0, (uint32_t*)nullptr, 0);
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_VERSION_1_3
void transform_tohost_VkPhysicalDeviceVulkan13Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan13Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkan13Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan13Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineCreationFeedback(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedback* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineCreationFeedback(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedback* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineCreationFeedbackCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedbackCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pPipelineCreationFeedback)
    {
        transform_tohost_VkPipelineCreationFeedback(resourceTracker, (VkPipelineCreationFeedback*)(toTransform->pPipelineCreationFeedback));
    }
    if (toTransform)
    {
        if (toTransform->pPipelineStageCreationFeedbacks)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pipelineStageCreationFeedbackCount; ++i)
            {
                transform_tohost_VkPipelineCreationFeedback(resourceTracker, (VkPipelineCreationFeedback*)(toTransform->pPipelineStageCreationFeedbacks + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineCreationFeedbackCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedbackCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pPipelineCreationFeedback)
    {
        transform_fromhost_VkPipelineCreationFeedback(resourceTracker, (VkPipelineCreationFeedback*)(toTransform->pPipelineCreationFeedback));
    }
    if (toTransform)
    {
        if (toTransform->pPipelineStageCreationFeedbacks)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->pipelineStageCreationFeedbackCount; ++i)
            {
                transform_fromhost_VkPipelineCreationFeedback(resourceTracker, (VkPipelineCreationFeedback*)(toTransform->pPipelineStageCreationFeedbacks + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceToolProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceToolProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceToolProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceToolProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePrivateDataFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrivateDataFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePrivateDataFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrivateDataFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDevicePrivateDataCreateInfo(
    ResourceTracker* resourceTracker,
    VkDevicePrivateDataCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDevicePrivateDataCreateInfo(
    ResourceTracker* resourceTracker,
    VkDevicePrivateDataCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPrivateDataSlotCreateInfo(
    ResourceTracker* resourceTracker,
    VkPrivateDataSlotCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPrivateDataSlotCreateInfo(
    ResourceTracker* resourceTracker,
    VkPrivateDataSlotCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_fromhost_VkImageMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_tohost_VkDependencyInfo(
    ResourceTracker* resourceTracker,
    VkDependencyInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pMemoryBarriers)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->memoryBarrierCount; ++i)
            {
                transform_tohost_VkMemoryBarrier2(resourceTracker, (VkMemoryBarrier2*)(toTransform->pMemoryBarriers + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pBufferMemoryBarriers)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferMemoryBarrierCount; ++i)
            {
                transform_tohost_VkBufferMemoryBarrier2(resourceTracker, (VkBufferMemoryBarrier2*)(toTransform->pBufferMemoryBarriers + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pImageMemoryBarriers)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageMemoryBarrierCount; ++i)
            {
                transform_tohost_VkImageMemoryBarrier2(resourceTracker, (VkImageMemoryBarrier2*)(toTransform->pImageMemoryBarriers + i));
            }
        }
    }
}

void transform_fromhost_VkDependencyInfo(
    ResourceTracker* resourceTracker,
    VkDependencyInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pMemoryBarriers)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->memoryBarrierCount; ++i)
            {
                transform_fromhost_VkMemoryBarrier2(resourceTracker, (VkMemoryBarrier2*)(toTransform->pMemoryBarriers + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pBufferMemoryBarriers)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->bufferMemoryBarrierCount; ++i)
            {
                transform_fromhost_VkBufferMemoryBarrier2(resourceTracker, (VkBufferMemoryBarrier2*)(toTransform->pBufferMemoryBarriers + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pImageMemoryBarriers)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->imageMemoryBarrierCount; ++i)
            {
                transform_fromhost_VkImageMemoryBarrier2(resourceTracker, (VkImageMemoryBarrier2*)(toTransform->pImageMemoryBarriers + i));
            }
        }
    }
}

void transform_tohost_VkSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferSubmitInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferSubmitInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferSubmitInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSubmitInfo2(
    ResourceTracker* resourceTracker,
    VkSubmitInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pWaitSemaphoreInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->waitSemaphoreInfoCount; ++i)
            {
                transform_tohost_VkSemaphoreSubmitInfo(resourceTracker, (VkSemaphoreSubmitInfo*)(toTransform->pWaitSemaphoreInfos + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pCommandBufferInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->commandBufferInfoCount; ++i)
            {
                transform_tohost_VkCommandBufferSubmitInfo(resourceTracker, (VkCommandBufferSubmitInfo*)(toTransform->pCommandBufferInfos + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pSignalSemaphoreInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->signalSemaphoreInfoCount; ++i)
            {
                transform_tohost_VkSemaphoreSubmitInfo(resourceTracker, (VkSemaphoreSubmitInfo*)(toTransform->pSignalSemaphoreInfos + i));
            }
        }
    }
}

void transform_fromhost_VkSubmitInfo2(
    ResourceTracker* resourceTracker,
    VkSubmitInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pWaitSemaphoreInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->waitSemaphoreInfoCount; ++i)
            {
                transform_fromhost_VkSemaphoreSubmitInfo(resourceTracker, (VkSemaphoreSubmitInfo*)(toTransform->pWaitSemaphoreInfos + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pCommandBufferInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->commandBufferInfoCount; ++i)
            {
                transform_fromhost_VkCommandBufferSubmitInfo(resourceTracker, (VkCommandBufferSubmitInfo*)(toTransform->pCommandBufferInfos + i));
            }
        }
    }
    if (toTransform)
    {
        if (toTransform->pSignalSemaphoreInfos)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->signalSemaphoreInfoCount; ++i)
            {
                transform_fromhost_VkSemaphoreSubmitInfo(resourceTracker, (VkSemaphoreSubmitInfo*)(toTransform->pSignalSemaphoreInfos + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceSynchronization2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSynchronization2Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSynchronization2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSynchronization2Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceImageRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageRobustnessFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageRobustnessFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferCopy2(
    ResourceTracker* resourceTracker,
    VkBufferCopy2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferCopy2(
    ResourceTracker* resourceTracker,
    VkBufferCopy2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCopyBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkBufferCopy2(resourceTracker, (VkBufferCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkBufferCopy2(resourceTracker, (VkBufferCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkImageCopy2(
    ResourceTracker* resourceTracker,
    VkImageCopy2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageCopy2(
    ResourceTracker* resourceTracker,
    VkImageCopy2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkCopyImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkImageCopy2(resourceTracker, (VkImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkImageCopy2(resourceTracker, (VkImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkBufferImageCopy2(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_fromhost_VkBufferImageCopy2(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_tohost_VkCopyBufferToImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferToImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkBufferImageCopy2(resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyBufferToImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferToImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkBufferImageCopy2(resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkCopyImageToBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageToBufferInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkBufferImageCopy2(resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyImageToBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageToBufferInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkBufferImageCopy2(resourceTracker, (VkBufferImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkImageBlit2(
    ResourceTracker* resourceTracker,
    VkImageBlit2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_fromhost_VkImageBlit2(
    ResourceTracker* resourceTracker,
    VkImageBlit2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->srcOffsets + i));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    for (uint32_t i = 0; i < (uint32_t)2; ++i)
    {
        transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(toTransform->dstOffsets + i));
    }
}

void transform_tohost_VkBlitImageInfo2(
    ResourceTracker* resourceTracker,
    VkBlitImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkImageBlit2(resourceTracker, (VkImageBlit2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkBlitImageInfo2(
    ResourceTracker* resourceTracker,
    VkBlitImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkImageBlit2(resourceTracker, (VkImageBlit2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkImageResolve2(
    ResourceTracker* resourceTracker,
    VkImageResolve2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_fromhost_VkImageResolve2(
    ResourceTracker* resourceTracker,
    VkImageResolve2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->srcSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->srcOffset));
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->dstSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->dstOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->extent));
}

void transform_tohost_VkResolveImageInfo2(
    ResourceTracker* resourceTracker,
    VkResolveImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkImageResolve2(resourceTracker, (VkImageResolve2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkResolveImageInfo2(
    ResourceTracker* resourceTracker,
    VkResolveImageInfo2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkImageResolve2(resourceTracker, (VkImageResolve2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceSubgroupSizeControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSubgroupSizeControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceSubgroupSizeControlProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceSubgroupSizeControlProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceInlineUniformBlockFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceInlineUniformBlockFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceInlineUniformBlockProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceInlineUniformBlockProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkWriteDescriptorSetInlineUniformBlock(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSetInlineUniformBlock* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkWriteDescriptorSetInlineUniformBlock(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSetInlineUniformBlock* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDescriptorPoolInlineUniformBlockCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolInlineUniformBlockCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDescriptorPoolInlineUniformBlockCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolInlineUniformBlockCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderingAttachmentInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_fromhost_VkRenderingAttachmentInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkClearValue(resourceTracker, (VkClearValue*)(&toTransform->clearValue));
}

void transform_tohost_VkRenderingInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform)
    {
        if (toTransform->pColorAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_tohost_VkRenderingAttachmentInfo(resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform->pDepthAttachment)
    {
        transform_tohost_VkRenderingAttachmentInfo(resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pDepthAttachment));
    }
    if (toTransform->pStencilAttachment)
    {
        transform_tohost_VkRenderingAttachmentInfo(resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pStencilAttachment));
    }
}

void transform_fromhost_VkRenderingInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkRect2D(resourceTracker, (VkRect2D*)(&toTransform->renderArea));
    if (toTransform)
    {
        if (toTransform->pColorAttachments)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->colorAttachmentCount; ++i)
            {
                transform_fromhost_VkRenderingAttachmentInfo(resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pColorAttachments + i));
            }
        }
    }
    if (toTransform->pDepthAttachment)
    {
        transform_fromhost_VkRenderingAttachmentInfo(resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pDepthAttachment));
    }
    if (toTransform->pStencilAttachment)
    {
        transform_fromhost_VkRenderingAttachmentInfo(resourceTracker, (VkRenderingAttachmentInfo*)(toTransform->pStencilAttachment));
    }
}

void transform_tohost_VkPipelineRenderingCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRenderingCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRenderingCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRenderingCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDynamicRenderingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDynamicRenderingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCommandBufferInheritanceRenderingInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceRenderingInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCommandBufferInheritanceRenderingInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceRenderingInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderIntegerDotProductProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTexelBufferAlignmentProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFormatProperties3(
    ResourceTracker* resourceTracker,
    VkFormatProperties3* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFormatProperties3(
    ResourceTracker* resourceTracker,
    VkFormatProperties3* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance4Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance4Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance4Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance4Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceBufferMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceBufferMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo)
    {
        transform_tohost_VkBufferCreateInfo(resourceTracker, (VkBufferCreateInfo*)(toTransform->pCreateInfo));
    }
}

void transform_fromhost_VkDeviceBufferMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceBufferMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo)
    {
        transform_fromhost_VkBufferCreateInfo(resourceTracker, (VkBufferCreateInfo*)(toTransform->pCreateInfo));
    }
}

void transform_tohost_VkDeviceImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceImageMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo)
    {
        resourceTracker->transformImpl_VkImageCreateInfo_tohost(toTransform->pCreateInfo, 1);
        transform_tohost_VkImageCreateInfo(resourceTracker, (VkImageCreateInfo*)(toTransform->pCreateInfo));
    }
}

void transform_fromhost_VkDeviceImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceImageMemoryRequirements* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo)
    {
        resourceTracker->transformImpl_VkImageCreateInfo_fromhost(toTransform->pCreateInfo, 1);
        transform_fromhost_VkImageCreateInfo(resourceTracker, (VkImageCreateInfo*)(toTransform->pCreateInfo));
    }
}

#endif
#ifdef VK_VERSION_1_4
void transform_tohost_VkPhysicalDeviceVulkan14Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan14Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVulkan14Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVulkan14Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceQueueGlobalPriorityCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueGlobalPriorityCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceQueueGlobalPriorityCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueGlobalPriorityCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkQueueFamilyGlobalPriorityProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyGlobalPriorityProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkQueueFamilyGlobalPriorityProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyGlobalPriorityProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderFloatControls2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloatControls2Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderFloatControls2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloatControls2Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceShaderExpectAssumeFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderExpectAssumeFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceShaderExpectAssumeFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderExpectAssumeFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceLineRasterizationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceLineRasterizationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceLineRasterizationProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceLineRasterizationProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRasterizationLineStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationLineStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationLineStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationLineStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceVertexAttributeDivisorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkVertexInputBindingDivisorDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDivisorDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkVertexInputBindingDivisorDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDivisorDescription* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineVertexInputDivisorStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputDivisorStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pVertexBindingDivisors)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexBindingDivisorCount; ++i)
            {
                transform_tohost_VkVertexInputBindingDivisorDescription(resourceTracker, (VkVertexInputBindingDivisorDescription*)(toTransform->pVertexBindingDivisors + i));
            }
        }
    }
}

void transform_fromhost_VkPipelineVertexInputDivisorStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputDivisorStateCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pVertexBindingDivisors)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->vertexBindingDivisorCount; ++i)
            {
                transform_fromhost_VkVertexInputBindingDivisorDescription(resourceTracker, (VkVertexInputBindingDivisorDescription*)(toTransform->pVertexBindingDivisors + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceIndexTypeUint8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIndexTypeUint8Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceIndexTypeUint8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIndexTypeUint8Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryMapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryMapInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryMapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryMapInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryUnmapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryUnmapInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkMemoryUnmapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryUnmapInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance5Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance5Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance5Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance5Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderingAreaInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAreaInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderingAreaInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAreaInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageSubresource2(
    ResourceTracker* resourceTracker,
    VkImageSubresource2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresource(resourceTracker, (VkImageSubresource*)(&toTransform->imageSubresource));
}

void transform_fromhost_VkImageSubresource2(
    ResourceTracker* resourceTracker,
    VkImageSubresource2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresource(resourceTracker, (VkImageSubresource*)(&toTransform->imageSubresource));
}

void transform_tohost_VkDeviceImageSubresourceInfo(
    ResourceTracker* resourceTracker,
    VkDeviceImageSubresourceInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo)
    {
        resourceTracker->transformImpl_VkImageCreateInfo_tohost(toTransform->pCreateInfo, 1);
        transform_tohost_VkImageCreateInfo(resourceTracker, (VkImageCreateInfo*)(toTransform->pCreateInfo));
    }
    if (toTransform->pSubresource)
    {
        transform_tohost_VkImageSubresource2(resourceTracker, (VkImageSubresource2*)(toTransform->pSubresource));
    }
}

void transform_fromhost_VkDeviceImageSubresourceInfo(
    ResourceTracker* resourceTracker,
    VkDeviceImageSubresourceInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform->pCreateInfo)
    {
        resourceTracker->transformImpl_VkImageCreateInfo_fromhost(toTransform->pCreateInfo, 1);
        transform_fromhost_VkImageCreateInfo(resourceTracker, (VkImageCreateInfo*)(toTransform->pCreateInfo));
    }
    if (toTransform->pSubresource)
    {
        transform_fromhost_VkImageSubresource2(resourceTracker, (VkImageSubresource2*)(toTransform->pSubresource));
    }
}

void transform_tohost_VkSubresourceLayout2(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkSubresourceLayout(resourceTracker, (VkSubresourceLayout*)(&toTransform->subresourceLayout));
}

void transform_fromhost_VkSubresourceLayout2(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout2* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkSubresourceLayout(resourceTracker, (VkSubresourceLayout*)(&toTransform->subresourceLayout));
}

void transform_tohost_VkPipelineCreateFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreateFlags2CreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineCreateFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreateFlags2CreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBufferUsageFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferUsageFlags2CreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBufferUsageFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferUsageFlags2CreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePushDescriptorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePushDescriptorProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePushDescriptorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePushDescriptorProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderingAttachmentLocationInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentLocationInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderingAttachmentLocationInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentLocationInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkRenderingInputAttachmentIndexInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInputAttachmentIndexInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderingInputAttachmentIndexInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInputAttachmentIndexInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance6Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance6Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Features* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceMaintenance6Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMaintenance6Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Properties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindMemoryStatus(
    ResourceTracker* resourceTracker,
    VkBindMemoryStatus* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindMemoryStatus(
    ResourceTracker* resourceTracker,
    VkBindMemoryStatus* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkBindDescriptorSetsInfo(
    ResourceTracker* resourceTracker,
    VkBindDescriptorSetsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkBindDescriptorSetsInfo(
    ResourceTracker* resourceTracker,
    VkBindDescriptorSetsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPushConstantsInfo(
    ResourceTracker* resourceTracker,
    VkPushConstantsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPushConstantsInfo(
    ResourceTracker* resourceTracker,
    VkPushConstantsInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPushDescriptorSetInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDescriptorWrites)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorWriteCount; ++i)
            {
                transform_tohost_VkWriteDescriptorSet(resourceTracker, (VkWriteDescriptorSet*)(toTransform->pDescriptorWrites + i));
            }
        }
    }
}

void transform_fromhost_VkPushDescriptorSetInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDescriptorWrites)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->descriptorWriteCount; ++i)
            {
                transform_fromhost_VkWriteDescriptorSet(resourceTracker, (VkWriteDescriptorSet*)(toTransform->pDescriptorWrites + i));
            }
        }
    }
}

void transform_tohost_VkPushDescriptorSetWithTemplateInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetWithTemplateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPushDescriptorSetWithTemplateInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetWithTemplateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePipelineProtectedAccessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineProtectedAccessFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePipelineProtectedAccessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineProtectedAccessFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePipelineRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePipelineRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePipelineRobustnessProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePipelineRobustnessProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRobustnessCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRobustnessCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRobustnessCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRobustnessCreateInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceHostImageCopyFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceHostImageCopyFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyFeatures* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceHostImageCopyProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceHostImageCopyProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyProperties* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkMemoryToImageCopy(
    ResourceTracker* resourceTracker,
    VkMemoryToImageCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_fromhost_VkMemoryToImageCopy(
    ResourceTracker* resourceTracker,
    VkMemoryToImageCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_tohost_VkImageToMemoryCopy(
    ResourceTracker* resourceTracker,
    VkImageToMemoryCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_tohost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_tohost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_fromhost_VkImageToMemoryCopy(
    ResourceTracker* resourceTracker,
    VkImageToMemoryCopy* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceLayers(resourceTracker, (VkImageSubresourceLayers*)(&toTransform->imageSubresource));
    transform_fromhost_VkOffset3D(resourceTracker, (VkOffset3D*)(&toTransform->imageOffset));
    transform_fromhost_VkExtent3D(resourceTracker, (VkExtent3D*)(&toTransform->imageExtent));
}

void transform_tohost_VkCopyMemoryToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyMemoryToImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkMemoryToImageCopy(resourceTracker, (VkMemoryToImageCopy*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyMemoryToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyMemoryToImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkMemoryToImageCopy(resourceTracker, (VkMemoryToImageCopy*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkCopyImageToMemoryInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkImageToMemoryCopy(resourceTracker, (VkImageToMemoryCopy*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyImageToMemoryInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToMemoryInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkImageToMemoryCopy(resourceTracker, (VkImageToMemoryCopy*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkCopyImageToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_tohost_VkImageCopy2(resourceTracker, (VkImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkCopyImageToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToImageInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->regionCount; ++i)
            {
                transform_fromhost_VkImageCopy2(resourceTracker, (VkImageCopy2*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_tohost_VkHostImageLayoutTransitionInfo(
    ResourceTracker* resourceTracker,
    VkHostImageLayoutTransitionInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_fromhost_VkHostImageLayoutTransitionInfo(
    ResourceTracker* resourceTracker,
    VkHostImageLayoutTransitionInfo* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkImageSubresourceRange(resourceTracker, (VkImageSubresourceRange*)(&toTransform->subresourceRange));
}

void transform_tohost_VkSubresourceHostMemcpySize(
    ResourceTracker* resourceTracker,
    VkSubresourceHostMemcpySize* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSubresourceHostMemcpySize(
    ResourceTracker* resourceTracker,
    VkSubresourceHostMemcpySize* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkHostImageCopyDevicePerformanceQuery(
    ResourceTracker* resourceTracker,
    VkHostImageCopyDevicePerformanceQuery* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkHostImageCopyDevicePerformanceQuery(
    ResourceTracker* resourceTracker,
    VkHostImageCopyDevicePerformanceQuery* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_external_semaphore_fd
void transform_tohost_VkImportSemaphoreFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportSemaphoreFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportSemaphoreFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportSemaphoreFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkSemaphoreGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkSemaphoreGetFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSemaphoreGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkSemaphoreGetFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_incremental_present
void transform_tohost_VkRectLayerKHR(
    ResourceTracker* resourceTracker,
    VkRectLayerKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_tohost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_tohost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_fromhost_VkRectLayerKHR(
    ResourceTracker* resourceTracker,
    VkRectLayerKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    transform_fromhost_VkOffset2D(resourceTracker, (VkOffset2D*)(&toTransform->offset));
    transform_fromhost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->extent));
}

void transform_tohost_VkPresentRegionKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pRectangles)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->rectangleCount; ++i)
            {
                transform_tohost_VkRectLayerKHR(resourceTracker, (VkRectLayerKHR*)(toTransform->pRectangles + i));
            }
        }
    }
}

void transform_fromhost_VkPresentRegionKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform)
    {
        if (toTransform->pRectangles)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->rectangleCount; ++i)
            {
                transform_fromhost_VkRectLayerKHR(resourceTracker, (VkRectLayerKHR*)(toTransform->pRectangles + i));
            }
        }
    }
}

void transform_tohost_VkPresentRegionsKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionsKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->swapchainCount; ++i)
            {
                transform_tohost_VkPresentRegionKHR(resourceTracker, (VkPresentRegionKHR*)(toTransform->pRegions + i));
            }
        }
    }
}

void transform_fromhost_VkPresentRegionsKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionsKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pRegions)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->swapchainCount; ++i)
            {
                transform_fromhost_VkPresentRegionKHR(resourceTracker, (VkPresentRegionKHR*)(toTransform->pRegions + i));
            }
        }
    }
}

#endif
#ifdef VK_KHR_external_fence_fd
void transform_tohost_VkImportFenceFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportFenceFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportFenceFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportFenceFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkFenceGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkFenceGetFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkFenceGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkFenceGetFdInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_KHR_pipeline_executable_properties
void transform_tohost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineExecutablePropertiesKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutablePropertiesKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineExecutablePropertiesKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutablePropertiesKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineExecutableInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineExecutableInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInfoKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineExecutableStatisticValueKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticValueKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkPipelineExecutableStatisticValueKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticValueKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkPipelineExecutableStatisticKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkPipelineExecutableStatisticValueKHR(resourceTracker, (VkPipelineExecutableStatisticValueKHR*)(&toTransform->value));
}

void transform_fromhost_VkPipelineExecutableStatisticKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkPipelineExecutableStatisticValueKHR(resourceTracker, (VkPipelineExecutableStatisticValueKHR*)(&toTransform->value));
}

void transform_tohost_VkPipelineExecutableInternalRepresentationKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInternalRepresentationKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineExecutableInternalRepresentationKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInternalRepresentationKHR* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_ANDROID_native_buffer
void transform_tohost_VkNativeBufferUsage2ANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferUsage2ANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkNativeBufferUsage2ANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferUsage2ANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkNativeBufferANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkNativeBufferUsage2ANDROID(resourceTracker, (VkNativeBufferUsage2ANDROID*)(&toTransform->usage2));
}

void transform_fromhost_VkNativeBufferANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkNativeBufferUsage2ANDROID(resourceTracker, (VkNativeBufferUsage2ANDROID*)(&toTransform->usage2));
}

void transform_tohost_VkSwapchainImageCreateInfoANDROID(
    ResourceTracker* resourceTracker,
    VkSwapchainImageCreateInfoANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkSwapchainImageCreateInfoANDROID(
    ResourceTracker* resourceTracker,
    VkSwapchainImageCreateInfoANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDevicePresentationPropertiesANDROID(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePresentationPropertiesANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePresentationPropertiesANDROID(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePresentationPropertiesANDROID* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_transform_feedback
void transform_tohost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRasterizationStateStreamCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateStreamCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationStateStreamCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateStreamCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_depth_clip_enable
void transform_tohost_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_image_drm_format_modifier
void transform_tohost_VkDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDrmFormatModifierPropertiesListEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesListEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDrmFormatModifierProperties)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->drmFormatModifierCount; ++i)
            {
                transform_tohost_VkDrmFormatModifierPropertiesEXT(resourceTracker, (VkDrmFormatModifierPropertiesEXT*)(toTransform->pDrmFormatModifierProperties + i));
            }
        }
    }
}

void transform_fromhost_VkDrmFormatModifierPropertiesListEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesListEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDrmFormatModifierProperties)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->drmFormatModifierCount; ++i)
            {
                transform_fromhost_VkDrmFormatModifierPropertiesEXT(resourceTracker, (VkDrmFormatModifierPropertiesEXT*)(toTransform->pDrmFormatModifierProperties + i));
            }
        }
    }
}

void transform_tohost_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageDrmFormatModifierListCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierListCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageDrmFormatModifierListCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierListCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pPlaneLayouts)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->drmFormatModifierPlaneCount; ++i)
            {
                transform_tohost_VkSubresourceLayout(resourceTracker, (VkSubresourceLayout*)(toTransform->pPlaneLayouts + i));
            }
        }
    }
}

void transform_fromhost_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pPlaneLayouts)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->drmFormatModifierPlaneCount; ++i)
            {
                transform_fromhost_VkSubresourceLayout(resourceTracker, (VkSubresourceLayout*)(toTransform->pPlaneLayouts + i));
            }
        }
    }
}

void transform_tohost_VkImageDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDrmFormatModifierProperties2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierProperties2EXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_fromhost_VkDrmFormatModifierProperties2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierProperties2EXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
}

void transform_tohost_VkDrmFormatModifierPropertiesList2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesList2EXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDrmFormatModifierProperties)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->drmFormatModifierCount; ++i)
            {
                transform_tohost_VkDrmFormatModifierProperties2EXT(resourceTracker, (VkDrmFormatModifierProperties2EXT*)(toTransform->pDrmFormatModifierProperties + i));
            }
        }
    }
}

void transform_fromhost_VkDrmFormatModifierPropertiesList2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesList2EXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    if (toTransform)
    {
        if (toTransform->pDrmFormatModifierProperties)
        {
            for (uint32_t i = 0; i < (uint32_t)toTransform->drmFormatModifierCount; ++i)
            {
                transform_fromhost_VkDrmFormatModifierProperties2EXT(resourceTracker, (VkDrmFormatModifierProperties2EXT*)(toTransform->pDrmFormatModifierProperties + i));
            }
        }
    }
}

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void transform_tohost_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_fragment_density_map
void transform_tohost_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->minFragmentDensityTexelSize));
    transform_tohost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->maxFragmentDensityTexelSize));
}

void transform_fromhost_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->minFragmentDensityTexelSize));
    transform_fromhost_VkExtent2D(resourceTracker, (VkExtent2D*)(&toTransform->maxFragmentDensityTexelSize));
}

void transform_tohost_VkRenderPassFragmentDensityMapCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderPassFragmentDensityMapCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(&toTransform->fragmentDensityMapAttachment));
}

void transform_fromhost_VkRenderPassFragmentDensityMapCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderPassFragmentDensityMapCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkAttachmentReference(resourceTracker, (VkAttachmentReference*)(&toTransform->fragmentDensityMapAttachment));
}

void transform_tohost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_memory_budget
void transform_tohost_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_provoking_vertex
void transform_tohost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state
void transform_tohost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_texel_buffer_alignment
void transform_tohost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_device_memory_report
void transform_tohost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceMemoryReportCallbackDataEXT(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryReportCallbackDataEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceMemoryReportCallbackDataEXT(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryReportCallbackDataEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkDeviceDeviceMemoryReportCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkDeviceDeviceMemoryReportCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkDeviceDeviceMemoryReportCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkDeviceDeviceMemoryReportCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_custom_border_color
void transform_tohost_VkSamplerCustomBorderColorCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkSamplerCustomBorderColorCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_tohost_VkClearColorValue(resourceTracker, (VkClearColorValue*)(&toTransform->customBorderColor));
}

void transform_fromhost_VkSamplerCustomBorderColorCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkSamplerCustomBorderColorCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
    transform_fromhost_VkClearColorValue(resourceTracker, (VkClearColorValue*)(&toTransform->customBorderColor));
}

void transform_tohost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_graphics_pipeline_library
void transform_tohost_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkGraphicsPipelineLibraryCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineLibraryCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkGraphicsPipelineLibraryCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineLibraryCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void transform_tohost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_image_compression_control
void transform_tohost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageCompressionControlEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionControlEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageCompressionControlEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionControlEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImageCompressionPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImageCompressionPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionPropertiesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_4444_formats
void transform_tohost_VkPhysicalDevice4444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice4444FormatsFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevice4444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice4444FormatsFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void transform_tohost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_extended_dynamic_state2
void transform_tohost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_color_write_enable
void transform_tohost_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkPipelineColorWriteCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineColorWriteCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPipelineColorWriteCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineColorWriteCreateInfoEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_GOOGLE_gfxstream
void transform_tohost_VkImportColorBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportColorBufferGOOGLE* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportColorBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportColorBufferGOOGLE* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkImportBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportBufferGOOGLE* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkImportBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportBufferGOOGLE* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_tohost_VkCreateBlobGOOGLE(
    ResourceTracker* resourceTracker,
    VkCreateBlobGOOGLE* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkCreateBlobGOOGLE(
    ResourceTracker* resourceTracker,
    VkCreateBlobGOOGLE* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void transform_tohost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_tohost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

void transform_fromhost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toTransform)
{
    (void)resourceTracker;
    (void)toTransform;
    if (toTransform->pNext)
    {
        transform_fromhost_extension_struct(resourceTracker, (void*)(toTransform->pNext));
    }
}

#endif
void transform_tohost_extension_struct(
    ResourceTracker* resourceTracker,
    void* structExtension_out)
{
    if (!structExtension_out)
    {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension_out);
    switch(structType)
    {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        {
            transform_tohost_VkShaderModuleCreateInfo(resourceTracker, reinterpret_cast<VkShaderModuleCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
        {
            transform_tohost_VkPipelineLayoutCreateInfo(resourceTracker, reinterpret_cast<VkPipelineLayoutCreateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceSubgroupProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        {
            transform_tohost_VkPhysicalDevice16BitStorageFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevice16BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        {
            transform_tohost_VkMemoryDedicatedRequirements(resourceTracker, reinterpret_cast<VkMemoryDedicatedRequirements*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
        {
            transform_tohost_VkMemoryDedicatedAllocateInfo(resourceTracker, reinterpret_cast<VkMemoryDedicatedAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
        {
            transform_tohost_VkMemoryAllocateFlagsInfo(resourceTracker, reinterpret_cast<VkMemoryAllocateFlagsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        {
            transform_tohost_VkDeviceGroupRenderPassBeginInfo(resourceTracker, reinterpret_cast<VkDeviceGroupRenderPassBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        {
            transform_tohost_VkDeviceGroupCommandBufferBeginInfo(resourceTracker, reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        {
            transform_tohost_VkDeviceGroupSubmitInfo(resourceTracker, reinterpret_cast<VkDeviceGroupSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        {
            transform_tohost_VkDeviceGroupBindSparseInfo(resourceTracker, reinterpret_cast<VkDeviceGroupBindSparseInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        {
            transform_tohost_VkBindBufferMemoryDeviceGroupInfo(resourceTracker, reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        {
            transform_tohost_VkBindImageMemoryDeviceGroupInfo(resourceTracker, reinterpret_cast<VkBindImageMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        {
            transform_tohost_VkDeviceGroupDeviceCreateInfo(resourceTracker, reinterpret_cast<VkDeviceGroupDeviceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        {
            transform_tohost_VkPhysicalDeviceFeatures2(resourceTracker, reinterpret_cast<VkPhysicalDeviceFeatures2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        {
            transform_tohost_VkPhysicalDevicePointClippingProperties(resourceTracker, reinterpret_cast<VkPhysicalDevicePointClippingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        {
            transform_tohost_VkRenderPassInputAttachmentAspectCreateInfo(resourceTracker, reinterpret_cast<VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
        {
            transform_tohost_VkImageViewUsageCreateInfo(resourceTracker, reinterpret_cast<VkImageViewUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        {
            transform_tohost_VkPipelineTessellationDomainOriginStateCreateInfo(resourceTracker, reinterpret_cast<VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        {
            transform_tohost_VkRenderPassMultiviewCreateInfo(resourceTracker, reinterpret_cast<VkRenderPassMultiviewCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceMultiviewFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceMultiviewFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceMultiviewProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMultiviewProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceVariablePointersFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceVariablePointersFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceProtectedMemoryFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceProtectedMemoryProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceProtectedMemoryProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        {
            transform_tohost_VkProtectedSubmitInfo(resourceTracker, reinterpret_cast<VkProtectedSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
        {
            transform_tohost_VkSamplerYcbcrConversionInfo(resourceTracker, reinterpret_cast<VkSamplerYcbcrConversionInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        {
            transform_tohost_VkBindImagePlaneMemoryInfo(resourceTracker, reinterpret_cast<VkBindImagePlaneMemoryInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        {
            transform_tohost_VkImagePlaneMemoryRequirementsInfo(resourceTracker, reinterpret_cast<VkImagePlaneMemoryRequirementsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        {
            transform_tohost_VkSamplerYcbcrConversionImageFormatProperties(resourceTracker, reinterpret_cast<VkSamplerYcbcrConversionImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        {
            resourceTracker->transformImpl_VkPhysicalDeviceExternalImageFormatInfo_tohost(reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out), 1);
            transform_tohost_VkPhysicalDeviceExternalImageFormatInfo(resourceTracker, reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        {
            resourceTracker->transformImpl_VkExternalImageFormatProperties_tohost(reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out), 1);
            transform_tohost_VkExternalImageFormatProperties(resourceTracker, reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceIDProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceIDProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        {
            resourceTracker->transformImpl_VkExternalMemoryImageCreateInfo_tohost(reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out), 1);
            transform_tohost_VkExternalMemoryImageCreateInfo(resourceTracker, reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
        {
            resourceTracker->transformImpl_VkExternalMemoryBufferCreateInfo_tohost(reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out), 1);
            transform_tohost_VkExternalMemoryBufferCreateInfo(resourceTracker, reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
        {
            resourceTracker->transformImpl_VkExportMemoryAllocateInfo_tohost(reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out), 1);
            transform_tohost_VkExportMemoryAllocateInfo(resourceTracker, reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        {
            transform_tohost_VkExportFenceCreateInfo(resourceTracker, reinterpret_cast<VkExportFenceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
        {
            transform_tohost_VkExportSemaphoreCreateInfo(resourceTracker, reinterpret_cast<VkExportSemaphoreCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceMaintenance3Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance3Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderDrawParametersFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceVulkan11Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan11Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceVulkan11Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan11Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceVulkan12Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan12Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceVulkan12Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan12Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        {
            transform_tohost_VkImageFormatListCreateInfo(resourceTracker, reinterpret_cast<VkImageFormatListCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        {
            transform_tohost_VkPhysicalDevice8BitStorageFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevice8BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceDriverProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceDriverProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderAtomicInt64Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderFloat16Int8Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceFloatControlsProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceFloatControlsProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
        {
            transform_tohost_VkDescriptorSetLayoutBindingFlagsCreateInfo(resourceTracker, reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceDescriptorIndexingFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceDescriptorIndexingProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        {
            transform_tohost_VkDescriptorSetVariableDescriptorCountAllocateInfo(resourceTracker, reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
        {
            transform_tohost_VkDescriptorSetVariableDescriptorCountLayoutSupport(resourceTracker, reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        {
            transform_tohost_VkSubpassDescriptionDepthStencilResolve(resourceTracker, reinterpret_cast<VkSubpassDescriptionDepthStencilResolve*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceDepthStencilResolveProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceScalarBlockLayoutFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        {
            transform_tohost_VkImageStencilUsageCreateInfo(resourceTracker, reinterpret_cast<VkImageStencilUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
        {
            transform_tohost_VkSamplerReductionModeCreateInfo(resourceTracker, reinterpret_cast<VkSamplerReductionModeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceSamplerFilterMinmaxProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceVulkanMemoryModelFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceImagelessFramebufferFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        {
            transform_tohost_VkFramebufferAttachmentsCreateInfo(resourceTracker, reinterpret_cast<VkFramebufferAttachmentsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        {
            transform_tohost_VkRenderPassAttachmentBeginInfo(resourceTracker, reinterpret_cast<VkRenderPassAttachmentBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        {
            transform_tohost_VkAttachmentReferenceStencilLayout(resourceTracker, reinterpret_cast<VkAttachmentReferenceStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        {
            transform_tohost_VkAttachmentDescriptionStencilLayout(resourceTracker, reinterpret_cast<VkAttachmentDescriptionStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceHostQueryResetFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceHostQueryResetFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceTimelineSemaphoreFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceTimelineSemaphoreProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        {
            transform_tohost_VkSemaphoreTypeCreateInfo(resourceTracker, reinterpret_cast<VkSemaphoreTypeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        {
            transform_tohost_VkTimelineSemaphoreSubmitInfo(resourceTracker, reinterpret_cast<VkTimelineSemaphoreSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceBufferDeviceAddressFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
        {
            transform_tohost_VkBufferOpaqueCaptureAddressCreateInfo(resourceTracker, reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
        {
            transform_tohost_VkMemoryOpaqueCaptureAddressAllocateInfo(resourceTracker, reinterpret_cast<VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceVulkan13Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan13Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceVulkan13Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan13Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        {
            transform_tohost_VkPipelineCreationFeedbackCreateInfo(resourceTracker, reinterpret_cast<VkPipelineCreationFeedbackCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderTerminateInvocationFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        {
            transform_tohost_VkPhysicalDevicePrivateDataFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePrivateDataFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        {
            transform_tohost_VkDevicePrivateDataCreateInfo(resourceTracker, reinterpret_cast<VkDevicePrivateDataCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        {
            transform_tohost_VkPhysicalDevicePipelineCreationCacheControlFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        {
            transform_tohost_VkMemoryBarrier2(resourceTracker, reinterpret_cast<VkMemoryBarrier2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceSynchronization2Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceSynchronization2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceImageRobustnessFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceSubgroupSizeControlFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceSubgroupSizeControlProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        {
            transform_tohost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(resourceTracker, reinterpret_cast<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceInlineUniformBlockFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceInlineUniformBlockProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
        {
            transform_tohost_VkWriteDescriptorSetInlineUniformBlock(resourceTracker, reinterpret_cast<VkWriteDescriptorSetInlineUniformBlock*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
        {
            transform_tohost_VkDescriptorPoolInlineUniformBlockCreateInfo(resourceTracker, reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        {
            transform_tohost_VkPipelineRenderingCreateInfo(resourceTracker, reinterpret_cast<VkPipelineRenderingCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceDynamicRenderingFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        {
            transform_tohost_VkCommandBufferInheritanceRenderingInfo(resourceTracker, reinterpret_cast<VkCommandBufferInheritanceRenderingInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderIntegerDotProductFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceShaderIntegerDotProductProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceTexelBufferAlignmentProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        {
            transform_tohost_VkFormatProperties3(resourceTracker, reinterpret_cast<VkFormatProperties3*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceMaintenance4Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance4Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceMaintenance4Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance4Properties*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceVulkan14Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan14Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceVulkan14Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan14Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        {
            transform_tohost_VkDeviceQueueGlobalPriorityCreateInfo(resourceTracker, reinterpret_cast<VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceGlobalPriorityQueryFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
        {
            transform_tohost_VkQueueFamilyGlobalPriorityProperties(resourceTracker, reinterpret_cast<VkQueueFamilyGlobalPriorityProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderSubgroupRotateFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderFloatControls2Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderFloatControls2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceShaderExpectAssumeFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceLineRasterizationFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceLineRasterizationProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
        {
            transform_tohost_VkPipelineRasterizationLineStateCreateInfo(resourceTracker, reinterpret_cast<VkPipelineRasterizationLineStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceVertexAttributeDivisorProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
        {
            transform_tohost_VkPipelineVertexInputDivisorStateCreateInfo(resourceTracker, reinterpret_cast<VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceVertexAttributeDivisorFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceIndexTypeUint8Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceIndexTypeUint8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceMaintenance5Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance5Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceMaintenance5Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance5Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
        {
            transform_tohost_VkPipelineCreateFlags2CreateInfo(resourceTracker, reinterpret_cast<VkPipelineCreateFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
        {
            transform_tohost_VkBufferUsageFlags2CreateInfo(resourceTracker, reinterpret_cast<VkBufferUsageFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        {
            transform_tohost_VkPhysicalDevicePushDescriptorProperties(resourceTracker, reinterpret_cast<VkPhysicalDevicePushDescriptorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
        {
            transform_tohost_VkRenderingAttachmentLocationInfo(resourceTracker, reinterpret_cast<VkRenderingAttachmentLocationInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
        {
            transform_tohost_VkRenderingInputAttachmentIndexInfo(resourceTracker, reinterpret_cast<VkRenderingInputAttachmentIndexInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceMaintenance6Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance6Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceMaintenance6Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance6Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
        {
            transform_tohost_VkBindMemoryStatus(resourceTracker, reinterpret_cast<VkBindMemoryStatus*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        {
            transform_tohost_VkPhysicalDevicePipelineProtectedAccessFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        {
            transform_tohost_VkPhysicalDevicePipelineRobustnessFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
        {
            transform_tohost_VkPhysicalDevicePipelineRobustnessProperties(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineRobustnessProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
        {
            transform_tohost_VkPipelineRobustnessCreateInfo(resourceTracker, reinterpret_cast<VkPipelineRobustnessCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        {
            transform_tohost_VkPhysicalDeviceHostImageCopyFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceHostImageCopyFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
        {
            transform_tohost_VkPhysicalDeviceHostImageCopyProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceHostImageCopyProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        {
            transform_tohost_VkSubresourceHostMemcpySize(resourceTracker, reinterpret_cast<VkSubresourceHostMemcpySize*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
        {
            transform_tohost_VkHostImageCopyDevicePerformanceQuery(resourceTracker, reinterpret_cast<VkHostImageCopyDevicePerformanceQuery*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
        {
            transform_tohost_VkPresentRegionsKHR(resourceTracker, reinterpret_cast<VkPresentRegionsKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
        {
            transform_tohost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID:
        {
            transform_tohost_VkNativeBufferANDROID(resourceTracker, reinterpret_cast<VkNativeBufferANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID:
        {
            transform_tohost_VkSwapchainImageCreateInfoANDROID(resourceTracker, reinterpret_cast<VkSwapchainImageCreateInfoANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID:
        {
            transform_tohost_VkPhysicalDevicePresentationPropertiesANDROID(resourceTracker, reinterpret_cast<VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        {
            transform_tohost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        {
            transform_tohost_VkPipelineRasterizationStateStreamCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_depth_clip_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceDepthClipEnableFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        {
            transform_tohost_VkPipelineRasterizationDepthClipStateCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        {
            transform_tohost_VkDrmFormatModifierPropertiesListEXT(resourceTracker, reinterpret_cast<VkDrmFormatModifierPropertiesListEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        {
            transform_tohost_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        {
            transform_tohost_VkImageDrmFormatModifierListCreateInfoEXT(resourceTracker, reinterpret_cast<VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        {
            transform_tohost_VkImageDrmFormatModifierExplicitCreateInfoEXT(resourceTracker, reinterpret_cast<VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        {
            transform_tohost_VkDrmFormatModifierPropertiesList2EXT(resourceTracker, reinterpret_cast<VkDrmFormatModifierPropertiesList2EXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_vertex_attribute_divisor
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        {
            transform_tohost_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_fragment_density_map
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
        {
            transform_tohost_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
        {
            transform_tohost_VkRenderPassFragmentDensityMapCreateInfoEXT(resourceTracker, reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
        {
            transform_tohost_VkRenderingFragmentDensityMapAttachmentInfoEXT(resourceTracker, reinterpret_cast<VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_memory_budget
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        {
            transform_tohost_VkPhysicalDeviceMemoryBudgetPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceProvokingVertexFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        {
            transform_tohost_VkPhysicalDeviceProvokingVertexPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        {
            transform_tohost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
        {
            transform_tohost_VkDeviceDeviceMemoryReportCreateInfoEXT(resourceTracker, reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
        {
            transform_tohost_VkSamplerCustomBorderColorCreateInfoEXT(resourceTracker, reinterpret_cast<VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        {
            transform_tohost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_graphics_pipeline_library
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        {
            transform_tohost_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        {
            transform_tohost_VkGraphicsPipelineLibraryCreateInfoEXT(resourceTracker, reinterpret_cast<VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
        {
            transform_tohost_VkImageCompressionControlEXT(resourceTracker, reinterpret_cast<VkImageCompressionControlEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
        {
            transform_tohost_VkImageCompressionPropertiesEXT(resourceTracker, reinterpret_cast<VkImageCompressionPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDevice4444FormatsFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_color_write_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceColorWriteEnableFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        {
            transform_tohost_VkPipelineColorWriteCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineColorWriteCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE:
        {
            transform_tohost_VkImportColorBufferGOOGLE(resourceTracker, reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE:
        {
            transform_tohost_VkImportBufferGOOGLE(resourceTracker, reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE:
        {
            transform_tohost_VkCreateBlobGOOGLE(resourceTracker, reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
        {
            transform_tohost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
        default:
        {
            return;
        }
    }
}

void transform_fromhost_extension_struct(
    ResourceTracker* resourceTracker,
    void* structExtension_out)
{
    if (!structExtension_out)
    {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension_out);
    switch(structType)
    {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        {
            transform_fromhost_VkShaderModuleCreateInfo(resourceTracker, reinterpret_cast<VkShaderModuleCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
        {
            transform_fromhost_VkPipelineLayoutCreateInfo(resourceTracker, reinterpret_cast<VkPipelineLayoutCreateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceSubgroupProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        {
            transform_fromhost_VkPhysicalDevice16BitStorageFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevice16BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        {
            transform_fromhost_VkMemoryDedicatedRequirements(resourceTracker, reinterpret_cast<VkMemoryDedicatedRequirements*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
        {
            transform_fromhost_VkMemoryDedicatedAllocateInfo(resourceTracker, reinterpret_cast<VkMemoryDedicatedAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
        {
            transform_fromhost_VkMemoryAllocateFlagsInfo(resourceTracker, reinterpret_cast<VkMemoryAllocateFlagsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        {
            transform_fromhost_VkDeviceGroupRenderPassBeginInfo(resourceTracker, reinterpret_cast<VkDeviceGroupRenderPassBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        {
            transform_fromhost_VkDeviceGroupCommandBufferBeginInfo(resourceTracker, reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        {
            transform_fromhost_VkDeviceGroupSubmitInfo(resourceTracker, reinterpret_cast<VkDeviceGroupSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        {
            transform_fromhost_VkDeviceGroupBindSparseInfo(resourceTracker, reinterpret_cast<VkDeviceGroupBindSparseInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
        {
            transform_fromhost_VkBindBufferMemoryDeviceGroupInfo(resourceTracker, reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        {
            transform_fromhost_VkBindImageMemoryDeviceGroupInfo(resourceTracker, reinterpret_cast<VkBindImageMemoryDeviceGroupInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        {
            transform_fromhost_VkDeviceGroupDeviceCreateInfo(resourceTracker, reinterpret_cast<VkDeviceGroupDeviceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        {
            transform_fromhost_VkPhysicalDeviceFeatures2(resourceTracker, reinterpret_cast<VkPhysicalDeviceFeatures2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDevicePointClippingProperties(resourceTracker, reinterpret_cast<VkPhysicalDevicePointClippingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        {
            transform_fromhost_VkRenderPassInputAttachmentAspectCreateInfo(resourceTracker, reinterpret_cast<VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
        {
            transform_fromhost_VkImageViewUsageCreateInfo(resourceTracker, reinterpret_cast<VkImageViewUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        {
            transform_fromhost_VkPipelineTessellationDomainOriginStateCreateInfo(resourceTracker, reinterpret_cast<VkPipelineTessellationDomainOriginStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        {
            transform_fromhost_VkRenderPassMultiviewCreateInfo(resourceTracker, reinterpret_cast<VkRenderPassMultiviewCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceMultiviewFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceMultiviewFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceMultiviewProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMultiviewProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceVariablePointersFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceVariablePointersFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceProtectedMemoryFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceProtectedMemoryProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceProtectedMemoryProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        {
            transform_fromhost_VkProtectedSubmitInfo(resourceTracker, reinterpret_cast<VkProtectedSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
        {
            transform_fromhost_VkSamplerYcbcrConversionInfo(resourceTracker, reinterpret_cast<VkSamplerYcbcrConversionInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        {
            transform_fromhost_VkBindImagePlaneMemoryInfo(resourceTracker, reinterpret_cast<VkBindImagePlaneMemoryInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        {
            transform_fromhost_VkImagePlaneMemoryRequirementsInfo(resourceTracker, reinterpret_cast<VkImagePlaneMemoryRequirementsInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        {
            transform_fromhost_VkSamplerYcbcrConversionImageFormatProperties(resourceTracker, reinterpret_cast<VkSamplerYcbcrConversionImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        {
            resourceTracker->transformImpl_VkPhysicalDeviceExternalImageFormatInfo_fromhost(reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out), 1);
            transform_fromhost_VkPhysicalDeviceExternalImageFormatInfo(resourceTracker, reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        {
            resourceTracker->transformImpl_VkExternalImageFormatProperties_fromhost(reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out), 1);
            transform_fromhost_VkExternalImageFormatProperties(resourceTracker, reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceIDProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceIDProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        {
            resourceTracker->transformImpl_VkExternalMemoryImageCreateInfo_fromhost(reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out), 1);
            transform_fromhost_VkExternalMemoryImageCreateInfo(resourceTracker, reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
        {
            resourceTracker->transformImpl_VkExternalMemoryBufferCreateInfo_fromhost(reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out), 1);
            transform_fromhost_VkExternalMemoryBufferCreateInfo(resourceTracker, reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
        {
            resourceTracker->transformImpl_VkExportMemoryAllocateInfo_fromhost(reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out), 1);
            transform_fromhost_VkExportMemoryAllocateInfo(resourceTracker, reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
        {
            transform_fromhost_VkExportFenceCreateInfo(resourceTracker, reinterpret_cast<VkExportFenceCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
        {
            transform_fromhost_VkExportSemaphoreCreateInfo(resourceTracker, reinterpret_cast<VkExportSemaphoreCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceMaintenance3Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance3Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderDrawParametersFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderDrawParametersFeatures*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan11Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan11Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan11Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan11Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan12Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan12Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan12Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan12Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        {
            transform_fromhost_VkImageFormatListCreateInfo(resourceTracker, reinterpret_cast<VkImageFormatListCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        {
            transform_fromhost_VkPhysicalDevice8BitStorageFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevice8BitStorageFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceDriverProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceDriverProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderAtomicInt64Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderFloat16Int8Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceFloatControlsProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceFloatControlsProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
        {
            transform_fromhost_VkDescriptorSetLayoutBindingFlagsCreateInfo(resourceTracker, reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceDescriptorIndexingFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceDescriptorIndexingProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceDescriptorIndexingProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        {
            transform_fromhost_VkDescriptorSetVariableDescriptorCountAllocateInfo(resourceTracker, reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
        {
            transform_fromhost_VkDescriptorSetVariableDescriptorCountLayoutSupport(resourceTracker, reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        {
            transform_fromhost_VkSubpassDescriptionDepthStencilResolve(resourceTracker, reinterpret_cast<VkSubpassDescriptionDepthStencilResolve*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceDepthStencilResolveProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceDepthStencilResolveProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceScalarBlockLayoutFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        {
            transform_fromhost_VkImageStencilUsageCreateInfo(resourceTracker, reinterpret_cast<VkImageStencilUsageCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
        {
            transform_fromhost_VkSamplerReductionModeCreateInfo(resourceTracker, reinterpret_cast<VkSamplerReductionModeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceSamplerFilterMinmaxProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceSamplerFilterMinmaxProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceVulkanMemoryModelFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceImagelessFramebufferFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceImagelessFramebufferFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        {
            transform_fromhost_VkFramebufferAttachmentsCreateInfo(resourceTracker, reinterpret_cast<VkFramebufferAttachmentsCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        {
            transform_fromhost_VkRenderPassAttachmentBeginInfo(resourceTracker, reinterpret_cast<VkRenderPassAttachmentBeginInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        {
            transform_fromhost_VkAttachmentReferenceStencilLayout(resourceTracker, reinterpret_cast<VkAttachmentReferenceStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        {
            transform_fromhost_VkAttachmentDescriptionStencilLayout(resourceTracker, reinterpret_cast<VkAttachmentDescriptionStencilLayout*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceHostQueryResetFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceHostQueryResetFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceTimelineSemaphoreFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceTimelineSemaphoreProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        {
            transform_fromhost_VkSemaphoreTypeCreateInfo(resourceTracker, reinterpret_cast<VkSemaphoreTypeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        {
            transform_fromhost_VkTimelineSemaphoreSubmitInfo(resourceTracker, reinterpret_cast<VkTimelineSemaphoreSubmitInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceBufferDeviceAddressFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
        {
            transform_fromhost_VkBufferOpaqueCaptureAddressCreateInfo(resourceTracker, reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
        {
            transform_fromhost_VkMemoryOpaqueCaptureAddressAllocateInfo(resourceTracker, reinterpret_cast<VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan13Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan13Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan13Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan13Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        {
            transform_fromhost_VkPipelineCreationFeedbackCreateInfo(resourceTracker, reinterpret_cast<VkPipelineCreationFeedbackCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderTerminateInvocationFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderTerminateInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        {
            transform_fromhost_VkPhysicalDevicePrivateDataFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePrivateDataFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        {
            transform_fromhost_VkDevicePrivateDataCreateInfo(resourceTracker, reinterpret_cast<VkDevicePrivateDataCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        {
            transform_fromhost_VkPhysicalDevicePipelineCreationCacheControlFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineCreationCacheControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        {
            transform_fromhost_VkMemoryBarrier2(resourceTracker, reinterpret_cast<VkMemoryBarrier2*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceSynchronization2Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceSynchronization2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceImageRobustnessFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceSubgroupSizeControlFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceSubgroupSizeControlProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        {
            transform_fromhost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(resourceTracker, reinterpret_cast<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceInlineUniformBlockFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceInlineUniformBlockProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceInlineUniformBlockProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
        {
            transform_fromhost_VkWriteDescriptorSetInlineUniformBlock(resourceTracker, reinterpret_cast<VkWriteDescriptorSetInlineUniformBlock*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
        {
            transform_fromhost_VkDescriptorPoolInlineUniformBlockCreateInfo(resourceTracker, reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        {
            transform_fromhost_VkPipelineRenderingCreateInfo(resourceTracker, reinterpret_cast<VkPipelineRenderingCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceDynamicRenderingFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        {
            transform_fromhost_VkCommandBufferInheritanceRenderingInfo(resourceTracker, reinterpret_cast<VkCommandBufferInheritanceRenderingInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        {
            transform_fromhost_VkFormatProperties3(resourceTracker, reinterpret_cast<VkFormatProperties3*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceMaintenance4Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance4Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceMaintenance4Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance4Properties*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_VERSION_1_4
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan14Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan14Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceVulkan14Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVulkan14Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
        {
            transform_fromhost_VkDeviceQueueGlobalPriorityCreateInfo(resourceTracker, reinterpret_cast<VkDeviceQueueGlobalPriorityCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceGlobalPriorityQueryFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceGlobalPriorityQueryFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
        {
            transform_fromhost_VkQueueFamilyGlobalPriorityProperties(resourceTracker, reinterpret_cast<VkQueueFamilyGlobalPriorityProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderSubgroupRotateFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderSubgroupRotateFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderFloatControls2Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderFloatControls2Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceShaderExpectAssumeFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceShaderExpectAssumeFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceLineRasterizationFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceLineRasterizationProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceLineRasterizationProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
        {
            transform_fromhost_VkPipelineRasterizationLineStateCreateInfo(resourceTracker, reinterpret_cast<VkPipelineRasterizationLineStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
        {
            transform_fromhost_VkPipelineVertexInputDivisorStateCreateInfo(resourceTracker, reinterpret_cast<VkPipelineVertexInputDivisorStateCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceIndexTypeUint8Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceIndexTypeUint8Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceMaintenance5Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance5Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceMaintenance5Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance5Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
        {
            transform_fromhost_VkPipelineCreateFlags2CreateInfo(resourceTracker, reinterpret_cast<VkPipelineCreateFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
        {
            transform_fromhost_VkBufferUsageFlags2CreateInfo(resourceTracker, reinterpret_cast<VkBufferUsageFlags2CreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDevicePushDescriptorProperties(resourceTracker, reinterpret_cast<VkPhysicalDevicePushDescriptorProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceDynamicRenderingLocalReadFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
        {
            transform_fromhost_VkRenderingAttachmentLocationInfo(resourceTracker, reinterpret_cast<VkRenderingAttachmentLocationInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
        {
            transform_fromhost_VkRenderingInputAttachmentIndexInfo(resourceTracker, reinterpret_cast<VkRenderingInputAttachmentIndexInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceMaintenance6Features(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance6Features*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceMaintenance6Properties(resourceTracker, reinterpret_cast<VkPhysicalDeviceMaintenance6Properties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
        {
            transform_fromhost_VkBindMemoryStatus(resourceTracker, reinterpret_cast<VkBindMemoryStatus*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
        {
            transform_fromhost_VkPhysicalDevicePipelineProtectedAccessFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineProtectedAccessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
        {
            transform_fromhost_VkPhysicalDevicePipelineRobustnessFeatures(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineRobustnessFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDevicePipelineRobustnessProperties(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineRobustnessProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
        {
            transform_fromhost_VkPipelineRobustnessCreateInfo(resourceTracker, reinterpret_cast<VkPipelineRobustnessCreateInfo*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
        {
            transform_fromhost_VkPhysicalDeviceHostImageCopyFeatures(resourceTracker, reinterpret_cast<VkPhysicalDeviceHostImageCopyFeatures*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
        {
            transform_fromhost_VkPhysicalDeviceHostImageCopyProperties(resourceTracker, reinterpret_cast<VkPhysicalDeviceHostImageCopyProperties*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
        {
            transform_fromhost_VkSubresourceHostMemcpySize(resourceTracker, reinterpret_cast<VkSubresourceHostMemcpySize*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
        {
            transform_fromhost_VkHostImageCopyDevicePerformanceQuery(resourceTracker, reinterpret_cast<VkHostImageCopyDevicePerformanceQuery*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
        {
            transform_fromhost_VkPresentRegionsKHR(resourceTracker, reinterpret_cast<VkPresentRegionsKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
        {
            transform_fromhost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(resourceTracker, reinterpret_cast<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID:
        {
            transform_fromhost_VkNativeBufferANDROID(resourceTracker, reinterpret_cast<VkNativeBufferANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID:
        {
            transform_fromhost_VkSwapchainImageCreateInfoANDROID(resourceTracker, reinterpret_cast<VkSwapchainImageCreateInfoANDROID*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID:
        {
            transform_fromhost_VkPhysicalDevicePresentationPropertiesANDROID(resourceTracker, reinterpret_cast<VkPhysicalDevicePresentationPropertiesANDROID*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        {
            transform_fromhost_VkPipelineRasterizationStateStreamCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineRasterizationStateStreamCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_depth_clip_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceDepthClipEnableFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceDepthClipEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        {
            transform_fromhost_VkPipelineRasterizationDepthClipStateCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineRasterizationDepthClipStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_drm_format_modifier
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        {
            transform_fromhost_VkDrmFormatModifierPropertiesListEXT(resourceTracker, reinterpret_cast<VkDrmFormatModifierPropertiesListEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        {
            transform_fromhost_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageDrmFormatModifierInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        {
            transform_fromhost_VkImageDrmFormatModifierListCreateInfoEXT(resourceTracker, reinterpret_cast<VkImageDrmFormatModifierListCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        {
            transform_fromhost_VkImageDrmFormatModifierExplicitCreateInfoEXT(resourceTracker, reinterpret_cast<VkImageDrmFormatModifierExplicitCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        {
            transform_fromhost_VkDrmFormatModifierPropertiesList2EXT(resourceTracker, reinterpret_cast<VkDrmFormatModifierPropertiesList2EXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_vertex_attribute_divisor
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_fragment_density_map
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceFragmentDensityMapPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
        {
            transform_fromhost_VkRenderPassFragmentDensityMapCreateInfoEXT(resourceTracker, reinterpret_cast<VkRenderPassFragmentDensityMapCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
        {
            transform_fromhost_VkRenderingFragmentDensityMapAttachmentInfoEXT(resourceTracker, reinterpret_cast<VkRenderingFragmentDensityMapAttachmentInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_memory_budget
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceMemoryBudgetPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceMemoryBudgetPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceProvokingVertexFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceProvokingVertexPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceProvokingVertexPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        {
            transform_fromhost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
        {
            transform_fromhost_VkDeviceDeviceMemoryReportCreateInfoEXT(resourceTracker, reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
        {
            transform_fromhost_VkSamplerCustomBorderColorCreateInfoEXT(resourceTracker, reinterpret_cast<VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_graphics_pipeline_library
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        {
            transform_fromhost_VkGraphicsPipelineLibraryCreateInfoEXT(resourceTracker, reinterpret_cast<VkGraphicsPipelineLibraryCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
        {
            transform_fromhost_VkImageCompressionControlEXT(resourceTracker, reinterpret_cast<VkImageCompressionControlEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
        {
            transform_fromhost_VkImageCompressionPropertiesEXT(resourceTracker, reinterpret_cast<VkImageCompressionPropertiesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDevice4444FormatsFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_color_write_enable
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceColorWriteEnableFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceColorWriteEnableFeaturesEXT*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        {
            transform_fromhost_VkPipelineColorWriteCreateInfoEXT(resourceTracker, reinterpret_cast<VkPipelineColorWriteCreateInfoEXT*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE:
        {
            transform_fromhost_VkImportColorBufferGOOGLE(resourceTracker, reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE:
        {
            transform_fromhost_VkImportBufferGOOGLE(resourceTracker, reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out));
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE:
        {
            transform_fromhost_VkCreateBlobGOOGLE(resourceTracker, reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out));
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
        {
            transform_fromhost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(resourceTracker, reinterpret_cast<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(structExtension_out));
            break;
        }
#endif
        default:
        {
            return;
        }
    }
}


}  // namespace vk
}  // namespace gfxstream
