// GENERATED BY ISLE. DO NOT EDIT!
//
// Generated automatically from the instruction-selection DSL code in:
// - src/prelude.isle
// - src/prelude_lower.isle
// - src/isa/x64/inst.isle
// - src/isa/x64/lower.isle
// - /build/lapce/src/lapce-0.4.6/target/release-lto/build/cranelift-codegen-d79f1091bdf3f75b/out/clif_lower.isle

use super::*; // Pulls in all external types.
use std::marker::PhantomData;

/// Context during lowering: an implementation of this trait
/// must be provided with all external constructors and extractors.
/// A mutable borrow is passed along through all lowering logic.
pub trait Context {
    fn unit(&mut self) -> Unit;
    fn value_type(&mut self, arg0: Value) -> Type;
    fn u32_nonnegative(&mut self, arg0: u32) -> Option<u32>;
    fn offset32(&mut self, arg0: Offset32) -> i32;
    fn u32_lteq(&mut self, arg0: u32, arg1: u32) -> Option<Unit>;
    fn u8_lteq(&mut self, arg0: u8, arg1: u8) -> Option<Unit>;
    fn u8_lt(&mut self, arg0: u8, arg1: u8) -> Option<Unit>;
    fn simm32(&mut self, arg0: Imm64) -> Option<i32>;
    fn uimm8(&mut self, arg0: Imm64) -> Option<u8>;
    fn u8_as_i8(&mut self, arg0: u8) -> i8;
    fn u8_as_u32(&mut self, arg0: u8) -> u32;
    fn u8_as_u64(&mut self, arg0: u8) -> u64;
    fn u16_as_u64(&mut self, arg0: u16) -> u64;
    fn u32_as_u64(&mut self, arg0: u32) -> u64;
    fn i32_as_i64(&mut self, arg0: i32) -> i64;
    fn i64_as_u64(&mut self, arg0: i64) -> u64;
    fn i64_neg(&mut self, arg0: i64) -> i64;
    fn u128_as_u64(&mut self, arg0: u128) -> Option<u64>;
    fn u64_as_u32(&mut self, arg0: u64) -> Option<u32>;
    fn u64_as_i32(&mut self, arg0: u64) -> i32;
    fn u8_and(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u8_shl(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u8_shr(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u8_sub(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u32_add(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u32_sub(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u32_and(&mut self, arg0: u32, arg1: u32) -> u32;
    fn s32_add_fallible(&mut self, arg0: i32, arg1: i32) -> Option<i32>;
    fn u64_add(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_sub(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_mul(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_sdiv(&mut self, arg0: u64, arg1: u64) -> Option<u64>;
    fn u64_udiv(&mut self, arg0: u64, arg1: u64) -> Option<u64>;
    fn u64_and(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_or(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_xor(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_shl(&mut self, arg0: u64, arg1: u64) -> u64;
    fn imm64_shl(&mut self, arg0: Type, arg1: Imm64, arg2: Imm64) -> Imm64;
    fn imm64_ushr(&mut self, arg0: Type, arg1: Imm64, arg2: Imm64) -> Imm64;
    fn imm64_sshr(&mut self, arg0: Type, arg1: Imm64, arg2: Imm64) -> Imm64;
    fn u64_not(&mut self, arg0: u64) -> u64;
    fn u64_eq(&mut self, arg0: u64, arg1: u64) -> bool;
    fn u64_le(&mut self, arg0: u64, arg1: u64) -> bool;
    fn u64_lt(&mut self, arg0: u64, arg1: u64) -> bool;
    fn i64_shr(&mut self, arg0: i64, arg1: i64) -> i64;
    fn i64_ctz(&mut self, arg0: i64) -> i64;
    fn i64_sextend_u64(&mut self, arg0: Type, arg1: u64) -> i64;
    fn i64_sextend_imm64(&mut self, arg0: Type, arg1: Imm64) -> i64;
    fn u64_uextend_imm64(&mut self, arg0: Type, arg1: Imm64) -> u64;
    fn imm64_icmp(&mut self, arg0: Type, arg1: &IntCC, arg2: Imm64, arg3: Imm64) -> Imm64;
    fn u64_is_zero(&mut self, arg0: u64) -> bool;
    fn u64_is_odd(&mut self, arg0: u64) -> bool;
    fn u128_replicated_u64(&mut self, arg0: u128) -> Option<u64>;
    fn u64_replicated_u32(&mut self, arg0: u64) -> Option<u64>;
    fn u32_replicated_u16(&mut self, arg0: u64) -> Option<u64>;
    fn u16_replicated_u8(&mut self, arg0: u64) -> Option<u8>;
    fn ty_umin(&mut self, arg0: Type) -> u64;
    fn ty_umax(&mut self, arg0: Type) -> u64;
    fn ty_smin(&mut self, arg0: Type) -> u64;
    fn ty_smax(&mut self, arg0: Type) -> u64;
    fn ty_bits(&mut self, arg0: Type) -> u8;
    fn ty_bits_u16(&mut self, arg0: Type) -> u16;
    fn ty_bits_u64(&mut self, arg0: Type) -> u64;
    fn ty_mask(&mut self, arg0: Type) -> u64;
    fn ty_lane_mask(&mut self, arg0: Type) -> u64;
    fn ty_lane_count(&mut self, arg0: Type) -> u64;
    fn ty_bytes(&mut self, arg0: Type) -> u16;
    fn lane_type(&mut self, arg0: Type) -> Type;
    fn ty_half_lanes(&mut self, arg0: Type) -> Option<Type>;
    fn ty_half_width(&mut self, arg0: Type) -> Option<Type>;
    fn ty_equal(&mut self, arg0: Type, arg1: Type) -> bool;
    fn mem_flags_trusted(&mut self) -> MemFlags;
    fn intcc_swap_args(&mut self, arg0: &IntCC) -> IntCC;
    fn intcc_complement(&mut self, arg0: &IntCC) -> IntCC;
    fn intcc_without_eq(&mut self, arg0: &IntCC) -> IntCC;
    fn floatcc_swap_args(&mut self, arg0: &FloatCC) -> FloatCC;
    fn floatcc_complement(&mut self, arg0: &FloatCC) -> FloatCC;
    fn floatcc_unordered(&mut self, arg0: &FloatCC) -> bool;
    fn fits_in_16(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn lane_fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32(&mut self, arg0: Type) -> Option<Type>;
    fn ty_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_scalar_64_extract(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_scalar_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32_or_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_8_or_16(&mut self, arg0: Type) -> Option<Type>;
    fn int_fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_16_to_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_scalar(&mut self, arg0: Type) -> Option<Type>;
    fn ty_scalar_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_float_or_vec(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vector_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vector_not_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec64_ctor(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec128(&mut self, arg0: Type) -> Option<Type>;
    fn ty_dyn_vec64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_dyn_vec128(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec64_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec128_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_addr64(&mut self, arg0: Type) -> Option<Type>;
    fn not_vec32x2(&mut self, arg0: Type) -> Option<Type>;
    fn not_i64x2(&mut self, arg0: Type) -> Option<()>;
    fn u8_from_uimm8(&mut self, arg0: Uimm8) -> u8;
    fn u64_from_bool(&mut self, arg0: bool) -> u64;
    fn u64_from_imm64(&mut self, arg0: Imm64) -> u64;
    fn nonzero_u64_from_imm64(&mut self, arg0: Imm64) -> Option<u64>;
    fn imm64_power_of_two(&mut self, arg0: Imm64) -> Option<u64>;
    fn imm64(&mut self, arg0: u64) -> Imm64;
    fn imm64_masked(&mut self, arg0: Type, arg1: u64) -> Imm64;
    fn u32_from_ieee32(&mut self, arg0: Ieee32) -> u32;
    fn u64_from_ieee64(&mut self, arg0: Ieee64) -> u64;
    fn multi_lane(&mut self, arg0: Type) -> Option<(u32, u32)>;
    fn dynamic_lane(&mut self, arg0: Type) -> Option<(u32, u32)>;
    fn dynamic_int_lane(&mut self, arg0: Type) -> Option<u32>;
    fn dynamic_fp_lane(&mut self, arg0: Type) -> Option<u32>;
    fn ty_dyn64_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_dyn128_int(&mut self, arg0: Type) -> Option<Type>;
    fn offset32_to_i32(&mut self, arg0: Offset32) -> i32;
    fn i32_to_offset32(&mut self, arg0: i32) -> Offset32;
    fn intcc_unsigned(&mut self, arg0: &IntCC) -> IntCC;
    fn signed_cond_code(&mut self, arg0: &IntCC) -> Option<IntCC>;
    fn trap_code_division_by_zero(&mut self) -> TrapCode;
    fn trap_code_integer_overflow(&mut self) -> TrapCode;
    fn trap_code_bad_conversion_to_integer(&mut self) -> TrapCode;
    fn range(&mut self, arg0: usize, arg1: usize) -> Range;
    fn range_view(&mut self, arg0: Range) -> RangeView;
    fn value_reg(&mut self, arg0: Reg) -> ValueRegs;
    fn writable_value_reg(&mut self, arg0: WritableReg) -> WritableValueRegs;
    fn value_regs(&mut self, arg0: Reg, arg1: Reg) -> ValueRegs;
    fn writable_value_regs(&mut self, arg0: WritableReg, arg1: WritableReg) -> WritableValueRegs;
    fn value_regs_invalid(&mut self) -> ValueRegs;
    fn output_none(&mut self) -> InstOutput;
    fn output(&mut self, arg0: ValueRegs) -> InstOutput;
    fn output_pair(&mut self, arg0: ValueRegs, arg1: ValueRegs) -> InstOutput;
    fn output_builder_new(&mut self) -> InstOutputBuilder;
    fn output_builder_push(&mut self, arg0: &InstOutputBuilder, arg1: ValueRegs) -> Unit;
    fn output_builder_finish(&mut self, arg0: &InstOutputBuilder) -> InstOutput;
    fn temp_writable_reg(&mut self, arg0: Type) -> WritableReg;
    fn is_valid_reg(&mut self, arg0: Reg) -> bool;
    fn invalid_reg(&mut self) -> Reg;
    fn mark_value_used(&mut self, arg0: Value) -> Unit;
    fn put_in_reg(&mut self, arg0: Value) -> Reg;
    fn put_in_regs(&mut self, arg0: Value) -> ValueRegs;
    fn ensure_in_vreg(&mut self, arg0: Reg, arg1: Type) -> Reg;
    fn value_regs_get(&mut self, arg0: ValueRegs, arg1: usize) -> Reg;
    fn value_regs_len(&mut self, arg0: ValueRegs) -> usize;
    fn preg_to_reg(&mut self, arg0: PReg) -> Reg;
    fn single_target(&mut self, arg0: &MachLabelSlice) -> Option<MachLabel>;
    fn two_targets(&mut self, arg0: &MachLabelSlice) -> Option<(MachLabel, MachLabel)>;
    fn jump_table_targets(&mut self, arg0: &MachLabelSlice)
        -> Option<(MachLabel, BoxVecMachLabel)>;
    fn jump_table_size(&mut self, arg0: &BoxVecMachLabel) -> u32;
    fn value_list_slice(&mut self, arg0: ValueList) -> ValueSlice;
    fn value_slice_empty(&mut self, arg0: ValueSlice) -> Option<()>;
    fn value_slice_unwrap(&mut self, arg0: ValueSlice) -> Option<(Value, ValueSlice)>;
    fn value_slice_len(&mut self, arg0: ValueSlice) -> usize;
    fn value_slice_get(&mut self, arg0: ValueSlice, arg1: usize) -> Value;
    fn writable_reg_to_reg(&mut self, arg0: WritableReg) -> Reg;
    fn inst_results(&mut self, arg0: Inst) -> ValueSlice;
    fn first_result(&mut self, arg0: Inst) -> Option<Value>;
    fn inst_data(&mut self, arg0: Inst) -> InstructionData;
    fn def_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn i64_from_iconst(&mut self, arg0: Value) -> Option<i64>;
    fn zero_value(&mut self, arg0: Value) -> Option<Value>;
    fn is_sinkable_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn maybe_uextend(&mut self, arg0: Value) -> Option<Value>;
    fn emit(&mut self, arg0: &MInst) -> Unit;
    fn sink_inst(&mut self, arg0: Inst) -> Unit;
    fn emit_u64_le_const(&mut self, arg0: u64) -> VCodeConstant;
    fn emit_u128_le_const(&mut self, arg0: u128) -> VCodeConstant;
    fn const_to_vconst(&mut self, arg0: Constant) -> VCodeConstant;
    fn tls_model(&mut self, arg0: Type) -> TlsModel;
    fn tls_model_is_elf_gd(&mut self) -> Option<Unit>;
    fn tls_model_is_macho(&mut self) -> Option<Unit>;
    fn tls_model_is_coff(&mut self) -> Option<Unit>;
    fn preserve_frame_pointers(&mut self) -> Option<Unit>;
    fn box_external_name(&mut self, arg0: ExternalName) -> BoxExternalName;
    fn func_ref_data(&mut self, arg0: FuncRef) -> (SigRef, ExternalName, RelocDistance);
    fn symbol_value_data(
        &mut self,
        arg0: GlobalValue,
    ) -> Option<(ExternalName, RelocDistance, i64)>;
    fn reloc_distance_near(&mut self, arg0: RelocDistance) -> Option<()>;
    fn vec_mask_from_immediate(&mut self, arg0: Immediate) -> Option<VecMask>;
    fn u128_from_immediate(&mut self, arg0: Immediate) -> Option<u128>;
    fn vconst_from_immediate(&mut self, arg0: Immediate) -> Option<VCodeConstant>;
    fn u128_from_constant(&mut self, arg0: Constant) -> Option<u128>;
    fn u64_from_constant(&mut self, arg0: Constant) -> Option<u64>;
    fn shuffle64_from_imm(&mut self, arg0: Immediate) -> Option<(u8, u8)>;
    fn shuffle32_from_imm(&mut self, arg0: Immediate) -> Option<(u8, u8, u8, u8)>;
    fn shuffle16_from_imm(&mut self, arg0: Immediate) -> Option<(u8, u8, u8, u8, u8, u8, u8, u8)>;
    fn only_writable_reg(&mut self, arg0: WritableValueRegs) -> Option<WritableReg>;
    fn writable_regs_get(&mut self, arg0: WritableValueRegs, arg1: usize) -> WritableReg;
    fn abi_num_args(&mut self, arg0: Sig) -> usize;
    fn abi_get_arg(&mut self, arg0: Sig, arg1: usize) -> ABIArg;
    fn abi_num_rets(&mut self, arg0: Sig) -> usize;
    fn abi_get_ret(&mut self, arg0: Sig, arg1: usize) -> ABIArg;
    fn abi_ret_arg(&mut self, arg0: Sig) -> Option<ABIArg>;
    fn abi_no_ret_arg(&mut self, arg0: Sig) -> Option<()>;
    fn abi_sized_stack_arg_space(&mut self, arg0: Sig) -> i64;
    fn abi_sized_stack_ret_space(&mut self, arg0: Sig) -> i64;
    fn abi_stackslot_addr(&mut self, arg0: WritableReg, arg1: StackSlot, arg2: Offset32) -> MInst;
    fn abi_dynamic_stackslot_addr(&mut self, arg0: WritableReg, arg1: DynamicStackSlot) -> MInst;
    fn abi_arg_only_slot(&mut self, arg0: &ABIArg) -> Option<ABIArgSlot>;
    fn abi_arg_struct_pointer(&mut self, arg0: &ABIArg) -> Option<(ABIArgSlot, i64, u64)>;
    fn abi_arg_implicit_pointer(&mut self, arg0: &ABIArg) -> Option<(ABIArgSlot, i64, Type)>;
    fn real_reg_to_reg(&mut self, arg0: RealReg) -> Reg;
    fn real_reg_to_writable_reg(&mut self, arg0: RealReg) -> WritableReg;
    fn gen_move(&mut self, arg0: Type, arg1: WritableReg, arg2: Reg) -> MInst;
    fn gen_return(&mut self, arg0: ValueSlice) -> Unit;
    fn gen_return_call(
        &mut self,
        arg0: SigRef,
        arg1: ExternalName,
        arg2: RelocDistance,
        arg3: ValueSlice,
    ) -> InstOutput;
    fn gen_return_call_indirect(
        &mut self,
        arg0: SigRef,
        arg1: Value,
        arg2: ValueSlice,
    ) -> InstOutput;
    fn safe_divisor_from_imm64(&mut self, arg0: Type, arg1: Imm64) -> Option<u64>;
    fn operand_size_of_type_32_64(&mut self, arg0: Type) -> OperandSize;
    fn raw_operand_size_of_type(&mut self, arg0: Type) -> OperandSize;
    fn put_in_reg_mem_imm(&mut self, arg0: Value) -> RegMemImm;
    fn put_in_reg_mem(&mut self, arg0: Value) -> RegMem;
    fn synthetic_amode_to_reg_mem(&mut self, arg0: &SyntheticAmode) -> RegMem;
    fn amode_to_synthetic_amode(&mut self, arg0: &Amode) -> SyntheticAmode;
    fn sum_extend_fits_in_32_bits(
        &mut self,
        arg0: Type,
        arg1: Imm64,
        arg2: Offset32,
    ) -> Option<u32>;
    fn amode_offset(&mut self, arg0: &Amode, arg1: i32) -> Amode;
    fn zero_offset(&mut self) -> Offset32;
    fn intcc_to_cc(&mut self, arg0: &IntCC) -> CC;
    fn cc_invert(&mut self, arg0: &CC) -> CC;
    fn cc_nz_or_z(&mut self, arg0: &CC) -> Option<CC>;
    fn encode_fcmp_imm(&mut self, arg0: &FcmpImm) -> u8;
    fn encode_round_imm(&mut self, arg0: &RoundImm) -> u8;
    fn imm8_reg_to_imm8_gpr(&mut self, arg0: &Imm8Reg) -> Imm8Gpr;
    fn gpr_from_imm8_gpr(&mut self, arg0: &Imm8Gpr) -> Option<Gpr>;
    fn imm8_from_imm8_gpr(&mut self, arg0: &Imm8Gpr) -> Option<u8>;
    fn writable_gpr_to_reg(&mut self, arg0: WritableGpr) -> WritableReg;
    fn writable_xmm_to_reg(&mut self, arg0: WritableXmm) -> WritableReg;
    fn writable_reg_to_xmm(&mut self, arg0: WritableReg) -> WritableXmm;
    fn writable_xmm_to_xmm(&mut self, arg0: WritableXmm) -> Xmm;
    fn writable_gpr_to_gpr(&mut self, arg0: WritableGpr) -> Gpr;
    fn gpr_to_reg(&mut self, arg0: Gpr) -> Reg;
    fn gpr_to_gpr_mem(&mut self, arg0: Gpr) -> GprMem;
    fn gpr_to_gpr_mem_imm(&mut self, arg0: Gpr) -> GprMemImm;
    fn xmm_to_reg(&mut self, arg0: Xmm) -> Reg;
    fn xmm_to_xmm_mem_imm(&mut self, arg0: Xmm) -> XmmMemImm;
    fn xmm_mem_to_xmm_mem_imm(&mut self, arg0: &XmmMem) -> XmmMemImm;
    fn xmm_mem_to_xmm_mem_aligned(&mut self, arg0: &XmmMem) -> XmmMemAligned;
    fn xmm_mem_imm_to_xmm_mem_aligned_imm(&mut self, arg0: &XmmMemImm) -> XmmMemAlignedImm;
    fn temp_writable_gpr(&mut self) -> WritableGpr;
    fn temp_writable_xmm(&mut self) -> WritableXmm;
    fn reg_mem_to_xmm_mem(&mut self, arg0: &RegMem) -> XmmMem;
    fn reg_to_reg_mem_imm(&mut self, arg0: Reg) -> RegMemImm;
    fn gpr_mem_imm_new(&mut self, arg0: &RegMemImm) -> GprMemImm;
    fn xmm_mem_imm_new(&mut self, arg0: &RegMemImm) -> XmmMemImm;
    fn xmm_to_xmm_mem(&mut self, arg0: Xmm) -> XmmMem;
    fn xmm_mem_to_reg_mem(&mut self, arg0: &XmmMem) -> RegMem;
    fn gpr_mem_to_reg_mem(&mut self, arg0: &GprMem) -> RegMem;
    fn xmm_new(&mut self, arg0: Reg) -> Xmm;
    fn gpr_new(&mut self, arg0: Reg) -> Gpr;
    fn reg_mem_to_gpr_mem(&mut self, arg0: &RegMem) -> GprMem;
    fn reg_to_gpr_mem(&mut self, arg0: Reg) -> GprMem;
    fn put_in_xmm_mem(&mut self, arg0: Value) -> XmmMem;
    fn put_in_xmm_mem_imm(&mut self, arg0: Value) -> XmmMemImm;
    fn gpr_to_imm8_gpr(&mut self, arg0: Gpr) -> Imm8Gpr;
    fn imm8_to_imm8_gpr(&mut self, arg0: u8) -> Imm8Gpr;
    fn xmi_imm(&mut self, arg0: u32) -> XmmMemImm;
    fn type_register_class(&mut self, arg0: Type) -> Option<RegisterClass>;
    fn use_avx512vl(&mut self) -> bool;
    fn use_avx512dq(&mut self) -> bool;
    fn use_avx512f(&mut self) -> bool;
    fn use_avx512bitalg(&mut self) -> bool;
    fn use_avx512vbmi(&mut self) -> bool;
    fn use_lzcnt(&mut self) -> bool;
    fn use_bmi1(&mut self) -> bool;
    fn use_bmi2(&mut self) -> bool;
    fn use_popcnt(&mut self) -> bool;
    fn use_fma(&mut self) -> bool;
    fn use_ssse3(&mut self) -> bool;
    fn use_sse41(&mut self) -> bool;
    fn use_sse42(&mut self) -> bool;
    fn use_avx(&mut self) -> bool;
    fn use_avx2(&mut self) -> bool;
    fn imm8_from_value(&mut self, arg0: Value) -> Option<Imm8Reg>;
    fn const_to_type_masked_imm8(&mut self, arg0: u64, arg1: Type) -> Imm8Gpr;
    fn shift_mask(&mut self, arg0: Type) -> u8;
    fn shift_amount_masked(&mut self, arg0: Type, arg1: Imm64) -> u8;
    fn simm32_from_value(&mut self, arg0: Value) -> Option<GprMemImm>;
    fn simm32_from_imm64(&mut self, arg0: Imm64) -> Option<GprMemImm>;
    fn sinkable_load(&mut self, arg0: Value) -> Option<SinkableLoad>;
    fn sinkable_load_exact(&mut self, arg0: Value) -> Option<SinkableLoad>;
    fn sink_load(&mut self, arg0: &SinkableLoad) -> SyntheticAmode;
    fn ext_mode(&mut self, arg0: u16, arg1: u16) -> ExtMode;
    fn gen_call(
        &mut self,
        arg0: SigRef,
        arg1: ExternalName,
        arg2: RelocDistance,
        arg3: ValueSlice,
    ) -> InstOutput;
    fn gen_call_indirect(&mut self, arg0: SigRef, arg1: Value, arg2: ValueSlice) -> InstOutput;
    fn nonzero_u64_fits_in_u32(&mut self, arg0: u64) -> Option<u64>;
    fn ty_int_bool_or_ref(&mut self, arg0: Type) -> Option<()>;
    fn atomic_rmw_op_to_mach_atomic_rmw_op(&mut self, arg0: &AtomicRmwOp) -> MachAtomicRmwOp;
    fn shuffle_0_31_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn shuffle_0_15_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn shuffle_16_31_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn perm_from_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn perm_from_mask_with_zeros(
        &mut self,
        arg0: &VecMask,
    ) -> Option<(VCodeConstant, VCodeConstant)>;
    fn const_to_synthetic_amode(&mut self, arg0: VCodeConstant) -> SyntheticAmode;
    fn preg_rbp(&mut self) -> PReg;
    fn preg_rsp(&mut self) -> PReg;
    fn preg_pinned(&mut self) -> PReg;
    fn libcall_1(&mut self, arg0: &LibCall, arg1: Reg) -> Reg;
    fn libcall_2(&mut self, arg0: &LibCall, arg1: Reg, arg2: Reg) -> Reg;
    fn libcall_3(&mut self, arg0: &LibCall, arg1: Reg, arg2: Reg, arg3: Reg) -> Reg;
    fn ishl_i8x16_mask_for_const(&mut self, arg0: u32) -> SyntheticAmode;
    fn ishl_i8x16_mask_table(&mut self) -> SyntheticAmode;
    fn ushr_i8x16_mask_for_const(&mut self, arg0: u32) -> SyntheticAmode;
    fn ushr_i8x16_mask_table(&mut self) -> SyntheticAmode;
    fn vconst_all_ones_or_all_zeros(&mut self, arg0: Constant) -> Option<()>;
    fn insert_i8x16_lane_hole(&mut self, arg0: u8) -> VCodeConstant;
    fn sse_insertps_lane_imm(&mut self, arg0: u8) -> u8;
    fn pblendw_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn palignr_imm_from_immediate(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshuflw_lhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshuflw_rhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufhw_lhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufhw_rhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufd_lhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufd_rhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn shufps_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn shufps_rev_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn unpack_value_array_2(&mut self, arg0: &ValueArray2) -> (Value, Value);
    fn pack_value_array_2(&mut self, arg0: Value, arg1: Value) -> ValueArray2;
    fn unpack_value_array_3(&mut self, arg0: &ValueArray3) -> (Value, Value, Value);
    fn pack_value_array_3(&mut self, arg0: Value, arg1: Value, arg2: Value) -> ValueArray3;
    fn unpack_block_array_2(&mut self, arg0: &BlockArray2) -> (BlockCall, BlockCall);
    fn pack_block_array_2(&mut self, arg0: BlockCall, arg1: BlockCall) -> BlockArray2;
}

pub trait ContextIter {
    type Context;
    type Output;
    fn next(&mut self, ctx: &mut Self::Context) -> Option<Self::Output>;
}

pub struct ContextIterWrapper<Item, I: Iterator<Item = Item>, C: Context> {
    iter: I,
    _ctx: PhantomData<C>,
}
impl<Item, I: Iterator<Item = Item>, C: Context> From<I> for ContextIterWrapper<Item, I, C> {
    fn from(iter: I) -> Self {
        Self {
            iter,
            _ctx: PhantomData,
        }
    }
}
impl<Item, I: Iterator<Item = Item>, C: Context> ContextIter for ContextIterWrapper<Item, I, C> {
    type Context = C;
    type Output = Item;
    fn next(&mut self, _ctx: &mut Self::Context) -> Option<Self::Output> {
        self.iter.next()
    }
}

/// Internal type MultiReg: defined at src/prelude_lower.isle line 21.
#[derive(Clone, Debug)]
pub enum MultiReg {
    Empty,
    One { a: Reg },
    Two { a: Reg, b: Reg },
    Three { a: Reg, b: Reg, c: Reg },
    Four { a: Reg, b: Reg, c: Reg, d: Reg },
}

/// Internal type SideEffectNoResult: defined at src/prelude_lower.isle line 340.
#[derive(Clone, Debug)]
pub enum SideEffectNoResult {
    Inst {
        inst: MInst,
    },
    Inst2 {
        inst1: MInst,
        inst2: MInst,
    },
    Inst3 {
        inst1: MInst,
        inst2: MInst,
        inst3: MInst,
    },
}

/// Internal type ProducesFlags: defined at src/prelude_lower.isle line 382.
#[derive(Clone, Debug)]
pub enum ProducesFlags {
    AlreadyExistingFlags,
    ProducesFlagsSideEffect { inst: MInst },
    ProducesFlagsTwiceSideEffect { inst1: MInst, inst2: MInst },
    ProducesFlagsReturnsReg { inst: MInst, result: Reg },
    ProducesFlagsReturnsResultWithConsumer { inst: MInst, result: Reg },
}

/// Internal type ConsumesAndProducesFlags: defined at src/prelude_lower.isle line 401.
#[derive(Clone, Debug)]
pub enum ConsumesAndProducesFlags {
    SideEffect { inst: MInst },
    ReturnsReg { inst: MInst, result: Reg },
}

/// Internal type ConsumesFlags: defined at src/prelude_lower.isle line 409.
#[derive(Clone, Debug)]
pub enum ConsumesFlags {
    ConsumesFlagsSideEffect {
        inst: MInst,
    },
    ConsumesFlagsSideEffect2 {
        inst1: MInst,
        inst2: MInst,
    },
    ConsumesFlagsReturnsResultWithProducer {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsReturnsReg {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsTwiceReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        result: ValueRegs,
    },
    ConsumesFlagsFourTimesReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        inst3: MInst,
        inst4: MInst,
        result: ValueRegs,
    },
}

/// Internal type MInst: defined at src/isa/x64/inst.isle line 8.
#[derive(Clone)]
pub enum MInst {
    Nop {
        len: u8,
    },
    AluRmiR {
        size: OperandSize,
        op: AluRmiROpcode,
        src1: Gpr,
        src2: GprMemImm,
        dst: WritableGpr,
    },
    AluRM {
        size: OperandSize,
        op: AluRmiROpcode,
        src1_dst: SyntheticAmode,
        src2: Gpr,
    },
    AluRmRVex {
        size: OperandSize,
        op: AluRmROpcode,
        src1: Gpr,
        src2: GprMem,
        dst: WritableGpr,
    },
    AluConstOp {
        op: AluRmiROpcode,
        size: OperandSize,
        dst: WritableGpr,
    },
    UnaryRmR {
        size: OperandSize,
        op: UnaryRmROpcode,
        src: GprMem,
        dst: WritableGpr,
    },
    UnaryRmRVex {
        size: OperandSize,
        op: UnaryRmRVexOpcode,
        src: GprMem,
        dst: WritableGpr,
    },
    UnaryRmRImmVex {
        size: OperandSize,
        op: UnaryRmRImmVexOpcode,
        src: GprMem,
        dst: WritableGpr,
        imm: u8,
    },
    Not {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Neg {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Div {
        size: OperandSize,
        sign: DivSignedness,
        trap: TrapCode,
        divisor: GprMem,
        dividend_lo: Gpr,
        dividend_hi: Gpr,
        dst_quotient: WritableGpr,
        dst_remainder: WritableGpr,
    },
    Div8 {
        sign: DivSignedness,
        trap: TrapCode,
        divisor: GprMem,
        dividend: Gpr,
        dst: WritableGpr,
    },
    MulHi {
        size: OperandSize,
        signed: bool,
        src1: Gpr,
        src2: GprMem,
        dst_lo: WritableGpr,
        dst_hi: WritableGpr,
    },
    UMulLo {
        size: OperandSize,
        src1: Gpr,
        src2: GprMem,
        dst: WritableGpr,
    },
    CheckedSRemSeq {
        size: OperandSize,
        dividend_lo: Gpr,
        dividend_hi: Gpr,
        divisor: Gpr,
        dst_quotient: WritableGpr,
        dst_remainder: WritableGpr,
    },
    CheckedSRemSeq8 {
        dividend: Gpr,
        divisor: Gpr,
        dst: WritableGpr,
    },
    SignExtendData {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Imm {
        dst_size: OperandSize,
        simm64: u64,
        dst: WritableGpr,
    },
    MovRR {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    MovFromPReg {
        src: PReg,
        dst: WritableGpr,
    },
    MovToPReg {
        src: Gpr,
        dst: PReg,
    },
    MovzxRmR {
        ext_mode: ExtMode,
        src: GprMem,
        dst: WritableGpr,
    },
    Mov64MR {
        src: SyntheticAmode,
        dst: WritableGpr,
    },
    LoadEffectiveAddress {
        addr: SyntheticAmode,
        dst: WritableGpr,
        size: OperandSize,
    },
    MovsxRmR {
        ext_mode: ExtMode,
        src: GprMem,
        dst: WritableGpr,
    },
    MovImmM {
        size: OperandSize,
        simm32: i32,
        dst: SyntheticAmode,
    },
    MovRM {
        size: OperandSize,
        src: Gpr,
        dst: SyntheticAmode,
    },
    ShiftR {
        size: OperandSize,
        kind: ShiftKind,
        src: Gpr,
        num_bits: Imm8Gpr,
        dst: WritableGpr,
    },
    XmmRmiReg {
        opcode: SseOpcode,
        src1: Xmm,
        src2: XmmMemAlignedImm,
        dst: WritableXmm,
    },
    CmpRmiR {
        size: OperandSize,
        opcode: CmpOpcode,
        src: GprMemImm,
        dst: Gpr,
    },
    Setcc {
        cc: CC,
        dst: WritableGpr,
    },
    Bswap {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Cmove {
        size: OperandSize,
        cc: CC,
        consequent: GprMem,
        alternative: Gpr,
        dst: WritableGpr,
    },
    XmmCmove {
        ty: Type,
        cc: CC,
        consequent: XmmMemAligned,
        alternative: Xmm,
        dst: WritableXmm,
    },
    Push64 {
        src: GprMemImm,
    },
    Pop64 {
        dst: WritableGpr,
    },
    StackProbeLoop {
        tmp: WritableReg,
        frame_size: u32,
        guard_size: u32,
    },
    XmmRmR {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMemAligned,
        dst: WritableXmm,
    },
    XmmRmRUnaligned {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMem,
        dst: WritableXmm,
    },
    XmmRmRBlend {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMemAligned,
        mask: Xmm,
        dst: WritableXmm,
    },
    XmmRmiRVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: XmmMemImm,
        dst: WritableXmm,
    },
    XmmRmRImmVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: XmmMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmVexPinsr {
        op: AvxOpcode,
        src1: Xmm,
        src2: GprMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmRmRVex3 {
        op: AvxOpcode,
        src1: Xmm,
        src2: Xmm,
        src3: XmmMem,
        dst: WritableXmm,
    },
    XmmRmRBlendVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: XmmMem,
        mask: Xmm,
        dst: WritableXmm,
    },
    XmmUnaryRmRVex {
        op: AvxOpcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmRImmVex {
        op: AvxOpcode,
        src: XmmMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmMovRMVex {
        op: AvxOpcode,
        src: Xmm,
        dst: SyntheticAmode,
    },
    XmmMovRMImmVex {
        op: AvxOpcode,
        src: Xmm,
        dst: SyntheticAmode,
        imm: u8,
    },
    XmmToGprImmVex {
        op: AvxOpcode,
        src: Xmm,
        dst: WritableGpr,
        imm: u8,
    },
    GprToXmmVex {
        op: AvxOpcode,
        src: GprMem,
        dst: WritableXmm,
        src_size: OperandSize,
    },
    XmmToGprVex {
        op: AvxOpcode,
        src: Xmm,
        dst: WritableGpr,
        dst_size: OperandSize,
    },
    XmmRmREvex {
        op: Avx512Opcode,
        src1: Xmm,
        src2: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmRImmEvex {
        op: Avx512Opcode,
        src: XmmMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmRmREvex3 {
        op: Avx512Opcode,
        src1: Xmm,
        src2: Xmm,
        src3: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmR {
        op: SseOpcode,
        src: XmmMemAligned,
        dst: WritableXmm,
    },
    XmmUnaryRmRUnaligned {
        op: SseOpcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmRImm {
        op: SseOpcode,
        src: XmmMemAligned,
        imm: u8,
        dst: WritableXmm,
    },
    XmmUnaryRmREvex {
        op: Avx512Opcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmMovRM {
        op: SseOpcode,
        src: Xmm,
        dst: SyntheticAmode,
    },
    XmmMovRMImm {
        op: SseOpcode,
        src: Xmm,
        dst: SyntheticAmode,
        imm: u8,
    },
    XmmToGpr {
        op: SseOpcode,
        src: Xmm,
        dst: WritableGpr,
        dst_size: OperandSize,
    },
    XmmToGprImm {
        op: SseOpcode,
        src: Xmm,
        dst: WritableGpr,
        imm: u8,
    },
    GprToXmm {
        op: SseOpcode,
        src: GprMem,
        dst: WritableXmm,
        src_size: OperandSize,
    },
    CvtIntToFloat {
        op: SseOpcode,
        src1: Xmm,
        src2: GprMem,
        dst: WritableXmm,
        src2_size: OperandSize,
    },
    CvtIntToFloatVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: GprMem,
        dst: WritableXmm,
        src2_size: OperandSize,
    },
    CvtUint64ToFloatSeq {
        dst_size: OperandSize,
        src: Gpr,
        dst: WritableXmm,
        tmp_gpr1: WritableGpr,
        tmp_gpr2: WritableGpr,
    },
    CvtFloatToSintSeq {
        dst_size: OperandSize,
        src_size: OperandSize,
        is_saturating: bool,
        src: Xmm,
        dst: WritableGpr,
        tmp_gpr: WritableGpr,
        tmp_xmm: WritableXmm,
    },
    CvtFloatToUintSeq {
        dst_size: OperandSize,
        src_size: OperandSize,
        is_saturating: bool,
        src: Xmm,
        dst: WritableGpr,
        tmp_gpr: WritableGpr,
        tmp_xmm: WritableXmm,
        tmp_xmm2: WritableXmm,
    },
    XmmMinMaxSeq {
        size: OperandSize,
        is_min: bool,
        lhs: Xmm,
        rhs: Xmm,
        dst: WritableXmm,
    },
    XmmCmpRmR {
        op: SseOpcode,
        src: XmmMemAligned,
        dst: Xmm,
    },
    XmmRmRImm {
        op: SseOpcode,
        src1: Reg,
        src2: RegMem,
        dst: WritableReg,
        imm: u8,
        size: OperandSize,
    },
    CallKnown {
        dest: ExternalName,
        info: BoxCallInfo,
    },
    CallUnknown {
        dest: RegMem,
        info: BoxCallInfo,
    },
    ReturnCallKnown {
        callee: ExternalName,
        info: BoxReturnCallInfo,
    },
    ReturnCallUnknown {
        callee: RegMem,
        info: BoxReturnCallInfo,
    },
    Args {
        args: VecArgPair,
    },
    Rets {
        rets: VecRetPair,
    },
    Ret {
        stack_bytes_to_pop: u32,
    },
    JmpKnown {
        dst: MachLabel,
    },
    JmpIf {
        cc: CC,
        taken: MachLabel,
    },
    JmpCond {
        cc: CC,
        taken: MachLabel,
        not_taken: MachLabel,
    },
    JmpTableSeq {
        idx: Reg,
        tmp1: WritableReg,
        tmp2: WritableReg,
        default_target: MachLabel,
        targets: BoxVecMachLabel,
    },
    JmpUnknown {
        target: RegMem,
    },
    TrapIf {
        cc: CC,
        trap_code: TrapCode,
    },
    TrapIfAnd {
        cc1: CC,
        cc2: CC,
        trap_code: TrapCode,
    },
    TrapIfOr {
        cc1: CC,
        cc2: CC,
        trap_code: TrapCode,
    },
    Hlt,
    Ud2 {
        trap_code: TrapCode,
    },
    LoadExtName {
        dst: WritableReg,
        name: BoxExternalName,
        offset: i64,
        distance: RelocDistance,
    },
    LockCmpxchg {
        ty: Type,
        replacement: Reg,
        expected: Reg,
        mem: SyntheticAmode,
        dst_old: WritableReg,
    },
    AtomicRmwSeq {
        ty: Type,
        op: MachAtomicRmwOp,
        mem: SyntheticAmode,
        operand: Reg,
        temp: WritableReg,
        dst_old: WritableReg,
    },
    Fence {
        kind: FenceKind,
    },
    VirtualSPOffsetAdj {
        offset: i64,
    },
    XmmUninitializedValue {
        dst: WritableXmm,
    },
    ElfTlsGetAddr {
        symbol: ExternalName,
        dst: WritableGpr,
    },
    MachOTlsGetAddr {
        symbol: ExternalName,
        dst: WritableGpr,
    },
    CoffTlsGetAddr {
        symbol: ExternalName,
        dst: WritableGpr,
        tmp: WritableGpr,
    },
    Unwind {
        inst: UnwindInst,
    },
    DummyUse {
        reg: Reg,
    },
}

/// Internal type DivSignedness: defined at src/isa/x64/inst.isle line 719.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum DivSignedness {
    Signed,
    Unsigned,
}

/// Internal type AluRmROpcode: defined at src/isa/x64/inst.isle line 756.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum AluRmROpcode {
    Andn,
    Sarx,
    Shrx,
    Shlx,
    Bzhi,
}

/// Internal type UnaryRmRVexOpcode: defined at src/isa/x64/inst.isle line 770.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum UnaryRmRVexOpcode {
    Blsi,
    Blsmsk,
    Blsr,
}

/// Internal type UnaryRmRImmVexOpcode: defined at src/isa/x64/inst.isle line 775.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum UnaryRmRImmVexOpcode {
    Rorx,
}

/// Internal type Amode: defined at src/isa/x64/inst.isle line 1021.
#[derive(Clone, Debug)]
pub enum Amode {
    ImmReg {
        simm32: i32,
        base: Reg,
        flags: MemFlags,
    },
    ImmRegRegShift {
        simm32: i32,
        base: Gpr,
        index: Gpr,
        shift: u8,
        flags: MemFlags,
    },
    RipRelative {
        target: MachLabel,
    },
}

/// Internal type AvxOpcode: defined at src/isa/x64/inst.isle line 1207.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum AvxOpcode {
    Vfmadd213ss,
    Vfmadd213sd,
    Vfmadd213ps,
    Vfmadd213pd,
    Vfmadd132ss,
    Vfmadd132sd,
    Vfmadd132ps,
    Vfmadd132pd,
    Vfnmadd213ss,
    Vfnmadd213sd,
    Vfnmadd213ps,
    Vfnmadd213pd,
    Vfnmadd132ss,
    Vfnmadd132sd,
    Vfnmadd132ps,
    Vfnmadd132pd,
    Vcmpps,
    Vcmppd,
    Vpsrlw,
    Vpsrld,
    Vpsrlq,
    Vpaddb,
    Vpaddw,
    Vpaddd,
    Vpaddq,
    Vpaddsb,
    Vpaddsw,
    Vpaddusb,
    Vpaddusw,
    Vpsubb,
    Vpsubw,
    Vpsubd,
    Vpsubq,
    Vpsubsb,
    Vpsubsw,
    Vpsubusb,
    Vpsubusw,
    Vpavgb,
    Vpavgw,
    Vpand,
    Vandps,
    Vandpd,
    Vpor,
    Vorps,
    Vorpd,
    Vpxor,
    Vxorps,
    Vxorpd,
    Vpmullw,
    Vpmulld,
    Vpmulhw,
    Vpmulhd,
    Vpmulhrsw,
    Vpmulhuw,
    Vpmuldq,
    Vpmuludq,
    Vpunpckhwd,
    Vpunpcklwd,
    Vunpcklps,
    Vunpckhps,
    Vandnps,
    Vandnpd,
    Vpandn,
    Vaddps,
    Vaddpd,
    Vsubps,
    Vsubpd,
    Vmulps,
    Vmulpd,
    Vdivps,
    Vdivpd,
    Vpcmpeqb,
    Vpcmpeqw,
    Vpcmpeqd,
    Vpcmpeqq,
    Vpcmpgtb,
    Vpcmpgtw,
    Vpcmpgtd,
    Vpcmpgtq,
    Vminps,
    Vminpd,
    Vmaxps,
    Vmaxpd,
    Vblendvpd,
    Vblendvps,
    Vpblendvb,
    Vmovlhps,
    Vpmaxsb,
    Vpmaxsw,
    Vpmaxsd,
    Vpminsb,
    Vpminsw,
    Vpminsd,
    Vpmaxub,
    Vpmaxuw,
    Vpmaxud,
    Vpminub,
    Vpminuw,
    Vpminud,
    Vpunpcklbw,
    Vpunpckhbw,
    Vpacksswb,
    Vpackssdw,
    Vpackuswb,
    Vpackusdw,
    Vpalignr,
    Vpinsrb,
    Vpinsrw,
    Vpinsrd,
    Vpinsrq,
    Vpmaddwd,
    Vpmaddubsw,
    Vinsertps,
    Vpshufb,
    Vshufps,
    Vpsllw,
    Vpslld,
    Vpsllq,
    Vpsraw,
    Vpsrad,
    Vpmovsxbw,
    Vpmovzxbw,
    Vpmovsxwd,
    Vpmovzxwd,
    Vpmovsxdq,
    Vpmovzxdq,
    Vaddss,
    Vaddsd,
    Vmulss,
    Vmulsd,
    Vsubss,
    Vsubsd,
    Vdivss,
    Vdivsd,
    Vpabsb,
    Vpabsw,
    Vpabsd,
    Vminss,
    Vminsd,
    Vmaxss,
    Vmaxsd,
    Vsqrtps,
    Vsqrtpd,
    Vroundps,
    Vroundpd,
    Vcvtdq2pd,
    Vcvtdq2ps,
    Vcvtpd2ps,
    Vcvtps2pd,
    Vcvttpd2dq,
    Vcvttps2dq,
    Vphaddw,
    Vphaddd,
    Vpunpckhdq,
    Vpunpckldq,
    Vpunpckhqdq,
    Vpunpcklqdq,
    Vpshuflw,
    Vpshufhw,
    Vpshufd,
    Vmovss,
    Vmovsd,
    Vmovups,
    Vmovupd,
    Vmovdqu,
    Vpextrb,
    Vpextrw,
    Vpextrd,
    Vpextrq,
    Vpblendw,
    Vmovddup,
    Vpbroadcastb,
    Vpbroadcastw,
    Vpbroadcastd,
    Vbroadcastss,
    Vmovd,
    Vmovq,
    Vmovmskps,
    Vmovmskpd,
    Vpmovmskb,
    Vcvtsi2ss,
    Vcvtsi2sd,
    Vcvtss2sd,
    Vcvtsd2ss,
    Vsqrtss,
    Vsqrtsd,
    Vroundss,
    Vroundsd,
}

/// Internal type Avx512Opcode: defined at src/isa/x64/inst.isle line 1398.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum Avx512Opcode {
    Vcvtudq2ps,
    Vpabsq,
    Vpermi2b,
    Vpmullq,
    Vpopcntb,
    Vpsraq,
    VpsraqImm,
}

/// Internal type RegisterClass: defined at src/isa/x64/inst.isle line 1674.
#[derive(Clone, Debug)]
pub enum RegisterClass {
    Gpr { single_register: bool },
    Xmm,
}

/// Internal type ExtendKind: defined at src/isa/x64/inst.isle line 2144.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ExtendKind {
    Sign,
    Zero,
}

/// Internal type IcmpCondResult: defined at src/isa/x64/inst.isle line 4644.
#[derive(Clone, Debug)]
pub enum IcmpCondResult {
    Condition { producer: ProducesFlags, cc: CC },
}

/// Internal type FcmpCondResult: defined at src/isa/x64/inst.isle line 4757.
#[derive(Clone, Debug)]
pub enum FcmpCondResult {
    Condition {
        producer: ProducesFlags,
        cc: CC,
    },
    AndCondition {
        producer: ProducesFlags,
        cc1: CC,
        cc2: CC,
    },
    OrCondition {
        producer: ProducesFlags,
        cc1: CC,
        cc2: CC,
    },
}

// Generated as internal constructor for term output_reg.
pub fn constructor_output_reg<C: Context>(ctx: &mut C, arg0: Reg) -> InstOutput {
    let v1 = C::value_reg(ctx, arg0);
    let v2 = C::output(ctx, v1);
    // Rule at src/prelude_lower.isle line 73.
    return v2;
}

// Generated as internal constructor for term output_value.
pub fn constructor_output_value<C: Context>(ctx: &mut C, arg0: Value) -> InstOutput {
    let v1 = C::put_in_regs(ctx, arg0);
    let v2 = C::output(ctx, v1);
    // Rule at src/prelude_lower.isle line 77.
    return v2;
}

// Generated as internal constructor for term temp_reg.
pub fn constructor_temp_reg<C: Context>(ctx: &mut C, arg0: Type) -> Reg {
    let v1 = C::temp_writable_reg(ctx, arg0);
    let v2 = C::writable_reg_to_reg(ctx, v1);
    // Rule at src/prelude_lower.isle line 97.
    return v2;
}

// Generated as internal constructor for term value_regs_range.
pub fn constructor_value_regs_range<C: Context>(ctx: &mut C, arg0: ValueRegs) -> Range {
    let v2 = C::value_regs_len(ctx, arg0);
    let v3 = C::range(ctx, 0x0, v2);
    // Rule at src/prelude_lower.isle line 146.
    return v3;
}

// Generated as internal constructor for term lo_reg.
pub fn constructor_lo_reg<C: Context>(ctx: &mut C, arg0: Value) -> Reg {
    let v1 = C::put_in_regs(ctx, arg0);
    let v3 = C::value_regs_get(ctx, v1, 0x0);
    // Rule at src/prelude_lower.isle line 157.
    return v3;
}

// Generated as internal constructor for term multi_reg_to_pair_and_single.
pub fn constructor_multi_reg_to_pair_and_single<C: Context>(
    ctx: &mut C,
    arg0: &MultiReg,
) -> InstOutput {
    if let &MultiReg::Three {
        a: v1,
        b: v2,
        c: v3,
    } = arg0
    {
        let v4 = C::value_regs(ctx, v1, v2);
        let v5 = C::value_reg(ctx, v3);
        let v6 = C::output_pair(ctx, v4, v5);
        // Rule at src/prelude_lower.isle line 168.
        return v6;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "multi_reg_to_pair_and_single", "src/prelude_lower.isle line 167"
    )
}

// Generated as internal constructor for term multi_reg_to_pair.
pub fn constructor_multi_reg_to_pair<C: Context>(ctx: &mut C, arg0: &MultiReg) -> InstOutput {
    if let &MultiReg::Two { a: v1, b: v2 } = arg0 {
        let v3 = C::value_regs(ctx, v1, v2);
        let v4 = C::output(ctx, v3);
        // Rule at src/prelude_lower.isle line 173.
        return v4;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "multi_reg_to_pair", "src/prelude_lower.isle line 172"
    )
}

// Generated as internal constructor for term multi_reg_to_single.
pub fn constructor_multi_reg_to_single<C: Context>(ctx: &mut C, arg0: &MultiReg) -> InstOutput {
    if let &MultiReg::One { a: v1 } = arg0 {
        let v2 = C::value_reg(ctx, v1);
        let v3 = C::output(ctx, v2);
        // Rule at src/prelude_lower.isle line 178.
        return v3;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "multi_reg_to_single", "src/prelude_lower.isle line 177"
    )
}

// Generated as internal constructor for term emit_side_effect.
pub fn constructor_emit_side_effect<C: Context>(ctx: &mut C, arg0: &SideEffectNoResult) -> Unit {
    match arg0 {
        &SideEffectNoResult::Inst { inst: ref v1 } => {
            let v2 = C::emit(ctx, v1);
            // Rule at src/prelude_lower.isle line 350.
            return v2;
        }
        &SideEffectNoResult::Inst2 {
            inst1: ref v3,
            inst2: ref v4,
        } => {
            let v5 = C::emit(ctx, v3);
            let v6 = C::emit(ctx, v4);
            // Rule at src/prelude_lower.isle line 352.
            return v6;
        }
        &SideEffectNoResult::Inst3 {
            inst1: ref v7,
            inst2: ref v8,
            inst3: ref v9,
        } => {
            let v10 = C::emit(ctx, v7);
            let v11 = C::emit(ctx, v8);
            let v12 = C::emit(ctx, v9);
            // Rule at src/prelude_lower.isle line 355.
            return v12;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "emit_side_effect", "src/prelude_lower.isle line 349"
    )
}

// Generated as internal constructor for term side_effect.
pub fn constructor_side_effect<C: Context>(ctx: &mut C, arg0: &SideEffectNoResult) -> InstOutput {
    let v1 = constructor_emit_side_effect(ctx, arg0);
    let v2 = C::output_none(ctx);
    // Rule at src/prelude_lower.isle line 363.
    return v2;
}

// Generated as internal constructor for term side_effect_concat.
pub fn constructor_side_effect_concat<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
    arg1: &SideEffectNoResult,
) -> SideEffectNoResult {
    match arg0 {
        &SideEffectNoResult::Inst { inst: ref v1 } => {
            match arg1 {
                &SideEffectNoResult::Inst { inst: ref v3 } => {
                    let v4 = SideEffectNoResult::Inst2 {
                        inst1: v1.clone(),
                        inst2: v3.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 368.
                    return v4;
                }
                &SideEffectNoResult::Inst2 {
                    inst1: ref v5,
                    inst2: ref v6,
                } => {
                    let v7 = SideEffectNoResult::Inst3 {
                        inst1: v1.clone(),
                        inst2: v5.clone(),
                        inst3: v6.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 370.
                    return v7;
                }
                _ => {}
            }
        }
        &SideEffectNoResult::Inst2 {
            inst1: ref v8,
            inst2: ref v9,
        } => {
            if let &SideEffectNoResult::Inst { inst: ref v3 } = arg1 {
                let v10 = SideEffectNoResult::Inst3 {
                    inst1: v8.clone(),
                    inst2: v9.clone(),
                    inst3: v3.clone(),
                };
                // Rule at src/prelude_lower.isle line 372.
                return v10;
            }
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "side_effect_concat", "src/prelude_lower.isle line 367"
    )
}

// Generated as internal constructor for term produces_flags_concat.
pub fn constructor_produces_flags_concat<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ProducesFlags,
) -> ProducesFlags {
    if let &ProducesFlags::ProducesFlagsSideEffect { inst: ref v1 } = arg0 {
        if let &ProducesFlags::ProducesFlagsSideEffect { inst: ref v3 } = arg1 {
            let v4 = ProducesFlags::ProducesFlagsTwiceSideEffect {
                inst1: v1.clone(),
                inst2: v3.clone(),
            };
            // Rule at src/prelude_lower.isle line 397.
            return v4;
        }
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "produces_flags_concat", "src/prelude_lower.isle line 396"
    )
}

// Generated as internal constructor for term produces_flags_get_reg.
pub fn constructor_produces_flags_get_reg<C: Context>(ctx: &mut C, arg0: &ProducesFlags) -> Reg {
    match arg0 {
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref v1,
            result: v2,
        } => {
            // Rule at src/prelude_lower.isle line 427.
            return v2;
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v3,
            result: v4,
        } => {
            // Rule at src/prelude_lower.isle line 428.
            return v4;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "produces_flags_get_reg", "src/prelude_lower.isle line 426"
    )
}

// Generated as internal constructor for term produces_flags_ignore.
pub fn constructor_produces_flags_ignore<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> ProducesFlags {
    match arg0 {
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref v1,
            result: v2,
        } => {
            let v3 = ProducesFlags::ProducesFlagsSideEffect { inst: v1.clone() };
            // Rule at src/prelude_lower.isle line 433.
            return v3;
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v4,
            result: v5,
        } => {
            let v6 = ProducesFlags::ProducesFlagsSideEffect { inst: v4.clone() };
            // Rule at src/prelude_lower.isle line 435.
            return v6;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "produces_flags_ignore", "src/prelude_lower.isle line 432"
    )
}

// Generated as internal constructor for term consumes_flags_concat.
pub fn constructor_consumes_flags_concat<C: Context>(
    ctx: &mut C,
    arg0: &ConsumesFlags,
    arg1: &ConsumesFlags,
) -> ConsumesFlags {
    match arg0 {
        &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v8 } => {
            if let &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v9 } = arg1 {
                let v10 = ConsumesFlags::ConsumesFlagsSideEffect2 {
                    inst1: v8.clone(),
                    inst2: v9.clone(),
                };
                // Rule at src/prelude_lower.isle line 448.
                return v10;
            }
        }
        &ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: ref v1,
            result: v2,
        } => {
            if let &ConsumesFlags::ConsumesFlagsReturnsReg {
                inst: ref v4,
                result: v5,
            } = arg1
            {
                let v6 = C::value_regs(ctx, v2, v5);
                let v7 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: v1.clone(),
                    inst2: v4.clone(),
                    result: v6,
                };
                // Rule at src/prelude_lower.isle line 442.
                return v7;
            }
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "consumes_flags_concat", "src/prelude_lower.isle line 441"
    )
}

// Generated as internal constructor for term with_flags.
pub fn constructor_with_flags<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> ValueRegs {
    match arg0 {
        &ProducesFlags::ProducesFlagsSideEffect { inst: ref v12 } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsReturnsReg {
                    inst: ref v13,
                    result: v14,
                } => {
                    let v15 = C::emit(ctx, v12);
                    let v16 = C::emit(ctx, v13);
                    let v17 = C::value_reg(ctx, v14);
                    // Rule at src/prelude_lower.isle line 479.
                    return v17;
                }
                &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: ref v18,
                    inst2: ref v19,
                    result: v20,
                } => {
                    let v15 = C::emit(ctx, v12);
                    let v21 = C::emit(ctx, v18);
                    let v22 = C::emit(ctx, v19);
                    // Rule at src/prelude_lower.isle line 485.
                    return v20;
                }
                &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                    inst1: ref v23,
                    inst2: ref v24,
                    inst3: ref v25,
                    inst4: ref v26,
                    result: v27,
                } => {
                    let v15 = C::emit(ctx, v12);
                    let v28 = C::emit(ctx, v23);
                    let v29 = C::emit(ctx, v24);
                    let v30 = C::emit(ctx, v25);
                    let v31 = C::emit(ctx, v26);
                    // Rule at src/prelude_lower.isle line 497.
                    return v27;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsTwiceSideEffect {
            inst1: ref v32,
            inst2: ref v33,
        } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsReturnsReg {
                    inst: ref v13,
                    result: v14,
                } => {
                    let v34 = C::emit(ctx, v32);
                    let v35 = C::emit(ctx, v33);
                    let v36 = C::emit(ctx, v13);
                    let v37 = C::value_reg(ctx, v14);
                    // Rule at src/prelude_lower.isle line 513.
                    return v37;
                }
                &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: ref v18,
                    inst2: ref v19,
                    result: v20,
                } => {
                    let v34 = C::emit(ctx, v32);
                    let v35 = C::emit(ctx, v33);
                    let v38 = C::emit(ctx, v18);
                    let v39 = C::emit(ctx, v19);
                    // Rule at src/prelude_lower.isle line 520.
                    return v20;
                }
                &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                    inst1: ref v23,
                    inst2: ref v24,
                    inst3: ref v25,
                    inst4: ref v26,
                    result: v27,
                } => {
                    let v34 = C::emit(ctx, v32);
                    let v35 = C::emit(ctx, v33);
                    let v40 = C::emit(ctx, v23);
                    let v41 = C::emit(ctx, v24);
                    let v42 = C::emit(ctx, v25);
                    let v43 = C::emit(ctx, v26);
                    // Rule at src/prelude_lower.isle line 533.
                    return v27;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v1,
            result: v2,
        } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v9 } => {
                    let v6 = C::emit(ctx, v1);
                    let v10 = C::emit(ctx, v9);
                    let v11 = C::value_reg(ctx, v2);
                    // Rule at src/prelude_lower.isle line 473.
                    return v11;
                }
                &ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
                    inst: ref v4,
                    result: v5,
                } => {
                    let v6 = C::emit(ctx, v1);
                    let v7 = C::emit(ctx, v4);
                    let v8 = C::value_regs(ctx, v2, v5);
                    // Rule at src/prelude_lower.isle line 465.
                    return v8;
                }
                _ => {}
            }
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "with_flags", "src/prelude_lower.isle line 463"
    )
}

// Generated as internal constructor for term with_flags_reg.
pub fn constructor_with_flags_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Reg {
    let v2 = constructor_with_flags(ctx, arg0, arg1);
    let v4 = C::value_regs_get(ctx, v2, 0x0);
    // Rule at src/prelude_lower.isle line 551.
    return v4;
}

// Generated as internal constructor for term flags_to_producesflags.
pub fn constructor_flags_to_producesflags<C: Context>(ctx: &mut C, arg0: Value) -> ProducesFlags {
    let v1 = C::mark_value_used(ctx, arg0);
    // Rule at src/prelude_lower.isle line 558.
    return ProducesFlags::AlreadyExistingFlags;
}

// Generated as internal constructor for term with_flags_side_effect.
pub fn constructor_with_flags_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> SideEffectNoResult {
    match arg0 {
        &ProducesFlags::AlreadyExistingFlags => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v2 } => {
                    let v3 = SideEffectNoResult::Inst { inst: v2.clone() };
                    // Rule at src/prelude_lower.isle line 569.
                    return v3;
                }
                &ConsumesFlags::ConsumesFlagsSideEffect2 {
                    inst1: ref v4,
                    inst2: ref v5,
                } => {
                    let v6 = SideEffectNoResult::Inst2 {
                        inst1: v4.clone(),
                        inst2: v5.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 574.
                    return v6;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsSideEffect { inst: ref v7 } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v2 } => {
                    let v8 = SideEffectNoResult::Inst2 {
                        inst1: v7.clone(),
                        inst2: v2.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 579.
                    return v8;
                }
                &ConsumesFlags::ConsumesFlagsSideEffect2 {
                    inst1: ref v4,
                    inst2: ref v5,
                } => {
                    let v9 = SideEffectNoResult::Inst3 {
                        inst1: v7.clone(),
                        inst2: v4.clone(),
                        inst3: v5.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 584.
                    return v9;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsTwiceSideEffect {
            inst1: ref v10,
            inst2: ref v11,
        } => {
            if let &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v2 } = arg1 {
                let v12 = SideEffectNoResult::Inst3 {
                    inst1: v10.clone(),
                    inst2: v11.clone(),
                    inst3: v2.clone(),
                };
                // Rule at src/prelude_lower.isle line 589.
                return v12;
            }
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "with_flags_side_effect", "src/prelude_lower.isle line 567"
    )
}

// Generated as internal constructor for term with_flags_chained.
pub fn constructor_with_flags_chained<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesAndProducesFlags,
    arg2: &ConsumesFlags,
) -> MultiReg {
    match arg0 {
        &ProducesFlags::ProducesFlagsSideEffect { inst: ref v1 } => {
            match arg1 {
                &ConsumesAndProducesFlags::SideEffect { inst: ref v3 } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v5 } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v8 = C::emit(ctx, v5);
                            // Rule at src/prelude_lower.isle line 598.
                            return MultiReg::Empty;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            // Rule at src/prelude_lower.isle line 606.
                            return MultiReg::Empty;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v16 = C::emit(ctx, v14);
                            let v17 = MultiReg::One { a: v15 };
                            // Rule at src/prelude_lower.isle line 615.
                            return v17;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0);
                            let v26 = C::value_regs_get(ctx, v20, 0x1);
                            let v27 = MultiReg::Two { a: v24, b: v26 };
                            // Rule at src/prelude_lower.isle line 623.
                            return v27;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0);
                            let v38 = C::value_regs_get(ctx, v32, 0x1);
                            let v39 = MultiReg::Two { a: v37, b: v38 };
                            // Rule at src/prelude_lower.isle line 632.
                            return v39;
                        }
                        _ => {}
                    }
                }
                &ConsumesAndProducesFlags::ReturnsReg {
                    inst: ref v47,
                    result: v48,
                } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v5 } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v8 = C::emit(ctx, v5);
                            let v50 = MultiReg::One { a: v48 };
                            // Rule at src/prelude_lower.isle line 692.
                            return v50;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            let v50 = MultiReg::One { a: v48 };
                            // Rule at src/prelude_lower.isle line 700.
                            return v50;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v16 = C::emit(ctx, v14);
                            let v51 = MultiReg::Two { a: v48, b: v15 };
                            // Rule at src/prelude_lower.isle line 709.
                            return v51;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0);
                            let v26 = C::value_regs_get(ctx, v20, 0x1);
                            let v52 = MultiReg::Three {
                                a: v48,
                                b: v24,
                                c: v26,
                            };
                            // Rule at src/prelude_lower.isle line 717.
                            return v52;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0);
                            let v38 = C::value_regs_get(ctx, v32, 0x1);
                            let v53 = MultiReg::Three {
                                a: v48,
                                b: v37,
                                c: v38,
                            };
                            // Rule at src/prelude_lower.isle line 726.
                            return v53;
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref v40,
            result: v41,
        } => {
            match arg1 {
                &ConsumesAndProducesFlags::SideEffect { inst: ref v3 } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v5 } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v8 = C::emit(ctx, v5);
                            let v43 = MultiReg::One { a: v41 };
                            // Rule at src/prelude_lower.isle line 645.
                            return v43;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            let v43 = MultiReg::One { a: v41 };
                            // Rule at src/prelude_lower.isle line 653.
                            return v43;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v16 = C::emit(ctx, v14);
                            let v44 = MultiReg::Two { a: v41, b: v15 };
                            // Rule at src/prelude_lower.isle line 662.
                            return v44;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0);
                            let v26 = C::value_regs_get(ctx, v20, 0x1);
                            let v45 = MultiReg::Three {
                                a: v41,
                                b: v24,
                                c: v26,
                            };
                            // Rule at src/prelude_lower.isle line 670.
                            return v45;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0);
                            let v38 = C::value_regs_get(ctx, v32, 0x1);
                            let v46 = MultiReg::Three {
                                a: v41,
                                b: v37,
                                c: v38,
                            };
                            // Rule at src/prelude_lower.isle line 679.
                            return v46;
                        }
                        _ => {}
                    }
                }
                &ConsumesAndProducesFlags::ReturnsReg {
                    inst: ref v47,
                    result: v48,
                } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v5 } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v8 = C::emit(ctx, v5);
                            let v54 = MultiReg::Two { a: v41, b: v48 };
                            // Rule at src/prelude_lower.isle line 739.
                            return v54;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            let v54 = MultiReg::Two { a: v41, b: v48 };
                            // Rule at src/prelude_lower.isle line 747.
                            return v54;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v16 = C::emit(ctx, v14);
                            let v55 = MultiReg::Three {
                                a: v41,
                                b: v48,
                                c: v15,
                            };
                            // Rule at src/prelude_lower.isle line 756.
                            return v55;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0);
                            let v26 = C::value_regs_get(ctx, v20, 0x1);
                            let v56 = MultiReg::Four {
                                a: v41,
                                b: v48,
                                c: v24,
                                d: v26,
                            };
                            // Rule at src/prelude_lower.isle line 764.
                            return v56;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0);
                            let v38 = C::value_regs_get(ctx, v32, 0x1);
                            let v57 = MultiReg::Four {
                                a: v41,
                                b: v48,
                                c: v37,
                                d: v38,
                            };
                            // Rule at src/prelude_lower.isle line 773.
                            return v57;
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v58,
            result: v59,
        } => {
            if let &ConsumesAndProducesFlags::ReturnsReg {
                inst: ref v47,
                result: v48,
            } = arg1
            {
                match arg2 {
                    &ConsumesFlags::ConsumesFlagsSideEffect { inst: ref v5 } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v8 = C::emit(ctx, v5);
                        let v61 = MultiReg::Two { a: v59, b: v48 };
                        // Rule at src/prelude_lower.isle line 785.
                        return v61;
                    }
                    &ConsumesFlags::ConsumesFlagsSideEffect2 {
                        inst1: ref v10,
                        inst2: ref v11,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v12 = C::emit(ctx, v10);
                        let v13 = C::emit(ctx, v11);
                        let v61 = MultiReg::Two { a: v59, b: v48 };
                        // Rule at src/prelude_lower.isle line 793.
                        return v61;
                    }
                    &ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
                        inst: ref v63,
                        result: v64,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v65 = C::emit(ctx, v63);
                        let v66 = MultiReg::Three {
                            a: v59,
                            b: v48,
                            c: v64,
                        };
                        // Rule at src/prelude_lower.isle line 810.
                        return v66;
                    }
                    &ConsumesFlags::ConsumesFlagsReturnsReg {
                        inst: ref v14,
                        result: v15,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v16 = C::emit(ctx, v14);
                        let v62 = MultiReg::Three {
                            a: v59,
                            b: v48,
                            c: v15,
                        };
                        // Rule at src/prelude_lower.isle line 802.
                        return v62;
                    }
                    &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                        inst1: ref v18,
                        inst2: ref v19,
                        result: v20,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v21 = C::emit(ctx, v18);
                        let v22 = C::emit(ctx, v19);
                        let v24 = C::value_regs_get(ctx, v20, 0x0);
                        let v26 = C::value_regs_get(ctx, v20, 0x1);
                        let v67 = MultiReg::Four {
                            a: v59,
                            b: v48,
                            c: v24,
                            d: v26,
                        };
                        // Rule at src/prelude_lower.isle line 818.
                        return v67;
                    }
                    &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                        inst1: ref v28,
                        inst2: ref v29,
                        inst3: ref v30,
                        inst4: ref v31,
                        result: v32,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v33 = C::emit(ctx, v28);
                        let v34 = C::emit(ctx, v29);
                        let v35 = C::emit(ctx, v30);
                        let v36 = C::emit(ctx, v31);
                        let v37 = C::value_regs_get(ctx, v32, 0x0);
                        let v38 = C::value_regs_get(ctx, v32, 0x1);
                        let v68 = MultiReg::Four {
                            a: v59,
                            b: v48,
                            c: v37,
                            d: v38,
                        };
                        // Rule at src/prelude_lower.isle line 827.
                        return v68;
                    }
                    _ => {}
                }
            }
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "with_flags_chained", "src/prelude_lower.isle line 595"
    )
}

// Generated as internal constructor for term lower_return.
pub fn constructor_lower_return<C: Context>(ctx: &mut C, arg0: ValueSlice) -> InstOutput {
    let v1 = C::gen_return(ctx, arg0);
    let v2 = C::output_none(ctx);
    // Rule at src/prelude_lower.isle line 1027.
    return v2;
}

// Generated as internal constructor for term operand_size_bits.
pub fn constructor_operand_size_bits<C: Context>(ctx: &mut C, arg0: &OperandSize) -> u16 {
    match arg0 {
        &OperandSize::Size8 => {
            // Rule at src/isa/x64/inst.isle line 741.
            return 0x8;
        }
        &OperandSize::Size16 => {
            // Rule at src/isa/x64/inst.isle line 742.
            return 0x10;
        }
        &OperandSize::Size32 => {
            // Rule at src/isa/x64/inst.isle line 743.
            return 0x20;
        }
        &OperandSize::Size64 => {
            // Rule at src/isa/x64/inst.isle line 744.
            return 0x40;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "operand_size_bits", "src/isa/x64/inst.isle line 740"
    )
}

// Generated as internal constructor for term reg_mem_to_reg_mem_imm.
pub fn constructor_reg_mem_to_reg_mem_imm<C: Context>(ctx: &mut C, arg0: &RegMem) -> RegMemImm {
    match arg0 {
        &RegMem::Reg { reg: v1 } => {
            let v2 = RegMemImm::Reg { reg: v1 };
            // Rule at src/isa/x64/inst.isle line 995.
            return v2;
        }
        &RegMem::Mem { addr: ref v3 } => {
            let v4 = RegMemImm::Mem { addr: v3.clone() };
            // Rule at src/isa/x64/inst.isle line 997.
            return v4;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "reg_mem_to_reg_mem_imm", "src/isa/x64/inst.isle line 994"
    )
}

// Generated as internal constructor for term to_amode.
pub fn constructor_to_amode<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Offset32,
) -> Amode {
    let v4 = C::def_inst(ctx, arg1);
    if let Some(v5) = v4 {
        let v6 = &C::inst_data(ctx, v5);
        if let &InstructionData::Binary {
            opcode: ref v7,
            args: ref v8,
        } = v6
        {
            if let &Opcode::Iadd = v7 {
                let v9 = C::unpack_value_array_2(ctx, v8);
                let v12 = &constructor_to_amode_add(ctx, arg0, v9.0, v9.1, arg2);
                // Rule at src/isa/x64/inst.isle line 1083.
                return v12.clone();
            }
        }
    }
    let v3 = &constructor_amode_imm_reg(ctx, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 1081.
    return v3.clone();
}

// Generated as internal constructor for term to_amode_add.
pub fn constructor_to_amode_add<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Amode {
    let v5 = C::def_inst(ctx, arg2);
    if let Some(v6) = v5 {
        let v7 = &C::inst_data(ctx, v6);
        if let &InstructionData::Binary {
            opcode: ref v55,
            args: ref v56,
        } = v7
        {
            if let &Opcode::Iadd = v55 {
                let v57 = C::unpack_value_array_2(ctx, v56);
                let v71 = C::def_inst(ctx, v57.0);
                if let Some(v72) = v71 {
                    let v73 = &C::inst_data(ctx, v72);
                    if let &InstructionData::UnaryImm {
                        opcode: ref v74,
                        imm: v75,
                    } = v73
                    {
                        if let &Opcode::Iconst = v74 {
                            let v76 = C::simm32(ctx, v75);
                            if let Some(v77) = v76 {
                                let v12 = C::offset32_to_i32(ctx, arg3);
                                let v78 = C::s32_add_fallible(ctx, v12, v77);
                                if let Some(v79) = v78 {
                                    let v80 = C::i32_to_offset32(ctx, v79);
                                    let v81 = &constructor_amode_imm_reg_reg_shift(
                                        ctx, arg0, arg1, v57.1, v80,
                                    );
                                    // Rule at src/isa/x64/inst.isle line 1116.
                                    return v81.clone();
                                }
                            }
                        }
                    }
                }
                let v60 = C::def_inst(ctx, v57.1);
                if let Some(v61) = v60 {
                    let v62 = &C::inst_data(ctx, v61);
                    if let &InstructionData::UnaryImm {
                        opcode: ref v63,
                        imm: v64,
                    } = v62
                    {
                        if let &Opcode::Iconst = v63 {
                            let v65 = C::simm32(ctx, v64);
                            if let Some(v66) = v65 {
                                let v12 = C::offset32_to_i32(ctx, arg3);
                                let v67 = C::s32_add_fallible(ctx, v12, v66);
                                if let Some(v68) = v67 {
                                    let v69 = C::i32_to_offset32(ctx, v68);
                                    let v70 = &constructor_amode_imm_reg_reg_shift(
                                        ctx, arg0, arg1, v57.0, v69,
                                    );
                                    // Rule at src/isa/x64/inst.isle line 1113.
                                    return v70.clone();
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    let v17 = C::def_inst(ctx, arg1);
    if let Some(v18) = v17 {
        let v19 = &C::inst_data(ctx, v18);
        match v19 {
            &InstructionData::Binary {
                opcode: ref v28,
                args: ref v29,
            } => {
                if let &Opcode::Iadd = v28 {
                    let v30 = C::unpack_value_array_2(ctx, v29);
                    let v44 = C::def_inst(ctx, v30.0);
                    if let Some(v45) = v44 {
                        let v46 = &C::inst_data(ctx, v45);
                        if let &InstructionData::UnaryImm {
                            opcode: ref v47,
                            imm: v48,
                        } = v46
                        {
                            if let &Opcode::Iconst = v47 {
                                let v49 = C::simm32(ctx, v48);
                                if let Some(v50) = v49 {
                                    let v12 = C::offset32_to_i32(ctx, arg3);
                                    let v51 = C::s32_add_fallible(ctx, v12, v50);
                                    if let Some(v52) = v51 {
                                        let v53 = C::i32_to_offset32(ctx, v52);
                                        let v54 = &constructor_amode_imm_reg_reg_shift(
                                            ctx, arg0, v30.1, arg2, v53,
                                        );
                                        // Rule at src/isa/x64/inst.isle line 1110.
                                        return v54.clone();
                                    }
                                }
                            }
                        }
                    }
                    let v33 = C::def_inst(ctx, v30.1);
                    if let Some(v34) = v33 {
                        let v35 = &C::inst_data(ctx, v34);
                        if let &InstructionData::UnaryImm {
                            opcode: ref v36,
                            imm: v37,
                        } = v35
                        {
                            if let &Opcode::Iconst = v36 {
                                let v38 = C::simm32(ctx, v37);
                                if let Some(v39) = v38 {
                                    let v12 = C::offset32_to_i32(ctx, arg3);
                                    let v40 = C::s32_add_fallible(ctx, v12, v39);
                                    if let Some(v41) = v40 {
                                        let v42 = C::i32_to_offset32(ctx, v41);
                                        let v43 = &constructor_amode_imm_reg_reg_shift(
                                            ctx, arg0, v30.0, arg2, v42,
                                        );
                                        // Rule at src/isa/x64/inst.isle line 1107.
                                        return v43.clone();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            &InstructionData::UnaryImm {
                opcode: ref v20,
                imm: v21,
            } => {
                if let &Opcode::Iconst = v20 {
                    let v22 = C::simm32(ctx, v21);
                    if let Some(v23) = v22 {
                        let v12 = C::offset32_to_i32(ctx, arg3);
                        let v24 = C::s32_add_fallible(ctx, v12, v23);
                        if let Some(v25) = v24 {
                            let v26 = C::i32_to_offset32(ctx, v25);
                            let v27 = &constructor_amode_imm_reg(ctx, arg0, arg2, v26);
                            // Rule at src/isa/x64/inst.isle line 1104.
                            return v27.clone();
                        }
                    }
                }
            }
            _ => {}
        }
    }
    if let Some(v6) = v5 {
        let v7 = &C::inst_data(ctx, v6);
        if let &InstructionData::UnaryImm {
            opcode: ref v8,
            imm: v9,
        } = v7
        {
            if let &Opcode::Iconst = v8 {
                let v10 = C::simm32(ctx, v9);
                if let Some(v11) = v10 {
                    let v12 = C::offset32_to_i32(ctx, arg3);
                    let v13 = C::s32_add_fallible(ctx, v12, v11);
                    if let Some(v14) = v13 {
                        let v15 = C::i32_to_offset32(ctx, v14);
                        let v16 = &constructor_amode_imm_reg(ctx, arg0, arg1, v15);
                        // Rule at src/isa/x64/inst.isle line 1101.
                        return v16.clone();
                    }
                }
            }
        }
    }
    let v4 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, arg1, arg2, arg3);
    // Rule at src/isa/x64/inst.isle line 1099.
    return v4.clone();
}

// Generated as internal constructor for term amode_imm_reg.
pub fn constructor_amode_imm_reg<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Offset32,
) -> Amode {
    let v6 = C::def_inst(ctx, arg1);
    if let Some(v7) = v6 {
        let v8 = &C::inst_data(ctx, v7);
        if let &InstructionData::Binary {
            opcode: ref v9,
            args: ref v10,
        } = v8
        {
            if let &Opcode::Iadd = v9 {
                let v11 = C::unpack_value_array_2(ctx, v10);
                let v14 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, v11.0, v11.1, arg2);
                // Rule at src/isa/x64/inst.isle line 1126.
                return v14.clone();
            }
        }
    }
    let v4 = C::put_in_reg(ctx, arg1);
    let v3 = C::offset32_to_i32(ctx, arg2);
    let v5 = Amode::ImmReg {
        simm32: v3,
        base: v4,
        flags: arg0,
    };
    // Rule at src/isa/x64/inst.isle line 1124.
    return v5;
}

// Generated as internal constructor for term amode_imm_reg_reg_shift.
pub fn constructor_amode_imm_reg_reg_shift<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Amode {
    let v30 = C::def_inst(ctx, arg1);
    if let Some(v31) = v30 {
        let v32 = &C::inst_data(ctx, v31);
        if let &InstructionData::Binary {
            opcode: ref v33,
            args: ref v34,
        } = v32
        {
            if let &Opcode::Ishl = v33 {
                let v35 = C::unpack_value_array_2(ctx, v34);
                let v38 = C::def_inst(ctx, v35.1);
                if let Some(v39) = v38 {
                    let v40 = &C::inst_data(ctx, v39);
                    if let &InstructionData::UnaryImm {
                        opcode: ref v41,
                        imm: v42,
                    } = v40
                    {
                        if let &Opcode::Iconst = v41 {
                            let v43 = C::uimm8(ctx, v42);
                            if let Some(v44) = v43 {
                                let v45 = C::u8_as_u32(ctx, v44);
                                let v46 = C::u32_lteq(ctx, v45, 0x3);
                                if let Some(v47) = v46 {
                                    let v48 = constructor_put_in_gpr(ctx, arg2);
                                    let v49 = constructor_put_in_gpr(ctx, v35.0);
                                    let v4 = C::offset32_to_i32(ctx, arg3);
                                    let v50 = Amode::ImmRegRegShift {
                                        simm32: v4,
                                        base: v48,
                                        index: v49,
                                        shift: v44,
                                        flags: arg0,
                                    };
                                    // Rule at src/isa/x64/inst.isle line 1135.
                                    return v50;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    let v9 = C::def_inst(ctx, arg2);
    if let Some(v10) = v9 {
        let v11 = &C::inst_data(ctx, v10);
        if let &InstructionData::Binary {
            opcode: ref v12,
            args: ref v13,
        } = v11
        {
            if let &Opcode::Ishl = v12 {
                let v14 = C::unpack_value_array_2(ctx, v13);
                let v17 = C::def_inst(ctx, v14.1);
                if let Some(v18) = v17 {
                    let v19 = &C::inst_data(ctx, v18);
                    if let &InstructionData::UnaryImm {
                        opcode: ref v20,
                        imm: v21,
                    } = v19
                    {
                        if let &Opcode::Iconst = v20 {
                            let v22 = C::uimm8(ctx, v21);
                            if let Some(v23) = v22 {
                                let v24 = C::u8_as_u32(ctx, v23);
                                let v26 = C::u32_lteq(ctx, v24, 0x3);
                                if let Some(v27) = v26 {
                                    let v5 = constructor_put_in_gpr(ctx, arg1);
                                    let v28 = constructor_put_in_gpr(ctx, v14.0);
                                    let v4 = C::offset32_to_i32(ctx, arg3);
                                    let v29 = Amode::ImmRegRegShift {
                                        simm32: v4,
                                        base: v5,
                                        index: v28,
                                        shift: v23,
                                        flags: arg0,
                                    };
                                    // Rule at src/isa/x64/inst.isle line 1132.
                                    return v29;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    let v5 = constructor_put_in_gpr(ctx, arg1);
    let v6 = constructor_put_in_gpr(ctx, arg2);
    let v4 = C::offset32_to_i32(ctx, arg3);
    let v8 = Amode::ImmRegRegShift {
        simm32: v4,
        base: v5,
        index: v6,
        shift: 0x0,
        flags: arg0,
    };
    // Rule at src/isa/x64/inst.isle line 1130.
    return v8;
}

// Generated as internal constructor for term put_masked_in_imm8_gpr.
pub fn constructor_put_masked_in_imm8_gpr<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Type,
) -> Imm8Gpr {
    let v1 = C::def_inst(ctx, arg0);
    if let Some(v2) = v1 {
        let v3 = &C::inst_data(ctx, v2);
        if let &InstructionData::UnaryImm {
            opcode: ref v4,
            imm: v5,
        } = v3
        {
            if let &Opcode::Iconst = v4 {
                let v6 = C::u64_from_imm64(ctx, v5);
                let v8 = &C::const_to_type_masked_imm8(ctx, v6, arg1);
                // Rule at src/isa/x64/inst.isle line 1171.
                return v8.clone();
            }
        }
    }
    let v9 = C::fits_in_16(ctx, arg1);
    if let Some(v10) = v9 {
        let v12 = C::put_in_regs(ctx, arg0);
        let v14 = constructor_value_regs_get_gpr(ctx, v12, 0x0);
        let v15 = C::shift_mask(ctx, v10);
        let v16 = C::u8_as_u32(ctx, v15);
        let v17 = RegMemImm::Imm { simm32: v16 };
        let v18 = &C::gpr_mem_imm_new(ctx, &v17);
        let v19 = constructor_x64_and(ctx, I64, v14, v18);
        let v20 = &C::gpr_to_imm8_gpr(ctx, v19);
        // Rule at src/isa/x64/inst.isle line 1173.
        return v20.clone();
    }
    let v12 = C::put_in_regs(ctx, arg0);
    let v14 = constructor_value_regs_get_gpr(ctx, v12, 0x0);
    let v21 = &C::gpr_to_imm8_gpr(ctx, v14);
    // Rule at src/isa/x64/inst.isle line 1175.
    return v21.clone();
}

// Generated as internal constructor for term reg_to_gpr_mem_imm.
pub fn constructor_reg_to_gpr_mem_imm<C: Context>(ctx: &mut C, arg0: Reg) -> GprMemImm {
    let v1 = C::gpr_new(ctx, arg0);
    let v2 = &C::gpr_to_gpr_mem_imm(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1591.
    return v2.clone();
}

// Generated as internal constructor for term put_in_gpr.
pub fn constructor_put_in_gpr<C: Context>(ctx: &mut C, arg0: Value) -> Gpr {
    let v1 = C::put_in_reg(ctx, arg0);
    let v2 = C::gpr_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1598.
    return v2;
}

// Generated as internal constructor for term put_in_gpr_mem.
pub fn constructor_put_in_gpr_mem<C: Context>(ctx: &mut C, arg0: Value) -> GprMem {
    let v1 = &C::put_in_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1605.
    return v2.clone();
}

// Generated as internal constructor for term put_in_gpr_mem_imm.
pub fn constructor_put_in_gpr_mem_imm<C: Context>(ctx: &mut C, arg0: Value) -> GprMemImm {
    let v1 = &C::put_in_reg_mem_imm(ctx, arg0);
    let v2 = &C::gpr_mem_imm_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1612.
    return v2.clone();
}

// Generated as internal constructor for term put_in_xmm.
pub fn constructor_put_in_xmm<C: Context>(ctx: &mut C, arg0: Value) -> Xmm {
    let v1 = C::put_in_reg(ctx, arg0);
    let v2 = C::xmm_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1619.
    return v2;
}

// Generated as internal constructor for term output_gpr.
pub fn constructor_output_gpr<C: Context>(ctx: &mut C, arg0: Gpr) -> InstOutput {
    let v1 = C::gpr_to_reg(ctx, arg0);
    let v2 = constructor_output_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1636.
    return v2;
}

// Generated as internal constructor for term value_gprs.
pub fn constructor_value_gprs<C: Context>(ctx: &mut C, arg0: Gpr, arg1: Gpr) -> ValueRegs {
    let v2 = C::gpr_to_reg(ctx, arg0);
    let v3 = C::gpr_to_reg(ctx, arg1);
    let v4 = C::value_regs(ctx, v2, v3);
    // Rule at src/isa/x64/inst.isle line 1641.
    return v4;
}

// Generated as internal constructor for term output_xmm.
pub fn constructor_output_xmm<C: Context>(ctx: &mut C, arg0: Xmm) -> InstOutput {
    let v1 = C::xmm_to_reg(ctx, arg0);
    let v2 = constructor_output_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1646.
    return v2;
}

// Generated as internal constructor for term value_regs_get_gpr.
pub fn constructor_value_regs_get_gpr<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: usize,
) -> Gpr {
    let v2 = C::value_regs_get(ctx, arg0, arg1);
    let v3 = C::gpr_new(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 1653.
    return v3;
}

// Generated as internal constructor for term lo_gpr.
pub fn constructor_lo_gpr<C: Context>(ctx: &mut C, arg0: Value) -> Gpr {
    let v1 = constructor_lo_reg(ctx, arg0);
    let v2 = C::gpr_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1666.
    return v2;
}

// Generated as internal constructor for term sink_load_to_gpr_mem_imm.
pub fn constructor_sink_load_to_gpr_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> GprMemImm {
    let v1 = &constructor_sink_load_to_reg_mem_imm(ctx, arg0);
    let v2 = &C::gpr_mem_imm_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1801.
    return v2.clone();
}

// Generated as internal constructor for term sink_load_to_xmm_mem.
pub fn constructor_sink_load_to_xmm_mem<C: Context>(ctx: &mut C, arg0: &SinkableLoad) -> XmmMem {
    let v1 = &constructor_sink_load_to_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1805.
    return v2.clone();
}

// Generated as internal constructor for term sink_load_to_reg_mem.
pub fn constructor_sink_load_to_reg_mem<C: Context>(ctx: &mut C, arg0: &SinkableLoad) -> RegMem {
    let v1 = &C::sink_load(ctx, arg0);
    let v2 = RegMem::Mem { addr: v1.clone() };
    // Rule at src/isa/x64/inst.isle line 1809.
    return v2;
}

// Generated as internal constructor for term sink_load_to_gpr_mem.
pub fn constructor_sink_load_to_gpr_mem<C: Context>(ctx: &mut C, arg0: &SinkableLoad) -> GprMem {
    let v1 = &C::sink_load(ctx, arg0);
    let v2 = RegMem::Mem { addr: v1.clone() };
    let v3 = &C::reg_mem_to_gpr_mem(ctx, &v2);
    // Rule at src/isa/x64/inst.isle line 1812.
    return v3.clone();
}

// Generated as internal constructor for term sink_load_to_reg_mem_imm.
pub fn constructor_sink_load_to_reg_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> RegMemImm {
    let v1 = &C::sink_load(ctx, arg0);
    let v2 = RegMemImm::Mem { addr: v1.clone() };
    // Rule at src/isa/x64/inst.isle line 1815.
    return v2;
}

// Generated as internal constructor for term xmm_uninit_value.
pub fn constructor_xmm_uninit_value<C: Context>(ctx: &mut C) -> Xmm {
    let v0 = C::temp_writable_xmm(ctx);
    let v1 = MInst::XmmUninitializedValue { dst: v0 };
    let v2 = C::emit(ctx, &v1);
    let v3 = C::writable_xmm_to_xmm(ctx, v0);
    // Rule at src/isa/x64/inst.isle line 1827.
    return v3;
}

// Generated as internal constructor for term load_ext_name.
pub fn constructor_load_ext_name<C: Context>(
    ctx: &mut C,
    arg0: ExternalName,
    arg1: i64,
    arg2: RelocDistance,
) -> Reg {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = C::writable_gpr_to_reg(ctx, v3);
    let v5 = C::box_external_name(ctx, arg0);
    let v6 = MInst::LoadExtName {
        dst: v4,
        name: v5,
        offset: arg1,
        distance: arg2,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = constructor_writable_gpr_to_r_reg(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1834.
    return v8;
}

// Generated as internal constructor for term mov64_mr.
pub fn constructor_mov64_mr<C: Context>(ctx: &mut C, arg0: &SyntheticAmode) -> Reg {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::Mov64MR {
        src: arg0.clone(),
        dst: v1,
    };
    let v3 = C::emit(ctx, &v2);
    let v4 = constructor_writable_gpr_to_r_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1841.
    return v4;
}

// Generated as internal constructor for term alu_rmi_r.
pub fn constructor_alu_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmiROpcode,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::AluRmiR {
        size: v5.clone(),
        op: arg1.clone(),
        src1: arg2,
        src2: arg3.clone(),
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 1848.
    return v8;
}

// Generated as internal constructor for term alu_rm_r_vex.
pub fn constructor_alu_rm_r_vex<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmROpcode,
    arg2: Gpr,
    arg3: &GprMem,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::AluRmRVex {
        size: v5.clone(),
        op: arg1.clone(),
        src1: arg2,
        src2: arg3.clone(),
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 1856.
    return v8;
}

// Generated as internal constructor for term xmm_rm_r.
pub fn constructor_xmm_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMemAligned,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmR {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1864.
    return v6;
}

// Generated as internal constructor for term xmm_rm_r_unaligned.
pub fn constructor_xmm_rm_r_unaligned<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmRUnaligned {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1871.
    return v6;
}

// Generated as internal constructor for term xmm_rm_r_blend.
pub fn constructor_xmm_rm_r_blend<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMemAligned,
    arg3: Xmm,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRBlend {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        mask: arg3,
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 1878.
    return v7;
}

// Generated as internal constructor for term xmm_rmr_blend_vex.
pub fn constructor_xmm_rmr_blend_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
    arg3: Xmm,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRBlendVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        mask: arg3,
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 1885.
    return v7;
}

// Generated as internal constructor for term xmm_unary_rm_r_vex.
pub fn constructor_xmm_unary_rm_r_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &XmmMem,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmRVex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 1892.
    return v5;
}

// Generated as internal constructor for term xmm_unary_rm_r_imm_vex.
pub fn constructor_xmm_unary_rm_r_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmUnaryRmRImmVex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1899.
    return v6;
}

// Generated as internal constructor for term xmm_rm_r_imm.
pub fn constructor_xmm_rm_r_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Reg,
    arg2: &RegMem,
    arg3: u8,
    arg4: &OperandSize,
) -> Xmm {
    let v5 = C::temp_writable_xmm(ctx);
    let v6 = C::writable_xmm_to_reg(ctx, v5);
    let v7 = MInst::XmmRmRImm {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v6,
        imm: arg3,
        size: arg4.clone(),
    };
    let v8 = C::emit(ctx, &v7);
    let v9 = C::writable_xmm_to_xmm(ctx, v5);
    // Rule at src/isa/x64/inst.isle line 1906.
    return v9;
}

// Generated as internal constructor for term xmm_vex_pinsr.
pub fn constructor_xmm_vex_pinsr<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &GprMem,
    arg3: u8,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmVexPinsr {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        imm: arg3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 1918.
    return v7;
}

// Generated as internal constructor for term xmm_unary_rm_r_imm.
pub fn constructor_xmm_unary_rm_r_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMemAligned,
    arg2: u8,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmUnaryRmRImm {
        op: arg0.clone(),
        src: arg1.clone(),
        imm: arg2,
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1925.
    return v6;
}

// Generated as internal constructor for term xmm_unary_rm_r.
pub fn constructor_xmm_unary_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMemAligned,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmR {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 1932.
    return v5;
}

// Generated as internal constructor for term xmm_unary_rm_r_unaligned.
pub fn constructor_xmm_unary_rm_r_unaligned<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMem,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmRUnaligned {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 1939.
    return v5;
}

// Generated as internal constructor for term xmm_unary_rm_r_evex.
pub fn constructor_xmm_unary_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &XmmMem,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmREvex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 1946.
    return v5;
}

// Generated as internal constructor for term xmm_rm_r_evex.
pub fn constructor_xmm_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmREvex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1953.
    return v6;
}

// Generated as internal constructor for term xmm_unary_rm_r_imm_evex.
pub fn constructor_xmm_unary_rm_r_imm_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmUnaryRmRImmEvex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1963.
    return v6;
}

// Generated as internal constructor for term xmm_rmi_xmm.
pub fn constructor_xmm_rmi_xmm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMemAlignedImm,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmiReg {
        opcode: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1970.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr_imm.
pub fn constructor_xmm_to_gpr_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: u8,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGprImm {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1980.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr_imm_vex.
pub fn constructor_xmm_to_gpr_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: u8,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGprImmVex {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1987.
    return v6;
}

// Generated as internal constructor for term gpr_to_xmm.
pub fn constructor_gpr_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::GprToXmm {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        src_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 1994.
    return v6;
}

// Generated as internal constructor for term gpr_to_xmm_vex.
pub fn constructor_gpr_to_xmm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::GprToXmmVex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        src_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2001.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr.
pub fn constructor_xmm_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGpr {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        dst_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2008.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr_vex.
pub fn constructor_xmm_to_gpr_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGprVex {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        dst_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2015.
    return v6;
}

// Generated as internal constructor for term xmm_min_max_seq.
pub fn constructor_xmm_min_max_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Xmm,
    arg3: Xmm,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::XmmMinMaxSeq {
        size: v5.clone(),
        is_min: arg1,
        lhs: arg2,
        rhs: arg3,
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2022.
    return v8;
}

// Generated as internal constructor for term xmm_rmir_vex.
pub fn constructor_xmm_rmir_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &XmmMemImm,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmiRVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2030.
    return v6;
}

// Generated as internal constructor for term xmm_rmr_imm_vex.
pub fn constructor_xmm_rmr_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
    arg3: u8,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRImmVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        imm: arg3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2037.
    return v7;
}

// Generated as internal constructor for term xmm_rmr_vex3.
pub fn constructor_xmm_rmr_vex3<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRVex3 {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2,
        src3: arg3.clone(),
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2044.
    return v7;
}

// Generated as internal constructor for term mul_hi.
pub fn constructor_mul_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Gpr,
    arg3: &GprMem,
) -> ValueRegs {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = &C::raw_operand_size_of_type(ctx, arg0);
    let v7 = MInst::MulHi {
        size: v6.clone(),
        signed: arg1,
        src1: arg2,
        src2: arg3.clone(),
        dst_lo: v4,
        dst_hi: v5,
    };
    let v8 = C::emit(ctx, &v7);
    let v9 = C::writable_gpr_to_gpr(ctx, v4);
    let v10 = C::writable_gpr_to_gpr(ctx, v5);
    let v11 = constructor_value_gprs(ctx, v9, v10);
    // Rule at src/isa/x64/inst.isle line 2053.
    return v11;
}

// Generated as internal constructor for term unary_rm_r.
pub fn constructor_unary_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &UnaryRmROpcode,
    arg1: Gpr,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::gpr_to_gpr_mem(ctx, arg1);
    let v5 = MInst::UnaryRmR {
        size: arg2.clone(),
        op: arg0.clone(),
        src: v4.clone(),
        dst: v3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2067.
    return v7;
}

// Generated as internal constructor for term unary_rm_r_vex.
pub fn constructor_unary_rm_r_vex<C: Context>(
    ctx: &mut C,
    arg0: &UnaryRmRVexOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::UnaryRmRVex {
        size: arg2.clone(),
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2074.
    return v6;
}

// Generated as internal constructor for term unary_rm_r_imm_vex.
pub fn constructor_unary_rm_r_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &UnaryRmRImmVexOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
    arg3: u8,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = MInst::UnaryRmRImmVex {
        size: arg2.clone(),
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v4,
        imm: arg3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2081.
    return v7;
}

// Generated as internal constructor for term cvt_int_to_float.
pub fn constructor_cvt_int_to_float<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &GprMem,
    arg3: &OperandSize,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::CvtIntToFloat {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        src2_size: arg3.clone(),
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2087.
    return v7;
}

// Generated as internal constructor for term cvt_int_to_float_vex.
pub fn constructor_cvt_int_to_float_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &GprMem,
    arg3: &OperandSize,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::CvtIntToFloatVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        src2_size: arg3.clone(),
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2093.
    return v7;
}

// Generated as internal constructor for term cvt_u64_to_float_seq.
pub fn constructor_cvt_u64_to_float_seq<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Xmm {
    let v2 = &C::raw_operand_size_of_type(ctx, arg0);
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = MInst::CvtUint64ToFloatSeq {
        dst_size: v2.clone(),
        src: arg1,
        dst: v3,
        tmp_gpr1: v4,
        tmp_gpr2: v5,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2099.
    return v8;
}

// Generated as internal constructor for term cvt_float_to_uint_seq.
pub fn constructor_cvt_float_to_uint_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Value,
    arg2: bool,
) -> Gpr {
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v2 = C::value_type(ctx, arg1);
    let v5 = &C::raw_operand_size_of_type(ctx, v2);
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = C::temp_writable_xmm(ctx);
    let v8 = C::temp_writable_xmm(ctx);
    let v9 = C::temp_writable_gpr(ctx);
    let v10 = constructor_put_in_xmm(ctx, arg1);
    let v11 = MInst::CvtFloatToUintSeq {
        dst_size: v4.clone(),
        src_size: v5.clone(),
        is_saturating: arg2,
        src: v10,
        dst: v6,
        tmp_gpr: v9,
        tmp_xmm: v7,
        tmp_xmm2: v8,
    };
    let v12 = C::emit(ctx, &v11);
    let v13 = C::writable_gpr_to_gpr(ctx, v6);
    // Rule at src/isa/x64/inst.isle line 2108.
    return v13;
}

// Generated as internal constructor for term cvt_float_to_sint_seq.
pub fn constructor_cvt_float_to_sint_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Value,
    arg2: bool,
) -> Gpr {
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v2 = C::value_type(ctx, arg1);
    let v5 = &C::raw_operand_size_of_type(ctx, v2);
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = C::temp_writable_xmm(ctx);
    let v8 = C::temp_writable_gpr(ctx);
    let v9 = constructor_put_in_xmm(ctx, arg1);
    let v10 = MInst::CvtFloatToSintSeq {
        dst_size: v4.clone(),
        src_size: v5.clone(),
        is_saturating: arg2,
        src: v9,
        dst: v6,
        tmp_gpr: v8,
        tmp_xmm: v7,
    };
    let v11 = C::emit(ctx, &v10);
    let v12 = C::writable_gpr_to_gpr(ctx, v6);
    // Rule at src/isa/x64/inst.isle line 2120.
    return v12;
}

// Generated as internal constructor for term mov_from_preg.
pub fn constructor_mov_from_preg<C: Context>(ctx: &mut C, arg0: PReg) -> Reg {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::MovFromPReg { src: arg0, dst: v1 };
    let v3 = C::emit(ctx, &v2);
    let v4 = constructor_writable_gpr_to_r_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 2132.
    return v4;
}

// Generated as internal constructor for term extend_to_gpr.
pub fn constructor_extend_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Type,
    arg2: &ExtendKind,
) -> Gpr {
    let v1 = C::value_type(ctx, arg0);
    if v1 == arg1 {
        let v4 = constructor_put_in_gpr(ctx, arg0);
        // Rule at src/isa/x64/inst.isle line 2156.
        return v4;
    }
    if v1 == I32 {
        if arg1 == I64 {
            if let &ExtendKind::Zero = arg2 {
                let v5 = constructor_value32_zeros_upper32(ctx, arg0);
                if v5 == true {
                    let v4 = constructor_put_in_gpr(ctx, arg0);
                    // Rule at src/isa/x64/inst.isle line 2164.
                    return v4;
                }
            }
        }
    }
    let v7 = &C::operand_size_of_type_32_64(ctx, arg1);
    let v8 = constructor_operand_size_bits(ctx, v7);
    let v6 = C::ty_bits_u16(ctx, v1);
    let v9 = &C::ext_mode(ctx, v6, v8);
    let v10 = &constructor_put_in_gpr_mem(ctx, arg0);
    let v11 = constructor_extend(ctx, arg2, arg1, v9, v10);
    // Rule at src/isa/x64/inst.isle line 2168.
    return v11;
}

// Generated as internal constructor for term extend.
pub fn constructor_extend<C: Context>(
    ctx: &mut C,
    arg0: &ExtendKind,
    arg1: Type,
    arg2: &ExtMode,
    arg3: &GprMem,
) -> Gpr {
    match arg0 {
        &ExtendKind::Sign => {
            let v5 = constructor_x64_movsx(ctx, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 2188.
            return v5;
        }
        &ExtendKind::Zero => {
            let v4 = constructor_x64_movzx(ctx, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 2184.
            return v4;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "extend", "src/isa/x64/inst.isle line 2181"
    )
}

// Generated as internal constructor for term value32_zeros_upper32.
pub fn constructor_value32_zeros_upper32<C: Context>(ctx: &mut C, arg0: Value) -> bool {
    let v1 = C::def_inst(ctx, arg0);
    if let Some(v2) = v1 {
        let v3 = &C::inst_data(ctx, v2);
        match v3 {
            &InstructionData::Binary {
                opcode: ref v4,
                args: ref v5,
            } => {
                match v4 {
                    &Opcode::Iadd => {
                        // Rule at src/isa/x64/inst.isle line 2195.
                        return true;
                    }
                    &Opcode::Isub => {
                        // Rule at src/isa/x64/inst.isle line 2196.
                        return true;
                    }
                    &Opcode::Imul => {
                        // Rule at src/isa/x64/inst.isle line 2197.
                        return true;
                    }
                    &Opcode::Band => {
                        // Rule at src/isa/x64/inst.isle line 2198.
                        return true;
                    }
                    &Opcode::Bor => {
                        // Rule at src/isa/x64/inst.isle line 2199.
                        return true;
                    }
                    &Opcode::Bxor => {
                        // Rule at src/isa/x64/inst.isle line 2200.
                        return true;
                    }
                    &Opcode::Ishl => {
                        // Rule at src/isa/x64/inst.isle line 2201.
                        return true;
                    }
                    &Opcode::Ushr => {
                        // Rule at src/isa/x64/inst.isle line 2202.
                        return true;
                    }
                    _ => {}
                }
            }
            &InstructionData::Load {
                opcode: ref v10,
                arg: v11,
                flags: v12,
                offset: v13,
            } => {
                if let &Opcode::Uload32 = v10 {
                    // Rule at src/isa/x64/inst.isle line 2203.
                    return true;
                }
            }
            _ => {}
        }
    }
    // Rule at src/isa/x64/inst.isle line 2204.
    return false;
}

// Generated as internal constructor for term vec_int_type.
pub fn constructor_vec_int_type<C: Context>(ctx: &mut C, arg0: Type) -> Type {
    let v1 = C::multi_lane(ctx, arg0);
    if let Some(v2) = v1 {
        match v2.0 {
            0x8 => {
                if v2.1 == 0x10 {
                    // Rule at src/isa/x64/inst.isle line 2210.
                    return I8X16;
                }
            }
            0x10 => {
                if v2.1 == 0x8 {
                    // Rule at src/isa/x64/inst.isle line 2211.
                    return I16X8;
                }
            }
            0x20 => {
                if v2.1 == 0x4 {
                    // Rule at src/isa/x64/inst.isle line 2212.
                    return I32X4;
                }
            }
            0x40 => {
                if v2.1 == 0x2 {
                    // Rule at src/isa/x64/inst.isle line 2213.
                    return I64X2;
                }
            }
            _ => {}
        }
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "vec_int_type", "src/isa/x64/inst.isle line 2209"
    )
}

// Generated as internal constructor for term x64_xor_vector.
pub fn constructor_x64_xor_vector<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v3 = constructor_x64_xorps(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2217.
            return v3;
        }
        F64 => {
            let v4 = constructor_x64_xorpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2218.
            return v4;
        }
        F32X4 => {
            let v3 = constructor_x64_xorps(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2219.
            return v3;
        }
        F64X2 => {
            let v4 = constructor_x64_xorpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2220.
            return v4;
        }
        _ => {}
    }
    let v5 = C::multi_lane(ctx, arg0);
    if let Some(v6) = v5 {
        let v9 = constructor_x64_pxor(ctx, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 2221.
        return v9;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_xor_vector", "src/isa/x64/inst.isle line 2216"
    )
}

// Generated as internal constructor for term vector_all_ones.
pub fn constructor_vector_all_ones<C: Context>(ctx: &mut C) -> Xmm {
    let v0 = constructor_xmm_uninit_value(ctx);
    let v1 = &C::xmm_to_xmm_mem(ctx, v0);
    let v2 = constructor_x64_pcmpeqd(ctx, v0, v1);
    // Rule at src/isa/x64/inst.isle line 2233.
    return v2;
}

// Generated as internal constructor for term mov_rmi_to_xmm.
pub fn constructor_mov_rmi_to_xmm<C: Context>(ctx: &mut C, arg0: &RegMemImm) -> XmmMemImm {
    match arg0 {
        &RegMemImm::Reg { reg: v4 } => {
            let v5 = &C::reg_to_gpr_mem(ctx, v4);
            let v6 = constructor_x64_movd_to_xmm(ctx, v5);
            let v7 = &C::xmm_to_xmm_mem_imm(ctx, v6);
            // Rule at src/isa/x64/inst.isle line 2241.
            return v7.clone();
        }
        &RegMemImm::Mem { addr: ref v1 } => {
            let v2 = &C::xmm_mem_imm_new(ctx, arg0);
            // Rule at src/isa/x64/inst.isle line 2239.
            return v2.clone();
        }
        &RegMemImm::Imm { simm32: v3 } => {
            let v2 = &C::xmm_mem_imm_new(ctx, arg0);
            // Rule at src/isa/x64/inst.isle line 2240.
            return v2.clone();
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "mov_rmi_to_xmm", "src/isa/x64/inst.isle line 2238"
    )
}

// Generated as internal constructor for term x64_load.
pub fn constructor_x64_load<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
    arg2: &ExtKind,
) -> Reg {
    match arg0 {
        I64 => {
            let v11 = constructor_mov64_mr(ctx, arg1);
            // Rule at src/isa/x64/inst.isle line 2260.
            return v11;
        }
        F32 => {
            let v12 = constructor_x64_movss_load(ctx, arg1);
            let v13 = C::xmm_to_reg(ctx, v12);
            // Rule at src/isa/x64/inst.isle line 2263.
            return v13;
        }
        F64 => {
            let v14 = constructor_x64_movsd_load(ctx, arg1);
            let v15 = C::xmm_to_reg(ctx, v14);
            // Rule at src/isa/x64/inst.isle line 2266.
            return v15;
        }
        F32X4 => {
            let v16 = constructor_x64_movups_load(ctx, arg1);
            let v17 = C::xmm_to_reg(ctx, v16);
            // Rule at src/isa/x64/inst.isle line 2269.
            return v17;
        }
        F64X2 => {
            let v18 = constructor_x64_movupd_load(ctx, arg1);
            let v19 = C::xmm_to_reg(ctx, v18);
            // Rule at src/isa/x64/inst.isle line 2272.
            return v19;
        }
        _ => {}
    }
    let v1 = C::fits_in_32(ctx, arg0);
    if let Some(v2) = v1 {
        if let &ExtKind::SignExtend = arg2 {
            let v5 = C::ty_bytes(ctx, v2);
            let v7 = &C::ext_mode(ctx, v5, 0x8);
            let v8 = &constructor_synthetic_amode_to_gpr_mem(ctx, arg1);
            let v9 = constructor_x64_movsx(ctx, v7, v8);
            let v10 = C::gpr_to_reg(ctx, v9);
            // Rule at src/isa/x64/inst.isle line 2256.
            return v10;
        }
    }
    let v20 = C::multi_lane(ctx, arg0);
    if let Some(v21) = v20 {
        let v24 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg1);
        let v25 = constructor_x64_movdqu_load(ctx, v24);
        let v26 = C::xmm_to_reg(ctx, v25);
        // Rule at src/isa/x64/inst.isle line 2275.
        return v26;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_load", "src/isa/x64/inst.isle line 2254"
    )
}

// Generated as internal constructor for term x64_mov.
pub fn constructor_x64_mov<C: Context>(ctx: &mut C, arg0: &Amode) -> Reg {
    let v1 = &C::amode_to_synthetic_amode(ctx, arg0);
    let v2 = constructor_mov64_mr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 2279.
    return v2;
}

// Generated as internal constructor for term x64_movzx.
pub fn constructor_x64_movzx<C: Context>(ctx: &mut C, arg0: &ExtMode, arg1: &GprMem) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::MovzxRmR {
        ext_mode: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2283.
    return v5;
}

// Generated as internal constructor for term x64_movsx.
pub fn constructor_x64_movsx<C: Context>(ctx: &mut C, arg0: &ExtMode, arg1: &GprMem) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::MovsxRmR {
        ext_mode: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2289.
    return v5;
}

// Generated as internal constructor for term x64_movss_load.
pub fn constructor_x64_movss_load<C: Context>(ctx: &mut C, arg0: &SyntheticAmode) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovss, v2);
        // Rule at src/isa/x64/inst.isle line 2297.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movss, v2);
    // Rule at src/isa/x64/inst.isle line 2295.
    return v3;
}

// Generated as internal constructor for term x64_movss_store.
pub fn constructor_x64_movss_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovss, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2304.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2302.
    return v3.clone();
}

// Generated as internal constructor for term x64_movsd_load.
pub fn constructor_x64_movsd_load<C: Context>(ctx: &mut C, arg0: &SyntheticAmode) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovsd, v2);
        // Rule at src/isa/x64/inst.isle line 2311.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movsd, v2);
    // Rule at src/isa/x64/inst.isle line 2309.
    return v3;
}

// Generated as internal constructor for term x64_movsd_store.
pub fn constructor_x64_movsd_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovsd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2318.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2316.
    return v3.clone();
}

// Generated as internal constructor for term x64_movups_load.
pub fn constructor_x64_movups_load<C: Context>(ctx: &mut C, arg0: &SyntheticAmode) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovups, v2);
        // Rule at src/isa/x64/inst.isle line 2325.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movups, v2);
    // Rule at src/isa/x64/inst.isle line 2323.
    return v3;
}

// Generated as internal constructor for term x64_movups_store.
pub fn constructor_x64_movups_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovups, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2332.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movups, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2330.
    return v3.clone();
}

// Generated as internal constructor for term x64_movupd_load.
pub fn constructor_x64_movupd_load<C: Context>(ctx: &mut C, arg0: &SyntheticAmode) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovupd, v2);
        // Rule at src/isa/x64/inst.isle line 2339.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movupd, v2);
    // Rule at src/isa/x64/inst.isle line 2337.
    return v3;
}

// Generated as internal constructor for term x64_movupd_store.
pub fn constructor_x64_movupd_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovupd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2346.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movupd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2344.
    return v3.clone();
}

// Generated as internal constructor for term x64_movd_to_gpr.
pub fn constructor_x64_movd_to_gpr<C: Context>(ctx: &mut C, arg0: Xmm) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovd, arg0, &OperandSize::Size32);
        // Rule at src/isa/x64/inst.isle line 2354.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movd, arg0, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 2352.
    return v3;
}

// Generated as internal constructor for term x64_movd_to_xmm.
pub fn constructor_x64_movd_to_xmm<C: Context>(ctx: &mut C, arg0: &GprMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_gpr_to_xmm_vex(ctx, &AvxOpcode::Vmovd, arg0, &OperandSize::Size32);
        // Rule at src/isa/x64/inst.isle line 2362.
        return v6;
    }
    let v3 = constructor_gpr_to_xmm(ctx, &SseOpcode::Movd, arg0, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 2360.
    return v3;
}

// Generated as internal constructor for term x64_movq_to_xmm.
pub fn constructor_x64_movq_to_xmm<C: Context>(ctx: &mut C, arg0: &GprMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_gpr_to_xmm_vex(ctx, &AvxOpcode::Vmovq, arg0, &OperandSize::Size64);
        // Rule at src/isa/x64/inst.isle line 2370.
        return v6;
    }
    let v3 = constructor_gpr_to_xmm(ctx, &SseOpcode::Movq, arg0, &OperandSize::Size64);
    // Rule at src/isa/x64/inst.isle line 2368.
    return v3;
}

// Generated as internal constructor for term x64_movq_to_gpr.
pub fn constructor_x64_movq_to_gpr<C: Context>(ctx: &mut C, arg0: Xmm) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovq, arg0, &OperandSize::Size64);
        // Rule at src/isa/x64/inst.isle line 2378.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movq, arg0, &OperandSize::Size64);
    // Rule at src/isa/x64/inst.isle line 2376.
    return v3;
}

// Generated as internal constructor for term x64_movdqu_load.
pub fn constructor_x64_movdqu_load<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovdqu, arg0);
        // Rule at src/isa/x64/inst.isle line 2385.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movdqu, arg0);
    // Rule at src/isa/x64/inst.isle line 2383.
    return v2;
}

// Generated as internal constructor for term x64_movdqu_store.
pub fn constructor_x64_movdqu_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovdqu, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2392.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movdqu, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2390.
    return v3.clone();
}

// Generated as internal constructor for term x64_pmovsxbw.
pub fn constructor_x64_pmovsxbw<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovsxbw, arg0);
        // Rule at src/isa/x64/inst.isle line 2399.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovsxbw, arg0);
    // Rule at src/isa/x64/inst.isle line 2397.
    return v2;
}

// Generated as internal constructor for term x64_pmovzxbw.
pub fn constructor_x64_pmovzxbw<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovzxbw, arg0);
        // Rule at src/isa/x64/inst.isle line 2406.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovzxbw, arg0);
    // Rule at src/isa/x64/inst.isle line 2404.
    return v2;
}

// Generated as internal constructor for term x64_pmovsxwd.
pub fn constructor_x64_pmovsxwd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovsxwd, arg0);
        // Rule at src/isa/x64/inst.isle line 2413.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovsxwd, arg0);
    // Rule at src/isa/x64/inst.isle line 2411.
    return v2;
}

// Generated as internal constructor for term x64_pmovzxwd.
pub fn constructor_x64_pmovzxwd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovzxwd, arg0);
        // Rule at src/isa/x64/inst.isle line 2420.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovzxwd, arg0);
    // Rule at src/isa/x64/inst.isle line 2418.
    return v2;
}

// Generated as internal constructor for term x64_pmovsxdq.
pub fn constructor_x64_pmovsxdq<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovsxdq, arg0);
        // Rule at src/isa/x64/inst.isle line 2427.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovsxdq, arg0);
    // Rule at src/isa/x64/inst.isle line 2425.
    return v2;
}

// Generated as internal constructor for term x64_pmovzxdq.
pub fn constructor_x64_pmovzxdq<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovzxdq, arg0);
        // Rule at src/isa/x64/inst.isle line 2434.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovzxdq, arg0);
    // Rule at src/isa/x64/inst.isle line 2432.
    return v2;
}

// Generated as internal constructor for term x64_movrm.
pub fn constructor_x64_movrm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v4 = MInst::MovRM {
        size: v3.clone(),
        src: arg2,
        dst: arg1.clone(),
    };
    let v5 = SideEffectNoResult::Inst { inst: v4 };
    // Rule at src/isa/x64/inst.isle line 2439.
    return v5;
}

// Generated as internal constructor for term x64_movimm_m.
pub fn constructor_x64_movimm_m<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
    arg2: i32,
) -> SideEffectNoResult {
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v4 = MInst::MovImmM {
        size: v3.clone(),
        simm32: arg2,
        dst: arg1.clone(),
    };
    let v5 = SideEffectNoResult::Inst { inst: v4 };
    // Rule at src/isa/x64/inst.isle line 2444.
    return v5;
}

// Generated as internal constructor for term xmm_movrm.
pub fn constructor_xmm_movrm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
) -> SideEffectNoResult {
    let v3 = MInst::XmmMovRM {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
    };
    let v4 = SideEffectNoResult::Inst { inst: v3 };
    // Rule at src/isa/x64/inst.isle line 2449.
    return v4;
}

// Generated as internal constructor for term xmm_movrm_imm.
pub fn constructor_xmm_movrm_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
    arg3: u8,
) -> SideEffectNoResult {
    let v4 = MInst::XmmMovRMImm {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
        imm: arg3,
    };
    let v5 = SideEffectNoResult::Inst { inst: v4 };
    // Rule at src/isa/x64/inst.isle line 2453.
    return v5;
}

// Generated as internal constructor for term xmm_movrm_vex.
pub fn constructor_xmm_movrm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
) -> SideEffectNoResult {
    let v3 = MInst::XmmMovRMVex {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
    };
    let v4 = SideEffectNoResult::Inst { inst: v3 };
    // Rule at src/isa/x64/inst.isle line 2457.
    return v4;
}

// Generated as internal constructor for term xmm_movrm_imm_vex.
pub fn constructor_xmm_movrm_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
    arg3: u8,
) -> SideEffectNoResult {
    let v4 = MInst::XmmMovRMImmVex {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
        imm: arg3,
    };
    let v5 = SideEffectNoResult::Inst { inst: v4 };
    // Rule at src/isa/x64/inst.isle line 2461.
    return v5;
}

// Generated as internal constructor for term x64_xmm_load_const.
pub fn constructor_x64_xmm_load_const<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: VCodeConstant,
) -> Xmm {
    let v2 = &C::const_to_synthetic_amode(ctx, arg1);
    let v4 = constructor_x64_load(ctx, arg0, v2, &ExtKind::None);
    let v5 = C::xmm_new(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2466.
    return v5;
}

// Generated as internal constructor for term x64_add.
pub fn constructor_x64_add<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Add, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2477.
    return v4;
}

// Generated as internal constructor for term x64_add_with_flags_paired.
pub fn constructor_x64_add_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Add,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2485.
    return v8;
}

// Generated as internal constructor for term x64_alurmi_with_flags_paired.
pub fn constructor_x64_alurmi_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: &AluRmiROpcode,
    arg1: Type,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> ProducesFlags {
    let v2 = C::fits_in_64(ctx, arg1);
    if let Some(v3) = v2 {
        let v6 = C::temp_writable_gpr(ctx);
        let v7 = &C::raw_operand_size_of_type(ctx, v3);
        let v9 = constructor_writable_gpr_to_r_reg(ctx, v6);
        let v8 = MInst::AluRmiR {
            size: v7.clone(),
            op: arg0.clone(),
            src1: arg2,
            src2: arg3.clone(),
            dst: v6,
        };
        let v10 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: v8,
            result: v9,
        };
        // Rule at src/isa/x64/inst.isle line 2496.
        return v10;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_alurmi_with_flags_paired", "src/isa/x64/inst.isle line 2495"
    )
}

// Generated as internal constructor for term x64_alurmi_with_flags_chained.
pub fn constructor_x64_alurmi_with_flags_chained<C: Context>(
    ctx: &mut C,
    arg0: &AluRmiROpcode,
    arg1: Type,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> ConsumesAndProducesFlags {
    let v2 = C::fits_in_64(ctx, arg1);
    if let Some(v3) = v2 {
        let v6 = C::temp_writable_gpr(ctx);
        let v7 = &C::raw_operand_size_of_type(ctx, v3);
        let v9 = constructor_writable_gpr_to_r_reg(ctx, v6);
        let v8 = MInst::AluRmiR {
            size: v7.clone(),
            op: arg0.clone(),
            src1: arg2,
            src2: arg3.clone(),
            dst: v6,
        };
        let v10 = ConsumesAndProducesFlags::ReturnsReg {
            inst: v8,
            result: v9,
        };
        // Rule at src/isa/x64/inst.isle line 2508.
        return v10;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_alurmi_with_flags_chained", "src/isa/x64/inst.isle line 2507"
    )
}

// Generated as internal constructor for term x64_adc_paired.
pub fn constructor_x64_adc_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ConsumesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Adc,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2520.
    return v8;
}

// Generated as internal constructor for term x64_sub.
pub fn constructor_x64_sub<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Sub, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2532.
    return v4;
}

// Generated as internal constructor for term x64_sub_with_flags_paired.
pub fn constructor_x64_sub_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Sub,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2540.
    return v8;
}

// Generated as internal constructor for term x64_sbb_paired.
pub fn constructor_x64_sbb_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ConsumesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Sbb,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2552.
    return v8;
}

// Generated as internal constructor for term x64_mul.
pub fn constructor_x64_mul<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Mul, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2564.
    return v4;
}

// Generated as internal constructor for term x64_umullo.
pub fn constructor_x64_umullo<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMem,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = MInst::UMulLo {
        size: v4.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2572.
    return v7;
}

// Generated as internal constructor for term x64_umullo_with_flags_paired.
pub fn constructor_x64_umullo_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMem,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v6 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v5 = MInst::UMulLo {
        size: v4.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v7 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v5,
        result: v6,
    };
    // Rule at src/isa/x64/inst.isle line 2579.
    return v7;
}

// Generated as internal constructor for term x64_and.
pub fn constructor_x64_and<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::And, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2590.
    return v4;
}

// Generated as internal constructor for term x64_and_with_flags_paired.
pub fn constructor_x64_and_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::And,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v7 = ProducesFlags::ProducesFlagsSideEffect { inst: v6 };
    // Rule at src/isa/x64/inst.isle line 2597.
    return v7;
}

// Generated as internal constructor for term x64_or.
pub fn constructor_x64_or<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: &GprMemImm) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Or, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2608.
    return v4;
}

// Generated as internal constructor for term x64_xor.
pub fn constructor_x64_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Xor, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2616.
    return v4;
}

// Generated as internal constructor for term x64_andn.
pub fn constructor_x64_andn<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: &GprMem) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Andn, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2623.
    return v4;
}

// Generated as internal constructor for term imm_i64.
pub fn constructor_imm_i64<C: Context>(ctx: &mut C, arg0: Type, arg1: i64) -> Reg {
    let v2 = C::i64_as_u64(ctx, arg1);
    let v3 = constructor_imm(ctx, arg0, v2);
    // Rule at src/isa/x64/inst.isle line 2630.
    return v3;
}

// Generated as internal constructor for term imm.
pub fn constructor_imm<C: Context>(ctx: &mut C, arg0: Type, arg1: u64) -> Reg {
    match arg0 {
        I64 => {
            let v20 = C::nonzero_u64_fits_in_u32(ctx, arg1);
            if let Some(v21) = v20 {
                let v5 = C::temp_writable_gpr(ctx);
                let v23 = MInst::Imm {
                    dst_size: OperandSize::Size32,
                    simm64: v21,
                    dst: v5,
                };
                let v24 = C::emit(ctx, &v23);
                let v25 = constructor_writable_gpr_to_r_reg(ctx, v5);
                // Rule at src/isa/x64/inst.isle line 2661.
                return v25;
            }
        }
        F32 => {
            let v4 = C::u64_is_zero(ctx, arg1);
            match v4 {
                true => {
                    let v35 = constructor_xmm_zero(ctx, arg0);
                    let v36 = C::xmm_to_reg(ctx, v35);
                    // Rule at src/isa/x64/inst.isle line 2679.
                    return v36;
                }
                false => {
                    let v11 = constructor_imm(ctx, I32, arg1);
                    let v12 = &C::reg_to_gpr_mem(ctx, v11);
                    let v13 = constructor_x64_movd_to_xmm(ctx, v12);
                    let v14 = C::xmm_to_reg(ctx, v13);
                    // Rule at src/isa/x64/inst.isle line 2652.
                    return v14;
                }
                _ => {}
            }
        }
        F64 => {
            let v4 = C::u64_is_zero(ctx, arg1);
            match v4 {
                true => {
                    let v35 = constructor_xmm_zero(ctx, arg0);
                    let v36 = C::xmm_to_reg(ctx, v35);
                    // Rule at src/isa/x64/inst.isle line 2684.
                    return v36;
                }
                false => {
                    let v16 = constructor_imm(ctx, I64, arg1);
                    let v17 = &C::reg_to_gpr_mem(ctx, v16);
                    let v18 = constructor_x64_movq_to_xmm(ctx, v17);
                    let v19 = C::xmm_to_reg(ctx, v18);
                    // Rule at src/isa/x64/inst.isle line 2656.
                    return v19;
                }
                _ => {}
            }
        }
        _ => {}
    }
    let v1 = C::fits_in_64(ctx, arg0);
    if let Some(v2) = v1 {
        let v4 = C::u64_is_zero(ctx, arg1);
        match v4 {
            true => {
                let v5 = C::temp_writable_gpr(ctx);
                let v6 = &C::operand_size_of_type_32_64(ctx, v2);
                let v27 = MInst::AluConstOp {
                    op: AluRmiROpcode::Xor,
                    size: v6.clone(),
                    dst: v5,
                };
                let v28 = C::emit(ctx, &v27);
                let v29 = C::writable_gpr_to_gpr(ctx, v5);
                let v30 = C::gpr_to_reg(ctx, v29);
                // Rule at src/isa/x64/inst.isle line 2667.
                return v30;
            }
            false => {
                let v5 = C::temp_writable_gpr(ctx);
                let v6 = &C::operand_size_of_type_32_64(ctx, v2);
                let v7 = MInst::Imm {
                    dst_size: v6.clone(),
                    simm64: arg1,
                    dst: v5,
                };
                let v8 = C::emit(ctx, &v7);
                let v9 = constructor_writable_gpr_to_r_reg(ctx, v5);
                // Rule at src/isa/x64/inst.isle line 2645.
                return v9;
            }
            _ => {}
        }
    }
    if arg1 == 0x0 {
        let v31 = C::multi_lane(ctx, arg0);
        if let Some(v32) = v31 {
            let v35 = constructor_xmm_zero(ctx, arg0);
            let v36 = C::xmm_to_reg(ctx, v35);
            // Rule at src/isa/x64/inst.isle line 2675.
            return v36;
        }
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "imm", "src/isa/x64/inst.isle line 2642"
    )
}

// Generated as internal constructor for term xmm_zero.
pub fn constructor_xmm_zero<C: Context>(ctx: &mut C, arg0: Type) -> Xmm {
    let v1 = constructor_xmm_uninit_value(ctx);
    let v2 = &C::xmm_to_xmm_mem(ctx, v1);
    let v3 = constructor_x64_xor_vector(ctx, arg0, v1, v2);
    // Rule at src/isa/x64/inst.isle line 2689.
    return v3;
}

// Generated as internal constructor for term shift_r.
pub fn constructor_shift_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ShiftKind,
    arg2: Gpr,
    arg3: &Imm8Gpr,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::raw_operand_size_of_type(ctx, arg0);
    let v6 = MInst::ShiftR {
        size: v5.clone(),
        kind: arg1.clone(),
        src: arg2,
        num_bits: arg3.clone(),
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2695.
    return v8;
}

// Generated as internal constructor for term x64_rotl.
pub fn constructor_x64_rotl<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: &Imm8Gpr) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::imm8_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = C::ty_bits(ctx, v6);
                let v12 = C::u8_sub(ctx, v11, v8);
                let v13 = constructor_x64_rorx(ctx, v6, v10, v12);
                // Rule at src/isa/x64/inst.isle line 2707.
                return v13;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::RotateLeft, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2705.
    return v4;
}

// Generated as internal constructor for term x64_rotr.
pub fn constructor_x64_rotr<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: &Imm8Gpr) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::imm8_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_rorx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 2715.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::RotateRight, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2713.
    return v4;
}

// Generated as internal constructor for term x64_shl.
pub fn constructor_x64_shl<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: &Imm8Gpr) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::gpr_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_shlx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 2727.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::ShiftLeft, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2721.
    return v4;
}

// Generated as internal constructor for term x64_shr.
pub fn constructor_x64_shr<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: &Imm8Gpr) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::gpr_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_shrx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 2736.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::ShiftRightLogical, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2733.
    return v4;
}

// Generated as internal constructor for term x64_sar.
pub fn constructor_x64_sar<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: &Imm8Gpr) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::gpr_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_sarx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 2745.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::ShiftRightArithmetic, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2742.
    return v4;
}

// Generated as internal constructor for term x64_bzhi.
pub fn constructor_x64_bzhi<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem, arg2: Gpr) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Bzhi, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 2754.
    return v4;
}

// Generated as internal constructor for term x64_bswap.
pub fn constructor_x64_bswap<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = MInst::Bswap {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2761.
    return v6;
}

// Generated as internal constructor for term cmp_rmi_r.
pub fn constructor_cmp_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &CmpOpcode,
    arg2: &GprMemImm,
    arg3: Gpr,
) -> ProducesFlags {
    let v4 = MInst::CmpRmiR {
        size: arg0.clone(),
        opcode: arg1.clone(),
        src: arg2.clone(),
        dst: arg3,
    };
    let v5 = ProducesFlags::ProducesFlagsSideEffect { inst: v4 };
    // Rule at src/isa/x64/inst.isle line 2769.
    return v5;
}

// Generated as internal constructor for term x64_cmp.
pub fn constructor_x64_cmp<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &GprMemImm,
    arg2: Gpr,
) -> ProducesFlags {
    let v4 = &constructor_cmp_rmi_r(ctx, arg0, &CmpOpcode::Cmp, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2778.
    return v4.clone();
}

// Generated as internal constructor for term x64_cmp_imm.
pub fn constructor_x64_cmp_imm<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: u32,
    arg2: Gpr,
) -> ProducesFlags {
    let v4 = RegMemImm::Imm { simm32: arg1 };
    let v5 = &C::gpr_mem_imm_new(ctx, &v4);
    let v6 = &constructor_cmp_rmi_r(ctx, arg0, &CmpOpcode::Cmp, v5, arg2);
    // Rule at src/isa/x64/inst.isle line 2783.
    return v6.clone();
}

// Generated as internal constructor for term xmm_cmp_rm_r.
pub fn constructor_xmm_cmp_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMemAligned,
    arg2: Xmm,
) -> ProducesFlags {
    let v3 = MInst::XmmCmpRmR {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: arg2,
    };
    let v4 = ProducesFlags::ProducesFlagsSideEffect { inst: v3 };
    // Rule at src/isa/x64/inst.isle line 2788.
    return v4;
}

// Generated as internal constructor for term x64_ucomis.
pub fn constructor_x64_ucomis<C: Context>(ctx: &mut C, arg0: Value, arg1: Value) -> ProducesFlags {
    let v1 = C::value_type(ctx, arg0);
    match v1 {
        F32 => {
            let v4 = constructor_put_in_xmm(ctx, arg0);
            let v5 = &constructor_xmm_to_xmm_mem_aligned(ctx, v4);
            let v6 = constructor_put_in_xmm(ctx, arg1);
            let v7 = &constructor_xmm_cmp_rm_r(ctx, &SseOpcode::Ucomiss, v5, v6);
            // Rule at src/isa/x64/inst.isle line 2794.
            return v7.clone();
        }
        F64 => {
            let v4 = constructor_put_in_xmm(ctx, arg0);
            let v5 = &constructor_xmm_to_xmm_mem_aligned(ctx, v4);
            let v6 = constructor_put_in_xmm(ctx, arg1);
            let v9 = &constructor_xmm_cmp_rm_r(ctx, &SseOpcode::Ucomisd, v5, v6);
            // Rule at src/isa/x64/inst.isle line 2798.
            return v9.clone();
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_ucomis", "src/isa/x64/inst.isle line 2793"
    )
}

// Generated as internal constructor for term x64_test.
pub fn constructor_x64_test<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &GprMemImm,
    arg2: Gpr,
) -> ProducesFlags {
    let v4 = &constructor_cmp_rmi_r(ctx, arg0, &CmpOpcode::Test, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2803.
    return v4.clone();
}

// Generated as internal constructor for term x64_ptest.
pub fn constructor_x64_ptest<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: Xmm) -> ProducesFlags {
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = &constructor_xmm_cmp_rm_r(ctx, &SseOpcode::Ptest, v3, arg1);
    // Rule at src/isa/x64/inst.isle line 2808.
    return v4.clone();
}

// Generated as internal constructor for term cmove.
pub fn constructor_cmove<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &GprMem,
    arg3: Gpr,
) -> ConsumesFlags {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v4);
    let v6 = MInst::Cmove {
        size: v5.clone(),
        cc: arg1.clone(),
        consequent: arg2.clone(),
        alternative: arg3,
        dst: v4,
    };
    let v8 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2815.
    return v8;
}

// Generated as internal constructor for term cmove_xmm.
pub fn constructor_cmove_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &XmmMemAligned,
    arg3: Xmm,
) -> ConsumesFlags {
    let v4 = C::temp_writable_xmm(ctx);
    let v6 = constructor_writable_xmm_to_r_reg(ctx, v4);
    let v5 = MInst::XmmCmove {
        ty: arg0,
        cc: arg1.clone(),
        consequent: arg2.clone(),
        alternative: arg3,
        dst: v4,
    };
    let v7 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: v5,
        result: v6,
    };
    // Rule at src/isa/x64/inst.isle line 2823.
    return v7;
}

// Generated as internal constructor for term cmove_from_values.
pub fn constructor_cmove_from_values<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: Value,
    arg3: Value,
) -> ConsumesFlags {
    let v1 = &C::type_register_class(ctx, arg0);
    if let Some(v2) = v1 {
        match v2 {
            &RegisterClass::Gpr {
                single_register: v3,
            } => {
                match v3 {
                    true => {
                        let v26 = &constructor_put_in_gpr_mem(ctx, arg2);
                        let v27 = constructor_put_in_gpr(ctx, arg3);
                        let v28 = &constructor_cmove(ctx, arg0, arg1, v26, v27);
                        // Rule at src/isa/x64/inst.isle line 2854.
                        return v28.clone();
                    }
                    false => {
                        if arg0 == I128 {
                            let v7 = C::put_in_regs(ctx, arg2);
                            let v8 = C::put_in_regs(ctx, arg3);
                            let v9 = C::temp_writable_gpr(ctx);
                            let v10 = C::temp_writable_gpr(ctx);
                            let v13 = constructor_value_regs_get_gpr(ctx, v7, 0x0);
                            let v14 = &C::gpr_to_gpr_mem(ctx, v13);
                            let v15 = constructor_value_regs_get_gpr(ctx, v8, 0x0);
                            let v18 = constructor_value_regs_get_gpr(ctx, v7, 0x1);
                            let v19 = &C::gpr_to_gpr_mem(ctx, v18);
                            let v20 = constructor_value_regs_get_gpr(ctx, v8, 0x1);
                            let v22 = constructor_writable_gpr_to_r_reg(ctx, v9);
                            let v23 = constructor_writable_gpr_to_r_reg(ctx, v10);
                            let v24 = C::value_regs(ctx, v22, v23);
                            let v16 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v14.clone(),
                                alternative: v15,
                                dst: v9,
                            };
                            let v21 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v19.clone(),
                                alternative: v20,
                                dst: v10,
                            };
                            let v25 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                                inst1: v16,
                                inst2: v21,
                                result: v24,
                            };
                            // Rule at src/isa/x64/inst.isle line 2833.
                            return v25;
                        }
                    }
                    _ => {}
                }
            }
            &RegisterClass::Xmm => {
                let v29 = &constructor_put_in_xmm_mem_aligned(ctx, arg2);
                let v30 = constructor_put_in_xmm(ctx, arg3);
                let v31 = &constructor_cmove_xmm(ctx, arg0, arg1, v29, v30);
                // Rule at src/isa/x64/inst.isle line 2857.
                return v31.clone();
            }
            _ => {}
        }
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "cmove_from_values", "src/isa/x64/inst.isle line 2832"
    )
}

// Generated as internal constructor for term cmove_or.
pub fn constructor_cmove_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: &GprMem,
    arg4: Gpr,
) -> ConsumesFlags {
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v9 = C::writable_gpr_to_gpr(ctx, v6);
    let v11 = constructor_writable_gpr_to_value_regs(ctx, v5);
    let v8 = MInst::Cmove {
        size: v7.clone(),
        cc: arg1.clone(),
        consequent: arg3.clone(),
        alternative: arg4,
        dst: v6,
    };
    let v10 = MInst::Cmove {
        size: v7.clone(),
        cc: arg2.clone(),
        consequent: arg3.clone(),
        alternative: v9,
        dst: v5,
    };
    let v12 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
        inst1: v8,
        inst2: v10,
        result: v11,
    };
    // Rule at src/isa/x64/inst.isle line 2864.
    return v12;
}

// Generated as internal constructor for term cmove_or_xmm.
pub fn constructor_cmove_or_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: &XmmMemAligned,
    arg4: Xmm,
) -> ConsumesFlags {
    let v5 = C::temp_writable_xmm(ctx);
    let v6 = C::temp_writable_xmm(ctx);
    let v8 = C::writable_xmm_to_xmm(ctx, v6);
    let v10 = constructor_writable_xmm_to_value_regs(ctx, v5);
    let v7 = MInst::XmmCmove {
        ty: arg0,
        cc: arg1.clone(),
        consequent: arg3.clone(),
        alternative: arg4,
        dst: v6,
    };
    let v9 = MInst::XmmCmove {
        ty: arg0,
        cc: arg2.clone(),
        consequent: arg3.clone(),
        alternative: v8,
        dst: v5,
    };
    let v11 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
        inst1: v7,
        inst2: v9,
        result: v10,
    };
    // Rule at src/isa/x64/inst.isle line 2876.
    return v11;
}

// Generated as internal constructor for term cmove_or_from_values.
pub fn constructor_cmove_or_from_values<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: Value,
    arg4: Value,
) -> ConsumesFlags {
    let v1 = &C::type_register_class(ctx, arg0);
    if let Some(v2) = v1 {
        match v2 {
            &RegisterClass::Gpr {
                single_register: v3,
            } => {
                match v3 {
                    true => {
                        let v37 = &constructor_put_in_gpr_mem(ctx, arg3);
                        let v38 = constructor_put_in_gpr(ctx, arg4);
                        let v39 = &constructor_cmove_or(ctx, arg0, arg1, arg2, v37, v38);
                        // Rule at src/isa/x64/inst.isle line 2909.
                        return v39.clone();
                    }
                    false => {
                        if arg0 == I128 {
                            let v8 = C::put_in_regs(ctx, arg3);
                            let v9 = C::put_in_regs(ctx, arg4);
                            let v10 = C::temp_writable_gpr(ctx);
                            let v11 = C::temp_writable_gpr(ctx);
                            let v12 = C::temp_writable_gpr(ctx);
                            let v13 = C::temp_writable_gpr(ctx);
                            let v16 = constructor_value_regs_get_gpr(ctx, v8, 0x0);
                            let v17 = &C::gpr_to_gpr_mem(ctx, v16);
                            let v18 = constructor_value_regs_get_gpr(ctx, v9, 0x0);
                            let v20 = constructor_value_regs_get_gpr(ctx, v8, 0x0);
                            let v21 = &C::gpr_to_gpr_mem(ctx, v20);
                            let v22 = C::writable_gpr_to_gpr(ctx, v12);
                            let v25 = constructor_value_regs_get_gpr(ctx, v8, 0x1);
                            let v26 = &C::gpr_to_gpr_mem(ctx, v25);
                            let v27 = constructor_value_regs_get_gpr(ctx, v9, 0x1);
                            let v29 = constructor_value_regs_get_gpr(ctx, v8, 0x1);
                            let v30 = &C::gpr_to_gpr_mem(ctx, v29);
                            let v31 = C::writable_gpr_to_gpr(ctx, v13);
                            let v33 = constructor_writable_gpr_to_r_reg(ctx, v10);
                            let v34 = constructor_writable_gpr_to_r_reg(ctx, v11);
                            let v35 = C::value_regs(ctx, v33, v34);
                            let v19 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v17.clone(),
                                alternative: v18,
                                dst: v12,
                            };
                            let v23 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg2.clone(),
                                consequent: v21.clone(),
                                alternative: v22,
                                dst: v10,
                            };
                            let v28 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v26.clone(),
                                alternative: v27,
                                dst: v13,
                            };
                            let v32 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg2.clone(),
                                consequent: v30.clone(),
                                alternative: v31,
                                dst: v11,
                            };
                            let v36 = ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                                inst1: v19,
                                inst2: v23,
                                inst3: v28,
                                inst4: v32,
                                result: v35,
                            };
                            // Rule at src/isa/x64/inst.isle line 2890.
                            return v36;
                        }
                    }
                    _ => {}
                }
            }
            &RegisterClass::Xmm => {
                let v40 = &constructor_put_in_xmm_mem_aligned(ctx, arg3);
                let v41 = constructor_put_in_xmm(ctx, arg4);
                let v42 = &constructor_cmove_or_xmm(ctx, arg0, arg1, arg2, v40, v41);
                // Rule at src/isa/x64/inst.isle line 2912.
                return v42.clone();
            }
            _ => {}
        }
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "cmove_or_from_values", "src/isa/x64/inst.isle line 2889"
    )
}

// Generated as internal constructor for term x64_setcc.
pub fn constructor_x64_setcc<C: Context>(ctx: &mut C, arg0: &CC) -> ConsumesFlags {
    let v1 = C::temp_writable_gpr(ctx);
    let v3 = constructor_writable_gpr_to_r_reg(ctx, v1);
    let v2 = MInst::Setcc {
        cc: arg0.clone(),
        dst: v1,
    };
    let v4 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: v2,
        result: v3,
    };
    // Rule at src/isa/x64/inst.isle line 2917.
    return v4;
}

// Generated as internal constructor for term x64_setcc_paired.
pub fn constructor_x64_setcc_paired<C: Context>(ctx: &mut C, arg0: &CC) -> ConsumesFlags {
    let v1 = C::temp_writable_gpr(ctx);
    let v3 = constructor_writable_gpr_to_r_reg(ctx, v1);
    let v2 = MInst::Setcc {
        cc: arg0.clone(),
        dst: v1,
    };
    let v4 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: v2,
        result: v3,
    };
    // Rule at src/isa/x64/inst.isle line 2926.
    return v4;
}

// Generated as internal constructor for term x64_paddb.
pub fn constructor_x64_paddb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2936.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2934.
    return v4;
}

// Generated as internal constructor for term x64_paddw.
pub fn constructor_x64_paddw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2944.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2942.
    return v4;
}

// Generated as internal constructor for term x64_paddd.
pub fn constructor_x64_paddd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2952.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2950.
    return v4;
}

// Generated as internal constructor for term x64_paddq.
pub fn constructor_x64_paddq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2960.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2958.
    return v4;
}

// Generated as internal constructor for term x64_paddsb.
pub fn constructor_x64_paddsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2968.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2966.
    return v4;
}

// Generated as internal constructor for term x64_paddsw.
pub fn constructor_x64_paddsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2976.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2974.
    return v4;
}

// Generated as internal constructor for term x64_phaddw.
pub fn constructor_x64_phaddw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vphaddw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2984.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Phaddw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2982.
    return v4;
}

// Generated as internal constructor for term x64_phaddd.
pub fn constructor_x64_phaddd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vphaddd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 2992.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Phaddd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2990.
    return v4;
}

// Generated as internal constructor for term x64_paddusb.
pub fn constructor_x64_paddusb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddusb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3000.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddusb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 2998.
    return v4;
}

// Generated as internal constructor for term x64_paddusw.
pub fn constructor_x64_paddusw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddusw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3008.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddusw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3006.
    return v4;
}

// Generated as internal constructor for term x64_psubb.
pub fn constructor_x64_psubb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3016.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3014.
    return v4;
}

// Generated as internal constructor for term x64_psubw.
pub fn constructor_x64_psubw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3024.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3022.
    return v4;
}

// Generated as internal constructor for term x64_psubd.
pub fn constructor_x64_psubd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3032.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3030.
    return v4;
}

// Generated as internal constructor for term x64_psubq.
pub fn constructor_x64_psubq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3040.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3038.
    return v4;
}

// Generated as internal constructor for term x64_psubsb.
pub fn constructor_x64_psubsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3048.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3046.
    return v4;
}

// Generated as internal constructor for term x64_psubsw.
pub fn constructor_x64_psubsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3056.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3054.
    return v4;
}

// Generated as internal constructor for term x64_psubusb.
pub fn constructor_x64_psubusb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubusb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3064.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubusb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3062.
    return v4;
}

// Generated as internal constructor for term x64_psubusw.
pub fn constructor_x64_psubusw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubusw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3072.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubusw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3070.
    return v4;
}

// Generated as internal constructor for term x64_pavgb.
pub fn constructor_x64_pavgb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpavgb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3080.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pavgb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3078.
    return v4;
}

// Generated as internal constructor for term x64_pavgw.
pub fn constructor_x64_pavgw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpavgw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3088.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pavgw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3086.
    return v4;
}

// Generated as internal constructor for term x64_pand.
pub fn constructor_x64_pand<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpand, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3096.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pand, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3094.
    return v4;
}

// Generated as internal constructor for term x64_andps.
pub fn constructor_x64_andps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3104.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3102.
    return v4;
}

// Generated as internal constructor for term x64_andpd.
pub fn constructor_x64_andpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3112.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3110.
    return v4;
}

// Generated as internal constructor for term x64_por.
pub fn constructor_x64_por<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpor, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3120.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Por, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3118.
    return v4;
}

// Generated as internal constructor for term x64_orps.
pub fn constructor_x64_orps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vorps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3128.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Orps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3126.
    return v4;
}

// Generated as internal constructor for term x64_orpd.
pub fn constructor_x64_orpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vorpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3136.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Orpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3134.
    return v4;
}

// Generated as internal constructor for term x64_pxor.
pub fn constructor_x64_pxor<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpxor, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3144.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pxor, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3142.
    return v4;
}

// Generated as internal constructor for term x64_xorps.
pub fn constructor_x64_xorps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vxorps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3152.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Xorps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3150.
    return v4;
}

// Generated as internal constructor for term x64_xorpd.
pub fn constructor_x64_xorpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vxorpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3160.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Xorpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3158.
    return v4;
}

// Generated as internal constructor for term x64_pmullw.
pub fn constructor_x64_pmullw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmullw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3168.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmullw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3166.
    return v4;
}

// Generated as internal constructor for term x64_pmulld.
pub fn constructor_x64_pmulld<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulld, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3176.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulld, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3174.
    return v4;
}

// Generated as internal constructor for term x64_pmulhw.
pub fn constructor_x64_pmulhw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulhw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3184.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulhw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3182.
    return v4;
}

// Generated as internal constructor for term x64_pmulhrsw.
pub fn constructor_x64_pmulhrsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulhrsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3192.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulhrsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3190.
    return v4;
}

// Generated as internal constructor for term x64_pmulhuw.
pub fn constructor_x64_pmulhuw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulhuw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3200.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulhuw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3198.
    return v4;
}

// Generated as internal constructor for term x64_pmuldq.
pub fn constructor_x64_pmuldq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmuldq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3208.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmuldq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3206.
    return v4;
}

// Generated as internal constructor for term x64_pmuludq.
pub fn constructor_x64_pmuludq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmuludq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3216.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmuludq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3214.
    return v4;
}

// Generated as internal constructor for term x64_punpckhwd.
pub fn constructor_x64_punpckhwd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhwd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3224.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhwd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3222.
    return v4;
}

// Generated as internal constructor for term x64_punpcklwd.
pub fn constructor_x64_punpcklwd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpcklwd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3232.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpcklwd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3230.
    return v4;
}

// Generated as internal constructor for term x64_punpckldq.
pub fn constructor_x64_punpckldq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckldq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3240.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckldq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3238.
    return v4;
}

// Generated as internal constructor for term x64_punpckhdq.
pub fn constructor_x64_punpckhdq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhdq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3248.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhdq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3246.
    return v4;
}

// Generated as internal constructor for term x64_punpcklqdq.
pub fn constructor_x64_punpcklqdq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpcklqdq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3256.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpcklqdq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3254.
    return v4;
}

// Generated as internal constructor for term x64_punpckhqdq.
pub fn constructor_x64_punpckhqdq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhqdq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3264.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhqdq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3262.
    return v4;
}

// Generated as internal constructor for term x64_unpcklps.
pub fn constructor_x64_unpcklps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vunpcklps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3272.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Unpcklps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3270.
    return v4;
}

// Generated as internal constructor for term x64_unpckhps.
pub fn constructor_x64_unpckhps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vunpckhps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3280.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Unpckhps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3278.
    return v4;
}

// Generated as internal constructor for term x64_andnps.
pub fn constructor_x64_andnps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandnps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3288.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andnps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3286.
    return v4;
}

// Generated as internal constructor for term x64_andnpd.
pub fn constructor_x64_andnpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandnpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3296.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andnpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3294.
    return v4;
}

// Generated as internal constructor for term x64_pandn.
pub fn constructor_x64_pandn<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpandn, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3304.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pandn, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3302.
    return v4;
}

// Generated as internal constructor for term x64_addss.
pub fn constructor_x64_addss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3312.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Addss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3310.
    return v3;
}

// Generated as internal constructor for term x64_addsd.
pub fn constructor_x64_addsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3320.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Addsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3318.
    return v3;
}

// Generated as internal constructor for term x64_addps.
pub fn constructor_x64_addps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3328.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Addps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3326.
    return v4;
}

// Generated as internal constructor for term x64_addpd.
pub fn constructor_x64_addpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3336.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Addpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3334.
    return v4;
}

// Generated as internal constructor for term x64_subss.
pub fn constructor_x64_subss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3344.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Subss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3342.
    return v3;
}

// Generated as internal constructor for term x64_subsd.
pub fn constructor_x64_subsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3352.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Subsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3350.
    return v3;
}

// Generated as internal constructor for term x64_subps.
pub fn constructor_x64_subps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3360.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Subps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3358.
    return v4;
}

// Generated as internal constructor for term x64_subpd.
pub fn constructor_x64_subpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3368.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Subpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3366.
    return v4;
}

// Generated as internal constructor for term x64_mulss.
pub fn constructor_x64_mulss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3376.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Mulss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3374.
    return v3;
}

// Generated as internal constructor for term x64_mulsd.
pub fn constructor_x64_mulsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3384.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Mulsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3382.
    return v3;
}

// Generated as internal constructor for term x64_mulps.
pub fn constructor_x64_mulps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3392.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Mulps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3390.
    return v4;
}

// Generated as internal constructor for term x64_mulpd.
pub fn constructor_x64_mulpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3400.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Mulpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3398.
    return v4;
}

// Generated as internal constructor for term x64_divss.
pub fn constructor_x64_divss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3408.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Divss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3406.
    return v3;
}

// Generated as internal constructor for term x64_divsd.
pub fn constructor_x64_divsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3416.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Divsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3414.
    return v3;
}

// Generated as internal constructor for term x64_divps.
pub fn constructor_x64_divps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3424.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Divps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3422.
    return v4;
}

// Generated as internal constructor for term x64_divpd.
pub fn constructor_x64_divpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3432.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Divpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3430.
    return v4;
}

// Generated as internal constructor for term x64_blendvpd.
pub fn constructor_x64_blendvpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = constructor_xmm_rmr_blend_vex(ctx, &AvxOpcode::Vblendvpd, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3440.
        return v8;
    }
    let v4 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v5 = constructor_xmm_rm_r_blend(ctx, &SseOpcode::Blendvpd, arg0, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 3438.
    return v5;
}

// Generated as internal constructor for term x64_blendvps.
pub fn constructor_x64_blendvps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = constructor_xmm_rmr_blend_vex(ctx, &AvxOpcode::Vblendvps, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3448.
        return v8;
    }
    let v4 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v5 = constructor_xmm_rm_r_blend(ctx, &SseOpcode::Blendvps, arg0, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 3446.
    return v5;
}

// Generated as internal constructor for term x64_pblendvb.
pub fn constructor_x64_pblendvb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = constructor_xmm_rmr_blend_vex(ctx, &AvxOpcode::Vpblendvb, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3456.
        return v8;
    }
    let v4 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v5 = constructor_xmm_rm_r_blend(ctx, &SseOpcode::Pblendvb, arg0, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 3454.
    return v5;
}

// Generated as internal constructor for term x64_pblendw.
pub fn constructor_x64_pblendw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem, arg2: u8) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vpblendw, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3464.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pblendw, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3462.
    return v7;
}

// Generated as internal constructor for term x64_movsd_regmove.
pub fn constructor_x64_movsd_regmove<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmovsd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3479.
        return v8;
    }
    let v3 = &C::xmm_to_xmm_mem(ctx, arg1);
    let v4 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Movsd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3477.
    return v4;
}

// Generated as internal constructor for term x64_movss_regmove.
pub fn constructor_x64_movss_regmove<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmovss, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3486.
        return v8;
    }
    let v3 = &C::xmm_to_xmm_mem(ctx, arg1);
    let v4 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Movss, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3484.
    return v4;
}

// Generated as internal constructor for term x64_movlhps.
pub fn constructor_x64_movlhps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmovlhps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3494.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Movlhps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3492.
    return v4;
}

// Generated as internal constructor for term x64_pmaxs.
pub fn constructor_x64_pmaxs<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm, arg2: &XmmMem) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pmaxsb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3500.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pmaxsw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3501.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pmaxsd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3502.
            return v5;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_pmaxs", "src/isa/x64/inst.isle line 3499"
    )
}

// Generated as internal constructor for term x64_pmaxsb.
pub fn constructor_x64_pmaxsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3506.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3505.
    return v4;
}

// Generated as internal constructor for term x64_pmaxsw.
pub fn constructor_x64_pmaxsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3511.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3510.
    return v4;
}

// Generated as internal constructor for term x64_pmaxsd.
pub fn constructor_x64_pmaxsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxsd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3516.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxsd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3515.
    return v4;
}

// Generated as internal constructor for term x64_pmins.
pub fn constructor_x64_pmins<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm, arg2: &XmmMem) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pminsb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3522.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pminsw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3523.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pminsd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3524.
            return v5;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_pmins", "src/isa/x64/inst.isle line 3521"
    )
}

// Generated as internal constructor for term x64_pminsb.
pub fn constructor_x64_pminsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3528.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3527.
    return v4;
}

// Generated as internal constructor for term x64_pminsw.
pub fn constructor_x64_pminsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3533.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3532.
    return v4;
}

// Generated as internal constructor for term x64_pminsd.
pub fn constructor_x64_pminsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminsd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3538.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminsd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3537.
    return v4;
}

// Generated as internal constructor for term x64_pmaxu.
pub fn constructor_x64_pmaxu<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm, arg2: &XmmMem) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pmaxub(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3544.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pmaxuw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3545.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pmaxud(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3546.
            return v5;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_pmaxu", "src/isa/x64/inst.isle line 3543"
    )
}

// Generated as internal constructor for term x64_pmaxub.
pub fn constructor_x64_pmaxub<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxub, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3550.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxub, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3549.
    return v4;
}

// Generated as internal constructor for term x64_pmaxuw.
pub fn constructor_x64_pmaxuw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxuw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3555.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxuw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3554.
    return v4;
}

// Generated as internal constructor for term x64_pmaxud.
pub fn constructor_x64_pmaxud<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxud, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3560.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxud, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3559.
    return v4;
}

// Generated as internal constructor for term x64_pminu.
pub fn constructor_x64_pminu<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm, arg2: &XmmMem) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pminub(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3566.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pminuw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3567.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pminud(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3568.
            return v5;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_pminu", "src/isa/x64/inst.isle line 3565"
    )
}

// Generated as internal constructor for term x64_pminub.
pub fn constructor_x64_pminub<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminub, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3572.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminub, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3571.
    return v4;
}

// Generated as internal constructor for term x64_pminuw.
pub fn constructor_x64_pminuw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminuw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3577.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminuw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3576.
    return v4;
}

// Generated as internal constructor for term x64_pminud.
pub fn constructor_x64_pminud<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminud, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3582.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminud, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3581.
    return v4;
}

// Generated as internal constructor for term x64_punpcklbw.
pub fn constructor_x64_punpcklbw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpcklbw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3590.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpcklbw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3588.
    return v4;
}

// Generated as internal constructor for term x64_punpckhbw.
pub fn constructor_x64_punpckhbw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhbw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3598.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhbw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3596.
    return v4;
}

// Generated as internal constructor for term x64_packsswb.
pub fn constructor_x64_packsswb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpacksswb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3606.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packsswb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3604.
    return v4;
}

// Generated as internal constructor for term x64_packssdw.
pub fn constructor_x64_packssdw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpackssdw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3614.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packssdw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3612.
    return v4;
}

// Generated as internal constructor for term x64_packuswb.
pub fn constructor_x64_packuswb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpackuswb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3622.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packuswb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3620.
    return v4;
}

// Generated as internal constructor for term x64_packusdw.
pub fn constructor_x64_packusdw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpackusdw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3630.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packusdw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3628.
    return v4;
}

// Generated as internal constructor for term x64_palignr.
pub fn constructor_x64_palignr<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem, arg2: u8) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vpalignr, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3642.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Palignr, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3636.
    return v7;
}

// Generated as internal constructor for term x64_cmpp.
pub fn constructor_x64_cmpp<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
    arg3: &FcmpImm,
) -> Xmm {
    match arg0 {
        F32X4 => {
            let v4 = constructor_x64_cmpps(ctx, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 3648.
            return v4;
        }
        F64X2 => {
            let v5 = constructor_x64_cmppd(ctx, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 3649.
            return v5;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_cmpp", "src/isa/x64/inst.isle line 3647"
    )
}

// Generated as internal constructor for term x64_cmpps.
pub fn constructor_x64_cmpps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: &FcmpImm,
) -> Xmm {
    let v9 = C::use_avx(ctx);
    if v9 == true {
        let v11 = C::encode_fcmp_imm(ctx, arg2);
        let v12 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vcmpps, arg0, arg1, v11);
        // Rule at src/isa/x64/inst.isle line 3658.
        return v12;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v6 = C::encode_fcmp_imm(ctx, arg2);
    let v8 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Cmpps, v4, v5, v6, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3652.
    return v8;
}

// Generated as internal constructor for term x64_cmppd.
pub fn constructor_x64_cmppd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: &FcmpImm,
) -> Xmm {
    let v9 = C::use_avx(ctx);
    if v9 == true {
        let v11 = C::encode_fcmp_imm(ctx, arg2);
        let v12 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vcmppd, arg0, arg1, v11);
        // Rule at src/isa/x64/inst.isle line 3675.
        return v12;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v6 = C::encode_fcmp_imm(ctx, arg2);
    let v8 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Cmppd, v4, v5, v6, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3669.
    return v8;
}

// Generated as internal constructor for term x64_pinsrb.
pub fn constructor_x64_pinsrb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &GprMem, arg2: u8) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrb, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3690.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrb, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3684.
    return v7;
}

// Generated as internal constructor for term x64_pinsrw.
pub fn constructor_x64_pinsrw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &GprMem, arg2: u8) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrw, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3702.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrw, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3696.
    return v7;
}

// Generated as internal constructor for term x64_pinsrd.
pub fn constructor_x64_pinsrd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &GprMem, arg2: u8) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrd, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3714.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrd, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3708.
    return v7;
}

// Generated as internal constructor for term x64_pinsrq.
pub fn constructor_x64_pinsrq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &GprMem, arg2: u8) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrq, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3726.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrd, v4, v5, arg2, &OperandSize::Size64);
    // Rule at src/isa/x64/inst.isle line 3720.
    return v7;
}

// Generated as internal constructor for term x64_roundss.
pub fn constructor_x64_roundss<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: &RoundImm) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = C::encode_round_imm(ctx, arg1);
        let v9 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundss, arg0, v8);
        // Rule at src/isa/x64/inst.isle line 3734.
        return v9;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = C::encode_round_imm(ctx, arg1);
    let v5 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundss, v3, v4);
    // Rule at src/isa/x64/inst.isle line 3732.
    return v5;
}

// Generated as internal constructor for term x64_roundsd.
pub fn constructor_x64_roundsd<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: &RoundImm) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = C::encode_round_imm(ctx, arg1);
        let v9 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundsd, arg0, v8);
        // Rule at src/isa/x64/inst.isle line 3742.
        return v9;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = C::encode_round_imm(ctx, arg1);
    let v5 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundsd, v3, v4);
    // Rule at src/isa/x64/inst.isle line 3740.
    return v5;
}

// Generated as internal constructor for term x64_roundps.
pub fn constructor_x64_roundps<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: &RoundImm) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = C::encode_round_imm(ctx, arg1);
        let v9 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundps, arg0, v8);
        // Rule at src/isa/x64/inst.isle line 3750.
        return v9;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = C::encode_round_imm(ctx, arg1);
    let v5 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundps, v3, v4);
    // Rule at src/isa/x64/inst.isle line 3748.
    return v5;
}

// Generated as internal constructor for term x64_roundpd.
pub fn constructor_x64_roundpd<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: &RoundImm) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = C::encode_round_imm(ctx, arg1);
        let v9 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundpd, arg0, v8);
        // Rule at src/isa/x64/inst.isle line 3758.
        return v9;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = C::encode_round_imm(ctx, arg1);
    let v5 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundpd, v3, v4);
    // Rule at src/isa/x64/inst.isle line 3756.
    return v5;
}

// Generated as internal constructor for term x64_pmaddwd.
pub fn constructor_x64_pmaddwd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaddwd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3766.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaddwd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3764.
    return v4;
}

// Generated as internal constructor for term x64_pmaddubsw.
pub fn constructor_x64_pmaddubsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaddubsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3773.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaddubsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3771.
    return v4;
}

// Generated as internal constructor for term x64_insertps.
pub fn constructor_x64_insertps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vinsertps, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3785.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(
        ctx,
        &SseOpcode::Insertps,
        v4,
        v5,
        arg2,
        &OperandSize::Size32,
    );
    // Rule at src/isa/x64/inst.isle line 3779.
    return v7;
}

// Generated as internal constructor for term x64_pshufd.
pub fn constructor_x64_pshufd<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: u8) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vpshufd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3793.
        return v7;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Pshufd, v3, arg1);
    // Rule at src/isa/x64/inst.isle line 3791.
    return v4;
}

// Generated as internal constructor for term x64_pshufb.
pub fn constructor_x64_pshufb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpshufb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3801.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pshufb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3799.
    return v4;
}

// Generated as internal constructor for term x64_pshuflw.
pub fn constructor_x64_pshuflw<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: u8) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vpshuflw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3809.
        return v7;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Pshuflw, v3, arg1);
    // Rule at src/isa/x64/inst.isle line 3807.
    return v4;
}

// Generated as internal constructor for term x64_pshufhw.
pub fn constructor_x64_pshufhw<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: u8) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vpshufhw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3817.
        return v7;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Pshufhw, v3, arg1);
    // Rule at src/isa/x64/inst.isle line 3815.
    return v4;
}

// Generated as internal constructor for term x64_shufps.
pub fn constructor_x64_shufps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem, arg2: u8) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vshufps, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3829.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Shufps, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3823.
    return v7;
}

// Generated as internal constructor for term x64_pabsb.
pub fn constructor_x64_pabsb<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpabsb, arg0);
        // Rule at src/isa/x64/inst.isle line 3837.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Pabsb, v2);
    // Rule at src/isa/x64/inst.isle line 3835.
    return v3;
}

// Generated as internal constructor for term x64_pabsw.
pub fn constructor_x64_pabsw<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpabsw, arg0);
        // Rule at src/isa/x64/inst.isle line 3845.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Pabsw, v2);
    // Rule at src/isa/x64/inst.isle line 3843.
    return v3;
}

// Generated as internal constructor for term x64_pabsd.
pub fn constructor_x64_pabsd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpabsd, arg0);
        // Rule at src/isa/x64/inst.isle line 3853.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Pabsd, v2);
    // Rule at src/isa/x64/inst.isle line 3851.
    return v3;
}

// Generated as internal constructor for term x64_vcvtudq2ps.
pub fn constructor_x64_vcvtudq2ps<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_evex(ctx, &Avx512Opcode::Vcvtudq2ps, arg0);
    // Rule at src/isa/x64/inst.isle line 3859.
    return v2;
}

// Generated as internal constructor for term x64_vpabsq.
pub fn constructor_x64_vpabsq<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_evex(ctx, &Avx512Opcode::Vpabsq, arg0);
    // Rule at src/isa/x64/inst.isle line 3864.
    return v2;
}

// Generated as internal constructor for term x64_vpopcntb.
pub fn constructor_x64_vpopcntb<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_evex(ctx, &Avx512Opcode::Vpopcntb, arg0);
    // Rule at src/isa/x64/inst.isle line 3869.
    return v2;
}

// Generated as internal constructor for term x64_vpmullq.
pub fn constructor_x64_vpmullq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v3 = constructor_xmm_rm_r_evex(ctx, &Avx512Opcode::Vpmullq, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3876.
    return v3;
}

// Generated as internal constructor for term x64_vpermi2b.
pub fn constructor_x64_vpermi2b<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmREvex3 {
        op: Avx512Opcode::Vpermi2b,
        src1: arg0,
        src2: arg1,
        src3: arg2.clone(),
        dst: v3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 3885.
    return v7;
}

// Generated as internal constructor for term mulhi_u.
pub fn constructor_mulhi_u<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMem,
) -> ValueRegs {
    let v4 = constructor_mul_hi(ctx, arg0, false, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3897.
    return v4;
}

// Generated as internal constructor for term x64_psllw.
pub fn constructor_x64_psllw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsllw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3904.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psllw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3902.
    return v4;
}

// Generated as internal constructor for term x64_pslld.
pub fn constructor_x64_pslld<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpslld, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3912.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Pslld, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3910.
    return v4;
}

// Generated as internal constructor for term x64_psllq.
pub fn constructor_x64_psllq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsllq, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3920.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psllq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3918.
    return v4;
}

// Generated as internal constructor for term x64_psrlw.
pub fn constructor_x64_psrlw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrlw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3928.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrlw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3926.
    return v4;
}

// Generated as internal constructor for term x64_psrld.
pub fn constructor_x64_psrld<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrld, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3936.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrld, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3934.
    return v4;
}

// Generated as internal constructor for term x64_psrlq.
pub fn constructor_x64_psrlq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrlq, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3944.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrlq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3942.
    return v4;
}

// Generated as internal constructor for term x64_psraw.
pub fn constructor_x64_psraw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsraw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3952.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psraw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3950.
    return v4;
}

// Generated as internal constructor for term x64_psrad.
pub fn constructor_x64_psrad<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrad, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3960.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrad, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3958.
    return v4;
}

// Generated as internal constructor for term x64_vpsraq.
pub fn constructor_x64_vpsraq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v3 = constructor_xmm_rm_r_evex(ctx, &Avx512Opcode::Vpsraq, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3966.
    return v3;
}

// Generated as internal constructor for term x64_vpsraq_imm.
pub fn constructor_x64_vpsraq_imm<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: u8) -> Xmm {
    let v3 = constructor_xmm_unary_rm_r_imm_evex(ctx, &Avx512Opcode::VpsraqImm, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3971.
    return v3;
}

// Generated as internal constructor for term x64_pextrb.
pub fn constructor_x64_pextrb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: u8) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrb, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3978.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrb, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3976.
    return v3;
}

// Generated as internal constructor for term x64_pextrb_store.
pub fn constructor_x64_pextrb_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrb, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3985.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrb, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3983.
    return v4.clone();
}

// Generated as internal constructor for term x64_pextrw.
pub fn constructor_x64_pextrw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: u8) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3993.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrw, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3991.
    return v3;
}

// Generated as internal constructor for term x64_pextrw_store.
pub fn constructor_x64_pextrw_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrw, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4000.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrw, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3998.
    return v4.clone();
}

// Generated as internal constructor for term x64_pextrd.
pub fn constructor_x64_pextrd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: u8) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4008.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4006.
    return v3;
}

// Generated as internal constructor for term x64_pextrd_store.
pub fn constructor_x64_pextrd_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrd, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4015.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrd, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4013.
    return v4.clone();
}

// Generated as internal constructor for term x64_pextrq.
pub fn constructor_x64_pextrq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: u8) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrq, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4023.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrq, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4021.
    return v3;
}

// Generated as internal constructor for term x64_pextrq_store.
pub fn constructor_x64_pextrq_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrq, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4030.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrq, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4028.
    return v4.clone();
}

// Generated as internal constructor for term x64_pmovmskb.
pub fn constructor_x64_pmovmskb<C: Context>(ctx: &mut C, arg0: &OperandSize, arg1: Xmm) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vpmovmskb, arg1, arg0);
        // Rule at src/isa/x64/inst.isle line 4038.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Pmovmskb, arg1, arg0);
    // Rule at src/isa/x64/inst.isle line 4036.
    return v3;
}

// Generated as internal constructor for term x64_movmskps.
pub fn constructor_x64_movmskps<C: Context>(ctx: &mut C, arg0: &OperandSize, arg1: Xmm) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovmskps, arg1, arg0);
        // Rule at src/isa/x64/inst.isle line 4046.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movmskps, arg1, arg0);
    // Rule at src/isa/x64/inst.isle line 4044.
    return v3;
}

// Generated as internal constructor for term x64_movmskpd.
pub fn constructor_x64_movmskpd<C: Context>(ctx: &mut C, arg0: &OperandSize, arg1: Xmm) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovmskpd, arg1, arg0);
        // Rule at src/isa/x64/inst.isle line 4054.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movmskpd, arg1, arg0);
    // Rule at src/isa/x64/inst.isle line 4052.
    return v3;
}

// Generated as internal constructor for term x64_not.
pub fn constructor_x64_not<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = MInst::Not {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4060.
    return v6;
}

// Generated as internal constructor for term x64_neg.
pub fn constructor_x64_neg<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v4 = MInst::Neg {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4068.
    return v6;
}

// Generated as internal constructor for term x64_neg_paired.
pub fn constructor_x64_neg_paired<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> ProducesFlags {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = constructor_writable_gpr_to_r_reg(ctx, v2);
    let v4 = MInst::Neg {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v6 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v4,
        result: v5,
    };
    // Rule at src/isa/x64/inst.isle line 4076.
    return v6;
}

// Generated as internal constructor for term x64_lea.
pub fn constructor_x64_lea<C: Context>(ctx: &mut C, arg0: Type, arg1: &SyntheticAmode) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = MInst::LoadEffectiveAddress {
        addr: arg1.clone(),
        dst: v2,
        size: v3.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4083.
    return v6;
}

// Generated as internal constructor for term x64_ud2.
pub fn constructor_x64_ud2<C: Context>(ctx: &mut C, arg0: &TrapCode) -> SideEffectNoResult {
    let v1 = MInst::Ud2 {
        trap_code: arg0.clone(),
    };
    let v2 = SideEffectNoResult::Inst { inst: v1 };
    // Rule at src/isa/x64/inst.isle line 4090.
    return v2;
}

// Generated as internal constructor for term x64_hlt.
pub fn constructor_x64_hlt<C: Context>(ctx: &mut C) -> SideEffectNoResult {
    let v1 = SideEffectNoResult::Inst { inst: MInst::Hlt };
    // Rule at src/isa/x64/inst.isle line 4095.
    return v1;
}

// Generated as internal constructor for term x64_lzcnt.
pub fn constructor_x64_lzcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r(ctx, &UnaryRmROpcode::Lzcnt, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4100.
    return v4;
}

// Generated as internal constructor for term x64_tzcnt.
pub fn constructor_x64_tzcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r(ctx, &UnaryRmROpcode::Tzcnt, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4105.
    return v4;
}

// Generated as internal constructor for term x64_bsr.
pub fn constructor_x64_bsr<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> ProducesFlags {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = &C::gpr_to_gpr_mem(ctx, arg1);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v2);
    let v6 = MInst::UnaryRmR {
        size: v3.clone(),
        op: UnaryRmROpcode::Bsr,
        src: v5.clone(),
        dst: v2,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsReg {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 4110.
    return v8;
}

// Generated as internal constructor for term bsr_or_else.
pub fn constructor_bsr_or_else<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: Gpr) -> Gpr {
    let v3 = &constructor_x64_bsr(ctx, arg0, arg1);
    let v4 = constructor_produces_flags_get_reg(ctx, v3);
    let v5 = C::gpr_new(ctx, v4);
    let v7 = &C::gpr_to_gpr_mem(ctx, arg2);
    let v8 = &constructor_cmove(ctx, arg0, &CC::Z, v7, v5);
    let v9 = &constructor_produces_flags_ignore(ctx, v3);
    let v10 = constructor_with_flags_reg(ctx, v9, v8);
    let v11 = C::gpr_new(ctx, v10);
    // Rule at src/isa/x64/inst.isle line 4119.
    return v11;
}

// Generated as internal constructor for term x64_bsf.
pub fn constructor_x64_bsf<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> ProducesFlags {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = &C::gpr_to_gpr_mem(ctx, arg1);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v2);
    let v6 = MInst::UnaryRmR {
        size: v3.clone(),
        op: UnaryRmROpcode::Bsf,
        src: v5.clone(),
        dst: v2,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsReg {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 4130.
    return v8;
}

// Generated as internal constructor for term bsf_or_else.
pub fn constructor_bsf_or_else<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr, arg2: Gpr) -> Gpr {
    let v3 = &constructor_x64_bsf(ctx, arg0, arg1);
    let v4 = constructor_produces_flags_get_reg(ctx, v3);
    let v5 = C::gpr_new(ctx, v4);
    let v7 = &C::gpr_to_gpr_mem(ctx, arg2);
    let v8 = &constructor_cmove(ctx, arg0, &CC::Z, v7, v5);
    let v9 = &constructor_produces_flags_ignore(ctx, v3);
    let v10 = constructor_with_flags_reg(ctx, v9, v8);
    let v11 = C::gpr_new(ctx, v10);
    // Rule at src/isa/x64/inst.isle line 4139.
    return v11;
}

// Generated as internal constructor for term x64_blsi.
pub fn constructor_x64_blsi<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r_vex(ctx, &UnaryRmRVexOpcode::Blsi, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4150.
    return v4;
}

// Generated as internal constructor for term x64_blsmsk.
pub fn constructor_x64_blsmsk<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r_vex(ctx, &UnaryRmRVexOpcode::Blsmsk, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4155.
    return v4;
}

// Generated as internal constructor for term x64_blsr.
pub fn constructor_x64_blsr<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r_vex(ctx, &UnaryRmRVexOpcode::Blsr, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4160.
    return v4;
}

// Generated as internal constructor for term x64_sarx.
pub fn constructor_x64_sarx<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem, arg2: Gpr) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Sarx, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 4165.
    return v4;
}

// Generated as internal constructor for term x64_shrx.
pub fn constructor_x64_shrx<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem, arg2: Gpr) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Shrx, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 4170.
    return v4;
}

// Generated as internal constructor for term x64_shlx.
pub fn constructor_x64_shlx<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem, arg2: Gpr) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Shlx, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 4175.
    return v4;
}

// Generated as internal constructor for term x64_rorx.
pub fn constructor_x64_rorx<C: Context>(ctx: &mut C, arg0: Type, arg1: &GprMem, arg2: u8) -> Gpr {
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = constructor_unary_rm_r_imm_vex(ctx, &UnaryRmRImmVexOpcode::Rorx, arg1, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 4180.
    return v5;
}

// Generated as internal constructor for term x64_popcnt.
pub fn constructor_x64_popcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r(ctx, &UnaryRmROpcode::Popcnt, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4188.
    return v4;
}

// Generated as internal constructor for term x64_minss.
pub fn constructor_x64_minss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4195.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Minss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4193.
    return v3;
}

// Generated as internal constructor for term x64_minsd.
pub fn constructor_x64_minsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4203.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Minsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4201.
    return v3;
}

// Generated as internal constructor for term x64_minps.
pub fn constructor_x64_minps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4211.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Minps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4209.
    return v4;
}

// Generated as internal constructor for term x64_minpd.
pub fn constructor_x64_minpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4219.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Minpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4217.
    return v4;
}

// Generated as internal constructor for term x64_maxss.
pub fn constructor_x64_maxss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4227.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Maxss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4225.
    return v3;
}

// Generated as internal constructor for term x64_maxsd.
pub fn constructor_x64_maxsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4235.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Maxsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4233.
    return v3;
}

// Generated as internal constructor for term x64_maxps.
pub fn constructor_x64_maxps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4243.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Maxps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4241.
    return v4;
}

// Generated as internal constructor for term x64_maxpd.
pub fn constructor_x64_maxpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4251.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Maxpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4249.
    return v4;
}

// Generated as internal constructor for term x64_vfmadd213.
pub fn constructor_x64_vfmadd213<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4257.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4258.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4259.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4260.
            return v11;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_vfmadd213", "src/isa/x64/inst.isle line 4256"
    )
}

// Generated as internal constructor for term x64_vfmadd132.
pub fn constructor_x64_vfmadd132<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4264.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4265.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4266.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4267.
            return v11;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_vfmadd132", "src/isa/x64/inst.isle line 4263"
    )
}

// Generated as internal constructor for term x64_vfnmadd213.
pub fn constructor_x64_vfnmadd213<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4271.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4272.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4273.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4274.
            return v11;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_vfnmadd213", "src/isa/x64/inst.isle line 4270"
    )
}

// Generated as internal constructor for term x64_vfnmadd132.
pub fn constructor_x64_vfnmadd132<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4278.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4279.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4280.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4281.
            return v11;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_vfnmadd132", "src/isa/x64/inst.isle line 4277"
    )
}

// Generated as internal constructor for term x64_sqrtss.
pub fn constructor_x64_sqrtss<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vsqrtss, arg0);
        // Rule at src/isa/x64/inst.isle line 4286.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Sqrtss, arg0);
    // Rule at src/isa/x64/inst.isle line 4285.
    return v2;
}

// Generated as internal constructor for term x64_sqrtsd.
pub fn constructor_x64_sqrtsd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vsqrtsd, arg0);
        // Rule at src/isa/x64/inst.isle line 4293.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Sqrtsd, arg0);
    // Rule at src/isa/x64/inst.isle line 4292.
    return v2;
}

// Generated as internal constructor for term x64_sqrtps.
pub fn constructor_x64_sqrtps<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vsqrtps, arg0);
        // Rule at src/isa/x64/inst.isle line 4300.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Sqrtps, v2);
    // Rule at src/isa/x64/inst.isle line 4299.
    return v3;
}

// Generated as internal constructor for term x64_sqrtpd.
pub fn constructor_x64_sqrtpd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vsqrtpd, arg0);
        // Rule at src/isa/x64/inst.isle line 4307.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Sqrtpd, v2);
    // Rule at src/isa/x64/inst.isle line 4306.
    return v3;
}

// Generated as internal constructor for term x64_cvtss2sd.
pub fn constructor_x64_cvtss2sd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtss2sd, arg0);
        // Rule at src/isa/x64/inst.isle line 4314.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Cvtss2sd, arg0);
    // Rule at src/isa/x64/inst.isle line 4313.
    return v2;
}

// Generated as internal constructor for term x64_cvtsd2ss.
pub fn constructor_x64_cvtsd2ss<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtsd2ss, arg0);
        // Rule at src/isa/x64/inst.isle line 4321.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Cvtsd2ss, arg0);
    // Rule at src/isa/x64/inst.isle line 4320.
    return v2;
}

// Generated as internal constructor for term x64_cvtdq2ps.
pub fn constructor_x64_cvtdq2ps<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtdq2ps, arg0);
        // Rule at src/isa/x64/inst.isle line 4328.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtdq2ps, v2);
    // Rule at src/isa/x64/inst.isle line 4327.
    return v3;
}

// Generated as internal constructor for term x64_cvtps2pd.
pub fn constructor_x64_cvtps2pd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtps2pd, arg0);
        // Rule at src/isa/x64/inst.isle line 4335.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtps2pd, v2);
    // Rule at src/isa/x64/inst.isle line 4334.
    return v3;
}

// Generated as internal constructor for term x64_cvtpd2ps.
pub fn constructor_x64_cvtpd2ps<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtpd2ps, arg0);
        // Rule at src/isa/x64/inst.isle line 4342.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtpd2ps, v2);
    // Rule at src/isa/x64/inst.isle line 4341.
    return v3;
}

// Generated as internal constructor for term x64_cvtdq2pd.
pub fn constructor_x64_cvtdq2pd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtdq2pd, arg0);
        // Rule at src/isa/x64/inst.isle line 4349.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtdq2pd, v2);
    // Rule at src/isa/x64/inst.isle line 4348.
    return v3;
}

// Generated as internal constructor for term x64_cvtsi2ss.
pub fn constructor_x64_cvtsi2ss<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &GprMem,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v4 = &C::raw_operand_size_of_type(ctx, arg0);
        let v8 = constructor_cvt_int_to_float_vex(ctx, &AvxOpcode::Vcvtsi2ss, arg1, arg2, v4);
        // Rule at src/isa/x64/inst.isle line 4357.
        return v8;
    }
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = constructor_cvt_int_to_float(ctx, &SseOpcode::Cvtsi2ss, arg1, arg2, v4);
    // Rule at src/isa/x64/inst.isle line 4355.
    return v5;
}

// Generated as internal constructor for term x64_cvtsi2sd.
pub fn constructor_x64_cvtsi2sd<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &GprMem,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v4 = &C::raw_operand_size_of_type(ctx, arg0);
        let v8 = constructor_cvt_int_to_float_vex(ctx, &AvxOpcode::Vcvtsi2sd, arg1, arg2, v4);
        // Rule at src/isa/x64/inst.isle line 4365.
        return v8;
    }
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = constructor_cvt_int_to_float(ctx, &SseOpcode::Cvtsi2sd, arg1, arg2, v4);
    // Rule at src/isa/x64/inst.isle line 4363.
    return v5;
}

// Generated as internal constructor for term x64_cvttps2dq.
pub fn constructor_x64_cvttps2dq<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvttps2dq, arg0);
        // Rule at src/isa/x64/inst.isle line 4373.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvttps2dq, v2);
    // Rule at src/isa/x64/inst.isle line 4371.
    return v3;
}

// Generated as internal constructor for term x64_cvttpd2dq.
pub fn constructor_x64_cvttpd2dq<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvttpd2dq, arg0);
        // Rule at src/isa/x64/inst.isle line 4381.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvttpd2dq, v2);
    // Rule at src/isa/x64/inst.isle line 4379.
    return v3;
}

// Generated as internal constructor for term x64_pcmpeq.
pub fn constructor_x64_pcmpeq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pcmpeqb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4387.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pcmpeqw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4388.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pcmpeqd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4389.
            return v5;
        }
        I64X2 => {
            let v6 = C::use_sse41(ctx);
            if v6 == true {
                let v7 = constructor_x64_pcmpeqq(ctx, arg1, arg2);
                // Rule at src/isa/x64/inst.isle line 4390.
                return v7;
            }
            let v5 = constructor_x64_pcmpeqd(ctx, arg1, arg2);
            let v8 = &C::xmm_to_xmm_mem(ctx, v5);
            let v10 = constructor_x64_pshufd(ctx, v8, 0xB1);
            let v11 = &C::xmm_to_xmm_mem(ctx, v10);
            let v12 = constructor_x64_pand(ctx, v5, v11);
            // Rule at src/isa/x64/inst.isle line 4399.
            return v12;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_pcmpeq", "src/isa/x64/inst.isle line 4386"
    )
}

// Generated as internal constructor for term x64_pcmpeqb.
pub fn constructor_x64_pcmpeqb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4406.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4405.
    return v4;
}

// Generated as internal constructor for term x64_pcmpeqw.
pub fn constructor_x64_pcmpeqw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4411.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4410.
    return v4;
}

// Generated as internal constructor for term x64_pcmpeqd.
pub fn constructor_x64_pcmpeqd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4416.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4415.
    return v4;
}

// Generated as internal constructor for term x64_pcmpeqq.
pub fn constructor_x64_pcmpeqq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4421.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4420.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgt.
pub fn constructor_x64_pcmpgt<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pcmpgtb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4427.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pcmpgtw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4428.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pcmpgtd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4429.
            return v5;
        }
        I64X2 => {
            let v6 = C::use_sse42(ctx);
            if v6 == true {
                let v7 = constructor_x64_pcmpgtq(ctx, arg1, arg2);
                // Rule at src/isa/x64/inst.isle line 4433.
                return v7;
            }
            let v9 = C::emit_u128_le_const(ctx, 0x800000000000000080000000);
            let v10 = &constructor_const_to_xmm_mem(ctx, v9);
            let v11 = constructor_x64_movdqu_load(ctx, v10);
            let v12 = &C::xmm_to_xmm_mem(ctx, arg1);
            let v13 = constructor_x64_pxor(ctx, v11, v12);
            let v14 = constructor_x64_pxor(ctx, v11, arg2);
            let v15 = &C::xmm_to_xmm_mem(ctx, v14);
            let v16 = constructor_x64_pcmpgtd(ctx, v13, v15);
            let v17 = &C::xmm_to_xmm_mem(ctx, v16);
            let v19 = constructor_x64_pshufd(ctx, v17, 0xA0);
            let v20 = &C::xmm_to_xmm_mem(ctx, v16);
            let v22 = constructor_x64_pshufd(ctx, v20, 0xF5);
            let v23 = &C::xmm_to_xmm_mem(ctx, v14);
            let v24 = constructor_x64_pcmpeqd(ctx, v13, v23);
            let v25 = &C::xmm_to_xmm_mem(ctx, v24);
            let v26 = constructor_x64_pshufd(ctx, v25, 0xF5);
            let v27 = &C::xmm_to_xmm_mem(ctx, v26);
            let v28 = constructor_x64_pand(ctx, v19, v27);
            let v29 = &C::xmm_to_xmm_mem(ctx, v22);
            let v30 = constructor_x64_por(ctx, v28, v29);
            // Rule at src/isa/x64/inst.isle line 4462.
            return v30;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "x64_pcmpgt", "src/isa/x64/inst.isle line 4426"
    )
}

// Generated as internal constructor for term x64_pcmpgtb.
pub fn constructor_x64_pcmpgtb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4478.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4477.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgtw.
pub fn constructor_x64_pcmpgtw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4483.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4482.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgtd.
pub fn constructor_x64_pcmpgtd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4488.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4487.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgtq.
pub fn constructor_x64_pcmpgtq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4493.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4492.
    return v4;
}

// Generated as internal constructor for term alu_rm.
pub fn constructor_alu_rm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmiROpcode,
    arg2: &Amode,
    arg3: Gpr,
) -> SideEffectNoResult {
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = &C::amode_to_synthetic_amode(ctx, arg2);
    let v6 = MInst::AluRM {
        size: v4.clone(),
        op: arg1.clone(),
        src1_dst: v5.clone(),
        src2: arg3,
    };
    let v7 = SideEffectNoResult::Inst { inst: v6 };
    // Rule at src/isa/x64/inst.isle line 4499.
    return v7;
}

// Generated as internal constructor for term x64_add_mem.
pub fn constructor_x64_add_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Add, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4504.
    return v4.clone();
}

// Generated as internal constructor for term x64_sub_mem.
pub fn constructor_x64_sub_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Sub, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4508.
    return v4.clone();
}

// Generated as internal constructor for term x64_and_mem.
pub fn constructor_x64_and_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::And, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4512.
    return v4.clone();
}

// Generated as internal constructor for term x64_or_mem.
pub fn constructor_x64_or_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Or, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4516.
    return v4.clone();
}

// Generated as internal constructor for term x64_xor_mem.
pub fn constructor_x64_xor_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Xor, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4520.
    return v4.clone();
}

// Generated as internal constructor for term trap_if.
pub fn constructor_trap_if<C: Context>(ctx: &mut C, arg0: &CC, arg1: &TrapCode) -> ConsumesFlags {
    let v2 = MInst::TrapIf {
        cc: arg0.clone(),
        trap_code: arg1.clone(),
    };
    let v3 = ConsumesFlags::ConsumesFlagsSideEffect { inst: v2 };
    // Rule at src/isa/x64/inst.isle line 4525.
    return v3;
}

// Generated as internal constructor for term trap_if_and.
pub fn constructor_trap_if_and<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: &CC,
    arg2: &TrapCode,
) -> ConsumesFlags {
    let v3 = MInst::TrapIfAnd {
        cc1: arg0.clone(),
        cc2: arg1.clone(),
        trap_code: arg2.clone(),
    };
    let v4 = ConsumesFlags::ConsumesFlagsSideEffect { inst: v3 };
    // Rule at src/isa/x64/inst.isle line 4530.
    return v4;
}

// Generated as internal constructor for term trap_if_or.
pub fn constructor_trap_if_or<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: &CC,
    arg2: &TrapCode,
) -> ConsumesFlags {
    let v3 = MInst::TrapIfOr {
        cc1: arg0.clone(),
        cc2: arg1.clone(),
        trap_code: arg2.clone(),
    };
    let v4 = ConsumesFlags::ConsumesFlagsSideEffect { inst: v3 };
    // Rule at src/isa/x64/inst.isle line 4535.
    return v4;
}

// Generated as internal constructor for term trap_if_icmp.
pub fn constructor_trap_if_icmp<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
    arg1: &TrapCode,
) -> SideEffectNoResult {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0
    {
        let v4 = &constructor_trap_if(ctx, v2, arg1);
        let v5 = &constructor_with_flags_side_effect(ctx, v1, v4);
        // Rule at src/isa/x64/inst.isle line 4539.
        return v5.clone();
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "trap_if_icmp", "src/isa/x64/inst.isle line 4538"
    )
}

// Generated as internal constructor for term trap_if_fcmp.
pub fn constructor_trap_if_fcmp<C: Context>(
    ctx: &mut C,
    arg0: &FcmpCondResult,
    arg1: &TrapCode,
) -> SideEffectNoResult {
    match arg0 {
        &FcmpCondResult::Condition {
            producer: ref v1,
            cc: ref v2,
        } => {
            let v4 = &constructor_trap_if(ctx, v2, arg1);
            let v5 = &constructor_with_flags_side_effect(ctx, v1, v4);
            // Rule at src/isa/x64/inst.isle line 4543.
            return v5.clone();
        }
        &FcmpCondResult::AndCondition {
            producer: ref v6,
            cc1: ref v7,
            cc2: ref v8,
        } => {
            let v9 = &constructor_trap_if_and(ctx, v7, v8, arg1);
            let v10 = &constructor_with_flags_side_effect(ctx, v6, v9);
            // Rule at src/isa/x64/inst.isle line 4545.
            return v10.clone();
        }
        &FcmpCondResult::OrCondition {
            producer: ref v11,
            cc1: ref v12,
            cc2: ref v13,
        } => {
            let v14 = &constructor_trap_if_or(ctx, v12, v13, arg1);
            let v15 = &constructor_with_flags_side_effect(ctx, v11, v14);
            // Rule at src/isa/x64/inst.isle line 4547.
            return v15.clone();
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "trap_if_fcmp", "src/isa/x64/inst.isle line 4542"
    )
}

// Generated as internal constructor for term x64_movddup.
pub fn constructor_x64_movddup<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovddup, arg0);
        // Rule at src/isa/x64/inst.isle line 4554.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movddup, arg0);
    // Rule at src/isa/x64/inst.isle line 4552.
    return v2;
}

// Generated as internal constructor for term x64_vpbroadcastb.
pub fn constructor_x64_vpbroadcastb<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpbroadcastb, arg0);
    // Rule at src/isa/x64/inst.isle line 4560.
    return v2;
}

// Generated as internal constructor for term x64_vpbroadcastw.
pub fn constructor_x64_vpbroadcastw<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpbroadcastw, arg0);
    // Rule at src/isa/x64/inst.isle line 4565.
    return v2;
}

// Generated as internal constructor for term x64_vpbroadcastd.
pub fn constructor_x64_vpbroadcastd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpbroadcastd, arg0);
    // Rule at src/isa/x64/inst.isle line 4570.
    return v2;
}

// Generated as internal constructor for term x64_vbroadcastss.
pub fn constructor_x64_vbroadcastss<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vbroadcastss, arg0);
    // Rule at src/isa/x64/inst.isle line 4575.
    return v2;
}

// Generated as internal constructor for term jmp_known.
pub fn constructor_jmp_known<C: Context>(ctx: &mut C, arg0: MachLabel) -> SideEffectNoResult {
    let v1 = MInst::JmpKnown { dst: arg0 };
    let v2 = SideEffectNoResult::Inst { inst: v1 };
    // Rule at src/isa/x64/inst.isle line 4582.
    return v2;
}

// Generated as internal constructor for term jmp_if.
pub fn constructor_jmp_if<C: Context>(ctx: &mut C, arg0: &CC, arg1: MachLabel) -> ConsumesFlags {
    let v2 = MInst::JmpIf {
        cc: arg0.clone(),
        taken: arg1,
    };
    let v3 = ConsumesFlags::ConsumesFlagsSideEffect { inst: v2 };
    // Rule at src/isa/x64/inst.isle line 4586.
    return v3;
}

// Generated as internal constructor for term jmp_cond.
pub fn constructor_jmp_cond<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: MachLabel,
    arg2: MachLabel,
) -> ConsumesFlags {
    let v3 = MInst::JmpCond {
        cc: arg0.clone(),
        taken: arg1,
        not_taken: arg2,
    };
    let v4 = ConsumesFlags::ConsumesFlagsSideEffect { inst: v3 };
    // Rule at src/isa/x64/inst.isle line 4591.
    return v4;
}

// Generated as internal constructor for term jmp_cond_icmp.
pub fn constructor_jmp_cond_icmp<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
    arg1: MachLabel,
    arg2: MachLabel,
) -> SideEffectNoResult {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0
    {
        let v5 = &constructor_jmp_cond(ctx, v2, arg1, arg2);
        let v6 = &constructor_with_flags_side_effect(ctx, v1, v5);
        // Rule at src/isa/x64/inst.isle line 4596.
        return v6.clone();
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "jmp_cond_icmp", "src/isa/x64/inst.isle line 4595"
    )
}

// Generated as internal constructor for term jmp_cond_fcmp.
pub fn constructor_jmp_cond_fcmp<C: Context>(
    ctx: &mut C,
    arg0: &FcmpCondResult,
    arg1: MachLabel,
    arg2: MachLabel,
) -> SideEffectNoResult {
    match arg0 {
        &FcmpCondResult::Condition {
            producer: ref v1,
            cc: ref v2,
        } => {
            let v5 = &constructor_jmp_cond(ctx, v2, arg1, arg2);
            let v6 = &constructor_with_flags_side_effect(ctx, v1, v5);
            // Rule at src/isa/x64/inst.isle line 4601.
            return v6.clone();
        }
        &FcmpCondResult::AndCondition {
            producer: ref v7,
            cc1: ref v8,
            cc2: ref v9,
        } => {
            let v10 = &C::cc_invert(ctx, v8);
            let v11 = &constructor_jmp_if(ctx, v10, arg2);
            let v12 = &C::cc_invert(ctx, v9);
            let v13 = &constructor_jmp_cond(ctx, v12, arg2, arg1);
            let v14 = &constructor_consumes_flags_concat(ctx, v11, v13);
            let v15 = &constructor_with_flags_side_effect(ctx, v7, v14);
            // Rule at src/isa/x64/inst.isle line 4603.
            return v15.clone();
        }
        &FcmpCondResult::OrCondition {
            producer: ref v16,
            cc1: ref v17,
            cc2: ref v18,
        } => {
            let v19 = &constructor_jmp_if(ctx, v17, arg1);
            let v20 = &constructor_jmp_cond(ctx, v18, arg1, arg2);
            let v21 = &constructor_consumes_flags_concat(ctx, v19, v20);
            let v22 = &constructor_with_flags_side_effect(ctx, v16, v21);
            // Rule at src/isa/x64/inst.isle line 4608.
            return v22.clone();
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "jmp_cond_fcmp", "src/isa/x64/inst.isle line 4600"
    )
}

// Generated as internal constructor for term jmp_table_seq.
pub fn constructor_jmp_table_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: MachLabel,
    arg3: &BoxVecMachLabel,
) -> SideEffectNoResult {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = C::gpr_to_reg(ctx, arg1);
    let v7 = C::writable_gpr_to_reg(ctx, v4);
    let v8 = C::writable_gpr_to_reg(ctx, v5);
    let v9 = MInst::JmpTableSeq {
        idx: v6,
        tmp1: v7,
        tmp2: v8,
        default_target: arg2,
        targets: arg3.clone(),
    };
    let v10 = SideEffectNoResult::Inst { inst: v9 };
    // Rule at src/isa/x64/inst.isle line 4628.
    return v10;
}

// Generated as internal constructor for term icmp_cond_result.
pub fn constructor_icmp_cond_result<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &CC,
) -> IcmpCondResult {
    let v2 = IcmpCondResult::Condition {
        producer: arg0.clone(),
        cc: arg1.clone(),
    };
    // Rule at src/isa/x64/inst.isle line 4647.
    return v2;
}

// Generated as internal constructor for term invert_icmp_cond_result.
pub fn constructor_invert_icmp_cond_result<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
) -> IcmpCondResult {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0
    {
        let v3 = &C::cc_invert(ctx, v2);
        let v4 = &constructor_icmp_cond_result(ctx, v1, v3);
        // Rule at src/isa/x64/inst.isle line 4650.
        return v4.clone();
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "invert_icmp_cond_result", "src/isa/x64/inst.isle line 4649"
    )
}

// Generated as internal constructor for term lower_icmp_bool.
pub fn constructor_lower_icmp_bool<C: Context>(ctx: &mut C, arg0: &IcmpCondResult) -> ValueRegs {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0
    {
        let v3 = &constructor_x64_setcc(ctx, v2);
        let v4 = constructor_with_flags(ctx, v1, v3);
        // Rule at src/isa/x64/inst.isle line 4655.
        return v4;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "lower_icmp_bool", "src/isa/x64/inst.isle line 4654"
    )
}

// Generated as internal constructor for term select_icmp.
pub fn constructor_select_icmp<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
    arg1: Value,
    arg2: Value,
) -> ValueRegs {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0
    {
        let v4 = C::value_type(ctx, arg1);
        let v5 = &C::type_register_class(ctx, v4);
        if let Some(v6) = v5 {
            if let &RegisterClass::Gpr {
                single_register: v7,
            } = v6
            {
                if v7 == true {
                    let v9 = constructor_put_in_gpr(ctx, arg1);
                    let v10 = &C::gpr_to_gpr_mem(ctx, v9);
                    let v11 = constructor_put_in_gpr(ctx, arg2);
                    let v12 = &constructor_cmove(ctx, v4, v2, v10, v11);
                    let v13 = constructor_with_flags(ctx, v1, v12);
                    // Rule at src/isa/x64/inst.isle line 4664.
                    return v13;
                }
            }
        }
        let v14 = &constructor_cmove_from_values(ctx, v4, v2, arg1, arg2);
        let v15 = constructor_with_flags(ctx, v1, v14);
        // Rule at src/isa/x64/inst.isle line 4668.
        return v15;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "select_icmp", "src/isa/x64/inst.isle line 4659"
    )
}

// Generated as internal constructor for term emit_cmp.
pub fn constructor_emit_cmp<C: Context>(
    ctx: &mut C,
    arg0: &IntCC,
    arg1: Value,
    arg2: Value,
) -> IcmpCondResult {
    let v2 = C::value_type(ctx, arg1);
    if v2 == I128 {
        match arg0 {
            &IntCC::Equal => {
                let v44 = C::put_in_regs(ctx, arg1);
                let v46 = constructor_value_regs_get_gpr(ctx, v44, 0x0);
                let v47 = C::put_in_regs(ctx, arg1);
                let v49 = constructor_value_regs_get_gpr(ctx, v47, 0x1);
                let v50 = C::put_in_regs(ctx, arg2);
                let v51 = constructor_value_regs_get_gpr(ctx, v50, 0x0);
                let v52 = C::put_in_regs(ctx, arg2);
                let v53 = constructor_value_regs_get_gpr(ctx, v52, 0x1);
                let v55 = &C::gpr_to_gpr_mem_imm(ctx, v51);
                let v56 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v55, v46);
                let v58 = &constructor_x64_setcc(ctx, &CC::Z);
                let v59 = constructor_with_flags_reg(ctx, v56, v58);
                let v60 = &C::gpr_to_gpr_mem_imm(ctx, v53);
                let v61 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v60, v49);
                let v62 = &constructor_x64_setcc(ctx, &CC::Z);
                let v63 = constructor_with_flags_reg(ctx, v61, v62);
                let v65 = C::gpr_new(ctx, v59);
                let v66 = &constructor_reg_to_gpr_mem_imm(ctx, v63);
                let v67 = constructor_x64_and(ctx, I64, v65, v66);
                let v68 = C::gpr_to_reg(ctx, v67);
                let v70 = RegMemImm::Imm { simm32: 0x1 };
                let v71 = &C::gpr_mem_imm_new(ctx, &v70);
                let v72 = C::gpr_new(ctx, v68);
                let v73 = &constructor_x64_test(ctx, &OperandSize::Size64, v71, v72);
                let v75 = &constructor_icmp_cond_result(ctx, v73, &CC::NZ);
                // Rule at src/isa/x64/inst.isle line 4700.
                return v75.clone();
            }
            &IntCC::NotEqual => {
                let v44 = C::put_in_regs(ctx, arg1);
                let v46 = constructor_value_regs_get_gpr(ctx, v44, 0x0);
                let v47 = C::put_in_regs(ctx, arg1);
                let v49 = constructor_value_regs_get_gpr(ctx, v47, 0x1);
                let v50 = C::put_in_regs(ctx, arg2);
                let v51 = constructor_value_regs_get_gpr(ctx, v50, 0x0);
                let v52 = C::put_in_regs(ctx, arg2);
                let v53 = constructor_value_regs_get_gpr(ctx, v52, 0x1);
                let v55 = &C::gpr_to_gpr_mem_imm(ctx, v51);
                let v56 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v55, v46);
                let v76 = &constructor_x64_setcc(ctx, &CC::NZ);
                let v77 = constructor_with_flags_reg(ctx, v56, v76);
                let v60 = &C::gpr_to_gpr_mem_imm(ctx, v53);
                let v61 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v60, v49);
                let v78 = &constructor_x64_setcc(ctx, &CC::NZ);
                let v79 = constructor_with_flags_reg(ctx, v61, v78);
                let v80 = C::gpr_new(ctx, v77);
                let v81 = &constructor_reg_to_gpr_mem_imm(ctx, v79);
                let v82 = constructor_x64_or(ctx, I64, v80, v81);
                let v83 = C::gpr_to_reg(ctx, v82);
                let v70 = RegMemImm::Imm { simm32: 0x1 };
                let v71 = &C::gpr_mem_imm_new(ctx, &v70);
                let v84 = C::gpr_new(ctx, v83);
                let v85 = &constructor_x64_test(ctx, &OperandSize::Size64, v71, v84);
                let v86 = &constructor_icmp_cond_result(ctx, v85, &CC::NZ);
                // Rule at src/isa/x64/inst.isle line 4721.
                return v86.clone();
            }
            _ => {}
        }
        let v44 = C::put_in_regs(ctx, arg1);
        let v46 = constructor_value_regs_get_gpr(ctx, v44, 0x0);
        let v47 = C::put_in_regs(ctx, arg1);
        let v49 = constructor_value_regs_get_gpr(ctx, v47, 0x1);
        let v50 = C::put_in_regs(ctx, arg2);
        let v51 = constructor_value_regs_get_gpr(ctx, v50, 0x0);
        let v52 = C::put_in_regs(ctx, arg2);
        let v53 = constructor_value_regs_get_gpr(ctx, v52, 0x1);
        let v87 = &C::gpr_to_gpr_mem_imm(ctx, v53);
        let v88 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v87, v49);
        let v89 = &C::intcc_without_eq(ctx, arg0);
        let v90 = &C::intcc_to_cc(ctx, v89);
        let v91 = &constructor_x64_setcc(ctx, v90);
        let v92 = &constructor_x64_setcc(ctx, &CC::Z);
        let v93 = &constructor_consumes_flags_concat(ctx, v91, v92);
        let v94 = constructor_with_flags(ctx, v88, v93);
        let v95 = C::value_regs_get(ctx, v94, 0x0);
        let v96 = C::value_regs_get(ctx, v94, 0x1);
        let v97 = &C::gpr_to_gpr_mem_imm(ctx, v51);
        let v98 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v97, v46);
        let v99 = &C::intcc_unsigned(ctx, arg0);
        let v100 = &C::intcc_to_cc(ctx, v99);
        let v101 = &constructor_x64_setcc(ctx, v100);
        let v102 = constructor_with_flags_reg(ctx, v98, v101);
        let v103 = C::gpr_new(ctx, v96);
        let v104 = &constructor_reg_to_gpr_mem_imm(ctx, v102);
        let v105 = constructor_x64_and(ctx, I64, v103, v104);
        let v106 = C::gpr_to_reg(ctx, v105);
        let v107 = C::gpr_new(ctx, v95);
        let v108 = &constructor_reg_to_gpr_mem_imm(ctx, v106);
        let v109 = constructor_x64_or(ctx, I64, v107, v108);
        let v110 = C::gpr_to_reg(ctx, v109);
        let v70 = RegMemImm::Imm { simm32: 0x1 };
        let v111 = &C::gpr_mem_imm_new(ctx, &v70);
        let v112 = C::gpr_new(ctx, v110);
        let v113 = &constructor_x64_test(ctx, &OperandSize::Size64, v111, v112);
        let v114 = &constructor_icmp_cond_result(ctx, v113, &CC::NZ);
        // Rule at src/isa/x64/inst.isle line 4736.
        return v114.clone();
    }
    let v29 = C::def_inst(ctx, arg1);
    if let Some(v30) = v29 {
        let v31 = &C::inst_data(ctx, v30);
        if let &InstructionData::UnaryImm {
            opcode: ref v32,
            imm: v33,
        } = v31
        {
            if let &Opcode::Iconst = v32 {
                let v34 = C::u64_from_imm64(ctx, v33);
                if v34 == 0x0 {
                    let v35 = C::value_type(ctx, arg2);
                    let v36 = &C::raw_operand_size_of_type(ctx, v35);
                    let v37 = C::put_in_reg(ctx, arg2);
                    let v38 = C::gpr_new(ctx, v37);
                    let v39 = &C::gpr_to_gpr_mem_imm(ctx, v38);
                    let v40 = &constructor_x64_test(ctx, v36, v39, v38);
                    let v41 = &C::intcc_swap_args(ctx, arg0);
                    let v42 = &C::intcc_to_cc(ctx, v41);
                    let v43 = &constructor_icmp_cond_result(ctx, v40, v42);
                    // Rule at src/isa/x64/inst.isle line 4693.
                    return v43.clone();
                }
            }
        }
    }
    let v17 = C::def_inst(ctx, arg2);
    if let Some(v18) = v17 {
        let v19 = &C::inst_data(ctx, v18);
        if let &InstructionData::UnaryImm {
            opcode: ref v20,
            imm: v21,
        } = v19
        {
            if let &Opcode::Iconst = v20 {
                let v22 = C::u64_from_imm64(ctx, v21);
                if v22 == 0x0 {
                    let v4 = &C::raw_operand_size_of_type(ctx, v2);
                    let v23 = C::put_in_reg(ctx, arg1);
                    let v24 = C::gpr_new(ctx, v23);
                    let v25 = &C::gpr_to_gpr_mem_imm(ctx, v24);
                    let v26 = &constructor_x64_test(ctx, v4, v25, v24);
                    let v27 = &C::intcc_to_cc(ctx, arg0);
                    let v28 = &constructor_icmp_cond_result(ctx, v26, v27);
                    // Rule at src/isa/x64/inst.isle line 4688.
                    return v28.clone();
                }
            }
        }
    }
    let v10 = &C::simm32_from_value(ctx, arg1);
    if let Some(v11) = v10 {
        let v4 = &C::raw_operand_size_of_type(ctx, v2);
        let v12 = constructor_put_in_gpr(ctx, arg2);
        let v13 = &constructor_x64_cmp(ctx, v4, v11, v12);
        let v14 = &C::intcc_swap_args(ctx, arg0);
        let v15 = &C::intcc_to_cc(ctx, v14);
        let v16 = &constructor_icmp_cond_result(ctx, v13, v15);
        // Rule at src/isa/x64/inst.isle line 4683.
        return v16.clone();
    }
    let v4 = &C::raw_operand_size_of_type(ctx, v2);
    let v5 = &constructor_put_in_gpr_mem_imm(ctx, arg2);
    let v6 = constructor_put_in_gpr(ctx, arg1);
    let v7 = &constructor_x64_cmp(ctx, v4, v5, v6);
    let v8 = &C::intcc_to_cc(ctx, arg0);
    let v9 = &constructor_icmp_cond_result(ctx, v7, v8);
    // Rule at src/isa/x64/inst.isle line 4676.
    return v9.clone();
}

// Generated as internal constructor for term lower_fcmp_bool.
pub fn constructor_lower_fcmp_bool<C: Context>(ctx: &mut C, arg0: &FcmpCondResult) -> ValueRegs {
    match arg0 {
        &FcmpCondResult::Condition {
            producer: ref v1,
            cc: ref v2,
        } => {
            let v3 = &constructor_x64_setcc(ctx, v2);
            let v4 = constructor_with_flags(ctx, v1, v3);
            // Rule at src/isa/x64/inst.isle line 4771.
            return v4;
        }
        &FcmpCondResult::AndCondition {
            producer: ref v5,
            cc1: ref v6,
            cc2: ref v7,
        } => {
            let v8 = &constructor_x64_setcc(ctx, v6);
            let v9 = &constructor_x64_setcc(ctx, v7);
            let v10 = &constructor_consumes_flags_concat(ctx, v8, v9);
            let v11 = constructor_with_flags(ctx, v5, v10);
            let v13 = constructor_value_regs_get_gpr(ctx, v11, 0x0);
            let v15 = constructor_value_regs_get_gpr(ctx, v11, 0x1);
            let v17 = &C::gpr_to_gpr_mem_imm(ctx, v15);
            let v18 = constructor_x64_and(ctx, I8, v13, v17);
            let v19 = C::gpr_to_reg(ctx, v18);
            let v20 = C::value_reg(ctx, v19);
            // Rule at src/isa/x64/inst.isle line 4774.
            return v20;
        }
        &FcmpCondResult::OrCondition {
            producer: ref v21,
            cc1: ref v22,
            cc2: ref v23,
        } => {
            let v24 = &constructor_x64_setcc(ctx, v22);
            let v25 = &constructor_x64_setcc(ctx, v23);
            let v26 = &constructor_consumes_flags_concat(ctx, v24, v25);
            let v27 = constructor_with_flags(ctx, v21, v26);
            let v28 = constructor_value_regs_get_gpr(ctx, v27, 0x0);
            let v29 = constructor_value_regs_get_gpr(ctx, v27, 0x1);
            let v30 = &C::gpr_to_gpr_mem_imm(ctx, v29);
            let v31 = constructor_x64_or(ctx, I8, v28, v30);
            let v32 = C::gpr_to_reg(ctx, v31);
            let v33 = C::value_reg(ctx, v32);
            // Rule at src/isa/x64/inst.isle line 4783.
            return v33;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "lower_fcmp_bool", "src/isa/x64/inst.isle line 4769"
    )
}

// Generated as internal constructor for term emit_fcmp.
pub fn constructor_emit_fcmp<C: Context>(
    ctx: &mut C,
    arg0: &FloatCC,
    arg1: Value,
    arg2: Value,
) -> FcmpCondResult {
    match arg0 {
        &FloatCC::Equal => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v9 = FcmpCondResult::AndCondition {
                    producer: v6.clone(),
                    cc1: CC::NP,
                    cc2: CC::Z,
                };
                // Rule at src/isa/x64/inst.isle line 4810.
                return v9;
            }
        }
        &FloatCC::GreaterThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v18 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::NBE,
                };
                // Rule at src/isa/x64/inst.isle line 4826.
                return v18;
            }
        }
        &FloatCC::GreaterThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v20 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::NB,
                };
                // Rule at src/isa/x64/inst.isle line 4828.
                return v20;
            }
        }
        &FloatCC::LessThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v25 = &constructor_x64_ucomis(ctx, arg1, arg2);
                let v26 = FcmpCondResult::Condition {
                    producer: v25.clone(),
                    cc: CC::NBE,
                };
                // Rule at src/isa/x64/inst.isle line 4838.
                return v26;
            }
        }
        &FloatCC::LessThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v25 = &constructor_x64_ucomis(ctx, arg1, arg2);
                let v27 = FcmpCondResult::Condition {
                    producer: v25.clone(),
                    cc: CC::NB,
                };
                // Rule at src/isa/x64/inst.isle line 4841.
                return v27;
            }
        }
        &FloatCC::NotEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v12 = FcmpCondResult::OrCondition {
                    producer: v6.clone(),
                    cc1: CC::P,
                    cc2: CC::NZ,
                };
                // Rule at src/isa/x64/inst.isle line 4813.
                return v12;
            }
        }
        &FloatCC::Ordered => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v13 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::NP,
                };
                // Rule at src/isa/x64/inst.isle line 4818.
                return v13;
            }
        }
        &FloatCC::OrderedNotEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v15 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::NZ,
                };
                // Rule at src/isa/x64/inst.isle line 4822.
                return v15;
            }
        }
        &FloatCC::Unordered => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v14 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::P,
                };
                // Rule at src/isa/x64/inst.isle line 4820.
                return v14;
            }
        }
        &FloatCC::UnorderedOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v16 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::Z,
                };
                // Rule at src/isa/x64/inst.isle line 4824.
                return v16;
            }
        }
        &FloatCC::UnorderedOrGreaterThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v25 = &constructor_x64_ucomis(ctx, arg1, arg2);
                let v28 = FcmpCondResult::Condition {
                    producer: v25.clone(),
                    cc: CC::B,
                };
                // Rule at src/isa/x64/inst.isle line 4844.
                return v28;
            }
        }
        &FloatCC::UnorderedOrGreaterThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v25 = &constructor_x64_ucomis(ctx, arg1, arg2);
                let v29 = FcmpCondResult::Condition {
                    producer: v25.clone(),
                    cc: CC::BE,
                };
                // Rule at src/isa/x64/inst.isle line 4847.
                return v29;
            }
        }
        &FloatCC::UnorderedOrLessThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v22 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::B,
                };
                // Rule at src/isa/x64/inst.isle line 4830.
                return v22;
            }
        }
        &FloatCC::UnorderedOrLessThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = &constructor_x64_ucomis(ctx, arg2, arg1);
                let v24 = FcmpCondResult::Condition {
                    producer: v6.clone(),
                    cc: CC::BE,
                };
                // Rule at src/isa/x64/inst.isle line 4832.
                return v24;
            }
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "emit_fcmp", "src/isa/x64/inst.isle line 4808"
    )
}

// Generated as internal constructor for term x64_mfence.
pub fn constructor_x64_mfence<C: Context>(ctx: &mut C) -> SideEffectNoResult {
    let v1 = MInst::Fence {
        kind: FenceKind::MFence,
    };
    let v2 = SideEffectNoResult::Inst { inst: v1 };
    // Rule at src/isa/x64/inst.isle line 4860.
    return v2;
}

// Generated as internal constructor for term x64_cmpxchg.
pub fn constructor_x64_cmpxchg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: Gpr,
    arg3: &SyntheticAmode,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::gpr_to_reg(ctx, arg2);
    let v6 = C::gpr_to_reg(ctx, arg1);
    let v7 = C::writable_gpr_to_reg(ctx, v4);
    let v8 = MInst::LockCmpxchg {
        ty: arg0,
        replacement: v5,
        expected: v6,
        mem: arg3.clone(),
        dst_old: v7,
    };
    let v9 = C::emit(ctx, &v8);
    let v10 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 4864.
    return v10;
}

// Generated as internal constructor for term x64_atomic_rmw_seq.
pub fn constructor_x64_atomic_rmw_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &MachAtomicRmwOp,
    arg2: &SyntheticAmode,
    arg3: Gpr,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = C::gpr_to_reg(ctx, arg3);
    let v7 = C::writable_gpr_to_reg(ctx, v5);
    let v8 = C::writable_gpr_to_reg(ctx, v4);
    let v9 = MInst::AtomicRmwSeq {
        ty: arg0,
        op: arg1.clone(),
        mem: arg2.clone(),
        operand: v6,
        temp: v7,
        dst_old: v8,
    };
    let v10 = C::emit(ctx, &v9);
    let v11 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 4870.
    return v11;
}

// Generated as internal constructor for term bitcast_xmm_to_gpr.
pub fn constructor_bitcast_xmm_to_gpr<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm) -> Gpr {
    match arg0 {
        F32 => {
            let v2 = constructor_x64_movd_to_gpr(ctx, arg1);
            // Rule at src/isa/x64/inst.isle line 4885.
            return v2;
        }
        F64 => {
            let v3 = constructor_x64_movq_to_gpr(ctx, arg1);
            // Rule at src/isa/x64/inst.isle line 4887.
            return v3;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "bitcast_xmm_to_gpr", "src/isa/x64/inst.isle line 4884"
    )
}

// Generated as internal constructor for term bitcast_gpr_to_xmm.
pub fn constructor_bitcast_gpr_to_xmm<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Xmm {
    match arg0 {
        I32 => {
            let v2 = &C::gpr_to_gpr_mem(ctx, arg1);
            let v3 = constructor_x64_movd_to_xmm(ctx, v2);
            // Rule at src/isa/x64/inst.isle line 4891.
            return v3;
        }
        I64 => {
            let v2 = &C::gpr_to_gpr_mem(ctx, arg1);
            let v4 = constructor_x64_movq_to_xmm(ctx, v2);
            // Rule at src/isa/x64/inst.isle line 4893.
            return v4;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "bitcast_gpr_to_xmm", "src/isa/x64/inst.isle line 4890"
    )
}

// Generated as internal constructor for term stack_addr_impl.
pub fn constructor_stack_addr_impl<C: Context>(
    ctx: &mut C,
    arg0: StackSlot,
    arg1: Offset32,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = C::writable_gpr_to_reg(ctx, v2);
    let v4 = &C::abi_stackslot_addr(ctx, v3, arg0, arg1);
    let v5 = C::emit(ctx, v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4899.
    return v6;
}

// Generated as internal constructor for term x64_checked_srem_seq.
pub fn constructor_x64_checked_srem_seq<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Gpr,
    arg2: Gpr,
    arg3: Gpr,
) -> ValueRegs {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = MInst::CheckedSRemSeq {
        size: arg0.clone(),
        dividend_lo: arg1,
        dividend_hi: arg2,
        divisor: arg3,
        dst_quotient: v4,
        dst_remainder: v5,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = constructor_writable_gpr_to_r_reg(ctx, v4);
    let v9 = constructor_writable_gpr_to_r_reg(ctx, v5);
    let v10 = C::value_regs(ctx, v8, v9);
    // Rule at src/isa/x64/inst.isle line 4908.
    return v10;
}

// Generated as internal constructor for term x64_checked_srem_seq8.
pub fn constructor_x64_checked_srem_seq8<C: Context>(ctx: &mut C, arg0: Gpr, arg1: Gpr) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::CheckedSRemSeq8 {
        dividend: arg0,
        divisor: arg1,
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4915.
    return v5;
}

// Generated as internal constructor for term x64_div8.
pub fn constructor_x64_div8<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: &GprMem,
    arg2: &DivSignedness,
    arg3: &TrapCode,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = MInst::Div8 {
        sign: arg2.clone(),
        trap: arg3.clone(),
        divisor: arg1.clone(),
        dividend: arg0,
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 4922.
    return v7;
}

// Generated as internal constructor for term x64_div.
pub fn constructor_x64_div<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
    arg2: &GprMem,
    arg3: &OperandSize,
    arg4: &DivSignedness,
    arg5: &TrapCode,
) -> ValueRegs {
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = C::temp_writable_gpr(ctx);
    let v8 = MInst::Div {
        size: arg3.clone(),
        sign: arg4.clone(),
        trap: arg5.clone(),
        divisor: arg2.clone(),
        dividend_lo: arg0,
        dividend_hi: arg1,
        dst_quotient: v6,
        dst_remainder: v7,
    };
    let v9 = C::emit(ctx, &v8);
    let v10 = constructor_writable_gpr_to_r_reg(ctx, v6);
    let v11 = constructor_writable_gpr_to_r_reg(ctx, v7);
    let v12 = C::value_regs(ctx, v10, v11);
    // Rule at src/isa/x64/inst.isle line 4932.
    return v12;
}

// Generated as internal constructor for term x64_div_quotient.
pub fn constructor_x64_div_quotient<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
    arg2: &GprMem,
    arg3: &OperandSize,
    arg4: &DivSignedness,
    arg5: &TrapCode,
) -> ValueRegs {
    let v6 = constructor_x64_div(ctx, arg0, arg1, arg2, arg3, arg4, arg5);
    let v8 = C::value_regs_get(ctx, v6, 0x0);
    let v9 = C::value_reg(ctx, v8);
    // Rule at src/isa/x64/inst.isle line 4940.
    return v9;
}

// Generated as internal constructor for term x64_div_remainder.
pub fn constructor_x64_div_remainder<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
    arg2: &GprMem,
    arg3: &OperandSize,
    arg4: &DivSignedness,
    arg5: &TrapCode,
) -> ValueRegs {
    let v6 = constructor_x64_div(ctx, arg0, arg1, arg2, arg3, arg4, arg5);
    let v8 = C::value_regs_get(ctx, v6, 0x1);
    let v9 = C::value_reg(ctx, v8);
    // Rule at src/isa/x64/inst.isle line 4945.
    return v9;
}

// Generated as internal constructor for term x64_sign_extend_data.
pub fn constructor_x64_sign_extend_data<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: &OperandSize,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::SignExtendData {
        size: arg1.clone(),
        src: arg0,
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4950.
    return v5;
}

// Generated as internal constructor for term read_pinned_gpr.
pub fn constructor_read_pinned_gpr<C: Context>(ctx: &mut C) -> Gpr {
    let v0 = C::preg_pinned(ctx);
    let v1 = constructor_mov_from_preg(ctx, v0);
    let v2 = C::gpr_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 4958.
    return v2;
}

// Generated as internal constructor for term write_pinned_gpr.
pub fn constructor_write_pinned_gpr<C: Context>(ctx: &mut C, arg0: Gpr) -> SideEffectNoResult {
    let v1 = C::preg_pinned(ctx);
    let v2 = &constructor_mov_to_preg(ctx, v1, arg0);
    // Rule at src/isa/x64/inst.isle line 4962.
    return v2.clone();
}

// Generated as internal constructor for term elf_tls_get_addr.
pub fn constructor_elf_tls_get_addr<C: Context>(ctx: &mut C, arg0: ExternalName) -> Gpr {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::ElfTlsGetAddr {
        symbol: arg0,
        dst: v1,
    };
    let v3 = C::emit(ctx, &v2);
    let v4 = C::writable_gpr_to_gpr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5004.
    return v4;
}

// Generated as internal constructor for term macho_tls_get_addr.
pub fn constructor_macho_tls_get_addr<C: Context>(ctx: &mut C, arg0: ExternalName) -> Gpr {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::MachOTlsGetAddr {
        symbol: arg0,
        dst: v1,
    };
    let v3 = C::emit(ctx, &v2);
    let v4 = C::writable_gpr_to_gpr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5011.
    return v4;
}

// Generated as internal constructor for term coff_tls_get_addr.
pub fn constructor_coff_tls_get_addr<C: Context>(ctx: &mut C, arg0: ExternalName) -> Gpr {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::CoffTlsGetAddr {
        symbol: arg0,
        dst: v1,
        tmp: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5018.
    return v5;
}

// Generated as internal constructor for term reg_to_xmm_mem.
pub fn constructor_reg_to_xmm_mem<C: Context>(ctx: &mut C, arg0: Reg) -> XmmMem {
    let v1 = C::xmm_new(ctx, arg0);
    let v2 = &C::xmm_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5105.
    return v2.clone();
}

// Generated as internal constructor for term xmm_to_reg_mem.
pub fn constructor_xmm_to_reg_mem<C: Context>(ctx: &mut C, arg0: Reg) -> XmmMem {
    let v1 = C::xmm_new(ctx, arg0);
    let v2 = C::xmm_to_reg(ctx, v1);
    let v3 = RegMem::Reg { reg: v2 };
    let v4 = &C::reg_mem_to_xmm_mem(ctx, &v3);
    // Rule at src/isa/x64/inst.isle line 5108.
    return v4.clone();
}

// Generated as internal constructor for term writable_gpr_to_r_reg.
pub fn constructor_writable_gpr_to_r_reg<C: Context>(ctx: &mut C, arg0: WritableGpr) -> Reg {
    let v1 = C::writable_gpr_to_reg(ctx, arg0);
    let v2 = C::writable_reg_to_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5112.
    return v2;
}

// Generated as internal constructor for term writable_gpr_to_gpr_mem.
pub fn constructor_writable_gpr_to_gpr_mem<C: Context>(ctx: &mut C, arg0: WritableGpr) -> GprMem {
    let v1 = C::writable_gpr_to_gpr(ctx, arg0);
    let v2 = &C::gpr_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5115.
    return v2.clone();
}

// Generated as internal constructor for term writable_gpr_to_value_regs.
pub fn constructor_writable_gpr_to_value_regs<C: Context>(
    ctx: &mut C,
    arg0: WritableGpr,
) -> ValueRegs {
    let v1 = constructor_writable_gpr_to_r_reg(ctx, arg0);
    let v2 = C::value_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5118.
    return v2;
}

// Generated as internal constructor for term writable_xmm_to_r_reg.
pub fn constructor_writable_xmm_to_r_reg<C: Context>(ctx: &mut C, arg0: WritableXmm) -> Reg {
    let v1 = C::writable_xmm_to_reg(ctx, arg0);
    let v2 = C::writable_reg_to_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5121.
    return v2;
}

// Generated as internal constructor for term writable_xmm_to_xmm_mem.
pub fn constructor_writable_xmm_to_xmm_mem<C: Context>(ctx: &mut C, arg0: WritableXmm) -> XmmMem {
    let v1 = C::writable_xmm_to_xmm(ctx, arg0);
    let v2 = &C::xmm_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5124.
    return v2.clone();
}

// Generated as internal constructor for term writable_xmm_to_value_regs.
pub fn constructor_writable_xmm_to_value_regs<C: Context>(
    ctx: &mut C,
    arg0: WritableXmm,
) -> ValueRegs {
    let v1 = constructor_writable_xmm_to_r_reg(ctx, arg0);
    let v2 = C::value_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5127.
    return v2;
}

// Generated as internal constructor for term synthetic_amode_to_gpr_mem.
pub fn constructor_synthetic_amode_to_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> GprMem {
    let v1 = &C::synthetic_amode_to_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5134.
    return v2.clone();
}

// Generated as internal constructor for term amode_to_gpr_mem.
pub fn constructor_amode_to_gpr_mem<C: Context>(ctx: &mut C, arg0: &Amode) -> GprMem {
    let v1 = &C::amode_to_synthetic_amode(ctx, arg0);
    let v2 = &constructor_synthetic_amode_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5132.
    return v2.clone();
}

// Generated as internal constructor for term amode_to_xmm_mem.
pub fn constructor_amode_to_xmm_mem<C: Context>(ctx: &mut C, arg0: &Amode) -> XmmMem {
    let v1 = &C::amode_to_synthetic_amode(ctx, arg0);
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5137.
    return v2.clone();
}

// Generated as internal constructor for term synthetic_amode_to_xmm_mem.
pub fn constructor_synthetic_amode_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> XmmMem {
    let v1 = &C::synthetic_amode_to_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5140.
    return v2.clone();
}

// Generated as internal constructor for term const_to_xmm_mem.
pub fn constructor_const_to_xmm_mem<C: Context>(ctx: &mut C, arg0: VCodeConstant) -> XmmMem {
    let v1 = &C::const_to_synthetic_amode(ctx, arg0);
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5145.
    return v2.clone();
}

// Generated as internal constructor for term const_to_reg_mem.
pub fn constructor_const_to_reg_mem<C: Context>(ctx: &mut C, arg0: VCodeConstant) -> RegMem {
    let v1 = &C::const_to_synthetic_amode(ctx, arg0);
    let v2 = RegMem::Mem { addr: v1.clone() };
    // Rule at src/isa/x64/inst.isle line 5147.
    return v2;
}

// Generated as internal constructor for term xmm_to_xmm_mem_aligned.
pub fn constructor_xmm_to_xmm_mem_aligned<C: Context>(ctx: &mut C, arg0: Xmm) -> XmmMemAligned {
    let v1 = &C::xmm_to_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5150.
    return v2.clone();
}

// Generated as internal constructor for term amode_to_xmm_mem_aligned.
pub fn constructor_amode_to_xmm_mem_aligned<C: Context>(
    ctx: &mut C,
    arg0: &Amode,
) -> XmmMemAligned {
    let v1 = &constructor_amode_to_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5152.
    return v2.clone();
}

// Generated as internal constructor for term synthetic_amode_to_xmm_mem_aligned.
pub fn constructor_synthetic_amode_to_xmm_mem_aligned<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> XmmMemAligned {
    let v1 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5154.
    return v2.clone();
}

// Generated as internal constructor for term put_in_xmm_mem_aligned.
pub fn constructor_put_in_xmm_mem_aligned<C: Context>(ctx: &mut C, arg0: Value) -> XmmMemAligned {
    let v1 = &C::put_in_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5156.
    return v2.clone();
}

// Generated as internal constructor for term mov_to_preg.
pub fn constructor_mov_to_preg<C: Context>(
    ctx: &mut C,
    arg0: PReg,
    arg1: Gpr,
) -> SideEffectNoResult {
    let v2 = MInst::MovToPReg {
        src: arg1,
        dst: arg0,
    };
    let v3 = SideEffectNoResult::Inst { inst: v2 };
    // Rule at src/isa/x64/inst.isle line 5159.
    return v3;
}

// Generated as internal constructor for term x64_rbp.
pub fn constructor_x64_rbp<C: Context>(ctx: &mut C) -> Reg {
    let v0 = C::preg_rbp(ctx);
    let v1 = constructor_mov_from_preg(ctx, v0);
    // Rule at src/isa/x64/inst.isle line 5172.
    return v1;
}

// Generated as internal constructor for term x64_rsp.
pub fn constructor_x64_rsp<C: Context>(ctx: &mut C) -> Reg {
    let v0 = C::preg_rsp(ctx);
    let v1 = constructor_mov_from_preg(ctx, v0);
    // Rule at src/isa/x64/inst.isle line 5176.
    return v1;
}

// Generated as internal constructor for term lower.
pub fn constructor_lower<C: Context>(ctx: &mut C, arg0: Inst) -> Option<InstOutput> {
    let v6 = &C::inst_data(ctx, arg0);
    match v6 {
        &InstructionData::AtomicCas {
            opcode: ref v1728,
            args: ref v1729,
            flags: v1730,
        } => {
            if let &Opcode::AtomicCas = v1728 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v3 = C::value_type(ctx, v2);
                    let v4 = C::fits_in_64(ctx, v3);
                    if let Some(v5) = v4 {
                        let v1703 = C::ty_int(ctx, v3);
                        if let Some(v1704) = v1703 {
                            let v1731 = C::unpack_value_array_3(ctx, v1729);
                            let v1735 = constructor_put_in_gpr(ctx, v1731.1);
                            let v1736 = constructor_put_in_gpr(ctx, v1731.2);
                            let v1737 = C::zero_offset(ctx);
                            let v1738 = &constructor_to_amode(ctx, v1730, v1731.0, v1737);
                            let v1739 = &C::amode_to_synthetic_amode(ctx, v1738);
                            let v1740 = constructor_x64_cmpxchg(ctx, v5, v1735, v1736, v1739);
                            let v1741 = constructor_output_gpr(ctx, v1740);
                            // Rule at src/isa/x64/lower.isle line 3215.
                            return Some(v1741);
                        }
                    }
                }
            }
        }
        &InstructionData::AtomicRmw {
            opcode: ref v1742,
            args: ref v1743,
            flags: v1744,
            op: ref v1745,
        } => {
            if let &Opcode::AtomicRmw = v1742 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v3 = C::value_type(ctx, v2);
                    let v4 = C::fits_in_64(ctx, v3);
                    if let Some(v5) = v4 {
                        let v1703 = C::ty_int(ctx, v3);
                        if let Some(v1704) = v1703 {
                            let v1749 = &C::atomic_rmw_op_to_mach_atomic_rmw_op(ctx, v1745);
                            let v1705 = C::zero_offset(ctx);
                            let v1746 = C::unpack_value_array_2(ctx, v1743);
                            let v1750 = &constructor_to_amode(ctx, v1744, v1746.0, v1705);
                            let v1751 = &C::amode_to_synthetic_amode(ctx, v1750);
                            let v1752 = constructor_put_in_gpr(ctx, v1746.1);
                            let v1753 =
                                constructor_x64_atomic_rmw_seq(ctx, v5, v1749, v1751, v1752);
                            let v1754 = constructor_output_gpr(ctx, v1753);
                            // Rule at src/isa/x64/lower.isle line 3231.
                            return Some(v1754);
                        }
                    }
                }
            }
        }
        &InstructionData::Binary {
            opcode: ref v36,
            args: ref v37,
        } => {
            match v36 {
                &Opcode::Swizzle => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                    let v2354 = C::emit_u128_le_const(ctx, 0x70707070707070707070707070707070);
                    let v2355 = &constructor_const_to_xmm_mem(ctx, v2354);
                    let v2356 = constructor_x64_paddusb(ctx, v1249, v2355);
                    let v343 = constructor_put_in_xmm(ctx, v38.0);
                    let v2357 = C::xmm_to_reg(ctx, v2356);
                    let v2358 = &constructor_xmm_to_reg_mem(ctx, v2357);
                    let v2359 = &C::xmm_mem_to_reg_mem(ctx, v2358);
                    let v2360 = constructor_lower_pshufb(ctx, v343, v2359);
                    let v2361 = constructor_output_xmm(ctx, v2360);
                    // Rule at src/isa/x64/lower.isle line 4341.
                    return Some(v2361);
                }
                &Opcode::X86Pshufb => {
                    let v525 = C::use_ssse3(ctx);
                    if v525 == true {
                        let v38 = C::unpack_value_array_2(ctx, v37);
                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                        let v2362 = constructor_x64_pshufb(ctx, v68, v69);
                        let v2363 = constructor_output_xmm(ctx, v2362);
                        // Rule at src/isa/x64/lower.isle line 4347.
                        return Some(v2363);
                    }
                }
                &Opcode::Smin => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v740 = C::ty_vec128(ctx, v3);
                        if let Some(v741) = v740 {
                            let v744 = constructor_has_pmins(ctx, v741);
                            if v744 == true {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v745 = constructor_x64_pmins(ctx, v741, v68, v69);
                                let v746 = constructor_output_xmm(ctx, v745);
                                // Rule at src/isa/x64/lower.isle line 1687.
                                return Some(v746);
                            }
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v444 = constructor_put_in_xmm(ctx, v38.1);
                            let v316 = &C::xmm_to_xmm_mem(ctx, v68);
                            let v747 = constructor_x64_pcmpgt(ctx, v741, v444, v316);
                            let v318 = &C::xmm_to_xmm_mem(ctx, v68);
                            let v748 = constructor_x64_pand(ctx, v747, v318);
                            let v449 = &C::xmm_to_xmm_mem(ctx, v444);
                            let v749 = constructor_x64_pandn(ctx, v747, v449);
                            let v750 = &C::xmm_to_xmm_mem(ctx, v749);
                            let v751 = constructor_x64_por(ctx, v748, v750);
                            let v752 = constructor_output_xmm(ctx, v751);
                            // Rule at src/isa/x64/lower.isle line 1691.
                            return Some(v752);
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v735 = constructor_cmp_and_choose(ctx, v5, &CC::L, v38.0, v38.1);
                            let v736 = C::output(ctx, v735);
                            // Rule at src/isa/x64/lower.isle line 1637.
                            return Some(v736);
                        }
                    }
                }
                &Opcode::Umin => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v740 = C::ty_vec128(ctx, v3);
                        if let Some(v741) = v740 {
                            let v774 = constructor_has_pminu(ctx, v741);
                            if v774 == true {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v775 = constructor_x64_pminu(ctx, v741, v68, v69);
                                let v776 = constructor_output_xmm(ctx, v775);
                                // Rule at src/isa/x64/lower.isle line 1739.
                                return Some(v776);
                            }
                        }
                        if v3 == I16X8 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v150 = constructor_x64_psubusw(ctx, v68, v69);
                            let v777 = &C::xmm_to_xmm_mem(ctx, v150);
                            let v778 = constructor_x64_psubw(ctx, v68, v777);
                            let v779 = constructor_output_xmm(ctx, v778);
                            // Rule at src/isa/x64/lower.isle line 1745.
                            return Some(v779);
                        }
                        if let Some(v741) = v740 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v444 = constructor_put_in_xmm(ctx, v38.1);
                            let v760 = constructor_flip_high_bit_mask(ctx, v741);
                            let v761 = &C::xmm_to_xmm_mem(ctx, v760);
                            let v762 = constructor_x64_pxor(ctx, v68, v761);
                            let v763 = &C::xmm_to_xmm_mem(ctx, v760);
                            let v764 = constructor_x64_pxor(ctx, v444, v763);
                            let v780 = &C::xmm_to_xmm_mem(ctx, v762);
                            let v781 = constructor_x64_pcmpgt(ctx, v741, v764, v780);
                            let v767 = &C::xmm_to_xmm_mem(ctx, v68);
                            let v782 = constructor_x64_pand(ctx, v781, v767);
                            let v769 = &C::xmm_to_xmm_mem(ctx, v444);
                            let v783 = constructor_x64_pandn(ctx, v781, v769);
                            let v784 = &C::xmm_to_xmm_mem(ctx, v783);
                            let v785 = constructor_x64_por(ctx, v782, v784);
                            let v786 = constructor_output_xmm(ctx, v785);
                            // Rule at src/isa/x64/lower.isle line 1750.
                            return Some(v786);
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v729 = constructor_cmp_and_choose(ctx, v5, &CC::B, v38.0, v38.1);
                            let v730 = C::output(ctx, v729);
                            // Rule at src/isa/x64/lower.isle line 1631.
                            return Some(v730);
                        }
                    }
                }
                &Opcode::Smax => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v740 = C::ty_vec128(ctx, v3);
                        if let Some(v741) = v740 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v444 = constructor_put_in_xmm(ctx, v38.1);
                            let v742 = constructor_lower_vec_smax(ctx, v741, v68, v444);
                            let v743 = constructor_output_xmm(ctx, v742);
                            // Rule at src/isa/x64/lower.isle line 1667.
                            return Some(v743);
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v738 = constructor_cmp_and_choose(ctx, v5, &CC::NL, v38.0, v38.1);
                            let v739 = C::output(ctx, v738);
                            // Rule at src/isa/x64/lower.isle line 1640.
                            return Some(v739);
                        }
                    }
                }
                &Opcode::Umax => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v740 = C::ty_vec128(ctx, v3);
                        if let Some(v741) = v740 {
                            let v753 = constructor_has_pmaxu(ctx, v741);
                            if v753 == true {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v754 = constructor_x64_pmaxu(ctx, v741, v68, v69);
                                let v755 = constructor_output_xmm(ctx, v754);
                                // Rule at src/isa/x64/lower.isle line 1703.
                                return Some(v755);
                            }
                        }
                        if v3 == I16X8 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v444 = constructor_put_in_xmm(ctx, v38.1);
                            let v316 = &C::xmm_to_xmm_mem(ctx, v68);
                            let v756 = constructor_x64_psubusw(ctx, v444, v316);
                            let v757 = &C::xmm_to_xmm_mem(ctx, v756);
                            let v758 = constructor_x64_paddw(ctx, v68, v757);
                            let v759 = constructor_output_xmm(ctx, v758);
                            // Rule at src/isa/x64/lower.isle line 1709.
                            return Some(v759);
                        }
                        if let Some(v741) = v740 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v444 = constructor_put_in_xmm(ctx, v38.1);
                            let v760 = constructor_flip_high_bit_mask(ctx, v741);
                            let v761 = &C::xmm_to_xmm_mem(ctx, v760);
                            let v762 = constructor_x64_pxor(ctx, v68, v761);
                            let v763 = &C::xmm_to_xmm_mem(ctx, v760);
                            let v764 = constructor_x64_pxor(ctx, v444, v763);
                            let v765 = &C::xmm_to_xmm_mem(ctx, v764);
                            let v766 = constructor_x64_pcmpgt(ctx, v741, v762, v765);
                            let v767 = &C::xmm_to_xmm_mem(ctx, v68);
                            let v768 = constructor_x64_pand(ctx, v766, v767);
                            let v769 = &C::xmm_to_xmm_mem(ctx, v444);
                            let v770 = constructor_x64_pandn(ctx, v766, v769);
                            let v771 = &C::xmm_to_xmm_mem(ctx, v770);
                            let v772 = constructor_x64_por(ctx, v768, v771);
                            let v773 = constructor_output_xmm(ctx, v772);
                            // Rule at src/isa/x64/lower.isle line 1716.
                            return Some(v773);
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v732 = constructor_cmp_and_choose(ctx, v5, &CC::NB, v38.0, v38.1);
                            let v733 = C::output(ctx, v732);
                            // Rule at src/isa/x64/lower.isle line 1634.
                            return Some(v733);
                        }
                    }
                }
                &Opcode::AvgRound => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x8 => {
                                    if v65.1 == 0x10 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v415 = constructor_x64_pavgb(ctx, v68, v69);
                                        let v416 = constructor_output_xmm(ctx, v415);
                                        // Rule at src/isa/x64/lower.isle line 956.
                                        return Some(v416);
                                    }
                                }
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v417 = constructor_x64_pavgw(ctx, v68, v69);
                                        let v418 = constructor_output_xmm(ctx, v417);
                                        // Rule at src/isa/x64/lower.isle line 960.
                                        return Some(v418);
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::UaddSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x8 => {
                                    if v65.1 == 0x10 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v126 = constructor_x64_paddusb(ctx, v68, v69);
                                        let v127 = constructor_output_xmm(ctx, v126);
                                        // Rule at src/isa/x64/lower.isle line 194.
                                        return Some(v127);
                                    }
                                }
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v128 = constructor_x64_paddusw(ctx, v68, v69);
                                        let v129 = constructor_output_xmm(ctx, v128);
                                        // Rule at src/isa/x64/lower.isle line 198.
                                        return Some(v129);
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::SaddSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x8 => {
                                    if v65.1 == 0x10 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v122 = constructor_x64_paddsb(ctx, v68, v69);
                                        let v123 = constructor_output_xmm(ctx, v122);
                                        // Rule at src/isa/x64/lower.isle line 184.
                                        return Some(v123);
                                    }
                                }
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v124 = constructor_x64_paddsw(ctx, v68, v69);
                                        let v125 = constructor_output_xmm(ctx, v124);
                                        // Rule at src/isa/x64/lower.isle line 188.
                                        return Some(v125);
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::UsubSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x8 => {
                                    if v65.1 == 0x10 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v148 = constructor_x64_psubusb(ctx, v68, v69);
                                        let v149 = constructor_output_xmm(ctx, v148);
                                        // Rule at src/isa/x64/lower.isle line 255.
                                        return Some(v149);
                                    }
                                }
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v150 = constructor_x64_psubusw(ctx, v68, v69);
                                        let v151 = constructor_output_xmm(ctx, v150);
                                        // Rule at src/isa/x64/lower.isle line 259.
                                        return Some(v151);
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::SsubSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x8 => {
                                    if v65.1 == 0x10 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v144 = constructor_x64_psubsb(ctx, v68, v69);
                                        let v145 = constructor_output_xmm(ctx, v144);
                                        // Rule at src/isa/x64/lower.isle line 245.
                                        return Some(v145);
                                    }
                                }
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v146 = constructor_x64_psubsw(ctx, v68, v69);
                                        let v147 = constructor_output_xmm(ctx, v146);
                                        // Rule at src/isa/x64/lower.isle line 249.
                                        return Some(v147);
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::Iadd => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v80 = constructor_value_regs_get_gpr(ctx, v78, 0x0);
                            let v82 = constructor_value_regs_get_gpr(ctx, v78, 0x1);
                            let v83 = C::put_in_regs(ctx, v38.1);
                            let v84 = constructor_value_regs_get_gpr(ctx, v83, 0x0);
                            let v85 = constructor_value_regs_get_gpr(ctx, v83, 0x1);
                            let v86 = &C::gpr_to_gpr_mem_imm(ctx, v84);
                            let v87 = &constructor_x64_add_with_flags_paired(ctx, I64, v80, v86);
                            let v88 = &C::gpr_to_gpr_mem_imm(ctx, v85);
                            let v89 = &constructor_x64_adc_paired(ctx, I64, v82, v88);
                            let v90 = constructor_with_flags(ctx, v87, v89);
                            let v91 = C::output(ctx, v90);
                            // Rule at src/isa/x64/lower.isle line 88.
                            return Some(v91);
                        }
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x8 => {
                                    if v65.1 == 0x10 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v70 = constructor_x64_paddb(ctx, v68, v69);
                                        let v71 = constructor_output_xmm(ctx, v70);
                                        // Rule at src/isa/x64/lower.isle line 71.
                                        return Some(v71);
                                    }
                                }
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v72 = constructor_x64_paddw(ctx, v68, v69);
                                        let v73 = constructor_output_xmm(ctx, v72);
                                        // Rule at src/isa/x64/lower.isle line 75.
                                        return Some(v73);
                                    }
                                }
                                0x20 => {
                                    if v65.1 == 0x4 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v74 = constructor_x64_paddd(ctx, v68, v69);
                                        let v75 = constructor_output_xmm(ctx, v74);
                                        // Rule at src/isa/x64/lower.isle line 79.
                                        return Some(v75);
                                    }
                                }
                                0x40 => {
                                    if v65.1 == 0x2 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v76 = constructor_x64_paddq(ctx, v68, v69);
                                        let v77 = constructor_output_xmm(ctx, v76);
                                        // Rule at src/isa/x64/lower.isle line 83.
                                        return Some(v77);
                                    }
                                }
                                _ => {}
                            }
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v58 = &C::sinkable_load(ctx, v38.0);
                            if let Some(v59) = v58 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v61 = &constructor_sink_load_to_gpr_mem_imm(ctx, v59);
                                let v62 = constructor_x64_add(ctx, v5, v60, v61);
                                let v63 = constructor_output_gpr(ctx, v62);
                                // Rule at src/isa/x64/lower.isle line 65.
                                return Some(v63);
                            }
                            let v53 = &C::sinkable_load(ctx, v38.1);
                            if let Some(v54) = v53 {
                                let v41 = constructor_put_in_gpr(ctx, v38.0);
                                let v55 = &constructor_sink_load_to_gpr_mem_imm(ctx, v54);
                                let v56 = constructor_x64_add(ctx, v5, v41, v55);
                                let v57 = constructor_output_gpr(ctx, v56);
                                // Rule at src/isa/x64/lower.isle line 62.
                                return Some(v57);
                            }
                        }
                        let v45 = C::ty_32_or_64(ctx, v3);
                        if let Some(v46) = v45 {
                            let v48 = C::zero_offset(ctx);
                            let v47 = C::mem_flags_trusted(ctx);
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v49 = &constructor_to_amode_add(ctx, v47, v38.0, v38.1, v48);
                            let v50 = &C::amode_to_synthetic_amode(ctx, v49);
                            let v51 = constructor_x64_lea(ctx, v46, v50);
                            let v52 = constructor_output_gpr(ctx, v51);
                            // Rule at src/isa/x64/lower.isle line 56.
                            return Some(v52);
                        }
                        let v34 = C::fits_in_16(ctx, v3);
                        if let Some(v35) = v34 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                            let v43 = constructor_x64_add(ctx, v35, v41, v42);
                            let v44 = constructor_output_gpr(ctx, v43);
                            // Rule at src/isa/x64/lower.isle line 45.
                            return Some(v44);
                        }
                    }
                }
                &Opcode::Isub => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v80 = constructor_value_regs_get_gpr(ctx, v78, 0x0);
                            let v82 = constructor_value_regs_get_gpr(ctx, v78, 0x1);
                            let v83 = C::put_in_regs(ctx, v38.1);
                            let v84 = constructor_value_regs_get_gpr(ctx, v83, 0x0);
                            let v85 = constructor_value_regs_get_gpr(ctx, v83, 0x1);
                            let v86 = &C::gpr_to_gpr_mem_imm(ctx, v84);
                            let v140 = &constructor_x64_sub_with_flags_paired(ctx, I64, v80, v86);
                            let v88 = &C::gpr_to_gpr_mem_imm(ctx, v85);
                            let v141 = &constructor_x64_sbb_paired(ctx, I64, v82, v88);
                            let v142 = constructor_with_flags(ctx, v140, v141);
                            let v143 = C::output(ctx, v142);
                            // Rule at src/isa/x64/lower.isle line 230.
                            return Some(v143);
                        }
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x8 => {
                                    if v65.1 == 0x10 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v132 = constructor_x64_psubb(ctx, v68, v69);
                                        let v133 = constructor_output_xmm(ctx, v132);
                                        // Rule at src/isa/x64/lower.isle line 213.
                                        return Some(v133);
                                    }
                                }
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v134 = constructor_x64_psubw(ctx, v68, v69);
                                        let v135 = constructor_output_xmm(ctx, v134);
                                        // Rule at src/isa/x64/lower.isle line 217.
                                        return Some(v135);
                                    }
                                }
                                0x20 => {
                                    if v65.1 == 0x4 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v136 = constructor_x64_psubd(ctx, v68, v69);
                                        let v137 = constructor_output_xmm(ctx, v136);
                                        // Rule at src/isa/x64/lower.isle line 221.
                                        return Some(v137);
                                    }
                                }
                                0x40 => {
                                    if v65.1 == 0x2 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v138 = constructor_x64_psubq(ctx, v68, v69);
                                        let v139 = constructor_output_xmm(ctx, v138);
                                        // Rule at src/isa/x64/lower.isle line 225.
                                        return Some(v139);
                                    }
                                }
                                _ => {}
                            }
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                            let v130 = constructor_x64_sub(ctx, v5, v41, v42);
                            let v131 = constructor_output_gpr(ctx, v130);
                            // Rule at src/isa/x64/lower.isle line 207.
                            return Some(v131);
                        }
                    }
                }
                &Opcode::Imul => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            if v65.0 == 0x40 {
                                if v65.1 == 0x2 {
                                    let v332 = C::use_avx512vl(ctx);
                                    if v332 == true {
                                        let v461 = C::use_avx512dq(ctx);
                                        if v461 == true {
                                            let v38 = C::unpack_value_array_2(ctx, v37);
                                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                            let v462 = constructor_x64_vpmullq(ctx, v68, v69);
                                            let v463 = constructor_output_xmm(ctx, v462);
                                            // Rule at src/isa/x64/lower.isle line 1047.
                                            return Some(v463);
                                        }
                                    }
                                }
                            }
                        }
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v80 = constructor_value_regs_get_gpr(ctx, v78, 0x0);
                            let v82 = constructor_value_regs_get_gpr(ctx, v78, 0x1);
                            let v83 = C::put_in_regs(ctx, v38.1);
                            let v84 = constructor_value_regs_get_gpr(ctx, v83, 0x0);
                            let v85 = constructor_value_regs_get_gpr(ctx, v83, 0x1);
                            let v425 = &C::gpr_to_gpr_mem_imm(ctx, v85);
                            let v426 = constructor_x64_mul(ctx, I64, v80, v425);
                            let v427 = &C::gpr_to_gpr_mem_imm(ctx, v84);
                            let v428 = constructor_x64_mul(ctx, I64, v82, v427);
                            let v429 = &C::gpr_to_gpr_mem_imm(ctx, v428);
                            let v430 = constructor_x64_add(ctx, I64, v426, v429);
                            let v431 = &C::gpr_to_gpr_mem(ctx, v84);
                            let v432 = constructor_mulhi_u(ctx, I64, v80, v431);
                            let v433 = constructor_value_regs_get_gpr(ctx, v432, 0x0);
                            let v434 = constructor_value_regs_get_gpr(ctx, v432, 0x1);
                            let v435 = &C::gpr_to_gpr_mem_imm(ctx, v434);
                            let v436 = constructor_x64_add(ctx, I64, v430, v435);
                            let v437 = constructor_value_gprs(ctx, v433, v436);
                            let v438 = C::output(ctx, v437);
                            // Rule at src/isa/x64/lower.isle line 997.
                            return Some(v438);
                        }
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x10 => {
                                    if v65.1 == 0x8 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v439 = constructor_x64_pmullw(ctx, v68, v69);
                                        let v440 = constructor_output_xmm(ctx, v439);
                                        // Rule at src/isa/x64/lower.isle line 1024.
                                        return Some(v440);
                                    }
                                }
                                0x20 => {
                                    if v65.1 == 0x4 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v171 = C::def_inst(ctx, v38.1);
                                        if let Some(v172) = v171 {
                                            let v173 = &C::inst_data(ctx, v172);
                                            if let &InstructionData::Unary {
                                                opcode: ref v174,
                                                arg: v175,
                                            } = v173
                                            {
                                                match v174 {
                                                    &Opcode::SwidenLow => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::SwidenLow = v183 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    let v482 =
                                                                        C::multi_lane(ctx, v481);
                                                                    if let Some(v483) = v482 {
                                                                        if v483.0 == 0x10 {
                                                                            if v483.1 == 0x8 {
                                                                                let v486 =
                                                                                    C::value_type(
                                                                                        ctx, v175,
                                                                                    );
                                                                                let v487 =
                                                                                    C::multi_lane(
                                                                                        ctx, v486,
                                                                                    );
                                                                                if let Some(v488) =
                                                                                    v487
                                                                                {
                                                                                    if v488.0
                                                                                        == 0x10
                                                                                    {
                                                                                        if v488.1
                                                                                            == 0x8
                                                                                        {
                                                                                            let v185 = constructor_put_in_xmm(ctx, v184);
                                                                                            let v491 = constructor_put_in_xmm(ctx, v175);
                                                                                            let v492 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v493 = constructor_x64_pmullw(ctx, v185, v492);
                                                                                            let v494 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v495 = constructor_x64_pmulhw(ctx, v185, v494);
                                                                                            let v496 = &C::xmm_to_xmm_mem(ctx, v495);
                                                                                            let v507 = constructor_x64_punpcklwd(ctx, v493, v496);
                                                                                            let v508 = constructor_output_xmm(ctx, v507);
                                                                                            // Rule at src/isa/x64/lower.isle line 1117.
                                                                                            return Some(v508);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::SwidenHigh => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::SwidenHigh = v183 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    let v482 =
                                                                        C::multi_lane(ctx, v481);
                                                                    if let Some(v483) = v482 {
                                                                        if v483.0 == 0x10 {
                                                                            if v483.1 == 0x8 {
                                                                                let v486 =
                                                                                    C::value_type(
                                                                                        ctx, v175,
                                                                                    );
                                                                                let v487 =
                                                                                    C::multi_lane(
                                                                                        ctx, v486,
                                                                                    );
                                                                                if let Some(v488) =
                                                                                    v487
                                                                                {
                                                                                    if v488.0
                                                                                        == 0x10
                                                                                    {
                                                                                        if v488.1
                                                                                            == 0x8
                                                                                        {
                                                                                            let v185 = constructor_put_in_xmm(ctx, v184);
                                                                                            let v491 = constructor_put_in_xmm(ctx, v175);
                                                                                            let v492 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v493 = constructor_x64_pmullw(ctx, v185, v492);
                                                                                            let v494 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v495 = constructor_x64_pmulhw(ctx, v185, v494);
                                                                                            let v496 = &C::xmm_to_xmm_mem(ctx, v495);
                                                                                            let v497 = constructor_x64_punpckhwd(ctx, v493, v496);
                                                                                            let v498 = constructor_output_xmm(ctx, v497);
                                                                                            // Rule at src/isa/x64/lower.isle line 1094.
                                                                                            return Some(v498);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenLow => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::UwidenLow = v183 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    let v482 =
                                                                        C::multi_lane(ctx, v481);
                                                                    if let Some(v483) = v482 {
                                                                        if v483.0 == 0x10 {
                                                                            if v483.1 == 0x8 {
                                                                                let v486 =
                                                                                    C::value_type(
                                                                                        ctx, v175,
                                                                                    );
                                                                                let v487 =
                                                                                    C::multi_lane(
                                                                                        ctx, v486,
                                                                                    );
                                                                                if let Some(v488) =
                                                                                    v487
                                                                                {
                                                                                    if v488.0
                                                                                        == 0x10
                                                                                    {
                                                                                        if v488.1
                                                                                            == 0x8
                                                                                        {
                                                                                            let v185 = constructor_put_in_xmm(ctx, v184);
                                                                                            let v491 = constructor_put_in_xmm(ctx, v175);
                                                                                            let v492 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v493 = constructor_x64_pmullw(ctx, v185, v492);
                                                                                            let v494 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v515 = constructor_x64_pmulhuw(ctx, v185, v494);
                                                                                            let v516 = &C::xmm_to_xmm_mem(ctx, v515);
                                                                                            let v521 = constructor_x64_punpcklwd(ctx, v493, v516);
                                                                                            let v522 = constructor_output_xmm(ctx, v521);
                                                                                            // Rule at src/isa/x64/lower.isle line 1162.
                                                                                            return Some(v522);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenHigh => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::UwidenHigh = v183 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    let v482 =
                                                                        C::multi_lane(ctx, v481);
                                                                    if let Some(v483) = v482 {
                                                                        if v483.0 == 0x10 {
                                                                            if v483.1 == 0x8 {
                                                                                let v486 =
                                                                                    C::value_type(
                                                                                        ctx, v175,
                                                                                    );
                                                                                let v487 =
                                                                                    C::multi_lane(
                                                                                        ctx, v486,
                                                                                    );
                                                                                if let Some(v488) =
                                                                                    v487
                                                                                {
                                                                                    if v488.0
                                                                                        == 0x10
                                                                                    {
                                                                                        if v488.1
                                                                                            == 0x8
                                                                                        {
                                                                                            let v185 = constructor_put_in_xmm(ctx, v184);
                                                                                            let v491 = constructor_put_in_xmm(ctx, v175);
                                                                                            let v492 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v493 = constructor_x64_pmullw(ctx, v185, v492);
                                                                                            let v494 = &C::xmm_to_xmm_mem(ctx, v491);
                                                                                            let v515 = constructor_x64_pmulhuw(ctx, v185, v494);
                                                                                            let v516 = &C::xmm_to_xmm_mem(ctx, v515);
                                                                                            let v517 = constructor_x64_punpckhwd(ctx, v493, v516);
                                                                                            let v518 = constructor_output_xmm(ctx, v517);
                                                                                            // Rule at src/isa/x64/lower.isle line 1140.
                                                                                            return Some(v518);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                        let v441 = C::use_sse41(ctx);
                                        if v441 == true {
                                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                            let v442 = constructor_x64_pmulld(ctx, v68, v69);
                                            let v443 = constructor_output_xmm(ctx, v442);
                                            // Rule at src/isa/x64/lower.isle line 1027.
                                            return Some(v443);
                                        }
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v444 = constructor_put_in_xmm(ctx, v38.1);
                                        let v316 = &C::xmm_to_xmm_mem(ctx, v68);
                                        let v446 = constructor_x64_pshufd(ctx, v316, 0x31);
                                        let v447 = &C::xmm_to_xmm_mem(ctx, v444);
                                        let v448 = constructor_x64_pshufd(ctx, v447, 0x31);
                                        let v449 = &C::xmm_to_xmm_mem(ctx, v444);
                                        let v450 = constructor_x64_pmuludq(ctx, v68, v449);
                                        let v451 = &C::xmm_to_xmm_mem(ctx, v450);
                                        let v453 = constructor_x64_pshufd(ctx, v451, 0x8);
                                        let v454 = &C::xmm_to_xmm_mem(ctx, v448);
                                        let v455 = constructor_x64_pmuludq(ctx, v446, v454);
                                        let v456 = &C::xmm_to_xmm_mem(ctx, v455);
                                        let v457 = constructor_x64_pshufd(ctx, v456, 0x8);
                                        let v458 = &C::xmm_to_xmm_mem(ctx, v457);
                                        let v459 = constructor_x64_punpckldq(ctx, v453, v458);
                                        let v460 = constructor_output_xmm(ctx, v459);
                                        // Rule at src/isa/x64/lower.isle line 1034.
                                        return Some(v460);
                                    }
                                }
                                0x40 => {
                                    if v65.1 == 0x2 {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v171 = C::def_inst(ctx, v38.1);
                                        if let Some(v172) = v171 {
                                            let v173 = &C::inst_data(ctx, v172);
                                            if let &InstructionData::Unary {
                                                opcode: ref v174,
                                                arg: v175,
                                            } = v173
                                            {
                                                match v174 {
                                                    &Opcode::SwidenLow => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::SwidenLow = v183 {
                                                                    let v441 = C::use_sse41(ctx);
                                                                    if v441 == true {
                                                                        let v481 = C::value_type(
                                                                            ctx, v184,
                                                                        );
                                                                        let v482 = C::multi_lane(
                                                                            ctx, v481,
                                                                        );
                                                                        if let Some(v483) = v482 {
                                                                            if v483.0 == 0x20 {
                                                                                if v483.1 == 0x4 {
                                                                                    let v486 = C::value_type(ctx, v175);
                                                                                    let v487 = C::multi_lane(ctx, v486);
                                                                                    if let Some(
                                                                                        v488,
                                                                                    ) = v487
                                                                                    {
                                                                                        if v488.0
                                                                                            == 0x20
                                                                                        {
                                                                                            if v488.1 == 0x4 {
                                                                                                let v499 = &C::put_in_xmm_mem(ctx, v184);
                                                                                                let v510 = constructor_x64_pshufd(ctx, v499, 0x50);
                                                                                                let v502 = &C::put_in_xmm_mem(ctx, v175);
                                                                                                let v511 = constructor_x64_pshufd(ctx, v502, 0x50);
                                                                                                let v512 = &C::xmm_to_xmm_mem(ctx, v511);
                                                                                                let v513 = constructor_x64_pmuldq(ctx, v510, v512);
                                                                                                let v514 = constructor_output_xmm(ctx, v513);
                                                                                                // Rule at src/isa/x64/lower.isle line 1129.
                                                                                                return Some(v514);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::SwidenHigh => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::SwidenHigh = v183 {
                                                                    let v441 = C::use_sse41(ctx);
                                                                    if v441 == true {
                                                                        let v481 = C::value_type(
                                                                            ctx, v184,
                                                                        );
                                                                        let v482 = C::multi_lane(
                                                                            ctx, v481,
                                                                        );
                                                                        if let Some(v483) = v482 {
                                                                            if v483.0 == 0x20 {
                                                                                if v483.1 == 0x4 {
                                                                                    let v486 = C::value_type(ctx, v175);
                                                                                    let v487 = C::multi_lane(ctx, v486);
                                                                                    if let Some(
                                                                                        v488,
                                                                                    ) = v487
                                                                                    {
                                                                                        if v488.0
                                                                                            == 0x20
                                                                                        {
                                                                                            if v488.1 == 0x4 {
                                                                                                let v499 = &C::put_in_xmm_mem(ctx, v184);
                                                                                                let v501 = constructor_x64_pshufd(ctx, v499, 0xFA);
                                                                                                let v502 = &C::put_in_xmm_mem(ctx, v175);
                                                                                                let v503 = constructor_x64_pshufd(ctx, v502, 0xFA);
                                                                                                let v504 = &C::xmm_to_xmm_mem(ctx, v503);
                                                                                                let v505 = constructor_x64_pmuldq(ctx, v501, v504);
                                                                                                let v506 = constructor_output_xmm(ctx, v505);
                                                                                                // Rule at src/isa/x64/lower.isle line 1106.
                                                                                                return Some(v506);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenLow => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::UwidenLow = v183 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    let v482 =
                                                                        C::multi_lane(ctx, v481);
                                                                    if let Some(v483) = v482 {
                                                                        if v483.0 == 0x20 {
                                                                            if v483.1 == 0x4 {
                                                                                let v486 =
                                                                                    C::value_type(
                                                                                        ctx, v175,
                                                                                    );
                                                                                let v487 =
                                                                                    C::multi_lane(
                                                                                        ctx, v486,
                                                                                    );
                                                                                if let Some(v488) =
                                                                                    v487
                                                                                {
                                                                                    if v488.0
                                                                                        == 0x20
                                                                                    {
                                                                                        if v488.1
                                                                                            == 0x4
                                                                                        {
                                                                                            let v499 = &C::put_in_xmm_mem(ctx, v184);
                                                                                            let v510 = constructor_x64_pshufd(ctx, v499, 0x50);
                                                                                            let v502 = &C::put_in_xmm_mem(ctx, v175);
                                                                                            let v511 = constructor_x64_pshufd(ctx, v502, 0x50);
                                                                                            let v512 = &C::xmm_to_xmm_mem(ctx, v511);
                                                                                            let v523 = constructor_x64_pmuludq(ctx, v510, v512);
                                                                                            let v524 = constructor_output_xmm(ctx, v523);
                                                                                            // Rule at src/isa/x64/lower.isle line 1174.
                                                                                            return Some(v524);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenHigh => {
                                                        let v180 = C::def_inst(ctx, v38.0);
                                                        if let Some(v181) = v180 {
                                                            let v182 = &C::inst_data(ctx, v181);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v183,
                                                                arg: v184,
                                                            } = v182
                                                            {
                                                                if let &Opcode::UwidenHigh = v183 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    let v482 =
                                                                        C::multi_lane(ctx, v481);
                                                                    if let Some(v483) = v482 {
                                                                        if v483.0 == 0x20 {
                                                                            if v483.1 == 0x4 {
                                                                                let v486 =
                                                                                    C::value_type(
                                                                                        ctx, v175,
                                                                                    );
                                                                                let v487 =
                                                                                    C::multi_lane(
                                                                                        ctx, v486,
                                                                                    );
                                                                                if let Some(v488) =
                                                                                    v487
                                                                                {
                                                                                    if v488.0
                                                                                        == 0x20
                                                                                    {
                                                                                        if v488.1
                                                                                            == 0x4
                                                                                        {
                                                                                            let v499 = &C::put_in_xmm_mem(ctx, v184);
                                                                                            let v501 = constructor_x64_pshufd(ctx, v499, 0xFA);
                                                                                            let v502 = &C::put_in_xmm_mem(ctx, v175);
                                                                                            let v503 = constructor_x64_pshufd(ctx, v502, 0xFA);
                                                                                            let v504 = &C::xmm_to_xmm_mem(ctx, v503);
                                                                                            let v519 = constructor_x64_pmuludq(ctx, v501, v504);
                                                                                            let v520 = constructor_output_xmm(ctx, v519);
                                                                                            // Rule at src/isa/x64/lower.isle line 1152.
                                                                                            return Some(v520);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v444 = constructor_put_in_xmm(ctx, v38.1);
                                        let v465 = &C::xmi_imm(ctx, 0x20);
                                        let v466 = constructor_x64_psrlq(ctx, v68, v465);
                                        let v447 = &C::xmm_to_xmm_mem(ctx, v444);
                                        let v467 = constructor_x64_pmuludq(ctx, v466, v447);
                                        let v468 = &C::xmi_imm(ctx, 0x20);
                                        let v469 = constructor_x64_psrlq(ctx, v444, v468);
                                        let v470 = &C::xmm_to_xmm_mem(ctx, v469);
                                        let v471 = constructor_x64_pmuludq(ctx, v68, v470);
                                        let v472 = &C::xmm_to_xmm_mem(ctx, v471);
                                        let v473 = constructor_x64_paddq(ctx, v467, v472);
                                        let v474 = &C::xmi_imm(ctx, 0x20);
                                        let v475 = constructor_x64_psllq(ctx, v473, v474);
                                        let v476 = &C::xmm_to_xmm_mem(ctx, v444);
                                        let v477 = constructor_x64_pmuludq(ctx, v68, v476);
                                        let v478 = &C::xmm_to_xmm_mem(ctx, v475);
                                        let v479 = constructor_x64_paddq(ctx, v477, v478);
                                        let v480 = constructor_output_xmm(ctx, v479);
                                        // Rule at src/isa/x64/lower.isle line 1072.
                                        return Some(v480);
                                    }
                                }
                                _ => {}
                            }
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v58 = &C::sinkable_load(ctx, v38.0);
                            if let Some(v59) = v58 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v61 = &constructor_sink_load_to_gpr_mem_imm(ctx, v59);
                                let v423 = constructor_x64_mul(ctx, v5, v60, v61);
                                let v424 = constructor_output_gpr(ctx, v423);
                                // Rule at src/isa/x64/lower.isle line 978.
                                return Some(v424);
                            }
                            let v158 = &C::simm32_from_value(ctx, v38.0);
                            if let Some(v159) = v158 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v421 = constructor_x64_mul(ctx, v5, v60, v159);
                                let v422 = constructor_output_gpr(ctx, v421);
                                // Rule at src/isa/x64/lower.isle line 975.
                                return Some(v422);
                            }
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                            let v419 = constructor_x64_mul(ctx, v5, v41, v42);
                            let v420 = constructor_output_gpr(ctx, v419);
                            // Rule at src/isa/x64/lower.isle line 969.
                            return Some(v420);
                        }
                    }
                }
                &Opcode::Umulhi => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v2080 = C::value_type(ctx, v38.0);
                    match v2080 {
                        I16 => {
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                            let v2220 = constructor_mul_hi(ctx, I16, false, v41, v109);
                            let v2221 = constructor_value_regs_get_gpr(ctx, v2220, 0x1);
                            let v2222 = constructor_output_gpr(ctx, v2221);
                            // Rule at src/isa/x64/lower.isle line 4138.
                            return Some(v2222);
                        }
                        I32 => {
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                            let v2223 = constructor_mul_hi(ctx, I32, false, v41, v109);
                            let v2224 = constructor_value_regs_get_gpr(ctx, v2223, 0x1);
                            let v2225 = constructor_output_gpr(ctx, v2224);
                            // Rule at src/isa/x64/lower.isle line 4143.
                            return Some(v2225);
                        }
                        I64 => {
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                            let v2226 = constructor_mul_hi(ctx, I64, false, v41, v109);
                            let v2227 = constructor_value_regs_get_gpr(ctx, v2226, 0x1);
                            let v2228 = constructor_output_gpr(ctx, v2227);
                            // Rule at src/isa/x64/lower.isle line 4148.
                            return Some(v2228);
                        }
                        _ => {}
                    }
                }
                &Opcode::Smulhi => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v2080 = C::value_type(ctx, v38.0);
                    match v2080 {
                        I16 => {
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                            let v2229 = constructor_mul_hi(ctx, I16, true, v41, v109);
                            let v2230 = constructor_value_regs_get_gpr(ctx, v2229, 0x1);
                            let v2231 = constructor_output_gpr(ctx, v2230);
                            // Rule at src/isa/x64/lower.isle line 4155.
                            return Some(v2231);
                        }
                        I32 => {
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                            let v2232 = constructor_mul_hi(ctx, I32, true, v41, v109);
                            let v2233 = constructor_value_regs_get_gpr(ctx, v2232, 0x1);
                            let v2234 = constructor_output_gpr(ctx, v2233);
                            // Rule at src/isa/x64/lower.isle line 4160.
                            return Some(v2234);
                        }
                        I64 => {
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                            let v2235 = constructor_mul_hi(ctx, I64, true, v41, v109);
                            let v2236 = constructor_value_regs_get_gpr(ctx, v2235, 0x1);
                            let v2237 = constructor_output_gpr(ctx, v2236);
                            // Rule at src/isa/x64/lower.isle line 4165.
                            return Some(v2237);
                        }
                        _ => {}
                    }
                }
                &Opcode::SqmulRoundSat => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v2080 = C::value_type(ctx, v38.0);
                    if v2080 == I16X8 {
                        let v525 = C::use_ssse3(ctx);
                        if v525 == true {
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v444 = constructor_put_in_xmm(ctx, v38.1);
                            let v2544 =
                                C::emit_u128_le_const(ctx, 0x80008000800080008000800080008000);
                            let v2545 = &constructor_const_to_xmm_mem(ctx, v2544);
                            let v447 = &C::xmm_to_xmm_mem(ctx, v444);
                            let v2546 = constructor_x64_pmulhrsw(ctx, v68, v447);
                            let v2547 = constructor_x64_pcmpeqw(ctx, v2546, v2545);
                            let v2548 = &C::xmm_to_xmm_mem(ctx, v2547);
                            let v2549 = constructor_x64_pxor(ctx, v2546, v2548);
                            let v2550 = constructor_output_xmm(ctx, v2549);
                            // Rule at src/isa/x64/lower.isle line 4631.
                            return Some(v2550);
                        }
                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                        let v444 = constructor_put_in_xmm(ctx, v38.1);
                        let v1963 = &C::xmm_to_xmm_mem(ctx, v444);
                        let v2551 = constructor_x64_pmullw(ctx, v68, v1963);
                        let v447 = &C::xmm_to_xmm_mem(ctx, v444);
                        let v2552 = constructor_x64_pmulhw(ctx, v68, v447);
                        let v2553 = &C::xmm_to_xmm_mem(ctx, v2552);
                        let v2554 = constructor_x64_punpcklwd(ctx, v2551, v2553);
                        let v2555 = &C::xmm_to_xmm_mem(ctx, v2552);
                        let v2556 = constructor_x64_punpckhwd(ctx, v2551, v2555);
                        let v2558 = C::emit_u128_le_const(ctx, 0x4000000040000000400000004000);
                        let v2559 = &constructor_const_to_xmm_mem(ctx, v2558);
                        let v2560 = constructor_x64_movdqu_load(ctx, v2559);
                        let v2561 = &C::xmm_to_xmm_mem(ctx, v2560);
                        let v2562 = constructor_x64_paddd(ctx, v2554, v2561);
                        let v2563 = &C::xmm_to_xmm_mem(ctx, v2560);
                        let v2564 = constructor_x64_paddd(ctx, v2556, v2563);
                        let v2566 = &C::xmi_imm(ctx, 0xF);
                        let v2567 = constructor_x64_psrad(ctx, v2562, v2566);
                        let v2568 = &C::xmi_imm(ctx, 0xF);
                        let v2569 = constructor_x64_psrad(ctx, v2564, v2568);
                        let v2570 = &C::xmm_to_xmm_mem(ctx, v2569);
                        let v2571 = constructor_x64_packssdw(ctx, v2567, v2570);
                        let v2572 = constructor_output_xmm(ctx, v2571);
                        // Rule at src/isa/x64/lower.isle line 4647.
                        return Some(v2572);
                    }
                }
                &Opcode::X86Pmulhrsw => {
                    let v525 = C::use_ssse3(ctx);
                    if v525 == true {
                        let v38 = C::unpack_value_array_2(ctx, v37);
                        let v2080 = C::value_type(ctx, v38.0);
                        if v2080 == I16X8 {
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v2573 = constructor_x64_pmulhrsw(ctx, v68, v69);
                            let v2574 = constructor_output_xmm(ctx, v2573);
                            // Rule at src/isa/x64/lower.isle line 4673.
                            return Some(v2574);
                        }
                    }
                }
                &Opcode::Udiv => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v2080 = C::value_type(ctx, v38.0);
                    if v2080 == I8 {
                        let v2164 = constructor_extend_to_gpr(ctx, v38.0, I32, &ExtendKind::Zero);
                        let v356 = constructor_put_in_gpr(ctx, v38.1);
                        let v2165 = &C::gpr_to_gpr_mem(ctx, v356);
                        let v2168 = constructor_x64_div8(
                            ctx,
                            v2164,
                            v2165,
                            &DivSignedness::Unsigned,
                            &TrapCode::IntegerDivisionByZero,
                        );
                        let v2169 = constructor_output_gpr(ctx, v2168);
                        // Rule at src/isa/x64/lower.isle line 4017.
                        return Some(v2169);
                    }
                    let v2170 = C::fits_in_64(ctx, v2080);
                    if let Some(v2171) = v2170 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v15 = constructor_imm(ctx, I64, 0x0);
                        let v2172 = C::gpr_new(ctx, v15);
                        let v2173 = constructor_put_in_gpr(ctx, v38.1);
                        let v2174 = &C::gpr_to_gpr_mem(ctx, v2173);
                        let v2175 = &C::raw_operand_size_of_type(ctx, v2171);
                        let v2176 = constructor_x64_div_quotient(
                            ctx,
                            v41,
                            v2172,
                            v2174,
                            v2175,
                            &DivSignedness::Unsigned,
                            &TrapCode::IntegerDivisionByZero,
                        );
                        let v2177 = C::output(ctx, v2176);
                        // Rule at src/isa/x64/lower.isle line 4026.
                        return Some(v2177);
                    }
                }
                &Opcode::Sdiv => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v2080 = C::value_type(ctx, v38.0);
                    if v2080 == I8 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v2179 = constructor_x64_sign_extend_data(ctx, v41, &OperandSize::Size8);
                        let v2180 = constructor_nonzero_sdiv_divisor(ctx, I8, v38.1);
                        let v2181 = &C::reg_to_gpr_mem(ctx, v2180);
                        let v2184 = constructor_x64_div8(
                            ctx,
                            v2179,
                            v2181,
                            &DivSignedness::Signed,
                            &TrapCode::IntegerOverflow,
                        );
                        let v2185 = constructor_output_gpr(ctx, v2184);
                        // Rule at src/isa/x64/lower.isle line 4036.
                        return Some(v2185);
                    }
                    let v2170 = C::fits_in_64(ctx, v2080);
                    if let Some(v2171) = v2170 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v2186 = &C::raw_operand_size_of_type(ctx, v2171);
                        let v2187 = constructor_x64_sign_extend_data(ctx, v41, v2186);
                        let v2188 = constructor_nonzero_sdiv_divisor(ctx, v2171, v38.1);
                        let v2189 = &C::reg_to_gpr_mem(ctx, v2188);
                        let v2190 = constructor_x64_div_quotient(
                            ctx,
                            v41,
                            v2187,
                            v2189,
                            v2186,
                            &DivSignedness::Signed,
                            &TrapCode::IntegerOverflow,
                        );
                        let v2191 = C::output(ctx, v2190);
                        // Rule at src/isa/x64/lower.isle line 4042.
                        return Some(v2191);
                    }
                }
                &Opcode::Urem => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v2080 = C::value_type(ctx, v38.0);
                    if v2080 == I8 {
                        let v2164 = constructor_extend_to_gpr(ctx, v38.0, I32, &ExtendKind::Zero);
                        let v356 = constructor_put_in_gpr(ctx, v38.1);
                        let v2165 = &C::gpr_to_gpr_mem(ctx, v356);
                        let v2168 = constructor_x64_div8(
                            ctx,
                            v2164,
                            v2165,
                            &DivSignedness::Unsigned,
                            &TrapCode::IntegerDivisionByZero,
                        );
                        let v1204 = Imm8Reg::Imm8 { imm: 0x8 };
                        let v2192 = &C::imm8_reg_to_imm8_gpr(ctx, &v1204);
                        let v2193 = constructor_x64_shr(ctx, I64, v2168, v2192);
                        let v2194 = constructor_output_gpr(ctx, v2193);
                        // Rule at src/isa/x64/lower.isle line 4075.
                        return Some(v2194);
                    }
                    let v2170 = C::fits_in_64(ctx, v2080);
                    if let Some(v2171) = v2170 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v15 = constructor_imm(ctx, I64, 0x0);
                        let v2172 = C::gpr_new(ctx, v15);
                        let v2173 = constructor_put_in_gpr(ctx, v38.1);
                        let v2174 = &C::gpr_to_gpr_mem(ctx, v2173);
                        let v2175 = &C::raw_operand_size_of_type(ctx, v2171);
                        let v2195 = constructor_x64_div_remainder(
                            ctx,
                            v41,
                            v2172,
                            v2174,
                            v2175,
                            &DivSignedness::Unsigned,
                            &TrapCode::IntegerDivisionByZero,
                        );
                        let v2196 = C::output(ctx, v2195);
                        // Rule at src/isa/x64/lower.isle line 4084.
                        return Some(v2196);
                    }
                }
                &Opcode::Srem => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v171 = C::def_inst(ctx, v38.1);
                    if let Some(v172) = v171 {
                        let v173 = &C::inst_data(ctx, v172);
                        if let &InstructionData::UnaryImm {
                            opcode: ref v330,
                            imm: v331,
                        } = v173
                        {
                            if let &Opcode::Iconst = v330 {
                                let v2080 = C::value_type(ctx, v38.0);
                                if v2080 == I8 {
                                    let v2197 = C::safe_divisor_from_imm64(ctx, I8, v331);
                                    if let Some(v2198) = v2197 {
                                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                                        let v2179 = constructor_x64_sign_extend_data(
                                            ctx,
                                            v41,
                                            &OperandSize::Size8,
                                        );
                                        let v2199 = constructor_imm(ctx, I8, v2198);
                                        let v2200 = &C::reg_to_gpr_mem(ctx, v2199);
                                        let v2201 = constructor_x64_div8(
                                            ctx,
                                            v2179,
                                            v2200,
                                            &DivSignedness::Signed,
                                            &TrapCode::IntegerDivisionByZero,
                                        );
                                        let v1204 = Imm8Reg::Imm8 { imm: 0x8 };
                                        let v2202 = &C::imm8_reg_to_imm8_gpr(ctx, &v1204);
                                        let v2203 = constructor_x64_shr(ctx, I64, v2201, v2202);
                                        let v2204 = constructor_output_gpr(ctx, v2203);
                                        // Rule at src/isa/x64/lower.isle line 4099.
                                        return Some(v2204);
                                    }
                                }
                                let v2205 = C::safe_divisor_from_imm64(ctx, v2080, v331);
                                if let Some(v2206) = v2205 {
                                    let v41 = constructor_put_in_gpr(ctx, v38.0);
                                    let v2207 = &C::raw_operand_size_of_type(ctx, v2080);
                                    let v2208 = constructor_x64_sign_extend_data(ctx, v41, v2207);
                                    let v2209 = constructor_imm(ctx, v2080, v2206);
                                    let v2210 = &C::reg_to_gpr_mem(ctx, v2209);
                                    let v2211 = constructor_x64_div_remainder(
                                        ctx,
                                        v41,
                                        v2208,
                                        v2210,
                                        v2207,
                                        &DivSignedness::Signed,
                                        &TrapCode::IntegerDivisionByZero,
                                    );
                                    let v2212 = C::output(ctx, v2211);
                                    // Rule at src/isa/x64/lower.isle line 4108.
                                    return Some(v2212);
                                }
                            }
                        }
                    }
                    let v2080 = C::value_type(ctx, v38.0);
                    if v2080 == I8 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v2179 = constructor_x64_sign_extend_data(ctx, v41, &OperandSize::Size8);
                        let v2213 = constructor_put_in_gpr(ctx, v38.1);
                        let v2214 = constructor_x64_checked_srem_seq8(ctx, v2179, v2213);
                        let v1204 = Imm8Reg::Imm8 { imm: 0x8 };
                        let v2192 = &C::imm8_reg_to_imm8_gpr(ctx, &v1204);
                        let v2215 = constructor_x64_shr(ctx, I64, v2214, v2192);
                        let v2216 = constructor_output_gpr(ctx, v2215);
                        // Rule at src/isa/x64/lower.isle line 4121.
                        return Some(v2216);
                    }
                    let v41 = constructor_put_in_gpr(ctx, v38.0);
                    let v2207 = &C::raw_operand_size_of_type(ctx, v2080);
                    let v2208 = constructor_x64_sign_extend_data(ctx, v41, v2207);
                    let v2173 = constructor_put_in_gpr(ctx, v38.1);
                    let v2217 = constructor_x64_checked_srem_seq(ctx, v2207, v41, v2208, v2173);
                    let v2218 = C::value_regs_get(ctx, v2217, 0x1);
                    let v2219 = constructor_output_reg(ctx, v2218);
                    // Rule at src/isa/x64/lower.isle line 4127.
                    return Some(v2219);
                }
                &Opcode::UaddOverflow => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v92 = C::value_type(ctx, v38.1);
                    let v93 = C::fits_in_64(ctx, v92);
                    if let Some(v94) = v93 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                        let v97 = constructor_construct_overflow_op_alu(
                            ctx,
                            v94,
                            &CC::B,
                            &AluRmiROpcode::Add,
                            v41,
                            v42,
                        );
                        // Rule at src/isa/x64/lower.isle line 137.
                        return Some(v97);
                    }
                    if v92 == I128 {
                        let v99 = constructor_construct_overflow_op_alu_128(
                            ctx,
                            &CC::B,
                            &AluRmiROpcode::Add,
                            &AluRmiROpcode::Adc,
                            v38.0,
                            v38.1,
                        );
                        // Rule at src/isa/x64/lower.isle line 141.
                        return Some(v99);
                    }
                }
                &Opcode::SaddOverflow => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v92 = C::value_type(ctx, v38.1);
                    let v93 = C::fits_in_64(ctx, v92);
                    if let Some(v94) = v93 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                        let v101 = constructor_construct_overflow_op_alu(
                            ctx,
                            v94,
                            &CC::O,
                            &AluRmiROpcode::Add,
                            v41,
                            v42,
                        );
                        // Rule at src/isa/x64/lower.isle line 146.
                        return Some(v101);
                    }
                    if v92 == I128 {
                        let v102 = constructor_construct_overflow_op_alu_128(
                            ctx,
                            &CC::O,
                            &AluRmiROpcode::Add,
                            &AluRmiROpcode::Adc,
                            v38.0,
                            v38.1,
                        );
                        // Rule at src/isa/x64/lower.isle line 149.
                        return Some(v102);
                    }
                }
                &Opcode::UsubOverflow => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v92 = C::value_type(ctx, v38.1);
                    let v93 = C::fits_in_64(ctx, v92);
                    if let Some(v94) = v93 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                        let v104 = constructor_construct_overflow_op_alu(
                            ctx,
                            v94,
                            &CC::B,
                            &AluRmiROpcode::Sub,
                            v41,
                            v42,
                        );
                        // Rule at src/isa/x64/lower.isle line 154.
                        return Some(v104);
                    }
                    if v92 == I128 {
                        let v106 = constructor_construct_overflow_op_alu_128(
                            ctx,
                            &CC::B,
                            &AluRmiROpcode::Sub,
                            &AluRmiROpcode::Sbb,
                            v38.0,
                            v38.1,
                        );
                        // Rule at src/isa/x64/lower.isle line 157.
                        return Some(v106);
                    }
                }
                &Opcode::SsubOverflow => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v92 = C::value_type(ctx, v38.1);
                    let v93 = C::fits_in_64(ctx, v92);
                    if let Some(v94) = v93 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                        let v107 = constructor_construct_overflow_op_alu(
                            ctx,
                            v94,
                            &CC::O,
                            &AluRmiROpcode::Sub,
                            v41,
                            v42,
                        );
                        // Rule at src/isa/x64/lower.isle line 162.
                        return Some(v107);
                    }
                    if v92 == I128 {
                        let v108 = constructor_construct_overflow_op_alu_128(
                            ctx,
                            &CC::O,
                            &AluRmiROpcode::Sub,
                            &AluRmiROpcode::Sbb,
                            v38.0,
                            v38.1,
                        );
                        // Rule at src/isa/x64/lower.isle line 165.
                        return Some(v108);
                    }
                }
                &Opcode::UmulOverflow => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v92 = C::value_type(ctx, v38.1);
                    let v93 = C::fits_in_64(ctx, v92);
                    if let Some(v94) = v93 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                        let v110 = &constructor_x64_umullo_with_flags_paired(ctx, v94, v41, v109);
                        let v111 = constructor_construct_overflow_op(ctx, &CC::O, v110);
                        // Rule at src/isa/x64/lower.isle line 170.
                        return Some(v111);
                    }
                }
                &Opcode::SmulOverflow => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v92 = C::value_type(ctx, v38.1);
                    let v112 = C::ty_int_ref_16_to_64(ctx, v92);
                    if let Some(v113) = v112 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                        let v115 = constructor_construct_overflow_op_alu(
                            ctx,
                            v113,
                            &CC::O,
                            &AluRmiROpcode::Mul,
                            v41,
                            v42,
                        );
                        // Rule at src/isa/x64/lower.isle line 175.
                        return Some(v115);
                    }
                    if v92 == I8 {
                        let v41 = constructor_put_in_gpr(ctx, v38.0);
                        let v117 = &C::put_in_reg_mem(ctx, v38.1);
                        let v118 = &constructor_reg_mem_to_reg_mem_imm(ctx, v117);
                        let v119 = &C::gpr_mem_imm_new(ctx, v118);
                        let v120 = &constructor_x64_alurmi_with_flags_paired(
                            ctx,
                            &AluRmiROpcode::Mul,
                            I8,
                            v41,
                            v119,
                        );
                        let v121 = constructor_construct_overflow_op(ctx, &CC::O, v120);
                        // Rule at src/isa/x64/lower.isle line 179.
                        return Some(v121);
                    }
                }
                &Opcode::Band => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v45 = C::ty_32_or_64(ctx, v3);
                        if let Some(v46) = v45 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v196 = constructor_val_minus_one(ctx, v38.1);
                            if let Some(v197) = v196 {
                                let v211 = C::use_bmi2(ctx);
                                if v211 == true {
                                    let v212 = C::def_inst(ctx, v197);
                                    if let Some(v213) = v212 {
                                        let v214 = &C::inst_data(ctx, v213);
                                        if let &InstructionData::Binary {
                                            opcode: ref v215,
                                            args: ref v216,
                                        } = v214
                                        {
                                            if let &Opcode::Ishl = v215 {
                                                let v217 = C::unpack_value_array_2(ctx, v216);
                                                let v220 = C::def_inst(ctx, v217.0);
                                                if let Some(v221) = v220 {
                                                    let v222 = &C::inst_data(ctx, v221);
                                                    if let &InstructionData::UnaryImm {
                                                        opcode: ref v223,
                                                        imm: v224,
                                                    } = v222
                                                    {
                                                        if let &Opcode::Iconst = v223 {
                                                            let v225 = C::u64_from_imm64(ctx, v224);
                                                            if v225 == 0x1 {
                                                                let v198 =
                                                                    &constructor_put_in_gpr_mem(
                                                                        ctx, v38.0,
                                                                    );
                                                                let v226 = constructor_put_in_gpr(
                                                                    ctx, v217.1,
                                                                );
                                                                let v227 = C::ty_bits(ctx, v46);
                                                                let v228 = C::u8_as_u32(ctx, v227);
                                                                let v230 =
                                                                    C::u32_sub(ctx, v228, 0x1);
                                                                let v231 =
                                                                    RegMemImm::Imm { simm32: v230 };
                                                                let v232 =
                                                                    &C::gpr_mem_imm_new(ctx, &v231);
                                                                let v233 = constructor_x64_and(
                                                                    ctx, v46, v226, v232,
                                                                );
                                                                let v234 = constructor_x64_bzhi(
                                                                    ctx, v46, v198, v233,
                                                                );
                                                                let v235 = constructor_output_gpr(
                                                                    ctx, v234,
                                                                );
                                                                // Rule at src/isa/x64/lower.isle line 382.
                                                                return Some(v235);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            let v188 = C::use_bmi1(ctx);
                            if v188 == true {
                                let v171 = C::def_inst(ctx, v38.1);
                                if let Some(v172) = v171 {
                                    let v173 = &C::inst_data(ctx, v172);
                                    if let &InstructionData::Unary {
                                        opcode: ref v174,
                                        arg: v175,
                                    } = v173
                                    {
                                        if let &Opcode::Ineg = v174 {
                                            if v38.0 == v175 {
                                                let v198 = &constructor_put_in_gpr_mem(ctx, v38.0);
                                                let v209 = constructor_x64_blsi(ctx, v46, v198);
                                                let v210 = constructor_output_gpr(ctx, v209);
                                                // Rule at src/isa/x64/lower.isle line 369.
                                                return Some(v210);
                                            }
                                        }
                                    }
                                }
                                let v180 = C::def_inst(ctx, v38.0);
                                if let Some(v181) = v180 {
                                    let v182 = &C::inst_data(ctx, v181);
                                    if let &InstructionData::Unary {
                                        opcode: ref v183,
                                        arg: v184,
                                    } = v182
                                    {
                                        if let &Opcode::Ineg = v183 {
                                            if v38.1 == v184 {
                                                let v206 = &constructor_put_in_gpr_mem(ctx, v184);
                                                let v207 = constructor_x64_blsi(ctx, v46, v206);
                                                let v208 = constructor_output_gpr(ctx, v207);
                                                // Rule at src/isa/x64/lower.isle line 366.
                                                return Some(v208);
                                            }
                                        }
                                    }
                                }
                                let v201 = constructor_val_minus_one(ctx, v38.0);
                                if let Some(v202) = v201 {
                                    if v38.1 == v202 {
                                        let v203 = &constructor_put_in_gpr_mem(ctx, v38.1);
                                        let v204 = constructor_x64_blsr(ctx, v46, v203);
                                        let v205 = constructor_output_gpr(ctx, v204);
                                        // Rule at src/isa/x64/lower.isle line 359.
                                        return Some(v205);
                                    }
                                }
                                if let Some(v197) = v196 {
                                    if v38.0 == v197 {
                                        let v198 = &constructor_put_in_gpr_mem(ctx, v38.0);
                                        let v199 = constructor_x64_blsr(ctx, v46, v198);
                                        let v200 = constructor_output_gpr(ctx, v199);
                                        // Rule at src/isa/x64/lower.isle line 355.
                                        return Some(v200);
                                    }
                                }
                            }
                        }
                        let v152 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v153) = v152 {
                            let v188 = C::use_bmi1(ctx);
                            if v188 == true {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v180 = C::def_inst(ctx, v38.0);
                                if let Some(v181) = v180 {
                                    let v182 = &C::inst_data(ctx, v181);
                                    if let &InstructionData::Unary {
                                        opcode: ref v183,
                                        arg: v184,
                                    } = v182
                                    {
                                        if let &Opcode::Bnot = v183 {
                                            let v193 = constructor_put_in_gpr(ctx, v184);
                                            let v109 = &constructor_put_in_gpr_mem(ctx, v38.1);
                                            let v194 = constructor_x64_andn(ctx, v3, v193, v109);
                                            let v195 = constructor_output_gpr(ctx, v194);
                                            // Rule at src/isa/x64/lower.isle line 343.
                                            return Some(v195);
                                        }
                                    }
                                }
                                let v171 = C::def_inst(ctx, v38.1);
                                if let Some(v172) = v171 {
                                    let v173 = &C::inst_data(ctx, v172);
                                    if let &InstructionData::Unary {
                                        opcode: ref v174,
                                        arg: v175,
                                    } = v173
                                    {
                                        if let &Opcode::Bnot = v174 {
                                            let v189 = constructor_put_in_gpr(ctx, v175);
                                            let v190 = &constructor_put_in_gpr_mem(ctx, v38.0);
                                            let v191 = constructor_x64_andn(ctx, v3, v189, v190);
                                            let v192 = constructor_output_gpr(ctx, v191);
                                            // Rule at src/isa/x64/lower.isle line 338.
                                            return Some(v192);
                                        }
                                    }
                                }
                            }
                        }
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v180 = C::def_inst(ctx, v38.0);
                            if let Some(v181) = v180 {
                                let v182 = &C::inst_data(ctx, v181);
                                if let &InstructionData::Unary {
                                    opcode: ref v183,
                                    arg: v184,
                                } = v182
                                {
                                    if let &Opcode::Bnot = v183 {
                                        let v185 = constructor_put_in_xmm(ctx, v184);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v186 = constructor_sse_and_not(ctx, v3, v185, v69);
                                        let v187 = constructor_output_xmm(ctx, v186);
                                        // Rule at src/isa/x64/lower.isle line 335.
                                        return Some(v187);
                                    }
                                }
                            }
                            let v171 = C::def_inst(ctx, v38.1);
                            if let Some(v172) = v171 {
                                let v173 = &C::inst_data(ctx, v172);
                                if let &InstructionData::Unary {
                                    opcode: ref v174,
                                    arg: v175,
                                } = v173
                                {
                                    if let &Opcode::Bnot = v174 {
                                        let v176 = constructor_put_in_xmm(ctx, v175);
                                        let v177 = &C::put_in_xmm_mem(ctx, v38.0);
                                        let v178 = constructor_sse_and_not(ctx, v3, v176, v177);
                                        let v179 = constructor_output_xmm(ctx, v178);
                                        // Rule at src/isa/x64/lower.isle line 333.
                                        return Some(v179);
                                    }
                                }
                            }
                        }
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v168 = C::put_in_regs(ctx, v38.1);
                            let v169 = constructor_and_i128(ctx, v78, v168);
                            let v170 = C::output(ctx, v169);
                            // Rule at src/isa/x64/lower.isle line 314.
                            return Some(v170);
                        }
                        if let Some(v65) = v64 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v166 = constructor_sse_and(ctx, v3, v68, v69);
                            let v167 = constructor_output_xmm(ctx, v166);
                            // Rule at src/isa/x64/lower.isle line 297.
                            return Some(v167);
                        }
                        let v162 = C::ty_scalar_float(ctx, v3);
                        if let Some(v163) = v162 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v164 = constructor_sse_and(ctx, v163, v68, v69);
                            let v165 = constructor_output_xmm(ctx, v164);
                            // Rule at src/isa/x64/lower.isle line 285.
                            return Some(v165);
                        }
                        if let Some(v153) = v152 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v158 = &C::simm32_from_value(ctx, v38.0);
                            if let Some(v159) = v158 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v160 = constructor_x64_and(ctx, v3, v60, v159);
                                let v161 = constructor_output_gpr(ctx, v160);
                                // Rule at src/isa/x64/lower.isle line 279.
                                return Some(v161);
                            }
                            let v58 = &C::sinkable_load(ctx, v38.0);
                            if let Some(v59) = v58 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v61 = &constructor_sink_load_to_gpr_mem_imm(ctx, v59);
                                let v156 = constructor_x64_and(ctx, v3, v60, v61);
                                let v157 = constructor_output_gpr(ctx, v156);
                                // Rule at src/isa/x64/lower.isle line 275.
                                return Some(v157);
                            }
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                            let v154 = constructor_x64_and(ctx, v3, v41, v42);
                            let v155 = constructor_output_gpr(ctx, v154);
                            // Rule at src/isa/x64/lower.isle line 268.
                            return Some(v155);
                        }
                    }
                }
                &Opcode::Bor => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v168 = C::put_in_regs(ctx, v38.1);
                            let v246 = constructor_or_i128(ctx, v78, v168);
                            let v247 = C::output(ctx, v246);
                            // Rule at src/isa/x64/lower.isle line 436.
                            return Some(v247);
                        }
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v244 = constructor_sse_or(ctx, v3, v68, v69);
                            let v245 = constructor_output_xmm(ctx, v244);
                            // Rule at src/isa/x64/lower.isle line 421.
                            return Some(v245);
                        }
                        let v162 = C::ty_scalar_float(ctx, v3);
                        if let Some(v163) = v162 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v242 = constructor_sse_or(ctx, v163, v68, v69);
                            let v243 = constructor_output_xmm(ctx, v242);
                            // Rule at src/isa/x64/lower.isle line 409.
                            return Some(v243);
                        }
                        let v152 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v153) = v152 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v158 = &C::simm32_from_value(ctx, v38.0);
                            if let Some(v159) = v158 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v240 = constructor_x64_or(ctx, v3, v60, v159);
                                let v241 = constructor_output_gpr(ctx, v240);
                                // Rule at src/isa/x64/lower.isle line 403.
                                return Some(v241);
                            }
                            let v58 = &C::sinkable_load(ctx, v38.0);
                            if let Some(v59) = v58 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v61 = &constructor_sink_load_to_gpr_mem_imm(ctx, v59);
                                let v238 = constructor_x64_or(ctx, v3, v60, v61);
                                let v239 = constructor_output_gpr(ctx, v238);
                                // Rule at src/isa/x64/lower.isle line 399.
                                return Some(v239);
                            }
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                            let v236 = constructor_x64_or(ctx, v3, v41, v42);
                            let v237 = constructor_output_gpr(ctx, v236);
                            // Rule at src/isa/x64/lower.isle line 392.
                            return Some(v237);
                        }
                    }
                }
                &Opcode::Bxor => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v45 = C::ty_32_or_64(ctx, v3);
                        if let Some(v46) = v45 {
                            let v188 = C::use_bmi1(ctx);
                            if v188 == true {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v201 = constructor_val_minus_one(ctx, v38.0);
                                if let Some(v202) = v201 {
                                    if v38.1 == v202 {
                                        let v203 = &constructor_put_in_gpr_mem(ctx, v38.1);
                                        let v264 = constructor_x64_blsmsk(ctx, v46, v203);
                                        let v265 = constructor_output_gpr(ctx, v264);
                                        // Rule at src/isa/x64/lower.isle line 487.
                                        return Some(v265);
                                    }
                                }
                                let v196 = constructor_val_minus_one(ctx, v38.1);
                                if let Some(v197) = v196 {
                                    if v38.0 == v197 {
                                        let v198 = &constructor_put_in_gpr_mem(ctx, v38.0);
                                        let v262 = constructor_x64_blsmsk(ctx, v46, v198);
                                        let v263 = constructor_output_gpr(ctx, v262);
                                        // Rule at src/isa/x64/lower.isle line 483.
                                        return Some(v263);
                                    }
                                }
                            }
                        }
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v80 = constructor_value_regs_get_gpr(ctx, v78, 0x0);
                            let v82 = constructor_value_regs_get_gpr(ctx, v78, 0x1);
                            let v83 = C::put_in_regs(ctx, v38.1);
                            let v84 = constructor_value_regs_get_gpr(ctx, v83, 0x0);
                            let v85 = constructor_value_regs_get_gpr(ctx, v83, 0x1);
                            let v86 = &C::gpr_to_gpr_mem_imm(ctx, v84);
                            let v258 = constructor_x64_xor(ctx, I64, v80, v86);
                            let v88 = &C::gpr_to_gpr_mem_imm(ctx, v85);
                            let v259 = constructor_x64_xor(ctx, I64, v82, v88);
                            let v260 = constructor_value_gprs(ctx, v258, v259);
                            let v261 = C::output(ctx, v260);
                            // Rule at src/isa/x64/lower.isle line 471.
                            return Some(v261);
                        }
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v256 = constructor_x64_xor_vector(ctx, v3, v68, v69);
                            let v257 = constructor_output_xmm(ctx, v256);
                            // Rule at src/isa/x64/lower.isle line 466.
                            return Some(v257);
                        }
                        let v162 = C::ty_scalar_float(ctx, v3);
                        if let Some(v163) = v162 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v68 = constructor_put_in_xmm(ctx, v38.0);
                            let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                            let v254 = constructor_x64_xor_vector(ctx, v163, v68, v69);
                            let v255 = constructor_output_xmm(ctx, v254);
                            // Rule at src/isa/x64/lower.isle line 461.
                            return Some(v255);
                        }
                        let v152 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v153) = v152 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v158 = &C::simm32_from_value(ctx, v38.0);
                            if let Some(v159) = v158 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v252 = constructor_x64_xor(ctx, v3, v60, v159);
                                let v253 = constructor_output_gpr(ctx, v252);
                                // Rule at src/isa/x64/lower.isle line 455.
                                return Some(v253);
                            }
                            let v58 = &C::sinkable_load(ctx, v38.0);
                            if let Some(v59) = v58 {
                                let v60 = constructor_put_in_gpr(ctx, v38.1);
                                let v61 = &constructor_sink_load_to_gpr_mem_imm(ctx, v59);
                                let v250 = constructor_x64_xor(ctx, v3, v60, v61);
                                let v251 = constructor_output_gpr(ctx, v250);
                                // Rule at src/isa/x64/lower.isle line 451.
                                return Some(v251);
                            }
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v42 = &constructor_put_in_gpr_mem_imm(ctx, v38.1);
                            let v248 = constructor_x64_xor(ctx, v3, v41, v42);
                            let v249 = constructor_output_gpr(ctx, v248);
                            // Rule at src/isa/x64/lower.isle line 444.
                            return Some(v249);
                        }
                    }
                }
                &Opcode::Rotl => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v364 = constructor_lo_gpr(ctx, v38.1);
                            let v365 = constructor_shl_i128(ctx, v78, v364);
                            let v367 = constructor_imm(ctx, I64, 0x80);
                            let v368 = C::gpr_new(ctx, v367);
                            let v369 = &C::gpr_to_gpr_mem_imm(ctx, v364);
                            let v370 = constructor_x64_sub(ctx, I64, v368, v369);
                            let v371 = constructor_shr_i128(ctx, v78, v370);
                            let v372 = constructor_or_i128(ctx, v365, v371);
                            let v373 = C::output(ctx, v372);
                            // Rule at src/isa/x64/lower.isle line 893.
                            return Some(v373);
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v266 = &constructor_put_masked_in_imm8_gpr(ctx, v38.1, v5);
                            let v362 = constructor_x64_rotl(ctx, v5, v41, v266);
                            let v363 = constructor_output_gpr(ctx, v362);
                            // Rule at src/isa/x64/lower.isle line 887.
                            return Some(v363);
                        }
                    }
                }
                &Opcode::Rotr => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v78 = C::put_in_regs(ctx, v38.0);
                            let v364 = constructor_lo_gpr(ctx, v38.1);
                            let v376 = constructor_shr_i128(ctx, v78, v364);
                            let v367 = constructor_imm(ctx, I64, 0x80);
                            let v368 = C::gpr_new(ctx, v367);
                            let v369 = &C::gpr_to_gpr_mem_imm(ctx, v364);
                            let v370 = constructor_x64_sub(ctx, I64, v368, v369);
                            let v377 = constructor_shl_i128(ctx, v78, v370);
                            let v378 = constructor_or_i128(ctx, v376, v377);
                            let v379 = C::output(ctx, v378);
                            // Rule at src/isa/x64/lower.isle line 914.
                            return Some(v379);
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v266 = &constructor_put_masked_in_imm8_gpr(ctx, v38.1, v5);
                            let v374 = constructor_x64_rotr(ctx, v5, v41, v266);
                            let v375 = constructor_output_gpr(ctx, v374);
                            // Rule at src/isa/x64/lower.isle line 908.
                            return Some(v375);
                        }
                    }
                }
                &Opcode::Ishl => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v269 = constructor_lo_gpr(ctx, v38.1);
                                let v270 = C::put_in_regs(ctx, v38.0);
                                let v271 = constructor_shl_i128(ctx, v270, v269);
                                let v272 = C::output(ctx, v271);
                                // Rule at src/isa/x64/lower.isle line 535.
                                return Some(v272);
                            }
                            I8X16 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v273 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v274 = constructor_put_in_xmm(ctx, v38.0);
                                let v275 = &constructor_mov_rmi_to_xmm(ctx, v273);
                                let v276 = constructor_x64_psllw(ctx, v274, v275);
                                let v277 = &constructor_ishl_i8x16_mask(ctx, v273);
                                let v280 = constructor_x64_load(ctx, I8X16, v277, &ExtKind::None);
                                let v281 = RegMem::Reg { reg: v280 };
                                let v282 = &C::reg_mem_to_xmm_mem(ctx, &v281);
                                let v283 = constructor_sse_and(ctx, I8X16, v276, v282);
                                let v284 = constructor_output_xmm(ctx, v283);
                                // Rule at src/isa/x64/lower.isle line 547.
                                return Some(v284);
                            }
                            I16X8 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v287 = constructor_x64_psllw(ctx, v68, v286);
                                let v288 = constructor_output_xmm(ctx, v287);
                                // Rule at src/isa/x64/lower.isle line 592.
                                return Some(v288);
                            }
                            I32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v289 = constructor_x64_pslld(ctx, v68, v286);
                                let v290 = constructor_output_xmm(ctx, v289);
                                // Rule at src/isa/x64/lower.isle line 595.
                                return Some(v290);
                            }
                            I64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v291 = constructor_x64_psllq(ctx, v68, v286);
                                let v292 = constructor_output_xmm(ctx, v291);
                                // Rule at src/isa/x64/lower.isle line 598.
                                return Some(v292);
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v41 = constructor_put_in_gpr(ctx, v38.0);
                            let v266 = &constructor_put_masked_in_imm8_gpr(ctx, v38.1, v5);
                            let v267 = constructor_x64_shl(ctx, v5, v41, v266);
                            let v268 = constructor_output_gpr(ctx, v267);
                            // Rule at src/isa/x64/lower.isle line 496.
                            return Some(v268);
                        }
                    }
                }
                &Opcode::Ushr => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v269 = constructor_lo_gpr(ctx, v38.1);
                                let v270 = C::put_in_regs(ctx, v38.0);
                                let v297 = constructor_shr_i128(ctx, v270, v269);
                                let v298 = C::output(ctx, v297);
                                // Rule at src/isa/x64/lower.isle line 642.
                                return Some(v298);
                            }
                            I8X16 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v273 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v274 = constructor_put_in_xmm(ctx, v38.0);
                                let v275 = &constructor_mov_rmi_to_xmm(ctx, v273);
                                let v299 = constructor_x64_psrlw(ctx, v274, v275);
                                let v300 = &constructor_ushr_i8x16_mask(ctx, v273);
                                let v301 = &constructor_synthetic_amode_to_xmm_mem(ctx, v300);
                                let v302 = constructor_sse_and(ctx, I8X16, v299, v301);
                                let v303 = constructor_output_xmm(ctx, v302);
                                // Rule at src/isa/x64/lower.isle line 652.
                                return Some(v303);
                            }
                            I16X8 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v304 = constructor_x64_psrlw(ctx, v68, v286);
                                let v305 = constructor_output_xmm(ctx, v304);
                                // Rule at src/isa/x64/lower.isle line 698.
                                return Some(v305);
                            }
                            I32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v306 = constructor_x64_psrld(ctx, v68, v286);
                                let v307 = constructor_output_xmm(ctx, v306);
                                // Rule at src/isa/x64/lower.isle line 701.
                                return Some(v307);
                            }
                            I64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v308 = constructor_x64_psrlq(ctx, v68, v286);
                                let v309 = constructor_output_xmm(ctx, v308);
                                // Rule at src/isa/x64/lower.isle line 704.
                                return Some(v309);
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v294 = constructor_extend_to_gpr(ctx, v38.0, v5, &ExtendKind::Zero);
                            let v266 = &constructor_put_masked_in_imm8_gpr(ctx, v38.1, v5);
                            let v295 = constructor_x64_shr(ctx, v5, v294, v266);
                            let v296 = constructor_output_gpr(ctx, v295);
                            // Rule at src/isa/x64/lower.isle line 605.
                            return Some(v296);
                        }
                    }
                }
                &Opcode::Sshr => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v269 = constructor_lo_gpr(ctx, v38.1);
                                let v270 = C::put_in_regs(ctx, v38.0);
                                let v314 = constructor_sar_i128(ctx, v270, v269);
                                let v315 = C::output(ctx, v314);
                                // Rule at src/isa/x64/lower.isle line 754.
                                return Some(v315);
                            }
                            I8X16 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v316 = &C::xmm_to_xmm_mem(ctx, v68);
                                let v317 = constructor_x64_punpcklbw(ctx, v68, v316);
                                let v318 = &C::xmm_to_xmm_mem(ctx, v68);
                                let v319 = constructor_x64_punpckhbw(ctx, v68, v318);
                                let v92 = C::value_type(ctx, v38.1);
                                let v320 = &constructor_sshr_i8x16_bigger_shift(ctx, v92, v285);
                                let v321 = constructor_x64_psraw(ctx, v317, v320);
                                let v322 = constructor_x64_psraw(ctx, v319, v320);
                                let v323 = &C::xmm_to_xmm_mem(ctx, v322);
                                let v324 = constructor_x64_packsswb(ctx, v321, v323);
                                let v325 = constructor_output_xmm(ctx, v324);
                                // Rule at src/isa/x64/lower.isle line 775.
                                return Some(v325);
                            }
                            I16X8 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v326 = constructor_x64_psraw(ctx, v68, v286);
                                let v327 = constructor_output_xmm(ctx, v326);
                                // Rule at src/isa/x64/lower.isle line 804.
                                return Some(v327);
                            }
                            I32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v285 = &constructor_mask_xmm_shift(ctx, v3, v38.1);
                                let v286 = &constructor_mov_rmi_to_xmm(ctx, v285);
                                let v328 = constructor_x64_psrad(ctx, v68, v286);
                                let v329 = constructor_output_xmm(ctx, v328);
                                // Rule at src/isa/x64/lower.isle line 807.
                                return Some(v329);
                            }
                            I64X2 => {
                                let v332 = C::use_avx512vl(ctx);
                                if v332 == true {
                                    let v333 = C::use_avx512f(ctx);
                                    if v333 == true {
                                        let v38 = C::unpack_value_array_2(ctx, v37);
                                        let v171 = C::def_inst(ctx, v38.1);
                                        if let Some(v172) = v171 {
                                            let v173 = &C::inst_data(ctx, v172);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v330,
                                                imm: v331,
                                            } = v173
                                            {
                                                if let &Opcode::Iconst = v330 {
                                                    let v334 = &C::put_in_xmm_mem(ctx, v38.0);
                                                    let v335 =
                                                        C::shift_amount_masked(ctx, v3, v331);
                                                    let v336 =
                                                        constructor_x64_vpsraq_imm(ctx, v334, v335);
                                                    let v337 = constructor_output_xmm(ctx, v336);
                                                    // Rule at src/isa/x64/lower.isle line 813.
                                                    return Some(v337);
                                                }
                                            }
                                        }
                                        let v60 = constructor_put_in_gpr(ctx, v38.1);
                                        let v338 = C::shift_mask(ctx, v3);
                                        let v339 = C::u8_as_u32(ctx, v338);
                                        let v340 = RegMemImm::Imm { simm32: v339 };
                                        let v341 = &C::gpr_mem_imm_new(ctx, &v340);
                                        let v342 = constructor_x64_and(ctx, I64, v60, v341);
                                        let v343 = constructor_put_in_xmm(ctx, v38.0);
                                        let v344 = &C::gpr_to_gpr_mem(ctx, v342);
                                        let v345 = constructor_x64_movd_to_xmm(ctx, v344);
                                        let v346 = &C::xmm_to_xmm_mem(ctx, v345);
                                        let v347 = constructor_x64_vpsraq(ctx, v343, v346);
                                        let v348 = constructor_output_xmm(ctx, v347);
                                        // Rule at src/isa/x64/lower.isle line 818.
                                        return Some(v348);
                                    }
                                }
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v171 = C::def_inst(ctx, v38.1);
                                if let Some(v172) = v171 {
                                    let v173 = &C::inst_data(ctx, v172);
                                    if let &InstructionData::UnaryImm {
                                        opcode: ref v330,
                                        imm: v331,
                                    } = v173
                                    {
                                        if let &Opcode::Iconst = v330 {
                                            let v349 = C::u64_from_imm64(ctx, v331);
                                            let v350 = C::u64_as_u32(ctx, v349);
                                            if let Some(v351) = v350 {
                                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                                let v353 = C::u32_and(ctx, v351, 0x3F);
                                                let v354 = constructor_lower_i64x2_sshr_imm(
                                                    ctx, v68, v353,
                                                );
                                                let v355 = constructor_output_xmm(ctx, v354);
                                                // Rule at src/isa/x64/lower.isle line 824.
                                                return Some(v355);
                                            }
                                        }
                                    }
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v356 = constructor_put_in_gpr(ctx, v38.1);
                                let v357 = RegMemImm::Imm { simm32: 0x3F };
                                let v358 = &C::gpr_mem_imm_new(ctx, &v357);
                                let v359 = constructor_x64_and(ctx, I64, v356, v358);
                                let v360 = constructor_lower_i64x2_sshr_gpr(ctx, v68, v359);
                                let v361 = constructor_output_xmm(ctx, v360);
                                // Rule at src/isa/x64/lower.isle line 827.
                                return Some(v361);
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v38 = C::unpack_value_array_2(ctx, v37);
                            let v311 = constructor_extend_to_gpr(ctx, v38.0, v5, &ExtendKind::Sign);
                            let v266 = &constructor_put_masked_in_imm8_gpr(ctx, v38.1, v5);
                            let v312 = constructor_x64_sar(ctx, v5, v311, v266);
                            let v313 = constructor_output_gpr(ctx, v312);
                            // Rule at src/isa/x64/lower.isle line 717.
                            return Some(v313);
                        }
                    }
                }
                &Opcode::Fadd => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1261 = constructor_x64_addss(ctx, v1249, v1260);
                                    let v1262 = constructor_output_xmm(ctx, v1261);
                                    // Rule at src/isa/x64/lower.isle line 2501.
                                    return Some(v1262);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1252 = constructor_x64_addss(ctx, v68, v69);
                                let v1253 = constructor_output_xmm(ctx, v1252);
                                // Rule at src/isa/x64/lower.isle line 2490.
                                return Some(v1253);
                            }
                            F64 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1263 = constructor_x64_addsd(ctx, v1249, v1260);
                                    let v1264 = constructor_output_xmm(ctx, v1263);
                                    // Rule at src/isa/x64/lower.isle line 2503.
                                    return Some(v1264);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1254 = constructor_x64_addsd(ctx, v68, v69);
                                let v1255 = constructor_output_xmm(ctx, v1254);
                                // Rule at src/isa/x64/lower.isle line 2492.
                                return Some(v1255);
                            }
                            F32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1265 = constructor_x64_addps(ctx, v1249, v1260);
                                    let v1266 = constructor_output_xmm(ctx, v1265);
                                    // Rule at src/isa/x64/lower.isle line 2505.
                                    return Some(v1266);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1256 = constructor_x64_addps(ctx, v68, v69);
                                let v1257 = constructor_output_xmm(ctx, v1256);
                                // Rule at src/isa/x64/lower.isle line 2494.
                                return Some(v1257);
                            }
                            F64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1267 = constructor_x64_addpd(ctx, v1249, v1260);
                                    let v1268 = constructor_output_xmm(ctx, v1267);
                                    // Rule at src/isa/x64/lower.isle line 2507.
                                    return Some(v1268);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1258 = constructor_x64_addpd(ctx, v68, v69);
                                let v1259 = constructor_output_xmm(ctx, v1258);
                                // Rule at src/isa/x64/lower.isle line 2496.
                                return Some(v1259);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fsub => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1269 = constructor_x64_subss(ctx, v68, v69);
                                let v1270 = constructor_output_xmm(ctx, v1269);
                                // Rule at src/isa/x64/lower.isle line 2512.
                                return Some(v1270);
                            }
                            F64 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1271 = constructor_x64_subsd(ctx, v68, v69);
                                let v1272 = constructor_output_xmm(ctx, v1271);
                                // Rule at src/isa/x64/lower.isle line 2514.
                                return Some(v1272);
                            }
                            F32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1273 = constructor_x64_subps(ctx, v68, v69);
                                let v1274 = constructor_output_xmm(ctx, v1273);
                                // Rule at src/isa/x64/lower.isle line 2516.
                                return Some(v1274);
                            }
                            F64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1275 = constructor_x64_subpd(ctx, v68, v69);
                                let v1276 = constructor_output_xmm(ctx, v1275);
                                // Rule at src/isa/x64/lower.isle line 2518.
                                return Some(v1276);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fmul => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1285 = constructor_x64_mulss(ctx, v1249, v1260);
                                    let v1286 = constructor_output_xmm(ctx, v1285);
                                    // Rule at src/isa/x64/lower.isle line 2534.
                                    return Some(v1286);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1277 = constructor_x64_mulss(ctx, v68, v69);
                                let v1278 = constructor_output_xmm(ctx, v1277);
                                // Rule at src/isa/x64/lower.isle line 2523.
                                return Some(v1278);
                            }
                            F64 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1287 = constructor_x64_mulsd(ctx, v1249, v1260);
                                    let v1288 = constructor_output_xmm(ctx, v1287);
                                    // Rule at src/isa/x64/lower.isle line 2536.
                                    return Some(v1288);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1279 = constructor_x64_mulsd(ctx, v68, v69);
                                let v1280 = constructor_output_xmm(ctx, v1279);
                                // Rule at src/isa/x64/lower.isle line 2525.
                                return Some(v1280);
                            }
                            F32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1289 = constructor_x64_mulps(ctx, v1249, v1260);
                                    let v1290 = constructor_output_xmm(ctx, v1289);
                                    // Rule at src/isa/x64/lower.isle line 2538.
                                    return Some(v1290);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1281 = constructor_x64_mulps(ctx, v68, v69);
                                let v1282 = constructor_output_xmm(ctx, v1281);
                                // Rule at src/isa/x64/lower.isle line 2527.
                                return Some(v1282);
                            }
                            F64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v58 = &C::sinkable_load(ctx, v38.0);
                                if let Some(v59) = v58 {
                                    let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                    let v1260 = &constructor_sink_load_to_xmm_mem(ctx, v59);
                                    let v1291 = constructor_x64_mulpd(ctx, v1249, v1260);
                                    let v1292 = constructor_output_xmm(ctx, v1291);
                                    // Rule at src/isa/x64/lower.isle line 2540.
                                    return Some(v1292);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1283 = constructor_x64_mulpd(ctx, v68, v69);
                                let v1284 = constructor_output_xmm(ctx, v1283);
                                // Rule at src/isa/x64/lower.isle line 2529.
                                return Some(v1284);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fdiv => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1293 = constructor_x64_divss(ctx, v68, v69);
                                let v1294 = constructor_output_xmm(ctx, v1293);
                                // Rule at src/isa/x64/lower.isle line 2545.
                                return Some(v1294);
                            }
                            F64 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1295 = constructor_x64_divsd(ctx, v68, v69);
                                let v1296 = constructor_output_xmm(ctx, v1295);
                                // Rule at src/isa/x64/lower.isle line 2547.
                                return Some(v1296);
                            }
                            F32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1297 = constructor_x64_divps(ctx, v68, v69);
                                let v1298 = constructor_output_xmm(ctx, v1297);
                                // Rule at src/isa/x64/lower.isle line 2549.
                                return Some(v1298);
                            }
                            F64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1299 = constructor_x64_divpd(ctx, v68, v69);
                                let v1300 = constructor_output_xmm(ctx, v1299);
                                // Rule at src/isa/x64/lower.isle line 2551.
                                return Some(v1300);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fcopysign => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v2080 = C::value_type(ctx, v38.0);
                                if v2080 == F32 {
                                    let v2130 = constructor_imm(ctx, F32, 0x80000000);
                                    let v2131 = C::xmm_new(ctx, v2130);
                                    let v2132 = &C::put_in_xmm_mem(ctx, v38.0);
                                    let v2133 = constructor_x64_andnps(ctx, v2131, v2132);
                                    let v2134 = &C::put_in_xmm_mem(ctx, v38.1);
                                    let v2135 = constructor_x64_andps(ctx, v2131, v2134);
                                    let v2136 = &C::xmm_to_xmm_mem(ctx, v2135);
                                    let v2137 = constructor_x64_orps(ctx, v2133, v2136);
                                    let v2138 = constructor_output_xmm(ctx, v2137);
                                    // Rule at src/isa/x64/lower.isle line 3916.
                                    return Some(v2138);
                                }
                            }
                            F64 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v2080 = C::value_type(ctx, v38.0);
                                if v2080 == F64 {
                                    let v2139 = constructor_imm(ctx, F64, 0x8000000000000000);
                                    let v2140 = C::xmm_new(ctx, v2139);
                                    let v2132 = &C::put_in_xmm_mem(ctx, v38.0);
                                    let v2141 = constructor_x64_andnpd(ctx, v2140, v2132);
                                    let v2134 = &C::put_in_xmm_mem(ctx, v38.1);
                                    let v2142 = constructor_x64_andpd(ctx, v2140, v2134);
                                    let v2143 = &C::xmm_to_xmm_mem(ctx, v2142);
                                    let v2144 = constructor_x64_orpd(ctx, v2141, v2143);
                                    let v2145 = constructor_output_xmm(ctx, v2144);
                                    // Rule at src/isa/x64/lower.isle line 3922.
                                    return Some(v2145);
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fmin => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v444 = constructor_put_in_xmm(ctx, v38.1);
                                let v1319 = constructor_xmm_min_max_seq(ctx, F32, true, v68, v444);
                                let v1320 = constructor_output_xmm(ctx, v1319);
                                // Rule at src/isa/x64/lower.isle line 2582.
                                return Some(v1320);
                            }
                            F64 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v444 = constructor_put_in_xmm(ctx, v38.1);
                                let v1321 = constructor_xmm_min_max_seq(ctx, F64, true, v68, v444);
                                let v1322 = constructor_output_xmm(ctx, v1321);
                                // Rule at src/isa/x64/lower.isle line 2584.
                                return Some(v1322);
                            }
                            F32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1323 = constructor_x64_minps(ctx, v68, v69);
                                let v1324 = constructor_put_in_xmm(ctx, v38.1);
                                let v1325 = &C::put_in_xmm_mem(ctx, v38.0);
                                let v1326 = constructor_x64_minps(ctx, v1324, v1325);
                                let v1327 = &C::xmm_to_xmm_mem(ctx, v1326);
                                let v1328 = constructor_x64_orps(ctx, v1323, v1327);
                                let v1329 = &C::xmm_to_xmm_mem(ctx, v1326);
                                let v1330 =
                                    constructor_x64_cmpps(ctx, v1328, v1329, &FcmpImm::Unordered);
                                let v1331 = &C::xmm_to_xmm_mem(ctx, v1330);
                                let v1332 = constructor_x64_orps(ctx, v1328, v1331);
                                let v1334 = &C::xmi_imm(ctx, 0xA);
                                let v1335 = constructor_x64_psrld(ctx, v1330, v1334);
                                let v1336 = &C::xmm_to_xmm_mem(ctx, v1332);
                                let v1337 = constructor_x64_andnps(ctx, v1335, v1336);
                                let v1338 = constructor_output_xmm(ctx, v1337);
                                // Rule at src/isa/x64/lower.isle line 2599.
                                return Some(v1338);
                            }
                            F64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1339 = constructor_x64_minpd(ctx, v68, v69);
                                let v1324 = constructor_put_in_xmm(ctx, v38.1);
                                let v1325 = &C::put_in_xmm_mem(ctx, v38.0);
                                let v1340 = constructor_x64_minpd(ctx, v1324, v1325);
                                let v1341 = &C::xmm_to_xmm_mem(ctx, v1340);
                                let v1342 = constructor_x64_orpd(ctx, v1339, v1341);
                                let v1343 = &C::xmm_to_xmm_mem(ctx, v1340);
                                let v1344 =
                                    constructor_x64_cmppd(ctx, v1339, v1343, &FcmpImm::Unordered);
                                let v1345 = &C::xmm_to_xmm_mem(ctx, v1344);
                                let v1346 = constructor_x64_orpd(ctx, v1342, v1345);
                                let v1348 = &C::xmi_imm(ctx, 0xD);
                                let v1349 = constructor_x64_psrlq(ctx, v1344, v1348);
                                let v1350 = &C::xmm_to_xmm_mem(ctx, v1346);
                                let v1351 = constructor_x64_andnpd(ctx, v1349, v1350);
                                let v1352 = constructor_output_xmm(ctx, v1351);
                                // Rule at src/isa/x64/lower.isle line 2642.
                                return Some(v1352);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fmax => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v444 = constructor_put_in_xmm(ctx, v38.1);
                                let v1354 = constructor_xmm_min_max_seq(ctx, F32, false, v68, v444);
                                let v1355 = constructor_output_xmm(ctx, v1354);
                                // Rule at src/isa/x64/lower.isle line 2654.
                                return Some(v1355);
                            }
                            F64 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v444 = constructor_put_in_xmm(ctx, v38.1);
                                let v1356 = constructor_xmm_min_max_seq(ctx, F64, false, v68, v444);
                                let v1357 = constructor_output_xmm(ctx, v1356);
                                // Rule at src/isa/x64/lower.isle line 2656.
                                return Some(v1357);
                            }
                            F32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1358 = constructor_x64_maxps(ctx, v68, v69);
                                let v1324 = constructor_put_in_xmm(ctx, v38.1);
                                let v1325 = &C::put_in_xmm_mem(ctx, v38.0);
                                let v1359 = constructor_x64_maxps(ctx, v1324, v1325);
                                let v1360 = &C::xmm_to_xmm_mem(ctx, v1359);
                                let v1361 = constructor_x64_xorps(ctx, v1358, v1360);
                                let v1362 = &C::xmm_to_xmm_mem(ctx, v1361);
                                let v1363 = constructor_x64_orps(ctx, v1358, v1362);
                                let v1364 = &C::xmm_to_xmm_mem(ctx, v1361);
                                let v1365 = constructor_x64_subps(ctx, v1363, v1364);
                                let v1366 = &C::xmm_to_xmm_mem(ctx, v1363);
                                let v1367 =
                                    constructor_x64_cmpps(ctx, v1363, v1366, &FcmpImm::Unordered);
                                let v1368 = &C::xmi_imm(ctx, 0xA);
                                let v1369 = constructor_x64_psrld(ctx, v1367, v1368);
                                let v1370 = &C::xmm_to_xmm_mem(ctx, v1365);
                                let v1371 = constructor_x64_andnps(ctx, v1369, v1370);
                                let v1372 = constructor_output_xmm(ctx, v1371);
                                // Rule at src/isa/x64/lower.isle line 2662.
                                return Some(v1372);
                            }
                            F64X2 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                let v1373 = constructor_x64_maxpd(ctx, v68, v69);
                                let v1324 = constructor_put_in_xmm(ctx, v38.1);
                                let v1325 = &C::put_in_xmm_mem(ctx, v38.0);
                                let v1374 = constructor_x64_maxpd(ctx, v1324, v1325);
                                let v1375 = &C::xmm_to_xmm_mem(ctx, v1374);
                                let v1376 = constructor_x64_xorpd(ctx, v1373, v1375);
                                let v1377 = &C::xmm_to_xmm_mem(ctx, v1376);
                                let v1378 = constructor_x64_orpd(ctx, v1373, v1377);
                                let v1379 = &C::xmm_to_xmm_mem(ctx, v1376);
                                let v1380 = constructor_x64_subpd(ctx, v1378, v1379);
                                let v1381 = &C::xmm_to_xmm_mem(ctx, v1378);
                                let v1382 =
                                    constructor_x64_cmppd(ctx, v1378, v1381, &FcmpImm::Unordered);
                                let v1383 = &C::xmi_imm(ctx, 0xD);
                                let v1384 = constructor_x64_psrlq(ctx, v1382, v1383);
                                let v1385 = &C::xmm_to_xmm_mem(ctx, v1380);
                                let v1386 = constructor_x64_andnpd(ctx, v1384, v1385);
                                let v1387 = constructor_output_xmm(ctx, v1386);
                                // Rule at src/isa/x64/lower.isle line 2705.
                                return Some(v1387);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Snarrow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v2080 = C::value_type(ctx, v38.0);
                                if v2080 == I16X8 {
                                    let v68 = constructor_put_in_xmm(ctx, v38.0);
                                    let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                    let v2081 = constructor_x64_packsswb(ctx, v68, v69);
                                    let v2082 = constructor_output_xmm(ctx, v2081);
                                    // Rule at src/isa/x64/lower.isle line 3802.
                                    return Some(v2082);
                                }
                            }
                            I16X8 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v2080 = C::value_type(ctx, v38.0);
                                if v2080 == I32X4 {
                                    let v68 = constructor_put_in_xmm(ctx, v38.0);
                                    let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                    let v2083 = constructor_x64_packssdw(ctx, v68, v69);
                                    let v2084 = constructor_output_xmm(ctx, v2083);
                                    // Rule at src/isa/x64/lower.isle line 3805.
                                    return Some(v2084);
                                }
                            }
                            I32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v171 = C::def_inst(ctx, v38.1);
                                if let Some(v172) = v171 {
                                    let v173 = &C::inst_data(ctx, v172);
                                    if let &InstructionData::UnaryConst {
                                        opcode: ref v2088,
                                        constant_handle: v2089,
                                    } = v173
                                    {
                                        if let &Opcode::Vconst = v2088 {
                                            let v180 = C::def_inst(ctx, v38.0);
                                            if let Some(v181) = v180 {
                                                let v182 = &C::inst_data(ctx, v181);
                                                if let &InstructionData::Unary {
                                                    opcode: ref v183,
                                                    arg: v184,
                                                } = v182
                                                {
                                                    match v183 {
                                                        &Opcode::FcvtToSintSat => {
                                                            let v2085 = C::first_result(ctx, v181);
                                                            if let Some(v2086) = v2085 {
                                                                let v2087 =
                                                                    C::value_type(ctx, v2086);
                                                                if v2087 == I64X2 {
                                                                    let v2090 =
                                                                        C::u128_from_constant(
                                                                            ctx, v2089,
                                                                        );
                                                                    if let Some(v2091) = v2090 {
                                                                        if v2091 == 0x0 {
                                                                            let v185 = constructor_put_in_xmm(ctx, v184);
                                                                            let v2092 =
                                                                                &C::xmm_to_xmm_mem(
                                                                                    ctx, v185,
                                                                                );
                                                                            let v2093 = constructor_x64_cmppd(ctx, v185, v2092, &FcmpImm::Equal);
                                                                            let v2095 = C::emit_u128_le_const(ctx, 0x41DFFFFFFFC0000041DFFFFFFFC00000);
                                                                            let v2096 = &constructor_const_to_xmm_mem(ctx, v2095);
                                                                            let v2097 = constructor_x64_andps(ctx, v2093, v2096);
                                                                            let v2098 =
                                                                                &C::xmm_to_xmm_mem(
                                                                                    ctx, v2097,
                                                                                );
                                                                            let v2099 = constructor_x64_minpd(ctx, v185, v2098);
                                                                            let v2100 =
                                                                                &C::xmm_to_xmm_mem(
                                                                                    ctx, v2099,
                                                                                );
                                                                            let v2101 = constructor_x64_cvttpd2dq(ctx, v2100);
                                                                            let v2102 = constructor_output_xmm(ctx, v2101);
                                                                            // Rule at src/isa/x64/lower.isle line 3814.
                                                                            return Some(v2102);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        &Opcode::X86Cvtt2dq => {
                                                            let v2085 = C::first_result(ctx, v181);
                                                            if let Some(v2086) = v2085 {
                                                                let v2087 =
                                                                    C::value_type(ctx, v2086);
                                                                if v2087 == I64X2 {
                                                                    let v2090 =
                                                                        C::u128_from_constant(
                                                                            ctx, v2089,
                                                                        );
                                                                    if let Some(v2091) = v2090 {
                                                                        if v2091 == 0x0 {
                                                                            let v499 =
                                                                                &C::put_in_xmm_mem(
                                                                                    ctx, v184,
                                                                                );
                                                                            let v2103 = constructor_x64_cvttpd2dq(ctx, v499);
                                                                            let v2104 = constructor_output_xmm(ctx, v2103);
                                                                            // Rule at src/isa/x64/lower.isle line 3838.
                                                                            return Some(v2104);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        _ => {}
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Unarrow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v2080 = C::value_type(ctx, v38.0);
                                if v2080 == I16X8 {
                                    let v68 = constructor_put_in_xmm(ctx, v38.0);
                                    let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                    let v2105 = constructor_x64_packuswb(ctx, v68, v69);
                                    let v2106 = constructor_output_xmm(ctx, v2105);
                                    // Rule at src/isa/x64/lower.isle line 3844.
                                    return Some(v2106);
                                }
                            }
                            I16X8 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v2080 = C::value_type(ctx, v38.0);
                                if v2080 == I32X4 {
                                    let v441 = C::use_sse41(ctx);
                                    if v441 == true {
                                        let v68 = constructor_put_in_xmm(ctx, v38.0);
                                        let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                        let v2107 = constructor_x64_packusdw(ctx, v68, v69);
                                        let v2108 = constructor_output_xmm(ctx, v2107);
                                        // Rule at src/isa/x64/lower.isle line 3847.
                                        return Some(v2108);
                                    }
                                    let v68 = constructor_put_in_xmm(ctx, v38.0);
                                    let v2109 =
                                        constructor_unarrow_i32x4_lanes_to_low_u16_lanes(ctx, v68);
                                    let v2110 = constructor_put_in_xmm(ctx, v38.1);
                                    let v2111 = constructor_unarrow_i32x4_lanes_to_low_u16_lanes(
                                        ctx, v2110,
                                    );
                                    let v2112 = &C::xmm_to_xmm_mem(ctx, v2111);
                                    let v2113 = constructor_x64_punpcklqdq(ctx, v2109, v2112);
                                    let v2114 = constructor_output_xmm(ctx, v2113);
                                    // Rule at src/isa/x64/lower.isle line 3857.
                                    return Some(v2114);
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Uunarrow => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v171 = C::def_inst(ctx, v38.1);
                    if let Some(v172) = v171 {
                        let v173 = &C::inst_data(ctx, v172);
                        if let &InstructionData::UnaryConst {
                            opcode: ref v2088,
                            constant_handle: v2089,
                        } = v173
                        {
                            if let &Opcode::Vconst = v2088 {
                                let v180 = C::def_inst(ctx, v38.0);
                                if let Some(v181) = v180 {
                                    let v182 = &C::inst_data(ctx, v181);
                                    if let &InstructionData::Unary {
                                        opcode: ref v183,
                                        arg: v184,
                                    } = v182
                                    {
                                        if let &Opcode::FcvtToUintSat = v183 {
                                            let v481 = C::value_type(ctx, v184);
                                            if v481 == F64X2 {
                                                let v2090 = C::u128_from_constant(ctx, v2089);
                                                if let Some(v2091) = v2090 {
                                                    if v2091 == 0x0 {
                                                        let v185 =
                                                            constructor_put_in_xmm(ctx, v184);
                                                        let v2575 =
                                                            constructor_xmm_zero(ctx, F64X2);
                                                        let v2576 = &C::xmm_to_xmm_mem(ctx, v2575);
                                                        let v2577 =
                                                            constructor_x64_maxpd(ctx, v185, v2576);
                                                        let v2579 = C::emit_u128_le_const(
                                                            ctx,
                                                            0x41EFFFFFFFE0000041EFFFFFFFE00000,
                                                        );
                                                        let v2580 = &constructor_const_to_xmm_mem(
                                                            ctx, v2579,
                                                        );
                                                        let v2581 = constructor_x64_minpd(
                                                            ctx, v2577, v2580,
                                                        );
                                                        let v2582 = C::xmm_to_reg(ctx, v2581);
                                                        let v2583 =
                                                            &constructor_xmm_to_reg_mem(ctx, v2582);
                                                        let v2584 =
                                                            &C::xmm_mem_to_reg_mem(ctx, v2583);
                                                        let v2585 = constructor_x64_round(
                                                            ctx,
                                                            F64X2,
                                                            v2584,
                                                            &RoundImm::RoundZero,
                                                        );
                                                        let v2586 = C::emit_u128_le_const(
                                                            ctx,
                                                            0x43300000000000004330000000000000,
                                                        );
                                                        let v2587 = &constructor_const_to_xmm_mem(
                                                            ctx, v2586,
                                                        );
                                                        let v2588 = constructor_x64_addpd(
                                                            ctx, v2585, v2587,
                                                        );
                                                        let v2589 = &C::xmm_to_xmm_mem(ctx, v2575);
                                                        let v2590 = constructor_x64_shufps(
                                                            ctx, v2588, v2589, 0x88,
                                                        );
                                                        let v2591 =
                                                            constructor_output_xmm(ctx, v2590);
                                                        // Rule at src/isa/x64/lower.isle line 4691.
                                                        return Some(v2591);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                &Opcode::IaddPairwise => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v1913 =
                                    C::emit_u128_le_const(ctx, 0xFF00FF00FF00FF00FF00FF00FF00FF);
                                let v1914 = &constructor_const_to_xmm_mem(ctx, v1913);
                                let v1915 = constructor_x64_movdqu_load(ctx, v1914);
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v1916 = constructor_put_in_xmm(ctx, v38.0);
                                let v1917 = &C::xmm_to_xmm_mem(ctx, v1915);
                                let v1918 = constructor_x64_pand(ctx, v1916, v1917);
                                let v1919 = constructor_put_in_xmm(ctx, v38.1);
                                let v1920 = &C::xmm_to_xmm_mem(ctx, v1915);
                                let v1921 = constructor_x64_pand(ctx, v1919, v1920);
                                let v1922 = &C::xmm_to_xmm_mem(ctx, v1921);
                                let v1923 = constructor_x64_packuswb(ctx, v1918, v1922);
                                let v1924 = constructor_put_in_xmm(ctx, v38.0);
                                let v1926 = &C::xmi_imm(ctx, 0x8);
                                let v1927 = constructor_x64_psrlw(ctx, v1924, v1926);
                                let v1928 = constructor_put_in_xmm(ctx, v38.1);
                                let v1929 = &C::xmi_imm(ctx, 0x8);
                                let v1930 = constructor_x64_psrlw(ctx, v1928, v1929);
                                let v1931 = &C::xmm_to_xmm_mem(ctx, v1930);
                                let v1932 = constructor_x64_packuswb(ctx, v1927, v1931);
                                let v1933 = &C::xmm_to_xmm_mem(ctx, v1932);
                                let v1934 = constructor_x64_paddb(ctx, v1923, v1933);
                                let v1935 = constructor_output_xmm(ctx, v1934);
                                // Rule at src/isa/x64/lower.isle line 3591.
                                return Some(v1935);
                            }
                            I16X8 => {
                                let v525 = C::use_ssse3(ctx);
                                if v525 == true {
                                    let v38 = C::unpack_value_array_2(ctx, v37);
                                    let v171 = C::def_inst(ctx, v38.1);
                                    if let Some(v172) = v171 {
                                        let v173 = &C::inst_data(ctx, v172);
                                        if let &InstructionData::Unary {
                                            opcode: ref v174,
                                            arg: v175,
                                        } = v173
                                        {
                                            match v174 {
                                                &Opcode::SwidenHigh => {
                                                    let v180 = C::def_inst(ctx, v38.0);
                                                    if let Some(v181) = v180 {
                                                        let v182 = &C::inst_data(ctx, v181);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v183,
                                                            arg: v184,
                                                        } = v182
                                                        {
                                                            if let &Opcode::SwidenLow = v183 {
                                                                if v175 == v184 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    if v481 == I8X16 {
                                                                        let v1972 = C::emit_u128_le_const(ctx, 0x1010101010101010101010101010101);
                                                                        let v1973 = constructor_x64_xmm_load_const(ctx, I8X16, v1972);
                                                                        let v1974 =
                                                                            &C::put_in_xmm_mem(
                                                                                ctx, v184,
                                                                            );
                                                                        let v1975 = constructor_x64_pmaddubsw(ctx, v1973, v1974);
                                                                        let v1976 =
                                                                            constructor_output_xmm(
                                                                                ctx, v1975,
                                                                            );
                                                                        // Rule at src/isa/x64/lower.isle line 3653.
                                                                        return Some(v1976);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                &Opcode::UwidenHigh => {
                                                    let v180 = C::def_inst(ctx, v38.0);
                                                    if let Some(v181) = v180 {
                                                        let v182 = &C::inst_data(ctx, v181);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v183,
                                                            arg: v184,
                                                        } = v182
                                                        {
                                                            if let &Opcode::UwidenLow = v183 {
                                                                if v175 == v184 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    if v481 == I8X16 {
                                                                        let v1972 = C::emit_u128_le_const(ctx, 0x1010101010101010101010101010101);
                                                                        let v1983 = &constructor_const_to_xmm_mem(ctx, v1972);
                                                                        let v1980 =
                                                                            constructor_put_in_xmm(
                                                                                ctx, v184,
                                                                            );
                                                                        let v1984 = constructor_x64_pmaddubsw(ctx, v1980, v1983);
                                                                        let v1985 =
                                                                            constructor_output_xmm(
                                                                                ctx, v1984,
                                                                            );
                                                                        // Rule at src/isa/x64/lower.isle line 3671.
                                                                        return Some(v1985);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                _ => {}
                                            }
                                        }
                                    }
                                    let v68 = constructor_put_in_xmm(ctx, v38.0);
                                    let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                    let v1936 = constructor_x64_phaddw(ctx, v68, v69);
                                    let v1937 = constructor_output_xmm(ctx, v1936);
                                    // Rule at src/isa/x64/lower.isle line 3607.
                                    return Some(v1937);
                                }
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v444 = constructor_put_in_xmm(ctx, v38.1);
                                let v316 = &C::xmm_to_xmm_mem(ctx, v68);
                                let v1939 = constructor_x64_pshuflw(ctx, v316, 0xE8);
                                let v1940 = &C::xmm_to_xmm_mem(ctx, v1939);
                                let v1941 = constructor_x64_pshufhw(ctx, v1940, 0xE8);
                                let v1942 = &C::xmm_to_xmm_mem(ctx, v1941);
                                let v1943 = constructor_x64_pshufd(ctx, v1942, 0xE8);
                                let v1944 = &C::xmm_to_xmm_mem(ctx, v444);
                                let v1945 = constructor_x64_pshuflw(ctx, v1944, 0xE8);
                                let v1946 = &C::xmm_to_xmm_mem(ctx, v1945);
                                let v1947 = constructor_x64_pshufhw(ctx, v1946, 0xE8);
                                let v1948 = &C::xmm_to_xmm_mem(ctx, v1947);
                                let v1949 = constructor_x64_pshufd(ctx, v1948, 0xE8);
                                let v1950 = &C::xmm_to_xmm_mem(ctx, v1949);
                                let v1951 = constructor_x64_punpcklqdq(ctx, v1943, v1950);
                                let v1952 = &C::xmi_imm(ctx, 0x10);
                                let v1953 = constructor_x64_psrad(ctx, v68, v1952);
                                let v1954 = &C::xmi_imm(ctx, 0x10);
                                let v1955 = constructor_x64_psrad(ctx, v444, v1954);
                                let v1956 = &C::xmm_to_xmm_mem(ctx, v1955);
                                let v1957 = constructor_x64_packssdw(ctx, v1953, v1956);
                                let v1958 = &C::xmm_to_xmm_mem(ctx, v1957);
                                let v1959 = constructor_x64_paddw(ctx, v1951, v1958);
                                let v1960 = constructor_output_xmm(ctx, v1959);
                                // Rule at src/isa/x64/lower.isle line 3611.
                                return Some(v1960);
                            }
                            I32X4 => {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v171 = C::def_inst(ctx, v38.1);
                                if let Some(v172) = v171 {
                                    let v173 = &C::inst_data(ctx, v172);
                                    match v173 {
                                        &InstructionData::Binary {
                                            opcode: ref v2013,
                                            args: ref v2014,
                                        } => {
                                            if let &Opcode::Imul = v2013 {
                                                let v180 = C::def_inst(ctx, v38.0);
                                                if let Some(v181) = v180 {
                                                    let v182 = &C::inst_data(ctx, v181);
                                                    if let &InstructionData::Binary {
                                                        opcode: ref v1998,
                                                        args: ref v1999,
                                                    } = v182
                                                    {
                                                        if let &Opcode::Imul = v1998 {
                                                            let v2000 =
                                                                C::unpack_value_array_2(ctx, v1999);
                                                            let v2003 = C::def_inst(ctx, v2000.0);
                                                            if let Some(v2004) = v2003 {
                                                                let v2005 =
                                                                    &C::inst_data(ctx, v2004);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref v2006,
                                                                    arg: v2007,
                                                                } = v2005
                                                                {
                                                                    if let &Opcode::SwidenLow =
                                                                        v2006
                                                                    {
                                                                        let v2008 = C::def_inst(
                                                                            ctx, v2000.1,
                                                                        );
                                                                        if let Some(v2009) = v2008 {
                                                                            let v2010 =
                                                                                &C::inst_data(
                                                                                    ctx, v2009,
                                                                                );
                                                                            if let &InstructionData::Unary {
                                                                                opcode: ref v2011,
                                                                                arg: v2012,
                                                                            } = v2010 {
                                                                                if let &Opcode::SwidenLow = v2011 {
                                                                                    let v2015 = C::unpack_value_array_2(ctx, v2014);
                                                                                    let v2018 = C::def_inst(ctx, v2015.0);
                                                                                    if let Some(v2019) = v2018 {
                                                                                        let v2020 = &C::inst_data(ctx, v2019);
                                                                                        if let &InstructionData::Unary {
                                                                                            opcode: ref v2021,
                                                                                            arg: v2022,
                                                                                        } = v2020 {
                                                                                            if let &Opcode::SwidenHigh = v2021 {
                                                                                                if v2007 == v2022 {
                                                                                                    let v2023 = C::def_inst(ctx, v2015.1);
                                                                                                    if let Some(v2024) = v2023 {
                                                                                                        let v2025 = &C::inst_data(ctx, v2024);
                                                                                                        if let &InstructionData::Unary {
                                                                                                            opcode: ref v2026,
                                                                                                            arg: v2027,
                                                                                                        } = v2025 {
                                                                                                            if let &Opcode::SwidenHigh = v2026 {
                                                                                                                if v2012 == v2027 {
                                                                                                                    let v2028 = constructor_put_in_xmm(ctx, v2007);
                                                                                                                    let v2029 = &C::put_in_xmm_mem(ctx, v2012);
                                                                                                                    let v2030 = constructor_x64_pmaddwd(ctx, v2028, v2029);
                                                                                                                    let v2031 = constructor_output_xmm(ctx, v2030);
                                                                                                                    // Rule at src/isa/x64/lower.isle line 3694.
                                                                                                                    return Some(v2031);
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &InstructionData::Unary {
                                            opcode: ref v174,
                                            arg: v175,
                                        } => {
                                            match v174 {
                                                &Opcode::SwidenHigh => {
                                                    let v180 = C::def_inst(ctx, v38.0);
                                                    if let Some(v181) = v180 {
                                                        let v182 = &C::inst_data(ctx, v181);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v183,
                                                            arg: v184,
                                                        } = v182
                                                        {
                                                            if let &Opcode::SwidenLow = v183 {
                                                                if v175 == v184 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    if v481 == I16X8 {
                                                                        let v1978 = C::emit_u128_le_const(ctx, 0x10001000100010001000100010001);
                                                                        let v1979 = &constructor_const_to_xmm_mem(ctx, v1978);
                                                                        let v1980 =
                                                                            constructor_put_in_xmm(
                                                                                ctx, v184,
                                                                            );
                                                                        let v1981 =
                                                                            constructor_x64_pmaddwd(
                                                                                ctx, v1980, v1979,
                                                                            );
                                                                        let v1982 =
                                                                            constructor_output_xmm(
                                                                                ctx, v1981,
                                                                            );
                                                                        // Rule at src/isa/x64/lower.isle line 3663.
                                                                        return Some(v1982);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                &Opcode::UwidenHigh => {
                                                    let v180 = C::def_inst(ctx, v38.0);
                                                    if let Some(v181) = v180 {
                                                        let v182 = &C::inst_data(ctx, v181);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v183,
                                                            arg: v184,
                                                        } = v182
                                                        {
                                                            if let &Opcode::UwidenLow = v183 {
                                                                if v175 == v184 {
                                                                    let v481 =
                                                                        C::value_type(ctx, v184);
                                                                    if v481 == I16X8 {
                                                                        let v1987 = C::emit_u128_le_const(ctx, 0x80008000800080008000800080008000);
                                                                        let v1988 = &constructor_const_to_xmm_mem(ctx, v1987);
                                                                        let v1980 =
                                                                            constructor_put_in_xmm(
                                                                                ctx, v184,
                                                                            );
                                                                        let v1989 =
                                                                            constructor_x64_pxor(
                                                                                ctx, v1980, v1988,
                                                                            );
                                                                        let v1990 = C::emit_u128_le_const(ctx, 0x10001000100010001000100010001);
                                                                        let v1991 = &constructor_const_to_xmm_mem(ctx, v1990);
                                                                        let v1992 =
                                                                            constructor_x64_pmaddwd(
                                                                                ctx, v1989, v1991,
                                                                            );
                                                                        let v1994 = C::emit_u128_le_const(ctx, 0x10000000100000001000000010000);
                                                                        let v1995 = &constructor_const_to_xmm_mem(ctx, v1994);
                                                                        let v1996 =
                                                                            constructor_x64_paddd(
                                                                                ctx, v1992, v1995,
                                                                            );
                                                                        let v1997 =
                                                                            constructor_output_xmm(
                                                                                ctx, v1996,
                                                                            );
                                                                        // Rule at src/isa/x64/lower.isle line 3680.
                                                                        return Some(v1997);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                _ => {}
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                                let v525 = C::use_ssse3(ctx);
                                if v525 == true {
                                    let v68 = constructor_put_in_xmm(ctx, v38.0);
                                    let v69 = &C::put_in_xmm_mem(ctx, v38.1);
                                    let v1961 = constructor_x64_phaddd(ctx, v68, v69);
                                    let v1962 = constructor_output_xmm(ctx, v1961);
                                    // Rule at src/isa/x64/lower.isle line 3637.
                                    return Some(v1962);
                                }
                                let v68 = constructor_put_in_xmm(ctx, v38.0);
                                let v444 = constructor_put_in_xmm(ctx, v38.1);
                                let v1963 = &C::xmm_to_xmm_mem(ctx, v444);
                                let v1965 = constructor_x64_shufps(ctx, v68, v1963, 0x88);
                                let v447 = &C::xmm_to_xmm_mem(ctx, v444);
                                let v1967 = constructor_x64_shufps(ctx, v68, v447, 0xDD);
                                let v1968 = &C::xmm_to_xmm_mem(ctx, v1967);
                                let v1969 = constructor_x64_paddd(ctx, v1965, v1968);
                                let v1970 = constructor_output_xmm(ctx, v1969);
                                // Rule at src/isa/x64/lower.isle line 3641.
                                return Some(v1970);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::X86Pmaddubsw => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I16X8 {
                            let v525 = C::use_ssse3(ctx);
                            if v525 == true {
                                let v38 = C::unpack_value_array_2(ctx, v37);
                                let v1249 = constructor_put_in_xmm(ctx, v38.1);
                                let v177 = &C::put_in_xmm_mem(ctx, v38.0);
                                let v1250 = constructor_x64_pmaddubsw(ctx, v1249, v177);
                                let v1251 = constructor_output_xmm(ctx, v1250);
                                // Rule at src/isa/x64/lower.isle line 2484.
                                return Some(v1251);
                            }
                        }
                    }
                }
                &Opcode::Iconcat => {
                    let v38 = C::unpack_value_array_2(ctx, v37);
                    let v2080 = C::value_type(ctx, v38.0);
                    if v2080 == I64 {
                        let v2528 = C::put_in_reg(ctx, v38.0);
                        let v2529 = C::put_in_reg(ctx, v38.1);
                        let v2530 = C::value_regs(ctx, v2528, v2529);
                        let v2531 = C::output(ctx, v2530);
                        // Rule at src/isa/x64/lower.isle line 4607.
                        return Some(v2531);
                    }
                }
                _ => {}
            }
        }
        &InstructionData::BinaryImm8 {
            opcode: ref v2364,
            arg: v2365,
            imm: v2366,
        } => {
            if let &Opcode::Extractlane = v2364 {
                if v2366 == 0x0 {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v162 = C::ty_scalar_float(ctx, v3);
                        if let Some(v163) = v162 {
                            let v2367 = constructor_output_value(ctx, v2365);
                            // Rule at src/isa/x64/lower.isle line 4370.
                            return Some(v2367);
                        }
                    }
                }
                let v2368 = C::value_type(ctx, v2365);
                match v2368 {
                    I8X16 => {
                        let v441 = C::use_sse41(ctx);
                        if v441 == true {
                            let v2375 = constructor_put_in_xmm(ctx, v2365);
                            let v2369 = C::u8_from_uimm8(ctx, v2366);
                            let v2376 = constructor_x64_pextrb(ctx, v2375, v2369);
                            let v2377 = constructor_output_gpr(ctx, v2376);
                            // Rule at src/isa/x64/lower.isle line 4385.
                            return Some(v2377);
                        }
                        let v2369 = C::u8_from_uimm8(ctx, v2366);
                        let v2378 = C::u8_and(ctx, v2369, 0x1);
                        match v2378 {
                            0x0 => {
                                let v2375 = constructor_put_in_xmm(ctx, v2365);
                                let v2379 = C::u8_shr(ctx, v2369, 0x1);
                                let v2380 = constructor_x64_pextrw(ctx, v2375, v2379);
                                let v2384 = constructor_output_gpr(ctx, v2380);
                                // Rule at src/isa/x64/lower.isle line 4396.
                                return Some(v2384);
                            }
                            0x1 => {
                                let v2375 = constructor_put_in_xmm(ctx, v2365);
                                let v2379 = C::u8_shr(ctx, v2369, 0x1);
                                let v2380 = constructor_x64_pextrw(ctx, v2375, v2379);
                                let v1204 = Imm8Reg::Imm8 { imm: 0x8 };
                                let v2381 = &C::imm8_reg_to_imm8_gpr(ctx, &v1204);
                                let v2382 = constructor_x64_shr(ctx, I16, v2380, v2381);
                                let v2383 = constructor_output_gpr(ctx, v2382);
                                // Rule at src/isa/x64/lower.isle line 4389.
                                return Some(v2383);
                            }
                            _ => {}
                        }
                    }
                    I16X8 => {
                        let v2375 = constructor_put_in_xmm(ctx, v2365);
                        let v2369 = C::u8_from_uimm8(ctx, v2366);
                        let v2385 = constructor_x64_pextrw(ctx, v2375, v2369);
                        let v2386 = constructor_output_gpr(ctx, v2385);
                        // Rule at src/isa/x64/lower.isle line 4401.
                        return Some(v2386);
                    }
                    I32X4 => {
                        let v441 = C::use_sse41(ctx);
                        if v441 == true {
                            let v2375 = constructor_put_in_xmm(ctx, v2365);
                            let v2369 = C::u8_from_uimm8(ctx, v2366);
                            let v2387 = constructor_x64_pextrd(ctx, v2375, v2369);
                            let v2388 = constructor_output_gpr(ctx, v2387);
                            // Rule at src/isa/x64/lower.isle line 4405.
                            return Some(v2388);
                        }
                        if v2366 == 0x0 {
                            let v2375 = constructor_put_in_xmm(ctx, v2365);
                            let v2389 = constructor_x64_movd_to_gpr(ctx, v2375);
                            let v2390 = constructor_output_gpr(ctx, v2389);
                            // Rule at src/isa/x64/lower.isle line 4408.
                            return Some(v2390);
                        }
                        let v2370 = &C::put_in_xmm_mem(ctx, v2365);
                        let v2369 = C::u8_from_uimm8(ctx, v2366);
                        let v2371 = constructor_x64_pshufd(ctx, v2370, v2369);
                        let v2391 = constructor_x64_movd_to_gpr(ctx, v2371);
                        let v2392 = constructor_output_gpr(ctx, v2391);
                        // Rule at src/isa/x64/lower.isle line 4410.
                        return Some(v2392);
                    }
                    I64X2 => {
                        let v441 = C::use_sse41(ctx);
                        if v441 == true {
                            let v2375 = constructor_put_in_xmm(ctx, v2365);
                            let v2369 = C::u8_from_uimm8(ctx, v2366);
                            let v2393 = constructor_x64_pextrq(ctx, v2375, v2369);
                            let v2394 = constructor_output_gpr(ctx, v2393);
                            // Rule at src/isa/x64/lower.isle line 4414.
                            return Some(v2394);
                        }
                        match v2366 {
                            0x0 => {
                                let v2375 = constructor_put_in_xmm(ctx, v2365);
                                let v2395 = constructor_x64_movq_to_gpr(ctx, v2375);
                                let v2396 = constructor_output_gpr(ctx, v2395);
                                // Rule at src/isa/x64/lower.isle line 4417.
                                return Some(v2396);
                            }
                            0x1 => {
                                let v2370 = &C::put_in_xmm_mem(ctx, v2365);
                                let v2397 = constructor_x64_pshufd(ctx, v2370, 0xE);
                                let v2398 = constructor_x64_movq_to_gpr(ctx, v2397);
                                let v2399 = constructor_output_gpr(ctx, v2398);
                                // Rule at src/isa/x64/lower.isle line 4419.
                                return Some(v2399);
                            }
                            _ => {}
                        }
                    }
                    F32X4 => {
                        let v2370 = &C::put_in_xmm_mem(ctx, v2365);
                        let v2369 = C::u8_from_uimm8(ctx, v2366);
                        let v2371 = constructor_x64_pshufd(ctx, v2370, v2369);
                        let v2372 = constructor_output_xmm(ctx, v2371);
                        // Rule at src/isa/x64/lower.isle line 4374.
                        return Some(v2372);
                    }
                    F64X2 => {
                        if v2366 == 0x1 {
                            let v2370 = &C::put_in_xmm_mem(ctx, v2365);
                            let v2373 = constructor_x64_pshufd(ctx, v2370, 0xEE);
                            let v2374 = constructor_output_xmm(ctx, v2373);
                            // Rule at src/isa/x64/lower.isle line 4378.
                            return Some(v2374);
                        }
                    }
                    _ => {}
                }
            }
        }
        &InstructionData::Call {
            opcode: ref v1755,
            args: v1756,
            func_ref: v1757,
        } => {
            match v1755 {
                &Opcode::Call => {
                    let v1759 = C::func_ref_data(ctx, v1757);
                    let v1758 = C::value_list_slice(ctx, v1756);
                    let v1763 = C::gen_call(ctx, v1759.0, v1759.1, v1759.2, v1758);
                    // Rule at src/isa/x64/lower.isle line 3237.
                    return Some(v1763);
                }
                &Opcode::ReturnCall => {
                    let v1759 = C::func_ref_data(ctx, v1757);
                    let v1758 = C::value_list_slice(ctx, v1756);
                    let v1773 = C::gen_return_call(ctx, v1759.0, v1759.1, v1759.2, v1758);
                    // Rule at src/isa/x64/lower.isle line 3245.
                    return Some(v1773);
                }
                _ => {}
            }
        }
        &InstructionData::CallIndirect {
            opcode: ref v1764,
            args: v1765,
            sig_ref: v1766,
        } => {
            match v1764 {
                &Opcode::CallIndirect => {
                    let v1767 = C::value_list_slice(ctx, v1765);
                    let v1768 = C::value_slice_unwrap(ctx, v1767);
                    if let Some(v1769) = v1768 {
                        let v1772 = C::gen_call_indirect(ctx, v1766, v1769.0, v1769.1);
                        // Rule at src/isa/x64/lower.isle line 3240.
                        return Some(v1772);
                    }
                }
                &Opcode::ReturnCallIndirect => {
                    let v1767 = C::value_list_slice(ctx, v1765);
                    let v1768 = C::value_slice_unwrap(ctx, v1767);
                    if let Some(v1769) = v1768 {
                        let v1774 = C::gen_return_call_indirect(ctx, v1766, v1769.0, v1769.1);
                        // Rule at src/isa/x64/lower.isle line 3248.
                        return Some(v1774);
                    }
                }
                _ => {}
            }
        }
        &InstructionData::FloatCompare {
            opcode: ref v957,
            args: ref v958,
            cond: ref v959,
        } => {
            if let &Opcode::Fcmp = v957 {
                match v959 {
                    &FloatCC::Equal => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v974 = constructor_x64_cmpp(ctx, v970, v971, v972, &FcmpImm::Equal);
                            let v975 = constructor_output_xmm(ctx, v974);
                            // Rule at src/isa/x64/lower.isle line 2003.
                            return Some(v975);
                        }
                    }
                    &FloatCC::GreaterThan => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v997 = constructor_put_in_xmm(ctx, v960.1);
                            let v998 = &C::put_in_xmm_mem(ctx, v960.0);
                            let v999 =
                                constructor_x64_cmpp(ctx, v970, v997, v998, &FcmpImm::LessThan);
                            let v1000 = constructor_output_xmm(ctx, v999);
                            // Rule at src/isa/x64/lower.isle line 2023.
                            return Some(v1000);
                        }
                    }
                    &FloatCC::GreaterThanOrEqual => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v997 = constructor_put_in_xmm(ctx, v960.1);
                            let v998 = &C::put_in_xmm_mem(ctx, v960.0);
                            let v1001 = constructor_x64_cmpp(
                                ctx,
                                v970,
                                v997,
                                v998,
                                &FcmpImm::LessThanOrEqual,
                            );
                            let v1002 = constructor_output_xmm(ctx, v1001);
                            // Rule at src/isa/x64/lower.isle line 2025.
                            return Some(v1002);
                        }
                    }
                    &FloatCC::LessThan => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v980 =
                                constructor_x64_cmpp(ctx, v970, v971, v972, &FcmpImm::LessThan);
                            let v981 = constructor_output_xmm(ctx, v980);
                            // Rule at src/isa/x64/lower.isle line 2007.
                            return Some(v981);
                        }
                    }
                    &FloatCC::LessThanOrEqual => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v983 = constructor_x64_cmpp(
                                ctx,
                                v970,
                                v971,
                                v972,
                                &FcmpImm::LessThanOrEqual,
                            );
                            let v984 = constructor_output_xmm(ctx, v983);
                            // Rule at src/isa/x64/lower.isle line 2009.
                            return Some(v984);
                        }
                    }
                    &FloatCC::NotEqual => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v977 =
                                constructor_x64_cmpp(ctx, v970, v971, v972, &FcmpImm::NotEqual);
                            let v978 = constructor_output_xmm(ctx, v977);
                            // Rule at src/isa/x64/lower.isle line 2005.
                            return Some(v978);
                        }
                    }
                    &FloatCC::Ordered => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v986 =
                                constructor_x64_cmpp(ctx, v970, v971, v972, &FcmpImm::Ordered);
                            let v987 = constructor_output_xmm(ctx, v986);
                            // Rule at src/isa/x64/lower.isle line 2011.
                            return Some(v987);
                        }
                    }
                    &FloatCC::Unordered => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v989 =
                                constructor_x64_cmpp(ctx, v970, v971, v972, &FcmpImm::Unordered);
                            let v990 = constructor_output_xmm(ctx, v989);
                            // Rule at src/isa/x64/lower.isle line 2013.
                            return Some(v990);
                        }
                    }
                    &FloatCC::UnorderedOrGreaterThan => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v992 = constructor_x64_cmpp(
                                ctx,
                                v970,
                                v971,
                                v972,
                                &FcmpImm::UnorderedOrGreaterThan,
                            );
                            let v993 = constructor_output_xmm(ctx, v992);
                            // Rule at src/isa/x64/lower.isle line 2015.
                            return Some(v993);
                        }
                    }
                    &FloatCC::UnorderedOrGreaterThanOrEqual => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v971 = constructor_put_in_xmm(ctx, v960.0);
                            let v972 = &C::put_in_xmm_mem(ctx, v960.1);
                            let v995 = constructor_x64_cmpp(
                                ctx,
                                v970,
                                v971,
                                v972,
                                &FcmpImm::UnorderedOrGreaterThanOrEqual,
                            );
                            let v996 = constructor_output_xmm(ctx, v995);
                            // Rule at src/isa/x64/lower.isle line 2017.
                            return Some(v996);
                        }
                    }
                    &FloatCC::UnorderedOrLessThan => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v997 = constructor_put_in_xmm(ctx, v960.1);
                            let v998 = &C::put_in_xmm_mem(ctx, v960.0);
                            let v1003 = constructor_x64_cmpp(
                                ctx,
                                v970,
                                v997,
                                v998,
                                &FcmpImm::UnorderedOrGreaterThan,
                            );
                            let v1004 = constructor_output_xmm(ctx, v1003);
                            // Rule at src/isa/x64/lower.isle line 2027.
                            return Some(v1004);
                        }
                    }
                    &FloatCC::UnorderedOrLessThanOrEqual => {
                        let v960 = C::unpack_value_array_2(ctx, v958);
                        let v963 = C::value_type(ctx, v960.0);
                        let v969 = C::ty_vec128(ctx, v963);
                        if let Some(v970) = v969 {
                            let v997 = constructor_put_in_xmm(ctx, v960.1);
                            let v998 = &C::put_in_xmm_mem(ctx, v960.0);
                            let v1005 = constructor_x64_cmpp(
                                ctx,
                                v970,
                                v997,
                                v998,
                                &FcmpImm::UnorderedOrGreaterThanOrEqual,
                            );
                            let v1006 = constructor_output_xmm(ctx, v1005);
                            // Rule at src/isa/x64/lower.isle line 2029.
                            return Some(v1006);
                        }
                    }
                    _ => {}
                }
                let v960 = C::unpack_value_array_2(ctx, v958);
                let v963 = C::value_type(ctx, v960.0);
                let v964 = C::ty_scalar_float(ctx, v963);
                if let Some(v965) = v964 {
                    let v966 = &constructor_emit_fcmp(ctx, v959, v960.0, v960.1);
                    let v967 = constructor_lower_fcmp_bool(ctx, v966);
                    let v968 = C::output(ctx, v967);
                    // Rule at src/isa/x64/lower.isle line 1996.
                    return Some(v968);
                }
            }
        }
        &InstructionData::FuncAddr {
            opcode: ref v1679,
            func_ref: v1680,
        } => {
            if let &Opcode::FuncAddr = v1679 {
                let v1681 = C::func_ref_data(ctx, v1680);
                let v1686 = constructor_load_ext_name(ctx, v1681.1, 0x0, v1681.2);
                let v1687 = constructor_output_reg(ctx, v1686);
                // Rule at src/isa/x64/lower.isle line 3179.
                return Some(v1687);
            }
        }
        &InstructionData::IntAddTrap {
            opcode: ref v791,
            args: ref v792,
            code: ref v793,
        } => {
            if let &Opcode::UaddOverflowTrap = v791 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v3 = C::value_type(ctx, v2);
                    let v4 = C::fits_in_64(ctx, v3);
                    if let Some(v5) = v4 {
                        let v794 = C::unpack_value_array_2(ctx, v792);
                        let v810 = &C::sinkable_load(ctx, v794.0);
                        if let Some(v811) = v810 {
                            let v805 = constructor_put_in_gpr(ctx, v794.1);
                            let v812 = &constructor_sink_load_to_gpr_mem_imm(ctx, v811);
                            let v813 = &constructor_x64_add_with_flags_paired(ctx, v5, v805, v812);
                            let v800 = &constructor_trap_if(ctx, &CC::B, v793);
                            let v814 = constructor_with_flags(ctx, v813, v800);
                            let v815 = C::output(ctx, v814);
                            // Rule at src/isa/x64/lower.isle line 1784.
                            return Some(v815);
                        }
                        let v803 = &C::simm32_from_value(ctx, v794.0);
                        if let Some(v804) = v803 {
                            let v805 = constructor_put_in_gpr(ctx, v794.1);
                            let v806 = &constructor_x64_add_with_flags_paired(ctx, v5, v805, v804);
                            let v807 = &constructor_trap_if(ctx, &CC::B, v793);
                            let v808 = constructor_with_flags(ctx, v806, v807);
                            let v809 = C::output(ctx, v808);
                            // Rule at src/isa/x64/lower.isle line 1778.
                            return Some(v809);
                        }
                        let v797 = constructor_put_in_gpr(ctx, v794.0);
                        let v798 = &constructor_put_in_gpr_mem_imm(ctx, v794.1);
                        let v799 = &constructor_x64_add_with_flags_paired(ctx, v5, v797, v798);
                        let v800 = &constructor_trap_if(ctx, &CC::B, v793);
                        let v801 = constructor_with_flags(ctx, v799, v800);
                        let v802 = C::output(ctx, v801);
                        // Rule at src/isa/x64/lower.isle line 1770.
                        return Some(v802);
                    }
                }
            }
        }
        &InstructionData::IntCompare {
            opcode: ref v820,
            args: ref v821,
            cond: ref v822,
        } => {
            if let &Opcode::Icmp = v820 {
                match v822 {
                    &IntCC::Equal => {
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v876 = constructor_put_in_xmm(ctx, v823.0);
                            let v877 = &C::put_in_xmm_mem(ctx, v823.1);
                            let v878 = constructor_x64_pcmpeq(ctx, v875, v876, v877);
                            let v879 = constructor_output_xmm(ctx, v878);
                            // Rule at src/isa/x64/lower.isle line 1846.
                            return Some(v879);
                        }
                    }
                    &IntCC::NotEqual => {
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v876 = constructor_put_in_xmm(ctx, v823.0);
                            let v877 = &C::put_in_xmm_mem(ctx, v823.1);
                            let v878 = constructor_x64_pcmpeq(ctx, v875, v876, v877);
                            let v880 = constructor_vector_all_ones(ctx);
                            let v881 = &C::xmm_to_xmm_mem(ctx, v880);
                            let v882 = constructor_x64_pxor(ctx, v878, v881);
                            let v883 = constructor_output_xmm(ctx, v882);
                            // Rule at src/isa/x64/lower.isle line 1851.
                            return Some(v883);
                        }
                    }
                    &IntCC::SignedGreaterThan => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v823 = C::unpack_value_array_2(ctx, v821);
                                let v844 = C::def_inst(ctx, v823.0);
                                if let Some(v845) = v844 {
                                    let v846 = &C::inst_data(ctx, v845);
                                    if let &InstructionData::UnaryImm {
                                        opcode: ref v847,
                                        imm: v848,
                                    } = v846
                                    {
                                        if let &Opcode::Iconst = v847 {
                                            let v849 = C::u64_from_imm64(ctx, v848);
                                            if v849 == 0x0 {
                                                let v850 = C::value_type(ctx, v823.1);
                                                match v850 {
                                                    I32 => {
                                                        let v851 =
                                                            constructor_put_in_gpr(ctx, v823.1);
                                                        let v863 = Imm8Reg::Imm8 { imm: 0x1F };
                                                        let v864 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v863);
                                                        let v867 = constructor_x64_shr(
                                                            ctx, I32, v851, v864,
                                                        );
                                                        let v868 =
                                                            constructor_output_gpr(ctx, v867);
                                                        // Rule at src/isa/x64/lower.isle line 1830.
                                                        return Some(v868);
                                                    }
                                                    I64 => {
                                                        let v851 =
                                                            constructor_put_in_gpr(ctx, v823.1);
                                                        let v840 = Imm8Reg::Imm8 { imm: 0x3F };
                                                        let v841 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v840);
                                                        let v852 = constructor_x64_shr(
                                                            ctx, I64, v851, v841,
                                                        );
                                                        let v853 =
                                                            constructor_output_gpr(ctx, v852);
                                                        // Rule at src/isa/x64/lower.isle line 1814.
                                                        return Some(v853);
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v876 = constructor_put_in_xmm(ctx, v823.0);
                            let v877 = &C::put_in_xmm_mem(ctx, v823.1);
                            let v884 = constructor_x64_pcmpgt(ctx, v875, v876, v877);
                            let v885 = constructor_output_xmm(ctx, v884);
                            // Rule at src/isa/x64/lower.isle line 1858.
                            return Some(v885);
                        }
                    }
                    &IntCC::SignedGreaterThanOrEqual => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v823 = C::unpack_value_array_2(ctx, v821);
                                let v826 = C::value_type(ctx, v823.0);
                                match v826 {
                                    I32 => {
                                        let v832 = C::def_inst(ctx, v823.1);
                                        if let Some(v833) = v832 {
                                            let v834 = &C::inst_data(ctx, v833);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v835,
                                                imm: v836,
                                            } = v834
                                            {
                                                if let &Opcode::Iconst = v835 {
                                                    let v837 = C::u64_from_imm64(ctx, v836);
                                                    if v837 == 0x0 {
                                                        let v838 =
                                                            constructor_put_in_gpr(ctx, v823.0);
                                                        let v858 =
                                                            constructor_x64_not(ctx, I64, v838);
                                                        let v863 = Imm8Reg::Imm8 { imm: 0x1F };
                                                        let v869 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v863);
                                                        let v872 = constructor_x64_shr(
                                                            ctx, I32, v858, v869,
                                                        );
                                                        let v873 =
                                                            constructor_output_gpr(ctx, v872);
                                                        // Rule at src/isa/x64/lower.isle line 1838.
                                                        return Some(v873);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    I64 => {
                                        let v832 = C::def_inst(ctx, v823.1);
                                        if let Some(v833) = v832 {
                                            let v834 = &C::inst_data(ctx, v833);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v835,
                                                imm: v836,
                                            } = v834
                                            {
                                                if let &Opcode::Iconst = v835 {
                                                    let v837 = C::u64_from_imm64(ctx, v836);
                                                    if v837 == 0x0 {
                                                        let v838 =
                                                            constructor_put_in_gpr(ctx, v823.0);
                                                        let v858 =
                                                            constructor_x64_not(ctx, I64, v838);
                                                        let v840 = Imm8Reg::Imm8 { imm: 0x3F };
                                                        let v855 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v840);
                                                        let v859 = constructor_x64_shr(
                                                            ctx, I64, v858, v855,
                                                        );
                                                        let v860 =
                                                            constructor_output_gpr(ctx, v859);
                                                        // Rule at src/isa/x64/lower.isle line 1822.
                                                        return Some(v860);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                        }
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v918 = constructor_has_pmaxs(ctx, v875);
                            if v918 == true {
                                let v876 = constructor_put_in_xmm(ctx, v823.0);
                                let v901 = constructor_put_in_xmm(ctx, v823.0);
                                let v919 = &C::put_in_xmm_mem(ctx, v823.1);
                                let v920 = constructor_x64_pmaxs(ctx, v875, v901, v919);
                                let v921 = &C::xmm_to_xmm_mem(ctx, v920);
                                let v922 = constructor_x64_pcmpeq(ctx, v875, v876, v921);
                                let v923 = constructor_output_xmm(ctx, v922);
                                // Rule at src/isa/x64/lower.isle line 1908.
                                return Some(v923);
                            }
                            let v886 = constructor_put_in_xmm(ctx, v823.1);
                            let v887 = &C::put_in_xmm_mem(ctx, v823.0);
                            let v888 = constructor_x64_pcmpgt(ctx, v875, v886, v887);
                            let v880 = constructor_vector_all_ones(ctx);
                            let v881 = &C::xmm_to_xmm_mem(ctx, v880);
                            let v924 = constructor_x64_pxor(ctx, v888, v881);
                            let v925 = constructor_output_xmm(ctx, v924);
                            // Rule at src/isa/x64/lower.isle line 1914.
                            return Some(v925);
                        }
                    }
                    &IntCC::SignedLessThan => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v823 = C::unpack_value_array_2(ctx, v821);
                                let v826 = C::value_type(ctx, v823.0);
                                match v826 {
                                    I32 => {
                                        let v832 = C::def_inst(ctx, v823.1);
                                        if let Some(v833) = v832 {
                                            let v834 = &C::inst_data(ctx, v833);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v835,
                                                imm: v836,
                                            } = v834
                                            {
                                                if let &Opcode::Iconst = v835 {
                                                    let v837 = C::u64_from_imm64(ctx, v836);
                                                    if v837 == 0x0 {
                                                        let v838 =
                                                            constructor_put_in_gpr(ctx, v823.0);
                                                        let v863 = Imm8Reg::Imm8 { imm: 0x1F };
                                                        let v864 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v863);
                                                        let v865 = constructor_x64_shr(
                                                            ctx, I32, v838, v864,
                                                        );
                                                        let v866 =
                                                            constructor_output_gpr(ctx, v865);
                                                        // Rule at src/isa/x64/lower.isle line 1826.
                                                        return Some(v866);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    I64 => {
                                        let v832 = C::def_inst(ctx, v823.1);
                                        if let Some(v833) = v832 {
                                            let v834 = &C::inst_data(ctx, v833);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v835,
                                                imm: v836,
                                            } = v834
                                            {
                                                if let &Opcode::Iconst = v835 {
                                                    let v837 = C::u64_from_imm64(ctx, v836);
                                                    if v837 == 0x0 {
                                                        let v838 =
                                                            constructor_put_in_gpr(ctx, v823.0);
                                                        let v840 = Imm8Reg::Imm8 { imm: 0x3F };
                                                        let v841 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v840);
                                                        let v842 = constructor_x64_shr(
                                                            ctx, I64, v838, v841,
                                                        );
                                                        let v843 =
                                                            constructor_output_gpr(ctx, v842);
                                                        // Rule at src/isa/x64/lower.isle line 1810.
                                                        return Some(v843);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                        }
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v886 = constructor_put_in_xmm(ctx, v823.1);
                            let v887 = &C::put_in_xmm_mem(ctx, v823.0);
                            let v888 = constructor_x64_pcmpgt(ctx, v875, v886, v887);
                            let v889 = constructor_output_xmm(ctx, v888);
                            // Rule at src/isa/x64/lower.isle line 1863.
                            return Some(v889);
                        }
                    }
                    &IntCC::SignedLessThanOrEqual => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v823 = C::unpack_value_array_2(ctx, v821);
                                let v844 = C::def_inst(ctx, v823.0);
                                if let Some(v845) = v844 {
                                    let v846 = &C::inst_data(ctx, v845);
                                    if let &InstructionData::UnaryImm {
                                        opcode: ref v847,
                                        imm: v848,
                                    } = v846
                                    {
                                        if let &Opcode::Iconst = v847 {
                                            let v849 = C::u64_from_imm64(ctx, v848);
                                            if v849 == 0x0 {
                                                let v850 = C::value_type(ctx, v823.1);
                                                match v850 {
                                                    I32 => {
                                                        let v851 =
                                                            constructor_put_in_gpr(ctx, v823.1);
                                                        let v854 =
                                                            constructor_x64_not(ctx, I64, v851);
                                                        let v863 = Imm8Reg::Imm8 { imm: 0x1F };
                                                        let v869 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v863);
                                                        let v870 = constructor_x64_shr(
                                                            ctx, I32, v854, v869,
                                                        );
                                                        let v871 =
                                                            constructor_output_gpr(ctx, v870);
                                                        // Rule at src/isa/x64/lower.isle line 1834.
                                                        return Some(v871);
                                                    }
                                                    I64 => {
                                                        let v851 =
                                                            constructor_put_in_gpr(ctx, v823.1);
                                                        let v854 =
                                                            constructor_x64_not(ctx, I64, v851);
                                                        let v840 = Imm8Reg::Imm8 { imm: 0x3F };
                                                        let v855 =
                                                            &C::imm8_reg_to_imm8_gpr(ctx, &v840);
                                                        let v856 = constructor_x64_shr(
                                                            ctx, I64, v854, v855,
                                                        );
                                                        let v857 =
                                                            constructor_output_gpr(ctx, v856);
                                                        // Rule at src/isa/x64/lower.isle line 1818.
                                                        return Some(v857);
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v926 = constructor_has_pmins(ctx, v875);
                            if v926 == true {
                                let v876 = constructor_put_in_xmm(ctx, v823.0);
                                let v901 = constructor_put_in_xmm(ctx, v823.0);
                                let v919 = &C::put_in_xmm_mem(ctx, v823.1);
                                let v927 = constructor_x64_pmins(ctx, v875, v901, v919);
                                let v928 = &C::xmm_to_xmm_mem(ctx, v927);
                                let v929 = constructor_x64_pcmpeq(ctx, v875, v876, v928);
                                let v930 = constructor_output_xmm(ctx, v929);
                                // Rule at src/isa/x64/lower.isle line 1920.
                                return Some(v930);
                            }
                            let v876 = constructor_put_in_xmm(ctx, v823.0);
                            let v877 = &C::put_in_xmm_mem(ctx, v823.1);
                            let v884 = constructor_x64_pcmpgt(ctx, v875, v876, v877);
                            let v880 = constructor_vector_all_ones(ctx);
                            let v881 = &C::xmm_to_xmm_mem(ctx, v880);
                            let v931 = constructor_x64_pxor(ctx, v884, v881);
                            let v932 = constructor_output_xmm(ctx, v931);
                            // Rule at src/isa/x64/lower.isle line 1925.
                            return Some(v932);
                        }
                    }
                    &IntCC::UnsignedGreaterThan => {
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v890 = constructor_has_pmaxu(ctx, v875);
                            if v890 == true {
                                let v876 = constructor_put_in_xmm(ctx, v823.0);
                                let v891 = constructor_put_in_xmm(ctx, v823.1);
                                let v892 = &C::xmm_to_xmm_mem(ctx, v891);
                                let v893 = constructor_x64_pmaxu(ctx, v875, v876, v892);
                                let v894 = &C::xmm_to_xmm_mem(ctx, v891);
                                let v895 = constructor_x64_pcmpeq(ctx, v875, v893, v894);
                                let v896 = constructor_vector_all_ones(ctx);
                                let v897 = &C::xmm_to_xmm_mem(ctx, v896);
                                let v898 = constructor_x64_pxor(ctx, v895, v897);
                                let v899 = constructor_output_xmm(ctx, v898);
                                // Rule at src/isa/x64/lower.isle line 1870.
                                return Some(v899);
                            }
                            let v900 = constructor_flip_high_bit_mask(ctx, v875);
                            let v901 = constructor_put_in_xmm(ctx, v823.0);
                            let v902 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v903 = constructor_x64_pxor(ctx, v901, v902);
                            let v904 = constructor_put_in_xmm(ctx, v823.1);
                            let v905 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v906 = constructor_x64_pxor(ctx, v904, v905);
                            let v907 = &C::xmm_to_xmm_mem(ctx, v906);
                            let v908 = constructor_x64_pcmpgt(ctx, v875, v903, v907);
                            let v909 = constructor_output_xmm(ctx, v908);
                            // Rule at src/isa/x64/lower.isle line 1880.
                            return Some(v909);
                        }
                    }
                    &IntCC::UnsignedGreaterThanOrEqual => {
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v890 = constructor_has_pmaxu(ctx, v875);
                            if v890 == true {
                                let v876 = constructor_put_in_xmm(ctx, v823.0);
                                let v901 = constructor_put_in_xmm(ctx, v823.0);
                                let v919 = &C::put_in_xmm_mem(ctx, v823.1);
                                let v933 = constructor_x64_pmaxu(ctx, v875, v901, v919);
                                let v934 = &C::xmm_to_xmm_mem(ctx, v933);
                                let v935 = constructor_x64_pcmpeq(ctx, v875, v876, v934);
                                let v936 = constructor_output_xmm(ctx, v935);
                                // Rule at src/isa/x64/lower.isle line 1930.
                                return Some(v936);
                            }
                        }
                        if v826 == I16X8 {
                            let v886 = constructor_put_in_xmm(ctx, v823.1);
                            let v887 = &C::put_in_xmm_mem(ctx, v823.0);
                            let v937 = constructor_x64_psubusw(ctx, v886, v887);
                            let v938 = constructor_xmm_zero(ctx, I16X8);
                            let v939 = &C::xmm_to_xmm_mem(ctx, v938);
                            let v940 = constructor_x64_pcmpeqw(ctx, v937, v939);
                            let v941 = constructor_output_xmm(ctx, v940);
                            // Rule at src/isa/x64/lower.isle line 1936.
                            return Some(v941);
                        }
                        if let Some(v875) = v874 {
                            let v900 = constructor_flip_high_bit_mask(ctx, v875);
                            let v901 = constructor_put_in_xmm(ctx, v823.0);
                            let v902 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v903 = constructor_x64_pxor(ctx, v901, v902);
                            let v904 = constructor_put_in_xmm(ctx, v823.1);
                            let v905 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v906 = constructor_x64_pxor(ctx, v904, v905);
                            let v915 = &C::xmm_to_xmm_mem(ctx, v903);
                            let v916 = constructor_x64_pcmpgt(ctx, v875, v906, v915);
                            let v942 = constructor_vector_all_ones(ctx);
                            let v943 = &C::xmm_to_xmm_mem(ctx, v942);
                            let v944 = constructor_x64_pxor(ctx, v916, v943);
                            let v945 = constructor_output_xmm(ctx, v944);
                            // Rule at src/isa/x64/lower.isle line 1942.
                            return Some(v945);
                        }
                    }
                    &IntCC::UnsignedLessThan => {
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v910 = constructor_has_pminu(ctx, v875);
                            if v910 == true {
                                let v876 = constructor_put_in_xmm(ctx, v823.0);
                                let v891 = constructor_put_in_xmm(ctx, v823.1);
                                let v892 = &C::xmm_to_xmm_mem(ctx, v891);
                                let v911 = constructor_x64_pminu(ctx, v875, v876, v892);
                                let v894 = &C::xmm_to_xmm_mem(ctx, v891);
                                let v912 = constructor_x64_pcmpeq(ctx, v875, v911, v894);
                                let v896 = constructor_vector_all_ones(ctx);
                                let v897 = &C::xmm_to_xmm_mem(ctx, v896);
                                let v913 = constructor_x64_pxor(ctx, v912, v897);
                                let v914 = constructor_output_xmm(ctx, v913);
                                // Rule at src/isa/x64/lower.isle line 1888.
                                return Some(v914);
                            }
                            let v900 = constructor_flip_high_bit_mask(ctx, v875);
                            let v901 = constructor_put_in_xmm(ctx, v823.0);
                            let v902 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v903 = constructor_x64_pxor(ctx, v901, v902);
                            let v904 = constructor_put_in_xmm(ctx, v823.1);
                            let v905 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v906 = constructor_x64_pxor(ctx, v904, v905);
                            let v915 = &C::xmm_to_xmm_mem(ctx, v903);
                            let v916 = constructor_x64_pcmpgt(ctx, v875, v906, v915);
                            let v917 = constructor_output_xmm(ctx, v916);
                            // Rule at src/isa/x64/lower.isle line 1899.
                            return Some(v917);
                        }
                    }
                    &IntCC::UnsignedLessThanOrEqual => {
                        let v823 = C::unpack_value_array_2(ctx, v821);
                        let v826 = C::value_type(ctx, v823.0);
                        let v874 = C::ty_vec128(ctx, v826);
                        if let Some(v875) = v874 {
                            let v910 = constructor_has_pminu(ctx, v875);
                            if v910 == true {
                                let v876 = constructor_put_in_xmm(ctx, v823.0);
                                let v901 = constructor_put_in_xmm(ctx, v823.0);
                                let v919 = &C::put_in_xmm_mem(ctx, v823.1);
                                let v946 = constructor_x64_pminu(ctx, v875, v901, v919);
                                let v947 = &C::xmm_to_xmm_mem(ctx, v946);
                                let v948 = constructor_x64_pcmpeq(ctx, v875, v876, v947);
                                let v949 = constructor_output_xmm(ctx, v948);
                                // Rule at src/isa/x64/lower.isle line 1953.
                                return Some(v949);
                            }
                        }
                        if v826 == I16X8 {
                            let v876 = constructor_put_in_xmm(ctx, v823.0);
                            let v877 = &C::put_in_xmm_mem(ctx, v823.1);
                            let v950 = constructor_x64_psubusw(ctx, v876, v877);
                            let v951 = constructor_xmm_zero(ctx, I8X16);
                            let v952 = &C::xmm_to_xmm_mem(ctx, v951);
                            let v953 = constructor_x64_pcmpeqw(ctx, v950, v952);
                            let v954 = constructor_output_xmm(ctx, v953);
                            // Rule at src/isa/x64/lower.isle line 1960.
                            return Some(v954);
                        }
                        if let Some(v875) = v874 {
                            let v900 = constructor_flip_high_bit_mask(ctx, v875);
                            let v901 = constructor_put_in_xmm(ctx, v823.0);
                            let v902 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v903 = constructor_x64_pxor(ctx, v901, v902);
                            let v904 = constructor_put_in_xmm(ctx, v823.1);
                            let v905 = &C::xmm_to_xmm_mem(ctx, v900);
                            let v906 = constructor_x64_pxor(ctx, v904, v905);
                            let v907 = &C::xmm_to_xmm_mem(ctx, v906);
                            let v908 = constructor_x64_pcmpgt(ctx, v875, v903, v907);
                            let v942 = constructor_vector_all_ones(ctx);
                            let v943 = &C::xmm_to_xmm_mem(ctx, v942);
                            let v955 = constructor_x64_pxor(ctx, v908, v943);
                            let v956 = constructor_output_xmm(ctx, v955);
                            // Rule at src/isa/x64/lower.isle line 1968.
                            return Some(v956);
                        }
                    }
                    _ => {}
                }
                let v823 = C::unpack_value_array_2(ctx, v821);
                let v826 = C::value_type(ctx, v823.0);
                if v826 == I128 {
                    let v829 = &constructor_emit_cmp(ctx, v822, v823.0, v823.1);
                    let v830 = constructor_lower_icmp_bool(ctx, v829);
                    let v831 = C::output(ctx, v830);
                    // Rule at src/isa/x64/lower.isle line 1806.
                    return Some(v831);
                }
                let v827 = C::fits_in_64(ctx, v826);
                if let Some(v828) = v827 {
                    let v829 = &constructor_emit_cmp(ctx, v822, v823.0, v823.1);
                    let v830 = constructor_lower_icmp_bool(ctx, v829);
                    let v831 = C::output(ctx, v830);
                    // Rule at src/isa/x64/lower.isle line 1803.
                    return Some(v831);
                }
            }
        }
        &InstructionData::Load {
            opcode: ref v1476,
            arg: v1477,
            flags: v1478,
            offset: v1479,
        } => {
            match v1476 {
                &Opcode::Load => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1508 = &C::amode_to_synthetic_amode(ctx, v1489);
                                let v1509 = constructor_x64_movss_load(ctx, v1508);
                                let v1510 = constructor_output_xmm(ctx, v1509);
                                // Rule at src/isa/x64/lower.isle line 2863.
                                return Some(v1510);
                            }
                            F64 => {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1508 = &C::amode_to_synthetic_amode(ctx, v1489);
                                let v1511 = constructor_x64_movsd_load(ctx, v1508);
                                let v1512 = constructor_output_xmm(ctx, v1511);
                                // Rule at src/isa/x64/lower.isle line 2865.
                                return Some(v1512);
                            }
                            F32X4 => {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1508 = &C::amode_to_synthetic_amode(ctx, v1489);
                                let v1513 = constructor_x64_movups_load(ctx, v1508);
                                let v1514 = constructor_output_xmm(ctx, v1513);
                                // Rule at src/isa/x64/lower.isle line 2867.
                                return Some(v1514);
                            }
                            F64X2 => {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1508 = &C::amode_to_synthetic_amode(ctx, v1489);
                                let v1515 = constructor_x64_movupd_load(ctx, v1508);
                                let v1516 = constructor_output_xmm(ctx, v1515);
                                // Rule at src/isa/x64/lower.isle line 2869.
                                return Some(v1516);
                            }
                            _ => {}
                        }
                        let v1487 = C::ty_int_ref_64(ctx, v3);
                        if let Some(v1488) = v1487 {
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1490 = constructor_x64_mov(ctx, v1489);
                            let v1491 = constructor_output_reg(ctx, v1490);
                            // Rule at src/isa/x64/lower.isle line 2841.
                            return Some(v1491);
                        }
                        let v740 = C::ty_vec128(ctx, v3);
                        if let Some(v741) = v740 {
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1517 = &constructor_amode_to_xmm_mem(ctx, v1489);
                            let v1518 = constructor_x64_movdqu_load(ctx, v1517);
                            let v1519 = constructor_output_xmm(ctx, v1518);
                            // Rule at src/isa/x64/lower.isle line 2871.
                            return Some(v1519);
                        }
                        if v3 == I128 {
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1521 = &C::amode_offset(ctx, v1489, 0x8);
                            let v1522 = constructor_x64_mov(ctx, v1489);
                            let v1523 = constructor_x64_mov(ctx, v1521);
                            let v1524 = C::value_regs(ctx, v1522, v1523);
                            let v1525 = C::output(ctx, v1524);
                            // Rule at src/isa/x64/lower.isle line 2875.
                            return Some(v1525);
                        }
                        let v1233 = C::fits_in_32(ctx, v3);
                        if let Some(v1234) = v1233 {
                            let v1473 = &C::type_register_class(ctx, v3);
                            if let Some(v1474) = v1473 {
                                if let &RegisterClass::Gpr {
                                    single_register: v1475,
                                } = v1474
                                {
                                    let v1480 = C::ty_bits_u16(ctx, v1234);
                                    let v1482 = &C::ext_mode(ctx, v1480, 0x40);
                                    let v1483 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                    let v1484 = &constructor_amode_to_gpr_mem(ctx, v1483);
                                    let v1485 = constructor_x64_movzx(ctx, v1482, v1484);
                                    let v1486 = constructor_output_gpr(ctx, v1485);
                                    // Rule at src/isa/x64/lower.isle line 2837.
                                    return Some(v1486);
                                }
                            }
                        }
                    }
                }
                &Opcode::Uload8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1473 = &C::type_register_class(ctx, v3);
                        if let Some(v1474) = v1473 {
                            if let &RegisterClass::Gpr {
                                single_register: v1475,
                            } = v1474
                            {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                                let v1494 = constructor_x64_movzx(ctx, &ExtMode::BQ, v1493);
                                let v1495 = constructor_output_gpr(ctx, v1494);
                                // Rule at src/isa/x64/lower.isle line 2846.
                                return Some(v1495);
                            }
                        }
                    }
                }
                &Opcode::Sload8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1473 = &C::type_register_class(ctx, v3);
                        if let Some(v1474) = v1473 {
                            if let &RegisterClass::Gpr {
                                single_register: v1475,
                            } = v1474
                            {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                                let v1496 = constructor_x64_movsx(ctx, &ExtMode::BQ, v1493);
                                let v1497 = constructor_output_gpr(ctx, v1496);
                                // Rule at src/isa/x64/lower.isle line 2848.
                                return Some(v1497);
                            }
                        }
                    }
                }
                &Opcode::Uload16 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1473 = &C::type_register_class(ctx, v3);
                        if let Some(v1474) = v1473 {
                            if let &RegisterClass::Gpr {
                                single_register: v1475,
                            } = v1474
                            {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                                let v1499 = constructor_x64_movzx(ctx, &ExtMode::WQ, v1493);
                                let v1500 = constructor_output_gpr(ctx, v1499);
                                // Rule at src/isa/x64/lower.isle line 2850.
                                return Some(v1500);
                            }
                        }
                    }
                }
                &Opcode::Sload16 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1473 = &C::type_register_class(ctx, v3);
                        if let Some(v1474) = v1473 {
                            if let &RegisterClass::Gpr {
                                single_register: v1475,
                            } = v1474
                            {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                                let v1501 = constructor_x64_movsx(ctx, &ExtMode::WQ, v1493);
                                let v1502 = constructor_output_gpr(ctx, v1501);
                                // Rule at src/isa/x64/lower.isle line 2852.
                                return Some(v1502);
                            }
                        }
                    }
                }
                &Opcode::Uload32 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1473 = &C::type_register_class(ctx, v3);
                        if let Some(v1474) = v1473 {
                            if let &RegisterClass::Gpr {
                                single_register: v1475,
                            } = v1474
                            {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                                let v1504 = constructor_x64_movzx(ctx, &ExtMode::LQ, v1493);
                                let v1505 = constructor_output_gpr(ctx, v1504);
                                // Rule at src/isa/x64/lower.isle line 2854.
                                return Some(v1505);
                            }
                        }
                    }
                }
                &Opcode::Sload32 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1473 = &C::type_register_class(ctx, v3);
                        if let Some(v1474) = v1473 {
                            if let &RegisterClass::Gpr {
                                single_register: v1475,
                            } = v1474
                            {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                                let v1506 = constructor_x64_movsx(ctx, &ExtMode::LQ, v1493);
                                let v1507 = constructor_output_gpr(ctx, v1506);
                                // Rule at src/isa/x64/lower.isle line 2856.
                                return Some(v1507);
                            }
                        }
                    }
                }
                &Opcode::Uload8x8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I16X8 {
                            let v441 = C::use_sse41(ctx);
                            if v441 == true {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1517 = &constructor_amode_to_xmm_mem(ctx, v1489);
                                let v1528 = constructor_x64_pmovzxbw(ctx, v1517);
                                let v1529 = constructor_output_xmm(ctx, v1528);
                                // Rule at src/isa/x64/lower.isle line 2888.
                                return Some(v1529);
                            }
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                            let v1538 = constructor_x64_movq_to_xmm(ctx, v1493);
                            let v1541 = constructor_lower_uwiden_low(ctx, I16X8, v1538);
                            let v1542 = constructor_output_xmm(ctx, v1541);
                            // Rule at src/isa/x64/lower.isle line 2906.
                            return Some(v1542);
                        }
                    }
                }
                &Opcode::Sload8x8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I16X8 {
                            let v441 = C::use_sse41(ctx);
                            if v441 == true {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1517 = &constructor_amode_to_xmm_mem(ctx, v1489);
                                let v1526 = constructor_x64_pmovsxbw(ctx, v1517);
                                let v1527 = constructor_output_xmm(ctx, v1526);
                                // Rule at src/isa/x64/lower.isle line 2885.
                                return Some(v1527);
                            }
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                            let v1538 = constructor_x64_movq_to_xmm(ctx, v1493);
                            let v1539 = constructor_lower_swiden_low(ctx, I16X8, v1538);
                            let v1540 = constructor_output_xmm(ctx, v1539);
                            // Rule at src/isa/x64/lower.isle line 2904.
                            return Some(v1540);
                        }
                    }
                }
                &Opcode::Uload16x4 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v441 = C::use_sse41(ctx);
                            if v441 == true {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1517 = &constructor_amode_to_xmm_mem(ctx, v1489);
                                let v1532 = constructor_x64_pmovzxwd(ctx, v1517);
                                let v1533 = constructor_output_xmm(ctx, v1532);
                                // Rule at src/isa/x64/lower.isle line 2894.
                                return Some(v1533);
                            }
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                            let v1538 = constructor_x64_movq_to_xmm(ctx, v1493);
                            let v1545 = constructor_lower_uwiden_low(ctx, I32X4, v1538);
                            let v1546 = constructor_output_xmm(ctx, v1545);
                            // Rule at src/isa/x64/lower.isle line 2910.
                            return Some(v1546);
                        }
                    }
                }
                &Opcode::Sload16x4 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v441 = C::use_sse41(ctx);
                            if v441 == true {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1517 = &constructor_amode_to_xmm_mem(ctx, v1489);
                                let v1530 = constructor_x64_pmovsxwd(ctx, v1517);
                                let v1531 = constructor_output_xmm(ctx, v1530);
                                // Rule at src/isa/x64/lower.isle line 2891.
                                return Some(v1531);
                            }
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                            let v1538 = constructor_x64_movq_to_xmm(ctx, v1493);
                            let v1543 = constructor_lower_swiden_low(ctx, I32X4, v1538);
                            let v1544 = constructor_output_xmm(ctx, v1543);
                            // Rule at src/isa/x64/lower.isle line 2908.
                            return Some(v1544);
                        }
                    }
                }
                &Opcode::Uload32x2 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I64X2 {
                            let v441 = C::use_sse41(ctx);
                            if v441 == true {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1517 = &constructor_amode_to_xmm_mem(ctx, v1489);
                                let v1536 = constructor_x64_pmovzxdq(ctx, v1517);
                                let v1537 = constructor_output_xmm(ctx, v1536);
                                // Rule at src/isa/x64/lower.isle line 2900.
                                return Some(v1537);
                            }
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                            let v1538 = constructor_x64_movq_to_xmm(ctx, v1493);
                            let v1549 = constructor_lower_uwiden_low(ctx, I64X2, v1538);
                            let v1550 = constructor_output_xmm(ctx, v1549);
                            // Rule at src/isa/x64/lower.isle line 2914.
                            return Some(v1550);
                        }
                    }
                }
                &Opcode::Sload32x2 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I64X2 {
                            let v441 = C::use_sse41(ctx);
                            if v441 == true {
                                let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                                let v1517 = &constructor_amode_to_xmm_mem(ctx, v1489);
                                let v1534 = constructor_x64_pmovsxdq(ctx, v1517);
                                let v1535 = constructor_output_xmm(ctx, v1534);
                                // Rule at src/isa/x64/lower.isle line 2897.
                                return Some(v1535);
                            }
                            let v1489 = &constructor_to_amode(ctx, v1478, v1477, v1479);
                            let v1493 = &constructor_amode_to_gpr_mem(ctx, v1489);
                            let v1538 = constructor_x64_movq_to_xmm(ctx, v1493);
                            let v1547 = constructor_lower_swiden_low(ctx, I64X2, v1538);
                            let v1548 = constructor_output_xmm(ctx, v1547);
                            // Rule at src/isa/x64/lower.isle line 2912.
                            return Some(v1548);
                        }
                    }
                }
                _ => {}
            }
        }
        &InstructionData::LoadNoOffset {
            opcode: ref v1697,
            arg: v1698,
            flags: v1699,
        } => {
            match v1697 {
                &Opcode::Bitcast => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1473 = &C::type_register_class(ctx, v3);
                        if let Some(v1474) = v1473 {
                            match v1474 {
                                &RegisterClass::Gpr {
                                    single_register: v1475,
                                } => {
                                    let v2115 = C::value_type(ctx, v1698);
                                    let v2126 = &C::type_register_class(ctx, v2115);
                                    if let Some(v2127) = v2126 {
                                        if let &RegisterClass::Gpr {
                                            single_register: v2128,
                                        } = v2127
                                        {
                                            let v2129 = constructor_output_value(ctx, v1698);
                                            // Rule at src/isa/x64/lower.isle line 3907.
                                            return Some(v2129);
                                        }
                                    }
                                }
                                &RegisterClass::Xmm => {
                                    let v2115 = C::value_type(ctx, v1698);
                                    let v2126 = &C::type_register_class(ctx, v2115);
                                    if let Some(v2127) = v2126 {
                                        if let &RegisterClass::Xmm = v2127 {
                                            let v2129 = constructor_output_value(ctx, v1698);
                                            // Rule at src/isa/x64/lower.isle line 3911.
                                            return Some(v2129);
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                        match v3 {
                            I32 => {
                                let v2115 = C::value_type(ctx, v1698);
                                if v2115 == F32 {
                                    let v2116 = constructor_put_in_xmm(ctx, v1698);
                                    let v2117 = constructor_bitcast_xmm_to_gpr(ctx, F32, v2116);
                                    let v2118 = constructor_output_gpr(ctx, v2117);
                                    // Rule at src/isa/x64/lower.isle line 3894.
                                    return Some(v2118);
                                }
                            }
                            I64 => {
                                let v2115 = C::value_type(ctx, v1698);
                                if v2115 == F64 {
                                    let v2116 = constructor_put_in_xmm(ctx, v1698);
                                    let v2122 = constructor_bitcast_xmm_to_gpr(ctx, F64, v2116);
                                    let v2123 = constructor_output_gpr(ctx, v2122);
                                    // Rule at src/isa/x64/lower.isle line 3900.
                                    return Some(v2123);
                                }
                            }
                            F32 => {
                                let v2115 = C::value_type(ctx, v1698);
                                if v2115 == I32 {
                                    let v2119 = constructor_put_in_gpr(ctx, v1698);
                                    let v2120 = constructor_bitcast_gpr_to_xmm(ctx, I32, v2119);
                                    let v2121 = constructor_output_xmm(ctx, v2120);
                                    // Rule at src/isa/x64/lower.isle line 3897.
                                    return Some(v2121);
                                }
                            }
                            F64 => {
                                let v2115 = C::value_type(ctx, v1698);
                                if v2115 == I64 {
                                    let v2119 = constructor_put_in_gpr(ctx, v1698);
                                    let v2124 = constructor_bitcast_gpr_to_xmm(ctx, I64, v2119);
                                    let v2125 = constructor_output_xmm(ctx, v2124);
                                    // Rule at src/isa/x64/lower.isle line 3903.
                                    return Some(v2125);
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::AtomicLoad => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I64 {
                            let v48 = C::zero_offset(ctx);
                            let v1700 = &constructor_to_amode(ctx, v1699, v1698, v48);
                            let v1701 = constructor_x64_mov(ctx, v1700);
                            let v1702 = constructor_output_reg(ctx, v1701);
                            // Rule at src/isa/x64/lower.isle line 3196.
                            return Some(v1702);
                        }
                        let v1233 = C::fits_in_32(ctx, v3);
                        if let Some(v1234) = v1233 {
                            let v1703 = C::ty_int(ctx, v3);
                            if let Some(v1704) = v1703 {
                                let v1480 = C::ty_bits_u16(ctx, v1234);
                                let v1482 = &C::ext_mode(ctx, v1480, 0x40);
                                let v1705 = C::zero_offset(ctx);
                                let v1706 = &constructor_to_amode(ctx, v1699, v1698, v1705);
                                let v1707 = &constructor_amode_to_gpr_mem(ctx, v1706);
                                let v1708 = constructor_x64_movzx(ctx, v1482, v1707);
                                let v1709 = constructor_output_gpr(ctx, v1708);
                                // Rule at src/isa/x64/lower.isle line 3198.
                                return Some(v1709);
                            }
                        }
                    }
                }
                _ => {}
            }
        }
        &InstructionData::MultiAry {
            opcode: ref v816,
            args: v817,
        } => {
            if let &Opcode::Return = v816 {
                let v818 = C::value_list_slice(ctx, v817);
                let v819 = constructor_lower_return(ctx, v818);
                // Rule at src/isa/x64/lower.isle line 1798.
                return Some(v819);
            }
        }
        &InstructionData::NullAry { opcode: ref v31 } => {
            match v31 {
                &Opcode::Debugtrap => {
                    let v1247 = &constructor_x64_hlt(ctx);
                    let v1248 = constructor_side_effect(ctx, v1247);
                    // Rule at src/isa/x64/lower.isle line 2479.
                    return Some(v1248);
                }
                &Opcode::GetPinnedReg => {
                    let v2238 = constructor_read_pinned_gpr(ctx);
                    let v2239 = constructor_output_gpr(ctx, v2238);
                    // Rule at src/isa/x64/lower.isle line 4172.
                    return Some(v2239);
                }
                &Opcode::GetFramePointer => {
                    let v1775 = constructor_x64_rbp(ctx);
                    let v1776 = constructor_output_reg(ctx, v1775);
                    // Rule at src/isa/x64/lower.isle line 3253.
                    return Some(v1776);
                }
                &Opcode::GetStackPointer => {
                    let v1777 = constructor_x64_rsp(ctx);
                    let v1778 = constructor_output_reg(ctx, v1777);
                    // Rule at src/isa/x64/lower.isle line 3256.
                    return Some(v1778);
                }
                &Opcode::GetReturnAddress => {
                    let v1775 = constructor_x64_rbp(ctx);
                    let v47 = C::mem_flags_trusted(ctx);
                    let v1779 = Amode::ImmReg {
                        simm32: 0x8,
                        base: v1775,
                        flags: v47,
                    };
                    let v1780 = &C::amode_to_synthetic_amode(ctx, &v1779);
                    let v1781 = constructor_x64_load(ctx, I64, v1780, &ExtKind::None);
                    let v1782 = constructor_output_reg(ctx, v1781);
                    // Rule at src/isa/x64/lower.isle line 3259.
                    return Some(v1782);
                }
                &Opcode::Null => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v32 = constructor_imm(ctx, v3, 0x0);
                        let v33 = constructor_output_reg(ctx, v32);
                        // Rule at src/isa/x64/lower.isle line 37.
                        return Some(v33);
                    }
                }
                &Opcode::Nop => {
                    let v2592 = C::invalid_reg(ctx);
                    let v2593 = constructor_output_reg(ctx, v2592);
                    // Rule at src/isa/x64/lower.isle line 4719.
                    return Some(v2593);
                }
                &Opcode::Fence => {
                    let v1677 = &constructor_x64_mfence(ctx);
                    let v1678 = constructor_side_effect(ctx, v1677);
                    // Rule at src/isa/x64/lower.isle line 3174.
                    return Some(v1678);
                }
                _ => {}
            }
        }
        &InstructionData::Shuffle {
            opcode: ref v2247,
            args: ref v2248,
            imm: v2249,
        } => {
            if let &Opcode::Shuffle = v2247 {
                let v441 = C::use_sse41(ctx);
                if v441 == true {
                    let v2253 = C::pblendw_imm(ctx, v2249);
                    if let Some(v2254) = v2253 {
                        let v2250 = C::unpack_value_array_2(ctx, v2248);
                        let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                        let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                        let v2257 = constructor_x64_pblendw(ctx, v2255, v2256, v2254);
                        let v2258 = constructor_output_xmm(ctx, v2257);
                        // Rule at src/isa/x64/lower.isle line 4192.
                        return Some(v2258);
                    }
                }
                let v525 = C::use_ssse3(ctx);
                if v525 == true {
                    let v2259 = C::palignr_imm_from_immediate(ctx, v2249);
                    if let Some(v2260) = v2259 {
                        let v2250 = C::unpack_value_array_2(ctx, v2248);
                        let v2261 = constructor_put_in_xmm(ctx, v2250.1);
                        let v2262 = &C::put_in_xmm_mem(ctx, v2250.0);
                        let v2263 = constructor_x64_palignr(ctx, v2261, v2262, v2260);
                        let v2264 = constructor_output_xmm(ctx, v2263);
                        // Rule at src/isa/x64/lower.isle line 4203.
                        return Some(v2264);
                    }
                }
                let v2265 = C::pshuflw_lhs_imm(ctx, v2249);
                if let Some(v2266) = v2265 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2267 = &C::put_in_xmm_mem(ctx, v2250.0);
                    let v2268 = constructor_x64_pshuflw(ctx, v2267, v2266);
                    let v2269 = constructor_output_xmm(ctx, v2268);
                    // Rule at src/isa/x64/lower.isle line 4215.
                    return Some(v2269);
                }
                let v2270 = C::pshuflw_rhs_imm(ctx, v2249);
                if let Some(v2271) = v2270 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2272 = &C::put_in_xmm_mem(ctx, v2250.1);
                    let v2273 = constructor_x64_pshuflw(ctx, v2272, v2271);
                    let v2274 = constructor_output_xmm(ctx, v2273);
                    // Rule at src/isa/x64/lower.isle line 4217.
                    return Some(v2274);
                }
                let v2275 = C::pshufhw_lhs_imm(ctx, v2249);
                if let Some(v2276) = v2275 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2267 = &C::put_in_xmm_mem(ctx, v2250.0);
                    let v2277 = constructor_x64_pshufhw(ctx, v2267, v2276);
                    let v2278 = constructor_output_xmm(ctx, v2277);
                    // Rule at src/isa/x64/lower.isle line 4219.
                    return Some(v2278);
                }
                let v2279 = C::pshufhw_rhs_imm(ctx, v2249);
                if let Some(v2280) = v2279 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2272 = &C::put_in_xmm_mem(ctx, v2250.1);
                    let v2281 = constructor_x64_pshufhw(ctx, v2272, v2280);
                    let v2282 = constructor_output_xmm(ctx, v2281);
                    // Rule at src/isa/x64/lower.isle line 4221.
                    return Some(v2282);
                }
                let v2283 = C::pshufd_lhs_imm(ctx, v2249);
                if let Some(v2284) = v2283 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2267 = &C::put_in_xmm_mem(ctx, v2250.0);
                    let v2285 = constructor_x64_pshufd(ctx, v2267, v2284);
                    let v2286 = constructor_output_xmm(ctx, v2285);
                    // Rule at src/isa/x64/lower.isle line 4238.
                    return Some(v2286);
                }
                let v2287 = C::pshufd_rhs_imm(ctx, v2249);
                if let Some(v2288) = v2287 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2272 = &C::put_in_xmm_mem(ctx, v2250.1);
                    let v2289 = constructor_x64_pshufd(ctx, v2272, v2288);
                    let v2290 = constructor_output_xmm(ctx, v2289);
                    // Rule at src/isa/x64/lower.isle line 4240.
                    return Some(v2290);
                }
                let v2291 = C::u128_from_immediate(ctx, v2249);
                if let Some(v2292) = v2291 {
                    match v2292 {
                        0x0 => {
                            if v525 == true {
                                let v2250 = C::unpack_value_array_2(ctx, v2248);
                                let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                                let v530 = constructor_xmm_zero(ctx, I8X16);
                                let v2073 = &C::xmm_to_xmm_mem(ctx, v530);
                                let v2309 = constructor_x64_pshufb(ctx, v2255, v2073);
                                let v2310 = constructor_output_xmm(ctx, v2309);
                                // Rule at src/isa/x64/lower.isle line 4277.
                                return Some(v2310);
                            }
                        }
                        0x17071606150514041303120211011000 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2295 = constructor_x64_punpcklbw(ctx, v2255, v2256);
                            let v2296 = constructor_output_xmm(ctx, v2295);
                            // Rule at src/isa/x64/lower.isle line 4251.
                            return Some(v2296);
                        }
                        0x17160706151405041312030211100100 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2299 = constructor_x64_punpcklwd(ctx, v2255, v2256);
                            let v2300 = constructor_output_xmm(ctx, v2299);
                            // Rule at src/isa/x64/lower.isle line 4257.
                            return Some(v2300);
                        }
                        0x17161514070605041312111003020100 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2303 = constructor_x64_punpckldq(ctx, v2255, v2256);
                            let v2304 = constructor_output_xmm(ctx, v2303);
                            // Rule at src/isa/x64/lower.isle line 4263.
                            return Some(v2304);
                        }
                        0x17161514131211100706050403020100 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2307 = constructor_x64_punpcklqdq(ctx, v2255, v2256);
                            let v2308 = constructor_output_xmm(ctx, v2307);
                            // Rule at src/isa/x64/lower.isle line 4269.
                            return Some(v2308);
                        }
                        0x1F0F1E0E1D0D1C0C1B0B1A0A19091808 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2293 = constructor_x64_punpckhbw(ctx, v2255, v2256);
                            let v2294 = constructor_output_xmm(ctx, v2293);
                            // Rule at src/isa/x64/lower.isle line 4249.
                            return Some(v2294);
                        }
                        0x1F1E0F0E1D1C0D0C1B1A0B0A19180908 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2297 = constructor_x64_punpckhwd(ctx, v2255, v2256);
                            let v2298 = constructor_output_xmm(ctx, v2297);
                            // Rule at src/isa/x64/lower.isle line 4255.
                            return Some(v2298);
                        }
                        0x1F1E1D1C0F0E0D0C1B1A19180B0A0908 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2301 = constructor_x64_punpckhdq(ctx, v2255, v2256);
                            let v2302 = constructor_output_xmm(ctx, v2301);
                            // Rule at src/isa/x64/lower.isle line 4261.
                            return Some(v2302);
                        }
                        0x1F1E1D1C1B1A19180F0E0D0C0B0A0908 => {
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2305 = constructor_x64_punpckhqdq(ctx, v2255, v2256);
                            let v2306 = constructor_output_xmm(ctx, v2305);
                            // Rule at src/isa/x64/lower.isle line 4267.
                            return Some(v2306);
                        }
                        _ => {}
                    }
                }
                let v2311 = C::shufps_imm(ctx, v2249);
                if let Some(v2312) = v2311 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                    let v2256 = &C::put_in_xmm_mem(ctx, v2250.1);
                    let v2313 = constructor_x64_shufps(ctx, v2255, v2256, v2312);
                    let v2314 = constructor_output_xmm(ctx, v2313);
                    // Rule at src/isa/x64/lower.isle line 4291.
                    return Some(v2314);
                }
                let v2315 = C::shufps_rev_imm(ctx, v2249);
                if let Some(v2316) = v2315 {
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2261 = constructor_put_in_xmm(ctx, v2250.1);
                    let v2262 = &C::put_in_xmm_mem(ctx, v2250.0);
                    let v2317 = constructor_x64_shufps(ctx, v2261, v2262, v2316);
                    let v2318 = constructor_output_xmm(ctx, v2317);
                    // Rule at src/isa/x64/lower.isle line 4293.
                    return Some(v2318);
                }
                let v2319 = &C::vec_mask_from_immediate(ctx, v2249);
                if let Some(v2320) = v2319 {
                    if v525 == true {
                        let v2250 = C::unpack_value_array_2(ctx, v2248);
                        if v2250.0 == v2250.1 {
                            let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2321 = C::shuffle_0_31_mask(ctx, v2320);
                            let v2322 = &constructor_const_to_xmm_mem(ctx, v2321);
                            let v2323 = constructor_x64_pshufb(ctx, v2255, v2322);
                            let v2324 = constructor_output_xmm(ctx, v2323);
                            // Rule at src/isa/x64/lower.isle line 4306.
                            return Some(v2324);
                        }
                    }
                    let v332 = C::use_avx512vl(ctx);
                    if v332 == true {
                        let v2329 = C::use_avx512vbmi(ctx);
                        if v2329 == true {
                            let v2325 = C::perm_from_mask_with_zeros(ctx, v2320);
                            if let Some(v2326) = v2325 {
                                let v2330 = constructor_x64_xmm_load_const(ctx, I8X16, v2326.0);
                                let v2250 = C::unpack_value_array_2(ctx, v2248);
                                let v2331 = constructor_put_in_xmm(ctx, v2250.0);
                                let v2332 = &C::put_in_xmm_mem(ctx, v2250.1);
                                let v2333 = constructor_x64_vpermi2b(ctx, v2330, v2331, v2332);
                                let v2334 = &constructor_const_to_xmm_mem(ctx, v2326.1);
                                let v2335 = constructor_x64_andps(ctx, v2333, v2334);
                                let v2336 = constructor_output_xmm(ctx, v2335);
                                // Rule at src/isa/x64/lower.isle line 4313.
                                return Some(v2336);
                            }
                            let v2337 = C::perm_from_mask(ctx, v2320);
                            let v2338 = constructor_x64_xmm_load_const(ctx, I8X16, v2337);
                            let v2250 = C::unpack_value_array_2(ctx, v2248);
                            let v2339 = constructor_put_in_xmm(ctx, v2250.0);
                            let v2340 = &C::put_in_xmm_mem(ctx, v2250.1);
                            let v2341 = constructor_x64_vpermi2b(ctx, v2338, v2339, v2340);
                            let v2342 = constructor_output_xmm(ctx, v2341);
                            // Rule at src/isa/x64/lower.isle line 4320.
                            return Some(v2342);
                        }
                    }
                    let v2250 = C::unpack_value_array_2(ctx, v2248);
                    let v2255 = constructor_put_in_xmm(ctx, v2250.0);
                    let v2343 = C::shuffle_0_15_mask(ctx, v2320);
                    let v2344 = &constructor_const_to_reg_mem(ctx, v2343);
                    let v2345 = constructor_lower_pshufb(ctx, v2255, v2344);
                    let v2346 = constructor_put_in_xmm(ctx, v2250.1);
                    let v2347 = C::shuffle_16_31_mask(ctx, v2320);
                    let v2348 = &constructor_const_to_reg_mem(ctx, v2347);
                    let v2349 = constructor_lower_pshufb(ctx, v2346, v2348);
                    let v2350 = &C::xmm_to_xmm_mem(ctx, v2349);
                    let v2351 = constructor_x64_por(ctx, v2345, v2350);
                    let v2352 = constructor_output_xmm(ctx, v2351);
                    // Rule at src/isa/x64/lower.isle line 4328.
                    return Some(v2352);
                }
            }
        }
        &InstructionData::StackLoad {
            opcode: ref v2159,
            stack_slot: v2160,
            offset: v2161,
        } => {
            if let &Opcode::StackAddr = v2159 {
                let v2162 = constructor_stack_addr_impl(ctx, v2160, v2161);
                let v2163 = constructor_output_gpr(ctx, v2162);
                // Rule at src/isa/x64/lower.isle line 4003.
                return Some(v2163);
            }
        }
        &InstructionData::Store {
            opcode: ref v1551,
            args: ref v1552,
            flags: v1553,
            offset: v1554,
        } => {
            match v1551 {
                &Opcode::Store => {
                    let v1555 = C::unpack_value_array_2(ctx, v1552);
                    let v1573 = C::def_inst(ctx, v1555.0);
                    if let Some(v1574) = v1573 {
                        let v1575 = C::first_result(ctx, v1574);
                        if let Some(v1576) = v1575 {
                            let v1580 = &C::inst_data(ctx, v1574);
                            match v1580 {
                                &InstructionData::Binary {
                                    opcode: ref v1630,
                                    args: ref v1631,
                                } => {
                                    match v1630 {
                                        &Opcode::Iadd => {
                                            let v1577 = C::value_type(ctx, v1576);
                                            let v1628 = C::ty_32_or_64(ctx, v1577);
                                            if let Some(v1629) = v1628 {
                                                let v1632 = C::unpack_value_array_2(ctx, v1631);
                                                let v1635 = &C::sinkable_load(ctx, v1632.0);
                                                if let Some(v1636) = v1635 {
                                                    let v1637 = C::def_inst(ctx, v1632.0);
                                                    if let Some(v1638) = v1637 {
                                                        let v1639 = &C::inst_data(ctx, v1638);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1640,
                                                            arg: v1641,
                                                            flags: v1642,
                                                            offset: v1643,
                                                        } = v1639
                                                        {
                                                            if let &Opcode::Load = v1640 {
                                                                if v1553 == v1642 {
                                                                    if v1554 == v1643 {
                                                                        if v1555.1 == v1641 {
                                                                            let v1644 = &constructor_sink_load_to_reg_mem_imm(ctx, v1636);
                                                                            let v1645 = &constructor_to_amode(ctx, v1642, v1641, v1643);
                                                                            let v1646 = constructor_put_in_gpr(ctx, v1632.1);
                                                                            let v1647 = &constructor_x64_add_mem(ctx, v1629, v1645, v1646);
                                                                            let v1648 = constructor_side_effect(ctx, v1647);
                                                                            // Rule at src/isa/x64/lower.isle line 3047.
                                                                            return Some(v1648);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v1649 = &C::sinkable_load(ctx, v1632.1);
                                                if let Some(v1650) = v1649 {
                                                    let v1651 = C::def_inst(ctx, v1632.1);
                                                    if let Some(v1652) = v1651 {
                                                        let v1653 = &C::inst_data(ctx, v1652);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1654,
                                                            arg: v1655,
                                                            flags: v1656,
                                                            offset: v1657,
                                                        } = v1653
                                                        {
                                                            if let &Opcode::Load = v1654 {
                                                                if v1553 == v1656 {
                                                                    if v1554 == v1657 {
                                                                        if v1555.1 == v1655 {
                                                                            let v1658 = &constructor_sink_load_to_reg_mem_imm(ctx, v1650);
                                                                            let v1659 = &constructor_to_amode(ctx, v1656, v1655, v1657);
                                                                            let v1660 = constructor_put_in_gpr(ctx, v1632.0);
                                                                            let v1661 = &constructor_x64_add_mem(ctx, v1629, v1659, v1660);
                                                                            let v1662 = constructor_side_effect(ctx, v1661);
                                                                            // Rule at src/isa/x64/lower.isle line 3061.
                                                                            return Some(v1662);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Isub => {
                                            let v1577 = C::value_type(ctx, v1576);
                                            let v1628 = C::ty_32_or_64(ctx, v1577);
                                            if let Some(v1629) = v1628 {
                                                let v1632 = C::unpack_value_array_2(ctx, v1631);
                                                let v1635 = &C::sinkable_load(ctx, v1632.0);
                                                if let Some(v1636) = v1635 {
                                                    let v1637 = C::def_inst(ctx, v1632.0);
                                                    if let Some(v1638) = v1637 {
                                                        let v1639 = &C::inst_data(ctx, v1638);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1640,
                                                            arg: v1641,
                                                            flags: v1642,
                                                            offset: v1643,
                                                        } = v1639
                                                        {
                                                            if let &Opcode::Load = v1640 {
                                                                if v1553 == v1642 {
                                                                    if v1554 == v1643 {
                                                                        if v1555.1 == v1641 {
                                                                            let v1644 = &constructor_sink_load_to_reg_mem_imm(ctx, v1636);
                                                                            let v1645 = &constructor_to_amode(ctx, v1642, v1641, v1643);
                                                                            let v1646 = constructor_put_in_gpr(ctx, v1632.1);
                                                                            let v1663 = &constructor_x64_sub_mem(ctx, v1629, v1645, v1646);
                                                                            let v1664 = constructor_side_effect(ctx, v1663);
                                                                            // Rule at src/isa/x64/lower.isle line 3075.
                                                                            return Some(v1664);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Band => {
                                            let v1577 = C::value_type(ctx, v1576);
                                            let v1628 = C::ty_32_or_64(ctx, v1577);
                                            if let Some(v1629) = v1628 {
                                                let v1632 = C::unpack_value_array_2(ctx, v1631);
                                                let v1635 = &C::sinkable_load(ctx, v1632.0);
                                                if let Some(v1636) = v1635 {
                                                    let v1637 = C::def_inst(ctx, v1632.0);
                                                    if let Some(v1638) = v1637 {
                                                        let v1639 = &C::inst_data(ctx, v1638);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1640,
                                                            arg: v1641,
                                                            flags: v1642,
                                                            offset: v1643,
                                                        } = v1639
                                                        {
                                                            if let &Opcode::Load = v1640 {
                                                                if v1553 == v1642 {
                                                                    if v1554 == v1643 {
                                                                        if v1555.1 == v1641 {
                                                                            let v1644 = &constructor_sink_load_to_reg_mem_imm(ctx, v1636);
                                                                            let v1645 = &constructor_to_amode(ctx, v1642, v1641, v1643);
                                                                            let v1646 = constructor_put_in_gpr(ctx, v1632.1);
                                                                            let v1665 = &constructor_x64_and_mem(ctx, v1629, v1645, v1646);
                                                                            let v1666 = constructor_side_effect(ctx, v1665);
                                                                            // Rule at src/isa/x64/lower.isle line 3089.
                                                                            return Some(v1666);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v1649 = &C::sinkable_load(ctx, v1632.1);
                                                if let Some(v1650) = v1649 {
                                                    let v1651 = C::def_inst(ctx, v1632.1);
                                                    if let Some(v1652) = v1651 {
                                                        let v1653 = &C::inst_data(ctx, v1652);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1654,
                                                            arg: v1655,
                                                            flags: v1656,
                                                            offset: v1657,
                                                        } = v1653
                                                        {
                                                            if let &Opcode::Load = v1654 {
                                                                if v1553 == v1656 {
                                                                    if v1554 == v1657 {
                                                                        if v1555.1 == v1655 {
                                                                            let v1658 = &constructor_sink_load_to_reg_mem_imm(ctx, v1650);
                                                                            let v1659 = &constructor_to_amode(ctx, v1656, v1655, v1657);
                                                                            let v1660 = constructor_put_in_gpr(ctx, v1632.0);
                                                                            let v1667 = &constructor_x64_and_mem(ctx, v1629, v1659, v1660);
                                                                            let v1668 = constructor_side_effect(ctx, v1667);
                                                                            // Rule at src/isa/x64/lower.isle line 3103.
                                                                            return Some(v1668);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Bor => {
                                            let v1577 = C::value_type(ctx, v1576);
                                            let v1628 = C::ty_32_or_64(ctx, v1577);
                                            if let Some(v1629) = v1628 {
                                                let v1632 = C::unpack_value_array_2(ctx, v1631);
                                                let v1635 = &C::sinkable_load(ctx, v1632.0);
                                                if let Some(v1636) = v1635 {
                                                    let v1637 = C::def_inst(ctx, v1632.0);
                                                    if let Some(v1638) = v1637 {
                                                        let v1639 = &C::inst_data(ctx, v1638);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1640,
                                                            arg: v1641,
                                                            flags: v1642,
                                                            offset: v1643,
                                                        } = v1639
                                                        {
                                                            if let &Opcode::Load = v1640 {
                                                                if v1553 == v1642 {
                                                                    if v1554 == v1643 {
                                                                        if v1555.1 == v1641 {
                                                                            let v1644 = &constructor_sink_load_to_reg_mem_imm(ctx, v1636);
                                                                            let v1645 = &constructor_to_amode(ctx, v1642, v1641, v1643);
                                                                            let v1646 = constructor_put_in_gpr(ctx, v1632.1);
                                                                            let v1669 = &constructor_x64_or_mem(ctx, v1629, v1645, v1646);
                                                                            let v1670 = constructor_side_effect(ctx, v1669);
                                                                            // Rule at src/isa/x64/lower.isle line 3117.
                                                                            return Some(v1670);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v1649 = &C::sinkable_load(ctx, v1632.1);
                                                if let Some(v1650) = v1649 {
                                                    let v1651 = C::def_inst(ctx, v1632.1);
                                                    if let Some(v1652) = v1651 {
                                                        let v1653 = &C::inst_data(ctx, v1652);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1654,
                                                            arg: v1655,
                                                            flags: v1656,
                                                            offset: v1657,
                                                        } = v1653
                                                        {
                                                            if let &Opcode::Load = v1654 {
                                                                if v1553 == v1656 {
                                                                    if v1554 == v1657 {
                                                                        if v1555.1 == v1655 {
                                                                            let v1658 = &constructor_sink_load_to_reg_mem_imm(ctx, v1650);
                                                                            let v1659 = &constructor_to_amode(ctx, v1656, v1655, v1657);
                                                                            let v1660 = constructor_put_in_gpr(ctx, v1632.0);
                                                                            let v1671 = &constructor_x64_or_mem(ctx, v1629, v1659, v1660);
                                                                            let v1672 = constructor_side_effect(ctx, v1671);
                                                                            // Rule at src/isa/x64/lower.isle line 3131.
                                                                            return Some(v1672);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Bxor => {
                                            let v1577 = C::value_type(ctx, v1576);
                                            let v1628 = C::ty_32_or_64(ctx, v1577);
                                            if let Some(v1629) = v1628 {
                                                let v1632 = C::unpack_value_array_2(ctx, v1631);
                                                let v1635 = &C::sinkable_load(ctx, v1632.0);
                                                if let Some(v1636) = v1635 {
                                                    let v1637 = C::def_inst(ctx, v1632.0);
                                                    if let Some(v1638) = v1637 {
                                                        let v1639 = &C::inst_data(ctx, v1638);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1640,
                                                            arg: v1641,
                                                            flags: v1642,
                                                            offset: v1643,
                                                        } = v1639
                                                        {
                                                            if let &Opcode::Load = v1640 {
                                                                if v1553 == v1642 {
                                                                    if v1554 == v1643 {
                                                                        if v1555.1 == v1641 {
                                                                            let v1644 = &constructor_sink_load_to_reg_mem_imm(ctx, v1636);
                                                                            let v1645 = &constructor_to_amode(ctx, v1642, v1641, v1643);
                                                                            let v1646 = constructor_put_in_gpr(ctx, v1632.1);
                                                                            let v1673 = &constructor_x64_xor_mem(ctx, v1629, v1645, v1646);
                                                                            let v1674 = constructor_side_effect(ctx, v1673);
                                                                            // Rule at src/isa/x64/lower.isle line 3145.
                                                                            return Some(v1674);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v1649 = &C::sinkable_load(ctx, v1632.1);
                                                if let Some(v1650) = v1649 {
                                                    let v1651 = C::def_inst(ctx, v1632.1);
                                                    if let Some(v1652) = v1651 {
                                                        let v1653 = &C::inst_data(ctx, v1652);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v1654,
                                                            arg: v1655,
                                                            flags: v1656,
                                                            offset: v1657,
                                                        } = v1653
                                                        {
                                                            if let &Opcode::Load = v1654 {
                                                                if v1553 == v1656 {
                                                                    if v1554 == v1657 {
                                                                        if v1555.1 == v1655 {
                                                                            let v1658 = &constructor_sink_load_to_reg_mem_imm(ctx, v1650);
                                                                            let v1659 = &constructor_to_amode(ctx, v1656, v1655, v1657);
                                                                            let v1660 = constructor_put_in_gpr(ctx, v1632.0);
                                                                            let v1675 = &constructor_x64_xor_mem(ctx, v1629, v1659, v1660);
                                                                            let v1676 = constructor_side_effect(ctx, v1675);
                                                                            // Rule at src/isa/x64/lower.isle line 3159.
                                                                            return Some(v1676);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                                &InstructionData::BinaryImm8 {
                                    opcode: ref v1611,
                                    arg: v1612,
                                    imm: v1613,
                                } => {
                                    if let &Opcode::Extractlane = v1611 {
                                        let v1577 = C::value_type(ctx, v1576);
                                        match v1577 {
                                            I8 => {
                                                let v441 = C::use_sse41(ctx);
                                                if v441 == true {
                                                    let v1562 = &constructor_to_amode(
                                                        ctx, v1553, v1555.1, v1554,
                                                    );
                                                    let v1563 =
                                                        &C::amode_to_synthetic_amode(ctx, v1562);
                                                    let v1615 = constructor_put_in_xmm(ctx, v1612);
                                                    let v1614 = C::u8_from_uimm8(ctx, v1613);
                                                    let v1620 = &constructor_x64_pextrb_store(
                                                        ctx, v1563, v1615, v1614,
                                                    );
                                                    let v1621 = constructor_side_effect(ctx, v1620);
                                                    // Rule at src/isa/x64/lower.isle line 3015.
                                                    return Some(v1621);
                                                }
                                            }
                                            I16 => {
                                                let v441 = C::use_sse41(ctx);
                                                if v441 == true {
                                                    let v1562 = &constructor_to_amode(
                                                        ctx, v1553, v1555.1, v1554,
                                                    );
                                                    let v1563 =
                                                        &C::amode_to_synthetic_amode(ctx, v1562);
                                                    let v1615 = constructor_put_in_xmm(ctx, v1612);
                                                    let v1614 = C::u8_from_uimm8(ctx, v1613);
                                                    let v1622 = &constructor_x64_pextrw_store(
                                                        ctx, v1563, v1615, v1614,
                                                    );
                                                    let v1623 = constructor_side_effect(ctx, v1622);
                                                    // Rule at src/isa/x64/lower.isle line 3022.
                                                    return Some(v1623);
                                                }
                                            }
                                            I32 => {
                                                let v441 = C::use_sse41(ctx);
                                                if v441 == true {
                                                    let v1562 = &constructor_to_amode(
                                                        ctx, v1553, v1555.1, v1554,
                                                    );
                                                    let v1563 =
                                                        &C::amode_to_synthetic_amode(ctx, v1562);
                                                    let v1615 = constructor_put_in_xmm(ctx, v1612);
                                                    let v1614 = C::u8_from_uimm8(ctx, v1613);
                                                    let v1624 = &constructor_x64_pextrd_store(
                                                        ctx, v1563, v1615, v1614,
                                                    );
                                                    let v1625 = constructor_side_effect(ctx, v1624);
                                                    // Rule at src/isa/x64/lower.isle line 3029.
                                                    return Some(v1625);
                                                }
                                            }
                                            I64 => {
                                                let v441 = C::use_sse41(ctx);
                                                if v441 == true {
                                                    let v1562 = &constructor_to_amode(
                                                        ctx, v1553, v1555.1, v1554,
                                                    );
                                                    let v1563 =
                                                        &C::amode_to_synthetic_amode(ctx, v1562);
                                                    let v1615 = constructor_put_in_xmm(ctx, v1612);
                                                    let v1614 = C::u8_from_uimm8(ctx, v1613);
                                                    let v1626 = &constructor_x64_pextrq_store(
                                                        ctx, v1563, v1615, v1614,
                                                    );
                                                    let v1627 = constructor_side_effect(ctx, v1626);
                                                    // Rule at src/isa/x64/lower.isle line 3036.
                                                    return Some(v1627);
                                                }
                                            }
                                            F32 => {
                                                let v1614 = C::u8_from_uimm8(ctx, v1613);
                                                if v1614 == 0x0 {
                                                    let v1562 = &constructor_to_amode(
                                                        ctx, v1553, v1555.1, v1554,
                                                    );
                                                    let v1563 =
                                                        &C::amode_to_synthetic_amode(ctx, v1562);
                                                    let v1615 = constructor_put_in_xmm(ctx, v1612);
                                                    let v1616 = &constructor_x64_movss_store(
                                                        ctx, v1563, v1615,
                                                    );
                                                    let v1617 = constructor_side_effect(ctx, v1616);
                                                    // Rule at src/isa/x64/lower.isle line 3003.
                                                    return Some(v1617);
                                                }
                                            }
                                            F64 => {
                                                let v1614 = C::u8_from_uimm8(ctx, v1613);
                                                if v1614 == 0x0 {
                                                    let v1562 = &constructor_to_amode(
                                                        ctx, v1553, v1555.1, v1554,
                                                    );
                                                    let v1563 =
                                                        &C::amode_to_synthetic_amode(ctx, v1562);
                                                    let v1615 = constructor_put_in_xmm(ctx, v1612);
                                                    let v1618 = &constructor_x64_movsd_store(
                                                        ctx, v1563, v1615,
                                                    );
                                                    let v1619 = constructor_side_effect(ctx, v1618);
                                                    // Rule at src/isa/x64/lower.isle line 3009.
                                                    return Some(v1619);
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                &InstructionData::UnaryImm {
                                    opcode: ref v1581,
                                    imm: v1582,
                                } => {
                                    if let &Opcode::Iconst = v1581 {
                                        let v1577 = C::value_type(ctx, v1576);
                                        let v1578 = C::fits_in_64(ctx, v1577);
                                        if let Some(v1579) = v1578 {
                                            let v1583 = C::simm32(ctx, v1582);
                                            if let Some(v1584) = v1583 {
                                                let v1562 = &constructor_to_amode(
                                                    ctx, v1553, v1555.1, v1554,
                                                );
                                                let v1563 =
                                                    &C::amode_to_synthetic_amode(ctx, v1562);
                                                let v1585 = &constructor_x64_movimm_m(
                                                    ctx, v1579, v1563, v1584,
                                                );
                                                let v1586 = constructor_side_effect(ctx, v1585);
                                                // Rule at src/isa/x64/lower.isle line 2939.
                                                return Some(v1586);
                                            }
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                    let v1558 = C::value_type(ctx, v1555.0);
                    match v1558 {
                        I128 => {
                            let v1600 = C::put_in_regs(ctx, v1555.0);
                            let v1601 = constructor_value_regs_get_gpr(ctx, v1600, 0x0);
                            let v1602 = constructor_value_regs_get_gpr(ctx, v1600, 0x1);
                            let v1603 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                            let v1604 = &C::amode_offset(ctx, v1603, 0x8);
                            let v1605 = &C::amode_to_synthetic_amode(ctx, v1603);
                            let v1606 = &constructor_x64_movrm(ctx, I64, v1605, v1601);
                            let v1607 = &C::amode_to_synthetic_amode(ctx, v1604);
                            let v1608 = &constructor_x64_movrm(ctx, I64, v1607, v1602);
                            let v1609 = &constructor_side_effect_concat(ctx, v1606, v1608);
                            let v1610 = constructor_side_effect(ctx, v1609);
                            // Rule at src/isa/x64/lower.isle line 2984.
                            return Some(v1610);
                        }
                        F32 => {
                            let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                            let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                            let v1587 = constructor_put_in_xmm(ctx, v1555.0);
                            let v1588 = &constructor_x64_movss_store(ctx, v1563, v1587);
                            let v1589 = constructor_side_effect(ctx, v1588);
                            // Rule at src/isa/x64/lower.isle line 2944.
                            return Some(v1589);
                        }
                        F64 => {
                            let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                            let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                            let v1587 = constructor_put_in_xmm(ctx, v1555.0);
                            let v1590 = &constructor_x64_movsd_store(ctx, v1563, v1587);
                            let v1591 = constructor_side_effect(ctx, v1590);
                            // Rule at src/isa/x64/lower.isle line 2952.
                            return Some(v1591);
                        }
                        F32X4 => {
                            let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                            let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                            let v1587 = constructor_put_in_xmm(ctx, v1555.0);
                            let v1592 = &constructor_x64_movups_store(ctx, v1563, v1587);
                            let v1593 = constructor_side_effect(ctx, v1592);
                            // Rule at src/isa/x64/lower.isle line 2960.
                            return Some(v1593);
                        }
                        F64X2 => {
                            let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                            let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                            let v1587 = constructor_put_in_xmm(ctx, v1555.0);
                            let v1594 = &constructor_x64_movupd_store(ctx, v1563, v1587);
                            let v1595 = constructor_side_effect(ctx, v1594);
                            // Rule at src/isa/x64/lower.isle line 2968.
                            return Some(v1595);
                        }
                        _ => {}
                    }
                    let v1596 = C::ty_vec128_int(ctx, v1558);
                    if let Some(v1597) = v1596 {
                        let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                        let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                        let v1587 = constructor_put_in_xmm(ctx, v1555.0);
                        let v1598 = &constructor_x64_movdqu_store(ctx, v1563, v1587);
                        let v1599 = constructor_side_effect(ctx, v1598);
                        // Rule at src/isa/x64/lower.isle line 2976.
                        return Some(v1599);
                    }
                    let v1559 = &C::type_register_class(ctx, v1558);
                    if let Some(v1560) = v1559 {
                        if let &RegisterClass::Gpr {
                            single_register: v1561,
                        } = v1560
                        {
                            let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                            let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                            let v1564 = constructor_put_in_gpr(ctx, v1555.0);
                            let v1565 = &constructor_x64_movrm(ctx, v1558, v1563, v1564);
                            let v1566 = constructor_side_effect(ctx, v1565);
                            // Rule at src/isa/x64/lower.isle line 2920.
                            return Some(v1566);
                        }
                    }
                }
                &Opcode::Istore8 => {
                    let v1555 = C::unpack_value_array_2(ctx, v1552);
                    let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                    let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                    let v1564 = constructor_put_in_gpr(ctx, v1555.0);
                    let v1567 = &constructor_x64_movrm(ctx, I8, v1563, v1564);
                    let v1568 = constructor_side_effect(ctx, v1567);
                    // Rule at src/isa/x64/lower.isle line 2928.
                    return Some(v1568);
                }
                &Opcode::Istore16 => {
                    let v1555 = C::unpack_value_array_2(ctx, v1552);
                    let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                    let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                    let v1564 = constructor_put_in_gpr(ctx, v1555.0);
                    let v1569 = &constructor_x64_movrm(ctx, I16, v1563, v1564);
                    let v1570 = constructor_side_effect(ctx, v1569);
                    // Rule at src/isa/x64/lower.isle line 2931.
                    return Some(v1570);
                }
                &Opcode::Istore32 => {
                    let v1555 = C::unpack_value_array_2(ctx, v1552);
                    let v1562 = &constructor_to_amode(ctx, v1553, v1555.1, v1554);
                    let v1563 = &C::amode_to_synthetic_amode(ctx, v1562);
                    let v1564 = constructor_put_in_gpr(ctx, v1555.0);
                    let v1571 = &constructor_x64_movrm(ctx, I32, v1563, v1564);
                    let v1572 = constructor_side_effect(ctx, v1571);
                    // Rule at src/isa/x64/lower.isle line 2934.
                    return Some(v1572);
                }
                _ => {}
            }
        }
        &InstructionData::StoreNoOffset {
            opcode: ref v1710,
            args: ref v1711,
            flags: v1712,
        } => {
            if let &Opcode::AtomicStore = v1710 {
                let v1713 = C::unpack_value_array_2(ctx, v1711);
                let v1716 = C::value_type(ctx, v1713.0);
                let v1717 = C::fits_in_64(ctx, v1716);
                if let Some(v1718) = v1717 {
                    let v1719 = C::ty_int(ctx, v1716);
                    if let Some(v1720) = v1719 {
                        let v48 = C::zero_offset(ctx);
                        let v1721 = &constructor_to_amode(ctx, v1712, v1713.1, v48);
                        let v1722 = &C::amode_to_synthetic_amode(ctx, v1721);
                        let v1723 = constructor_put_in_gpr(ctx, v1713.0);
                        let v1724 = &constructor_x64_movrm(ctx, v1718, v1722, v1723);
                        let v1725 = &constructor_x64_mfence(ctx);
                        let v1726 = &constructor_side_effect_concat(ctx, v1724, v1725);
                        let v1727 = constructor_side_effect(ctx, v1726);
                        // Rule at src/isa/x64/lower.isle line 3206.
                        return Some(v1727);
                    }
                }
            }
        }
        &InstructionData::Ternary {
            opcode: ref v634,
            args: ref v635,
        } => {
            match v634 {
                &Opcode::Select => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v636 = C::unpack_value_array_3(ctx, v635);
                        let v1007 = C::maybe_uextend(ctx, v636.0);
                        if let Some(v1008) = v1007 {
                            let v1009 = C::def_inst(ctx, v1008);
                            if let Some(v1010) = v1009 {
                                let v1011 = &C::inst_data(ctx, v1010);
                                match v1011 {
                                    &InstructionData::FloatCompare {
                                        opcode: ref v1012,
                                        args: ref v1013,
                                        cond: ref v1014,
                                    } => {
                                        if let &Opcode::Fcmp = v1012 {
                                            match v1014 {
                                                &FloatCC::Equal => {
                                                    let v1015 = C::unpack_value_array_2(ctx, v1013);
                                                    let v1021 = &constructor_emit_fcmp(
                                                        ctx,
                                                        &FloatCC::NotEqual,
                                                        v1015.0,
                                                        v1015.1,
                                                    );
                                                    let v3 = C::value_type(ctx, v2);
                                                    let v1022 = constructor_lower_select_fcmp(
                                                        ctx, v3, v1021, v636.2, v636.1,
                                                    );
                                                    // Rule at src/isa/x64/lower.isle line 2049.
                                                    return Some(v1022);
                                                }
                                                &FloatCC::LessThan => {
                                                    let v3 = C::value_type(ctx, v2);
                                                    match v3 {
                                                        F32 => {
                                                            let v1015 =
                                                                C::unpack_value_array_2(ctx, v1013);
                                                            if v636.1 == v1015.1 {
                                                                if v636.2 == v1015.0 {
                                                                    let v1061 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v1015.1,
                                                                        );
                                                                    let v1062 = &C::put_in_xmm_mem(
                                                                        ctx, v1015.0,
                                                                    );
                                                                    let v1063 =
                                                                        constructor_x64_maxss(
                                                                            ctx, v1061, v1062,
                                                                        );
                                                                    let v1064 =
                                                                        constructor_output_xmm(
                                                                            ctx, v1063,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 2088.
                                                                    return Some(v1064);
                                                                }
                                                            }
                                                            if v636.1 == v1015.0 {
                                                                if v636.2 == v1015.1 {
                                                                    let v1055 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v1015.0,
                                                                        );
                                                                    let v1056 = &C::put_in_xmm_mem(
                                                                        ctx, v1015.1,
                                                                    );
                                                                    let v1057 =
                                                                        constructor_x64_minss(
                                                                            ctx, v1055, v1056,
                                                                        );
                                                                    let v1058 =
                                                                        constructor_output_xmm(
                                                                            ctx, v1057,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 2084.
                                                                    return Some(v1058);
                                                                }
                                                            }
                                                        }
                                                        F64 => {
                                                            let v1015 =
                                                                C::unpack_value_array_2(ctx, v1013);
                                                            if v636.1 == v1015.1 {
                                                                if v636.2 == v1015.0 {
                                                                    let v1061 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v1015.1,
                                                                        );
                                                                    let v1062 = &C::put_in_xmm_mem(
                                                                        ctx, v1015.0,
                                                                    );
                                                                    let v1065 =
                                                                        constructor_x64_maxsd(
                                                                            ctx, v1061, v1062,
                                                                        );
                                                                    let v1066 =
                                                                        constructor_output_xmm(
                                                                            ctx, v1065,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 2090.
                                                                    return Some(v1066);
                                                                }
                                                            }
                                                            if v636.1 == v1015.0 {
                                                                if v636.2 == v1015.1 {
                                                                    let v1055 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v1015.0,
                                                                        );
                                                                    let v1056 = &C::put_in_xmm_mem(
                                                                        ctx, v1015.1,
                                                                    );
                                                                    let v1059 =
                                                                        constructor_x64_minsd(
                                                                            ctx, v1055, v1056,
                                                                        );
                                                                    let v1060 =
                                                                        constructor_output_xmm(
                                                                            ctx, v1059,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 2086.
                                                                    return Some(v1060);
                                                                }
                                                            }
                                                        }
                                                        _ => {}
                                                    }
                                                }
                                                _ => {}
                                            }
                                            let v1015 = C::unpack_value_array_2(ctx, v1013);
                                            let v1018 = &constructor_emit_fcmp(
                                                ctx, v1014, v1015.0, v1015.1,
                                            );
                                            let v3 = C::value_type(ctx, v2);
                                            let v1019 = constructor_lower_select_fcmp(
                                                ctx, v3, v1018, v636.1, v636.2,
                                            );
                                            // Rule at src/isa/x64/lower.isle line 2047.
                                            return Some(v1019);
                                        }
                                    }
                                    &InstructionData::IntCompare {
                                        opcode: ref v1023,
                                        args: ref v1024,
                                        cond: ref v1025,
                                    } => {
                                        if let &Opcode::Icmp = v1023 {
                                            let v1026 = C::unpack_value_array_2(ctx, v1024);
                                            let v1029 = C::value_type(ctx, v1026.0);
                                            let v1030 = C::fits_in_64(ctx, v1029);
                                            if let Some(v1031) = v1030 {
                                                let v1032 =
                                                    &C::raw_operand_size_of_type(ctx, v1031);
                                                let v1033 =
                                                    &constructor_put_in_gpr_mem_imm(ctx, v1026.1);
                                                let v1034 = constructor_put_in_gpr(ctx, v1026.0);
                                                let v1035 =
                                                    &constructor_x64_cmp(ctx, v1032, v1033, v1034);
                                                let v1036 = &C::intcc_to_cc(ctx, v1025);
                                                let v3 = C::value_type(ctx, v2);
                                                let v1037 = &constructor_cmove_from_values(
                                                    ctx, v3, v1036, v636.1, v636.2,
                                                );
                                                let v1038 =
                                                    constructor_with_flags(ctx, v1035, v1037);
                                                let v1039 = C::output(ctx, v1038);
                                                // Rule at src/isa/x64/lower.isle line 2063.
                                                return Some(v1039);
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                        }
                        let v1040 = C::value_type(ctx, v636.0);
                        let v1041 = C::fits_in_64(ctx, v1040);
                        if let Some(v1042) = v1041 {
                            let v1043 = &C::raw_operand_size_of_type(ctx, v1042);
                            let v1044 = constructor_put_in_gpr(ctx, v636.0);
                            let v1045 = &C::gpr_to_gpr_mem_imm(ctx, v1044);
                            let v1046 = &constructor_x64_test(ctx, v1043, v1045, v1044);
                            let v3 = C::value_type(ctx, v2);
                            let v1048 =
                                &constructor_cmove_from_values(ctx, v3, &CC::NZ, v636.1, v636.2);
                            let v1049 = constructor_with_flags(ctx, v1046, v1048);
                            let v1050 = C::output(ctx, v1049);
                            // Rule at src/isa/x64/lower.isle line 2070.
                            return Some(v1050);
                        }
                        if v1040 == I128 {
                            let v683 = C::put_in_regs(ctx, v636.0);
                            let v1052 = &constructor_cmp_zero_i128(ctx, &CC::Z, v683);
                            let v1053 = constructor_select_icmp(ctx, v1052, v636.1, v636.2);
                            let v1054 = C::output(ctx, v1053);
                            // Rule at src/isa/x64/lower.isle line 2077.
                            return Some(v1054);
                        }
                    }
                }
                &Opcode::SelectSpectreGuard => {
                    let v636 = C::unpack_value_array_3(ctx, v635);
                    let v656 = C::def_inst(ctx, v636.0);
                    if let Some(v657) = v656 {
                        let v658 = &C::inst_data(ctx, v657);
                        if let &InstructionData::IntCompare {
                            opcode: ref v1783,
                            args: ref v1784,
                            cond: ref v1785,
                        } = v658
                        {
                            if let &Opcode::Icmp = v1783 {
                                let v1786 = C::unpack_value_array_2(ctx, v1784);
                                let v1789 = &constructor_emit_cmp(ctx, v1785, v1786.0, v1786.1);
                                let v1790 = constructor_select_icmp(ctx, v1789, v636.1, v636.2);
                                let v1791 = C::output(ctx, v1790);
                                // Rule at src/isa/x64/lower.isle line 3325.
                                return Some(v1791);
                            }
                        }
                    }
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v1040 = C::value_type(ctx, v636.0);
                        let v1041 = C::fits_in_64(ctx, v1040);
                        if let Some(v1042) = v1041 {
                            let v1043 = &C::raw_operand_size_of_type(ctx, v1042);
                            let v1044 = constructor_put_in_gpr(ctx, v636.0);
                            let v1045 = &C::gpr_to_gpr_mem_imm(ctx, v1044);
                            let v1046 = &constructor_x64_test(ctx, v1043, v1045, v1044);
                            let v3 = C::value_type(ctx, v2);
                            let v1048 =
                                &constructor_cmove_from_values(ctx, v3, &CC::NZ, v636.1, v636.2);
                            let v1049 = constructor_with_flags(ctx, v1046, v1048);
                            let v1050 = C::output(ctx, v1049);
                            // Rule at src/isa/x64/lower.isle line 3328.
                            return Some(v1050);
                        }
                        if v1040 == I128 {
                            let v683 = C::put_in_regs(ctx, v636.0);
                            let v1052 = &constructor_cmp_zero_i128(ctx, &CC::Z, v683);
                            let v1053 = constructor_select_icmp(ctx, v1052, v636.1, v636.2);
                            let v1054 = C::output(ctx, v1053);
                            // Rule at src/isa/x64/lower.isle line 3333.
                            return Some(v1054);
                        }
                    }
                }
                &Opcode::Bitselect => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v162 = C::ty_scalar_float(ctx, v3);
                        if let Some(v163) = v162 {
                            let v636 = C::unpack_value_array_3(ctx, v635);
                            let v640 = constructor_put_in_xmm(ctx, v636.0);
                            let v652 = &C::put_in_xmm_mem(ctx, v636.1);
                            let v703 = constructor_sse_and(ctx, v163, v640, v652);
                            let v704 = constructor_put_in_xmm(ctx, v636.0);
                            let v705 = constructor_vector_all_ones(ctx);
                            let v706 = &C::xmm_to_xmm_mem(ctx, v705);
                            let v707 = constructor_x64_xor_vector(ctx, v163, v704, v706);
                            let v708 = &C::put_in_xmm_mem(ctx, v636.2);
                            let v709 = constructor_sse_and(ctx, v163, v707, v708);
                            let v710 = &C::xmm_to_xmm_mem(ctx, v709);
                            let v711 = constructor_sse_or(ctx, v163, v703, v710);
                            let v712 = constructor_output_xmm(ctx, v711);
                            // Rule at src/isa/x64/lower.isle line 1437.
                            return Some(v712);
                        }
                        let v691 = C::ty_int_ref_scalar_64_extract(ctx, v3);
                        if let Some(v692) = v691 {
                            let v636 = C::unpack_value_array_3(ctx, v635);
                            let v693 = constructor_put_in_gpr(ctx, v636.0);
                            let v694 = &constructor_put_in_gpr_mem_imm(ctx, v636.1);
                            let v695 = constructor_x64_and(ctx, v692, v693, v694);
                            let v696 = constructor_put_in_gpr(ctx, v636.0);
                            let v697 = constructor_x64_not(ctx, v692, v696);
                            let v698 = &constructor_put_in_gpr_mem_imm(ctx, v636.2);
                            let v699 = constructor_x64_and(ctx, v692, v697, v698);
                            let v700 = &C::gpr_to_gpr_mem_imm(ctx, v699);
                            let v701 = constructor_x64_or(ctx, v692, v695, v700);
                            let v702 = constructor_output_gpr(ctx, v701);
                            // Rule at src/isa/x64/lower.isle line 1432.
                            return Some(v702);
                        }
                        match v3 {
                            I128 => {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v683 = C::put_in_regs(ctx, v636.0);
                                let v684 = C::put_in_regs(ctx, v636.1);
                                let v685 = constructor_and_i128(ctx, v683, v684);
                                let v686 = constructor_i128_not(ctx, v636.0);
                                let v687 = C::put_in_regs(ctx, v636.2);
                                let v688 = constructor_and_i128(ctx, v686, v687);
                                let v689 = constructor_or_i128(ctx, v685, v688);
                                let v690 = C::output(ctx, v689);
                                // Rule at src/isa/x64/lower.isle line 1427.
                                return Some(v690);
                            }
                            F32X4 => {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v656 = C::def_inst(ctx, v636.0);
                                if let Some(v657) = v656 {
                                    let v658 = &C::inst_data(ctx, v657);
                                    if let &InstructionData::LoadNoOffset {
                                        opcode: ref v659,
                                        arg: v660,
                                        flags: v661,
                                    } = v658
                                    {
                                        if let &Opcode::Bitcast = v659 {
                                            let v662 = C::def_inst(ctx, v660);
                                            if let Some(v663) = v662 {
                                                let v664 = &C::inst_data(ctx, v663);
                                                if let &InstructionData::FloatCompare {
                                                    opcode: ref v665,
                                                    args: ref v666,
                                                    cond: ref v667,
                                                } = v664
                                                {
                                                    if let &Opcode::Fcmp = v665 {
                                                        if let &FloatCC::LessThan = v667 {
                                                            let v668 =
                                                                C::unpack_value_array_2(ctx, v666);
                                                            if v636.1 == v668.1 {
                                                                if v636.2 == v668.0 {
                                                                    let v677 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v668.1,
                                                                        );
                                                                    let v678 = &C::put_in_xmm_mem(
                                                                        ctx, v668.0,
                                                                    );
                                                                    let v679 =
                                                                        constructor_x64_maxps(
                                                                            ctx, v677, v678,
                                                                        );
                                                                    let v680 =
                                                                        constructor_output_xmm(
                                                                            ctx, v679,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 1420.
                                                                    return Some(v680);
                                                                }
                                                            }
                                                            if v636.1 == v668.0 {
                                                                if v636.2 == v668.1 {
                                                                    let v671 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v668.0,
                                                                        );
                                                                    let v672 = &C::put_in_xmm_mem(
                                                                        ctx, v668.1,
                                                                    );
                                                                    let v673 =
                                                                        constructor_x64_minps(
                                                                            ctx, v671, v672,
                                                                        );
                                                                    let v674 =
                                                                        constructor_output_xmm(
                                                                            ctx, v673,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 1415.
                                                                    return Some(v674);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            F64X2 => {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v656 = C::def_inst(ctx, v636.0);
                                if let Some(v657) = v656 {
                                    let v658 = &C::inst_data(ctx, v657);
                                    if let &InstructionData::LoadNoOffset {
                                        opcode: ref v659,
                                        arg: v660,
                                        flags: v661,
                                    } = v658
                                    {
                                        if let &Opcode::Bitcast = v659 {
                                            let v662 = C::def_inst(ctx, v660);
                                            if let Some(v663) = v662 {
                                                let v664 = &C::inst_data(ctx, v663);
                                                if let &InstructionData::FloatCompare {
                                                    opcode: ref v665,
                                                    args: ref v666,
                                                    cond: ref v667,
                                                } = v664
                                                {
                                                    if let &Opcode::Fcmp = v665 {
                                                        if let &FloatCC::LessThan = v667 {
                                                            let v668 =
                                                                C::unpack_value_array_2(ctx, v666);
                                                            if v636.1 == v668.1 {
                                                                if v636.2 == v668.0 {
                                                                    let v677 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v668.1,
                                                                        );
                                                                    let v678 = &C::put_in_xmm_mem(
                                                                        ctx, v668.0,
                                                                    );
                                                                    let v681 =
                                                                        constructor_x64_maxpd(
                                                                            ctx, v677, v678,
                                                                        );
                                                                    let v682 =
                                                                        constructor_output_xmm(
                                                                            ctx, v681,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 1422.
                                                                    return Some(v682);
                                                                }
                                                            }
                                                            if v636.1 == v668.0 {
                                                                if v636.2 == v668.1 {
                                                                    let v671 =
                                                                        constructor_put_in_xmm(
                                                                            ctx, v668.0,
                                                                        );
                                                                    let v672 = &C::put_in_xmm_mem(
                                                                        ctx, v668.1,
                                                                    );
                                                                    let v675 =
                                                                        constructor_x64_minpd(
                                                                            ctx, v671, v672,
                                                                        );
                                                                    let v676 =
                                                                        constructor_output_xmm(
                                                                            ctx, v675,
                                                                        );
                                                                    // Rule at src/isa/x64/lower.isle line 1417.
                                                                    return Some(v676);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            let v441 = C::use_sse41(ctx);
                            if v441 == true {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v649 = constructor_all_ones_or_all_zeros(ctx, v636.0);
                                if let Some(v650) = v649 {
                                    let v651 = constructor_put_in_xmm(ctx, v636.2);
                                    let v652 = &C::put_in_xmm_mem(ctx, v636.1);
                                    let v653 = constructor_put_in_xmm(ctx, v636.0);
                                    let v654 = constructor_x64_pblendvb(ctx, v651, v652, v653);
                                    let v655 = constructor_output_xmm(ctx, v654);
                                    // Rule at src/isa/x64/lower.isle line 1394.
                                    return Some(v655);
                                }
                            }
                            let v636 = C::unpack_value_array_3(ctx, v635);
                            let v640 = constructor_put_in_xmm(ctx, v636.0);
                            let v641 = constructor_put_in_xmm(ctx, v636.1);
                            let v642 = &C::xmm_to_xmm_mem(ctx, v640);
                            let v643 = constructor_sse_and(ctx, v3, v641, v642);
                            let v644 = &C::put_in_xmm_mem(ctx, v636.2);
                            let v645 = constructor_sse_and_not(ctx, v3, v640, v644);
                            let v646 = &C::xmm_to_xmm_mem(ctx, v643);
                            let v647 = constructor_sse_or(ctx, v3, v645, v646);
                            let v648 = constructor_output_xmm(ctx, v647);
                            // Rule at src/isa/x64/lower.isle line 1380.
                            return Some(v648);
                        }
                    }
                }
                &Opcode::X86Blendv => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v636 = C::unpack_value_array_3(ctx, v635);
                                    let v651 = constructor_put_in_xmm(ctx, v636.2);
                                    let v652 = &C::put_in_xmm_mem(ctx, v636.1);
                                    let v653 = constructor_put_in_xmm(ctx, v636.0);
                                    let v654 = constructor_x64_pblendvb(ctx, v651, v652, v653);
                                    let v655 = constructor_output_xmm(ctx, v654);
                                    // Rule at src/isa/x64/lower.isle line 1445.
                                    return Some(v655);
                                }
                            }
                            I32X4 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v636 = C::unpack_value_array_3(ctx, v635);
                                    let v651 = constructor_put_in_xmm(ctx, v636.2);
                                    let v652 = &C::put_in_xmm_mem(ctx, v636.1);
                                    let v653 = constructor_put_in_xmm(ctx, v636.0);
                                    let v713 = constructor_x64_blendvps(ctx, v651, v652, v653);
                                    let v714 = constructor_output_xmm(ctx, v713);
                                    // Rule at src/isa/x64/lower.isle line 1450.
                                    return Some(v714);
                                }
                            }
                            I64X2 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v636 = C::unpack_value_array_3(ctx, v635);
                                    let v651 = constructor_put_in_xmm(ctx, v636.2);
                                    let v652 = &C::put_in_xmm_mem(ctx, v636.1);
                                    let v653 = constructor_put_in_xmm(ctx, v636.0);
                                    let v715 = constructor_x64_blendvpd(ctx, v651, v652, v653);
                                    let v716 = constructor_output_xmm(ctx, v715);
                                    // Rule at src/isa/x64/lower.isle line 1455.
                                    return Some(v716);
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fma => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v1470 = C::use_fma(ctx);
                        if v1470 == true {
                            let v3 = C::value_type(ctx, v2);
                            let v636 = C::unpack_value_array_3(ctx, v635);
                            let v1471 = constructor_fmadd(ctx, v3, v636.0, v636.1, v636.2);
                            let v1472 = constructor_output_xmm(ctx, v1471);
                            // Rule at src/isa/x64/lower.isle line 2799.
                            return Some(v1472);
                        }
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v1389 = C::put_in_reg(ctx, v636.0);
                                let v1390 = C::put_in_reg(ctx, v636.1);
                                let v1391 = C::put_in_reg(ctx, v636.2);
                                let v1392 =
                                    C::libcall_3(ctx, &LibCall::FmaF32, v1389, v1390, v1391);
                                let v1393 = constructor_output_reg(ctx, v1392);
                                // Rule at src/isa/x64/lower.isle line 2754.
                                return Some(v1393);
                            }
                            F64 => {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v1389 = C::put_in_reg(ctx, v636.0);
                                let v1390 = C::put_in_reg(ctx, v636.1);
                                let v1391 = C::put_in_reg(ctx, v636.2);
                                let v1395 =
                                    C::libcall_3(ctx, &LibCall::FmaF64, v1389, v1390, v1391);
                                let v1396 = constructor_output_reg(ctx, v1395);
                                // Rule at src/isa/x64/lower.isle line 2756.
                                return Some(v1396);
                            }
                            F32X4 => {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v640 = constructor_put_in_xmm(ctx, v636.0);
                                let v641 = constructor_put_in_xmm(ctx, v636.1);
                                let v1397 = constructor_put_in_xmm(ctx, v636.2);
                                let v1398 = C::xmm_to_reg(ctx, v640);
                                let v1399 = C::xmm_to_reg(ctx, v641);
                                let v1400 = C::xmm_to_reg(ctx, v1397);
                                let v1401 =
                                    C::libcall_3(ctx, &LibCall::FmaF32, v1398, v1399, v1400);
                                let v1402 = C::xmm_new(ctx, v1401);
                                let v1403 = &C::xmm_to_xmm_mem(ctx, v640);
                                let v1405 = constructor_x64_pshufd(ctx, v1403, 0x1);
                                let v1406 = C::xmm_to_reg(ctx, v1405);
                                let v1407 = &C::xmm_to_xmm_mem(ctx, v641);
                                let v1408 = constructor_x64_pshufd(ctx, v1407, 0x1);
                                let v1409 = C::xmm_to_reg(ctx, v1408);
                                let v1410 = &C::xmm_to_xmm_mem(ctx, v1397);
                                let v1411 = constructor_x64_pshufd(ctx, v1410, 0x1);
                                let v1412 = C::xmm_to_reg(ctx, v1411);
                                let v1413 =
                                    C::libcall_3(ctx, &LibCall::FmaF32, v1406, v1409, v1412);
                                let v1414 = C::xmm_new(ctx, v1413);
                                let v1415 = &C::xmm_to_xmm_mem(ctx, v640);
                                let v1417 = constructor_x64_pshufd(ctx, v1415, 0x2);
                                let v1418 = C::xmm_to_reg(ctx, v1417);
                                let v1419 = &C::xmm_to_xmm_mem(ctx, v641);
                                let v1420 = constructor_x64_pshufd(ctx, v1419, 0x2);
                                let v1421 = C::xmm_to_reg(ctx, v1420);
                                let v1422 = &C::xmm_to_xmm_mem(ctx, v1397);
                                let v1423 = constructor_x64_pshufd(ctx, v1422, 0x2);
                                let v1424 = C::xmm_to_reg(ctx, v1423);
                                let v1425 =
                                    C::libcall_3(ctx, &LibCall::FmaF32, v1418, v1421, v1424);
                                let v1426 = C::xmm_new(ctx, v1425);
                                let v1427 = &C::xmm_to_xmm_mem(ctx, v640);
                                let v1429 = constructor_x64_pshufd(ctx, v1427, 0x3);
                                let v1430 = C::xmm_to_reg(ctx, v1429);
                                let v1431 = &C::xmm_to_xmm_mem(ctx, v641);
                                let v1432 = constructor_x64_pshufd(ctx, v1431, 0x3);
                                let v1433 = C::xmm_to_reg(ctx, v1432);
                                let v1434 = &C::xmm_to_xmm_mem(ctx, v1397);
                                let v1435 = constructor_x64_pshufd(ctx, v1434, 0x3);
                                let v1436 = C::xmm_to_reg(ctx, v1435);
                                let v1437 =
                                    C::libcall_3(ctx, &LibCall::FmaF32, v1430, v1433, v1436);
                                let v1438 = C::xmm_new(ctx, v1437);
                                let v1440 = C::xmm_to_reg(ctx, v1414);
                                let v1441 = &constructor_xmm_to_reg_mem(ctx, v1440);
                                let v1442 = &C::xmm_mem_to_reg_mem(ctx, v1441);
                                let v1443 =
                                    constructor_vec_insert_lane(ctx, F32X4, v1402, v1442, 0x1);
                                let v1444 = C::xmm_to_reg(ctx, v1426);
                                let v1445 = &constructor_xmm_to_reg_mem(ctx, v1444);
                                let v1446 = &C::xmm_mem_to_reg_mem(ctx, v1445);
                                let v1447 =
                                    constructor_vec_insert_lane(ctx, F32X4, v1443, v1446, 0x2);
                                let v1448 = C::xmm_to_reg(ctx, v1438);
                                let v1449 = &constructor_xmm_to_reg_mem(ctx, v1448);
                                let v1450 = &C::xmm_mem_to_reg_mem(ctx, v1449);
                                let v1451 =
                                    constructor_vec_insert_lane(ctx, F32X4, v1447, v1450, 0x3);
                                let v1452 = constructor_output_xmm(ctx, v1451);
                                // Rule at src/isa/x64/lower.isle line 2759.
                                return Some(v1452);
                            }
                            F64X2 => {
                                let v636 = C::unpack_value_array_3(ctx, v635);
                                let v640 = constructor_put_in_xmm(ctx, v636.0);
                                let v641 = constructor_put_in_xmm(ctx, v636.1);
                                let v1397 = constructor_put_in_xmm(ctx, v636.2);
                                let v1398 = C::xmm_to_reg(ctx, v640);
                                let v1399 = C::xmm_to_reg(ctx, v641);
                                let v1400 = C::xmm_to_reg(ctx, v1397);
                                let v1453 =
                                    C::libcall_3(ctx, &LibCall::FmaF64, v1398, v1399, v1400);
                                let v1454 = C::xmm_new(ctx, v1453);
                                let v1403 = &C::xmm_to_xmm_mem(ctx, v640);
                                let v1456 = constructor_x64_pshufd(ctx, v1403, 0xEE);
                                let v1457 = C::xmm_to_reg(ctx, v1456);
                                let v1407 = &C::xmm_to_xmm_mem(ctx, v641);
                                let v1458 = constructor_x64_pshufd(ctx, v1407, 0xEE);
                                let v1459 = C::xmm_to_reg(ctx, v1458);
                                let v1410 = &C::xmm_to_xmm_mem(ctx, v1397);
                                let v1460 = constructor_x64_pshufd(ctx, v1410, 0xEE);
                                let v1461 = C::xmm_to_reg(ctx, v1460);
                                let v1462 =
                                    C::libcall_3(ctx, &LibCall::FmaF64, v1457, v1459, v1461);
                                let v1463 = C::xmm_new(ctx, v1462);
                                let v1465 = C::xmm_to_reg(ctx, v1463);
                                let v1466 = &constructor_xmm_to_reg_mem(ctx, v1465);
                                let v1467 = &C::xmm_mem_to_reg_mem(ctx, v1466);
                                let v1468 =
                                    constructor_vec_insert_lane(ctx, F64X2, v1454, v1467, 0x1);
                                let v1469 = constructor_output_xmm(ctx, v1468);
                                // Rule at src/isa/x64/lower.isle line 2783.
                                return Some(v1469);
                            }
                            _ => {}
                        }
                    }
                }
                _ => {}
            }
        }
        &InstructionData::TernaryImm8 {
            opcode: ref v717,
            args: ref v718,
            imm: v719,
        } => {
            if let &Opcode::Insertlane = v717 {
                let v720 = C::unpack_value_array_2(ctx, v718);
                let v725 = constructor_put_in_xmm(ctx, v720.0);
                let v726 = &C::put_in_reg_mem(ctx, v720.1);
                let v723 = C::value_type(ctx, v720.0);
                let v724 = C::u8_from_uimm8(ctx, v719);
                let v727 = constructor_vec_insert_lane(ctx, v723, v725, v726, v724);
                let v728 = constructor_output_xmm(ctx, v727);
                // Rule at src/isa/x64/lower.isle line 1462.
                return Some(v728);
            }
        }
        &InstructionData::Trap {
            opcode: ref v787,
            code: ref v788,
        } => {
            match v787 {
                &Opcode::Trap => {
                    let v789 = &constructor_x64_ud2(ctx, v788);
                    let v790 = constructor_side_effect(ctx, v789);
                    // Rule at src/isa/x64/lower.isle line 1765.
                    return Some(v790);
                }
                &Opcode::ResumableTrap => {
                    let v789 = &constructor_x64_ud2(ctx, v788);
                    let v790 = constructor_side_effect(ctx, v789);
                    // Rule at src/isa/x64/lower.isle line 1792.
                    return Some(v790);
                }
                _ => {}
            }
        }
        &InstructionData::Unary {
            opcode: ref v380,
            arg: v381,
        } => {
            match v380 {
                &Opcode::Splat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            match v65.0 {
                                0x20 => {
                                    if v65.1 == 0x4 {
                                        let v2402 = &C::sinkable_load(ctx, v381);
                                        if let Some(v2403) = v2402 {
                                            let v2468 = C::use_avx(ctx);
                                            if v2468 == true {
                                                let v2469 =
                                                    &constructor_sink_load_to_xmm_mem(ctx, v2403);
                                                let v2470 =
                                                    constructor_x64_vbroadcastss(ctx, v2469);
                                                let v2471 = constructor_output_xmm(ctx, v2470);
                                                // Rule at src/isa/x64/lower.isle line 4521.
                                                return Some(v2471);
                                            }
                                            let v2406 = &C::sink_load(ctx, v2403);
                                            let v2407 = constructor_x64_movss_load(ctx, v2406);
                                            let v2465 = &C::xmm_to_xmm_mem(ctx, v2407);
                                            let v2466 =
                                                constructor_x64_shufps(ctx, v2407, v2465, 0x0);
                                            let v2467 = constructor_output_xmm(ctx, v2466);
                                            // Rule at src/isa/x64/lower.isle line 4518.
                                            return Some(v2467);
                                        }
                                    }
                                }
                                0x40 => {
                                    if v65.1 == 0x2 {
                                        let v525 = C::use_ssse3(ctx);
                                        if v525 == true {
                                            let v2402 = &C::sinkable_load(ctx, v381);
                                            if let Some(v2403) = v2402 {
                                                let v2469 =
                                                    &constructor_sink_load_to_xmm_mem(ctx, v2403);
                                                let v2479 = constructor_x64_movddup(ctx, v2469);
                                                let v2480 = constructor_output_xmm(ctx, v2479);
                                                // Rule at src/isa/x64/lower.isle line 4532.
                                                return Some(v2480);
                                            }
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                        match v3 {
                            I8X16 => {
                                let v2432 = &C::sinkable_load_exact(ctx, v381);
                                if let Some(v2433) = v2432 {
                                    let v2428 = C::use_avx2(ctx);
                                    if v2428 == true {
                                        let v2439 = &constructor_sink_load_to_xmm_mem(ctx, v2433);
                                        let v2440 = constructor_x64_vpbroadcastb(ctx, v2439);
                                        let v2441 = constructor_output_xmm(ctx, v2440);
                                        // Rule at src/isa/x64/lower.isle line 4469.
                                        return Some(v2441);
                                    }
                                    let v441 = C::use_sse41(ctx);
                                    if v441 == true {
                                        let v525 = C::use_ssse3(ctx);
                                        if v525 == true {
                                            let v2434 = constructor_xmm_uninit_value(ctx);
                                            let v2435 =
                                                &constructor_sink_load_to_gpr_mem(ctx, v2433);
                                            let v2436 =
                                                constructor_x64_pinsrb(ctx, v2434, v2435, 0x0);
                                            let v951 = constructor_xmm_zero(ctx, I8X16);
                                            let v952 = &C::xmm_to_xmm_mem(ctx, v951);
                                            let v2437 = constructor_x64_pshufb(ctx, v2436, v952);
                                            let v2438 = constructor_output_xmm(ctx, v2437);
                                            // Rule at src/isa/x64/lower.isle line 4465.
                                            return Some(v2438);
                                        }
                                    }
                                }
                                let v2428 = C::use_avx2(ctx);
                                if v2428 == true {
                                    let v382 = constructor_put_in_gpr(ctx, v381);
                                    let v2423 = constructor_bitcast_gpr_to_xmm(ctx, I32, v382);
                                    let v2429 = &C::xmm_to_xmm_mem(ctx, v2423);
                                    let v2430 = constructor_x64_vpbroadcastb(ctx, v2429);
                                    let v2431 = constructor_output_xmm(ctx, v2430);
                                    // Rule at src/isa/x64/lower.isle line 4462.
                                    return Some(v2431);
                                }
                                let v525 = C::use_ssse3(ctx);
                                if v525 == true {
                                    let v382 = constructor_put_in_gpr(ctx, v381);
                                    let v2423 = constructor_bitcast_gpr_to_xmm(ctx, I32, v382);
                                    let v2424 = constructor_xmm_zero(ctx, I8X16);
                                    let v2425 = &C::xmm_to_xmm_mem(ctx, v2424);
                                    let v2426 = constructor_x64_pshufb(ctx, v2423, v2425);
                                    let v2427 = constructor_output_xmm(ctx, v2426);
                                    // Rule at src/isa/x64/lower.isle line 4459.
                                    return Some(v2427);
                                }
                                let v2413 = &constructor_put_in_gpr_mem(ctx, v381);
                                let v2414 = constructor_x64_movd_to_xmm(ctx, v2413);
                                let v2415 = &C::xmm_to_xmm_mem(ctx, v2414);
                                let v2416 = constructor_x64_punpcklbw(ctx, v2414, v2415);
                                let v2417 = &C::xmm_to_xmm_mem(ctx, v2416);
                                let v2419 = constructor_x64_pshuflw(ctx, v2417, 0x0);
                                let v2420 = &C::xmm_to_xmm_mem(ctx, v2419);
                                let v2421 = constructor_x64_pshufd(ctx, v2420, 0x0);
                                let v2422 = constructor_output_xmm(ctx, v2421);
                                // Rule at src/isa/x64/lower.isle line 4456.
                                return Some(v2422);
                            }
                            I16X8 => {
                                let v2432 = &C::sinkable_load_exact(ctx, v381);
                                if let Some(v2433) = v2432 {
                                    let v2428 = C::use_avx2(ctx);
                                    if v2428 == true {
                                        let v2439 = &constructor_sink_load_to_xmm_mem(ctx, v2433);
                                        let v2454 = constructor_x64_vpbroadcastw(ctx, v2439);
                                        let v2455 = constructor_output_xmm(ctx, v2454);
                                        // Rule at src/isa/x64/lower.isle line 4485.
                                        return Some(v2455);
                                    }
                                    let v2434 = constructor_xmm_uninit_value(ctx);
                                    let v2435 = &constructor_sink_load_to_gpr_mem(ctx, v2433);
                                    let v2448 = constructor_x64_pinsrw(ctx, v2434, v2435, 0x0);
                                    let v2449 = &C::xmm_to_xmm_mem(ctx, v2448);
                                    let v2450 = constructor_x64_pshuflw(ctx, v2449, 0x0);
                                    let v2451 = &C::xmm_to_xmm_mem(ctx, v2450);
                                    let v2452 = constructor_x64_pshufd(ctx, v2451, 0x0);
                                    let v2453 = constructor_output_xmm(ctx, v2452);
                                    // Rule at src/isa/x64/lower.isle line 4483.
                                    return Some(v2453);
                                }
                                let v2428 = C::use_avx2(ctx);
                                if v2428 == true {
                                    let v382 = constructor_put_in_gpr(ctx, v381);
                                    let v2423 = constructor_bitcast_gpr_to_xmm(ctx, I32, v382);
                                    let v2429 = &C::xmm_to_xmm_mem(ctx, v2423);
                                    let v2446 = constructor_x64_vpbroadcastw(ctx, v2429);
                                    let v2447 = constructor_output_xmm(ctx, v2446);
                                    // Rule at src/isa/x64/lower.isle line 4480.
                                    return Some(v2447);
                                }
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v2423 = constructor_bitcast_gpr_to_xmm(ctx, I32, v382);
                                let v2429 = &C::xmm_to_xmm_mem(ctx, v2423);
                                let v2442 = constructor_x64_pshuflw(ctx, v2429, 0x0);
                                let v2443 = &C::xmm_to_xmm_mem(ctx, v2442);
                                let v2444 = constructor_x64_pshufd(ctx, v2443, 0x0);
                                let v2445 = constructor_output_xmm(ctx, v2444);
                                // Rule at src/isa/x64/lower.isle line 4478.
                                return Some(v2445);
                            }
                            I32X4 => {
                                let v2428 = C::use_avx2(ctx);
                                if v2428 == true {
                                    let v382 = constructor_put_in_gpr(ctx, v381);
                                    let v2423 = constructor_bitcast_gpr_to_xmm(ctx, I32, v382);
                                    let v2429 = &C::xmm_to_xmm_mem(ctx, v2423);
                                    let v2458 = constructor_x64_vpbroadcastd(ctx, v2429);
                                    let v2459 = constructor_output_xmm(ctx, v2458);
                                    // Rule at src/isa/x64/lower.isle line 4495.
                                    return Some(v2459);
                                }
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v2423 = constructor_bitcast_gpr_to_xmm(ctx, I32, v382);
                                let v2429 = &C::xmm_to_xmm_mem(ctx, v2423);
                                let v2456 = constructor_x64_pshufd(ctx, v2429, 0x0);
                                let v2457 = constructor_output_xmm(ctx, v2456);
                                // Rule at src/isa/x64/lower.isle line 4493.
                                return Some(v2457);
                            }
                            I64X2 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v2472 = constructor_bitcast_gpr_to_xmm(ctx, I64, v382);
                                let v2473 = &C::xmm_to_xmm_mem(ctx, v2472);
                                let v2475 = constructor_x64_pshufd(ctx, v2473, 0x44);
                                let v2476 = constructor_output_xmm(ctx, v2475);
                                // Rule at src/isa/x64/lower.isle line 4528.
                                return Some(v2476);
                            }
                            F32X4 => {
                                let v2428 = C::use_avx2(ctx);
                                if v2428 == true {
                                    let v526 = &C::put_in_xmm_mem(ctx, v381);
                                    let v2463 = constructor_x64_vbroadcastss(ctx, v526);
                                    let v2464 = constructor_output_xmm(ctx, v2463);
                                    // Rule at src/isa/x64/lower.isle line 4505.
                                    return Some(v2464);
                                }
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v2460 = constructor_put_in_xmm(ctx, v381);
                                let v397 = &C::put_in_xmm_mem(ctx, v381);
                                let v2461 = constructor_x64_shufps(ctx, v2460, v397, 0x0);
                                let v2462 = constructor_output_xmm(ctx, v2461);
                                // Rule at src/isa/x64/lower.isle line 4502.
                                return Some(v2462);
                            }
                            F64X2 => {
                                let v526 = &C::put_in_xmm_mem(ctx, v381);
                                let v2477 = constructor_x64_pshufd(ctx, v526, 0x44);
                                let v2478 = constructor_output_xmm(ctx, v2477);
                                // Rule at src/isa/x64/lower.isle line 4530.
                                return Some(v2478);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::SetPinnedReg => {
                    let v382 = constructor_put_in_gpr(ctx, v381);
                    let v2240 = &constructor_write_pinned_gpr(ctx, v382);
                    let v2241 = constructor_side_effect(ctx, v2240);
                    // Rule at src/isa/x64/lower.isle line 4177.
                    return Some(v2241);
                }
                &Opcode::VanyTrue => {
                    let v441 = C::use_sse41(ctx);
                    if v441 == true {
                        let v529 = constructor_put_in_xmm(ctx, v381);
                        let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                        let v2481 = &constructor_x64_ptest(ctx, v1311, v529);
                        let v2482 = &constructor_x64_setcc(ctx, &CC::NZ);
                        let v2483 = constructor_with_flags(ctx, v2481, v2482);
                        let v2484 = C::output(ctx, v2483);
                        // Rule at src/isa/x64/lower.isle line 4538.
                        return Some(v2484);
                    }
                    let v529 = constructor_put_in_xmm(ctx, v381);
                    let v530 = constructor_xmm_zero(ctx, I8X16);
                    let v2073 = &C::xmm_to_xmm_mem(ctx, v530);
                    let v2485 = constructor_x64_pcmpeqb(ctx, v529, v2073);
                    let v2487 = constructor_x64_pmovmskb(ctx, &OperandSize::Size32, v2485);
                    let v2489 = RegMemImm::Imm { simm32: 0xFFFF };
                    let v2490 = &C::gpr_mem_imm_new(ctx, &v2489);
                    let v2491 = &constructor_x64_cmp(ctx, &OperandSize::Size32, v2490, v2487);
                    let v2492 = &constructor_x64_setcc(ctx, &CC::NZ);
                    let v2493 = constructor_with_flags(ctx, v2491, v2492);
                    let v2494 = C::output(ctx, v2493);
                    // Rule at src/isa/x64/lower.isle line 4547.
                    return Some(v2494);
                }
                &Opcode::VallTrue => {
                    let v441 = C::use_sse41(ctx);
                    if v441 == true {
                        let v529 = constructor_put_in_xmm(ctx, v381);
                        let v622 = C::value_type(ctx, v381);
                        let v2495 = constructor_xmm_zero(ctx, v622);
                        let v2496 = constructor_vec_int_type(ctx, v622);
                        let v2497 = &C::xmm_to_xmm_mem(ctx, v2495);
                        let v2498 = constructor_x64_pcmpeq(ctx, v2496, v529, v2497);
                        let v2499 = &C::xmm_to_xmm_mem(ctx, v2498);
                        let v2500 = &constructor_x64_ptest(ctx, v2499, v2498);
                        let v2501 = &constructor_x64_setcc(ctx, &CC::Z);
                        let v2502 = constructor_with_flags(ctx, v2500, v2501);
                        let v2503 = C::output(ctx, v2502);
                        // Rule at src/isa/x64/lower.isle line 4557.
                        return Some(v2503);
                    }
                    let v622 = C::value_type(ctx, v381);
                    let v2504 = constructor_vec_int_type(ctx, v622);
                    let v2460 = constructor_put_in_xmm(ctx, v381);
                    let v2505 = constructor_xmm_zero(ctx, v622);
                    let v2506 = &C::xmm_to_xmm_mem(ctx, v2505);
                    let v2507 = constructor_x64_pcmpeq(ctx, v2504, v2460, v2506);
                    let v2508 = constructor_x64_pmovmskb(ctx, &OperandSize::Size32, v2507);
                    let v2509 = &C::gpr_to_gpr_mem_imm(ctx, v2508);
                    let v2510 = &constructor_x64_test(ctx, &OperandSize::Size32, v2509, v2508);
                    let v2511 = &constructor_x64_setcc(ctx, &CC::Z);
                    let v2512 = constructor_with_flags(ctx, v2510, v2511);
                    let v2513 = C::output(ctx, v2512);
                    // Rule at src/isa/x64/lower.isle line 4567.
                    return Some(v2513);
                }
                &Opcode::VhighBits => {
                    let v622 = C::value_type(ctx, v381);
                    let v2514 = C::multi_lane(ctx, v622);
                    if let Some(v2515) = v2514 {
                        match v2515.0 {
                            0x8 => {
                                if v2515.1 == 0x10 {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v2518 =
                                        constructor_x64_pmovmskb(ctx, &OperandSize::Size32, v529);
                                    let v2519 = constructor_output_gpr(ctx, v2518);
                                    // Rule at src/isa/x64/lower.isle line 4584.
                                    return Some(v2519);
                                }
                            }
                            0x10 => {
                                if v2515.1 == 0x8 {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                                    let v2524 = constructor_x64_packsswb(ctx, v529, v1311);
                                    let v2525 =
                                        constructor_x64_pmovmskb(ctx, &OperandSize::Size32, v2524);
                                    let v1204 = Imm8Reg::Imm8 { imm: 0x8 };
                                    let v2192 = &C::imm8_reg_to_imm8_gpr(ctx, &v1204);
                                    let v2526 = constructor_x64_shr(ctx, I64, v2525, v2192);
                                    let v2527 = constructor_output_gpr(ctx, v2526);
                                    // Rule at src/isa/x64/lower.isle line 4599.
                                    return Some(v2527);
                                }
                            }
                            0x20 => {
                                if v2515.1 == 0x4 {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v2520 =
                                        constructor_x64_movmskps(ctx, &OperandSize::Size32, v529);
                                    let v2521 = constructor_output_gpr(ctx, v2520);
                                    // Rule at src/isa/x64/lower.isle line 4587.
                                    return Some(v2521);
                                }
                            }
                            0x40 => {
                                if v2515.1 == 0x2 {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v2522 =
                                        constructor_x64_movmskpd(ctx, &OperandSize::Size32, v529);
                                    let v2523 = constructor_output_gpr(ctx, v2522);
                                    // Rule at src/isa/x64/lower.isle line 4590.
                                    return Some(v2523);
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Ineg => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v395 = constructor_imm(ctx, I8X16, 0x0);
                                let v396 = C::xmm_new(ctx, v395);
                                let v397 = &C::put_in_xmm_mem(ctx, v381);
                                let v398 = constructor_x64_psubb(ctx, v396, v397);
                                let v399 = constructor_output_xmm(ctx, v398);
                                // Rule at src/isa/x64/lower.isle line 942.
                                return Some(v399);
                            }
                            I16X8 => {
                                let v401 = constructor_imm(ctx, I16X8, 0x0);
                                let v402 = C::xmm_new(ctx, v401);
                                let v397 = &C::put_in_xmm_mem(ctx, v381);
                                let v403 = constructor_x64_psubw(ctx, v402, v397);
                                let v404 = constructor_output_xmm(ctx, v403);
                                // Rule at src/isa/x64/lower.isle line 945.
                                return Some(v404);
                            }
                            I32X4 => {
                                let v406 = constructor_imm(ctx, I32X4, 0x0);
                                let v407 = C::xmm_new(ctx, v406);
                                let v397 = &C::put_in_xmm_mem(ctx, v381);
                                let v408 = constructor_x64_psubd(ctx, v407, v397);
                                let v409 = constructor_output_xmm(ctx, v408);
                                // Rule at src/isa/x64/lower.isle line 948.
                                return Some(v409);
                            }
                            I64X2 => {
                                let v411 = constructor_imm(ctx, I64X2, 0x0);
                                let v412 = C::xmm_new(ctx, v411);
                                let v397 = &C::put_in_xmm_mem(ctx, v381);
                                let v413 = constructor_x64_psubq(ctx, v412, v397);
                                let v414 = constructor_output_xmm(ctx, v413);
                                // Rule at src/isa/x64/lower.isle line 951.
                                return Some(v414);
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v382 = constructor_put_in_gpr(ctx, v381);
                            let v383 = constructor_x64_neg(ctx, v5, v382);
                            let v384 = constructor_output_gpr(ctx, v383);
                            // Rule at src/isa/x64/lower.isle line 928.
                            return Some(v384);
                        }
                        if v3 == I128 {
                            let v385 = C::put_in_regs(ctx, v381);
                            let v386 = constructor_value_regs_get_gpr(ctx, v385, 0x0);
                            let v387 = constructor_value_regs_get_gpr(ctx, v385, 0x1);
                            let v388 = &constructor_x64_neg_paired(ctx, I64, v386);
                            let v389 = constructor_imm(ctx, I64, 0x0);
                            let v390 = C::gpr_new(ctx, v389);
                            let v391 = &C::gpr_to_gpr_mem_imm(ctx, v387);
                            let v392 = &constructor_x64_sbb_paired(ctx, I64, v390, v391);
                            let v393 = constructor_with_flags(ctx, v388, v392);
                            let v394 = C::output(ctx, v393);
                            // Rule at src/isa/x64/lower.isle line 931.
                            return Some(v394);
                        }
                    }
                }
                &Opcode::Iabs => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v525 = C::use_ssse3(ctx);
                                if v525 == true {
                                    let v526 = &C::put_in_xmm_mem(ctx, v381);
                                    let v527 = constructor_x64_pabsb(ctx, v526);
                                    let v528 = constructor_output_xmm(ctx, v527);
                                    // Rule at src/isa/x64/lower.isle line 1185.
                                    return Some(v528);
                                }
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v530 = constructor_xmm_zero(ctx, I8X16);
                                let v531 = &C::xmm_to_xmm_mem(ctx, v529);
                                let v532 = constructor_x64_psubb(ctx, v530, v531);
                                let v533 = &C::xmm_to_xmm_mem(ctx, v532);
                                let v534 = constructor_x64_pminub(ctx, v529, v533);
                                let v535 = constructor_output_xmm(ctx, v534);
                                // Rule at src/isa/x64/lower.isle line 1192.
                                return Some(v535);
                            }
                            I16X8 => {
                                let v525 = C::use_ssse3(ctx);
                                if v525 == true {
                                    let v526 = &C::put_in_xmm_mem(ctx, v381);
                                    let v536 = constructor_x64_pabsw(ctx, v526);
                                    let v537 = constructor_output_xmm(ctx, v536);
                                    // Rule at src/isa/x64/lower.isle line 1199.
                                    return Some(v537);
                                }
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v538 = constructor_xmm_zero(ctx, I16X8);
                                let v531 = &C::xmm_to_xmm_mem(ctx, v529);
                                let v539 = constructor_x64_psubw(ctx, v538, v531);
                                let v540 = &C::xmm_to_xmm_mem(ctx, v539);
                                let v541 = constructor_x64_pmaxsw(ctx, v529, v540);
                                let v542 = constructor_output_xmm(ctx, v541);
                                // Rule at src/isa/x64/lower.isle line 1203.
                                return Some(v542);
                            }
                            I32X4 => {
                                let v525 = C::use_ssse3(ctx);
                                if v525 == true {
                                    let v526 = &C::put_in_xmm_mem(ctx, v381);
                                    let v543 = constructor_x64_pabsd(ctx, v526);
                                    let v544 = constructor_output_xmm(ctx, v543);
                                    // Rule at src/isa/x64/lower.isle line 1210.
                                    return Some(v544);
                                }
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v546 = &C::xmi_imm(ctx, 0x1F);
                                let v547 = constructor_x64_psrad(ctx, v529, v546);
                                let v548 = &C::xmm_to_xmm_mem(ctx, v547);
                                let v549 = constructor_x64_pxor(ctx, v529, v548);
                                let v550 = &C::xmm_to_xmm_mem(ctx, v547);
                                let v551 = constructor_x64_psubd(ctx, v549, v550);
                                let v552 = constructor_output_xmm(ctx, v551);
                                // Rule at src/isa/x64/lower.isle line 1220.
                                return Some(v552);
                            }
                            I64X2 => {
                                let v332 = C::use_avx512vl(ctx);
                                if v332 == true {
                                    let v333 = C::use_avx512f(ctx);
                                    if v333 == true {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v553 = constructor_x64_vpabsq(ctx, v526);
                                        let v554 = constructor_output_xmm(ctx, v553);
                                        // Rule at src/isa/x64/lower.isle line 1229.
                                        return Some(v554);
                                    }
                                }
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v555 = constructor_imm(ctx, I64X2, 0x0);
                                    let v556 = C::xmm_new(ctx, v555);
                                    let v557 = &C::xmm_to_xmm_mem(ctx, v529);
                                    let v558 = constructor_x64_psubq(ctx, v556, v557);
                                    let v559 = &C::xmm_to_xmm_mem(ctx, v529);
                                    let v560 = constructor_x64_blendvpd(ctx, v558, v559, v558);
                                    let v561 = constructor_output_xmm(ctx, v560);
                                    // Rule at src/isa/x64/lower.isle line 1238.
                                    return Some(v561);
                                }
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v562 = RegMemImm::Imm { simm32: 0x1F };
                                let v563 = &C::xmm_mem_imm_new(ctx, &v562);
                                let v564 = constructor_x64_psrad(ctx, v529, v563);
                                let v565 = &C::xmm_to_xmm_mem(ctx, v564);
                                let v567 = constructor_x64_pshufd(ctx, v565, 0xF5);
                                let v568 = &C::xmm_to_xmm_mem(ctx, v567);
                                let v569 = constructor_x64_pxor(ctx, v529, v568);
                                let v570 = &C::xmm_to_xmm_mem(ctx, v567);
                                let v571 = constructor_x64_psubq(ctx, v569, v570);
                                let v572 = constructor_output_xmm(ctx, v571);
                                // Rule at src/isa/x64/lower.isle line 1247.
                                return Some(v572);
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v382 = constructor_put_in_gpr(ctx, v381);
                            let v573 = &constructor_x64_neg_paired(ctx, v5, v382);
                            let v574 = constructor_produces_flags_get_reg(ctx, v573);
                            let v575 = C::gpr_new(ctx, v574);
                            let v577 = &C::gpr_to_gpr_mem(ctx, v382);
                            let v578 = &constructor_cmove(ctx, v5, &CC::S, v577, v575);
                            let v579 = &constructor_produces_flags_ignore(ctx, v573);
                            let v580 = constructor_with_flags_reg(ctx, v579, v578);
                            let v581 = constructor_output_reg(ctx, v580);
                            // Rule at src/isa/x64/lower.isle line 1256.
                            return Some(v581);
                        }
                    }
                }
                &Opcode::Bnot => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v627 = constructor_i128_not(ctx, v381);
                            let v628 = C::output(ctx, v627);
                            // Rule at src/isa/x64/lower.isle line 1365.
                            return Some(v628);
                        }
                        let v64 = C::multi_lane(ctx, v3);
                        if let Some(v65) = v64 {
                            let v529 = constructor_put_in_xmm(ctx, v381);
                            let v592 = constructor_vector_all_ones(ctx);
                            let v629 = &C::xmm_to_xmm_mem(ctx, v592);
                            let v632 = constructor_x64_xor_vector(ctx, v3, v529, v629);
                            let v633 = constructor_output_xmm(ctx, v632);
                            // Rule at src/isa/x64/lower.isle line 1375.
                            return Some(v633);
                        }
                        let v152 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v153) = v152 {
                            let v382 = constructor_put_in_gpr(ctx, v381);
                            let v625 = constructor_x64_not(ctx, v3, v382);
                            let v626 = constructor_output_gpr(ctx, v625);
                            // Rule at src/isa/x64/lower.isle line 1350.
                            return Some(v626);
                        }
                        let v162 = C::ty_scalar_float(ctx, v3);
                        if let Some(v163) = v162 {
                            let v529 = constructor_put_in_xmm(ctx, v381);
                            let v592 = constructor_vector_all_ones(ctx);
                            let v629 = &C::xmm_to_xmm_mem(ctx, v592);
                            let v630 = constructor_x64_xor_vector(ctx, v163, v529, v629);
                            let v631 = constructor_output_xmm(ctx, v630);
                            // Rule at src/isa/x64/lower.isle line 1370.
                            return Some(v631);
                        }
                    }
                }
                &Opcode::Bitrev => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1187 = constructor_do_bitrev8(ctx, I32, v382);
                                let v1188 = constructor_output_gpr(ctx, v1187);
                                // Rule at src/isa/x64/lower.isle line 2320.
                                return Some(v1188);
                            }
                            I16 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1189 = constructor_do_bitrev16(ctx, I32, v382);
                                let v1190 = constructor_output_gpr(ctx, v1189);
                                // Rule at src/isa/x64/lower.isle line 2323.
                                return Some(v1190);
                            }
                            I32 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1191 = constructor_do_bitrev32(ctx, I32, v382);
                                let v1192 = constructor_output_gpr(ctx, v1191);
                                // Rule at src/isa/x64/lower.isle line 2326.
                                return Some(v1192);
                            }
                            I64 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1193 = constructor_do_bitrev64(ctx, I64, v382);
                                let v1194 = constructor_output_gpr(ctx, v1193);
                                // Rule at src/isa/x64/lower.isle line 2329.
                                return Some(v1194);
                            }
                            I128 => {
                                let v385 = C::put_in_regs(ctx, v381);
                                let v1077 = constructor_value_regs_get_gpr(ctx, v385, 0x1);
                                let v1195 = constructor_do_bitrev64(ctx, I64, v1077);
                                let v1196 = C::gpr_to_reg(ctx, v1195);
                                let v1197 = C::put_in_regs(ctx, v381);
                                let v1198 = constructor_value_regs_get_gpr(ctx, v1197, 0x0);
                                let v1199 = constructor_do_bitrev64(ctx, I64, v1198);
                                let v1200 = C::gpr_to_reg(ctx, v1199);
                                let v1201 = C::value_regs(ctx, v1196, v1200);
                                let v1202 = C::output(ctx, v1201);
                                // Rule at src/isa/x64/lower.isle line 2332.
                                return Some(v1202);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Clz => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v45 = C::ty_32_or_64(ctx, v3);
                        if let Some(v46) = v45 {
                            let v1067 = C::use_lzcnt(ctx);
                            if v1067 == true {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1068 = constructor_x64_lzcnt(ctx, v46, v382);
                                let v1069 = constructor_output_gpr(ctx, v1068);
                                // Rule at src/isa/x64/lower.isle line 2099.
                                return Some(v1069);
                            }
                            let v382 = constructor_put_in_gpr(ctx, v381);
                            let v1070 = constructor_do_clz(ctx, v46, v46, v382);
                            let v1071 = constructor_output_gpr(ctx, v1070);
                            // Rule at src/isa/x64/lower.isle line 2103.
                            return Some(v1071);
                        }
                        let v1072 = C::ty_8_or_16(ctx, v3);
                        if let Some(v1073) = v1072 {
                            let v1074 =
                                constructor_extend_to_gpr(ctx, v381, I32, &ExtendKind::Zero);
                            let v1075 = constructor_do_clz(ctx, I32, v1073, v1074);
                            let v1076 = constructor_output_gpr(ctx, v1075);
                            // Rule at src/isa/x64/lower.isle line 2106.
                            return Some(v1076);
                        }
                        if v3 == I128 {
                            let v385 = C::put_in_regs(ctx, v381);
                            let v1077 = constructor_value_regs_get_gpr(ctx, v385, 0x1);
                            let v1078 = constructor_do_clz(ctx, I64, I64, v1077);
                            let v1079 = C::put_in_regs(ctx, v381);
                            let v1080 = constructor_value_regs_get_gpr(ctx, v1079, 0x0);
                            let v1081 = constructor_do_clz(ctx, I64, I64, v1080);
                            let v1083 = RegMemImm::Imm { simm32: 0x40 };
                            let v1084 = &C::gpr_mem_imm_new(ctx, &v1083);
                            let v1085 = constructor_x64_add(ctx, I64, v1081, v1084);
                            let v1087 =
                                &constructor_x64_cmp_imm(ctx, &OperandSize::Size64, 0x40, v1078);
                            let v1088 = &C::gpr_to_gpr_mem(ctx, v1078);
                            let v1089 = &constructor_cmove(ctx, I64, &CC::NZ, v1088, v1085);
                            let v1090 = constructor_with_flags_reg(ctx, v1087, v1089);
                            let v1091 = C::gpr_new(ctx, v1090);
                            let v1092 = C::gpr_to_reg(ctx, v1091);
                            let v1093 = constructor_imm(ctx, I64, 0x0);
                            let v1094 = C::value_regs(ctx, v1092, v1093);
                            let v1095 = C::output(ctx, v1094);
                            // Rule at src/isa/x64/lower.isle line 2111.
                            return Some(v1095);
                        }
                    }
                }
                &Opcode::Ctz => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v45 = C::ty_32_or_64(ctx, v3);
                        if let Some(v46) = v45 {
                            let v188 = C::use_bmi1(ctx);
                            if v188 == true {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1096 = constructor_x64_tzcnt(ctx, v46, v382);
                                let v1097 = constructor_output_gpr(ctx, v1096);
                                // Rule at src/isa/x64/lower.isle line 2136.
                                return Some(v1097);
                            }
                            let v382 = constructor_put_in_gpr(ctx, v381);
                            let v1098 = constructor_do_ctz(ctx, v46, v46, v382);
                            let v1099 = constructor_output_gpr(ctx, v1098);
                            // Rule at src/isa/x64/lower.isle line 2140.
                            return Some(v1099);
                        }
                        let v1072 = C::ty_8_or_16(ctx, v3);
                        if let Some(v1073) = v1072 {
                            let v1074 =
                                constructor_extend_to_gpr(ctx, v381, I32, &ExtendKind::Zero);
                            let v1100 = constructor_do_ctz(ctx, I32, v1073, v1074);
                            let v1101 = constructor_output_gpr(ctx, v1100);
                            // Rule at src/isa/x64/lower.isle line 2143.
                            return Some(v1101);
                        }
                        if v3 == I128 {
                            let v385 = C::put_in_regs(ctx, v381);
                            let v386 = constructor_value_regs_get_gpr(ctx, v385, 0x0);
                            let v1102 = constructor_do_ctz(ctx, I64, I64, v386);
                            let v1079 = C::put_in_regs(ctx, v381);
                            let v1103 = constructor_value_regs_get_gpr(ctx, v1079, 0x1);
                            let v1104 = constructor_do_ctz(ctx, I64, I64, v1103);
                            let v1083 = RegMemImm::Imm { simm32: 0x40 };
                            let v1084 = &C::gpr_mem_imm_new(ctx, &v1083);
                            let v1105 = constructor_x64_add(ctx, I64, v1104, v1084);
                            let v1106 =
                                &constructor_x64_cmp_imm(ctx, &OperandSize::Size64, 0x40, v1102);
                            let v1107 = &C::gpr_to_gpr_mem(ctx, v1105);
                            let v1108 = &constructor_cmove(ctx, I64, &CC::Z, v1107, v1102);
                            let v1109 = constructor_with_flags_reg(ctx, v1106, v1108);
                            let v1110 = C::gpr_new(ctx, v1109);
                            let v1111 = C::gpr_to_reg(ctx, v1110);
                            let v1093 = constructor_imm(ctx, I64, 0x0);
                            let v1112 = C::value_regs(ctx, v1111, v1093);
                            let v1113 = C::output(ctx, v1112);
                            // Rule at src/isa/x64/lower.isle line 2148.
                            return Some(v1113);
                        }
                    }
                }
                &Opcode::Bswap => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1204 = Imm8Reg::Imm8 { imm: 0x8 };
                                let v1205 = &C::imm8_reg_to_imm8_gpr(ctx, &v1204);
                                let v1206 = constructor_x64_rotl(ctx, I16, v382, v1205);
                                let v1207 = constructor_output_gpr(ctx, v1206);
                                // Rule at src/isa/x64/lower.isle line 2399.
                                return Some(v1207);
                            }
                            I32 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1208 = constructor_x64_bswap(ctx, I32, v382);
                                let v1209 = constructor_output_gpr(ctx, v1208);
                                // Rule at src/isa/x64/lower.isle line 2402.
                                return Some(v1209);
                            }
                            I64 => {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1210 = constructor_x64_bswap(ctx, I64, v382);
                                let v1211 = constructor_output_gpr(ctx, v1210);
                                // Rule at src/isa/x64/lower.isle line 2405.
                                return Some(v1211);
                            }
                            I128 => {
                                let v385 = C::put_in_regs(ctx, v381);
                                let v1077 = constructor_value_regs_get_gpr(ctx, v385, 0x1);
                                let v1212 = constructor_x64_bswap(ctx, I64, v1077);
                                let v1213 = C::gpr_to_reg(ctx, v1212);
                                let v1197 = C::put_in_regs(ctx, v381);
                                let v1198 = constructor_value_regs_get_gpr(ctx, v1197, 0x0);
                                let v1214 = constructor_x64_bswap(ctx, I64, v1198);
                                let v1215 = C::gpr_to_reg(ctx, v1214);
                                let v1216 = C::value_regs(ctx, v1213, v1215);
                                let v1217 = C::output(ctx, v1216);
                                // Rule at src/isa/x64/lower.isle line 2408.
                                return Some(v1217);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Popcnt => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v1114 = C::use_popcnt(ctx);
                        if v1114 == true {
                            let v3 = C::value_type(ctx, v2);
                            let v45 = C::ty_32_or_64(ctx, v3);
                            if let Some(v46) = v45 {
                                let v382 = constructor_put_in_gpr(ctx, v381);
                                let v1115 = constructor_x64_popcnt(ctx, v46, v382);
                                let v1116 = constructor_output_gpr(ctx, v1115);
                                // Rule at src/isa/x64/lower.isle line 2167.
                                return Some(v1116);
                            }
                            let v1072 = C::ty_8_or_16(ctx, v3);
                            if let Some(v1073) = v1072 {
                                let v1074 =
                                    constructor_extend_to_gpr(ctx, v381, I32, &ExtendKind::Zero);
                                let v1117 = constructor_x64_popcnt(ctx, I32, v1074);
                                let v1118 = constructor_output_gpr(ctx, v1117);
                                // Rule at src/isa/x64/lower.isle line 2171.
                                return Some(v1118);
                            }
                        }
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                if v1114 == true {
                                    let v385 = C::put_in_regs(ctx, v381);
                                    let v386 = constructor_value_regs_get_gpr(ctx, v385, 0x0);
                                    let v1119 = constructor_x64_popcnt(ctx, I64, v386);
                                    let v1079 = C::put_in_regs(ctx, v381);
                                    let v1103 = constructor_value_regs_get_gpr(ctx, v1079, 0x1);
                                    let v1120 = constructor_x64_popcnt(ctx, I64, v1103);
                                    let v1121 = &C::gpr_to_gpr_mem_imm(ctx, v1120);
                                    let v1122 = constructor_x64_add(ctx, I64, v1119, v1121);
                                    let v1123 = C::gpr_to_reg(ctx, v1122);
                                    let v1124 = constructor_imm(ctx, I64, 0x0);
                                    let v1125 = C::value_regs(ctx, v1123, v1124);
                                    let v1126 = C::output(ctx, v1125);
                                    // Rule at src/isa/x64/lower.isle line 2175.
                                    return Some(v1126);
                                }
                                let v385 = C::put_in_regs(ctx, v381);
                                let v386 = constructor_value_regs_get_gpr(ctx, v385, 0x0);
                                let v1131 = constructor_do_popcnt(ctx, I64, v386);
                                let v1079 = C::put_in_regs(ctx, v381);
                                let v1103 = constructor_value_regs_get_gpr(ctx, v1079, 0x1);
                                let v1132 = constructor_do_popcnt(ctx, I64, v1103);
                                let v1133 = &C::gpr_to_gpr_mem_imm(ctx, v1132);
                                let v1134 = constructor_x64_add(ctx, I64, v1131, v1133);
                                let v1135 = C::gpr_to_reg(ctx, v1134);
                                let v1124 = constructor_imm(ctx, I64, 0x0);
                                let v1136 = C::value_regs(ctx, v1135, v1124);
                                let v1137 = C::output(ctx, v1136);
                                // Rule at src/isa/x64/lower.isle line 2191.
                                return Some(v1137);
                            }
                            I8X16 => {
                                let v332 = C::use_avx512vl(ctx);
                                if v332 == true {
                                    let v1138 = C::use_avx512bitalg(ctx);
                                    if v1138 == true {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v1139 = constructor_x64_vpopcntb(ctx, v526);
                                        let v1140 = constructor_output_xmm(ctx, v1139);
                                        // Rule at src/isa/x64/lower.isle line 2264.
                                        return Some(v1140);
                                    }
                                }
                                let v525 = C::use_ssse3(ctx);
                                if v525 == true {
                                    let v1142 = C::emit_u128_le_const(
                                        ctx,
                                        0xF0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F,
                                    );
                                    let v1143 = &constructor_const_to_xmm_mem(ctx, v1142);
                                    let v1144 = constructor_put_in_xmm(ctx, v381);
                                    let v1145 = constructor_sse_and(ctx, I8X16, v1144, v1143);
                                    let v1146 = constructor_put_in_xmm(ctx, v381);
                                    let v1148 = &C::xmi_imm(ctx, 0x4);
                                    let v1149 = constructor_x64_psrlw(ctx, v1146, v1148);
                                    let v1150 = constructor_sse_and(ctx, I8X16, v1149, v1143);
                                    let v1152 = C::emit_u128_le_const(
                                        ctx,
                                        0x4030302030202010302020102010100,
                                    );
                                    let v1153 = constructor_x64_xmm_load_const(ctx, I8X16, v1152);
                                    let v1154 = &C::xmm_to_xmm_mem(ctx, v1145);
                                    let v1155 = constructor_x64_pshufb(ctx, v1153, v1154);
                                    let v1156 = &C::xmm_to_xmm_mem(ctx, v1150);
                                    let v1157 = constructor_x64_pshufb(ctx, v1153, v1156);
                                    let v1158 = &C::xmm_to_xmm_mem(ctx, v1157);
                                    let v1159 = constructor_x64_paddb(ctx, v1155, v1158);
                                    let v1160 = constructor_output_xmm(ctx, v1159);
                                    // Rule at src/isa/x64/lower.isle line 2290.
                                    return Some(v1160);
                                }
                                let v1162 =
                                    C::emit_u128_le_const(ctx, 0x77777777777777777777777777777777);
                                let v1163 = &constructor_const_to_xmm_mem(ctx, v1162);
                                let v1144 = constructor_put_in_xmm(ctx, v381);
                                let v1164 = &C::xmi_imm(ctx, 0x1);
                                let v1165 = constructor_x64_psrlq(ctx, v1144, v1164);
                                let v1166 = constructor_x64_pand(ctx, v1165, v1163);
                                let v1167 = &C::xmm_to_xmm_mem(ctx, v1166);
                                let v1168 = constructor_x64_psubb(ctx, v1144, v1167);
                                let v1169 = &C::xmi_imm(ctx, 0x1);
                                let v1170 = constructor_x64_psrlq(ctx, v1166, v1169);
                                let v1171 = constructor_x64_pand(ctx, v1170, v1163);
                                let v1172 = &C::xmm_to_xmm_mem(ctx, v1171);
                                let v1173 = constructor_x64_psubb(ctx, v1168, v1172);
                                let v1174 = &C::xmi_imm(ctx, 0x1);
                                let v1175 = constructor_x64_psrlq(ctx, v1171, v1174);
                                let v1176 = constructor_x64_pand(ctx, v1175, v1163);
                                let v1177 = &C::xmm_to_xmm_mem(ctx, v1176);
                                let v1178 = constructor_x64_psubb(ctx, v1173, v1177);
                                let v1179 = &C::xmi_imm(ctx, 0x4);
                                let v1180 = constructor_x64_psrlw(ctx, v1178, v1179);
                                let v1181 = &C::xmm_to_xmm_mem(ctx, v1180);
                                let v1182 = constructor_x64_paddb(ctx, v1178, v1181);
                                let v1183 =
                                    C::emit_u128_le_const(ctx, 0xF0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F);
                                let v1184 = &constructor_const_to_xmm_mem(ctx, v1183);
                                let v1185 = constructor_x64_pand(ctx, v1182, v1184);
                                let v1186 = constructor_output_xmm(ctx, v1185);
                                // Rule at src/isa/x64/lower.isle line 2306.
                                return Some(v1186);
                            }
                            _ => {}
                        }
                        let v45 = C::ty_32_or_64(ctx, v3);
                        if let Some(v46) = v45 {
                            let v382 = constructor_put_in_gpr(ctx, v381);
                            let v1127 = constructor_do_popcnt(ctx, v46, v382);
                            let v1128 = constructor_output_gpr(ctx, v1127);
                            // Rule at src/isa/x64/lower.isle line 2181.
                            return Some(v1128);
                        }
                        let v1072 = C::ty_8_or_16(ctx, v3);
                        if let Some(v1073) = v1072 {
                            let v1074 =
                                constructor_extend_to_gpr(ctx, v381, I32, &ExtendKind::Zero);
                            let v1129 = constructor_do_popcnt(ctx, I32, v1074);
                            let v1130 = constructor_output_gpr(ctx, v1129);
                            // Rule at src/isa/x64/lower.isle line 2186.
                            return Some(v1130);
                        }
                    }
                }
                &Opcode::Sqrt => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v526 = &C::put_in_xmm_mem(ctx, v381);
                                let v1301 = constructor_x64_sqrtss(ctx, v526);
                                let v1302 = constructor_output_xmm(ctx, v1301);
                                // Rule at src/isa/x64/lower.isle line 2555.
                                return Some(v1302);
                            }
                            F64 => {
                                let v526 = &C::put_in_xmm_mem(ctx, v381);
                                let v1303 = constructor_x64_sqrtsd(ctx, v526);
                                let v1304 = constructor_output_xmm(ctx, v1303);
                                // Rule at src/isa/x64/lower.isle line 2557.
                                return Some(v1304);
                            }
                            F32X4 => {
                                let v526 = &C::put_in_xmm_mem(ctx, v381);
                                let v1305 = constructor_x64_sqrtps(ctx, v526);
                                let v1306 = constructor_output_xmm(ctx, v1305);
                                // Rule at src/isa/x64/lower.isle line 2559.
                                return Some(v1306);
                            }
                            F64X2 => {
                                let v526 = &C::put_in_xmm_mem(ctx, v381);
                                let v1307 = constructor_x64_sqrtpd(ctx, v526);
                                let v1308 = constructor_output_xmm(ctx, v1307);
                                // Rule at src/isa/x64/lower.isle line 2561.
                                return Some(v1308);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fneg => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v603 = constructor_imm(ctx, F32, 0x80000000);
                                let v604 = &constructor_reg_to_xmm_mem(ctx, v603);
                                let v605 = constructor_x64_xorps(ctx, v529, v604);
                                let v606 = constructor_output_xmm(ctx, v605);
                                // Rule at src/isa/x64/lower.isle line 1288.
                                return Some(v606);
                            }
                            F64 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v608 = constructor_imm(ctx, F64, 0x8000000000000000);
                                let v609 = &constructor_reg_to_xmm_mem(ctx, v608);
                                let v610 = constructor_x64_xorpd(ctx, v529, v609);
                                let v611 = constructor_output_xmm(ctx, v610);
                                // Rule at src/isa/x64/lower.isle line 1291.
                                return Some(v611);
                            }
                            F32X4 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v592 = constructor_vector_all_ones(ctx);
                                let v612 = &C::xmi_imm(ctx, 0x1F);
                                let v613 = constructor_x64_pslld(ctx, v592, v612);
                                let v614 = &C::xmm_to_xmm_mem(ctx, v613);
                                let v615 = constructor_x64_xorps(ctx, v529, v614);
                                let v616 = constructor_output_xmm(ctx, v615);
                                // Rule at src/isa/x64/lower.isle line 1294.
                                return Some(v616);
                            }
                            F64X2 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v592 = constructor_vector_all_ones(ctx);
                                let v617 = &C::xmi_imm(ctx, 0x3F);
                                let v618 = constructor_x64_psllq(ctx, v592, v617);
                                let v619 = &C::xmm_to_xmm_mem(ctx, v618);
                                let v620 = constructor_x64_xorpd(ctx, v529, v619);
                                let v621 = constructor_output_xmm(ctx, v620);
                                // Rule at src/isa/x64/lower.isle line 1298.
                                return Some(v621);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fabs => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v583 = constructor_imm(ctx, F32, 0x7FFFFFFF);
                                let v584 = &constructor_reg_to_xmm_mem(ctx, v583);
                                let v585 = constructor_x64_andps(ctx, v529, v584);
                                let v586 = constructor_output_xmm(ctx, v585);
                                // Rule at src/isa/x64/lower.isle line 1270.
                                return Some(v586);
                            }
                            F64 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v588 = constructor_imm(ctx, F64, 0x7FFFFFFFFFFFFFFF);
                                let v589 = &constructor_reg_to_xmm_mem(ctx, v588);
                                let v590 = constructor_x64_andpd(ctx, v529, v589);
                                let v591 = constructor_output_xmm(ctx, v590);
                                // Rule at src/isa/x64/lower.isle line 1273.
                                return Some(v591);
                            }
                            F32X4 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v592 = constructor_vector_all_ones(ctx);
                                let v593 = &C::xmi_imm(ctx, 0x1);
                                let v594 = constructor_x64_psrld(ctx, v592, v593);
                                let v595 = &C::xmm_to_xmm_mem(ctx, v594);
                                let v596 = constructor_x64_andps(ctx, v529, v595);
                                let v597 = constructor_output_xmm(ctx, v596);
                                // Rule at src/isa/x64/lower.isle line 1277.
                                return Some(v597);
                            }
                            F64X2 => {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v592 = constructor_vector_all_ones(ctx);
                                let v593 = &C::xmi_imm(ctx, 0x1);
                                let v598 = constructor_x64_psrlq(ctx, v592, v593);
                                let v599 = &C::xmm_to_xmm_mem(ctx, v598);
                                let v600 = constructor_x64_andpd(ctx, v529, v599);
                                let v601 = constructor_output_xmm(ctx, v600);
                                // Rule at src/isa/x64/lower.isle line 1282.
                                return Some(v601);
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Ceil => {
                    let v2146 = &C::put_in_reg_mem(ctx, v381);
                    let v622 = C::value_type(ctx, v381);
                    let v2148 = constructor_x64_round(ctx, v622, v2146, &RoundImm::RoundUp);
                    let v2149 = constructor_output_xmm(ctx, v2148);
                    // Rule at src/isa/x64/lower.isle line 3983.
                    return Some(v2149);
                }
                &Opcode::Floor => {
                    let v2146 = &C::put_in_reg_mem(ctx, v381);
                    let v622 = C::value_type(ctx, v381);
                    let v2151 = constructor_x64_round(ctx, v622, v2146, &RoundImm::RoundDown);
                    let v2152 = constructor_output_xmm(ctx, v2151);
                    // Rule at src/isa/x64/lower.isle line 3988.
                    return Some(v2152);
                }
                &Opcode::Trunc => {
                    let v2146 = &C::put_in_reg_mem(ctx, v381);
                    let v622 = C::value_type(ctx, v381);
                    let v2157 = constructor_x64_round(ctx, v622, v2146, &RoundImm::RoundZero);
                    let v2158 = constructor_output_xmm(ctx, v2157);
                    // Rule at src/isa/x64/lower.isle line 3998.
                    return Some(v2158);
                }
                &Opcode::Nearest => {
                    let v2146 = &C::put_in_reg_mem(ctx, v381);
                    let v622 = C::value_type(ctx, v381);
                    let v2154 = constructor_x64_round(ctx, v622, v2146, &RoundImm::RoundNearest);
                    let v2155 = constructor_output_xmm(ctx, v2154);
                    // Rule at src/isa/x64/lower.isle line 3993.
                    return Some(v2155);
                }
                &Opcode::IsNull => {
                    let v622 = C::value_type(ctx, v381);
                    if v622 == R64 {
                        let v382 = constructor_put_in_gpr(ctx, v381);
                        let v1219 = &constructor_x64_cmp_imm(ctx, &OperandSize::Size64, 0x0, v382);
                        let v1220 = &constructor_x64_setcc(ctx, &CC::Z);
                        let v1221 = constructor_with_flags(ctx, v1219, v1220);
                        let v1222 = C::output(ctx, v1221);
                        // Rule at src/isa/x64/lower.isle line 2416.
                        return Some(v1222);
                    }
                }
                &Opcode::IsInvalid => {
                    let v622 = C::value_type(ctx, v381);
                    if v622 == R64 {
                        let v382 = constructor_put_in_gpr(ctx, v381);
                        let v1224 =
                            &constructor_x64_cmp_imm(ctx, &OperandSize::Size64, 0xFFFFFFFF, v382);
                        let v1220 = &constructor_x64_setcc(ctx, &CC::Z);
                        let v1225 = constructor_with_flags(ctx, v1224, v1220);
                        let v1226 = C::output(ctx, v1225);
                        // Rule at src/isa/x64/lower.isle line 2424.
                        return Some(v1226);
                    }
                }
                &Opcode::ScalarToVector => {
                    let v2402 = &C::sinkable_load(ctx, v381);
                    if let Some(v2403) = v2402 {
                        let v622 = C::value_type(ctx, v381);
                        let v2409 = C::ty_64(ctx, v622);
                        if let Some(v2410) = v2409 {
                            let v2406 = &C::sink_load(ctx, v2403);
                            let v2411 = constructor_x64_movsd_load(ctx, v2406);
                            let v2412 = constructor_output_xmm(ctx, v2411);
                            // Rule at src/isa/x64/lower.isle line 4440.
                            return Some(v2412);
                        }
                        let v2404 = C::ty_32(ctx, v622);
                        if let Some(v2405) = v2404 {
                            let v2406 = &C::sink_load(ctx, v2403);
                            let v2407 = constructor_x64_movss_load(ctx, v2406);
                            let v2408 = constructor_output_xmm(ctx, v2407);
                            // Rule at src/isa/x64/lower.isle line 4438.
                            return Some(v2408);
                        }
                    }
                    let v622 = C::value_type(ctx, v381);
                    let v1862 = C::ty_scalar_float(ctx, v622);
                    if let Some(v1863) = v1862 {
                        let v1245 = constructor_output_value(ctx, v381);
                        // Rule at src/isa/x64/lower.isle line 4428.
                        return Some(v1245);
                    }
                    let v382 = constructor_put_in_gpr(ctx, v381);
                    let v2400 = constructor_bitcast_gpr_to_xmm(ctx, v622, v382);
                    let v2401 = constructor_output_xmm(ctx, v2400);
                    // Rule at src/isa/x64/lower.isle line 4433.
                    return Some(v2401);
                }
                &Opcode::Bmask => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v385 = C::put_in_regs(ctx, v381);
                        let v3 = C::value_type(ctx, v2);
                        let v622 = C::value_type(ctx, v381);
                        let v623 = constructor_lower_bmask(ctx, v3, v622, v385);
                        let v624 = C::output(ctx, v623);
                        // Rule at src/isa/x64/lower.isle line 1343.
                        return Some(v624);
                    }
                }
                &Opcode::Ireduce => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v385 = C::put_in_regs(ctx, v381);
                            let v386 = constructor_value_regs_get_gpr(ctx, v385, 0x0);
                            let v1246 = constructor_output_gpr(ctx, v386);
                            // Rule at src/isa/x64/lower.isle line 2474.
                            return Some(v1246);
                        }
                        let v622 = C::value_type(ctx, v381);
                        if v3 == v622 {
                            let v1245 = constructor_output_value(ctx, v381);
                            // Rule at src/isa/x64/lower.isle line 2468.
                            return Some(v1245);
                        }
                    }
                }
                &Opcode::SwidenLow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v622 = C::value_type(ctx, v381);
                                    if v622 == I8X16 {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v2032 = constructor_x64_pmovsxbw(ctx, v526);
                                        let v2033 = constructor_output_xmm(ctx, v2032);
                                        // Rule at src/isa/x64/lower.isle line 3703.
                                        return Some(v2033);
                                    }
                                }
                            }
                            I32X4 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v622 = C::value_type(ctx, v381);
                                    if v622 == I16X8 {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v2034 = constructor_x64_pmovsxwd(ctx, v526);
                                        let v2035 = constructor_output_xmm(ctx, v2034);
                                        // Rule at src/isa/x64/lower.isle line 3706.
                                        return Some(v2035);
                                    }
                                }
                            }
                            I64X2 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v622 = C::value_type(ctx, v381);
                                    if v622 == I32X4 {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v2036 = constructor_x64_pmovsxdq(ctx, v526);
                                        let v2037 = constructor_output_xmm(ctx, v2036);
                                        // Rule at src/isa/x64/lower.isle line 3709.
                                        return Some(v2037);
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v529 = constructor_put_in_xmm(ctx, v381);
                        let v2038 = constructor_lower_swiden_low(ctx, v3, v529);
                        let v2039 = constructor_output_xmm(ctx, v2038);
                        // Rule at src/isa/x64/lower.isle line 3713.
                        return Some(v2039);
                    }
                }
                &Opcode::SwidenHigh => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v622 = C::value_type(ctx, v381);
                                if v622 == I8X16 {
                                    let v441 = C::use_sse41(ctx);
                                    if v441 == true {
                                        let v525 = C::use_ssse3(ctx);
                                        if v525 == true {
                                            let v529 = constructor_put_in_xmm(ctx, v381);
                                            let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                                            let v2040 =
                                                constructor_x64_palignr(ctx, v529, v1311, 0x8);
                                            let v2041 = &C::xmm_to_xmm_mem(ctx, v2040);
                                            let v2042 = constructor_x64_pmovsxbw(ctx, v2041);
                                            let v2043 = constructor_output_xmm(ctx, v2042);
                                            // Rule at src/isa/x64/lower.isle line 3736.
                                            return Some(v2043);
                                        }
                                    }
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                                    let v2050 = constructor_x64_punpckhbw(ctx, v529, v1311);
                                    let v2051 = &C::xmi_imm(ctx, 0x8);
                                    let v2052 = constructor_x64_psraw(ctx, v2050, v2051);
                                    let v2053 = constructor_output_xmm(ctx, v2052);
                                    // Rule at src/isa/x64/lower.isle line 3752.
                                    return Some(v2053);
                                }
                            }
                            I32X4 => {
                                let v622 = C::value_type(ctx, v381);
                                if v622 == I16X8 {
                                    let v441 = C::use_sse41(ctx);
                                    if v441 == true {
                                        let v525 = C::use_ssse3(ctx);
                                        if v525 == true {
                                            let v529 = constructor_put_in_xmm(ctx, v381);
                                            let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                                            let v2040 =
                                                constructor_x64_palignr(ctx, v529, v1311, 0x8);
                                            let v2041 = &C::xmm_to_xmm_mem(ctx, v2040);
                                            let v2044 = constructor_x64_pmovsxwd(ctx, v2041);
                                            let v2045 = constructor_output_xmm(ctx, v2044);
                                            // Rule at src/isa/x64/lower.isle line 3741.
                                            return Some(v2045);
                                        }
                                    }
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                                    let v2054 = constructor_x64_punpckhwd(ctx, v529, v1311);
                                    let v1847 = &C::xmi_imm(ctx, 0x10);
                                    let v2055 = constructor_x64_psrad(ctx, v2054, v1847);
                                    let v2056 = constructor_output_xmm(ctx, v2055);
                                    // Rule at src/isa/x64/lower.isle line 3755.
                                    return Some(v2056);
                                }
                            }
                            I64X2 => {
                                let v622 = C::value_type(ctx, v381);
                                if v622 == I32X4 {
                                    let v441 = C::use_sse41(ctx);
                                    if v441 == true {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v2046 = constructor_x64_pshufd(ctx, v526, 0xEE);
                                        let v2047 = &C::xmm_to_xmm_mem(ctx, v2046);
                                        let v2048 = constructor_x64_pmovsxdq(ctx, v2047);
                                        let v2049 = constructor_output_xmm(ctx, v2048);
                                        // Rule at src/isa/x64/lower.isle line 3746.
                                        return Some(v2049);
                                    }
                                    let v526 = &C::put_in_xmm_mem(ctx, v381);
                                    let v2058 = constructor_x64_pshufd(ctx, v526, 0xE);
                                    let v2059 = constructor_xmm_zero(ctx, I32X4);
                                    let v2060 = &C::xmm_to_xmm_mem(ctx, v2058);
                                    let v2061 = constructor_x64_pcmpgtd(ctx, v2059, v2060);
                                    let v2062 = &C::xmm_to_xmm_mem(ctx, v2061);
                                    let v2063 = constructor_x64_punpckldq(ctx, v2058, v2062);
                                    let v2064 = constructor_output_xmm(ctx, v2063);
                                    // Rule at src/isa/x64/lower.isle line 3760.
                                    return Some(v2064);
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::UwidenLow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v622 = C::value_type(ctx, v381);
                                    if v622 == I8X16 {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v2065 = constructor_x64_pmovzxbw(ctx, v526);
                                        let v2066 = constructor_output_xmm(ctx, v2065);
                                        // Rule at src/isa/x64/lower.isle line 3768.
                                        return Some(v2066);
                                    }
                                }
                            }
                            I32X4 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v622 = C::value_type(ctx, v381);
                                    if v622 == I16X8 {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v2067 = constructor_x64_pmovzxwd(ctx, v526);
                                        let v2068 = constructor_output_xmm(ctx, v2067);
                                        // Rule at src/isa/x64/lower.isle line 3771.
                                        return Some(v2068);
                                    }
                                }
                            }
                            I64X2 => {
                                let v441 = C::use_sse41(ctx);
                                if v441 == true {
                                    let v622 = C::value_type(ctx, v381);
                                    if v622 == I32X4 {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v2069 = constructor_x64_pmovzxdq(ctx, v526);
                                        let v2070 = constructor_output_xmm(ctx, v2069);
                                        // Rule at src/isa/x64/lower.isle line 3774.
                                        return Some(v2070);
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v529 = constructor_put_in_xmm(ctx, v381);
                        let v2071 = constructor_lower_uwiden_low(ctx, v3, v529);
                        let v2072 = constructor_output_xmm(ctx, v2071);
                        // Rule at src/isa/x64/lower.isle line 3778.
                        return Some(v2072);
                    }
                }
                &Opcode::UwidenHigh => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v622 = C::value_type(ctx, v381);
                                if v622 == I8X16 {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v530 = constructor_xmm_zero(ctx, I8X16);
                                    let v2073 = &C::xmm_to_xmm_mem(ctx, v530);
                                    let v2074 = constructor_x64_punpckhbw(ctx, v529, v2073);
                                    let v2075 = constructor_output_xmm(ctx, v2074);
                                    // Rule at src/isa/x64/lower.isle line 3793.
                                    return Some(v2075);
                                }
                            }
                            I32X4 => {
                                let v622 = C::value_type(ctx, v381);
                                if v622 == I16X8 {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v530 = constructor_xmm_zero(ctx, I8X16);
                                    let v2073 = &C::xmm_to_xmm_mem(ctx, v530);
                                    let v2076 = constructor_x64_punpckhwd(ctx, v529, v2073);
                                    let v2077 = constructor_output_xmm(ctx, v2076);
                                    // Rule at src/isa/x64/lower.isle line 3795.
                                    return Some(v2077);
                                }
                            }
                            I64X2 => {
                                let v622 = C::value_type(ctx, v381);
                                if v622 == I32X4 {
                                    let v529 = constructor_put_in_xmm(ctx, v381);
                                    let v1886 = constructor_xmm_zero(ctx, F32X4);
                                    let v1887 = &C::xmm_to_xmm_mem(ctx, v1886);
                                    let v2078 = constructor_x64_unpckhps(ctx, v529, v1887);
                                    let v2079 = constructor_output_xmm(ctx, v2078);
                                    // Rule at src/isa/x64/lower.isle line 3797.
                                    return Some(v2079);
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Uextend => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I64 => {
                                let v1227 =
                                    constructor_extend_to_gpr(ctx, v381, I64, &ExtendKind::Zero);
                                let v1232 = constructor_output_gpr(ctx, v1227);
                                // Rule at src/isa/x64/lower.isle line 2437.
                                return Some(v1232);
                            }
                            I128 => {
                                let v1227 =
                                    constructor_extend_to_gpr(ctx, v381, I64, &ExtendKind::Zero);
                                let v1228 = C::gpr_to_reg(ctx, v1227);
                                let v1229 = constructor_imm(ctx, I64, 0x0);
                                let v1230 = C::value_regs(ctx, v1228, v1229);
                                let v1231 = C::output(ctx, v1230);
                                // Rule at src/isa/x64/lower.isle line 2433.
                                return Some(v1231);
                            }
                            _ => {}
                        }
                        let v1233 = C::fits_in_32(ctx, v3);
                        if let Some(v1234) = v1233 {
                            let v1074 =
                                constructor_extend_to_gpr(ctx, v381, I32, &ExtendKind::Zero);
                            let v1235 = constructor_output_gpr(ctx, v1074);
                            // Rule at src/isa/x64/lower.isle line 2442.
                            return Some(v1235);
                        }
                    }
                }
                &Opcode::Sextend => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I64 => {
                                let v1236 =
                                    constructor_extend_to_gpr(ctx, v381, I64, &ExtendKind::Sign);
                                let v1242 = constructor_output_gpr(ctx, v1236);
                                // Rule at src/isa/x64/lower.isle line 2457.
                                return Some(v1242);
                            }
                            I128 => {
                                let v1236 =
                                    constructor_extend_to_gpr(ctx, v381, I64, &ExtendKind::Sign);
                                let v840 = Imm8Reg::Imm8 { imm: 0x3F };
                                let v841 = &C::imm8_reg_to_imm8_gpr(ctx, &v840);
                                let v1237 = constructor_x64_sar(ctx, I64, v1236, v841);
                                let v1238 = C::gpr_to_reg(ctx, v1236);
                                let v1239 = C::gpr_to_reg(ctx, v1237);
                                let v1240 = C::value_regs(ctx, v1238, v1239);
                                let v1241 = C::output(ctx, v1240);
                                // Rule at src/isa/x64/lower.isle line 2451.
                                return Some(v1241);
                            }
                            _ => {}
                        }
                        let v1233 = C::fits_in_32(ctx, v3);
                        if let Some(v1234) = v1233 {
                            let v1243 =
                                constructor_extend_to_gpr(ctx, v381, I32, &ExtendKind::Sign);
                            let v1244 = constructor_output_gpr(ctx, v1243);
                            // Rule at src/isa/x64/lower.isle line 2462.
                            return Some(v1244);
                        }
                    }
                }
                &Opcode::Fpromote => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F64 {
                            let v526 = &C::put_in_xmm_mem(ctx, v381);
                            let v1309 = constructor_x64_cvtss2sd(ctx, v526);
                            let v1310 = constructor_output_xmm(ctx, v1309);
                            // Rule at src/isa/x64/lower.isle line 2565.
                            return Some(v1310);
                        }
                    }
                }
                &Opcode::Fdemote => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F32 {
                            let v526 = &C::put_in_xmm_mem(ctx, v381);
                            let v1314 = constructor_x64_cvtsd2ss(ctx, v526);
                            let v1315 = constructor_output_xmm(ctx, v1314);
                            // Rule at src/isa/x64/lower.isle line 2573.
                            return Some(v1315);
                        }
                    }
                }
                &Opcode::Fvdemote => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F32X4 {
                            let v526 = &C::put_in_xmm_mem(ctx, v381);
                            let v1316 = constructor_x64_cvtpd2ps(ctx, v526);
                            let v1317 = constructor_output_xmm(ctx, v1316);
                            // Rule at src/isa/x64/lower.isle line 2577.
                            return Some(v1317);
                        }
                    }
                }
                &Opcode::FvpromoteLow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F64X2 {
                            let v529 = constructor_put_in_xmm(ctx, v381);
                            let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                            let v1312 = constructor_x64_cvtps2pd(ctx, v1311);
                            let v1313 = constructor_output_xmm(ctx, v1312);
                            // Rule at src/isa/x64/lower.isle line 2569.
                            return Some(v1313);
                        }
                    }
                }
                &Opcode::FcvtToUint => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v622 = C::value_type(ctx, v381);
                        let v1862 = C::ty_scalar_float(ctx, v622);
                        if let Some(v1863) = v1862 {
                            let v3 = C::value_type(ctx, v2);
                            let v1864 = constructor_cvt_float_to_uint_seq(ctx, v3, v381, false);
                            let v1865 = constructor_output_gpr(ctx, v1864);
                            // Rule at src/isa/x64/lower.isle line 3455.
                            return Some(v1865);
                        }
                    }
                }
                &Opcode::FcvtToSint => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v622 = C::value_type(ctx, v381);
                        let v1862 = C::ty_scalar_float(ctx, v622);
                        if let Some(v1863) = v1862 {
                            let v3 = C::value_type(ctx, v2);
                            let v1868 = constructor_cvt_float_to_sint_seq(ctx, v3, v381, false);
                            let v1869 = constructor_output_gpr(ctx, v1868);
                            // Rule at src/isa/x64/lower.isle line 3461.
                            return Some(v1869);
                        }
                    }
                }
                &Opcode::FcvtToUintSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v622 = C::value_type(ctx, v381);
                            if v622 == F32X4 {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v1886 = constructor_xmm_zero(ctx, F32X4);
                                let v1887 = &C::xmm_to_xmm_mem(ctx, v1886);
                                let v1888 = constructor_x64_maxps(ctx, v529, v1887);
                                let v1889 = &C::xmm_to_xmm_mem(ctx, v1886);
                                let v1890 = constructor_x64_pcmpeqd(ctx, v1886, v1889);
                                let v1891 = &C::xmi_imm(ctx, 0x1);
                                let v1892 = constructor_x64_psrld(ctx, v1890, v1891);
                                let v1893 = &C::xmm_to_xmm_mem(ctx, v1892);
                                let v1894 = constructor_x64_cvtdq2ps(ctx, v1893);
                                let v1895 = &C::xmm_to_xmm_mem(ctx, v1888);
                                let v1896 = constructor_x64_cvttps2dq(ctx, v1895);
                                let v1897 = &C::xmm_to_xmm_mem(ctx, v1894);
                                let v1898 = constructor_x64_subps(ctx, v1888, v1897);
                                let v1899 = &C::xmm_to_xmm_mem(ctx, v1898);
                                let v1900 = constructor_x64_cmpps(
                                    ctx,
                                    v1894,
                                    v1899,
                                    &FcmpImm::LessThanOrEqual,
                                );
                                let v1901 = &C::xmm_to_xmm_mem(ctx, v1898);
                                let v1902 = constructor_x64_cvttps2dq(ctx, v1901);
                                let v1903 = &C::xmm_to_xmm_mem(ctx, v1900);
                                let v1904 = constructor_x64_pxor(ctx, v1902, v1903);
                                let v1905 = constructor_xmm_zero(ctx, I32X4);
                                let v1906 = constructor_lower_vec_smax(ctx, I32X4, v1904, v1905);
                                let v1907 = &C::xmm_to_xmm_mem(ctx, v1896);
                                let v1908 = constructor_x64_paddd(ctx, v1906, v1907);
                                let v1909 = constructor_output_xmm(ctx, v1908);
                                // Rule at src/isa/x64/lower.isle line 3539.
                                return Some(v1909);
                            }
                        }
                        let v622 = C::value_type(ctx, v381);
                        let v1862 = C::ty_scalar_float(ctx, v622);
                        if let Some(v1863) = v1862 {
                            let v1866 = constructor_cvt_float_to_uint_seq(ctx, v3, v381, true);
                            let v1867 = constructor_output_gpr(ctx, v1866);
                            // Rule at src/isa/x64/lower.isle line 3458.
                            return Some(v1867);
                        }
                    }
                }
                &Opcode::FcvtToSintSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v622 = C::value_type(ctx, v381);
                            if v622 == F32X4 {
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v1311 = &C::xmm_to_xmm_mem(ctx, v529);
                                let v1872 =
                                    constructor_x64_cmpps(ctx, v529, v1311, &FcmpImm::Equal);
                                let v1873 = &C::xmm_to_xmm_mem(ctx, v1872);
                                let v1874 = constructor_x64_andps(ctx, v529, v1873);
                                let v1875 = &C::xmm_to_xmm_mem(ctx, v1874);
                                let v1876 = constructor_x64_pxor(ctx, v1872, v1875);
                                let v1877 = &C::xmm_to_xmm_mem(ctx, v1874);
                                let v1878 = constructor_x64_cvttps2dq(ctx, v1877);
                                let v1879 = &C::xmm_to_xmm_mem(ctx, v1876);
                                let v1880 = constructor_x64_pand(ctx, v1878, v1879);
                                let v1881 = &C::xmi_imm(ctx, 0x1F);
                                let v1882 = constructor_x64_psrad(ctx, v1880, v1881);
                                let v1883 = &C::xmm_to_xmm_mem(ctx, v1878);
                                let v1884 = constructor_x64_pxor(ctx, v1882, v1883);
                                let v1885 = constructor_output_xmm(ctx, v1884);
                                // Rule at src/isa/x64/lower.isle line 3468.
                                return Some(v1885);
                            }
                        }
                        let v622 = C::value_type(ctx, v381);
                        let v1862 = C::ty_scalar_float(ctx, v622);
                        if let Some(v1863) = v1862 {
                            let v1870 = constructor_cvt_float_to_sint_seq(ctx, v3, v381, true);
                            let v1871 = constructor_output_gpr(ctx, v1870);
                            // Rule at src/isa/x64/lower.isle line 3464.
                            return Some(v1871);
                        }
                    }
                }
                &Opcode::X86Cvtt2dq => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v622 = C::value_type(ctx, v381);
                            if v622 == F32X4 {
                                let v526 = &C::put_in_xmm_mem(ctx, v381);
                                let v1910 = constructor_x64_cvttps2dq(ctx, v526);
                                let v1911 = constructor_output_xmm(ctx, v1910);
                                // Rule at src/isa/x64/lower.isle line 3586.
                                return Some(v1911);
                            }
                        }
                    }
                }
                &Opcode::FcvtFromUint => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v622 = C::value_type(ctx, v381);
                                let v1820 = C::fits_in_32(ctx, v622);
                                if let Some(v1821) = v1820 {
                                    let v1822 = C::ty_int(ctx, v1821);
                                    if let Some(v1823) = v1822 {
                                        let v1792 = constructor_xmm_zero(ctx, F32X4);
                                        let v1824 = constructor_extend_to_gpr(
                                            ctx,
                                            v381,
                                            I64,
                                            &ExtendKind::Zero,
                                        );
                                        let v1825 = &C::gpr_to_gpr_mem(ctx, v1824);
                                        let v1826 =
                                            constructor_x64_cvtsi2ss(ctx, I64, v1792, v1825);
                                        let v1827 = constructor_output_xmm(ctx, v1826);
                                        // Rule at src/isa/x64/lower.isle line 3382.
                                        return Some(v1827);
                                    }
                                }
                            }
                            F64 => {
                                let v622 = C::value_type(ctx, v381);
                                let v1820 = C::fits_in_32(ctx, v622);
                                if let Some(v1821) = v1820 {
                                    let v1822 = C::ty_int(ctx, v1821);
                                    if let Some(v1823) = v1822 {
                                        let v1804 = constructor_xmm_zero(ctx, F64X2);
                                        let v1824 = constructor_extend_to_gpr(
                                            ctx,
                                            v381,
                                            I64,
                                            &ExtendKind::Zero,
                                        );
                                        let v1825 = &C::gpr_to_gpr_mem(ctx, v1824);
                                        let v1828 =
                                            constructor_x64_cvtsi2sd(ctx, I64, v1804, v1825);
                                        let v1829 = constructor_output_xmm(ctx, v1828);
                                        // Rule at src/isa/x64/lower.isle line 3385.
                                        return Some(v1829);
                                    }
                                }
                            }
                            F32X4 => {
                                let v332 = C::use_avx512vl(ctx);
                                if v332 == true {
                                    let v333 = C::use_avx512f(ctx);
                                    if v333 == true {
                                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                                        let v1842 = constructor_x64_vcvtudq2ps(ctx, v526);
                                        let v1843 = constructor_output_xmm(ctx, v1842);
                                        // Rule at src/isa/x64/lower.isle line 3403.
                                        return Some(v1843);
                                    }
                                }
                                let v529 = constructor_put_in_xmm(ctx, v381);
                                let v1845 = &C::xmi_imm(ctx, 0x10);
                                let v1846 = constructor_x64_pslld(ctx, v529, v1845);
                                let v1847 = &C::xmi_imm(ctx, 0x10);
                                let v1848 = constructor_x64_psrld(ctx, v1846, v1847);
                                let v1849 = &C::xmm_to_xmm_mem(ctx, v1848);
                                let v1850 = constructor_x64_psubd(ctx, v529, v1849);
                                let v1851 = &C::xmm_to_xmm_mem(ctx, v1848);
                                let v1852 = constructor_x64_cvtdq2ps(ctx, v1851);
                                let v1853 = &C::xmi_imm(ctx, 0x1);
                                let v1854 = constructor_x64_psrld(ctx, v1850, v1853);
                                let v1855 = &C::xmm_to_xmm_mem(ctx, v1854);
                                let v1856 = constructor_x64_cvtdq2ps(ctx, v1855);
                                let v1857 = &C::xmm_to_xmm_mem(ctx, v1856);
                                let v1858 = constructor_x64_addps(ctx, v1856, v1857);
                                let v1859 = &C::xmm_to_xmm_mem(ctx, v1852);
                                let v1860 = constructor_x64_addps(ctx, v1858, v1859);
                                let v1861 = constructor_output_xmm(ctx, v1860);
                                // Rule at src/isa/x64/lower.isle line 3431.
                                return Some(v1861);
                            }
                            F64X2 => {
                                let v1811 = C::def_inst(ctx, v381);
                                if let Some(v1812) = v1811 {
                                    let v1813 = &C::inst_data(ctx, v1812);
                                    if let &InstructionData::Unary {
                                        opcode: ref v1814,
                                        arg: v1815,
                                    } = v1813
                                    {
                                        if let &Opcode::UwidenLow = v1814 {
                                            let v1816 = C::value_type(ctx, v1815);
                                            if v1816 == I32X4 {
                                                let v1833 =
                                                    C::emit_u128_le_const(ctx, 0x4330000043300000);
                                                let v1834 =
                                                    &constructor_const_to_xmm_mem(ctx, v1833);
                                                let v1835 = constructor_put_in_xmm(ctx, v1815);
                                                let v1836 =
                                                    constructor_x64_unpcklps(ctx, v1835, v1834);
                                                let v1838 = C::emit_u128_le_const(
                                                    ctx,
                                                    0x43300000000000004330000000000000,
                                                );
                                                let v1839 =
                                                    &constructor_const_to_xmm_mem(ctx, v1838);
                                                let v1840 =
                                                    constructor_x64_subpd(ctx, v1836, v1839);
                                                let v1841 = constructor_output_xmm(ctx, v1840);
                                                // Rule at src/isa/x64/lower.isle line 3395.
                                                return Some(v1841);
                                            }
                                        }
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v622 = C::value_type(ctx, v381);
                        if v622 == I64 {
                            let v382 = constructor_put_in_gpr(ctx, v381);
                            let v1830 = constructor_cvt_u64_to_float_seq(ctx, v3, v382);
                            let v1831 = constructor_output_xmm(ctx, v1830);
                            // Rule at src/isa/x64/lower.isle line 3388.
                            return Some(v1831);
                        }
                    }
                }
                &Opcode::FcvtFromSint => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v622 = C::value_type(ctx, v381);
                                match v622 {
                                    I8 => {
                                        let v1792 = constructor_xmm_zero(ctx, F32X4);
                                        let v1793 = constructor_extend_to_gpr(
                                            ctx,
                                            v381,
                                            I32,
                                            &ExtendKind::Sign,
                                        );
                                        let v1794 = &C::gpr_to_gpr_mem(ctx, v1793);
                                        let v1795 =
                                            constructor_x64_cvtsi2ss(ctx, I32, v1792, v1794);
                                        let v1796 = constructor_output_xmm(ctx, v1795);
                                        // Rule at src/isa/x64/lower.isle line 3356.
                                        return Some(v1796);
                                    }
                                    I16 => {
                                        let v1792 = constructor_xmm_zero(ctx, F32X4);
                                        let v1793 = constructor_extend_to_gpr(
                                            ctx,
                                            v381,
                                            I32,
                                            &ExtendKind::Sign,
                                        );
                                        let v1794 = &C::gpr_to_gpr_mem(ctx, v1793);
                                        let v1795 =
                                            constructor_x64_cvtsi2ss(ctx, I32, v1792, v1794);
                                        let v1796 = constructor_output_xmm(ctx, v1795);
                                        // Rule at src/isa/x64/lower.isle line 3359.
                                        return Some(v1796);
                                    }
                                    _ => {}
                                }
                                let v1797 = C::ty_int(ctx, v622);
                                if let Some(v1798) = v1797 {
                                    let v1799 = C::fits_in_64(ctx, v1798);
                                    if let Some(v1800) = v1799 {
                                        let v1792 = constructor_xmm_zero(ctx, F32X4);
                                        let v1801 = &constructor_put_in_gpr_mem(ctx, v381);
                                        let v1802 =
                                            constructor_x64_cvtsi2ss(ctx, v1800, v1792, v1801);
                                        let v1803 = constructor_output_xmm(ctx, v1802);
                                        // Rule at src/isa/x64/lower.isle line 3362.
                                        return Some(v1803);
                                    }
                                }
                            }
                            F64 => {
                                let v622 = C::value_type(ctx, v381);
                                match v622 {
                                    I8 => {
                                        let v1804 = constructor_xmm_zero(ctx, F64X2);
                                        let v1793 = constructor_extend_to_gpr(
                                            ctx,
                                            v381,
                                            I32,
                                            &ExtendKind::Sign,
                                        );
                                        let v1794 = &C::gpr_to_gpr_mem(ctx, v1793);
                                        let v1805 =
                                            constructor_x64_cvtsi2sd(ctx, I32, v1804, v1794);
                                        let v1806 = constructor_output_xmm(ctx, v1805);
                                        // Rule at src/isa/x64/lower.isle line 3365.
                                        return Some(v1806);
                                    }
                                    I16 => {
                                        let v1804 = constructor_xmm_zero(ctx, F64X2);
                                        let v1793 = constructor_extend_to_gpr(
                                            ctx,
                                            v381,
                                            I32,
                                            &ExtendKind::Sign,
                                        );
                                        let v1794 = &C::gpr_to_gpr_mem(ctx, v1793);
                                        let v1805 =
                                            constructor_x64_cvtsi2sd(ctx, I32, v1804, v1794);
                                        let v1806 = constructor_output_xmm(ctx, v1805);
                                        // Rule at src/isa/x64/lower.isle line 3368.
                                        return Some(v1806);
                                    }
                                    _ => {}
                                }
                                let v1797 = C::ty_int(ctx, v622);
                                if let Some(v1798) = v1797 {
                                    let v1799 = C::fits_in_64(ctx, v1798);
                                    if let Some(v1800) = v1799 {
                                        let v1804 = constructor_xmm_zero(ctx, F64X2);
                                        let v1801 = &constructor_put_in_gpr_mem(ctx, v381);
                                        let v1807 =
                                            constructor_x64_cvtsi2sd(ctx, v1800, v1804, v1801);
                                        let v1808 = constructor_output_xmm(ctx, v1807);
                                        // Rule at src/isa/x64/lower.isle line 3371.
                                        return Some(v1808);
                                    }
                                }
                            }
                            F64X2 => {
                                let v1811 = C::def_inst(ctx, v381);
                                if let Some(v1812) = v1811 {
                                    let v1813 = &C::inst_data(ctx, v1812);
                                    if let &InstructionData::Unary {
                                        opcode: ref v1814,
                                        arg: v1815,
                                    } = v1813
                                    {
                                        if let &Opcode::SwidenLow = v1814 {
                                            let v1816 = C::value_type(ctx, v1815);
                                            if v1816 == I32X4 {
                                                let v1817 = &C::put_in_xmm_mem(ctx, v1815);
                                                let v1818 = constructor_x64_cvtdq2pd(ctx, v1817);
                                                let v1819 = constructor_output_xmm(ctx, v1818);
                                                // Rule at src/isa/x64/lower.isle line 3377.
                                                return Some(v1819);
                                            }
                                        }
                                    }
                                }
                            }
                            _ => {}
                        }
                    }
                    let v622 = C::value_type(ctx, v381);
                    if v622 == I32X4 {
                        let v526 = &C::put_in_xmm_mem(ctx, v381);
                        let v1809 = constructor_x64_cvtdq2ps(ctx, v526);
                        let v1810 = constructor_output_xmm(ctx, v1809);
                        // Rule at src/isa/x64/lower.isle line 3374.
                        return Some(v1810);
                    }
                }
                &Opcode::Isplit => {
                    let v622 = C::value_type(ctx, v381);
                    if v622 == I128 {
                        let v385 = C::put_in_regs(ctx, v381);
                        let v2532 = C::value_regs_get(ctx, v385, 0x0);
                        let v2533 = C::value_regs_get(ctx, v385, 0x1);
                        let v2534 = C::value_reg(ctx, v2532);
                        let v2535 = C::value_reg(ctx, v2533);
                        let v2536 = C::output_pair(ctx, v2534, v2535);
                        // Rule at src/isa/x64/lower.isle line 4612.
                        return Some(v2536);
                    }
                }
                _ => {}
            }
        }
        &InstructionData::UnaryConst {
            opcode: ref v2242,
            constant_handle: v2243,
        } => {
            if let &Opcode::Vconst = v2242 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v2244 = C::const_to_vconst(ctx, v2243);
                    let v3 = C::value_type(ctx, v2);
                    let v2245 = constructor_x64_xmm_load_const(ctx, v3, v2244);
                    let v2246 = constructor_output_xmm(ctx, v2245);
                    // Rule at src/isa/x64/lower.isle line 4182.
                    return Some(v2246);
                }
            }
        }
        &InstructionData::UnaryGlobalValue {
            opcode: ref v1688,
            global_value: v1689,
        } => {
            match v1688 {
                &Opcode::SymbolValue => {
                    let v1690 = C::symbol_value_data(ctx, v1689);
                    if let Some(v1691) = v1690 {
                        let v1695 = constructor_load_ext_name(ctx, v1691.0, v1691.2, v1691.1);
                        let v1696 = constructor_output_reg(ctx, v1695);
                        // Rule at src/isa/x64/lower.isle line 3184.
                        return Some(v1696);
                    }
                }
                &Opcode::TlsValue => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v1690 = C::symbol_value_data(ctx, v1689);
                        if let Some(v1691) = v1690 {
                            let v3 = C::value_type(ctx, v2);
                            let v2537 = &C::tls_model(ctx, v3);
                            match v2537 {
                                &TlsModel::ElfGd => {
                                    let v2538 = constructor_elf_tls_get_addr(ctx, v1691.0);
                                    let v2539 = constructor_output_gpr(ctx, v2538);
                                    // Rule at src/isa/x64/lower.isle line 4620.
                                    return Some(v2539);
                                }
                                &TlsModel::Macho => {
                                    let v2540 = constructor_macho_tls_get_addr(ctx, v1691.0);
                                    let v2541 = constructor_output_gpr(ctx, v2540);
                                    // Rule at src/isa/x64/lower.isle line 4623.
                                    return Some(v2541);
                                }
                                &TlsModel::Coff => {
                                    let v2542 = constructor_coff_tls_get_addr(ctx, v1691.0);
                                    let v2543 = constructor_output_gpr(ctx, v2542);
                                    // Rule at src/isa/x64/lower.isle line 4626.
                                    return Some(v2543);
                                }
                                _ => {}
                            }
                        }
                    }
                }
                _ => {}
            }
        }
        &InstructionData::UnaryIeee32 {
            opcode: ref v18,
            imm: v19,
        } => {
            if let &Opcode::F32const = v18 {
                let v20 = C::u32_from_ieee32(ctx, v19);
                let v22 = C::u32_as_u64(ctx, v20);
                let v23 = constructor_imm(ctx, F32, v22);
                let v24 = constructor_output_reg(ctx, v23);
                // Rule at src/isa/x64/lower.isle line 27.
                return Some(v24);
            }
        }
        &InstructionData::UnaryIeee64 {
            opcode: ref v25,
            imm: v26,
        } => {
            if let &Opcode::F64const = v25 {
                let v27 = C::u64_from_ieee64(ctx, v26);
                let v29 = constructor_imm(ctx, F64, v27);
                let v30 = constructor_output_reg(ctx, v29);
                // Rule at src/isa/x64/lower.isle line 32.
                return Some(v30);
            }
        }
        &InstructionData::UnaryImm {
            opcode: ref v7,
            imm: v8,
        } => {
            if let &Opcode::Iconst = v7 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v3 = C::value_type(ctx, v2);
                    if v3 == I128 {
                        let v9 = C::u64_from_imm64(ctx, v8);
                        let v13 = constructor_imm(ctx, I64, v9);
                        let v15 = constructor_imm(ctx, I64, 0x0);
                        let v16 = C::value_regs(ctx, v13, v15);
                        let v17 = C::output(ctx, v16);
                        // Rule at src/isa/x64/lower.isle line 20.
                        return Some(v17);
                    }
                    let v4 = C::fits_in_64(ctx, v3);
                    if let Some(v5) = v4 {
                        let v9 = C::u64_from_imm64(ctx, v8);
                        let v10 = constructor_imm(ctx, v5, v9);
                        let v11 = constructor_output_reg(ctx, v10);
                        // Rule at src/isa/x64/lower.isle line 15.
                        return Some(v11);
                    }
                }
            }
        }
        _ => {}
    }
    None
}

// Generated as internal constructor for term lower_branch.
pub fn constructor_lower_branch<C: Context>(
    ctx: &mut C,
    arg0: Inst,
    arg1: &MachLabelSlice,
) -> Option<Unit> {
    let v1 = &C::inst_data(ctx, arg0);
    match v1 {
        &InstructionData::BranchTable {
            opcode: ref v55,
            arg: v56,
            table: v57,
        } => {
            if let &Opcode::BrTable = v55 {
                let v59 = C::jump_table_targets(ctx, arg1);
                if let Some(v60) = v59 {
                    let v58 = C::value_type(ctx, v56);
                    let v63 = &C::raw_operand_size_of_type(ctx, v58);
                    let v64 = C::jump_table_size(ctx, &v60.1);
                    let v65 = C::u32_as_u64(ctx, v64);
                    let v66 = constructor_imm(ctx, v58, v65);
                    let v69 = constructor_extend_to_gpr(ctx, v56, I64, &ExtendKind::Zero);
                    let v70 = &constructor_reg_to_gpr_mem_imm(ctx, v66);
                    let v71 = &constructor_x64_cmp(ctx, v63, v70, v69);
                    let v73 = &C::gpr_to_gpr_mem(ctx, v69);
                    let v74 = C::gpr_new(ctx, v66);
                    let v75 = &constructor_cmove(ctx, v58, &CC::B, v73, v74);
                    let v76 = constructor_with_flags_reg(ctx, v71, v75);
                    let v77 = C::gpr_new(ctx, v76);
                    let v78 = &constructor_jmp_table_seq(ctx, v58, v77, v60.0, &v60.1);
                    let v79 = constructor_emit_side_effect(ctx, v78);
                    // Rule at src/isa/x64/lower.isle line 3313.
                    return Some(v79);
                }
            }
        }
        &InstructionData::Brif {
            opcode: ref v9,
            arg: v10,
            blocks: ref v11,
        } => {
            if let &Opcode::Brif = v9 {
                let v26 = C::two_targets(ctx, arg1);
                if let Some(v27) = v26 {
                    let v12 = C::maybe_uextend(ctx, v10);
                    if let Some(v13) = v12 {
                        let v14 = C::def_inst(ctx, v13);
                        if let Some(v15) = v14 {
                            let v16 = &C::inst_data(ctx, v15);
                            match v16 {
                                &InstructionData::FloatCompare {
                                    opcode: ref v33,
                                    args: ref v34,
                                    cond: ref v35,
                                } => {
                                    if let &Opcode::Fcmp = v33 {
                                        let v36 = C::unpack_value_array_2(ctx, v34);
                                        let v39 = &constructor_emit_fcmp(ctx, v35, v36.0, v36.1);
                                        let v40 =
                                            &constructor_jmp_cond_fcmp(ctx, v39, v27.0, v27.1);
                                        let v41 = constructor_emit_side_effect(ctx, v40);
                                        // Rule at src/isa/x64/lower.isle line 3274.
                                        return Some(v41);
                                    }
                                }
                                &InstructionData::IntCompare {
                                    opcode: ref v17,
                                    args: ref v18,
                                    cond: ref v19,
                                } => {
                                    if let &Opcode::Icmp = v17 {
                                        let v20 = C::unpack_value_array_2(ctx, v18);
                                        let v30 = &constructor_emit_cmp(ctx, v19, v20.0, v20.1);
                                        let v31 =
                                            &constructor_jmp_cond_icmp(ctx, v30, v27.0, v27.1);
                                        let v32 = constructor_emit_side_effect(ctx, v31);
                                        // Rule at src/isa/x64/lower.isle line 3271.
                                        return Some(v32);
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                    let v42 = C::value_type(ctx, v10);
                    if v42 == I128 {
                        let v44 = C::put_in_regs(ctx, v10);
                        let v45 = &constructor_cmp_zero_i128(ctx, &CC::Z, v44);
                        let v46 = &constructor_jmp_cond_icmp(ctx, v45, v27.0, v27.1);
                        let v47 = constructor_emit_side_effect(ctx, v46);
                        // Rule at src/isa/x64/lower.isle line 3277.
                        return Some(v47);
                    }
                    let v48 = C::ty_int_bool_or_ref(ctx, v42);
                    if let Some(v49) = v48 {
                        let v50 = &constructor_cmp_zero_int_bool_ref(ctx, v10);
                        let v52 = &constructor_jmp_cond(ctx, &CC::NZ, v27.0, v27.1);
                        let v53 = &constructor_with_flags_side_effect(ctx, v50, v52);
                        let v54 = constructor_emit_side_effect(ctx, v53);
                        // Rule at src/isa/x64/lower.isle line 3281.
                        return Some(v54);
                    }
                }
            }
        }
        &InstructionData::Jump {
            opcode: ref v2,
            destination: v3,
        } => {
            if let &Opcode::Jump = v2 {
                let v5 = C::single_target(ctx, arg1);
                if let Some(v6) = v5 {
                    let v7 = &constructor_jmp_known(ctx, v6);
                    let v8 = constructor_emit_side_effect(ctx, v7);
                    // Rule at src/isa/x64/lower.isle line 3266.
                    return Some(v8);
                }
            }
        }
        _ => {}
    }
    None
}

// Generated as internal constructor for term construct_overflow_op.
pub fn constructor_construct_overflow_op<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: &ProducesFlags,
) -> InstOutput {
    let v2 = &constructor_x64_setcc_paired(ctx, arg0);
    let v3 = constructor_with_flags(ctx, arg1, v2);
    let v5 = C::value_regs_get(ctx, v3, 0x0);
    let v6 = C::value_reg(ctx, v5);
    let v8 = C::value_regs_get(ctx, v3, 0x1);
    let v9 = C::value_reg(ctx, v8);
    let v10 = C::output_pair(ctx, v6, v9);
    // Rule at src/isa/x64/lower.isle line 104.
    return v10;
}

// Generated as internal constructor for term construct_overflow_op_alu.
pub fn constructor_construct_overflow_op_alu<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &AluRmiROpcode,
    arg3: Gpr,
    arg4: &GprMemImm,
) -> InstOutput {
    let v5 = &constructor_x64_alurmi_with_flags_paired(ctx, arg2, arg0, arg3, arg4);
    let v6 = constructor_construct_overflow_op(ctx, arg1, v5);
    // Rule at src/isa/x64/lower.isle line 111.
    return v6;
}

// Generated as internal constructor for term construct_overflow_op_alu_128.
pub fn constructor_construct_overflow_op_alu_128<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: &AluRmiROpcode,
    arg2: &AluRmiROpcode,
    arg3: Value,
    arg4: Value,
) -> InstOutput {
    let v5 = C::put_in_regs(ctx, arg3);
    let v7 = constructor_value_regs_get_gpr(ctx, v5, 0x0);
    let v9 = constructor_value_regs_get_gpr(ctx, v5, 0x1);
    let v10 = C::put_in_regs(ctx, arg4);
    let v11 = constructor_value_regs_get_gpr(ctx, v10, 0x0);
    let v12 = constructor_value_regs_get_gpr(ctx, v10, 0x1);
    let v14 = &C::gpr_to_gpr_mem_imm(ctx, v11);
    let v15 = &constructor_x64_alurmi_with_flags_paired(ctx, arg1, I64, v7, v14);
    let v16 = &C::gpr_to_gpr_mem_imm(ctx, v12);
    let v17 = &constructor_x64_alurmi_with_flags_chained(ctx, arg2, I64, v9, v16);
    let v18 = &constructor_x64_setcc_paired(ctx, arg0);
    let v19 = &constructor_with_flags_chained(ctx, v15, v17, v18);
    let v20 = constructor_multi_reg_to_pair_and_single(ctx, v19);
    // Rule at src/isa/x64/lower.isle line 119.
    return v20;
}

// Generated as internal constructor for term sse_and.
pub fn constructor_sse_and<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm, arg2: &XmmMem) -> Xmm {
    match arg0 {
        F32 => {
            let v3 = constructor_x64_andps(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 293.
            return v3;
        }
        F64 => {
            let v4 = constructor_x64_andpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 294.
            return v4;
        }
        F32X4 => {
            let v3 = constructor_x64_andps(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 291.
            return v3;
        }
        F64X2 => {
            let v4 = constructor_x64_andpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 292.
            return v4;
        }
        _ => {}
    }
    let v5 = C::multi_lane(ctx, arg0);
    if let Some(v6) = v5 {
        let v9 = constructor_x64_pand(ctx, arg1, arg2);
        // Rule at src/isa/x64/lower.isle line 295.
        return v9;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "sse_and", "src/isa/x64/lower.isle line 290"
    )
}

// Generated as internal constructor for term and_i128.
pub fn constructor_and_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: ValueRegs,
) -> ValueRegs {
    let v3 = constructor_value_regs_get_gpr(ctx, arg0, 0x0);
    let v5 = constructor_value_regs_get_gpr(ctx, arg0, 0x1);
    let v6 = constructor_value_regs_get_gpr(ctx, arg1, 0x0);
    let v7 = constructor_value_regs_get_gpr(ctx, arg1, 0x1);
    let v9 = &C::gpr_to_gpr_mem_imm(ctx, v6);
    let v10 = constructor_x64_and(ctx, I64, v3, v9);
    let v11 = &C::gpr_to_gpr_mem_imm(ctx, v7);
    let v12 = constructor_x64_and(ctx, I64, v5, v11);
    let v13 = constructor_value_gprs(ctx, v10, v12);
    // Rule at src/isa/x64/lower.isle line 304.
    return v13;
}

// Generated as internal constructor for term sse_and_not.
pub fn constructor_sse_and_not<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        F32X4 => {
            let v3 = constructor_x64_andnps(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 322.
            return v3;
        }
        F64X2 => {
            let v4 = constructor_x64_andnpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 323.
            return v4;
        }
        _ => {}
    }
    let v5 = C::multi_lane(ctx, arg0);
    if let Some(v6) = v5 {
        let v9 = constructor_x64_pandn(ctx, arg1, arg2);
        // Rule at src/isa/x64/lower.isle line 324.
        return v9;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "sse_and_not", "src/isa/x64/lower.isle line 321"
    )
}

// Generated as internal constructor for term val_minus_one.
pub fn constructor_val_minus_one<C: Context>(ctx: &mut C, arg0: Value) -> Option<Value> {
    let v1 = C::def_inst(ctx, arg0);
    if let Some(v2) = v1 {
        let v3 = &C::inst_data(ctx, v2);
        if let &InstructionData::Binary {
            opcode: ref v4,
            args: ref v5,
        } = v3
        {
            match v4 {
                &Opcode::Iadd => {
                    let v6 = C::unpack_value_array_2(ctx, v5);
                    let v17 = C::i64_from_iconst(ctx, v6.0);
                    if let Some(v18) = v17 {
                        if v18 == -0x1 {
                            // Rule at src/isa/x64/lower.isle line 353.
                            return Some(v6.1);
                        }
                    }
                    let v15 = C::i64_from_iconst(ctx, v6.1);
                    if let Some(v16) = v15 {
                        if v16 == -0x1 {
                            // Rule at src/isa/x64/lower.isle line 352.
                            return Some(v6.0);
                        }
                    }
                }
                &Opcode::Isub => {
                    let v6 = C::unpack_value_array_2(ctx, v5);
                    let v9 = C::def_inst(ctx, v6.1);
                    if let Some(v10) = v9 {
                        let v11 = &C::inst_data(ctx, v10);
                        if let &InstructionData::UnaryImm {
                            opcode: ref v12,
                            imm: v13,
                        } = v11
                        {
                            if let &Opcode::Iconst = v12 {
                                let v14 = C::u64_from_imm64(ctx, v13);
                                if v14 == 0x1 {
                                    // Rule at src/isa/x64/lower.isle line 351.
                                    return Some(v6.0);
                                }
                            }
                        }
                    }
                }
                _ => {}
            }
        }
    }
    None
}

// Generated as internal constructor for term sse_or.
pub fn constructor_sse_or<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm, arg2: &XmmMem) -> Xmm {
    match arg0 {
        F32 => {
            let v3 = constructor_x64_orps(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 417.
            return v3;
        }
        F64 => {
            let v4 = constructor_x64_orpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 418.
            return v4;
        }
        F32X4 => {
            let v3 = constructor_x64_orps(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 415.
            return v3;
        }
        F64X2 => {
            let v4 = constructor_x64_orpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/lower.isle line 416.
            return v4;
        }
        _ => {}
    }
    let v5 = C::multi_lane(ctx, arg0);
    if let Some(v6) = v5 {
        let v9 = constructor_x64_por(ctx, arg1, arg2);
        // Rule at src/isa/x64/lower.isle line 419.
        return v9;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "sse_or", "src/isa/x64/lower.isle line 414"
    )
}

// Generated as internal constructor for term or_i128.
pub fn constructor_or_i128<C: Context>(ctx: &mut C, arg0: ValueRegs, arg1: ValueRegs) -> ValueRegs {
    let v3 = constructor_value_regs_get_gpr(ctx, arg0, 0x0);
    let v5 = constructor_value_regs_get_gpr(ctx, arg0, 0x1);
    let v6 = constructor_value_regs_get_gpr(ctx, arg1, 0x0);
    let v7 = constructor_value_regs_get_gpr(ctx, arg1, 0x1);
    let v9 = &C::gpr_to_gpr_mem_imm(ctx, v6);
    let v10 = constructor_x64_or(ctx, I64, v3, v9);
    let v11 = &C::gpr_to_gpr_mem_imm(ctx, v7);
    let v12 = constructor_x64_or(ctx, I64, v5, v11);
    let v13 = constructor_value_gprs(ctx, v10, v12);
    // Rule at src/isa/x64/lower.isle line 428.
    return v13;
}

// Generated as internal constructor for term shl_i128.
pub fn constructor_shl_i128<C: Context>(ctx: &mut C, arg0: ValueRegs, arg1: Gpr) -> ValueRegs {
    let v3 = constructor_value_regs_get_gpr(ctx, arg0, 0x0);
    let v5 = constructor_value_regs_get_gpr(ctx, arg0, 0x1);
    let v7 = &C::gpr_to_imm8_gpr(ctx, arg1);
    let v8 = constructor_x64_shl(ctx, I64, v3, v7);
    let v9 = &C::gpr_to_imm8_gpr(ctx, arg1);
    let v10 = constructor_x64_shl(ctx, I64, v5, v9);
    let v12 = constructor_imm(ctx, I64, 0x40);
    let v13 = C::gpr_new(ctx, v12);
    let v14 = &C::gpr_to_gpr_mem_imm(ctx, arg1);
    let v15 = constructor_x64_sub(ctx, I64, v13, v14);
    let v16 = &C::gpr_to_imm8_gpr(ctx, v15);
    let v17 = constructor_x64_shr(ctx, I64, v3, v16);
    let v19 = constructor_imm(ctx, I64, 0x0);
    let v20 = C::gpr_new(ctx, v19);
    let v23 = RegMemImm::Imm { simm32: 0x7F };
    let v24 = &C::gpr_mem_imm_new(ctx, &v23);
    let v25 = &constructor_x64_test(ctx, &OperandSize::Size64, v24, arg1);
    let v27 = &C::gpr_to_gpr_mem(ctx, v20);
    let v28 = &constructor_cmove(ctx, I64, &CC::Z, v27, v17);
    let v29 = constructor_with_flags_reg(ctx, v25, v28);
    let v30 = C::gpr_new(ctx, v29);
    let v31 = &C::gpr_to_gpr_mem_imm(ctx, v10);
    let v32 = constructor_x64_or(ctx, I64, v30, v31);
    let v34 = RegMemImm::Imm { simm32: 0x40 };
    let v35 = &C::gpr_mem_imm_new(ctx, &v34);
    let v36 = &constructor_x64_test(ctx, &OperandSize::Size64, v35, arg1);
    let v37 = &C::gpr_to_gpr_mem(ctx, v8);
    let v38 = &constructor_cmove(ctx, I64, &CC::Z, v37, v20);
    let v39 = &C::gpr_to_gpr_mem(ctx, v32);
    let v40 = &constructor_cmove(ctx, I64, &CC::Z, v39, v8);
    let v41 = &constructor_consumes_flags_concat(ctx, v38, v40);
    let v42 = constructor_with_flags(ctx, v36, v41);
    // Rule at src/isa/x64/lower.isle line 502.
    return v42;
}

// Generated as internal constructor for term ishl_i8x16_mask.
pub fn constructor_ishl_i8x16_mask<C: Context>(ctx: &mut C, arg0: &RegMemImm) -> SyntheticAmode {
    match arg0 {
        &RegMemImm::Reg { reg: v3 } => {
            let v4 = &C::ishl_i8x16_mask_table(ctx);
            let v6 = constructor_x64_lea(ctx, I64, v4);
            let v7 = C::gpr_new(ctx, v3);
            let v9 = &C::imm8_to_imm8_gpr(ctx, 0x4);
            let v10 = constructor_x64_shl(ctx, I64, v7, v9);
            let v13 = C::mem_flags_trusted(ctx);
            let v14 = Amode::ImmRegRegShift {
                simm32: 0x0,
                base: v6,
                index: v10,
                shift: 0x0,
                flags: v13,
            };
            let v15 = &C::amode_to_synthetic_amode(ctx, &v14);
            // Rule at src/isa/x64/lower.isle line 576.
            return v15.clone();
        }
        &RegMemImm::Mem { addr: ref v16 } => {
            let v18 = constructor_x64_load(ctx, I64, v16, &ExtKind::None);
            let v19 = RegMemImm::Reg { reg: v18 };
            let v20 = &constructor_ishl_i8x16_mask(ctx, &v19);
            // Rule at src/isa/x64/lower.isle line 587.
            return v20.clone();
        }
        &RegMemImm::Imm { simm32: v1 } => {
            let v2 = &C::ishl_i8x16_mask_for_const(ctx, v1);
            // Rule at src/isa/x64/lower.isle line 567.
            return v2.clone();
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "ishl_i8x16_mask", "src/isa/x64/lower.isle line 561"
    )
}

// Generated as internal constructor for term shr_i128.
pub fn constructor_shr_i128<C: Context>(ctx: &mut C, arg0: ValueRegs, arg1: Gpr) -> ValueRegs {
    let v3 = constructor_value_regs_get_gpr(ctx, arg0, 0x0);
    let v5 = constructor_value_regs_get_gpr(ctx, arg0, 0x1);
    let v7 = &C::gpr_to_imm8_gpr(ctx, arg1);
    let v8 = constructor_x64_shr(ctx, I64, v3, v7);
    let v9 = &C::gpr_to_imm8_gpr(ctx, arg1);
    let v10 = constructor_x64_shr(ctx, I64, v5, v9);
    let v12 = constructor_imm(ctx, I64, 0x40);
    let v13 = C::gpr_new(ctx, v12);
    let v14 = &C::gpr_to_gpr_mem_imm(ctx, arg1);
    let v15 = constructor_x64_sub(ctx, I64, v13, v14);
    let v16 = &C::gpr_to_imm8_gpr(ctx, v15);
    let v17 = constructor_x64_shl(ctx, I64, v5, v16);
    let v19 = constructor_imm(ctx, I64, 0x0);
    let v20 = C::gpr_new(ctx, v19);
    let v23 = RegMemImm::Imm { simm32: 0x7F };
    let v24 = &C::gpr_mem_imm_new(ctx, &v23);
    let v25 = &constructor_x64_test(ctx, &OperandSize::Size64, v24, arg1);
    let v27 = &C::gpr_to_gpr_mem(ctx, v20);
    let v28 = &constructor_cmove(ctx, I64, &CC::Z, v27, v17);
    let v29 = constructor_with_flags_reg(ctx, v25, v28);
    let v30 = C::gpr_new(ctx, v29);
    let v31 = &C::gpr_to_gpr_mem_imm(ctx, v8);
    let v32 = constructor_x64_or(ctx, I64, v30, v31);
    let v34 = RegMemImm::Imm { simm32: 0x40 };
    let v35 = &C::gpr_mem_imm_new(ctx, &v34);
    let v36 = &constructor_x64_test(ctx, &OperandSize::Size64, v35, arg1);
    let v37 = &C::gpr_to_gpr_mem(ctx, v32);
    let v38 = &constructor_cmove(ctx, I64, &CC::Z, v37, v10);
    let v39 = &C::gpr_to_gpr_mem(ctx, v10);
    let v40 = &constructor_cmove(ctx, I64, &CC::Z, v39, v20);
    let v41 = &constructor_consumes_flags_concat(ctx, v38, v40);
    let v42 = constructor_with_flags(ctx, v36, v41);
    // Rule at src/isa/x64/lower.isle line 612.
    return v42;
}

// Generated as internal constructor for term ushr_i8x16_mask.
pub fn constructor_ushr_i8x16_mask<C: Context>(ctx: &mut C, arg0: &RegMemImm) -> SyntheticAmode {
    match arg0 {
        &RegMemImm::Reg { reg: v3 } => {
            let v4 = &C::ushr_i8x16_mask_table(ctx);
            let v6 = constructor_x64_lea(ctx, I64, v4);
            let v7 = C::gpr_new(ctx, v3);
            let v9 = &C::imm8_to_imm8_gpr(ctx, 0x4);
            let v10 = constructor_x64_shl(ctx, I64, v7, v9);
            let v13 = C::mem_flags_trusted(ctx);
            let v14 = Amode::ImmRegRegShift {
                simm32: 0x0,
                base: v6,
                index: v10,
                shift: 0x0,
                flags: v13,
            };
            let v15 = &C::amode_to_synthetic_amode(ctx, &v14);
            // Rule at src/isa/x64/lower.isle line 681.
            return v15.clone();
        }
        &RegMemImm::Mem { addr: ref v16 } => {
            let v18 = constructor_x64_load(ctx, I64, v16, &ExtKind::None);
            let v19 = RegMemImm::Reg { reg: v18 };
            let v20 = &constructor_ushr_i8x16_mask(ctx, &v19);
            // Rule at src/isa/x64/lower.isle line 693.
            return v20.clone();
        }
        &RegMemImm::Imm { simm32: v1 } => {
            let v2 = &C::ushr_i8x16_mask_for_const(ctx, v1);
            // Rule at src/isa/x64/lower.isle line 672.
            return v2.clone();
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "ushr_i8x16_mask", "src/isa/x64/lower.isle line 666"
    )
}

// Generated as internal constructor for term mask_xmm_shift.
pub fn constructor_mask_xmm_shift<C: Context>(ctx: &mut C, arg0: Type, arg1: Value) -> RegMemImm {
    let v11 = C::def_inst(ctx, arg1);
    if let Some(v12) = v11 {
        let v13 = &C::inst_data(ctx, v12);
        if let &InstructionData::UnaryImm {
            opcode: ref v14,
            imm: v15,
        } = v13
        {
            if let &Opcode::Iconst = v14 {
                let v16 = C::shift_amount_masked(ctx, arg0, v15);
                let v17 = C::u8_as_u32(ctx, v16);
                let v18 = RegMemImm::Imm { simm32: v17 };
                // Rule at src/isa/x64/lower.isle line 710.
                return v18;
            }
        }
    }
    let v3 = constructor_put_in_gpr(ctx, arg1);
    let v4 = C::shift_mask(ctx, arg0);
    let v5 = C::u8_as_u32(ctx, v4);
    let v6 = RegMemImm::Imm { simm32: v5 };
    let v7 = &C::gpr_mem_imm_new(ctx, &v6);
    let v8 = constructor_x64_and(ctx, I64, v3, v7);
    let v9 = C::gpr_to_reg(ctx, v8);
    let v10 = &C::reg_to_reg_mem_imm(ctx, v9);
    // Rule at src/isa/x64/lower.isle line 708.
    return v10.clone();
}

// Generated as internal constructor for term sar_i128.
pub fn constructor_sar_i128<C: Context>(ctx: &mut C, arg0: ValueRegs, arg1: Gpr) -> ValueRegs {
    let v3 = constructor_value_regs_get_gpr(ctx, arg0, 0x0);
    let v5 = constructor_value_regs_get_gpr(ctx, arg0, 0x1);
    let v7 = &C::gpr_to_imm8_gpr(ctx, arg1);
    let v8 = constructor_x64_shr(ctx, I64, v3, v7);
    let v9 = &C::gpr_to_imm8_gpr(ctx, arg1);
    let v10 = constructor_x64_sar(ctx, I64, v5, v9);
    let v12 = constructor_imm(ctx, I64, 0x40);
    let v13 = C::gpr_new(ctx, v12);
    let v14 = &C::gpr_to_gpr_mem_imm(ctx, arg1);
    let v15 = constructor_x64_sub(ctx, I64, v13, v14);
    let v16 = &C::gpr_to_imm8_gpr(ctx, v15);
    let v17 = constructor_x64_shl(ctx, I64, v5, v16);
    let v20 = RegMemImm::Imm { simm32: 0x7F };
    let v21 = &C::gpr_mem_imm_new(ctx, &v20);
    let v22 = &constructor_x64_test(ctx, &OperandSize::Size64, v21, arg1);
    let v25 = constructor_imm(ctx, I64, 0x0);
    let v26 = &C::reg_to_gpr_mem(ctx, v25);
    let v27 = &constructor_cmove(ctx, I64, &CC::Z, v26, v17);
    let v28 = constructor_with_flags_reg(ctx, v22, v27);
    let v29 = C::gpr_new(ctx, v28);
    let v30 = &C::gpr_to_gpr_mem_imm(ctx, v29);
    let v31 = constructor_x64_or(ctx, I64, v8, v30);
    let v33 = &C::imm8_to_imm8_gpr(ctx, 0x3F);
    let v34 = constructor_x64_sar(ctx, I64, v5, v33);
    let v36 = RegMemImm::Imm { simm32: 0x40 };
    let v37 = &C::gpr_mem_imm_new(ctx, &v36);
    let v38 = &constructor_x64_test(ctx, &OperandSize::Size64, v37, arg1);
    let v39 = &C::gpr_to_gpr_mem(ctx, v31);
    let v40 = &constructor_cmove(ctx, I64, &CC::Z, v39, v10);
    let v41 = &C::gpr_to_gpr_mem(ctx, v10);
    let v42 = &constructor_cmove(ctx, I64, &CC::Z, v41, v34);
    let v43 = &constructor_consumes_flags_concat(ctx, v40, v42);
    let v44 = constructor_with_flags(ctx, v38, v43);
    // Rule at src/isa/x64/lower.isle line 724.
    return v44;
}

// Generated as internal constructor for term sshr_i8x16_bigger_shift.
pub fn constructor_sshr_i8x16_bigger_shift<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &RegMemImm,
) -> XmmMemImm {
    match arg1 {
        &RegMemImm::Reg { reg: v7 } => {
            let v8 = C::gpr_new(ctx, v7);
            let v9 = RegMemImm::Imm { simm32: 0x8 };
            let v10 = &C::gpr_mem_imm_new(ctx, &v9);
            let v11 = constructor_x64_add(ctx, arg0, v8, v10);
            let v12 = C::gpr_to_reg(ctx, v11);
            let v13 = RegMemImm::Reg { reg: v12 };
            let v14 = &constructor_mov_rmi_to_xmm(ctx, &v13);
            // Rule at src/isa/x64/lower.isle line 792.
            return v14.clone();
        }
        &RegMemImm::Mem { addr: ref v15 } => {
            let v17 = constructor_imm(ctx, arg0, 0x8);
            let v18 = C::gpr_new(ctx, v17);
            let v19 = &C::gpr_mem_imm_new(ctx, arg1);
            let v20 = constructor_x64_add(ctx, arg0, v18, v19);
            let v21 = C::gpr_to_reg(ctx, v20);
            let v22 = RegMemImm::Reg { reg: v21 };
            let v23 = &constructor_mov_rmi_to_xmm(ctx, &v22);
            // Rule at src/isa/x64/lower.isle line 796.
            return v23.clone();
        }
        &RegMemImm::Imm { simm32: v2 } => {
            let v4 = C::u32_add(ctx, v2, 0x8);
            let v5 = RegMemImm::Imm { simm32: v4 };
            let v6 = &C::xmm_mem_imm_new(ctx, &v5);
            // Rule at src/isa/x64/lower.isle line 790.
            return v6.clone();
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "sshr_i8x16_bigger_shift", "src/isa/x64/lower.isle line 789"
    )
}

// Generated as internal constructor for term lower_i64x2_sshr_imm.
pub fn constructor_lower_i64x2_sshr_imm<C: Context>(ctx: &mut C, arg0: Xmm, arg1: u32) -> Xmm {
    let v2 = C::u32_as_u64(ctx, arg1);
    let v4 = C::u64_lt(ctx, v2, 0x20);
    if v4 == true {
        let v5 = &C::xmi_imm(ctx, arg1);
        let v6 = constructor_x64_psrad(ctx, arg0, v5);
        let v7 = &C::xmm_to_xmm_mem(ctx, v6);
        let v9 = constructor_x64_pshufd(ctx, v7, 0xED);
        let v10 = &C::xmi_imm(ctx, arg1);
        let v11 = constructor_x64_psrlq(ctx, arg0, v10);
        let v12 = &C::xmm_to_xmm_mem(ctx, v11);
        let v14 = constructor_x64_pshufd(ctx, v12, 0xE8);
        let v15 = &C::xmm_to_xmm_mem(ctx, v9);
        let v16 = constructor_x64_punpckldq(ctx, v14, v15);
        // Rule at src/isa/x64/lower.isle line 835.
        return v16;
    }
    if arg1 == 0x20 {
        let v17 = &C::xmm_to_xmm_mem(ctx, arg0);
        let v18 = constructor_x64_pshufd(ctx, v17, 0xED);
        let v20 = &C::xmi_imm(ctx, 0x1F);
        let v21 = constructor_x64_psrad(ctx, arg0, v20);
        let v22 = &C::xmm_to_xmm_mem(ctx, v21);
        let v23 = constructor_x64_pshufd(ctx, v22, 0xED);
        let v24 = &C::xmm_to_xmm_mem(ctx, v23);
        let v25 = constructor_x64_punpckldq(ctx, v18, v24);
        // Rule at src/isa/x64/lower.isle line 846.
        return v25;
    }
    let v26 = C::u64_lt(ctx, 0x20, v2);
    if v26 == true {
        let v27 = &C::xmi_imm(ctx, 0x1F);
        let v28 = constructor_x64_psrad(ctx, arg0, v27);
        let v29 = &C::xmm_to_xmm_mem(ctx, v28);
        let v30 = constructor_x64_pshufd(ctx, v29, 0xED);
        let v32 = C::u32_sub(ctx, arg1, 0x20);
        let v33 = &C::xmi_imm(ctx, v32);
        let v34 = constructor_x64_psrad(ctx, arg0, v33);
        let v35 = &C::xmm_to_xmm_mem(ctx, v34);
        let v36 = constructor_x64_pshufd(ctx, v35, 0xED);
        let v37 = &C::xmm_to_xmm_mem(ctx, v30);
        let v38 = constructor_x64_punpckldq(ctx, v36, v37);
        // Rule at src/isa/x64/lower.isle line 857.
        return v38;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "lower_i64x2_sshr_imm", "src/isa/x64/lower.isle line 830"
    )
}

// Generated as internal constructor for term lower_i64x2_sshr_gpr.
pub fn constructor_lower_i64x2_sshr_gpr<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Gpr) -> Xmm {
    let v2 = &C::gpr_to_gpr_mem(ctx, arg1);
    let v3 = constructor_x64_movq_to_xmm(ctx, v2);
    let v5 = constructor_flip_high_bit_mask(ctx, I64X2);
    let v6 = &C::xmm_to_xmm_mem_imm(ctx, v3);
    let v7 = constructor_x64_psrlq(ctx, v5, v6);
    let v8 = &C::xmm_to_xmm_mem_imm(ctx, v3);
    let v9 = constructor_x64_psrlq(ctx, arg0, v8);
    let v10 = &C::xmm_to_xmm_mem(ctx, v9);
    let v11 = constructor_x64_pxor(ctx, v7, v10);
    let v12 = &C::xmm_to_xmm_mem(ctx, v7);
    let v13 = constructor_x64_psubq(ctx, v11, v12);
    // Rule at src/isa/x64/lower.isle line 872.
    return v13;
}

// Generated as internal constructor for term lower_bmask.
pub fn constructor_lower_bmask<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: ValueRegs,
) -> ValueRegs {
    if arg0 == I128 {
        let v23 = constructor_lower_bmask(ctx, I64, arg1, arg2);
        let v24 = constructor_value_regs_get_gpr(ctx, v23, 0x0);
        let v25 = C::gpr_to_reg(ctx, v24);
        let v26 = C::gpr_to_reg(ctx, v24);
        let v27 = C::value_regs(ctx, v25, v26);
        // Rule at src/isa/x64/lower.isle line 1335.
        return v27;
    }
    let v1 = C::fits_in_64(ctx, arg0);
    if let Some(v2) = v1 {
        if arg1 == I128 {
            let v8 = constructor_value_regs_get_gpr(ctx, arg2, 0x0);
            let v16 = constructor_value_regs_get_gpr(ctx, arg2, 0x1);
            let v18 = &C::gpr_to_gpr_mem_imm(ctx, v16);
            let v19 = constructor_x64_or(ctx, I64, v8, v18);
            let v20 = C::gpr_to_reg(ctx, v19);
            let v21 = C::value_reg(ctx, v20);
            let v22 = constructor_lower_bmask(ctx, v2, I64, v21);
            // Rule at src/isa/x64/lower.isle line 1327.
            return v22;
        }
        let v4 = C::fits_in_64(ctx, arg1);
        if let Some(v5) = v4 {
            let v8 = constructor_value_regs_get_gpr(ctx, arg2, 0x0);
            let v9 = &constructor_x64_neg_paired(ctx, v5, v8);
            let v10 = &C::gpr_to_gpr_mem_imm(ctx, v8);
            let v11 = &constructor_x64_sbb_paired(ctx, v2, v8, v10);
            let v12 = constructor_with_flags(ctx, v9, v11);
            let v14 = C::value_regs_get(ctx, v12, 0x1);
            let v15 = C::value_reg(ctx, v14);
            // Rule at src/isa/x64/lower.isle line 1316.
            return v15;
        }
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "lower_bmask", "src/isa/x64/lower.isle line 1304"
    )
}

// Generated as internal constructor for term i128_not.
pub fn constructor_i128_not<C: Context>(ctx: &mut C, arg0: Value) -> ValueRegs {
    let v1 = C::put_in_regs(ctx, arg0);
    let v3 = constructor_value_regs_get_gpr(ctx, v1, 0x0);
    let v5 = constructor_value_regs_get_gpr(ctx, v1, 0x1);
    let v7 = constructor_x64_not(ctx, I64, v3);
    let v8 = constructor_x64_not(ctx, I64, v5);
    let v9 = constructor_value_gprs(ctx, v7, v8);
    // Rule at src/isa/x64/lower.isle line 1358.
    return v9;
}

// Generated as internal constructor for term all_ones_or_all_zeros.
pub fn constructor_all_ones_or_all_zeros<C: Context>(ctx: &mut C, arg0: Value) -> Option<bool> {
    let v1 = C::def_inst(ctx, arg0);
    if let Some(v2) = v1 {
        let v3 = &C::inst_data(ctx, v2);
        match v3 {
            &InstructionData::FloatCompare {
                opcode: ref v16,
                args: ref v17,
                cond: ref v18,
            } => {
                if let &Opcode::Fcmp = v16 {
                    let v10 = C::value_type(ctx, arg0);
                    let v11 = C::multi_lane(ctx, v10);
                    if let Some(v12) = v11 {
                        // Rule at src/isa/x64/lower.isle line 1404.
                        return Some(true);
                    }
                }
            }
            &InstructionData::IntCompare {
                opcode: ref v4,
                args: ref v5,
                cond: ref v6,
            } => {
                if let &Opcode::Icmp = v4 {
                    let v10 = C::value_type(ctx, arg0);
                    let v11 = C::multi_lane(ctx, v10);
                    if let Some(v12) = v11 {
                        // Rule at src/isa/x64/lower.isle line 1403.
                        return Some(true);
                    }
                }
            }
            &InstructionData::UnaryConst {
                opcode: ref v22,
                constant_handle: v23,
            } => {
                if let &Opcode::Vconst = v22 {
                    let v24 = C::vconst_all_ones_or_all_zeros(ctx, v23);
                    if let Some(v25) = v24 {
                        // Rule at src/isa/x64/lower.isle line 1405.
                        return Some(true);
                    }
                }
            }
            _ => {}
        }
    }
    None
}

// Generated as internal constructor for term vec_insert_lane.
pub fn constructor_vec_insert_lane<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &RegMem,
    arg3: u8,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v4 = C::use_sse41(ctx);
            if v4 == true {
                let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                let v6 = constructor_x64_pinsrb(ctx, arg1, v5, arg3);
                // Rule at src/isa/x64/lower.isle line 1473.
                return v6;
            }
            let v7 = C::insert_i8x16_lane_hole(ctx, arg3);
            let v8 = &constructor_const_to_xmm_mem(ctx, v7);
            let v9 = constructor_x64_pand(ctx, arg1, v8);
            let v11 = &C::reg_mem_to_gpr_mem(ctx, arg2);
            let v12 = constructor_x64_movzx(ctx, &ExtMode::BL, v11);
            let v15 = C::u8_and(ctx, arg3, 0x3);
            let v16 = C::u8_shl(ctx, v15, 0x3);
            let v17 = Imm8Reg::Imm8 { imm: v16 };
            let v18 = &C::imm8_reg_to_imm8_gpr(ctx, &v17);
            let v19 = constructor_x64_shl(ctx, I32, v12, v18);
            let v20 = &C::gpr_to_gpr_mem(ctx, v19);
            let v21 = constructor_x64_movd_to_xmm(ctx, v20);
            let v22 = &C::xmm_to_xmm_mem(ctx, v21);
            let v24 = C::u8_shr(ctx, arg3, 0x2);
            let v25 = constructor_insert_i8x16_lane_pshufd_imm(ctx, v24);
            let v26 = constructor_x64_pshufd(ctx, v22, v25);
            let v27 = &C::xmm_to_xmm_mem(ctx, v26);
            let v28 = constructor_x64_por(ctx, v9, v27);
            // Rule at src/isa/x64/lower.isle line 1501.
            return v28;
        }
        I16X8 => {
            let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
            let v29 = constructor_x64_pinsrw(ctx, arg1, v5, arg3);
            // Rule at src/isa/x64/lower.isle line 1518.
            return v29;
        }
        I32X4 => {
            let v4 = C::use_sse41(ctx);
            if v4 == true {
                let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                let v30 = constructor_x64_pinsrd(ctx, arg1, v5, arg3);
                // Rule at src/isa/x64/lower.isle line 1522.
                return v30;
            }
            match arg3 {
                0x0 => {
                    let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                    let v31 = constructor_x64_movd_to_xmm(ctx, v5);
                    let v32 = constructor_x64_movss_regmove(ctx, arg1, v31);
                    // Rule at src/isa/x64/lower.isle line 1526.
                    return v32;
                }
                0x1 => {
                    let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                    let v31 = constructor_x64_movd_to_xmm(ctx, v5);
                    let v33 = &C::xmm_to_xmm_mem(ctx, arg1);
                    let v34 = constructor_x64_punpcklqdq(ctx, v31, v33);
                    let v35 = &C::xmm_to_xmm_mem(ctx, arg1);
                    let v37 = constructor_x64_shufps(ctx, v34, v35, 0xE2);
                    // Rule at src/isa/x64/lower.isle line 1531.
                    return v37;
                }
                0x2 => {
                    let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                    let v31 = constructor_x64_movd_to_xmm(ctx, v5);
                    let v33 = &C::xmm_to_xmm_mem(ctx, arg1);
                    let v39 = constructor_x64_shufps(ctx, v31, v33, 0x30);
                    let v40 = &C::xmm_to_xmm_mem(ctx, v39);
                    let v42 = constructor_x64_shufps(ctx, arg1, v40, 0x84);
                    // Rule at src/isa/x64/lower.isle line 1538.
                    return v42;
                }
                0x3 => {
                    let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                    let v31 = constructor_x64_movd_to_xmm(ctx, v5);
                    let v33 = &C::xmm_to_xmm_mem(ctx, arg1);
                    let v44 = constructor_x64_shufps(ctx, v31, v33, 0xE4);
                    let v45 = &C::xmm_to_xmm_mem(ctx, v44);
                    let v47 = constructor_x64_shufps(ctx, arg1, v45, 0x24);
                    // Rule at src/isa/x64/lower.isle line 1545.
                    return v47;
                }
                _ => {}
            }
        }
        I64X2 => {
            let v4 = C::use_sse41(ctx);
            if v4 == true {
                let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                let v48 = constructor_x64_pinsrq(ctx, arg1, v5, arg3);
                // Rule at src/isa/x64/lower.isle line 1551.
                return v48;
            }
            match arg3 {
                0x0 => {
                    let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                    let v49 = constructor_x64_movq_to_xmm(ctx, v5);
                    let v50 = constructor_x64_movsd_regmove(ctx, arg1, v49);
                    // Rule at src/isa/x64/lower.isle line 1554.
                    return v50;
                }
                0x1 => {
                    let v5 = &C::reg_mem_to_gpr_mem(ctx, arg2);
                    let v49 = constructor_x64_movq_to_xmm(ctx, v5);
                    let v51 = &C::xmm_to_xmm_mem(ctx, v49);
                    let v52 = constructor_x64_punpcklqdq(ctx, arg1, v51);
                    // Rule at src/isa/x64/lower.isle line 1556.
                    return v52;
                }
                _ => {}
            }
        }
        F32X4 => {
            let v4 = C::use_sse41(ctx);
            if v4 == true {
                let v53 = &C::reg_mem_to_xmm_mem(ctx, arg2);
                let v54 = C::sse_insertps_lane_imm(ctx, arg3);
                let v55 = constructor_x64_insertps(ctx, arg1, v53, v54);
                // Rule at src/isa/x64/lower.isle line 1560.
                return v55;
            }
            match arg2 {
                &RegMem::Reg { reg: v56 } => {
                    match arg3 {
                        0x0 => {
                            let v57 = C::xmm_new(ctx, v56);
                            let v58 = constructor_x64_movss_regmove(ctx, arg1, v57);
                            // Rule at src/isa/x64/lower.isle line 1565.
                            return v58;
                        }
                        0x1 => {
                            let v57 = C::xmm_new(ctx, v56);
                            let v59 = &C::xmm_to_xmm_mem(ctx, arg1);
                            let v60 = constructor_x64_movlhps(ctx, v57, v59);
                            let v61 = &C::xmm_to_xmm_mem(ctx, arg1);
                            let v62 = constructor_x64_shufps(ctx, v60, v61, 0xE2);
                            // Rule at src/isa/x64/lower.isle line 1571.
                            return v62;
                        }
                        0x2 => {
                            let v57 = C::xmm_new(ctx, v56);
                            let v59 = &C::xmm_to_xmm_mem(ctx, arg1);
                            let v63 = constructor_x64_shufps(ctx, v57, v59, 0x30);
                            let v64 = &C::xmm_to_xmm_mem(ctx, v63);
                            let v65 = constructor_x64_shufps(ctx, arg1, v64, 0x84);
                            // Rule at src/isa/x64/lower.isle line 1578.
                            return v65;
                        }
                        0x3 => {
                            let v57 = C::xmm_new(ctx, v56);
                            let v59 = &C::xmm_to_xmm_mem(ctx, arg1);
                            let v66 = constructor_x64_shufps(ctx, v57, v59, 0xE4);
                            let v67 = &C::xmm_to_xmm_mem(ctx, v66);
                            let v68 = constructor_x64_shufps(ctx, arg1, v67, 0x24);
                            // Rule at src/isa/x64/lower.isle line 1585.
                            return v68;
                        }
                        _ => {}
                    }
                }
                &RegMem::Mem { addr: ref v69 } => {
                    let v71 = constructor_x64_movss_load(ctx, v69);
                    let v72 = C::xmm_to_reg(ctx, v71);
                    let v73 = &constructor_xmm_to_reg_mem(ctx, v72);
                    let v74 = &C::xmm_mem_to_reg_mem(ctx, v73);
                    let v75 = constructor_vec_insert_lane(ctx, F32X4, arg1, v74, arg3);
                    // Rule at src/isa/x64/lower.isle line 1590.
                    return v75;
                }
                _ => {}
            }
        }
        F64X2 => {
            match arg3 {
                0x0 => {
                    match arg2 {
                        &RegMem::Reg { reg: v56 } => {
                            let v57 = C::xmm_new(ctx, v56);
                            let v76 = constructor_x64_movsd_regmove(ctx, arg1, v57);
                            // Rule at src/isa/x64/lower.isle line 1602.
                            return v76;
                        }
                        &RegMem::Mem { addr: ref v69 } => {
                            let v77 = constructor_x64_movsd_load(ctx, v69);
                            let v78 = constructor_x64_movsd_regmove(ctx, arg1, v77);
                            // Rule at src/isa/x64/lower.isle line 1604.
                            return v78;
                        }
                        _ => {}
                    }
                }
                0x1 => {
                    let v53 = &C::reg_mem_to_xmm_mem(ctx, arg2);
                    let v79 = constructor_x64_movlhps(ctx, arg1, v53);
                    // Rule at src/isa/x64/lower.isle line 1612.
                    return v79;
                }
                _ => {}
            }
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "vec_insert_lane", "src/isa/x64/lower.isle line 1470"
    )
}

// Generated as internal constructor for term insert_i8x16_lane_pshufd_imm.
pub fn constructor_insert_i8x16_lane_pshufd_imm<C: Context>(ctx: &mut C, arg0: u8) -> u8 {
    match arg0 {
        0x0 => {
            // Rule at src/isa/x64/lower.isle line 1512.
            return 0x54;
        }
        0x1 => {
            // Rule at src/isa/x64/lower.isle line 1513.
            return 0x51;
        }
        0x2 => {
            // Rule at src/isa/x64/lower.isle line 1514.
            return 0x45;
        }
        0x3 => {
            // Rule at src/isa/x64/lower.isle line 1515.
            return 0x15;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "insert_i8x16_lane_pshufd_imm", "src/isa/x64/lower.isle line 1511"
    )
}

// Generated as internal constructor for term cmp_and_choose.
pub fn constructor_cmp_and_choose<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: Value,
    arg3: Value,
) -> ValueRegs {
    let v1 = C::fits_in_64(ctx, arg0);
    if let Some(v2) = v1 {
        let v6 = &C::raw_operand_size_of_type(ctx, v2);
        let v7 = C::put_in_reg(ctx, arg2);
        let v8 = C::put_in_reg(ctx, arg3);
        let v9 = &constructor_reg_to_gpr_mem_imm(ctx, v7);
        let v10 = C::gpr_new(ctx, v8);
        let v11 = &constructor_x64_cmp(ctx, v6, v9, v10);
        let v12 = &C::reg_to_gpr_mem(ctx, v8);
        let v13 = C::gpr_new(ctx, v7);
        let v14 = &constructor_cmove(ctx, v2, arg1, v12, v13);
        let v15 = constructor_with_flags_reg(ctx, v11, v14);
        let v16 = C::value_reg(ctx, v15);
        // Rule at src/isa/x64/lower.isle line 1620.
        return v16;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "cmp_and_choose", "src/isa/x64/lower.isle line 1619"
    )
}

// Generated as internal constructor for term has_pmins.
pub fn constructor_has_pmins<C: Context>(ctx: &mut C, arg0: Type) -> bool {
    match arg0 {
        I16X8 => {
            // Rule at src/isa/x64/lower.isle line 1646.
            return true;
        }
        I64X2 => {
            // Rule at src/isa/x64/lower.isle line 1647.
            return false;
        }
        _ => {}
    }
    let v3 = C::use_sse41(ctx);
    // Rule at src/isa/x64/lower.isle line 1648.
    return v3;
}

// Generated as internal constructor for term has_pmaxs.
pub fn constructor_has_pmaxs<C: Context>(ctx: &mut C, arg0: Type) -> bool {
    match arg0 {
        I16X8 => {
            // Rule at src/isa/x64/lower.isle line 1651.
            return true;
        }
        I64X2 => {
            // Rule at src/isa/x64/lower.isle line 1652.
            return false;
        }
        _ => {}
    }
    let v3 = C::use_sse41(ctx);
    // Rule at src/isa/x64/lower.isle line 1653.
    return v3;
}

// Generated as internal constructor for term has_pmaxu.
pub fn constructor_has_pmaxu<C: Context>(ctx: &mut C, arg0: Type) -> bool {
    match arg0 {
        I8X16 => {
            // Rule at src/isa/x64/lower.isle line 1656.
            return true;
        }
        I64X2 => {
            // Rule at src/isa/x64/lower.isle line 1657.
            return false;
        }
        _ => {}
    }
    let v3 = C::use_sse41(ctx);
    // Rule at src/isa/x64/lower.isle line 1658.
    return v3;
}

// Generated as internal constructor for term has_pminu.
pub fn constructor_has_pminu<C: Context>(ctx: &mut C, arg0: Type) -> bool {
    match arg0 {
        I8X16 => {
            // Rule at src/isa/x64/lower.isle line 1661.
            return true;
        }
        I64X2 => {
            // Rule at src/isa/x64/lower.isle line 1662.
            return false;
        }
        _ => {}
    }
    let v3 = C::use_sse41(ctx);
    // Rule at src/isa/x64/lower.isle line 1663.
    return v3;
}

// Generated as internal constructor for term lower_vec_smax.
pub fn constructor_lower_vec_smax<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
) -> Xmm {
    let v3 = constructor_has_pmaxs(ctx, arg0);
    if v3 == true {
        let v4 = &C::xmm_to_xmm_mem(ctx, arg2);
        let v5 = constructor_x64_pmaxs(ctx, arg0, arg1, v4);
        // Rule at src/isa/x64/lower.isle line 1671.
        return v5;
    }
    let v4 = &C::xmm_to_xmm_mem(ctx, arg2);
    let v6 = constructor_x64_pcmpgt(ctx, arg0, arg1, v4);
    let v7 = &C::xmm_to_xmm_mem(ctx, arg1);
    let v8 = constructor_x64_pand(ctx, v6, v7);
    let v9 = &C::xmm_to_xmm_mem(ctx, arg2);
    let v10 = constructor_x64_pandn(ctx, v6, v9);
    let v11 = &C::xmm_to_xmm_mem(ctx, v10);
    let v12 = constructor_x64_por(ctx, v8, v11);
    // Rule at src/isa/x64/lower.isle line 1675.
    return v12;
}

// Generated as internal constructor for term flip_high_bit_mask.
pub fn constructor_flip_high_bit_mask<C: Context>(ctx: &mut C, arg0: Type) -> Xmm {
    match arg0 {
        I16X8 => {
            let v2 = C::emit_u128_le_const(ctx, 0x80008000800080008000800080008000);
            let v3 = &constructor_const_to_xmm_mem(ctx, v2);
            let v4 = constructor_x64_movdqu_load(ctx, v3);
            // Rule at src/isa/x64/lower.isle line 1730.
            return v4;
        }
        I32X4 => {
            let v6 = C::emit_u128_le_const(ctx, 0x80000000800000008000000080000000);
            let v7 = &constructor_const_to_xmm_mem(ctx, v6);
            let v8 = constructor_x64_movdqu_load(ctx, v7);
            // Rule at src/isa/x64/lower.isle line 1732.
            return v8;
        }
        I64X2 => {
            let v10 = C::emit_u128_le_const(ctx, 0x80000000000000008000000000000000);
            let v11 = &constructor_const_to_xmm_mem(ctx, v10);
            let v12 = constructor_x64_movdqu_load(ctx, v11);
            // Rule at src/isa/x64/lower.isle line 1734.
            return v12;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "flip_high_bit_mask", "src/isa/x64/lower.isle line 1729"
    )
}

// Generated as internal constructor for term lower_select_fcmp.
pub fn constructor_lower_select_fcmp<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FcmpCondResult,
    arg2: Value,
    arg3: Value,
) -> InstOutput {
    match arg1 {
        &FcmpCondResult::Condition {
            producer: ref v2,
            cc: ref v3,
        } => {
            let v6 = &constructor_cmove_from_values(ctx, arg0, v3, arg2, arg3);
            let v7 = constructor_with_flags(ctx, v2, v6);
            let v8 = C::output(ctx, v7);
            // Rule at src/isa/x64/lower.isle line 2053.
            return v8;
        }
        &FcmpCondResult::OrCondition {
            producer: ref v9,
            cc1: ref v10,
            cc2: ref v11,
        } => {
            let v12 = &constructor_cmove_or_from_values(ctx, arg0, v10, v11, arg2, arg3);
            let v13 = constructor_with_flags(ctx, v9, v12);
            let v14 = C::output(ctx, v13);
            // Rule at src/isa/x64/lower.isle line 2055.
            return v14;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "lower_select_fcmp", "src/isa/x64/lower.isle line 2052"
    )
}

// Generated as internal constructor for term do_clz.
pub fn constructor_do_clz<C: Context>(ctx: &mut C, arg0: Type, arg1: Type, arg2: Gpr) -> Gpr {
    let v5 = constructor_imm_i64(ctx, I64, -0x1);
    let v6 = C::gpr_new(ctx, v5);
    let v7 = constructor_bsr_or_else(ctx, arg0, arg2, v6);
    let v8 = C::gpr_to_reg(ctx, v7);
    let v9 = C::ty_bits_u64(ctx, arg1);
    let v11 = C::u64_sub(ctx, v9, 0x1);
    let v12 = constructor_imm(ctx, arg0, v11);
    let v13 = C::gpr_new(ctx, v12);
    let v14 = &constructor_reg_to_gpr_mem_imm(ctx, v8);
    let v15 = constructor_x64_sub(ctx, arg0, v13, v14);
    // Rule at src/isa/x64/lower.isle line 2126.
    return v15;
}

// Generated as internal constructor for term do_ctz.
pub fn constructor_do_ctz<C: Context>(ctx: &mut C, arg0: Type, arg1: Type, arg2: Gpr) -> Gpr {
    let v4 = C::ty_bits_u64(ctx, arg1);
    let v5 = constructor_imm(ctx, I64, v4);
    let v6 = C::gpr_new(ctx, v5);
    let v7 = constructor_bsf_or_else(ctx, arg0, arg2, v6);
    // Rule at src/isa/x64/lower.isle line 2162.
    return v7;
}

// Generated as internal constructor for term do_popcnt.
pub fn constructor_do_popcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    match arg0 {
        I32 => {
            let v4 = Imm8Reg::Imm8 { imm: 0x1 };
            let v5 = &C::imm8_reg_to_imm8_gpr(ctx, &v4);
            let v47 = constructor_x64_shr(ctx, I32, arg1, v5);
            let v49 = constructor_imm(ctx, I32, 0x77777777);
            let v50 = C::gpr_new(ctx, v49);
            let v51 = &C::gpr_to_gpr_mem_imm(ctx, v50);
            let v52 = constructor_x64_and(ctx, I32, v47, v51);
            let v53 = &C::gpr_to_gpr_mem_imm(ctx, v52);
            let v54 = constructor_x64_sub(ctx, I32, arg1, v53);
            let v14 = &C::imm8_reg_to_imm8_gpr(ctx, &v4);
            let v55 = constructor_x64_shr(ctx, I32, v52, v14);
            let v56 = &C::gpr_to_gpr_mem_imm(ctx, v50);
            let v57 = constructor_x64_and(ctx, I32, v55, v56);
            let v58 = &C::gpr_to_gpr_mem_imm(ctx, v57);
            let v59 = constructor_x64_sub(ctx, I32, v54, v58);
            let v20 = &C::imm8_reg_to_imm8_gpr(ctx, &v4);
            let v60 = constructor_x64_shr(ctx, I32, v57, v20);
            let v61 = &C::gpr_to_gpr_mem_imm(ctx, v50);
            let v62 = constructor_x64_and(ctx, I32, v60, v61);
            let v63 = &C::gpr_to_gpr_mem_imm(ctx, v62);
            let v64 = constructor_x64_sub(ctx, I32, v59, v63);
            let v27 = Imm8Reg::Imm8 { imm: 0x4 };
            let v28 = &C::imm8_reg_to_imm8_gpr(ctx, &v27);
            let v65 = constructor_x64_shr(ctx, I32, v64, v28);
            let v66 = &C::gpr_to_gpr_mem_imm(ctx, v64);
            let v67 = constructor_x64_add(ctx, I32, v65, v66);
            let v69 = RegMemImm::Imm { simm32: 0xF0F0F0F };
            let v70 = &C::gpr_mem_imm_new(ctx, &v69);
            let v71 = constructor_x64_and(ctx, I32, v67, v70);
            let v73 = RegMemImm::Imm { simm32: 0x1010101 };
            let v74 = &C::gpr_mem_imm_new(ctx, &v73);
            let v75 = constructor_x64_mul(ctx, I32, v71, v74);
            let v77 = Imm8Reg::Imm8 { imm: 0x18 };
            let v78 = &C::imm8_reg_to_imm8_gpr(ctx, &v77);
            let v79 = constructor_x64_shr(ctx, I32, v75, v78);
            // Rule at src/isa/x64/lower.isle line 2244.
            return v79;
        }
        I64 => {
            let v4 = Imm8Reg::Imm8 { imm: 0x1 };
            let v5 = &C::imm8_reg_to_imm8_gpr(ctx, &v4);
            let v6 = constructor_x64_shr(ctx, I64, arg1, v5);
            let v8 = constructor_imm(ctx, I64, 0x7777777777777777);
            let v9 = C::gpr_new(ctx, v8);
            let v10 = &C::gpr_to_gpr_mem_imm(ctx, v9);
            let v11 = constructor_x64_and(ctx, I64, v6, v10);
            let v12 = &C::gpr_to_gpr_mem_imm(ctx, v11);
            let v13 = constructor_x64_sub(ctx, I64, arg1, v12);
            let v14 = &C::imm8_reg_to_imm8_gpr(ctx, &v4);
            let v15 = constructor_x64_shr(ctx, I64, v11, v14);
            let v16 = &C::gpr_to_gpr_mem_imm(ctx, v9);
            let v17 = constructor_x64_and(ctx, I64, v15, v16);
            let v18 = &C::gpr_to_gpr_mem_imm(ctx, v17);
            let v19 = constructor_x64_sub(ctx, I64, v13, v18);
            let v20 = &C::imm8_reg_to_imm8_gpr(ctx, &v4);
            let v21 = constructor_x64_shr(ctx, I64, v17, v20);
            let v22 = &C::gpr_to_gpr_mem_imm(ctx, v9);
            let v23 = constructor_x64_and(ctx, I64, v21, v22);
            let v24 = &C::gpr_to_gpr_mem_imm(ctx, v23);
            let v25 = constructor_x64_sub(ctx, I64, v19, v24);
            let v27 = Imm8Reg::Imm8 { imm: 0x4 };
            let v28 = &C::imm8_reg_to_imm8_gpr(ctx, &v27);
            let v29 = constructor_x64_shr(ctx, I64, v25, v28);
            let v30 = &C::gpr_to_gpr_mem_imm(ctx, v25);
            let v31 = constructor_x64_add(ctx, I64, v29, v30);
            let v33 = constructor_imm(ctx, I64, 0xF0F0F0F0F0F0F0F);
            let v34 = C::gpr_new(ctx, v33);
            let v35 = &C::gpr_to_gpr_mem_imm(ctx, v34);
            let v36 = constructor_x64_and(ctx, I64, v31, v35);
            let v38 = constructor_imm(ctx, I64, 0x101010101010101);
            let v39 = C::gpr_new(ctx, v38);
            let v40 = &C::gpr_to_gpr_mem_imm(ctx, v39);
            let v41 = constructor_x64_mul(ctx, I64, v36, v40);
            let v43 = Imm8Reg::Imm8 { imm: 0x38 };
            let v44 = &C::imm8_reg_to_imm8_gpr(ctx, &v43);
            let v45 = constructor_x64_shr(ctx, I64, v41, v44);
            // Rule at src/isa/x64/lower.isle line 2201.
            return v45;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "do_popcnt", "src/isa/x64/lower.isle line 2200"
    )
}

// Generated as internal constructor for term do_bitrev8.
pub fn constructor_do_bitrev8<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v2 = C::ty_mask(ctx, arg0);
    let v4 = C::u64_and(ctx, v2, 0x5555555555555555);
    let v5 = constructor_imm(ctx, arg0, v4);
    let v6 = C::gpr_new(ctx, v5);
    let v7 = &C::gpr_to_gpr_mem_imm(ctx, v6);
    let v8 = constructor_x64_and(ctx, arg0, arg1, v7);
    let v10 = Imm8Reg::Imm8 { imm: 0x1 };
    let v11 = &C::imm8_reg_to_imm8_gpr(ctx, &v10);
    let v12 = constructor_x64_shr(ctx, arg0, arg1, v11);
    let v13 = &C::gpr_to_gpr_mem_imm(ctx, v6);
    let v14 = constructor_x64_and(ctx, arg0, v12, v13);
    let v15 = &C::imm8_reg_to_imm8_gpr(ctx, &v10);
    let v16 = constructor_x64_shl(ctx, arg0, v8, v15);
    let v17 = &C::gpr_to_gpr_mem_imm(ctx, v14);
    let v18 = constructor_x64_or(ctx, arg0, v16, v17);
    let v20 = C::u64_and(ctx, v2, 0x3333333333333333);
    let v21 = constructor_imm(ctx, arg0, v20);
    let v22 = C::gpr_new(ctx, v21);
    let v23 = &C::gpr_to_gpr_mem_imm(ctx, v22);
    let v24 = constructor_x64_and(ctx, arg0, v18, v23);
    let v26 = Imm8Reg::Imm8 { imm: 0x2 };
    let v27 = &C::imm8_reg_to_imm8_gpr(ctx, &v26);
    let v28 = constructor_x64_shr(ctx, arg0, v18, v27);
    let v29 = &C::gpr_to_gpr_mem_imm(ctx, v22);
    let v30 = constructor_x64_and(ctx, arg0, v28, v29);
    let v31 = &C::imm8_reg_to_imm8_gpr(ctx, &v26);
    let v32 = constructor_x64_shl(ctx, arg0, v24, v31);
    let v33 = &C::gpr_to_gpr_mem_imm(ctx, v30);
    let v34 = constructor_x64_or(ctx, arg0, v32, v33);
    let v36 = C::u64_and(ctx, v2, 0xF0F0F0F0F0F0F0F);
    let v37 = constructor_imm(ctx, arg0, v36);
    let v38 = C::gpr_new(ctx, v37);
    let v39 = &C::gpr_to_gpr_mem_imm(ctx, v38);
    let v40 = constructor_x64_and(ctx, arg0, v34, v39);
    let v42 = Imm8Reg::Imm8 { imm: 0x4 };
    let v43 = &C::imm8_reg_to_imm8_gpr(ctx, &v42);
    let v44 = constructor_x64_shr(ctx, arg0, v34, v43);
    let v45 = &C::gpr_to_gpr_mem_imm(ctx, v38);
    let v46 = constructor_x64_and(ctx, arg0, v44, v45);
    let v47 = &C::imm8_reg_to_imm8_gpr(ctx, &v42);
    let v48 = constructor_x64_shl(ctx, arg0, v40, v47);
    let v49 = &C::gpr_to_gpr_mem_imm(ctx, v46);
    let v50 = constructor_x64_or(ctx, arg0, v48, v49);
    // Rule at src/isa/x64/lower.isle line 2338.
    return v50;
}

// Generated as internal constructor for term do_bitrev16.
pub fn constructor_do_bitrev16<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v2 = constructor_do_bitrev8(ctx, arg0, arg1);
    let v3 = C::ty_mask(ctx, arg0);
    let v5 = C::u64_and(ctx, v3, 0xFF00FF00FF00FF);
    let v6 = constructor_imm(ctx, arg0, v5);
    let v7 = C::gpr_new(ctx, v6);
    let v8 = &C::gpr_to_gpr_mem_imm(ctx, v7);
    let v9 = constructor_x64_and(ctx, arg0, v2, v8);
    let v11 = Imm8Reg::Imm8 { imm: 0x8 };
    let v12 = &C::imm8_reg_to_imm8_gpr(ctx, &v11);
    let v13 = constructor_x64_shr(ctx, arg0, v2, v12);
    let v14 = &C::gpr_to_gpr_mem_imm(ctx, v7);
    let v15 = constructor_x64_and(ctx, arg0, v13, v14);
    let v16 = &C::imm8_reg_to_imm8_gpr(ctx, &v11);
    let v17 = constructor_x64_shl(ctx, arg0, v9, v16);
    let v18 = &C::gpr_to_gpr_mem_imm(ctx, v15);
    let v19 = constructor_x64_or(ctx, arg0, v17, v18);
    // Rule at src/isa/x64/lower.isle line 2361.
    return v19;
}

// Generated as internal constructor for term do_bitrev32.
pub fn constructor_do_bitrev32<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    let v2 = constructor_do_bitrev16(ctx, arg0, arg1);
    let v3 = C::ty_mask(ctx, arg0);
    let v5 = C::u64_and(ctx, v3, 0xFFFF0000FFFF);
    let v6 = constructor_imm(ctx, arg0, v5);
    let v7 = C::gpr_new(ctx, v6);
    let v8 = &C::gpr_to_gpr_mem_imm(ctx, v7);
    let v9 = constructor_x64_and(ctx, arg0, v2, v8);
    let v11 = Imm8Reg::Imm8 { imm: 0x10 };
    let v12 = &C::imm8_reg_to_imm8_gpr(ctx, &v11);
    let v13 = constructor_x64_shr(ctx, arg0, v2, v12);
    let v14 = &C::gpr_to_gpr_mem_imm(ctx, v7);
    let v15 = constructor_x64_and(ctx, arg0, v13, v14);
    let v16 = &C::imm8_reg_to_imm8_gpr(ctx, &v11);
    let v17 = constructor_x64_shl(ctx, arg0, v9, v16);
    let v18 = &C::gpr_to_gpr_mem_imm(ctx, v15);
    let v19 = constructor_x64_or(ctx, arg0, v17, v18);
    // Rule at src/isa/x64/lower.isle line 2373.
    return v19;
}

// Generated as internal constructor for term do_bitrev64.
pub fn constructor_do_bitrev64<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Gpr {
    if arg0 == I64 {
        let v2 = constructor_do_bitrev32(ctx, arg0, arg1);
        let v4 = constructor_imm(ctx, arg0, 0xFFFFFFFF);
        let v5 = C::gpr_new(ctx, v4);
        let v6 = &C::gpr_to_gpr_mem_imm(ctx, v5);
        let v7 = constructor_x64_and(ctx, arg0, v2, v6);
        let v9 = Imm8Reg::Imm8 { imm: 0x20 };
        let v10 = &C::imm8_reg_to_imm8_gpr(ctx, &v9);
        let v11 = constructor_x64_shr(ctx, arg0, v2, v10);
        let v12 = &C::imm8_reg_to_imm8_gpr(ctx, &v9);
        let v13 = constructor_x64_shl(ctx, arg0, v7, v12);
        let v14 = &C::gpr_to_gpr_mem_imm(ctx, v11);
        let v15 = constructor_x64_or(ctx, arg0, v13, v14);
        // Rule at src/isa/x64/lower.isle line 2385.
        return v15;
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "do_bitrev64", "src/isa/x64/lower.isle line 2384"
    )
}

// Generated as internal constructor for term fmadd.
pub fn constructor_fmadd<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Value,
    arg2: Value,
    arg3: Value,
) -> Xmm {
    let v24 = C::def_inst(ctx, arg2);
    if let Some(v25) = v24 {
        let v26 = &C::inst_data(ctx, v25);
        if let &InstructionData::Unary {
            opcode: ref v27,
            arg: v28,
        } = v26
        {
            if let &Opcode::Fneg = v27 {
                let v29 = constructor_fnmadd(ctx, arg0, arg1, v28, arg3);
                // Rule at src/isa/x64/lower.isle line 2819.
                return v29;
            }
        }
    }
    let v18 = C::def_inst(ctx, arg1);
    if let Some(v19) = v18 {
        let v20 = &C::inst_data(ctx, v19);
        if let &InstructionData::Unary {
            opcode: ref v21,
            arg: v22,
        } = v20
        {
            if let &Opcode::Fneg = v21 {
                let v23 = constructor_fnmadd(ctx, arg0, v22, arg2, arg3);
                // Rule at src/isa/x64/lower.isle line 2818.
                return v23;
            }
        }
    }
    let v14 = &C::sinkable_load(ctx, arg2);
    if let Some(v15) = v14 {
        let v4 = constructor_put_in_xmm(ctx, arg1);
        let v11 = constructor_put_in_xmm(ctx, arg3);
        let v16 = &constructor_sink_load_to_xmm_mem(ctx, v15);
        let v17 = constructor_x64_vfmadd132(ctx, arg0, v4, v11, v16);
        // Rule at src/isa/x64/lower.isle line 2814.
        return v17;
    }
    let v8 = &C::sinkable_load(ctx, arg1);
    if let Some(v9) = v8 {
        let v10 = constructor_put_in_xmm(ctx, arg2);
        let v11 = constructor_put_in_xmm(ctx, arg3);
        let v12 = &constructor_sink_load_to_xmm_mem(ctx, v9);
        let v13 = constructor_x64_vfmadd132(ctx, arg0, v10, v11, v12);
        // Rule at src/isa/x64/lower.isle line 2813.
        return v13;
    }
    let v4 = constructor_put_in_xmm(ctx, arg1);
    let v5 = constructor_put_in_xmm(ctx, arg2);
    let v6 = &C::put_in_xmm_mem(ctx, arg3);
    let v7 = constructor_x64_vfmadd213(ctx, arg0, v4, v5, v6);
    // Rule at src/isa/x64/lower.isle line 2808.
    return v7;
}

// Generated as internal constructor for term fnmadd.
pub fn constructor_fnmadd<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Value,
    arg2: Value,
    arg3: Value,
) -> Xmm {
    let v24 = C::def_inst(ctx, arg2);
    if let Some(v25) = v24 {
        let v26 = &C::inst_data(ctx, v25);
        if let &InstructionData::Unary {
            opcode: ref v27,
            arg: v28,
        } = v26
        {
            if let &Opcode::Fneg = v27 {
                let v29 = constructor_fmadd(ctx, arg0, arg1, v28, arg3);
                // Rule at src/isa/x64/lower.isle line 2827.
                return v29;
            }
        }
    }
    let v18 = C::def_inst(ctx, arg1);
    if let Some(v19) = v18 {
        let v20 = &C::inst_data(ctx, v19);
        if let &InstructionData::Unary {
            opcode: ref v21,
            arg: v22,
        } = v20
        {
            if let &Opcode::Fneg = v21 {
                let v23 = constructor_fmadd(ctx, arg0, v22, arg2, arg3);
                // Rule at src/isa/x64/lower.isle line 2826.
                return v23;
            }
        }
    }
    let v14 = &C::sinkable_load(ctx, arg2);
    if let Some(v15) = v14 {
        let v4 = constructor_put_in_xmm(ctx, arg1);
        let v11 = constructor_put_in_xmm(ctx, arg3);
        let v16 = &constructor_sink_load_to_xmm_mem(ctx, v15);
        let v17 = constructor_x64_vfnmadd132(ctx, arg0, v4, v11, v16);
        // Rule at src/isa/x64/lower.isle line 2823.
        return v17;
    }
    let v8 = &C::sinkable_load(ctx, arg1);
    if let Some(v9) = v8 {
        let v10 = constructor_put_in_xmm(ctx, arg2);
        let v11 = constructor_put_in_xmm(ctx, arg3);
        let v12 = &constructor_sink_load_to_xmm_mem(ctx, v9);
        let v13 = constructor_x64_vfnmadd132(ctx, arg0, v10, v11, v12);
        // Rule at src/isa/x64/lower.isle line 2822.
        return v13;
    }
    let v4 = constructor_put_in_xmm(ctx, arg1);
    let v5 = constructor_put_in_xmm(ctx, arg2);
    let v6 = &C::put_in_xmm_mem(ctx, arg3);
    let v7 = constructor_x64_vfnmadd213(ctx, arg0, v4, v5, v6);
    // Rule at src/isa/x64/lower.isle line 2821.
    return v7;
}

// Generated as internal constructor for term cmp_zero_i128.
pub fn constructor_cmp_zero_i128<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: ValueRegs,
) -> IcmpCondResult {
    let v1 = &C::cc_nz_or_z(ctx, arg0);
    if let Some(v2) = v1 {
        let v5 = constructor_value_regs_get_gpr(ctx, arg1, 0x0);
        let v7 = constructor_value_regs_get_gpr(ctx, arg1, 0x1);
        let v10 = RegMemImm::Imm { simm32: 0x0 };
        let v11 = &C::gpr_mem_imm_new(ctx, &v10);
        let v12 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v11, v5);
        let v14 = &constructor_x64_setcc(ctx, &CC::Z);
        let v15 = constructor_with_flags_reg(ctx, v12, v14);
        let v16 = C::gpr_new(ctx, v15);
        let v17 = &C::gpr_mem_imm_new(ctx, &v10);
        let v18 = &constructor_x64_cmp(ctx, &OperandSize::Size64, v17, v7);
        let v19 = &constructor_x64_setcc(ctx, &CC::Z);
        let v20 = constructor_with_flags_reg(ctx, v18, v19);
        let v21 = C::gpr_new(ctx, v20);
        let v23 = &C::gpr_to_gpr_mem_imm(ctx, v16);
        let v24 = &constructor_x64_test(ctx, &OperandSize::Size8, v23, v21);
        let v25 = &constructor_icmp_cond_result(ctx, v24, v2);
        // Rule at src/isa/x64/lower.isle line 3295.
        return v25.clone();
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "cmp_zero_i128", "src/isa/x64/lower.isle line 3294"
    )
}

// Generated as internal constructor for term cmp_zero_int_bool_ref.
pub fn constructor_cmp_zero_int_bool_ref<C: Context>(ctx: &mut C, arg0: Value) -> ProducesFlags {
    let v1 = C::value_type(ctx, arg0);
    let v2 = &C::raw_operand_size_of_type(ctx, v1);
    let v3 = constructor_put_in_gpr(ctx, arg0);
    let v4 = &C::gpr_to_gpr_mem_imm(ctx, v3);
    let v5 = &constructor_x64_test(ctx, v2, v4, v3);
    // Rule at src/isa/x64/lower.isle line 3306.
    return v5.clone();
}

// Generated as internal constructor for term lower_swiden_low.
pub fn constructor_lower_swiden_low<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm) -> Xmm {
    match arg0 {
        I16X8 => {
            let v2 = &C::xmm_to_xmm_mem(ctx, arg1);
            let v3 = constructor_x64_punpcklbw(ctx, arg1, v2);
            let v5 = &C::xmi_imm(ctx, 0x8);
            let v6 = constructor_x64_psraw(ctx, v3, v5);
            // Rule at src/isa/x64/lower.isle line 3720.
            return v6;
        }
        I32X4 => {
            let v2 = &C::xmm_to_xmm_mem(ctx, arg1);
            let v7 = constructor_x64_punpcklwd(ctx, arg1, v2);
            let v9 = &C::xmi_imm(ctx, 0x10);
            let v10 = constructor_x64_psrad(ctx, v7, v9);
            // Rule at src/isa/x64/lower.isle line 3722.
            return v10;
        }
        I64X2 => {
            let v12 = constructor_xmm_zero(ctx, I32X4);
            let v13 = &C::xmm_to_xmm_mem(ctx, arg1);
            let v14 = constructor_x64_pcmpgtd(ctx, v12, v13);
            let v15 = &C::xmm_to_xmm_mem(ctx, v14);
            let v16 = constructor_x64_punpckldq(ctx, arg1, v15);
            // Rule at src/isa/x64/lower.isle line 3728.
            return v16;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "lower_swiden_low", "src/isa/x64/lower.isle line 3715"
    )
}

// Generated as internal constructor for term lower_uwiden_low.
pub fn constructor_lower_uwiden_low<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm) -> Xmm {
    match arg0 {
        I16X8 => {
            let v3 = constructor_xmm_zero(ctx, I8X16);
            let v4 = &C::xmm_to_xmm_mem(ctx, v3);
            let v5 = constructor_x64_punpcklbw(ctx, arg1, v4);
            // Rule at src/isa/x64/lower.isle line 3783.
            return v5;
        }
        I32X4 => {
            let v3 = constructor_xmm_zero(ctx, I8X16);
            let v4 = &C::xmm_to_xmm_mem(ctx, v3);
            let v6 = constructor_x64_punpcklwd(ctx, arg1, v4);
            // Rule at src/isa/x64/lower.isle line 3784.
            return v6;
        }
        I64X2 => {
            let v8 = constructor_xmm_zero(ctx, F32X4);
            let v9 = &C::xmm_to_xmm_mem(ctx, v8);
            let v10 = constructor_x64_unpcklps(ctx, arg1, v9);
            // Rule at src/isa/x64/lower.isle line 3785.
            return v10;
        }
        _ => {}
    }
    unreachable!(
        "no rule matched for term {} at {}; should it be partial?",
        "lower_uwiden_low", "src/isa/x64/lower.isle line 3782"
    )
}

// Generated as internal constructor for term unarrow_i32x4_lanes_to_low_u16_lanes.
pub fn constructor_unarrow_i32x4_lanes_to_low_u16_lanes<C: Context>(ctx: &mut C, arg0: Xmm) -> Xmm {
    let v2 = constructor_xmm_zero(ctx, I32X4);
    let v3 = &C::xmm_to_xmm_mem(ctx, v2);
    let v4 = constructor_x64_pcmpgtd(ctx, arg0, v3);
    let v5 = &C::xmm_to_xmm_mem(ctx, v4);
    let v6 = constructor_x64_pand(ctx, arg0, v5);
    let v8 = C::emit_u128_le_const(ctx, 0xFFFF0000FFFF0000FFFF0000FFFF);
    let v9 = &constructor_const_to_xmm_mem(ctx, v8);
    let v10 = constructor_x64_movdqu_load(ctx, v9);
    let v11 = &C::xmm_to_xmm_mem(ctx, v6);
    let v12 = constructor_x64_pcmpgtd(ctx, v10, v11);
    let v13 = &C::xmm_to_xmm_mem(ctx, v12);
    let v14 = constructor_x64_pand(ctx, v6, v13);
    let v15 = &C::xmm_to_xmm_mem(ctx, v10);
    let v16 = constructor_x64_pandn(ctx, v12, v15);
    let v17 = &C::xmm_to_xmm_mem(ctx, v16);
    let v18 = constructor_x64_por(ctx, v14, v17);
    let v19 = &C::xmm_to_xmm_mem(ctx, v18);
    let v21 = constructor_x64_pshuflw(ctx, v19, 0x8);
    let v22 = &C::xmm_to_xmm_mem(ctx, v21);
    let v23 = constructor_x64_pshufhw(ctx, 