
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kxmlguiwindow_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "kmainwindow_wrapper.h"
#include "kxmlguibuilder_wrapper.h"
#include "kshortcutsdialog_wrapper.h"
#include "kxmlguiclient_wrapper.h"
#include "ktoolbar_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <kactioncollection.h>
#include <kxmlguiclient.h>
#include <kxmlguifactory.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KXmlGuiWindow_Type = nullptr;
static PyTypeObject *Sbk_KXmlGuiWindow_TypeF(void)
{
    return _Sbk_KXmlGuiWindow_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KXmlGuiWindowWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KXmlGuiWindowWrapper::KXmlGuiWindowWrapper(::QWidget * parent, ::QFlags<Qt::WindowType> flags) : KXmlGuiWindow(parent, flags)
{
}

::KActionCollection * KXmlGuiWindowWrapper::actionCollection() const
{
    static const char *funcName = "actionCollection";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::actionCollection();
    }
    return KXMLGUIClientWrapper::sbk_o_actionCollection("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KToolBarWrapper::sbk_o_actionEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KToolBarWrapper::sbk_o_changeEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::closeEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_closeEvent("KXmlGuiWindow", funcName, gil, pyOverride, arg__1);
}

::QString KXmlGuiWindowWrapper::componentName() const
{
    static const char *funcName = "componentName";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::componentName();
    }
    return KXMLGUIClientWrapper::sbk_o_componentName("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::configureToolbars()
{
    static const char *funcName = "configureToolbars";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXmlGuiWindow::configureToolbars();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KXmlGuiWindow", funcName, gil, pyOverride, signal);
}

::QStringList KXmlGuiWindowWrapper::containerTags() const
{
    static const char *funcName = "containerTags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIBuilder::containerTags();
    }
    return KXMLGUIBuilderWrapper::sbk_o_containerTags("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMainWindow::contextMenuEvent(event);
    }
    KToolBarWrapper::sbk_o_contextMenuEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

::QMenu * KXmlGuiWindowWrapper::createPopupMenu()
{
    static const char *funcName = "createPopupMenu";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMainWindow::createPopupMenu();
    }
    return KMainWindowWrapper::sbk_o_createPopupMenu("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

::QStringList KXmlGuiWindowWrapper::customTags() const
{
    static const char *funcName = "customTags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIBuilder::customTags();
    }
    return KXMLGUIBuilderWrapper::sbk_o_containerTags("KXmlGuiWindow", funcName, gil, pyOverride);
}

int KXmlGuiWindowWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KToolBarWrapper::sbk_o_devType("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KXmlGuiWindow", funcName, gil, pyOverride, signal);
}

void KXmlGuiWindowWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KToolBarWrapper::sbk_o_dragEnterEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragLeaveEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragMoveEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KToolBarWrapper::sbk_o_dropEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KToolBarWrapper::sbk_o_enterEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

bool KXmlGuiWindowWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXmlGuiWindow::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

bool KXmlGuiWindowWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KXmlGuiWindow", funcName, gil, pyOverride, watched, event);
}

void KXmlGuiWindowWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KToolBarWrapper::sbk_o_focusInEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

bool KXmlGuiWindowWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KToolBarWrapper::sbk_o_focusNextPrevChild("KXmlGuiWindow", funcName, gil, pyOverride, next);
}

void KXmlGuiWindowWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KToolBarWrapper::sbk_o_focusOutEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

::KXMLGUIFactory * KXmlGuiWindowWrapper::guiFactory()
{
    static const char *funcName = "guiFactory";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXmlGuiWindow::guiFactory();
    }
    return sbk_o_guiFactory("KXmlGuiWindow", funcName, gil, pyOverride);
}

::KXMLGUIFactory * KXmlGuiWindowWrapper::sbk_o_guiFactory(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< KXMLGUIFactory >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::KXMLGUIFactory *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KXmlGuiWindowWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KXmlGuiWindow", funcName, gil, pyOverride);
}

int KXmlGuiWindowWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KToolBarWrapper::sbk_o_heightForWidth("KXmlGuiWindow", funcName, gil, pyOverride, arg__1);
}

void KXmlGuiWindowWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KToolBarWrapper::sbk_o_hideEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KToolBarWrapper::sbk_o_initPainter("KXmlGuiWindow", funcName, gil, pyOverride, painter);
}

void KXmlGuiWindowWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KToolBarWrapper::sbk_o_inputMethodEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

::QVariant KXmlGuiWindowWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KToolBarWrapper::sbk_o_inputMethodQuery("KXmlGuiWindow", funcName, gil, pyOverride, arg__1);
}

void KXmlGuiWindowWrapper::keyPressEvent(::QKeyEvent * keyEvent)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::keyPressEvent(keyEvent);
    }
    KToolBarWrapper::sbk_o_keyPressEvent("KXmlGuiWindow", funcName, gil, pyOverride, keyEvent);
}

void KXmlGuiWindowWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_keyReleaseEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KToolBarWrapper::sbk_o_leaveEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

::QString KXmlGuiWindowWrapper::localXMLFile() const
{
    static const char *funcName = "localXMLFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::localXMLFile();
    }
    return KXMLGUIClientWrapper::sbk_o_componentName("KXmlGuiWindow", funcName, gil, pyOverride);
}

int KXmlGuiWindowWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KToolBarWrapper::sbk_o_metric("KXmlGuiWindow", funcName, gil, pyOverride, arg__1);
}

::QSize KXmlGuiWindowWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseDoubleClickEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseMoveEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KToolBarWrapper::sbk_o_mousePressEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseReleaseEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KToolBarWrapper::sbk_o_moveEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

bool KXmlGuiWindowWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KToolBarWrapper::sbk_o_nativeEvent("KXmlGuiWindow", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KXmlGuiWindowWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KToolBarWrapper::sbk_o_paintEngine("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KToolBarWrapper::sbk_o_paintEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

bool KXmlGuiWindowWrapper::queryClose()
{
    static const char *funcName = "queryClose";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::queryClose();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KXmlGuiWindow", funcName, gil, pyOverride);
}

::QPaintDevice * KXmlGuiWindowWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KToolBarWrapper::sbk_o_redirected("KXmlGuiWindow", funcName, gil, pyOverride, offset);
}

void KXmlGuiWindowWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KToolBarWrapper::sbk_o_resizeEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::saveNewToolbarConfig()
{
    static const char *funcName = "saveNewToolbarConfig";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXmlGuiWindow::saveNewToolbarConfig();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::setCaption(const ::QString & caption)
{
    static const char *funcName = "setCaption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::setCaption(caption);
    }
    KXMLGUIClientWrapper::sbk_o_setLocalXMLFile("KXmlGuiWindow", funcName, gil, pyOverride, caption);
}

void KXmlGuiWindowWrapper::setCaption(const ::QString & caption, bool modified)
{
    static const char *funcName = "setCaption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::setCaption(caption, modified);
    }
    KXMLGUIClientWrapper::sbk_o_setXML("KXmlGuiWindow", funcName, gil, pyOverride, caption, modified);
}

void KXmlGuiWindowWrapper::setComponentName(const ::QString & componentName, const ::QString & componentDisplayName)
{
    static const char *funcName = "setComponentName";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[52], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setComponentName(componentName, componentDisplayName);
    }
    KXMLGUIClientWrapper::sbk_o_setComponentName("KXmlGuiWindow", funcName, gil, pyOverride, componentName, componentDisplayName);
}

void KXmlGuiWindowWrapper::setLocalXMLFile(const ::QString & file)
{
    static const char *funcName = "setLocalXMLFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[53], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setLocalXMLFile(file);
    }
    KXMLGUIClientWrapper::sbk_o_setLocalXMLFile("KXmlGuiWindow", funcName, gil, pyOverride, file);
}

void KXmlGuiWindowWrapper::setPlainCaption(const ::QString & caption)
{
    static const char *funcName = "setPlainCaption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[54], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMainWindow::setPlainCaption(caption);
    }
    KXMLGUIClientWrapper::sbk_o_setLocalXMLFile("KXmlGuiWindow", funcName, gil, pyOverride, caption);
}

void KXmlGuiWindowWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[55], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KToolBarWrapper::sbk_o_setVisible("KXmlGuiWindow", funcName, gil, pyOverride, visible);
}

void KXmlGuiWindowWrapper::setXML(const ::QString & document, bool merge)
{
    static const char *funcName = "setXML";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[56], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setXML(document, merge);
    }
    KXMLGUIClientWrapper::sbk_o_setXML("KXmlGuiWindow", funcName, gil, pyOverride, document, merge);
}

void KXmlGuiWindowWrapper::setXMLFile(const ::QString & file, bool merge, bool setXMLDoc)
{
    static const char *funcName = "setXMLFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[57], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::setXMLFile(file, merge, setXMLDoc);
    }
    KXMLGUIClientWrapper::sbk_o_setXMLFile("KXmlGuiWindow", funcName, gil, pyOverride, file, merge, setXMLDoc);
}

::QPainter * KXmlGuiWindowWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[58], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KToolBarWrapper::sbk_o_sharedPainter("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[59], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KToolBarWrapper::sbk_o_showEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

::QSize KXmlGuiWindowWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[60], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KXmlGuiWindow", funcName, gil, pyOverride);
}

void KXmlGuiWindowWrapper::slotStateChanged(const ::QString & newstate)
{
    static const char *funcName = "slotStateChanged";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[61], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXmlGuiWindow::slotStateChanged(newstate);
    }
    KXMLGUIClientWrapper::sbk_o_setLocalXMLFile("KXmlGuiWindow", funcName, gil, pyOverride, newstate);
}

void KXmlGuiWindowWrapper::stateChanged(const ::QString & newstate, ::KXMLGUIClient::ReverseStateChange reverse)
{
    static const char *funcName = "stateChanged";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[62], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::stateChanged(newstate, reverse);
    }
    KXMLGUIClientWrapper::sbk_o_stateChanged("KXmlGuiWindow", funcName, gil, pyOverride, newstate, reverse);
}

void KXmlGuiWindowWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[63], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KToolBarWrapper::sbk_o_tabletEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[64], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

void KXmlGuiWindowWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[65], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KToolBarWrapper::sbk_o_wheelEvent("KXmlGuiWindow", funcName, gil, pyOverride, event);
}

::QString KXmlGuiWindowWrapper::xmlFile() const
{
    static const char *funcName = "xmlFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXmlGuiWindow_TypeF(), gil, funcName, m_PyMethodCache[66], nameCache));
    if (pyOverride.isNull()) {
        return this->::KXMLGUIClient::xmlFile();
    }
    return KXMLGUIClientWrapper::sbk_o_componentName("KXmlGuiWindow", funcName, gil, pyOverride);
}

const QMetaObject *KXmlGuiWindowWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KXmlGuiWindow::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KXmlGuiWindowWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KXmlGuiWindow::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KXmlGuiWindowWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KXmlGuiWindowWrapper *>(this));
    }
    return KXmlGuiWindow::qt_metacast(_clname);
}

KXmlGuiWindowWrapper::~KXmlGuiWindowWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KXmlGuiWindow_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KXmlGuiWindow_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
    if (type != myType)
        Shiboken::ObjectType::copyMultipleInheritance(type, myType);

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KXmlGuiWindow >()))
        return -1;

    KXmlGuiWindowWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KXmlGuiWindow", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KXmlGuiWindow::KXmlGuiWindow(QWidget*=,QFlags<Qt::WindowType>=)
    if (numArgs == 0) {
        overloadId = 0; // KXmlGuiWindow(QWidget*,QFlags<Qt::WindowType>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KXmlGuiWindow(QWidget*,QFlags<Qt::WindowType>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // KXmlGuiWindow(QWidget*,QFlags<Qt::WindowType>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 0}, {"flags", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::WindowType> cppArg1 = Qt::WindowFlags();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KXmlGuiWindow(QWidget*,QFlags<Qt::WindowType>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KXmlGuiWindowWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KXmlGuiWindowWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KXmlGuiWindow >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KXmlGuiWindowFunc_checkAmbiguousShortcuts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // checkAmbiguousShortcuts()
        cppSelf->checkAmbiguousShortcuts();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_configureToolbars(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // configureToolbars()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KXmlGuiWindow::configureToolbars()
            : cppSelf->configureToolbars();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_createGUI(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "createGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    if (PyArg_ParseTuple(args, "|O:createGUI", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXmlGuiWindow::createGUI(const QString&=)
    if (numArgs == 0) {
        overloadId = 0; // createGUI(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // createGUI(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"xmlfile", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "createGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createGUI(QString)
            cppSelf->createGUI(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_createStandardStatusBarAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // createStandardStatusBarAction()
        cppSelf->createStandardStatusBarAction();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KXmlGuiWindow::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXmlGuiWindowFunc_finalizeGUI(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXmlGuiWindow::finalizeGUI(bool)
    // 1: KXMLGUIBuilder::finalizeGUI(KXMLGUIClient*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArg)))) {
        overloadId = 1; // finalizeGUI(KXMLGUIClient*)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // finalizeGUI(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "finalizeGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // finalizeGUI(bool force)
        {
            bool cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // finalizeGUI(bool)
                cppSelf->finalizeGUI(cppArg0);
            }
            break;
        }
        case 1: // finalizeGUI(KXMLGUIClient *client)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::KXMLGUIClient *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // finalizeGUI(KXMLGUIClient*)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? reinterpret_cast<KXMLGUIBuilder *>(cppSelf)->::KXMLGUIBuilder::finalizeGUI(cppArg0)
                    : reinterpret_cast<KXMLGUIBuilder *>(cppSelf)->finalizeGUI(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_guiFactory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // guiFactory()
        KXMLGUIFactory * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KXmlGuiWindow::guiFactory()
            : cppSelf->guiFactory();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXmlGuiWindowFunc_isCommandBarEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isCommandBarEnabled()const
        bool cppResult = const_cast<const ::KXmlGuiWindow *>(cppSelf)->isCommandBarEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXmlGuiWindowFunc_isHelpMenuEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isHelpMenuEnabled()const
        bool cppResult = const_cast<const ::KXmlGuiWindow *>(cppSelf)->isHelpMenuEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXmlGuiWindowFunc_isStandardToolBarMenuEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isStandardToolBarMenuEnabled()const
        bool cppResult = const_cast<const ::KXmlGuiWindow *>(cppSelf)->isStandardToolBarMenuEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXmlGuiWindowFunc_isToolBarVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXmlGuiWindow::isToolBarVisible(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // isToolBarVisible(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isToolBarVisible", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isToolBarVisible(QString)
            bool cppResult = cppSelf->isToolBarVisible(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXmlGuiWindowFunc_saveNewToolbarConfig(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveNewToolbarConfig()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KXmlGuiWindow::saveNewToolbarConfig()
            : cppSelf->saveNewToolbarConfig();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_setCommandBarEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXmlGuiWindow::setCommandBarEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCommandBarEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCommandBarEnabled", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCommandBarEnabled(bool)
            cppSelf->setCommandBarEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_setHelpMenuEnabled(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setHelpMenuEnabled", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    if (PyArg_ParseTuple(args, "|O:setHelpMenuEnabled", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXmlGuiWindow::setHelpMenuEnabled(bool=)
    if (numArgs == 0) {
        overloadId = 0; // setHelpMenuEnabled(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setHelpMenuEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setHelpMenuEnabled", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"showHelpMenu", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setHelpMenuEnabled", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHelpMenuEnabled(bool)
            cppSelf->setHelpMenuEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_setStandardToolBarMenuEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXmlGuiWindow::setStandardToolBarMenuEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStandardToolBarMenuEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStandardToolBarMenuEnabled", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStandardToolBarMenuEnabled(bool)
            cppSelf->setStandardToolBarMenuEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_setToolBarVisible(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setToolBarVisible", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXmlGuiWindow::setToolBarVisible(QString,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setToolBarVisible(QString,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setToolBarVisible", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolBarVisible(QString,bool)
            cppSelf->setToolBarVisible(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_setupGUI(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setupGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setupGUI", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXmlGuiWindow::setupGUI(QFlags<KXmlGuiWindow::StandardWindowOption>=,const QString&=)
    // 1: KXmlGuiWindow::setupGUI(QSize,QFlags<KXmlGuiWindow::StandardWindowOption>=,const QString&=)
    if (numArgs == 0) {
        overloadId = 0; // setupGUI(QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setupGUI(QSize,QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KXmlGuiWindow_StandardWindowOption_IDX])))->flagsConverter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // setupGUI(QSize,QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                overloadId = 1; // setupGUI(QSize,QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KXmlGuiWindow_StandardWindowOption_IDX])))->flagsConverter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setupGUI(QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setupGUI(QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setupGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setupGUI(QFlags<KXmlGuiWindow::StandardWindowOption> options, const QString &xmlfile)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"options", 0}, {"xmlfile", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KXmlGuiWindow_StandardWindowOption_IDX])))->flagsConverter, (pyArgs[0]))))
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "setupGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
                }
            }
            ::QFlags<KXmlGuiWindow::StandardWindowOption> cppArg0(KXmlGuiWindow::StandardWindowOption::Default);
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setupGUI(QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
                cppSelf->setupGUI(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setupGUI(const QSize &defaultSize, QFlags<KXmlGuiWindow::StandardWindowOption> options, const QString &xmlfile)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"options", 1}, {"xmlfile", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KXmlGuiWindow_StandardWindowOption_IDX])))->flagsConverter, (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "setupGUI", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<KXmlGuiWindow::StandardWindowOption> cppArg1(KXmlGuiWindow::StandardWindowOption::Default);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setupGUI(QSize,QFlags<KXmlGuiWindow::StandardWindowOption>,QString)
                cppSelf->setupGUI(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_setupToolbarMenuActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setupToolbarMenuActions()
        cppSelf->setupToolbarMenuActions();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_slotStateChanged(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "slotStateChanged", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXmlGuiWindow::slotStateChanged(QString)
    // 1: KXmlGuiWindow::slotStateChanged(QString,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // slotStateChanged(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 1; // slotStateChanged(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "slotStateChanged", errInfo, SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // slotStateChanged(const QString &newstate)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // slotStateChanged(QString)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::KXmlGuiWindow::slotStateChanged(cppArg0)
                    : cppSelf->slotStateChanged(cppArg0);
            }
            break;
        }
        case 1: // slotStateChanged(const QString &newstate, bool reverse)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // slotStateChanged(QString,bool)
                cppSelf->slotStateChanged(cppArg0, cppArg1);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXmlGuiWindowFunc_toolBarMenuAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolBarMenuAction()
        QAction * cppResult = cppSelf->toolBarMenuAction();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXmlGuiWindowFunc_toolBarNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolBarNames()const
        QStringList cppResult = const_cast<const ::KXmlGuiWindow *>(cppSelf)->toolBarNames();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KXmlGuiWindow_PropertyStrings[] = {
    "autoSaveGroup:",
    "autoSaveSettings:",
    "hasMenuBar:",
    "standardToolBarMenuEnabled:isStandardToolBarMenuEnabled:",
    "toolBars:toolBarNames",
    nullptr // Sentinel
};

static const char *Sbk_KXmlGuiWindow_EnumFlagInfo[] = {
    "StandardWindowOption:IntFlag:StandardWindowOptions",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KXmlGuiWindow_methods[] = {
    {"checkAmbiguousShortcuts", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_checkAmbiguousShortcuts), METH_NOARGS, nullptr},
    {"configureToolbars", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_configureToolbars), METH_NOARGS, nullptr},
    {"createGUI", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_createGUI), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"createStandardStatusBarAction", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_createStandardStatusBarAction), METH_NOARGS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_event), METH_O, nullptr},
    {"finalizeGUI", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_finalizeGUI), METH_O, nullptr},
    {"guiFactory", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_guiFactory), METH_NOARGS, nullptr},
    {"isCommandBarEnabled", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_isCommandBarEnabled), METH_NOARGS, nullptr},
    {"isHelpMenuEnabled", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_isHelpMenuEnabled), METH_NOARGS, nullptr},
    {"isStandardToolBarMenuEnabled", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_isStandardToolBarMenuEnabled), METH_NOARGS, nullptr},
    {"isToolBarVisible", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_isToolBarVisible), METH_O, nullptr},
    {"saveNewToolbarConfig", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_saveNewToolbarConfig), METH_NOARGS, nullptr},
    {"setCommandBarEnabled", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_setCommandBarEnabled), METH_O, nullptr},
    {"setHelpMenuEnabled", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_setHelpMenuEnabled), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setStandardToolBarMenuEnabled", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_setStandardToolBarMenuEnabled), METH_O, nullptr},
    {"setToolBarVisible", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_setToolBarVisible), METH_VARARGS, nullptr},
    {"setupGUI", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_setupGUI), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setupToolbarMenuActions", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_setupToolbarMenuActions), METH_NOARGS, nullptr},
    {"slotStateChanged", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_slotStateChanged), METH_VARARGS, nullptr},
    {"toolBarMenuAction", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_toolBarMenuAction), METH_NOARGS, nullptr},
    {"toolBarNames", reinterpret_cast<PyCFunction>(Sbk_KXmlGuiWindowFunc_toolBarNames), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KXmlGuiWindow_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KXmlGuiWindow *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KXmlGuiWindowWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KXmlGuiWindow_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KXmlGuiWindow_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
int *
Sbk_KXmlGuiWindow_mi_init(const void *cptr)
{
    static int mi_offsets[] = {-2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    if (mi_offsets[0] == -2) {
        const auto *class_ptr = reinterpret_cast<const KXmlGuiWindow *>(cptr);
        const auto base = reinterpret_cast<uintptr_t>(class_ptr);
        int *p = mi_offsets;
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const KMainWindow *>(class_ptr)) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const KMainWindow *>(static_cast<const KXmlGuiWindow *>(static_cast<const void *>(class_ptr)))) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const KXMLGUIBuilder *>(class_ptr)) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const KXMLGUIBuilder *>(static_cast<const KXmlGuiWindow *>(static_cast<const void *>(class_ptr)))) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const KXMLGUIClient *>(class_ptr)) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const KXMLGUIClient *>(static_cast<const KXmlGuiWindow *>(static_cast<const void *>(class_ptr)))) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QMainWindow *>(class_ptr)) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QMainWindow *>(static_cast<const KMainWindow *>(static_cast<const void *>(class_ptr)))) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QWidget *>(class_ptr)) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QWidget *>(static_cast<const QMainWindow *>(static_cast<const void *>(class_ptr)))) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(class_ptr)) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(static_cast<const QWidget *>(static_cast<const void *>(class_ptr)))) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QPaintDevice *>(class_ptr)) - base);
        *p++ = int(reinterpret_cast<uintptr_t>(static_cast<const QPaintDevice *>(static_cast<const QWidget *>(static_cast<const void *>(class_ptr)))) - base);
        std::sort(mi_offsets, p);
        auto *end = std::unique(mi_offsets, p);
        *end++ = -1;
        if (mi_offsets[0] == 0)
            std::memmove(&mi_offsets[0], &mi_offsets[1], (end - mi_offsets  - 1) * sizeof(int));
    }
    return mi_offsets;
}
static void * Sbk_KXmlGuiWindowSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KXmlGuiWindow *>(obj);
    if (desiredType == Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]))
        return static_cast< ::KMainWindow *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX]))
        return static_cast< ::QMainWindow *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    else if (desiredType == Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]))
        return static_cast< ::KXMLGUIBuilder *>(me);
    else if (desiredType == Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]))
        return static_cast< ::KXMLGUIClient *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KXmlGuiWindow_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KXmlGuiWindow_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KXmlGuiWindow_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KXmlGuiWindow_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KXmlGuiWindow_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KXmlGuiWindow_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KXmlGuiWindow_spec = {
    "1:KXmlGui.KXmlGuiWindow",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KXmlGuiWindow_slots
};

} //extern "C"

static void *Sbk_KXmlGuiWindow_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KXmlGuiWindow *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KXmlGuiWindow *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KXmlGuiWindow *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    if (instanceType == Shiboken::SbkType< ::KXMLGUIBuilder >())
        return dynamic_cast< ::KXmlGuiWindow *>(reinterpret_cast< ::KXMLGUIBuilder *>(cptr));
    if (instanceType == Shiboken::SbkType< ::KXMLGUIClient >())
        return dynamic_cast< ::KXmlGuiWindow *>(reinterpret_cast< ::KXMLGUIClient *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KXmlGuiWindow_StandardWindowOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KXmlGuiWindow::StandardWindowOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KXmlGuiWindow::StandardWindowOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KXmlGuiWindow_StandardWindowOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_StandardWindowOption_IDX])))
        return Enum_PythonToCpp_KXmlGuiWindow_StandardWindowOption;
    return {};
}

static PyObject *KXmlGuiWindow_StandardWindowOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KXmlGuiWindow::StandardWindowOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KXmlGuiWindow::StandardWindowOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KXmlGuiWindow_StandardWindowOption(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KXmlGuiWindow::StandardWindowOption>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KXmlGuiWindow::StandardWindowOption> *>(cppOut) = value;

}

static PyObject *KXmlGuiWindow_StandardWindowOption_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KXmlGuiWindow::StandardWindowOption> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_StandardWindowOption_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KXmlGuiWindow_PythonToCpp_KXmlGuiWindow_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KXmlGuiWindow_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KXmlGuiWindow_PythonToCpp_KXmlGuiWindow_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KXmlGuiWindow_TypeF()))
        return KXmlGuiWindow_PythonToCpp_KXmlGuiWindow_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KXmlGuiWindow_PTR_CppToPython_KXmlGuiWindow(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KXmlGuiWindow *>(const_cast<void *>(cppIn)), Sbk_KXmlGuiWindow_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KXmlGuiWindow_SignatureStrings[] = {
    "KXmlGui.KXmlGuiWindow(self,parent:PySide6.QtWidgets.QWidget=nullptr,flags:PySide6.QtCore.Qt.WindowType=Qt.WindowFlags(),*:KeywordOnly=None,hasMenuBar:bool=None,autoSaveSettings:bool=None,autoSaveGroup:QString=None,standardToolBarMenuEnabled:bool=None,toolBars:QStringList=None)",
    "KXmlGui.KXmlGuiWindow.checkAmbiguousShortcuts(self)",
    "KXmlGui.KXmlGuiWindow.configureToolbars(self)",
    "KXmlGui.KXmlGuiWindow.createGUI(self,xmlfile:QString=QString())",
    "KXmlGui.KXmlGuiWindow.createStandardStatusBarAction(self)",
    "KXmlGui.KXmlGuiWindow.event(self,event:PySide6.QtCore.QEvent)->bool",
    "1:KXmlGui.KXmlGuiWindow.finalizeGUI(self,force:bool)",
    "0:KXmlGui.KXmlGuiWindow.finalizeGUI(self,client:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXmlGuiWindow.guiFactory(self)->KXmlGui.KXMLGUIFactory",
    "KXmlGui.KXmlGuiWindow.isCommandBarEnabled(self)->bool",
    "KXmlGui.KXmlGuiWindow.isHelpMenuEnabled(self)->bool",
    "KXmlGui.KXmlGuiWindow.isStandardToolBarMenuEnabled(self)->bool",
    "KXmlGui.KXmlGuiWindow.isToolBarVisible(self,name:QString)->bool",
    "KXmlGui.KXmlGuiWindow.saveNewToolbarConfig(self)",
    "KXmlGui.KXmlGuiWindow.setCommandBarEnabled(self,showCommandBar:bool)",
    "KXmlGui.KXmlGuiWindow.setHelpMenuEnabled(self,showHelpMenu:bool=true)",
    "KXmlGui.KXmlGuiWindow.setStandardToolBarMenuEnabled(self,showToolBarMenu:bool)",
    "KXmlGui.KXmlGuiWindow.setToolBarVisible(self,name:QString,visible:bool)",
    "1:KXmlGui.KXmlGuiWindow.setupGUI(self,options:KXmlGui.KXmlGuiWindow.StandardWindowOption=KXmlGuiWindow.StandardWindowOption.Default,xmlfile:QString=QString())",
    "0:KXmlGui.KXmlGuiWindow.setupGUI(self,defaultSize:PySide6.QtCore.QSize,options:KXmlGui.KXmlGuiWindow.StandardWindowOption=KXmlGuiWindow.StandardWindowOption.Default,xmlfile:QString=QString())",
    "KXmlGui.KXmlGuiWindow.setupToolbarMenuActions(self)",
    "1:KXmlGui.KXmlGuiWindow.slotStateChanged(self,newstate:QString)",
    "0:KXmlGui.KXmlGuiWindow.slotStateChanged(self,newstate:QString,reverse:bool)",
    "KXmlGui.KXmlGuiWindow.toolBarMenuAction(self)->PySide6.QtGui.QAction",
    "KXmlGui.KXmlGuiWindow.toolBarNames(self)->QStringList",
    nullptr}; // Sentinel
#else
static constexpr size_t KXmlGuiWindow_SignatureByteSize = 553;
static constexpr uint8_t KXmlGuiWindow_SignatureBytes[553] = {
    0x78, 0xda, 0xc5, 0x55, 0xc1, 0x8e, 0x9b, 0x30, 0x10, 0xbd, 0xe7, 0x4b, 0x92, 0x8a, 0xa0, 0xed,
    0xa5, 0x07, 0xa4, 0x44, 0xda, 0xd2, 0xdd, 0xb4, 0xca, 0x6e, 0xb6, 0x11, 0xbb, 0xdd, 0x5e, 0x1d,
    0x18, 0xc0, 0xaa, 0xb1, 0x91, 0x3d, 0x0e, 0xa5, 0x5f, 0x5f, 0x1b, 0x43, 0x40, 0x4d, 0x20, 0xb9,
    0xf5, 0x64, 0xe2, 0x99, 0xf7, 0x3c, 0xf3, 0xe6, 0xd9, 0xd9, 0xfe, 0x2c, 0xd8, 0x46, 0x53, 0x7f,
    0xeb, 0xd6, 0x77, 0xca, 0x13, 0x51, 0xcd, 0x15, 0xb0, 0xd4, 0x2b, 0x89, 0x04, 0x8e, 0xc1, 0xf7,
    0x3a, 0xa2, 0x09, 0x7c, 0xf2, 0xf7, 0xf8, 0x4e, 0x93, 0x0c, 0x50, 0xf9, 0x7b, 0xf7, 0xb1, 0xe2,
    0x9a, 0xb1, 0x12, 0xa5, 0x97, 0x32, 0x92, 0xa9, 0x41, 0x5e, 0x28, 0x24, 0x98, 0xc5, 0x77, 0x64,
    0xaf, 0x75, 0x09, 0xab, 0xd3, 0xaf, 0x47, 0x9b, 0x3b, 0x5f, 0x78, 0x1f, 0x82, 0x2d, 0xd4, 0x95,
    0x90, 0xc9, 0x0b, 0x67, 0xf5, 0x6a, 0x27, 0x38, 0x78, 0x39, 0x51, 0xcf, 0xc0, 0xf5, 0x67, 0x22,
    0x83, 0x83, 0x10, 0xcc, 0x6d, 0x12, 0x8d, 0x22, 0x22, 0x47, 0x88, 0x00, 0x91, 0x72, 0x73, 0xcc,
    0x79, 0x68, 0x23, 0x85, 0x2e, 0x83, 0x7d, 0x84, 0xd2, 0x24, 0xb8, 0x90, 0x42, 0xc2, 0x13, 0x22,
    0x93, 0x57, 0x93, 0x6c, 0xf8, 0x2c, 0xed, 0x03, 0x27, 0x07, 0x06, 0xc9, 0x00, 0x8f, 0x2e, 0xa8,
    0x3a, 0xe8, 0x13, 0x55, 0xd8, 0x44, 0x16, 0xb3, 0xed, 0x25, 0x55, 0xfc, 0x38, 0x87, 0xf8, 0xd7,
    0x7d, 0x71, 0xa0, 0x99, 0x16, 0x5a, 0x45, 0xb9, 0x90, 0x18, 0x6b, 0x54, 0x8d, 0x5a, 0xa3, 0x18,
    0xc1, 0x53, 0x93, 0x2f, 0xc1, 0x96, 0x72, 0x30, 0xa7, 0x4d, 0x67, 0x4b, 0x20, 0x08, 0x9b, 0xb7,
    0x6f, 0x6e, 0x02, 0xbf, 0x0b, 0x96, 0x52, 0x06, 0xa7, 0xde, 0xda, 0x75, 0xbe, 0x98, 0xc6, 0x47,
    0x6d, 0xf7, 0x66, 0x45, 0xad, 0x4c, 0x8b, 0xf7, 0x31, 0x52, 0xc1, 0x27, 0x4f, 0x86, 0xa3, 0x99,
    0xb5, 0x3b, 0xb5, 0xf9, 0x3c, 0x1b, 0xe7, 0x83, 0xdd, 0x5d, 0x2c, 0xd7, 0x56, 0xbf, 0xd9, 0xc7,
    0xe0, 0x32, 0x4b, 0x4a, 0x39, 0x61, 0xf4, 0x4f, 0xdf, 0x41, 0x2a, 0x64, 0x0c, 0x8d, 0xe6, 0x8b,
    0xd9, 0xdd, 0xad, 0xa0, 0x98, 0x51, 0x5b, 0x41, 0x9f, 0xfd, 0xfc, 0x64, 0x62, 0x61, 0xb3, 0x3b,
    0x56, 0x7f, 0xa6, 0xe9, 0x23, 0x89, 0x51, 0xc8, 0xda, 0xb5, 0xb9, 0x5c, 0xff, 0x03, 0x6f, 0xa3,
    0x23, 0x70, 0xaa, 0x42, 0x51, 0x14, 0x46, 0x36, 0xa3, 0x56, 0xeb, 0x94, 0x8e, 0xa7, 0x69, 0x78,
    0x0c, 0xf5, 0x15, 0x58, 0x39, 0x70, 0xd7, 0x4d, 0x98, 0x68, 0xd4, 0x9c, 0x37, 0xc1, 0x5b, 0xd8,
    0x0f, 0xaa, 0xa8, 0xc1, 0x38, 0xc5, 0x38, 0x29, 0x4e, 0x2e, 0x99, 0xc6, 0x2b, 0x73, 0x61, 0x76,
    0x50, 0xb5, 0x6e, 0x0c, 0x1b, 0x77, 0x4e, 0x1a, 0x43, 0x01, 0x5e, 0x96, 0xc6, 0x53, 0xb9, 0xa8,
    0xfa, 0x50, 0x3b, 0xe4, 0x51, 0x92, 0x4b, 0x4a, 0x35, 0x14, 0x5d, 0xc0, 0xdd, 0x4c, 0x94, 0x1a,
    0x26, 0x58, 0xae, 0x68, 0xd7, 0x10, 0x0e, 0x62, 0xd7, 0x8a, 0xba, 0xa6, 0xa5, 0x77, 0x74, 0x91,
    0x96, 0x67, 0xcc, 0xf6, 0x86, 0x49, 0x97, 0x27, 0xfb, 0x8a, 0xd2, 0xde, 0x36, 0x35, 0x92, 0xdb,
    0x75, 0xe0, 0x7e, 0xbe, 0x34, 0xb9, 0xab, 0xeb, 0x29, 0xfe, 0x17, 0x48, 0x89, 0x66, 0x38, 0xf5,
    0x26, 0xdc, 0xdd, 0x54, 0x5e, 0xe2, 0x88, 0x22, 0x73, 0xe3, 0xce, 0x2e, 0xb9, 0xdd, 0xfc, 0x7f,
    0xf5, 0x4f, 0x54, 0xdf, 0xfa, 0xd5, 0xce, 0xd4, 0x3d, 0x66, 0xdd, 0x3b, 0x3a, 0x3a, 0x12, 0x26,
    0xac, 0x59, 0x10, 0xc2, 0x9c, 0xf0, 0xac, 0xb3, 0x07, 0x87, 0x4a, 0xd9, 0xcd, 0xd3, 0x5d, 0x19,
    0xd7, 0xec, 0x26, 0xbc, 0x27, 0xcd, 0x63, 0x29, 0x15, 0x4c, 0xfa, 0x0c, 0x7b, 0x3f, 0x0e, 0x1f,
    0xe2, 0xe5, 0xba, 0x57, 0xdf, 0x82, 0xf6, 0x2e, 0x38, 0x4d, 0xb2, 0x33, 0xe6, 0x54, 0x1d, 0x7e,
    0xf0, 0xbf, 0x35, 0xfb, 0x0b, 0xe9, 0x1f, 0xdd, 0x4d
};
#endif

PyTypeObject *init_KXmlGuiWindow(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX].type;

    Shiboken::AutoDecRef Sbk_KXmlGuiWindow_Type_bases(PyTuple_Pack(3,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX])),
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX])),
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]))));

    _Sbk_KXmlGuiWindow_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KXmlGuiWindow",
        "KXmlGuiWindow*",
        &Sbk_KXmlGuiWindow_spec,
        &Shiboken::callCppDestructor< KXmlGuiWindow >,
        Sbk_KXmlGuiWindow_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KXmlGuiWindow_Type; // references _Sbk_KXmlGuiWindow_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KXmlGuiWindow_SignatureStrings);
#else
    InitSignatureBytes(pyType, KXmlGuiWindow_SignatureBytes, KXmlGuiWindow_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KXmlGuiWindow_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KXmlGuiWindow_PythonToCpp_KXmlGuiWindow_PTR,
        is_KXmlGuiWindow_PythonToCpp_KXmlGuiWindow_PTR_Convertible,
        KXmlGuiWindow_PTR_CppToPython_KXmlGuiWindow);

    Shiboken::Conversions::registerConverterName(converter, "KXmlGuiWindow");
    Shiboken::Conversions::registerConverterName(converter, "KXmlGuiWindow*");
    Shiboken::Conversions::registerConverterName(converter, "KXmlGuiWindow&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KXmlGuiWindow).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KXmlGuiWindowWrapper).name());

    MultipleInheritanceInitFunction func = Sbk_KXmlGuiWindow_mi_init;
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KXmlGuiWindow_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KXmlGuiWindow_TypeF(), &Sbk_KXmlGuiWindowSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KXmlGuiWindow_TypeF(), &Sbk_KXmlGuiWindow_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KXmlGuiWindow_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'StandardWindowOption'.
    const char *StandardWindowOption_Initializer[] = {
        "ToolBar",
        "Keys",
        "StatusBar",
        "Save",
        "Create",
        "Default",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t StandardWindowOption_InitializerValues[] = {
        uint8_t(KXmlGuiWindow::StandardWindowOption::ToolBar),   //  0x01  1
        uint8_t(KXmlGuiWindow::StandardWindowOption::Keys),      //  0x02  2
        uint8_t(KXmlGuiWindow::StandardWindowOption::StatusBar), //  0x04  4
        uint8_t(KXmlGuiWindow::StandardWindowOption::Save),      //  0x08  8
        uint8_t(KXmlGuiWindow::StandardWindowOption::Create),    //  0x10  16
        uint8_t(KXmlGuiWindow::StandardWindowOption::Default)    //  0x1f  31
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KXmlGuiWindow_TypeF(),
        "1:KXmlGui.KXmlGuiWindow.StandardWindowOption",
        StandardWindowOption_Initializer, StandardWindowOption_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_StandardWindowOption_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKXmlGuiTypeStructs[SBK_QFlags_KXmlGuiWindow_StandardWindowOption_IDX].type =
        EType;
    // Register converter for enum 'KXmlGuiWindow::StandardWindowOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KXmlGuiWindow_StandardWindowOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KXmlGuiWindow_StandardWindowOption,
            is_Enum_PythonToCpp_KXmlGuiWindow_StandardWindowOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KXmlGuiWindow::StandardWindowOption");
        Shiboken::Conversions::registerConverterAlias(converter, "StandardWindowOption");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KXmlGuiWindow_StandardWindowOption_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KXmlGuiWindow_StandardWindowOption,
            is_Enum_PythonToCpp_KXmlGuiWindow_StandardWindowOption_Convertible);
        // Register converter for flag 'QFlags<KXmlGuiWindow::StandardWindowOption>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KXmlGuiWindow::StandardWindowOption>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KXmlGuiWindow::StandardWindowOptions");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'StandardWindowOption' enum/flags.

    qRegisterMetaType< ::KXmlGuiWindow::StandardWindowOption >("KXmlGuiWindow::StandardWindowOption");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KXmlGuiWindow::staticMetaObject, sizeof(KXmlGuiWindowWrapper));

    return pyType;
}
