
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kxmlguifactory_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kxmlguibuilder.h>
#include <kxmlguiclient.h>
#include <qaction.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KXMLGUIFactory_Type = nullptr;
static PyTypeObject *Sbk_KXMLGUIFactory_TypeF(void)
{
    return _Sbk_KXMLGUIFactory_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KXMLGUIFactoryWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KXMLGUIFactoryWrapper::KXMLGUIFactoryWrapper(::KXMLGUIBuilder * builder, ::QObject * parent) : KXMLGUIFactory(builder, parent)
{
}

void KXMLGUIFactoryWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIFactory_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    sbk_o_childEvent("KXMLGUIFactory", funcName, gil, pyOverride, event);
}

void KXMLGUIFactoryWrapper::sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KXMLGUIFactoryWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIFactory_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    sbk_o_connectNotify("KXMLGUIFactory", funcName, gil, pyOverride, signal);
}

void KXMLGUIFactoryWrapper::sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KXMLGUIFactoryWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIFactory_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    sbk_o_customEvent("KXMLGUIFactory", funcName, gil, pyOverride, event);
}

void KXMLGUIFactoryWrapper::sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KXMLGUIFactoryWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIFactory_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KXMLGUIFactory", funcName, gil, pyOverride, signal);
}

bool KXMLGUIFactoryWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIFactory_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return sbk_o_event("KXMLGUIFactory", funcName, gil, pyOverride, event);
}

bool KXMLGUIFactoryWrapper::sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KXMLGUIFactoryWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIFactory_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return sbk_o_eventFilter("KXMLGUIFactory", funcName, gil, pyOverride, watched, event);
}

bool KXMLGUIFactoryWrapper::sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg2 = Py_REFCNT(pyArgArray[1]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg2 = Py_REFCNT(PyTuple_GetItem(pyArgs, 1)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(pyArgArray[1]);
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 1));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KXMLGUIFactoryWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KXMLGUIFactory_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    sbk_o_timerEvent("KXMLGUIFactory", funcName, gil, pyOverride, event);
}

void KXMLGUIFactoryWrapper::sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

const QMetaObject *KXMLGUIFactoryWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KXMLGUIFactory::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KXMLGUIFactoryWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KXMLGUIFactory::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KXMLGUIFactoryWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KXMLGUIFactoryWrapper *>(this));
    }
    return KXMLGUIFactory::qt_metacast(_clname);
}

KXMLGUIFactoryWrapper::~KXMLGUIFactoryWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KXMLGUIFactory_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KXMLGUIFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KXMLGUIFactory >()))
        return -1;

    KXMLGUIFactoryWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KXMLGUIFactory", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KXMLGUIFactory::KXMLGUIFactory(KXMLGUIBuilder*,QObject*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KXMLGUIFactory(KXMLGUIBuilder*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 0; // KXMLGUIFactory(KXMLGUIBuilder*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::KXMLGUIBuilder *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KXMLGUIFactory(KXMLGUIBuilder*,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KXMLGUIFactoryWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KXMLGUIFactoryWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KXMLGUIFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KXMLGUIFactoryFunc_addClient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIFactory::addClient(KXMLGUIClient*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArg)))) {
        overloadId = 0; // addClient(KXMLGUIClient*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addClient", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addClient(KXMLGUIClient*)
            cppSelf->addClient(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_changeShortcutScheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIFactory::changeShortcutScheme(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // changeShortcutScheme(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "changeShortcutScheme", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // changeShortcutScheme(QString)
            cppSelf->changeShortcutScheme(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_clients(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clients()const
        QList<KXMLGUIClient*> cppResult = const_cast<const ::KXMLGUIFactory *>(cppSelf)->clients();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KXMLGUIClientPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIFactoryFunc_container(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "container", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:container", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIFactory::container(QString,KXMLGUIClient*,bool=)->QWidget*
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // container(QString,KXMLGUIClient*,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // container(QString,KXMLGUIClient*,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "container", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"useTagName", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "container", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::KXMLGUIClient *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // container(QString,KXMLGUIClient*,bool)
            QWidget * cppResult = cppSelf->container(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIFactoryFunc_containers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIFactory::containers(QString)->QList<QWidget*>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // containers(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "containers", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // containers(QString)
            QList<QWidget*> cppResult = cppSelf->containers(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QWidgetPTR_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIFactoryFunc_plugActionList(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "plugActionList", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIFactory::plugActionList(KXMLGUIClient*,QString,QList<QAction*>)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX], (pyArgs[2])))) {
        overloadId = 0; // plugActionList(KXMLGUIClient*,QString,QList<QAction*>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "plugActionList", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QList<QAction*> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // plugActionList(KXMLGUIClient*,QString,QList<QAction*>)
            cppSelf->plugActionList(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_readConfigFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "readConfigFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    if (PyArg_ParseTuple(args, "|OO:readConfigFile", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KXMLGUIFactory::readConfigFile(QString,const QString&=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // readConfigFile(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // readConfigFile(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "readConfigFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"componentName", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "readConfigFile", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // readConfigFile(QString,QString)
            QString cppResult = ::KXMLGUIFactory::readConfigFile(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KXMLGUIFactoryFunc_refreshActionProperties(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // refreshActionProperties()
        cppSelf->refreshActionProperties();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_removeClient(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KXMLGUIFactory::removeClient(KXMLGUIClient*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArg)))) {
        overloadId = 0; // removeClient(KXMLGUIClient*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeClient", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeClient(KXMLGUIClient*)
            cppSelf->removeClient(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reset()
        cppSelf->reset();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_resetContainer(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "resetContainer", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    if (PyArg_ParseTuple(args, "|OO:resetContainer", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIFactory::resetContainer(QString,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // resetContainer(QString,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // resetContainer(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "resetContainer", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"useTagName", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "resetContainer", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resetContainer(QString,bool)
            cppSelf->resetContainer(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_showConfigureShortcutsDialog(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showConfigureShortcutsDialog()
        cppSelf->showConfigureShortcutsDialog();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KXMLGUIFactoryFunc_unplugActionList(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "unplugActionList", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KXMLGUIFactory::unplugActionList(KXMLGUIClient*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // unplugActionList(KXMLGUIClient*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "unplugActionList", errInfo, SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KXMLGUIClient *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unplugActionList(KXMLGUIClient*,QString)
            cppSelf->unplugActionList(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KXMLGUIFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KXMLGUIFactory_methods[] = {
    {"addClient", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_addClient), METH_O, nullptr},
    {"changeShortcutScheme", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_changeShortcutScheme), METH_O, nullptr},
    {"clients", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_clients), METH_NOARGS, nullptr},
    {"container", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_container), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"containers", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_containers), METH_O, nullptr},
    {"plugActionList", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_plugActionList), METH_VARARGS, nullptr},
    {"readConfigFile", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_readConfigFile), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"refreshActionProperties", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_refreshActionProperties), METH_NOARGS, nullptr},
    {"removeClient", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_removeClient), METH_O, nullptr},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_reset), METH_NOARGS, nullptr},
    {"resetContainer", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_resetContainer), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"showConfigureShortcutsDialog", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_showConfigureShortcutsDialog), METH_NOARGS, nullptr},
    {"unplugActionList", reinterpret_cast<PyCFunction>(Sbk_KXMLGUIFactoryFunc_unplugActionList), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KXMLGUIFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KXMLGUIFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KXMLGUIFactoryWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KXMLGUIFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KXMLGUIFactory_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KXMLGUIFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KXMLGUIFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KXMLGUIFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KXMLGUIFactory_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KXMLGUIFactory_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KXMLGUIFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KXMLGUIFactory_spec = {
    "1:KXmlGui.KXMLGUIFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KXMLGUIFactory_slots
};

} //extern "C"

static void *Sbk_KXMLGUIFactory_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KXMLGUIFactory *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KXMLGUIFactory_PythonToCpp_KXMLGUIFactory_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KXMLGUIFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KXMLGUIFactory_PythonToCpp_KXMLGUIFactory_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KXMLGUIFactory_TypeF()))
        return KXMLGUIFactory_PythonToCpp_KXMLGUIFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KXMLGUIFactory_PTR_CppToPython_KXMLGUIFactory(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KXMLGUIFactory *>(const_cast<void *>(cppIn)), Sbk_KXMLGUIFactory_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KXMLGUIFactory_SignatureStrings[] = {
    "KXmlGui.KXMLGUIFactory(self,builder:KXmlGui.KXMLGUIBuilder,parent:PySide6.QtCore.QObject=nullptr)",
    "KXmlGui.KXMLGUIFactory.addClient(self,client:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXMLGUIFactory.changeShortcutScheme(self,scheme:QString)",
    "KXmlGui.KXMLGUIFactory.clients(self)->QList[KXmlGui.KXMLGUIClient]",
    "KXmlGui.KXMLGUIFactory.container(self,containerName:QString,client:KXmlGui.KXMLGUIClient,useTagName:bool=false)->PySide6.QtWidgets.QWidget",
    "KXmlGui.KXMLGUIFactory.containers(self,tagName:QString)->QList[PySide6.QtWidgets.QWidget]",
    "KXmlGui.KXMLGUIFactory.plugActionList(self,client:KXmlGui.KXMLGUIClient,name:QString,actionList:QList[PySide6.QtGui.QAction])",
    "KXmlGui.KXMLGUIFactory.readConfigFile(filename:QString,componentName:QString=QString())->QString",
    "KXmlGui.KXMLGUIFactory.refreshActionProperties(self)",
    "KXmlGui.KXMLGUIFactory.removeClient(self,client:KXmlGui.KXMLGUIClient)",
    "KXmlGui.KXMLGUIFactory.reset(self)",
    "KXmlGui.KXMLGUIFactory.resetContainer(self,containerName:QString,useTagName:bool=false)",
    "KXmlGui.KXMLGUIFactory.showConfigureShortcutsDialog(self)",
    "KXmlGui.KXMLGUIFactory.unplugActionList(self,client:KXmlGui.KXMLGUIClient,name:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KXMLGUIFactory_SignatureByteSize = 348;
static constexpr uint8_t KXMLGUIFactory_SignatureBytes[348] = {
    0x78, 0xda, 0xa5, 0x93, 0xdf, 0x6b, 0x83, 0x30, 0x10, 0xc7, 0xdf, 0xfb, 0x97, 0x54, 0x70, 0x3e,
    0xee, 0x41, 0xe8, 0x60, 0x73, 0xb4, 0x0c, 0xbb, 0xad, 0xe2, 0xc6, 0x0a, 0xa3, 0x0f, 0x69, 0x3c,
    0x63, 0x46, 0x4c, 0x24, 0xb9, 0x6c, 0xf4, 0xbf, 0x9f, 0x35, 0xf6, 0x27, 0x4d, 0x5b, 0xe8, 0x8b,
    0x5e, 0xe4, 0xee, 0xf3, 0xbd, 0xef, 0xe5, 0x4c, 0xe7, 0xb5, 0x98, 0x58, 0x1e, 0xa5, 0xf3, 0xd7,
    0xe9, 0xe4, 0xf3, 0x65, 0x4c, 0x28, 0x2a, 0xbd, 0x1a, 0x1a, 0x10, 0x65, 0xb8, 0xb4, 0x5c, 0x14,
    0xa0, 0xe3, 0xf4, 0x30, 0xe7, 0xc9, 0x7d, 0x0e, 0x1b, 0xa2, 0x41, 0x62, 0x3c, 0x5b, 0xe5, 0xbc,
    0x80, 0xfb, 0x28, 0xc3, 0x44, 0x69, 0x88, 0xb2, 0xf7, 0xe5, 0x0f, 0x50, 0x1c, 0x49, 0x2b, 0x44,
    0x83, 0x3a, 0x18, 0xa4, 0x27, 0x15, 0x22, 0x52, 0x14, 0x89, 0xe0, 0x2d, 0xc0, 0x69, 0xd1, 0x2e,
    0x3e, 0x96, 0x72, 0x19, 0x5e, 0x06, 0xad, 0x88, 0x64, 0x90, 0x57, 0x4a, 0x23, 0xb5, 0x98, 0xd3,
    0x0a, 0x6a, 0x70, 0x38, 0xd3, 0xc5, 0x71, 0x96, 0xa3, 0xe6, 0x92, 0xf9, 0x01, 0x1d, 0xdf, 0x74,
    0x35, 0xc1, 0xdd, 0x43, 0x36, 0xe5, 0x06, 0xbf, 0x4f, 0xf6, 0xb0, 0xf0, 0x22, 0x94, 0x44, 0xc2,
    0x25, 0xe8, 0xde, 0xc7, 0xe6, 0xf8, 0x46, 0x76, 0xfa, 0x67, 0xdd, 0x85, 0xd6, 0xc0, 0x07, 0x61,
    0x5d, 0xfe, 0x52, 0x29, 0x31, 0x2a, 0x89, 0x30, 0xd0, 0x76, 0xb3, 0x1b, 0xec, 0x17, 0x2f, 0x18,
    0xa0, 0x89, 0x32, 0x17, 0x5c, 0x6c, 0xc5, 0x19, 0x0a, 0xb1, 0xa7, 0x6e, 0xa6, 0xb0, 0x31, 0xe8,
    0x05, 0x7b, 0x4d, 0x36, 0xc2, 0xb2, 0x47, 0x8a, 0x5c, 0xc9, 0x35, 0xe0, 0xf2, 0x8d, 0x85, 0x72,
    0xdf, 0x3d, 0xd9, 0x56, 0xc6, 0xc7, 0x0d, 0xac, 0x2b, 0x33, 0x47, 0x5e, 0x78, 0x6f, 0x49, 0x03,
    0x29, 0x12, 0x25, 0x4b, 0xce, 0xc6, 0x5c, 0xc0, 0xb0, 0x6c, 0x1f, 0x07, 0x7c, 0xaa, 0xea, 0x46,
    0xc9, 0x56, 0x76, 0xdf, 0xed, 0xa8, 0x7f, 0x0f, 0x83, 0xb5, 0x6f, 0x17, 0xfb, 0x05, 0x4a, 0x0d,
    0xa6, 0x72, 0x7d, 0xcc, 0xb4, 0x6a, 0x40, 0x23, 0x87, 0x7e, 0x2d, 0xfc, 0x45, 0xb5, 0xfa, 0x85,
    0x9b, 0x77, 0xb8, 0x15, 0x06, 0xbc, 0xa4, 0xd4, 0xa6, 0x24, 0xd7, 0xec, 0xd9, 0xe9, 0x55, 0xf2,
    0x71, 0x4d, 0xa5, 0xfe, 0xdc, 0x5c, 0xad, 0xde, 0xfe, 0x45, 0xe6, 0x99, 0x13, 0xa1, 0xd8, 0xf9,
    0x8e, 0xac, 0xbc, 0x69, 0x23, 0x82, 0xc1, 0x3f, 0xd1, 0x06, 0x9a, 0xe3
};
#endif

PyTypeObject *init_KXMLGUIFactory(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX].type;

    Shiboken::AutoDecRef Sbk_KXMLGUIFactory_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KXMLGUIFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KXMLGUIFactory",
        "KXMLGUIFactory*",
        &Sbk_KXMLGUIFactory_spec,
        &Shiboken::callCppDestructor< KXMLGUIFactory >,
        Sbk_KXMLGUIFactory_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KXMLGUIFactory_Type; // references _Sbk_KXMLGUIFactory_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KXMLGUIFactory_SignatureStrings);
#else
    InitSignatureBytes(pyType, KXMLGUIFactory_SignatureBytes, KXMLGUIFactory_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KXMLGUIFactory_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KXMLGUIFactory_PythonToCpp_KXMLGUIFactory_PTR,
        is_KXMLGUIFactory_PythonToCpp_KXMLGUIFactory_PTR_Convertible,
        KXMLGUIFactory_PTR_CppToPython_KXMLGUIFactory);

    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIFactory");
    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIFactory*");
    Shiboken::Conversions::registerConverterName(converter, "KXMLGUIFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KXMLGUIFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KXMLGUIFactoryWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KXMLGUIFactory_TypeF(), &Sbk_KXMLGUIFactory_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KXMLGUIFactory::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KXMLGUIFactory::staticMetaObject, sizeof(KXMLGUIFactoryWrapper));

    return pyType;
}
