
#include <sbkpep.h>
#include <shiboken.h>
#include <sbkbindingutils.h>
#include <algorithm>
#include <signature.h>
#include <sbkcontainer.h>
#include <sbkstaticstrings.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysidecleanup.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <pysidestaticstrings.h>
#include "kxmlgui_python.h"

#include <QList>
#include <QMap>
#include <QString>
#include <kactioncollection.h>
#include <kmainwindow.h>
#include <ktoolbar.h>
#include <kxmlguiclient.h>
#include <qaction.h>
#include <qkeysequence.h>
#include <qvariant.h>
#include <qwidget.h>


// Current module's type array.
Shiboken::Module::TypeInitStruct *SbkKXmlGuiTypeStructs = nullptr;
// Backwards compatible structure with identical indexing.
PyTypeObject **SbkKXmlGuiTypes = nullptr;
// Current module's converter array.
SbkConverter **SbkKXmlGuiTypeConverters = nullptr;

void cleanTypesAttributes() {
    static PyObject *attrName = Shiboken::PyName::qtStaticMetaObject();
    const int imax = SBK_KXmlGui_IDX_COUNT;
    for (int i = 0; i < imax && SbkKXmlGuiTypeStructs[i].fullName != nullptr; ++i) {
        auto *pyType = reinterpret_cast<PyObject *>(SbkKXmlGuiTypeStructs[i].type);
        if (pyType != nullptr && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}

// Global functions ------------------------------------------------------------

static PyMethodDef KXmlGuiMethods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
PyTypeObject *init_KXMLGUIFactory(PyObject *enclosing);
PyTypeObject *init_KXMLGUIClient(PyObject *enclosing);
PyTypeObject *init_KXMLGUIBuilder(PyObject *enclosing);
PyTypeObject *init_KXmlGuiKUndoActions(PyObject *enclosing);
PyTypeObject *init_KToolTipHelper(PyObject *enclosing);
PyTypeObject *init_KToolBar(PyObject *enclosing);
PyTypeObject *init_KToggleToolBarAction(PyObject *enclosing);
PyTypeObject *init_KShortcutsEditor(PyObject *enclosing);
PyTypeObject *init_KShortcutsDialog(PyObject *enclosing);
PyTypeObject *init_KShortcutWidget(PyObject *enclosing);
PyTypeObject *init_KMainWindow(PyObject *enclosing);
PyTypeObject *init_KXmlGuiWindow(PyObject *enclosing);
PyTypeObject *init_KKeySequenceWidget(PyObject *enclosing);
PyTypeObject *init_KHelpMenu(PyObject *enclosing);
PyTypeObject *init_KEditToolBar(PyObject *enclosing);
PyTypeObject *init_KBugReport(PyObject *enclosing);
PyTypeObject *init_KActionCollection(PyObject *enclosing);
PyTypeObject *init_KActionCategory(PyObject *enclosing);
PyTypeObject *init_KAboutPluginDialog(PyObject *enclosing);
PyTypeObject *init_KAboutApplicationDialog(PyObject *enclosing);

// Required modules' type and converter arrays.
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWidgetsTypeStructs;
SbkConverter **SbkPySide6_QtWidgetsTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtGuiTypeStructs;
SbkConverter **SbkPySide6_QtGuiTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtCoreTypeStructs;
SbkConverter **SbkPySide6_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for container type 'QList<int>'.
static PyObject *_QList_int__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<int> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<int> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_int__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return PySequence_PythonToCpp__QList_int_;
    return {};
}


// Binding for QList<int>

template <>
struct ShibokenContainerValueConverter<int>
{
    static bool checkValue(PyObject *pyArg)
    {
        return PyLong_Check(pyArg);
    }

    static PyObject *convertValueToPython(int cppArg)
    {
        return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg);
    }

    static std::optional<int> convertValueToCpp(PyObject *pyArg)
    {
        Shiboken::Conversions::PythonToCppConversion pythonToCpp;
        if (!(PyLong_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg))))) {
            Shiboken::Errors::setWrongContainerType();
            return {};
        }
        int cppArg;
        pythonToCpp(pyArg, &cppArg);
        return cppArg;
    }
};

static PyMethodDef QIntList_methods[] = {
    {"push_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "push_back"},
    {"append", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "append"},
    {"clear", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::clear), METH_NOARGS, "clear"},
    {"pop_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "pop_back"},
    {"removeLast", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "removeLast"},
    {"push_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "push_front"},
    {"prepend", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "prepend"},
    {"pop_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_NOARGS, "pop_front"},
    {"removeFirst", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_O, "removeFirst"},
    {"reserve", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::reserve), METH_O, "reserve"},
    {"capacity", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::capacity), METH_NOARGS, "capacity"},
    {"data", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::data), METH_NOARGS, "data"},
    {"constData", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::constData), METH_NOARGS, "constData"},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyType_Slot QIntList_slots[] = {
    {Py_tp_init, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpInit)},
    {Py_tp_new, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpNew)},
    {Py_tp_free, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpFree)},
    {Py_tp_dealloc, reinterpret_cast<void *>(Sbk_object_dealloc)},
    {Py_tp_methods, reinterpret_cast<void *>(QIntList_methods)},
    {Py_sq_ass_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqSetItem)},
    {Py_sq_length, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqLen)},
    {Py_sq_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqGetItem)},
    {0, nullptr}
};

static PyType_Spec QIntList_spec = {
    "1:KXmlGui.QIntList",
    sizeof(ShibokenContainer),
    0,
    Py_TPFLAGS_DEFAULT,
    QIntList_slots
};

static inline PyTypeObject *createQIntListType()
{
    auto *result = SbkType_FromSpec(&QIntList_spec);
    Py_INCREF(Py_True);
    Shiboken::AutoDecRef tpDict(PepType_GetDict(result));
    PyDict_SetItem(tpDict.object(), Shiboken::PyMagicName::opaque_container(), Py_True);
    return result;
}

static PyTypeObject *QIntList_TypeF()
{
    static PyTypeObject *type = createQIntListType();
    return type;
}

extern "C" PyObject *createQIntList(QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = ct;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" PyObject *createConstQIntList(const QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = const_cast<QList<int> *>(ct);
    d->m_const = true;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" int QIntList_Check(PyObject *pyArg)
{
    return pyArg != nullptr && pyArg != Py_None && pyArg->ob_type == QIntList_TypeF();
}

extern "C" void PythonToCppQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QList<int>**>(cppOut) = d->m_list;
}

extern "C" PythonToCppFunc isQIntListPythonToCppConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToCppQIntList;
    return {};
}

extern "C" void PythonToQVariantQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QVariant *>(cppOut) = QVariant::fromValue(*d->m_list);
}

extern "C" PythonToCppFunc isQIntListPythonToQVariantConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToQVariantQIntList;
    return {};
}

// C++ to Python conversion for container type 'QList<KXMLGUIClient*>'.
static PyObject *_QList_KXMLGUIClientPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KXMLGUIClient*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KXMLGUIClientPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KXMLGUIClient*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KXMLGUIClient* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KXMLGUIClientPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KXMLGUIClientPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QWidget*>'.
static PyObject *_QList_QWidgetPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QWidget*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QWidgetPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QWidget*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWidget* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QWidgetPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QWidgetPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QAction*>'.
static PyObject *_QList_QActionPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QAction*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QActionPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QAction*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAction* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QActionPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QActionPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<KActionCollection*>'.
static PyObject *_QList_KActionCollectionPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KActionCollection*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KActionCollectionPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KActionCollection*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KActionCollection* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KActionCollectionPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KActionCollectionPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QKeySequence>'.
static PyObject *_QList_QKeySequence__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QKeySequence> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QKeySequence_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QKeySequence> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QKeySequence cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QKeySequence__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QKeySequence_;
    return {};
}

// C++ to Python conversion for container type 'QList<KMainWindow*>'.
static PyObject *_QList_KMainWindowPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KMainWindow*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KMainWindowPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KMainWindow*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KMainWindow* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KMainWindowPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KMainWindowPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<KToolBar*>'.
static PyObject *_QList_KToolBarPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<KToolBar*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolBar_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_KToolBarPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<KToolBar*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::KToolBar* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolBar_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_KToolBarPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolBar_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_KToolBarPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QActionGroup*>'.
static PyObject *_QList_QActionGroupPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QActionGroup*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QActionGroup_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QActionGroupPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QActionGroup*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QActionGroup* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QActionGroup_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QActionGroupPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QActionGroup_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QActionGroupPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QVariant>'.
static PyObject *_QList_QVariant__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<QString>'.
static PyObject *_QList_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QVariant>'.
static PyObject *_QMap_QString_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QVariant_;
    return {};
}


// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KXmlGui_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t KXmlGui_SignatureByteSize = 0;
static constexpr uint8_t KXmlGui_SignatureBytes[1] = {
    0x00
};
#endif

static void initInheritance()
{
    auto &bm = Shiboken::BindingManager::instance();
    SBK_UNUSED(bm)
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KXMLGUIFactory_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KToolTipHelper_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QToolBar_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KToolBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KShortcutsEditor_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KShortcutsDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KShortcutWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX]);
    bm.addClassInheritance(&SbkKXmlGuiTypeStructs[SBK_KMainWindow_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
    bm.addClassInheritance(&SbkKXmlGuiTypeStructs[SBK_KXMLGUIBuilder_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
    bm.addClassInheritance(&SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KXmlGuiWindow_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KEditToolBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KBugReport_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KActionCategory_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKXmlGuiTypeStructs[SBK_KAboutApplicationDialog_IDX]);
}

static void initConverters_KXmlGui()
{
    // Register primitive types converters.
    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "QRgb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "__caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__clock_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__clockid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_d_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__fsword_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__poll_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__sig_atomic_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__socklen_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__syscall_slong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__syscall_ulong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__time_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__useconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "comparison_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "int_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "qInternalCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "register_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "uint_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "useconds_t");

}

static void initContainerConverters_KXmlGui()
{
    // Register converter for type 'QList<int>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_int_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_int_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_int_IDX],
        PySequence_PythonToCpp__QList_int_,
        is_PySequence_PythonToCpp__QList_int__Convertible);
    Shiboken::Conversions::setPythonToCppPointerFunctions(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_int_IDX],
        PythonToCppQIntList,
        isQIntListPythonToCppConvertible);

    // Register converter for type 'QList<KXMLGUIClient*>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KXMLGUIClientPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KXMLGUIClientPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KXMLGUIClientPTR_IDX], "QList<KXMLGUIClient*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KXMLGUIClientPTR_IDX],
        PySequence_PythonToCpp__QList_KXMLGUIClientPTR_,
        is_PySequence_PythonToCpp__QList_KXMLGUIClientPTR__Convertible);

    // Register converter for type 'QList<QWidget*>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QWidgetPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QWidgetPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QWidgetPTR_IDX], "QList<QWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QWidgetPTR_IDX],
        PySequence_PythonToCpp__QList_QWidgetPTR_,
        is_PySequence_PythonToCpp__QList_QWidgetPTR__Convertible);
    // Register converters for type aliases of QList<QWidget*>'.
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QWidgetPTR_IDX], "QWidgetList");

    // Register converter for type 'QList<QAction*>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX], "QList<QAction*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX],
        PySequence_PythonToCpp__QList_QActionPTR_,
        is_PySequence_PythonToCpp__QList_QActionPTR__Convertible);

    // Register converter for type 'QList<KActionCollection*>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KActionCollectionPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KActionCollectionPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KActionCollectionPTR_IDX], "QList<KActionCollection*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KActionCollectionPTR_IDX],
        PySequence_PythonToCpp__QList_KActionCollectionPTR_,
        is_PySequence_PythonToCpp__QList_KActionCollectionPTR__Convertible);

    // Register converter for type 'QList<QKeySequence>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QKeySequence_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QKeySequence__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QKeySequence_IDX], "QList<QKeySequence>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QKeySequence_IDX],
        PySequence_PythonToCpp__QList_QKeySequence_,
        is_PySequence_PythonToCpp__QList_QKeySequence__Convertible);

    // Register converter for type 'QList<KMainWindow*>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KMainWindowPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KMainWindowPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KMainWindowPTR_IDX], "QList<KMainWindow*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KMainWindowPTR_IDX],
        PySequence_PythonToCpp__QList_KMainWindowPTR_,
        is_PySequence_PythonToCpp__QList_KMainWindowPTR__Convertible);

    // Register converter for type 'QList<KToolBar*>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KToolBarPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_KToolBarPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KToolBarPTR_IDX], "QList<KToolBar*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KToolBarPTR_IDX],
        PySequence_PythonToCpp__QList_KToolBarPTR_,
        is_PySequence_PythonToCpp__QList_KToolBarPTR__Convertible);

    // Register converter for type 'QList<QActionGroup*>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionGroupPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionGroupPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionGroupPTR_IDX], "QList<QActionGroup*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionGroupPTR_IDX],
        PySequence_PythonToCpp__QList_QActionGroupPTR_,
        is_PySequence_PythonToCpp__QList_QActionGroupPTR__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QVariant_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QVariant_IDX],
        PySequence_PythonToCpp__QList_QVariant_,
        is_PySequence_PythonToCpp__QList_QVariant__Convertible);
    // Register converters for type aliases of QList<QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QVariant_IDX], "QVariantList");

    // Register converter for type 'QList<QString>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QString_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QString_IDX],
        PySequence_PythonToCpp__QList_QString_,
        is_PySequence_PythonToCpp__QList_QString__Convertible);
    // Register converters for type aliases of QList<QString>'.

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkKXmlGuiTypeConverters[SBK_KXmlGui_QMap_QString_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QMap_QString_QVariant_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QMap_QString_QVariant_IDX],
        PyDict_PythonToCpp__QMap_QString_QVariant_,
        is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible);
    // Register converters for type aliases of QMap<QString,QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QMap_QString_QVariant_IDX], "QVariantMap");

}

static void registerOpaqueContainers_KXmlGui(PyObject *module)
{
    PyTypeObject *pyType{};
    auto *qVariantConverter = Shiboken::Conversions::getConverter("QVariant");
    Q_ASSERT(qVariantConverter != nullptr);
    pyType = QIntList_TypeF();
    Py_XINCREF(reinterpret_cast<PyObject *>(pyType));
    PepModule_AddType(module, pyType);
    if constexpr (QMetaTypeId2<int>::Defined) {
        Shiboken::Conversions::prependPythonToCppValueConversion(qVariantConverter,
            PythonToQVariantQIntList, isQIntListPythonToQVariantConvertible);
    }
}

extern "C" {
static int exec_KXmlGui(PyObject *module)
{
    Shiboken::Module::exec(module);

    // Initialize classes in the type system
    Shiboken::Module::AddTypeCreationFunction(module, "KXMLGUIFactory", init_KXMLGUIFactory);
    Shiboken::Module::AddTypeCreationFunction(module, "KXMLGUIClient", init_KXMLGUIClient);
    Shiboken::Module::AddTypeCreationFunction(module, "KXMLGUIBuilder", init_KXMLGUIBuilder);
    Shiboken::Module::AddTypeCreationFunction(module, "KUndoActions", init_KXmlGuiKUndoActions);
    Shiboken::Module::AddTypeCreationFunction(module, "KToolTipHelper", init_KToolTipHelper);
    Shiboken::Module::AddTypeCreationFunction(module, "KToolBar", init_KToolBar);
    Shiboken::Module::AddTypeCreationFunction(module, "KToggleToolBarAction", init_KToggleToolBarAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KShortcutsEditor", init_KShortcutsEditor);
    Shiboken::Module::AddTypeCreationFunction(module, "KShortcutsDialog", init_KShortcutsDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KShortcutWidget", init_KShortcutWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KMainWindow", init_KMainWindow);
    Shiboken::Module::AddTypeCreationFunction(module, "KXmlGuiWindow", init_KXmlGuiWindow);
    Shiboken::Module::AddTypeCreationFunction(module, "KKeySequenceWidget", init_KKeySequenceWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KHelpMenu", init_KHelpMenu);
    Shiboken::Module::AddTypeCreationFunction(module, "KEditToolBar", init_KEditToolBar);
    Shiboken::Module::AddTypeCreationFunction(module, "KBugReport", init_KBugReport);
    Shiboken::Module::AddTypeCreationFunction(module, "KActionCollection", init_KActionCollection);
    Shiboken::Module::AddTypeCreationFunction(module, "KActionCategory", init_KActionCategory);
    Shiboken::Module::AddTypeCreationFunction(module, "KAboutPluginDialog", init_KAboutPluginDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KAboutApplicationDialog", init_KAboutApplicationDialog);

    registerOpaqueContainers_KXmlGui(module);

    Shiboken::Module::registerTypes(module, SbkKXmlGuiTypeStructs);
    Shiboken::Module::registerTypeConverters(module, SbkKXmlGuiTypeConverters);

    initInheritance();

    if (Shiboken::Errors::occurred() != nullptr) {
        PyErr_Print();
        Py_FatalError("shiboken: can't initialize module KXmlGui");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

#if PYSIDE6_COMOPT_COMPRESS == 0
    FinishSignatureInitialization(module, KXmlGui_SignatureStrings);
#else
    if (FinishSignatureInitBytes(module, KXmlGui_SignatureBytes, KXmlGui_SignatureByteSize) < 0)
        return -1;
#endif

    return 0;
}
} // extern "C"

static PyModuleDef_Slot KXmlGuiModuleSlots[] = {
    {Py_mod_exec, reinterpret_cast<void *>(exec_KXmlGui)},
#if !defined(PYPY_VERSION) && ((!defined(Py_LIMITED_API) && PY_VERSION_HEX >= 0x030C0000) || (defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030C0000))
    {Py_mod_multiple_interpreters, Py_MOD_MULTIPLE_INTERPRETERS_NOT_SUPPORTED},
#endif
#ifdef Py_GIL_DISABLED
    {Py_mod_gil, Py_MOD_GIL_USED},
#endif
    {0, nullptr}
};

static struct PyModuleDef KXmlGuiModuleDef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "KXmlGui",
    /* m_doc      */ nullptr,
    /* m_size     */ 0,
    /* m_methods  */ KXmlGuiMethods,
    /* m_slots    */ KXmlGuiModuleSlots,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

extern "C" LIBSHIBOKEN_EXPORT PyObject *PyInit_KXmlGui()
{
    Shiboken::init();

    // Create an array of wrapper types/names for the current module.
    static Shiboken::Module::TypeInitStruct cppApi[] = {
        {nullptr, "KXmlGui.KAboutApplicationDialog"},
        {nullptr, "KXmlGui.KAboutApplicationDialog.Option"},
        {nullptr, "KXmlGui.KAboutPluginDialog"},
        {nullptr, "KXmlGui.KAboutPluginDialog.Option"},
        {nullptr, "KXmlGui.KActionCategory"},
        {nullptr, "KXmlGui.KActionCollection"},
        {nullptr, "KXmlGui.KBugReport"},
        {nullptr, "KXmlGui.KEditToolBar"},
        {nullptr, "KXmlGui.KHelpMenu"},
        {nullptr, "KXmlGui.KHelpMenu.MenuId"},
        {nullptr, "KXmlGui.KKeySequenceWidget"},
        {nullptr, "KXmlGui.KKeySequenceWidget.ShortcutType"},
        {nullptr, "KXmlGui.KKeySequenceWidget.Validation"},
        {nullptr, "KXmlGui.KMainWindow"},
        {nullptr, "KXmlGui.KShortcutWidget"},
        {nullptr, "KXmlGui.KShortcutsDialog"},
        {nullptr, "KXmlGui.KShortcutsEditor"},
        {nullptr, "KXmlGui.KShortcutsEditor.ActionType"},
        {nullptr, "KXmlGui.KShortcutsEditor.LetterShortcuts"},
        {nullptr, "KXmlGui.KToggleToolBarAction"},
        {nullptr, "KXmlGui.KToolBar"},
        {nullptr, "KXmlGui.KToolTipHelper"},
        {nullptr, "KXmlGui.KUndoActions"},
        {nullptr, "KXmlGui.KXMLGUIBuilder"},
        {nullptr, "KXmlGui.KXMLGUIClient"},
        {nullptr, "KXmlGui.KXMLGUIClient.ReverseStateChange"},
        {nullptr, "KXmlGui.KXMLGUIFactory"},
        {nullptr, "KXmlGui.KXmlGuiWindow"},
        {nullptr, "KXmlGui.KXmlGuiWindow.StandardWindowOption"},
        {nullptr, "KXmlGui.KAboutApplicationDialog.Options"},
        {nullptr, "KXmlGui.KAboutPluginDialog.Options"},
        {nullptr, "KXmlGui.KKeySequenceWidget.ShortcutTypes"},
        {nullptr, "KXmlGui.KShortcutsEditor.ActionTypes"},
        {nullptr, "KXmlGui.KXmlGuiWindow.StandardWindowOptions"},
        {nullptr, nullptr}
    };
    // The new global structure consisting of (type, name) pairs.
    SbkKXmlGuiTypeStructs = cppApi;
    QT_WARNING_PUSH
    QT_WARNING_DISABLE_DEPRECATED
    // The backward compatible alias with upper case indexes.
    SbkKXmlGuiTypes = reinterpret_cast<PyTypeObject **>(cppApi);
    QT_WARNING_POP

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_KXmlGui_CONVERTERS_IDX_COUNT];
    SbkKXmlGuiTypeConverters = sbkConverters;

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWidgets"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWidgetsTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtGui"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtGuiTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtCore"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtCoreTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    initConverters_KXmlGui();
    initContainerConverters_KXmlGui();

    PyObject *module = nullptr;
    if (Shiboken::isCompiled()) {
        KXmlGuiModuleDef.m_size = -1;
        KXmlGuiModuleDef.m_slots = nullptr;
        module = Shiboken::Module::createOnly("KXmlGui", &KXmlGuiModuleDef);
        if (module == nullptr)
            return nullptr;
#ifdef Py_GIL_DISABLED
        PyUnstable_Module_SetGIL(module, Py_MOD_GIL_NOT_USED);
#endif
        if (exec_KXmlGui(module) != 0)
            return nullptr;
    } else {
        module = PyModuleDef_Init(&KXmlGuiModuleDef);
    }
    return module;
}

