// This file was generated by qtwaylandscanner
// source file is kde-output-management-v2.xml

#ifndef QT_WAYLAND_SERVER_KDE_OUTPUT_MANAGEMENT_V2
#define QT_WAYLAND_SERVER_KDE_OUTPUT_MANAGEMENT_V2

#include "wayland-server-core.h"
#include "wayland-kde-output-management-v2-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  kde_output_management_v2
    {
    public:
        kde_output_management_v2(struct ::wl_client *client, int id, int version);
        kde_output_management_v2(struct ::wl_display *display, int version);
        kde_output_management_v2(struct ::wl_resource *resource);
        kde_output_management_v2();

        virtual ~kde_output_management_v2();

        class Resource
        {
        public:
            Resource() : kde_output_management_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            kde_output_management_v2 *kde_output_management_v2_object;
            kde_output_management_v2 *object() { return kde_output_management_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


    protected:
        virtual Resource *kde_output_management_v2_allocate();

        virtual void kde_output_management_v2_destroy_global();

        virtual void kde_output_management_v2_bind_resource(Resource *resource);
        virtual void kde_output_management_v2_destroy_resource(Resource *resource);

        virtual void kde_output_management_v2_create_configuration(Resource *resource, uint32_t id);
        virtual void kde_output_management_v2_create_mode_list(Resource *resource, uint32_t id);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::kde_output_management_v2_interface m_kde_output_management_v2_interface;

        static void handle_create_configuration(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);
        static void handle_create_mode_list(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            kde_output_management_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  kde_output_configuration_v2
    {
    public:
        kde_output_configuration_v2(struct ::wl_client *client, int id, int version);
        kde_output_configuration_v2(struct ::wl_display *display, int version);
        kde_output_configuration_v2(struct ::wl_resource *resource);
        kde_output_configuration_v2();

        virtual ~kde_output_configuration_v2();

        class Resource
        {
        public:
            Resource() : kde_output_configuration_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            kde_output_configuration_v2 *kde_output_configuration_v2_object;
            kde_output_configuration_v2 *object() { return kde_output_configuration_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_already_applied = 0, // the config is already applied
        };

        enum vrr_policy {
            vrr_policy_never = 0,
            vrr_policy_always = 1,
            vrr_policy_automatic = 2,
        };

        enum rgb_range {
            rgb_range_automatic = 0,
            rgb_range_full = 1,
            rgb_range_limited = 2,
        };

        enum auto_rotate_policy {
            auto_rotate_policy_never = 0,
            auto_rotate_policy_in_tablet_mode = 1,
            auto_rotate_policy_always = 2,
        };

        enum color_profile_source {
            color_profile_source_sRGB = 0,
            color_profile_source_ICC = 1,
            color_profile_source_EDID = 2,
        };

        enum color_power_tradeoff {
            color_power_tradeoff_efficiency = 0, // prefer efficiency and performance
            color_power_tradeoff_accuracy = 1, // prefer accuracy
        };

        enum edr_policy {
            edr_policy_never = 0,
            edr_policy_always = 1,
        };

        void send_applied();
        void send_applied(struct ::wl_resource *resource);
        void send_failed();
        void send_failed(struct ::wl_resource *resource);
        void send_failure_reason(const QString &reason);
        void send_failure_reason(struct ::wl_resource *resource, const QString &reason);

    protected:
        virtual Resource *kde_output_configuration_v2_allocate();

        virtual void kde_output_configuration_v2_destroy_global();

        virtual void kde_output_configuration_v2_bind_resource(Resource *resource);
        virtual void kde_output_configuration_v2_destroy_resource(Resource *resource);

        virtual void kde_output_configuration_v2_enable(Resource *resource, struct ::wl_resource *outputdevice, int32_t enable);
        virtual void kde_output_configuration_v2_mode(Resource *resource, struct ::wl_resource *outputdevice, struct ::wl_resource *mode);
        virtual void kde_output_configuration_v2_transform(Resource *resource, struct ::wl_resource *outputdevice, int32_t transform);
        virtual void kde_output_configuration_v2_position(Resource *resource, struct ::wl_resource *outputdevice, int32_t x, int32_t y);
        virtual void kde_output_configuration_v2_scale(Resource *resource, struct ::wl_resource *outputdevice, wl_fixed_t scale);
        virtual void kde_output_configuration_v2_apply(Resource *resource);
        virtual void kde_output_configuration_v2_destroy(Resource *resource);
        virtual void kde_output_configuration_v2_overscan(Resource *resource, struct ::wl_resource *outputdevice, uint32_t overscan);
        virtual void kde_output_configuration_v2_set_vrr_policy(Resource *resource, struct ::wl_resource *outputdevice, uint32_t policy);
        virtual void kde_output_configuration_v2_set_rgb_range(Resource *resource, struct ::wl_resource *outputdevice, uint32_t rgb_range);
        virtual void kde_output_configuration_v2_set_primary_output(Resource *resource, struct ::wl_resource *output);
        virtual void kde_output_configuration_v2_set_priority(Resource *resource, struct ::wl_resource *outputdevice, uint32_t priority);
        virtual void kde_output_configuration_v2_set_high_dynamic_range(Resource *resource, struct ::wl_resource *outputdevice, uint32_t enable_hdr);
        virtual void kde_output_configuration_v2_set_sdr_brightness(Resource *resource, struct ::wl_resource *outputdevice, uint32_t sdr_brightness);
        virtual void kde_output_configuration_v2_set_wide_color_gamut(Resource *resource, struct ::wl_resource *outputdevice, uint32_t enable_wcg);
        virtual void kde_output_configuration_v2_set_auto_rotate_policy(Resource *resource, struct ::wl_resource *outputdevice, uint32_t policy);
        virtual void kde_output_configuration_v2_set_icc_profile_path(Resource *resource, struct ::wl_resource *outputdevice, const QString &profile_path);
        virtual void kde_output_configuration_v2_set_brightness_overrides(Resource *resource, struct ::wl_resource *outputdevice, int32_t max_peak_brightness, int32_t max_frame_average_brightness, int32_t min_brightness);
        virtual void kde_output_configuration_v2_set_sdr_gamut_wideness(Resource *resource, struct ::wl_resource *outputdevice, uint32_t gamut_wideness);
        virtual void kde_output_configuration_v2_set_color_profile_source(Resource *resource, struct ::wl_resource *outputdevice, uint32_t color_profile_source);
        virtual void kde_output_configuration_v2_set_brightness(Resource *resource, struct ::wl_resource *outputdevice, uint32_t brightness);
        virtual void kde_output_configuration_v2_set_color_power_tradeoff(Resource *resource, struct ::wl_resource *outputdevice, uint32_t preference);
        virtual void kde_output_configuration_v2_set_dimming(Resource *resource, struct ::wl_resource *outputdevice, uint32_t multiplier);
        virtual void kde_output_configuration_v2_set_replication_source(Resource *resource, struct ::wl_resource *outputdevice, const QString &source);
        virtual void kde_output_configuration_v2_set_ddc_ci_allowed(Resource *resource, struct ::wl_resource *outputdevice, uint32_t allowed);
        virtual void kde_output_configuration_v2_set_max_bits_per_color(Resource *resource, struct ::wl_resource *outputdevice, uint32_t max_bpc);
        virtual void kde_output_configuration_v2_set_edr_policy(Resource *resource, struct ::wl_resource *outputdevice, uint32_t policy);
        virtual void kde_output_configuration_v2_set_sharpness(Resource *resource, struct ::wl_resource *outputdevice, uint32_t sharpness);
        virtual void kde_output_configuration_v2_set_custom_modes(Resource *resource, struct ::wl_resource *outputdevice, struct ::wl_resource *modes);
        virtual void kde_output_configuration_v2_set_auto_brightness(Resource *resource, struct ::wl_resource *outputdevice, uint32_t enabled);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::kde_output_configuration_v2_interface m_kde_output_configuration_v2_interface;

        static void handle_enable(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t enable);
        static void handle_mode(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            struct ::wl_resource *mode);
        static void handle_transform(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t transform);
        static void handle_position(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t x,
            int32_t y);
        static void handle_scale(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            wl_fixed_t scale);
        static void handle_apply(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_overscan(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t overscan);
        static void handle_set_vrr_policy(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t policy);
        static void handle_set_rgb_range(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t rgb_range);
        static void handle_set_primary_output(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *output);
        static void handle_set_priority(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t priority);
        static void handle_set_high_dynamic_range(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t enable_hdr);
        static void handle_set_sdr_brightness(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t sdr_brightness);
        static void handle_set_wide_color_gamut(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t enable_wcg);
        static void handle_set_auto_rotate_policy(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t policy);
        static void handle_set_icc_profile_path(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            const char *profile_path);
        static void handle_set_brightness_overrides(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t max_peak_brightness,
            int32_t max_frame_average_brightness,
            int32_t min_brightness);
        static void handle_set_sdr_gamut_wideness(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t gamut_wideness);
        static void handle_set_color_profile_source(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t color_profile_source);
        static void handle_set_brightness(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t brightness);
        static void handle_set_color_power_tradeoff(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t preference);
        static void handle_set_dimming(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t multiplier);
        static void handle_set_replication_source(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            const char *source);
        static void handle_set_ddc_ci_allowed(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t allowed);
        static void handle_set_max_bits_per_color(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t max_bpc);
        static void handle_set_edr_policy(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t policy);
        static void handle_set_sharpness(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t sharpness);
        static void handle_set_custom_modes(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            struct ::wl_resource *modes);
        static void handle_set_auto_brightness(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t enabled);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            kde_output_configuration_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  kde_mode_list_v2
    {
    public:
        kde_mode_list_v2(struct ::wl_client *client, int id, int version);
        kde_mode_list_v2(struct ::wl_display *display, int version);
        kde_mode_list_v2(struct ::wl_resource *resource);
        kde_mode_list_v2();

        virtual ~kde_mode_list_v2();

        class Resource
        {
        public:
            Resource() : kde_mode_list_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            kde_mode_list_v2 *kde_mode_list_v2_object;
            kde_mode_list_v2 *object() { return kde_mode_list_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_missing_parameters = 0, // a required parameter wasn't set
        };

    protected:
        virtual Resource *kde_mode_list_v2_allocate();

        virtual void kde_mode_list_v2_destroy_global();

        virtual void kde_mode_list_v2_bind_resource(Resource *resource);
        virtual void kde_mode_list_v2_destroy_resource(Resource *resource);

        virtual void kde_mode_list_v2_destroy(Resource *resource);
        virtual void kde_mode_list_v2_add_mode(Resource *resource);
        virtual void kde_mode_list_v2_set_resolution(Resource *resource, uint32_t width, uint32_t height);
        virtual void kde_mode_list_v2_set_refresh_rate(Resource *resource, uint32_t rate);
        virtual void kde_mode_list_v2_set_reduced_blanking(Resource *resource, uint32_t reduced);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::kde_mode_list_v2_interface m_kde_mode_list_v2_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_add_mode(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_resolution(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t width,
            uint32_t height);
        static void handle_set_refresh_rate(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t rate);
        static void handle_set_reduced_blanking(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t reduced);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            kde_mode_list_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
