// This file was generated by qtwaylandscanner
// source file is org-kde-plasma-virtual-desktop.xml

#ifndef QT_WAYLAND_SERVER_ORG_KDE_PLASMA_VIRTUAL_DESKTOP
#define QT_WAYLAND_SERVER_ORG_KDE_PLASMA_VIRTUAL_DESKTOP

#include "wayland-server-core.h"
#include "wayland-org-kde-plasma-virtual-desktop-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  org_kde_plasma_virtual_desktop_management
    {
    public:
        org_kde_plasma_virtual_desktop_management(struct ::wl_client *client, int id, int version);
        org_kde_plasma_virtual_desktop_management(struct ::wl_display *display, int version);
        org_kde_plasma_virtual_desktop_management(struct ::wl_resource *resource);
        org_kde_plasma_virtual_desktop_management();

        virtual ~org_kde_plasma_virtual_desktop_management();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_virtual_desktop_management_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management_object;
            org_kde_plasma_virtual_desktop_management *object() { return org_kde_plasma_virtual_desktop_management_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_desktop_created(const QString &desktop_id, uint32_t position);
        void send_desktop_created(struct ::wl_resource *resource, const QString &desktop_id, uint32_t position);
        void send_desktop_removed(const QString &desktop_id);
        void send_desktop_removed(struct ::wl_resource *resource, const QString &desktop_id);
        void send_done();
        void send_done(struct ::wl_resource *resource);
        void send_rows(uint32_t rows);
        void send_rows(struct ::wl_resource *resource, uint32_t rows);

    protected:
        virtual Resource *org_kde_plasma_virtual_desktop_management_allocate();

        virtual void org_kde_plasma_virtual_desktop_management_destroy_global();

        virtual void org_kde_plasma_virtual_desktop_management_bind_resource(Resource *resource);
        virtual void org_kde_plasma_virtual_desktop_management_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_virtual_desktop_management_get_virtual_desktop(Resource *resource, uint32_t id, const QString &desktop_id);
        virtual void org_kde_plasma_virtual_desktop_management_request_create_virtual_desktop(Resource *resource, const QString &name, uint32_t position);
        virtual void org_kde_plasma_virtual_desktop_management_request_remove_virtual_desktop(Resource *resource, const QString &desktop_id);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_virtual_desktop_management_interface m_org_kde_plasma_virtual_desktop_management_interface;

        static void handle_get_virtual_desktop(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            const char *desktop_id);
        static void handle_request_create_virtual_desktop(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *name,
            uint32_t position);
        static void handle_request_remove_virtual_desktop(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *desktop_id);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_virtual_desktop_management *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  org_kde_plasma_virtual_desktop
    {
    public:
        org_kde_plasma_virtual_desktop(struct ::wl_client *client, int id, int version);
        org_kde_plasma_virtual_desktop(struct ::wl_display *display, int version);
        org_kde_plasma_virtual_desktop(struct ::wl_resource *resource);
        org_kde_plasma_virtual_desktop();

        virtual ~org_kde_plasma_virtual_desktop();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_virtual_desktop_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop_object;
            org_kde_plasma_virtual_desktop *object() { return org_kde_plasma_virtual_desktop_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_desktop_id(const QString &desktop_id);
        void send_desktop_id(struct ::wl_resource *resource, const QString &desktop_id);
        void send_name(const QString &name);
        void send_name(struct ::wl_resource *resource, const QString &name);
        void send_activated();
        void send_activated(struct ::wl_resource *resource);
        void send_deactivated();
        void send_deactivated(struct ::wl_resource *resource);
        void send_done();
        void send_done(struct ::wl_resource *resource);
        void send_removed();
        void send_removed(struct ::wl_resource *resource);
        void send_position(uint32_t index);
        void send_position(struct ::wl_resource *resource, uint32_t index);

    protected:
        virtual Resource *org_kde_plasma_virtual_desktop_allocate();

        virtual void org_kde_plasma_virtual_desktop_destroy_global();

        virtual void org_kde_plasma_virtual_desktop_bind_resource(Resource *resource);
        virtual void org_kde_plasma_virtual_desktop_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_virtual_desktop_request_activate(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_virtual_desktop_interface m_org_kde_plasma_virtual_desktop_interface;

        static void handle_request_activate(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_virtual_desktop *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
