
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kanimatedbutton_wrapper.h"

// Wrappers providing overrides
#include "ksplittercollapserbutton_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QString>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAnimatedButton_Type = nullptr;
static PyTypeObject *Sbk_KAnimatedButton_TypeF(void)
{
    return _Sbk_KAnimatedButton_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KAnimatedButtonWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KAnimatedButtonWrapper::KAnimatedButtonWrapper(::QWidget * parent) : KAnimatedButton(parent)
{
}

void KAnimatedButtonWrapper::actionEvent(::QActionEvent * arg__1)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::actionEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

void KAnimatedButtonWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::changeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

void KAnimatedButtonWrapper::checkStateSet()
{
    static const char *funcName = "checkStateSet";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::checkStateSet();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KAnimatedButton", funcName, gil, pyOverride);
}

void KAnimatedButtonWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KAnimatedButton", funcName, gil, pyOverride, signal);
}

void KAnimatedButtonWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

int KAnimatedButtonWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KAnimatedButton", funcName, gil, pyOverride);
}

void KAnimatedButtonWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KAnimatedButton", funcName, gil, pyOverride, signal);
}

void KAnimatedButtonWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::enterEvent(::QEnterEvent * arg__1)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::enterEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

bool KAnimatedButtonWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::event(e);
    }
    return KXYSelectorWrapper::sbk_o_event("KAnimatedButton", funcName, gil, pyOverride, e);
}

bool KAnimatedButtonWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KAnimatedButton", funcName, gil, pyOverride, watched, event);
}

void KAnimatedButtonWrapper::focusInEvent(::QFocusEvent * e)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::focusInEvent(e);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KAnimatedButton", funcName, gil, pyOverride, e);
}

bool KAnimatedButtonWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KAnimatedButton", funcName, gil, pyOverride, next);
}

void KAnimatedButtonWrapper::focusOutEvent(::QFocusEvent * e)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::focusOutEvent(e);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KAnimatedButton", funcName, gil, pyOverride, e);
}

bool KAnimatedButtonWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KAnimatedButton", funcName, gil, pyOverride);
}

int KAnimatedButtonWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

void KAnimatedButtonWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

bool KAnimatedButtonWrapper::hitButton(const ::QPoint & pos) const
{
    static const char *funcName = "hitButton";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::hitButton(pos);
    }
    return KSplitterCollapserButtonWrapper::sbk_o_hitButton("KAnimatedButton", funcName, gil, pyOverride, pos);
}

void KAnimatedButtonWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KAnimatedButton", funcName, gil, pyOverride, painter);
}

void KAnimatedButtonWrapper::initStyleOption(::QStyleOptionToolButton * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::initStyleOption(option);
    }
    KSplitterCollapserButtonWrapper::sbk_o_initStyleOption("KAnimatedButton", funcName, gil, pyOverride, option);
}

void KAnimatedButtonWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

::QVariant KAnimatedButtonWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

void KAnimatedButtonWrapper::keyPressEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::keyPressEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KAnimatedButton", funcName, gil, pyOverride, e);
}

void KAnimatedButtonWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::keyReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KAnimatedButton", funcName, gil, pyOverride, e);
}

void KAnimatedButtonWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::leaveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

int KAnimatedButtonWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

::QSize KAnimatedButtonWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KAnimatedButton", funcName, gil, pyOverride);
}

void KAnimatedButtonWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::mouseMoveEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mouseMoveEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KAnimatedButton", funcName, gil, pyOverride, e);
}

void KAnimatedButtonWrapper::mousePressEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::mousePressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

void KAnimatedButtonWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::mouseReleaseEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

void KAnimatedButtonWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

bool KAnimatedButtonWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KAnimatedButton", funcName, gil, pyOverride, eventType, message, result);
}

void KAnimatedButtonWrapper::nextCheckState()
{
    static const char *funcName = "nextCheckState";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::nextCheckState();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KAnimatedButton", funcName, gil, pyOverride);
}

::QPaintEngine * KAnimatedButtonWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KAnimatedButton", funcName, gil, pyOverride);
}

void KAnimatedButtonWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KAnimatedButtonWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KAnimatedButton", funcName, gil, pyOverride, offset);
}

void KAnimatedButtonWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KAnimatedButton", funcName, gil, pyOverride, visible);
}

::QPainter * KAnimatedButtonWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KAnimatedButton", funcName, gil, pyOverride);
}

void KAnimatedButtonWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

::QSize KAnimatedButtonWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KAnimatedButton", funcName, gil, pyOverride);
}

void KAnimatedButtonWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

void KAnimatedButtonWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::timerEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KAnimatedButton", funcName, gil, pyOverride, arg__1);
}

void KAnimatedButtonWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAnimatedButton_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KAnimatedButton", funcName, gil, pyOverride, event);
}

const QMetaObject *KAnimatedButtonWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KAnimatedButton::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KAnimatedButtonWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KAnimatedButton::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KAnimatedButtonWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KAnimatedButtonWrapper *>(this));
    }
    return KAnimatedButton::qt_metacast(_clname);
}

KAnimatedButtonWrapper::~KAnimatedButtonWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KAnimatedButton_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAnimatedButton_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAnimatedButton >()))
        return -1;

    KAnimatedButtonWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KAnimatedButton", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAnimatedButton::KAnimatedButton(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KAnimatedButton(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KAnimatedButton(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KAnimatedButton(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KAnimatedButtonWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KAnimatedButtonWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KAnimatedButton >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KAnimatedButtonFunc_animationPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAnimatedButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // animationPath()const
        QString cppResult = const_cast<const ::KAnimatedButton *>(cppSelf)->animationPath();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAnimatedButtonFunc_setAnimationPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAnimatedButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAnimatedButton::setAnimationPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setAnimationPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAnimationPath", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAnimationPath(QString)
            cppSelf->setAnimationPath(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAnimatedButtonFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAnimatedButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // start()
        cppSelf->start();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAnimatedButtonFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAnimatedButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stop()
        cppSelf->stop();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KAnimatedButton_PropertyStrings[] = {
    "animationPath::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAnimatedButton_methods[] = {
    {"animationPath", reinterpret_cast<PyCFunction>(Sbk_KAnimatedButtonFunc_animationPath), METH_NOARGS, nullptr},
    {"setAnimationPath", reinterpret_cast<PyCFunction>(Sbk_KAnimatedButtonFunc_setAnimationPath), METH_O, nullptr},
    {"start", reinterpret_cast<PyCFunction>(Sbk_KAnimatedButtonFunc_start), METH_NOARGS, nullptr},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_KAnimatedButtonFunc_stop), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KAnimatedButton_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KAnimatedButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KAnimatedButtonWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KAnimatedButton_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAnimatedButton_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KAnimatedButtonSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KAnimatedButton *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX]))
        return static_cast< ::QToolButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractButton_IDX]))
        return static_cast< ::QAbstractButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAnimatedButton_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KAnimatedButton_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAnimatedButton_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAnimatedButton_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAnimatedButton_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAnimatedButton_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAnimatedButton_spec = {
    "1:KWidgetsAddons.KAnimatedButton",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAnimatedButton_slots
};

} //extern "C"

static void *Sbk_KAnimatedButton_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KAnimatedButton *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KAnimatedButton *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KAnimatedButton *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAnimatedButton_PythonToCpp_KAnimatedButton_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAnimatedButton_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAnimatedButton_PythonToCpp_KAnimatedButton_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAnimatedButton_TypeF()))
        return KAnimatedButton_PythonToCpp_KAnimatedButton_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAnimatedButton_PTR_CppToPython_KAnimatedButton(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KAnimatedButton *>(const_cast<void *>(cppIn)), Sbk_KAnimatedButton_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAnimatedButton_SignatureStrings[] = {
    "KWidgetsAddons.KAnimatedButton(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,animationPath:QString=None)",
    "KWidgetsAddons.KAnimatedButton.animationPath(self)->QString",
    "KWidgetsAddons.KAnimatedButton.setAnimationPath(self,path:QString)",
    "KWidgetsAddons.KAnimatedButton.start(self)",
    "KWidgetsAddons.KAnimatedButton.stop(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KAnimatedButton_SignatureByteSize = 152;
static constexpr uint8_t KAnimatedButton_SignatureBytes[152] = {
    0x78, 0xda, 0x85, 0x8f, 0x4d, 0x0b, 0x02, 0x21, 0x10, 0x86, 0xef, 0xfd, 0x92, 0x36, 0xcc, 0x63,
    0x07, 0x61, 0x03, 0xbb, 0x0a, 0xb5, 0xb2, 0x87, 0xce, 0x82, 0xd3, 0x26, 0xd8, 0x28, 0x3a, 0x4b,
    0xec, 0xbf, 0x2f, 0x5c, 0x21, 0x22, 0xc8, 0xdb, 0xc0, 0xbc, 0xcf, 0xfb, 0xa1, 0xae, 0xce, 0x4e,
    0x40, 0x59, 0x5a, 0x1b, 0x30, 0x73, 0x25, 0xd1, 0x3d, 0x0c, 0x81, 0x3d, 0xcd, 0x44, 0x01, 0xb7,
    0x19, 0xfc, 0x8d, 0x45, 0x93, 0x00, 0x49, 0x0c, 0xcb, 0xe8, 0x2c, 0x1c, 0xb8, 0xa6, 0xca, 0x70,
    0xbd, 0x1e, 0x3d, 0xce, 0xde, 0x47, 0x4a, 0x6c, 0x27, 0x14, 0x2c, 0xcf, 0x90, 0xec, 0x05, 0xfd,
    0xd2, 0x9f, 0x03, 0x02, 0x33, 0xc5, 0xcf, 0x05, 0x1c, 0x0c, 0xdd, 0x85, 0x1e, 0x29, 0x39, 0x9c,
    0xca, 0xab, 0xdb, 0xa8, 0xbf, 0xd9, 0xfc, 0x0b, 0x2d, 0x4d, 0xba, 0xfd, 0xb1, 0x3a, 0xb4, 0xd8,
    0x0c, 0x24, 0x7f, 0xf0, 0xf7, 0x90, 0x4f, 0x87, 0x66, 0x7c, 0x26, 0x93, 0x68, 0x8d, 0x6d, 0x4b,
    0x43, 0xac, 0xca, 0x17, 0xb1, 0x3c, 0x7d, 0x14
};
#endif

PyTypeObject *init_KAnimatedButton(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX].type;

    Shiboken::AutoDecRef Sbk_KAnimatedButton_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX]))));

    _Sbk_KAnimatedButton_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAnimatedButton",
        "KAnimatedButton*",
        &Sbk_KAnimatedButton_spec,
        &Shiboken::callCppDestructor< KAnimatedButton >,
        Sbk_KAnimatedButton_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KAnimatedButton_Type; // references _Sbk_KAnimatedButton_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAnimatedButton_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAnimatedButton_SignatureBytes, KAnimatedButton_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAnimatedButton_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAnimatedButton_PythonToCpp_KAnimatedButton_PTR,
        is_KAnimatedButton_PythonToCpp_KAnimatedButton_PTR_Convertible,
        KAnimatedButton_PTR_CppToPython_KAnimatedButton);

    Shiboken::Conversions::registerConverterName(converter, "KAnimatedButton");
    Shiboken::Conversions::registerConverterName(converter, "KAnimatedButton*");
    Shiboken::Conversions::registerConverterName(converter, "KAnimatedButton&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAnimatedButton).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KAnimatedButtonWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KAnimatedButton_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KAnimatedButton_TypeF(), &Sbk_KAnimatedButtonSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KAnimatedButton_TypeF(), &Sbk_KAnimatedButton_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KAnimatedButton::staticMetaObject, sizeof(KAnimatedButtonWrapper));

    return pyType;
}
