
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpassworddialog_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "kpixmapregionselectordialog_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QMap>
#include <QString>
#include <kpassword.h>
#include <kpassworddialog.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdialogbuttonbox.h>
#include <qevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPasswordDialog_Type = nullptr;
static PyTypeObject *Sbk_KPasswordDialog_TypeF(void)
{
    return _Sbk_KPasswordDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPasswordDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPasswordDialogWrapper::KPasswordDialogWrapper(::QWidget * parent, const ::QFlags<KPasswordDialog::KPasswordDialogFlag> & flags) : KPasswordDialog(parent, flags)
{
}

void KPasswordDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPasswordDialog::accept();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

bool KPasswordDialogWrapper::checkPassword()
{
    static const char *funcName = "checkPassword";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPasswordDialog::checkPassword();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KPasswordDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPasswordDialog", funcName, gil, pyOverride, signal);
}

void KPasswordDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KPasswordDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

int KPasswordDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPasswordDialog", funcName, gil, pyOverride, signal);
}

void KPasswordDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    KPixmapRegionSelectorDialogWrapper::sbk_o_done("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KPasswordDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

bool KPasswordDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPasswordDialog", funcName, gil, pyOverride, event);
}

bool KPasswordDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPasswordDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KPasswordDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return KPixmapRegionSelectorDialogWrapper::sbk_o_exec("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

bool KPasswordDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KPasswordDialog", funcName, gil, pyOverride, next);
}

void KPasswordDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

bool KPasswordDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPasswordDialog", funcName, gil, pyOverride);
}

int KPasswordDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KPasswordDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KPasswordDialog", funcName, gil, pyOverride, painter);
}

void KPasswordDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

::QVariant KPasswordDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KPasswordDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KPasswordDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

int KPasswordDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KPasswordDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

bool KPasswordDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KPasswordDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KPasswordDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPasswordDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KPasswordDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KPasswordDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KPasswordDialog", funcName, gil, pyOverride, offset);
}

void KPasswordDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

void KPasswordDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KPasswordDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KPasswordDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::showEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KPasswordDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KPasswordDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPasswordDialog", funcName, gil, pyOverride);
}

void KPasswordDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

void KPasswordDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordDialog_TypeF(), gil, funcName, m_PyMethodCache[52], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KPasswordDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KPasswordDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPasswordDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPasswordDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPasswordDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPasswordDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPasswordDialogWrapper *>(this));
    }
    return KPasswordDialog::qt_metacast(_clname);
}

KPasswordDialogWrapper::~KPasswordDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPasswordDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPasswordDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPasswordDialog >()))
        return -1;

    KPasswordDialogWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KPasswordDialog", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPasswordDialog::KPasswordDialog(QWidget*=,const QFlags<KPasswordDialog::KPasswordDialogFlag>&=)
    if (numArgs == 0) {
        overloadId = 0; // KPasswordDialog(QWidget*,QFlags<KPasswordDialog::KPasswordDialogFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KPasswordDialog(QWidget*,QFlags<KPasswordDialog::KPasswordDialogFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KPasswordDialog_KPasswordDialogFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // KPasswordDialog(QWidget*,QFlags<KPasswordDialog::KPasswordDialogFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 0}, {"flags", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KPasswordDialog_KPasswordDialogFlag_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KPasswordDialog::KPasswordDialogFlag> cppArg1(KPasswordDialog::NoFlags);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KPasswordDialog(QWidget*,QFlags<KPasswordDialog::KPasswordDialogFlag>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KPasswordDialogWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KPasswordDialogWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPasswordDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPasswordDialogFunc_accept(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // accept()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KPasswordDialog::accept()
            : cppSelf->accept();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_addCommentLine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addCommentLine", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPasswordDialog::addCommentLine(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // addCommentLine(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addCommentLine", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addCommentLine(QString,QString)
            cppSelf->addCommentLine(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_anonymousMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // anonymousMode()const
        bool cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->anonymousMode();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_buttonBox(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // buttonBox()const
        QDialogButtonBox * cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->buttonBox();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialogButtonBox_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_checkPassword(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // checkPassword()
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KPasswordDialog::checkPassword()
            : cppSelf->checkPassword();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_domain(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // domain()const
        QString cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->domain();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_isRevealPasswordAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KPasswordDialog", "isRevealPasswordAvailable() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // isRevealPasswordAvailable()const
        bool cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->isRevealPasswordAvailable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_keepPassword(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // keepPassword()const
        bool cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->keepPassword();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_password(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // password()const
        QString cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->password();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_prompt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // prompt()const
        QString cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->prompt();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_revealPasswordMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // revealPasswordMode()const
        KPassword::RevealMode cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->revealPasswordMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordDialogFunc_setAnonymousMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setAnonymousMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAnonymousMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAnonymousMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAnonymousMode(bool)
            cppSelf->setAnonymousMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setDomain(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setDomain(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDomain(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDomain", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDomain(QString)
            cppSelf->setDomain(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setKeepPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setKeepPassword(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setKeepPassword(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setKeepPassword", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setKeepPassword(bool)
            cppSelf->setKeepPassword(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setKnownLogins(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setKnownLogins(QMap<QString,QString>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QString_IDX], (pyArg)))) {
        overloadId = 0; // setKnownLogins(QMap<QString,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setKnownLogins", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::QMap<QString,QString> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setKnownLogins(QMap<QString,QString>)
            cppSelf->setKnownLogins(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setPassword(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setPassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPassword", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPassword(QString)
            cppSelf->setPassword(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setPrompt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setPrompt(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setPrompt(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPrompt", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPrompt(QString)
            cppSelf->setPrompt(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setRevealPasswordAvailable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setRevealPasswordAvailable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRevealPasswordAvailable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordAvailable", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KPasswordDialog", "setRevealPasswordAvailable(bool reveal)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordAvailable(bool)
            cppSelf->setRevealPasswordAvailable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setRevealPasswordMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setRevealPasswordMode(KPassword::RevealMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setRevealPasswordMode(KPassword::RevealMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::KPassword::RevealMode cppArg0{KPassword::RevealMode::OnlyNew};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordMode(KPassword::RevealMode)
            cppSelf->setRevealPasswordMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setUsername(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setUsername(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setUsername(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUsername", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUsername(QString)
            cppSelf->setUsername(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setUsernameContextHelp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setUsernameContextHelp(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setUsernameContextHelp(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUsernameContextHelp", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUsernameContextHelp(QString)
            cppSelf->setUsernameContextHelp(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_setUsernameReadOnly(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordDialog::setUsernameReadOnly(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUsernameReadOnly(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUsernameReadOnly", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUsernameReadOnly(bool)
            cppSelf->setUsernameReadOnly(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_showErrorMessage(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "showErrorMessage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    if (PyArg_ParseTuple(args, "|OO:showErrorMessage", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KPasswordDialog::showErrorMessage(QString,KPasswordDialog::ErrorType=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // showErrorMessage(QString,KPasswordDialog::ErrorType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_ErrorType_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // showErrorMessage(QString,KPasswordDialog::ErrorType)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showErrorMessage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"type", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_ErrorType_IDX])))->converter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "showErrorMessage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KPasswordDialog::ErrorType cppArg1(KPasswordDialog::ErrorType::PasswordError);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showErrorMessage(QString,KPasswordDialog::ErrorType)
            cppSelf->showErrorMessage(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordDialogFunc_username(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // username()const
        QString cppResult = const_cast<const ::KPasswordDialog *>(cppSelf)->username();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPasswordDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KPasswordDialog_EnumFlagInfo[] = {
    "ErrorType:IntEnum",
    "KPasswordDialogFlag:IntFlag:KPasswordDialogFlags",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPasswordDialog_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_accept), METH_NOARGS, nullptr},
    {"addCommentLine", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_addCommentLine), METH_VARARGS, nullptr},
    {"anonymousMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_anonymousMode), METH_NOARGS, nullptr},
    {"buttonBox", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_buttonBox), METH_NOARGS, nullptr},
    {"checkPassword", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_checkPassword), METH_NOARGS, nullptr},
    {"domain", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_domain), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_icon), METH_NOARGS, nullptr},
    {"isRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_isRevealPasswordAvailable), METH_NOARGS, nullptr},
    {"keepPassword", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_keepPassword), METH_NOARGS, nullptr},
    {"password", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_password), METH_NOARGS, nullptr},
    {"prompt", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_prompt), METH_NOARGS, nullptr},
    {"revealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_revealPasswordMode), METH_NOARGS, nullptr},
    {"setAnonymousMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setAnonymousMode), METH_O, nullptr},
    {"setDomain", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setDomain), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setIcon), METH_O, nullptr},
    {"setKeepPassword", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setKeepPassword), METH_O, nullptr},
    {"setKnownLogins", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setKnownLogins), METH_O, nullptr},
    {"setPassword", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setPassword), METH_O, nullptr},
    {"setPrompt", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setPrompt), METH_O, nullptr},
    {"setRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setRevealPasswordAvailable), METH_O, nullptr},
    {"setRevealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setRevealPasswordMode), METH_O, nullptr},
    {"setUsername", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setUsername), METH_O, nullptr},
    {"setUsernameContextHelp", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setUsernameContextHelp), METH_O, nullptr},
    {"setUsernameReadOnly", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_setUsernameReadOnly), METH_O, nullptr},
    {"showErrorMessage", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_showErrorMessage), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"username", reinterpret_cast<PyCFunction>(Sbk_KPasswordDialogFunc_username), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPasswordDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPasswordDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPasswordDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPasswordDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPasswordDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KPasswordDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KPasswordDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPasswordDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPasswordDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPasswordDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPasswordDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPasswordDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPasswordDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPasswordDialog_spec = {
    "1:KWidgetsAddons.KPasswordDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPasswordDialog_slots
};

} //extern "C"

static void *Sbk_KPasswordDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KPasswordDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPasswordDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KPasswordDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KPasswordDialog_KPasswordDialogFlag(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KPasswordDialog::KPasswordDialogFlag>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KPasswordDialog::KPasswordDialogFlag *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KPasswordDialog_KPasswordDialogFlag_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_KPasswordDialogFlag_IDX])))
        return Enum_PythonToCpp_KPasswordDialog_KPasswordDialogFlag;
    return {};
}

static PyObject *KPasswordDialog_KPasswordDialogFlag_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KPasswordDialog::KPasswordDialogFlag>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KPasswordDialog::KPasswordDialogFlag *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KPasswordDialog_KPasswordDialogFlag(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KPasswordDialog::KPasswordDialogFlag>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KPasswordDialog::KPasswordDialogFlag> *>(cppOut) = value;

}

static PyObject *KPasswordDialog_KPasswordDialogFlag_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KPasswordDialog::KPasswordDialogFlag> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_KPasswordDialogFlag_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KPasswordDialog_ErrorType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KPasswordDialog::ErrorType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KPasswordDialog::ErrorType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KPasswordDialog_ErrorType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_ErrorType_IDX])))
        return Enum_PythonToCpp_KPasswordDialog_ErrorType;
    return {};
}

static PyObject *KPasswordDialog_ErrorType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KPasswordDialog::ErrorType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KPasswordDialog::ErrorType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPasswordDialog_PythonToCpp_KPasswordDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPasswordDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPasswordDialog_PythonToCpp_KPasswordDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPasswordDialog_TypeF()))
        return KPasswordDialog_PythonToCpp_KPasswordDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPasswordDialog_PTR_CppToPython_KPasswordDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPasswordDialog *>(const_cast<void *>(cppIn)), Sbk_KPasswordDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPasswordDialog_SignatureStrings[] = {
    "KWidgetsAddons.KPasswordDialog(self,parent:PySide6.QtWidgets.QWidget=nullptr,flags:KWidgetsAddons.KPasswordDialog.KPasswordDialogFlag=KPasswordDialog.NoFlags)",
    "KWidgetsAddons.KPasswordDialog.accept(self)",
    "KWidgetsAddons.KPasswordDialog.addCommentLine(self,label:QString,comment:QString)",
    "KWidgetsAddons.KPasswordDialog.anonymousMode(self)->bool",
    "KWidgetsAddons.KPasswordDialog.buttonBox(self)->PySide6.QtWidgets.QDialogButtonBox",
    "KWidgetsAddons.KPasswordDialog.checkPassword(self)->bool",
    "KWidgetsAddons.KPasswordDialog.domain(self)->QString",
    "KWidgetsAddons.KPasswordDialog.icon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KPasswordDialog.isRevealPasswordAvailable(self)->bool",
    "KWidgetsAddons.KPasswordDialog.keepPassword(self)->bool",
    "KWidgetsAddons.KPasswordDialog.password(self)->QString",
    "KWidgetsAddons.KPasswordDialog.prompt(self)->QString",
    "KWidgetsAddons.KPasswordDialog.revealPasswordMode(self)->KWidgetsAddons.KPassword.RevealMode",
    "KWidgetsAddons.KPasswordDialog.setAnonymousMode(self,anonymous:bool)",
    "KWidgetsAddons.KPasswordDialog.setDomain(self,arg__1:QString)",
    "KWidgetsAddons.KPasswordDialog.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KPasswordDialog.setKeepPassword(self,b:bool)",
    "KWidgetsAddons.KPasswordDialog.setKnownLogins(self,knownLogins:QMap[QString, QString])",
    "KWidgetsAddons.KPasswordDialog.setPassword(self,password:QString)",
    "KWidgetsAddons.KPasswordDialog.setPrompt(self,prompt:QString)",
    "KWidgetsAddons.KPasswordDialog.setRevealPasswordAvailable(self,reveal:bool)",
    "KWidgetsAddons.KPasswordDialog.setRevealPasswordMode(self,revealPasswordMode:KWidgetsAddons.KPassword.RevealMode)",
    "KWidgetsAddons.KPasswordDialog.setUsername(self,arg__1:QString)",
    "KWidgetsAddons.KPasswordDialog.setUsernameContextHelp(self,help:QString)",
    "KWidgetsAddons.KPasswordDialog.setUsernameReadOnly(self,readOnly:bool)",
    "KWidgetsAddons.KPasswordDialog.showErrorMessage(self,message:QString,type:KWidgetsAddons.KPasswordDialog.ErrorType=KPasswordDialog.ErrorType.PasswordError)",
    "KWidgetsAddons.KPasswordDialog.username(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KPasswordDialog_SignatureByteSize = 473;
static constexpr uint8_t KPasswordDialog_SignatureBytes[473] = {
    0x78, 0xda, 0x9d, 0x55, 0x4d, 0x6f, 0x1b, 0x21, 0x10, 0xbd, 0xf7, 0x57, 0xe4, 0x58, 0x4b, 0x64,
    0xa5, 0x5e, 0x7a, 0x58, 0xc9, 0x95, 0x9c, 0xa4, 0x1f, 0xd1, 0xc6, 0x8d, 0xd7, 0x49, 0xd4, 0x43,
    0x54, 0x45, 0x78, 0x99, 0xac, 0x91, 0x59, 0x06, 0x01, 0x1b, 0xdb, 0xff, 0x3e, 0xd8, 0x98, 0xd8,
    0x59, 0x3b, 0x01, 0xfb, 0x06, 0xc3, 0xbc, 0xc7, 0xbc, 0xe1, 0x01, 0xc5, 0x3f, 0xce, 0x6a, 0xb0,
    0x66, 0xc0, 0x18, 0x4a, 0x93, 0x15, 0x23, 0x6a, 0xcc, 0x1c, 0x35, 0xbb, 0xe2, 0x54, 0x60, 0xfd,
    0xd5, 0x80, 0x78, 0x26, 0x8a, 0x6a, 0x90, 0x36, 0x1f, 0x2d, 0xef, 0x38, 0x83, 0xef, 0x59, 0x69,
    0x37, 0x98, 0xac, 0xf4, 0x83, 0xbe, 0x6c, 0x85, 0x50, 0x56, 0x93, 0x67, 0x41, 0x6b, 0x93, 0x17,
    0x9f, 0x52, 0x76, 0xe7, 0xbf, 0x1c, 0xa6, 0xdf, 0xcd, 0xf9, 0x8b, 0xab, 0xb0, 0xe9, 0x7d, 0x89,
    0x70, 0xd1, 0xaa, 0x02, 0x65, 0xd7, 0x55, 0xc6, 0x73, 0x19, 0xbb, 0xc4, 0xa6, 0x71, 0x4a, 0x6e,
    0xb8, 0x04, 0xaf, 0x4c, 0xd0, 0x09, 0x88, 0xbc, 0xbc, 0xb3, 0x9a, 0xcb, 0x9a, 0x54, 0x7e, 0x39,
    0xcc, 0xe3, 0x8c, 0x12, 0xe5, 0xb2, 0xc1, 0xd6, 0x0c, 0x91, 0x79, 0xc2, 0xde, 0xf9, 0x8f, 0x09,
    0xa2, 0x88, 0x01, 0x27, 0xad, 0xb5, 0x28, 0x2f, 0x70, 0x11, 0x40, 0x07, 0x5a, 0xeb, 0x53, 0x2f,
    0x42, 0x66, 0x8c, 0xb2, 0x9a, 0x42, 0x35, 0x0b, 0xb1, 0x63, 0x6a, 0x61, 0xd8, 0x50, 0x2e, 0x03,
    0x62, 0x23, 0x3d, 0x06, 0xe2, 0x15, 0xca, 0xfd, 0xda, 0x7f, 0xb7, 0x3c, 0x2b, 0xaf, 0xdd, 0x52,
    0x14, 0x6e, 0xc6, 0xf0, 0x02, 0x54, 0x84, 0xf0, 0xe0, 0x85, 0x72, 0x77, 0x14, 0xe2, 0xa8, 0x26,
    0xce, 0x00, 0xd4, 0x29, 0x82, 0x55, 0x07, 0x93, 0x28, 0x59, 0x69, 0x6c, 0x82, 0xd5, 0x92, 0x41,
    0xfa, 0x9d, 0xcc, 0x5d, 0x9b, 0x7c, 0x04, 0xcc, 0x7c, 0x67, 0x56, 0xa9, 0x31, 0x72, 0x03, 0x76,
    0xb0, 0xe7, 0x40, 0xf2, 0x66, 0xca, 0x7c, 0xd5, 0x8c, 0x5e, 0x02, 0xc9, 0xd5, 0xd6, 0x01, 0x84,
    0xea, 0xfa, 0xe9, 0xe9, 0x5b, 0xf2, 0x0d, 0x70, 0xe8, 0xeb, 0x60, 0x05, 0xb2, 0x32, 0x45, 0x6e,
    0x97, 0xca, 0x01, 0xb3, 0x07, 0xc9, 0x51, 0x3e, 0x1e, 0xb0, 0x06, 0x39, 0xeb, 0x04, 0x47, 0x7c,
    0xd1, 0x50, 0xf5, 0x3f, 0x65, 0xab, 0xa2, 0x7b, 0xe2, 0x64, 0x92, 0x2c, 0xb2, 0x90, 0x38, 0x97,
    0x37, 0x58, 0x73, 0x69, 0x3c, 0x74, 0xb6, 0x0d, 0xe4, 0xe5, 0x90, 0xaa, 0xc7, 0xf0, 0x0a, 0x9c,
    0x6d, 0x06, 0x49, 0x25, 0xbd, 0x2f, 0x27, 0x58, 0xeb, 0x98, 0xfe, 0x8d, 0xb6, 0xbe, 0x22, 0xde,
    0x63, 0xc7, 0xa0, 0x3f, 0xbb, 0x47, 0xc4, 0xbb, 0x2f, 0xb9, 0x45, 0xe3, 0xc3, 0x66, 0x25, 0xfb,
    0x26, 0xce, 0x13, 0xdc, 0x9b, 0xb2, 0xe3, 0x83, 0x01, 0x2d, 0x69, 0x03, 0xa7, 0x7a, 0x2f, 0xe0,
    0x2f, 0x51, 0x5a, 0x58, 0xd8, 0x3f, 0x20, 0x94, 0xa7, 0x9a, 0xba, 0xd1, 0x29, 0x44, 0x63, 0xa0,
    0xec, 0x56, 0x8a, 0x65, 0x10, 0xee, 0x67, 0x89, 0x1d, 0x9c, 0xe2, 0xfc, 0xa7, 0xd6, 0xa8, 0x87,
    0x60, 0x0c, 0xad, 0x37, 0xa2, 0x1a, 0x3f, 0x79, 0xfb, 0x63, 0xdc, 0xfd, 0x80, 0xd8, 0x0f, 0xb9,
    0x66, 0xb9, 0x77, 0x89, 0xfd, 0x0f, 0x57, 0xb2, 0xb0, 0xb0, 0x8e, 0x44, 0x6b, 0x6b, 0x77, 0x1b,
    0xbd, 0xf3, 0x7c, 0xbd, 0x02, 0x42, 0xee, 0xfd, 0x0c
};
#endif

PyTypeObject *init_KPasswordDialog(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KPasswordDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))));

    _Sbk_KPasswordDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPasswordDialog",
        "KPasswordDialog*",
        &Sbk_KPasswordDialog_spec,
        &Shiboken::callCppDestructor< KPasswordDialog >,
        Sbk_KPasswordDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KPasswordDialog_Type; // references _Sbk_KPasswordDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPasswordDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPasswordDialog_SignatureBytes, KPasswordDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPasswordDialog_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPasswordDialog_PythonToCpp_KPasswordDialog_PTR,
        is_KPasswordDialog_PythonToCpp_KPasswordDialog_PTR_Convertible,
        KPasswordDialog_PTR_CppToPython_KPasswordDialog);

    Shiboken::Conversions::registerConverterName(converter, "KPasswordDialog");
    Shiboken::Conversions::registerConverterName(converter, "KPasswordDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KPasswordDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPasswordDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPasswordDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KPasswordDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KPasswordDialog_TypeF(), &Sbk_KPasswordDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPasswordDialog_TypeF(), &Sbk_KPasswordDialog_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KPasswordDialog_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'KPasswordDialogFlag'.
    const char *KPasswordDialogFlag_Initializer[] = {
        "NoFlags",
        "ShowKeepPassword",
        "ShowUsernameLine",
        "UsernameReadOnly",
        "ShowAnonymousLoginCheckBox",
        "ShowDomainLine",
        "DomainReadOnly",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t KPasswordDialogFlag_InitializerValues[] = {
        uint8_t(KPasswordDialog::KPasswordDialogFlag::NoFlags),                    //  0x00  0
        uint8_t(KPasswordDialog::KPasswordDialogFlag::ShowKeepPassword),           //  0x01  1
        uint8_t(KPasswordDialog::KPasswordDialogFlag::ShowUsernameLine),           //  0x02  2
        uint8_t(KPasswordDialog::KPasswordDialogFlag::UsernameReadOnly),           //  0x04  4
        uint8_t(KPasswordDialog::KPasswordDialogFlag::ShowAnonymousLoginCheckBox), //  0x08  8
        uint8_t(KPasswordDialog::KPasswordDialogFlag::ShowDomainLine),             //  0x10  16
        uint8_t(KPasswordDialog::KPasswordDialogFlag::DomainReadOnly)              //  0x20  32
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KPasswordDialog_TypeF(),
        "1:KWidgetsAddons.KPasswordDialog.KPasswordDialogFlag",
        KPasswordDialogFlag_Initializer, KPasswordDialogFlag_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_KPasswordDialogFlag_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KPasswordDialog_KPasswordDialogFlag_IDX].type =
        EType;
    // Register converter for enum 'KPasswordDialog::KPasswordDialogFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KPasswordDialog_KPasswordDialogFlag_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KPasswordDialog_KPasswordDialogFlag,
            is_Enum_PythonToCpp_KPasswordDialog_KPasswordDialogFlag_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KPasswordDialog::KPasswordDialogFlag");
        Shiboken::Conversions::registerConverterAlias(converter, "KPasswordDialogFlag");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KPasswordDialog_KPasswordDialogFlag_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KPasswordDialog_KPasswordDialogFlag,
            is_Enum_PythonToCpp_KPasswordDialog_KPasswordDialogFlag_Convertible);
        // Register converter for flag 'QFlags<KPasswordDialog::KPasswordDialogFlag>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KPasswordDialog::KPasswordDialogFlag>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KPasswordDialog::KPasswordDialogFlags");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'KPasswordDialogFlag' enum/flags.

    // Initialization of enum 'ErrorType'.
    const char *ErrorType_Initializer[] = {
        "UnknownError",
        "UsernameError",
        "PasswordError",
        "FatalError",
        "DomainError",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ErrorType_InitializerValues[] = {
        uint8_t(KPasswordDialog::ErrorType::UnknownError),  //  0x00  0
        uint8_t(KPasswordDialog::ErrorType::UsernameError), //  0x01  1
        uint8_t(KPasswordDialog::ErrorType::PasswordError), //  0x02  2
        uint8_t(KPasswordDialog::ErrorType::FatalError),    //  0x03  3
        uint8_t(KPasswordDialog::ErrorType::DomainError)    //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KPasswordDialog_TypeF(),
        "1:KWidgetsAddons.KPasswordDialog.ErrorType",
        ErrorType_Initializer, ErrorType_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_ErrorType_IDX].type = EType;
    // Register converter for enum 'KPasswordDialog::ErrorType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KPasswordDialog_ErrorType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KPasswordDialog_ErrorType,
            is_Enum_PythonToCpp_KPasswordDialog_ErrorType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KPasswordDialog::ErrorType");
        Shiboken::Conversions::registerConverterAlias(converter, "ErrorType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ErrorType' enum.

    PySide::Signal::registerSignals(pyType, &::KPasswordDialog::staticMetaObject);
    qRegisterMetaType< ::KPasswordDialog::KPasswordDialogFlag >("KPasswordDialog::KPasswordDialogFlag");
    qRegisterMetaType< ::KPasswordDialog::ErrorType >("KPasswordDialog::ErrorType");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPasswordDialog::staticMetaObject, sizeof(KPasswordDialogWrapper));

    return pyType;
}
