
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kguiitem_wrapper.h"

// Argument includes
#include <QString>
#include <kguiitem.h>
#include <qicon.h>
#include <qpushbutton.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KGuiItem_Type = nullptr;
static PyTypeObject *Sbk_KGuiItem_TypeF(void)
{
    return _Sbk_KGuiItem_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KGuiItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KGuiItem >()))
        return -1;

    ::KGuiItem *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:KGuiItem", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KGuiItem::KGuiItem()
    // 1: KGuiItem::KGuiItem(KGuiItem)
    // 2: KGuiItem::KGuiItem(QString,QIcon,const QString&=,const QString&=)
    // 3: KGuiItem::KGuiItem(QString,const QString&=,const QString&=,const QString&=)
    if (numArgs == 0) {
        overloadId = 0; // KGuiItem()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // KGuiItem(QString,QString,QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // KGuiItem(QString,QString,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // KGuiItem(QString,QString,QString,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    overloadId = 3; // KGuiItem(QString,QString,QString,QString)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // KGuiItem(QString,QIcon,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // KGuiItem(QString,QIcon,QString,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    overloadId = 2; // KGuiItem(QString,QIcon,QString,QString)
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KGuiItem(KGuiItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KGuiItem()
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);
            }

            // KGuiItem()
            cptr = new ::KGuiItem();
            break;
        }
        case 1: // KGuiItem(const KGuiItem &other)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KGuiItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KGuiItem(KGuiItem)
                cptr = new ::KGuiItem(*cppArg0);
            }
            break;
        }
        case 2: // KGuiItem(const QString &text, const QIcon &icon, const QString &toolTip, const QString &whatsThis)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"toolTip", 2}, {"whatsThis", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QIcon cppArg1_local;
            ::QIcon *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KGuiItem(QString,QIcon,QString,QString)
                cptr = new ::KGuiItem(cppArg0, *cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // KGuiItem(const QString &text, const QString &iconName, const QString &toolTip, const QString &whatsThis)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"iconName", 1}, {"toolTip", 2}, {"whatsThis", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KGuiItem(QString,QString,QString,QString)
                cptr = new ::KGuiItem(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KGuiItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KGuiItemFunc_assign(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "assign", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KGuiItem::assign(QPushButton*,KGuiItem)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // assign(QPushButton*,KGuiItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "assign", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPushButton *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::KGuiItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // assign(QPushButton*,KGuiItem)
            ::KGuiItem::assign(cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGuiItemFunc_hasIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hasIcon()const
        bool cppResult = const_cast<const ::KGuiItem *>(cppSelf)->hasIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGuiItemFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::KGuiItem *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGuiItemFunc_iconName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconName()const
        QString cppResult = const_cast<const ::KGuiItem *>(cppSelf)->iconName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGuiItemFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEnabled()const
        bool cppResult = const_cast<const ::KGuiItem *>(cppSelf)->isEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGuiItemFunc_plainText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // plainText()const
        QString cppResult = const_cast<const ::KGuiItem *>(cppSelf)->plainText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGuiItemFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGuiItem::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGuiItemFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGuiItem::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGuiItemFunc_setIconName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGuiItem::setIconName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setIconName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIconName", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setIconName(QString)
            cppSelf->setIconName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGuiItemFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGuiItem::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGuiItemFunc_setToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGuiItem::setToolTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setToolTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolTip", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolTip(QString)
            cppSelf->setToolTip(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGuiItemFunc_setWhatsThis(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KGuiItem::setWhatsThis(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setWhatsThis(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWhatsThis", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWhatsThis(QString)
            cppSelf->setWhatsThis(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KGuiItemFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // text()const
        QString cppResult = const_cast<const ::KGuiItem *>(cppSelf)->text();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGuiItemFunc_toolTip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolTip()const
        QString cppResult = const_cast<const ::KGuiItem *>(cppSelf)->toolTip();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KGuiItemFunc_whatsThis(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KGuiItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // whatsThis()const
        QString cppResult = const_cast<const ::KGuiItem *>(cppSelf)->whatsThis();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KGuiItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KGuiItem_methods[] = {
    {"assign", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_assign), METH_VARARGS|METH_STATIC, nullptr},
    {"hasIcon", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_hasIcon), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_icon), METH_NOARGS, nullptr},
    {"iconName", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_iconName), METH_NOARGS, nullptr},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_isEnabled), METH_NOARGS, nullptr},
    {"plainText", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_plainText), METH_NOARGS, nullptr},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_setEnabled), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_setIcon), METH_O, nullptr},
    {"setIconName", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_setIconName), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_setText), METH_O, nullptr},
    {"setToolTip", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_setToolTip), METH_O, nullptr},
    {"setWhatsThis", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_setWhatsThis), METH_O, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_text), METH_NOARGS, nullptr},
    {"toolTip", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_toolTip), METH_NOARGS, nullptr},
    {"whatsThis", reinterpret_cast<PyCFunction>(Sbk_KGuiItemFunc_whatsThis), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KGuiItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KGuiItem_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KGuiItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KGuiItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KGuiItem_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KGuiItem_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KGuiItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KGuiItem_spec = {
    "1:KWidgetsAddons.KGuiItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KGuiItem_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KGuiItem_PythonToCpp_KGuiItem_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KGuiItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KGuiItem_PythonToCpp_KGuiItem_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KGuiItem_TypeF()))
        return KGuiItem_PythonToCpp_KGuiItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KGuiItem_PTR_CppToPython_KGuiItem(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KGuiItem_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KGuiItem_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KGuiItem_SignatureStrings[] = {
    "3:KWidgetsAddons.KGuiItem(self)",
    "2:KWidgetsAddons.KGuiItem(self,other:KWidgetsAddons.KGuiItem)",
    "1:KWidgetsAddons.KGuiItem(self,text:QString,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],toolTip:QString=QString(),whatsThis:QString=QString())",
    "0:KWidgetsAddons.KGuiItem(self,text:QString,iconName:QString=QString(),toolTip:QString=QString(),whatsThis:QString=QString())",
    "KWidgetsAddons.KGuiItem.assign(button:PySide6.QtWidgets.QPushButton,item:KWidgetsAddons.KGuiItem)",
    "KWidgetsAddons.KGuiItem.hasIcon(self)->bool",
    "KWidgetsAddons.KGuiItem.icon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KGuiItem.iconName(self)->QString",
    "KWidgetsAddons.KGuiItem.isEnabled(self)->bool",
    "KWidgetsAddons.KGuiItem.plainText(self)->QString",
    "KWidgetsAddons.KGuiItem.setEnabled(self,enable:bool)",
    "KWidgetsAddons.KGuiItem.setIcon(self,iconset:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KGuiItem.setIconName(self,iconName:QString)",
    "KWidgetsAddons.KGuiItem.setText(self,text:QString)",
    "KWidgetsAddons.KGuiItem.setToolTip(self,tooltip:QString)",
    "KWidgetsAddons.KGuiItem.setWhatsThis(self,whatsThis:QString)",
    "KWidgetsAddons.KGuiItem.text(self)->QString",
    "KWidgetsAddons.KGuiItem.toolTip(self)->QString",
    "KWidgetsAddons.KGuiItem.whatsThis(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KGuiItem_SignatureByteSize = 308;
static constexpr uint8_t KGuiItem_SignatureBytes[308] = {
    0x78, 0xda, 0x9d, 0x92, 0xcb, 0x6a, 0x83, 0x40, 0x14, 0x86, 0xf7, 0x3e, 0x45, 0x97, 0x0a, 0x53,
    0xe9, 0x05, 0xba, 0x10, 0x5a, 0x68, 0xa1, 0x94, 0x10, 0x28, 0x91, 0x58, 0xb2, 0x28, 0x5d, 0x8c,
    0x75, 0xaa, 0x07, 0x74, 0x46, 0x72, 0x4e, 0x48, 0xf2, 0xf6, 0x1d, 0xaf, 0x31, 0x35, 0x33, 0x35,
    0x59, 0xe9, 0xcc, 0xfc, 0xdf, 0xb9, 0xfe, 0xf7, 0xc1, 0x7c, 0x05, 0x49, 0x2a, 0x08, 0x9f, 0x93,
    0x44, 0x49, 0xf4, 0xe7, 0x6f, 0x1b, 0x98, 0x91, 0x28, 0x5c, 0x14, 0xf9, 0x8f, 0xe7, 0xdc, 0x59,
    0xdf, 0x99, 0xa2, 0x4c, 0xac, 0x4d, 0x12, 0xcf, 0xb9, 0xb5, 0xd3, 0x24, 0x76, 0x14, 0x84, 0x4b,
    0x5a, 0x83, 0x4c, 0x19, 0x7c, 0x2b, 0x19, 0xd0, 0xbe, 0xd4, 0xff, 0xfe, 0x87, 0x04, 0x25, 0x3f,
    0x17, 0xfb, 0x25, 0x24, 0xe2, 0xc1, 0x0f, 0x49, 0x53, 0x7e, 0x38, 0xd3, 0x02, 0x76, 0xf5, 0xe7,
    0x72, 0x01, 0xbb, 0x82, 0x97, 0x5f, 0x8c, 0x94, 0xca, 0x23, 0x28, 0xbb, 0x68, 0x8f, 0xed, 0xd7,
    0xf5, 0xd8, 0x36, 0xe3, 0x84, 0x51, 0x06, 0x38, 0x7e, 0xf3, 0x9c, 0x9b, 0x33, 0x0b, 0x7c, 0xe7,
    0x85, 0x38, 0x91, 0xe3, 0xc2, 0xec, 0x86, 0xdc, 0x3e, 0x47, 0x84, 0x54, 0xba, 0xf1, 0x86, 0x48,
    0xcf, 0xe4, 0xd0, 0x71, 0x2b, 0xd7, 0x5d, 0x6f, 0x30, 0x7b, 0xa9, 0x5f, 0x19, 0x68, 0xc0, 0xbc,
    0x00, 0x53, 0x86, 0x8c, 0x63, 0x35, 0xce, 0x66, 0xc9, 0xd7, 0x4f, 0xb1, 0xae, 0xdf, 0xa8, 0x85,
    0x81, 0xf0, 0xc4, 0x4a, 0xac, 0x5c, 0x35, 0xaf, 0x8e, 0x6d, 0x1b, 0x37, 0xeb, 0xf1, 0x55, 0xf2,
    0x38, 0x17, 0xc9, 0xa4, 0xaa, 0xca, 0x9c, 0x83, 0x8c, 0xf4, 0x7e, 0xa6, 0x86, 0x47, 0x41, 0xc3,
    0xf8, 0x4c, 0xd4, 0x87, 0xa0, 0x4a, 0xe2, 0xd9, 0xa0, 0x7e, 0x4e, 0xb5, 0x01, 0xf4, 0xc5, 0xc5,
    0x26, 0xfd, 0x37, 0x4d, 0x3f, 0xad, 0x91, 0xd7, 0xac, 0x68, 0x3f, 0x85, 0x23, 0xbf, 0xda, 0x91,
    0xc6, 0xb0, 0x2d, 0xa5, 0x0f, 0x74, 0x70, 0xaf, 0x15, 0x5c, 0x75, 0x7e, 0x6e, 0xd0, 0x91, 0xbd,
    0xcd, 0x30, 0x9d, 0xb1, 0x2b, 0x1a, 0x94, 0x37, 0x41, 0xbe, 0x3d, 0x2a, 0x6a, 0x00, 0xfc, 0x02,
    0xab, 0x43, 0xc2, 0xba
};
#endif

PyTypeObject *init_KGuiItem(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX].type;

    Shiboken::AutoDecRef Sbk_KGuiItem_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KGuiItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KGuiItem",
        "KGuiItem*",
        &Sbk_KGuiItem_spec,
        &Shiboken::callCppDestructor< ::KGuiItem >,
        Sbk_KGuiItem_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KGuiItem_Type; // references _Sbk_KGuiItem_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KGuiItem_SignatureStrings);
#else
    InitSignatureBytes(pyType, KGuiItem_SignatureBytes, KGuiItem_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KGuiItem_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KGuiItem_PythonToCpp_KGuiItem_PTR,
        is_KGuiItem_PythonToCpp_KGuiItem_PTR_Convertible,
        KGuiItem_PTR_CppToPython_KGuiItem);

    Shiboken::Conversions::registerConverterName(converter, "KGuiItem");
    Shiboken::Conversions::registerConverterName(converter, "KGuiItem*");
    Shiboken::Conversions::registerConverterName(converter, "KGuiItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KGuiItem).name());

    qRegisterMetaType< ::KGuiItem *>();

    return pyType;
}
