
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kstandardguiitem_wrapper.h"

// Argument includes
#include <QString>
#include <kguiitem.h>
#include <kstandardguiitem.h>
#include <qpushbutton.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KStandardGuiItem_Type = nullptr;
static PyTypeObject *Sbk_KStandardGuiItem_TypeF(void)
{
    return _Sbk_KStandardGuiItem_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KStandardGuiItem_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KStandardGuiItem");
    return -1;
}

static PyObject *Sbk_KStandardGuiItemFunc_add(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // add()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::add());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_adminMode(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // adminMode()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::adminMode());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_apply(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // apply()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::apply());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_assign(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "assign", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KStandardGuiItem::assign(QPushButton*,KStandardGuiItem::StandardItem)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_StandardItem_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // assign(QPushButton*,KStandardGuiItem::StandardItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "assign", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPushButton *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KStandardGuiItem::StandardItem cppArg1 = static_cast< ::KStandardGuiItem::StandardItem>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // assign(QPushButton*,KStandardGuiItem::StandardItem)
            ::KStandardGuiItem::assign(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KStandardGuiItemFunc_back(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "back", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);

    if (PyArg_ParseTuple(args, "|O:back", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KStandardGuiItem::back(KStandardGuiItem::BidiMode=)->KGuiItem
    if (numArgs == 0) {
        overloadId = 0; // back(KStandardGuiItem::BidiMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_BidiMode_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 0; // back(KStandardGuiItem::BidiMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "back", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"useBidi", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_BidiMode_IDX])))->converter, (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "back", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);
            }
        }
        ::KStandardGuiItem::BidiMode cppArg0(KStandardGuiItem::BidiMode::IgnoreRTL);
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // back(KStandardGuiItem::BidiMode)
            KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::back(cppArg0));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_backAndForward(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // backAndForward()
        std::pair<KGuiItem,KGuiItem> cppResult = ::KStandardGuiItem::backAndForward();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_KGuiItem_KGuiItem_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_cancel(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // cancel()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::cancel());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_clear(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clear()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::clear());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_close(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // close()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::close());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_closeDocument(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // closeDocument()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::closeDocument());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_closeWindow(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // closeWindow()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::closeWindow());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_configure(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // configure()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::configure());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_cont(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // cont()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::cont());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_defaults(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // defaults()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::defaults());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_del(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // del()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::del());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_discard(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // discard()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::discard());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_dontSave(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dontSave()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::dontSave());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_find(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // find()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::find());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_forward(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "forward", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);

    if (PyArg_ParseTuple(args, "|O:forward", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KStandardGuiItem::forward(KStandardGuiItem::BidiMode=)->KGuiItem
    if (numArgs == 0) {
        overloadId = 0; // forward(KStandardGuiItem::BidiMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_BidiMode_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 0; // forward(KStandardGuiItem::BidiMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "forward", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"useBidi", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_BidiMode_IDX])))->converter, (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "forward", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);
            }
        }
        ::KStandardGuiItem::BidiMode cppArg0(KStandardGuiItem::BidiMode::IgnoreRTL);
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // forward(KStandardGuiItem::BidiMode)
            KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::forward(cppArg0));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_guiItem(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KStandardGuiItem::guiItem(KStandardGuiItem::StandardItem)->KGuiItem
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_StandardItem_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // guiItem(KStandardGuiItem::StandardItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "guiItem", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);

    // Call function/method
    {
        ::KStandardGuiItem::StandardItem cppArg0 = static_cast< ::KStandardGuiItem::StandardItem>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // guiItem(KStandardGuiItem::StandardItem)
            KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::guiItem(cppArg0));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_help(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // help()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::help());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_insert(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // insert()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::insert());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_ok(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // ok()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::ok());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_open(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // open()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::open());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_overwrite(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // overwrite()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::overwrite());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_print(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // print()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::print());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_properties(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // properties()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::properties());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_quit(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // quit()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::quit());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_remove(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // remove()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::remove());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_reset(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reset()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::reset());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_save(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // save()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::save());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_saveAs(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveAs()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::saveAs());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_standardItem(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KStandardGuiItem::standardItem(KStandardGuiItem::StandardItem)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_StandardItem_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // standardItem(KStandardGuiItem::StandardItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "standardItem", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX]);

    // Call function/method
    {
        ::KStandardGuiItem::StandardItem cppArg0 = static_cast< ::KStandardGuiItem::StandardItem>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // standardItem(KStandardGuiItem::StandardItem)
            QString cppResult = ::KStandardGuiItem::standardItem(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_stop(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stop()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::stop());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStandardGuiItemFunc_test(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // test()
        KGuiItem* cppResult = new KGuiItem(::KStandardGuiItem::test());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KStandardGuiItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KStandardGuiItem_EnumFlagInfo[] = {
    "BidiMode:IntEnum",
    "StandardItem:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KStandardGuiItem_methods[] = {
    {"add", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_add), METH_NOARGS|METH_STATIC, nullptr},
    {"adminMode", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_adminMode), METH_NOARGS|METH_STATIC, nullptr},
    {"apply", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_apply), METH_NOARGS|METH_STATIC, nullptr},
    {"assign", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_assign), METH_VARARGS|METH_STATIC, nullptr},
    {"back", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_back), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"backAndForward", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_backAndForward), METH_NOARGS|METH_STATIC, nullptr},
    {"cancel", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_cancel), METH_NOARGS|METH_STATIC, nullptr},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_clear), METH_NOARGS|METH_STATIC, nullptr},
    {"close", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_close), METH_NOARGS|METH_STATIC, nullptr},
    {"closeDocument", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_closeDocument), METH_NOARGS|METH_STATIC, nullptr},
    {"closeWindow", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_closeWindow), METH_NOARGS|METH_STATIC, nullptr},
    {"configure", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_configure), METH_NOARGS|METH_STATIC, nullptr},
    {"cont", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_cont), METH_NOARGS|METH_STATIC, nullptr},
    {"defaults", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_defaults), METH_NOARGS|METH_STATIC, nullptr},
    {"del", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_del), METH_NOARGS|METH_STATIC, nullptr},
    {"discard", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_discard), METH_NOARGS|METH_STATIC, nullptr},
    {"dontSave", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_dontSave), METH_NOARGS|METH_STATIC, nullptr},
    {"find", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_find), METH_NOARGS|METH_STATIC, nullptr},
    {"forward", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_forward), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"guiItem", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_guiItem), METH_O|METH_STATIC, nullptr},
    {"help", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_help), METH_NOARGS|METH_STATIC, nullptr},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_insert), METH_NOARGS|METH_STATIC, nullptr},
    {"ok", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_ok), METH_NOARGS|METH_STATIC, nullptr},
    {"open", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_open), METH_NOARGS|METH_STATIC, nullptr},
    {"overwrite", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_overwrite), METH_NOARGS|METH_STATIC, nullptr},
    {"print", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_print), METH_NOARGS|METH_STATIC, nullptr},
    {"properties", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_properties), METH_NOARGS|METH_STATIC, nullptr},
    {"quit", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_quit), METH_NOARGS|METH_STATIC, nullptr},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_remove), METH_NOARGS|METH_STATIC, nullptr},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_reset), METH_NOARGS|METH_STATIC, nullptr},
    {"save", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_save), METH_NOARGS|METH_STATIC, nullptr},
    {"saveAs", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_saveAs), METH_NOARGS|METH_STATIC, nullptr},
    {"standardItem", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_standardItem), METH_O|METH_STATIC, nullptr},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_stop), METH_NOARGS|METH_STATIC, nullptr},
    {"test", reinterpret_cast<PyCFunction>(Sbk_KStandardGuiItemFunc_test), METH_NOARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KStandardGuiItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KStandardGuiItem_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KStandardGuiItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KStandardGuiItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KStandardGuiItem_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KStandardGuiItem_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KStandardGuiItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KStandardGuiItem_spec = {
    "1:KWidgetsAddons.KStandardGuiItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KStandardGuiItem_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KStandardGuiItem_BidiMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KStandardGuiItem::BidiMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KStandardGuiItem::BidiMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KStandardGuiItem_BidiMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_BidiMode_IDX])))
        return Enum_PythonToCpp_KStandardGuiItem_BidiMode;
    return {};
}

static PyObject *KStandardGuiItem_BidiMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KStandardGuiItem::BidiMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KStandardGuiItem::BidiMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KStandardGuiItem_StandardItem(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KStandardGuiItem::StandardItem>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KStandardGuiItem::StandardItem *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KStandardGuiItem_StandardItem_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_StandardItem_IDX])))
        return Enum_PythonToCpp_KStandardGuiItem_StandardItem;
    return {};
}

static PyObject *KStandardGuiItem_StandardItem_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KStandardGuiItem::StandardItem>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KStandardGuiItem::StandardItem *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KWidgetsAddonsKStandardGuiItem_SignatureStrings[] = {
    "KWidgetsAddons.KStandardGuiItem.add()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.adminMode()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.apply()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.assign(button:PySide6.QtWidgets.QPushButton,item:KWidgetsAddons.KStandardGuiItem.StandardItem)",
    "KWidgetsAddons.KStandardGuiItem.back(useBidi:KWidgetsAddons.KStandardGuiItem.BidiMode=KStandardGuiItem.BidiMode.IgnoreRTL)->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.backAndForward()->std.pair[KWidgetsAddons.KGuiItem, KWidgetsAddons.KGuiItem]",
    "KWidgetsAddons.KStandardGuiItem.cancel()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.clear()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.close()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.closeDocument()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.closeWindow()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.configure()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.cont()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.defaults()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.del()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.discard()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.dontSave()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.find()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.forward(useBidi:KWidgetsAddons.KStandardGuiItem.BidiMode=KStandardGuiItem.BidiMode.IgnoreRTL)->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.guiItem(id:KWidgetsAddons.KStandardGuiItem.StandardItem)->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.help()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.insert()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.ok()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.open()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.overwrite()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.print()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.properties()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.quit()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.remove()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.reset()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.save()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.saveAs()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.standardItem(id:KWidgetsAddons.KStandardGuiItem.StandardItem)->QString",
    "KWidgetsAddons.KStandardGuiItem.stop()->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KStandardGuiItem.test()->KWidgetsAddons.KGuiItem",
    nullptr}; // Sentinel
#else
static constexpr size_t KWidgetsAddonsKStandardGuiItem_SignatureByteSize = 353;
static constexpr uint8_t KWidgetsAddonsKStandardGuiItem_SignatureBytes[353] = {
    0x78, 0xda, 0xcd, 0x55, 0xc1, 0x4a, 0xc3, 0x40, 0x10, 0xbd, 0xfb, 0x15, 0x1e, 0x53, 0xa8, 0x39,
    0x7a, 0x28, 0x28, 0xb4, 0x88, 0x52, 0xa2, 0xd0, 0x1a, 0xa1, 0x07, 0xf1, 0xb0, 0xcd, 0x4c, 0xd3,
    0xa1, 0xc9, 0xee, 0x3a, 0xb3, 0xdb, 0xd2, 0xbf, 0x37, 0xd1, 0x08, 0x22, 0xd4, 0x68, 0xe6, 0xe2,
    0x29, 0x6c, 0x66, 0xdf, 0x9b, 0xd9, 0xb7, 0xf3, 0x66, 0xb3, 0x15, 0x41, 0x89, 0x41, 0xa6, 0x00,
    0xce, 0x4a, 0x9a, 0xe5, 0xc1, 0x58, 0x30, 0x0c, 0x77, 0x91, 0xe6, 0x01, 0xeb, 0xd4, 0x00, 0x24,
    0xa3, 0x8b, 0xeb, 0xec, 0xdb, 0xb6, 0x2e, 0x7c, 0x96, 0xf5, 0xc2, 0x6b, 0xb2, 0x0f, 0x0e, 0x50,
    0x45, 0xe2, 0x7d, 0x75, 0x54, 0x11, 0x88, 0x50, 0x69, 0x93, 0x75, 0x0c, 0xc1, 0xd9, 0xc9, 0xe2,
    0x98, 0x13, 0xe0, 0x65, 0xba, 0x0c, 0x1d, 0x2c, 0x5d, 0x2e, 0xa2, 0x6c, 0x67, 0xef, 0xd1, 0x31,
    0x35, 0x80, 0x49, 0x1f, 0xe1, 0xe7, 0xba, 0x5d, 0x8c, 0x7a, 0xd3, 0xaf, 0x4d, 0xb1, 0x4b, 0xa2,
    0xe0, 0x8c, 0x80, 0x7a, 0xa9, 0xdb, 0x4d, 0xad, 0x60, 0x57, 0x27, 0x23, 0xe9, 0xbc, 0xb4, 0x8e,
    0xf1, 0xf1, 0xe9, 0x5e, 0x21, 0x49, 0x5b, 0xd3, 0xd4, 0xc2, 0xad, 0xe3, 0x43, 0xf3, 0xb7, 0x15,
    0x57, 0x02, 0xa4, 0xde, 0x10, 0x3f, 0x9f, 0xa0, 0x1c, 0x9f, 0x9f, 0x08, 0xbc, 0xf4, 0x26, 0x2b,
    0x8c, 0x2d, 0xb0, 0xd2, 0xdc, 0x60, 0x51, 0xa1, 0x61, 0x1d, 0x81, 0x13, 0x54, 0x13, 0xdc, 0xb8,
    0x22, 0xd6, 0x68, 0x83, 0x9a, 0x68, 0x45, 0x16, 0xdc, 0x41, 0x45, 0xe3, 0xec, 0x86, 0xca, 0xc8,
    0xa8, 0x24, 0x51, 0x9d, 0x05, 0x70, 0x63, 0x62, 0x15, 0x44, 0xc7, 0xa1, 0xea, 0x0c, 0x20, 0x29,
    0xba, 0x0e, 0x1e, 0x4c, 0xd1, 0xa8, 0x90, 0x9b, 0xbd, 0x4a, 0xc9, 0x4d, 0x73, 0xa1, 0x2a, 0x7c,
    0x67, 0xc4, 0x7f, 0x36, 0x26, 0xca, 0x8f, 0x6f, 0x42, 0xf0, 0xb7, 0x99, 0x38, 0x3c, 0xe3, 0x16,
    0x2b, 0xaf, 0x11, 0x92, 0xac, 0x20, 0xab, 0x9a, 0xda, 0xed, 0x54, 0x68, 0x8f, 0x56, 0x85, 0xdf,
    0x23, 0x1f, 0xb8, 0x79, 0x85, 0x34, 0x24, 0x9e, 0x49, 0x67, 0x6c, 0xcf, 0xcd, 0x39, 0x38, 0x10,
    0xaa, 0xac, 0xfd, 0x1a, 0x49, 0x55, 0x05, 0x63, 0xed, 0x74, 0xb6, 0x64, 0x14, 0x54, 0x95, 0x20,
    0xca, 0xb9, 0xd0, 0xe2, 0xa7, 0x2a, 0x11, 0xe5, 0x8b, 0xaf, 0x06, 0xf8, 0x70, 0x99, 0x87, 0xa6,
    0x19, 0xca, 0x5f, 0xa4, 0x71, 0x2a, 0xdf, 0x05, 0x94, 0x1f, 0x85, 0x7e, 0x03, 0xa4, 0x4d, 0xcb,
    0xf4
};
#endif

PyTypeObject *init_KWidgetsAddonsKStandardGuiItem(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX].type;

    Shiboken::AutoDecRef Sbk_KStandardGuiItem_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KStandardGuiItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KStandardGuiItem",
        "KStandardGuiItem",
        &Sbk_KStandardGuiItem_spec,
        nullptr,
        Sbk_KStandardGuiItem_Type_bases.object(),
        0);
    auto *pyType = Sbk_KStandardGuiItem_TypeF(); // references _Sbk_KStandardGuiItem_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KWidgetsAddonsKStandardGuiItem_SignatureStrings);
#else
    InitSignatureBytes(pyType, KWidgetsAddonsKStandardGuiItem_SignatureBytes, KWidgetsAddonsKStandardGuiItem_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KStandardGuiItem_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKStandardGuiItem_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KStandardGuiItem_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'BidiMode'.
    const char *BidiMode_Initializer[] = {
        "UseRTL",
        "IgnoreRTL",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t BidiMode_InitializerValues[] = {
        uint8_t(KStandardGuiItem::BidiMode::UseRTL),   //  0x00  0
        uint8_t(KStandardGuiItem::BidiMode::IgnoreRTL) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KStandardGuiItem_TypeF(),
        "1:KWidgetsAddons.KStandardGuiItem.BidiMode",
        BidiMode_Initializer, BidiMode_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_BidiMode_IDX].type = EType;
    // Register converter for enum 'KStandardGuiItem::BidiMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KStandardGuiItem_BidiMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KStandardGuiItem_BidiMode,
            is_Enum_PythonToCpp_KStandardGuiItem_BidiMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KStandardGuiItem::BidiMode");
        Shiboken::Conversions::registerConverterAlias(converter, "BidiMode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'BidiMode' enum.

    // Initialization of enum 'StandardItem'.
    const char *StandardItem_Initializer[] = {
        "Ok",
        "Cancel",
        "Discard",
        "Save",
        "DontSave",
        "SaveAs",
        "Apply",
        "Clear",
        "Help",
        "Defaults",
        "Close",
        "Back",
        "Forward",
        "Print",
        "Continue",
        "Open",
        "Quit",
        "AdminMode",
        "Reset",
        "Delete",
        "Insert",
        "Configure",
        "Find",
        "Stop",
        "Add",
        "Remove",
        "Test",
        "Properties",
        "Overwrite",
        "CloseWindow",
        "CloseDocument",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t StandardItem_InitializerValues[] = {
        uint8_t(KStandardGuiItem::StandardItem::Ok),           //  0x01  1
        uint8_t(KStandardGuiItem::StandardItem::Cancel),       //  0x02  2
        uint8_t(KStandardGuiItem::StandardItem::Discard),      //  0x03  3
        uint8_t(KStandardGuiItem::StandardItem::Save),         //  0x04  4
        uint8_t(KStandardGuiItem::StandardItem::DontSave),     //  0x05  5
        uint8_t(KStandardGuiItem::StandardItem::SaveAs),       //  0x06  6
        uint8_t(KStandardGuiItem::StandardItem::Apply),        //  0x07  7
        uint8_t(KStandardGuiItem::StandardItem::Clear),        //  0x08  8
        uint8_t(KStandardGuiItem::StandardItem::Help),         //  0x09  9
        uint8_t(KStandardGuiItem::StandardItem::Defaults),     //  0x0a  10
        uint8_t(KStandardGuiItem::StandardItem::Close),        //  0x0b  11
        uint8_t(KStandardGuiItem::StandardItem::Back),         //  0x0c  12
        uint8_t(KStandardGuiItem::StandardItem::Forward),      //  0x0d  13
        uint8_t(KStandardGuiItem::StandardItem::Print),        //  0x0e  14
        uint8_t(KStandardGuiItem::StandardItem::Continue),     //  0x0f  15
        uint8_t(KStandardGuiItem::StandardItem::Open),         //  0x10  16
        uint8_t(KStandardGuiItem::StandardItem::Quit),         //  0x11  17
        uint8_t(KStandardGuiItem::StandardItem::AdminMode),    //  0x12  18
        uint8_t(KStandardGuiItem::StandardItem::Reset),        //  0x13  19
        uint8_t(KStandardGuiItem::StandardItem::Delete),       //  0x14  20
        uint8_t(KStandardGuiItem::StandardItem::Insert),       //  0x15  21
        uint8_t(KStandardGuiItem::StandardItem::Configure),    //  0x16  22
        uint8_t(KStandardGuiItem::StandardItem::Find),         //  0x17  23
        uint8_t(KStandardGuiItem::StandardItem::Stop),         //  0x18  24
        uint8_t(KStandardGuiItem::StandardItem::Add),          //  0x19  25
        uint8_t(KStandardGuiItem::StandardItem::Remove),       //  0x1a  26
        uint8_t(KStandardGuiItem::StandardItem::Test),         //  0x1b  27
        uint8_t(KStandardGuiItem::StandardItem::Properties),   //  0x1c  28
        uint8_t(KStandardGuiItem::StandardItem::Overwrite),    //  0x1d  29
        uint8_t(KStandardGuiItem::StandardItem::CloseWindow),  //  0x1e  30
        uint8_t(KStandardGuiItem::StandardItem::CloseDocument) //  0x1f  31
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KStandardGuiItem_TypeF(),
        "1:KWidgetsAddons.KStandardGuiItem.StandardItem",
        StandardItem_Initializer, StandardItem_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KStandardGuiItem_StandardItem_IDX].type = EType;
    // Register converter for enum 'KStandardGuiItem::StandardItem'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KStandardGuiItem_StandardItem_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KStandardGuiItem_StandardItem,
            is_Enum_PythonToCpp_KStandardGuiItem_StandardItem_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KStandardGuiItem::StandardItem");
        Shiboken::Conversions::registerConverterAlias(converter, "StandardItem");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'StandardItem' enum.

    qRegisterMetaType< ::KStandardGuiItem::BidiMode >("KStandardGuiItem::BidiMode");
    qRegisterMetaType< ::KStandardGuiItem::StandardItem >("KStandardGuiItem::StandardItem");

    return pyType;
}
