#ifndef SBK_KNOTIFICATIONWRAPPER_H
#define SBK_KNOTIFICATIONWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <knotification.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KNotificationWrapper : public KNotification
{
public:
    KNotificationWrapper(const ::QString & eventId, ::QFlags<KNotification::NotificationFlag> flags = KNotification::NotificationFlag::CloseOnTimeout, ::QObject * parent = nullptr);
    KNotificationWrapper(const KNotificationWrapper &) = delete;
    KNotificationWrapper& operator=(const KNotificationWrapper &) = delete;
    KNotificationWrapper(KNotificationWrapper &&) = delete;
    KNotificationWrapper& operator=(KNotificationWrapper &&) = delete;
    ~KNotificationWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 6> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KNOTIFICATIONWRAPPER_H
