// This file is generated by kconfig_compiler_kf6 from knetwalk.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class Settings : public KConfigSkeleton
{
  public:

    static Settings *self();
    ~Settings() override;

    /**
      Set Default user name
    */
    static
    void setUsername( const QString & v )
    {
      if (!self()->isUsernameImmutable())
        self()->mUsername = v;
    }

    /**
      Get Default user name
    */
    static
    QString username()
    {
      return self()->mUsername;
    }

    /**
      Is Default user name Immutable
    */
    static
    bool isUsernameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "username" ) );
    }

    /**
      Set Whether game sounds are played.
    */
    static
    void setPlaySounds( bool v )
    {
      if (!self()->isPlaySoundsImmutable())
        self()->mPlaySounds = v;
    }

    /**
      Get Whether game sounds are played.
    */
    static
    bool playSounds()
    {
      return self()->mPlaySounds;
    }

    /**
      Is Whether game sounds are played. Immutable
    */
    static
    bool isPlaySoundsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "PlaySounds" ) );
    }

    /**
      Set Whether lock cell after rotation.
    */
    static
    void setAutolock( bool v )
    {
      if (!self()->isAutolockImmutable())
        self()->mAutolock = v;
    }

    /**
      Get Whether lock cell after rotation.
    */
    static
    bool autolock()
    {
      return self()->mAutolock;
    }

    /**
      Is Whether lock cell after rotation. Immutable
    */
    static
    bool isAutolockImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Autolock" ) );
    }

    /**
      Set Use left click for clockwise and right click for counter-clockwise.
    */
    static
    void setReverseButtons( bool v )
    {
      if (!self()->isReverseButtonsImmutable())
        self()->mReverseButtons = v;
    }

    /**
      Get Use left click for clockwise and right click for counter-clockwise.
    */
    static
    bool reverseButtons()
    {
      return self()->mReverseButtons;
    }

    /**
      Is Use left click for clockwise and right click for counter-clockwise. Immutable
    */
    static
    bool isReverseButtonsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ReverseButtons" ) );
    }

    /**
      Set Duration for cell to complete one rotation.
    */
    static
    void setRotateDuration( int v )
    {
      if (v < 100)
      {
        qDebug() << "setRotateDuration: value " << v << " is less than the minimum value of 100";
        v = 100;
      }

      if (v > 500)
      {
        qDebug() << "setRotateDuration: value " << v << " is greater than the maximum value of 500";
        v = 500;
      }

      if (!self()->isRotateDurationImmutable())
        self()->mRotateDuration = v;
    }

    /**
      Get Duration for cell to complete one rotation.
    */
    static
    int rotateDuration()
    {
      return self()->mRotateDuration;
    }

    /**
      Is Duration for cell to complete one rotation. Immutable
    */
    static
    bool isRotateDurationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RotateDuration" ) );
    }

    /**
      Set The width of the board.
    */
    static
    void setWidth( int v )
    {
      if (v < 3)
      {
        qDebug() << "setWidth: value " << v << " is less than the minimum value of 3";
        v = 3;
      }

      if (v > 11)
      {
        qDebug() << "setWidth: value " << v << " is greater than the maximum value of 11";
        v = 11;
      }

      if (!self()->isWidthImmutable())
        self()->mWidth = v;
    }

    /**
      Get The width of the board.
    */
    static
    int width()
    {
      return self()->mWidth;
    }

    /**
      Is The width of the board. Immutable
    */
    static
    bool isWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Width" ) );
    }

    /**
      Set The height of the board.
    */
    static
    void setHeight( int v )
    {
      if (v < 3)
      {
        qDebug() << "setHeight: value " << v << " is less than the minimum value of 3";
        v = 3;
      }

      if (v > 11)
      {
        qDebug() << "setHeight: value " << v << " is greater than the maximum value of 11";
        v = 11;
      }

      if (!self()->isHeightImmutable())
        self()->mHeight = v;
    }

    /**
      Get The height of the board.
    */
    static
    int height()
    {
      return self()->mHeight;
    }

    /**
      Is The height of the board. Immutable
    */
    static
    bool isHeightImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Height" ) );
    }

    /**
      Set Whether wrap from left to right and from top to bottom is enabled.
    */
    static
    void setWrapping( bool v )
    {
      if (!self()->isWrappingImmutable())
        self()->mWrapping = v;
    }

    /**
      Get Whether wrap from left to right and from top to bottom is enabled.
    */
    static
    bool wrapping()
    {
      return self()->mWrapping;
    }

    /**
      Is Whether wrap from left to right and from top to bottom is enabled. Immutable
    */
    static
    bool isWrappingImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Wrapping" ) );
    }

  protected:
    Settings();
    friend class SettingsHelper;


    // Preferences
    QString mUsername;

    // General
    bool mPlaySounds;
    bool mAutolock;
    bool mReverseButtons;
    int mRotateDuration;

    // Custom
    int mWidth;
    int mHeight;
    bool mWrapping;
};

#endif

