#ifndef SBK_KSYSTEMCLIPBOARDWRAPPER_H
#define SBK_KSYSTEMCLIPBOARDWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <ksystemclipboard.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KSystemClipboardWrapper : public KSystemClipboard
{
public:
    KSystemClipboardWrapper(::QObject * parent);
    KSystemClipboardWrapper(const KSystemClipboardWrapper &) = delete;
    KSystemClipboardWrapper& operator=(const KSystemClipboardWrapper &) = delete;
    KSystemClipboardWrapper(KSystemClipboardWrapper &&) = delete;
    KSystemClipboardWrapper& operator=(KSystemClipboardWrapper &&) = delete;
    ~KSystemClipboardWrapper() override;

    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void clear(::QClipboard::Mode mode) override;
    static void sbk_o_clear(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QClipboard::Mode mode);
    void connectNotify(const ::QMetaMethod & signal) override;
    static void sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal);
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    const ::QMimeData * mimeData(::QClipboard::Mode mode) const override;
    static const ::QMimeData * sbk_o_mimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QClipboard::Mode mode);
    void setMimeData(::QMimeData * mime, ::QClipboard::Mode mode) override;
    static void sbk_o_setMimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMimeData * mime, ::QClipboard::Mode mode);
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 10> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KSYSTEMCLIPBOARDWRAPPER_H
