
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kcolorutils_wrapper.h"

// Argument includes
#include <qcolor.h>
#include <qpainter.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KColorUtils_Type = nullptr;
static PyTypeObject *Sbk_KColorUtils_TypeF(void)
{
    return _Sbk_KColorUtils_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KColorUtils_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KColorUtils");
    return -1;
}

static PyObject *Sbk_KColorUtilsFunc_chroma(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KColorUtils::chroma(QColor)->qreal
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // chroma(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "chroma", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // chroma(QColor)
            qreal cppResult = ::KColorUtils::chroma(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_contrastRatio(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "contrastRatio", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::contrastRatio(QColor,QColor)->qreal
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        overloadId = 0; // contrastRatio(QColor,QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "contrastRatio", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // contrastRatio(QColor,QColor)
            qreal cppResult = ::KColorUtils::contrastRatio(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_darken(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "darken", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:darken", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::darken(QColor,qreal=,qreal=)->QColor
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // darken(QColor,qreal,qreal)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // darken(QColor,qreal,qreal)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
                overloadId = 0; // darken(QColor,qreal,qreal)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "darken", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"amount", 1}, {"chromaGain", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "darken", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        qreal cppArg1 = 0.5;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2 = 1.0;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // darken(QColor,qreal,qreal)
            QColor cppResult = ::KColorUtils::darken(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_getHcy(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 4, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getHcy", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:getHcy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::getHcy(QColor,qreal*,qreal*,qreal*,qreal*=)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // getHcy(QColor,qreal*,qreal*,qreal*,qreal*)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
            overloadId = 0; // getHcy(QColor,qreal*,qreal*,qreal*,qreal*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getHcy", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"alpha", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "getHcy", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        qreal *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        qreal *cppArg4 = nullptr;
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getHcy(QColor,qreal*,qreal*,qreal*,qreal*)
            ::KColorUtils::getHcy(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KColorUtilsFunc_hcyColor(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "hcyColor", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:hcyColor", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::hcyColor(qreal,qreal,qreal,qreal=)->QColor
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // hcyColor(qreal,qreal,qreal,qreal)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            overloadId = 0; // hcyColor(qreal,qreal,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "hcyColor", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"alpha", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "hcyColor", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1.0;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // hcyColor(qreal,qreal,qreal,qreal)
            QColor cppResult = ::KColorUtils::hcyColor(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_hue(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KColorUtils::hue(QColor)->qreal
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // hue(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hue", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // hue(QColor)
            qreal cppResult = ::KColorUtils::hue(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_lighten(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "lighten", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:lighten", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::lighten(QColor,qreal=,qreal=)->QColor
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // lighten(QColor,qreal,qreal)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // lighten(QColor,qreal,qreal)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
                overloadId = 0; // lighten(QColor,qreal,qreal)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "lighten", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"amount", 1}, {"chromaInverseGain", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "lighten", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        qreal cppArg1 = 0.5;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2 = 1.0;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // lighten(QColor,qreal,qreal)
            QColor cppResult = ::KColorUtils::lighten(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_luma(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KColorUtils::luma(QColor)->qreal
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // luma(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "luma", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // luma(QColor)
            qreal cppResult = ::KColorUtils::luma(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_mix(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "mix", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:mix", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::mix(QColor,QColor,qreal=)->QColor
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // mix(QColor,QColor,qreal)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
            overloadId = 0; // mix(QColor,QColor,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "mix", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"bias", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "mix", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        qreal cppArg2 = 0.5;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mix(QColor,QColor,qreal)
            QColor cppResult = ::KColorUtils::mix(*cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_overlayColors(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "overlayColors", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:overlayColors", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::overlayColors(QColor,QColor,QPainter::CompositionMode=)->QColor
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // overlayColors(QColor,QColor,QPainter::CompositionMode)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_CompositionMode_IDX])))->converter, (pyArgs[2])))) {
            overloadId = 0; // overlayColors(QColor,QColor,QPainter::CompositionMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "overlayColors", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"comp", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_CompositionMode_IDX])))->converter, (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "overlayColors", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QPainter::CompositionMode cppArg2(QPainter::CompositionMode_SourceOver);
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // overlayColors(QColor,QColor,QPainter::CompositionMode)
            QColor cppResult = ::KColorUtils::overlayColors(*cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_shade(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "shade", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:shade", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::shade(QColor,qreal,qreal=)->QColor
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // shade(QColor,qreal,qreal)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
            overloadId = 0; // shade(QColor,qreal,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "shade", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"chromaAmount", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "shade", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2 = 0.0;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // shade(QColor,qreal,qreal)
            QColor cppResult = ::KColorUtils::shade(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorUtilsFunc_tint(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "tint", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:tint", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorUtils::tint(QColor,QColor,qreal=)->QColor
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // tint(QColor,QColor,qreal)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
            overloadId = 0; // tint(QColor,QColor,qreal)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "tint", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"amount", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "tint", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        qreal cppArg2 = 0.3;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tint(QColor,QColor,qreal)
            QColor cppResult = ::KColorUtils::tint(*cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KColorUtils_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KColorUtils_methods[] = {
    {"chroma", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_chroma), METH_O|METH_STATIC, nullptr},
    {"contrastRatio", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_contrastRatio), METH_VARARGS|METH_STATIC, nullptr},
    {"darken", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_darken), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"getHcy", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_getHcy), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"hcyColor", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_hcyColor), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"hue", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_hue), METH_O|METH_STATIC, nullptr},
    {"lighten", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_lighten), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"luma", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_luma), METH_O|METH_STATIC, nullptr},
    {"mix", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_mix), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"overlayColors", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_overlayColors), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"shade", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_shade), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"tint", reinterpret_cast<PyCFunction>(Sbk_KColorUtilsFunc_tint), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KColorUtils_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KColorUtils_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KColorUtils_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KColorUtils_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KColorUtils_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KColorUtils_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KColorUtils_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KColorUtils_spec = {
    "1:KGuiAddons.KColorUtils",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KColorUtils_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KGuiAddonsKColorUtils_SignatureStrings[] = {
    "KGuiAddons.KColorUtils.chroma(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])->qreal",
    "KGuiAddons.KColorUtils.contrastRatio(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],arg__2:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])->qreal",
    "KGuiAddons.KColorUtils.darken(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],amount:qreal=0.5,chromaGain:qreal=1.0)->PySide6.QtGui.QColor",
    "KGuiAddons.KColorUtils.getHcy(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],hue:qreal*,chroma:qreal*,luma:qreal*,alpha:qreal*=nullptr)",
    "KGuiAddons.KColorUtils.hcyColor(hue:qreal,chroma:qreal,luma:qreal,alpha:qreal=1.0)->PySide6.QtGui.QColor",
    "KGuiAddons.KColorUtils.hue(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])->qreal",
    "KGuiAddons.KColorUtils.lighten(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],amount:qreal=0.5,chromaInverseGain:qreal=1.0)->PySide6.QtGui.QColor",
    "KGuiAddons.KColorUtils.luma(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])->qreal",
    "KGuiAddons.KColorUtils.mix(c1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],c2:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],bias:qreal=0.5)->PySide6.QtGui.QColor",
    "KGuiAddons.KColorUtils.overlayColors(base:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],paint:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],comp:PySide6.QtGui.QPainter.CompositionMode=QPainter.CompositionMode_SourceOver)->PySide6.QtGui.QColor",
    "KGuiAddons.KColorUtils.shade(arg__1:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],lumaAmount:qreal,chromaAmount:qreal=0.0)->PySide6.QtGui.QColor",
    "KGuiAddons.KColorUtils.tint(base:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],amount:qreal=0.3)->PySide6.QtGui.QColor",
    nullptr}; // Sentinel
#else
static constexpr size_t KGuiAddonsKColorUtils_SignatureByteSize = 391;
static constexpr uint8_t KGuiAddonsKColorUtils_SignatureBytes[391] = {
    0x78, 0xda, 0xd5, 0x56, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0xbc, 0xf3, 0x15, 0x3d, 0xa6, 0x28, 0x58,
    0x2d, 0xaf, 0x43, 0xa5, 0x22, 0x55, 0x3d, 0x14, 0x54, 0x10, 0x7d, 0xa8, 0x5c, 0x10, 0xaa, 0x36,
    0x89, 0x95, 0x58, 0x38, 0xeb, 0x60, 0x6f, 0x10, 0xf9, 0x7b, 0xdc, 0xb4, 0xa1, 0x69, 0x45, 0x0e,
    0x85, 0x8b, 0x73, 0x4a, 0x1c, 0xaf, 0x47, 0x33, 0xbb, 0xa3, 0x71, 0xa6, 0x93, 0x5c, 0x8c, 0xa2,
    0x48, 0xa1, 0x61, 0xd3, 0xb1, 0x92, 0x4a, 0xaf, 0x48, 0x48, 0xc3, 0xc2, 0x44, 0xab, 0x14, 0x3c,
    0xd0, 0xf1, 0x7a, 0xdd, 0x1f, 0x50, 0x91, 0x09, 0x8c, 0xd9, 0x0a, 0x85, 0xc2, 0xd7, 0x59, 0xb1,
    0x14, 0x11, 0xbf, 0x65, 0x73, 0xb2, 0x47, 0xd9, 0xbc, 0x3c, 0xe4, 0x77, 0xe6, 0x8f, 0x40, 0x02,
    0xfb, 0x4b, 0xd2, 0xb6, 0xd2, 0xef, 0x1c, 0x15, 0x2d, 0xe2, 0x00, 0x6e, 0xaf, 0x6d, 0xd5, 0x0b,
    0x68, 0x01, 0x48, 0xf5, 0x82, 0xb1, 0xd2, 0xdc, 0x3e, 0xd8, 0x44, 0xaa, 0x00, 0x64, 0x05, 0x57,
    0x01, 0xe5, 0x68, 0x44, 0x8c, 0x3c, 0xea, 0x08, 0xa4, 0xb7, 0xee, 0xc5, 0xdd, 0x87, 0xe6, 0x20,
    0xcf, 0xa6, 0x0d, 0xac, 0x15, 0x92, 0x06, 0x43, 0x0b, 0xcb, 0x45, 0xb9, 0x46, 0xde, 0x2f, 0xf9,
    0x5c, 0xb6, 0xa6, 0x99, 0x11, 0xe8, 0x77, 0x8e, 0xee, 0x75, 0x31, 0x55, 0x39, 0xd2, 0xa0, 0xa4,
    0x3e, 0xec, 0xb1, 0x1b, 0x7f, 0x6b, 0xd5, 0x09, 0x08, 0xdc, 0x7d, 0xec, 0xb3, 0x9e, 0xd5, 0xf6,
    0x1b, 0xc7, 0x26, 0xa9, 0x31, 0xa7, 0xfb, 0xb0, 0x70, 0x4e, 0x6a, 0x92, 0xf3, 0xad, 0xa4, 0xf3,
    0x9d, 0xc8, 0x6a, 0x25, 0xf3, 0xfd, 0x3b, 0xc8, 0x2c, 0xa9, 0x16, 0x43, 0xcc, 0xa5, 0xcc, 0x48,
    0x77, 0x9b, 0x84, 0x26, 0x61, 0x51, 0xae, 0xbc, 0x1f, 0xe8, 0x03, 0xe4, 0x1a, 0x70, 0x1d, 0xf7,
    0x0f, 0x1d, 0xb5, 0xf8, 0x6d, 0x0b, 0x0f, 0x29, 0xe2, 0x84, 0xda, 0x63, 0xf8, 0x07, 0xfc, 0xe4,
    0xda, 0xf0, 0x7f, 0xf9, 0x7e, 0x33, 0xee, 0xb6, 0x8d, 0x29, 0x15, 0x5f, 0x5e, 0xe8, 0xd0, 0x78,
    0x42, 0x77, 0x12, 0xdd, 0x0f, 0x04, 0x98, 0xbd, 0x51, 0x4e, 0x34, 0x83, 0xb2, 0x7e, 0x92, 0xb0,
    0xcd, 0x07, 0xe3, 0x05, 0x60, 0xb8, 0x3b, 0xc2, 0x32, 0xeb, 0x72, 0x72, 0x68, 0xe6, 0x2a, 0xcd,
    0x06, 0x47, 0xd8, 0xb3, 0x0d, 0x45, 0xae, 0xd9, 0xd8, 0xee, 0x29, 0x23, 0xec, 0x0f, 0x08, 0x3e,
    0xa9, 0x88, 0x0f, 0x9b, 0x36, 0xd6, 0x4b, 0x95, 0xeb, 0x90, 0x3f, 0xdb, 0xae, 0x9f, 0x38, 0x28,
    0x93, 0x40, 0xe4, 0x5c, 0xba, 0x96, 0x57, 0xc7, 0xa8, 0x16, 0x55, 0xbb, 0x98, 0x1a, 0x1d, 0xa6,
    0xd7, 0xa9, 0x09, 0x65, 0x89, 0x93, 0x63, 0x5e, 0x0c, 0x37, 0xbb, 0xce, 0x5e, 0x0f, 0x57, 0x4d,
    0x0d, 0xfe, 0x06, 0x12, 0x8a, 0x2e, 0xd7
};
#endif

PyTypeObject *init_KGuiAddonsKColorUtils(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX].type;

    Shiboken::AutoDecRef Sbk_KColorUtils_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KColorUtils_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KColorUtils",
        "KColorUtils",
        &Sbk_KColorUtils_spec,
        nullptr,
        Sbk_KColorUtils_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KColorUtils_Type; // references _Sbk_KColorUtils_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KGuiAddonsKColorUtils_SignatureStrings);
#else
    InitSignatureBytes(pyType, KGuiAddonsKColorUtils_SignatureBytes, KGuiAddonsKColorUtils_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KColorUtils_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorUtils_IDX].type = pyType;



    return pyType;
}
