
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kcolormimedata_wrapper.h"

// Argument includes
#include <qcolor.h>
#include <qobject.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KColorMimeData_Type = nullptr;
static PyTypeObject *Sbk_KColorMimeData_TypeF(void)
{
    return _Sbk_KColorMimeData_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KColorMimeData_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KColorMimeData");
    return -1;
}

static PyObject *Sbk_KColorMimeDataFunc_canDecode(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KColorMimeData::canDecode(const QMimeData*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArg)))) {
        overloadId = 0; // canDecode(const QMimeData*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "canDecode", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorMimeData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // canDecode(const QMimeData*)
            bool cppResult = ::KColorMimeData::canDecode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorMimeDataFunc_createDrag(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "createDrag", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorMimeData::createDrag(QColor,QObject*)->QDrag*
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 0; // createDrag(QColor,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createDrag", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorMimeData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createDrag(QColor,QObject*)
            QDrag * cppResult = ::KColorMimeData::createDrag(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDrag_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorMimeDataFunc_fromMimeData(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KColorMimeData::fromMimeData(const QMimeData*)->QColor
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArg)))) {
        overloadId = 0; // fromMimeData(const QMimeData*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fromMimeData", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorMimeData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fromMimeData(const QMimeData*)
            QColor cppResult = ::KColorMimeData::fromMimeData(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColorMimeDataFunc_populateMimeData(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "populateMimeData", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KColorMimeData::populateMimeData(QMimeData*,QColor)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        overloadId = 0; // populateMimeData(QMimeData*,QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "populateMimeData", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorMimeData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // populateMimeData(QMimeData*,QColor)
            ::KColorMimeData::populateMimeData(cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KColorMimeData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KColorMimeData_methods[] = {
    {"canDecode", reinterpret_cast<PyCFunction>(Sbk_KColorMimeDataFunc_canDecode), METH_O|METH_STATIC, nullptr},
    {"createDrag", reinterpret_cast<PyCFunction>(Sbk_KColorMimeDataFunc_createDrag), METH_VARARGS|METH_STATIC, nullptr},
    {"fromMimeData", reinterpret_cast<PyCFunction>(Sbk_KColorMimeDataFunc_fromMimeData), METH_O|METH_STATIC, nullptr},
    {"populateMimeData", reinterpret_cast<PyCFunction>(Sbk_KColorMimeDataFunc_populateMimeData), METH_VARARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KColorMimeData_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KColorMimeData_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KColorMimeData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KColorMimeData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KColorMimeData_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KColorMimeData_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KColorMimeData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KColorMimeData_spec = {
    "1:KGuiAddons.KColorMimeData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KColorMimeData_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KGuiAddonsKColorMimeData_SignatureStrings[] = {
    "KGuiAddons.KColorMimeData.canDecode(mimeData:PySide6.QtCore.QMimeData)->bool",
    "KGuiAddons.KColorMimeData.createDrag(color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],dragsource:PySide6.QtCore.QObject)->PySide6.QtGui.QDrag",
    "KGuiAddons.KColorMimeData.fromMimeData(mimeData:PySide6.QtCore.QMimeData)->PySide6.QtGui.QColor",
    "KGuiAddons.KColorMimeData.populateMimeData(mimeData:PySide6.QtCore.QMimeData,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    nullptr}; // Sentinel
#else
static constexpr size_t KGuiAddonsKColorMimeData_SignatureByteSize = 222;
static constexpr uint8_t KGuiAddonsKColorMimeData_SignatureBytes[222] = {
    0x78, 0xda, 0xcd, 0x90, 0xc1, 0x6a, 0xc2, 0x40, 0x10, 0x86, 0xef, 0x3e, 0x45, 0x8e, 0x0a, 0xe9,
    0x42, 0xa1, 0x78, 0xf0, 0x50, 0x28, 0x06, 0x3c, 0xc4, 0xd2, 0x46, 0xd1, 0x8b, 0xf4, 0x30, 0xd9,
    0x9d, 0x86, 0x91, 0xcd, 0x4c, 0xd8, 0x4c, 0x0e, 0xbe, 0xbd, 0xab, 0x35, 0x58, 0xd4, 0x8a, 0xc7,
    0x1e, 0x77, 0xf7, 0xdf, 0x6f, 0xe6, 0xfb, 0xf3, 0x59, 0x47, 0x6f, 0xce, 0x09, 0xb7, 0x26, 0x9f,
    0x8a, 0x97, 0xf0, 0x4e, 0x35, 0x66, 0xa0, 0x60, 0x2c, 0x70, 0x86, 0x56, 0x1c, 0x0e, 0xeb, 0xd3,
    0xd5, 0xe4, 0x73, 0xb7, 0x24, 0x87, 0x63, 0x53, 0xe8, 0x54, 0x02, 0x9a, 0xa2, 0xcf, 0x8e, 0x9e,
    0x5e, 0x4b, 0x11, 0x3f, 0xc8, 0xff, 0x86, 0x05, 0x04, 0xc5, 0x2c, 0x40, 0x35, 0xb4, 0x87, 0x87,
    0x89, 0xee, 0x1a, 0xe2, 0xca, 0xac, 0x98, 0x84, 0x37, 0x67, 0x6e, 0x04, 0x98, 0xe2, 0xf8, 0x35,
    0x4d, 0x8a, 0x39, 0x28, 0xf1, 0xf3, 0x52, 0x43, 0x4c, 0xa6, 0xc9, 0x45, 0x68, 0x51, 0x95, 0x30,
    0x7e, 0x89, 0xa9, 0x35, 0x04, 0x02, 0xd6, 0xdf, 0x81, 0x9f, 0xed, 0xd4, 0xcc, 0xbc, 0x94, 0xe0,
    0x7b, 0x5c, 0x0f, 0xea, 0xb8, 0xa5, 0x8a, 0xd1, 0x25, 0xc4, 0xfa, 0x95, 0xba, 0xb8, 0x53, 0x2b,
    0x5d, 0xb0, 0x78, 0xa5, 0xf7, 0x51, 0x6e, 0xd1, 0x6a, 0x94, 0xbb, 0x18, 0x7d, 0xd0, 0xb8, 0xe3,
    0xfa, 0x1d, 0xa4, 0xee, 0x0f, 0x0f, 0x75, 0x77, 0x4b, 0xff, 0x0e, 0xbf, 0x91, 0xa6, 0xf3, 0xb1,
    0xcd, 0xc7, 0x67, 0xa4, 0xff, 0xab, 0xf3, 0xd1, 0x60, 0x0f, 0x45, 0x6f, 0xde, 0x45
};
#endif

PyTypeObject *init_KGuiAddonsKColorMimeData(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorMimeData_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorMimeData_IDX].type;

    Shiboken::AutoDecRef Sbk_KColorMimeData_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KColorMimeData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KColorMimeData",
        "KColorMimeData",
        &Sbk_KColorMimeData_spec,
        nullptr,
        Sbk_KColorMimeData_Type_bases.object(),
        0);
    auto *pyType = Sbk_KColorMimeData_TypeF(); // references _Sbk_KColorMimeData_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KGuiAddonsKColorMimeData_SignatureStrings);
#else
    InitSignatureBytes(pyType, KGuiAddonsKColorMimeData_SignatureBytes, KGuiAddonsKColorMimeData_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KColorMimeData_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKColorMimeData_IDX].type = pyType;



    return pyType;
}
