
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kfuzzymatcher_range_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KFuzzyMatcher;

extern "C" {
static PyTypeObject *_Sbk_KFuzzyMatcher_Range_Type = nullptr;
static PyTypeObject *Sbk_KFuzzyMatcher_Range_TypeF(void)
{
    return _Sbk_KFuzzyMatcher_Range_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KFuzzyMatcher_Range_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KFuzzyMatcher::Range >()))
        return -1;

    ::KFuzzyMatcher::Range *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Range", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Range::Range()
    // 1: Range::Range(KFuzzyMatcher::Range)
    if (numArgs == 0) {
        overloadId = 0; // Range()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Range(KFuzzyMatcher::Range)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Range()
        {

            // Range()
            cptr = new ::KFuzzyMatcher::Range();
            break;
        }
        case 1: // Range(const KFuzzyMatcher::Range &Range)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KFuzzyMatcher::Range cppArg0_local;
            ::KFuzzyMatcher::Range *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // Range(KFuzzyMatcher::Range)
                cptr = new ::KFuzzyMatcher::Range(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KFuzzyMatcher::Range >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KFuzzyMatcher_Range__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KFuzzyMatcher::Range *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KFuzzyMatcher_Range_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFuzzyMatcher_Range_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KFuzzyMatcher_Range__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_KFuzzyMatcher_Range_get_start(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Range *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->start;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_KFuzzyMatcher_Range_set_start(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Range *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("start");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("start", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->start;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->start = cppOut_local;

    return 0;
}

static PyObject *Sbk_KFuzzyMatcher_Range_get_length(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Range *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->length;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_KFuzzyMatcher_Range_set_length(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Range *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("length");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("length", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->length;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->length = cppOut_local;

    return 0;
}

// Getters and Setters for Range
static PyGetSetDef Sbk_KFuzzyMatcher_Range_getsetlist[] = {
    {"start", Sbk_KFuzzyMatcher_Range_get_start, Sbk_KFuzzyMatcher_Range_set_start, "int", nullptr},
    {"length", Sbk_KFuzzyMatcher_Range_get_length, Sbk_KFuzzyMatcher_Range_set_length, "int", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KFuzzyMatcher_Range_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFuzzyMatcher_Range_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFuzzyMatcher_Range_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Range_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Range_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Range_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Range_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Range_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFuzzyMatcher_Range_spec = {
    "1:KCoreAddons.KFuzzyMatcher.Range",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFuzzyMatcher_Range_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Range_PythonToCpp_Range_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KFuzzyMatcher_Range_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Range_PythonToCpp_Range_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KFuzzyMatcher_Range_TypeF()))
        return Range_PythonToCpp_Range_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Range_PTR_CppToPython_Range(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KFuzzyMatcher_Range_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KFuzzyMatcher_Range_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *Range_COPY_CppToPython_Range(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KFuzzyMatcher::Range *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KFuzzyMatcher_Range_TypeF(), new ::KFuzzyMatcher::Range(*source), true, true);
}

// Python to C++ copy conversion.
static void Range_PythonToCpp_Range_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KFuzzyMatcher::Range *>(cppOut) = *reinterpret_cast< ::KFuzzyMatcher::Range *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Range_PythonToCpp_Range_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KFuzzyMatcher_Range_TypeF()))
        return Range_PythonToCpp_Range_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KFuzzyMatcher_Range_SignatureStrings[] = {
    "1:KCoreAddons.KFuzzyMatcher.Range(self)",
    "0:KCoreAddons.KFuzzyMatcher.Range(self,Range:KCoreAddons.KFuzzyMatcher.Range)",
    "KCoreAddons.KFuzzyMatcher.Range.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KFuzzyMatcher_Range_SignatureByteSize = 85;
static constexpr uint8_t KFuzzyMatcher_Range_SignatureBytes[85] = {
    0x78, 0xda, 0x33, 0xb4, 0xf2, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6,
    0xf3, 0x76, 0x2b, 0xad, 0xaa, 0xaa, 0xf4, 0x4d, 0x2c, 0x49, 0xce, 0x48, 0x2d, 0xd2, 0x0b, 0x4a,
    0xcc, 0x4b, 0x4f, 0xd5, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x32, 0x20, 0x4a, 0x9d, 0x0e, 0x98,
    0x49, 0x48, 0xa9, 0x26, 0x17, 0x01, 0x05, 0x7a, 0xf1, 0xf1, 0xc9, 0xf9, 0x05, 0x95, 0xf1, 0xf1,
    0x10, 0xcb, 0x75, 0xed, 0x4a, 0x2a, 0x0b, 0x32, 0xf3, 0xd2, 0xf5, 0xe2, 0x83, 0x81, 0x5c, 0x2e,
    0x00, 0x98, 0x75, 0x40, 0x6e
};
#endif

PyTypeObject *init_KFuzzyMatcher_Range(PyObject *enclosingClass)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX].type;

    Shiboken::AutoDecRef Sbk_KFuzzyMatcher_Range_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KFuzzyMatcher_Range_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Range",
        "KFuzzyMatcher::Range",
        &Sbk_KFuzzyMatcher_Range_spec,
        &Shiboken::callCppDestructor< ::KFuzzyMatcher::Range >,
        Sbk_KFuzzyMatcher_Range_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KFuzzyMatcher_Range_Type; // references _Sbk_KFuzzyMatcher_Range_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KFuzzyMatcher_Range_SignatureStrings);
#else
    InitSignatureBytes(pyType, KFuzzyMatcher_Range_SignatureBytes, KFuzzyMatcher_Range_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFuzzyMatcher_Range_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Range_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Range_PythonToCpp_Range_PTR,
        is_Range_PythonToCpp_Range_PTR_Convertible,
        Range_PTR_CppToPython_Range,
        Range_COPY_CppToPython_Range);

    Shiboken::Conversions::registerConverterName(converter, "KFuzzyMatcher::Range");
    Shiboken::Conversions::registerConverterName(converter, "KFuzzyMatcher::Range*");
    Shiboken::Conversions::registerConverterName(converter, "KFuzzyMatcher::Range&");
    Shiboken::Conversions::registerConverterAlias(converter, "Range");
    Shiboken::Conversions::registerConverterAlias(converter, "Range*");
    Shiboken::Conversions::registerConverterAlias(converter, "Range&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KFuzzyMatcher::Range).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Range_PythonToCpp_Range_COPY,
        is_Range_PythonToCpp_Range_COPY_Convertible);

    qRegisterMetaType< ::KFuzzyMatcher::Range >("Range");
    qRegisterMetaType< ::KFuzzyMatcher::Range >("KFuzzyMatcher::Range");

    return pyType;
}
