
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kusergroup_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <QStringList>
#include <kuser.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUserGroup_Type = nullptr;
static PyTypeObject *Sbk_KUserGroup_TypeF(void)
{
    return _Sbk_KUserGroup_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUserGroup_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUserGroup >()))
        return -1;

    ::KUserGroup *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    if (PyArg_ParseTuple(args, "|O:KUserGroup", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KUserGroup::KUserGroup(KGroupId)
    // 1: KUserGroup::KUserGroup(KUser::UIDMode=)
    // 2: KUserGroup::KUserGroup(KUserGroup)
    // 3: KUserGroup::KUserGroup(QString)
    // 4: KUserGroup::KUserGroup(const char*)
    // 5: KUserGroup::KUserGroup(uint)
    if (numArgs == 0) {
        overloadId = 1; // KUserGroup(KUser::UIDMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 1; // KUserGroup(KUser::UIDMode)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), (pyArgs[0])))) {
        overloadId = 2; // KUserGroup(KUserGroup)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 4; // KUserGroup(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 3; // KUserGroup(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 5; // KUserGroup(uint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KUserGroup(KGroupId)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KUserGroup(KGroupId gid)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KGroupId cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserGroup(KGroupId)
                cptr = new ::KUserGroup(cppArg0);
            }
            break;
        }
        case 1: // KUserGroup(KUser::UIDMode mode)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"mode", 0}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX])))->converter, (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
                }
            }
            ::KUser::UIDMode cppArg0(KUser::UseEffectiveUID);
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserGroup(KUser::UIDMode)
                cptr = new ::KUserGroup(cppArg0);
            }
            break;
        }
        case 2: // KUserGroup(const KUserGroup &group)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUserGroup cppArg0_local;
            ::KUserGroup *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserGroup(KUserGroup)
                cptr = new ::KUserGroup(*cppArg0);
            }
            break;
        }
        case 3: // KUserGroup(const QString &name)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserGroup(QString)
                cptr = new ::KUserGroup(cppArg0);
            }
            break;
        }
        case 4: // KUserGroup(const char *name)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserGroup(const char*)
                cptr = new ::KUserGroup(cppArg0);
            }
            break;
        }
        case 5: // KUserGroup(unsigned int gid)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserGroup(uint)
                cptr = new ::KUserGroup(cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KUserGroup >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KUserGroupFunc_allGroupNames(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "allGroupNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    if (PyArg_ParseTuple(args, "|O:allGroupNames", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KUserGroup::allGroupNames(uint=)->QStringList
    if (numArgs == 0) {
        overloadId = 0; // allGroupNames(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // allGroupNames(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "allGroupNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "allGroupNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // allGroupNames(uint)
            QStringList cppResult = ::KUserGroup::allGroupNames(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserGroupFunc_allGroups(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "allGroups", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    if (PyArg_ParseTuple(args, "|O:allGroups", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KUserGroup::allGroups(uint=)->QList<KUserGroup>
    if (numArgs == 0) {
        overloadId = 0; // allGroups(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // allGroups(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "allGroups", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "allGroups", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // allGroups(uint)
            QList<KUserGroup> cppResult = ::KUserGroup::allGroups(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUserGroup_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserGroupFunc_groupId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // groupId()const
        KGroupId cppResult = const_cast<const ::KUserGroup *>(cppSelf)->groupId();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KGroupId_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserGroupFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KUserGroup *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserGroupFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KUserGroup *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserGroupFunc_userNames(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "userNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    if (PyArg_ParseTuple(args, "|O:userNames", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUserGroup::userNames(uint=)const->QStringList
    if (numArgs == 0) {
        overloadId = 0; // userNames(uint)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // userNames(uint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "userNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "userNames", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // userNames(uint)const
            QStringList cppResult = const_cast<const ::KUserGroup *>(cppSelf)->userNames(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserGroupFunc_users(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "users", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    if (PyArg_ParseTuple(args, "|O:users", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUserGroup::users(uint=)const->QList<KUser>
    if (numArgs == 0) {
        overloadId = 0; // users(uint)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // users(uint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "users", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxCount", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "users", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]);
            }
        }
        uint cppArg0 = KCOREADDONS_UINT_MAX;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // users(uint)const
            QList<KUser> cppResult = const_cast<const ::KUserGroup *>(cppSelf)->users(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KUser_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserGroup__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KUserGroup_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUserGroup_methods[] = {
    {"allGroupNames", reinterpret_cast<PyCFunction>(Sbk_KUserGroupFunc_allGroupNames), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"allGroups", reinterpret_cast<PyCFunction>(Sbk_KUserGroupFunc_allGroups), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"groupId", reinterpret_cast<PyCFunction>(Sbk_KUserGroupFunc_groupId), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KUserGroupFunc_isValid), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KUserGroupFunc_name), METH_NOARGS, nullptr},
    {"userNames", reinterpret_cast<PyCFunction>(Sbk_KUserGroupFunc_userNames), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"users", reinterpret_cast<PyCFunction>(Sbk_KUserGroupFunc_users), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KUserGroup__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_KUserGroup_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), (pyArg)))) {
                // operator!=(const KUserGroup &group) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUserGroup cppArg0_local;
                ::KUserGroup *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf != (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), (pyArg)))) {
                // operator==(const KUserGroup &group) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUserGroup cppArg0_local;
                ::KUserGroup *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

} // extern "C"

static int Sbk_KUserGroup_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUserGroup_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUserGroup_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUserGroup_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUserGroup_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_KUserGroup_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUserGroup_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUserGroup_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUserGroup_spec = {
    "1:KCoreAddons.KUserGroup",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUserGroup_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KUserGroup_PythonToCpp_KUserGroup_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUserGroup_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KUserGroup_PythonToCpp_KUserGroup_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUserGroup_TypeF()))
        return KUserGroup_PythonToCpp_KUserGroup_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KUserGroup_PTR_CppToPython_KUserGroup(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KUserGroup_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KUserGroup_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KUserGroup_COPY_CppToPython_KUserGroup(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KUserGroup *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KUserGroup_TypeF(), new ::KUserGroup(*source), true, true);
}

// Python to C++ copy conversion.
static void KUserGroup_PythonToCpp_KUserGroup_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KUserGroup *>(cppOut) = *reinterpret_cast< ::KUserGroup *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KUserGroup_PythonToCpp_KUserGroup_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KUserGroup_TypeF()))
        return KUserGroup_PythonToCpp_KUserGroup_COPY;
    return {};
}

// Implicit conversions.
static void KUser_UIDMode_PythonToCpp_KUserGroup(PyObject *pyIn, void *cppOut)
{
    ::KUser::UIDMode cppIn{KUser::UseEffectiveUID};
    Shiboken::Conversions::pythonToCppCopy(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX])))->converter, pyIn, &cppIn);
    *reinterpret_cast<::KUserGroup *>(cppOut) = ::KUserGroup(cppIn);
}
static PythonToCppFunc is_KUser_UIDMode_PythonToCpp_KUserGroup_Convertible(PyObject *pyIn)
{
    if (SbkObject_TypeCheck(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUser_UIDMode_IDX]), pyIn))
        return KUser_UIDMode_PythonToCpp_KUserGroup;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUserGroup_SignatureStrings[] = {
    "5:KCoreAddons.KUserGroup(self,gid:KCoreAddons.KGroupId)",
    "4:KCoreAddons.KUserGroup(self,mode:KCoreAddons.KUser.UIDMode=KUser.UseEffectiveUID)",
    "3:KCoreAddons.KUserGroup(self,group:KCoreAddons.KUserGroup)",
    "2:KCoreAddons.KUserGroup(self,name:QString)",
    "1:KCoreAddons.KUserGroup(self,name:char*)",
    "0:KCoreAddons.KUserGroup(self,gid:unsigned int)",
    "KCoreAddons.KUserGroup.allGroupNames(maxCount:uint=KCOREADDONS_UINT_MAX)->QStringList",
    "KCoreAddons.KUserGroup.allGroups(maxCount:uint=KCOREADDONS_UINT_MAX)->QList[KCoreAddons.KUserGroup]",
    "KCoreAddons.KUserGroup.groupId(self)->KCoreAddons.KGroupId",
    "KCoreAddons.KUserGroup.isValid(self)->bool",
    "KCoreAddons.KUserGroup.name(self)->QString",
    "KCoreAddons.KUserGroup.userNames(self,maxCount:uint=KCOREADDONS_UINT_MAX)->QStringList",
    "KCoreAddons.KUserGroup.users(self,maxCount:uint=KCOREADDONS_UINT_MAX)->QList[KCoreAddons.KUser]",
    "KCoreAddons.KUserGroup.__copy__(self)->typing._Self",
    "KCoreAddons.KUserGroup.__ne__(self,group:typing.Union[KCoreAddons.KUserGroup, KCoreAddons.KUser.UIDMode])->bool",
    "KCoreAddons.KUserGroup.__eq__(self,group:typing.Union[KCoreAddons.KUserGroup, KCoreAddons.KUser.UIDMode])->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KUserGroup_SignatureByteSize = 303;
static constexpr uint8_t KUserGroup_SignatureBytes[303] = {
    0x78, 0xda, 0xb5, 0x53, 0x5d, 0x6b, 0x83, 0x30, 0x14, 0x7d, 0xcf, 0xaf, 0xe8, 0x63, 0x33, 0x3a,
    0xd9, 0xe7, 0x8b, 0xd0, 0x82, 0x68, 0x19, 0xe2, 0x6a, 0xd9, 0x9c, 0x63, 0x50, 0x4a, 0x70, 0x26,
    0xba, 0x80, 0x26, 0xce, 0xc4, 0xb1, 0xfe, 0xfb, 0x45, 0x4d, 0x07, 0x63, 0x46, 0x37, 0xd8, 0xde,
    0xee, 0xe5, 0x9e, 0x73, 0x72, 0xef, 0xb9, 0x37, 0xd7, 0x76, 0xe0, 0xf2, 0x9a, 0x38, 0x18, 0x73,
    0x26, 0xac, 0x20, 0x16, 0xa4, 0xbe, 0xa9, 0x79, 0x53, 0xcd, 0x05, 0x29, 0xb2, 0x45, 0x4e, 0xf1,
    0xd7, 0x7a, 0x57, 0xf3, 0x31, 0x04, 0x57, 0xa3, 0xbc, 0x92, 0x63, 0xf2, 0x1d, 0x60, 0xc5, 0xbe,
    0xb7, 0x51, 0x95, 0xa5, 0xce, 0x04, 0x59, 0x67, 0x19, 0x49, 0x25, 0x7d, 0x23, 0xaa, 0x02, 0xc1,
    0xe5, 0x78, 0x2f, 0x6d, 0x68, 0x40, 0x40, 0x70, 0x31, 0xca, 0x65, 0x49, 0x49, 0xec, 0xbb, 0x48,
    0xd6, 0x94, 0xe5, 0x10, 0x9c, 0x4f, 0x63, 0xd3, 0x97, 0xa4, 0x3e, 0x81, 0xe0, 0x6c, 0xd2, 0x9d,
    0x86, 0x09, 0x9a, 0x33, 0x82, 0x67, 0x94, 0x49, 0x08, 0x86, 0xd1, 0x56, 0x52, 0x14, 0x5d, 0x10,
    0x2a, 0x69, 0x31, 0x2f, 0x93, 0x77, 0x97, 0x37, 0x4c, 0xda, 0x8d, 0xe2, 0x2c, 0x03, 0x77, 0x7b,
    0xbf, 0x76, 0x3c, 0x6f, 0x1b, 0x46, 0x28, 0xf6, 0xc3, 0x07, 0xb4, 0x71, 0x9e, 0xe0, 0xe9, 0x4a,
    0x37, 0x7b, 0x4b, 0x85, 0x9c, 0x52, 0xfd, 0xa9, 0x62, 0xab, 0xb5, 0x1b, 0xd6, 0xda, 0x9b, 0xde,
    0xc8, 0xfb, 0x7d, 0x77, 0xf3, 0x2a, 0x8d, 0xa1, 0x5b, 0x30, 0x51, 0xa9, 0x78, 0x4c, 0x0a, 0xfa,
    0x49, 0x7d, 0xe6, 0xbc, 0x30, 0x41, 0x5b, 0xcb, 0x8f, 0x38, 0x3d, 0xb8, 0x09, 0xda, 0xa8, 0xa8,
    0xb7, 0xb1, 0x3f, 0xb4, 0x3f, 0xf2, 0xb2, 0x95, 0xfd, 0x95, 0xe4, 0xb0, 0x99, 0x46, 0x1f, 0x11,
    0x4a, 0x79, 0x75, 0x40, 0xe8, 0x38, 0xa5, 0x3c, 0x54, 0xaa, 0x23, 0x0b, 0x45, 0x2a, 0x35, 0x73,
    0x18, 0xd1, 0x0c, 0x7d, 0xfc, 0x9a, 0x15, 0x33, 0xca, 0x99, 0x61, 0x93, 0x8b, 0x99, 0xf1, 0xdb,
    0xed, 0x27, 0xb6, 0x80, 0x10, 0x79, 0xfd, 0x97, 0xf7, 0x3e, 0x00, 0xb5, 0xac, 0x90, 0xc6
};
#endif

PyTypeObject *init_KUserGroup(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX].type;

    Shiboken::AutoDecRef Sbk_KUserGroup_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUserGroup_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUserGroup",
        "KUserGroup",
        &Sbk_KUserGroup_spec,
        &Shiboken::callCppDestructor< ::KUserGroup >,
        Sbk_KUserGroup_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KUserGroup_Type; // references _Sbk_KUserGroup_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUserGroup_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUserGroup_SignatureBytes, KUserGroup_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUserGroup_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KUserGroup_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KUserGroup_PythonToCpp_KUserGroup_PTR,
        is_KUserGroup_PythonToCpp_KUserGroup_PTR_Convertible,
        KUserGroup_PTR_CppToPython_KUserGroup,
        KUserGroup_COPY_CppToPython_KUserGroup);

    Shiboken::Conversions::registerConverterName(converter, "KUserGroup");
    Shiboken::Conversions::registerConverterName(converter, "KUserGroup*");
    Shiboken::Conversions::registerConverterName(converter, "KUserGroup&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUserGroup).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KUserGroup_PythonToCpp_KUserGroup_COPY,
        is_KUserGroup_PythonToCpp_KUserGroup_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KUser_UIDMode_PythonToCpp_KUserGroup,
        is_KUser_UIDMode_PythonToCpp_KUserGroup_Convertible);

    qRegisterMetaType< ::KUserGroup >("KUserGroup");

    return pyType;
}
