#ifndef FR_EMERSION_KANSHI_H
#define FR_EMERSION_KANSHI_H

#include <stdbool.h>
#include <stddef.h>

struct json_object;
struct vali_client;
struct vali_error;
struct vali_service_call;
struct vali_registry;

struct ipc_error_ProfileNotFound {
	char _;
};
/** Try to convert a struct vali_error into a ProfileNotFound error. */
bool ipc_error_ProfileNotFound_from(struct ipc_error_ProfileNotFound *out, const struct vali_error *err);
/** Close a service call with a ProfileNotFound error. */
void ipc_error_ProfileNotFound_close_service_call(struct vali_service_call *call, const struct ipc_error_ProfileNotFound *params);

struct ipc_error_ProfileNotMatched {
	char _;
};
/** Try to convert a struct vali_error into a ProfileNotMatched error. */
bool ipc_error_ProfileNotMatched_from(struct ipc_error_ProfileNotMatched *out, const struct vali_error *err);
/** Close a service call with a ProfileNotMatched error. */
void ipc_error_ProfileNotMatched_close_service_call(struct vali_service_call *call, const struct ipc_error_ProfileNotMatched *params);

struct ipc_error_ProfileNotApplied {
	char _;
};
/** Try to convert a struct vali_error into a ProfileNotApplied error. */
bool ipc_error_ProfileNotApplied_from(struct ipc_error_ProfileNotApplied *out, const struct vali_error *err);
/** Close a service call with a ProfileNotApplied error. */
void ipc_error_ProfileNotApplied_close_service_call(struct vali_service_call *call, const struct ipc_error_ProfileNotApplied *params);

/** Input for Reload calls. */
struct ipc_Reload_in {
	char _;
};
/** Output for Reload calls. */
struct ipc_Reload_out {
	char _;
};
/** Release resources held by Reload call output. */
void ipc_Reload_out_finish(struct ipc_Reload_out *v);
/** Perform a Reload client call. */
bool ipc_Reload(struct vali_client *c, const struct ipc_Reload_in *in, struct ipc_Reload_out *out, struct vali_error *err);
/** A Reload call for a client. */
struct ipc_Reload_client_call {
	struct vali_client_call *base;
};
/** Send a request for a Reload client call, indicating that multiple replies are expected. */
struct ipc_Reload_client_call ipc_Reload_more(struct vali_client *c, const struct ipc_Reload_in *in);
/** Wait for a Reload reply. */
bool ipc_Reload_client_call_wait(struct ipc_Reload_client_call call, struct ipc_Reload_out *out, struct vali_error *err);
/** Send a request for a Reload client call, indicating that no reply is expected. */bool ipc_Reload_oneway(struct vali_client *c, const struct ipc_Reload_in *in);
/** A Reload call for a service. */
struct ipc_Reload_service_call {
	struct vali_service_call *base;
};
/** Close a Reload service call with a final reply. */
void ipc_Reload_close_with_reply(struct ipc_Reload_service_call call, const struct ipc_Reload_out *params);
/** Send a reply for a Reload service call, indicating that more replies will be sent. */
void ipc_Reload_reply(struct ipc_Reload_service_call call, const struct ipc_Reload_out *params);

/** Input for Switch calls. */
struct ipc_Switch_in {
	char *profile;
};
/** Output for Switch calls. */
struct ipc_Switch_out {
	char _;
};
/** Release resources held by Switch call output. */
void ipc_Switch_out_finish(struct ipc_Switch_out *v);
/** Perform a Switch client call. */
bool ipc_Switch(struct vali_client *c, const struct ipc_Switch_in *in, struct ipc_Switch_out *out, struct vali_error *err);
/** A Switch call for a client. */
struct ipc_Switch_client_call {
	struct vali_client_call *base;
};
/** Send a request for a Switch client call, indicating that multiple replies are expected. */
struct ipc_Switch_client_call ipc_Switch_more(struct vali_client *c, const struct ipc_Switch_in *in);
/** Wait for a Switch reply. */
bool ipc_Switch_client_call_wait(struct ipc_Switch_client_call call, struct ipc_Switch_out *out, struct vali_error *err);
/** Send a request for a Switch client call, indicating that no reply is expected. */bool ipc_Switch_oneway(struct vali_client *c, const struct ipc_Switch_in *in);
/** A Switch call for a service. */
struct ipc_Switch_service_call {
	struct vali_service_call *base;
};
/** Close a Switch service call with a final reply. */
void ipc_Switch_close_with_reply(struct ipc_Switch_service_call call, const struct ipc_Switch_out *params);
/** Send a reply for a Switch service call, indicating that more replies will be sent. */
void ipc_Switch_reply(struct ipc_Switch_service_call call, const struct ipc_Switch_out *params);

/** Input for Status calls. */
struct ipc_Status_in {
	char _;
};
/** Output for Status calls. */
struct ipc_Status_out {
	char *current_profile;
	char *pending_profile;
};
/** Release resources held by Status call output. */
void ipc_Status_out_finish(struct ipc_Status_out *v);
/** Perform a Status client call. */
bool ipc_Status(struct vali_client *c, const struct ipc_Status_in *in, struct ipc_Status_out *out, struct vali_error *err);
/** A Status call for a client. */
struct ipc_Status_client_call {
	struct vali_client_call *base;
};
/** Send a request for a Status client call, indicating that multiple replies are expected. */
struct ipc_Status_client_call ipc_Status_more(struct vali_client *c, const struct ipc_Status_in *in);
/** Wait for a Status reply. */
bool ipc_Status_client_call_wait(struct ipc_Status_client_call call, struct ipc_Status_out *out, struct vali_error *err);
/** Send a request for a Status client call, indicating that no reply is expected. */bool ipc_Status_oneway(struct vali_client *c, const struct ipc_Status_in *in);
/** A Status call for a service. */
struct ipc_Status_service_call {
	struct vali_service_call *base;
};
/** Close a Status service call with a final reply. */
void ipc_Status_close_with_reply(struct ipc_Status_service_call call, const struct ipc_Status_out *params);
/** Send a reply for a Status service call, indicating that more replies will be sent. */
void ipc_Status_reply(struct ipc_Status_service_call call, const struct ipc_Status_out *params);

/** Handler for fr.emersion.kanshi. */
struct ipc_handler {
	void (*Reload)(struct ipc_Reload_service_call call, const struct ipc_Reload_in *in);
	void (*Switch)(struct ipc_Switch_service_call call, const struct ipc_Switch_in *in);
	void (*Status)(struct ipc_Status_service_call call, const struct ipc_Status_in *in);
};

/** Get a service call handler from a fr.emersion.kanshi handler. */
struct vali_service_call_handler ipc_get_call_handler(const struct ipc_handler *handler);

/** Description of the fr.emersion.kanshi interface. */
extern const struct vali_registry_interface ipc_interface;

#endif
