/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 7 "parse.y"

/*
 * Copyright (c) 2011-2025 Stephen Williams (steve@icarus.com)
 * Copyright CERN 2012-2016 / Stephen Williams (steve@icarus.com),
 * @author Maciej Suminski (maciej.suminski@cern.ch)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

# include "vhdlpp_config.h"
# include "vhdlint.h"
# include "vhdlreal.h"
# include "compiler.h"
# include "parse_api.h"
# include "parse_misc.h"
# include "architec.h"
# include "expression.h"
# include "sequential.h"
# include "subprogram.h"
# include "package.h"
# include "vsignal.h"
# include "vtype.h"
# include "std_funcs.h"
# include "std_types.h"
# include  <cstdarg>
# include  <cstring>
# include  <list>
# include  <stack>
# include  <map>
# include  <vector>
# include  "parse_types.h"
# include  <ivl_assert.h>
# include  <assert.h>

using namespace std;

inline void FILE_NAME(LineInfo*tmp, const struct yyltype&where)
{
      tmp->set_lineno(where.first_line);
      tmp->set_file(filename_strings.make(where.text));
}


/* Recent version of bison expect that the user supply a
   YYLLOC_DEFAULT macro that makes up a yylloc value from existing
   values. I need to supply an explicit version to account for the
   text field, that otherwise won't be copied. */
# define YYLLOC_DEFAULT(Current, Rhs, N)  do {       \
  (Current).first_line   = (Rhs)[1].first_line;      \
  (Current).text         = file_path; /*(Rhs)[1].text;*/   } while (0)

static void yyerror(const YYLTYPE*yyllocp,yyscan_t yyscanner,const char*file_path,bool, const char*msg);

int parse_errors = 0;
int parse_sorrys = 0;

/*
 * The parser calls yylex to get the next lexical token. It is only
 * called by the bison-generated parser.
 */
extern int yylex(union YYSTYPE*yylvalp,YYLTYPE*yyllocp,yyscan_t yyscanner);


/*
 * Create an initial scope that collects all the global
 * declarations. Also save a stack of previous scopes, as a way to
 * manage lexical scopes.
 */
static ActiveScope*active_scope = new ActiveScope;
static stack<ActiveScope*> scope_stack;
static SubprogramHeader*active_sub = NULL;
static ActiveScope*arc_scope = NULL;

/*
 * When a scope boundary starts, call the push_scope function to push
 * a scope context. Preload this scope context with the contents of
 * the parent scope, then make this the current scope. When the scope
 * is done, the pop_scope function pops the scope off the stack and
 * resumes the scope that was the parent.
 */
static void push_scope(void)
{
      assert(active_scope);
      scope_stack.push(active_scope);
      active_scope = new ActiveScope (active_scope);
}

static void pop_scope(void)
{
      delete active_scope;
      assert(! scope_stack.empty());
      active_scope = scope_stack.top();
      scope_stack.pop();
}

static bool is_subprogram_param(perm_string name)
{
    if(!active_sub)
        return false;

    return (active_sub->find_param(name) != NULL);
}

void preload_global_types(void)
{
      generate_global_types(active_scope);
}

//Remove the scope created at the beginning of parser's work.
//After the parsing active_scope should keep it's address

static void delete_global_scope(void)
{
    active_scope->destroy_global_scope();
    delete active_scope;
}

//delete global entities that were gathered over the parsing process
static void delete_design_entities(void)
{
      for(map<perm_string,Entity*>::iterator cur = design_entities.begin()
      ; cur != design_entities.end(); ++cur)
        delete cur->second;
}

//clean the mess caused by the parser
void parser_cleanup(void)
{
    delete_design_entities();
    delete_global_scope();
    delete_std_funcs();
    lex_strings.cleanup();
}

const VType*parse_type_by_name(perm_string name)
{
      return active_scope->find_type(name);
}

// This function is called when an aggregate expression is detected by
// the parser. It makes the ExpAggregate. It also tries to detect the
// special case that the aggregate is really a primary. The problem is
// that this:
//   ( <expression> )
// also matches the pattern:
//   ( [ choices => ] <expression> ... )
// so try to assume that a single expression in parentheses is a
// primary and fix the parse by returning an Expression instead of an
// ExpAggregate.
static Expression*aggregate_or_primary(const YYLTYPE&loc, std::list<ExpAggregate::element_t*>*el)
{
      if (el->size() != 1) {
	    ExpAggregate*tmp = new ExpAggregate(el);
	    FILE_NAME(tmp,loc);
	    return tmp;
      }

      ExpAggregate::element_t*el1 = el->front();
      if (el1->count_choices() > 0) {
	    ExpAggregate*tmp = new ExpAggregate(el);
	    FILE_NAME(tmp,loc);
	    return tmp;
      }

      return el1->extract_expression();
}

static list<VTypeRecord::element_t*>* record_elements(list<perm_string>*names,
						      const VType*type)
{
      list<VTypeRecord::element_t*>*res = new list<VTypeRecord::element_t*>;

      for (list<perm_string>::iterator cur = names->begin()
		 ; cur != names->end() ; ++cur) {
	    res->push_back(new VTypeRecord::element_t(*cur, type));
      }

      return res;
}

static void touchup_interface_for_functions(std::list<InterfacePort*>*ports)
{
      for (list<InterfacePort*>::iterator cur = ports->begin()
		 ; cur != ports->end() ; ++cur) {
	    InterfacePort*curp = *cur;
	    if (curp->mode == PORT_NONE)
		  curp->mode = PORT_IN;
      }
}


#line 276 "parse.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parse.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_K_abs = 3,                      /* K_abs  */
  YYSYMBOL_K_access = 4,                   /* K_access  */
  YYSYMBOL_K_after = 5,                    /* K_after  */
  YYSYMBOL_K_alias = 6,                    /* K_alias  */
  YYSYMBOL_K_all = 7,                      /* K_all  */
  YYSYMBOL_K_and = 8,                      /* K_and  */
  YYSYMBOL_K_architecture = 9,             /* K_architecture  */
  YYSYMBOL_K_array = 10,                   /* K_array  */
  YYSYMBOL_K_assert = 11,                  /* K_assert  */
  YYSYMBOL_K_assume = 12,                  /* K_assume  */
  YYSYMBOL_K_assume_guarantee = 13,        /* K_assume_guarantee  */
  YYSYMBOL_K_attribute = 14,               /* K_attribute  */
  YYSYMBOL_K_begin = 15,                   /* K_begin  */
  YYSYMBOL_K_block = 16,                   /* K_block  */
  YYSYMBOL_K_body = 17,                    /* K_body  */
  YYSYMBOL_K_buffer = 18,                  /* K_buffer  */
  YYSYMBOL_K_bus = 19,                     /* K_bus  */
  YYSYMBOL_K_case = 20,                    /* K_case  */
  YYSYMBOL_K_component = 21,               /* K_component  */
  YYSYMBOL_K_configuration = 22,           /* K_configuration  */
  YYSYMBOL_K_constant = 23,                /* K_constant  */
  YYSYMBOL_K_context = 24,                 /* K_context  */
  YYSYMBOL_K_cover = 25,                   /* K_cover  */
  YYSYMBOL_K_default = 26,                 /* K_default  */
  YYSYMBOL_K_disconnect = 27,              /* K_disconnect  */
  YYSYMBOL_K_downto = 28,                  /* K_downto  */
  YYSYMBOL_K_else = 29,                    /* K_else  */
  YYSYMBOL_K_elsif = 30,                   /* K_elsif  */
  YYSYMBOL_K_end = 31,                     /* K_end  */
  YYSYMBOL_K_entity = 32,                  /* K_entity  */
  YYSYMBOL_K_exit = 33,                    /* K_exit  */
  YYSYMBOL_K_fairness = 34,                /* K_fairness  */
  YYSYMBOL_K_file = 35,                    /* K_file  */
  YYSYMBOL_K_for = 36,                     /* K_for  */
  YYSYMBOL_K_force = 37,                   /* K_force  */
  YYSYMBOL_K_function = 38,                /* K_function  */
  YYSYMBOL_K_generate = 39,                /* K_generate  */
  YYSYMBOL_K_generic = 40,                 /* K_generic  */
  YYSYMBOL_K_group = 41,                   /* K_group  */
  YYSYMBOL_K_guarded = 42,                 /* K_guarded  */
  YYSYMBOL_K_if = 43,                      /* K_if  */
  YYSYMBOL_K_impure = 44,                  /* K_impure  */
  YYSYMBOL_K_in = 45,                      /* K_in  */
  YYSYMBOL_K_inertial = 46,                /* K_inertial  */
  YYSYMBOL_K_inout = 47,                   /* K_inout  */
  YYSYMBOL_K_is = 48,                      /* K_is  */
  YYSYMBOL_K_label = 49,                   /* K_label  */
  YYSYMBOL_K_library = 50,                 /* K_library  */
  YYSYMBOL_K_linkage = 51,                 /* K_linkage  */
  YYSYMBOL_K_literal = 52,                 /* K_literal  */
  YYSYMBOL_K_loop = 53,                    /* K_loop  */
  YYSYMBOL_K_map = 54,                     /* K_map  */
  YYSYMBOL_K_mod = 55,                     /* K_mod  */
  YYSYMBOL_K_nand = 56,                    /* K_nand  */
  YYSYMBOL_K_new = 57,                     /* K_new  */
  YYSYMBOL_K_next = 58,                    /* K_next  */
  YYSYMBOL_K_nor = 59,                     /* K_nor  */
  YYSYMBOL_K_not = 60,                     /* K_not  */
  YYSYMBOL_K_null = 61,                    /* K_null  */
  YYSYMBOL_K_of = 62,                      /* K_of  */
  YYSYMBOL_K_on = 63,                      /* K_on  */
  YYSYMBOL_K_open = 64,                    /* K_open  */
  YYSYMBOL_K_or = 65,                      /* K_or  */
  YYSYMBOL_K_others = 66,                  /* K_others  */
  YYSYMBOL_K_out = 67,                     /* K_out  */
  YYSYMBOL_K_package = 68,                 /* K_package  */
  YYSYMBOL_K_parameter = 69,               /* K_parameter  */
  YYSYMBOL_K_port = 70,                    /* K_port  */
  YYSYMBOL_K_postponed = 71,               /* K_postponed  */
  YYSYMBOL_K_procedure = 72,               /* K_procedure  */
  YYSYMBOL_K_process = 73,                 /* K_process  */
  YYSYMBOL_K_property = 74,                /* K_property  */
  YYSYMBOL_K_protected = 75,               /* K_protected  */
  YYSYMBOL_K_pure = 76,                    /* K_pure  */
  YYSYMBOL_K_range = 77,                   /* K_range  */
  YYSYMBOL_K_record = 78,                  /* K_record  */
  YYSYMBOL_K_register = 79,                /* K_register  */
  YYSYMBOL_K_reject = 80,                  /* K_reject  */
  YYSYMBOL_K_release = 81,                 /* K_release  */
  YYSYMBOL_K_rem = 82,                     /* K_rem  */
  YYSYMBOL_K_report = 83,                  /* K_report  */
  YYSYMBOL_K_restrict = 84,                /* K_restrict  */
  YYSYMBOL_K_restrict_guarantee = 85,      /* K_restrict_guarantee  */
  YYSYMBOL_K_return = 86,                  /* K_return  */
  YYSYMBOL_K_reverse_range = 87,           /* K_reverse_range  */
  YYSYMBOL_K_rol = 88,                     /* K_rol  */
  YYSYMBOL_K_ror = 89,                     /* K_ror  */
  YYSYMBOL_K_select = 90,                  /* K_select  */
  YYSYMBOL_K_sequence = 91,                /* K_sequence  */
  YYSYMBOL_K_severity = 92,                /* K_severity  */
  YYSYMBOL_K_signal = 93,                  /* K_signal  */
  YYSYMBOL_K_shared = 94,                  /* K_shared  */
  YYSYMBOL_K_sla = 95,                     /* K_sla  */
  YYSYMBOL_K_sll = 96,                     /* K_sll  */
  YYSYMBOL_K_sra = 97,                     /* K_sra  */
  YYSYMBOL_K_srl = 98,                     /* K_srl  */
  YYSYMBOL_K_strong = 99,                  /* K_strong  */
  YYSYMBOL_K_subtype = 100,                /* K_subtype  */
  YYSYMBOL_K_then = 101,                   /* K_then  */
  YYSYMBOL_K_to = 102,                     /* K_to  */
  YYSYMBOL_K_transport = 103,              /* K_transport  */
  YYSYMBOL_K_type = 104,                   /* K_type  */
  YYSYMBOL_K_unaffected = 105,             /* K_unaffected  */
  YYSYMBOL_K_units = 106,                  /* K_units  */
  YYSYMBOL_K_until = 107,                  /* K_until  */
  YYSYMBOL_K_use = 108,                    /* K_use  */
  YYSYMBOL_K_variable = 109,               /* K_variable  */
  YYSYMBOL_K_vmode = 110,                  /* K_vmode  */
  YYSYMBOL_K_vprop = 111,                  /* K_vprop  */
  YYSYMBOL_K_vunit = 112,                  /* K_vunit  */
  YYSYMBOL_K_wait = 113,                   /* K_wait  */
  YYSYMBOL_K_when = 114,                   /* K_when  */
  YYSYMBOL_K_while = 115,                  /* K_while  */
  YYSYMBOL_K_with = 116,                   /* K_with  */
  YYSYMBOL_K_xnor = 117,                   /* K_xnor  */
  YYSYMBOL_K_xor = 118,                    /* K_xor  */
  YYSYMBOL_IDENTIFIER = 119,               /* IDENTIFIER  */
  YYSYMBOL_INT_LITERAL = 120,              /* INT_LITERAL  */
  YYSYMBOL_REAL_LITERAL = 121,             /* REAL_LITERAL  */
  YYSYMBOL_STRING_LITERAL = 122,           /* STRING_LITERAL  */
  YYSYMBOL_CHARACTER_LITERAL = 123,        /* CHARACTER_LITERAL  */
  YYSYMBOL_BITSTRING_LITERAL = 124,        /* BITSTRING_LITERAL  */
  YYSYMBOL_LEQ = 125,                      /* LEQ  */
  YYSYMBOL_GEQ = 126,                      /* GEQ  */
  YYSYMBOL_VASSIGN = 127,                  /* VASSIGN  */
  YYSYMBOL_NE = 128,                       /* NE  */
  YYSYMBOL_BOX = 129,                      /* BOX  */
  YYSYMBOL_EXP = 130,                      /* EXP  */
  YYSYMBOL_ARROW = 131,                    /* ARROW  */
  YYSYMBOL_DLT = 132,                      /* DLT  */
  YYSYMBOL_DGT = 133,                      /* DGT  */
  YYSYMBOL_CC = 134,                       /* CC  */
  YYSYMBOL_M_EQ = 135,                     /* M_EQ  */
  YYSYMBOL_M_NE = 136,                     /* M_NE  */
  YYSYMBOL_M_LT = 137,                     /* M_LT  */
  YYSYMBOL_M_LEQ = 138,                    /* M_LEQ  */
  YYSYMBOL_M_GT = 139,                     /* M_GT  */
  YYSYMBOL_M_GEQ = 140,                    /* M_GEQ  */
  YYSYMBOL_141_ = 141,                     /* '+'  */
  YYSYMBOL_142_ = 142,                     /* '-'  */
  YYSYMBOL_143_ = 143,                     /* '&'  */
  YYSYMBOL_144_ = 144,                     /* ';'  */
  YYSYMBOL_145_ = 145,                     /* '('  */
  YYSYMBOL_146_ = 146,                     /* ')'  */
  YYSYMBOL_147_ = 147,                     /* ','  */
  YYSYMBOL_148_ = 148,                     /* ':'  */
  YYSYMBOL_149_ = 149,                     /* '|'  */
  YYSYMBOL_150_ = 150,                     /* '\''  */
  YYSYMBOL_151_ = 151,                     /* '='  */
  YYSYMBOL_152_ = 152,                     /* '<'  */
  YYSYMBOL_153_ = 153,                     /* '>'  */
  YYSYMBOL_154_ = 154,                     /* '.'  */
  YYSYMBOL_155_ = 155,                     /* '*'  */
  YYSYMBOL_156_ = 156,                     /* '/'  */
  YYSYMBOL_YYACCEPT = 157,                 /* $accept  */
  YYSYMBOL_design_file = 158,              /* design_file  */
  YYSYMBOL_159_1 = 159,                    /* $@1  */
  YYSYMBOL_adding_operator = 160,          /* adding_operator  */
  YYSYMBOL_architecture_body = 161,        /* architecture_body  */
  YYSYMBOL_162_2 = 162,                    /* $@2  */
  YYSYMBOL_architecture_body_start = 163,  /* architecture_body_start  */
  YYSYMBOL_architecture_statement_part = 164, /* architecture_statement_part  */
  YYSYMBOL_argument_list = 165,            /* argument_list  */
  YYSYMBOL_argument_list_opt = 166,        /* argument_list_opt  */
  YYSYMBOL_assertion_statement = 167,      /* assertion_statement  */
  YYSYMBOL_association_element = 168,      /* association_element  */
  YYSYMBOL_association_list = 169,         /* association_list  */
  YYSYMBOL_binding_indication = 170,       /* binding_indication  */
  YYSYMBOL_binding_indication_semicolon_opt = 171, /* binding_indication_semicolon_opt  */
  YYSYMBOL_block_configuration = 172,      /* block_configuration  */
  YYSYMBOL_block_configuration_opt = 173,  /* block_configuration_opt  */
  YYSYMBOL_block_declarative_item = 174,   /* block_declarative_item  */
  YYSYMBOL_block_declarative_items = 175,  /* block_declarative_items  */
  YYSYMBOL_block_declarative_items_opt = 176, /* block_declarative_items_opt  */
  YYSYMBOL_case_statement = 177,           /* case_statement  */
  YYSYMBOL_case_statement_alternative_list = 178, /* case_statement_alternative_list  */
  YYSYMBOL_case_statement_alternative = 179, /* case_statement_alternative  */
  YYSYMBOL_choice = 180,                   /* choice  */
  YYSYMBOL_choices = 181,                  /* choices  */
  YYSYMBOL_component_configuration = 182,  /* component_configuration  */
  YYSYMBOL_component_declaration = 183,    /* component_declaration  */
  YYSYMBOL_instantiated_unit = 184,        /* instantiated_unit  */
  YYSYMBOL_component_instantiation_statement = 185, /* component_instantiation_statement  */
  YYSYMBOL_component_specification = 186,  /* component_specification  */
  YYSYMBOL_composite_type_definition = 187, /* composite_type_definition  */
  YYSYMBOL_concurrent_assertion_statement = 188, /* concurrent_assertion_statement  */
  YYSYMBOL_concurrent_conditional_signal_assignment = 189, /* concurrent_conditional_signal_assignment  */
  YYSYMBOL_concurrent_simple_signal_assignment = 190, /* concurrent_simple_signal_assignment  */
  YYSYMBOL_else_when_waveforms = 191,      /* else_when_waveforms  */
  YYSYMBOL_else_when_waveforms_opt = 192,  /* else_when_waveforms_opt  */
  YYSYMBOL_else_when_waveform = 193,       /* else_when_waveform  */
  YYSYMBOL_concurrent_signal_assignment_statement = 194, /* concurrent_signal_assignment_statement  */
  YYSYMBOL_concurrent_statement = 195,     /* concurrent_statement  */
  YYSYMBOL_configuration_declaration = 196, /* configuration_declaration  */
  YYSYMBOL_configuration_declarative_item = 197, /* configuration_declarative_item  */
  YYSYMBOL_configuration_declarative_items = 198, /* configuration_declarative_items  */
  YYSYMBOL_configuration_declarative_part = 199, /* configuration_declarative_part  */
  YYSYMBOL_configuration_item = 200,       /* configuration_item  */
  YYSYMBOL_configuration_items = 201,      /* configuration_items  */
  YYSYMBOL_configuration_items_opt = 202,  /* configuration_items_opt  */
  YYSYMBOL_constant_declaration = 203,     /* constant_declaration  */
  YYSYMBOL_context_clause = 204,           /* context_clause  */
  YYSYMBOL_context_item = 205,             /* context_item  */
  YYSYMBOL_context_items = 206,            /* context_items  */
  YYSYMBOL_design_unit = 207,              /* design_unit  */
  YYSYMBOL_design_units = 208,             /* design_units  */
  YYSYMBOL_direction = 209,                /* direction  */
  YYSYMBOL_element_association = 210,      /* element_association  */
  YYSYMBOL_element_association_list = 211, /* element_association_list  */
  YYSYMBOL_element_declaration = 212,      /* element_declaration  */
  YYSYMBOL_element_declaration_list = 213, /* element_declaration_list  */
  YYSYMBOL_entity_aspect = 214,            /* entity_aspect  */
  YYSYMBOL_entity_aspect_opt = 215,        /* entity_aspect_opt  */
  YYSYMBOL_entity_declaration = 216,       /* entity_declaration  */
  YYSYMBOL_enumeration_literal = 217,      /* enumeration_literal  */
  YYSYMBOL_enumeration_literal_list = 218, /* enumeration_literal_list  */
  YYSYMBOL_expression_list = 219,          /* expression_list  */
  YYSYMBOL_expression = 220,               /* expression  */
  YYSYMBOL_expression_logical = 221,       /* expression_logical  */
  YYSYMBOL_expression_logical_and = 222,   /* expression_logical_and  */
  YYSYMBOL_expression_logical_or = 223,    /* expression_logical_or  */
  YYSYMBOL_expression_logical_xnor = 224,  /* expression_logical_xnor  */
  YYSYMBOL_expression_logical_xor = 225,   /* expression_logical_xor  */
  YYSYMBOL_factor = 226,                   /* factor  */
  YYSYMBOL_file_declaration = 227,         /* file_declaration  */
  YYSYMBOL_file_open_information = 228,    /* file_open_information  */
  YYSYMBOL_file_open_information_opt = 229, /* file_open_information_opt  */
  YYSYMBOL_for_generate_statement = 230,   /* for_generate_statement  */
  YYSYMBOL_function_specification = 231,   /* function_specification  */
  YYSYMBOL_generate_statement = 232,       /* generate_statement  */
  YYSYMBOL_generate_statement_body = 233,  /* generate_statement_body  */
  YYSYMBOL_generic_clause_opt = 234,       /* generic_clause_opt  */
  YYSYMBOL_generic_clause = 235,           /* generic_clause  */
  YYSYMBOL_generic_map_aspect_opt = 236,   /* generic_map_aspect_opt  */
  YYSYMBOL_generic_map_aspect = 237,       /* generic_map_aspect  */
  YYSYMBOL_identifier_list = 238,          /* identifier_list  */
  YYSYMBOL_identifier_opt = 239,           /* identifier_opt  */
  YYSYMBOL_identifier_colon_opt = 240,     /* identifier_colon_opt  */
  YYSYMBOL_if_generate_statement = 241,    /* if_generate_statement  */
  YYSYMBOL_if_statement = 242,             /* if_statement  */
  YYSYMBOL_if_statement_elsif_list_opt = 243, /* if_statement_elsif_list_opt  */
  YYSYMBOL_if_statement_elsif_list = 244,  /* if_statement_elsif_list  */
  YYSYMBOL_if_statement_elsif = 245,       /* if_statement_elsif  */
  YYSYMBOL_if_statement_else = 246,        /* if_statement_else  */
  YYSYMBOL_index_constraint = 247,         /* index_constraint  */
  YYSYMBOL_index_subtype_definition = 248, /* index_subtype_definition  */
  YYSYMBOL_index_subtype_definition_list = 249, /* index_subtype_definition_list  */
  YYSYMBOL_instantiation_list = 250,       /* instantiation_list  */
  YYSYMBOL_interface_element = 251,        /* interface_element  */
  YYSYMBOL_interface_element_expression = 252, /* interface_element_expression  */
  YYSYMBOL_interface_list = 253,           /* interface_list  */
  YYSYMBOL_library_clause = 254,           /* library_clause  */
  YYSYMBOL_library_unit = 255,             /* library_unit  */
  YYSYMBOL_logical_name = 256,             /* logical_name  */
  YYSYMBOL_logical_name_list = 257,        /* logical_name_list  */
  YYSYMBOL_loop_statement = 258,           /* loop_statement  */
  YYSYMBOL_mode = 259,                     /* mode  */
  YYSYMBOL_mode_opt = 260,                 /* mode_opt  */
  YYSYMBOL_name = 261,                     /* name  */
  YYSYMBOL_indexed_name = 262,             /* indexed_name  */
  YYSYMBOL_name_list = 263,                /* name_list  */
  YYSYMBOL_package_declaration = 264,      /* package_declaration  */
  YYSYMBOL_package_declaration_start = 265, /* package_declaration_start  */
  YYSYMBOL_package_body_declarative_item = 266, /* package_body_declarative_item  */
  YYSYMBOL_package_body_declarative_items = 267, /* package_body_declarative_items  */
  YYSYMBOL_package_body_declarative_part_opt = 268, /* package_body_declarative_part_opt  */
  YYSYMBOL_package_declarative_item = 269, /* package_declarative_item  */
  YYSYMBOL_package_declarative_items = 270, /* package_declarative_items  */
  YYSYMBOL_package_declarative_part_opt = 271, /* package_declarative_part_opt  */
  YYSYMBOL_package_body = 272,             /* package_body  */
  YYSYMBOL_package_body_start = 273,       /* package_body_start  */
  YYSYMBOL_parameter_list = 274,           /* parameter_list  */
  YYSYMBOL_parameter_list_opt = 275,       /* parameter_list_opt  */
  YYSYMBOL_port_clause = 276,              /* port_clause  */
  YYSYMBOL_port_clause_opt = 277,          /* port_clause_opt  */
  YYSYMBOL_port_map_aspect = 278,          /* port_map_aspect  */
  YYSYMBOL_port_map_aspect_opt = 279,      /* port_map_aspect_opt  */
  YYSYMBOL_prefix = 280,                   /* prefix  */
  YYSYMBOL_primary = 281,                  /* primary  */
  YYSYMBOL_primary_unit = 282,             /* primary_unit  */
  YYSYMBOL_procedure_call = 283,           /* procedure_call  */
  YYSYMBOL_procedure_call_statement = 284, /* procedure_call_statement  */
  YYSYMBOL_procedure_specification = 285,  /* procedure_specification  */
  YYSYMBOL_process_declarative_item = 286, /* process_declarative_item  */
  YYSYMBOL_process_declarative_part = 287, /* process_declarative_part  */
  YYSYMBOL_process_declarative_part_opt = 288, /* process_declarative_part_opt  */
  YYSYMBOL_process_start = 289,            /* process_start  */
  YYSYMBOL_process_statement = 290,        /* process_statement  */
  YYSYMBOL_process_sensitivity_list_opt = 291, /* process_sensitivity_list_opt  */
  YYSYMBOL_process_sensitivity_list = 292, /* process_sensitivity_list  */
  YYSYMBOL_range = 293,                    /* range  */
  YYSYMBOL_range_list = 294,               /* range_list  */
  YYSYMBOL_record_type_definition = 295,   /* record_type_definition  */
  YYSYMBOL_relation = 296,                 /* relation  */
  YYSYMBOL_report_statement = 297,         /* report_statement  */
  YYSYMBOL_return_statement = 298,         /* return_statement  */
  YYSYMBOL_secondary_unit = 299,           /* secondary_unit  */
  YYSYMBOL_selected_name = 300,            /* selected_name  */
  YYSYMBOL_selected_names = 301,           /* selected_names  */
  YYSYMBOL_selected_name_lib = 302,        /* selected_name_lib  */
  YYSYMBOL_selected_names_lib = 303,       /* selected_names_lib  */
  YYSYMBOL_selected_signal_assignment = 304, /* selected_signal_assignment  */
  YYSYMBOL_selected_waveform = 305,        /* selected_waveform  */
  YYSYMBOL_selected_waveform_list = 306,   /* selected_waveform_list  */
  YYSYMBOL_list_of_statements = 307,       /* list_of_statements  */
  YYSYMBOL_sequence_of_statements = 308,   /* sequence_of_statements  */
  YYSYMBOL_sequential_statement = 309,     /* sequential_statement  */
  YYSYMBOL_severity = 310,                 /* severity  */
  YYSYMBOL_severity_opt = 311,             /* severity_opt  */
  YYSYMBOL_shift_expression = 312,         /* shift_expression  */
  YYSYMBOL_signal_declaration_assign_opt = 313, /* signal_declaration_assign_opt  */
  YYSYMBOL_simple_expression = 314,        /* simple_expression  */
  YYSYMBOL_simple_expression_2 = 315,      /* simple_expression_2  */
  YYSYMBOL_simple_expression_terms = 316,  /* simple_expression_terms  */
  YYSYMBOL_signal_assignment = 317,        /* signal_assignment  */
  YYSYMBOL_signal_assignment_statement = 318, /* signal_assignment_statement  */
  YYSYMBOL_subprogram_body_start = 319,    /* subprogram_body_start  */
  YYSYMBOL_subprogram_body = 320,          /* subprogram_body  */
  YYSYMBOL_subprogram_declaration = 321,   /* subprogram_declaration  */
  YYSYMBOL_subprogram_declarative_item = 322, /* subprogram_declarative_item  */
  YYSYMBOL_subprogram_declarative_item_list = 323, /* subprogram_declarative_item_list  */
  YYSYMBOL_subprogram_declarative_part = 324, /* subprogram_declarative_part  */
  YYSYMBOL_subprogram_kind = 325,          /* subprogram_kind  */
  YYSYMBOL_subprogram_kind_opt = 326,      /* subprogram_kind_opt  */
  YYSYMBOL_subprogram_specification = 327, /* subprogram_specification  */
  YYSYMBOL_subprogram_statement_part = 328, /* subprogram_statement_part  */
  YYSYMBOL_subtype_declaration = 329,      /* subtype_declaration  */
  YYSYMBOL_subtype_indication = 330,       /* subtype_indication  */
  YYSYMBOL_suffix = 331,                   /* suffix  */
  YYSYMBOL_term = 332,                     /* term  */
  YYSYMBOL_type_declaration = 333,         /* type_declaration  */
  YYSYMBOL_type_definition = 334,          /* type_definition  */
  YYSYMBOL_use_clause = 335,               /* use_clause  */
  YYSYMBOL_use_clause_lib = 336,           /* use_clause_lib  */
  YYSYMBOL_use_clauses_lib = 337,          /* use_clauses_lib  */
  YYSYMBOL_use_clauses_opt = 338,          /* use_clauses_opt  */
  YYSYMBOL_variable_assignment_statement = 339, /* variable_assignment_statement  */
  YYSYMBOL_variable_assignment = 340,      /* variable_assignment  */
  YYSYMBOL_variable_declaration = 341,     /* variable_declaration  */
  YYSYMBOL_variable_declaration_assign_opt = 342, /* variable_declaration_assign_opt  */
  YYSYMBOL_wait_statement = 343,           /* wait_statement  */
  YYSYMBOL_waveform = 344,                 /* waveform  */
  YYSYMBOL_waveform_elements = 345,        /* waveform_elements  */
  YYSYMBOL_waveform_element = 346,         /* waveform_element  */
  YYSYMBOL_K_architecture_opt = 347,       /* K_architecture_opt  */
  YYSYMBOL_K_configuration_opt = 348,      /* K_configuration_opt  */
  YYSYMBOL_K_entity_opt = 349,             /* K_entity_opt  */
  YYSYMBOL_K_is_opt = 350,                 /* K_is_opt  */
  YYSYMBOL_K_package_opt = 351,            /* K_package_opt  */
  YYSYMBOL_K_postponed_opt = 352,          /* K_postponed_opt  */
  YYSYMBOL_K_shared_opt = 353              /* K_shared_opt  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1347

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  157
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  197
/* YYNRULES -- Number of rules.  */
#define YYNRULES  449
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  884

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   395


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   143,   150,
     145,   146,   155,   141,   147,   142,   154,   156,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   148,   144,
     152,   151,   153,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   149,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   394,   394,   394,   397,   398,   399,   405,   403,   425,
     437,   442,   448,   455,   458,   459,   463,   471,   479,   484,
     489,   497,   502,   510,   520,   521,   525,   533,   534,   538,
     550,   552,   554,   556,   558,   560,   562,   566,   568,   579,
     580,   584,   585,   589,   600,   605,   620,   658,   660,   662,
     667,   672,   680,   689,   697,   716,   725,   726,   730,   741,
     750,   760,   767,   777,   782,   802,   818,   834,   845,   850,
     858,   859,   864,   869,   877,   879,   884,   886,   891,   893,
     895,   901,   910,   911,   912,   913,   914,   918,   928,   936,
     940,   941,   945,   946,   950,   951,   955,   956,   960,   961,
     965,   973,   980,   990,   995,  1002,  1002,  1005,  1006,  1010,
    1011,  1016,  1017,  1021,  1022,  1026,  1027,  1031,  1036,  1043,
    1048,  1056,  1063,  1068,  1074,  1080,  1086,  1094,  1095,  1099,
    1116,  1124,  1133,  1142,  1149,  1154,  1162,  1164,  1192,  1193,
    1198,  1203,  1208,  1213,  1218,  1226,  1228,  1236,  1238,  1246,
    1248,  1256,  1258,  1266,  1268,  1273,  1278,  1286,  1323,  1330,
    1337,  1343,  1344,  1348,  1369,  1383,  1384,  1388,  1392,  1395,
    1399,  1401,  1409,  1410,  1414,  1416,  1424,  1430,  1438,  1438,
    1440,  1440,  1447,  1466,  1477,  1486,  1492,  1500,  1501,  1505,
    1510,  1518,  1524,  1532,  1534,  1540,  1544,  1546,  1555,  1559,
    1560,  1564,  1569,  1574,  1583,  1601,  1602,  1606,  1612,  1619,
    1623,  1630,  1631,  1634,  1637,  1643,  1652,  1670,  1689,  1707,
    1708,  1709,  1712,  1712,  1715,  1732,  1735,  1738,  1752,  1763,
    1773,  1778,  1786,  1804,  1812,  1821,  1822,  1826,  1827,  1830,
    1831,  1835,  1836,  1837,  1838,  1839,  1840,  1841,  1848,  1849,
    1853,  1854,  1858,  1869,  1881,  1895,  1899,  1900,  1904,  1906,
    1913,  1913,  1916,  1918,  1925,  1926,  1931,  1936,  1938,  1954,
    1960,  1965,  1970,  1976,  1982,  2017,  2025,  2032,  2033,  2034,
    2038,  2045,  2052,  2060,  2069,  2073,  2077,  2088,  2089,  2093,
    2094,  2098,  2099,  2103,  2110,  2135,  2151,  2153,  2159,  2163,
    2170,  2175,  2180,  2192,  2207,  2212,  2220,  2227,  2229,  2234,
    2239,  2244,  2249,  2254,  2262,  2269,  2274,  2279,  2289,  2290,
    2294,  2303,  2313,  2318,  2329,  2333,  2338,  2347,  2348,  2352,
    2368,  2373,  2381,  2386,  2394,  2400,  2409,  2410,  2414,  2415,
    2416,  2417,  2418,  2419,  2420,  2421,  2422,  2423,  2424,  2425,
    2433,  2450,  2451,  2454,  2455,  2460,  2465,  2470,  2475,  2481,
    2490,  2491,  2514,  2516,  2518,  2523,  2525,  2543,  2551,  2562,
    2568,  2577,  2578,  2584,  2594,  2613,  2626,  2631,  2632,  2636,
    2637,  2641,  2642,  2646,  2647,  2650,  2650,  2653,  2654,  2662,
    2666,  2687,  2696,  2705,  2716,  2718,  2720,  2727,  2729,  2734,
    2739,  2744,  2752,  2770,  2777,  2782,  2789,  2795,  2801,  2803,
    2808,  2809,  2814,  2815,  2819,  2820,  2824,  2825,  2831,  2836,
    2842,  2851,  2862,  2869,  2870,  2874,  2879,  2884,  2889,  2897,
    2899,  2904,  2909,  2917,  2919,  2923,  2929,  2929,  2930,  2930,
    2931,  2931,  2932,  2932,  2933,  2933,  2934,  2934,  2935,  2935
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "K_abs", "K_access",
  "K_after", "K_alias", "K_all", "K_and", "K_architecture", "K_array",
  "K_assert", "K_assume", "K_assume_guarantee", "K_attribute", "K_begin",
  "K_block", "K_body", "K_buffer", "K_bus", "K_case", "K_component",
  "K_configuration", "K_constant", "K_context", "K_cover", "K_default",
  "K_disconnect", "K_downto", "K_else", "K_elsif", "K_end", "K_entity",
  "K_exit", "K_fairness", "K_file", "K_for", "K_force", "K_function",
  "K_generate", "K_generic", "K_group", "K_guarded", "K_if", "K_impure",
  "K_in", "K_inertial", "K_inout", "K_is", "K_label", "K_library",
  "K_linkage", "K_literal", "K_loop", "K_map", "K_mod", "K_nand", "K_new",
  "K_next", "K_nor", "K_not", "K_null", "K_of", "K_on", "K_open", "K_or",
  "K_others", "K_out", "K_package", "K_parameter", "K_port", "K_postponed",
  "K_procedure", "K_process", "K_property", "K_protected", "K_pure",
  "K_range", "K_record", "K_register", "K_reject", "K_release", "K_rem",
  "K_report", "K_restrict", "K_restrict_guarantee", "K_return",
  "K_reverse_range", "K_rol", "K_ror", "K_select", "K_sequence",
  "K_severity", "K_signal", "K_shared", "K_sla", "K_sll", "K_sra", "K_srl",
  "K_strong", "K_subtype", "K_then", "K_to", "K_transport", "K_type",
  "K_unaffected", "K_units", "K_until", "K_use", "K_variable", "K_vmode",
  "K_vprop", "K_vunit", "K_wait", "K_when", "K_while", "K_with", "K_xnor",
  "K_xor", "IDENTIFIER", "INT_LITERAL", "REAL_LITERAL", "STRING_LITERAL",
  "CHARACTER_LITERAL", "BITSTRING_LITERAL", "LEQ", "GEQ", "VASSIGN", "NE",
  "BOX", "EXP", "ARROW", "DLT", "DGT", "CC", "M_EQ", "M_NE", "M_LT",
  "M_LEQ", "M_GT", "M_GEQ", "'+'", "'-'", "'&'", "';'", "'('", "')'",
  "','", "':'", "'|'", "'\\''", "'='", "'<'", "'>'", "'.'", "'*'", "'/'",
  "$accept", "design_file", "$@1", "adding_operator", "architecture_body",
  "$@2", "architecture_body_start", "architecture_statement_part",
  "argument_list", "argument_list_opt", "assertion_statement",
  "association_element", "association_list", "binding_indication",
  "binding_indication_semicolon_opt", "block_configuration",
  "block_configuration_opt", "block_declarative_item",
  "block_declarative_items", "block_declarative_items_opt",
  "case_statement", "case_statement_alternative_list",
  "case_statement_alternative", "choice", "choices",
  "component_configuration", "component_declaration", "instantiated_unit",
  "component_instantiation_statement", "component_specification",
  "composite_type_definition", "concurrent_assertion_statement",
  "concurrent_conditional_signal_assignment",
  "concurrent_simple_signal_assignment", "else_when_waveforms",
  "else_when_waveforms_opt", "else_when_waveform",
  "concurrent_signal_assignment_statement", "concurrent_statement",
  "configuration_declaration", "configuration_declarative_item",
  "configuration_declarative_items", "configuration_declarative_part",
  "configuration_item", "configuration_items", "configuration_items_opt",
  "constant_declaration", "context_clause", "context_item",
  "context_items", "design_unit", "design_units", "direction",
  "element_association", "element_association_list", "element_declaration",
  "element_declaration_list", "entity_aspect", "entity_aspect_opt",
  "entity_declaration", "enumeration_literal", "enumeration_literal_list",
  "expression_list", "expression", "expression_logical",
  "expression_logical_and", "expression_logical_or",
  "expression_logical_xnor", "expression_logical_xor", "factor",
  "file_declaration", "file_open_information", "file_open_information_opt",
  "for_generate_statement", "function_specification", "generate_statement",
  "generate_statement_body", "generic_clause_opt", "generic_clause",
  "generic_map_aspect_opt", "generic_map_aspect", "identifier_list",
  "identifier_opt", "identifier_colon_opt", "if_generate_statement",
  "if_statement", "if_statement_elsif_list_opt", "if_statement_elsif_list",
  "if_statement_elsif", "if_statement_else", "index_constraint",
  "index_subtype_definition", "index_subtype_definition_list",
  "instantiation_list", "interface_element",
  "interface_element_expression", "interface_list", "library_clause",
  "library_unit", "logical_name", "logical_name_list", "loop_statement",
  "mode", "mode_opt", "name", "indexed_name", "name_list",
  "package_declaration", "package_declaration_start",
  "package_body_declarative_item", "package_body_declarative_items",
  "package_body_declarative_part_opt", "package_declarative_item",
  "package_declarative_items", "package_declarative_part_opt",
  "package_body", "package_body_start", "parameter_list",
  "parameter_list_opt", "port_clause", "port_clause_opt",
  "port_map_aspect", "port_map_aspect_opt", "prefix", "primary",
  "primary_unit", "procedure_call", "procedure_call_statement",
  "procedure_specification", "process_declarative_item",
  "process_declarative_part", "process_declarative_part_opt",
  "process_start", "process_statement", "process_sensitivity_list_opt",
  "process_sensitivity_list", "range", "range_list",
  "record_type_definition", "relation", "report_statement",
  "return_statement", "secondary_unit", "selected_name", "selected_names",
  "selected_name_lib", "selected_names_lib", "selected_signal_assignment",
  "selected_waveform", "selected_waveform_list", "list_of_statements",
  "sequence_of_statements", "sequential_statement", "severity",
  "severity_opt", "shift_expression", "signal_declaration_assign_opt",
  "simple_expression", "simple_expression_2", "simple_expression_terms",
  "signal_assignment", "signal_assignment_statement",
  "subprogram_body_start", "subprogram_body", "subprogram_declaration",
  "subprogram_declarative_item", "subprogram_declarative_item_list",
  "subprogram_declarative_part", "subprogram_kind", "subprogram_kind_opt",
  "subprogram_specification", "subprogram_statement_part",
  "subtype_declaration", "subtype_indication", "suffix", "term",
  "type_declaration", "type_definition", "use_clause", "use_clause_lib",
  "use_clauses_lib", "use_clauses_opt", "variable_assignment_statement",
  "variable_assignment", "variable_declaration",
  "variable_declaration_assign_opt", "wait_statement", "waveform",
  "waveform_elements", "waveform_element", "K_architecture_opt",
  "K_configuration_opt", "K_entity_opt", "K_is_opt", "K_package_opt",
  "K_postponed_opt", "K_shared_opt", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-629)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-450)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -629,    29,   476,  -629,  -629,    17,    36,   381,  -629,   262,
    -629,   374,  -629,  -629,   -95,  -629,  -629,   388,   -80,   -71,
    -629,   404,    90,    67,    80,     6,  -629,   184,  -629,  -629,
    -629,  -629,   209,  -629,   263,  -629,  -629,  -629,  -629,  -629,
    -629,   225,  -629,    51,  -629,   285,  -629,   409,   254,   417,
     383,   360,  -629,   364,  1227,   271,  -629,  -629,   333,  -629,
     474,   386,   502,   514,  -629,  -629,    14,   452,    84,   468,
     472,   490,    85,    86,  -629,  -629,  -629,  -629,  1239,   595,
    -629,  -629,   484,  -629,  -629,  -629,   613,  -629,    12,   627,
     288,  -629,   612,  -629,    66,  -629,   543,   616,  -629,   543,
     525,   603,  -629,   629,   621,  -629,   643,   549,  -629,   104,
     550,   550,   654,   560,   -18,   178,   562,  -629,   564,   557,
     -94,   441,   602,  -629,   621,  -629,   621,  -629,   621,    87,
    -629,  -629,  -629,   288,   716,  -629,   639,  -629,  -629,  -629,
    -629,   606,   644,   622,    95,   624,   626,  -629,   738,   941,
    -629,   543,  -629,   387,  -629,   660,    96,   661,   687,  -629,
    -629,   668,  -629,    11,  -629,  -629,   106,   689,   689,   106,
     689,  -629,    97,   543,   543,   543,   646,   327,  -629,  1077,
      98,  -629,  -629,   644,   752,  -629,  -629,   645,   376,  -629,
     371,  -629,    99,   648,   502,   649,   100,  -629,  1180,   785,
    -629,  -629,  -629,  -629,    79,  -629,  -629,  -629,   657,   774,
     603,  -629,   670,   117,   105,   696,   674,   683,   691,   661,
     700,  -629,  -629,   684,  -629,  -629,  -629,  -629,   652,    27,
      27,   692,   719,  -629,  -629,  -629,  -629,    19,    19,   501,
     400,  -629,  -629,   171,   218,   715,  -629,   321,   701,   455,
     296,  -629,   423,   471,  -629,   485,   -94,   711,   713,   714,
    -629,   740,    38,   689,   689,   702,   724,   689,   530,   197,
     377,  -629,  -629,   159,  -629,  -629,   520,  -629,  -629,  -629,
    -629,   917,  -629,  -629,  -629,  -629,   829,  -629,  -629,  -629,
     728,   488,  -629,   754,   850,   741,   469,   661,  -629,   736,
    -629,   543,  -629,   756,   493,  -629,   118,  -629,   865,   870,
    -629,   689,   729,  -629,   742,  -629,  -629,  -629,  -629,   769,
     840,  -629,     4,   508,  -629,  -629,   535,  -629,   293,  -629,
    -629,   775,  -629,  -629,  -629,  -629,  -629,    82,  -629,   538,
    -629,   540,   461,  -629,   689,    19,    19,    19,    19,   334,
      27,   689,   689,   689,   689,   689,   689,   689,   689,   689,
     689,   689,   689,  -629,   689,   689,   689,   689,   689,   689,
    -629,   689,  -629,  -629,  -629,    19,   423,  -629,  -629,  -629,
    -629,  -629,    -9,   172,   689,  -629,   236,   855,    34,   803,
    -629,   813,   276,  -629,   762,   689,   689,   689,  -629,  -629,
     853,   206,   763,   789,  1130,   689,    56,   866,   101,  -629,
     172,  -629,   668,   801,   474,  -629,  -629,  -629,  -629,  -629,
     668,  -629,   768,   771,  -629,   668,   365,   689,   454,   628,
    -629,  -629,  -629,  -629,  -629,  -629,  -629,  -629,  -629,   848,
    -629,   796,   777,  -629,  -629,   543,   902,    26,  -110,  -629,
     551,    26,   356,   780,   119,  -629,   567,   668,   847,  -629,
     668,  -629,   700,   808,   264,  -629,   578,   689,   501,  -629,
     501,  -629,  -629,  -629,  -629,  -629,  -629,  -629,   784,  -629,
     922,  -629,   744,  -629,  -629,   867,  -629,   814,  -629,   815,
    -629,  -629,  -629,  -629,  -629,  -629,  -629,  -629,  -629,  -629,
    -629,  -629,  -629,  -629,  -629,    19,   812,   816,  -629,   792,
    -629,  -629,  -629,   543,   794,   820,  -629,  -629,   797,   826,
     900,   990,  1024,   800,  -629,  -629,   805,   806,   807,   269,
     582,   587,   191,   522,  -629,  -629,  -629,  -629,   907,   914,
     901,  -629,  -629,   950,   186,   810,  -629,   357,   817,   543,
     831,  -629,   801,   923,   543,   836,  -629,  -629,   838,    56,
    -629,   876,   470,   -92,   958,  -629,  -629,   895,   339,    65,
     643,   825,   543,   689,  -629,  -629,   689,  -629,  -629,   842,
     918,   862,  -629,  -629,   839,  -629,   597,  -629,   863,  -629,
    -629,  -629,    26,  -629,   689,  -629,  -629,   689,   689,   689,
     689,  -629,  -629,   936,  -629,   849,  -629,  -629,  -629,   501,
     140,  -629,   852,   962,    39,   962,  -629,  -629,  -629,  -629,
     858,   860,   861,   689,   944,  1130,   689,   689,  -629,   662,
    -629,  -629,   868,   689,   871,  -629,   201,  -629,  -629,  -629,
     923,   968,   872,   689,  -629,   689,   873,   874,    97,   887,
     890,   689,   311,     8,  -629,  -629,   889,  -629,  -629,   543,
    -629,   353,   275,   280,  -629,   869,   875,   878,   288,  -629,
     883,  -629,  -629,  -629,   668,   951,  -629,  -629,   652,  -629,
    -629,   898,  -629,   590,  -629,  -629,  -629,  -629,   915,  -629,
     279,  1018,  -629,  -629,   689,  1010,   962,  -629,   999,  1010,
    -629,  -629,   993,   543,  1016,  -629,  1019,  -629,  -629,  -629,
    -629,  -629,  -629,    10,    25,   905,   908,  -629,  1021,  -629,
    -629,  -629,  -629,  -629,   933,  -629,  1017,  1022,   919,  1011,
     996,  -629,   492,   927,   689,  -629,   689,  -629,  -629,    97,
    -629,  -629,  -629,   288,  1057,  -629,  -629,  -629,  -629,  -629,
    1063,   935,   979,  1144,  1050,  -629,   940,  1055,  1130,   943,
    1036,    56,  1059,   390,   947,   752,    97,   949,    56,   689,
     118,  -629,   953,  1041,  -629,   952,   179,  -629,  1072,  1072,
     869,  -629,  1168,  -629,  -629,  1039,   101,  -629,  1061,  -629,
    1068,  1071,  -629,   543,   970,  1076,    97,    97,  -629,  -629,
     996,  -629,  -629,  1084,   869,  -629,  -629,   483,  1003,  1079,
     637,  1088,   102,   976,  -629,    56,   -10,  -629,  1072,   982,
      46,  1092,   101,  -629,   983,   984,  1080,   985,  -629,  -629,
     869,   869,  1094,  1096,  -629,    56,   675,   118,  1097,   989,
     608,   103,  1026,  -629,  -629,  -629,   848,   848,  -629,  -629,
     543,  -629,  -629,   998,  -629,  -629,  -629,  1113,   543,  -629,
    -629,  1001,   611,   689,  1075,  1078,  1009,  -629,  1117,  1013,
    -629,  -629,  -629,   543,   543,  -629,   543,  -629,  1015,  1023,
    1027,  -629,  -629,  -629
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     0,     1,   112,     0,     0,     0,   110,   105,
     114,     0,   107,   108,     0,   213,   215,     0,     0,     0,
     328,     0,     0,     0,     0,     0,   318,     0,   278,   277,
     111,   279,     0,   319,     0,   211,   212,   109,   113,   210,
     209,     0,   411,     0,   410,     0,     9,     0,     0,     0,
       0,     0,   234,     0,     0,     0,   214,   324,     0,   327,
     439,     0,   441,   169,   254,     7,     0,     0,     0,     0,
       0,     0,     0,     0,   241,   242,   387,   249,     0,     0,
     388,   243,     0,   244,   245,   246,     0,   238,   239,     0,
     382,   236,     0,   235,     0,   438,   179,     0,   440,   179,
       0,   261,   168,     0,   445,   247,   443,     0,   177,     0,
       0,   257,     0,     0,     0,     0,   224,   266,   226,     0,
     323,     0,     0,   248,   445,   376,   445,   237,   445,     0,
     448,   378,   380,   381,     0,   377,     0,   373,   325,   326,
     178,     0,    93,     0,     0,     0,     0,   260,     0,     0,
     444,   179,   442,     0,   104,     0,     0,     0,     0,   256,
     286,     0,   405,     0,   403,   409,     0,     0,     0,     0,
       0,   408,     0,   179,   179,   179,     0,     0,   379,     0,
       0,    88,    91,    92,     0,    89,   130,     0,     0,   208,
       0,   170,     0,     0,   441,     0,     0,    40,     0,     0,
      30,    31,    33,    32,     0,    34,    35,    36,     0,     0,
     261,   176,     0,   391,     0,     0,     0,     0,     0,     0,
       0,   407,    63,     0,   396,   394,   395,   321,     0,     0,
       0,   224,   270,   271,   272,   269,   273,     0,     0,     0,
       0,   135,   136,   397,   267,   153,   137,   138,   225,   307,
     353,   364,   365,     0,   320,     0,   322,     0,     0,     0,
     158,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   346,   341,     0,   338,   343,   266,   285,   342,   345,
     344,     0,   389,   335,   371,   339,     0,   340,   416,   347,
       0,     0,    90,     0,     0,     0,   223,     0,   255,     0,
     258,   179,    38,     0,     0,    39,     0,   233,     0,     0,
     103,     0,     0,   392,     0,   101,   164,   390,   404,     0,
       0,   123,     0,     0,   131,   133,     0,   402,   267,   155,
     156,     0,   274,   363,   362,    48,    51,     0,   120,     0,
     118,    49,   353,   228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   116,     0,     0,     0,     0,     0,     0,
     115,     0,     4,     5,     6,     0,   366,   229,   227,   232,
     253,   252,   162,   386,     0,   349,   352,     0,     0,     0,
     348,   352,     0,   316,     0,     0,     0,     0,   428,   280,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   334,
     386,   422,     0,   415,   439,   171,   219,   221,   220,   222,
       0,   207,     0,     0,    37,     0,     0,     0,   224,     0,
      64,    82,    84,    76,    74,    83,    11,   166,    85,   447,
     165,   266,   298,    86,    78,   179,     0,     0,     0,   304,
       0,     0,     0,     0,   224,   200,     0,     0,     0,   122,
       0,   406,     0,     0,   224,    22,     0,     0,     0,   276,
       0,   134,   400,   401,   398,   399,   302,   303,    15,   154,
     139,   145,   353,   142,   143,   140,   147,   144,   149,   141,
     151,   311,   312,   313,   308,   309,   310,   359,   358,   357,
     355,   356,   354,   301,   367,     0,     0,     0,   161,     0,
     383,   384,   385,   179,     0,     0,    16,   351,     0,     0,
       0,     0,     0,     0,   317,   315,     0,     0,     0,     0,
       0,     0,     0,   224,   284,   372,   417,   282,     0,     0,
       0,   435,   430,   433,     0,   429,   432,     0,     0,   179,
     424,   413,   414,    99,   179,   206,   259,   129,   361,     0,
      12,     0,     0,     0,   437,    10,   446,     0,     0,     0,
     443,     0,   179,     0,   197,   196,     0,   102,   100,     0,
       0,     0,    61,   306,     0,   132,     0,   275,     0,   117,
      50,    49,    47,   119,     0,    14,   268,     0,     0,     0,
       0,   368,   160,     0,   157,     0,   420,   350,    17,     0,
       0,    45,     0,   188,     0,   188,   314,   425,   426,   427,
       0,     0,   228,     0,     0,     0,     0,     0,   369,     0,
     419,   418,     0,     0,     0,   412,     0,    94,    95,    97,
      98,     0,     0,     0,   204,     0,     0,     0,     0,     0,
       0,     0,    56,     0,    77,    75,   266,    79,   436,   179,
     293,     0,     0,     0,   299,   231,   300,     0,   292,    55,
       0,   393,   305,   198,     0,     0,   199,   121,    20,    19,
      18,     0,    21,     0,   146,   148,   150,   152,     0,   375,
       0,     0,    44,   186,     0,   195,   187,   190,     0,   195,
     283,   281,     0,   179,     0,   434,     0,   431,   374,   423,
     421,   203,   202,   177,     0,   201,     0,    96,     0,    87,
     205,   360,    29,    81,   266,    57,     0,     0,     0,     0,
     265,   172,     0,     0,     0,    80,     0,    67,   297,     0,
     296,   288,   290,   291,     0,   287,    54,    62,    13,   159,
       0,     0,     0,     0,     0,   189,     0,     0,     0,     0,
       0,     0,     0,   128,     0,    28,     0,     0,     0,     0,
       0,    59,     0,     0,   264,     0,     0,     8,     0,    71,
     230,   289,     0,    46,    43,     0,   194,   193,     0,   185,
       0,     0,   218,   179,     0,     0,     0,     0,   126,   127,
     265,    24,    27,     0,    60,    26,   333,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,    69,    70,     0,
       0,     0,   192,   191,     0,     0,     0,     0,   370,    53,
     125,   124,   173,     0,   329,     0,     0,     0,     0,     0,
       0,     0,    73,    66,    68,    65,   447,   447,   184,   183,
     179,   216,    23,     0,   332,   331,   330,     0,   179,   175,
     174,     0,     0,     0,     0,     0,     0,    52,     0,     0,
     263,   262,    72,   179,   179,   217,   179,   182,     0,     0,
       0,   295,   294,   163
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -629,  -629,  -629,   786,  -629,  -629,  -629,   859,   690,  -629,
    -298,   584,  -395,  -629,  -629,  -183,  -629,   972,  -629,  -629,
    -629,  -629,   574,   706,   576,  -629,  -118,  -629,  -629,  -629,
    -629,  -629,   631,   632,   407,  -629,  -215,  -629,  -423,  -629,
    1006,  -629,  -629,   558,  -629,  -629,    71,  -629,  1191,  -629,
    1195,  -629,   755,   737,  -629,   886,  -629,  -629,  -629,  -629,
     747,  -629,  -153,  -157,   809,  -629,  -629,  -629,  -629,   228,
    -628,  -629,  -629,  -629,  -629,  -629,   373,  1062,  -629,   380,
    -629,   -66,   -99,  -292,  -629,  -629,   604,  -629,   521,   524,
    1002,   641,  -629,  -629,   928,  -629,  -629,  -629,  -629,  1183,
    -629,  -629,  -629,  -629,   -70,  -629,  -629,  -629,  -629,  1138,
    -629,  -629,  1153,  -629,  -629,  -629,  -629,   322,  -629,  -629,
    1025,  -629,   432,  -629,  -187,  -629,   832,  -629,  -629,   491,
    -629,  -629,  -629,  -629,  -629,  -629,  -207,  -629,  -629,  -261,
     851,  -629,  -629,   -48,  -629,  1193,  -629,   677,   401,  -629,
    -629,  -377,   960,  -629,   856,   518,  -629,    -4,   523,  -629,
     841,  -629,  -629,    75,    81,  1111,  -629,  -629,  -629,   843,
     -17,  -629,   116,  -154,  1086,  -351,   168,  -629,   -21,  -145,
    -629,  -629,  -629,   845,  -621,  -629,  -629,  -390,  -629,   635,
    -629,   854,  1067,   686,   414,   -83,  -629
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,   375,    26,   103,    27,   810,   402,   596,
     271,   465,   466,   764,   765,   637,   803,   197,   198,   199,
     272,   610,   611,   336,   337,   638,    74,   653,   431,   714,
     221,   432,   433,   434,   816,   819,   817,   435,   436,    28,
     182,   183,   184,   639,   640,   641,    75,     7,     8,     9,
      10,    11,   371,   338,   339,   321,   322,   799,   800,    29,
     325,   326,   240,   543,   242,   480,   485,   487,   489,   243,
     131,   508,   509,   437,    76,   438,   811,   101,   102,   730,
     731,   188,   141,   273,   440,   274,   695,   696,   697,   754,
     313,   455,   456,   716,   189,   644,   190,    12,    30,    16,
      17,   275,   419,   420,   244,   118,   666,    31,    32,    87,
      88,    89,    77,    78,    79,    33,    34,   145,   160,   147,
     148,   774,   775,   119,   245,    35,   277,   278,    80,   742,
     743,   744,   442,   443,   570,   667,   246,   450,   222,   247,
     279,   280,    36,   248,   121,    20,    21,   444,   806,   807,
     281,   282,   283,   517,   518,   249,   646,   250,   251,   376,
     284,   285,    90,    91,    81,   132,   133,   134,   512,   513,
      82,   286,    83,   214,   227,   252,    84,   223,    85,    13,
     552,   553,   287,   288,   135,   634,   289,   662,   545,   546,
     659,    96,    99,   153,   151,   567,   136
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     143,   294,   109,   117,   207,   530,   565,   216,   430,   728,
     241,   241,   217,   241,   439,   253,   544,   255,    14,   815,
     228,   218,   229,    51,   504,   120,   762,   539,   228,     3,
     163,   200,   341,   559,    93,   458,   574,    18,    92,   506,
     741,  -415,   329,   330,   166,   104,  -415,   745,   729,    39,
      69,   170,   208,   207,   363,   507,   -25,   228,    57,   229,
    -225,   -25,   166,   177,    42,   520,   663,    93,    47,   383,
     698,    92,   664,   138,   257,   258,   259,   846,  -173,   230,
     200,    49,   340,    43,    70,   107,   113,   115,   176,   219,
     481,   483,   484,   486,   488,   490,   187,   212,   228,   290,
     299,   303,   117,   839,   861,   449,   386,   387,   389,   276,
     391,   394,   449,   224,   291,   741,   230,   541,     6,   426,
      73,   185,   745,   108,   256,    52,   164,   137,   370,   263,
     304,   430,   204,   763,   843,   521,    15,   439,   231,   232,
     233,   234,   235,   236,   613,   615,   231,   232,   233,   234,
     235,   236,  -173,   323,   601,    19,   220,   453,   105,   328,
     328,   542,   185,   479,   239,   384,   384,   328,   328,   647,
      58,   691,   239,   384,   241,   231,   232,   233,   234,   235,
     236,   204,   385,   385,   116,   139,    48,   471,   166,  -181,
     385,  -181,   166,   166,   311,   403,   579,   237,   238,    50,
     166,   239,   423,   108,   114,   116,   108,   532,   711,    46,
     510,   276,   404,   467,   108,   213,   116,   108,   108,   108,
     201,   681,   681,   125,   202,   225,   345,   514,   384,   226,
     203,   468,   314,   395,   427,   342,   441,   428,   526,   527,
     528,   328,  -180,   241,   511,   385,    53,   531,   704,   315,
     548,   155,   156,   346,   609,   166,   323,    54,   550,  -180,
     396,   591,   312,   341,   331,   205,   555,   712,   551,   201,
     561,   558,    86,   202,   405,   328,   328,   328,   328,   203,
     328,   328,   328,   328,   328,   328,   328,   328,   328,   328,
     328,   328,   328,   734,   328,   328,   328,   328,   328,   328,
     627,   328,  -240,   582,   397,   328,   584,   447,   451,    69,
     589,    55,     5,   340,   205,   451,    61,   206,   384,   267,
     713,  -180,   165,   129,   363,   533,   347,   348,   515,   351,
     628,   276,   166,   166,   276,   328,   684,   685,   686,   687,
     661,   398,   229,    70,    15,   166,   571,   482,   482,   482,
     482,   482,   482,   482,   482,   482,   482,   482,   482,   441,
     497,   498,   499,   500,   501,   502,   206,   503,   349,   672,
       6,   794,  -266,   783,    -3,     4,   787,   352,   808,    73,
     353,   791,   130,  -106,   364,   365,   354,   565,   209,   736,
      22,   366,   367,   368,   369,   586,  -106,  -449,   370,   230,
     541,   482,   591,    23,    19,   821,  -106,   635,   823,   331,
     750,   476,   796,    24,   605,   620,   702,   840,  -169,   737,
     524,   477,   797,   166,     5,   842,   738,   100,   468,   680,
     166,    63,   158,   159,   166,   328,  -224,   241,   355,   356,
      60,   683,  -106,   463,   542,   808,   862,  -266,    62,    25,
     632,   276,   276,   478,   798,   642,   167,  -169,   231,   232,
     233,   234,   235,   236,   592,  -224,   342,   734,   193,   705,
     706,   228,   430,   670,   155,   261,   709,     4,   439,    64,
     237,   238,     6,    65,   239,  -106,   720,    94,   721,   363,
     559,   649,   656,   776,   727,   229,    95,   735,  -106,   665,
     577,   630,   228,   328,   229,    97,   650,   166,  -106,   560,
     166,   166,   430,   651,   416,   297,   417,   298,   439,   166,
     747,   399,   400,   155,   296,   401,     5,   328,   328,   328,
     328,   392,    40,   229,    98,    41,   418,   752,   173,   430,
     174,  -180,   175,  -180,  -106,   439,   343,   344,    44,   364,
     365,    45,   230,   541,   100,   276,   366,   367,   368,   369,
     733,   230,   809,   370,   372,   373,   374,   335,   551,   671,
     715,   106,   451,   472,   473,   474,   475,   778,   724,   779,
     357,   358,   802,   359,     6,   171,   427,   110,   172,   652,
     230,   111,   -47,   482,   482,   482,   482,   542,   678,   167,
     229,   844,   562,   844,   759,   592,   360,   361,   362,   112,
     -47,   231,   232,   233,   234,   235,   236,   377,   344,   451,
     231,   232,   233,   234,   235,   236,   124,   834,   125,   563,
     835,   378,   344,   237,   238,   155,   412,   239,   563,   263,
     155,   425,   237,   238,   126,   406,   239,   407,   263,   231,
     232,   233,   234,   235,   236,   155,   460,   230,   128,   564,
     137,   679,   140,   228,   142,   229,   399,   400,  -167,   780,
     144,   237,   238,   146,   393,   239,   228,   149,   229,   856,
     276,   461,   462,   276,   469,   470,  -137,  -137,   276,   150,
     228,   152,   229,   154,   827,   157,   804,   575,   576,  -181,
     441,  -181,   161,   388,   162,   229,   872,   167,  -181,   168,
    -181,   169,   276,   580,   581,   276,   231,   232,   233,   234,
     235,   236,   230,   541,   587,   588,   830,   831,   621,   588,
     448,   179,   229,   622,   344,   230,   748,   344,   237,   238,
     441,   855,   239,   452,   427,   229,   105,   428,   180,   230,
     181,   866,    73,   427,   860,   588,   428,   871,   588,   869,
     333,   334,   230,   864,   865,   451,   186,   441,   191,   194,
     448,   192,   229,   215,   878,   879,   228,   880,   229,   211,
     108,   231,   232,   233,   234,   235,   236,   213,   293,   230,
     260,   295,   300,   302,   231,   232,   233,   234,   235,   236,
     306,   307,   230,   237,   238,   308,   166,   239,   231,   232,
     233,   234,   235,   236,   310,   316,   237,   238,   317,   324,
     239,   231,   232,   233,   234,   235,   236,   318,   327,   230,
     237,   238,   364,   365,   239,   230,   319,   331,   332,   366,
     367,   368,   369,   237,   238,   350,   170,   239,   231,   232,
     233,   234,   235,   236,   529,   379,   229,   380,   381,   382,
     410,   231,   232,   233,   234,   235,   236,   547,   390,   229,
     237,   238,   411,   413,   239,   491,   492,   493,   494,   495,
     496,   414,   422,   237,   238,   415,   445,   239,   454,   232,
     233,   234,   235,   236,   464,   232,   233,   234,   235,   236,
     424,   446,   457,   519,   522,   515,   525,   537,   538,     6,
     237,   238,   556,   230,   239,   557,   237,   238,   408,   566,
     239,   568,   569,   572,   578,   583,   230,   478,   263,   594,
     597,   599,   598,   600,   602,   603,   604,   264,   606,   607,
     609,   608,   195,   612,   616,   624,  -336,  -336,  -336,   617,
     618,   619,   623,  -181,   625,   626,   -42,   629,   633,   636,
     265,   631,    67,   643,    68,   645,   648,   658,   660,   669,
    -181,   673,   464,   232,   233,   234,   235,   236,   266,    69,
     674,   675,   681,   677,   688,   231,   232,   233,   234,   235,
     236,   408,   694,   689,   237,   238,   693,   703,   239,   718,
     267,   263,   700,   268,   701,   -13,   725,   237,   238,   726,
     264,   239,   708,    70,   732,   710,   719,   722,   723,  -337,
    -337,  -337,   739,  -266,   740,   614,  -181,   746,   579,   586,
     269,  -336,  -181,   265,   196,   263,   270,   749,   751,   753,
     822,    71,   756,  -181,   264,    72,   758,   760,   761,     6,
     263,   266,   155,  -337,  -337,  -337,   766,   767,   768,   264,
    -181,   770,   769,   771,   408,   772,   773,   265,  -337,  -337,
    -337,   777,   782,   267,   263,  -181,   268,  -181,   262,   784,
     785,   788,   265,   264,   789,   266,   790,   792,   263,   793,
     795,   801,  -181,   805,  -337,   813,   814,   264,   812,  -181,
     266,   815,   826,   269,   824,  -181,   265,   267,  -337,   270,
     268,   825,   829,  -181,   828,   833,  -181,   836,   837,   838,
     265,   841,   267,   847,   266,   268,   845,   848,   849,   851,
    -181,   408,   853,   850,   729,   859,   858,   269,   266,  -181,
     863,   263,   867,   270,   868,   786,   267,   870,   873,   268,
     264,   874,   269,   875,  -181,   263,   876,   877,   270,   881,
     267,  -337,   505,   268,   264,   429,  -181,   882,   595,   820,
     305,   883,   682,   265,   590,  -337,   269,  -337,  -181,   263,
    -181,   195,   270,  -181,   692,   690,   818,   265,   264,   292,
     269,   266,  -181,   654,   655,   -41,   270,  -181,   717,  -337,
      37,    67,   573,    68,  -181,   266,    38,   593,   459,   585,
     857,   265,   852,   267,   540,   210,   268,   755,    69,   699,
     320,  -181,   676,   757,    56,   421,   127,   267,    66,   266,
     268,   123,   832,   534,   781,   309,   854,   516,    59,   657,
     122,   409,   535,   269,   178,  -181,   536,   523,    67,   270,
      68,   267,    70,   549,   268,   254,   668,   269,  -251,  -181,
      67,   301,    68,   270,   707,    69,     0,     0,   554,     0,
    -250,     0,     0,   196,     0,     0,     0,    69,     0,     0,
      71,   269,     0,  -181,    72,     0,     0,   270,     6,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    70,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    70,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    71,     0,     0,
       0,    72,     0,     0,     0,    73,     0,     0,     0,    71,
       0,     0,     0,    72,     0,     0,     0,    73
};

static const yytype_int16 yycheck[] =
{
      99,   184,    68,    73,   149,   400,   429,   161,   306,     1,
     167,   168,     1,   170,   306,   168,   406,   170,     1,    29,
       1,    10,     3,    17,   375,    73,     1,   404,     1,     0,
      48,   149,   239,   125,    55,    31,   146,     1,    55,    48,
     668,    31,   229,   230,   154,    31,    36,   668,    40,   144,
      38,   145,   151,   198,    28,    64,    31,     1,     7,     3,
     154,    36,   154,   129,   144,    31,     1,    88,     1,    31,
      31,    88,     7,     7,   173,   174,   175,    31,    70,    60,
     198,     1,   239,   154,    72,     1,     1,     1,     1,    78,
     351,   352,   353,   354,   355,   356,     1,     1,     1,     1,
       1,     1,   172,     1,     1,   312,   263,   264,   265,   179,
     267,   268,   319,     7,   180,   743,    60,    61,   108,     1,
     108,   142,   743,   119,   172,   119,   144,    48,   102,    11,
     196,   429,   149,   108,   144,   101,   119,   429,   119,   120,
     121,   122,   123,   124,   521,   522,   119,   120,   121,   122,
     123,   124,   144,   219,   505,   119,   145,   314,   144,   229,
     230,   105,   183,   350,   145,   127,   127,   237,   238,   559,
     119,    31,   145,   127,   331,   119,   120,   121,   122,   123,
     124,   198,   144,   144,   119,   119,   119,   344,   154,    71,
     144,    73,   154,   154,    77,    36,    77,   141,   142,   119,
     154,   145,   301,   119,   119,   119,   119,     1,     7,   119,
      38,   281,    53,   131,   119,   119,   119,   119,   119,   119,
     149,   119,   119,   144,   149,   119,    55,   384,   127,   123,
     149,   149,   127,    36,   116,   239,   306,   119,   395,   396,
     397,   311,    36,   400,    72,   144,    62,   400,   625,   144,
     407,   147,   148,    82,   114,   154,   322,    48,   412,    53,
      63,   468,   145,   470,   145,   149,   420,    66,   413,   198,
     427,   425,     1,   198,   115,   345,   346,   347,   348,   198,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   114,   364,   365,   366,   367,   368,   369,
     114,   371,    31,   457,   107,   375,   460,   311,   312,    38,
     467,    48,    50,   470,   198,   319,    62,   149,   127,    83,
     119,   115,   144,    35,    28,   119,   155,   156,    92,     8,
     144,   401,   154,   154,   404,   405,   597,   598,   599,   600,
       1,   144,     3,    72,   119,   154,   445,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   429,
     364,   365,   366,   367,   368,   369,   198,   371,   150,   576,
     108,   761,   154,   750,     0,     1,   753,    56,   768,   108,
      59,   758,    94,     9,    88,    89,    65,   810,     1,   114,
       9,    95,    96,    97,    98,   131,    22,   109,   102,    60,
      61,   405,   609,    22,   119,   782,    32,   552,   785,   145,
     131,    77,    22,    32,   513,   146,   623,   812,    31,   144,
     144,    87,    32,   154,    50,   815,   146,    40,   149,   586,
     154,    48,   110,   111,   154,   505,   125,   594,   117,   118,
      31,   594,    68,   150,   105,   835,   841,   154,    31,    68,
     549,   521,   522,   119,    64,   554,   145,    70,   119,   120,
     121,   122,   123,   124,   468,   154,   470,   114,   146,   626,
     627,     1,   770,   572,   147,   148,   633,     1,   770,   119,
     141,   142,   108,   119,   145,     9,   643,   154,   645,    28,
     125,    21,   562,     1,   651,     3,    22,   144,    22,   569,
     144,   144,     1,   573,     3,   119,    36,   154,    32,   144,
     154,   154,   810,    43,    45,   144,    47,   146,   810,   154,
     674,   144,   145,   147,   148,   148,    50,   597,   598,   599,
     600,     1,   144,     3,    32,   147,    67,   694,   124,   837,
     126,    71,   128,    73,    68,   837,   146,   147,   144,    88,
      89,   147,    60,    61,    40,   625,    95,    96,    97,    98,
     659,    60,   769,   102,   141,   142,   143,    66,   713,   573,
     636,   119,   576,   345,   346,   347,   348,   734,   648,   736,
     125,   126,   765,   128,   108,   144,   116,   119,   147,   119,
      60,   119,   131,   597,   598,   599,   600,   105,     1,   145,
       3,   816,   148,   818,   703,   609,   151,   152,   153,   119,
     149,   119,   120,   121,   122,   123,   124,   146,   147,   623,
     119,   120,   121,   122,   123,   124,    31,   144,   144,     1,
     147,   146,   147,   141,   142,   147,   148,   145,     1,    11,
     147,   148,   141,   142,    31,   125,   145,   127,    11,   119,
     120,   121,   122,   123,   124,   147,   148,    60,    31,    31,
      48,    64,   119,     1,    48,     3,   144,   145,    31,   739,
     145,   141,   142,    70,   144,   145,     1,    48,     3,   836,
     750,   146,   147,   753,   146,   147,   146,   147,   758,    68,
       1,    48,     3,   144,   793,   145,   766,   146,   147,    71,
     770,    73,    48,     1,   144,     3,   863,   145,    71,   145,
      73,   154,   782,   146,   147,   785,   119,   120,   121,   122,
     123,   124,    60,    61,   146,   147,   796,   797,   146,   147,
       1,    15,     3,   146,   147,    60,   146,   147,   141,   142,
     810,    66,   145,     1,   116,     3,   144,   119,   109,    60,
     144,   850,   108,   116,   146,   147,   119,   146,   147,   858,
     237,   238,    60,   846,   847,   769,   144,   837,   144,    31,
       1,   145,     3,    86,   873,   874,     1,   876,     3,   119,
     119,   119,   120,   121,   122,   123,   124,   119,    36,    60,
     144,   146,   144,   144,   119,   120,   121,   122,   123,   124,
      15,   144,    60,   141,   142,    31,   154,   145,   119,   120,
     121,   122,   123,   124,   144,   119,   141,   142,   144,   119,
     145,   119,   120,   121,   122,   123,   124,   144,   144,    60,
     141,   142,    88,    89,   145,    60,   145,   145,   119,    95,
      96,    97,    98,   141,   142,   130,   145,   145,   119,   120,
     121,   122,   123,   124,     1,   144,     3,   144,   144,   119,
      31,   119,   120,   121,   122,   123,   124,     1,   144,     3,
     141,   142,   144,   119,   145,   357,   358,   359,   360,   361,
     362,    31,   146,   141,   142,   144,    21,   145,   119,   120,
     121,   122,   123,   124,   119,   120,   121,   122,   123,   124,
     144,    31,    62,    48,   101,    92,   144,   144,   119,   108,
     141,   142,   144,    60,   145,   144,   141,   142,     1,    71,
     145,   125,   145,    21,   144,    78,    60,   119,    11,   145,
       8,   117,    65,   118,   122,   119,   144,    20,   144,   119,
     114,   144,     1,    43,   144,    31,    29,    30,    31,   144,
     144,   144,    45,    36,    53,     5,    15,   147,   127,    36,
      43,   144,    21,   127,    23,   127,    90,     9,    73,   144,
      53,   129,   119,   120,   121,   122,   123,   124,    61,    38,
      62,   119,   119,   144,    48,   119,   120,   121,   122,   123,
     124,     1,    30,   144,   141,   142,   144,    53,   145,    31,
      83,    11,   144,    86,   144,   144,   119,   141,   142,   119,
      20,   145,   144,    72,   125,   144,   144,   144,   144,    29,
      30,    31,   147,   154,   146,     1,    36,   144,    77,   131,
     113,   114,   115,    43,    93,    11,   119,   122,    20,    29,
       1,   100,    43,    53,    20,   104,    53,    31,    29,   108,
      11,    61,   147,    29,    30,    31,   148,    36,   125,    20,
      36,    39,    45,   144,     1,    54,    70,    43,    29,    30,
      31,   144,    15,    83,    11,    36,    86,    53,     1,   144,
     101,    31,    43,    20,   144,    61,    31,   144,    11,    53,
      31,   144,    53,   144,    31,    54,   144,    20,   145,    36,
      61,    29,    31,   113,    43,   115,    43,    83,    31,   119,
      86,    43,    36,    36,   144,    31,    53,   114,    39,    31,
      43,   145,    83,    31,    61,    86,   144,   144,   144,   144,
      53,     1,    36,    53,    40,   146,    39,   113,    61,   115,
     114,    11,   144,   119,    31,     1,    83,   146,    73,    86,
      20,    73,   113,   144,   115,    11,    39,   144,   119,   144,
      83,    31,   376,    86,    20,   306,    36,   144,   478,     1,
     198,   144,   588,    43,   468,    31,   113,   114,   115,    11,
      36,     1,   119,    53,   610,   609,   779,    43,    20,   183,
     113,    61,   115,   562,   562,    15,   119,    53,   640,    31,
       9,    21,   447,    23,    36,    61,    11,   470,   322,   462,
     837,    43,   832,    83,   405,   153,    86,   696,    38,   615,
     218,    53,   581,   699,    41,   297,    88,    83,     1,    61,
      86,    78,   800,   401,   743,   210,   835,   386,    45,   562,
       1,   281,   401,   113,   133,   115,   401,   391,    21,   119,
      23,    83,    72,   410,    86,   169,   570,   113,    31,   115,
      21,   194,    23,   119,   629,    38,    -1,    -1,   414,    -1,
      31,    -1,    -1,    93,    -1,    -1,    -1,    38,    -1,    -1,
     100,   113,    -1,   115,   104,    -1,    -1,   119,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,    -1,    -1,    -1,   108,    -1,    -1,    -1,   100,
      -1,    -1,    -1,   104,    -1,    -1,    -1,   108
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   158,   159,     0,     1,    50,   108,   204,   205,   206,
     207,   208,   254,   336,     1,   119,   256,   257,     1,   119,
     302,   303,     9,    22,    32,    68,   161,   163,   196,   216,
     255,   264,   265,   272,   273,   282,   299,   205,   207,   144,
     144,   147,   144,   154,   144,   147,   119,     1,   119,     1,
     119,    17,   119,    62,    48,    48,   256,     7,   119,   302,
      31,    62,    31,    48,   119,   119,     1,    21,    23,    38,
      72,   100,   104,   108,   183,   203,   231,   269,   270,   271,
     285,   321,   327,   329,   333,   335,     1,   266,   267,   268,
     319,   320,   327,   335,   154,    22,   348,   119,    32,   349,
      40,   234,   235,   162,    31,   144,   119,     1,   119,   238,
     119,   119,   119,     1,   119,     1,   119,   261,   262,   280,
     300,   301,     1,   269,    31,   144,    31,   266,    31,    35,
      94,   227,   322,   323,   324,   341,   353,    48,     7,   119,
     119,   239,    48,   239,   145,   274,    70,   276,   277,    48,
      68,   351,    48,   350,   144,   147,   148,   145,   274,   274,
     275,    48,   144,    48,   144,   144,   154,   145,   145,   154,
     145,   144,   147,   351,   351,   351,     1,   238,   322,    15,
     109,   144,   197,   198,   199,   335,   144,     1,   238,   251,
     253,   144,   145,   274,    31,     1,    93,   174,   175,   176,
     183,   203,   320,   321,   327,   329,   333,   336,   239,     1,
     234,   119,     1,   119,   330,    86,   330,     1,    10,    78,
     145,   187,   295,   334,     7,   119,   123,   331,     1,     3,
      60,   119,   120,   121,   122,   123,   124,   141,   142,   145,
     219,   220,   221,   226,   261,   281,   293,   296,   300,   312,
     314,   315,   332,   219,   331,   219,   300,   239,   239,   239,
     144,   148,     1,    11,    20,    43,    61,    83,    86,   113,
     119,   167,   177,   240,   242,   258,   261,   283,   284,   297,
     298,   307,   308,   309,   317,   318,   328,   339,   340,   343,
       1,   238,   197,    36,   172,   146,   148,   144,   146,     1,
     144,   349,   144,     1,   238,   174,    15,   144,    31,   277,
     144,    77,   145,   247,   127,   144,   119,   144,   144,   145,
     247,   212,   213,   238,   119,   217,   218,   144,   261,   281,
     281,   145,   119,   315,   315,    66,   180,   181,   210,   211,
     220,   293,   314,   146,   147,    55,    82,   155,   156,   150,
     130,     8,    56,    59,    65,   117,   118,   125,   126,   128,
     151,   152,   153,    28,    88,    89,    95,    96,    97,    98,
     102,   209,   141,   142,   143,   160,   316,   146,   146,   144,
     144,   144,   119,    31,   127,   144,   220,   220,     1,   220,
     144,   220,     1,   144,   220,    36,    63,   107,   144,   144,
     145,   148,   165,    36,    53,   115,   125,   127,     1,   309,
      31,   144,   148,   119,    31,   144,    45,    47,    67,   259,
     260,   251,   146,   239,   144,   148,     1,   116,   119,   164,
     167,   185,   188,   189,   190,   194,   195,   230,   232,   240,
     241,   261,   289,   290,   304,    21,    31,   314,     1,   293,
     294,   314,     1,   220,   119,   248,   249,    62,    31,   212,
     148,   146,   147,   150,   119,   168,   169,   131,   149,   146,
     147,   220,   226,   226,   226,   226,    77,    87,   119,   281,
     222,   296,   314,   296,   296,   223,   296,   224,   296,   225,
     296,   312,   312,   312,   312,   312,   312,   314,   314,   314,
     314,   314,   314,   314,   332,   160,    48,    64,   228,   229,
      38,    72,   325,   326,   220,    92,   297,   310,   311,    48,
      31,   101,   101,   311,   144,   144,   220,   220,   220,     1,
     169,   219,     1,   119,   283,   317,   340,   144,   119,   308,
     221,    61,   105,   220,   344,   345,   346,     1,   220,   326,
     330,   336,   337,   338,   348,   330,   144,   144,   330,   125,
     144,   220,   148,     1,    31,   195,    71,   352,   125,   145,
     291,   239,    21,   209,   146,   146,   147,   144,   144,    77,
     146,   147,   330,    78,   330,   217,   131,   146,   147,   220,
     180,   293,   314,   210,   145,   165,   166,     8,    65,   117,
     118,   332,   122,   119,   144,   239,   144,   119,   144,   114,
     178,   179,    43,   308,     1,   308,   144,   144,   144,   144,
     146,   146,   146,    45,    31,    53,     5,   114,   144,   147,
     144,   144,   239,   127,   342,   336,    36,   172,   182,   200,
     201,   202,   239,   127,   252,   127,   313,   344,    90,    21,
      36,    43,   119,   184,   189,   190,   261,   304,     9,   347,
      73,     1,   344,     1,     7,   261,   263,   292,   350,   144,
     239,   314,   293,   129,    62,   119,   248,   144,     1,    64,
     220,   119,   168,   219,   296,   296,   296,   296,    48,   144,
     181,    31,   179,   144,    30,   243,   244,   245,    31,   243,
     144,   144,   293,    53,   308,   220,   220,   346,   144,   220,
     144,     7,    66,   119,   186,   238,   250,   200,    31,   144,
     220,   220,   144,   144,   261,   119,   119,   220,     1,    40,
     236,   237,   125,   239,   114,   144,   114,   144,   146,   147,
     146,   227,   286,   287,   288,   341,   144,   330,   146,   122,
     131,    20,   220,    29,   246,   245,    43,   246,    53,   239,
      31,    29,     1,   108,   170,   171,   148,    36,   125,    45,
      39,   144,    54,    70,   278,   279,     1,   144,   220,   220,
     261,   286,    15,   308,   144,   101,     1,   308,    31,   144,
      31,   308,   144,    53,   344,    31,    22,    32,    64,   214,
     215,   144,   172,   173,   261,   144,   305,   306,   344,   293,
     164,   233,   145,    54,   144,    29,   191,   193,   191,   192,
       1,   308,     1,   308,    43,    43,    31,   239,   144,    36,
     261,   261,   279,    31,   144,   147,   114,    39,    31,     1,
     169,   145,   344,   144,   193,   144,    31,    31,   144,   144,
      53,   144,   236,    36,   305,    66,   220,   233,    39,   146,
     146,     1,   169,   114,   352,   352,   239,   144,    31,   239,
     146,   146,   220,    73,    73,   144,    39,   144,   239,   239,
     239,   144,   144,   144
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   157,   159,   158,   160,   160,   160,   162,   161,   163,
     164,   164,   164,   165,   166,   166,   167,   167,   168,   168,
     168,   169,   169,   170,   171,   171,   172,   173,   173,   174,
     174,   174,   174,   174,   174,   174,   174,   174,   174,   175,
     175,   176,   176,   177,   178,   178,   179,   180,   180,   180,
     181,   181,   182,   182,   183,   183,   184,   184,   185,   185,
     186,   187,   187,   187,   188,   189,   189,   190,   191,   191,
     192,   192,   193,   193,   194,   194,   194,   194,   194,   194,
     194,   194,   195,   195,   195,   195,   195,   196,   196,   197,
     198,   198,   199,   199,   200,   200,   201,   201,   202,   202,
     203,   203,   203,   203,   203,   204,   204,   205,   205,   206,
     206,   207,   207,   208,   208,   209,   209,   210,   210,   211,
     211,   212,   213,   213,   214,   214,   214,   215,   215,   216,
     216,   217,   218,   218,   219,   219,   220,   220,   221,   221,
     221,   221,   221,   221,   221,   222,   222,   223,   223,   224,
     224,   225,   225,   226,   226,   226,   226,   227,   227,   228,
     228,   229,   229,   230,   231,   232,   232,   233,   234,   234,
     235,   235,   236,   236,   237,   237,   238,   238,   239,   239,
     240,   240,   241,   242,   242,   242,   242,   243,   243,   244,
     244,   245,   245,   246,   246,   246,   247,   247,   248,   249,
     249,   250,   250,   250,   251,   252,   252,   253,   253,   254,
     254,   255,   255,   256,   257,   257,   258,   258,   258,   259,
     259,   259,   260,   260,   261,   261,   261,   261,   262,   262,
     263,   263,   264,   264,   265,   266,   266,   267,   267,   268,
     268,   269,   269,   269,   269,   269,   269,   269,   270,   270,
     271,   271,   272,   272,   273,   274,   275,   275,   276,   276,
     277,   277,   278,   278,   279,   279,   280,   281,   281,   281,
     281,   281,   281,   281,   281,   281,   281,   282,   282,   282,
     283,   283,   283,   283,   284,   284,   285,   286,   286,   287,
     287,   288,   288,   289,   290,   290,   291,   291,   291,   292,
     292,   293,   293,   293,   294,   294,   295,   296,   296,   296,
     296,   296,   296,   296,   297,   298,   298,   298,   299,   299,
     300,   300,   301,   301,   302,   302,   302,   303,   303,   304,
     305,   305,   306,   306,   307,   307,   308,   308,   309,   309,
     309,   309,   309,   309,   309,   309,   309,   309,   309,   309,
     310,   311,   311,   312,   312,   312,   312,   312,   312,   312,
     313,   313,   314,   314,   314,   315,   315,   316,   316,   317,
     317,   318,   318,   319,   320,   320,   321,   322,   322,   323,
     323,   324,   324,   325,   325,   326,   326,   327,   327,   328,
     329,   330,   330,   330,   331,   331,   331,   332,   332,   332,
     332,   332,   333,   333,   333,   333,   334,   334,   335,   335,
     336,   336,   337,   337,   338,   338,   339,   339,   340,   340,
     340,   341,   341,   342,   342,   343,   343,   343,   343,   344,
     344,   345,   345,   346,   346,   346,   347,   347,   348,   348,
     349,   349,   350,   350,   351,   351,   352,   352,   353,   353
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     1,     0,    12,     2,
       2,     1,     2,     3,     1,     0,     3,     4,     3,     3,
       3,     3,     1,     4,     2,     0,     7,     1,     0,     6,
       1,     1,     1,     1,     1,     1,     1,     3,     2,     2,
       1,     1,     0,     7,     2,     1,     4,     1,     1,     1,
       3,     1,     7,     5,     9,     8,     1,     2,     6,     5,
       3,     4,     6,     1,     1,     7,     7,     4,     2,     1,
       1,     0,     4,     2,     1,     3,     1,     3,     1,     3,
       4,     4,     1,     1,     1,     1,     1,    11,     6,     1,
       2,     1,     1,     0,     1,     1,     2,     1,     1,     0,
       7,     5,     7,     5,     3,     1,     0,     1,     1,     2,
       1,     2,     1,     2,     1,     1,     1,     3,     1,     3,
       1,     4,     2,     1,     2,     2,     1,     1,     0,     9,
       6,     1,     3,     1,     3,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     1,     3,     1,     3,     1,
       3,     1,     3,     1,     3,     2,     2,     6,     3,     4,
       2,     1,     0,    12,     5,     1,     1,     1,     1,     0,
       3,     5,     1,     0,     5,     5,     3,     1,     1,     0,
       2,     0,    10,     9,     9,     7,     5,     1,     0,     2,
       1,     4,     4,     2,     2,     0,     3,     3,     3,     3,
       1,     1,     1,     1,     5,     2,     0,     3,     1,     3,
       3,     1,     1,     1,     3,     1,     9,    11,     7,     1,
       1,     1,     1,     0,     1,     1,     1,     4,     4,     4,
       3,     1,     7,     7,     2,     1,     1,     2,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     0,     7,     7,     3,     3,     1,     0,     3,     5,
       1,     0,     5,     5,     1,     0,     1,     1,     4,     1,
       1,     1,     1,     1,     2,     4,     3,     1,     1,     1,
       2,     5,     3,     5,     3,     1,     3,     1,     1,     2,
       1,     1,     0,     3,    11,    11,     3,     3,     0,     1,
       1,     3,     3,     3,     1,     3,     4,     1,     3,     3,
       3,     3,     3,     3,     4,     3,     2,     3,     1,     1,
       3,     3,     3,     1,     3,     5,     5,     3,     1,     7,
       3,     3,     3,     1,     2,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       2,     1,     0,     1,     3,     3,     3,     3,     3,     3,
       2,     0,     2,     2,     1,     1,     2,     2,     3,     4,
       8,     1,     3,     2,     8,     8,     2,     1,     1,     2,
       1,     1,     0,     1,     1,     1,     0,     1,     1,     1,
       5,     1,     2,     5,     1,     1,     1,     1,     3,     3,
       3,     3,     5,     3,     5,     3,     3,     1,     3,     3,
       3,     3,     2,     1,     1,     0,     1,     3,     4,     4,
       4,     7,     4,     2,     0,     4,     4,     4,     2,     1,
       1,     3,     1,     1,     3,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, yyscanner, file_path, parse_library_name, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, yyscanner, file_path, parse_library_name); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner, const char*file_path, perm_string parse_library_name)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (yyscanner);
  YY_USE (file_path);
  YY_USE (parse_library_name);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner, const char*file_path, perm_string parse_library_name)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, yyscanner, file_path, parse_library_name);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, yyscan_t yyscanner, const char*file_path, perm_string parse_library_name)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), yyscanner, file_path, parse_library_name);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner, file_path, parse_library_name); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner, const char*file_path, perm_string parse_library_name)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (yyscanner);
  YY_USE (file_path);
  YY_USE (parse_library_name);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner, const char*file_path, perm_string parse_library_name)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 394 "parse.y"
              { yylloc.text = file_path; }
#line 2542 "parse.cc"
    break;

  case 4: /* adding_operator: '+'  */
#line 397 "parse.y"
        { (yyval.arithmetic_op) = ExpArithmetic::PLUS; }
#line 2548 "parse.cc"
    break;

  case 5: /* adding_operator: '-'  */
#line 398 "parse.y"
        { (yyval.arithmetic_op) = ExpArithmetic::MINUS; }
#line 2554 "parse.cc"
    break;

  case 6: /* adding_operator: '&'  */
#line 399 "parse.y"
        { (yyval.arithmetic_op) = ExpArithmetic::xCONCAT; }
#line 2560 "parse.cc"
    break;

  case 7: /* $@2: %empty  */
#line 405 "parse.y"
      { bind_entity_to_active_scope((yyvsp[0].text), active_scope); }
#line 2566 "parse.cc"
    break;

  case 8: /* architecture_body: architecture_body_start K_of IDENTIFIER $@2 K_is block_declarative_items_opt K_begin architecture_statement_part K_end K_architecture_opt identifier_opt ';'  */
#line 408 "parse.y"
      { Architecture*tmp = new Architecture(lex_strings.make((yyvsp[-11].text)),
					    *active_scope, *(yyvsp[-4].arch_statement_list));
	FILE_NAME(tmp, (yylsp[-11]));
	bind_architecture_to_entity((yyvsp[-9].text), tmp);
	if ((yyvsp[-1].text) && tmp->get_name() != (yyvsp[-1].text))
	      errormsg((yylsp[-11]), "Architecture name doesn't match closing name.\n");
	delete[](yyvsp[-11].text);
	delete[](yyvsp[-9].text);
	delete (yyvsp[-4].arch_statement_list);
	pop_scope();
	assert(arc_scope);
	arc_scope = NULL;
	if ((yyvsp[-1].text)) delete[](yyvsp[-1].text);
      }
#line 2585 "parse.cc"
    break;

  case 9: /* architecture_body_start: K_architecture IDENTIFIER  */
#line 426 "parse.y"
      { (yyval.text) = (yyvsp[0].text);
	push_scope();
	assert(!arc_scope);
	arc_scope = active_scope;
      }
#line 2595 "parse.cc"
    break;

  case 10: /* architecture_statement_part: architecture_statement_part concurrent_statement  */
#line 438 "parse.y"
      { std::list<Architecture::Statement*>*tmp = (yyvsp[-1].arch_statement_list);
	if ((yyvsp[0].arch_statement)) tmp->push_back((yyvsp[0].arch_statement));
	(yyval.arch_statement_list) = tmp;
      }
#line 2604 "parse.cc"
    break;

  case 11: /* architecture_statement_part: concurrent_statement  */
#line 443 "parse.y"
      { std::list<Architecture::Statement*>*tmp = new std::list<Architecture::Statement*>;
	if ((yyvsp[0].arch_statement)) tmp->push_back((yyvsp[0].arch_statement));
	(yyval.arch_statement_list) = tmp;
      }
#line 2613 "parse.cc"
    break;

  case 12: /* architecture_statement_part: error ';'  */
#line 449 "parse.y"
      { (yyval.arch_statement_list) = 0;
	errormsg((yylsp[-1]), "Syntax error in architecture statement.\n");
	yyerrok;
      }
#line 2622 "parse.cc"
    break;

  case 13: /* argument_list: '(' expression_list ')'  */
#line 455 "parse.y"
                                        { (yyval.expr_list) = (yyvsp[-1].expr_list); }
#line 2628 "parse.cc"
    break;

  case 14: /* argument_list_opt: argument_list  */
#line 458 "parse.y"
                  { (yyval.expr_list) = (yyvsp[0].expr_list); }
#line 2634 "parse.cc"
    break;

  case 15: /* argument_list_opt: %empty  */
#line 459 "parse.y"
    { (yyval.expr_list) = 0; }
#line 2640 "parse.cc"
    break;

  case 16: /* assertion_statement: K_assert expression report_statement  */
#line 464 "parse.y"
      { ReportStmt*report = dynamic_cast<ReportStmt*>((yyvsp[0].sequ));
        assert(report);
	AssertStmt*tmp = new AssertStmt((yyvsp[-1].expr), report->message(), report->severity());
        delete report;
	FILE_NAME(tmp,(yylsp[-1]));
	(yyval.sequ) = tmp;
      }
#line 2652 "parse.cc"
    break;

  case 17: /* assertion_statement: K_assert expression severity_opt ';'  */
#line 472 "parse.y"
      { AssertStmt*tmp = new AssertStmt((yyvsp[-2].expr), NULL, (yyvsp[-1].severity));
	FILE_NAME(tmp,(yylsp[-2]));
	(yyval.sequ) = tmp;
      }
#line 2661 "parse.cc"
    break;

  case 18: /* association_element: IDENTIFIER ARROW expression  */
#line 480 "parse.y"
      { named_expr_t*tmp = new named_expr_t(lex_strings.make((yyvsp[-2].text)), (yyvsp[0].expr));
	delete[](yyvsp[-2].text);
	(yyval.named_expr) = tmp;
	}
#line 2670 "parse.cc"
    break;

  case 19: /* association_element: IDENTIFIER ARROW K_open  */
#line 485 "parse.y"
      { named_expr_t*tmp = new named_expr_t(lex_strings.make((yyvsp[-2].text)), 0);
	delete[](yyvsp[-2].text);
	(yyval.named_expr) = tmp;
      }
#line 2679 "parse.cc"
    break;

  case 20: /* association_element: IDENTIFIER ARROW error  */
#line 490 "parse.y"
      { errormsg((yylsp[0]), "Invalid target for port map association.\n");
	yyerrok;
	(yyval.named_expr) = 0;
      }
#line 2688 "parse.cc"
    break;

  case 21: /* association_list: association_list ',' association_element  */
#line 498 "parse.y"
      { std::list<named_expr_t*>*tmp = (yyvsp[-2].named_expr_list);
	tmp->push_back((yyvsp[0].named_expr));
	(yyval.named_expr_list) = tmp;
      }
#line 2697 "parse.cc"
    break;

  case 22: /* association_list: association_element  */
#line 503 "parse.y"
      { std::list<named_expr_t*>*tmp = new std::list<named_expr_t*>;
	tmp->push_back((yyvsp[0].named_expr));
	(yyval.named_expr_list) = tmp;
      }
#line 2706 "parse.cc"
    break;

  case 23: /* binding_indication: K_use entity_aspect_opt port_map_aspect_opt generic_map_aspect_opt  */
#line 511 "parse.y"
      { (yyval.entity_aspect) = (yyvsp[-2].entity_aspect);
	if ((yyvsp[-1].named_expr_list)) sorrymsg((yylsp[-1]), "Port map aspect not supported here. (binding_indication)\n");
	if ((yyvsp[0].named_expr_list)) sorrymsg((yylsp[0]), "Generic map aspect not supported here. (binding_indication)\n");
	delete (yyvsp[-1].named_expr_list);
	delete (yyvsp[0].named_expr_list);
      }
#line 2717 "parse.cc"
    break;

  case 24: /* binding_indication_semicolon_opt: binding_indication ';'  */
#line 520 "parse.y"
                           { (yyval.entity_aspect) = (yyvsp[-1].entity_aspect); }
#line 2723 "parse.cc"
    break;

  case 25: /* binding_indication_semicolon_opt: %empty  */
#line 521 "parse.y"
    { (yyval.entity_aspect) = 0; }
#line 2729 "parse.cc"
    break;

  case 26: /* block_configuration: K_for IDENTIFIER use_clauses_opt configuration_items_opt K_end K_for ';'  */
#line 529 "parse.y"
    { delete[] (yyvsp[-5].text); }
#line 2735 "parse.cc"
    break;

  case 29: /* block_declarative_item: K_signal identifier_list ':' subtype_indication signal_declaration_assign_opt ';'  */
#line 540 "parse.y"
      { /* Save the signal declaration in the block_signals map. */
	for (std::list<perm_string>::iterator cur = (yyvsp[-4].name_list)->begin()
		   ; cur != (yyvsp[-4].name_list)->end() ; ++cur) {
	      Signal*sig = new Signal(*cur, (yyvsp[-2].vtype), (yyvsp[-1].expr) ? (yyvsp[-1].expr)->clone() : 0);
	      FILE_NAME(sig, (yylsp[-5]));
	      active_scope->bind_name(*cur, sig);
	}
	delete (yyvsp[-4].name_list);
      }
#line 2749 "parse.cc"
    break;

  case 37: /* block_declarative_item: K_signal error ';'  */
#line 567 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error declaring signals.\n"); yyerrok; }
#line 2755 "parse.cc"
    break;

  case 38: /* block_declarative_item: error ';'  */
#line 569 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error in block declarations.\n"); yyerrok; }
#line 2761 "parse.cc"
    break;

  case 43: /* case_statement: K_case expression K_is case_statement_alternative_list K_end K_case ';'  */
#line 592 "parse.y"
      { CaseSeqStmt* tmp = new CaseSeqStmt((yyvsp[-5].expr), (yyvsp[-3].case_alt_list));
	FILE_NAME(tmp, (yylsp[-6]));
	delete (yyvsp[-3].case_alt_list);
	(yyval.sequ) = tmp;
      }
#line 2771 "parse.cc"
    break;

  case 44: /* case_statement_alternative_list: case_statement_alternative_list case_statement_alternative  */
#line 601 "parse.y"
      { std::list<CaseSeqStmt::CaseStmtAlternative*>* tmp = (yyvsp[-1].case_alt_list);
	tmp->push_back((yyvsp[0].case_alt));
	(yyval.case_alt_list) = tmp;
      }
#line 2780 "parse.cc"
    break;

  case 45: /* case_statement_alternative_list: case_statement_alternative  */
#line 606 "parse.y"
      { std::list<CaseSeqStmt::CaseStmtAlternative*>*tmp
		  = new std::list<CaseSeqStmt::CaseStmtAlternative*>();
	tmp->push_back((yyvsp[0].case_alt));
	(yyval.case_alt_list) = tmp;
      }
#line 2790 "parse.cc"
    break;

  case 46: /* case_statement_alternative: K_when choices ARROW sequence_of_statements  */
#line 621 "parse.y"
      { CaseSeqStmt::CaseStmtAlternative* tmp;
        std::list<ExpAggregate::choice_t*>*choices = (yyvsp[-2].choice_list);
        std::list<Expression*>*exp_list = new std::list<Expression*>;
        bool others = false;

        for(std::list<ExpAggregate::choice_t*>::iterator it = choices->begin();
                it != choices->end(); ++it) {
            if((*it)->others() || others)
                // If there is one "others", then it also covers all other alternatives
                // Continue the loop to delete every choice_t, but do not
                // bother to add the expressions to the exp_list (we are going to
                // delete them very soon)
                others = true;
            else
                exp_list->push_back((*it)->simple_expression());

            delete (*it);
        }

        if(others) {
            tmp = new CaseSeqStmt::CaseStmtAlternative(0, (yyvsp[0].sequ_list));
            for(std::list<Expression*>::iterator it = exp_list->begin();
                    it != exp_list->end(); ++it) {
                delete (*it);
            }
        } else {
            tmp = new CaseSeqStmt::CaseStmtAlternative(exp_list, (yyvsp[0].sequ_list));
        }
        if (tmp) FILE_NAME(tmp, (yylsp[-3]));

        delete choices;
        delete (yyvsp[0].sequ_list);
        (yyval.case_alt) = tmp;
      }
#line 2829 "parse.cc"
    break;

  case 47: /* choice: simple_expression  */
#line 659 "parse.y"
      { (yyval.choice) = new ExpAggregate::choice_t((yyvsp[0].expr));}
#line 2835 "parse.cc"
    break;

  case 48: /* choice: K_others  */
#line 661 "parse.y"
      { (yyval.choice) = new ExpAggregate::choice_t; }
#line 2841 "parse.cc"
    break;

  case 49: /* choice: range  */
#line 663 "parse.y"
      { (yyval.choice) = new ExpAggregate::choice_t((yyvsp[0].range)); }
#line 2847 "parse.cc"
    break;

  case 50: /* choices: choices '|' choice  */
#line 668 "parse.y"
      { std::list<ExpAggregate::choice_t*>*tmp = (yyvsp[-2].choice_list);
	tmp->push_back((yyvsp[0].choice));
	(yyval.choice_list) = tmp;
      }
#line 2856 "parse.cc"
    break;

  case 51: /* choices: choice  */
#line 673 "parse.y"
      { std::list<ExpAggregate::choice_t*>*tmp = new std::list<ExpAggregate::choice_t*>;
	tmp->push_back((yyvsp[0].choice));
	(yyval.choice_list) = tmp;
      }
#line 2865 "parse.cc"
    break;

  case 52: /* component_configuration: K_for component_specification binding_indication_semicolon_opt block_configuration_opt K_end K_for ';'  */
#line 684 "parse.y"
      {
    sorrymsg((yylsp[-6]), "Component configuration in not yet supported\n");
    if((yyvsp[-4].entity_aspect)) delete (yyvsp[-4].entity_aspect);
    delete (yyvsp[-5].component_specification);
      }
#line 2875 "parse.cc"
    break;

  case 53: /* component_configuration: K_for component_specification error K_end K_for  */
#line 690 "parse.y"
      {
    errormsg((yylsp[-4]), "Error in component configuration statement.\n");
    delete (yyvsp[-3].component_specification);
      }
#line 2884 "parse.cc"
    break;

  case 54: /* component_declaration: K_component IDENTIFIER K_is_opt generic_clause_opt port_clause_opt K_end K_component identifier_opt ';'  */
#line 700 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-7].text));
	if((yyvsp[-1].text) && name != (yyvsp[-1].text)) {
	      errormsg((yylsp[-1]), "Identifier %s doesn't match component name %s.\n",
		       (yyvsp[-1].text), name.str());
	}

	ComponentBase*comp = new ComponentBase(name);
	comp->set_interface((yyvsp[-5].interface_list), (yyvsp[-4].interface_list));
	if ((yyvsp[-5].interface_list)) delete (yyvsp[-5].interface_list);
	if ((yyvsp[-4].interface_list)) delete (yyvsp[-4].interface_list);

	active_scope->bind_name(name, comp);
	delete[](yyvsp[-7].text);
	if ((yyvsp[-1].text)) delete[] (yyvsp[-1].text);
      }
#line 2904 "parse.cc"
    break;

  case 55: /* component_declaration: K_component IDENTIFIER K_is_opt error K_end K_component identifier_opt ';'  */
#line 717 "parse.y"
      { errormsg((yylsp[-4]), "Syntax error in component declaration.\n");
	delete[] (yyvsp[-6].text);
	if((yyvsp[-1].text)) delete[] (yyvsp[-1].text);
	yyerrok;
      }
#line 2914 "parse.cc"
    break;

  case 57: /* instantiated_unit: K_component IDENTIFIER  */
#line 726 "parse.y"
                           { (yyval.text) = (yyvsp[0].text); }
#line 2920 "parse.cc"
    break;

  case 58: /* component_instantiation_statement: IDENTIFIER ':' instantiated_unit generic_map_aspect_opt port_map_aspect_opt ';'  */
#line 731 "parse.y"
      { perm_string iname = lex_strings.make((yyvsp[-5].text));
	perm_string cname = lex_strings.make((yyvsp[-3].text));
	ComponentInstantiation*tmp = new ComponentInstantiation(iname, cname, (yyvsp[-2].named_expr_list), (yyvsp[-1].named_expr_list));
	delete (yyvsp[-2].named_expr_list);
	delete (yyvsp[-1].named_expr_list);
	FILE_NAME(tmp, (yylsp[-5]));
	delete[](yyvsp[-5].text);
	delete[](yyvsp[-3].text);
	(yyval.arch_statement) = tmp;
      }
#line 2935 "parse.cc"
    break;

  case 59: /* component_instantiation_statement: IDENTIFIER ':' instantiated_unit error ';'  */
#line 742 "parse.y"
      { errormsg((yylsp[-1]), "Errors in component instantiation.\n");
	delete[](yyvsp[-4].text);
	delete[](yyvsp[-2].text);
	(yyval.arch_statement) = 0;
      }
#line 2945 "parse.cc"
    break;

  case 60: /* component_specification: instantiation_list ':' name  */
#line 751 "parse.y"
      {
    ExpName* name = dynamic_cast<ExpName*>((yyvsp[0].expr));
    std::pair<instant_list_t*, ExpName*>* tmp = new std::pair<instant_list_t*, ExpName*>((yyvsp[-2].instantiation_list), name);
    (yyval.component_specification) = tmp;
      }
#line 2955 "parse.cc"
    break;

  case 61: /* composite_type_definition: K_array index_constraint K_of subtype_indication  */
#line 761 "parse.y"
      { const VTypeArray*tmp = new VTypeArray((yyvsp[0].vtype), (yyvsp[-2].range_list));
	delete (yyvsp[-2].range_list);
	(yyval.vtype) = tmp;
      }
#line 2964 "parse.cc"
    break;

  case 62: /* composite_type_definition: K_array '(' index_subtype_definition_list ')' K_of subtype_indication  */
#line 768 "parse.y"
      { std::list<ExpRange*> r;
	// NULL boundaries indicate unbounded array type
	ExpRange*tmp = new ExpRange(NULL, NULL, ExpRange::DOWNTO);
	r.push_back(tmp);
	FILE_NAME(tmp, (yylsp[-5]));
	const VTypeArray*arr = new VTypeArray((yyvsp[0].vtype), &r);
	(yyval.vtype) = arr;
      }
#line 2977 "parse.cc"
    break;

  case 63: /* composite_type_definition: record_type_definition  */
#line 778 "parse.y"
      { (yyval.vtype) = (yyvsp[0].vtype); }
#line 2983 "parse.cc"
    break;

  case 64: /* concurrent_assertion_statement: assertion_statement  */
#line 783 "parse.y"
      {
        /* See more explanations at IEEE 1076-2008 P11.5 */
        std::list<SequentialStmt*> stmts;
        stmts.push_back((yyvsp[0].sequ));
        stmts.push_back(new WaitStmt(WaitStmt::FINAL, NULL));
        push_scope();
        ProcessStatement*tmp = new ProcessStatement(empty_perm_string, *active_scope,
                                                    NULL, &stmts);
        pop_scope();
        FILE_NAME(tmp, (yylsp[0]));
        (yyval.arch_statement) = tmp;
      }
#line 3000 "parse.cc"
    break;

  case 65: /* concurrent_conditional_signal_assignment: name LEQ waveform K_when expression else_when_waveforms_opt ';'  */
#line 803 "parse.y"
      { std::list<ExpConditional::case_t*>*options;
        options = (yyvsp[-1].exp_options_list) ? (yyvsp[-1].exp_options_list) : new std::list<ExpConditional::case_t*>;
        options->push_front(new ExpConditional::case_t((yyvsp[-2].expr), (yyvsp[-4].expr_list)));

        ExpName*name = dynamic_cast<ExpName*>((yyvsp[-6].expr));
        assert(name);
        CondSignalAssignment*tmp = new CondSignalAssignment(name, *options);

        FILE_NAME(tmp, (yylsp[-6]));
        delete options;
        (yyval.arch_statement) = tmp;
      }
#line 3017 "parse.cc"
    break;

  case 66: /* concurrent_conditional_signal_assignment: name LEQ error K_when expression else_when_waveforms ';'  */
#line 819 "parse.y"
      { errormsg((yylsp[-4]), "Syntax error in waveform of conditional signal assignment.\n");
	ExpConditional*tmp = new ExpConditional((yyvsp[-2].expr), 0, (yyvsp[-1].exp_options_list));
	FILE_NAME(tmp, (yylsp[-4]));
	delete (yyvsp[-1].exp_options_list);

        ExpName*name = dynamic_cast<ExpName*> ((yyvsp[-6].expr));
	assert(name);
	SignalAssignment*tmpa = new SignalAssignment(name, tmp);
	FILE_NAME(tmpa, (yylsp[-6]));

	(yyval.arch_statement) = tmpa;
      }
#line 3034 "parse.cc"
    break;

  case 67: /* concurrent_simple_signal_assignment: name LEQ waveform ';'  */
#line 835 "parse.y"
      { ExpName*name = dynamic_cast<ExpName*> ((yyvsp[-3].expr));
	assert(name);
	SignalAssignment*tmp = new SignalAssignment(name, *(yyvsp[-1].expr_list));
	FILE_NAME(tmp, (yylsp[-3]));

	(yyval.arch_statement) = tmp;
	delete (yyvsp[-1].expr_list);
      }
#line 3047 "parse.cc"
    break;

  case 68: /* else_when_waveforms: else_when_waveforms else_when_waveform  */
#line 846 "parse.y"
      { list<ExpConditional::case_t*>*tmp = (yyvsp[-1].exp_options_list);
	tmp ->push_back((yyvsp[0].exp_options));
	(yyval.exp_options_list) = tmp;
      }
#line 3056 "parse.cc"
    break;

  case 69: /* else_when_waveforms: else_when_waveform  */
#line 851 "parse.y"
      { list<ExpConditional::case_t*>*tmp = new list<ExpConditional::case_t*>;
	tmp->push_back((yyvsp[0].exp_options));
	(yyval.exp_options_list) = tmp;
      }
#line 3065 "parse.cc"
    break;

  case 70: /* else_when_waveforms_opt: else_when_waveforms  */
#line 858 "parse.y"
                        { (yyval.exp_options_list) = (yyvsp[0].exp_options_list); }
#line 3071 "parse.cc"
    break;

  case 71: /* else_when_waveforms_opt: %empty  */
#line 859 "parse.y"
    { (yyval.exp_options_list) = 0; }
#line 3077 "parse.cc"
    break;

  case 72: /* else_when_waveform: K_else waveform K_when expression  */
#line 865 "parse.y"
      { ExpConditional::case_t*tmp = new ExpConditional::case_t((yyvsp[0].expr), (yyvsp[-2].expr_list));
	FILE_NAME(tmp, (yylsp[-3]));
	(yyval.exp_options) = tmp;
      }
#line 3086 "parse.cc"
    break;

  case 73: /* else_when_waveform: K_else waveform  */
#line 870 "parse.y"
      { ExpConditional::case_t*tmp = new ExpConditional::case_t(0,  (yyvsp[0].expr_list));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.exp_options) = tmp;
      }
#line 3095 "parse.cc"
    break;

  case 75: /* concurrent_signal_assignment_statement: IDENTIFIER ':' concurrent_simple_signal_assignment  */
#line 880 "parse.y"
      { delete[] (yyvsp[-2].text);
	(yyval.arch_statement) = (yyvsp[0].arch_statement);
      }
#line 3103 "parse.cc"
    break;

  case 77: /* concurrent_signal_assignment_statement: IDENTIFIER ':' concurrent_conditional_signal_assignment  */
#line 887 "parse.y"
      { delete[] (yyvsp[-2].text);
	(yyval.arch_statement) = (yyvsp[0].arch_statement);
      }
#line 3111 "parse.cc"
    break;

  case 79: /* concurrent_signal_assignment_statement: IDENTIFIER ':' selected_signal_assignment  */
#line 893 "parse.y"
                                              { (yyval.arch_statement) = (yyvsp[0].arch_statement); }
#line 3117 "parse.cc"
    break;

  case 80: /* concurrent_signal_assignment_statement: name LEQ error ';'  */
#line 896 "parse.y"
      { errormsg((yylsp[-2]), "Syntax error in signal assignment waveform.\n");
	delete (yyvsp[-3].expr);
	(yyval.arch_statement) = 0;
	yyerrok;
      }
#line 3127 "parse.cc"
    break;

  case 81: /* concurrent_signal_assignment_statement: error LEQ waveform ';'  */
#line 902 "parse.y"
      { errormsg((yylsp[-3]), "Syntax error in l-value of signal assignment.\n");
	yyerrok;
	delete (yyvsp[-1].expr_list);
	(yyval.arch_statement) = 0;
      }
#line 3137 "parse.cc"
    break;

  case 87: /* configuration_declaration: K_configuration IDENTIFIER K_of IDENTIFIER K_is configuration_declarative_part block_configuration K_end K_configuration_opt identifier_opt ';'  */
#line 922 "parse.y"
     {
  if(design_entities.find(lex_strings.make((yyvsp[-7].text))) == design_entities.end())
      errormsg((yylsp[-7]), "Couldn't find entity %s used in configuration declaration\n", (yyvsp[-7].text));
  //choose_architecture_for_entity();
  sorrymsg((yylsp[-10]), "Configuration declaration is not yet supported.\n");
     }
#line 3148 "parse.cc"
    break;

  case 88: /* configuration_declaration: K_configuration error K_end K_configuration_opt identifier_opt ';'  */
#line 929 "parse.y"
      { errormsg((yylsp[-4]), "Too many errors, giving up on configuration declaration.\n");
    if((yyvsp[-1].text)) delete (yyvsp[-1].text);
    yyerrok;
      }
#line 3157 "parse.cc"
    break;

  case 100: /* constant_declaration: K_constant identifier_list ':' subtype_indication VASSIGN expression ';'  */
#line 966 "parse.y"
      { // The syntax allows multiple names to have the same type/value.
	for (std::list<perm_string>::iterator cur = (yyvsp[-5].name_list)->begin()
		   ; cur != (yyvsp[-5].name_list)->end() ; ++cur) {
	      active_scope->bind_name(*cur, (yyvsp[-3].vtype), (yyvsp[-1].expr));
	}
	delete (yyvsp[-5].name_list);
      }
#line 3169 "parse.cc"
    break;

  case 101: /* constant_declaration: K_constant identifier_list ':' subtype_indication ';'  */
#line 974 "parse.y"
      { sorrymsg((yylsp[-4]), "Deferred constant declarations not supported\n");
	delete (yyvsp[-3].name_list);
      }
#line 3177 "parse.cc"
    break;

  case 102: /* constant_declaration: K_constant identifier_list ':' subtype_indication VASSIGN error ';'  */
#line 981 "parse.y"
      { // The syntax allows multiple names to have the same type/value.
	errormsg((yylsp[-1]), "Error in value expression for constants.\n");
	yyerrok;
	for (std::list<perm_string>::iterator cur = (yyvsp[-5].name_list)->begin()
		   ; cur != (yyvsp[-5].name_list)->end() ; ++cur) {
	      active_scope->bind_name(*cur, (yyvsp[-3].vtype), 0);
	}
	delete (yyvsp[-5].name_list);
      }
#line 3191 "parse.cc"
    break;

  case 103: /* constant_declaration: K_constant identifier_list ':' error ';'  */
#line 991 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error in constant declaration type.\n");
	yyerrok;
	delete (yyvsp[-3].name_list);
      }
#line 3200 "parse.cc"
    break;

  case 104: /* constant_declaration: K_constant error ';'  */
#line 996 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error in constant declaration.\n");
	yyerrok;
      }
#line 3208 "parse.cc"
    break;

  case 112: /* design_unit: error  */
#line 1017 "parse.y"
          { errormsg((yylsp[0]), "Invalid design_unit\n"); }
#line 3214 "parse.cc"
    break;

  case 115: /* direction: K_to  */
#line 1026 "parse.y"
         { (yyval.range_dir) = ExpRange::TO; }
#line 3220 "parse.cc"
    break;

  case 116: /* direction: K_downto  */
#line 1027 "parse.y"
             { (yyval.range_dir) = ExpRange::DOWNTO; }
#line 3226 "parse.cc"
    break;

  case 117: /* element_association: choices ARROW expression  */
#line 1032 "parse.y"
      { ExpAggregate::element_t*tmp = new ExpAggregate::element_t((yyvsp[-2].choice_list), (yyvsp[0].expr));
	delete (yyvsp[-2].choice_list);
	(yyval.element) = tmp;
      }
#line 3235 "parse.cc"
    break;

  case 118: /* element_association: expression  */
#line 1037 "parse.y"
      { ExpAggregate::element_t*tmp = new ExpAggregate::element_t(0, (yyvsp[0].expr));
	(yyval.element) = tmp;
      }
#line 3243 "parse.cc"
    break;

  case 119: /* element_association_list: element_association_list ',' element_association  */
#line 1044 "parse.y"
      { std::list<ExpAggregate::element_t*>*tmp = (yyvsp[-2].element_list);
	tmp->push_back((yyvsp[0].element));
	(yyval.element_list) = tmp;
      }
#line 3252 "parse.cc"
    break;

  case 120: /* element_association_list: element_association  */
#line 1049 "parse.y"
      { std::list<ExpAggregate::element_t*>*tmp = new std::list<ExpAggregate::element_t*>;
	tmp->push_back((yyvsp[0].element));
	(yyval.element_list) = tmp;
      }
#line 3261 "parse.cc"
    break;

  case 121: /* element_declaration: identifier_list ':' subtype_indication ';'  */
#line 1057 "parse.y"
      { (yyval.record_elements) = record_elements((yyvsp[-3].name_list), (yyvsp[-1].vtype));
        delete (yyvsp[-3].name_list);
      }
#line 3269 "parse.cc"
    break;

  case 122: /* element_declaration_list: element_declaration_list element_declaration  */
#line 1064 "parse.y"
      { (yyval.record_elements) = (yyvsp[-1].record_elements);
	(yyval.record_elements)->splice((yyval.record_elements)->end(), *(yyvsp[0].record_elements));
	delete (yyvsp[0].record_elements);
      }
#line 3278 "parse.cc"
    break;

  case 123: /* element_declaration_list: element_declaration  */
#line 1069 "parse.y"
      { (yyval.record_elements) = (yyvsp[0].record_elements); }
#line 3284 "parse.cc"
    break;

  case 124: /* entity_aspect: K_entity name  */
#line 1075 "parse.y"
      {
    ExpName* name = dynamic_cast<ExpName*>((yyvsp[0].expr));
    entity_aspect_t* tmp = new entity_aspect_t(entity_aspect_t::ENTITY, name);
    (yyval.entity_aspect) = tmp;
      }
#line 3294 "parse.cc"
    break;

  case 125: /* entity_aspect: K_configuration name  */
#line 1081 "parse.y"
      {
    ExpName* name = dynamic_cast<ExpName*>((yyvsp[0].expr));
    entity_aspect_t* tmp = new entity_aspect_t(entity_aspect_t::CONFIGURATION, name);
    (yyval.entity_aspect) = tmp;
      }
#line 3304 "parse.cc"
    break;

  case 126: /* entity_aspect: K_open  */
#line 1087 "parse.y"
      {
    entity_aspect_t* tmp = new entity_aspect_t(entity_aspect_t::OPEN, 0);
    (yyval.entity_aspect) = tmp;
      }
#line 3313 "parse.cc"
    break;

  case 127: /* entity_aspect_opt: entity_aspect  */
#line 1094 "parse.y"
                  { (yyval.entity_aspect) = (yyvsp[0].entity_aspect); }
#line 3319 "parse.cc"
    break;

  case 128: /* entity_aspect_opt: %empty  */
#line 1095 "parse.y"
    { (yyval.entity_aspect) = 0; }
#line 3325 "parse.cc"
    break;

  case 129: /* entity_declaration: K_entity IDENTIFIER K_is generic_clause_opt port_clause_opt K_end K_entity_opt identifier_opt ';'  */
#line 1102 "parse.y"
      { Entity*tmp = new Entity(lex_strings.make((yyvsp[-7].text)));
	FILE_NAME(tmp, (yylsp[-8]));
	  // Transfer the ports
	tmp->set_interface((yyvsp[-5].interface_list), (yyvsp[-4].interface_list));
	delete (yyvsp[-5].interface_list);
	delete (yyvsp[-4].interface_list);
	  // Save the entity in the entity map.
	design_entities[tmp->get_name()] = tmp;
	delete[](yyvsp[-7].text);
	if((yyvsp[-1].text) && tmp->get_name() != (yyvsp[-1].text)) {
	      errormsg((yylsp[-8]), "Syntax error in entity clause. Closing name doesn't match.\n");
        }
        delete[](yyvsp[-1].text);
      }
#line 3344 "parse.cc"
    break;

  case 130: /* entity_declaration: K_entity error K_end K_entity_opt identifier_opt ';'  */
#line 1117 "parse.y"
      { errormsg((yylsp[-5]), "Too many errors, giving up on entity declaration.\n");
	yyerrok;
	if ((yyvsp[-1].text)) delete[](yyvsp[-1].text);
      }
#line 3353 "parse.cc"
    break;

  case 131: /* enumeration_literal: IDENTIFIER  */
#line 1125 "parse.y"
      { list<perm_string>*tmp = new list<perm_string>;
	tmp->push_back(lex_strings.make((yyvsp[0].text)));
	delete[](yyvsp[0].text);
	(yyval.name_list) = tmp;
      }
#line 3363 "parse.cc"
    break;

  case 132: /* enumeration_literal_list: enumeration_literal_list ',' enumeration_literal  */
#line 1134 "parse.y"
      { list<perm_string>*tmp = (yyvsp[-2].name_list);
	list<perm_string>*tmp3 = (yyvsp[0].name_list);
	if (tmp3) {
	      tmp->splice(tmp->end(), *tmp3);
	      delete tmp3;
	}
	(yyval.name_list) = tmp;
      }
#line 3376 "parse.cc"
    break;

  case 133: /* enumeration_literal_list: enumeration_literal  */
#line 1143 "parse.y"
      { list<perm_string>*tmp = (yyvsp[0].name_list);
	(yyval.name_list) = tmp;
      }
#line 3384 "parse.cc"
    break;

  case 134: /* expression_list: expression_list ',' expression  */
#line 1150 "parse.y"
      { list<Expression*>*tmp = (yyvsp[-2].expr_list);
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 3393 "parse.cc"
    break;

  case 135: /* expression_list: expression  */
#line 1155 "parse.y"
      { list<Expression*>*tmp = new list<Expression*>;
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 3402 "parse.cc"
    break;

  case 136: /* expression: expression_logical  */
#line 1163 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 3408 "parse.cc"
    break;

  case 137: /* expression: range  */
#line 1165 "parse.y"
      { (yyval.expr) = (yyvsp[0].range); }
#line 3414 "parse.cc"
    break;

  case 138: /* expression_logical: relation  */
#line 1192 "parse.y"
             { (yyval.expr) = (yyvsp[0].expr); }
#line 3420 "parse.cc"
    break;

  case 139: /* expression_logical: relation K_and expression_logical_and  */
#line 1194 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::AND, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3429 "parse.cc"
    break;

  case 140: /* expression_logical: relation K_or expression_logical_or  */
#line 1199 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::OR, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3438 "parse.cc"
    break;

  case 141: /* expression_logical: relation K_xor expression_logical_xor  */
#line 1204 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::XOR, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3447 "parse.cc"
    break;

  case 142: /* expression_logical: relation K_nand relation  */
#line 1209 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::NAND, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3456 "parse.cc"
    break;

  case 143: /* expression_logical: relation K_nor relation  */
#line 1214 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::NOR, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3465 "parse.cc"
    break;

  case 144: /* expression_logical: relation K_xnor expression_logical_xnor  */
#line 1219 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::XNOR, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3474 "parse.cc"
    break;

  case 145: /* expression_logical_and: relation  */
#line 1227 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 3480 "parse.cc"
    break;

  case 146: /* expression_logical_and: expression_logical_and K_and relation  */
#line 1229 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::AND, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3489 "parse.cc"
    break;

  case 147: /* expression_logical_or: relation  */
#line 1237 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 3495 "parse.cc"
    break;

  case 148: /* expression_logical_or: expression_logical_or K_or relation  */
#line 1239 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::OR, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3504 "parse.cc"
    break;

  case 149: /* expression_logical_xnor: relation  */
#line 1247 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 3510 "parse.cc"
    break;

  case 150: /* expression_logical_xnor: expression_logical_xnor K_xnor relation  */
#line 1249 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::XNOR, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3519 "parse.cc"
    break;

  case 151: /* expression_logical_xor: relation  */
#line 1257 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 3525 "parse.cc"
    break;

  case 152: /* expression_logical_xor: expression_logical_xor K_xor relation  */
#line 1259 "parse.y"
      { ExpLogical*tmp = new ExpLogical(ExpLogical::XOR, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3534 "parse.cc"
    break;

  case 153: /* factor: primary  */
#line 1267 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 3540 "parse.cc"
    break;

  case 154: /* factor: primary EXP primary  */
#line 1269 "parse.y"
      { ExpArithmetic*tmp = new ExpArithmetic(ExpArithmetic::POW, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3549 "parse.cc"
    break;

  case 155: /* factor: K_abs primary  */
#line 1274 "parse.y"
      { ExpUAbs*tmp = new ExpUAbs((yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3558 "parse.cc"
    break;

  case 156: /* factor: K_not primary  */
#line 1279 "parse.y"
      { ExpUNot*tmp = new ExpUNot((yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 3567 "parse.cc"
    break;

  case 157: /* file_declaration: K_file identifier_list ':' IDENTIFIER file_open_information_opt ';'  */
#line 1287 "parse.y"
      {
	if (strcasecmp((yyvsp[-2].text), "TEXT"))
	      sorrymsg((yylsp[-5]), "file declaration currently handles only TEXT type.\n");

	for (std::list<perm_string>::iterator cur = (yyvsp[-4].name_list)->begin()
		   ; cur != (yyvsp[-4].name_list)->end() ; ++cur) {
	      Variable*var = new Variable(*cur, &primitive_INTEGER);
	      FILE_NAME(var, (yylsp[-5]));
	      active_scope->bind_name(*cur, var);

	      // there was a file name specified, so it needs an implicit call
	      // to open it at the beginning of simulation and close it at the end
	      if((yyvsp[-1].file_info)) {
		std::list<Expression*> params;

		// add file_open() call in 'initial' block
		params.push_back(new ExpScopedName(active_scope->peek_name(), new ExpName(*cur)));
		params.push_back((yyvsp[-1].file_info)->filename()->clone());
		params.push_back((yyvsp[-1].file_info)->kind()->clone());
		ProcedureCall*fopen_call = new ProcedureCall(
                                    perm_string::literal("file_open"), &params);
		arc_scope->add_initializer(fopen_call);

		// add file_close() call in 'final' block
		params.clear();
		params.push_back(new ExpScopedName(active_scope->peek_name(), new ExpName(*cur)));
		ProcedureCall*fclose_call = new ProcedureCall(
                                    perm_string::literal("file_close"), &params);
		arc_scope->add_finalizer(fclose_call);

		delete (yyvsp[-1].file_info);
	      }
	}

	delete (yyvsp[-4].name_list);
      }
#line 3608 "parse.cc"
    break;

  case 158: /* file_declaration: K_file error ';'  */
#line 1324 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error in file declaration.\n");
	yyerrok;
      }
#line 3616 "parse.cc"
    break;

  case 159: /* file_open_information: K_open IDENTIFIER K_is STRING_LITERAL  */
#line 1331 "parse.y"
     {
        ExpName*mode = new ExpName(lex_strings.make((yyvsp[-2].text)));
        delete[](yyvsp[-2].text);
        FILE_NAME(mode, (yylsp[-3]));
        (yyval.file_info) = new file_open_info_t(new ExpString((yyvsp[0].text)), mode);
     }
#line 3627 "parse.cc"
    break;

  case 160: /* file_open_information: K_is STRING_LITERAL  */
#line 1338 "parse.y"
     {
        (yyval.file_info) = new file_open_info_t(new ExpString((yyvsp[0].text)));
     }
#line 3635 "parse.cc"
    break;

  case 161: /* file_open_information_opt: file_open_information  */
#line 1343 "parse.y"
                          { (yyval.file_info) = (yyvsp[0].file_info); }
#line 3641 "parse.cc"
    break;

  case 162: /* file_open_information_opt: %empty  */
#line 1344 "parse.y"
    { (yyval.file_info) = 0; }
#line 3647 "parse.cc"
    break;

  case 163: /* for_generate_statement: IDENTIFIER ':' K_for IDENTIFIER K_in range K_generate generate_statement_body K_end K_generate identifier_opt ';'  */
#line 1351 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-11].text));
	perm_string gvar = lex_strings.make((yyvsp[-8].text));
	ForGenerate*tmp = new ForGenerate(name, gvar, (yyvsp[-6].range), *(yyvsp[-4].arch_statement_list));
	FILE_NAME(tmp, (yylsp[-11]));

	if ((yyvsp[-1].text) && name != (yyvsp[-1].text)) {
	      errormsg((yylsp[-11]), "for-generate name %s does not match closing name %s\n",
		       name.str(), (yyvsp[-1].text));
	}
	delete[](yyvsp[-11].text);
	delete[](yyvsp[-8].text);
	delete (yyvsp[-4].arch_statement_list);
	delete[](yyvsp[-1].text);
	(yyval.arch_statement) = tmp;
      }
#line 3667 "parse.cc"
    break;

  case 164: /* function_specification: K_function IDENTIFIER parameter_list K_return IDENTIFIER  */
#line 1370 "parse.y"
      { perm_string type_name = lex_strings.make((yyvsp[0].text));
	perm_string name = lex_strings.make((yyvsp[-3].text));
	const VType*type_mark = active_scope->find_type(type_name);
	touchup_interface_for_functions((yyvsp[-2].interface_list));
	SubprogramHeader*tmp = new SubprogramHeader(name, (yyvsp[-2].interface_list), type_mark);
	FILE_NAME(tmp, (yylsp[-4]));
	delete[](yyvsp[-3].text);
	delete[](yyvsp[0].text);
	(yyval.subprogram) = tmp;
      }
#line 3682 "parse.cc"
    break;

  case 167: /* generate_statement_body: architecture_statement_part  */
#line 1388 "parse.y"
                                { (yyval.arch_statement_list) = (yyvsp[0].arch_statement_list); }
#line 3688 "parse.cc"
    break;

  case 168: /* generic_clause_opt: generic_clause  */
#line 1393 "parse.y"
      { (yyval.interface_list) = (yyvsp[0].interface_list);}
#line 3694 "parse.cc"
    break;

  case 169: /* generic_clause_opt: %empty  */
#line 1395 "parse.y"
      { (yyval.interface_list) = 0; }
#line 3700 "parse.cc"
    break;

  case 170: /* generic_clause: K_generic parameter_list ';'  */
#line 1400 "parse.y"
      { (yyval.interface_list) = (yyvsp[-1].interface_list); }
#line 3706 "parse.cc"
    break;

  case 171: /* generic_clause: K_generic '(' error ')' ';'  */
#line 1402 "parse.y"
      { errormsg((yylsp[-2]), "Error in interface list for generic.\n");
	yyerrok;
	(yyval.interface_list) = 0;
      }
#line 3715 "parse.cc"
    break;

  case 172: /* generic_map_aspect_opt: generic_map_aspect  */
#line 1409 "parse.y"
                       { (yyval.named_expr_list) = (yyvsp[0].named_expr_list); }
#line 3721 "parse.cc"
    break;

  case 173: /* generic_map_aspect_opt: %empty  */
#line 1410 "parse.y"
                       { (yyval.named_expr_list) = 0; }
#line 3727 "parse.cc"
    break;

  case 174: /* generic_map_aspect: K_generic K_map '(' association_list ')'  */
#line 1415 "parse.y"
      { (yyval.named_expr_list) = (yyvsp[-1].named_expr_list); }
#line 3733 "parse.cc"
    break;

  case 175: /* generic_map_aspect: K_generic K_map '(' error ')'  */
#line 1417 "parse.y"
      { errormsg((yylsp[-1]), "Error in association list for generic map.\n");
	yyerrok;
	(yyval.named_expr_list) = 0;
      }
#line 3742 "parse.cc"
    break;

  case 176: /* identifier_list: identifier_list ',' IDENTIFIER  */
#line 1425 "parse.y"
      { std::list<perm_string>* tmp = (yyvsp[-2].name_list);
	tmp->push_back(lex_strings.make((yyvsp[0].text)));
	delete[](yyvsp[0].text);
	(yyval.name_list) = tmp;
      }
#line 3752 "parse.cc"
    break;

  case 177: /* identifier_list: IDENTIFIER  */
#line 1431 "parse.y"
      { std::list<perm_string>*tmp = new std::list<perm_string>;
	tmp->push_back(lex_strings.make((yyvsp[0].text)));
	delete[](yyvsp[0].text);
	(yyval.name_list) = tmp;
      }
#line 3762 "parse.cc"
    break;

  case 178: /* identifier_opt: IDENTIFIER  */
#line 1438 "parse.y"
                            { (yyval.text) = (yyvsp[0].text); }
#line 3768 "parse.cc"
    break;

  case 179: /* identifier_opt: %empty  */
#line 1438 "parse.y"
                                           { (yyval.text) = 0; }
#line 3774 "parse.cc"
    break;

  case 180: /* identifier_colon_opt: IDENTIFIER ':'  */
#line 1440 "parse.y"
                                      { (yyval.text) = (yyvsp[-1].text); }
#line 3780 "parse.cc"
    break;

  case 181: /* identifier_colon_opt: %empty  */
#line 1440 "parse.y"
                                                     { (yyval.text) = 0; }
#line 3786 "parse.cc"
    break;

  case 182: /* if_generate_statement: IDENTIFIER ':' K_if expression K_generate generate_statement_body K_end K_generate identifier_opt ';'  */
#line 1450 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-9].text));
	IfGenerate*tmp = new IfGenerate(name, (yyvsp[-6].expr), *(yyvsp[-4].arch_statement_list));
	FILE_NAME(tmp, (yylsp[-7]));

	if ((yyvsp[-1].text) && name != (yyvsp[-1].text)) {
	      errormsg((yylsp[-9]), "if-generate name %s does not match closing name %s\n",
		       name.str(), (yyvsp[-1].text));
	}
	delete[](yyvsp[-9].text);
	delete  (yyvsp[-4].arch_statement_list);
	delete[](yyvsp[-1].text);
	(yyval.arch_statement) = tmp;
      }
#line 3804 "parse.cc"
    break;

  case 183: /* if_statement: K_if expression K_then sequence_of_statements if_statement_elsif_list_opt if_statement_else K_end K_if ';'  */
#line 1469 "parse.y"
      { IfSequential*tmp = new IfSequential((yyvsp[-7].expr), (yyvsp[-5].sequ_list), (yyvsp[-4].elsif_list), (yyvsp[-3].sequ_list));
	FILE_NAME(tmp, (yylsp[-8]));
	delete (yyvsp[-5].sequ_list);
	delete (yyvsp[-4].elsif_list);
	delete (yyvsp[-3].sequ_list);
	(yyval.sequ) = tmp;
      }
#line 3816 "parse.cc"
    break;

  case 184: /* if_statement: K_if error K_then sequence_of_statements if_statement_elsif_list_opt if_statement_else K_end K_if ';'  */
#line 1480 "parse.y"
      { errormsg((yylsp[-7]), "Error in if_statement condition expression.\n");
	yyerrok;
	(yyval.sequ) = 0;
	delete (yyvsp[-5].sequ_list);
      }
#line 3826 "parse.cc"
    break;

  case 185: /* if_statement: K_if expression K_then error K_end K_if ';'  */
#line 1487 "parse.y"
      { errormsg((yylsp[-3]), "Too many errors in sequence within if_statement.\n");
	yyerrok;
	(yyval.sequ) = 0;
      }
#line 3835 "parse.cc"
    break;

  case 186: /* if_statement: K_if error K_end K_if ';'  */
#line 1493 "parse.y"
      { errormsg((yylsp[-3]), "Too many errors in if_statement.\n");
	yyerrok;
	(yyval.sequ) = 0;
      }
#line 3844 "parse.cc"
    break;

  case 187: /* if_statement_elsif_list_opt: if_statement_elsif_list  */
#line 1500 "parse.y"
                            { (yyval.elsif_list) = (yyvsp[0].elsif_list); }
#line 3850 "parse.cc"
    break;

  case 188: /* if_statement_elsif_list_opt: %empty  */
#line 1501 "parse.y"
                            { (yyval.elsif_list) = 0;  }
#line 3856 "parse.cc"
    break;

  case 189: /* if_statement_elsif_list: if_statement_elsif_list if_statement_elsif  */
#line 1506 "parse.y"
      { list<IfSequential::Elsif*>*tmp = (yyvsp[-1].elsif_list);
	tmp->push_back((yyvsp[0].elsif));
	(yyval.elsif_list) = tmp;
      }
#line 3865 "parse.cc"
    break;

  case 190: /* if_statement_elsif_list: if_statement_elsif  */
#line 1511 "parse.y"
      { list<IfSequential::Elsif*>*tmp = new list<IfSequential::Elsif*>;
	tmp->push_back((yyvsp[0].elsif));
	(yyval.elsif_list) = tmp;
      }
#line 3874 "parse.cc"
    break;

  case 191: /* if_statement_elsif: K_elsif expression K_then sequence_of_statements  */
#line 1519 "parse.y"
      { IfSequential::Elsif*tmp = new IfSequential::Elsif((yyvsp[-2].expr), (yyvsp[0].sequ_list));
	FILE_NAME(tmp, (yylsp[-3]));
	delete (yyvsp[0].sequ_list);
	(yyval.elsif) = tmp;
      }
#line 3884 "parse.cc"
    break;

  case 192: /* if_statement_elsif: K_elsif expression K_then error  */
#line 1525 "parse.y"
      { errormsg((yylsp[0]), "Too many errors in elsif sub-statements.\n");
	yyerrok;
	(yyval.elsif) = 0;
      }
#line 3893 "parse.cc"
    break;

  case 193: /* if_statement_else: K_else sequence_of_statements  */
#line 1533 "parse.y"
      { (yyval.sequ_list) = (yyvsp[0].sequ_list); }
#line 3899 "parse.cc"
    break;

  case 194: /* if_statement_else: K_else error  */
#line 1535 "parse.y"
      { errormsg((yylsp[0]), "Too many errors in else sub-statements.\n");
	yyerrok;
	(yyval.sequ_list) = 0;
      }
#line 3908 "parse.cc"
    break;

  case 195: /* if_statement_else: %empty  */
#line 1540 "parse.y"
      { (yyval.sequ_list) = 0; }
#line 3914 "parse.cc"
    break;

  case 196: /* index_constraint: '(' range_list ')'  */
#line 1545 "parse.y"
      { (yyval.range_list) = (yyvsp[-1].range_list); }
#line 3920 "parse.cc"
    break;

  case 197: /* index_constraint: '(' error ')'  */
#line 1547 "parse.y"
      { errormsg((yylsp[-1]), "Errors in the index constraint.\n");
	yyerrok;
	(yyval.range_list) = new list<ExpRange*>;
      }
#line 3929 "parse.cc"
    break;

  case 201: /* instantiation_list: identifier_list  */
#line 1565 "parse.y"
     {
  instant_list_t* tmp = new instant_list_t(instant_list_t::NO_DOMAIN, (yyvsp[0].name_list));
  (yyval.instantiation_list) = tmp;
     }
#line 3938 "parse.cc"
    break;

  case 202: /* instantiation_list: K_others  */
#line 1570 "parse.y"
     {
  instant_list_t* tmp = new instant_list_t(instant_list_t::OTHERS, 0);
  (yyval.instantiation_list) = tmp;
     }
#line 3947 "parse.cc"
    break;

  case 203: /* instantiation_list: K_all  */
#line 1575 "parse.y"
   {
  instant_list_t* tmp = new instant_list_t(instant_list_t::ALL, 0);
  (yyval.instantiation_list) = tmp;
   }
#line 3956 "parse.cc"
    break;

  case 204: /* interface_element: identifier_list ':' mode_opt subtype_indication interface_element_expression  */
#line 1584 "parse.y"
      { std::list<InterfacePort*>*tmp = new std::list<InterfacePort*>;
	for (std::list<perm_string>::iterator cur = (yyvsp[-4].name_list)->begin()
		   ; cur != (yyvsp[-4].name_list)->end() ; ++cur) {
	      InterfacePort*port = new InterfacePort;
	      FILE_NAME(port, (yylsp[-4]));
	      port->mode = (yyvsp[-2].port_mode);
	      port->name = *(cur);
	      port->type = (yyvsp[-1].vtype);
	      port->expr = (yyvsp[0].expr);
	      tmp->push_back(port);
	}
	delete (yyvsp[-4].name_list);
	(yyval.interface_list) = tmp;
      }
#line 3975 "parse.cc"
    break;

  case 205: /* interface_element_expression: VASSIGN expression  */
#line 1601 "parse.y"
                       { (yyval.expr) = (yyvsp[0].expr); }
#line 3981 "parse.cc"
    break;

  case 206: /* interface_element_expression: %empty  */
#line 1602 "parse.y"
                       { (yyval.expr) = 0; }
#line 3987 "parse.cc"
    break;

  case 207: /* interface_list: interface_list ';' interface_element  */
#line 1607 "parse.y"
      { std::list<InterfacePort*>*tmp = (yyvsp[-2].interface_list);
	tmp->splice(tmp->end(), *(yyvsp[0].interface_list));
	delete (yyvsp[0].interface_list);
	(yyval.interface_list) = tmp;
      }
#line 3997 "parse.cc"
    break;

  case 208: /* interface_list: interface_element  */
#line 1613 "parse.y"
      { std::list<InterfacePort*>*tmp = (yyvsp[0].interface_list);
	(yyval.interface_list) = tmp;
      }
#line 4005 "parse.cc"
    break;

  case 209: /* library_clause: K_library logical_name_list ';'  */
#line 1620 "parse.y"
      { library_import((yylsp[-2]), (yyvsp[-1].name_list));
	delete (yyvsp[-1].name_list);
      }
#line 4013 "parse.cc"
    break;

  case 210: /* library_clause: K_library error ';'  */
#line 1624 "parse.y"
     { errormsg((yylsp[-2]), "Syntax error in library clause.\n"); yyerrok; }
#line 4019 "parse.cc"
    break;

  case 213: /* logical_name: IDENTIFIER  */
#line 1634 "parse.y"
                          { (yyval.text) = (yyvsp[0].text); }
#line 4025 "parse.cc"
    break;

  case 214: /* logical_name_list: logical_name_list ',' logical_name  */
#line 1638 "parse.y"
      { std::list<perm_string>*tmp = (yyvsp[-2].name_list);
	tmp->push_back(lex_strings.make((yyvsp[0].text)));
	delete[](yyvsp[0].text);
	(yyval.name_list) = tmp;
      }
#line 4035 "parse.cc"
    break;

  case 215: /* logical_name_list: logical_name  */
#line 1644 "parse.y"
      { std::list<perm_string>*tmp = new std::list<perm_string>;
	tmp->push_back(lex_strings.make((yyvsp[0].text)));
	delete[](yyvsp[0].text);
	(yyval.name_list) = tmp;
      }
#line 4045 "parse.cc"
    break;

  case 216: /* loop_statement: identifier_colon_opt K_while expression_logical K_loop sequence_of_statements K_end K_loop identifier_opt ';'  */
#line 1656 "parse.y"
      { perm_string loop_name = (yyvsp[-8].text)? lex_strings.make((yyvsp[-8].text)) : perm_string() ;
	if ((yyvsp[-1].text) && !(yyvsp[-8].text)) {
	      errormsg((yylsp[-1]), "Loop statement closing name %s for un-named statement\n", (yyvsp[-1].text));
	} else if((yyvsp[-1].text) && loop_name != (yyvsp[-1].text)) {
	      errormsg((yylsp[-8]), "Loop statement name %s doesn't match closing name %s.\n", loop_name.str(), (yyvsp[-1].text));
	}
	if((yyvsp[-8].text)) delete[](yyvsp[-8].text);
	if((yyvsp[-1].text)) delete[](yyvsp[-1].text);

	WhileLoopStatement* tmp = new WhileLoopStatement(loop_name, (yyvsp[-6].expr), (yyvsp[-4].sequ_list));
	FILE_NAME(tmp, (yylsp[-8]));
	(yyval.sequ) = tmp;
      }
#line 4063 "parse.cc"
    break;

  case 217: /* loop_statement: identifier_colon_opt K_for IDENTIFIER K_in range K_loop sequence_of_statements K_end K_loop identifier_opt ';'  */
#line 1673 "parse.y"
      { perm_string loop_name = (yyvsp[-10].text)? lex_strings.make((yyvsp[-10].text)) : perm_string() ;
	perm_string index_name = lex_strings.make((yyvsp[-8].text));
	if ((yyvsp[-1].text) && !(yyvsp[-10].text)) {
	      errormsg((yylsp[-1]), "Loop statement closing name %s for un-named statement\n", (yyvsp[-1].text));
	} else if((yyvsp[-1].text) && loop_name != (yyvsp[-1].text)) {
	      errormsg((yylsp[-10]), "Loop statement name %s doesn't match closing name %s.\n", loop_name.str(), (yyvsp[-1].text));
	}
	if((yyvsp[-10].text))  delete[] (yyvsp[-10].text);
	delete[] (yyvsp[-8].text);
	if((yyvsp[-1].text)) delete[] (yyvsp[-1].text);

	ForLoopStatement* tmp = new ForLoopStatement(loop_name, index_name, (yyvsp[-6].range), (yyvsp[-4].sequ_list));
	FILE_NAME(tmp, (yylsp[-10]));
	(yyval.sequ) = tmp;
      }
#line 4083 "parse.cc"
    break;

  case 218: /* loop_statement: identifier_colon_opt K_loop sequence_of_statements K_end K_loop identifier_opt ';'  */
#line 1691 "parse.y"
      { perm_string loop_name = (yyvsp[-6].text)? lex_strings.make((yyvsp[-6].text)) : perm_string() ;
	if ((yyvsp[-1].text) && !(yyvsp[-6].text)) {
	      errormsg((yylsp[-1]), "Loop statement closing name %s for un-named statement\n", (yyvsp[-1].text));
	} else if((yyvsp[-1].text) && loop_name != (yyvsp[-1].text)) {
	      errormsg((yylsp[-6]), "Loop statement name %s doesn't match closing name %s.\n", loop_name.str(), (yyvsp[-1].text));
	}
	if((yyvsp[-6].text)) delete[](yyvsp[-6].text);
	if((yyvsp[-1].text)) delete[](yyvsp[-1].text);

	BasicLoopStatement* tmp = new BasicLoopStatement(loop_name, (yyvsp[-4].sequ_list));
	FILE_NAME(tmp, (yylsp[-5]));

	(yyval.sequ) = tmp;
      }
#line 4102 "parse.cc"
    break;

  case 219: /* mode: K_in  */
#line 1707 "parse.y"
          { (yyval.port_mode) = PORT_IN; }
#line 4108 "parse.cc"
    break;

  case 220: /* mode: K_out  */
#line 1708 "parse.y"
          { (yyval.port_mode) = PORT_OUT; }
#line 4114 "parse.cc"
    break;

  case 221: /* mode: K_inout  */
#line 1709 "parse.y"
            { (yyval.port_mode) = PORT_INOUT; }
#line 4120 "parse.cc"
    break;

  case 222: /* mode_opt: mode  */
#line 1712 "parse.y"
                {(yyval.port_mode) = (yyvsp[0].port_mode);}
#line 4126 "parse.cc"
    break;

  case 223: /* mode_opt: %empty  */
#line 1712 "parse.y"
                             {(yyval.port_mode) = PORT_NONE;}
#line 4132 "parse.cc"
    break;

  case 224: /* name: IDENTIFIER  */
#line 1716 "parse.y"
      { Expression*tmp;
        /* Check if the IDENTIFIER is one of CHARACTER enums (LF, CR, etc.) */
        tmp = parse_char_enums((yyvsp[0].text));
        if(!tmp) {
            perm_string name = lex_strings.make((yyvsp[0].text));
            /* There are functions that have the same name types, e.g. integer */
            if(!active_scope->find_subprogram(name).empty() && !parse_type_by_name(name))
                tmp = new ExpFunc(name);
            else
                tmp = new ExpName(name);
        }
        FILE_NAME(tmp, (yylsp[0]));
        delete[](yyvsp[0].text);
        (yyval.expr) = tmp;
      }
#line 4152 "parse.cc"
    break;

  case 225: /* name: selected_name  */
#line 1733 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 4158 "parse.cc"
    break;

  case 226: /* name: indexed_name  */
#line 1736 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 4164 "parse.cc"
    break;

  case 227: /* name: selected_name '(' expression_list ')'  */
#line 1739 "parse.y"
    {
        ExpName*name = dynamic_cast<ExpName*>((yyvsp[-3].expr));
        assert(name);
        name->add_index((yyvsp[-1].expr_list));
        delete (yyvsp[-1].expr_list);  // contents of the list is moved to the selected_name
    }
#line 4175 "parse.cc"
    break;

  case 228: /* indexed_name: IDENTIFIER '(' expression_list ')'  */
#line 1753 "parse.y"
      { Expression*tmp;
        perm_string name = lex_strings.make((yyvsp[-3].text));
        delete[](yyvsp[-3].text);
        if (active_scope->is_vector_name(name) || is_subprogram_param(name))
            tmp = new ExpName(name, (yyvsp[-1].expr_list));
        else
            tmp = new ExpFunc(name, (yyvsp[-1].expr_list));
        FILE_NAME(tmp, (yylsp[-3]));
        (yyval.expr) = tmp;
      }
#line 4190 "parse.cc"
    break;

  case 229: /* indexed_name: indexed_name '(' expression_list ')'  */
#line 1764 "parse.y"
      { ExpName*name = dynamic_cast<ExpName*>((yyvsp[-3].expr));
        assert(name);
        name->add_index((yyvsp[-1].expr_list));
        (yyval.expr) = (yyvsp[-3].expr);
      }
#line 4200 "parse.cc"
    break;

  case 230: /* name_list: name_list ',' name  */
#line 1774 "parse.y"
      { std::list<Expression*>*tmp = (yyvsp[-2].expr_list);
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 4209 "parse.cc"
    break;

  case 231: /* name_list: name  */
#line 1779 "parse.y"
      { std::list<Expression*>*tmp = new std::list<Expression*>;
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 4218 "parse.cc"
    break;

  case 232: /* package_declaration: package_declaration_start K_is package_declarative_part_opt K_end K_package_opt identifier_opt ';'  */
#line 1789 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-6].text));
	if((yyvsp[-1].text) && name != (yyvsp[-1].text)) {
	      errormsg((yylsp[-6]), "Identifier %s doesn't match package name %s.\n",
		       (yyvsp[-1].text), name.str());
        }
	Package*tmp = new Package(name, *active_scope);
	FILE_NAME(tmp, (yylsp[-6]));
	delete[](yyvsp[-6].text);
        if ((yyvsp[-1].text)) delete[](yyvsp[-1].text);
	pop_scope();
	  /* Put this package into the work library, or the currently
	     parsed library. Note that parse_library_name is an
	     argument to the parser. */
	library_save_package(parse_library_name, tmp);
      }
#line 4238 "parse.cc"
    break;

  case 233: /* package_declaration: package_declaration_start K_is error K_end K_package_opt identifier_opt ';'  */
#line 1805 "parse.y"
    { errormsg((yylsp[-4]), "Syntax error in package clause.\n");
      yyerrok;
      pop_scope();
    }
#line 4247 "parse.cc"
    break;

  case 234: /* package_declaration_start: K_package IDENTIFIER  */
#line 1813 "parse.y"
      { push_scope();
	(yyval.text) = (yyvsp[0].text);
      }
#line 4255 "parse.cc"
    break;

  case 247: /* package_declarative_item: error ';'  */
#line 1842 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error in package declarative item.\n");
	yyerrok;
      }
#line 4263 "parse.cc"
    break;

  case 252: /* package_body: package_body_start K_is package_body_declarative_part_opt K_end K_package_opt identifier_opt ';'  */
#line 1861 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-6].text));
	if ((yyvsp[-1].text) && name != (yyvsp[-1].text))
	      errormsg((yylsp[-1]), "Package name (%s) doesn't match closing name (%s).\n", (yyvsp[-6].text), (yyvsp[-1].text));
	delete[] (yyvsp[-6].text);
	if((yyvsp[-1].text)) delete[](yyvsp[-1].text);
	pop_scope();
      }
#line 4275 "parse.cc"
    break;

  case 253: /* package_body: package_body_start K_is error K_end K_package_opt identifier_opt ';'  */
#line 1870 "parse.y"
      { errormsg((yylsp[-6]), "Errors in package %s body.\n", (yyvsp[-6].text));
	yyerrok;
	pop_scope();
      }
#line 4284 "parse.cc"
    break;

  case 254: /* package_body_start: K_package K_body IDENTIFIER  */
#line 1882 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[0].text));
	push_scope();
	Package*pkg = library_recall_package(parse_library_name, name);
	if (pkg != 0) {
	      active_scope->set_package_header(pkg);
	} else {
	      errormsg((yylsp[-2]), "Package body for %s has no matching header.\n", (yyvsp[0].text));
	}
	(yyval.text) = (yyvsp[0].text);
      }
#line 4299 "parse.cc"
    break;

  case 255: /* parameter_list: '(' interface_list ')'  */
#line 1895 "parse.y"
                           { (yyval.interface_list) = (yyvsp[-1].interface_list); }
#line 4305 "parse.cc"
    break;

  case 256: /* parameter_list_opt: parameter_list  */
#line 1899 "parse.y"
                    { (yyval.interface_list) = (yyvsp[0].interface_list); }
#line 4311 "parse.cc"
    break;

  case 257: /* parameter_list_opt: %empty  */
#line 1900 "parse.y"
                    { (yyval.interface_list) = 0; }
#line 4317 "parse.cc"
    break;

  case 258: /* port_clause: K_port parameter_list ';'  */
#line 1905 "parse.y"
      { (yyval.interface_list) = (yyvsp[-1].interface_list); }
#line 4323 "parse.cc"
    break;

  case 259: /* port_clause: K_port '(' error ')' ';'  */
#line 1907 "parse.y"
      { errormsg((yylsp[-4]), "Syntax error in port list.\n");
	yyerrok;
	(yyval.interface_list) = 0;
      }
#line 4332 "parse.cc"
    break;

  case 260: /* port_clause_opt: port_clause  */
#line 1913 "parse.y"
                              {(yyval.interface_list) = (yyvsp[0].interface_list);}
#line 4338 "parse.cc"
    break;

  case 261: /* port_clause_opt: %empty  */
#line 1913 "parse.y"
                                           {(yyval.interface_list) = 0;}
#line 4344 "parse.cc"
    break;

  case 262: /* port_map_aspect: K_port K_map '(' association_list ')'  */
#line 1917 "parse.y"
      { (yyval.named_expr_list) = (yyvsp[-1].named_expr_list); }
#line 4350 "parse.cc"
    break;

  case 263: /* port_map_aspect: K_port K_map '(' error ')'  */
#line 1919 "parse.y"
      { errormsg((yylsp[-4]), "Syntax error in port map aspect.\n");
	yyerrok;
      }
#line 4358 "parse.cc"
    break;

  case 264: /* port_map_aspect_opt: port_map_aspect  */
#line 1925 "parse.y"
                     { (yyval.named_expr_list) = (yyvsp[0].named_expr_list); }
#line 4364 "parse.cc"
    break;

  case 265: /* port_map_aspect_opt: %empty  */
#line 1926 "parse.y"
                     { (yyval.named_expr_list) = 0; }
#line 4370 "parse.cc"
    break;

  case 266: /* prefix: name  */
#line 1932 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 4376 "parse.cc"
    break;

  case 267: /* primary: name  */
#line 1937 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 4382 "parse.cc"
    break;

  case 268: /* primary: name '\'' IDENTIFIER argument_list_opt  */
#line 1939 "parse.y"
      { ExpAttribute*tmp = NULL;
	perm_string attr = lex_strings.make((yyvsp[-1].text));
	ExpName*base = dynamic_cast<ExpName*>((yyvsp[-3].expr));
	const VType*type = parse_type_by_name(base->peek_name());

	if(type) {
	    tmp = new ExpTypeAttribute(type, attr, (yyvsp[0].expr_list));
	} else {
	    tmp = new ExpObjAttribute(base, attr, (yyvsp[0].expr_list));
	}

	FILE_NAME(tmp, (yylsp[-3]));
	delete[](yyvsp[-1].text);
	(yyval.expr) = tmp;
      }
#line 4402 "parse.cc"
    break;

  case 269: /* primary: CHARACTER_LITERAL  */
#line 1955 "parse.y"
      { ExpCharacter*tmp = new ExpCharacter((yyvsp[0].text)[0]);
	FILE_NAME(tmp,(yylsp[0]));
	delete[](yyvsp[0].text);
	(yyval.expr) = tmp;
      }
#line 4412 "parse.cc"
    break;

  case 270: /* primary: INT_LITERAL  */
#line 1961 "parse.y"
      { ExpInteger*tmp = new ExpInteger((yyvsp[0].uni_integer));
	FILE_NAME(tmp, (yylsp[0]));
	(yyval.expr) = tmp;
      }
#line 4421 "parse.cc"
    break;

  case 271: /* primary: REAL_LITERAL  */
#line 1966 "parse.y"
      { ExpReal*tmp = new ExpReal((yyvsp[0].uni_real));
	FILE_NAME(tmp, (yylsp[0]));
	(yyval.expr) = tmp;
      }
#line 4430 "parse.cc"
    break;

  case 272: /* primary: STRING_LITERAL  */
#line 1971 "parse.y"
      { ExpString*tmp = new ExpString((yyvsp[0].text));
	FILE_NAME(tmp,(yylsp[0]));
	delete[](yyvsp[0].text);
	(yyval.expr) = tmp;
      }
#line 4440 "parse.cc"
    break;

  case 273: /* primary: BITSTRING_LITERAL  */
#line 1977 "parse.y"
      { ExpBitstring*tmp = new ExpBitstring((yyvsp[0].text));
	FILE_NAME(tmp, (yylsp[0]));
	delete[](yyvsp[0].text);
	(yyval.expr) = tmp;
      }
#line 4450 "parse.cc"
    break;

  case 274: /* primary: INT_LITERAL IDENTIFIER  */
#line 1983 "parse.y"
      { ExpTime::timeunit_t unit = ExpTime::FS;

        if(!strcasecmp((yyvsp[0].text), "us"))
            unit = ExpTime::US;
        else if(!strcasecmp((yyvsp[0].text), "ms"))
            unit = ExpTime::MS;
        else if(!strcasecmp((yyvsp[0].text), "ns"))
            unit = ExpTime::NS;
        else if(!strcasecmp((yyvsp[0].text), "s"))
            unit = ExpTime::S;
        else if(!strcasecmp((yyvsp[0].text), "ps"))
            unit = ExpTime::PS;
        else if(!strcasecmp((yyvsp[0].text), "fs"))
            unit = ExpTime::FS;
        else
            errormsg((yylsp[0]), "Invalid time unit (accepted are fs, ps, ns, us, ms, s).\n");

        if((yyvsp[-1].uni_integer) < 0)
            errormsg((yylsp[-1]), "Time cannot be negative.\n");

        ExpTime*tmp = new ExpTime((yyvsp[-1].uni_integer), unit);
        FILE_NAME(tmp, (yylsp[-1]));
        delete[] (yyvsp[0].text);
        (yyval.expr) = tmp;
      }
#line 4480 "parse.cc"
    break;

  case 275: /* primary: IDENTIFIER '(' association_list ')'  */
#line 2018 "parse.y"
      { sorrymsg((yylsp[-3]), "Function calls not supported\n");
	delete[] (yyvsp[-3].text);
	(yyval.expr) = 0;
      }
#line 4489 "parse.cc"
    break;

  case 276: /* primary: '(' element_association_list ')'  */
#line 2026 "parse.y"
      { Expression*tmp = aggregate_or_primary((yylsp[-2]), (yyvsp[-1].element_list));
	(yyval.expr) = tmp;
      }
#line 4497 "parse.cc"
    break;

  case 280: /* procedure_call: IDENTIFIER ';'  */
#line 2039 "parse.y"
      {
    ProcedureCall* tmp = new ProcedureCall(lex_strings.make((yyvsp[-1].text)));
    FILE_NAME(tmp, (yylsp[-1]));
    delete[] (yyvsp[-1].text);
    (yyval.sequ) = tmp;
      }
#line 4508 "parse.cc"
    break;

  case 281: /* procedure_call: IDENTIFIER '(' association_list ')' ';'  */
#line 2046 "parse.y"
      {
    ProcedureCall* tmp = new ProcedureCall(lex_strings.make((yyvsp[-4].text)), (yyvsp[-2].named_expr_list));
    FILE_NAME(tmp, (yylsp[-4]));
    delete[] (yyvsp[-4].text);
    (yyval.sequ) = tmp;
      }
#line 4519 "parse.cc"
    break;

  case 282: /* procedure_call: IDENTIFIER argument_list ';'  */
#line 2053 "parse.y"
      {
    ProcedureCall* tmp = new ProcedureCall(lex_strings.make((yyvsp[-2].text)), (yyvsp[-1].expr_list));
    FILE_NAME(tmp, (yylsp[-2]));
    delete[] (yyvsp[-2].text);
    delete (yyvsp[-1].expr_list); // parameters are copied in this variant
    (yyval.sequ) = tmp;
      }
#line 4531 "parse.cc"
    break;

  case 283: /* procedure_call: IDENTIFIER '(' error ')' ';'  */
#line 2061 "parse.y"
      { errormsg((yylsp[-4]), "Errors in procedure call.\n");
	yyerrok;
	delete[](yyvsp[-4].text);
	(yyval.sequ) = 0;
      }
#line 4541 "parse.cc"
    break;

  case 284: /* procedure_call_statement: IDENTIFIER ':' procedure_call  */
#line 2070 "parse.y"
      { delete[] (yyvsp[-2].text);
	(yyval.sequ) = (yyvsp[0].sequ);
      }
#line 4549 "parse.cc"
    break;

  case 285: /* procedure_call_statement: procedure_call  */
#line 2073 "parse.y"
                   { (yyval.sequ) = (yyvsp[0].sequ); }
#line 4555 "parse.cc"
    break;

  case 286: /* procedure_specification: K_procedure IDENTIFIER parameter_list_opt  */
#line 2078 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-1].text));
	touchup_interface_for_functions((yyvsp[0].interface_list));
	SubprogramHeader*tmp = new SubprogramHeader(name, (yyvsp[0].interface_list), NULL);
	FILE_NAME(tmp, (yylsp[-2]));
	delete[](yyvsp[-1].text);
	(yyval.subprogram) = tmp;
      }
#line 4567 "parse.cc"
    break;

  case 293: /* process_start: identifier_colon_opt K_postponed_opt K_process  */
#line 2104 "parse.y"
       { push_scope();
         (yyval.text) = (yyvsp[-2].text);
       }
#line 4575 "parse.cc"
    break;

  case 294: /* process_statement: process_start process_sensitivity_list_opt K_is_opt process_declarative_part_opt K_begin sequence_of_statements K_end K_postponed_opt K_process identifier_opt ';'  */
#line 2114 "parse.y"
      { perm_string iname = (yyvsp[-10].text)? lex_strings.make((yyvsp[-10].text)) : empty_perm_string;
	if ((yyvsp[-10].text)) delete[](yyvsp[-10].text);
	if ((yyvsp[-1].text)) {
	      if (iname.nil()) {
		    errormsg((yylsp[-1]), "Process end name %s for un-named processes.\n", (yyvsp[-1].text));
	      } else if (iname != (yyvsp[-1].text)) {
		    errormsg((yylsp[-1]), "Process name %s does not match opening name %s.\n",
			     (yyvsp[-1].text), (yyvsp[-10].text));
	      }
	      delete[](yyvsp[-1].text);
	}

	ProcessStatement*tmp = new ProcessStatement(iname, *active_scope, (yyvsp[-9].expr_list), (yyvsp[-5].sequ_list));
        arc_scope->bind_scope(tmp->peek_name(), tmp);
        pop_scope();
	FILE_NAME(tmp, (yylsp[-8]));
	delete (yyvsp[-9].expr_list);
	delete (yyvsp[-5].sequ_list);
	(yyval.arch_statement) = tmp;
      }
#line 4600 "parse.cc"
    break;

  case 295: /* process_statement: process_start process_sensitivity_list_opt K_is_opt process_declarative_part_opt K_begin error K_end K_postponed_opt K_process identifier_opt ';'  */
#line 2139 "parse.y"
      { errormsg((yylsp[-4]), "Too many errors in process sequential statements.\n");
	yyerrok;
	(yyval.arch_statement) = 0;
      }
#line 4609 "parse.cc"
    break;

  case 296: /* process_sensitivity_list_opt: '(' process_sensitivity_list ')'  */
#line 2152 "parse.y"
      { (yyval.expr_list) = (yyvsp[-1].expr_list); }
#line 4615 "parse.cc"
    break;

  case 297: /* process_sensitivity_list_opt: '(' error ')'  */
#line 2154 "parse.y"
      { errormsg((yylsp[-1]), "Error in process sensitivity list\n");
	yyerrok;
	(yyval.expr_list) = 0;
      }
#line 4624 "parse.cc"
    break;

  case 298: /* process_sensitivity_list_opt: %empty  */
#line 2159 "parse.y"
      { (yyval.expr_list) = 0; }
#line 4630 "parse.cc"
    break;

  case 299: /* process_sensitivity_list: K_all  */
#line 2164 "parse.y"
      { std::list<Expression*>*tmp = new std::list<Expression*>;
	ExpName*all = new ExpNameALL;
	FILE_NAME(all, (yylsp[0]));
	tmp->push_back(all);
	(yyval.expr_list) = tmp;
      }
#line 4641 "parse.cc"
    break;

  case 300: /* process_sensitivity_list: name_list  */
#line 2171 "parse.y"
      { (yyval.expr_list) = (yyvsp[0].expr_list); }
#line 4647 "parse.cc"
    break;

  case 301: /* range: simple_expression direction simple_expression  */
#line 2176 "parse.y"
      { ExpRange* tmp = new ExpRange((yyvsp[-2].expr), (yyvsp[0].expr), (yyvsp[-1].range_dir));
	FILE_NAME(tmp, (yylsp[-2]));
	(yyval.range) = tmp;
      }
#line 4656 "parse.cc"
    break;

  case 302: /* range: name '\'' K_range  */
#line 2181 "parse.y"
      {
        ExpRange*tmp = NULL;
        ExpName*name = NULL;
        if((name = dynamic_cast<ExpName*>((yyvsp[-2].expr)))) {
            tmp = new ExpRange(name, false);
            FILE_NAME(tmp, (yylsp[-2]));
        } else {
	    errormsg((yylsp[-2]), "'range attribute can be used with named expressions only");
        }
        (yyval.range) = tmp;
      }
#line 4672 "parse.cc"
    break;

  case 303: /* range: name '\'' K_reverse_range  */
#line 2193 "parse.y"
      {
        ExpRange*tmp = NULL;
        ExpName*name = NULL;
        if((name = dynamic_cast<ExpName*>((yyvsp[-2].expr)))) {
            tmp = new ExpRange(name, true);
            FILE_NAME(tmp, (yylsp[-2]));
        } else {
	    errormsg((yylsp[-2]), "'reverse_range attribute can be used with named expressions only");
        }
        (yyval.range) = tmp;
      }
#line 4688 "parse.cc"
    break;

  case 304: /* range_list: range  */
#line 2208 "parse.y"
      { list<ExpRange*>*tmp = new list<ExpRange*>;
	tmp->push_back((yyvsp[0].range));
	(yyval.range_list) = tmp;
      }
#line 4697 "parse.cc"
    break;

  case 305: /* range_list: range_list ',' range  */
#line 2213 "parse.y"
      { list<ExpRange*>*tmp = (yyvsp[-2].range_list);
	tmp->push_back((yyvsp[0].range));
	(yyval.range_list) = tmp;
      }
#line 4706 "parse.cc"
    break;

  case 306: /* record_type_definition: K_record element_declaration_list K_end K_record  */
#line 2221 "parse.y"
      { const VTypeRecord*tmp = new VTypeRecord((yyvsp[-2].record_elements));
	(yyval.vtype) = tmp;
      }
#line 4714 "parse.cc"
    break;

  case 307: /* relation: shift_expression  */
#line 2228 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 4720 "parse.cc"
    break;

  case 308: /* relation: shift_expression '=' shift_expression  */
#line 2230 "parse.y"
      { ExpRelation*tmp = new ExpRelation(ExpRelation::EQ, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 4729 "parse.cc"
    break;

  case 309: /* relation: shift_expression '<' shift_expression  */
#line 2235 "parse.y"
      { ExpRelation*tmp = new ExpRelation(ExpRelation::LT, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 4738 "parse.cc"
    break;

  case 310: /* relation: shift_expression '>' shift_expression  */
#line 2240 "parse.y"
      { ExpRelation*tmp = new ExpRelation(ExpRelation::GT, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 4747 "parse.cc"
    break;

  case 311: /* relation: shift_expression LEQ shift_expression  */
#line 2245 "parse.y"
      { ExpRelation*tmp = new ExpRelation(ExpRelation::LE, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 4756 "parse.cc"
    break;

  case 312: /* relation: shift_expression GEQ shift_expression  */
#line 2250 "parse.y"
      { ExpRelation*tmp = new ExpRelation(ExpRelation::GE, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 4765 "parse.cc"
    break;

  case 313: /* relation: shift_expression NE shift_expression  */
#line 2255 "parse.y"
      { ExpRelation*tmp = new ExpRelation(ExpRelation::NEQ, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 4774 "parse.cc"
    break;

  case 314: /* report_statement: K_report expression severity_opt ';'  */
#line 2263 "parse.y"
      { ReportStmt*tmp = new ReportStmt((yyvsp[-2].expr), (yyvsp[-1].severity));
	FILE_NAME(tmp,(yylsp[-2]));
	(yyval.sequ) = tmp;
      }
#line 4783 "parse.cc"
    break;

  case 315: /* return_statement: K_return expression ';'  */
#line 2270 "parse.y"
      { ReturnStmt*tmp = new ReturnStmt((yyvsp[-1].expr));
	FILE_NAME(tmp, (yylsp[-2]));
	(yyval.sequ) = tmp;
      }
#line 4792 "parse.cc"
    break;

  case 316: /* return_statement: K_return ';'  */
#line 2275 "parse.y"
      { ReturnStmt*tmp = new ReturnStmt(0);
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.sequ) = tmp;
      }
#line 4801 "parse.cc"
    break;

  case 317: /* return_statement: K_return error ';'  */
#line 2280 "parse.y"
      { ReturnStmt*tmp = new ReturnStmt(0);
	FILE_NAME(tmp, (yylsp[-2]));
	(yyval.sequ) = tmp;
	errormsg((yylsp[-1]), "Error in expression in return statement.\n");
	yyerrok;
      }
#line 4812 "parse.cc"
    break;

  case 320: /* selected_name: prefix '.' suffix  */
#line 2295 "parse.y"
      { Expression*pfx = (yyvsp[-2].expr);
	ExpName*pfx1 = dynamic_cast<ExpName*>(pfx);
	assert(pfx1);
	perm_string tmp = lex_strings.make((yyvsp[0].text));
	(yyval.expr) = new ExpName(pfx1, tmp);
	FILE_NAME((yyval.expr), (yylsp[0]));
	delete[](yyvsp[0].text);
      }
#line 4825 "parse.cc"
    break;

  case 321: /* selected_name: error '.' suffix  */
#line 2304 "parse.y"
      { errormsg((yylsp[-2]), "Syntax error in prefix in front of \"%s\".\n", (yyvsp[0].text));
        yyerrok;
	(yyval.expr) = new ExpName(lex_strings.make((yyvsp[0].text)));
	FILE_NAME((yyval.expr), (yylsp[0]));
	delete[](yyvsp[0].text);
      }
#line 4836 "parse.cc"
    break;

  case 322: /* selected_names: selected_names ',' selected_name  */
#line 2314 "parse.y"
      { std::list<Expression*>* tmp = (yyvsp[-2].expr_list);
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 4845 "parse.cc"
    break;

  case 323: /* selected_names: selected_name  */
#line 2319 "parse.y"
      { std::list<Expression*>* tmp = new std::list<Expression*>();
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 4854 "parse.cc"
    break;

  case 324: /* selected_name_lib: IDENTIFIER '.' K_all  */
#line 2330 "parse.y"
      { library_use((yylsp[-2]), active_scope, 0, (yyvsp[-2].text), 0);
	delete[](yyvsp[-2].text);
      }
#line 4862 "parse.cc"
    break;

  case 325: /* selected_name_lib: IDENTIFIER '.' IDENTIFIER '.' K_all  */
#line 2334 "parse.y"
      { library_use((yylsp[-4]), active_scope, (yyvsp[-4].text), (yyvsp[-2].text), 0);
	delete[](yyvsp[-4].text);
	delete[](yyvsp[-2].text);
      }
#line 4871 "parse.cc"
    break;

  case 326: /* selected_name_lib: IDENTIFIER '.' IDENTIFIER '.' IDENTIFIER  */
#line 2339 "parse.y"
      { library_use((yylsp[-4]), active_scope, (yyvsp[-4].text), (yyvsp[-2].text), (yyvsp[0].text));
	delete[](yyvsp[-4].text);
	delete[](yyvsp[-2].text);
	delete[](yyvsp[0].text);
      }
#line 4881 "parse.cc"
    break;

  case 329: /* selected_signal_assignment: K_with expression K_select name LEQ selected_waveform_list ';'  */
#line 2353 "parse.y"
      { ExpSelected*tmp = new ExpSelected((yyvsp[-5].expr), (yyvsp[-1].exp_options_list));
	FILE_NAME(tmp, (yylsp[-4]));
        delete (yyvsp[-5].expr);
	delete (yyvsp[-1].exp_options_list);

	ExpName*name = dynamic_cast<ExpName*>((yyvsp[-3].expr));
	assert(name);
	SignalAssignment*tmpa = new SignalAssignment(name, tmp);
	FILE_NAME(tmpa, (yylsp[-6]));

	(yyval.arch_statement) = tmpa;
      }
#line 4898 "parse.cc"
    break;

  case 330: /* selected_waveform: waveform K_when expression  */
#line 2369 "parse.y"
      { ExpConditional::case_t*tmp = new ExpConditional::case_t((yyvsp[0].expr), (yyvsp[-2].expr_list));
	FILE_NAME(tmp, (yylsp[-2]));
	(yyval.exp_options) = tmp;
      }
#line 4907 "parse.cc"
    break;

  case 331: /* selected_waveform: waveform K_when K_others  */
#line 2374 "parse.y"
      { ExpConditional::case_t*tmp = new ExpConditional::case_t(0,  (yyvsp[-2].expr_list));
	FILE_NAME(tmp, (yylsp[-2]));
	(yyval.exp_options) = tmp;
      }
#line 4916 "parse.cc"
    break;

  case 332: /* selected_waveform_list: selected_waveform_list ',' selected_waveform  */
#line 2382 "parse.y"
      { list<ExpConditional::case_t*>*tmp = (yyvsp[-2].exp_options_list);
	tmp->push_back((yyvsp[0].exp_options));
	(yyval.exp_options_list) = tmp;
      }
#line 4925 "parse.cc"
    break;

  case 333: /* selected_waveform_list: selected_waveform  */
#line 2387 "parse.y"
      { list<ExpConditional::case_t*>*tmp = new list<ExpConditional::case_t*>;
	tmp->push_back((yyvsp[0].exp_options));
	(yyval.exp_options_list) = tmp;
      }
#line 4934 "parse.cc"
    break;

  case 334: /* list_of_statements: list_of_statements sequential_statement  */
#line 2395 "parse.y"
      { std::list<SequentialStmt*>*tmp = (yyvsp[-1].sequ_list);
    if((yyvsp[0].sequ))
        tmp->push_back((yyvsp[0].sequ));
	(yyval.sequ_list) = tmp;
      }
#line 4944 "parse.cc"
    break;

  case 335: /* list_of_statements: sequential_statement  */
#line 2401 "parse.y"
      { std::list<SequentialStmt*>*tmp = new std::list<SequentialStmt*>;
    if((yyvsp[0].sequ))
        tmp->push_back((yyvsp[0].sequ));
	(yyval.sequ_list) = tmp;
      }
#line 4954 "parse.cc"
    break;

  case 336: /* sequence_of_statements: list_of_statements  */
#line 2409 "parse.y"
                       { (yyvsp[0].sequ_list) = (yyval.sequ_list); }
#line 4960 "parse.cc"
    break;

  case 337: /* sequence_of_statements: %empty  */
#line 2410 "parse.y"
    { (yyval.sequ_list) = NULL; }
#line 4966 "parse.cc"
    break;

  case 338: /* sequential_statement: if_statement  */
#line 2414 "parse.y"
                                { (yyval.sequ) = (yyvsp[0].sequ); }
#line 4972 "parse.cc"
    break;

  case 339: /* sequential_statement: signal_assignment_statement  */
#line 2415 "parse.y"
                                { (yyval.sequ) = (yyvsp[0].sequ); }
#line 4978 "parse.cc"
    break;

  case 340: /* sequential_statement: variable_assignment_statement  */
#line 2416 "parse.y"
                                  { (yyval.sequ) = (yyvsp[0].sequ); }
#line 4984 "parse.cc"
    break;

  case 341: /* sequential_statement: case_statement  */
#line 2417 "parse.y"
                   { (yyval.sequ) = (yyvsp[0].sequ); }
#line 4990 "parse.cc"
    break;

  case 342: /* sequential_statement: procedure_call_statement  */
#line 2418 "parse.y"
                             { (yyval.sequ) = (yyvsp[0].sequ); }
#line 4996 "parse.cc"
    break;

  case 343: /* sequential_statement: loop_statement  */
#line 2419 "parse.y"
                   { (yyval.sequ) = (yyvsp[0].sequ); }
#line 5002 "parse.cc"
    break;

  case 344: /* sequential_statement: return_statement  */
#line 2420 "parse.y"
                     { (yyval.sequ) = (yyvsp[0].sequ); }
#line 5008 "parse.cc"
    break;

  case 345: /* sequential_statement: report_statement  */
#line 2421 "parse.y"
                     { (yyval.sequ) = (yyvsp[0].sequ); }
#line 5014 "parse.cc"
    break;

  case 346: /* sequential_statement: assertion_statement  */
#line 2422 "parse.y"
                        { (yyval.sequ) = (yyvsp[0].sequ); }
#line 5020 "parse.cc"
    break;

  case 347: /* sequential_statement: wait_statement  */
#line 2423 "parse.y"
                   { (yyval.sequ) = (yyvsp[0].sequ); }
#line 5026 "parse.cc"
    break;

  case 348: /* sequential_statement: K_null ';'  */
#line 2424 "parse.y"
               { (yyval.sequ) = 0; }
#line 5032 "parse.cc"
    break;

  case 349: /* sequential_statement: error ';'  */
#line 2426 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error in sequential statement.\n");
	(yyval.sequ) = 0;
	yyerrok;
      }
#line 5041 "parse.cc"
    break;

  case 350: /* severity: K_severity IDENTIFIER  */
#line 2434 "parse.y"
  { if(!strcasecmp((yyvsp[0].text), "NOTE"))
        (yyval.severity) = ReportStmt::NOTE;
    else if(!strcasecmp((yyvsp[0].text), "WARNING"))
        (yyval.severity) = ReportStmt::WARNING;
    else if(!strcasecmp((yyvsp[0].text), "ERROR"))
        (yyval.severity) = ReportStmt::ERROR;
    else if(!strcasecmp((yyvsp[0].text), "FAILURE"))
        (yyval.severity) = ReportStmt::FAILURE;
    else {
        errormsg((yylsp[-1]), "Invalid severity level (possible values: NOTE, WARNING, ERROR, FAILURE).\n");
        (yyval.severity) = ReportStmt::UNSPECIFIED;
    }
    delete[] (yyvsp[0].text);
  }
#line 5060 "parse.cc"
    break;

  case 351: /* severity_opt: severity  */
#line 2450 "parse.y"
             { (yyval.severity) = (yyvsp[0].severity); }
#line 5066 "parse.cc"
    break;

  case 352: /* severity_opt: %empty  */
#line 2451 "parse.y"
    { (yyval.severity) = ReportStmt::UNSPECIFIED; }
#line 5072 "parse.cc"
    break;

  case 354: /* shift_expression: simple_expression K_srl simple_expression  */
#line 2456 "parse.y"
      { ExpShift*tmp = new ExpShift(ExpShift::SRL, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
        (yyval.expr) = tmp;
      }
#line 5081 "parse.cc"
    break;

  case 355: /* shift_expression: simple_expression K_sll simple_expression  */
#line 2461 "parse.y"
      { ExpShift*tmp = new ExpShift(ExpShift::SLL, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
        (yyval.expr) = tmp;
      }
#line 5090 "parse.cc"
    break;

  case 356: /* shift_expression: simple_expression K_sra simple_expression  */
#line 2466 "parse.y"
      { ExpShift*tmp = new ExpShift(ExpShift::SRA, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
        (yyval.expr) = tmp;
      }
#line 5099 "parse.cc"
    break;

  case 357: /* shift_expression: simple_expression K_sla simple_expression  */
#line 2471 "parse.y"
      { ExpShift*tmp = new ExpShift(ExpShift::SLA, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
        (yyval.expr) = tmp;
      }
#line 5108 "parse.cc"
    break;

  case 358: /* shift_expression: simple_expression K_ror simple_expression  */
#line 2476 "parse.y"
      { sorrymsg((yylsp[-1]), "ROR is not supported.\n");
        ExpShift*tmp = new ExpShift(ExpShift::ROR, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
        (yyval.expr) = tmp;
      }
#line 5118 "parse.cc"
    break;

  case 359: /* shift_expression: simple_expression K_rol simple_expression  */
#line 2482 "parse.y"
      { sorrymsg((yylsp[-1]), "ROL is not supported.\n");
        ExpShift*tmp = new ExpShift(ExpShift::ROL, (yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-1]));
        (yyval.expr) = tmp;
      }
#line 5128 "parse.cc"
    break;

  case 360: /* signal_declaration_assign_opt: VASSIGN expression  */
#line 2490 "parse.y"
                       { (yyval.expr) = (yyvsp[0].expr); }
#line 5134 "parse.cc"
    break;

  case 361: /* signal_declaration_assign_opt: %empty  */
#line 2491 "parse.y"
                       { (yyval.expr) = 0;  }
#line 5140 "parse.cc"
    break;

  case 362: /* simple_expression: '-' simple_expression_2  */
#line 2515 "parse.y"
      { (yyval.expr) = new ExpUMinus((yyvsp[0].expr)); }
#line 5146 "parse.cc"
    break;

  case 363: /* simple_expression: '+' simple_expression_2  */
#line 2517 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 5152 "parse.cc"
    break;

  case 364: /* simple_expression: simple_expression_2  */
#line 2519 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 5158 "parse.cc"
    break;

  case 365: /* simple_expression_2: term  */
#line 2524 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 5164 "parse.cc"
    break;

  case 366: /* simple_expression_2: term simple_expression_terms  */
#line 2526 "parse.y"
      { Expression*tmp = (yyvsp[-1].expr);
	list<struct adding_term>*lst = (yyvsp[0].adding_terms);
	while (! lst->empty()) {
	      struct adding_term item = lst->front();
	      lst->pop_front();
	      if (item.op == ExpArithmetic::xCONCAT)
		    tmp = new ExpConcat(tmp, item.term);
	      else
		    tmp = new ExpArithmetic(item.op, tmp, item.term);
	}
	delete lst;
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 5183 "parse.cc"
    break;

  case 367: /* simple_expression_terms: adding_operator term  */
#line 2544 "parse.y"
      { struct adding_term item;
	item.op = (yyvsp[-1].arithmetic_op);
	item.term = (yyvsp[0].expr);
	list<adding_term>*tmp = new list<adding_term>;
	tmp->push_back(item);
	(yyval.adding_terms) = tmp;
      }
#line 5195 "parse.cc"
    break;

  case 368: /* simple_expression_terms: simple_expression_terms adding_operator term  */
#line 2552 "parse.y"
      { list<adding_term>*tmp = (yyvsp[-2].adding_terms);
	struct adding_term item;
	item.op = (yyvsp[-1].arithmetic_op);
	item.term = (yyvsp[0].expr);
	tmp->push_back(item);
	(yyval.adding_terms) = tmp;
      }
#line 5207 "parse.cc"
    break;

  case 369: /* signal_assignment: name LEQ waveform ';'  */
#line 2563 "parse.y"
      { SignalSeqAssignment*tmp = new SignalSeqAssignment((yyvsp[-3].expr), (yyvsp[-1].expr_list));
	FILE_NAME(tmp, (yylsp[-3]));
	delete (yyvsp[-1].expr_list);
	(yyval.sequ) = tmp;
      }
#line 5217 "parse.cc"
    break;

  case 370: /* signal_assignment: name LEQ waveform K_when expression K_else waveform ';'  */
#line 2569 "parse.y"
      { SignalSeqAssignment*tmp = new SignalSeqAssignment((yyvsp[-7].expr), (yyvsp[-5].expr_list));
	FILE_NAME(tmp, (yylsp[-7]));
	sorrymsg((yylsp[-4]), "Conditional signal assignment not supported.\n");
	(yyval.sequ) = tmp;
      }
#line 5227 "parse.cc"
    break;

  case 372: /* signal_assignment_statement: IDENTIFIER ':' signal_assignment  */
#line 2579 "parse.y"
      { delete[] (yyvsp[-2].text);
	(yyval.sequ) = (yyvsp[0].sequ);
      }
#line 5235 "parse.cc"
    break;

  case 373: /* subprogram_body_start: subprogram_specification K_is  */
#line 2585 "parse.y"
      { assert(!active_sub);
        active_sub = (yyvsp[-1].subprogram);
        (yyval.subprogram) = (yyvsp[-1].subprogram); }
#line 5243 "parse.cc"
    break;

  case 374: /* subprogram_body: subprogram_body_start subprogram_declarative_part K_begin subprogram_statement_part K_end subprogram_kind_opt identifier_opt ';'  */
#line 2597 "parse.y"
      { SubprogramHeader*prog = (yyvsp[-7].subprogram);
	SubprogramHeader*tmp = active_scope->recall_subprogram(prog);
	if (tmp) {
	      delete prog;
	      prog = tmp;
	}

	SubprogramBody*body = new SubprogramBody();
	body->transfer_from(*active_scope, ScopeBase::VARIABLES);
	body->set_statements((yyvsp[-4].sequ_list));

	prog->set_body(body);
	active_scope->bind_subprogram(prog->name(), prog);
	active_sub = NULL;
      }
#line 5263 "parse.cc"
    break;

  case 375: /* subprogram_body: subprogram_body_start subprogram_declarative_part K_begin error K_end subprogram_kind_opt identifier_opt ';'  */
#line 2617 "parse.y"
      { errormsg((yylsp[-6]), "Syntax errors in subprogram body.\n");
	yyerrok;
	active_sub = NULL;
	if ((yyvsp[-7].subprogram)) delete (yyvsp[-7].subprogram);
	if ((yyvsp[-1].text)) delete[](yyvsp[-1].text);
      }
#line 5274 "parse.cc"
    break;

  case 376: /* subprogram_declaration: subprogram_specification ';'  */
#line 2627 "parse.y"
      { if ((yyvsp[-1].subprogram)) active_scope->bind_subprogram((yyvsp[-1].subprogram)->name(), (yyvsp[-1].subprogram)); }
#line 5280 "parse.cc"
    break;

  case 387: /* subprogram_specification: function_specification  */
#line 2653 "parse.y"
                           { (yyval.subprogram) = (yyvsp[0].subprogram); }
#line 5286 "parse.cc"
    break;

  case 388: /* subprogram_specification: procedure_specification  */
#line 2654 "parse.y"
                            { (yyval.subprogram) = (yyvsp[0].subprogram); }
#line 5292 "parse.cc"
    break;

  case 389: /* subprogram_statement_part: sequence_of_statements  */
#line 2662 "parse.y"
                           { (yyval.sequ_list) = (yyvsp[0].sequ_list); }
#line 5298 "parse.cc"
    break;

  case 390: /* subtype_declaration: K_subtype IDENTIFIER K_is subtype_indication ';'  */
#line 2667 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-3].text));
	if ((yyvsp[-1].vtype) == 0) {
	      errormsg((yylsp[-4]), "Failed to declare type name %s.\n", name.str());
	} else {
	      VTypeDef*tmp;
	      map<perm_string,VTypeDef*>::iterator cur = active_scope->incomplete_types.find(name);
	      if (cur == active_scope->incomplete_types.end()) {
		    tmp = new VSubTypeDef(name, (yyvsp[-1].vtype));
		    active_scope->bind_name(name, tmp);
	      } else {
		    tmp = cur->second;
		    tmp->set_definition((yyvsp[-1].vtype));
		    active_scope->incomplete_types.erase(cur);
	      }
	}
	delete[](yyvsp[-3].text);
      }
#line 5320 "parse.cc"
    break;

  case 391: /* subtype_indication: IDENTIFIER  */
#line 2688 "parse.y"
      { const VType*tmp = parse_type_by_name(lex_strings.make((yyvsp[0].text)));
	if (tmp == 0) {
	      errormsg((yylsp[0]), "Can't find type name `%s'\n", (yyvsp[0].text));
	      tmp = new VTypeERROR;
	}
	delete[](yyvsp[0].text);
	(yyval.vtype) = tmp;
      }
#line 5333 "parse.cc"
    break;

  case 392: /* subtype_indication: IDENTIFIER index_constraint  */
#line 2697 "parse.y"
      { const VType*tmp = calculate_subtype_array((yylsp[-1]), (yyvsp[-1].text), active_scope, (yyvsp[0].range_list));
	if (tmp == 0) {
	      errormsg((yylsp[-1]), "Unable to calculate bounds for array of %s.\n", (yyvsp[-1].text));
	}
	delete[](yyvsp[-1].text);
	delete  (yyvsp[0].range_list);
	(yyval.vtype) = tmp;
      }
#line 5346 "parse.cc"
    break;

  case 393: /* subtype_indication: IDENTIFIER K_range simple_expression direction simple_expression  */
#line 2706 "parse.y"
      { const VType*tmp = calculate_subtype_range((yylsp[-4]), (yyvsp[-4].text), active_scope, (yyvsp[-2].expr), (yyvsp[-1].range_dir), (yyvsp[0].expr));
	if (tmp == 0) {
	      errormsg((yylsp[-4]), "Unable to calculate bounds for range of %s.\n", (yyvsp[-4].text));
	}
	delete[](yyvsp[-4].text);
	(yyval.vtype) = tmp;
      }
#line 5358 "parse.cc"
    break;

  case 394: /* suffix: IDENTIFIER  */
#line 2717 "parse.y"
      { (yyval.text) = (yyvsp[0].text); }
#line 5364 "parse.cc"
    break;

  case 395: /* suffix: CHARACTER_LITERAL  */
#line 2719 "parse.y"
      { (yyval.text) = (yyvsp[0].text); }
#line 5370 "parse.cc"
    break;

  case 396: /* suffix: K_all  */
#line 2721 "parse.y"
      { //do not have now better idea than using char constant
	(yyval.text) = strdup("all");
      }
#line 5378 "parse.cc"
    break;

  case 397: /* term: factor  */
#line 2728 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 5384 "parse.cc"
    break;

  case 398: /* term: factor '*' factor  */
#line 2730 "parse.y"
      { ExpArithmetic*tmp = new ExpArithmetic(ExpArithmetic::MULT, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 5393 "parse.cc"
    break;

  case 399: /* term: factor '/' factor  */
#line 2735 "parse.y"
      { ExpArithmetic*tmp = new ExpArithmetic(ExpArithmetic::DIV, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 5402 "parse.cc"
    break;

  case 400: /* term: factor K_mod factor  */
#line 2740 "parse.y"
      { ExpArithmetic*tmp = new ExpArithmetic(ExpArithmetic::MOD, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 5411 "parse.cc"
    break;

  case 401: /* term: factor K_rem factor  */
#line 2745 "parse.y"
      { ExpArithmetic*tmp = new ExpArithmetic(ExpArithmetic::REM, (yyvsp[-2].expr), (yyvsp[0].expr));
	FILE_NAME(tmp, (yylsp[-1]));
	(yyval.expr) = tmp;
      }
#line 5420 "parse.cc"
    break;

  case 402: /* type_declaration: K_type IDENTIFIER K_is type_definition ';'  */
#line 2753 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-3].text));
	if ((yyvsp[-1].vtype) == 0) {
	      errormsg((yylsp[-4]), "Failed to declare type name %s.\n", name.str());
	} else {
	      VTypeDef*tmp;
	      map<perm_string,VTypeDef*>::iterator cur = active_scope->incomplete_types.find(name);
	      if (cur == active_scope->incomplete_types.end()) {
		    tmp = new VTypeDef(name, (yyvsp[-1].vtype));
		    active_scope->bind_name(name, tmp);
	      } else {
		    tmp = cur->second;
		    tmp->set_definition((yyvsp[-1].vtype));
		    active_scope->incomplete_types.erase(cur);
	      }
	}
	delete[](yyvsp[-3].text);
      }
#line 5442 "parse.cc"
    break;

  case 403: /* type_declaration: K_type IDENTIFIER ';'  */
#line 2771 "parse.y"
      { perm_string name = lex_strings.make((yyvsp[-1].text));
	VTypeDef*tmp = new VTypeDef(name);
	active_scope->incomplete_types[name] = tmp;
	active_scope->bind_name(name, tmp);
	delete[](yyvsp[-1].text);
      }
#line 5453 "parse.cc"
    break;

  case 404: /* type_declaration: K_type IDENTIFIER K_is error ';'  */
#line 2778 "parse.y"
      { errormsg((yylsp[-1]), "Error in type definition for %s\n", (yyvsp[-3].text));
	yyerrok;
	delete[](yyvsp[-3].text);
      }
#line 5462 "parse.cc"
    break;

  case 405: /* type_declaration: K_type error ';'  */
#line 2783 "parse.y"
      { errormsg((yylsp[-2]), "Error in type definition\n");
	yyerrok;
      }
#line 5470 "parse.cc"
    break;

  case 406: /* type_definition: '(' enumeration_literal_list ')'  */
#line 2790 "parse.y"
      { const VTypeEnum*tmp = new VTypeEnum((yyvsp[-1].name_list));
	active_scope->use_enum(tmp);
	delete (yyvsp[-1].name_list);
	(yyval.vtype) = tmp;
      }
#line 5480 "parse.cc"
    break;

  case 407: /* type_definition: composite_type_definition  */
#line 2796 "parse.y"
      { (yyval.vtype) = (yyvsp[0].vtype); }
#line 5486 "parse.cc"
    break;

  case 408: /* use_clause: K_use selected_names ';'  */
#line 2802 "parse.y"
     { (yyval.expr_list) = (yyvsp[-1].expr_list); }
#line 5492 "parse.cc"
    break;

  case 409: /* use_clause: K_use error ';'  */
#line 2804 "parse.y"
     { errormsg((yylsp[-2]), "Syntax error in use clause.\n"); yyerrok; }
#line 5498 "parse.cc"
    break;

  case 411: /* use_clause_lib: K_use error ';'  */
#line 2810 "parse.y"
     { errormsg((yylsp[-2]), "Syntax error in use clause.\n"); yyerrok; }
#line 5504 "parse.cc"
    break;

  case 417: /* variable_assignment_statement: IDENTIFIER ':' variable_assignment  */
#line 2826 "parse.y"
      { delete[] (yyvsp[-2].text);
	(yyval.sequ) = (yyvsp[0].sequ);
      }
#line 5512 "parse.cc"
    break;

  case 418: /* variable_assignment: name VASSIGN expression ';'  */
#line 2832 "parse.y"
      { VariableSeqAssignment*tmp = new VariableSeqAssignment((yyvsp[-3].expr), (yyvsp[-1].expr));
	FILE_NAME(tmp, (yylsp[-3]));
	(yyval.sequ) = tmp;
      }
#line 5521 "parse.cc"
    break;

  case 419: /* variable_assignment: name VASSIGN error ';'  */
#line 2837 "parse.y"
      { errormsg((yylsp[-1]), "Syntax error in r-value expression of assignment.\n");
	yyerrok;
	delete (yyvsp[-3].expr);
	(yyval.sequ) = 0;
      }
#line 5531 "parse.cc"
    break;

  case 420: /* variable_assignment: error VASSIGN expression ';'  */
#line 2843 "parse.y"
      { errormsg((yylsp[-3]), "Syntax error in l-value expression of assignment.\n");
	yyerrok;
	delete (yyvsp[-1].expr);
	(yyval.sequ) = 0;
      }
#line 5541 "parse.cc"
    break;

  case 421: /* variable_declaration: K_shared_opt K_variable identifier_list ':' subtype_indication variable_declaration_assign_opt ';'  */
#line 2853 "parse.y"
      { /* Save the signal declaration in the block_signals map. */
	for (std::list<perm_string>::iterator cur = (yyvsp[-4].name_list)->begin()
		   ; cur != (yyvsp[-4].name_list)->end() ; ++cur) {
	      Variable*sig = new Variable(*cur, (yyvsp[-2].vtype), (yyvsp[-1].expr));
	      FILE_NAME(sig, (yylsp[-5]));
	      active_scope->bind_name(*cur, sig);
	}
	delete (yyvsp[-4].name_list);
      }
#line 5555 "parse.cc"
    break;

  case 422: /* variable_declaration: K_shared_opt K_variable error ';'  */
#line 2863 "parse.y"
      { errormsg((yylsp[-2]), "Syntax error in variable declaration.\n");
	yyerrok;
      }
#line 5563 "parse.cc"
    break;

  case 423: /* variable_declaration_assign_opt: VASSIGN expression  */
#line 2869 "parse.y"
                       { (yyval.expr) = (yyvsp[0].expr); }
#line 5569 "parse.cc"
    break;

  case 424: /* variable_declaration_assign_opt: %empty  */
#line 2870 "parse.y"
                       { (yyval.expr) = 0;  }
#line 5575 "parse.cc"
    break;

  case 425: /* wait_statement: K_wait K_for expression ';'  */
#line 2875 "parse.y"
      { WaitForStmt*tmp = new WaitForStmt((yyvsp[-1].expr));
	FILE_NAME(tmp, (yylsp[-3]));
	(yyval.sequ) = tmp;
      }
#line 5584 "parse.cc"
    break;

  case 426: /* wait_statement: K_wait K_on expression ';'  */
#line 2880 "parse.y"
      { WaitStmt*tmp = new WaitStmt(WaitStmt::ON, (yyvsp[-1].expr));
        FILE_NAME(tmp, (yylsp[-3]));
        (yyval.sequ) = tmp;
      }
#line 5593 "parse.cc"
    break;

  case 427: /* wait_statement: K_wait K_until expression ';'  */
#line 2885 "parse.y"
      { WaitStmt*tmp = new WaitStmt(WaitStmt::UNTIL, (yyvsp[-1].expr));
        FILE_NAME(tmp, (yylsp[-3]));
        (yyval.sequ) = tmp;
      }
#line 5602 "parse.cc"
    break;

  case 428: /* wait_statement: K_wait ';'  */
#line 2890 "parse.y"
      { WaitStmt*tmp = new WaitStmt(WaitStmt::FINAL, NULL);
        FILE_NAME(tmp, (yylsp[-1]));
        (yyval.sequ) = tmp;
      }
#line 5611 "parse.cc"
    break;

  case 429: /* waveform: waveform_elements  */
#line 2898 "parse.y"
      { (yyval.expr_list) = (yyvsp[0].expr_list); }
#line 5617 "parse.cc"
    break;

  case 430: /* waveform: K_unaffected  */
#line 2900 "parse.y"
      { (yyval.expr_list) = 0; }
#line 5623 "parse.cc"
    break;

  case 431: /* waveform_elements: waveform_elements ',' waveform_element  */
#line 2905 "parse.y"
      { std::list<Expression*>*tmp = (yyvsp[-2].expr_list);
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 5632 "parse.cc"
    break;

  case 432: /* waveform_elements: waveform_element  */
#line 2910 "parse.y"
      { std::list<Expression*>*tmp = new std::list<Expression*>;
	tmp->push_back((yyvsp[0].expr));
	(yyval.expr_list) = tmp;
      }
#line 5641 "parse.cc"
    break;

  case 433: /* waveform_element: expression  */
#line 2918 "parse.y"
      { (yyval.expr) = (yyvsp[0].expr); }
#line 5647 "parse.cc"
    break;

  case 434: /* waveform_element: expression K_after expression  */
#line 2920 "parse.y"
      { ExpDelay*tmp = new ExpDelay((yyvsp[-2].expr), (yyvsp[0].expr));
        FILE_NAME(tmp, (yylsp[-2]));
        (yyval.expr) = tmp; }
#line 5655 "parse.cc"
    break;

  case 435: /* waveform_element: K_null  */
#line 2924 "parse.y"
      { (yyval.expr) = 0; }
#line 5661 "parse.cc"
    break;


#line 5665 "parse.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (&yylloc, yyscanner, file_path, parse_library_name, YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner, file_path, parse_library_name);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, yyscanner, file_path, parse_library_name);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, file_path, parse_library_name, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner, file_path, parse_library_name);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, yyscanner, file_path, parse_library_name);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 2936 "parse.y"


static void yyerror(const YYLTYPE*loc, yyscan_t, const char*, bool, const char*msg)
{
      fprintf(stderr, "%s:%u: %s\n", loc->text, loc->first_line, msg);
      parse_errors += 1;
}

void errormsg(const YYLTYPE&loc, const char*fmt, ...)
{
      va_list ap;
      va_start(ap, fmt);

      fprintf(stderr, "%s:%u: error: ", loc.text, loc.first_line);
      vfprintf(stderr, fmt, ap);
      va_end(ap);
      parse_errors += 1;
}

void sorrymsg(const YYLTYPE&loc, const char*fmt, ...)
{
      va_list ap;
      va_start(ap, fmt);

      fprintf(stderr, "%s:%u: sorry: ", loc.text, loc.first_line);
      vfprintf(stderr, fmt, ap);
      va_end(ap);
      parse_sorrys += 1;
}


/*
 * The reset_lexor function takes the fd and makes it the input file
 * for the lexor. The path argument is used in lexor/parser error messages.
 */
extern yyscan_t prepare_lexor(FILE*fd);
extern void destroy_lexor(yyscan_t scanner);

int parse_source_file(const char*file_path, perm_string parse_library_name)
{
      FILE*fd = fopen(file_path, "r");
      if (fd == 0) {
	    perror(file_path);
	    return -1;
      }

      yyscan_t scanner = prepare_lexor(fd);
      int rc = yyparse(scanner, file_path, parse_library_name);
      fclose(fd);
      destroy_lexor(scanner);

      return rc;
}
