// Copyright 2018 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: networking/v1alpha3/destination_rule.proto

// $schema: istio.networking.v1alpha3.DestinationRule
// $title: Destination Rule
// $description: Configuration affecting load balancing, outlier detection, etc.
// $location: https://istio.io/docs/reference/config/networking/destination-rule.html
// $aliases: [/docs/reference/config/networking/v1alpha3/destination-rule]

// `DestinationRule` defines policies that apply to traffic intended for a
// service after routing has occurred. These rules specify configuration
// for load balancing, connection pool size from the sidecar, and outlier
// detection settings to detect and evict unhealthy hosts from the load
// balancing pool. For example, a simple load balancing policy for the
// ratings service would look as follows:
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_REQUEST
// ```
//
// Version specific policies can be specified by defining a named
// `subset` and overriding the settings specified at the service level. The
// following rule uses a round robin load balancing policy for all traffic
// going to a subset named testversion that is composed of endpoints (e.g.,
// pods) with labels (version:v3).
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_REQUEST
//   subsets:
//   - name: testversion
//     labels:
//       version: v3
//     trafficPolicy:
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
//
// **Note:** Policies specified for subsets will not take effect until
// a route rule explicitly sends traffic to this subset.
//
// Traffic policies can be customized to specific ports as well. The
// following rule uses the least connection load balancing policy for all
// traffic to port 80, while uses a round robin load balancing setting for
// traffic to the port 9080.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings-port
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy: # Apply to all ports
//     portLevelSettings:
//     - port:
//         number: 80
//       loadBalancer:
//         simple: LEAST_REQUEST
//     - port:
//         number: 9080
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
//
// Destination Rules can be customized to specific workloads as well.
// The following example shows how a destination rule can be applied to a
// specific workload using the workloadSelector configuration.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//   name: configure-client-mtls-dr-with-workloadselector
// spec:
//   host: example.com
//   workloadSelector:
//     matchLabels:
//       app: ratings
//   trafficPolicy:
//     loadBalancer:
//       simple: ROUND_ROBIN
//     portLevelSettings:
//     - port:
//         number: 31443
//       tls:
//         credentialName: client-credential
//         mode: MUTUAL
// ```

package v1alpha3

import (
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1beta1 "istio.io/api/type/v1beta1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TrafficPolicy_ProxyProtocol_VERSION int32

const (
	// ⁣PROXY protocol version 1. Human readable format.
	TrafficPolicy_ProxyProtocol_V1 TrafficPolicy_ProxyProtocol_VERSION = 0
	// ⁣PROXY protocol version 2. Binary format.
	TrafficPolicy_ProxyProtocol_V2 TrafficPolicy_ProxyProtocol_VERSION = 1
)

// Enum value maps for TrafficPolicy_ProxyProtocol_VERSION.
var (
	TrafficPolicy_ProxyProtocol_VERSION_name = map[int32]string{
		0: "V1",
		1: "V2",
	}
	TrafficPolicy_ProxyProtocol_VERSION_value = map[string]int32{
		"V1": 0,
		"V2": 1,
	}
)

func (x TrafficPolicy_ProxyProtocol_VERSION) Enum() *TrafficPolicy_ProxyProtocol_VERSION {
	p := new(TrafficPolicy_ProxyProtocol_VERSION)
	*p = x
	return p
}

func (x TrafficPolicy_ProxyProtocol_VERSION) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrafficPolicy_ProxyProtocol_VERSION) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_destination_rule_proto_enumTypes[0].Descriptor()
}

func (TrafficPolicy_ProxyProtocol_VERSION) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_destination_rule_proto_enumTypes[0]
}

func (x TrafficPolicy_ProxyProtocol_VERSION) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrafficPolicy_ProxyProtocol_VERSION.Descriptor instead.
func (TrafficPolicy_ProxyProtocol_VERSION) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{1, 2, 0}
}

// +kubebuilder:validation:XValidation:message="only one of warmupDurationSecs or warmup can be set",rule="oneof(self.warmupDurationSecs, self.warmup)"
// Standard load balancing algorithms that require no tuning.
type LoadBalancerSettings_SimpleLB int32

const (
	// No load balancing algorithm has been specified by the user. Istio
	// will select an appropriate default.
	LoadBalancerSettings_UNSPECIFIED LoadBalancerSettings_SimpleLB = 0
	// Deprecated. Use LEAST_REQUEST instead.
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/destination_rule.proto.
	LoadBalancerSettings_LEAST_CONN LoadBalancerSettings_SimpleLB = 1
	// The random load balancer selects a random healthy host. The random
	// load balancer generally performs better than round robin if no health
	// checking policy is configured.
	LoadBalancerSettings_RANDOM LoadBalancerSettings_SimpleLB = 2
	// This option will forward the connection to the original IP address
	// requested by the caller without doing any form of load
	// balancing. This option must be used with care. It is meant for
	// advanced use cases. Refer to Original Destination load balancer in
	// Envoy for further details.
	LoadBalancerSettings_PASSTHROUGH LoadBalancerSettings_SimpleLB = 3
	// A basic round robin load balancing policy. This is generally unsafe
	// for many scenarios (e.g. when endpoint weighting is used) as it can
	// overburden endpoints. In general, prefer to use LEAST_REQUEST as a
	// drop-in replacement for ROUND_ROBIN.
	LoadBalancerSettings_ROUND_ROBIN LoadBalancerSettings_SimpleLB = 4
	// The least request load balancer spreads load across endpoints, favoring
	// endpoints with the least outstanding requests. This is generally safer
	// and outperforms ROUND_ROBIN in nearly all cases. Prefer to use
	// LEAST_REQUEST as a drop-in replacement for ROUND_ROBIN.
	LoadBalancerSettings_LEAST_REQUEST LoadBalancerSettings_SimpleLB = 5
)

// Enum value maps for LoadBalancerSettings_SimpleLB.
var (
	LoadBalancerSettings_SimpleLB_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "LEAST_CONN",
		2: "RANDOM",
		3: "PASSTHROUGH",
		4: "ROUND_ROBIN",
		5: "LEAST_REQUEST",
	}
	LoadBalancerSettings_SimpleLB_value = map[string]int32{
		"UNSPECIFIED":   0,
		"LEAST_CONN":    1,
		"RANDOM":        2,
		"PASSTHROUGH":   3,
		"ROUND_ROBIN":   4,
		"LEAST_REQUEST": 5,
	}
)

func (x LoadBalancerSettings_SimpleLB) Enum() *LoadBalancerSettings_SimpleLB {
	p := new(LoadBalancerSettings_SimpleLB)
	*p = x
	return p
}

func (x LoadBalancerSettings_SimpleLB) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerSettings_SimpleLB) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_destination_rule_proto_enumTypes[1].Descriptor()
}

func (LoadBalancerSettings_SimpleLB) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_destination_rule_proto_enumTypes[1]
}

func (x LoadBalancerSettings_SimpleLB) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerSettings_SimpleLB.Descriptor instead.
func (LoadBalancerSettings_SimpleLB) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{3, 0}
}

// Policy for upgrading http1.1 connections to http2.
type ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy int32

const (
	// Use the global default.
	ConnectionPoolSettings_HTTPSettings_DEFAULT ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy = 0
	// Do not upgrade the connection to http2.
	// This opt-out option overrides the default.
	ConnectionPoolSettings_HTTPSettings_DO_NOT_UPGRADE ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy = 1
	// Upgrade the connection to http2.
	// This opt-in option overrides the default.
	ConnectionPoolSettings_HTTPSettings_UPGRADE ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy = 2
)

// Enum value maps for ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy.
var (
	ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy_name = map[int32]string{
		0: "DEFAULT",
		1: "DO_NOT_UPGRADE",
		2: "UPGRADE",
	}
	ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy_value = map[string]int32{
		"DEFAULT":        0,
		"DO_NOT_UPGRADE": 1,
		"UPGRADE":        2,
	}
)

func (x ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) Enum() *ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy {
	p := new(ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy)
	*p = x
	return p
}

func (x ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_destination_rule_proto_enumTypes[2].Descriptor()
}

func (ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_destination_rule_proto_enumTypes[2]
}

func (x ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy.Descriptor instead.
func (ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{5, 1, 0}
}

// TLS connection mode
type ClientTLSSettings_TLSmode int32

const (
	// Do not setup a TLS connection to the upstream endpoint.
	ClientTLSSettings_DISABLE ClientTLSSettings_TLSmode = 0
	// Originate a TLS connection to the upstream endpoint.
	ClientTLSSettings_SIMPLE ClientTLSSettings_TLSmode = 1
	// Secure connections to the upstream using mutual TLS by presenting
	// client certificates for authentication.
	ClientTLSSettings_MUTUAL ClientTLSSettings_TLSmode = 2
	// Secure connections to the upstream using mutual TLS by presenting
	// client certificates for authentication.
	// Compared to Mutual mode, this mode uses certificates generated
	// automatically by Istio for mTLS authentication. When this mode is
	// used, all other fields in `ClientTLSSettings` should be empty.
	ClientTLSSettings_ISTIO_MUTUAL ClientTLSSettings_TLSmode = 3
)

// Enum value maps for ClientTLSSettings_TLSmode.
var (
	ClientTLSSettings_TLSmode_name = map[int32]string{
		0: "DISABLE",
		1: "SIMPLE",
		2: "MUTUAL",
		3: "ISTIO_MUTUAL",
	}
	ClientTLSSettings_TLSmode_value = map[string]int32{
		"DISABLE":      0,
		"SIMPLE":       1,
		"MUTUAL":       2,
		"ISTIO_MUTUAL": 3,
	}
)

func (x ClientTLSSettings_TLSmode) Enum() *ClientTLSSettings_TLSmode {
	p := new(ClientTLSSettings_TLSmode)
	*p = x
	return p
}

func (x ClientTLSSettings_TLSmode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientTLSSettings_TLSmode) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_destination_rule_proto_enumTypes[3].Descriptor()
}

func (ClientTLSSettings_TLSmode) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_destination_rule_proto_enumTypes[3]
}

func (x ClientTLSSettings_TLSmode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientTLSSettings_TLSmode.Descriptor instead.
func (ClientTLSSettings_TLSmode) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{7, 0}
}

// DestinationRule defines policies that apply to traffic intended for a service
// after routing has occurred.
//
// <!-- crd generation tags
// +cue-gen:DestinationRule:groupName:networking.istio.io
// +cue-gen:DestinationRule:versions:v1,v1beta1,v1alpha3
// +cue-gen:DestinationRule:annotations:helm.sh/resource-policy=keep
// +cue-gen:DestinationRule:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:DestinationRule:subresource:status
// +cue-gen:DestinationRule:scope:Namespaced
// +cue-gen:DestinationRule:resource:categories=istio-io,networking-istio-io,shortNames=dr
// +cue-gen:DestinationRule:printerColumn:name=Host,type=string,JSONPath=.spec.host,description="The name of a service from the service registry"
// +cue-gen:DestinationRule:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. For more information, see [Kubernetes API Conventions](https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata)"
// +cue-gen:DestinationRule:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type DestinationRule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of a service from the service registry. Service
	// names are looked up from the platform's service registry (e.g.,
	// Kubernetes services, Consul services, etc.) and from the hosts
	// declared by [ServiceEntries](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Rules defined for
	// services that do not exist in the service registry will be ignored.
	//
	// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
	// instead of "reviews.default.svc.cluster.local"), Istio will interpret
	// the short name based on the namespace of the rule, not the service. A
	// rule in the "default" namespace containing a host "reviews" will be
	// interpreted as "reviews.default.svc.cluster.local", irrespective of
	// the actual namespace associated with the reviews service. To avoid
	// potential misconfigurations, it is recommended to always use fully
	// qualified domain names over short names.
	//
	// Note that the host field applies to both HTTP and TCP services.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Traffic policies to apply (load balancing policy, connection pool
	// sizes, outlier detection).
	TrafficPolicy *TrafficPolicy `protobuf:"bytes,2,opt,name=traffic_policy,json=trafficPolicy,proto3" json:"traffic_policy,omitempty"`
	// One or more named sets that represent individual versions of a
	// service. Traffic policies can be overridden at subset level.
	Subsets []*Subset `protobuf:"bytes,3,rep,name=subsets,proto3" json:"subsets,omitempty"`
	// A list of namespaces to which this destination rule is exported.
	// The resolution of a destination rule to apply to a service occurs in the
	// context of a hierarchy of namespaces. Exporting a destination rule allows
	// it to be included in the resolution hierarchy for services in
	// other namespaces. This feature provides a mechanism for service owners
	// and mesh administrators to control the visibility of destination rules
	// across namespace boundaries.
	//
	// If no namespaces are specified then the destination rule is exported to all
	// namespaces by default.
	//
	// The value "." is reserved and defines an export to the same namespace that
	// the destination rule is declared in. Similarly, the value "*" is reserved and
	// defines an export to all namespaces.
	ExportTo []string `protobuf:"bytes,4,rep,name=export_to,json=exportTo,proto3" json:"export_to,omitempty"`
	// Criteria used to select the specific set of pods/VMs on which this
	// `DestinationRule` configuration should be applied. If specified, the `DestinationRule`
	// configuration will be applied only to the workload instances matching the workload selector
	// label in the same namespace. Workload selectors do not apply across namespace boundaries.
	// If omitted, the `DestinationRule` falls back to its default behavior.
	// For example, if specific sidecars need to have egress TLS settings for services outside
	// of the mesh, instead of every sidecar in the mesh needing to have the
	// configuration (which is the default behaviour), a workload selector can be specified.
	WorkloadSelector *v1beta1.WorkloadSelector `protobuf:"bytes,5,opt,name=workload_selector,json=workloadSelector,proto3" json:"workload_selector,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *DestinationRule) Reset() {
	*x = DestinationRule{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DestinationRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationRule) ProtoMessage() {}

func (x *DestinationRule) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationRule.ProtoReflect.Descriptor instead.
func (*DestinationRule) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{0}
}

func (x *DestinationRule) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *DestinationRule) GetTrafficPolicy() *TrafficPolicy {
	if x != nil {
		return x.TrafficPolicy
	}
	return nil
}

func (x *DestinationRule) GetSubsets() []*Subset {
	if x != nil {
		return x.Subsets
	}
	return nil
}

func (x *DestinationRule) GetExportTo() []string {
	if x != nil {
		return x.ExportTo
	}
	return nil
}

func (x *DestinationRule) GetWorkloadSelector() *v1beta1.WorkloadSelector {
	if x != nil {
		return x.WorkloadSelector
	}
	return nil
}

// Traffic policies to apply for a specific destination, across all
// destination ports. See DestinationRule for examples.
type TrafficPolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Settings controlling the load balancer algorithms.
	LoadBalancer *LoadBalancerSettings `protobuf:"bytes,1,opt,name=load_balancer,json=loadBalancer,proto3" json:"load_balancer,omitempty"`
	// Settings controlling the volume of connections to an upstream service
	ConnectionPool *ConnectionPoolSettings `protobuf:"bytes,2,opt,name=connection_pool,json=connectionPool,proto3" json:"connection_pool,omitempty"`
	// Settings controlling eviction of unhealthy hosts from the load balancing pool
	OutlierDetection *OutlierDetection `protobuf:"bytes,3,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	// TLS related settings for connections to the upstream service.
	Tls *ClientTLSSettings `protobuf:"bytes,4,opt,name=tls,proto3" json:"tls,omitempty"`
	// Traffic policies specific to individual ports. Note that port level
	// settings will override the destination-level settings. Traffic
	// settings specified at the destination-level will not be inherited when
	// overridden by port-level settings, i.e. default values will be applied
	// to fields omitted in port-level traffic policies.
	// +kubebuilder:validation:MaxItems=4096
	PortLevelSettings []*TrafficPolicy_PortTrafficPolicy `protobuf:"bytes,5,rep,name=port_level_settings,json=portLevelSettings,proto3" json:"port_level_settings,omitempty"`
	// Configuration of tunneling TCP over other transport or application layers
	// for the host configured in the DestinationRule.
	// Tunnel settings can be applied to TCP or TLS routes and can't be applied to HTTP routes.
	Tunnel *TrafficPolicy_TunnelSettings `protobuf:"bytes,6,opt,name=tunnel,proto3" json:"tunnel,omitempty"`
	// The upstream PROXY protocol settings.
	ProxyProtocol *TrafficPolicy_ProxyProtocol `protobuf:"bytes,7,opt,name=proxy_protocol,json=proxyProtocol,proto3" json:"proxy_protocol,omitempty"`
	// Specifies a limit on concurrent retries in relation to the number of active requests.
	RetryBudget   *TrafficPolicy_RetryBudget `protobuf:"bytes,8,opt,name=retry_budget,json=retryBudget,proto3" json:"retry_budget,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficPolicy) Reset() {
	*x = TrafficPolicy{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficPolicy) ProtoMessage() {}

func (x *TrafficPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficPolicy.ProtoReflect.Descriptor instead.
func (*TrafficPolicy) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{1}
}

func (x *TrafficPolicy) GetLoadBalancer() *LoadBalancerSettings {
	if x != nil {
		return x.LoadBalancer
	}
	return nil
}

func (x *TrafficPolicy) GetConnectionPool() *ConnectionPoolSettings {
	if x != nil {
		return x.ConnectionPool
	}
	return nil
}

func (x *TrafficPolicy) GetOutlierDetection() *OutlierDetection {
	if x != nil {
		return x.OutlierDetection
	}
	return nil
}

func (x *TrafficPolicy) GetTls() *ClientTLSSettings {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *TrafficPolicy) GetPortLevelSettings() []*TrafficPolicy_PortTrafficPolicy {
	if x != nil {
		return x.PortLevelSettings
	}
	return nil
}

func (x *TrafficPolicy) GetTunnel() *TrafficPolicy_TunnelSettings {
	if x != nil {
		return x.Tunnel
	}
	return nil
}

func (x *TrafficPolicy) GetProxyProtocol() *TrafficPolicy_ProxyProtocol {
	if x != nil {
		return x.ProxyProtocol
	}
	return nil
}

func (x *TrafficPolicy) GetRetryBudget() *TrafficPolicy_RetryBudget {
	if x != nil {
		return x.RetryBudget
	}
	return nil
}

// A subset of endpoints of a service. Subsets can be used for scenarios
// like A/B testing, or routing to a specific version of a service. Refer
// to [VirtualService](https://istio.io/docs/reference/config/networking/virtual-service/#VirtualService) documentation for examples of using
// subsets in these scenarios. In addition, traffic policies defined at the
// service-level can be overridden at a subset-level. The following rule
// uses a round robin load balancing policy for all traffic going to a
// subset named testversion that is composed of endpoints (e.g., pods) with
// labels (version:v3).
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: bookinfo-ratings
//
// spec:
//
//	host: ratings.prod.svc.cluster.local
//	trafficPolicy:
//	  loadBalancer:
//	    simple: LEAST_REQUEST
//	subsets:
//	- name: testversion
//	  labels:
//	    version: v3
//	  trafficPolicy:
//	    loadBalancer:
//	      simple: ROUND_ROBIN
//
// ```
//
// **Note:** Policies specified for subsets will not take effect until
// a route rule explicitly sends traffic to this subset.
//
// One or more labels are typically required to identify the subset destination,
// however, when the corresponding DestinationRule represents a host that
// supports multiple SNI hosts (e.g., an egress gateway), a subset without labels
// may be meaningful. In this case a traffic policy with [ClientTLSSettings](#ClientTLSSettings)
// can be used to identify a specific SNI host corresponding to the named subset.
type Subset struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the subset. The service name and the subset name can
	// be used for traffic splitting in a route rule.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Labels apply a filter over the endpoints of a service in the
	// service registry. See route rules for examples of usage.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Traffic policies that apply to this subset. Subsets inherit the
	// traffic policies specified at the DestinationRule level. Settings
	// specified at the subset level will override the corresponding settings
	// specified at the DestinationRule level.
	TrafficPolicy *TrafficPolicy `protobuf:"bytes,3,opt,name=traffic_policy,json=trafficPolicy,proto3" json:"traffic_policy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Subset) Reset() {
	*x = Subset{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Subset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subset) ProtoMessage() {}

func (x *Subset) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subset.ProtoReflect.Descriptor instead.
func (*Subset) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{2}
}

func (x *Subset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subset) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Subset) GetTrafficPolicy() *TrafficPolicy {
	if x != nil {
		return x.TrafficPolicy
	}
	return nil
}

// Load balancing policies to apply for a specific destination. See Envoy's
// load balancing
// [documentation](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/load_balancing)
// for more details.
//
// For example, the following rule uses a round robin load balancing policy
// for all traffic going to the ratings service.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: bookinfo-ratings
//
// spec:
//
//	host: ratings.prod.svc.cluster.local
//	trafficPolicy:
//	  loadBalancer:
//	    simple: ROUND_ROBIN
//
// ```
//
// The following example sets up sticky sessions for the ratings service
// hashing-based load balancer for the same ratings service using the
// the User cookie as the hash key.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: bookinfo-ratings
//
// spec:
//
//	host: ratings.prod.svc.cluster.local
//	trafficPolicy:
//	  loadBalancer:
//	    consistentHash:
//	      httpCookie:
//	        name: user
//	        ttl: 0s
//
// ```
type LoadBalancerSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Upstream load balancing policy.
	//
	// Types that are valid to be assigned to LbPolicy:
	//
	//	*LoadBalancerSettings_Simple
	//	*LoadBalancerSettings_ConsistentHash
	LbPolicy isLoadBalancerSettings_LbPolicy `protobuf_oneof:"lb_policy"`
	// Locality load balancer settings, this will override mesh-wide settings in entirety, meaning no merging would be performed
	// between this object and the object one in MeshConfig
	LocalityLbSetting *LocalityLoadBalancerSetting `protobuf:"bytes,3,opt,name=locality_lb_setting,json=localityLbSetting,proto3" json:"locality_lb_setting,omitempty"`
	// Deprecated: use `warmup` instead.
	WarmupDurationSecs *duration.Duration `protobuf:"bytes,4,opt,name=warmup_duration_secs,json=warmupDurationSecs,proto3" json:"warmup_duration_secs,omitempty"`
	// Represents the warmup configuration of Service. If set, the newly created endpoint of service
	// remains in warmup mode starting from its creation time for the duration of this window and
	// Istio progressively increases amount of traffic for that endpoint instead of sending proportional amount of traffic.
	// This should be enabled for services that require warm up time to serve full production load with reasonable latency.
	// Please note that this is most effective when few new endpoints come up like scale event in Kubernetes. When all the
	// endpoints are relatively new like new deployment, this is not very effective as all endpoints end up getting same
	// amount of requests.
	// Currently this is only supported for ROUND_ROBIN and LEAST_REQUEST load balancers.
	Warmup        *WarmupConfiguration `protobuf:"bytes,5,opt,name=warmup,proto3" json:"warmup,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoadBalancerSettings) Reset() {
	*x = LoadBalancerSettings{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerSettings) ProtoMessage() {}

func (x *LoadBalancerSettings) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerSettings.ProtoReflect.Descriptor instead.
func (*LoadBalancerSettings) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{3}
}

func (x *LoadBalancerSettings) GetLbPolicy() isLoadBalancerSettings_LbPolicy {
	if x != nil {
		return x.LbPolicy
	}
	return nil
}

func (x *LoadBalancerSettings) GetSimple() LoadBalancerSettings_SimpleLB {
	if x != nil {
		if x, ok := x.LbPolicy.(*LoadBalancerSettings_Simple); ok {
			return x.Simple
		}
	}
	return LoadBalancerSettings_UNSPECIFIED
}

func (x *LoadBalancerSettings) GetConsistentHash() *LoadBalancerSettings_ConsistentHashLB {
	if x != nil {
		if x, ok := x.LbPolicy.(*LoadBalancerSettings_ConsistentHash); ok {
			return x.ConsistentHash
		}
	}
	return nil
}

func (x *LoadBalancerSettings) GetLocalityLbSetting() *LocalityLoadBalancerSetting {
	if x != nil {
		return x.LocalityLbSetting
	}
	return nil
}

func (x *LoadBalancerSettings) GetWarmupDurationSecs() *duration.Duration {
	if x != nil {
		return x.WarmupDurationSecs
	}
	return nil
}

func (x *LoadBalancerSettings) GetWarmup() *WarmupConfiguration {
	if x != nil {
		return x.Warmup
	}
	return nil
}

type isLoadBalancerSettings_LbPolicy interface {
	isLoadBalancerSettings_LbPolicy()
}

type LoadBalancerSettings_Simple struct {
	Simple LoadBalancerSettings_SimpleLB `protobuf:"varint,1,opt,name=simple,proto3,enum=istio.networking.v1alpha3.LoadBalancerSettings_SimpleLB,oneof"`
}

type LoadBalancerSettings_ConsistentHash struct {
	ConsistentHash *LoadBalancerSettings_ConsistentHashLB `protobuf:"bytes,2,opt,name=consistent_hash,json=consistentHash,proto3,oneof"`
}

func (*LoadBalancerSettings_Simple) isLoadBalancerSettings_LbPolicy() {}

func (*LoadBalancerSettings_ConsistentHash) isLoadBalancerSettings_LbPolicy() {}

type WarmupConfiguration struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Duration of warmup mode
	Duration *duration.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
	// Configures the minimum percentage of origin weight
	// If unspecified, defaults to 10
	// +kubebuilder:validation:Maximum=100
	// +kubebuilder:validation:Minimum=0
	MinimumPercent *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=minimum_percent,json=minimumPercent,proto3" json:"minimum_percent,omitempty"`
	// This parameter controls the speed of traffic increase over the warmup duration. Defaults to 1.0, so that endpoints would
	// get linearly increasing amount of traffic. When increasing the value for this parameter,
	// the speed of traffic ramp-up increases non-linearly.
	// +kubebuilder:validation:Minimum=0
	Aggression    *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=aggression,proto3" json:"aggression,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WarmupConfiguration) Reset() {
	*x = WarmupConfiguration{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WarmupConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WarmupConfiguration) ProtoMessage() {}

func (x *WarmupConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WarmupConfiguration.ProtoReflect.Descriptor instead.
func (*WarmupConfiguration) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{4}
}

func (x *WarmupConfiguration) GetDuration() *duration.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *WarmupConfiguration) GetMinimumPercent() *wrappers.DoubleValue {
	if x != nil {
		return x.MinimumPercent
	}
	return nil
}

func (x *WarmupConfiguration) GetAggression() *wrappers.DoubleValue {
	if x != nil {
		return x.Aggression
	}
	return nil
}

// Connection pool settings for an upstream host. The settings apply to
// each individual host in the upstream service.  See Envoy's [circuit
// breaker](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/circuit_breaking)
// for more details. Connection pool settings can be applied at the TCP
// level as well as at HTTP level.
//
// For example, the following rule sets a limit of 100 connections to redis
// service called myredissrv with a connect timeout of 30ms
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: bookinfo-redis
//
// spec:
//
//	host: myredissrv.prod.svc.cluster.local
//	trafficPolicy:
//	  connectionPool:
//	    tcp:
//	      maxConnections: 100
//	      connectTimeout: 30ms
//	      tcpKeepalive:
//	        time: 7200s
//	        interval: 75s
//
// ```
type ConnectionPoolSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Settings common to both HTTP and TCP upstream connections.
	Tcp *ConnectionPoolSettings_TCPSettings `protobuf:"bytes,1,opt,name=tcp,proto3" json:"tcp,omitempty"`
	// HTTP connection pool settings.
	Http          *ConnectionPoolSettings_HTTPSettings `protobuf:"bytes,2,opt,name=http,proto3" json:"http,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConnectionPoolSettings) Reset() {
	*x = ConnectionPoolSettings{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionPoolSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionPoolSettings) ProtoMessage() {}

func (x *ConnectionPoolSettings) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionPoolSettings.ProtoReflect.Descriptor instead.
func (*ConnectionPoolSettings) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{5}
}

func (x *ConnectionPoolSettings) GetTcp() *ConnectionPoolSettings_TCPSettings {
	if x != nil {
		return x.Tcp
	}
	return nil
}

func (x *ConnectionPoolSettings) GetHttp() *ConnectionPoolSettings_HTTPSettings {
	if x != nil {
		return x.Http
	}
	return nil
}

// A Circuit breaker implementation that tracks the status of each
// individual host in the upstream service.  Applicable to both HTTP and
// TCP services.  For HTTP services, hosts that continually return 5xx
// errors for API calls are ejected from the pool for a pre-defined period
// of time. For TCP services, connection timeouts or connection
// failures to a given host counts as an error when measuring the
// consecutive errors metric. See Envoy's [outlier
// detection](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/outlier)
// for more details.
//
// The following rule sets a connection pool size of 100 HTTP1 connections
// with no more than 10 req/connection to the "reviews" service. In addition,
// it sets a limit of 1000 concurrent HTTP/2 requests and configures upstream
// hosts to be scanned every 5 mins so that any host that fails 7 consecutive
// times with a 502, 503, or 504 error code will be ejected for 15 minutes.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: reviews-cb-policy
//
// spec:
//
//	host: reviews.prod.svc.cluster.local
//	trafficPolicy:
//	  connectionPool:
//	    tcp:
//	      maxConnections: 100
//	    http:
//	      http2MaxRequests: 1000
//	      maxRequestsPerConnection: 10
//	  outlierDetection:
//	    consecutive5xxErrors: 7
//	    interval: 5m
//	    baseEjectionTime: 15m
//
// ```
type OutlierDetection struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of errors before a host is ejected from the connection
	// pool. Defaults to 5. When the upstream host is accessed over HTTP, a
	// 502, 503, or 504 return code qualifies as an error. When the upstream host
	// is accessed over an opaque TCP connection, connect timeouts and
	// connection error/failure events qualify as an error.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/destination_rule.proto.
	ConsecutiveErrors int32 `protobuf:"varint,1,opt,name=consecutive_errors,json=consecutiveErrors,proto3" json:"consecutive_errors,omitempty"`
	// Determines whether to distinguish local origin failures from external errors. If set to true
	// `consecutiveLocalOriginFailures` is taken into account for outlier detection calculations.
	// This should be used when you want to derive the outlier detection status based on the errors
	// seen locally such as failure to connect, timeout while connecting etc. rather than the status code
	// returned by upstream service. This is especially useful when the upstream service explicitly returns
	// a 5xx for some requests and you want to ignore those responses from upstream service while determining
	// the outlier detection status of a host.
	// Defaults to false.
	SplitExternalLocalOriginErrors bool `protobuf:"varint,8,opt,name=split_external_local_origin_errors,json=splitExternalLocalOriginErrors,proto3" json:"split_external_local_origin_errors,omitempty"`
	// The number of consecutive locally originated failures before ejection
	// occurs. Defaults to 5. Parameter takes effect only when `splitExternalLocalOriginErrors`
	// is set to true.
	ConsecutiveLocalOriginFailures *wrappers.UInt32Value `protobuf:"bytes,9,opt,name=consecutive_local_origin_failures,json=consecutiveLocalOriginFailures,proto3" json:"consecutive_local_origin_failures,omitempty"`
	// Number of gateway errors before a host is ejected from the connection pool.
	// When the upstream host is accessed over HTTP, a 502, 503, or 504 return
	// code qualifies as a gateway error. When the upstream host is accessed over
	// an opaque TCP connection, connect timeouts and connection error/failure
	// events qualify as a gateway error.
	// This feature is disabled by default or when set to the value 0.
	//
	// Note that `consecutiveGatewayErrors` and `consecutive5xxErrors` can be
	// used separately or together. Because the errors counted by
	// `consecutiveGatewayErrors` are also included in `consecutive5xxErrors`,
	// if the value of `consecutiveGatewayErrors` is greater than or equal to
	// the value of `consecutive5xxErrors`, `consecutiveGatewayErrors` will have
	// no effect.
	ConsecutiveGatewayErrors *wrappers.UInt32Value `protobuf:"bytes,6,opt,name=consecutive_gateway_errors,json=consecutiveGatewayErrors,proto3" json:"consecutive_gateway_errors,omitempty"`
	// Number of 5xx errors before a host is ejected from the connection pool.
	// When the upstream host is accessed over an opaque TCP connection, connect
	// timeouts, connection error/failure and request failure events qualify as a
	// 5xx error.
	// This feature defaults to 5 but can be disabled by setting the value to 0.
	//
	// Note that `consecutiveGatewayErrors` and `consecutive5xxErrors` can be
	// used separately or together. Because the errors counted by
	// `consecutiveGatewayErrors` are also included in `consecutive5xxErrors`,
	// if the value of `consecutiveGatewayErrors` is greater than or equal to
	// the value of `consecutive5xxErrors`, `consecutiveGatewayErrors` will have
	// no effect.
	Consecutive_5XxErrors *wrappers.UInt32Value `protobuf:"bytes,7,opt,name=consecutive_5xx_errors,json=consecutive5xxErrors,proto3" json:"consecutive_5xx_errors,omitempty"`
	// Time interval between ejection sweep analysis. format:
	// 1h/1m/1s/1ms. MUST be >=1ms. Default is 10s.
	Interval *duration.Duration `protobuf:"bytes,2,opt,name=interval,proto3" json:"interval,omitempty"`
	// Minimum ejection duration. A host will remain ejected for a period
	// equal to the product of minimum ejection duration and the number of
	// times the host has been ejected. This technique allows the system to
	// automatically increase the ejection period for unhealthy upstream
	// servers. format: 1h/1m/1s/1ms. MUST be >=1ms. Default is 30s.
	BaseEjectionTime *duration.Duration `protobuf:"bytes,3,opt,name=base_ejection_time,json=baseEjectionTime,proto3" json:"base_ejection_time,omitempty"`
	// Maximum % of hosts in the load balancing pool for the upstream
	// service that can be ejected. Defaults to 10%.
	MaxEjectionPercent int32 `protobuf:"varint,4,opt,name=max_ejection_percent,json=maxEjectionPercent,proto3" json:"max_ejection_percent,omitempty"`
	// Outlier detection will be enabled as long as the associated load balancing
	// pool has at least `minHealthPercent` hosts in healthy mode. When the
	// percentage of healthy hosts in the load balancing pool drops below this
	// threshold, outlier detection will be disabled and the proxy will load balance
	// across all hosts in the pool (healthy and unhealthy). The threshold can be
	// disabled by setting it to 0%. The default is 0% as it's not typically
	// applicable in k8s environments with few pods per service.
	MinHealthPercent int32 `protobuf:"varint,5,opt,name=min_health_percent,json=minHealthPercent,proto3" json:"min_health_percent,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *OutlierDetection) Reset() {
	*x = OutlierDetection{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutlierDetection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutlierDetection) ProtoMessage() {}

func (x *OutlierDetection) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutlierDetection.ProtoReflect.Descriptor instead.
func (*OutlierDetection) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{6}
}

// Deprecated: Marked as deprecated in networking/v1alpha3/destination_rule.proto.
func (x *OutlierDetection) GetConsecutiveErrors() int32 {
	if x != nil {
		return x.ConsecutiveErrors
	}
	return 0
}

func (x *OutlierDetection) GetSplitExternalLocalOriginErrors() bool {
	if x != nil {
		return x.SplitExternalLocalOriginErrors
	}
	return false
}

func (x *OutlierDetection) GetConsecutiveLocalOriginFailures() *wrappers.UInt32Value {
	if x != nil {
		return x.ConsecutiveLocalOriginFailures
	}
	return nil
}

func (x *OutlierDetection) GetConsecutiveGatewayErrors() *wrappers.UInt32Value {
	if x != nil {
		return x.ConsecutiveGatewayErrors
	}
	return nil
}

func (x *OutlierDetection) GetConsecutive_5XxErrors() *wrappers.UInt32Value {
	if x != nil {
		return x.Consecutive_5XxErrors
	}
	return nil
}

func (x *OutlierDetection) GetInterval() *duration.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *OutlierDetection) GetBaseEjectionTime() *duration.Duration {
	if x != nil {
		return x.BaseEjectionTime
	}
	return nil
}

func (x *OutlierDetection) GetMaxEjectionPercent() int32 {
	if x != nil {
		return x.MaxEjectionPercent
	}
	return 0
}

func (x *OutlierDetection) GetMinHealthPercent() int32 {
	if x != nil {
		return x.MinHealthPercent
	}
	return 0
}

// SSL/TLS related settings for upstream connections. See Envoy's [TLS
// context](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/transport_sockets/tls/v3/common.proto.html#common-tls-configuration)
// for more details. These settings are common to both HTTP and TCP upstreams.
//
// For example, the following rule configures a client to use mutual TLS
// for connections to upstream database cluster.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: db-mtls
//
// spec:
//
//	host: mydbserver.prod.svc.cluster.local
//	trafficPolicy:
//	  tls:
//	    mode: MUTUAL
//	    clientCertificate: /etc/certs/myclientcert.pem
//	    privateKey: /etc/certs/client_private_key.pem
//	    caCertificates: /etc/certs/rootcacerts.pem
//
// ```
//
// The following rule configures a client to use TLS when talking to a
// foreign service whose domain matches *.foo.com.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: tls-foo
//
// spec:
//
//	host: "*.foo.com"
//	trafficPolicy:
//	  tls:
//	    mode: SIMPLE
//
// ```
//
// The following rule configures a client to use Istio mutual TLS when talking
// to rating services.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: ratings-istio-mtls
//
// spec:
//
//	host: ratings.prod.svc.cluster.local
//	trafficPolicy:
//	  tls:
//	    mode: ISTIO_MUTUAL
//
// ```
type ClientTLSSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Indicates whether connections to this port should be secured
	// using TLS. The value of this field determines how TLS is enforced.
	Mode ClientTLSSettings_TLSmode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.networking.v1alpha3.ClientTLSSettings_TLSmode" json:"mode,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to the file holding the
	// client-side TLS certificate to use.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	ClientCertificate string `protobuf:"bytes,2,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to the file holding the
	// client's private key.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	PrivateKey string `protobuf:"bytes,3,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// OPTIONAL: The path to the file containing certificate authority
	// certificates to use in verifying a presented server certificate. If
	// omitted, the proxy will verify the server's certificate using
	// the OS CA certificates.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	CaCertificates string `protobuf:"bytes,4,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// The name of the secret that holds the TLS certs for the
	// client including the CA certificates. This secret must exist in
	// the namespace of the proxy using the certificates.
	// An Opaque secret should contain the following keys and values:
	// `key: <privateKey>`, `cert: <clientCert>`, `cacert: <CACertificate>`,
	// `crl: <certificateRevocationList>`
	// Here CACertificate is used to verify the server certificate.
	// For mutual TLS, `cacert: <CACertificate>` can be provided in the
	// same secret or a separate secret named `<secret>-cacert`.
	// A TLS secret for client certificates with an additional
	// `ca.crt` key for CA certificates and `ca.crl` key for
	// certificate revocation list(CRL) is also supported.
	// Only one of client certificates and CA certificate
	// or credentialName can be specified.
	//
	// **NOTE:** This field is applicable at sidecars only if
	// `DestinationRule` has a `workloadSelector` specified.
	// Otherwise the field will be applicable only at gateways, and
	// sidecars will continue to use the certificate paths.
	CredentialName string `protobuf:"bytes,7,opt,name=credential_name,json=credentialName,proto3" json:"credential_name,omitempty"`
	// A list of alternate names to verify the subject identity in the
	// certificate. If specified, the proxy will verify that the server
	// certificate's subject alt name matches one of the specified values.
	// If specified, this list overrides the value of `subjectAltNames`
	// from the `ServiceEntry`. If unspecified, automatic validation of upstream
	// presented certificate for new upstream connections will be done based on the
	// downstream HTTP host/authority header.
	SubjectAltNames []string `protobuf:"bytes,5,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
	// SNI string to present to the server during TLS handshake.
	// If unspecified, SNI will be automatically set based on downstream HTTP
	// host/authority header for SIMPLE and MUTUAL TLS modes.
	Sni string `protobuf:"bytes,6,opt,name=sni,proto3" json:"sni,omitempty"`
	// `insecureSkipVerify` specifies whether the proxy should skip verifying the
	// CA signature and SAN for the server certificate corresponding to the host.
	// The default value of this field is false.
	InsecureSkipVerify *wrappers.BoolValue `protobuf:"bytes,8,opt,name=insecure_skip_verify,json=insecureSkipVerify,proto3" json:"insecure_skip_verify,omitempty"`
	// OPTIONAL: The path to the file containing the certificate revocation list (CRL)
	// to use in verifying a presented server certificate. `CRL` is a list of certificates
	// that have been revoked by the CA (Certificate Authority) before their scheduled expiration date.
	// If specified, the proxy will verify if the presented certificate is part of the revoked list of certificates.
	// If omitted, the proxy will not verify the certificate against the `crl`. Note that if `credentialName` is set,
	// `CRL` cannot be specified using `caCrl`, rather it has to be specified inside the credential.
	CaCrl         string `protobuf:"bytes,9,opt,name=ca_crl,json=caCrl,proto3" json:"ca_crl,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClientTLSSettings) Reset() {
	*x = ClientTLSSettings{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientTLSSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientTLSSettings) ProtoMessage() {}

func (x *ClientTLSSettings) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientTLSSettings.ProtoReflect.Descriptor instead.
func (*ClientTLSSettings) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{7}
}

func (x *ClientTLSSettings) GetMode() ClientTLSSettings_TLSmode {
	if x != nil {
		return x.Mode
	}
	return ClientTLSSettings_DISABLE
}

func (x *ClientTLSSettings) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *ClientTLSSettings) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (x *ClientTLSSettings) GetCaCertificates() string {
	if x != nil {
		return x.CaCertificates
	}
	return ""
}

func (x *ClientTLSSettings) GetCredentialName() string {
	if x != nil {
		return x.CredentialName
	}
	return ""
}

func (x *ClientTLSSettings) GetSubjectAltNames() []string {
	if x != nil {
		return x.SubjectAltNames
	}
	return nil
}

func (x *ClientTLSSettings) GetSni() string {
	if x != nil {
		return x.Sni
	}
	return ""
}

func (x *ClientTLSSettings) GetInsecureSkipVerify() *wrappers.BoolValue {
	if x != nil {
		return x.InsecureSkipVerify
	}
	return nil
}

func (x *ClientTLSSettings) GetCaCrl() string {
	if x != nil {
		return x.CaCrl
	}
	return ""
}

// Locality-weighted load balancing allows administrators to control the
// distribution of traffic to endpoints based on the localities of where the
// traffic originates and where it will terminate. These localities are
// specified using arbitrary labels that designate a hierarchy of localities in
// {region}/{zone}/{sub-zone} form. For additional detail refer to
// [Locality Weight](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/locality_weight)
// The following example shows how to setup locality weights mesh-wide.
//
// Given a mesh with workloads and their service deployed to "us-west/zone1/\*"
// and "us-west/zone2/\*". This example specifies that when traffic accessing a
// service originates from workloads in "us-west/zone1/\*", 80% of the traffic
// will be sent to endpoints in "us-west/zone1/\*", i.e the same zone, and the
// remaining 20% will go to endpoints in "us-west/zone2/\*". This setup is
// intended to favor routing traffic to endpoints in the same locality.
// A similar setting is specified for traffic originating in "us-west/zone2/\*".
//
// ```yaml
//
//	distribute:
//	  - from: us-west/zone1/*
//	    to:
//	      "us-west/zone1/*": 80
//	      "us-west/zone2/*": 20
//	  - from: us-west/zone2/*
//	    to:
//	      "us-west/zone1/*": 20
//	      "us-west/zone2/*": 80
//
// ```
//
// If the goal of the operator is not to distribute load across zones and
// regions but rather to restrict the regionality of failover to meet other
// operational requirements an operator can set a 'failover' policy instead of
// a 'distribute' policy.
//
// The following example sets up a locality failover policy for regions.
// Assume a service resides in zones within us-east, us-west & eu-west
// this example specifies that when endpoints within us-east become unhealthy
// traffic should failover to endpoints in any zone or sub-zone within eu-west
// and similarly us-west should failover to us-east.
//
// ```yaml
//
//	failover:
//	  - from: us-east
//	    to: eu-west
//	  - from: us-west
//	    to: us-east
//
// ```
type LocalityLoadBalancerSetting struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional: only one of distribute, failover or failoverPriority can be set.
	// Explicitly specify loadbalancing weight across different zones and geographical locations.
	// Refer to [Locality weighted load balancing](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/locality_weight)
	// If empty, the locality weight is set according to the endpoints number within it.
	Distribute []*LocalityLoadBalancerSetting_Distribute `protobuf:"bytes,1,rep,name=distribute,proto3" json:"distribute,omitempty"`
	// Optional: only one of distribute, failover or failoverPriority can be set.
	// Explicitly specify the region traffic will land on when endpoints in local region becomes unhealthy.
	// Should be used together with OutlierDetection to detect unhealthy endpoints.
	// Note: if no OutlierDetection specified, this will not take effect.
	Failover []*LocalityLoadBalancerSetting_Failover `protobuf:"bytes,2,rep,name=failover,proto3" json:"failover,omitempty"`
	// failoverPriority is an ordered list of labels used to sort endpoints to do priority based load balancing.
	// This is to support traffic failover across different groups of endpoints.
	// Two kinds of labels can be specified:
	//
	//   - Specify only label keys `[key1, key2, key3]`, istio would compare the label values of client with endpoints.
	//     Suppose there are total N label keys `[key1, key2, key3, ...keyN]` specified:
	//
	//     1. Endpoints matching all N labels with the client proxy have priority P(0) i.e. the highest priority.
	//     2. Endpoints matching the first N-1 labels with the client proxy have priority P(1) i.e. second highest priority.
	//     3. By extension of this logic, endpoints matching only the first label with the client proxy has priority P(N-1) i.e. second lowest priority.
	//     4. All the other endpoints have priority P(N) i.e. lowest priority.
	//
	//   - Specify labels with key and value `[key1=value1, key2=value2, key3=value3]`, istio would compare the labels with endpoints.
	//     Suppose there are total N labels `[key1=value1, key2=value2, key3=value3, ...keyN=valueN]` specified:
	//
	//     1. Endpoints matching all N labels have priority P(0) i.e. the highest priority.
	//     2. Endpoints matching the first N-1 labels have priority P(1) i.e. second highest priority.
	//     3. By extension of this logic, endpoints matching only the first label has priority P(N-1) i.e. second lowest priority.
	//     4. All the other endpoints have priority P(N) i.e. lowest priority.
	//
	// Note: For a label to be considered for match, the previous labels must match, i.e. nth label would be considered matched only if first n-1 labels match.
	//
	// It can be any label specified on both client and server workloads.
	// The following labels which have special semantic meaning are also supported:
	//
	//   - `topology.istio.io/network` is used to match the network metadata of an endpoint, which can be specified by pod/namespace label `topology.istio.io/network`, sidecar env `ISTIO_META_NETWORK` or MeshNetworks.
	//   - `topology.istio.io/cluster` is used to match the clusterID of an endpoint, which can be specified by pod label `topology.istio.io/cluster` or pod env `ISTIO_META_CLUSTER_ID`.
	//   - `topology.kubernetes.io/region` is used to match the region metadata of an endpoint, which maps to Kubernetes node label `topology.kubernetes.io/region` or the deprecated label `failure-domain.beta.kubernetes.io/region`.
	//   - `topology.kubernetes.io/zone` is used to match the zone metadata of an endpoint, which maps to Kubernetes node label `topology.kubernetes.io/zone` or the deprecated label `failure-domain.beta.kubernetes.io/zone`.
	//   - `topology.istio.io/subzone` is used to match the subzone metadata of an endpoint, which maps to Istio node label `topology.istio.io/subzone`.
	//   - `kubernetes.io/hostname` is used to match the current node of an endpoint, which maps to Kubernetes node label `kubernetes.io/hostname`.
	//
	// The below topology config indicates the following priority levels:
	//
	// ```yaml
	// failoverPriority:
	// - "topology.istio.io/network"
	// - "topology.kubernetes.io/region"
	// - "topology.kubernetes.io/zone"
	// - "topology.istio.io/subzone"
	// ```
	//
	// 1. endpoints match same [network, region, zone, subzone] label with the client proxy have the highest priority.
	// 2. endpoints have same [network, region, zone] label but different [subzone] label with the client proxy have the second highest priority.
	// 3. endpoints have same [network, region] label but different [zone] label with the client proxy have the third highest priority.
	// 4. endpoints have same [network] but different [region] labels with the client proxy have the fourth highest priority.
	// 5. all the other endpoints have the same lowest priority.
	//
	// Suppose a service associated endpoints reside in multi clusters, the below example represents:
	// 1. endpoints in `clusterA` and has `version=v1` label have P(0) priority.
	// 2. endpoints not in `clusterA` but has `version=v1` label have P(1) priority.
	// 2. all the other endpoints have P(2) priority.
	//
	// ```yaml
	// failoverPriority:
	// - "version=v1"
	// - "topology.istio.io/cluster=clusterA"
	// ```
	//
	// Optional: only one of distribute, failover or failoverPriority can be set.
	// And it should be used together with `OutlierDetection` to detect unhealthy endpoints, otherwise has no effect.
	FailoverPriority []string `protobuf:"bytes,4,rep,name=failover_priority,json=failoverPriority,proto3" json:"failover_priority,omitempty"`
	// Enable locality load balancing. This is DestinationRule-level and will override mesh-wide settings in entirety.
	// e.g. true means that turn on locality load balancing for this DestinationRule no matter what mesh-wide settings is.
	Enabled       *wrappers.BoolValue `protobuf:"bytes,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LocalityLoadBalancerSetting) Reset() {
	*x = LocalityLoadBalancerSetting{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalityLoadBalancerSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalityLoadBalancerSetting) ProtoMessage() {}

func (x *LocalityLoadBalancerSetting) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalityLoadBalancerSetting.ProtoReflect.Descriptor instead.
func (*LocalityLoadBalancerSetting) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{8}
}

func (x *LocalityLoadBalancerSetting) GetDistribute() []*LocalityLoadBalancerSetting_Distribute {
	if x != nil {
		return x.Distribute
	}
	return nil
}

func (x *LocalityLoadBalancerSetting) GetFailover() []*LocalityLoadBalancerSetting_Failover {
	if x != nil {
		return x.Failover
	}
	return nil
}

func (x *LocalityLoadBalancerSetting) GetFailoverPriority() []string {
	if x != nil {
		return x.FailoverPriority
	}
	return nil
}

func (x *LocalityLoadBalancerSetting) GetEnabled() *wrappers.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// Traffic policies that apply to specific ports of the service
type TrafficPolicy_PortTrafficPolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the number of a port on the destination service
	// on which this policy is being applied.
	Port *PortSelector `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	// Settings controlling the load balancer algorithms.
	LoadBalancer *LoadBalancerSettings `protobuf:"bytes,2,opt,name=load_balancer,json=loadBalancer,proto3" json:"load_balancer,omitempty"`
	// Settings controlling the volume of connections to an upstream service
	ConnectionPool *ConnectionPoolSettings `protobuf:"bytes,3,opt,name=connection_pool,json=connectionPool,proto3" json:"connection_pool,omitempty"`
	// Settings controlling eviction of unhealthy hosts from the load balancing pool
	OutlierDetection *OutlierDetection `protobuf:"bytes,4,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	// TLS related settings for connections to the upstream service.
	Tls           *ClientTLSSettings `protobuf:"bytes,5,opt,name=tls,proto3" json:"tls,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficPolicy_PortTrafficPolicy) Reset() {
	*x = TrafficPolicy_PortTrafficPolicy{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficPolicy_PortTrafficPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficPolicy_PortTrafficPolicy) ProtoMessage() {}

func (x *TrafficPolicy_PortTrafficPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficPolicy_PortTrafficPolicy.ProtoReflect.Descriptor instead.
func (*TrafficPolicy_PortTrafficPolicy) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{1, 0}
}

func (x *TrafficPolicy_PortTrafficPolicy) GetPort() *PortSelector {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *TrafficPolicy_PortTrafficPolicy) GetLoadBalancer() *LoadBalancerSettings {
	if x != nil {
		return x.LoadBalancer
	}
	return nil
}

func (x *TrafficPolicy_PortTrafficPolicy) GetConnectionPool() *ConnectionPoolSettings {
	if x != nil {
		return x.ConnectionPool
	}
	return nil
}

func (x *TrafficPolicy_PortTrafficPolicy) GetOutlierDetection() *OutlierDetection {
	if x != nil {
		return x.OutlierDetection
	}
	return nil
}

func (x *TrafficPolicy_PortTrafficPolicy) GetTls() *ClientTLSSettings {
	if x != nil {
		return x.Tls
	}
	return nil
}

type TrafficPolicy_TunnelSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies which protocol to use for tunneling the downstream connection.
	// Supported protocols are:
	//   - CONNECT - uses HTTP CONNECT;
	//   - POST - uses HTTP POST.
	//
	// CONNECT is used by default if not specified.
	//
	// HTTP version for upstream requests is determined by the service protocol defined for the proxy.
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Specifies a host to which the downstream connection is tunneled.
	// Target host must be an FQDN or IP address.
	TargetHost string `protobuf:"bytes,2,opt,name=target_host,json=targetHost,proto3" json:"target_host,omitempty"`
	// Specifies a port to which the downstream connection is tunneled.
	TargetPort    uint32 `protobuf:"varint,3,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficPolicy_TunnelSettings) Reset() {
	*x = TrafficPolicy_TunnelSettings{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficPolicy_TunnelSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficPolicy_TunnelSettings) ProtoMessage() {}

func (x *TrafficPolicy_TunnelSettings) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficPolicy_TunnelSettings.ProtoReflect.Descriptor instead.
func (*TrafficPolicy_TunnelSettings) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{1, 1}
}

func (x *TrafficPolicy_TunnelSettings) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *TrafficPolicy_TunnelSettings) GetTargetHost() string {
	if x != nil {
		return x.TargetHost
	}
	return ""
}

func (x *TrafficPolicy_TunnelSettings) GetTargetPort() uint32 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

type TrafficPolicy_ProxyProtocol struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The PROXY protocol version to use. See [the protocol spec](https://www.haproxy.org/download/2.1/doc/proxy-protocol.txt) for details.
	// By default it is `V1`.
	Version       TrafficPolicy_ProxyProtocol_VERSION `protobuf:"varint,1,opt,name=version,proto3,enum=istio.networking.v1alpha3.TrafficPolicy_ProxyProtocol_VERSION" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TrafficPolicy_ProxyProtocol) Reset() {
	*x = TrafficPolicy_ProxyProtocol{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficPolicy_ProxyProtocol) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficPolicy_ProxyProtocol) ProtoMessage() {}

func (x *TrafficPolicy_ProxyProtocol) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficPolicy_ProxyProtocol.ProtoReflect.Descriptor instead.
func (*TrafficPolicy_ProxyProtocol) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{1, 2}
}

func (x *TrafficPolicy_ProxyProtocol) GetVersion() TrafficPolicy_ProxyProtocol_VERSION {
	if x != nil {
		return x.Version
	}
	return TrafficPolicy_ProxyProtocol_V1
}

type TrafficPolicy_RetryBudget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the limit on concurrent retries as a percentage of
	// the sum of active requests and active pending requests.
	// Defaults to 20%.
	//
	// +kubebuilder:validation:Maximum=100
	// +kubebuilder:validation:Minimum=0
	Percent *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=percent,proto3" json:"percent,omitempty"`
	// Specifies the minimum retry concurrency allowed for the retry budget.
	// For example, a budget of 20% with a minimum retry concurrency of 3
	// will allow 5 active retries while there are 25 active requests.
	// If there are 2 active requests, there are still 3 active retries
	// allowed because of the minimum retry concurrency.
	//
	// Defaults to 3.
	MinRetryConcurrency uint32 `protobuf:"varint,2,opt,name=min_retry_concurrency,json=minRetryConcurrency,proto3" json:"min_retry_concurrency,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *TrafficPolicy_RetryBudget) Reset() {
	*x = TrafficPolicy_RetryBudget{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TrafficPolicy_RetryBudget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficPolicy_RetryBudget) ProtoMessage() {}

func (x *TrafficPolicy_RetryBudget) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficPolicy_RetryBudget.ProtoReflect.Descriptor instead.
func (*TrafficPolicy_RetryBudget) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{1, 3}
}

func (x *TrafficPolicy_RetryBudget) GetPercent() *wrappers.DoubleValue {
	if x != nil {
		return x.Percent
	}
	return nil
}

func (x *TrafficPolicy_RetryBudget) GetMinRetryConcurrency() uint32 {
	if x != nil {
		return x.MinRetryConcurrency
	}
	return 0
}

// Consistent Hash-based load balancing can be used to provide soft
// session affinity based on HTTP headers, cookies or other
// properties. The affinity to a particular destination host may be
// lost when one or more hosts are added/removed from the destination
// service.
//
// Note: consistent hashing is less reliable at maintaining affinity than common
// "sticky sessions" implementations, which often encode a specific destination in
// a cookie, ensuring affinity is maintained as long as the backend remains.
// With consistent hash, the guarantees are weaker; any host addition or removal can
// break affinity for `1/backends` requests.
//
// Warning: consistent hashing depends on each proxy having a consistent view of endpoints.
// This is not the case when locality load balancing is enabled. Locality load balancing
// and consistent hash will only work together when all proxies are in the same locality,
// or a high level load balancer handles locality affinity.
type LoadBalancerSettings_ConsistentHashLB struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The hash key to use.
	//
	// Types that are valid to be assigned to HashKey:
	//
	//	*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName
	//	*LoadBalancerSettings_ConsistentHashLB_HttpCookie
	//	*LoadBalancerSettings_ConsistentHashLB_UseSourceIp
	//	*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName
	HashKey isLoadBalancerSettings_ConsistentHashLB_HashKey `protobuf_oneof:"hash_key"`
	// The hash algorithm to use.
	// Please refer to Envoy's [Ring Hash Load Balancer](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/load_balancers#ring-hash)
	// and [Maglev Load Balancer](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/load_balancers#maglev) docs for
	// considerations on choosing an algorithm.
	// Defaults to RingHash if not specified.
	//
	// Types that are valid to be assigned to HashAlgorithm:
	//
	//	*LoadBalancerSettings_ConsistentHashLB_RingHash_
	//	*LoadBalancerSettings_ConsistentHashLB_Maglev
	HashAlgorithm isLoadBalancerSettings_ConsistentHashLB_HashAlgorithm `protobuf_oneof:"hash_algorithm"`
	// Deprecated. Use RingHash instead.
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/destination_rule.proto.
	MinimumRingSize uint64 `protobuf:"varint,4,opt,name=minimum_ring_size,json=minimumRingSize,proto3" json:"minimum_ring_size,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *LoadBalancerSettings_ConsistentHashLB) Reset() {
	*x = LoadBalancerSettings_ConsistentHashLB{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerSettings_ConsistentHashLB) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerSettings_ConsistentHashLB) ProtoMessage() {}

func (x *LoadBalancerSettings_ConsistentHashLB) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerSettings_ConsistentHashLB.ProtoReflect.Descriptor instead.
func (*LoadBalancerSettings_ConsistentHashLB) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{3, 0}
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetHashKey() isLoadBalancerSettings_ConsistentHashLB_HashKey {
	if x != nil {
		return x.HashKey
	}
	return nil
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetHttpHeaderName() string {
	if x != nil {
		if x, ok := x.HashKey.(*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName); ok {
			return x.HttpHeaderName
		}
	}
	return ""
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetHttpCookie() *LoadBalancerSettings_ConsistentHashLB_HTTPCookie {
	if x != nil {
		if x, ok := x.HashKey.(*LoadBalancerSettings_ConsistentHashLB_HttpCookie); ok {
			return x.HttpCookie
		}
	}
	return nil
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetUseSourceIp() bool {
	if x != nil {
		if x, ok := x.HashKey.(*LoadBalancerSettings_ConsistentHashLB_UseSourceIp); ok {
			return x.UseSourceIp
		}
	}
	return false
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetHttpQueryParameterName() string {
	if x != nil {
		if x, ok := x.HashKey.(*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName); ok {
			return x.HttpQueryParameterName
		}
	}
	return ""
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetHashAlgorithm() isLoadBalancerSettings_ConsistentHashLB_HashAlgorithm {
	if x != nil {
		return x.HashAlgorithm
	}
	return nil
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetRingHash() *LoadBalancerSettings_ConsistentHashLB_RingHash {
	if x != nil {
		if x, ok := x.HashAlgorithm.(*LoadBalancerSettings_ConsistentHashLB_RingHash_); ok {
			return x.RingHash
		}
	}
	return nil
}

func (x *LoadBalancerSettings_ConsistentHashLB) GetMaglev() *LoadBalancerSettings_ConsistentHashLB_MagLev {
	if x != nil {
		if x, ok := x.HashAlgorithm.(*LoadBalancerSettings_ConsistentHashLB_Maglev); ok {
			return x.Maglev
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in networking/v1alpha3/destination_rule.proto.
func (x *LoadBalancerSettings_ConsistentHashLB) GetMinimumRingSize() uint64 {
	if x != nil {
		return x.MinimumRingSize
	}
	return 0
}

type isLoadBalancerSettings_ConsistentHashLB_HashKey interface {
	isLoadBalancerSettings_ConsistentHashLB_HashKey()
}

type LoadBalancerSettings_ConsistentHashLB_HttpHeaderName struct {
	// Hash based on a specific HTTP header.
	HttpHeaderName string `protobuf:"bytes,1,opt,name=http_header_name,json=httpHeaderName,proto3,oneof"`
}

type LoadBalancerSettings_ConsistentHashLB_HttpCookie struct {
	// Hash based on HTTP cookie.
	HttpCookie *LoadBalancerSettings_ConsistentHashLB_HTTPCookie `protobuf:"bytes,2,opt,name=http_cookie,json=httpCookie,proto3,oneof"`
}

type LoadBalancerSettings_ConsistentHashLB_UseSourceIp struct {
	// Hash based on the source IP address.
	// This is applicable for both TCP and HTTP connections.
	UseSourceIp bool `protobuf:"varint,3,opt,name=use_source_ip,json=useSourceIp,proto3,oneof"`
}

type LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName struct {
	// Hash based on a specific HTTP query parameter.
	HttpQueryParameterName string `protobuf:"bytes,5,opt,name=http_query_parameter_name,json=httpQueryParameterName,proto3,oneof"`
}

func (*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}

func (*LoadBalancerSettings_ConsistentHashLB_HttpCookie) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}

func (*LoadBalancerSettings_ConsistentHashLB_UseSourceIp) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}

func (*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}

type isLoadBalancerSettings_ConsistentHashLB_HashAlgorithm interface {
	isLoadBalancerSettings_ConsistentHashLB_HashAlgorithm()
}

type LoadBalancerSettings_ConsistentHashLB_RingHash_ struct {
	// The ring/modulo hash load balancer implements consistent hashing to backend hosts.
	RingHash *LoadBalancerSettings_ConsistentHashLB_RingHash `protobuf:"bytes,6,opt,name=ring_hash,json=ringHash,proto3,oneof"`
}

type LoadBalancerSettings_ConsistentHashLB_Maglev struct {
	// The Maglev load balancer implements consistent hashing to backend hosts.
	Maglev *LoadBalancerSettings_ConsistentHashLB_MagLev `protobuf:"bytes,7,opt,name=maglev,proto3,oneof"`
}

func (*LoadBalancerSettings_ConsistentHashLB_RingHash_) isLoadBalancerSettings_ConsistentHashLB_HashAlgorithm() {
}

func (*LoadBalancerSettings_ConsistentHashLB_Maglev) isLoadBalancerSettings_ConsistentHashLB_HashAlgorithm() {
}

type LoadBalancerSettings_ConsistentHashLB_RingHash struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The minimum number of virtual nodes to use for the hash
	// ring. Defaults to 1024. Larger ring sizes result in more granular
	// load distributions. If the number of hosts in the load balancing
	// pool is larger than the ring size, each host will be assigned a
	// single virtual node.
	MinimumRingSize uint64 `protobuf:"varint,1,opt,name=minimum_ring_size,json=minimumRingSize,proto3" json:"minimum_ring_size,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *LoadBalancerSettings_ConsistentHashLB_RingHash) Reset() {
	*x = LoadBalancerSettings_ConsistentHashLB_RingHash{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerSettings_ConsistentHashLB_RingHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerSettings_ConsistentHashLB_RingHash) ProtoMessage() {}

func (x *LoadBalancerSettings_ConsistentHashLB_RingHash) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerSettings_ConsistentHashLB_RingHash.ProtoReflect.Descriptor instead.
func (*LoadBalancerSettings_ConsistentHashLB_RingHash) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{3, 0, 0}
}

func (x *LoadBalancerSettings_ConsistentHashLB_RingHash) GetMinimumRingSize() uint64 {
	if x != nil {
		return x.MinimumRingSize
	}
	return 0
}

type LoadBalancerSettings_ConsistentHashLB_MagLev struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The table size for Maglev hashing. This helps in controlling the
	// disruption when the backend hosts change.
	// Increasing the table size reduces the amount of disruption.
	// The table size must be prime number less than 5000011.
	// If it is not specified, the default is 65537.
	TableSize     uint64 `protobuf:"varint,1,opt,name=table_size,json=tableSize,proto3" json:"table_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoadBalancerSettings_ConsistentHashLB_MagLev) Reset() {
	*x = LoadBalancerSettings_ConsistentHashLB_MagLev{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerSettings_ConsistentHashLB_MagLev) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerSettings_ConsistentHashLB_MagLev) ProtoMessage() {}

func (x *LoadBalancerSettings_ConsistentHashLB_MagLev) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerSettings_ConsistentHashLB_MagLev.ProtoReflect.Descriptor instead.
func (*LoadBalancerSettings_ConsistentHashLB_MagLev) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{3, 0, 1}
}

func (x *LoadBalancerSettings_ConsistentHashLB_MagLev) GetTableSize() uint64 {
	if x != nil {
		return x.TableSize
	}
	return 0
}

// Describes a HTTP cookie that will be used as the hash key for the
// Consistent Hash load balancer.
type LoadBalancerSettings_ConsistentHashLB_HTTPCookie struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the cookie.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path to set for the cookie.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Lifetime of the cookie. If specified, a cookie with the TTL will be
	// generated if the cookie is not present. If the TTL is present and zero,
	// the generated cookie will be a session cookie.
	// +protoc-gen-crd:duration-validation:none
	Ttl *duration.Duration `protobuf:"bytes,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// Additional attributes for the cookie. They will be used when generating a new cookie.
	Attributes    []*LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) Reset() {
	*x = LoadBalancerSettings_ConsistentHashLB_HTTPCookie{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerSettings_ConsistentHashLB_HTTPCookie) ProtoMessage() {}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerSettings_ConsistentHashLB_HTTPCookie.ProtoReflect.Descriptor instead.
func (*LoadBalancerSettings_ConsistentHashLB_HTTPCookie) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{3, 0, 2}
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) GetTtl() *duration.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) GetAttributes() []*LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Attribute defines an API for adding additional attributes for a HTTP cookie.
type LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the cookie attribute.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The optional value of the cookie attribute.
	Value         string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute) Reset() {
	*x = LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute) ProtoMessage() {}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute.ProtoReflect.Descriptor instead.
func (*LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{3, 0, 2, 0}
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Settings common to both HTTP and TCP upstream connections.
type ConnectionPoolSettings_TCPSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Maximum number of HTTP1 /TCP connections to a destination host. Default 2^32-1.
	MaxConnections int32 `protobuf:"varint,1,opt,name=max_connections,json=maxConnections,proto3" json:"max_connections,omitempty"`
	// TCP connection timeout. format:
	// 1h/1m/1s/1ms. MUST be >=1ms. Default is 10s.
	ConnectTimeout *duration.Duration `protobuf:"bytes,2,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	// If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives.
	TcpKeepalive *ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,3,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	// The maximum duration of a connection. The duration is defined as the period since a connection
	// was established. If not set, there is no max duration. When `maxConnectionDuration`
	// is reached the connection will be closed. Duration must be at least 1ms.
	MaxConnectionDuration *duration.Duration `protobuf:"bytes,4,opt,name=max_connection_duration,json=maxConnectionDuration,proto3" json:"max_connection_duration,omitempty"`
	// The idle timeout for TCP connections.
	// The idle timeout is defined as the period in which there are no bytes sent or received on either
	// the upstream or downstream connection.
	// If not set, the default idle timeout is 1 hour. If set to 0s, the timeout will be disabled.
	// Idle timeout is not configured per each cluster individually when weighted destinations are used,
	// because idleTimeout is a property of a listener, not a cluster. In that case, idleTimeout
	// specified in a destination rule for the first weighted route is configured in the listener,
	// which means also for all weighted routes.
	// +protoc-gen-crd:duration-validation:none
	IdleTimeout   *duration.Duration `protobuf:"bytes,5,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConnectionPoolSettings_TCPSettings) Reset() {
	*x = ConnectionPoolSettings_TCPSettings{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionPoolSettings_TCPSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionPoolSettings_TCPSettings) ProtoMessage() {}

func (x *ConnectionPoolSettings_TCPSettings) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionPoolSettings_TCPSettings.ProtoReflect.Descriptor instead.
func (*ConnectionPoolSettings_TCPSettings) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ConnectionPoolSettings_TCPSettings) GetMaxConnections() int32 {
	if x != nil {
		return x.MaxConnections
	}
	return 0
}

func (x *ConnectionPoolSettings_TCPSettings) GetConnectTimeout() *duration.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

func (x *ConnectionPoolSettings_TCPSettings) GetTcpKeepalive() *ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if x != nil {
		return x.TcpKeepalive
	}
	return nil
}

func (x *ConnectionPoolSettings_TCPSettings) GetMaxConnectionDuration() *duration.Duration {
	if x != nil {
		return x.MaxConnectionDuration
	}
	return nil
}

func (x *ConnectionPoolSettings_TCPSettings) GetIdleTimeout() *duration.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

// Settings applicable to HTTP1.1/HTTP2/GRPC connections.
type ConnectionPoolSettings_HTTPSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Maximum number of requests that will be queued while waiting for
	// a ready connection pool connection. Default 2^32-1.
	// Refer to [Envoy Circuit Breaking](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/circuit_breaking)
	// under which conditions a new connection is created for HTTP/2.
	// Please note that this is applicable to both HTTP/1.1 and HTTP/2.
	Http1MaxPendingRequests int32 `protobuf:"varint,1,opt,name=http1_max_pending_requests,json=http1MaxPendingRequests,proto3" json:"http1_max_pending_requests,omitempty"`
	// Maximum number of active requests to a destination. Default 2^32-1.
	// Please note that this is applicable to both HTTP/1.1 and HTTP/2.
	Http2MaxRequests int32 `protobuf:"varint,2,opt,name=http2_max_requests,json=http2MaxRequests,proto3" json:"http2_max_requests,omitempty"`
	// Maximum number of requests per connection to a backend. Setting this
	// parameter to 1 disables keep alive. Default 0, meaning "unlimited",
	// up to 2^29.
	MaxRequestsPerConnection int32 `protobuf:"varint,3,opt,name=max_requests_per_connection,json=maxRequestsPerConnection,proto3" json:"max_requests_per_connection,omitempty"`
	// Maximum number of retries that can be outstanding to all hosts in a
	// cluster at a given time. Defaults to 2^32-1.
	MaxRetries int32 `protobuf:"varint,4,opt,name=max_retries,json=maxRetries,proto3" json:"max_retries,omitempty"`
	// The idle timeout for upstream connection pool connections. The idle timeout
	// is defined as the period in which there are no active requests.
	// If not set, the default is 1 hour. When the idle timeout is reached,
	// the connection will be closed. If the connection is an HTTP/2
	// connection a drain sequence will occur prior to closing the connection.
	// Note that request based timeouts mean that HTTP/2 PINGs will not
	// keep the connection alive. Applies to both HTTP/1.1 and HTTP/2 connections.
	IdleTimeout *duration.Duration `protobuf:"bytes,5,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// Specify if http1.1 connection should be upgraded to http2 for the associated destination.
	H2UpgradePolicy ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy `protobuf:"varint,6,opt,name=h2_upgrade_policy,json=h2UpgradePolicy,proto3,enum=istio.networking.v1alpha3.ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy" json:"h2_upgrade_policy,omitempty"`
	// If set to true, client protocol will be preserved while initiating connection to backend.
	// Note that when this is set to true, `h2UpgradePolicy` will be ineffective i.e. the client
	// connections will not be upgraded to http2.
	UseClientProtocol bool `protobuf:"varint,7,opt,name=use_client_protocol,json=useClientProtocol,proto3" json:"use_client_protocol,omitempty"`
	// The maximum number of concurrent streams allowed for a peer on one HTTP/2 connection.
	// Defaults to 2^31-1.
	MaxConcurrentStreams int32 `protobuf:"varint,8,opt,name=max_concurrent_streams,json=maxConcurrentStreams,proto3" json:"max_concurrent_streams,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ConnectionPoolSettings_HTTPSettings) Reset() {
	*x = ConnectionPoolSettings_HTTPSettings{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionPoolSettings_HTTPSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionPoolSettings_HTTPSettings) ProtoMessage() {}

func (x *ConnectionPoolSettings_HTTPSettings) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionPoolSettings_HTTPSettings.ProtoReflect.Descriptor instead.
func (*ConnectionPoolSettings_HTTPSettings) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{5, 1}
}

func (x *ConnectionPoolSettings_HTTPSettings) GetHttp1MaxPendingRequests() int32 {
	if x != nil {
		return x.Http1MaxPendingRequests
	}
	return 0
}

func (x *ConnectionPoolSettings_HTTPSettings) GetHttp2MaxRequests() int32 {
	if x != nil {
		return x.Http2MaxRequests
	}
	return 0
}

func (x *ConnectionPoolSettings_HTTPSettings) GetMaxRequestsPerConnection() int32 {
	if x != nil {
		return x.MaxRequestsPerConnection
	}
	return 0
}

func (x *ConnectionPoolSettings_HTTPSettings) GetMaxRetries() int32 {
	if x != nil {
		return x.MaxRetries
	}
	return 0
}

func (x *ConnectionPoolSettings_HTTPSettings) GetIdleTimeout() *duration.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

func (x *ConnectionPoolSettings_HTTPSettings) GetH2UpgradePolicy() ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy {
	if x != nil {
		return x.H2UpgradePolicy
	}
	return ConnectionPoolSettings_HTTPSettings_DEFAULT
}

func (x *ConnectionPoolSettings_HTTPSettings) GetUseClientProtocol() bool {
	if x != nil {
		return x.UseClientProtocol
	}
	return false
}

func (x *ConnectionPoolSettings_HTTPSettings) GetMaxConcurrentStreams() int32 {
	if x != nil {
		return x.MaxConcurrentStreams
	}
	return 0
}

// TCP keepalive.
type ConnectionPoolSettings_TCPSettings_TcpKeepalive struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Maximum number of keepalive probes to send without response before
	// deciding the connection is dead. Default is to use the OS level configuration
	// (unless overridden, Linux defaults to 9.)
	Probes uint32 `protobuf:"varint,1,opt,name=probes,proto3" json:"probes,omitempty"`
	// The time duration a connection needs to be idle before keep-alive
	// probes start being sent. Default is to use the OS level configuration
	// (unless overridden, Linux defaults to 7200s (ie 2 hours.)
	Time *duration.Duration `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// The time duration between keep-alive probes.
	// Default is to use the OS level configuration
	// (unless overridden, Linux defaults to 75s.)
	Interval      *duration.Duration `protobuf:"bytes,3,opt,name=interval,proto3" json:"interval,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConnectionPoolSettings_TCPSettings_TcpKeepalive) Reset() {
	*x = ConnectionPoolSettings_TCPSettings_TcpKeepalive{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionPoolSettings_TCPSettings_TcpKeepalive) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionPoolSettings_TCPSettings_TcpKeepalive) ProtoMessage() {}

func (x *ConnectionPoolSettings_TCPSettings_TcpKeepalive) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionPoolSettings_TCPSettings_TcpKeepalive.ProtoReflect.Descriptor instead.
func (*ConnectionPoolSettings_TCPSettings_TcpKeepalive) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{5, 0, 0}
}

func (x *ConnectionPoolSettings_TCPSettings_TcpKeepalive) GetProbes() uint32 {
	if x != nil {
		return x.Probes
	}
	return 0
}

func (x *ConnectionPoolSettings_TCPSettings_TcpKeepalive) GetTime() *duration.Duration {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *ConnectionPoolSettings_TCPSettings_TcpKeepalive) GetInterval() *duration.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

// Describes how traffic originating in the 'from' zone or sub-zone is
// distributed over a set of 'to' zones. Syntax for specifying a zone is
// {region}/{zone}/{sub-zone} and terminal wildcards are allowed on any
// segment of the specification. Examples:
//
// `*` - matches all localities
//
// `us-west/*` - all zones and sub-zones within the us-west region
//
// `us-west/zone-1/*` - all sub-zones within us-west/zone-1
type LocalityLoadBalancerSetting_Distribute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Originating locality, '/' separated, e.g. 'region/zone/sub_zone'.
	From string `protobuf:"bytes,1,opt,name=from,proto3" json:"from,omitempty"`
	// Map of upstream localities to traffic distribution weights. The sum of
	// all weights should be 100. Any locality not present will
	// receive no traffic.
	To            map[string]uint32 `protobuf:"bytes,2,rep,name=to,proto3" json:"to,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LocalityLoadBalancerSetting_Distribute) Reset() {
	*x = LocalityLoadBalancerSetting_Distribute{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalityLoadBalancerSetting_Distribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalityLoadBalancerSetting_Distribute) ProtoMessage() {}

func (x *LocalityLoadBalancerSetting_Distribute) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalityLoadBalancerSetting_Distribute.ProtoReflect.Descriptor instead.
func (*LocalityLoadBalancerSetting_Distribute) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{8, 0}
}

func (x *LocalityLoadBalancerSetting_Distribute) GetFrom() string {
	if x != nil {
		return x.From
	}
	return ""
}

func (x *LocalityLoadBalancerSetting_Distribute) GetTo() map[string]uint32 {
	if x != nil {
		return x.To
	}
	return nil
}

// Specify the traffic failover policy across regions. Since zone and sub-zone
// failover is supported by default this only needs to be specified for
// regions when the operator needs to constrain traffic failover so that
// the default behavior of failing over to any endpoint globally does not
// apply. This is useful when failing over traffic across regions would not
// improve service health or may need to be restricted for other reasons
// like regulatory controls.
type LocalityLoadBalancerSetting_Failover struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Originating region.
	From string `protobuf:"bytes,1,opt,name=from,proto3" json:"from,omitempty"`
	// Destination region the traffic will fail over to when endpoints in
	// the 'from' region becomes unhealthy.
	To            string `protobuf:"bytes,2,opt,name=to,proto3" json:"to,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LocalityLoadBalancerSetting_Failover) Reset() {
	*x = LocalityLoadBalancerSetting_Failover{}
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalityLoadBalancerSetting_Failover) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalityLoadBalancerSetting_Failover) ProtoMessage() {}

func (x *LocalityLoadBalancerSetting_Failover) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_destination_rule_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalityLoadBalancerSetting_Failover.ProtoReflect.Descriptor instead.
func (*LocalityLoadBalancerSetting_Failover) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_destination_rule_proto_rawDescGZIP(), []int{8, 1}
}

func (x *LocalityLoadBalancerSetting_Failover) GetFrom() string {
	if x != nil {
		return x.From
	}
	return ""
}

func (x *LocalityLoadBalancerSetting_Failover) GetTo() string {
	if x != nil {
		return x.To
	}
	return ""
}

var File_networking_v1alpha3_destination_rule_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_destination_rule_proto_rawDesc = "" +
	"\n" +
	"*networking/v1alpha3/destination_rule.proto\x12\x19istio.networking.v1alpha3\x1a\x1fgoogle/api/field_behavior.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a)networking/v1alpha3/virtual_service.proto\x1a\x1btype/v1beta1/selector.proto\"\xa9\x02\n" +
	"\x0fDestinationRule\x12\x18\n" +
	"\x04host\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04host\x12O\n" +
	"\x0etraffic_policy\x18\x02 \x01(\v2(.istio.networking.v1alpha3.TrafficPolicyR\rtrafficPolicy\x12;\n" +
	"\asubsets\x18\x03 \x03(\v2!.istio.networking.v1alpha3.SubsetR\asubsets\x12\x1b\n" +
	"\texport_to\x18\x04 \x03(\tR\bexportTo\x12Q\n" +
	"\x11workload_selector\x18\x05 \x01(\v2$.istio.type.v1beta1.WorkloadSelectorR\x10workloadSelector\"\xed\v\n" +
	"\rTrafficPolicy\x12T\n" +
	"\rload_balancer\x18\x01 \x01(\v2/.istio.networking.v1alpha3.LoadBalancerSettingsR\floadBalancer\x12Z\n" +
	"\x0fconnection_pool\x18\x02 \x01(\v21.istio.networking.v1alpha3.ConnectionPoolSettingsR\x0econnectionPool\x12X\n" +
	"\x11outlier_detection\x18\x03 \x01(\v2+.istio.networking.v1alpha3.OutlierDetectionR\x10outlierDetection\x12>\n" +
	"\x03tls\x18\x04 \x01(\v2,.istio.networking.v1alpha3.ClientTLSSettingsR\x03tls\x12j\n" +
	"\x13port_level_settings\x18\x05 \x03(\v2:.istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicyR\x11portLevelSettings\x12O\n" +
	"\x06tunnel\x18\x06 \x01(\v27.istio.networking.v1alpha3.TrafficPolicy.TunnelSettingsR\x06tunnel\x12]\n" +
	"\x0eproxy_protocol\x18\a \x01(\v26.istio.networking.v1alpha3.TrafficPolicy.ProxyProtocolR\rproxyProtocol\x12W\n" +
	"\fretry_budget\x18\b \x01(\v24.istio.networking.v1alpha3.TrafficPolicy.RetryBudgetR\vretryBudget\x1a\x9c\x03\n" +
	"\x11PortTrafficPolicy\x12;\n" +
	"\x04port\x18\x01 \x01(\v2'.istio.networking.v1alpha3.PortSelectorR\x04port\x12T\n" +
	"\rload_balancer\x18\x02 \x01(\v2/.istio.networking.v1alpha3.LoadBalancerSettingsR\floadBalancer\x12Z\n" +
	"\x0fconnection_pool\x18\x03 \x01(\v21.istio.networking.v1alpha3.ConnectionPoolSettingsR\x0econnectionPool\x12X\n" +
	"\x11outlier_detection\x18\x04 \x01(\v2+.istio.networking.v1alpha3.OutlierDetectionR\x10outlierDetection\x12>\n" +
	"\x03tls\x18\x05 \x01(\v2,.istio.networking.v1alpha3.ClientTLSSettingsR\x03tls\x1az\n" +
	"\x0eTunnelSettings\x12\x1a\n" +
	"\bprotocol\x18\x01 \x01(\tR\bprotocol\x12%\n" +
	"\vtarget_host\x18\x02 \x01(\tB\x04\xe2A\x01\x02R\n" +
	"targetHost\x12%\n" +
	"\vtarget_port\x18\x03 \x01(\rB\x04\xe2A\x01\x02R\n" +
	"targetPort\x1a\x84\x01\n" +
	"\rProxyProtocol\x12X\n" +
	"\aversion\x18\x01 \x01(\x0e2>.istio.networking.v1alpha3.TrafficPolicy.ProxyProtocol.VERSIONR\aversion\"\x19\n" +
	"\aVERSION\x12\x06\n" +
	"\x02V1\x10\x00\x12\x06\n" +
	"\x02V2\x10\x01\x1ay\n" +
	"\vRetryBudget\x126\n" +
	"\apercent\x18\x01 \x01(\v2\x1c.google.protobuf.DoubleValueR\apercent\x122\n" +
	"\x15min_retry_concurrency\x18\x02 \x01(\rR\x13minRetryConcurrency\"\xf5\x01\n" +
	"\x06Subset\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12E\n" +
	"\x06labels\x18\x02 \x03(\v2-.istio.networking.v1alpha3.Subset.LabelsEntryR\x06labels\x12O\n" +
	"\x0etraffic_policy\x18\x03 \x01(\v2(.istio.networking.v1alpha3.TrafficPolicyR\rtrafficPolicy\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x81\f\n" +
	"\x14LoadBalancerSettings\x12R\n" +
	"\x06simple\x18\x01 \x01(\x0e28.istio.networking.v1alpha3.LoadBalancerSettings.SimpleLBH\x00R\x06simple\x12k\n" +
	"\x0fconsistent_hash\x18\x02 \x01(\v2@.istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLBH\x00R\x0econsistentHash\x12f\n" +
	"\x13locality_lb_setting\x18\x03 \x01(\v26.istio.networking.v1alpha3.LocalityLoadBalancerSettingR\x11localityLbSetting\x12K\n" +
	"\x14warmup_duration_secs\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\x12warmupDurationSecs\x12F\n" +
	"\x06warmup\x18\x05 \x01(\v2..istio.networking.v1alpha3.WarmupConfigurationR\x06warmup\x1a\xab\a\n" +
	"\x10ConsistentHashLB\x12*\n" +
	"\x10http_header_name\x18\x01 \x01(\tH\x00R\x0ehttpHeaderName\x12n\n" +
	"\vhttp_cookie\x18\x02 \x01(\v2K.istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookieH\x00R\n" +
	"httpCookie\x12$\n" +
	"\ruse_source_ip\x18\x03 \x01(\bH\x00R\vuseSourceIp\x12;\n" +
	"\x19http_query_parameter_name\x18\x05 \x01(\tH\x00R\x16httpQueryParameterName\x12h\n" +
	"\tring_hash\x18\x06 \x01(\v2I.istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.RingHashH\x01R\bringHash\x12a\n" +
	"\x06maglev\x18\a \x01(\v2G.istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.MagLevH\x01R\x06maglev\x12.\n" +
	"\x11minimum_ring_size\x18\x04 \x01(\x04B\x02\x18\x01R\x0fminimumRingSize\x1a6\n" +
	"\bRingHash\x12*\n" +
	"\x11minimum_ring_size\x18\x01 \x01(\x04R\x0fminimumRingSize\x1a'\n" +
	"\x06MagLev\x12\x1d\n" +
	"\n" +
	"table_size\x18\x01 \x01(\x04R\ttableSize\x1a\x9b\x02\n" +
	"\n" +
	"HTTPCookie\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12\x12\n" +
	"\x04path\x18\x02 \x01(\tR\x04path\x12+\n" +
	"\x03ttl\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x03ttl\x12u\n" +
	"\n" +
	"attributes\x18\x04 \x03(\v2U.istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookie.AttributeR\n" +
	"attributes\x1a;\n" +
	"\tAttribute\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05valueB\n" +
	"\n" +
	"\bhash_keyB\x10\n" +
	"\x0ehash_algorithm\"p\n" +
	"\bSimpleLB\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\x12\n" +
	"\n" +
	"LEAST_CONN\x10\x01\x1a\x02\b\x01\x12\n" +
	"\n" +
	"\x06RANDOM\x10\x02\x12\x0f\n" +
	"\vPASSTHROUGH\x10\x03\x12\x0f\n" +
	"\vROUND_ROBIN\x10\x04\x12\x11\n" +
	"\rLEAST_REQUEST\x10\x05B\v\n" +
	"\tlb_policy\"\xd7\x01\n" +
	"\x13WarmupConfiguration\x12;\n" +
	"\bduration\x18\x01 \x01(\v2\x19.google.protobuf.DurationB\x04\xe2A\x01\x02R\bduration\x12E\n" +
	"\x0fminimum_percent\x18\x02 \x01(\v2\x1c.google.protobuf.DoubleValueR\x0eminimumPercent\x12<\n" +
	"\n" +
	"aggression\x18\x03 \x01(\v2\x1c.google.protobuf.DoubleValueR\n" +
	"aggression\"\x88\n" +
	"\n" +
	"\x16ConnectionPoolSettings\x12O\n" +
	"\x03tcp\x18\x01 \x01(\v2=.istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettingsR\x03tcp\x12R\n" +
	"\x04http\x18\x02 \x01(\v2>.istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettingsR\x04http\x1a\x8b\x04\n" +
	"\vTCPSettings\x12'\n" +
	"\x0fmax_connections\x18\x01 \x01(\x05R\x0emaxConnections\x12B\n" +
	"\x0fconnect_timeout\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\x0econnectTimeout\x12o\n" +
	"\rtcp_keepalive\x18\x03 \x01(\v2J.istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepaliveR\ftcpKeepalive\x12Q\n" +
	"\x17max_connection_duration\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\x15maxConnectionDuration\x12<\n" +
	"\fidle_timeout\x18\x05 \x01(\v2\x19.google.protobuf.DurationR\vidleTimeout\x1a\x8c\x01\n" +
	"\fTcpKeepalive\x12\x16\n" +
	"\x06probes\x18\x01 \x01(\rR\x06probes\x12-\n" +
	"\x04time\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\x04time\x125\n" +
	"\binterval\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\binterval\x1a\xba\x04\n" +
	"\fHTTPSettings\x12;\n" +
	"\x1ahttp1_max_pending_requests\x18\x01 \x01(\x05R\x17http1MaxPendingRequests\x12,\n" +
	"\x12http2_max_requests\x18\x02 \x01(\x05R\x10http2MaxRequests\x12=\n" +
	"\x1bmax_requests_per_connection\x18\x03 \x01(\x05R\x18maxRequestsPerConnection\x12\x1f\n" +
	"\vmax_retries\x18\x04 \x01(\x05R\n" +
	"maxRetries\x12<\n" +
	"\fidle_timeout\x18\x05 \x01(\v2\x19.google.protobuf.DurationR\vidleTimeout\x12z\n" +
	"\x11h2_upgrade_policy\x18\x06 \x01(\x0e2N.istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings.H2UpgradePolicyR\x0fh2UpgradePolicy\x12.\n" +
	"\x13use_client_protocol\x18\a \x01(\bR\x11useClientProtocol\x124\n" +
	"\x16max_concurrent_streams\x18\b \x01(\x05R\x14maxConcurrentStreams\"?\n" +
	"\x0fH2UpgradePolicy\x12\v\n" +
	"\aDEFAULT\x10\x00\x12\x12\n" +
	"\x0eDO_NOT_UPGRADE\x10\x01\x12\v\n" +
	"\aUPGRADE\x10\x02\"\x8a\x05\n" +
	"\x10OutlierDetection\x121\n" +
	"\x12consecutive_errors\x18\x01 \x01(\x05B\x02\x18\x01R\x11consecutiveErrors\x12J\n" +
	"\"split_external_local_origin_errors\x18\b \x01(\bR\x1esplitExternalLocalOriginErrors\x12g\n" +
	"!consecutive_local_origin_failures\x18\t \x01(\v2\x1c.google.protobuf.UInt32ValueR\x1econsecutiveLocalOriginFailures\x12Z\n" +
	"\x1aconsecutive_gateway_errors\x18\x06 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x18consecutiveGatewayErrors\x12R\n" +
	"\x16consecutive_5xx_errors\x18\a \x01(\v2\x1c.google.protobuf.UInt32ValueR\x14consecutive5xxErrors\x125\n" +
	"\binterval\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\binterval\x12G\n" +
	"\x12base_ejection_time\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x10baseEjectionTime\x120\n" +
	"\x14max_ejection_percent\x18\x04 \x01(\x05R\x12maxEjectionPercent\x12,\n" +
	"\x12min_health_percent\x18\x05 \x01(\x05R\x10minHealthPercent\"\xe4\x03\n" +
	"\x11ClientTLSSettings\x12H\n" +
	"\x04mode\x18\x01 \x01(\x0e24.istio.networking.v1alpha3.ClientTLSSettings.TLSmodeR\x04mode\x12-\n" +
	"\x12client_certificate\x18\x02 \x01(\tR\x11clientCertificate\x12\x1f\n" +
	"\vprivate_key\x18\x03 \x01(\tR\n" +
	"privateKey\x12'\n" +
	"\x0fca_certificates\x18\x04 \x01(\tR\x0ecaCertificates\x12'\n" +
	"\x0fcredential_name\x18\a \x01(\tR\x0ecredentialName\x12*\n" +
	"\x11subject_alt_names\x18\x05 \x03(\tR\x0fsubjectAltNames\x12\x10\n" +
	"\x03sni\x18\x06 \x01(\tR\x03sni\x12L\n" +
	"\x14insecure_skip_verify\x18\b \x01(\v2\x1a.google.protobuf.BoolValueR\x12insecureSkipVerify\x12\x15\n" +
	"\x06ca_crl\x18\t \x01(\tR\x05caCrl\"@\n" +
	"\aTLSmode\x12\v\n" +
	"\aDISABLE\x10\x00\x12\n" +
	"\n" +
	"\x06SIMPLE\x10\x01\x12\n" +
	"\n" +
	"\x06MUTUAL\x10\x02\x12\x10\n" +
	"\fISTIO_MUTUAL\x10\x03\"\xa5\x04\n" +
	"\x1bLocalityLoadBalancerSetting\x12a\n" +
	"\n" +
	"distribute\x18\x01 \x03(\v2A.istio.networking.v1alpha3.LocalityLoadBalancerSetting.DistributeR\n" +
	"distribute\x12[\n" +
	"\bfailover\x18\x02 \x03(\v2?.istio.networking.v1alpha3.LocalityLoadBalancerSetting.FailoverR\bfailover\x12+\n" +
	"\x11failover_priority\x18\x04 \x03(\tR\x10failoverPriority\x124\n" +
	"\aenabled\x18\x03 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x1a\xb2\x01\n" +
	"\n" +
	"Distribute\x12\x12\n" +
	"\x04from\x18\x01 \x01(\tR\x04from\x12Y\n" +
	"\x02to\x18\x02 \x03(\v2I.istio.networking.v1alpha3.LocalityLoadBalancerSetting.Distribute.ToEntryR\x02to\x1a5\n" +
	"\aToEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\rR\x05value:\x028\x01\x1a.\n" +
	"\bFailover\x12\x12\n" +
	"\x04from\x18\x01 \x01(\tR\x04from\x12\x0e\n" +
	"\x02to\x18\x02 \x01(\tR\x02toB\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_destination_rule_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_destination_rule_proto_rawDescData []byte
)

func file_networking_v1alpha3_destination_rule_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_destination_rule_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_destination_rule_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_destination_rule_proto_rawDesc), len(file_networking_v1alpha3_destination_rule_proto_rawDesc)))
	})
	return file_networking_v1alpha3_destination_rule_proto_rawDescData
}

var file_networking_v1alpha3_destination_rule_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_networking_v1alpha3_destination_rule_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_networking_v1alpha3_destination_rule_proto_goTypes = []any{
	(TrafficPolicy_ProxyProtocol_VERSION)(0),                           // 0: istio.networking.v1alpha3.TrafficPolicy.ProxyProtocol.VERSION
	(LoadBalancerSettings_SimpleLB)(0),                                 // 1: istio.networking.v1alpha3.LoadBalancerSettings.SimpleLB
	(ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy)(0),           // 2: istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings.H2UpgradePolicy
	(ClientTLSSettings_TLSmode)(0),                                     // 3: istio.networking.v1alpha3.ClientTLSSettings.TLSmode
	(*DestinationRule)(nil),                                            // 4: istio.networking.v1alpha3.DestinationRule
	(*TrafficPolicy)(nil),                                              // 5: istio.networking.v1alpha3.TrafficPolicy
	(*Subset)(nil),                                                     // 6: istio.networking.v1alpha3.Subset
	(*LoadBalancerSettings)(nil),                                       // 7: istio.networking.v1alpha3.LoadBalancerSettings
	(*WarmupConfiguration)(nil),                                        // 8: istio.networking.v1alpha3.WarmupConfiguration
	(*ConnectionPoolSettings)(nil),                                     // 9: istio.networking.v1alpha3.ConnectionPoolSettings
	(*OutlierDetection)(nil),                                           // 10: istio.networking.v1alpha3.OutlierDetection
	(*ClientTLSSettings)(nil),                                          // 11: istio.networking.v1alpha3.ClientTLSSettings
	(*LocalityLoadBalancerSetting)(nil),                                // 12: istio.networking.v1alpha3.LocalityLoadBalancerSetting
	(*TrafficPolicy_PortTrafficPolicy)(nil),                            // 13: istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy
	(*TrafficPolicy_TunnelSettings)(nil),                               // 14: istio.networking.v1alpha3.TrafficPolicy.TunnelSettings
	(*TrafficPolicy_ProxyProtocol)(nil),                                // 15: istio.networking.v1alpha3.TrafficPolicy.ProxyProtocol
	(*TrafficPolicy_RetryBudget)(nil),                                  // 16: istio.networking.v1alpha3.TrafficPolicy.RetryBudget
	nil,                                                                // 17: istio.networking.v1alpha3.Subset.LabelsEntry
	(*LoadBalancerSettings_ConsistentHashLB)(nil),                      // 18: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB
	(*LoadBalancerSettings_ConsistentHashLB_RingHash)(nil),             // 19: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.RingHash
	(*LoadBalancerSettings_ConsistentHashLB_MagLev)(nil),               // 20: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.MagLev
	(*LoadBalancerSettings_ConsistentHashLB_HTTPCookie)(nil),           // 21: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookie
	(*LoadBalancerSettings_ConsistentHashLB_HTTPCookie_Attribute)(nil), // 22: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookie.Attribute
	(*ConnectionPoolSettings_TCPSettings)(nil),                         // 23: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings
	(*ConnectionPoolSettings_HTTPSettings)(nil),                        // 24: istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings
	(*ConnectionPoolSettings_TCPSettings_TcpKeepalive)(nil),            // 25: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive
	(*LocalityLoadBalancerSetting_Distribute)(nil),                     // 26: istio.networking.v1alpha3.LocalityLoadBalancerSetting.Distribute
	(*LocalityLoadBalancerSetting_Failover)(nil),                       // 27: istio.networking.v1alpha3.LocalityLoadBalancerSetting.Failover
	nil,                              // 28: istio.networking.v1alpha3.LocalityLoadBalancerSetting.Distribute.ToEntry
	(*v1beta1.WorkloadSelector)(nil), // 29: istio.type.v1beta1.WorkloadSelector
	(*duration.Duration)(nil),        // 30: google.protobuf.Duration
	(*wrappers.DoubleValue)(nil),     // 31: google.protobuf.DoubleValue
	(*wrappers.UInt32Value)(nil),     // 32: google.protobuf.UInt32Value
	(*wrappers.BoolValue)(nil),       // 33: google.protobuf.BoolValue
	(*PortSelector)(nil),             // 34: istio.networking.v1alpha3.PortSelector
}
var file_networking_v1alpha3_destination_rule_proto_depIdxs = []int32{
	5,  // 0: istio.networking.v1alpha3.DestinationRule.traffic_policy:type_name -> istio.networking.v1alpha3.TrafficPolicy
	6,  // 1: istio.networking.v1alpha3.DestinationRule.subsets:type_name -> istio.networking.v1alpha3.Subset
	29, // 2: istio.networking.v1alpha3.DestinationRule.workload_selector:type_name -> istio.type.v1beta1.WorkloadSelector
	7,  // 3: istio.networking.v1alpha3.TrafficPolicy.load_balancer:type_name -> istio.networking.v1alpha3.LoadBalancerSettings
	9,  // 4: istio.networking.v1alpha3.TrafficPolicy.connection_pool:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings
	10, // 5: istio.networking.v1alpha3.TrafficPolicy.outlier_detection:type_name -> istio.networking.v1alpha3.OutlierDetection
	11, // 6: istio.networking.v1alpha3.TrafficPolicy.tls:type_name -> istio.networking.v1alpha3.ClientTLSSettings
	13, // 7: istio.networking.v1alpha3.TrafficPolicy.port_level_settings:type_name -> istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy
	14, // 8: istio.networking.v1alpha3.TrafficPolicy.tunnel:type_name -> istio.networking.v1alpha3.TrafficPolicy.TunnelSettings
	15, // 9: istio.networking.v1alpha3.TrafficPolicy.proxy_protocol:type_name -> istio.networking.v1alpha3.TrafficPolicy.ProxyProtocol
	16, // 10: istio.networking.v1alpha3.TrafficPolicy.retry_budget:type_name -> istio.networking.v1alpha3.TrafficPolicy.RetryBudget
	17, // 11: istio.networking.v1alpha3.Subset.labels:type_name -> istio.networking.v1alpha3.Subset.LabelsEntry
	5,  // 12: istio.networking.v1alpha3.Subset.traffic_policy:type_name -> istio.networking.v1alpha3.TrafficPolicy
	1,  // 13: istio.networking.v1alpha3.LoadBalancerSettings.simple:type_name -> istio.networking.v1alpha3.LoadBalancerSettings.SimpleLB
	18, // 14: istio.networking.v1alpha3.LoadBalancerSettings.consistent_hash:type_name -> istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB
	12, // 15: istio.networking.v1alpha3.LoadBalancerSettings.locality_lb_setting:type_name -> istio.networking.v1alpha3.LocalityLoadBalancerSetting
	30, // 16: istio.networking.v1alpha3.LoadBalancerSettings.warmup_duration_secs:type_name -> google.protobuf.Duration
	8,  // 17: istio.networking.v1alpha3.LoadBalancerSettings.warmup:type_name -> istio.networking.v1alpha3.WarmupConfiguration
	30, // 18: istio.networking.v1alpha3.WarmupConfiguration.duration:type_name -> google.protobuf.Duration
	31, // 19: istio.networking.v1alpha3.WarmupConfiguration.minimum_percent:type_name -> google.protobuf.DoubleValue
	31, // 20: istio.networking.v1alpha3.WarmupConfiguration.aggression:type_name -> google.protobuf.DoubleValue
	23, // 21: istio.networking.v1alpha3.ConnectionPoolSettings.tcp:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings
	24, // 22: istio.networking.v1alpha3.ConnectionPoolSettings.http:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings
	32, // 23: istio.networking.v1alpha3.OutlierDetection.consecutive_local_origin_failures:type_name -> google.protobuf.UInt32Value
	32, // 24: istio.networking.v1alpha3.OutlierDetection.consecutive_gateway_errors:type_name -> google.protobuf.UInt32Value
	32, // 25: istio.networking.v1alpha3.OutlierDetection.consecutive_5xx_errors:type_name -> google.protobuf.UInt32Value
	30, // 26: istio.networking.v1alpha3.OutlierDetection.interval:type_name -> google.protobuf.Duration
	30, // 27: istio.networking.v1alpha3.OutlierDetection.base_ejection_time:type_name -> google.protobuf.Duration
	3,  // 28: istio.networking.v1alpha3.ClientTLSSettings.mode:type_name -> istio.networking.v1alpha3.ClientTLSSettings.TLSmode
	33, // 29: istio.networking.v1alpha3.ClientTLSSettings.insecure_skip_verify:type_name -> google.protobuf.BoolValue
	26, // 30: istio.networking.v1alpha3.LocalityLoadBalancerSetting.distribute:type_name -> istio.networking.v1alpha3.LocalityLoadBalancerSetting.Distribute
	27, // 31: istio.networking.v1alpha3.LocalityLoadBalancerSetting.failover:type_name -> istio.networking.v1alpha3.LocalityLoadBalancerSetting.Failover
	33, // 32: istio.networking.v1alpha3.LocalityLoadBalancerSetting.enabled:type_name -> google.protobuf.BoolValue
	34, // 33: istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy.port:type_name -> istio.networking.v1alpha3.PortSelector
	7,  // 34: istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy.load_balancer:type_name -> istio.networking.v1alpha3.LoadBalancerSettings
	9,  // 35: istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy.connection_pool:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings
	10, // 36: istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy.outlier_detection:type_name -> istio.networking.v1alpha3.OutlierDetection
	11, // 37: istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy.tls:type_name -> istio.networking.v1alpha3.ClientTLSSettings
	0,  // 38: istio.networking.v1alpha3.TrafficPolicy.ProxyProtocol.version:type_name -> istio.networking.v1alpha3.TrafficPolicy.ProxyProtocol.VERSION
	31, // 39: istio.networking.v1alpha3.TrafficPolicy.RetryBudget.percent:type_name -> google.protobuf.DoubleValue
	21, // 40: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.http_cookie:type_name -> istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookie
	19, // 41: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.ring_hash:type_name -> istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.RingHash
	20, // 42: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.maglev:type_name -> istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.MagLev
	30, // 43: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookie.ttl:type_name -> google.protobuf.Duration
	22, // 44: istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookie.attributes:type_name -> istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB.HTTPCookie.Attribute
	30, // 45: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.connect_timeout:type_name -> google.protobuf.Duration
	25, // 46: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.tcp_keepalive:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive
	30, // 47: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.max_connection_duration:type_name -> google.protobuf.Duration
	30, // 48: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.idle_timeout:type_name -> google.protobuf.Duration
	30, // 49: istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings.idle_timeout:type_name -> google.protobuf.Duration
	2,  // 50: istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings.h2_upgrade_policy:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings.H2UpgradePolicy
	30, // 51: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive.time:type_name -> google.protobuf.Duration
	30, // 52: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive.interval:type_name -> google.protobuf.Duration
	28, // 53: istio.networking.v1alpha3.LocalityLoadBalancerSetting.Distribute.to:type_name -> istio.networking.v1alpha3.LocalityLoadBalancerSetting.Distribute.ToEntry
	54, // [54:54] is the sub-list for method output_type
	54, // [54:54] is the sub-list for method input_type
	54, // [54:54] is the sub-list for extension type_name
	54, // [54:54] is the sub-list for extension extendee
	0,  // [0:54] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_destination_rule_proto_init() }
func file_networking_v1alpha3_destination_rule_proto_init() {
	if File_networking_v1alpha3_destination_rule_proto != nil {
		return
	}
	file_networking_v1alpha3_virtual_service_proto_init()
	file_networking_v1alpha3_destination_rule_proto_msgTypes[3].OneofWrappers = []any{
		(*LoadBalancerSettings_Simple)(nil),
		(*LoadBalancerSettings_ConsistentHash)(nil),
	}
	file_networking_v1alpha3_destination_rule_proto_msgTypes[14].OneofWrappers = []any{
		(*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_HttpCookie)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_UseSourceIp)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_RingHash_)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_Maglev)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_destination_rule_proto_rawDesc), len(file_networking_v1alpha3_destination_rule_proto_rawDesc)),
			NumEnums:      4,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_destination_rule_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_destination_rule_proto_depIdxs,
		EnumInfos:         file_networking_v1alpha3_destination_rule_proto_enumTypes,
		MessageInfos:      file_networking_v1alpha3_destination_rule_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_destination_rule_proto = out.File
	file_networking_v1alpha3_destination_rule_proto_goTypes = nil
	file_networking_v1alpha3_destination_rule_proto_depIdxs = nil
}
