//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/load_balancing_policies/round_robin/v3/round_robin.proto

package round_robinv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on RoundRobin with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RoundRobin) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RoundRobin with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RoundRobinMultiError, or
// nil if none found.
func (m *RoundRobin) ValidateAll() error {
	return m.validate(true)
}

func (m *RoundRobin) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetSlowStartConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RoundRobinValidationError{
					field:  "SlowStartConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RoundRobinValidationError{
					field:  "SlowStartConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSlowStartConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RoundRobinValidationError{
				field:  "SlowStartConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetLocalityLbConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RoundRobinValidationError{
					field:  "LocalityLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RoundRobinValidationError{
					field:  "LocalityLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLocalityLbConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RoundRobinValidationError{
				field:  "LocalityLbConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RoundRobinMultiError(errors)
	}

	return nil
}

// RoundRobinMultiError is an error wrapping multiple validation errors
// returned by RoundRobin.ValidateAll() if the designated constraints aren't met.
type RoundRobinMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RoundRobinMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RoundRobinMultiError) AllErrors() []error { return m }

// RoundRobinValidationError is the validation error returned by
// RoundRobin.Validate if the designated constraints aren't met.
type RoundRobinValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RoundRobinValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RoundRobinValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RoundRobinValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RoundRobinValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RoundRobinValidationError) ErrorName() string { return "RoundRobinValidationError" }

// Error satisfies the builtin error interface
func (e RoundRobinValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRoundRobin.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RoundRobinValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RoundRobinValidationError{}
