//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/mcp/v3/mcp.proto

package mcpv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Mcp with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Mcp) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Mcp with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in McpMultiError, or nil if none found.
func (m *Mcp) ValidateAll() error {
	return m.validate(true)
}

func (m *Mcp) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return McpMultiError(errors)
	}

	return nil
}

// McpMultiError is an error wrapping multiple validation errors returned by
// Mcp.ValidateAll() if the designated constraints aren't met.
type McpMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m McpMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m McpMultiError) AllErrors() []error { return m }

// McpValidationError is the validation error returned by Mcp.Validate if the
// designated constraints aren't met.
type McpValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e McpValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e McpValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e McpValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e McpValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e McpValidationError) ErrorName() string { return "McpValidationError" }

// Error satisfies the builtin error interface
func (e McpValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMcp.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = McpValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = McpValidationError{}

// Validate checks the field values on McpOverride with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *McpOverride) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on McpOverride with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in McpOverrideMultiError, or
// nil if none found.
func (m *McpOverride) ValidateAll() error {
	return m.validate(true)
}

func (m *McpOverride) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return McpOverrideMultiError(errors)
	}

	return nil
}

// McpOverrideMultiError is an error wrapping multiple validation errors
// returned by McpOverride.ValidateAll() if the designated constraints aren't met.
type McpOverrideMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m McpOverrideMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m McpOverrideMultiError) AllErrors() []error { return m }

// McpOverrideValidationError is the validation error returned by
// McpOverride.Validate if the designated constraints aren't met.
type McpOverrideValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e McpOverrideValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e McpOverrideValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e McpOverrideValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e McpOverrideValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e McpOverrideValidationError) ErrorName() string { return "McpOverrideValidationError" }

// Error satisfies the builtin error interface
func (e McpOverrideValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMcpOverride.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = McpOverrideValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = McpOverrideValidationError{}
