// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: pkg/apis/values_types.proto

package apis

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	v1 "k8s.io/api/core/v1"
	v11 "k8s.io/apimachinery/pkg/apis/meta/v1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Mode for the ingress controller.
type IngressControllerMode int32

const (
	// Unspecified Istio ingress controller.
	IngressControllerMode_UNSPECIFIED IngressControllerMode = 0
	// Selects all Ingress resources, with or without Istio annotation.
	IngressControllerMode_DEFAULT IngressControllerMode = 1
	// Selects only resources with istio annotation.
	IngressControllerMode_STRICT IngressControllerMode = 2
	// No ingress or sync.
	IngressControllerMode_OFF IngressControllerMode = 3
)

// Enum value maps for IngressControllerMode.
var (
	IngressControllerMode_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "DEFAULT",
		2: "STRICT",
		3: "OFF",
	}
	IngressControllerMode_value = map[string]int32{
		"UNSPECIFIED": 0,
		"DEFAULT":     1,
		"STRICT":      2,
		"OFF":         3,
	}
)

func (x IngressControllerMode) Enum() *IngressControllerMode {
	p := new(IngressControllerMode)
	*p = x
	return p
}

func (x IngressControllerMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngressControllerMode) Descriptor() protoreflect.EnumDescriptor {
	return file_pkg_apis_values_types_proto_enumTypes[0].Descriptor()
}

func (IngressControllerMode) Type() protoreflect.EnumType {
	return &file_pkg_apis_values_types_proto_enumTypes[0]
}

func (x IngressControllerMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngressControllerMode.Descriptor instead.
func (IngressControllerMode) EnumDescriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{0}
}

// Specifies which tracer to use.
type Tracer int32

const (
	Tracer_zipkin          Tracer = 0
	Tracer_lightstep       Tracer = 1
	Tracer_datadog         Tracer = 2
	Tracer_stackdriver     Tracer = 3
	Tracer_openCensusAgent Tracer = 4
	Tracer_none            Tracer = 5
)

// Enum value maps for Tracer.
var (
	Tracer_name = map[int32]string{
		0: "zipkin",
		1: "lightstep",
		2: "datadog",
		3: "stackdriver",
		4: "openCensusAgent",
		5: "none",
	}
	Tracer_value = map[string]int32{
		"zipkin":          0,
		"lightstep":       1,
		"datadog":         2,
		"stackdriver":     3,
		"openCensusAgent": 4,
		"none":            5,
	}
)

func (x Tracer) Enum() *Tracer {
	p := new(Tracer)
	*p = x
	return p
}

func (x Tracer) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tracer) Descriptor() protoreflect.EnumDescriptor {
	return file_pkg_apis_values_types_proto_enumTypes[1].Descriptor()
}

func (Tracer) Type() protoreflect.EnumType {
	return &file_pkg_apis_values_types_proto_enumTypes[1]
}

func (x Tracer) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tracer.Descriptor instead.
func (Tracer) EnumDescriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{1}
}

// Specifies the sidecar's default behavior when handling outbound traffic from the application.
type OutboundTrafficPolicyConfig_Mode int32

const (
	// Outbound traffic to unknown destinations will be allowed, in case there are no services or ServiceEntries for the destination port
	OutboundTrafficPolicyConfig_ALLOW_ANY OutboundTrafficPolicyConfig_Mode = 0
	// Restrict outbound traffic to services defined in the service registry as well as those defined through ServiceEntries
	OutboundTrafficPolicyConfig_REGISTRY_ONLY OutboundTrafficPolicyConfig_Mode = 1
)

// Enum value maps for OutboundTrafficPolicyConfig_Mode.
var (
	OutboundTrafficPolicyConfig_Mode_name = map[int32]string{
		0: "ALLOW_ANY",
		1: "REGISTRY_ONLY",
	}
	OutboundTrafficPolicyConfig_Mode_value = map[string]int32{
		"ALLOW_ANY":     0,
		"REGISTRY_ONLY": 1,
	}
)

func (x OutboundTrafficPolicyConfig_Mode) Enum() *OutboundTrafficPolicyConfig_Mode {
	p := new(OutboundTrafficPolicyConfig_Mode)
	*p = x
	return p
}

func (x OutboundTrafficPolicyConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutboundTrafficPolicyConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_pkg_apis_values_types_proto_enumTypes[2].Descriptor()
}

func (OutboundTrafficPolicyConfig_Mode) Type() protoreflect.EnumType {
	return &file_pkg_apis_values_types_proto_enumTypes[2]
}

func (x OutboundTrafficPolicyConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutboundTrafficPolicyConfig_Mode.Descriptor instead.
func (OutboundTrafficPolicyConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{19, 0}
}

// ArchConfig specifies the pod scheduling target architecture(amd64, ppc64le, s390x, arm64)
// for all the Istio control plane components.
type ArchConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Sets pod scheduling weight for amd64 arch
	Amd64 uint32 `protobuf:"varint,1,opt,name=amd64,proto3" json:"amd64,omitempty"`
	// Sets pod scheduling weight for ppc64le arch.
	Ppc64Le uint32 `protobuf:"varint,2,opt,name=ppc64le,proto3" json:"ppc64le,omitempty"`
	// Sets pod scheduling weight for s390x arch.
	S390X uint32 `protobuf:"varint,3,opt,name=s390x,proto3" json:"s390x,omitempty"`
	// Sets pod scheduling weight for arm64 arch.
	Arm64         uint32 `protobuf:"varint,4,opt,name=arm64,proto3" json:"arm64,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ArchConfig) Reset() {
	*x = ArchConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchConfig) ProtoMessage() {}

func (x *ArchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchConfig.ProtoReflect.Descriptor instead.
func (*ArchConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{0}
}

func (x *ArchConfig) GetAmd64() uint32 {
	if x != nil {
		return x.Amd64
	}
	return 0
}

func (x *ArchConfig) GetPpc64Le() uint32 {
	if x != nil {
		return x.Ppc64Le
	}
	return 0
}

func (x *ArchConfig) GetS390X() uint32 {
	if x != nil {
		return x.S390X
	}
	return 0
}

func (x *ArchConfig) GetArm64() uint32 {
	if x != nil {
		return x.Arm64
	}
	return 0
}

// Configuration for CNI.
type CNIConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether CNI is installed.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Hub to pull the container image from. Image will be `Hub/Image:Tag-Variant`.
	Hub string `protobuf:"bytes,2,opt,name=hub,proto3" json:"hub,omitempty"`
	// The container image tag to pull. Image will be `Hub/Image:Tag-Variant`.
	Tag *structpb.Value `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
	// The container image variant to pull. Options are "debug" or "distroless". Unset will use the default for the given version.
	Variant string `protobuf:"bytes,29,opt,name=variant,proto3" json:"variant,omitempty"`
	// Image name to pull from. Image will be `Hub/Image:Tag-Variant`.
	// If Image contains a "/", it will replace the entire `image` in the pod.
	Image string `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Specifies the image pull policy. one of Always, Never, IfNotPresent.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated.
	//
	// More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
	PullPolicy string `protobuf:"bytes,5,opt,name=pullPolicy,proto3" json:"pullPolicy,omitempty"`
	// The directory path within the cluster node's filesystem where the CNI binaries are to be installed. Typically /var/lib/cni/bin.
	CniBinDir string `protobuf:"bytes,6,opt,name=cniBinDir,proto3" json:"cniBinDir,omitempty"`
	// The directory path within the cluster node's filesystem where the CNI configuration files are to be installed. Typically /etc/cni/net.d.
	CniConfDir string `protobuf:"bytes,7,opt,name=cniConfDir,proto3" json:"cniConfDir,omitempty"`
	// The name of the CNI plugin configuration file. Defaults to istio-cni.conf.
	CniConfFileName string `protobuf:"bytes,8,opt,name=cniConfFileName,proto3" json:"cniConfFileName,omitempty"`
	// The directory path within the cluster node's filesystem where network namespaces are located.
	// Defaults to '/var/run/netns', in minikube/docker/others can be '/var/run/docker/netns'.
	CniNetnsDir string `protobuf:"bytes,31,opt,name=cniNetnsDir,proto3" json:"cniNetnsDir,omitempty"`
	// List of namespaces that should be ignored by the CNI plugin.
	ExcludeNamespaces []string `protobuf:"bytes,9,rep,name=excludeNamespaces,proto3" json:"excludeNamespaces,omitempty"`
	// K8s affinity to set on the istio-cni Pods. Can be used to exclude istio-cni from being scheduled on specified nodes.
	Affinity *v1.Affinity `protobuf:"bytes,20,opt,name=affinity,proto3" json:"affinity,omitempty"`
	// Environment variables passed to the CNI container.
	//
	// Examples:
	// env:
	//
	//	ENV_VAR_1: value1
	//	ENV_VAR_2: value2
	Env *structpb.Struct `protobuf:"bytes,32,opt,name=env,proto3" json:"env,omitempty"`
	// Additional annotations to apply to the istio-cni Pods.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAnnotations *structpb.Struct `protobuf:"bytes,10,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	// PodSecurityPolicy cluster role. No longer used anywhere.
	PspClusterRole string `protobuf:"bytes,11,opt,name=psp_cluster_role,json=pspClusterRole,proto3" json:"psp_cluster_role,omitempty"`
	// DEPRECATED. Configuration log level of istio-cni binary. By default, istio-cni sends all logs to the UDS server.
	// To see the logs, change global.logging.level to cni:debug.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	LogLevel string `protobuf:"bytes,12,opt,name=logLevel,proto3" json:"logLevel,omitempty"`
	// Same as `global.logging.level`, but will override it if set
	Logging *GlobalLoggingConfig `protobuf:"bytes,25,opt,name=logging,proto3" json:"logging,omitempty"`
	// Configuration for the CNI Repair controller.
	Repair *CNIRepairConfig `protobuf:"bytes,13,opt,name=repair,proto3" json:"repair,omitempty"`
	// Configure the plugin as a chained CNI plugin. When true, the configuration is added to the CNI chain; when false,
	// the configuration is added as a standalone file in the CNI configuration directory.
	Chained *wrapperspb.BoolValue `protobuf:"bytes,14,opt,name=chained,proto3" json:"chained,omitempty"`
	// The resource quotas configration for the CNI DaemonSet.
	ResourceQuotas *ResourceQuotas `protobuf:"bytes,16,opt,name=resource_quotas,json=resourceQuotas,proto3" json:"resource_quotas,omitempty"`
	// The k8s resource requests and limits for the istio-cni Pods.
	Resources *Resources `protobuf:"bytes,17,opt,name=resources,proto3" json:"resources,omitempty"`
	// No longer used for CNI. See: https://github.com/istio/istio/issues/49004
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Privileged *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// The Container seccompProfile
	//
	// See: https://kubernetes.io/docs/tutorials/security/seccomp/
	SeccompProfile *v1.SeccompProfile `protobuf:"bytes,19,opt,name=seccompProfile,proto3" json:"seccompProfile,omitempty"`
	// Configuration for Istio Ambient.
	Ambient *CNIAmbientConfig `protobuf:"bytes,21,opt,name=ambient,proto3" json:"ambient,omitempty"`
	// Specifies the CNI provider. Can be either "default" or "multus". When set to "multus", an additional
	// NetworkAttachmentDefinition resource is deployed to the cluster to allow the istio-cni plugin to be
	// invoked in a cluster using the Multus CNI plugin.
	Provider string `protobuf:"bytes,22,opt,name=provider,proto3" json:"provider,omitempty"`
	// The number of pods that can be unavailable during a rolling update of the CNI DaemonSet (see
	// `updateStrategy.rollingUpdate.maxUnavailable` here:
	// https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/daemon-set-v1/#DaemonSetSpec).
	// May be specified as a number of pods or as a percent of the total number
	// of pods at the start of the update.
	RollingMaxUnavailable *IntOrString `protobuf:"bytes,23,opt,name=rollingMaxUnavailable,proto3" json:"rollingMaxUnavailable,omitempty"`
	// Specifies if an Istio owned CNI config should be created.
	IstioOwnedCNIConfig         *wrapperspb.BoolValue `protobuf:"bytes,35,opt,name=istioOwnedCNIConfig,proto3" json:"istioOwnedCNIConfig,omitempty"`
	IstioOwnedCNIConfigFileName string                `protobuf:"bytes,36,opt,name=istioOwnedCNIConfigFileName,proto3" json:"istioOwnedCNIConfigFileName,omitempty"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *CNIConfig) Reset() {
	*x = CNIConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CNIConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CNIConfig) ProtoMessage() {}

func (x *CNIConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CNIConfig.ProtoReflect.Descriptor instead.
func (*CNIConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{1}
}

func (x *CNIConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *CNIConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *CNIConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *CNIConfig) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *CNIConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *CNIConfig) GetPullPolicy() string {
	if x != nil {
		return x.PullPolicy
	}
	return ""
}

func (x *CNIConfig) GetCniBinDir() string {
	if x != nil {
		return x.CniBinDir
	}
	return ""
}

func (x *CNIConfig) GetCniConfDir() string {
	if x != nil {
		return x.CniConfDir
	}
	return ""
}

func (x *CNIConfig) GetCniConfFileName() string {
	if x != nil {
		return x.CniConfFileName
	}
	return ""
}

func (x *CNIConfig) GetCniNetnsDir() string {
	if x != nil {
		return x.CniNetnsDir
	}
	return ""
}

func (x *CNIConfig) GetExcludeNamespaces() []string {
	if x != nil {
		return x.ExcludeNamespaces
	}
	return nil
}

func (x *CNIConfig) GetAffinity() *v1.Affinity {
	if x != nil {
		return x.Affinity
	}
	return nil
}

func (x *CNIConfig) GetEnv() *structpb.Struct {
	if x != nil {
		return x.Env
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *CNIConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

func (x *CNIConfig) GetPspClusterRole() string {
	if x != nil {
		return x.PspClusterRole
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *CNIConfig) GetLogLevel() string {
	if x != nil {
		return x.LogLevel
	}
	return ""
}

func (x *CNIConfig) GetLogging() *GlobalLoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *CNIConfig) GetRepair() *CNIRepairConfig {
	if x != nil {
		return x.Repair
	}
	return nil
}

func (x *CNIConfig) GetChained() *wrapperspb.BoolValue {
	if x != nil {
		return x.Chained
	}
	return nil
}

func (x *CNIConfig) GetResourceQuotas() *ResourceQuotas {
	if x != nil {
		return x.ResourceQuotas
	}
	return nil
}

func (x *CNIConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *CNIConfig) GetPrivileged() *wrapperspb.BoolValue {
	if x != nil {
		return x.Privileged
	}
	return nil
}

func (x *CNIConfig) GetSeccompProfile() *v1.SeccompProfile {
	if x != nil {
		return x.SeccompProfile
	}
	return nil
}

func (x *CNIConfig) GetAmbient() *CNIAmbientConfig {
	if x != nil {
		return x.Ambient
	}
	return nil
}

func (x *CNIConfig) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *CNIConfig) GetRollingMaxUnavailable() *IntOrString {
	if x != nil {
		return x.RollingMaxUnavailable
	}
	return nil
}

func (x *CNIConfig) GetIstioOwnedCNIConfig() *wrapperspb.BoolValue {
	if x != nil {
		return x.IstioOwnedCNIConfig
	}
	return nil
}

func (x *CNIConfig) GetIstioOwnedCNIConfigFileName() string {
	if x != nil {
		return x.IstioOwnedCNIConfigFileName
	}
	return ""
}

type CNIUsageConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether CNI should be used.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Chained *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=chained,proto3" json:"chained,omitempty"`
	// Specifies the CNI provider. Can be either "default" or "multus". When set to "multus", an annotation
	// `k8s.v1.cni.cncf.io/networks` is set on injected pods to point to a NetworkAttachmentDefinition
	Provider      string `protobuf:"bytes,3,opt,name=provider,proto3" json:"provider,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CNIUsageConfig) Reset() {
	*x = CNIUsageConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CNIUsageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CNIUsageConfig) ProtoMessage() {}

func (x *CNIUsageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CNIUsageConfig.ProtoReflect.Descriptor instead.
func (*CNIUsageConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{2}
}

func (x *CNIUsageConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *CNIUsageConfig) GetChained() *wrapperspb.BoolValue {
	if x != nil {
		return x.Chained
	}
	return nil
}

func (x *CNIUsageConfig) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

type CNIAmbientConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether ambient redirection is enabled
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The directory path containing the configuration files for Ambient. Defaults to /etc/ambient-config.
	ConfigDir string `protobuf:"bytes,3,opt,name=configDir,proto3" json:"configDir,omitempty"`
	// If enabled, and ambient is enabled, DNS redirection will be enabled.
	DnsCapture *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=dnsCapture,proto3" json:"dnsCapture,omitempty"`
	// UNSTABLE: If enabled, and ambient is enabled, enables ipv6 support
	Ipv6 *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=ipv6,proto3" json:"ipv6,omitempty"`
	// If enabled, and ambient is enabled, iptables reconciliation will be enabled.
	ReconcileIptablesOnStartup *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=reconcileIptablesOnStartup,proto3" json:"reconcileIptablesOnStartup,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *CNIAmbientConfig) Reset() {
	*x = CNIAmbientConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CNIAmbientConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CNIAmbientConfig) ProtoMessage() {}

func (x *CNIAmbientConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CNIAmbientConfig.ProtoReflect.Descriptor instead.
func (*CNIAmbientConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{3}
}

func (x *CNIAmbientConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *CNIAmbientConfig) GetConfigDir() string {
	if x != nil {
		return x.ConfigDir
	}
	return ""
}

func (x *CNIAmbientConfig) GetDnsCapture() *wrapperspb.BoolValue {
	if x != nil {
		return x.DnsCapture
	}
	return nil
}

func (x *CNIAmbientConfig) GetIpv6() *wrapperspb.BoolValue {
	if x != nil {
		return x.Ipv6
	}
	return nil
}

func (x *CNIAmbientConfig) GetReconcileIptablesOnStartup() *wrapperspb.BoolValue {
	if x != nil {
		return x.ReconcileIptablesOnStartup
	}
	return nil
}

type CNIRepairConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether repair behavior is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Hub to pull the container image from. Image will be `Hub/Image:Tag-Variant`.
	Hub string `protobuf:"bytes,2,opt,name=hub,proto3" json:"hub,omitempty"`
	// The container image tag to pull. Image will be `Hub/Image:Tag-Variant`.
	Tag *structpb.Value `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
	// Image name to pull from. Image will be `Hub/Image:Tag-Variant`.
	// If Image contains a "/", it will replace the entire `image` in the pod.
	Image string `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// The Repair controller has 3 modes (labelPods, deletePods, and repairPods). Pick which one meets your use cases. Note only one may be used.
	// The mode defines the action the controller will take when a pod is detected as broken.
	// If labelPods is true, the controller will label all broken pods with <brokenPodLabelKey>=<brokenPodLabelValue>.
	// This is only capable of identifying broken pods; the user is responsible for fixing them (generally, by deleting them).
	// Note this gives the DaemonSet a relatively high privilege, as modifying pod metadata/status can have wider impacts.
	LabelPods bool `protobuf:"varint,5,opt,name=labelPods,proto3" json:"labelPods,omitempty"`
	// The Repair controller has 3 modes (labelPods, deletePods, and repairPods). Pick which one meets your use cases. Note only one may be used.
	// The mode defines the action the controller will take when a pod is detected as broken.
	// If repairPods is true, the controller will dynamically repair any broken pod by setting up the pod networking configuration even after it has started.
	// Note the pod will be crashlooping, so this may take a few minutes to become fully functional based on when the retry occurs.
	// This requires no RBAC privilege, but will require the CNI agent to run as a privileged pod.
	RepairPods bool `protobuf:"varint,11,opt,name=repairPods,proto3" json:"repairPods,omitempty"`
	// No longer used.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	CreateEvents string `protobuf:"bytes,6,opt,name=createEvents,proto3" json:"createEvents,omitempty"`
	// The Repair controller has 3 modes (labelPods, deletePods, and repairPods). Pick which one meets your use cases. Note only one may be used.
	// The mode defines the action the controller will take when a pod is detected as broken.
	// If deletePods is true, the controller will delete the broken pod. The pod will then be rescheduled, hopefully onto a node that is fully ready.
	// Note this gives the DaemonSet a relatively high privilege, as it can delete any Pod.
	DeletePods bool `protobuf:"varint,7,opt,name=deletePods,proto3" json:"deletePods,omitempty"`
	// The label key to apply to a broken pod when the controller is in labelPods mode.
	BrokenPodLabelKey string `protobuf:"bytes,8,opt,name=brokenPodLabelKey,proto3" json:"brokenPodLabelKey,omitempty"`
	// The label value to apply to a broken pod when the controller is in labelPods mode.
	BrokenPodLabelValue string `protobuf:"bytes,9,opt,name=brokenPodLabelValue,proto3" json:"brokenPodLabelValue,omitempty"`
	// The name of the init container to use for the repairPods mode.
	InitContainerName string `protobuf:"bytes,10,opt,name=initContainerName,proto3" json:"initContainerName,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *CNIRepairConfig) Reset() {
	*x = CNIRepairConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CNIRepairConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CNIRepairConfig) ProtoMessage() {}

func (x *CNIRepairConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CNIRepairConfig.ProtoReflect.Descriptor instead.
func (*CNIRepairConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{4}
}

func (x *CNIRepairConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *CNIRepairConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *CNIRepairConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *CNIRepairConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *CNIRepairConfig) GetLabelPods() bool {
	if x != nil {
		return x.LabelPods
	}
	return false
}

func (x *CNIRepairConfig) GetRepairPods() bool {
	if x != nil {
		return x.RepairPods
	}
	return false
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *CNIRepairConfig) GetCreateEvents() string {
	if x != nil {
		return x.CreateEvents
	}
	return ""
}

func (x *CNIRepairConfig) GetDeletePods() bool {
	if x != nil {
		return x.DeletePods
	}
	return false
}

func (x *CNIRepairConfig) GetBrokenPodLabelKey() string {
	if x != nil {
		return x.BrokenPodLabelKey
	}
	return ""
}

func (x *CNIRepairConfig) GetBrokenPodLabelValue() string {
	if x != nil {
		return x.BrokenPodLabelValue
	}
	return ""
}

func (x *CNIRepairConfig) GetInitContainerName() string {
	if x != nil {
		return x.InitContainerName
	}
	return ""
}

// Configuration for the resource quotas for the CNI DaemonSet.
type ResourceQuotas struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether to create resource quotas or not for the CNI DaemonSet.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The hard limit on the number of pods in the namespace where the CNI DaemonSet is deployed.
	Pods          int64 `protobuf:"varint,2,opt,name=pods,proto3" json:"pods,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceQuotas) Reset() {
	*x = ResourceQuotas{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceQuotas) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceQuotas) ProtoMessage() {}

func (x *ResourceQuotas) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceQuotas.ProtoReflect.Descriptor instead.
func (*ResourceQuotas) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{5}
}

func (x *ResourceQuotas) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *ResourceQuotas) GetPods() int64 {
	if x != nil {
		return x.Pods
	}
	return 0
}

// Configuration for CPU or memory target utilization for HorizontalPodAutoscaler target.
type TargetUtilizationConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// K8s utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	TargetAverageUtilization int32 `protobuf:"varint,1,opt,name=targetAverageUtilization,proto3" json:"targetAverageUtilization,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *TargetUtilizationConfig) Reset() {
	*x = TargetUtilizationConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TargetUtilizationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetUtilizationConfig) ProtoMessage() {}

func (x *TargetUtilizationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetUtilizationConfig.ProtoReflect.Descriptor instead.
func (*TargetUtilizationConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{6}
}

func (x *TargetUtilizationConfig) GetTargetAverageUtilization() int32 {
	if x != nil {
		return x.TargetAverageUtilization
	}
	return 0
}

// Compute resources required by a container.
type Resources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The maximum amount of compute resources allowed.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	Limits map[string]string `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The minimum amount of compute resources required. If Requests is omitted for a container,
	// it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value.
	// More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	Requests      map[string]string `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resources) Reset() {
	*x = Resources{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{7}
}

func (x *Resources) GetLimits() map[string]string {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *Resources) GetRequests() map[string]string {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Mirrors ServiceAccount for unmarshaling.
type ServiceAccount struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Annotations   *structpb.Struct       `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{8}
}

func (x *ServiceAccount) GetAnnotations() *structpb.Struct {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// DefaultPodDisruptionBudgetConfig specifies the default pod disruption budget configuration.
//
// See https://kubernetes.io/docs/concepts/workloads/pods/disruptions/
type DefaultPodDisruptionBudgetConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether a PodDisruptionBudget with a default minAvailable value of 1 is created for each deployment.
	Enabled       *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DefaultPodDisruptionBudgetConfig) Reset() {
	*x = DefaultPodDisruptionBudgetConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DefaultPodDisruptionBudgetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultPodDisruptionBudgetConfig) ProtoMessage() {}

func (x *DefaultPodDisruptionBudgetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultPodDisruptionBudgetConfig.ProtoReflect.Descriptor instead.
func (*DefaultPodDisruptionBudgetConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{9}
}

func (x *DefaultPodDisruptionBudgetConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// DefaultResourcesConfig specifies the default k8s resources settings for all Istio control plane components.
type DefaultResourcesConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// k8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	Requests      *ResourcesRequestsConfig `protobuf:"bytes,1,opt,name=requests,proto3" json:"requests,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DefaultResourcesConfig) Reset() {
	*x = DefaultResourcesConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DefaultResourcesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultResourcesConfig) ProtoMessage() {}

func (x *DefaultResourcesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultResourcesConfig.ProtoReflect.Descriptor instead.
func (*DefaultResourcesConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{10}
}

func (x *DefaultResourcesConfig) GetRequests() *ResourcesRequestsConfig {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Configuration for an egress gateway.
type EgressGatewayConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether auto scaling with a HorizontalPodAutoscaler is enabled.
	AutoscaleEnabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=autoscaleEnabled,proto3" json:"autoscaleEnabled,omitempty"`
	// maxReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMax uint32 `protobuf:"varint,2,opt,name=autoscaleMax,proto3" json:"autoscaleMax,omitempty"`
	// minReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMin uint32 `protobuf:"varint,3,opt,name=autoscaleMin,proto3" json:"autoscaleMin,omitempty"`
	// K8s memory utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Memory *TargetUtilizationConfig `protobuf:"bytes,4,opt,name=memory,proto3" json:"memory,omitempty"`
	// K8s utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Cpu           *TargetUtilizationConfig `protobuf:"bytes,5,opt,name=cpu,proto3" json:"cpu,omitempty"`
	CustomService *wrapperspb.BoolValue    `protobuf:"bytes,6,opt,name=customService,proto3" json:"customService,omitempty"`
	// Controls whether an egress gateway is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Environment variables passed to the proxy container.
	Env    *structpb.Struct  `protobuf:"bytes,8,opt,name=env,proto3" json:"env,omitempty"`
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Name   string            `protobuf:"bytes,25,opt,name=name,proto3" json:"name,omitempty"`
	// K8s node selector.
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	NodeSelector *structpb.Struct `protobuf:"bytes,10,opt,name=nodeSelector,proto3" json:"nodeSelector,omitempty"`
	// K8s annotations for pods.
	//
	// See: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAnnotations *structpb.Struct `protobuf:"bytes,11,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	// Pod anti-affinity label selector.
	//
	// Specify the pod anti-affinity that allows you to constrain which nodes
	// your pod is eligible to be scheduled based on labels on pods that are
	// already running on the node rather than based on labels on nodes.
	// There are currently two types of anti-affinity:
	//
	//	"requiredDuringSchedulingIgnoredDuringExecution"
	//	"preferredDuringSchedulingIgnoredDuringExecution"
	//
	// which denote “hard” vs. “soft” requirements, you can define your values
	// in "podAntiAffinityLabelSelector" and "podAntiAffinityTermLabelSelector"
	// correspondingly.
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#affinity-and-anti-affinity
	//
	// Examples:
	// podAntiAffinityLabelSelector:
	//   - key: security
	//     operator: In
	//     values: S1,S2
	//     topologyKey: "kubernetes.io/hostname"
	//     This pod anti-affinity rule says that the pod requires not to be scheduled
	//     onto a node if that node is already running a pod with label having key
	//     “security” and value “S1”.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAntiAffinityLabelSelector []*v11.LabelSelector `protobuf:"bytes,12,rep,name=podAntiAffinityLabelSelector,proto3" json:"podAntiAffinityLabelSelector,omitempty"`
	// See PodAntiAffinityLabelSelector.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAntiAffinityTermLabelSelector []*v11.LabelSelector `protobuf:"bytes,13,rep,name=podAntiAffinityTermLabelSelector,proto3" json:"podAntiAffinityTermLabelSelector,omitempty"`
	// Ports Configuration for the egress gateway service.
	Ports []*PortsConfig `protobuf:"bytes,14,rep,name=ports,proto3" json:"ports,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Resources *Resources `protobuf:"bytes,15,opt,name=resources,proto3" json:"resources,omitempty"`
	// Config for secret volume mounts.
	SecretVolumes []*SecretVolume `protobuf:"bytes,16,rep,name=secretVolumes,proto3" json:"secretVolumes,omitempty"`
	// Annotations to add to the egress gateway service.
	ServiceAnnotations *structpb.Struct `protobuf:"bytes,17,opt,name=serviceAnnotations,proto3" json:"serviceAnnotations,omitempty"`
	// Service type.
	//
	// See https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
	Type string `protobuf:"bytes,18,opt,name=type,proto3" json:"type,omitempty"`
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Tolerations []*v1.Toleration `protobuf:"bytes,20,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	RollingMaxSurge *IntOrString `protobuf:"bytes,21,opt,name=rollingMaxSurge,proto3" json:"rollingMaxSurge,omitempty"`
	// The number of pods that can be unavailable during a rolling update (see
	// `strategy.rollingUpdate.maxUnavailable` here:
	// https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/deployment-v1/#DeploymentSpec).
	// May be specified as a number of pods or as a percent of the total number
	// of pods at the start of the update.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	RollingMaxUnavailable *IntOrString          `protobuf:"bytes,22,opt,name=rollingMaxUnavailable,proto3" json:"rollingMaxUnavailable,omitempty"`
	ConfigVolumes         []*structpb.Struct    `protobuf:"bytes,23,rep,name=configVolumes,proto3" json:"configVolumes,omitempty"`
	AdditionalContainers  []*structpb.Struct    `protobuf:"bytes,24,rep,name=additionalContainers,proto3" json:"additionalContainers,omitempty"`
	RunAsRoot             *wrapperspb.BoolValue `protobuf:"bytes,26,opt,name=runAsRoot,proto3" json:"runAsRoot,omitempty"`
	// The injection template to use for the gateway. If not set, no injection will be performed.
	InjectionTemplate string          `protobuf:"bytes,27,opt,name=injectionTemplate,proto3" json:"injectionTemplate,omitempty"`
	ServiceAccount    *ServiceAccount `protobuf:"bytes,28,opt,name=serviceAccount,proto3" json:"serviceAccount,omitempty"`
	// Defines which IP family to use for single stack or the order of IP families for dual-stack.
	// Valid list items are "IPv4", "IPv6".
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilies []string `protobuf:"bytes,29,rep,name=ipFamilies,proto3" json:"ipFamilies,omitempty"`
	// Controls whether Services are configured to use IPv4, IPv6, or both. Valid options
	// are PreferDualStack, RequireDualStack, and SingleStack.
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilyPolicy string `protobuf:"bytes,30,opt,name=ipFamilyPolicy,proto3" json:"ipFamilyPolicy,omitempty"` // Next available 31.
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *EgressGatewayConfig) Reset() {
	*x = EgressGatewayConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EgressGatewayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressGatewayConfig) ProtoMessage() {}

func (x *EgressGatewayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressGatewayConfig.ProtoReflect.Descriptor instead.
func (*EgressGatewayConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{11}
}

func (x *EgressGatewayConfig) GetAutoscaleEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoscaleEnabled
	}
	return nil
}

func (x *EgressGatewayConfig) GetAutoscaleMax() uint32 {
	if x != nil {
		return x.AutoscaleMax
	}
	return 0
}

func (x *EgressGatewayConfig) GetAutoscaleMin() uint32 {
	if x != nil {
		return x.AutoscaleMin
	}
	return 0
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetMemory() *TargetUtilizationConfig {
	if x != nil {
		return x.Memory
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetCpu() *TargetUtilizationConfig {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *EgressGatewayConfig) GetCustomService() *wrapperspb.BoolValue {
	if x != nil {
		return x.CustomService
	}
	return nil
}

func (x *EgressGatewayConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *EgressGatewayConfig) GetEnv() *structpb.Struct {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *EgressGatewayConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EgressGatewayConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetNodeSelector() *structpb.Struct {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetPodAntiAffinityLabelSelector() []*v11.LabelSelector {
	if x != nil {
		return x.PodAntiAffinityLabelSelector
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetPodAntiAffinityTermLabelSelector() []*v11.LabelSelector {
	if x != nil {
		return x.PodAntiAffinityTermLabelSelector
	}
	return nil
}

func (x *EgressGatewayConfig) GetPorts() []*PortsConfig {
	if x != nil {
		return x.Ports
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *EgressGatewayConfig) GetSecretVolumes() []*SecretVolume {
	if x != nil {
		return x.SecretVolumes
	}
	return nil
}

func (x *EgressGatewayConfig) GetServiceAnnotations() *structpb.Struct {
	if x != nil {
		return x.ServiceAnnotations
	}
	return nil
}

func (x *EgressGatewayConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetTolerations() []*v1.Toleration {
	if x != nil {
		return x.Tolerations
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetRollingMaxSurge() *IntOrString {
	if x != nil {
		return x.RollingMaxSurge
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *EgressGatewayConfig) GetRollingMaxUnavailable() *IntOrString {
	if x != nil {
		return x.RollingMaxUnavailable
	}
	return nil
}

func (x *EgressGatewayConfig) GetConfigVolumes() []*structpb.Struct {
	if x != nil {
		return x.ConfigVolumes
	}
	return nil
}

func (x *EgressGatewayConfig) GetAdditionalContainers() []*structpb.Struct {
	if x != nil {
		return x.AdditionalContainers
	}
	return nil
}

func (x *EgressGatewayConfig) GetRunAsRoot() *wrapperspb.BoolValue {
	if x != nil {
		return x.RunAsRoot
	}
	return nil
}

func (x *EgressGatewayConfig) GetInjectionTemplate() string {
	if x != nil {
		return x.InjectionTemplate
	}
	return ""
}

func (x *EgressGatewayConfig) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

func (x *EgressGatewayConfig) GetIpFamilies() []string {
	if x != nil {
		return x.IpFamilies
	}
	return nil
}

func (x *EgressGatewayConfig) GetIpFamilyPolicy() string {
	if x != nil {
		return x.IpFamilyPolicy
	}
	return ""
}

// Configuration for gateways.
type GatewaysConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for an egress gateway.
	IstioEgressgateway *EgressGatewayConfig `protobuf:"bytes,1,opt,name=istio_egressgateway,json=istio-egressgateway,proto3" json:"istio_egressgateway,omitempty"`
	// Controls whether any gateways are enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Configuration for an ingress gateway.
	IstioIngressgateway *IngressGatewayConfig `protobuf:"bytes,4,opt,name=istio_ingressgateway,json=istio-ingressgateway,proto3" json:"istio_ingressgateway,omitempty"`
	SecurityContext     *structpb.Value       `protobuf:"bytes,10,opt,name=securityContext,proto3" json:"securityContext,omitempty"`
	SeccompProfile      *structpb.Value       `protobuf:"bytes,12,opt,name=seccompProfile,proto3" json:"seccompProfile,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GatewaysConfig) Reset() {
	*x = GatewaysConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewaysConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewaysConfig) ProtoMessage() {}

func (x *GatewaysConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewaysConfig.ProtoReflect.Descriptor instead.
func (*GatewaysConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{12}
}

func (x *GatewaysConfig) GetIstioEgressgateway() *EgressGatewayConfig {
	if x != nil {
		return x.IstioEgressgateway
	}
	return nil
}

func (x *GatewaysConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *GatewaysConfig) GetIstioIngressgateway() *IngressGatewayConfig {
	if x != nil {
		return x.IstioIngressgateway
	}
	return nil
}

func (x *GatewaysConfig) GetSecurityContext() *structpb.Value {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

func (x *GatewaysConfig) GetSeccompProfile() *structpb.Value {
	if x != nil {
		return x.SeccompProfile
	}
	return nil
}

// Global Configuration for Istio components.
type GlobalConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies pod scheduling arch(amd64, ppc64le, s390x, arm64) and weight as follows:
	//
	//	0 - Never scheduled
	//	1 - Least preferred
	//	2 - No preference
	//	3 - Most preferred
	//
	// Deprecated: replaced by the affinity k8s settings which allows architecture nodeAffinity configuration of this behavior.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Arch *ArchConfig `protobuf:"bytes,1,opt,name=arch,proto3" json:"arch,omitempty"`
	// List of certSigners to allow "approve" action in the ClusterRole
	CertSigners []string `protobuf:"bytes,68,rep,name=certSigners,proto3" json:"certSigners,omitempty"`
	// Controls whether the server-side validation is enabled.
	ConfigValidation *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=configValidation,proto3" json:"configValidation,omitempty"`
	// Default k8s node selector for all the Istio control plane components
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	DefaultNodeSelector *structpb.Struct `protobuf:"bytes,6,opt,name=defaultNodeSelector,proto3" json:"defaultNodeSelector,omitempty"`
	// Specifies the default pod disruption budget configuration.
	DefaultPodDisruptionBudget *DefaultPodDisruptionBudgetConfig `protobuf:"bytes,7,opt,name=defaultPodDisruptionBudget,proto3" json:"defaultPodDisruptionBudget,omitempty"`
	// Default k8s resources settings for all Istio control plane components.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	DefaultResources *DefaultResourcesConfig `protobuf:"bytes,9,opt,name=defaultResources,proto3" json:"defaultResources,omitempty"`
	// Default node tolerations to be applied to all deployments so that all pods can be
	// scheduled to nodes with matching taints. Each component can overwrite
	// these default values by adding its tolerations block in the relevant section below
	// and setting the desired values.
	// Configure this field in case that all pods of Istio control plane are expected to
	// be scheduled to particular nodes with specified taints.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	DefaultTolerations []*v1.Toleration `protobuf:"bytes,55,rep,name=defaultTolerations,proto3" json:"defaultTolerations,omitempty"`
	// Specifies the docker hub for Istio images.
	Hub string `protobuf:"bytes,12,opt,name=hub,proto3" json:"hub,omitempty"`
	// Specifies the image pull policy for the Istio images. one of Always, Never, IfNotPresent.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated.
	//
	// More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
	ImagePullPolicy string `protobuf:"bytes,13,opt,name=imagePullPolicy,proto3" json:"imagePullPolicy,omitempty"`
	// ImagePullSecrets for the control plane ServiceAccount, list of secrets in the same namespace
	// to use for pulling any images in pods that reference this ServiceAccount.
	// Must be set for any cluster configured with private docker registry.
	ImagePullSecrets []string `protobuf:"bytes,37,rep,name=imagePullSecrets,proto3" json:"imagePullSecrets,omitempty"`
	// Specifies the default namespace for the Istio control plane components.
	IstioNamespace string `protobuf:"bytes,14,opt,name=istioNamespace,proto3" json:"istioNamespace,omitempty"`
	// Specifies whether istio components should output logs in json format by adding --log_as_json argument to each container.
	LogAsJson *wrapperspb.BoolValue `protobuf:"bytes,36,opt,name=logAsJson,proto3" json:"logAsJson,omitempty"`
	// Specifies the global logging level settings for the Istio control plane components.
	Logging *GlobalLoggingConfig `protobuf:"bytes,17,opt,name=logging,proto3" json:"logging,omitempty"`
	// The Mesh Identifier. It should be unique within the scope where
	// meshes will interact with each other, but it is not required to be
	// globally/universally unique. For example, if any of the following are true,
	// then two meshes must have different Mesh IDs:
	// - Meshes will have their telemetry aggregated in one place
	// - Meshes will be federated together
	// - Policy will be written referencing one mesh from the other
	//
	// If an administrator expects that any of these conditions may become true in
	// the future, they should ensure their meshes have different Mesh IDs
	// assigned.
	//
	// Within a multicluster mesh, each cluster must be (manually or auto)
	// configured to have the same Mesh ID value. If an existing cluster 'joins' a
	// multicluster mesh, it will need to be migrated to the new mesh ID. Details
	// of migration TBD, and it may be a disruptive operation to change the Mesh
	// ID post-install.
	//
	// If the mesh admin does not specify a value, Istio will use the value of the
	// mesh's Trust Domain. The best practice is to select a proper Trust Domain
	// value.
	MeshID string `protobuf:"bytes,53,opt,name=meshID,proto3" json:"meshID,omitempty"`
	// Configure the mesh networks to be used by the Split Horizon EDS.
	//
	// The following example defines two networks with different endpoints association methods.
	// For `network1` all endpoints that their IP belongs to the provided CIDR range will be
	// mapped to network1. The gateway for this network example is specified by its public IP
	// address and port.
	// The second network, `network2`, in this example is defined differently with all endpoints
	// retrieved through the specified Multi-Cluster registry being mapped to network2. The
	// gateway is also defined differently with the name of the gateway service on the remote
	// cluster. The public IP for the gateway will be determined from that remote service (only
	// LoadBalancer gateway service type is currently supported, for a NodePort type gateway service,
	// it still need to be configured manually).
	//
	// meshNetworks:
	//
	//	network1:
	//	  endpoints:
	//	  - fromCidr: "192.168.0.1/24"
	//	  gateways:
	//	  - address: 1.1.1.1
	//	    port: 80
	//	network2:
	//	  endpoints:
	//	  - fromRegistry: reg1
	//	  gateways:
	//	  - registryServiceName: istio-ingressgateway.istio-system.svc.cluster.local
	//	    port: 443
	MeshNetworks *structpb.Struct `protobuf:"bytes,19,opt,name=meshNetworks,proto3" json:"meshNetworks,omitempty"`
	// Specifies the Configuration for Istio mesh across multiple clusters through Istio gateways.
	MultiCluster *MultiClusterConfig `protobuf:"bytes,22,opt,name=multiCluster,proto3" json:"multiCluster,omitempty"`
	// Network defines the network this cluster belong to. This name
	// corresponds to the networks in the map of mesh networks.
	Network string `protobuf:"bytes,39,opt,name=network,proto3" json:"network,omitempty"`
	// Custom DNS config for the pod to resolve names of services in other
	// clusters. Use this to add additional search domains, and other settings.
	// see https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#dns-config
	// This does not apply to gateway pods as they typically need a different
	// set of DNS settings than the normal application pods (e.g. in multicluster scenarios).
	PodDNSSearchNamespaces []string `protobuf:"bytes,43,rep,name=podDNSSearchNamespaces,proto3" json:"podDNSSearchNamespaces,omitempty"`
	// Controls whether the creation of the sidecar injector ConfigMap should be skipped.
	// Defaults to false. When set to true, the sidecar injector ConfigMap will not be created.
	OmitSidecarInjectorConfigMap *wrapperspb.BoolValue `protobuf:"bytes,38,opt,name=omitSidecarInjectorConfigMap,proto3" json:"omitSidecarInjectorConfigMap,omitempty"`
	// Controls whether the WebhookConfiguration resource(s) should be created. The current behavior
	// of Istiod is to manage its own webhook configurations.
	// When this option is set to true, Istio Operator, instead of webhooks, manages the
	// webhook configurations. When this option is set as false, webhooks manage their
	// own webhook configurations.
	OperatorManageWebhooks *wrapperspb.BoolValue `protobuf:"bytes,41,opt,name=operatorManageWebhooks,proto3" json:"operatorManageWebhooks,omitempty"`
	// Specifies the k8s priorityClassName for the istio control plane components.
	//
	// See https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/#priorityclass
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PriorityClassName string `protobuf:"bytes,27,opt,name=priorityClassName,proto3" json:"priorityClassName,omitempty"`
	// Specifies how proxies are configured within Istio.
	Proxy *ProxyConfig `protobuf:"bytes,28,opt,name=proxy,proto3" json:"proxy,omitempty"`
	// Specifies the Configuration for proxy_init container which sets the pods' networking to intercept the inbound/outbound traffic.
	ProxyInit *ProxyInitConfig `protobuf:"bytes,29,opt,name=proxy_init,proto3" json:"proxy_init,omitempty"`
	// Specifies the Configuration for the SecretDiscoveryService instead of using K8S secrets to mount the certificates.
	Sds *SDSConfig `protobuf:"bytes,30,opt,name=sds,proto3" json:"sds,omitempty"`
	// Specifies the tag for the Istio docker images.
	Tag *structpb.Value `protobuf:"bytes,31,opt,name=tag,proto3" json:"tag,omitempty"`
	// The variant of the Istio container images to use. Options are "debug" or "distroless". Unset will use the default for the given version.
	Variant string `protobuf:"bytes,67,opt,name=variant,proto3" json:"variant,omitempty"`
	// Specifies the Configuration for each of the supported tracers.
	Tracer *TracerConfig `protobuf:"bytes,33,opt,name=tracer,proto3" json:"tracer,omitempty"`
	// Specifies the Istio control plane’s pilot Pod IP address or remote cluster DNS resolvable hostname.
	RemotePilotAddress string `protobuf:"bytes,48,opt,name=remotePilotAddress,proto3" json:"remotePilotAddress,omitempty"`
	// Specifies the configution of istiod
	Istiod *IstiodConfig `protobuf:"bytes,54,opt,name=istiod,proto3" json:"istiod,omitempty"`
	// Configure the Pilot certificate provider.
	// Currently, four providers are supported: "kubernetes", "istiod", "custom" and "none".
	PilotCertProvider string `protobuf:"bytes,56,opt,name=pilotCertProvider,proto3" json:"pilotCertProvider,omitempty"`
	// Configure the policy for validating JWT.
	// This is deprecated and has no effect.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	JwtPolicy string `protobuf:"bytes,57,opt,name=jwtPolicy,proto3" json:"jwtPolicy,omitempty"`
	// Specifies the configuration for Security Token Service.
	Sts *STSConfig `protobuf:"bytes,58,opt,name=sts,proto3" json:"sts,omitempty"`
	// Configures the revision this control plane is a part of
	Revision string `protobuf:"bytes,59,opt,name=revision,proto3" json:"revision,omitempty"`
	// Controls whether the in-cluster MTLS key and certs are loaded from the secret volume mounts.
	MountMtlsCerts *wrapperspb.BoolValue `protobuf:"bytes,60,opt,name=mountMtlsCerts,proto3" json:"mountMtlsCerts,omitempty"`
	// The address of the CA for CSR.
	CaAddress string `protobuf:"bytes,61,opt,name=caAddress,proto3" json:"caAddress,omitempty"`
	// Controls whether one external istiod is enabled.
	ExternalIstiod *wrapperspb.BoolValue `protobuf:"bytes,62,opt,name=externalIstiod,proto3" json:"externalIstiod,omitempty"`
	// Controls whether a remote cluster is the config cluster for an external istiod
	ConfigCluster *wrapperspb.BoolValue `protobuf:"bytes,64,opt,name=configCluster,proto3" json:"configCluster,omitempty"`
	// The name of the CA for workloads.
	// For example, when caName=GkeWorkloadCertificate, GKE workload certificates
	// will be used as the certificates for workloads.
	// The default value is "" and when caName="", the CA will be configured by other
	// mechanisms (e.g., environmental variable CA_PROVIDER).
	CaName string `protobuf:"bytes,65,opt,name=caName,proto3" json:"caName,omitempty"`
	// Platform in which Istio is deployed. Possible values are: "openshift" and "gcp"
	// An empty value means it is a vanilla Kubernetes distribution, therefore no special
	// treatment will be considered.
	Platform string `protobuf:"bytes,69,opt,name=platform,proto3" json:"platform,omitempty"`
	// Defines which IP family to use for single stack or the order of IP families for dual-stack.
	// Valid list items are "IPv4", "IPv6".
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilies []string `protobuf:"bytes,70,rep,name=ipFamilies,proto3" json:"ipFamilies,omitempty"`
	// Controls whether Services are configured to use IPv4, IPv6, or both. Valid options
	// are PreferDualStack, RequireDualStack, and SingleStack.
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilyPolicy string `protobuf:"bytes,71,opt,name=ipFamilyPolicy,proto3" json:"ipFamilyPolicy,omitempty"`
	// Specifies how waypoints are configured within Istio.
	Waypoint *WaypointConfig `protobuf:"bytes,72,opt,name=waypoint,proto3" json:"waypoint,omitempty"`
	// Select a custom name for istiod's CA Root Cert ConfigMap.
	TrustBundleName string `protobuf:"bytes,73,opt,name=trustBundleName,proto3" json:"trustBundleName,omitempty"`
	// Specifies whether native nftables rules should be used instead of iptables rules for traffic redirection.
	NativeNftables *wrapperspb.BoolValue `protobuf:"bytes,74,opt,name=nativeNftables,proto3" json:"nativeNftables,omitempty"` // The next available key is 75
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GlobalConfig) Reset() {
	*x = GlobalConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GlobalConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalConfig) ProtoMessage() {}

func (x *GlobalConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalConfig.ProtoReflect.Descriptor instead.
func (*GlobalConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{13}
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *GlobalConfig) GetArch() *ArchConfig {
	if x != nil {
		return x.Arch
	}
	return nil
}

func (x *GlobalConfig) GetCertSigners() []string {
	if x != nil {
		return x.CertSigners
	}
	return nil
}

func (x *GlobalConfig) GetConfigValidation() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigValidation
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *GlobalConfig) GetDefaultNodeSelector() *structpb.Struct {
	if x != nil {
		return x.DefaultNodeSelector
	}
	return nil
}

func (x *GlobalConfig) GetDefaultPodDisruptionBudget() *DefaultPodDisruptionBudgetConfig {
	if x != nil {
		return x.DefaultPodDisruptionBudget
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *GlobalConfig) GetDefaultResources() *DefaultResourcesConfig {
	if x != nil {
		return x.DefaultResources
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *GlobalConfig) GetDefaultTolerations() []*v1.Toleration {
	if x != nil {
		return x.DefaultTolerations
	}
	return nil
}

func (x *GlobalConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *GlobalConfig) GetImagePullPolicy() string {
	if x != nil {
		return x.ImagePullPolicy
	}
	return ""
}

func (x *GlobalConfig) GetImagePullSecrets() []string {
	if x != nil {
		return x.ImagePullSecrets
	}
	return nil
}

func (x *GlobalConfig) GetIstioNamespace() string {
	if x != nil {
		return x.IstioNamespace
	}
	return ""
}

func (x *GlobalConfig) GetLogAsJson() *wrapperspb.BoolValue {
	if x != nil {
		return x.LogAsJson
	}
	return nil
}

func (x *GlobalConfig) GetLogging() *GlobalLoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *GlobalConfig) GetMeshID() string {
	if x != nil {
		return x.MeshID
	}
	return ""
}

func (x *GlobalConfig) GetMeshNetworks() *structpb.Struct {
	if x != nil {
		return x.MeshNetworks
	}
	return nil
}

func (x *GlobalConfig) GetMultiCluster() *MultiClusterConfig {
	if x != nil {
		return x.MultiCluster
	}
	return nil
}

func (x *GlobalConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *GlobalConfig) GetPodDNSSearchNamespaces() []string {
	if x != nil {
		return x.PodDNSSearchNamespaces
	}
	return nil
}

func (x *GlobalConfig) GetOmitSidecarInjectorConfigMap() *wrapperspb.BoolValue {
	if x != nil {
		return x.OmitSidecarInjectorConfigMap
	}
	return nil
}

func (x *GlobalConfig) GetOperatorManageWebhooks() *wrapperspb.BoolValue {
	if x != nil {
		return x.OperatorManageWebhooks
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *GlobalConfig) GetPriorityClassName() string {
	if x != nil {
		return x.PriorityClassName
	}
	return ""
}

func (x *GlobalConfig) GetProxy() *ProxyConfig {
	if x != nil {
		return x.Proxy
	}
	return nil
}

func (x *GlobalConfig) GetProxyInit() *ProxyInitConfig {
	if x != nil {
		return x.ProxyInit
	}
	return nil
}

func (x *GlobalConfig) GetSds() *SDSConfig {
	if x != nil {
		return x.Sds
	}
	return nil
}

func (x *GlobalConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *GlobalConfig) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *GlobalConfig) GetTracer() *TracerConfig {
	if x != nil {
		return x.Tracer
	}
	return nil
}

func (x *GlobalConfig) GetRemotePilotAddress() string {
	if x != nil {
		return x.RemotePilotAddress
	}
	return ""
}

func (x *GlobalConfig) GetIstiod() *IstiodConfig {
	if x != nil {
		return x.Istiod
	}
	return nil
}

func (x *GlobalConfig) GetPilotCertProvider() string {
	if x != nil {
		return x.PilotCertProvider
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *GlobalConfig) GetJwtPolicy() string {
	if x != nil {
		return x.JwtPolicy
	}
	return ""
}

func (x *GlobalConfig) GetSts() *STSConfig {
	if x != nil {
		return x.Sts
	}
	return nil
}

func (x *GlobalConfig) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *GlobalConfig) GetMountMtlsCerts() *wrapperspb.BoolValue {
	if x != nil {
		return x.MountMtlsCerts
	}
	return nil
}

func (x *GlobalConfig) GetCaAddress() string {
	if x != nil {
		return x.CaAddress
	}
	return ""
}

func (x *GlobalConfig) GetExternalIstiod() *wrapperspb.BoolValue {
	if x != nil {
		return x.ExternalIstiod
	}
	return nil
}

func (x *GlobalConfig) GetConfigCluster() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigCluster
	}
	return nil
}

func (x *GlobalConfig) GetCaName() string {
	if x != nil {
		return x.CaName
	}
	return ""
}

func (x *GlobalConfig) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *GlobalConfig) GetIpFamilies() []string {
	if x != nil {
		return x.IpFamilies
	}
	return nil
}

func (x *GlobalConfig) GetIpFamilyPolicy() string {
	if x != nil {
		return x.IpFamilyPolicy
	}
	return ""
}

func (x *GlobalConfig) GetWaypoint() *WaypointConfig {
	if x != nil {
		return x.Waypoint
	}
	return nil
}

func (x *GlobalConfig) GetTrustBundleName() string {
	if x != nil {
		return x.TrustBundleName
	}
	return ""
}

func (x *GlobalConfig) GetNativeNftables() *wrapperspb.BoolValue {
	if x != nil {
		return x.NativeNftables
	}
	return nil
}

// Configuration for Security Token Service (STS) server.
//
// See https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-16
type STSConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ServicePort   uint32                 `protobuf:"varint,1,opt,name=servicePort,proto3" json:"servicePort,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *STSConfig) Reset() {
	*x = STSConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *STSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*STSConfig) ProtoMessage() {}

func (x *STSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use STSConfig.ProtoReflect.Descriptor instead.
func (*STSConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{14}
}

func (x *STSConfig) GetServicePort() uint32 {
	if x != nil {
		return x.ServicePort
	}
	return 0
}

type IstiodConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If enabled, istiod will perform config analysis
	EnableAnalysis *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enableAnalysis,proto3" json:"enableAnalysis,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *IstiodConfig) Reset() {
	*x = IstiodConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IstiodConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstiodConfig) ProtoMessage() {}

func (x *IstiodConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstiodConfig.ProtoReflect.Descriptor instead.
func (*IstiodConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{15}
}

func (x *IstiodConfig) GetEnableAnalysis() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableAnalysis
	}
	return nil
}

// GlobalLoggingConfig specifies the global logging level settings for the Istio control plane components.
type GlobalLoggingConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Comma-separated minimum per-scope logging level of messages to output, in the form of <scope>:<level>,<scope>:<level>
	// The control plane has different scopes depending on component, but can configure default log level across all components
	// If empty, default scope and level will be used as configured in code
	Level         string `protobuf:"bytes,1,opt,name=level,proto3" json:"level,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GlobalLoggingConfig) Reset() {
	*x = GlobalLoggingConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GlobalLoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalLoggingConfig) ProtoMessage() {}

func (x *GlobalLoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalLoggingConfig.ProtoReflect.Descriptor instead.
func (*GlobalLoggingConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{16}
}

func (x *GlobalLoggingConfig) GetLevel() string {
	if x != nil {
		return x.Level
	}
	return ""
}

// Configuration for an ingress gateway.
type IngressGatewayConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether auto scaling with a HorizontalPodAutoscaler is enabled.
	AutoscaleEnabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=autoscaleEnabled,proto3" json:"autoscaleEnabled,omitempty"`
	// maxReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMax uint32 `protobuf:"varint,2,opt,name=autoscaleMax,proto3" json:"autoscaleMax,omitempty"`
	// minReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMin uint32 `protobuf:"varint,3,opt,name=autoscaleMin,proto3" json:"autoscaleMin,omitempty"`
	// K8s memory utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Memory *TargetUtilizationConfig `protobuf:"bytes,4,opt,name=memory,proto3" json:"memory,omitempty"`
	// K8s cpu utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Cpu           *TargetUtilizationConfig `protobuf:"bytes,5,opt,name=cpu,proto3" json:"cpu,omitempty"`
	CustomService *wrapperspb.BoolValue    `protobuf:"bytes,6,opt,name=customService,proto3" json:"customService,omitempty"`
	// Controls whether an ingress gateway is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Environment variables passed to the proxy container.
	Env                      *structpb.Struct  `protobuf:"bytes,11,opt,name=env,proto3" json:"env,omitempty"`
	Labels                   map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	LoadBalancerIP           string            `protobuf:"bytes,16,opt,name=loadBalancerIP,proto3" json:"loadBalancerIP,omitempty"`
	LoadBalancerSourceRanges []string          `protobuf:"bytes,17,rep,name=loadBalancerSourceRanges,proto3" json:"loadBalancerSourceRanges,omitempty"`
	Name                     string            `protobuf:"bytes,44,opt,name=name,proto3" json:"name,omitempty"`
	// K8s node selector.
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	NodeSelector *structpb.Struct `protobuf:"bytes,19,opt,name=nodeSelector,proto3" json:"nodeSelector,omitempty"`
	// K8s annotations for pods.
	//
	// See: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAnnotations *structpb.Struct `protobuf:"bytes,20,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	// See EgressGatewayConfig.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAntiAffinityLabelSelector []*v11.LabelSelector `protobuf:"bytes,21,rep,name=podAntiAffinityLabelSelector,proto3" json:"podAntiAffinityLabelSelector,omitempty"`
	// See EgressGatewayConfig.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAntiAffinityTermLabelSelector []*v11.LabelSelector `protobuf:"bytes,22,rep,name=podAntiAffinityTermLabelSelector,proto3" json:"podAntiAffinityTermLabelSelector,omitempty"`
	// Port Configuration for the ingress gateway.
	Ports []*PortsConfig `protobuf:"bytes,23,rep,name=ports,proto3" json:"ports,omitempty"`
	// Number of replicas for the ingress gateway Deployment.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	ReplicaCount uint32 `protobuf:"varint,24,opt,name=replicaCount,proto3" json:"replicaCount,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Resources *structpb.Struct `protobuf:"bytes,25,opt,name=resources,proto3" json:"resources,omitempty"`
	// Config for secret volume mounts.
	SecretVolumes []*SecretVolume `protobuf:"bytes,27,rep,name=secretVolumes,proto3" json:"secretVolumes,omitempty"`
	// Annotations to add to the egress gateway service.
	ServiceAnnotations *structpb.Struct `protobuf:"bytes,28,opt,name=serviceAnnotations,proto3" json:"serviceAnnotations,omitempty"`
	// Service type.
	//
	// See https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
	Type string `protobuf:"bytes,29,opt,name=type,proto3" json:"type,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	RollingMaxSurge *IntOrString `protobuf:"bytes,31,opt,name=rollingMaxSurge,proto3" json:"rollingMaxSurge,omitempty"`
	// The number of pods that can be unavailable during a rolling update (see
	// `strategy.rollingUpdate.maxUnavailable` here:
	// https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/deployment-v1/#DeploymentSpec).
	// May be specified as a number of pods or as a percent of the total number
	// of pods at the start of the update.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	RollingMaxUnavailable *IntOrString `protobuf:"bytes,32,opt,name=rollingMaxUnavailable,proto3" json:"rollingMaxUnavailable,omitempty"`
	ExternalTrafficPolicy string       `protobuf:"bytes,34,opt,name=externalTrafficPolicy,proto3" json:"externalTrafficPolicy,omitempty"`
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Tolerations          []*v1.Toleration      `protobuf:"bytes,35,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	IngressPorts         []*structpb.Struct    `protobuf:"bytes,36,rep,name=ingressPorts,proto3" json:"ingressPorts,omitempty"`
	AdditionalContainers []*structpb.Struct    `protobuf:"bytes,37,rep,name=additionalContainers,proto3" json:"additionalContainers,omitempty"`
	ConfigVolumes        []*structpb.Struct    `protobuf:"bytes,38,rep,name=configVolumes,proto3" json:"configVolumes,omitempty"`
	RunAsRoot            *wrapperspb.BoolValue `protobuf:"bytes,45,opt,name=runAsRoot,proto3" json:"runAsRoot,omitempty"`
	// The injection template to use for the gateway. If not set, no injection will be performed.
	InjectionTemplate string          `protobuf:"bytes,46,opt,name=injectionTemplate,proto3" json:"injectionTemplate,omitempty"`
	ServiceAccount    *ServiceAccount `protobuf:"bytes,47,opt,name=serviceAccount,proto3" json:"serviceAccount,omitempty"`
	// Defines which IP family to use for single stack or the order of IP families for dual-stack.
	// Valid list items are "IPv4", "IPv6".
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilies []string `protobuf:"bytes,48,rep,name=ipFamilies,proto3" json:"ipFamilies,omitempty"`
	// Controls whether Services are configured to use IPv4, IPv6, or both. Valid options
	// are PreferDualStack, RequireDualStack, and SingleStack.
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilyPolicy string `protobuf:"bytes,49,opt,name=ipFamilyPolicy,proto3" json:"ipFamilyPolicy,omitempty"` // Next available 50.
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *IngressGatewayConfig) Reset() {
	*x = IngressGatewayConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IngressGatewayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngressGatewayConfig) ProtoMessage() {}

func (x *IngressGatewayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngressGatewayConfig.ProtoReflect.Descriptor instead.
func (*IngressGatewayConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{17}
}

func (x *IngressGatewayConfig) GetAutoscaleEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoscaleEnabled
	}
	return nil
}

func (x *IngressGatewayConfig) GetAutoscaleMax() uint32 {
	if x != nil {
		return x.AutoscaleMax
	}
	return 0
}

func (x *IngressGatewayConfig) GetAutoscaleMin() uint32 {
	if x != nil {
		return x.AutoscaleMin
	}
	return 0
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetMemory() *TargetUtilizationConfig {
	if x != nil {
		return x.Memory
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetCpu() *TargetUtilizationConfig {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *IngressGatewayConfig) GetCustomService() *wrapperspb.BoolValue {
	if x != nil {
		return x.CustomService
	}
	return nil
}

func (x *IngressGatewayConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *IngressGatewayConfig) GetEnv() *structpb.Struct {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *IngressGatewayConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *IngressGatewayConfig) GetLoadBalancerIP() string {
	if x != nil {
		return x.LoadBalancerIP
	}
	return ""
}

func (x *IngressGatewayConfig) GetLoadBalancerSourceRanges() []string {
	if x != nil {
		return x.LoadBalancerSourceRanges
	}
	return nil
}

func (x *IngressGatewayConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetNodeSelector() *structpb.Struct {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetPodAntiAffinityLabelSelector() []*v11.LabelSelector {
	if x != nil {
		return x.PodAntiAffinityLabelSelector
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetPodAntiAffinityTermLabelSelector() []*v11.LabelSelector {
	if x != nil {
		return x.PodAntiAffinityTermLabelSelector
	}
	return nil
}

func (x *IngressGatewayConfig) GetPorts() []*PortsConfig {
	if x != nil {
		return x.Ports
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetReplicaCount() uint32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetResources() *structpb.Struct {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *IngressGatewayConfig) GetSecretVolumes() []*SecretVolume {
	if x != nil {
		return x.SecretVolumes
	}
	return nil
}

func (x *IngressGatewayConfig) GetServiceAnnotations() *structpb.Struct {
	if x != nil {
		return x.ServiceAnnotations
	}
	return nil
}

func (x *IngressGatewayConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetRollingMaxSurge() *IntOrString {
	if x != nil {
		return x.RollingMaxSurge
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetRollingMaxUnavailable() *IntOrString {
	if x != nil {
		return x.RollingMaxUnavailable
	}
	return nil
}

func (x *IngressGatewayConfig) GetExternalTrafficPolicy() string {
	if x != nil {
		return x.ExternalTrafficPolicy
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *IngressGatewayConfig) GetTolerations() []*v1.Toleration {
	if x != nil {
		return x.Tolerations
	}
	return nil
}

func (x *IngressGatewayConfig) GetIngressPorts() []*structpb.Struct {
	if x != nil {
		return x.IngressPorts
	}
	return nil
}

func (x *IngressGatewayConfig) GetAdditionalContainers() []*structpb.Struct {
	if x != nil {
		return x.AdditionalContainers
	}
	return nil
}

func (x *IngressGatewayConfig) GetConfigVolumes() []*structpb.Struct {
	if x != nil {
		return x.ConfigVolumes
	}
	return nil
}

func (x *IngressGatewayConfig) GetRunAsRoot() *wrapperspb.BoolValue {
	if x != nil {
		return x.RunAsRoot
	}
	return nil
}

func (x *IngressGatewayConfig) GetInjectionTemplate() string {
	if x != nil {
		return x.InjectionTemplate
	}
	return ""
}

func (x *IngressGatewayConfig) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

func (x *IngressGatewayConfig) GetIpFamilies() []string {
	if x != nil {
		return x.IpFamilies
	}
	return nil
}

func (x *IngressGatewayConfig) GetIpFamilyPolicy() string {
	if x != nil {
		return x.IpFamilyPolicy
	}
	return ""
}

// MultiClusterConfig specifies the Configuration for Istio mesh across multiple clusters through the istio gateways.
type MultiClusterConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enables the connection between two kubernetes clusters via their respective ingressgateway services.
	// Use if the pods in each cluster cannot directly talk to one another.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name of the cluster this installation will run in. This is required for sidecar injection
	// to properly label proxies
	ClusterName string `protobuf:"bytes,2,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	// The suffix for global service names.
	GlobalDomainSuffix string `protobuf:"bytes,3,opt,name=globalDomainSuffix,proto3" json:"globalDomainSuffix,omitempty"`
	// Enable envoy filter to translate `globalDomainSuffix` to cluster local suffix for cross cluster communication.
	IncludeEnvoyFilter *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=includeEnvoyFilter,proto3" json:"includeEnvoyFilter,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *MultiClusterConfig) Reset() {
	*x = MultiClusterConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MultiClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiClusterConfig) ProtoMessage() {}

func (x *MultiClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiClusterConfig.ProtoReflect.Descriptor instead.
func (*MultiClusterConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{18}
}

func (x *MultiClusterConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *MultiClusterConfig) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *MultiClusterConfig) GetGlobalDomainSuffix() string {
	if x != nil {
		return x.GlobalDomainSuffix
	}
	return ""
}

func (x *MultiClusterConfig) GetIncludeEnvoyFilter() *wrapperspb.BoolValue {
	if x != nil {
		return x.IncludeEnvoyFilter
	}
	return nil
}

// OutboundTrafficPolicyConfig controls the default behavior of the sidecar for handling outbound traffic from the application.
type OutboundTrafficPolicyConfig struct {
	state         protoimpl.MessageState           `protogen:"open.v1"`
	Mode          OutboundTrafficPolicyConfig_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.operator.v1alpha1.OutboundTrafficPolicyConfig_Mode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OutboundTrafficPolicyConfig) Reset() {
	*x = OutboundTrafficPolicyConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutboundTrafficPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundTrafficPolicyConfig) ProtoMessage() {}

func (x *OutboundTrafficPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundTrafficPolicyConfig.ProtoReflect.Descriptor instead.
func (*OutboundTrafficPolicyConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{19}
}

func (x *OutboundTrafficPolicyConfig) GetMode() OutboundTrafficPolicyConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return OutboundTrafficPolicyConfig_ALLOW_ANY
}

// Configuration for Pilot.
type PilotConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether Pilot is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Controls whether a HorizontalPodAutoscaler is installed for Pilot.
	AutoscaleEnabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=autoscaleEnabled,proto3" json:"autoscaleEnabled,omitempty"`
	// Minimum number of replicas in the HorizontalPodAutoscaler for Pilot.
	AutoscaleMin uint32 `protobuf:"varint,3,opt,name=autoscaleMin,proto3" json:"autoscaleMin,omitempty"`
	// Maximum number of replicas in the HorizontalPodAutoscaler for Pilot.
	AutoscaleMax uint32 `protobuf:"varint,4,opt,name=autoscaleMax,proto3" json:"autoscaleMax,omitempty"`
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#configurable-scaling-behavior
	AutoscaleBehavior *structpb.Struct `protobuf:"bytes,40,opt,name=autoscaleBehavior,proto3" json:"autoscaleBehavior,omitempty"`
	// Number of replicas in the Pilot Deployment.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	ReplicaCount uint32 `protobuf:"varint,5,opt,name=replicaCount,proto3" json:"replicaCount,omitempty"`
	// Image name used for Pilot.
	//
	// This can be set either to image name if hub is also set, or can be set to the full hub:name string.
	//
	// Examples: custom-pilot, docker.io/someuser:custom-pilot
	Image string `protobuf:"bytes,6,opt,name=image,proto3" json:"image,omitempty"`
	// Trace sampling fraction.
	//
	// Used to set the fraction of time that traces are sampled. Higher values are more accurate but add CPU overhead.
	//
	// Allowed values: 0.0 to 1.0
	TraceSampling float64 `protobuf:"fixed64,8,opt,name=traceSampling,proto3" json:"traceSampling,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Resources *Resources `protobuf:"bytes,9,opt,name=resources,proto3" json:"resources,omitempty"`
	// Target CPU utilization used in HorizontalPodAutoscaler.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Cpu *TargetUtilizationConfig `protobuf:"bytes,11,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// K8s node selector.
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	NodeSelector *structpb.Struct `protobuf:"bytes,12,opt,name=nodeSelector,proto3" json:"nodeSelector,omitempty"`
	// Maximum duration that a sidecar can be connected to a pilot.
	//
	// This setting balances out load across pilot instances, but adds some resource overhead.
	//
	// Examples: 300s, 30m, 1h
	KeepaliveMaxServerConnectionAge *durationpb.Duration `protobuf:"bytes,13,opt,name=keepaliveMaxServerConnectionAge,proto3" json:"keepaliveMaxServerConnectionAge,omitempty"`
	// Labels that are added to Pilot deployment.
	//
	// See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	DeploymentLabels *structpb.Struct `protobuf:"bytes,14,opt,name=deploymentLabels,proto3" json:"deploymentLabels,omitempty"`
	// Labels that are added to Pilot pods.
	//
	// See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	PodLabels *structpb.Struct `protobuf:"bytes,36,opt,name=podLabels,proto3" json:"podLabels,omitempty"`
	// Configuration settings passed to Pilot as a ConfigMap.
	//
	// This controls whether the mesh config map, generated from values.yaml is generated.
	// If false, pilot wil use default values or user-supplied values, in that order of preference.
	ConfigMap *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=configMap,proto3" json:"configMap,omitempty"`
	// Environment variables passed to the Pilot container.
	//
	// Examples:
	// env:
	//
	//	ENV_VAR_1: value1
	//	ENV_VAR_2: value2
	Env *structpb.Struct `protobuf:"bytes,21,opt,name=env,proto3" json:"env,omitempty"`
	// K8s affinity to set on the Pilot Pods.
	Affinity *v1.Affinity `protobuf:"bytes,22,opt,name=affinity,proto3" json:"affinity,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	RollingMaxSurge *IntOrString `protobuf:"bytes,24,opt,name=rollingMaxSurge,proto3" json:"rollingMaxSurge,omitempty"`
	// The number of pods that can be unavailable during a rolling update (see
	// `strategy.rollingUpdate.maxUnavailable` here:
	// https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/deployment-v1/#DeploymentSpec).
	// May be specified as a number of pods or as a percent of the total number
	// of pods at the start of the update.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	RollingMaxUnavailable *IntOrString `protobuf:"bytes,25,opt,name=rollingMaxUnavailable,proto3" json:"rollingMaxUnavailable,omitempty"`
	// The node tolerations to be applied to the Pilot deployment so that it can be
	// scheduled to particular nodes with matching taints.
	// More info: https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#scheduling
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Tolerations []*v1.Toleration `protobuf:"bytes,26,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// K8s annotations for pods.
	//
	// See: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	PodAnnotations *structpb.Struct `protobuf:"bytes,30,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	// K8s annotations for the Service.
	//
	// See: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	ServiceAnnotations *structpb.Struct `protobuf:"bytes,37,opt,name=serviceAnnotations,proto3" json:"serviceAnnotations,omitempty"`
	// K8s annotations for the service account
	ServiceAccountAnnotations *structpb.Struct `protobuf:"bytes,56,opt,name=serviceAccountAnnotations,proto3" json:"serviceAccountAnnotations,omitempty"`
	// Specifies an extra root certificate in PEM format. This certificate will be trusted
	// by pilot when resolving JWKS URIs.
	JwksResolverExtraRootCA string `protobuf:"bytes,32,opt,name=jwksResolverExtraRootCA,proto3" json:"jwksResolverExtraRootCA,omitempty"`
	// Hub to pull the container image from. Image will be `Hub/Image:Tag-Variant`.
	Hub string `protobuf:"bytes,34,opt,name=hub,proto3" json:"hub,omitempty"`
	// The container image tag to pull. Image will be `Hub/Image:Tag-Variant`.
	Tag *structpb.Value `protobuf:"bytes,35,opt,name=tag,proto3" json:"tag,omitempty"`
	// The container image variant to pull. Options are "debug" or "distroless". Unset will use the default for the given version.
	Variant string `protobuf:"bytes,39,opt,name=variant,proto3" json:"variant,omitempty"`
	// The seccompProfile for the Pilot container.
	//
	// See: https://kubernetes.io/docs/tutorials/security/seccomp/
	SeccompProfile *v1.SeccompProfile `protobuf:"bytes,38,opt,name=seccompProfile,proto3" json:"seccompProfile,omitempty"`
	// The k8s topologySpreadConstraints for the Pilot pods.
	TopologySpreadConstraints []*v1.TopologySpreadConstraint `protobuf:"bytes,41,rep,name=topologySpreadConstraints,proto3" json:"topologySpreadConstraints,omitempty"`
	// Additional container arguments for the Pilot container.
	ExtraContainerArgs []*structpb.Struct `protobuf:"bytes,42,rep,name=extraContainerArgs,proto3" json:"extraContainerArgs,omitempty"`
	// Additional volumeMounts to add to the Pilot container.
	VolumeMounts []*v1.VolumeMount `protobuf:"bytes,49,rep,name=volumeMounts,proto3" json:"volumeMounts,omitempty"`
	// Additional volumes to add to the Pilot Pod.
	Volumes []*v1.Volume `protobuf:"bytes,51,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// Defines which IP family to use for single stack or the order of IP families for dual-stack.
	// Valid list items are "IPv4", "IPv6".
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilies []string `protobuf:"bytes,52,rep,name=ipFamilies,proto3" json:"ipFamilies,omitempty"`
	// Controls whether Services are configured to use IPv4, IPv6, or both. Valid options
	// are PreferDualStack, RequireDualStack, and SingleStack.
	// More info: https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services
	IpFamilyPolicy string `protobuf:"bytes,53,opt,name=ipFamilyPolicy,proto3" json:"ipFamilyPolicy,omitempty"`
	// Target memory utilization used in HorizontalPodAutoscaler.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Memory *TargetUtilizationConfig `protobuf:"bytes,54,opt,name=memory,proto3" json:"memory,omitempty"`
	// Configures whether to use an existing CNI installation for workloads
	Cni   *CNIUsageConfig             `protobuf:"bytes,55,opt,name=cni,proto3" json:"cni,omitempty"`
	Taint *PilotTaintControllerConfig `protobuf:"bytes,57,opt,name=taint,proto3" json:"taint,omitempty"`
	// If set, `istiod` will allow connections from trusted node proxy ztunnels
	// in the provided namespace.
	TrustedZtunnelNamespace string `protobuf:"bytes,59,opt,name=trustedZtunnelNamespace,proto3" json:"trustedZtunnelNamespace,omitempty"`
	// Configuration for the istio-discovery chart when istiod is running in a remote cluster (e.g. "remote control plane").
	IstiodRemote *IstiodRemoteConfig `protobuf:"bytes,61,opt,name=istiodRemote,proto3" json:"istiodRemote,omitempty"`
	// Configuration for the istio-discovery chart
	EnvVarFrom    []*structpb.Struct `protobuf:"bytes,62,rep,name=envVarFrom,proto3" json:"envVarFrom,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PilotConfig) Reset() {
	*x = PilotConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PilotConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotConfig) ProtoMessage() {}

func (x *PilotConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotConfig.ProtoReflect.Descriptor instead.
func (*PilotConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{20}
}

func (x *PilotConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *PilotConfig) GetAutoscaleEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoscaleEnabled
	}
	return nil
}

func (x *PilotConfig) GetAutoscaleMin() uint32 {
	if x != nil {
		return x.AutoscaleMin
	}
	return 0
}

func (x *PilotConfig) GetAutoscaleMax() uint32 {
	if x != nil {
		return x.AutoscaleMax
	}
	return 0
}

func (x *PilotConfig) GetAutoscaleBehavior() *structpb.Struct {
	if x != nil {
		return x.AutoscaleBehavior
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetReplicaCount() uint32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

func (x *PilotConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *PilotConfig) GetTraceSampling() float64 {
	if x != nil {
		return x.TraceSampling
	}
	return 0
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetCpu() *TargetUtilizationConfig {
	if x != nil {
		return x.Cpu
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetNodeSelector() *structpb.Struct {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

func (x *PilotConfig) GetKeepaliveMaxServerConnectionAge() *durationpb.Duration {
	if x != nil {
		return x.KeepaliveMaxServerConnectionAge
	}
	return nil
}

func (x *PilotConfig) GetDeploymentLabels() *structpb.Struct {
	if x != nil {
		return x.DeploymentLabels
	}
	return nil
}

func (x *PilotConfig) GetPodLabels() *structpb.Struct {
	if x != nil {
		return x.PodLabels
	}
	return nil
}

func (x *PilotConfig) GetConfigMap() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigMap
	}
	return nil
}

func (x *PilotConfig) GetEnv() *structpb.Struct {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *PilotConfig) GetAffinity() *v1.Affinity {
	if x != nil {
		return x.Affinity
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetRollingMaxSurge() *IntOrString {
	if x != nil {
		return x.RollingMaxSurge
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetRollingMaxUnavailable() *IntOrString {
	if x != nil {
		return x.RollingMaxUnavailable
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetTolerations() []*v1.Toleration {
	if x != nil {
		return x.Tolerations
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

func (x *PilotConfig) GetServiceAnnotations() *structpb.Struct {
	if x != nil {
		return x.ServiceAnnotations
	}
	return nil
}

func (x *PilotConfig) GetServiceAccountAnnotations() *structpb.Struct {
	if x != nil {
		return x.ServiceAccountAnnotations
	}
	return nil
}

func (x *PilotConfig) GetJwksResolverExtraRootCA() string {
	if x != nil {
		return x.JwksResolverExtraRootCA
	}
	return ""
}

func (x *PilotConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *PilotConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *PilotConfig) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *PilotConfig) GetSeccompProfile() *v1.SeccompProfile {
	if x != nil {
		return x.SeccompProfile
	}
	return nil
}

func (x *PilotConfig) GetTopologySpreadConstraints() []*v1.TopologySpreadConstraint {
	if x != nil {
		return x.TopologySpreadConstraints
	}
	return nil
}

func (x *PilotConfig) GetExtraContainerArgs() []*structpb.Struct {
	if x != nil {
		return x.ExtraContainerArgs
	}
	return nil
}

func (x *PilotConfig) GetVolumeMounts() []*v1.VolumeMount {
	if x != nil {
		return x.VolumeMounts
	}
	return nil
}

func (x *PilotConfig) GetVolumes() []*v1.Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *PilotConfig) GetIpFamilies() []string {
	if x != nil {
		return x.IpFamilies
	}
	return nil
}

func (x *PilotConfig) GetIpFamilyPolicy() string {
	if x != nil {
		return x.IpFamilyPolicy
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *PilotConfig) GetMemory() *TargetUtilizationConfig {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *PilotConfig) GetCni() *CNIUsageConfig {
	if x != nil {
		return x.Cni
	}
	return nil
}

func (x *PilotConfig) GetTaint() *PilotTaintControllerConfig {
	if x != nil {
		return x.Taint
	}
	return nil
}

func (x *PilotConfig) GetTrustedZtunnelNamespace() string {
	if x != nil {
		return x.TrustedZtunnelNamespace
	}
	return ""
}

func (x *PilotConfig) GetIstiodRemote() *IstiodRemoteConfig {
	if x != nil {
		return x.IstiodRemote
	}
	return nil
}

func (x *PilotConfig) GetEnvVarFrom() []*structpb.Struct {
	if x != nil {
		return x.EnvVarFrom
	}
	return nil
}

type PilotTaintControllerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enable the untaint controller for new nodes. This aims to solve a race for CNI installation on
	// new nodes. For this to work, the newly added nodes need to have the istio CNI taint as they are
	// added to the cluster. This is usually done by configuring the cluster infra provider.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The namespace of the CNI daemonset, incase it's not the same as istiod.
	Namespace     string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PilotTaintControllerConfig) Reset() {
	*x = PilotTaintControllerConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PilotTaintControllerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotTaintControllerConfig) ProtoMessage() {}

func (x *PilotTaintControllerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotTaintControllerConfig.ProtoReflect.Descriptor instead.
func (*PilotTaintControllerConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{21}
}

func (x *PilotTaintControllerConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *PilotTaintControllerConfig) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// Controls legacy k8s ingress. Only one pilot profile should enable ingress support.
type PilotIngressConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Sets the type ingress service for Pilot.
	//
	// If empty, node-port is assumed.
	//
	// Allowed values: node-port, istio-ingressgateway, ingress
	IngressService        string                `protobuf:"bytes,1,opt,name=ingressService,proto3" json:"ingressService,omitempty"`
	IngressControllerMode IngressControllerMode `protobuf:"varint,2,opt,name=ingressControllerMode,proto3,enum=istio.operator.v1alpha1.IngressControllerMode" json:"ingressControllerMode,omitempty"`
	// If mode is STRICT, this value must be set on "kubernetes.io/ingress.class" annotation to activate.
	IngressClass  string `protobuf:"bytes,3,opt,name=ingressClass,proto3" json:"ingressClass,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PilotIngressConfig) Reset() {
	*x = PilotIngressConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PilotIngressConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotIngressConfig) ProtoMessage() {}

func (x *PilotIngressConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotIngressConfig.ProtoReflect.Descriptor instead.
func (*PilotIngressConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{22}
}

func (x *PilotIngressConfig) GetIngressService() string {
	if x != nil {
		return x.IngressService
	}
	return ""
}

func (x *PilotIngressConfig) GetIngressControllerMode() IngressControllerMode {
	if x != nil {
		return x.IngressControllerMode
	}
	return IngressControllerMode_UNSPECIFIED
}

func (x *PilotIngressConfig) GetIngressClass() string {
	if x != nil {
		return x.IngressClass
	}
	return ""
}

// Controls whether Istio policy is applied to Pilot.
type PilotPolicyConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether Istio policy is applied to Pilot.
	Enabled       *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PilotPolicyConfig) Reset() {
	*x = PilotPolicyConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PilotPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotPolicyConfig) ProtoMessage() {}

func (x *PilotPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotPolicyConfig.ProtoReflect.Descriptor instead.
func (*PilotPolicyConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{23}
}

func (x *PilotPolicyConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// Controls telemetry configuration
type TelemetryConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether telemetry is exported for Pilot.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Configuration for Telemetry v2.
	V2            *TelemetryV2Config `protobuf:"bytes,3,opt,name=v2,proto3" json:"v2,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TelemetryConfig) Reset() {
	*x = TelemetryConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TelemetryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryConfig) ProtoMessage() {}

func (x *TelemetryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryConfig.ProtoReflect.Descriptor instead.
func (*TelemetryConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{24}
}

func (x *TelemetryConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *TelemetryConfig) GetV2() *TelemetryV2Config {
	if x != nil {
		return x.V2
	}
	return nil
}

// Controls whether pilot will configure telemetry v2.
type TelemetryV2Config struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether pilot will configure telemetry v2.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Telemetry v2 settings for prometheus.
	Prometheus *TelemetryV2PrometheusConfig `protobuf:"bytes,2,opt,name=prometheus,proto3" json:"prometheus,omitempty"`
	// Telemetry v2 settings for stackdriver.
	Stackdriver   *TelemetryV2StackDriverConfig `protobuf:"bytes,3,opt,name=stackdriver,proto3" json:"stackdriver,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TelemetryV2Config) Reset() {
	*x = TelemetryV2Config{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TelemetryV2Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2Config) ProtoMessage() {}

func (x *TelemetryV2Config) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2Config.ProtoReflect.Descriptor instead.
func (*TelemetryV2Config) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{25}
}

func (x *TelemetryV2Config) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *TelemetryV2Config) GetPrometheus() *TelemetryV2PrometheusConfig {
	if x != nil {
		return x.Prometheus
	}
	return nil
}

func (x *TelemetryV2Config) GetStackdriver() *TelemetryV2StackDriverConfig {
	if x != nil {
		return x.Stackdriver
	}
	return nil
}

// Controls telemetry v2 prometheus settings.
type TelemetryV2PrometheusConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether stats envoyfilter would be enabled or not.
	Enabled       *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TelemetryV2PrometheusConfig) Reset() {
	*x = TelemetryV2PrometheusConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TelemetryV2PrometheusConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2PrometheusConfig) ProtoMessage() {}

func (x *TelemetryV2PrometheusConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2PrometheusConfig.ProtoReflect.Descriptor instead.
func (*TelemetryV2PrometheusConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{26}
}

func (x *TelemetryV2PrometheusConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// TelemetryV2StackDriverConfig controls telemetry v2 stackdriver settings.
type TelemetryV2StackDriverConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Enabled       *wrapperspb.BoolValue  `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TelemetryV2StackDriverConfig) Reset() {
	*x = TelemetryV2StackDriverConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TelemetryV2StackDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2StackDriverConfig) ProtoMessage() {}

func (x *TelemetryV2StackDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2StackDriverConfig.ProtoReflect.Descriptor instead.
func (*TelemetryV2StackDriverConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{27}
}

func (x *TelemetryV2StackDriverConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// Configuration for a port.
type PortsConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Port name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Port number.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// NodePort number.
	NodePort int32 `protobuf:"varint,3,opt,name=nodePort,proto3" json:"nodePort,omitempty"`
	// Target port number.
	TargetPort int32 `protobuf:"varint,4,opt,name=targetPort,proto3" json:"targetPort,omitempty"`
	// Protocol name.
	Protocol      string `protobuf:"bytes,5,opt,name=protocol,proto3" json:"protocol,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortsConfig) Reset() {
	*x = PortsConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortsConfig) ProtoMessage() {}

func (x *PortsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortsConfig.ProtoReflect.Descriptor instead.
func (*PortsConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{28}
}

func (x *PortsConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PortsConfig) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *PortsConfig) GetNodePort() int32 {
	if x != nil {
		return x.NodePort
	}
	return 0
}

func (x *PortsConfig) GetTargetPort() int32 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

func (x *PortsConfig) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

// Configuration for Proxy.
type ProxyConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls the 'policy' in the sidecar injector.
	AutoInject string `protobuf:"bytes,4,opt,name=autoInject,proto3" json:"autoInject,omitempty"`
	// Domain for the cluster, default: "cluster.local".
	//
	// K8s allows this to be customized, see https://kubernetes.io/docs/tasks/administer-cluster/dns-custom-nameservers/
	ClusterDomain string `protobuf:"bytes,5,opt,name=clusterDomain,proto3" json:"clusterDomain,omitempty"`
	// Per Component log level for proxy, applies to gateways and sidecars.
	//
	// If a component level is not set, then the global "logLevel" will be used. If left empty, "misc:error" is used.
	ComponentLogLevel string `protobuf:"bytes,6,opt,name=componentLogLevel,proto3" json:"componentLogLevel,omitempty"`
	// Enables core dumps for newly injected sidecars.
	//
	// If set, newly injected sidecars will have core dumps enabled.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	EnableCoreDump *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=enableCoreDump,proto3" json:"enableCoreDump,omitempty"`
	// Specifies the Istio ingress ports not to capture.
	ExcludeInboundPorts string `protobuf:"bytes,12,opt,name=excludeInboundPorts,proto3" json:"excludeInboundPorts,omitempty"`
	// Lists the excluded IP ranges of Istio egress traffic that the sidecar captures.
	ExcludeIPRanges string `protobuf:"bytes,13,opt,name=excludeIPRanges,proto3" json:"excludeIPRanges,omitempty"`
	// Image name or path for the proxy, default: "proxyv2".
	//
	// If registry or tag are not specified, global.hub and global.tag are used.
	//
	// Examples: my-proxy (uses global.hub/tag), docker.io/myrepo/my-proxy:v1.0.0
	Image string `protobuf:"bytes,14,opt,name=image,proto3" json:"image,omitempty"`
	// Lists the IP ranges of Istio egress traffic that the sidecar captures.
	//
	// Example: "172.30.0.0/16,172.20.0.0/16"
	// This would only capture egress traffic on those two IP Ranges, all other outbound traffic would # be allowed by the sidecar."
	IncludeIPRanges string `protobuf:"bytes,16,opt,name=includeIPRanges,proto3" json:"includeIPRanges,omitempty"`
	// Log level for proxy, applies to gateways and sidecars. If left empty, "warning" is used. Expected values are: trace\|debug\|info\|warning\|error\|critical\|off
	LogLevel string `protobuf:"bytes,18,opt,name=logLevel,proto3" json:"logLevel,omitempty"`
	// Path to the file to which the proxy will write outlier detection logs.
	//
	// Example: "/dev/stdout"
	// This would write the logs to standard output.
	OutlierLogPath string `protobuf:"bytes,42,opt,name=outlierLogPath,proto3" json:"outlierLogPath,omitempty"`
	// Enables privileged securityContext for the istio-proxy container.
	//
	// See https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	Privileged *wrapperspb.BoolValue `protobuf:"bytes,19,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Sets the initial delay for readiness probes in seconds.
	ReadinessInitialDelaySeconds uint32 `protobuf:"varint,20,opt,name=readinessInitialDelaySeconds,proto3" json:"readinessInitialDelaySeconds,omitempty"`
	// Sets the interval between readiness probes in seconds.
	ReadinessPeriodSeconds uint32 `protobuf:"varint,21,opt,name=readinessPeriodSeconds,proto3" json:"readinessPeriodSeconds,omitempty"`
	// Sets the number of successive failed probes before indicating readiness failure.
	ReadinessFailureThreshold uint32 `protobuf:"varint,22,opt,name=readinessFailureThreshold,proto3" json:"readinessFailureThreshold,omitempty"`
	// Configures the startup probe for the istio-proxy container.
	StartupProbe *StartupProbe `protobuf:"bytes,41,opt,name=startupProbe,proto3" json:"startupProbe,omitempty"`
	// Default port used for the Pilot agent's health checks.
	StatusPort uint32 `protobuf:"varint,23,opt,name=statusPort,proto3" json:"statusPort,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Resources *Resources `protobuf:"bytes,24,opt,name=resources,proto3" json:"resources,omitempty"`
	// Specify which tracer to use. One of: zipkin, lightstep, datadog, stackdriver.
	// If using stackdriver tracer outside GCP, set env GOOGLE_APPLICATION_CREDENTIALS to the GCP credential file.
	Tracer Tracer `protobuf:"varint,25,opt,name=tracer,proto3,enum=istio.operator.v1alpha1.Tracer" json:"tracer,omitempty"`
	// A comma separated list of outbound ports to be excluded from redirection to Envoy.
	ExcludeOutboundPorts string `protobuf:"bytes,28,opt,name=excludeOutboundPorts,proto3" json:"excludeOutboundPorts,omitempty"`
	// The k8s lifecycle hooks definition (pod.spec.containers.lifecycle) for the proxy container.
	// More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	Lifecycle *v1.Lifecycle `protobuf:"bytes,36,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// Controls if sidecar is injected at the front of the container list and blocks the start of the other containers until the proxy is ready
	//
	// Deprecated: replaced by ProxyConfig setting which allows per-pod configuration of this behavior.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	HoldApplicationUntilProxyStarts *wrapperspb.BoolValue `protobuf:"bytes,37,opt,name=holdApplicationUntilProxyStarts,proto3" json:"holdApplicationUntilProxyStarts,omitempty"`
	// A comma separated list of inbound ports for which traffic is to be redirected to Envoy.
	// The wildcard character '*' can be used to configure redirection for all ports.
	IncludeInboundPorts string `protobuf:"bytes,38,opt,name=includeInboundPorts,proto3" json:"includeInboundPorts,omitempty"`
	// A comma separated list of outbound ports for which traffic is to be redirected to Envoy, regardless of the destination IP.
	IncludeOutboundPorts string `protobuf:"bytes,39,opt,name=includeOutboundPorts,proto3" json:"includeOutboundPorts,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ProxyConfig) Reset() {
	*x = ProxyConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig) ProtoMessage() {}

func (x *ProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig.ProtoReflect.Descriptor instead.
func (*ProxyConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{29}
}

func (x *ProxyConfig) GetAutoInject() string {
	if x != nil {
		return x.AutoInject
	}
	return ""
}

func (x *ProxyConfig) GetClusterDomain() string {
	if x != nil {
		return x.ClusterDomain
	}
	return ""
}

func (x *ProxyConfig) GetComponentLogLevel() string {
	if x != nil {
		return x.ComponentLogLevel
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *ProxyConfig) GetEnableCoreDump() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableCoreDump
	}
	return nil
}

func (x *ProxyConfig) GetExcludeInboundPorts() string {
	if x != nil {
		return x.ExcludeInboundPorts
	}
	return ""
}

func (x *ProxyConfig) GetExcludeIPRanges() string {
	if x != nil {
		return x.ExcludeIPRanges
	}
	return ""
}

func (x *ProxyConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *ProxyConfig) GetIncludeIPRanges() string {
	if x != nil {
		return x.IncludeIPRanges
	}
	return ""
}

func (x *ProxyConfig) GetLogLevel() string {
	if x != nil {
		return x.LogLevel
	}
	return ""
}

func (x *ProxyConfig) GetOutlierLogPath() string {
	if x != nil {
		return x.OutlierLogPath
	}
	return ""
}

func (x *ProxyConfig) GetPrivileged() *wrapperspb.BoolValue {
	if x != nil {
		return x.Privileged
	}
	return nil
}

func (x *ProxyConfig) GetReadinessInitialDelaySeconds() uint32 {
	if x != nil {
		return x.ReadinessInitialDelaySeconds
	}
	return 0
}

func (x *ProxyConfig) GetReadinessPeriodSeconds() uint32 {
	if x != nil {
		return x.ReadinessPeriodSeconds
	}
	return 0
}

func (x *ProxyConfig) GetReadinessFailureThreshold() uint32 {
	if x != nil {
		return x.ReadinessFailureThreshold
	}
	return 0
}

func (x *ProxyConfig) GetStartupProbe() *StartupProbe {
	if x != nil {
		return x.StartupProbe
	}
	return nil
}

func (x *ProxyConfig) GetStatusPort() uint32 {
	if x != nil {
		return x.StatusPort
	}
	return 0
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *ProxyConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ProxyConfig) GetTracer() Tracer {
	if x != nil {
		return x.Tracer
	}
	return Tracer_zipkin
}

func (x *ProxyConfig) GetExcludeOutboundPorts() string {
	if x != nil {
		return x.ExcludeOutboundPorts
	}
	return ""
}

func (x *ProxyConfig) GetLifecycle() *v1.Lifecycle {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *ProxyConfig) GetHoldApplicationUntilProxyStarts() *wrapperspb.BoolValue {
	if x != nil {
		return x.HoldApplicationUntilProxyStarts
	}
	return nil
}

func (x *ProxyConfig) GetIncludeInboundPorts() string {
	if x != nil {
		return x.IncludeInboundPorts
	}
	return ""
}

func (x *ProxyConfig) GetIncludeOutboundPorts() string {
	if x != nil {
		return x.IncludeOutboundPorts
	}
	return ""
}

type StartupProbe struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enables or disables a startup probe.
	// For optimal startup times, changing this should be tied to the readiness probe values.
	//
	// If the probe is enabled, it is recommended to have delay=0s,period=15s,failureThreshold=4.
	// This ensures the pod is marked ready immediately after the startup probe passes (which has a 1s poll interval),
	// and doesn't spam the readiness endpoint too much
	//
	// If the probe is disabled, it is recommended to have delay=1s,period=2s,failureThreshold=30.
	// This ensures the startup is reasonable fast (polling every 2s). 1s delay is used since the startup is not often ready instantly.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Minimum consecutive failures for the probe to be considered failed after having succeeded.
	FailureThreshold uint32 `protobuf:"varint,2,opt,name=failureThreshold,proto3" json:"failureThreshold,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *StartupProbe) Reset() {
	*x = StartupProbe{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartupProbe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartupProbe) ProtoMessage() {}

func (x *StartupProbe) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartupProbe.ProtoReflect.Descriptor instead.
func (*StartupProbe) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{30}
}

func (x *StartupProbe) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *StartupProbe) GetFailureThreshold() uint32 {
	if x != nil {
		return x.FailureThreshold
	}
	return 0
}

// Configuration for proxy_init container which sets the pods' networking to intercept the inbound/outbound traffic.
type ProxyInitConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the image for the proxy_init container.
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Resources     *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyInitConfig) Reset() {
	*x = ProxyInitConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyInitConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyInitConfig) ProtoMessage() {}

func (x *ProxyInitConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyInitConfig.ProtoReflect.Descriptor instead.
func (*ProxyInitConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{31}
}

func (x *ProxyInitConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *ProxyInitConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

// Configuration for K8s resource requests.
type ResourcesRequestsConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// CPU requests.
	Cpu string `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory requests.
	Memory        string `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourcesRequestsConfig) Reset() {
	*x = ResourcesRequestsConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourcesRequestsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcesRequestsConfig) ProtoMessage() {}

func (x *ResourcesRequestsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcesRequestsConfig.ProtoReflect.Descriptor instead.
func (*ResourcesRequestsConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{32}
}

func (x *ResourcesRequestsConfig) GetCpu() string {
	if x != nil {
		return x.Cpu
	}
	return ""
}

func (x *ResourcesRequestsConfig) GetMemory() string {
	if x != nil {
		return x.Memory
	}
	return ""
}

// Configuration for the SecretDiscoveryService instead of using K8S secrets to mount the certificates.
type SDSConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	Token         *structpb.Struct `protobuf:"bytes,5,opt,name=token,proto3" json:"token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SDSConfig) Reset() {
	*x = SDSConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SDSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SDSConfig) ProtoMessage() {}

func (x *SDSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SDSConfig.ProtoReflect.Descriptor instead.
func (*SDSConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{33}
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *SDSConfig) GetToken() *structpb.Struct {
	if x != nil {
		return x.Token
	}
	return nil
}

// Configuration for secret volume mounts.
//
// See https://kubernetes.io/docs/concepts/configuration/secret/#using-secrets.
type SecretVolume struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MountPath     string                 `protobuf:"bytes,1,opt,name=mountPath,proto3" json:"mountPath,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	SecretName    string                 `protobuf:"bytes,3,opt,name=secretName,proto3" json:"secretName,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecretVolume) Reset() {
	*x = SecretVolume{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecretVolume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVolume) ProtoMessage() {}

func (x *SecretVolume) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVolume.ProtoReflect.Descriptor instead.
func (*SecretVolume) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{34}
}

func (x *SecretVolume) GetMountPath() string {
	if x != nil {
		return x.MountPath
	}
	return ""
}

func (x *SecretVolume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecretVolume) GetSecretName() string {
	if x != nil {
		return x.SecretName
	}
	return ""
}

// SidecarInjectorConfig is described in istio.io documentation.
type SidecarInjectorConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enables sidecar auto-injection in namespaces by default.
	EnableNamespacesByDefault *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enableNamespacesByDefault,proto3" json:"enableNamespacesByDefault,omitempty"`
	// Setting this to `IfNeeded` will result in the sidecar injector being run again if additional mutations occur. Default: Never
	ReinvocationPolicy string `protobuf:"bytes,3,opt,name=reinvocationPolicy,proto3" json:"reinvocationPolicy,omitempty"`
	// Instructs Istio to not inject the sidecar on those pods, based on labels that are present in those pods.
	//
	// Annotations in the pods have higher precedence than the label selectors.
	// Order of evaluation: Pod Annotations → NeverInjectSelector → AlwaysInjectSelector → Default Policy.
	// See https://istio.io/docs/setup/kubernetes/additional-setup/sidecar-injection/#more-control-adding-exceptions
	NeverInjectSelector []*v11.LabelSelector `protobuf:"bytes,11,rep,name=neverInjectSelector,proto3" json:"neverInjectSelector,omitempty"`
	// See NeverInjectSelector.
	AlwaysInjectSelector []*v11.LabelSelector `protobuf:"bytes,12,rep,name=alwaysInjectSelector,proto3" json:"alwaysInjectSelector,omitempty"`
	// If true, webhook or istioctl injector will rewrite PodSpec for liveness health check to redirect request to sidecar. This makes liveness check work even when mTLS is enabled.
	RewriteAppHTTPProbe *wrapperspb.BoolValue `protobuf:"bytes,16,opt,name=rewriteAppHTTPProbe,proto3" json:"rewriteAppHTTPProbe,omitempty"`
	// injectedAnnotations are additional annotations that will be added to the pod spec after injection
	// This is primarily to support PSP annotations.
	InjectedAnnotations *structpb.Struct `protobuf:"bytes,19,opt,name=injectedAnnotations,proto3" json:"injectedAnnotations,omitempty"`
	// Configure the injection url for sidecar injector webhook
	InjectionURL string `protobuf:"bytes,22,opt,name=injectionURL,proto3" json:"injectionURL,omitempty"`
	// Templates defines a set of custom injection templates that can be used. For example, defining:
	//
	// templates:
	//
	//	hello: |
	//	  metadata:
	//	    labels:
	//	      hello: world
	//
	// Then starting a pod with the `inject.istio.io/templates: hello` annotation, will result in the pod
	// being injected with the hello=world labels.
	// This is intended for advanced configuration only; most users should use the built in template
	Templates *structpb.Struct `protobuf:"bytes,23,opt,name=templates,proto3" json:"templates,omitempty"`
	// defaultTemplates: ["sidecar", "hello"]
	DefaultTemplates []string `protobuf:"bytes,24,rep,name=defaultTemplates,proto3" json:"defaultTemplates,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *SidecarInjectorConfig) Reset() {
	*x = SidecarInjectorConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SidecarInjectorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SidecarInjectorConfig) ProtoMessage() {}

func (x *SidecarInjectorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SidecarInjectorConfig.ProtoReflect.Descriptor instead.
func (*SidecarInjectorConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{35}
}

func (x *SidecarInjectorConfig) GetEnableNamespacesByDefault() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableNamespacesByDefault
	}
	return nil
}

func (x *SidecarInjectorConfig) GetReinvocationPolicy() string {
	if x != nil {
		return x.ReinvocationPolicy
	}
	return ""
}

func (x *SidecarInjectorConfig) GetNeverInjectSelector() []*v11.LabelSelector {
	if x != nil {
		return x.NeverInjectSelector
	}
	return nil
}

func (x *SidecarInjectorConfig) GetAlwaysInjectSelector() []*v11.LabelSelector {
	if x != nil {
		return x.AlwaysInjectSelector
	}
	return nil
}

func (x *SidecarInjectorConfig) GetRewriteAppHTTPProbe() *wrapperspb.BoolValue {
	if x != nil {
		return x.RewriteAppHTTPProbe
	}
	return nil
}

func (x *SidecarInjectorConfig) GetInjectedAnnotations() *structpb.Struct {
	if x != nil {
		return x.InjectedAnnotations
	}
	return nil
}

func (x *SidecarInjectorConfig) GetInjectionURL() string {
	if x != nil {
		return x.InjectionURL
	}
	return ""
}

func (x *SidecarInjectorConfig) GetTemplates() *structpb.Struct {
	if x != nil {
		return x.Templates
	}
	return nil
}

func (x *SidecarInjectorConfig) GetDefaultTemplates() []string {
	if x != nil {
		return x.DefaultTemplates
	}
	return nil
}

// Configuration for each of the supported tracers.
type TracerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for the datadog tracing service.
	Datadog *TracerDatadogConfig `protobuf:"bytes,1,opt,name=datadog,proto3" json:"datadog,omitempty"`
	// Configuration for the lightstep tracing service.
	Lightstep *TracerLightStepConfig `protobuf:"bytes,2,opt,name=lightstep,proto3" json:"lightstep,omitempty"`
	// Configuration for the zipkin tracing service.
	Zipkin *TracerZipkinConfig `protobuf:"bytes,3,opt,name=zipkin,proto3" json:"zipkin,omitempty"`
	// Configuration for the stackdriver tracing service.
	Stackdriver   *TracerStackdriverConfig `protobuf:"bytes,4,opt,name=stackdriver,proto3" json:"stackdriver,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TracerConfig) Reset() {
	*x = TracerConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TracerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerConfig) ProtoMessage() {}

func (x *TracerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerConfig.ProtoReflect.Descriptor instead.
func (*TracerConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{36}
}

func (x *TracerConfig) GetDatadog() *TracerDatadogConfig {
	if x != nil {
		return x.Datadog
	}
	return nil
}

func (x *TracerConfig) GetLightstep() *TracerLightStepConfig {
	if x != nil {
		return x.Lightstep
	}
	return nil
}

func (x *TracerConfig) GetZipkin() *TracerZipkinConfig {
	if x != nil {
		return x.Zipkin
	}
	return nil
}

func (x *TracerConfig) GetStackdriver() *TracerStackdriverConfig {
	if x != nil {
		return x.Stackdriver
	}
	return nil
}

// Configuration for the datadog tracing service.
type TracerDatadogConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address in host:port format for reporting trace data to the Datadog agent.
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TracerDatadogConfig) Reset() {
	*x = TracerDatadogConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TracerDatadogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerDatadogConfig) ProtoMessage() {}

func (x *TracerDatadogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerDatadogConfig.ProtoReflect.Descriptor instead.
func (*TracerDatadogConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{37}
}

func (x *TracerDatadogConfig) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// Configuration for the lightstep tracing service.
type TracerLightStepConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Sets the lightstep satellite pool address in host:port format for reporting trace data.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Sets the lightstep access token.
	AccessToken   string `protobuf:"bytes,2,opt,name=accessToken,proto3" json:"accessToken,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TracerLightStepConfig) Reset() {
	*x = TracerLightStepConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TracerLightStepConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerLightStepConfig) ProtoMessage() {}

func (x *TracerLightStepConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerLightStepConfig.ProtoReflect.Descriptor instead.
func (*TracerLightStepConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{38}
}

func (x *TracerLightStepConfig) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *TracerLightStepConfig) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

// Configuration for the zipkin tracing service.
type TracerZipkinConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address of zipkin instance in host:port format for reporting trace data.
	//
	// Example: <zipkin-collector-service>.<zipkin-collector-namespace>:941
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TracerZipkinConfig) Reset() {
	*x = TracerZipkinConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TracerZipkinConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerZipkinConfig) ProtoMessage() {}

func (x *TracerZipkinConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerZipkinConfig.ProtoReflect.Descriptor instead.
func (*TracerZipkinConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{39}
}

func (x *TracerZipkinConfig) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// Configuration for the stackdriver tracing service.
type TracerStackdriverConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// enables trace output to stdout.
	Debug *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// The global default max number of attributes per span.
	MaxNumberOfAttributes uint32 `protobuf:"varint,2,opt,name=maxNumberOfAttributes,proto3" json:"maxNumberOfAttributes,omitempty"`
	// The global default max number of annotation events per span.
	MaxNumberOfAnnotations uint32 `protobuf:"varint,3,opt,name=maxNumberOfAnnotations,proto3" json:"maxNumberOfAnnotations,omitempty"`
	// The global default max number of message events per span.
	MaxNumberOfMessageEvents uint32 `protobuf:"varint,4,opt,name=maxNumberOfMessageEvents,proto3" json:"maxNumberOfMessageEvents,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *TracerStackdriverConfig) Reset() {
	*x = TracerStackdriverConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TracerStackdriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerStackdriverConfig) ProtoMessage() {}

func (x *TracerStackdriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerStackdriverConfig.ProtoReflect.Descriptor instead.
func (*TracerStackdriverConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{40}
}

func (x *TracerStackdriverConfig) GetDebug() *wrapperspb.BoolValue {
	if x != nil {
		return x.Debug
	}
	return nil
}

func (x *TracerStackdriverConfig) GetMaxNumberOfAttributes() uint32 {
	if x != nil {
		return x.MaxNumberOfAttributes
	}
	return 0
}

func (x *TracerStackdriverConfig) GetMaxNumberOfAnnotations() uint32 {
	if x != nil {
		return x.MaxNumberOfAnnotations
	}
	return 0
}

func (x *TracerStackdriverConfig) GetMaxNumberOfMessageEvents() uint32 {
	if x != nil {
		return x.MaxNumberOfMessageEvents
	}
	return 0
}

type BaseConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// For Helm2 use, adds the CRDs to templates.
	EnableCRDTemplates *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enableCRDTemplates,proto3" json:"enableCRDTemplates,omitempty"`
	// CRDs to exclude. Requires `enableCRDTemplates`
	ExcludedCRDs []string `protobuf:"bytes,6,rep,name=excludedCRDs,proto3" json:"excludedCRDs,omitempty"`
	// URL to use for validating webhook.
	ValidationURL string `protobuf:"bytes,2,opt,name=validationURL,proto3" json:"validationURL,omitempty"`
	// For istioctl usage to disable istio config crds in base
	EnableIstioConfigCRDs *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=enableIstioConfigCRDs,proto3" json:"enableIstioConfigCRDs,omitempty"`
	ValidateGateway       *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=validateGateway,proto3" json:"validateGateway,omitempty"`
	// validation webhook CA bundle
	ValidationCABundle string `protobuf:"bytes,5,opt,name=validationCABundle,proto3" json:"validationCABundle,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *BaseConfig) Reset() {
	*x = BaseConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BaseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BaseConfig) ProtoMessage() {}

func (x *BaseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BaseConfig.ProtoReflect.Descriptor instead.
func (*BaseConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{41}
}

func (x *BaseConfig) GetEnableCRDTemplates() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableCRDTemplates
	}
	return nil
}

func (x *BaseConfig) GetExcludedCRDs() []string {
	if x != nil {
		return x.ExcludedCRDs
	}
	return nil
}

func (x *BaseConfig) GetValidationURL() string {
	if x != nil {
		return x.ValidationURL
	}
	return ""
}

func (x *BaseConfig) GetEnableIstioConfigCRDs() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableIstioConfigCRDs
	}
	return nil
}

func (x *BaseConfig) GetValidateGateway() *wrapperspb.BoolValue {
	if x != nil {
		return x.ValidateGateway
	}
	return nil
}

func (x *BaseConfig) GetValidationCABundle() string {
	if x != nil {
		return x.ValidationCABundle
	}
	return ""
}

type IstiodRemoteConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// URL to use for sidecar injector webhook.
	InjectionURL string `protobuf:"bytes,1,opt,name=injectionURL,proto3" json:"injectionURL,omitempty"`
	// Path to use for the sidecar injector webhook service.
	InjectionPath string `protobuf:"bytes,2,opt,name=injectionPath,proto3" json:"injectionPath,omitempty"`
	// injector ca bundle
	InjectionCABundle string `protobuf:"bytes,3,opt,name=injectionCABundle,proto3" json:"injectionCABundle,omitempty"`
	// Indicates if this cluster/install should consume a "remote" istiod instance,
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// If `true`, indicates that this cluster/install should consume a "local istiod" installation,
	// local istiod inject sidecars
	EnabledLocalInjectorIstiod *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=enabledLocalInjectorIstiod,proto3" json:"enabledLocalInjectorIstiod,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *IstiodRemoteConfig) Reset() {
	*x = IstiodRemoteConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IstiodRemoteConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstiodRemoteConfig) ProtoMessage() {}

func (x *IstiodRemoteConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstiodRemoteConfig.ProtoReflect.Descriptor instead.
func (*IstiodRemoteConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{42}
}

func (x *IstiodRemoteConfig) GetInjectionURL() string {
	if x != nil {
		return x.InjectionURL
	}
	return ""
}

func (x *IstiodRemoteConfig) GetInjectionPath() string {
	if x != nil {
		return x.InjectionPath
	}
	return ""
}

func (x *IstiodRemoteConfig) GetInjectionCABundle() string {
	if x != nil {
		return x.InjectionCABundle
	}
	return ""
}

func (x *IstiodRemoteConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *IstiodRemoteConfig) GetEnabledLocalInjectorIstiod() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnabledLocalInjectorIstiod
	}
	return nil
}

type Values struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for the Istio CNI plugin.
	Cni *CNIConfig `protobuf:"bytes,2,opt,name=cni,proto3" json:"cni,omitempty"`
	// Configuration for ingress and egress gateways.
	Gateways *GatewaysConfig `protobuf:"bytes,5,opt,name=gateways,proto3" json:"gateways,omitempty"`
	// Global configuration for Istio components.
	Global *GlobalConfig `protobuf:"bytes,6,opt,name=global,proto3" json:"global,omitempty"`
	// Configuration for the Pilot component.
	Pilot *PilotConfig `protobuf:"bytes,10,opt,name=pilot,proto3" json:"pilot,omitempty"`
	// Configuration for the ZTunnel component.
	Ztunnel *structpb.Value `protobuf:"bytes,41,opt,name=ztunnel,proto3" json:"ztunnel,omitempty"`
	// Controls whether telemetry is exported for Pilot.
	Telemetry *TelemetryConfig `protobuf:"bytes,23,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	// Configuration for the sidecar injector webhook.
	SidecarInjectorWebhook *SidecarInjectorConfig `protobuf:"bytes,13,opt,name=sidecarInjectorWebhook,proto3" json:"sidecarInjectorWebhook,omitempty"`
	// Configuration for the Istio CNI plugin.
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	IstioCni *CNIUsageConfig `protobuf:"bytes,19,opt,name=istio_cni,json=istioCni,proto3" json:"istio_cni,omitempty"`
	// Identifies the revision this installation is associated with.
	Revision string `protobuf:"bytes,21,opt,name=revision,proto3" json:"revision,omitempty"`
	// Used internally to identify the owner of each resource.
	OwnerName string `protobuf:"bytes,22,opt,name=ownerName,proto3" json:"ownerName,omitempty"`
	// Defines runtime configuration of components, including Istiod and istio-agent behavior.
	// See https://istio.io/docs/reference/config/istio.mesh.v1alpha1/ for all available options.
	// TODO can this import the real mesh config API?
	MeshConfig *structpb.Value `protobuf:"bytes,36,opt,name=meshConfig,proto3" json:"meshConfig,omitempty"`
	// Configuration for the base component.
	Base *BaseConfig `protobuf:"bytes,37,opt,name=base,proto3" json:"base,omitempty"`
	// Configuration for istiod-remote.
	// DEPRECATED - istiod-remote chart is removed and replaced with
	// `istio-discovery --set values.istiodRemote.enabled=true`
	//
	// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
	IstiodRemote *IstiodRemoteConfig `protobuf:"bytes,38,opt,name=istiodRemote,proto3" json:"istiodRemote,omitempty"`
	// Specifies the aliases for the Istio control plane revision. A MutatingWebhookConfiguration
	// is created for each alias.
	RevisionTags []string `protobuf:"bytes,39,rep,name=revisionTags,proto3" json:"revisionTags,omitempty"`
	// The name of the default revision in the cluster.
	DefaultRevision string `protobuf:"bytes,40,opt,name=defaultRevision,proto3" json:"defaultRevision,omitempty"`
	// Specifies which installation configuration profile to apply.
	Profile string `protobuf:"bytes,42,opt,name=profile,proto3" json:"profile,omitempty"`
	// Specifies the compatibility version to use. When this is set, the control plane will
	// be configured with the same defaults as the specified version.
	CompatibilityVersion string `protobuf:"bytes,43,opt,name=compatibilityVersion,proto3" json:"compatibilityVersion,omitempty"`
	// Specifies experimental helm fields that could be removed or changed in the future
	Experimental *ExperimentalConfig `protobuf:"bytes,44,opt,name=experimental,proto3" json:"experimental,omitempty"`
	// Configuration for Gateway Classes
	GatewayClasses *structpb.Value `protobuf:"bytes,45,opt,name=gatewayClasses,proto3" json:"gatewayClasses,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Values) Reset() {
	*x = Values{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Values) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Values) ProtoMessage() {}

func (x *Values) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Values.ProtoReflect.Descriptor instead.
func (*Values) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{43}
}

func (x *Values) GetCni() *CNIConfig {
	if x != nil {
		return x.Cni
	}
	return nil
}

func (x *Values) GetGateways() *GatewaysConfig {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *Values) GetGlobal() *GlobalConfig {
	if x != nil {
		return x.Global
	}
	return nil
}

func (x *Values) GetPilot() *PilotConfig {
	if x != nil {
		return x.Pilot
	}
	return nil
}

func (x *Values) GetZtunnel() *structpb.Value {
	if x != nil {
		return x.Ztunnel
	}
	return nil
}

func (x *Values) GetTelemetry() *TelemetryConfig {
	if x != nil {
		return x.Telemetry
	}
	return nil
}

func (x *Values) GetSidecarInjectorWebhook() *SidecarInjectorConfig {
	if x != nil {
		return x.SidecarInjectorWebhook
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *Values) GetIstioCni() *CNIUsageConfig {
	if x != nil {
		return x.IstioCni
	}
	return nil
}

func (x *Values) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *Values) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *Values) GetMeshConfig() *structpb.Value {
	if x != nil {
		return x.MeshConfig
	}
	return nil
}

func (x *Values) GetBase() *BaseConfig {
	if x != nil {
		return x.Base
	}
	return nil
}

// Deprecated: Marked as deprecated in pkg/apis/values_types.proto.
func (x *Values) GetIstiodRemote() *IstiodRemoteConfig {
	if x != nil {
		return x.IstiodRemote
	}
	return nil
}

func (x *Values) GetRevisionTags() []string {
	if x != nil {
		return x.RevisionTags
	}
	return nil
}

func (x *Values) GetDefaultRevision() string {
	if x != nil {
		return x.DefaultRevision
	}
	return ""
}

func (x *Values) GetProfile() string {
	if x != nil {
		return x.Profile
	}
	return ""
}

func (x *Values) GetCompatibilityVersion() string {
	if x != nil {
		return x.CompatibilityVersion
	}
	return ""
}

func (x *Values) GetExperimental() *ExperimentalConfig {
	if x != nil {
		return x.Experimental
	}
	return nil
}

func (x *Values) GetGatewayClasses() *structpb.Value {
	if x != nil {
		return x.GatewayClasses
	}
	return nil
}

// ExperimentalConfig is a placeholder for experimental installation features.
type ExperimentalConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls whether the experimental feature is enabled.
	StableValidationPolicy *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=stableValidationPolicy,proto3" json:"stableValidationPolicy,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ExperimentalConfig) Reset() {
	*x = ExperimentalConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExperimentalConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExperimentalConfig) ProtoMessage() {}

func (x *ExperimentalConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExperimentalConfig.ProtoReflect.Descriptor instead.
func (*ExperimentalConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{44}
}

func (x *ExperimentalConfig) GetStableValidationPolicy() *wrapperspb.BoolValue {
	if x != nil {
		return x.StableValidationPolicy
	}
	return nil
}

// IntOrString is a type that can hold an int32 or a string.  When used in
// JSON or YAML marshalling and unmarshalling, it produces or consumes the
// inner type.  This allows you to have, for example, a JSON field that can
// accept a name or number.
// TODO: Rename to Int32OrString
//
// +protobuf=true
// +protobuf.options.(gogoproto.goproto_stringer)=false
// +k8s:openapi-gen=true
type IntOrString struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	Type          int64                   `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	IntVal        *wrapperspb.Int32Value  `protobuf:"bytes,2,opt,name=intVal,proto3" json:"intVal,omitempty"`
	StrVal        *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=strVal,proto3" json:"strVal,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IntOrString) Reset() {
	*x = IntOrString{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntOrString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntOrString) ProtoMessage() {}

func (x *IntOrString) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntOrString.ProtoReflect.Descriptor instead.
func (*IntOrString) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{45}
}

func (x *IntOrString) GetType() int64 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *IntOrString) GetIntVal() *wrapperspb.Int32Value {
	if x != nil {
		return x.IntVal
	}
	return nil
}

func (x *IntOrString) GetStrVal() *wrapperspb.StringValue {
	if x != nil {
		return x.StrVal
	}
	return nil
}

// Configuration for Waypoint proxies.
type WaypointConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// K8s resource settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// K8s affinity settings for waypoint pods.
	//
	// See https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity
	Affinity *v1.Affinity `protobuf:"bytes,2,opt,name=affinity,proto3" json:"affinity,omitempty"`
	// K8s topology spread constraints settings.
	//
	// See https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/
	TopologySpreadConstraints []*v1.TopologySpreadConstraint `protobuf:"bytes,3,rep,name=topologySpreadConstraints,proto3" json:"topologySpreadConstraints,omitempty"`
	// K8s node labels settings.
	//
	// See https://kubernetes.io/docs/user-guide/node-selection/
	NodeSelector *v1.NodeSelector `protobuf:"bytes,4,opt,name=nodeSelector,proto3" json:"nodeSelector,omitempty"`
	// K8s tolerations settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Toleration    []*v1.Toleration `protobuf:"bytes,5,rep,name=toleration,proto3" json:"toleration,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WaypointConfig) Reset() {
	*x = WaypointConfig{}
	mi := &file_pkg_apis_values_types_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WaypointConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WaypointConfig) ProtoMessage() {}

func (x *WaypointConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_values_types_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WaypointConfig.ProtoReflect.Descriptor instead.
func (*WaypointConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_values_types_proto_rawDescGZIP(), []int{46}
}

func (x *WaypointConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *WaypointConfig) GetAffinity() *v1.Affinity {
	if x != nil {
		return x.Affinity
	}
	return nil
}

func (x *WaypointConfig) GetTopologySpreadConstraints() []*v1.TopologySpreadConstraint {
	if x != nil {
		return x.TopologySpreadConstraints
	}
	return nil
}

func (x *WaypointConfig) GetNodeSelector() *v1.NodeSelector {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

func (x *WaypointConfig) GetToleration() []*v1.Toleration {
	if x != nil {
		return x.Toleration
	}
	return nil
}

var File_pkg_apis_values_types_proto protoreflect.FileDescriptor

const file_pkg_apis_values_types_proto_rawDesc = "" +
	"\n" +
	"\x1bpkg/apis/values_types.proto\x12\x17istio.operator.v1alpha1\x1a\x19google/protobuf/any.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1cgoogle/protobuf/struct.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\"k8s.io/api/core/v1/generated.proto\x1a4k8s.io/apimachinery/pkg/apis/meta/v1/generated.proto\"h\n" +
	"\n" +
	"ArchConfig\x12\x14\n" +
	"\x05amd64\x18\x01 \x01(\rR\x05amd64\x12\x18\n" +
	"\appc64le\x18\x02 \x01(\rR\appc64le\x12\x14\n" +
	"\x05s390x\x18\x03 \x01(\rR\x05s390x\x12\x14\n" +
	"\x05arm64\x18\x04 \x01(\rR\x05arm64\"\xa6\v\n" +
	"\tCNIConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12\x10\n" +
	"\x03hub\x18\x02 \x01(\tR\x03hub\x12(\n" +
	"\x03tag\x18\x03 \x01(\v2\x16.google.protobuf.ValueR\x03tag\x12\x18\n" +
	"\avariant\x18\x1d \x01(\tR\avariant\x12\x14\n" +
	"\x05image\x18\x04 \x01(\tR\x05image\x12\x1e\n" +
	"\n" +
	"pullPolicy\x18\x05 \x01(\tR\n" +
	"pullPolicy\x12\x1c\n" +
	"\tcniBinDir\x18\x06 \x01(\tR\tcniBinDir\x12\x1e\n" +
	"\n" +
	"cniConfDir\x18\a \x01(\tR\n" +
	"cniConfDir\x12(\n" +
	"\x0fcniConfFileName\x18\b \x01(\tR\x0fcniConfFileName\x12 \n" +
	"\vcniNetnsDir\x18\x1f \x01(\tR\vcniNetnsDir\x12,\n" +
	"\x11excludeNamespaces\x18\t \x03(\tR\x11excludeNamespaces\x128\n" +
	"\baffinity\x18\x14 \x01(\v2\x1c.k8s.io.api.core.v1.AffinityR\baffinity\x12)\n" +
	"\x03env\x18  \x01(\v2\x17.google.protobuf.StructR\x03env\x12C\n" +
	"\x0epodAnnotations\x18\n" +
	" \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\x0epodAnnotations\x12(\n" +
	"\x10psp_cluster_role\x18\v \x01(\tR\x0epspClusterRole\x12\x1e\n" +
	"\blogLevel\x18\f \x01(\tB\x02\x18\x01R\blogLevel\x12F\n" +
	"\alogging\x18\x19 \x01(\v2,.istio.operator.v1alpha1.GlobalLoggingConfigR\alogging\x12@\n" +
	"\x06repair\x18\r \x01(\v2(.istio.operator.v1alpha1.CNIRepairConfigR\x06repair\x124\n" +
	"\achained\x18\x0e \x01(\v2\x1a.google.protobuf.BoolValueR\achained\x12P\n" +
	"\x0fresource_quotas\x18\x10 \x01(\v2'.istio.operator.v1alpha1.ResourceQuotasR\x0eresourceQuotas\x12@\n" +
	"\tresources\x18\x11 \x01(\v2\".istio.operator.v1alpha1.ResourcesR\tresources\x12>\n" +
	"\n" +
	"privileged\x18\x12 \x01(\v2\x1a.google.protobuf.BoolValueB\x02\x18\x01R\n" +
	"privileged\x12J\n" +
	"\x0eseccompProfile\x18\x13 \x01(\v2\".k8s.io.api.core.v1.SeccompProfileR\x0eseccompProfile\x12C\n" +
	"\aambient\x18\x15 \x01(\v2).istio.operator.v1alpha1.CNIAmbientConfigR\aambient\x12\x1a\n" +
	"\bprovider\x18\x16 \x01(\tR\bprovider\x12Z\n" +
	"\x15rollingMaxUnavailable\x18\x17 \x01(\v2$.istio.operator.v1alpha1.IntOrStringR\x15rollingMaxUnavailable\x12L\n" +
	"\x13istioOwnedCNIConfig\x18# \x01(\v2\x1a.google.protobuf.BoolValueR\x13istioOwnedCNIConfig\x12@\n" +
	"\x1bistioOwnedCNIConfigFileName\x18$ \x01(\tR\x1bistioOwnedCNIConfigFileName\"\x9c\x01\n" +
	"\x0eCNIUsageConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x128\n" +
	"\achained\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueB\x02\x18\x01R\achained\x12\x1a\n" +
	"\bprovider\x18\x03 \x01(\tR\bprovider\"\xae\x02\n" +
	"\x10CNIAmbientConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12\x1c\n" +
	"\tconfigDir\x18\x03 \x01(\tR\tconfigDir\x12:\n" +
	"\n" +
	"dnsCapture\x18\x05 \x01(\v2\x1a.google.protobuf.BoolValueR\n" +
	"dnsCapture\x12.\n" +
	"\x04ipv6\x18\a \x01(\v2\x1a.google.protobuf.BoolValueR\x04ipv6\x12Z\n" +
	"\x1areconcileIptablesOnStartup\x18\t \x01(\v2\x1a.google.protobuf.BoolValueR\x1areconcileIptablesOnStartup\"\xad\x03\n" +
	"\x0fCNIRepairConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12\x10\n" +
	"\x03hub\x18\x02 \x01(\tR\x03hub\x12(\n" +
	"\x03tag\x18\x03 \x01(\v2\x16.google.protobuf.ValueR\x03tag\x12\x14\n" +
	"\x05image\x18\x04 \x01(\tR\x05image\x12\x1c\n" +
	"\tlabelPods\x18\x05 \x01(\bR\tlabelPods\x12\x1e\n" +
	"\n" +
	"repairPods\x18\v \x01(\bR\n" +
	"repairPods\x12&\n" +
	"\fcreateEvents\x18\x06 \x01(\tB\x02\x18\x01R\fcreateEvents\x12\x1e\n" +
	"\n" +
	"deletePods\x18\a \x01(\bR\n" +
	"deletePods\x12,\n" +
	"\x11brokenPodLabelKey\x18\b \x01(\tR\x11brokenPodLabelKey\x120\n" +
	"\x13brokenPodLabelValue\x18\t \x01(\tR\x13brokenPodLabelValue\x12,\n" +
	"\x11initContainerName\x18\n" +
	" \x01(\tR\x11initContainerName\"Z\n" +
	"\x0eResourceQuotas\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12\x12\n" +
	"\x04pods\x18\x02 \x01(\x03R\x04pods\"U\n" +
	"\x17TargetUtilizationConfig\x12:\n" +
	"\x18targetAverageUtilization\x18\x01 \x01(\x05R\x18targetAverageUtilization\"\x99\x02\n" +
	"\tResources\x12F\n" +
	"\x06limits\x18\x01 \x03(\v2..istio.operator.v1alpha1.Resources.LimitsEntryR\x06limits\x12L\n" +
	"\brequests\x18\x02 \x03(\v20.istio.operator.v1alpha1.Resources.RequestsEntryR\brequests\x1a9\n" +
	"\vLimitsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a;\n" +
	"\rRequestsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"K\n" +
	"\x0eServiceAccount\x129\n" +
	"\vannotations\x18\x01 \x01(\v2\x17.google.protobuf.StructR\vannotations\"X\n" +
	" DefaultPodDisruptionBudgetConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\"f\n" +
	"\x16DefaultResourcesConfig\x12L\n" +
	"\brequests\x18\x01 \x01(\v20.istio.operator.v1alpha1.ResourcesRequestsConfigR\brequests\"\xbb\x0f\n" +
	"\x13EgressGatewayConfig\x12F\n" +
	"\x10autoscaleEnabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\x10autoscaleEnabled\x12\"\n" +
	"\fautoscaleMax\x18\x02 \x01(\rR\fautoscaleMax\x12\"\n" +
	"\fautoscaleMin\x18\x03 \x01(\rR\fautoscaleMin\x12L\n" +
	"\x06memory\x18\x04 \x01(\v20.istio.operator.v1alpha1.TargetUtilizationConfigB\x02\x18\x01R\x06memory\x12F\n" +
	"\x03cpu\x18\x05 \x01(\v20.istio.operator.v1alpha1.TargetUtilizationConfigB\x02\x18\x01R\x03cpu\x12@\n" +
	"\rcustomService\x18\x06 \x01(\v2\x1a.google.protobuf.BoolValueR\rcustomService\x124\n" +
	"\aenabled\x18\a \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12)\n" +
	"\x03env\x18\b \x01(\v2\x17.google.protobuf.StructR\x03env\x12P\n" +
	"\x06labels\x18\t \x03(\v28.istio.operator.v1alpha1.EgressGatewayConfig.LabelsEntryR\x06labels\x12\x12\n" +
	"\x04name\x18\x19 \x01(\tR\x04name\x12?\n" +
	"\fnodeSelector\x18\n" +
	" \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\fnodeSelector\x12C\n" +
	"\x0epodAnnotations\x18\v \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\x0epodAnnotations\x12{\n" +
	"\x1cpodAntiAffinityLabelSelector\x18\f \x03(\v23.k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorB\x02\x18\x01R\x1cpodAntiAffinityLabelSelector\x12\x83\x01\n" +
	" podAntiAffinityTermLabelSelector\x18\r \x03(\v23.k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorB\x02\x18\x01R podAntiAffinityTermLabelSelector\x12:\n" +
	"\x05ports\x18\x0e \x03(\v2$.istio.operator.v1alpha1.PortsConfigR\x05ports\x12D\n" +
	"\tresources\x18\x0f \x01(\v2\".istio.operator.v1alpha1.ResourcesB\x02\x18\x01R\tresources\x12K\n" +
	"\rsecretVolumes\x18\x10 \x03(\v2%.istio.operator.v1alpha1.SecretVolumeR\rsecretVolumes\x12G\n" +
	"\x12serviceAnnotations\x18\x11 \x01(\v2\x17.google.protobuf.StructR\x12serviceAnnotations\x12\x12\n" +
	"\x04type\x18\x12 \x01(\tR\x04type\x12D\n" +
	"\vtolerations\x18\x14 \x03(\v2\x1e.k8s.io.api.core.v1.TolerationB\x02\x18\x01R\vtolerations\x12R\n" +
	"\x0frollingMaxSurge\x18\x15 \x01(\v2$.istio.operator.v1alpha1.IntOrStringB\x02\x18\x01R\x0frollingMaxSurge\x12^\n" +
	"\x15rollingMaxUnavailable\x18\x16 \x01(\v2$.istio.operator.v1alpha1.IntOrStringB\x02\x18\x01R\x15rollingMaxUnavailable\x12=\n" +
	"\rconfigVolumes\x18\x17 \x03(\v2\x17.google.protobuf.StructR\rconfigVolumes\x12K\n" +
	"\x14additionalContainers\x18\x18 \x03(\v2\x17.google.protobuf.StructR\x14additionalContainers\x128\n" +
	"\trunAsRoot\x18\x1a \x01(\v2\x1a.google.protobuf.BoolValueR\trunAsRoot\x12,\n" +
	"\x11injectionTemplate\x18\x1b \x01(\tR\x11injectionTemplate\x12O\n" +
	"\x0eserviceAccount\x18\x1c \x01(\v2'.istio.operator.v1alpha1.ServiceAccountR\x0eserviceAccount\x12\x1e\n" +
	"\n" +
	"ipFamilies\x18\x1d \x03(\tR\n" +
	"ipFamilies\x12&\n" +
	"\x0eipFamilyPolicy\x18\x1e \x01(\tR\x0eipFamilyPolicy\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x8b\x03\n" +
	"\x0eGatewaysConfig\x12^\n" +
	"\x13istio_egressgateway\x18\x01 \x01(\v2,.istio.operator.v1alpha1.EgressGatewayConfigR\x13istio-egressgateway\x124\n" +
	"\aenabled\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12a\n" +
	"\x14istio_ingressgateway\x18\x04 \x01(\v2-.istio.operator.v1alpha1.IngressGatewayConfigR\x14istio-ingressgateway\x12@\n" +
	"\x0fsecurityContext\x18\n" +
	" \x01(\v2\x16.google.protobuf.ValueR\x0fsecurityContext\x12>\n" +
	"\x0eseccompProfile\x18\f \x01(\v2\x16.google.protobuf.ValueR\x0eseccompProfile\"\x8b\x13\n" +
	"\fGlobalConfig\x12;\n" +
	"\x04arch\x18\x01 \x01(\v2#.istio.operator.v1alpha1.ArchConfigB\x02\x18\x01R\x04arch\x12 \n" +
	"\vcertSigners\x18D \x03(\tR\vcertSigners\x12F\n" +
	"\x10configValidation\x18\x03 \x01(\v2\x1a.google.protobuf.BoolValueR\x10configValidation\x12M\n" +
	"\x13defaultNodeSelector\x18\x06 \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\x13defaultNodeSelector\x12y\n" +
	"\x1adefaultPodDisruptionBudget\x18\a \x01(\v29.istio.operator.v1alpha1.DefaultPodDisruptionBudgetConfigR\x1adefaultPodDisruptionBudget\x12_\n" +
	"\x10defaultResources\x18\t \x01(\v2/.istio.operator.v1alpha1.DefaultResourcesConfigB\x02\x18\x01R\x10defaultResources\x12R\n" +
	"\x12defaultTolerations\x187 \x03(\v2\x1e.k8s.io.api.core.v1.TolerationB\x02\x18\x01R\x12defaultTolerations\x12\x10\n" +
	"\x03hub\x18\f \x01(\tR\x03hub\x12(\n" +
	"\x0fimagePullPolicy\x18\r \x01(\tR\x0fimagePullPolicy\x12*\n" +
	"\x10imagePullSecrets\x18% \x03(\tR\x10imagePullSecrets\x12&\n" +
	"\x0eistioNamespace\x18\x0e \x01(\tR\x0eistioNamespace\x128\n" +
	"\tlogAsJson\x18$ \x01(\v2\x1a.google.protobuf.BoolValueR\tlogAsJson\x12F\n" +
	"\alogging\x18\x11 \x01(\v2,.istio.operator.v1alpha1.GlobalLoggingConfigR\alogging\x12\x16\n" +
	"\x06meshID\x185 \x01(\tR\x06meshID\x12;\n" +
	"\fmeshNetworks\x18\x13 \x01(\v2\x17.google.protobuf.StructR\fmeshNetworks\x12O\n" +
	"\fmultiCluster\x18\x16 \x01(\v2+.istio.operator.v1alpha1.MultiClusterConfigR\fmultiCluster\x12\x18\n" +
	"\anetwork\x18' \x01(\tR\anetwork\x126\n" +
	"\x16podDNSSearchNamespaces\x18+ \x03(\tR\x16podDNSSearchNamespaces\x12^\n" +
	"\x1comitSidecarInjectorConfigMap\x18& \x01(\v2\x1a.google.protobuf.BoolValueR\x1comitSidecarInjectorConfigMap\x12R\n" +
	"\x16operatorManageWebhooks\x18) \x01(\v2\x1a.google.protobuf.BoolValueR\x16operatorManageWebhooks\x120\n" +
	"\x11priorityClassName\x18\x1b \x01(\tB\x02\x18\x01R\x11priorityClassName\x12:\n" +
	"\x05proxy\x18\x1c \x01(\v2$.istio.operator.v1alpha1.ProxyConfigR\x05proxy\x12H\n" +
	"\n" +
	"proxy_init\x18\x1d \x01(\v2(.istio.operator.v1alpha1.ProxyInitConfigR\n" +
	"proxy_init\x124\n" +
	"\x03sds\x18\x1e \x01(\v2\".istio.operator.v1alpha1.SDSConfigR\x03sds\x12(\n" +
	"\x03tag\x18\x1f \x01(\v2\x16.google.protobuf.ValueR\x03tag\x12\x18\n" +
	"\avariant\x18C \x01(\tR\avariant\x12=\n" +
	"\x06tracer\x18! \x01(\v2%.istio.operator.v1alpha1.TracerConfigR\x06tracer\x12.\n" +
	"\x12remotePilotAddress\x180 \x01(\tR\x12remotePilotAddress\x12=\n" +
	"\x06istiod\x186 \x01(\v2%.istio.operator.v1alpha1.IstiodConfigR\x06istiod\x12,\n" +
	"\x11pilotCertProvider\x188 \x01(\tR\x11pilotCertProvider\x12 \n" +
	"\tjwtPolicy\x189 \x01(\tB\x02\x18\x01R\tjwtPolicy\x124\n" +
	"\x03sts\x18: \x01(\v2\".istio.operator.v1alpha1.STSConfigR\x03sts\x12\x1a\n" +
	"\brevision\x18; \x01(\tR\brevision\x12B\n" +
	"\x0emountMtlsCerts\x18< \x01(\v2\x1a.google.protobuf.BoolValueR\x0emountMtlsCerts\x12\x1c\n" +
	"\tcaAddress\x18= \x01(\tR\tcaAddress\x12B\n" +
	"\x0eexternalIstiod\x18> \x01(\v2\x1a.google.protobuf.BoolValueR\x0eexternalIstiod\x12@\n" +
	"\rconfigCluster\x18@ \x01(\v2\x1a.google.protobuf.BoolValueR\rconfigCluster\x12\x16\n" +
	"\x06caName\x18A \x01(\tR\x06caName\x12\x1a\n" +
	"\bplatform\x18E \x01(\tR\bplatform\x12\x1e\n" +
	"\n" +
	"ipFamilies\x18F \x03(\tR\n" +
	"ipFamilies\x12&\n" +
	"\x0eipFamilyPolicy\x18G \x01(\tR\x0eipFamilyPolicy\x12C\n" +
	"\bwaypoint\x18H \x01(\v2'.istio.operator.v1alpha1.WaypointConfigR\bwaypoint\x12(\n" +
	"\x0ftrustBundleName\x18I \x01(\tR\x0ftrustBundleName\x12B\n" +
	"\x0enativeNftables\x18J \x01(\v2\x1a.google.protobuf.BoolValueR\x0enativeNftables\"-\n" +
	"\tSTSConfig\x12 \n" +
	"\vservicePort\x18\x01 \x01(\rR\vservicePort\"R\n" +
	"\fIstiodConfig\x12B\n" +
	"\x0eenableAnalysis\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\x0eenableAnalysis\"+\n" +
	"\x13GlobalLoggingConfig\x12\x14\n" +
	"\x05level\x18\x01 \x01(\tR\x05level\"\xb1\x11\n" +
	"\x14IngressGatewayConfig\x12F\n" +
	"\x10autoscaleEnabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\x10autoscaleEnabled\x12\"\n" +
	"\fautoscaleMax\x18\x02 \x01(\rR\fautoscaleMax\x12\"\n" +
	"\fautoscaleMin\x18\x03 \x01(\rR\fautoscaleMin\x12L\n" +
	"\x06memory\x18\x04 \x01(\v20.istio.operator.v1alpha1.TargetUtilizationConfigB\x02\x18\x01R\x06memory\x12F\n" +
	"\x03cpu\x18\x05 \x01(\v20.istio.operator.v1alpha1.TargetUtilizationConfigB\x02\x18\x01R\x03cpu\x12@\n" +
	"\rcustomService\x18\x06 \x01(\v2\x1a.google.protobuf.BoolValueR\rcustomService\x124\n" +
	"\aenabled\x18\n" +
	" \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12)\n" +
	"\x03env\x18\v \x01(\v2\x17.google.protobuf.StructR\x03env\x12Q\n" +
	"\x06labels\x18\x0f \x03(\v29.istio.operator.v1alpha1.IngressGatewayConfig.LabelsEntryR\x06labels\x12&\n" +
	"\x0eloadBalancerIP\x18\x10 \x01(\tR\x0eloadBalancerIP\x12:\n" +
	"\x18loadBalancerSourceRanges\x18\x11 \x03(\tR\x18loadBalancerSourceRanges\x12\x12\n" +
	"\x04name\x18, \x01(\tR\x04name\x12?\n" +
	"\fnodeSelector\x18\x13 \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\fnodeSelector\x12C\n" +
	"\x0epodAnnotations\x18\x14 \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\x0epodAnnotations\x12{\n" +
	"\x1cpodAntiAffinityLabelSelector\x18\x15 \x03(\v23.k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorB\x02\x18\x01R\x1cpodAntiAffinityLabelSelector\x12\x83\x01\n" +
	" podAntiAffinityTermLabelSelector\x18\x16 \x03(\v23.k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorB\x02\x18\x01R podAntiAffinityTermLabelSelector\x12:\n" +
	"\x05ports\x18\x17 \x03(\v2$.istio.operator.v1alpha1.PortsConfigR\x05ports\x12&\n" +
	"\freplicaCount\x18\x18 \x01(\rB\x02\x18\x01R\freplicaCount\x129\n" +
	"\tresources\x18\x19 \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\tresources\x12K\n" +
	"\rsecretVolumes\x18\x1b \x03(\v2%.istio.operator.v1alpha1.SecretVolumeR\rsecretVolumes\x12G\n" +
	"\x12serviceAnnotations\x18\x1c \x01(\v2\x17.google.protobuf.StructR\x12serviceAnnotations\x12\x12\n" +
	"\x04type\x18\x1d \x01(\tR\x04type\x12R\n" +
	"\x0frollingMaxSurge\x18\x1f \x01(\v2$.istio.operator.v1alpha1.IntOrStringB\x02\x18\x01R\x0frollingMaxSurge\x12^\n" +
	"\x15rollingMaxUnavailable\x18  \x01(\v2$.istio.operator.v1alpha1.IntOrStringB\x02\x18\x01R\x15rollingMaxUnavailable\x124\n" +
	"\x15externalTrafficPolicy\x18\" \x01(\tR\x15externalTrafficPolicy\x12D\n" +
	"\vtolerations\x18# \x03(\v2\x1e.k8s.io.api.core.v1.TolerationB\x02\x18\x01R\vtolerations\x12;\n" +
	"\fingressPorts\x18$ \x03(\v2\x17.google.protobuf.StructR\fingressPorts\x12K\n" +
	"\x14additionalContainers\x18% \x03(\v2\x17.google.protobuf.StructR\x14additionalContainers\x12=\n" +
	"\rconfigVolumes\x18& \x03(\v2\x17.google.protobuf.StructR\rconfigVolumes\x128\n" +
	"\trunAsRoot\x18- \x01(\v2\x1a.google.protobuf.BoolValueR\trunAsRoot\x12,\n" +
	"\x11injectionTemplate\x18. \x01(\tR\x11injectionTemplate\x12O\n" +
	"\x0eserviceAccount\x18/ \x01(\v2'.istio.operator.v1alpha1.ServiceAccountR\x0eserviceAccount\x12\x1e\n" +
	"\n" +
	"ipFamilies\x180 \x03(\tR\n" +
	"ipFamilies\x12&\n" +
	"\x0eipFamilyPolicy\x181 \x01(\tR\x0eipFamilyPolicy\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xe8\x01\n" +
	"\x12MultiClusterConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12 \n" +
	"\vclusterName\x18\x02 \x01(\tR\vclusterName\x12.\n" +
	"\x12globalDomainSuffix\x18\x03 \x01(\tR\x12globalDomainSuffix\x12J\n" +
	"\x12includeEnvoyFilter\x18\x04 \x01(\v2\x1a.google.protobuf.BoolValueR\x12includeEnvoyFilter\"\x96\x01\n" +
	"\x1bOutboundTrafficPolicyConfig\x12M\n" +
	"\x04mode\x18\x02 \x01(\x0e29.istio.operator.v1alpha1.OutboundTrafficPolicyConfig.ModeR\x04mode\"(\n" +
	"\x04Mode\x12\r\n" +
	"\tALLOW_ANY\x10\x00\x12\x11\n" +
	"\rREGISTRY_ONLY\x10\x01\"\x98\x13\n" +
	"\vPilotConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12F\n" +
	"\x10autoscaleEnabled\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\x10autoscaleEnabled\x12\"\n" +
	"\fautoscaleMin\x18\x03 \x01(\rR\fautoscaleMin\x12\"\n" +
	"\fautoscaleMax\x18\x04 \x01(\rR\fautoscaleMax\x12E\n" +
	"\x11autoscaleBehavior\x18( \x01(\v2\x17.google.protobuf.StructR\x11autoscaleBehavior\x12&\n" +
	"\freplicaCount\x18\x05 \x01(\rB\x02\x18\x01R\freplicaCount\x12\x14\n" +
	"\x05image\x18\x06 \x01(\tR\x05image\x12$\n" +
	"\rtraceSampling\x18\b \x01(\x01R\rtraceSampling\x12D\n" +
	"\tresources\x18\t \x01(\v2\".istio.operator.v1alpha1.ResourcesB\x02\x18\x01R\tresources\x12F\n" +
	"\x03cpu\x18\v \x01(\v20.istio.operator.v1alpha1.TargetUtilizationConfigB\x02\x18\x01R\x03cpu\x12?\n" +
	"\fnodeSelector\x18\f \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\fnodeSelector\x12c\n" +
	"\x1fkeepaliveMaxServerConnectionAge\x18\r \x01(\v2\x19.google.protobuf.DurationR\x1fkeepaliveMaxServerConnectionAge\x12C\n" +
	"\x10deploymentLabels\x18\x0e \x01(\v2\x17.google.protobuf.StructR\x10deploymentLabels\x125\n" +
	"\tpodLabels\x18$ \x01(\v2\x17.google.protobuf.StructR\tpodLabels\x128\n" +
	"\tconfigMap\x18\x12 \x01(\v2\x1a.google.protobuf.BoolValueR\tconfigMap\x12)\n" +
	"\x03env\x18\x15 \x01(\v2\x17.google.protobuf.StructR\x03env\x128\n" +
	"\baffinity\x18\x16 \x01(\v2\x1c.k8s.io.api.core.v1.AffinityR\baffinity\x12R\n" +
	"\x0frollingMaxSurge\x18\x18 \x01(\v2$.istio.operator.v1alpha1.IntOrStringB\x02\x18\x01R\x0frollingMaxSurge\x12^\n" +
	"\x15rollingMaxUnavailable\x18\x19 \x01(\v2$.istio.operator.v1alpha1.IntOrStringB\x02\x18\x01R\x15rollingMaxUnavailable\x12D\n" +
	"\vtolerations\x18\x1a \x03(\v2\x1e.k8s.io.api.core.v1.TolerationB\x02\x18\x01R\vtolerations\x12C\n" +
	"\x0epodAnnotations\x18\x1e \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\x0epodAnnotations\x12G\n" +
	"\x12serviceAnnotations\x18% \x01(\v2\x17.google.protobuf.StructR\x12serviceAnnotations\x12U\n" +
	"\x19serviceAccountAnnotations\x188 \x01(\v2\x17.google.protobuf.StructR\x19serviceAccountAnnotations\x128\n" +
	"\x17jwksResolverExtraRootCA\x18  \x01(\tR\x17jwksResolverExtraRootCA\x12\x10\n" +
	"\x03hub\x18\" \x01(\tR\x03hub\x12(\n" +
	"\x03tag\x18# \x01(\v2\x16.google.protobuf.ValueR\x03tag\x12\x18\n" +
	"\avariant\x18' \x01(\tR\avariant\x12J\n" +
	"\x0eseccompProfile\x18& \x01(\v2\".k8s.io.api.core.v1.SeccompProfileR\x0eseccompProfile\x12j\n" +
	"\x19topologySpreadConstraints\x18) \x03(\v2,.k8s.io.api.core.v1.TopologySpreadConstraintR\x19topologySpreadConstraints\x12G\n" +
	"\x12extraContainerArgs\x18* \x03(\v2\x17.google.protobuf.StructR\x12extraContainerArgs\x12C\n" +
	"\fvolumeMounts\x181 \x03(\v2\x1f.k8s.io.api.core.v1.VolumeMountR\fvolumeMounts\x124\n" +
	"\avolumes\x183 \x03(\v2\x1a.k8s.io.api.core.v1.VolumeR\avolumes\x12\x1e\n" +
	"\n" +
	"ipFamilies\x184 \x03(\tR\n" +
	"ipFamilies\x12&\n" +
	"\x0eipFamilyPolicy\x185 \x01(\tR\x0eipFamilyPolicy\x12L\n" +
	"\x06memory\x186 \x01(\v20.istio.operator.v1alpha1.TargetUtilizationConfigB\x02\x18\x01R\x06memory\x129\n" +
	"\x03cni\x187 \x01(\v2'.istio.operator.v1alpha1.CNIUsageConfigR\x03cni\x12I\n" +
	"\x05taint\x189 \x01(\v23.istio.operator.v1alpha1.PilotTaintControllerConfigR\x05taint\x128\n" +
	"\x17trustedZtunnelNamespace\x18; \x01(\tR\x17trustedZtunnelNamespace\x12O\n" +
	"\fistiodRemote\x18= \x01(\v2+.istio.operator.v1alpha1.IstiodRemoteConfigR\fistiodRemote\x127\n" +
	"\n" +
	"envVarFrom\x18> \x03(\v2\x17.google.protobuf.StructR\n" +
	"envVarFrom\"T\n" +
	"\x1aPilotTaintControllerConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\"\xc6\x01\n" +
	"\x12PilotIngressConfig\x12&\n" +
	"\x0eingressService\x18\x01 \x01(\tR\x0eingressService\x12d\n" +
	"\x15ingressControllerMode\x18\x02 \x01(\x0e2..istio.operator.v1alpha1.ingressControllerModeR\x15ingressControllerMode\x12\"\n" +
	"\fingressClass\x18\x03 \x01(\tR\fingressClass\"I\n" +
	"\x11PilotPolicyConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\"\x83\x01\n" +
	"\x0fTelemetryConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12:\n" +
	"\x02v2\x18\x03 \x01(\v2*.istio.operator.v1alpha1.TelemetryV2ConfigR\x02v2\"\xf8\x01\n" +
	"\x11TelemetryV2Config\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12T\n" +
	"\n" +
	"prometheus\x18\x02 \x01(\v24.istio.operator.v1alpha1.TelemetryV2PrometheusConfigR\n" +
	"prometheus\x12W\n" +
	"\vstackdriver\x18\x03 \x01(\v25.istio.operator.v1alpha1.TelemetryV2StackDriverConfigR\vstackdriver\"S\n" +
	"\x1bTelemetryV2PrometheusConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\"T\n" +
	"\x1cTelemetryV2StackDriverConfig\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\"\x8d\x01\n" +
	"\vPortsConfig\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04port\x18\x02 \x01(\x05R\x04port\x12\x1a\n" +
	"\bnodePort\x18\x03 \x01(\x05R\bnodePort\x12\x1e\n" +
	"\n" +
	"targetPort\x18\x04 \x01(\x05R\n" +
	"targetPort\x12\x1a\n" +
	"\bprotocol\x18\x05 \x01(\tR\bprotocol\"\xca\t\n" +
	"\vProxyConfig\x12\x1e\n" +
	"\n" +
	"autoInject\x18\x04 \x01(\tR\n" +
	"autoInject\x12$\n" +
	"\rclusterDomain\x18\x05 \x01(\tR\rclusterDomain\x12,\n" +
	"\x11componentLogLevel\x18\x06 \x01(\tR\x11componentLogLevel\x12F\n" +
	"\x0eenableCoreDump\x18\t \x01(\v2\x1a.google.protobuf.BoolValueB\x02\x18\x01R\x0eenableCoreDump\x120\n" +
	"\x13excludeInboundPorts\x18\f \x01(\tR\x13excludeInboundPorts\x12(\n" +
	"\x0fexcludeIPRanges\x18\r \x01(\tR\x0fexcludeIPRanges\x12\x14\n" +
	"\x05image\x18\x0e \x01(\tR\x05image\x12(\n" +
	"\x0fincludeIPRanges\x18\x10 \x01(\tR\x0fincludeIPRanges\x12\x1a\n" +
	"\blogLevel\x18\x12 \x01(\tR\blogLevel\x12&\n" +
	"\x0eoutlierLogPath\x18* \x01(\tR\x0eoutlierLogPath\x12:\n" +
	"\n" +
	"privileged\x18\x13 \x01(\v2\x1a.google.protobuf.BoolValueR\n" +
	"privileged\x12B\n" +
	"\x1creadinessInitialDelaySeconds\x18\x14 \x01(\rR\x1creadinessInitialDelaySeconds\x126\n" +
	"\x16readinessPeriodSeconds\x18\x15 \x01(\rR\x16readinessPeriodSeconds\x12<\n" +
	"\x19readinessFailureThreshold\x18\x16 \x01(\rR\x19readinessFailureThreshold\x12I\n" +
	"\fstartupProbe\x18) \x01(\v2%.istio.operator.v1alpha1.StartupProbeR\fstartupProbe\x12\x1e\n" +
	"\n" +
	"statusPort\x18\x17 \x01(\rR\n" +
	"statusPort\x12D\n" +
	"\tresources\x18\x18 \x01(\v2\".istio.operator.v1alpha1.ResourcesB\x02\x18\x01R\tresources\x127\n" +
	"\x06tracer\x18\x19 \x01(\x0e2\x1f.istio.operator.v1alpha1.tracerR\x06tracer\x122\n" +
	"\x14excludeOutboundPorts\x18\x1c \x01(\tR\x14excludeOutboundPorts\x12;\n" +
	"\tlifecycle\x18$ \x01(\v2\x1d.k8s.io.api.core.v1.LifecycleR\tlifecycle\x12h\n" +
	"\x1fholdApplicationUntilProxyStarts\x18% \x01(\v2\x1a.google.protobuf.BoolValueB\x02\x18\x01R\x1fholdApplicationUntilProxyStarts\x120\n" +
	"\x13includeInboundPorts\x18& \x01(\tR\x13includeInboundPorts\x122\n" +
	"\x14includeOutboundPorts\x18' \x01(\tR\x14includeOutboundPorts\"p\n" +
	"\fStartupProbe\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12*\n" +
	"\x10failureThreshold\x18\x02 \x01(\rR\x10failureThreshold\"m\n" +
	"\x0fProxyInitConfig\x12\x14\n" +
	"\x05image\x18\x01 \x01(\tR\x05image\x12D\n" +
	"\tresources\x18\x05 \x01(\v2\".istio.operator.v1alpha1.ResourcesB\x02\x18\x01R\tresources\"C\n" +
	"\x17ResourcesRequestsConfig\x12\x10\n" +
	"\x03cpu\x18\x01 \x01(\tR\x03cpu\x12\x16\n" +
	"\x06memory\x18\x02 \x01(\tR\x06memory\">\n" +
	"\tSDSConfig\x121\n" +
	"\x05token\x18\x05 \x01(\v2\x17.google.protobuf.StructB\x02\x18\x01R\x05token\"`\n" +
	"\fSecretVolume\x12\x1c\n" +
	"\tmountPath\x18\x01 \x01(\tR\tmountPath\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x1e\n" +
	"\n" +
	"secretName\x18\x03 \x01(\tR\n" +
	"secretName\"\x91\x05\n" +
	"\x15SidecarInjectorConfig\x12X\n" +
	"\x19enableNamespacesByDefault\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\x19enableNamespacesByDefault\x12.\n" +
	"\x12reinvocationPolicy\x18\x03 \x01(\tR\x12reinvocationPolicy\x12e\n" +
	"\x13neverInjectSelector\x18\v \x03(\v23.k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorR\x13neverInjectSelector\x12g\n" +
	"\x14alwaysInjectSelector\x18\f \x03(\v23.k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorR\x14alwaysInjectSelector\x12L\n" +
	"\x13rewriteAppHTTPProbe\x18\x10 \x01(\v2\x1a.google.protobuf.BoolValueR\x13rewriteAppHTTPProbe\x12I\n" +
	"\x13injectedAnnotations\x18\x13 \x01(\v2\x17.google.protobuf.StructR\x13injectedAnnotations\x12\"\n" +
	"\finjectionURL\x18\x16 \x01(\tR\finjectionURL\x125\n" +
	"\ttemplates\x18\x17 \x01(\v2\x17.google.protobuf.StructR\ttemplates\x12*\n" +
	"\x10defaultTemplates\x18\x18 \x03(\tR\x10defaultTemplates\"\xbd\x02\n" +
	"\fTracerConfig\x12F\n" +
	"\adatadog\x18\x01 \x01(\v2,.istio.operator.v1alpha1.TracerDatadogConfigR\adatadog\x12L\n" +
	"\tlightstep\x18\x02 \x01(\v2..istio.operator.v1alpha1.TracerLightStepConfigR\tlightstep\x12C\n" +
	"\x06zipkin\x18\x03 \x01(\v2+.istio.operator.v1alpha1.TracerZipkinConfigR\x06zipkin\x12R\n" +
	"\vstackdriver\x18\x04 \x01(\v20.istio.operator.v1alpha1.TracerStackdriverConfigR\vstackdriver\"/\n" +
	"\x13TracerDatadogConfig\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\"S\n" +
	"\x15TracerLightStepConfig\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12 \n" +
	"\vaccessToken\x18\x02 \x01(\tR\vaccessToken\".\n" +
	"\x12TracerZipkinConfig\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\"\xf5\x01\n" +
	"\x17TracerStackdriverConfig\x120\n" +
	"\x05debug\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\x05debug\x124\n" +
	"\x15maxNumberOfAttributes\x18\x02 \x01(\rR\x15maxNumberOfAttributes\x126\n" +
	"\x16maxNumberOfAnnotations\x18\x03 \x01(\rR\x16maxNumberOfAnnotations\x12:\n" +
	"\x18maxNumberOfMessageEvents\x18\x04 \x01(\rR\x18maxNumberOfMessageEvents\"\xea\x02\n" +
	"\n" +
	"BaseConfig\x12J\n" +
	"\x12enableCRDTemplates\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\x12enableCRDTemplates\x12\"\n" +
	"\fexcludedCRDs\x18\x06 \x03(\tR\fexcludedCRDs\x12$\n" +
	"\rvalidationURL\x18\x02 \x01(\tR\rvalidationURL\x12P\n" +
	"\x15enableIstioConfigCRDs\x18\x03 \x01(\v2\x1a.google.protobuf.BoolValueR\x15enableIstioConfigCRDs\x12D\n" +
	"\x0fvalidateGateway\x18\x04 \x01(\v2\x1a.google.protobuf.BoolValueR\x0fvalidateGateway\x12.\n" +
	"\x12validationCABundle\x18\x05 \x01(\tR\x12validationCABundle\"\x9e\x02\n" +
	"\x12IstiodRemoteConfig\x12\"\n" +
	"\finjectionURL\x18\x01 \x01(\tR\finjectionURL\x12$\n" +
	"\rinjectionPath\x18\x02 \x01(\tR\rinjectionPath\x12,\n" +
	"\x11injectionCABundle\x18\x03 \x01(\tR\x11injectionCABundle\x124\n" +
	"\aenabled\x18\x05 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x12Z\n" +
	"\x1aenabledLocalInjectorIstiod\x18\x06 \x01(\v2\x1a.google.protobuf.BoolValueR\x1aenabledLocalInjectorIstiod\"\xd7\b\n" +
	"\x06Values\x124\n" +
	"\x03cni\x18\x02 \x01(\v2\".istio.operator.v1alpha1.CNIConfigR\x03cni\x12C\n" +
	"\bgateways\x18\x05 \x01(\v2'.istio.operator.v1alpha1.GatewaysConfigR\bgateways\x12=\n" +
	"\x06global\x18\x06 \x01(\v2%.istio.operator.v1alpha1.GlobalConfigR\x06global\x12:\n" +
	"\x05pilot\x18\n" +
	" \x01(\v2$.istio.operator.v1alpha1.PilotConfigR\x05pilot\x120\n" +
	"\aztunnel\x18) \x01(\v2\x16.google.protobuf.ValueR\aztunnel\x12F\n" +
	"\ttelemetry\x18\x17 \x01(\v2(.istio.operator.v1alpha1.TelemetryConfigR\ttelemetry\x12f\n" +
	"\x16sidecarInjectorWebhook\x18\r \x01(\v2..istio.operator.v1alpha1.SidecarInjectorConfigR\x16sidecarInjectorWebhook\x12H\n" +
	"\tistio_cni\x18\x13 \x01(\v2'.istio.operator.v1alpha1.CNIUsageConfigB\x02\x18\x01R\bistioCni\x12\x1a\n" +
	"\brevision\x18\x15 \x01(\tR\brevision\x12\x1c\n" +
	"\townerName\x18\x16 \x01(\tR\townerName\x126\n" +
	"\n" +
	"meshConfig\x18$ \x01(\v2\x16.google.protobuf.ValueR\n" +
	"meshConfig\x127\n" +
	"\x04base\x18% \x01(\v2#.istio.operator.v1alpha1.BaseConfigR\x04base\x12S\n" +
	"\fistiodRemote\x18& \x01(\v2+.istio.operator.v1alpha1.IstiodRemoteConfigB\x02\x18\x01R\fistiodRemote\x12\"\n" +
	"\frevisionTags\x18' \x03(\tR\frevisionTags\x12(\n" +
	"\x0fdefaultRevision\x18( \x01(\tR\x0fdefaultRevision\x12\x18\n" +
	"\aprofile\x18* \x01(\tR\aprofile\x122\n" +
	"\x14compatibilityVersion\x18+ \x01(\tR\x14compatibilityVersion\x12O\n" +
	"\fexperimental\x18, \x01(\v2+.istio.operator.v1alpha1.ExperimentalConfigR\fexperimental\x12>\n" +
	"\x0egatewayClasses\x18- \x01(\v2\x16.google.protobuf.ValueR\x0egatewayClasses\"h\n" +
	"\x12ExperimentalConfig\x12R\n" +
	"\x16stableValidationPolicy\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\x16stableValidationPolicy\"\x8c\x01\n" +
	"\vIntOrString\x12\x12\n" +
	"\x04type\x18\x01 \x01(\x03R\x04type\x123\n" +
	"\x06intVal\x18\x02 \x01(\v2\x1b.google.protobuf.Int32ValueR\x06intVal\x124\n" +
	"\x06strVal\x18\x03 \x01(\v2\x1c.google.protobuf.StringValueR\x06strVal\"\xfe\x02\n" +
	"\x0eWaypointConfig\x12@\n" +
	"\tresources\x18\x01 \x01(\v2\".istio.operator.v1alpha1.ResourcesR\tresources\x128\n" +
	"\baffinity\x18\x02 \x01(\v2\x1c.k8s.io.api.core.v1.AffinityR\baffinity\x12j\n" +
	"\x19topologySpreadConstraints\x18\x03 \x03(\v2,.k8s.io.api.core.v1.TopologySpreadConstraintR\x19topologySpreadConstraints\x12D\n" +
	"\fnodeSelector\x18\x04 \x01(\v2 .k8s.io.api.core.v1.NodeSelectorR\fnodeSelector\x12>\n" +
	"\n" +
	"toleration\x18\x05 \x03(\v2\x1e.k8s.io.api.core.v1.TolerationR\n" +
	"toleration*J\n" +
	"\x15ingressControllerMode\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\v\n" +
	"\aDEFAULT\x10\x01\x12\n" +
	"\n" +
	"\x06STRICT\x10\x02\x12\a\n" +
	"\x03OFF\x10\x03*`\n" +
	"\x06tracer\x12\n" +
	"\n" +
	"\x06zipkin\x10\x00\x12\r\n" +
	"\tlightstep\x10\x01\x12\v\n" +
	"\adatadog\x10\x02\x12\x0f\n" +
	"\vstackdriver\x10\x03\x12\x13\n" +
	"\x0fopenCensusAgent\x10\x04\x12\b\n" +
	"\x04none\x10\x05B\"Z istio.io/istio/operator/pkg/apisb\x06proto3"

var (
	file_pkg_apis_values_types_proto_rawDescOnce sync.Once
	file_pkg_apis_values_types_proto_rawDescData []byte
)

func file_pkg_apis_values_types_proto_rawDescGZIP() []byte {
	file_pkg_apis_values_types_proto_rawDescOnce.Do(func() {
		file_pkg_apis_values_types_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_pkg_apis_values_types_proto_rawDesc), len(file_pkg_apis_values_types_proto_rawDesc)))
	})
	return file_pkg_apis_values_types_proto_rawDescData
}

var file_pkg_apis_values_types_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_pkg_apis_values_types_proto_msgTypes = make([]protoimpl.MessageInfo, 51)
var file_pkg_apis_values_types_proto_goTypes = []any{
	(IngressControllerMode)(0),               // 0: istio.operator.v1alpha1.ingressControllerMode
	(Tracer)(0),                              // 1: istio.operator.v1alpha1.tracer
	(OutboundTrafficPolicyConfig_Mode)(0),    // 2: istio.operator.v1alpha1.OutboundTrafficPolicyConfig.Mode
	(*ArchConfig)(nil),                       // 3: istio.operator.v1alpha1.ArchConfig
	(*CNIConfig)(nil),                        // 4: istio.operator.v1alpha1.CNIConfig
	(*CNIUsageConfig)(nil),                   // 5: istio.operator.v1alpha1.CNIUsageConfig
	(*CNIAmbientConfig)(nil),                 // 6: istio.operator.v1alpha1.CNIAmbientConfig
	(*CNIRepairConfig)(nil),                  // 7: istio.operator.v1alpha1.CNIRepairConfig
	(*ResourceQuotas)(nil),                   // 8: istio.operator.v1alpha1.ResourceQuotas
	(*TargetUtilizationConfig)(nil),          // 9: istio.operator.v1alpha1.TargetUtilizationConfig
	(*Resources)(nil),                        // 10: istio.operator.v1alpha1.Resources
	(*ServiceAccount)(nil),                   // 11: istio.operator.v1alpha1.ServiceAccount
	(*DefaultPodDisruptionBudgetConfig)(nil), // 12: istio.operator.v1alpha1.DefaultPodDisruptionBudgetConfig
	(*DefaultResourcesConfig)(nil),           // 13: istio.operator.v1alpha1.DefaultResourcesConfig
	(*EgressGatewayConfig)(nil),              // 14: istio.operator.v1alpha1.EgressGatewayConfig
	(*GatewaysConfig)(nil),                   // 15: istio.operator.v1alpha1.GatewaysConfig
	(*GlobalConfig)(nil),                     // 16: istio.operator.v1alpha1.GlobalConfig
	(*STSConfig)(nil),                        // 17: istio.operator.v1alpha1.STSConfig
	(*IstiodConfig)(nil),                     // 18: istio.operator.v1alpha1.IstiodConfig
	(*GlobalLoggingConfig)(nil),              // 19: istio.operator.v1alpha1.GlobalLoggingConfig
	(*IngressGatewayConfig)(nil),             // 20: istio.operator.v1alpha1.IngressGatewayConfig
	(*MultiClusterConfig)(nil),               // 21: istio.operator.v1alpha1.MultiClusterConfig
	(*OutboundTrafficPolicyConfig)(nil),      // 22: istio.operator.v1alpha1.OutboundTrafficPolicyConfig
	(*PilotConfig)(nil),                      // 23: istio.operator.v1alpha1.PilotConfig
	(*PilotTaintControllerConfig)(nil),       // 24: istio.operator.v1alpha1.PilotTaintControllerConfig
	(*PilotIngressConfig)(nil),               // 25: istio.operator.v1alpha1.PilotIngressConfig
	(*PilotPolicyConfig)(nil),                // 26: istio.operator.v1alpha1.PilotPolicyConfig
	(*TelemetryConfig)(nil),                  // 27: istio.operator.v1alpha1.TelemetryConfig
	(*TelemetryV2Config)(nil),                // 28: istio.operator.v1alpha1.TelemetryV2Config
	(*TelemetryV2PrometheusConfig)(nil),      // 29: istio.operator.v1alpha1.TelemetryV2PrometheusConfig
	(*TelemetryV2StackDriverConfig)(nil),     // 30: istio.operator.v1alpha1.TelemetryV2StackDriverConfig
	(*PortsConfig)(nil),                      // 31: istio.operator.v1alpha1.PortsConfig
	(*ProxyConfig)(nil),                      // 32: istio.operator.v1alpha1.ProxyConfig
	(*StartupProbe)(nil),                     // 33: istio.operator.v1alpha1.StartupProbe
	(*ProxyInitConfig)(nil),                  // 34: istio.operator.v1alpha1.ProxyInitConfig
	(*ResourcesRequestsConfig)(nil),          // 35: istio.operator.v1alpha1.ResourcesRequestsConfig
	(*SDSConfig)(nil),                        // 36: istio.operator.v1alpha1.SDSConfig
	(*SecretVolume)(nil),                     // 37: istio.operator.v1alpha1.SecretVolume
	(*SidecarInjectorConfig)(nil),            // 38: istio.operator.v1alpha1.SidecarInjectorConfig
	(*TracerConfig)(nil),                     // 39: istio.operator.v1alpha1.TracerConfig
	(*TracerDatadogConfig)(nil),              // 40: istio.operator.v1alpha1.TracerDatadogConfig
	(*TracerLightStepConfig)(nil),            // 41: istio.operator.v1alpha1.TracerLightStepConfig
	(*TracerZipkinConfig)(nil),               // 42: istio.operator.v1alpha1.TracerZipkinConfig
	(*TracerStackdriverConfig)(nil),          // 43: istio.operator.v1alpha1.TracerStackdriverConfig
	(*BaseConfig)(nil),                       // 44: istio.operator.v1alpha1.BaseConfig
	(*IstiodRemoteConfig)(nil),               // 45: istio.operator.v1alpha1.IstiodRemoteConfig
	(*Values)(nil),                           // 46: istio.operator.v1alpha1.Values
	(*ExperimentalConfig)(nil),               // 47: istio.operator.v1alpha1.ExperimentalConfig
	(*IntOrString)(nil),                      // 48: istio.operator.v1alpha1.IntOrString
	(*WaypointConfig)(nil),                   // 49: istio.operator.v1alpha1.WaypointConfig
	nil,                                      // 50: istio.operator.v1alpha1.Resources.LimitsEntry
	nil,                                      // 51: istio.operator.v1alpha1.Resources.RequestsEntry
	nil,                                      // 52: istio.operator.v1alpha1.EgressGatewayConfig.LabelsEntry
	nil,                                      // 53: istio.operator.v1alpha1.IngressGatewayConfig.LabelsEntry
	(*wrapperspb.BoolValue)(nil),             // 54: google.protobuf.BoolValue
	(*structpb.Value)(nil),                   // 55: google.protobuf.Value
	(*v1.Affinity)(nil),                      // 56: k8s.io.api.core.v1.Affinity
	(*structpb.Struct)(nil),                  // 57: google.protobuf.Struct
	(*v1.SeccompProfile)(nil),                // 58: k8s.io.api.core.v1.SeccompProfile
	(*v11.LabelSelector)(nil),                // 59: k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
	(*v1.Toleration)(nil),                    // 60: k8s.io.api.core.v1.Toleration
	(*durationpb.Duration)(nil),              // 61: google.protobuf.Duration
	(*v1.TopologySpreadConstraint)(nil),      // 62: k8s.io.api.core.v1.TopologySpreadConstraint
	(*v1.VolumeMount)(nil),                   // 63: k8s.io.api.core.v1.VolumeMount
	(*v1.Volume)(nil),                        // 64: k8s.io.api.core.v1.Volume
	(*v1.Lifecycle)(nil),                     // 65: k8s.io.api.core.v1.Lifecycle
	(*wrapperspb.Int32Value)(nil),            // 66: google.protobuf.Int32Value
	(*wrapperspb.StringValue)(nil),           // 67: google.protobuf.StringValue
	(*v1.NodeSelector)(nil),                  // 68: k8s.io.api.core.v1.NodeSelector
}
var file_pkg_apis_values_types_proto_depIdxs = []int32{
	54,  // 0: istio.operator.v1alpha1.CNIConfig.enabled:type_name -> google.protobuf.BoolValue
	55,  // 1: istio.operator.v1alpha1.CNIConfig.tag:type_name -> google.protobuf.Value
	56,  // 2: istio.operator.v1alpha1.CNIConfig.affinity:type_name -> k8s.io.api.core.v1.Affinity
	57,  // 3: istio.operator.v1alpha1.CNIConfig.env:type_name -> google.protobuf.Struct
	57,  // 4: istio.operator.v1alpha1.CNIConfig.podAnnotations:type_name -> google.protobuf.Struct
	19,  // 5: istio.operator.v1alpha1.CNIConfig.logging:type_name -> istio.operator.v1alpha1.GlobalLoggingConfig
	7,   // 6: istio.operator.v1alpha1.CNIConfig.repair:type_name -> istio.operator.v1alpha1.CNIRepairConfig
	54,  // 7: istio.operator.v1alpha1.CNIConfig.chained:type_name -> google.protobuf.BoolValue
	8,   // 8: istio.operator.v1alpha1.CNIConfig.resource_quotas:type_name -> istio.operator.v1alpha1.ResourceQuotas
	10,  // 9: istio.operator.v1alpha1.CNIConfig.resources:type_name -> istio.operator.v1alpha1.Resources
	54,  // 10: istio.operator.v1alpha1.CNIConfig.privileged:type_name -> google.protobuf.BoolValue
	58,  // 11: istio.operator.v1alpha1.CNIConfig.seccompProfile:type_name -> k8s.io.api.core.v1.SeccompProfile
	6,   // 12: istio.operator.v1alpha1.CNIConfig.ambient:type_name -> istio.operator.v1alpha1.CNIAmbientConfig
	48,  // 13: istio.operator.v1alpha1.CNIConfig.rollingMaxUnavailable:type_name -> istio.operator.v1alpha1.IntOrString
	54,  // 14: istio.operator.v1alpha1.CNIConfig.istioOwnedCNIConfig:type_name -> google.protobuf.BoolValue
	54,  // 15: istio.operator.v1alpha1.CNIUsageConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 16: istio.operator.v1alpha1.CNIUsageConfig.chained:type_name -> google.protobuf.BoolValue
	54,  // 17: istio.operator.v1alpha1.CNIAmbientConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 18: istio.operator.v1alpha1.CNIAmbientConfig.dnsCapture:type_name -> google.protobuf.BoolValue
	54,  // 19: istio.operator.v1alpha1.CNIAmbientConfig.ipv6:type_name -> google.protobuf.BoolValue
	54,  // 20: istio.operator.v1alpha1.CNIAmbientConfig.reconcileIptablesOnStartup:type_name -> google.protobuf.BoolValue
	54,  // 21: istio.operator.v1alpha1.CNIRepairConfig.enabled:type_name -> google.protobuf.BoolValue
	55,  // 22: istio.operator.v1alpha1.CNIRepairConfig.tag:type_name -> google.protobuf.Value
	54,  // 23: istio.operator.v1alpha1.ResourceQuotas.enabled:type_name -> google.protobuf.BoolValue
	50,  // 24: istio.operator.v1alpha1.Resources.limits:type_name -> istio.operator.v1alpha1.Resources.LimitsEntry
	51,  // 25: istio.operator.v1alpha1.Resources.requests:type_name -> istio.operator.v1alpha1.Resources.RequestsEntry
	57,  // 26: istio.operator.v1alpha1.ServiceAccount.annotations:type_name -> google.protobuf.Struct
	54,  // 27: istio.operator.v1alpha1.DefaultPodDisruptionBudgetConfig.enabled:type_name -> google.protobuf.BoolValue
	35,  // 28: istio.operator.v1alpha1.DefaultResourcesConfig.requests:type_name -> istio.operator.v1alpha1.ResourcesRequestsConfig
	54,  // 29: istio.operator.v1alpha1.EgressGatewayConfig.autoscaleEnabled:type_name -> google.protobuf.BoolValue
	9,   // 30: istio.operator.v1alpha1.EgressGatewayConfig.memory:type_name -> istio.operator.v1alpha1.TargetUtilizationConfig
	9,   // 31: istio.operator.v1alpha1.EgressGatewayConfig.cpu:type_name -> istio.operator.v1alpha1.TargetUtilizationConfig
	54,  // 32: istio.operator.v1alpha1.EgressGatewayConfig.customService:type_name -> google.protobuf.BoolValue
	54,  // 33: istio.operator.v1alpha1.EgressGatewayConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 34: istio.operator.v1alpha1.EgressGatewayConfig.env:type_name -> google.protobuf.Struct
	52,  // 35: istio.operator.v1alpha1.EgressGatewayConfig.labels:type_name -> istio.operator.v1alpha1.EgressGatewayConfig.LabelsEntry
	57,  // 36: istio.operator.v1alpha1.EgressGatewayConfig.nodeSelector:type_name -> google.protobuf.Struct
	57,  // 37: istio.operator.v1alpha1.EgressGatewayConfig.podAnnotations:type_name -> google.protobuf.Struct
	59,  // 38: istio.operator.v1alpha1.EgressGatewayConfig.podAntiAffinityLabelSelector:type_name -> k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
	59,  // 39: istio.operator.v1alpha1.EgressGatewayConfig.podAntiAffinityTermLabelSelector:type_name -> k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
	31,  // 40: istio.operator.v1alpha1.EgressGatewayConfig.ports:type_name -> istio.operator.v1alpha1.PortsConfig
	10,  // 41: istio.operator.v1alpha1.EgressGatewayConfig.resources:type_name -> istio.operator.v1alpha1.Resources
	37,  // 42: istio.operator.v1alpha1.EgressGatewayConfig.secretVolumes:type_name -> istio.operator.v1alpha1.SecretVolume
	57,  // 43: istio.operator.v1alpha1.EgressGatewayConfig.serviceAnnotations:type_name -> google.protobuf.Struct
	60,  // 44: istio.operator.v1alpha1.EgressGatewayConfig.tolerations:type_name -> k8s.io.api.core.v1.Toleration
	48,  // 45: istio.operator.v1alpha1.EgressGatewayConfig.rollingMaxSurge:type_name -> istio.operator.v1alpha1.IntOrString
	48,  // 46: istio.operator.v1alpha1.EgressGatewayConfig.rollingMaxUnavailable:type_name -> istio.operator.v1alpha1.IntOrString
	57,  // 47: istio.operator.v1alpha1.EgressGatewayConfig.configVolumes:type_name -> google.protobuf.Struct
	57,  // 48: istio.operator.v1alpha1.EgressGatewayConfig.additionalContainers:type_name -> google.protobuf.Struct
	54,  // 49: istio.operator.v1alpha1.EgressGatewayConfig.runAsRoot:type_name -> google.protobuf.BoolValue
	11,  // 50: istio.operator.v1alpha1.EgressGatewayConfig.serviceAccount:type_name -> istio.operator.v1alpha1.ServiceAccount
	14,  // 51: istio.operator.v1alpha1.GatewaysConfig.istio_egressgateway:type_name -> istio.operator.v1alpha1.EgressGatewayConfig
	54,  // 52: istio.operator.v1alpha1.GatewaysConfig.enabled:type_name -> google.protobuf.BoolValue
	20,  // 53: istio.operator.v1alpha1.GatewaysConfig.istio_ingressgateway:type_name -> istio.operator.v1alpha1.IngressGatewayConfig
	55,  // 54: istio.operator.v1alpha1.GatewaysConfig.securityContext:type_name -> google.protobuf.Value
	55,  // 55: istio.operator.v1alpha1.GatewaysConfig.seccompProfile:type_name -> google.protobuf.Value
	3,   // 56: istio.operator.v1alpha1.GlobalConfig.arch:type_name -> istio.operator.v1alpha1.ArchConfig
	54,  // 57: istio.operator.v1alpha1.GlobalConfig.configValidation:type_name -> google.protobuf.BoolValue
	57,  // 58: istio.operator.v1alpha1.GlobalConfig.defaultNodeSelector:type_name -> google.protobuf.Struct
	12,  // 59: istio.operator.v1alpha1.GlobalConfig.defaultPodDisruptionBudget:type_name -> istio.operator.v1alpha1.DefaultPodDisruptionBudgetConfig
	13,  // 60: istio.operator.v1alpha1.GlobalConfig.defaultResources:type_name -> istio.operator.v1alpha1.DefaultResourcesConfig
	60,  // 61: istio.operator.v1alpha1.GlobalConfig.defaultTolerations:type_name -> k8s.io.api.core.v1.Toleration
	54,  // 62: istio.operator.v1alpha1.GlobalConfig.logAsJson:type_name -> google.protobuf.BoolValue
	19,  // 63: istio.operator.v1alpha1.GlobalConfig.logging:type_name -> istio.operator.v1alpha1.GlobalLoggingConfig
	57,  // 64: istio.operator.v1alpha1.GlobalConfig.meshNetworks:type_name -> google.protobuf.Struct
	21,  // 65: istio.operator.v1alpha1.GlobalConfig.multiCluster:type_name -> istio.operator.v1alpha1.MultiClusterConfig
	54,  // 66: istio.operator.v1alpha1.GlobalConfig.omitSidecarInjectorConfigMap:type_name -> google.protobuf.BoolValue
	54,  // 67: istio.operator.v1alpha1.GlobalConfig.operatorManageWebhooks:type_name -> google.protobuf.BoolValue
	32,  // 68: istio.operator.v1alpha1.GlobalConfig.proxy:type_name -> istio.operator.v1alpha1.ProxyConfig
	34,  // 69: istio.operator.v1alpha1.GlobalConfig.proxy_init:type_name -> istio.operator.v1alpha1.ProxyInitConfig
	36,  // 70: istio.operator.v1alpha1.GlobalConfig.sds:type_name -> istio.operator.v1alpha1.SDSConfig
	55,  // 71: istio.operator.v1alpha1.GlobalConfig.tag:type_name -> google.protobuf.Value
	39,  // 72: istio.operator.v1alpha1.GlobalConfig.tracer:type_name -> istio.operator.v1alpha1.TracerConfig
	18,  // 73: istio.operator.v1alpha1.GlobalConfig.istiod:type_name -> istio.operator.v1alpha1.IstiodConfig
	17,  // 74: istio.operator.v1alpha1.GlobalConfig.sts:type_name -> istio.operator.v1alpha1.STSConfig
	54,  // 75: istio.operator.v1alpha1.GlobalConfig.mountMtlsCerts:type_name -> google.protobuf.BoolValue
	54,  // 76: istio.operator.v1alpha1.GlobalConfig.externalIstiod:type_name -> google.protobuf.BoolValue
	54,  // 77: istio.operator.v1alpha1.GlobalConfig.configCluster:type_name -> google.protobuf.BoolValue
	49,  // 78: istio.operator.v1alpha1.GlobalConfig.waypoint:type_name -> istio.operator.v1alpha1.WaypointConfig
	54,  // 79: istio.operator.v1alpha1.GlobalConfig.nativeNftables:type_name -> google.protobuf.BoolValue
	54,  // 80: istio.operator.v1alpha1.IstiodConfig.enableAnalysis:type_name -> google.protobuf.BoolValue
	54,  // 81: istio.operator.v1alpha1.IngressGatewayConfig.autoscaleEnabled:type_name -> google.protobuf.BoolValue
	9,   // 82: istio.operator.v1alpha1.IngressGatewayConfig.memory:type_name -> istio.operator.v1alpha1.TargetUtilizationConfig
	9,   // 83: istio.operator.v1alpha1.IngressGatewayConfig.cpu:type_name -> istio.operator.v1alpha1.TargetUtilizationConfig
	54,  // 84: istio.operator.v1alpha1.IngressGatewayConfig.customService:type_name -> google.protobuf.BoolValue
	54,  // 85: istio.operator.v1alpha1.IngressGatewayConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 86: istio.operator.v1alpha1.IngressGatewayConfig.env:type_name -> google.protobuf.Struct
	53,  // 87: istio.operator.v1alpha1.IngressGatewayConfig.labels:type_name -> istio.operator.v1alpha1.IngressGatewayConfig.LabelsEntry
	57,  // 88: istio.operator.v1alpha1.IngressGatewayConfig.nodeSelector:type_name -> google.protobuf.Struct
	57,  // 89: istio.operator.v1alpha1.IngressGatewayConfig.podAnnotations:type_name -> google.protobuf.Struct
	59,  // 90: istio.operator.v1alpha1.IngressGatewayConfig.podAntiAffinityLabelSelector:type_name -> k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
	59,  // 91: istio.operator.v1alpha1.IngressGatewayConfig.podAntiAffinityTermLabelSelector:type_name -> k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
	31,  // 92: istio.operator.v1alpha1.IngressGatewayConfig.ports:type_name -> istio.operator.v1alpha1.PortsConfig
	57,  // 93: istio.operator.v1alpha1.IngressGatewayConfig.resources:type_name -> google.protobuf.Struct
	37,  // 94: istio.operator.v1alpha1.IngressGatewayConfig.secretVolumes:type_name -> istio.operator.v1alpha1.SecretVolume
	57,  // 95: istio.operator.v1alpha1.IngressGatewayConfig.serviceAnnotations:type_name -> google.protobuf.Struct
	48,  // 96: istio.operator.v1alpha1.IngressGatewayConfig.rollingMaxSurge:type_name -> istio.operator.v1alpha1.IntOrString
	48,  // 97: istio.operator.v1alpha1.IngressGatewayConfig.rollingMaxUnavailable:type_name -> istio.operator.v1alpha1.IntOrString
	60,  // 98: istio.operator.v1alpha1.IngressGatewayConfig.tolerations:type_name -> k8s.io.api.core.v1.Toleration
	57,  // 99: istio.operator.v1alpha1.IngressGatewayConfig.ingressPorts:type_name -> google.protobuf.Struct
	57,  // 100: istio.operator.v1alpha1.IngressGatewayConfig.additionalContainers:type_name -> google.protobuf.Struct
	57,  // 101: istio.operator.v1alpha1.IngressGatewayConfig.configVolumes:type_name -> google.protobuf.Struct
	54,  // 102: istio.operator.v1alpha1.IngressGatewayConfig.runAsRoot:type_name -> google.protobuf.BoolValue
	11,  // 103: istio.operator.v1alpha1.IngressGatewayConfig.serviceAccount:type_name -> istio.operator.v1alpha1.ServiceAccount
	54,  // 104: istio.operator.v1alpha1.MultiClusterConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 105: istio.operator.v1alpha1.MultiClusterConfig.includeEnvoyFilter:type_name -> google.protobuf.BoolValue
	2,   // 106: istio.operator.v1alpha1.OutboundTrafficPolicyConfig.mode:type_name -> istio.operator.v1alpha1.OutboundTrafficPolicyConfig.Mode
	54,  // 107: istio.operator.v1alpha1.PilotConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 108: istio.operator.v1alpha1.PilotConfig.autoscaleEnabled:type_name -> google.protobuf.BoolValue
	57,  // 109: istio.operator.v1alpha1.PilotConfig.autoscaleBehavior:type_name -> google.protobuf.Struct
	10,  // 110: istio.operator.v1alpha1.PilotConfig.resources:type_name -> istio.operator.v1alpha1.Resources
	9,   // 111: istio.operator.v1alpha1.PilotConfig.cpu:type_name -> istio.operator.v1alpha1.TargetUtilizationConfig
	57,  // 112: istio.operator.v1alpha1.PilotConfig.nodeSelector:type_name -> google.protobuf.Struct
	61,  // 113: istio.operator.v1alpha1.PilotConfig.keepaliveMaxServerConnectionAge:type_name -> google.protobuf.Duration
	57,  // 114: istio.operator.v1alpha1.PilotConfig.deploymentLabels:type_name -> google.protobuf.Struct
	57,  // 115: istio.operator.v1alpha1.PilotConfig.podLabels:type_name -> google.protobuf.Struct
	54,  // 116: istio.operator.v1alpha1.PilotConfig.configMap:type_name -> google.protobuf.BoolValue
	57,  // 117: istio.operator.v1alpha1.PilotConfig.env:type_name -> google.protobuf.Struct
	56,  // 118: istio.operator.v1alpha1.PilotConfig.affinity:type_name -> k8s.io.api.core.v1.Affinity
	48,  // 119: istio.operator.v1alpha1.PilotConfig.rollingMaxSurge:type_name -> istio.operator.v1alpha1.IntOrString
	48,  // 120: istio.operator.v1alpha1.PilotConfig.rollingMaxUnavailable:type_name -> istio.operator.v1alpha1.IntOrString
	60,  // 121: istio.operator.v1alpha1.PilotConfig.tolerations:type_name -> k8s.io.api.core.v1.Toleration
	57,  // 122: istio.operator.v1alpha1.PilotConfig.podAnnotations:type_name -> google.protobuf.Struct
	57,  // 123: istio.operator.v1alpha1.PilotConfig.serviceAnnotations:type_name -> google.protobuf.Struct
	57,  // 124: istio.operator.v1alpha1.PilotConfig.serviceAccountAnnotations:type_name -> google.protobuf.Struct
	55,  // 125: istio.operator.v1alpha1.PilotConfig.tag:type_name -> google.protobuf.Value
	58,  // 126: istio.operator.v1alpha1.PilotConfig.seccompProfile:type_name -> k8s.io.api.core.v1.SeccompProfile
	62,  // 127: istio.operator.v1alpha1.PilotConfig.topologySpreadConstraints:type_name -> k8s.io.api.core.v1.TopologySpreadConstraint
	57,  // 128: istio.operator.v1alpha1.PilotConfig.extraContainerArgs:type_name -> google.protobuf.Struct
	63,  // 129: istio.operator.v1alpha1.PilotConfig.volumeMounts:type_name -> k8s.io.api.core.v1.VolumeMount
	64,  // 130: istio.operator.v1alpha1.PilotConfig.volumes:type_name -> k8s.io.api.core.v1.Volume
	9,   // 131: istio.operator.v1alpha1.PilotConfig.memory:type_name -> istio.operator.v1alpha1.TargetUtilizationConfig
	5,   // 132: istio.operator.v1alpha1.PilotConfig.cni:type_name -> istio.operator.v1alpha1.CNIUsageConfig
	24,  // 133: istio.operator.v1alpha1.PilotConfig.taint:type_name -> istio.operator.v1alpha1.PilotTaintControllerConfig
	45,  // 134: istio.operator.v1alpha1.PilotConfig.istiodRemote:type_name -> istio.operator.v1alpha1.IstiodRemoteConfig
	57,  // 135: istio.operator.v1alpha1.PilotConfig.envVarFrom:type_name -> google.protobuf.Struct
	0,   // 136: istio.operator.v1alpha1.PilotIngressConfig.ingressControllerMode:type_name -> istio.operator.v1alpha1.ingressControllerMode
	54,  // 137: istio.operator.v1alpha1.PilotPolicyConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 138: istio.operator.v1alpha1.TelemetryConfig.enabled:type_name -> google.protobuf.BoolValue
	28,  // 139: istio.operator.v1alpha1.TelemetryConfig.v2:type_name -> istio.operator.v1alpha1.TelemetryV2Config
	54,  // 140: istio.operator.v1alpha1.TelemetryV2Config.enabled:type_name -> google.protobuf.BoolValue
	29,  // 141: istio.operator.v1alpha1.TelemetryV2Config.prometheus:type_name -> istio.operator.v1alpha1.TelemetryV2PrometheusConfig
	30,  // 142: istio.operator.v1alpha1.TelemetryV2Config.stackdriver:type_name -> istio.operator.v1alpha1.TelemetryV2StackDriverConfig
	54,  // 143: istio.operator.v1alpha1.TelemetryV2PrometheusConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 144: istio.operator.v1alpha1.TelemetryV2StackDriverConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 145: istio.operator.v1alpha1.ProxyConfig.enableCoreDump:type_name -> google.protobuf.BoolValue
	54,  // 146: istio.operator.v1alpha1.ProxyConfig.privileged:type_name -> google.protobuf.BoolValue
	33,  // 147: istio.operator.v1alpha1.ProxyConfig.startupProbe:type_name -> istio.operator.v1alpha1.StartupProbe
	10,  // 148: istio.operator.v1alpha1.ProxyConfig.resources:type_name -> istio.operator.v1alpha1.Resources
	1,   // 149: istio.operator.v1alpha1.ProxyConfig.tracer:type_name -> istio.operator.v1alpha1.tracer
	65,  // 150: istio.operator.v1alpha1.ProxyConfig.lifecycle:type_name -> k8s.io.api.core.v1.Lifecycle
	54,  // 151: istio.operator.v1alpha1.ProxyConfig.holdApplicationUntilProxyStarts:type_name -> google.protobuf.BoolValue
	54,  // 152: istio.operator.v1alpha1.StartupProbe.enabled:type_name -> google.protobuf.BoolValue
	10,  // 153: istio.operator.v1alpha1.ProxyInitConfig.resources:type_name -> istio.operator.v1alpha1.Resources
	57,  // 154: istio.operator.v1alpha1.SDSConfig.token:type_name -> google.protobuf.Struct
	54,  // 155: istio.operator.v1alpha1.SidecarInjectorConfig.enableNamespacesByDefault:type_name -> google.protobuf.BoolValue
	59,  // 156: istio.operator.v1alpha1.SidecarInjectorConfig.neverInjectSelector:type_name -> k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
	59,  // 157: istio.operator.v1alpha1.SidecarInjectorConfig.alwaysInjectSelector:type_name -> k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
	54,  // 158: istio.operator.v1alpha1.SidecarInjectorConfig.rewriteAppHTTPProbe:type_name -> google.protobuf.BoolValue
	57,  // 159: istio.operator.v1alpha1.SidecarInjectorConfig.injectedAnnotations:type_name -> google.protobuf.Struct
	57,  // 160: istio.operator.v1alpha1.SidecarInjectorConfig.templates:type_name -> google.protobuf.Struct
	40,  // 161: istio.operator.v1alpha1.TracerConfig.datadog:type_name -> istio.operator.v1alpha1.TracerDatadogConfig
	41,  // 162: istio.operator.v1alpha1.TracerConfig.lightstep:type_name -> istio.operator.v1alpha1.TracerLightStepConfig
	42,  // 163: istio.operator.v1alpha1.TracerConfig.zipkin:type_name -> istio.operator.v1alpha1.TracerZipkinConfig
	43,  // 164: istio.operator.v1alpha1.TracerConfig.stackdriver:type_name -> istio.operator.v1alpha1.TracerStackdriverConfig
	54,  // 165: istio.operator.v1alpha1.TracerStackdriverConfig.debug:type_name -> google.protobuf.BoolValue
	54,  // 166: istio.operator.v1alpha1.BaseConfig.enableCRDTemplates:type_name -> google.protobuf.BoolValue
	54,  // 167: istio.operator.v1alpha1.BaseConfig.enableIstioConfigCRDs:type_name -> google.protobuf.BoolValue
	54,  // 168: istio.operator.v1alpha1.BaseConfig.validateGateway:type_name -> google.protobuf.BoolValue
	54,  // 169: istio.operator.v1alpha1.IstiodRemoteConfig.enabled:type_name -> google.protobuf.BoolValue
	54,  // 170: istio.operator.v1alpha1.IstiodRemoteConfig.enabledLocalInjectorIstiod:type_name -> google.protobuf.BoolValue
	4,   // 171: istio.operator.v1alpha1.Values.cni:type_name -> istio.operator.v1alpha1.CNIConfig
	15,  // 172: istio.operator.v1alpha1.Values.gateways:type_name -> istio.operator.v1alpha1.GatewaysConfig
	16,  // 173: istio.operator.v1alpha1.Values.global:type_name -> istio.operator.v1alpha1.GlobalConfig
	23,  // 174: istio.operator.v1alpha1.Values.pilot:type_name -> istio.operator.v1alpha1.PilotConfig
	55,  // 175: istio.operator.v1alpha1.Values.ztunnel:type_name -> google.protobuf.Value
	27,  // 176: istio.operator.v1alpha1.Values.telemetry:type_name -> istio.operator.v1alpha1.TelemetryConfig
	38,  // 177: istio.operator.v1alpha1.Values.sidecarInjectorWebhook:type_name -> istio.operator.v1alpha1.SidecarInjectorConfig
	5,   // 178: istio.operator.v1alpha1.Values.istio_cni:type_name -> istio.operator.v1alpha1.CNIUsageConfig
	55,  // 179: istio.operator.v1alpha1.Values.meshConfig:type_name -> google.protobuf.Value
	44,  // 180: istio.operator.v1alpha1.Values.base:type_name -> istio.operator.v1alpha1.BaseConfig
	45,  // 181: istio.operator.v1alpha1.Values.istiodRemote:type_name -> istio.operator.v1alpha1.IstiodRemoteConfig
	47,  // 182: istio.operator.v1alpha1.Values.experimental:type_name -> istio.operator.v1alpha1.ExperimentalConfig
	55,  // 183: istio.operator.v1alpha1.Values.gatewayClasses:type_name -> google.protobuf.Value
	54,  // 184: istio.operator.v1alpha1.ExperimentalConfig.stableValidationPolicy:type_name -> google.protobuf.BoolValue
	66,  // 185: istio.operator.v1alpha1.IntOrString.intVal:type_name -> google.protobuf.Int32Value
	67,  // 186: istio.operator.v1alpha1.IntOrString.strVal:type_name -> google.protobuf.StringValue
	10,  // 187: istio.operator.v1alpha1.WaypointConfig.resources:type_name -> istio.operator.v1alpha1.Resources
	56,  // 188: istio.operator.v1alpha1.WaypointConfig.affinity:type_name -> k8s.io.api.core.v1.Affinity
	62,  // 189: istio.operator.v1alpha1.WaypointConfig.topologySpreadConstraints:type_name -> k8s.io.api.core.v1.TopologySpreadConstraint
	68,  // 190: istio.operator.v1alpha1.WaypointConfig.nodeSelector:type_name -> k8s.io.api.core.v1.NodeSelector
	60,  // 191: istio.operator.v1alpha1.WaypointConfig.toleration:type_name -> k8s.io.api.core.v1.Toleration
	192, // [192:192] is the sub-list for method output_type
	192, // [192:192] is the sub-list for method input_type
	192, // [192:192] is the sub-list for extension type_name
	192, // [192:192] is the sub-list for extension extendee
	0,   // [0:192] is the sub-list for field type_name
}

func init() { file_pkg_apis_values_types_proto_init() }
func file_pkg_apis_values_types_proto_init() {
	if File_pkg_apis_values_types_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_pkg_apis_values_types_proto_rawDesc), len(file_pkg_apis_values_types_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   51,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pkg_apis_values_types_proto_goTypes,
		DependencyIndexes: file_pkg_apis_values_types_proto_depIdxs,
		EnumInfos:         file_pkg_apis_values_types_proto_enumTypes,
		MessageInfos:      file_pkg_apis_values_types_proto_msgTypes,
	}.Build()
	File_pkg_apis_values_types_proto = out.File
	file_pkg_apis_values_types_proto_goTypes = nil
	file_pkg_apis_values_types_proto_depIdxs = nil
}
