//! # DBus interface proxy for: `org.freedesktop.UDisks2.MDRaid`
//!
//! This code was generated by `zbus-xmlgen` `4.0.0` from DBus introspection data.
//! Source: `org.freedesktop.UDisks2.xml`.
//!
//! You may prefer to adapt it, instead of using it verbatim.
//!
//! More information can be found in the
//! [Writing a client proxy](https://dbus2.github.io/zbus/client.html)
//! section of the zbus documentation.
//!

use zbus::proxy;

use crate::error;

#[proxy(
    interface = "org.freedesktop.UDisks2.MDRaid",
    default_service = "org.freedesktop.UDisks2",
    default_path = "/org/freedesktop/UDisks2/MDRaid"
)]
pub trait MDRaid {
    /// AddDevice method
    fn add_device(
        &self,
        device: &zbus::zvariant::ObjectPath<'_>,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// Delete method
    fn delete(
        &self,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// RemoveDevice method
    fn remove_device(
        &self,
        device: &zbus::zvariant::ObjectPath<'_>,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// RequestSyncAction method
    fn request_sync_action(
        &self,
        sync_action: &str,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// SetBitmapLocation method
    fn set_bitmap_location(
        &self,
        value: &[u8],
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// Start method
    fn start(
        &self,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// Stop method
    fn stop(
        &self,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// ActiveDevices property
    #[zbus(property)]
    #[allow(clippy::type_complexity)]
    fn active_devices(
        &self,
    ) -> error::Result<
        Vec<(
            zbus::zvariant::OwnedObjectPath,
            i32,
            Vec<String>,
            u64,
            std::collections::HashMap<String, zbus::zvariant::OwnedValue>,
        )>,
    >;

    /// BitmapLocation property
    #[zbus(property)]
    fn bitmap_location(&self) -> error::Result<Vec<u8>>;

    /// ChildConfiguration property
    #[zbus(property)]
    fn child_configuration(
        &self,
    ) -> error::Result<
        Vec<(
            String,
            std::collections::HashMap<String, zbus::zvariant::OwnedValue>,
        )>,
    >;

    /// ChunkSize property
    #[zbus(property)]
    fn chunk_size(&self) -> error::Result<u64>;

    /// Degraded property
    #[zbus(property)]
    fn degraded(&self) -> error::Result<u32>;

    /// Level property
    #[zbus(property)]
    fn level(&self) -> error::Result<String>;

    /// Name property
    #[zbus(property)]
    fn name(&self) -> error::Result<String>;

    /// NumDevices property
    #[zbus(property)]
    fn num_devices(&self) -> error::Result<u32>;

    /// Running property
    #[zbus(property)]
    fn running(&self) -> error::Result<bool>;

    /// Size property
    #[zbus(property)]
    fn size(&self) -> error::Result<u64>;

    /// SyncAction property
    #[zbus(property)]
    fn sync_action(&self) -> error::Result<String>;

    /// SyncCompleted property
    #[zbus(property)]
    fn sync_completed(&self) -> error::Result<f64>;

    /// SyncRate property
    #[zbus(property)]
    fn sync_rate(&self) -> error::Result<u64>;

    /// SyncRemainingTime property
    #[zbus(property)]
    fn sync_remaining_time(&self) -> error::Result<u64>;

    /// UUID property
    #[zbus(property, name = "UUID")]
    fn uuid(&self) -> error::Result<String>;
}
