// Generated with hyprwayland-scanner 0.4.5. Made with vaxry's keyboard and ❤️.
// ext_session_lock_v1

/*
 This protocol's authors' copyright notice is:


    Copyright 2021 Isaac Freund

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
  
*/

#pragma once

#include <functional>
#include <cstdint>
#include <string>
#include <wayland-client.h>

#define F std::function

struct wl_proxy;

enum extSessionLockV1Error : uint32_t {
    EXT_SESSION_LOCK_V1_ERROR_INVALID_DESTROY = 0,
    EXT_SESSION_LOCK_V1_ERROR_INVALID_UNLOCK = 1,
    EXT_SESSION_LOCK_V1_ERROR_ROLE = 2,
    EXT_SESSION_LOCK_V1_ERROR_DUPLICATE_OUTPUT = 3,
    EXT_SESSION_LOCK_V1_ERROR_ALREADY_CONSTRUCTED = 4,
};

enum extSessionLockSurfaceV1Error : uint32_t {
    EXT_SESSION_LOCK_SURFACE_V1_ERROR_COMMIT_BEFORE_FIRST_ACK = 0,
    EXT_SESSION_LOCK_SURFACE_V1_ERROR_NULL_BUFFER = 1,
    EXT_SESSION_LOCK_SURFACE_V1_ERROR_DIMENSIONS_MISMATCH = 2,
    EXT_SESSION_LOCK_SURFACE_V1_ERROR_INVALID_SERIAL = 3,
};


class CCExtSessionLockManagerV1;
class CCExtSessionLockV1;
class CCExtSessionLockV1;
class CCExtSessionLockSurfaceV1;
class CCWlSurface;
class CCWlOutput;
class CCExtSessionLockSurfaceV1;

#ifndef HYPRWAYLAND_SCANNER_NO_INTERFACES
extern const wl_interface ext_session_lock_manager_v1_interface;
extern const wl_interface ext_session_lock_v1_interface;
extern const wl_interface ext_session_lock_surface_v1_interface;

#endif


class CCExtSessionLockManagerV1 {
  public:
    CCExtSessionLockManagerV1(wl_proxy*);
    ~CCExtSessionLockManagerV1();


    // set the data for this resource
    void setData(void* data) {{
        pData = data;
    }}

    // get the data for this resource
    void* data() {{
        return pData;
    }}

    // get the raw wl_resource (wl_proxy) ptr
    wl_proxy* resource() {{
        return pResource;
    }}

    // get the raw wl_proxy ptr
    wl_proxy* proxy() {{
        return pResource;
    }}

    // get the resource version
    int version() {{
        return wl_proxy_get_version(pResource);
    }}
            
    // --------------- Requests --------------- //


    // --------------- Events --------------- //

    void sendDestroy();
    wl_proxy* sendLock();

  private:
    struct {
    } requests;

    wl_proxy* pResource = nullptr;

    bool destroyed = false;

    void* pData = nullptr;
};



class CCExtSessionLockV1 {
  public:
    CCExtSessionLockV1(wl_proxy*);
    ~CCExtSessionLockV1();


    // set the data for this resource
    void setData(void* data) {{
        pData = data;
    }}

    // get the data for this resource
    void* data() {{
        return pData;
    }}

    // get the raw wl_resource (wl_proxy) ptr
    wl_proxy* resource() {{
        return pResource;
    }}

    // get the raw wl_proxy ptr
    wl_proxy* proxy() {{
        return pResource;
    }}

    // get the resource version
    int version() {{
        return wl_proxy_get_version(pResource);
    }}
            
    // --------------- Requests --------------- //

    void setLocked(F<void(CCExtSessionLockV1*)> handler);
    void setFinished(F<void(CCExtSessionLockV1*)> handler);

    // --------------- Events --------------- //

    void sendDestroy();
    wl_proxy* sendGetLockSurface(wl_proxy*, wl_proxy*);
    void sendUnlockAndDestroy();

  private:
    struct {
        F<void(CCExtSessionLockV1*)> locked;
        F<void(CCExtSessionLockV1*)> finished;
    } requests;

    wl_proxy* pResource = nullptr;

    bool destroyed = false;

    void* pData = nullptr;
};



class CCExtSessionLockSurfaceV1 {
  public:
    CCExtSessionLockSurfaceV1(wl_proxy*);
    ~CCExtSessionLockSurfaceV1();


    // set the data for this resource
    void setData(void* data) {{
        pData = data;
    }}

    // get the data for this resource
    void* data() {{
        return pData;
    }}

    // get the raw wl_resource (wl_proxy) ptr
    wl_proxy* resource() {{
        return pResource;
    }}

    // get the raw wl_proxy ptr
    wl_proxy* proxy() {{
        return pResource;
    }}

    // get the resource version
    int version() {{
        return wl_proxy_get_version(pResource);
    }}
            
    // --------------- Requests --------------- //

    void setConfigure(F<void(CCExtSessionLockSurfaceV1*, uint32_t, uint32_t, uint32_t)> handler);

    // --------------- Events --------------- //

    void sendDestroy();
    void sendAckConfigure(uint32_t);

  private:
    struct {
        F<void(CCExtSessionLockSurfaceV1*, uint32_t, uint32_t, uint32_t)> configure;
    } requests;

    wl_proxy* pResource = nullptr;

    bool destroyed = false;

    void* pData = nullptr;
};



#undef F
