{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoFontMap@ represents the set of fonts available for a
-- particular rendering system.
-- 
-- This is a virtual object with implementations being specific to
-- particular rendering systems.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Objects.FontMap
    ( 

-- * Exported types
    FontMap(..)                             ,
    IsFontMap                               ,
    toFontMap                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addFontFile]("GI.Pango.Objects.FontMap#g:method:addFontFile"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Pango.Objects.FontMap#g:method:changed"), [createContext]("GI.Pango.Objects.FontMap#g:method:createContext"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [listFamilies]("GI.Pango.Objects.FontMap#g:method:listFamilies"), [loadFont]("GI.Pango.Objects.FontMap#g:method:loadFont"), [loadFontset]("GI.Pango.Objects.FontMap#g:method:loadFontset"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reloadFont]("GI.Pango.Objects.FontMap#g:method:reloadFont"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFamily]("GI.Pango.Objects.FontMap#g:method:getFamily"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSerial]("GI.Pango.Objects.FontMap#g:method:getSerial").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFontMapMethod                    ,
#endif

-- ** addFontFile #method:addFontFile#

#if defined(ENABLE_OVERLOADING)
    FontMapAddFontFileMethodInfo            ,
#endif
    fontMapAddFontFile                      ,


-- ** changed #method:changed#

#if defined(ENABLE_OVERLOADING)
    FontMapChangedMethodInfo                ,
#endif
    fontMapChanged                          ,


-- ** createContext #method:createContext#

#if defined(ENABLE_OVERLOADING)
    FontMapCreateContextMethodInfo          ,
#endif
    fontMapCreateContext                    ,


-- ** getFamily #method:getFamily#

#if defined(ENABLE_OVERLOADING)
    FontMapGetFamilyMethodInfo              ,
#endif
    fontMapGetFamily                        ,


-- ** getSerial #method:getSerial#

#if defined(ENABLE_OVERLOADING)
    FontMapGetSerialMethodInfo              ,
#endif
    fontMapGetSerial                        ,


-- ** listFamilies #method:listFamilies#

#if defined(ENABLE_OVERLOADING)
    FontMapListFamiliesMethodInfo           ,
#endif
    fontMapListFamilies                     ,


-- ** loadFont #method:loadFont#

#if defined(ENABLE_OVERLOADING)
    FontMapLoadFontMethodInfo               ,
#endif
    fontMapLoadFont                         ,


-- ** loadFontset #method:loadFontset#

#if defined(ENABLE_OVERLOADING)
    FontMapLoadFontsetMethodInfo            ,
#endif
    fontMapLoadFontset                      ,


-- ** reloadFont #method:reloadFont#

#if defined(ENABLE_OVERLOADING)
    FontMapReloadFontMethodInfo             ,
#endif
    fontMapReloadFont                       ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items contained in this list.
-- 
-- /Since: 1.52/

#if defined(ENABLE_OVERLOADING)
    FontMapItemTypePropertyInfo             ,
#endif
#if defined(ENABLE_OVERLOADING)
    fontMapItemType                         ,
#endif
    getFontMapItemType                      ,


-- ** nItems #attr:nItems#
-- | The number of items contained in this list.
-- 
-- /Since: 1.52/

#if defined(ENABLE_OVERLOADING)
    FontMapNItemsPropertyInfo               ,
#endif
#if defined(ENABLE_OVERLOADING)
    fontMapNItems                           ,
#endif
    getFontMapNItems                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language

#endif

-- | Memory-managed wrapper type.
newtype FontMap = FontMap (SP.ManagedPtr FontMap)
    deriving (Eq)

instance SP.ManagedPtrNewtype FontMap where
    toManagedPtr (FontMap p) = p

foreign import ccall "pango_font_map_get_type"
    c_pango_font_map_get_type :: IO B.Types.GType

instance B.Types.TypedObject FontMap where
    glibType = c_pango_font_map_get_type

instance B.Types.GObject FontMap

-- | Type class for types which can be safely cast to t'FontMap', for instance with `toFontMap`.
class (SP.GObject o, O.IsDescendantOf FontMap o) => IsFontMap o
instance (SP.GObject o, O.IsDescendantOf FontMap o) => IsFontMap o

instance O.HasParentTypes FontMap
type instance O.ParentTypes FontMap = '[GObject.Object.Object, Gio.ListModel.ListModel]

-- | Cast to t'FontMap', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFontMap :: (MIO.MonadIO m, IsFontMap o) => o -> m FontMap
toFontMap = MIO.liftIO . B.ManagedPtr.unsafeCastTo FontMap

-- | Convert t'FontMap' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FontMap) where
    gvalueGType_ = c_pango_font_map_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FontMap)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FontMap)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FontMap ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFontMapMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontMapMethod "addFontFile" o = FontMapAddFontFileMethodInfo
    ResolveFontMapMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFontMapMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFontMapMethod "changed" o = FontMapChangedMethodInfo
    ResolveFontMapMethod "createContext" o = FontMapCreateContextMethodInfo
    ResolveFontMapMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFontMapMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFontMapMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFontMapMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFontMapMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveFontMapMethod "listFamilies" o = FontMapListFamiliesMethodInfo
    ResolveFontMapMethod "loadFont" o = FontMapLoadFontMethodInfo
    ResolveFontMapMethod "loadFontset" o = FontMapLoadFontsetMethodInfo
    ResolveFontMapMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFontMapMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFontMapMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFontMapMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFontMapMethod "reloadFont" o = FontMapReloadFontMethodInfo
    ResolveFontMapMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFontMapMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFontMapMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFontMapMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFontMapMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFontMapMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFontMapMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFontMapMethod "getFamily" o = FontMapGetFamilyMethodInfo
    ResolveFontMapMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveFontMapMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveFontMapMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveFontMapMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFontMapMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFontMapMethod "getSerial" o = FontMapGetSerialMethodInfo
    ResolveFontMapMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFontMapMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFontMapMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFontMapMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontMapMethod t FontMap, O.OverloadedMethod info FontMap p) => OL.IsLabel t (FontMap -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontMapMethod t FontMap, O.OverloadedMethod info FontMap p, R.HasField t FontMap p) => R.HasField t FontMap p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontMapMethod t FontMap, O.OverloadedMethodInfo info FontMap) => OL.IsLabel t (O.MethodProxy info FontMap) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontMap #itemType
-- @
getFontMapItemType :: (MonadIO m, IsFontMap o) => o -> m GType
getFontMapItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data FontMapItemTypePropertyInfo
instance AttrInfo FontMapItemTypePropertyInfo where
    type AttrAllowedOps FontMapItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FontMapItemTypePropertyInfo = IsFontMap
    type AttrSetTypeConstraint FontMapItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FontMapItemTypePropertyInfo = (~) ()
    type AttrTransferType FontMapItemTypePropertyInfo = ()
    type AttrGetType FontMapItemTypePropertyInfo = GType
    type AttrLabel FontMapItemTypePropertyInfo = "item-type"
    type AttrOrigin FontMapItemTypePropertyInfo = FontMap
    attrGet = getFontMapItemType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#g:attr:itemType"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontMap #nItems
-- @
getFontMapNItems :: (MonadIO m, IsFontMap o) => o -> m Word32
getFontMapNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data FontMapNItemsPropertyInfo
instance AttrInfo FontMapNItemsPropertyInfo where
    type AttrAllowedOps FontMapNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FontMapNItemsPropertyInfo = IsFontMap
    type AttrSetTypeConstraint FontMapNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint FontMapNItemsPropertyInfo = (~) ()
    type AttrTransferType FontMapNItemsPropertyInfo = ()
    type AttrGetType FontMapNItemsPropertyInfo = Word32
    type AttrLabel FontMapNItemsPropertyInfo = "n-items"
    type AttrOrigin FontMapNItemsPropertyInfo = FontMap
    attrGet = getFontMapNItems
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FontMap
type instance O.AttributeList FontMap = FontMapAttributeList
type FontMapAttributeList = ('[ '("itemType", FontMapItemTypePropertyInfo), '("nItems", FontMapNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fontMapItemType :: AttrLabelProxy "itemType"
fontMapItemType = AttrLabelProxy

fontMapNItems :: AttrLabelProxy "nItems"
fontMapNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FontMap = FontMapSignalList
type FontMapSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FontMap::add_font_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Path to the font file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "pango_font_map_add_font_file" pango_font_map_add_font_file :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    CString ->                              -- filename : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Loads a font file with one or more fonts into the @PangoFontMap@.
-- 
-- The added fonts will take precedence over preexisting
-- fonts with the same name.
-- 
-- /Since: 1.56/
fontMapAddFontFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> [Char]
    -- ^ /@filename@/: Path to the font file
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fontMapAddFontFile fontmap filename = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    filename' <- stringToCString filename
    onException (do
        _ <- propagateGError $ pango_font_map_add_font_file fontmap' filename'
        touchManagedPtr fontmap
        freeMem filename'
        return ()
     ) (do
        freeMem filename'
     )

#if defined(ENABLE_OVERLOADING)
data FontMapAddFontFileMethodInfo
instance (signature ~ ([Char] -> m ()), MonadIO m, IsFontMap a) => O.OverloadedMethod FontMapAddFontFileMethodInfo a signature where
    overloadedMethod = fontMapAddFontFile

instance O.OverloadedMethodInfo FontMapAddFontFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapAddFontFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapAddFontFile"
        })


#endif

-- method FontMap::changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_changed" pango_font_map_changed :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    IO ()

-- | Forces a change in the fontmap, which will cause any @PangoContext@
-- using this fontmap to change.
-- 
-- This function is only useful when implementing a new backend
-- for Pango, something applications won\'t do. Backends should
-- call this function if they have attached extra data to the
-- fontmap and such data is changed.
-- 
-- /Since: 1.34/
fontMapChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> m ()
fontMapChanged fontmap = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    pango_font_map_changed fontmap'
    touchManagedPtr fontmap
    return ()

#if defined(ENABLE_OVERLOADING)
data FontMapChangedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsFontMap a) => O.OverloadedMethod FontMapChangedMethodInfo a signature where
    overloadedMethod = fontMapChanged

instance O.OverloadedMethodInfo FontMapChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapChanged"
        })


#endif

-- method FontMap::create_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_create_context" pango_font_map_create_context :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    IO (Ptr Pango.Context.Context)

-- | Creates a @PangoContext@ connected to /@fontmap@/.
-- 
-- This is equivalent to 'GI.Pango.Objects.Context.contextNew' followed by
-- 'GI.Pango.Objects.Context.contextSetFontMap'.
-- 
-- If you are using Pango as part of a higher-level system,
-- that system may have it\'s own way of create a @PangoContext@.
-- For instance, the GTK toolkit has, among others,
-- @/gtk_widget_get_pango_context()/@. Use those instead.
-- 
-- /Since: 1.22/
fontMapCreateContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> m Pango.Context.Context
    -- ^ __Returns:__ the newly allocated @PangoContext@,
    --   which should be freed with 'GI.GObject.Objects.Object.objectUnref'.
fontMapCreateContext fontmap = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    result <- pango_font_map_create_context fontmap'
    checkUnexpectedReturnNULL "fontMapCreateContext" result
    result' <- (wrapObject Pango.Context.Context) result
    touchManagedPtr fontmap
    return result'

#if defined(ENABLE_OVERLOADING)
data FontMapCreateContextMethodInfo
instance (signature ~ (m Pango.Context.Context), MonadIO m, IsFontMap a) => O.OverloadedMethod FontMapCreateContextMethodInfo a signature where
    overloadedMethod = fontMapCreateContext

instance O.OverloadedMethodInfo FontMapCreateContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapCreateContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapCreateContext"
        })


#endif

-- method FontMap::get_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a family name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "FontFamily" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_get_family" pango_font_map_get_family :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Pango.FontFamily.FontFamily)

-- | Gets a font family by name.
-- 
-- /Since: 1.46/
fontMapGetFamily ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> T.Text
    -- ^ /@name@/: a family name
    -> m Pango.FontFamily.FontFamily
    -- ^ __Returns:__ the @PangoFontFamily@
fontMapGetFamily fontmap name = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    name' <- textToCString name
    result <- pango_font_map_get_family fontmap' name'
    checkUnexpectedReturnNULL "fontMapGetFamily" result
    result' <- (newObject Pango.FontFamily.FontFamily) result
    touchManagedPtr fontmap
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
data FontMapGetFamilyMethodInfo
instance (signature ~ (T.Text -> m Pango.FontFamily.FontFamily), MonadIO m, IsFontMap a) => O.OverloadedMethod FontMapGetFamilyMethodInfo a signature where
    overloadedMethod = fontMapGetFamily

instance O.OverloadedMethodInfo FontMapGetFamilyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapGetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapGetFamily"
        })


#endif

-- method FontMap::get_serial
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_get_serial" pango_font_map_get_serial :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    IO Word32

-- | Returns the current serial number of /@fontmap@/.
-- 
-- The serial number is initialized to an small number larger than zero
-- when a new fontmap is created and is increased whenever the fontmap
-- is changed. It may wrap, but will never have the value 0. Since it can
-- wrap, never compare it with \"less than\", always use \"not equals\".
-- 
-- The fontmap can only be changed using backend-specific API, like changing
-- fontmap resolution.
-- 
-- This can be used to automatically detect changes to a @PangoFontMap@,
-- like in @PangoContext@.
-- 
-- /Since: 1.32.4/
fontMapGetSerial ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> m Word32
    -- ^ __Returns:__ The current serial number of /@fontmap@/.
fontMapGetSerial fontmap = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    result <- pango_font_map_get_serial fontmap'
    touchManagedPtr fontmap
    return result

#if defined(ENABLE_OVERLOADING)
data FontMapGetSerialMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsFontMap a) => O.OverloadedMethod FontMapGetSerialMethodInfo a signature where
    overloadedMethod = fontMapGetSerial

instance O.OverloadedMethodInfo FontMapGetSerialMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapGetSerial",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapGetSerial"
        })


#endif

-- method FontMap::list_families
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "families"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Pango" , name = "FontFamily" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to\n  store a pointer to an array of `PangoFontFamily` *.\n  This array should be freed with g_free()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferContainer
--           }
--       , Arg
--           { argCName = "n_families"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the number of elements in @families"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_families"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "location to store the number of elements in @families"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_list_families" pango_font_map_list_families :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    Ptr (Ptr (Ptr Pango.FontFamily.FontFamily)) -> -- families : TCArray False (-1) 2 (TInterface (Name {namespace = "Pango", name = "FontFamily"}))
    Ptr Int32 ->                            -- n_families : TBasicType TInt
    IO ()

-- | List all families for a fontmap.
-- 
-- Note that the returned families are not in any particular order.
-- 
-- @PangoFontMap@ also implemented the t'GI.Gio.Interfaces.ListModel.ListModel' interface
-- for enumerating families.
fontMapListFamilies ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> m ([Pango.FontFamily.FontFamily])
fontMapListFamilies fontmap = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    families <- callocMem :: IO (Ptr (Ptr (Ptr Pango.FontFamily.FontFamily)))
    nFamilies <- allocMem :: IO (Ptr Int32)
    pango_font_map_list_families fontmap' families nFamilies
    nFamilies' <- peek nFamilies
    families' <- peek families
    families'' <- (unpackPtrArrayWithLength nFamilies') families'
    families''' <- mapM (newObject Pango.FontFamily.FontFamily) families''
    freeMem families'
    touchManagedPtr fontmap
    freeMem families
    freeMem nFamilies
    return families'''

#if defined(ENABLE_OVERLOADING)
data FontMapListFamiliesMethodInfo
instance (signature ~ (m ([Pango.FontFamily.FontFamily])), MonadIO m, IsFontMap a) => O.OverloadedMethod FontMapListFamiliesMethodInfo a signature where
    overloadedMethod = fontMapListFamilies

instance O.OverloadedMethodInfo FontMapListFamiliesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapListFamilies",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapListFamilies"
        })


#endif

-- method FontMap::load_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `PangoContext` the font will be used with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `PangoFontDescription` describing the font to load"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Font" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_load_font" pango_font_map_load_font :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    Ptr Pango.Context.Context ->            -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO (Ptr Pango.Font.Font)

-- | Load the font in the fontmap that is the closest match for /@desc@/.
fontMapLoadFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a, Pango.Context.IsContext b) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> b
    -- ^ /@context@/: the @PangoContext@ the font will be used with
    -> Pango.FontDescription.FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@ describing the font to load
    -> m (Maybe Pango.Font.Font)
    -- ^ __Returns:__ the newly allocated @PangoFont@
    --   loaded, or 'P.Nothing' if no font matched.
fontMapLoadFont fontmap context desc = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    context' <- unsafeManagedPtrCastPtr context
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_font_map_load_font fontmap' context' desc'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Pango.Font.Font) result'
        return result''
    touchManagedPtr fontmap
    touchManagedPtr context
    touchManagedPtr desc
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontMapLoadFontMethodInfo
instance (signature ~ (b -> Pango.FontDescription.FontDescription -> m (Maybe Pango.Font.Font)), MonadIO m, IsFontMap a, Pango.Context.IsContext b) => O.OverloadedMethod FontMapLoadFontMethodInfo a signature where
    overloadedMethod = fontMapLoadFont

instance O.OverloadedMethodInfo FontMapLoadFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapLoadFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapLoadFont"
        })


#endif

-- method FontMap::load_fontset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `PangoContext` the font will be used with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `PangoFontDescription` describing the font to load"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLanguage` the fonts will be used for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Fontset" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_load_fontset" pango_font_map_load_fontset :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    Ptr Pango.Context.Context ->            -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr Pango.Language.Language ->          -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    IO (Ptr Pango.Fontset.Fontset)

-- | Load a set of fonts in the fontmap that can be used to render
-- a font matching /@desc@/.
fontMapLoadFontset ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a, Pango.Context.IsContext b) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> b
    -- ^ /@context@/: the @PangoContext@ the font will be used with
    -> Pango.FontDescription.FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@ describing the font to load
    -> Pango.Language.Language
    -- ^ /@language@/: a @PangoLanguage@ the fonts will be used for
    -> m (Maybe Pango.Fontset.Fontset)
    -- ^ __Returns:__ the newly allocated
    --   @PangoFontset@ loaded, or 'P.Nothing' if no font matched.
fontMapLoadFontset fontmap context desc language = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    context' <- unsafeManagedPtrCastPtr context
    desc' <- unsafeManagedPtrGetPtr desc
    language' <- unsafeManagedPtrGetPtr language
    result <- pango_font_map_load_fontset fontmap' context' desc' language'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Pango.Fontset.Fontset) result'
        return result''
    touchManagedPtr fontmap
    touchManagedPtr context
    touchManagedPtr desc
    touchManagedPtr language
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontMapLoadFontsetMethodInfo
instance (signature ~ (b -> Pango.FontDescription.FontDescription -> Pango.Language.Language -> m (Maybe Pango.Fontset.Fontset)), MonadIO m, IsFontMap a, Pango.Context.IsContext b) => O.OverloadedMethod FontMapLoadFontsetMethodInfo a signature where
    overloadedMethod = fontMapLoadFontset

instance O.OverloadedMethodInfo FontMapLoadFontsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapLoadFontset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapLoadFontset"
        })


#endif

-- method FontMap::reload_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fontmap"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontMap`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType = TInterface Name { namespace = "Pango" , name = "Font" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a font in @fontmap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the scale factor to apply"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variations"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "font variations to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Font" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_font_map_reload_font" pango_font_map_reload_font :: 
    Ptr FontMap ->                          -- fontmap : TInterface (Name {namespace = "Pango", name = "FontMap"})
    Ptr Pango.Font.Font ->                  -- font : TInterface (Name {namespace = "Pango", name = "Font"})
    CDouble ->                              -- scale : TBasicType TDouble
    Ptr Pango.Context.Context ->            -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    CString ->                              -- variations : TBasicType TUTF8
    IO (Ptr Pango.Font.Font)

-- | Returns a new font that is like /@font@/, except that it is scaled
-- by /@scale@/, its backend-dependent configuration (e.g. cairo font options)
-- is replaced by the one in /@context@/, and its variations are replaced
-- by /@variations@/.
-- 
-- Note that the scaling here is meant to be linear, so this
-- scaling can be used to render a font on a hi-dpi display
-- without changing its optical size.
-- 
-- /Since: 1.52/
fontMapReloadFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontMap a, Pango.Font.IsFont b, Pango.Context.IsContext c) =>
    a
    -- ^ /@fontmap@/: a @PangoFontMap@
    -> b
    -- ^ /@font@/: a font in /@fontmap@/
    -> Double
    -- ^ /@scale@/: the scale factor to apply
    -> Maybe (c)
    -- ^ /@context@/: a @PangoContext@
    -> Maybe (T.Text)
    -- ^ /@variations@/: font variations to use
    -> m Pango.Font.Font
    -- ^ __Returns:__ the modified font
fontMapReloadFont fontmap font scale context variations = liftIO $ do
    fontmap' <- unsafeManagedPtrCastPtr fontmap
    font' <- unsafeManagedPtrCastPtr font
    let scale' = realToFrac scale
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrCastPtr jContext
            return jContext'
    maybeVariations <- case variations of
        Nothing -> return FP.nullPtr
        Just jVariations -> do
            jVariations' <- textToCString jVariations
            return jVariations'
    result <- pango_font_map_reload_font fontmap' font' scale' maybeContext maybeVariations
    checkUnexpectedReturnNULL "fontMapReloadFont" result
    result' <- (wrapObject Pango.Font.Font) result
    touchManagedPtr fontmap
    touchManagedPtr font
    whenJust context touchManagedPtr
    freeMem maybeVariations
    return result'

#if defined(ENABLE_OVERLOADING)
data FontMapReloadFontMethodInfo
instance (signature ~ (b -> Double -> Maybe (c) -> Maybe (T.Text) -> m Pango.Font.Font), MonadIO m, IsFontMap a, Pango.Font.IsFont b, Pango.Context.IsContext c) => O.OverloadedMethod FontMapReloadFontMethodInfo a signature where
    overloadedMethod = fontMapReloadFont

instance O.OverloadedMethodInfo FontMapReloadFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.FontMap.fontMapReloadFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-FontMap.html#v:fontMapReloadFont"
        })


#endif


