{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The structure that holds various text properties of an t'GI.HarfBuzz.Structs.BufferT.BufferT'. Can be
-- set and retrieved using 'GI.HarfBuzz.Functions.bufferSetSegmentProperties' and
-- 'GI.HarfBuzz.Functions.bufferGetSegmentProperties', respectively.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.SegmentPropertiesT
    ( 

-- * Exported types
    SegmentPropertiesT(..)                  ,
    newZeroSegmentPropertiesT               ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveSegmentPropertiesTMethod         ,
#endif



 -- * Properties


-- ** direction #attr:direction#
-- | the t'GI.HarfBuzz.Enums.DirectionT' of the buffer, see 'GI.HarfBuzz.Functions.bufferSetDirection'.

    getSegmentPropertiesTDirection          ,
#if defined(ENABLE_OVERLOADING)
    segmentPropertiesT_direction            ,
#endif
    setSegmentPropertiesTDirection          ,


-- ** language #attr:language#
-- | the t'GI.HarfBuzz.Structs.LanguageT.LanguageT' of the buffer, see 'GI.HarfBuzz.Functions.bufferSetLanguage'.

    getSegmentPropertiesTLanguage           ,
#if defined(ENABLE_OVERLOADING)
    segmentPropertiesT_language             ,
#endif


-- ** script #attr:script#
-- | the t'GI.HarfBuzz.Enums.ScriptT' of the buffer, see 'GI.HarfBuzz.Functions.bufferSetScript'.

    getSegmentPropertiesTScript             ,
#if defined(ENABLE_OVERLOADING)
    segmentPropertiesT_script               ,
#endif
    setSegmentPropertiesTScript             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.HarfBuzz.Enums as HarfBuzz.Enums
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.LanguageT as HarfBuzz.LanguageT

#else
import {-# SOURCE #-} qualified GI.HarfBuzz.Enums as HarfBuzz.Enums
import {-# SOURCE #-} qualified GI.HarfBuzz.Structs.LanguageT as HarfBuzz.LanguageT

#endif

-- | Memory-managed wrapper type.
newtype SegmentPropertiesT = SegmentPropertiesT (SP.ManagedPtr SegmentPropertiesT)
    deriving (Eq)

instance SP.ManagedPtrNewtype SegmentPropertiesT where
    toManagedPtr (SegmentPropertiesT p) = p

foreign import ccall "hb_gobject_segment_properties_get_type" c_hb_gobject_segment_properties_get_type :: 
    IO GType

type instance O.ParentTypes SegmentPropertiesT = '[]
instance O.HasParentTypes SegmentPropertiesT

instance B.Types.TypedObject SegmentPropertiesT where
    glibType = c_hb_gobject_segment_properties_get_type

instance B.Types.GBoxed SegmentPropertiesT

-- | Convert t'SegmentPropertiesT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SegmentPropertiesT) where
    gvalueGType_ = c_hb_gobject_segment_properties_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr SegmentPropertiesT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr SegmentPropertiesT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed SegmentPropertiesT ptr
        else return P.Nothing
        
    

-- | Construct a t'SegmentPropertiesT' struct initialized to zero.
newZeroSegmentPropertiesT :: MonadIO m => m SegmentPropertiesT
newZeroSegmentPropertiesT = liftIO $ callocBoxedBytes 32 >>= wrapBoxed SegmentPropertiesT

instance tag ~ 'AttrSet => Constructible SegmentPropertiesT tag where
    new _ attrs = do
        o <- newZeroSegmentPropertiesT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@direction@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' segmentPropertiesT #direction
-- @
getSegmentPropertiesTDirection :: MonadIO m => SegmentPropertiesT -> m HarfBuzz.Enums.DirectionT
getSegmentPropertiesTDirection s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@direction@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' segmentPropertiesT [ #direction 'Data.GI.Base.Attributes.:=' value ]
-- @
setSegmentPropertiesTDirection :: MonadIO m => SegmentPropertiesT -> HarfBuzz.Enums.DirectionT -> m ()
setSegmentPropertiesTDirection s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data SegmentPropertiesTDirectionFieldInfo
instance AttrInfo SegmentPropertiesTDirectionFieldInfo where
    type AttrBaseTypeConstraint SegmentPropertiesTDirectionFieldInfo = (~) SegmentPropertiesT
    type AttrAllowedOps SegmentPropertiesTDirectionFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SegmentPropertiesTDirectionFieldInfo = (~) HarfBuzz.Enums.DirectionT
    type AttrTransferTypeConstraint SegmentPropertiesTDirectionFieldInfo = (~)HarfBuzz.Enums.DirectionT
    type AttrTransferType SegmentPropertiesTDirectionFieldInfo = HarfBuzz.Enums.DirectionT
    type AttrGetType SegmentPropertiesTDirectionFieldInfo = HarfBuzz.Enums.DirectionT
    type AttrLabel SegmentPropertiesTDirectionFieldInfo = "direction"
    type AttrOrigin SegmentPropertiesTDirectionFieldInfo = SegmentPropertiesT
    attrGet = getSegmentPropertiesTDirection
    attrSet = setSegmentPropertiesTDirection
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.SegmentPropertiesT.direction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-SegmentPropertiesT.html#g:attr:direction"
        })

segmentPropertiesT_direction :: AttrLabelProxy "direction"
segmentPropertiesT_direction = AttrLabelProxy

#endif


-- | Get the value of the “@script@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' segmentPropertiesT #script
-- @
getSegmentPropertiesTScript :: MonadIO m => SegmentPropertiesT -> m HarfBuzz.Enums.ScriptT
getSegmentPropertiesTScript s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@script@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' segmentPropertiesT [ #script 'Data.GI.Base.Attributes.:=' value ]
-- @
setSegmentPropertiesTScript :: MonadIO m => SegmentPropertiesT -> HarfBuzz.Enums.ScriptT -> m ()
setSegmentPropertiesTScript s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 4) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data SegmentPropertiesTScriptFieldInfo
instance AttrInfo SegmentPropertiesTScriptFieldInfo where
    type AttrBaseTypeConstraint SegmentPropertiesTScriptFieldInfo = (~) SegmentPropertiesT
    type AttrAllowedOps SegmentPropertiesTScriptFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SegmentPropertiesTScriptFieldInfo = (~) HarfBuzz.Enums.ScriptT
    type AttrTransferTypeConstraint SegmentPropertiesTScriptFieldInfo = (~)HarfBuzz.Enums.ScriptT
    type AttrTransferType SegmentPropertiesTScriptFieldInfo = HarfBuzz.Enums.ScriptT
    type AttrGetType SegmentPropertiesTScriptFieldInfo = HarfBuzz.Enums.ScriptT
    type AttrLabel SegmentPropertiesTScriptFieldInfo = "script"
    type AttrOrigin SegmentPropertiesTScriptFieldInfo = SegmentPropertiesT
    attrGet = getSegmentPropertiesTScript
    attrSet = setSegmentPropertiesTScript
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.SegmentPropertiesT.script"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-SegmentPropertiesT.html#g:attr:script"
        })

segmentPropertiesT_script :: AttrLabelProxy "script"
segmentPropertiesT_script = AttrLabelProxy

#endif


-- | Get the value of the “@language@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' segmentPropertiesT #language
-- @
getSegmentPropertiesTLanguage :: MonadIO m => SegmentPropertiesT -> m HarfBuzz.LanguageT.LanguageT
getSegmentPropertiesTLanguage s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 8 :: (Ptr HarfBuzz.LanguageT.LanguageT)
    val' <- (newPtr HarfBuzz.LanguageT.LanguageT) val
    return val'

#if defined(ENABLE_OVERLOADING)
data SegmentPropertiesTLanguageFieldInfo
instance AttrInfo SegmentPropertiesTLanguageFieldInfo where
    type AttrBaseTypeConstraint SegmentPropertiesTLanguageFieldInfo = (~) SegmentPropertiesT
    type AttrAllowedOps SegmentPropertiesTLanguageFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint SegmentPropertiesTLanguageFieldInfo = (~) (Ptr HarfBuzz.LanguageT.LanguageT)
    type AttrTransferTypeConstraint SegmentPropertiesTLanguageFieldInfo = (~)(Ptr HarfBuzz.LanguageT.LanguageT)
    type AttrTransferType SegmentPropertiesTLanguageFieldInfo = (Ptr HarfBuzz.LanguageT.LanguageT)
    type AttrGetType SegmentPropertiesTLanguageFieldInfo = HarfBuzz.LanguageT.LanguageT
    type AttrLabel SegmentPropertiesTLanguageFieldInfo = "language"
    type AttrOrigin SegmentPropertiesTLanguageFieldInfo = SegmentPropertiesT
    attrGet = getSegmentPropertiesTLanguage
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.SegmentPropertiesT.language"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-SegmentPropertiesT.html#g:attr:language"
        })

segmentPropertiesT_language :: AttrLabelProxy "language"
segmentPropertiesT_language = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SegmentPropertiesT
type instance O.AttributeList SegmentPropertiesT = SegmentPropertiesTAttributeList
type SegmentPropertiesTAttributeList = ('[ '("direction", SegmentPropertiesTDirectionFieldInfo), '("script", SegmentPropertiesTScriptFieldInfo), '("language", SegmentPropertiesTLanguageFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSegmentPropertiesTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSegmentPropertiesTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSegmentPropertiesTMethod t SegmentPropertiesT, O.OverloadedMethod info SegmentPropertiesT p) => OL.IsLabel t (SegmentPropertiesT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSegmentPropertiesTMethod t SegmentPropertiesT, O.OverloadedMethod info SegmentPropertiesT p, R.HasField t SegmentPropertiesT p) => R.HasField t SegmentPropertiesT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSegmentPropertiesTMethod t SegmentPropertiesT, O.OverloadedMethodInfo info SegmentPropertiesT) => OL.IsLabel t (O.MethodProxy info SegmentPropertiesT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


