{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Wraps a list of references to t'GI.Gtk.Interfaces.Accessible.Accessible' objects.
-- 
-- /Since: 4.14/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.AccessibleList
    ( 

-- * Exported types
    AccessibleList(..)                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getObjects]("GI.Gtk.Structs.AccessibleList#g:method:getObjects").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveAccessibleListMethod             ,
#endif

-- ** getObjects #method:getObjects#

#if defined(ENABLE_OVERLOADING)
    AccessibleListGetObjectsMethodInfo      ,
#endif
    accessibleListGetObjects                ,


-- ** newFromArray #method:newFromArray#

    accessibleListNewFromArray              ,


-- ** newFromList #method:newFromList#

    accessibleListNewFromList               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext

#else
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible

#endif

-- | Memory-managed wrapper type.
newtype AccessibleList = AccessibleList (SP.ManagedPtr AccessibleList)
    deriving (Eq)

instance SP.ManagedPtrNewtype AccessibleList where
    toManagedPtr (AccessibleList p) = p

foreign import ccall "gtk_accessible_list_get_type" c_gtk_accessible_list_get_type :: 
    IO GType

type instance O.ParentTypes AccessibleList = '[]
instance O.HasParentTypes AccessibleList

instance B.Types.TypedObject AccessibleList where
    glibType = c_gtk_accessible_list_get_type

instance B.Types.GBoxed AccessibleList

-- | Convert t'AccessibleList' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AccessibleList) where
    gvalueGType_ = c_gtk_accessible_list_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr AccessibleList)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr AccessibleList)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed AccessibleList ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AccessibleList
type instance O.AttributeList AccessibleList = AccessibleListAttributeList
type AccessibleListAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method AccessibleList::new_from_array
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "accessibles"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Gtk" , name = "Accessible" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "array of accessible objects"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_accessibles"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of the @accessibles array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_accessibles"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "length of the @accessibles array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "AccessibleList" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accessible_list_new_from_array" gtk_accessible_list_new_from_array :: 
    Ptr (Ptr Gtk.Accessible.Accessible) ->  -- accessibles : TCArray False (-1) 1 (TInterface (Name {namespace = "Gtk", name = "Accessible"}))
    FCT.CSize ->                            -- n_accessibles : TBasicType TSize
    IO (Ptr AccessibleList)

-- | Allocates a new list of accessible objects.
-- 
-- /Since: 4.14/
accessibleListNewFromArray ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Gtk.Accessible.Accessible]
    -- ^ /@accessibles@/: array of accessible objects
    -> m AccessibleList
    -- ^ __Returns:__ the newly created list of accessible objects
accessibleListNewFromArray accessibles = liftIO $ do
    let nAccessibles = fromIntegral $ P.length accessibles
    accessibles' <- mapM unsafeManagedPtrCastPtr accessibles
    accessibles'' <- packPtrArray accessibles'
    result <- gtk_accessible_list_new_from_array accessibles'' nAccessibles
    checkUnexpectedReturnNULL "accessibleListNewFromArray" result
    result' <- (wrapBoxed AccessibleList) result
    mapM_ touchManagedPtr accessibles
    freeMem accessibles''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AccessibleList::new_from_list
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TGList
--                 (TInterface Name { namespace = "Gtk" , name = "Accessible" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a list\n  of accessible objects"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "AccessibleList" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accessible_list_new_from_list" gtk_accessible_list_new_from_list :: 
    Ptr (GList (Ptr Gtk.Accessible.Accessible)) -> -- list : TGList (TInterface (Name {namespace = "Gtk", name = "Accessible"}))
    IO (Ptr AccessibleList)

-- | Allocates a new @GtkAccessibleList@, doing a shallow copy
-- of the passed list of accessible objects
-- 
-- /Since: 4.14/
accessibleListNewFromList ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Accessible.IsAccessible a) =>
    [a]
    -- ^ /@list@/: a list
    --   of accessible objects
    -> m AccessibleList
    -- ^ __Returns:__ the list of accessible objects
accessibleListNewFromList list = liftIO $ do
    list' <- mapM unsafeManagedPtrCastPtr list
    list'' <- packGList list'
    result <- gtk_accessible_list_new_from_list list''
    checkUnexpectedReturnNULL "accessibleListNewFromList" result
    result' <- (wrapBoxed AccessibleList) result
    mapM_ touchManagedPtr list
    g_list_free list''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AccessibleList::get_objects
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "accessible_list"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gtk" , name = "Accessible" }))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accessible_list_get_objects" gtk_accessible_list_get_objects :: 
    Ptr AccessibleList ->                   -- accessible_list : TInterface (Name {namespace = "Gtk", name = "AccessibleList"})
    IO (Ptr (GList (Ptr Gtk.Accessible.Accessible)))

-- | Gets the list of objects this boxed type holds.
-- 
-- /Since: 4.14/
accessibleListGetObjects ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AccessibleList
    -> m [Gtk.Accessible.Accessible]
    -- ^ __Returns:__ a shallow copy
    --   of the objects
accessibleListGetObjects accessibleList = liftIO $ do
    accessibleList' <- unsafeManagedPtrGetPtr accessibleList
    result <- gtk_accessible_list_get_objects accessibleList'
    result' <- unpackGList result
    result'' <- mapM (newObject Gtk.Accessible.Accessible) result'
    g_list_free result
    touchManagedPtr accessibleList
    return result''

#if defined(ENABLE_OVERLOADING)
data AccessibleListGetObjectsMethodInfo
instance (signature ~ (m [Gtk.Accessible.Accessible]), MonadIO m) => O.OverloadedMethod AccessibleListGetObjectsMethodInfo AccessibleList signature where
    overloadedMethod = accessibleListGetObjects

instance O.OverloadedMethodInfo AccessibleListGetObjectsMethodInfo AccessibleList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.AccessibleList.accessibleListGetObjects",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-AccessibleList.html#v:accessibleListGetObjects"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAccessibleListMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAccessibleListMethod "getObjects" o = AccessibleListGetObjectsMethodInfo
    ResolveAccessibleListMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAccessibleListMethod t AccessibleList, O.OverloadedMethod info AccessibleList p) => OL.IsLabel t (AccessibleList -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAccessibleListMethod t AccessibleList, O.OverloadedMethod info AccessibleList p, R.HasField t AccessibleList p) => R.HasField t AccessibleList p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAccessibleListMethod t AccessibleList, O.OverloadedMethodInfo info AccessibleList) => OL.IsLabel t (O.MethodProxy info AccessibleList) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


