{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node for a @GdkTexture@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.TextureNode
    ( 

-- * Exported types
    TextureNode(..)                         ,
    IsTextureNode                           ,
    toTextureNode                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getTexture]("GI.Gsk.Objects.TextureNode#g:method:getTexture").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTextureNodeMethod                ,
#endif

-- ** getTexture #method:getTexture#

#if defined(ENABLE_OVERLOADING)
    TextureNodeGetTextureMethodInfo         ,
#endif
    textureNodeGetTexture                   ,


-- ** new #method:new#

    textureNodeNew                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype TextureNode = TextureNode (SP.ManagedPtr TextureNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype TextureNode where
    toManagedPtr (TextureNode p) = p

foreign import ccall "gsk_texture_node_get_type"
    c_gsk_texture_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject TextureNode where
    glibType = c_gsk_texture_node_get_type

-- | Type class for types which can be safely cast to t'TextureNode', for instance with `toTextureNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TextureNode o) => IsTextureNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TextureNode o) => IsTextureNode o

instance O.HasParentTypes TextureNode
type instance O.ParentTypes TextureNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'TextureNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTextureNode :: (MIO.MonadIO m, IsTextureNode o) => o -> m TextureNode
toTextureNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo TextureNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveTextureNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTextureNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveTextureNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveTextureNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveTextureNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveTextureNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveTextureNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveTextureNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveTextureNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveTextureNodeMethod "getTexture" o = TextureNodeGetTextureMethodInfo
    ResolveTextureNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTextureNodeMethod t TextureNode, O.OverloadedMethod info TextureNode p) => OL.IsLabel t (TextureNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTextureNodeMethod t TextureNode, O.OverloadedMethod info TextureNode p, R.HasField t TextureNode p) => R.HasField t TextureNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTextureNodeMethod t TextureNode, O.OverloadedMethodInfo info TextureNode) => OL.IsLabel t (O.MethodProxy info TextureNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr TextureNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method TextureNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "texture"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Texture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkTexture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the rectangle to render the texture into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "TextureNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_texture_node_new" gsk_texture_node_new :: 
    Ptr Gdk.Texture.Texture ->              -- texture : TInterface (Name {namespace = "Gdk", name = "Texture"})
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr TextureNode)

-- | Creates a @GskRenderNode@ that will render the given
-- /@texture@/ into the area given by /@bounds@/.
-- 
-- Note that GSK applies linear filtering when textures are
-- scaled and transformed. See t'GI.Gsk.Objects.TextureScaleNode.TextureScaleNode'
-- for a way to influence filtering.
textureNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Texture.IsTexture a) =>
    a
    -- ^ /@texture@/: the @GdkTexture@
    -> Graphene.Rect.Rect
    -- ^ /@bounds@/: the rectangle to render the texture into
    -> m TextureNode
    -- ^ __Returns:__ A new @GskRenderNode@
textureNodeNew texture bounds = liftIO $ do
    texture' <- unsafeManagedPtrCastPtr texture
    bounds' <- unsafeManagedPtrGetPtr bounds
    result <- gsk_texture_node_new texture' bounds'
    checkUnexpectedReturnNULL "textureNodeNew" result
    result' <- (wrapPtr TextureNode) result
    touchManagedPtr texture
    touchManagedPtr bounds
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TextureNode::get_texture
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "TextureNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` of type %GSK_TEXTURE_NODE"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_texture_node_get_texture" gsk_texture_node_get_texture :: 
    Ptr TextureNode ->                      -- node : TInterface (Name {namespace = "Gsk", name = "TextureNode"})
    IO (Ptr Gdk.Texture.Texture)

-- | Retrieves the @GdkTexture@ used when creating this @GskRenderNode@.
textureNodeGetTexture ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextureNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ of type 'GI.Gsk.Enums.RenderNodeTypeTextureNode'
    -> m Gdk.Texture.Texture
    -- ^ __Returns:__ the @GdkTexture@
textureNodeGetTexture node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_texture_node_get_texture node'
    checkUnexpectedReturnNULL "textureNodeGetTexture" result
    result' <- (newObject Gdk.Texture.Texture) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data TextureNodeGetTextureMethodInfo
instance (signature ~ (m Gdk.Texture.Texture), MonadIO m, IsTextureNode a) => O.OverloadedMethod TextureNodeGetTextureMethodInfo a signature where
    overloadedMethod = textureNodeGetTexture

instance O.OverloadedMethodInfo TextureNodeGetTextureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.TextureNode.textureNodeGetTexture",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-TextureNode.html#v:textureNodeGetTexture"
        })


#endif


