{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The class of an enumeration type holds information about its
-- possible values.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.EnumClass
    ( 

-- * Exported types
    EnumClass(..)                           ,
    newZeroEnumClass                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEnumClassMethod                  ,
#endif



 -- * Properties


-- ** gTypeClass #attr:gTypeClass#
-- | the parent class

#if defined(ENABLE_OVERLOADING)
    enumClass_gTypeClass                    ,
#endif
    getEnumClassGTypeClass                  ,


-- ** maximum #attr:maximum#
-- | the largest possible value.

#if defined(ENABLE_OVERLOADING)
    enumClass_maximum                       ,
#endif
    getEnumClassMaximum                     ,
    setEnumClassMaximum                     ,


-- ** minimum #attr:minimum#
-- | the smallest possible value.

#if defined(ENABLE_OVERLOADING)
    enumClass_minimum                       ,
#endif
    getEnumClassMinimum                     ,
    setEnumClassMinimum                     ,


-- ** nValues #attr:nValues#
-- | the number of possible values.

#if defined(ENABLE_OVERLOADING)
    enumClass_nValues                       ,
#endif
    getEnumClassNValues                     ,
    setEnumClassNValues                     ,


-- ** values #attr:values#
-- | an array of t'GI.GObject.Structs.EnumValue.EnumValue' structs describing the
--  individual values.

    clearEnumClassValues                    ,
#if defined(ENABLE_OVERLOADING)
    enumClass_values                        ,
#endif
    getEnumClassValues                      ,
    setEnumClassValues                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumValue as GObject.EnumValue
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#else
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumValue as GObject.EnumValue
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#endif

-- | Memory-managed wrapper type.
newtype EnumClass = EnumClass (SP.ManagedPtr EnumClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype EnumClass where
    toManagedPtr (EnumClass p) = p

instance BoxedPtr EnumClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr EnumClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EnumClass where
    boxedPtrCalloc = callocBytes 32


-- | Construct a t'EnumClass' struct initialized to zero.
newZeroEnumClass :: MonadIO m => m EnumClass
newZeroEnumClass = liftIO $ boxedPtrCalloc >>= wrapPtr EnumClass

instance tag ~ 'AttrSet => Constructible EnumClass tag where
    new _ attrs = do
        o <- newZeroEnumClass
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@g_type_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumClass #gTypeClass
-- @
getEnumClassGTypeClass :: MonadIO m => EnumClass -> m GObject.TypeClass.TypeClass
getEnumClassGTypeClass s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr GObject.TypeClass.TypeClass)
    val' <- (newPtr GObject.TypeClass.TypeClass) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EnumClassGTypeClassFieldInfo
instance AttrInfo EnumClassGTypeClassFieldInfo where
    type AttrBaseTypeConstraint EnumClassGTypeClassFieldInfo = (~) EnumClass
    type AttrAllowedOps EnumClassGTypeClassFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EnumClassGTypeClassFieldInfo = (~) (Ptr GObject.TypeClass.TypeClass)
    type AttrTransferTypeConstraint EnumClassGTypeClassFieldInfo = (~)(Ptr GObject.TypeClass.TypeClass)
    type AttrTransferType EnumClassGTypeClassFieldInfo = (Ptr GObject.TypeClass.TypeClass)
    type AttrGetType EnumClassGTypeClassFieldInfo = GObject.TypeClass.TypeClass
    type AttrLabel EnumClassGTypeClassFieldInfo = "g_type_class"
    type AttrOrigin EnumClassGTypeClassFieldInfo = EnumClass
    attrGet = getEnumClassGTypeClass
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumClass.gTypeClass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumClass.html#g:attr:gTypeClass"
        })

enumClass_gTypeClass :: AttrLabelProxy "gTypeClass"
enumClass_gTypeClass = AttrLabelProxy

#endif


-- | Get the value of the “@minimum@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumClass #minimum
-- @
getEnumClassMinimum :: MonadIO m => EnumClass -> m Int32
getEnumClassMinimum s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@minimum@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' enumClass [ #minimum 'Data.GI.Base.Attributes.:=' value ]
-- @
setEnumClassMinimum :: MonadIO m => EnumClass -> Int32 -> m ()
setEnumClassMinimum s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data EnumClassMinimumFieldInfo
instance AttrInfo EnumClassMinimumFieldInfo where
    type AttrBaseTypeConstraint EnumClassMinimumFieldInfo = (~) EnumClass
    type AttrAllowedOps EnumClassMinimumFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EnumClassMinimumFieldInfo = (~) Int32
    type AttrTransferTypeConstraint EnumClassMinimumFieldInfo = (~)Int32
    type AttrTransferType EnumClassMinimumFieldInfo = Int32
    type AttrGetType EnumClassMinimumFieldInfo = Int32
    type AttrLabel EnumClassMinimumFieldInfo = "minimum"
    type AttrOrigin EnumClassMinimumFieldInfo = EnumClass
    attrGet = getEnumClassMinimum
    attrSet = setEnumClassMinimum
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumClass.minimum"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumClass.html#g:attr:minimum"
        })

enumClass_minimum :: AttrLabelProxy "minimum"
enumClass_minimum = AttrLabelProxy

#endif


-- | Get the value of the “@maximum@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumClass #maximum
-- @
getEnumClassMaximum :: MonadIO m => EnumClass -> m Int32
getEnumClassMaximum s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@maximum@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' enumClass [ #maximum 'Data.GI.Base.Attributes.:=' value ]
-- @
setEnumClassMaximum :: MonadIO m => EnumClass -> Int32 -> m ()
setEnumClassMaximum s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data EnumClassMaximumFieldInfo
instance AttrInfo EnumClassMaximumFieldInfo where
    type AttrBaseTypeConstraint EnumClassMaximumFieldInfo = (~) EnumClass
    type AttrAllowedOps EnumClassMaximumFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EnumClassMaximumFieldInfo = (~) Int32
    type AttrTransferTypeConstraint EnumClassMaximumFieldInfo = (~)Int32
    type AttrTransferType EnumClassMaximumFieldInfo = Int32
    type AttrGetType EnumClassMaximumFieldInfo = Int32
    type AttrLabel EnumClassMaximumFieldInfo = "maximum"
    type AttrOrigin EnumClassMaximumFieldInfo = EnumClass
    attrGet = getEnumClassMaximum
    attrSet = setEnumClassMaximum
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumClass.maximum"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumClass.html#g:attr:maximum"
        })

enumClass_maximum :: AttrLabelProxy "maximum"
enumClass_maximum = AttrLabelProxy

#endif


-- | Get the value of the “@n_values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumClass #nValues
-- @
getEnumClassNValues :: MonadIO m => EnumClass -> m Word32
getEnumClassNValues s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Word32
    return val

-- | Set the value of the “@n_values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' enumClass [ #nValues 'Data.GI.Base.Attributes.:=' value ]
-- @
setEnumClassNValues :: MonadIO m => EnumClass -> Word32 -> m ()
setEnumClassNValues s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EnumClassNValuesFieldInfo
instance AttrInfo EnumClassNValuesFieldInfo where
    type AttrBaseTypeConstraint EnumClassNValuesFieldInfo = (~) EnumClass
    type AttrAllowedOps EnumClassNValuesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EnumClassNValuesFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EnumClassNValuesFieldInfo = (~)Word32
    type AttrTransferType EnumClassNValuesFieldInfo = Word32
    type AttrGetType EnumClassNValuesFieldInfo = Word32
    type AttrLabel EnumClassNValuesFieldInfo = "n_values"
    type AttrOrigin EnumClassNValuesFieldInfo = EnumClass
    attrGet = getEnumClassNValues
    attrSet = setEnumClassNValues
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumClass.nValues"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumClass.html#g:attr:nValues"
        })

enumClass_nValues :: AttrLabelProxy "nValues"
enumClass_nValues = AttrLabelProxy

#endif


-- | Get the value of the “@values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumClass #values
-- @
getEnumClassValues :: MonadIO m => EnumClass -> m (Maybe GObject.EnumValue.EnumValue)
getEnumClassValues s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr GObject.EnumValue.EnumValue)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr GObject.EnumValue.EnumValue) val'
        return val''
    return result

-- | Set the value of the “@values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' enumClass [ #values 'Data.GI.Base.Attributes.:=' value ]
-- @
setEnumClassValues :: MonadIO m => EnumClass -> Ptr GObject.EnumValue.EnumValue -> m ()
setEnumClassValues s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr GObject.EnumValue.EnumValue)

-- | Set the value of the “@values@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #values
-- @
clearEnumClassValues :: MonadIO m => EnumClass -> m ()
clearEnumClassValues s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr GObject.EnumValue.EnumValue)

#if defined(ENABLE_OVERLOADING)
data EnumClassValuesFieldInfo
instance AttrInfo EnumClassValuesFieldInfo where
    type AttrBaseTypeConstraint EnumClassValuesFieldInfo = (~) EnumClass
    type AttrAllowedOps EnumClassValuesFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EnumClassValuesFieldInfo = (~) (Ptr GObject.EnumValue.EnumValue)
    type AttrTransferTypeConstraint EnumClassValuesFieldInfo = (~)(Ptr GObject.EnumValue.EnumValue)
    type AttrTransferType EnumClassValuesFieldInfo = (Ptr GObject.EnumValue.EnumValue)
    type AttrGetType EnumClassValuesFieldInfo = Maybe GObject.EnumValue.EnumValue
    type AttrLabel EnumClassValuesFieldInfo = "values"
    type AttrOrigin EnumClassValuesFieldInfo = EnumClass
    attrGet = getEnumClassValues
    attrSet = setEnumClassValues
    attrConstruct = undefined
    attrClear = clearEnumClassValues
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumClass.values"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumClass.html#g:attr:values"
        })

enumClass_values :: AttrLabelProxy "values"
enumClass_values = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EnumClass
type instance O.AttributeList EnumClass = EnumClassAttributeList
type EnumClassAttributeList = ('[ '("gTypeClass", EnumClassGTypeClassFieldInfo), '("minimum", EnumClassMinimumFieldInfo), '("maximum", EnumClassMaximumFieldInfo), '("nValues", EnumClassNValuesFieldInfo), '("values", EnumClassValuesFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEnumClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEnumClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEnumClassMethod t EnumClass, O.OverloadedMethod info EnumClass p) => OL.IsLabel t (EnumClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEnumClassMethod t EnumClass, O.OverloadedMethod info EnumClass p, R.HasField t EnumClass p) => R.HasField t EnumClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEnumClassMethod t EnumClass, O.OverloadedMethodInfo info EnumClass) => OL.IsLabel t (O.MethodProxy info EnumClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


