{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Contains the public fields of a
-- <http://developer.gnome.org/glib/stable/data-structures.html#double-ended-queues Queue>.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Queue
    ( 

-- * Exported types
    Queue(..)                               ,
    newZeroQueue                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [clear]("GI.GLib.Structs.Queue#g:method:clear"), [clearFull]("GI.GLib.Structs.Queue#g:method:clearFull"), [foreach]("GI.GLib.Structs.Queue#g:method:foreach"), [free]("GI.GLib.Structs.Queue#g:method:free"), [freeFull]("GI.GLib.Structs.Queue#g:method:freeFull"), [index]("GI.GLib.Structs.Queue#g:method:index"), [init]("GI.GLib.Structs.Queue#g:method:init"), [insertSorted]("GI.GLib.Structs.Queue#g:method:insertSorted"), [isEmpty]("GI.GLib.Structs.Queue#g:method:isEmpty"), [peekHead]("GI.GLib.Structs.Queue#g:method:peekHead"), [peekNth]("GI.GLib.Structs.Queue#g:method:peekNth"), [peekTail]("GI.GLib.Structs.Queue#g:method:peekTail"), [popHead]("GI.GLib.Structs.Queue#g:method:popHead"), [popNth]("GI.GLib.Structs.Queue#g:method:popNth"), [popTail]("GI.GLib.Structs.Queue#g:method:popTail"), [pushHead]("GI.GLib.Structs.Queue#g:method:pushHead"), [pushNth]("GI.GLib.Structs.Queue#g:method:pushNth"), [pushTail]("GI.GLib.Structs.Queue#g:method:pushTail"), [remove]("GI.GLib.Structs.Queue#g:method:remove"), [removeAll]("GI.GLib.Structs.Queue#g:method:removeAll"), [reverse]("GI.GLib.Structs.Queue#g:method:reverse"), [sort]("GI.GLib.Structs.Queue#g:method:sort").
-- 
-- ==== Getters
-- [getLength]("GI.GLib.Structs.Queue#g:method:getLength").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveQueueMethod                      ,
#endif

-- ** clear #method:clear#

#if defined(ENABLE_OVERLOADING)
    QueueClearMethodInfo                    ,
#endif
    queueClear                              ,


-- ** clearFull #method:clearFull#

#if defined(ENABLE_OVERLOADING)
    QueueClearFullMethodInfo                ,
#endif
    queueClearFull                          ,


-- ** foreach #method:foreach#

#if defined(ENABLE_OVERLOADING)
    QueueForeachMethodInfo                  ,
#endif
    queueForeach                            ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    QueueFreeMethodInfo                     ,
#endif
    queueFree                               ,


-- ** freeFull #method:freeFull#

#if defined(ENABLE_OVERLOADING)
    QueueFreeFullMethodInfo                 ,
#endif
    queueFreeFull                           ,


-- ** getLength #method:getLength#

#if defined(ENABLE_OVERLOADING)
    QueueGetLengthMethodInfo                ,
#endif
    queueGetLength                          ,


-- ** index #method:index#

#if defined(ENABLE_OVERLOADING)
    QueueIndexMethodInfo                    ,
#endif
    queueIndex                              ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    QueueInitMethodInfo                     ,
#endif
    queueInit                               ,


-- ** insertSorted #method:insertSorted#

#if defined(ENABLE_OVERLOADING)
    QueueInsertSortedMethodInfo             ,
#endif
    queueInsertSorted                       ,


-- ** isEmpty #method:isEmpty#

#if defined(ENABLE_OVERLOADING)
    QueueIsEmptyMethodInfo                  ,
#endif
    queueIsEmpty                            ,


-- ** peekHead #method:peekHead#

#if defined(ENABLE_OVERLOADING)
    QueuePeekHeadMethodInfo                 ,
#endif
    queuePeekHead                           ,


-- ** peekNth #method:peekNth#

#if defined(ENABLE_OVERLOADING)
    QueuePeekNthMethodInfo                  ,
#endif
    queuePeekNth                            ,


-- ** peekTail #method:peekTail#

#if defined(ENABLE_OVERLOADING)
    QueuePeekTailMethodInfo                 ,
#endif
    queuePeekTail                           ,


-- ** popHead #method:popHead#

#if defined(ENABLE_OVERLOADING)
    QueuePopHeadMethodInfo                  ,
#endif
    queuePopHead                            ,


-- ** popNth #method:popNth#

#if defined(ENABLE_OVERLOADING)
    QueuePopNthMethodInfo                   ,
#endif
    queuePopNth                             ,


-- ** popTail #method:popTail#

#if defined(ENABLE_OVERLOADING)
    QueuePopTailMethodInfo                  ,
#endif
    queuePopTail                            ,


-- ** pushHead #method:pushHead#

#if defined(ENABLE_OVERLOADING)
    QueuePushHeadMethodInfo                 ,
#endif
    queuePushHead                           ,


-- ** pushNth #method:pushNth#

#if defined(ENABLE_OVERLOADING)
    QueuePushNthMethodInfo                  ,
#endif
    queuePushNth                            ,


-- ** pushTail #method:pushTail#

#if defined(ENABLE_OVERLOADING)
    QueuePushTailMethodInfo                 ,
#endif
    queuePushTail                           ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    QueueRemoveMethodInfo                   ,
#endif
    queueRemove                             ,


-- ** removeAll #method:removeAll#

#if defined(ENABLE_OVERLOADING)
    QueueRemoveAllMethodInfo                ,
#endif
    queueRemoveAll                          ,


-- ** reverse #method:reverse#

#if defined(ENABLE_OVERLOADING)
    QueueReverseMethodInfo                  ,
#endif
    queueReverse                            ,


-- ** sort #method:sort#

#if defined(ENABLE_OVERLOADING)
    QueueSortMethodInfo                     ,
#endif
    queueSort                               ,




 -- * Properties


-- ** head #attr:head#
-- | a pointer to the first element of the queue

    clearQueueHead                          ,
    getQueueHead                            ,
#if defined(ENABLE_OVERLOADING)
    queue_head                              ,
#endif
    setQueueHead                            ,


-- ** length #attr:length#
-- | the number of elements in the queue

    getQueueLength                          ,
#if defined(ENABLE_OVERLOADING)
    queue_length                            ,
#endif
    setQueueLength                          ,


-- ** tail #attr:tail#
-- | a pointer to the last element of the queue

    clearQueueTail                          ,
    getQueueTail                            ,
#if defined(ENABLE_OVERLOADING)
    queue_tail                              ,
#endif
    setQueueTail                            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype Queue = Queue (SP.ManagedPtr Queue)
    deriving (Eq)

instance SP.ManagedPtrNewtype Queue where
    toManagedPtr (Queue p) = p

instance BoxedPtr Queue where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr Queue)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Queue where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'Queue' struct initialized to zero.
newZeroQueue :: MonadIO m => m Queue
newZeroQueue = liftIO $ boxedPtrCalloc >>= wrapPtr Queue

instance tag ~ 'AttrSet => Constructible Queue tag where
    new _ attrs = do
        o <- newZeroQueue
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@head@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' queue #head
-- @
getQueueHead :: MonadIO m => Queue -> m ([Ptr ()])
getQueueHead s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr (GList (Ptr ())))
    val' <- unpackGList val
    return val'

-- | Set the value of the “@head@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' queue [ #head 'Data.GI.Base.Attributes.:=' value ]
-- @
setQueueHead :: MonadIO m => Queue -> Ptr (GList (Ptr ())) -> m ()
setQueueHead s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr (GList (Ptr ())))

-- | Set the value of the “@head@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #head
-- @
clearQueueHead :: MonadIO m => Queue -> m ()
clearQueueHead s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr (GList (Ptr ())))

#if defined(ENABLE_OVERLOADING)
data QueueHeadFieldInfo
instance AttrInfo QueueHeadFieldInfo where
    type AttrBaseTypeConstraint QueueHeadFieldInfo = (~) Queue
    type AttrAllowedOps QueueHeadFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint QueueHeadFieldInfo = (~) (Ptr (GList (Ptr ())))
    type AttrTransferTypeConstraint QueueHeadFieldInfo = (~)(Ptr (GList (Ptr ())))
    type AttrTransferType QueueHeadFieldInfo = (Ptr (GList (Ptr ())))
    type AttrGetType QueueHeadFieldInfo = [Ptr ()]
    type AttrLabel QueueHeadFieldInfo = "head"
    type AttrOrigin QueueHeadFieldInfo = Queue
    attrGet = getQueueHead
    attrSet = setQueueHead
    attrConstruct = undefined
    attrClear = clearQueueHead
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.head"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#g:attr:head"
        })

queue_head :: AttrLabelProxy "head"
queue_head = AttrLabelProxy

#endif


-- | Get the value of the “@tail@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' queue #tail
-- @
getQueueTail :: MonadIO m => Queue -> m ([Ptr ()])
getQueueTail s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr (GList (Ptr ())))
    val' <- unpackGList val
    return val'

-- | Set the value of the “@tail@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' queue [ #tail 'Data.GI.Base.Attributes.:=' value ]
-- @
setQueueTail :: MonadIO m => Queue -> Ptr (GList (Ptr ())) -> m ()
setQueueTail s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr (GList (Ptr ())))

-- | Set the value of the “@tail@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #tail
-- @
clearQueueTail :: MonadIO m => Queue -> m ()
clearQueueTail s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr (GList (Ptr ())))

#if defined(ENABLE_OVERLOADING)
data QueueTailFieldInfo
instance AttrInfo QueueTailFieldInfo where
    type AttrBaseTypeConstraint QueueTailFieldInfo = (~) Queue
    type AttrAllowedOps QueueTailFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint QueueTailFieldInfo = (~) (Ptr (GList (Ptr ())))
    type AttrTransferTypeConstraint QueueTailFieldInfo = (~)(Ptr (GList (Ptr ())))
    type AttrTransferType QueueTailFieldInfo = (Ptr (GList (Ptr ())))
    type AttrGetType QueueTailFieldInfo = [Ptr ()]
    type AttrLabel QueueTailFieldInfo = "tail"
    type AttrOrigin QueueTailFieldInfo = Queue
    attrGet = getQueueTail
    attrSet = setQueueTail
    attrConstruct = undefined
    attrClear = clearQueueTail
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.tail"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#g:attr:tail"
        })

queue_tail :: AttrLabelProxy "tail"
queue_tail = AttrLabelProxy

#endif


-- | Get the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' queue #length
-- @
getQueueLength :: MonadIO m => Queue -> m Word32
getQueueLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Word32
    return val

-- | Set the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' queue [ #length 'Data.GI.Base.Attributes.:=' value ]
-- @
setQueueLength :: MonadIO m => Queue -> Word32 -> m ()
setQueueLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data QueueLengthFieldInfo
instance AttrInfo QueueLengthFieldInfo where
    type AttrBaseTypeConstraint QueueLengthFieldInfo = (~) Queue
    type AttrAllowedOps QueueLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint QueueLengthFieldInfo = (~) Word32
    type AttrTransferTypeConstraint QueueLengthFieldInfo = (~)Word32
    type AttrTransferType QueueLengthFieldInfo = Word32
    type AttrGetType QueueLengthFieldInfo = Word32
    type AttrLabel QueueLengthFieldInfo = "length"
    type AttrOrigin QueueLengthFieldInfo = Queue
    attrGet = getQueueLength
    attrSet = setQueueLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.length"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#g:attr:length"
        })

queue_length :: AttrLabelProxy "length"
queue_length = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Queue
type instance O.AttributeList Queue = QueueAttributeList
type QueueAttributeList = ('[ '("head", QueueHeadFieldInfo), '("tail", QueueTailFieldInfo), '("length", QueueLengthFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Queue::clear
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_clear" g_queue_clear :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO ()

-- | Removes all the elements in /@queue@/. If queue elements contain
-- dynamically-allocated memory, they should be freed first.
-- 
-- /Since: 2.14/
queueClear ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m ()
queueClear queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_queue_clear queue'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueClearMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod QueueClearMethodInfo Queue signature where
    overloadedMethod = queueClear

instance O.OverloadedMethodInfo QueueClearMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueClear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueClear"
        })


#endif

-- method Queue::clear_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #GQueue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "free_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function to be called to free memory allocated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_clear_full" g_queue_clear_full :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- free_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Convenience method, which frees all the memory used by a t'GI.GLib.Structs.Queue.Queue',
-- and calls the provided /@freeFunc@/ on each item in the t'GI.GLib.Structs.Queue.Queue'.
-- 
-- /Since: 2.60/
queueClearFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a pointer to a t'GI.GLib.Structs.Queue.Queue'
    -> Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@freeFunc@/: the function to be called to free memory allocated
    -> m ()
queueClearFull queue freeFunc = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    maybeFreeFunc <- case freeFunc of
        Nothing -> return FP.nullFunPtr
        Just jFreeFunc -> do
            ptrfreeFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jFreeFunc' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrfreeFunc) jFreeFunc)
            poke ptrfreeFunc jFreeFunc'
            return jFreeFunc'
    g_queue_clear_full queue' maybeFreeFunc
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueClearFullMethodInfo
instance (signature ~ (Maybe (GLib.Callbacks.DestroyNotify) -> m ()), MonadIO m) => O.OverloadedMethod QueueClearFullMethodInfo Queue signature where
    overloadedMethod = queueClearFull

instance O.OverloadedMethodInfo QueueClearFullMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueClearFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueClearFull"
        })


#endif

-- method Queue::foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TInterface Name { namespace = "GLib" , name = "Func" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function to call for each element's data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_foreach" g_queue_foreach :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    FunPtr GLib.Callbacks.C_Func ->         -- func : TInterface (Name {namespace = "GLib", name = "Func"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Calls /@func@/ for each element in the queue passing /@userData@/ to the
-- function.
-- 
-- It is safe for /@func@/ to remove the element from /@queue@/, but it must
-- not modify any part of the queue after that element.
-- 
-- /Since: 2.4/
queueForeach ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> GLib.Callbacks.Func
    -- ^ /@func@/: the function to call for each element\'s data
    -> m ()
queueForeach queue func = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    func' <- GLib.Callbacks.mk_Func (GLib.Callbacks.wrap_Func Nothing (GLib.Callbacks.drop_closures_Func func))
    let userData = nullPtr
    g_queue_foreach queue' func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueForeachMethodInfo
instance (signature ~ (GLib.Callbacks.Func -> m ()), MonadIO m) => O.OverloadedMethod QueueForeachMethodInfo Queue signature where
    overloadedMethod = queueForeach

instance O.OverloadedMethodInfo QueueForeachMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueForeach"
        })


#endif

-- method Queue::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_free" g_queue_free :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO ()

-- | Frees the memory allocated for the t'GI.GLib.Structs.Queue.Queue'. Only call this function
-- if /@queue@/ was created with @/g_queue_new()/@. If queue elements contain
-- dynamically-allocated memory, they should be freed first.
-- 
-- If queue elements contain dynamically-allocated memory, you should
-- either use 'GI.GLib.Structs.Queue.queueFreeFull' or free them manually first.
queueFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m ()
queueFree queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_queue_free queue'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod QueueFreeMethodInfo Queue signature where
    overloadedMethod = queueFree

instance O.OverloadedMethodInfo QueueFreeMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueFree"
        })


#endif

-- method Queue::free_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #GQueue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "free_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function to be called to free each element's data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_free_full" g_queue_free_full :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- free_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Convenience method, which frees all the memory used by a t'GI.GLib.Structs.Queue.Queue',
-- and calls the specified destroy function on every element\'s data.
-- 
-- /@freeFunc@/ should not modify the queue (eg, by removing the freed
-- element from it).
-- 
-- /Since: 2.32/
queueFreeFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a pointer to a t'GI.GLib.Structs.Queue.Queue'
    -> GLib.Callbacks.DestroyNotify
    -- ^ /@freeFunc@/: the function to be called to free each element\'s data
    -> m ()
queueFreeFull queue freeFunc = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    ptrfreeFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
    freeFunc' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrfreeFunc) freeFunc)
    poke ptrfreeFunc freeFunc'
    g_queue_free_full queue' freeFunc'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueFreeFullMethodInfo
instance (signature ~ (GLib.Callbacks.DestroyNotify -> m ()), MonadIO m) => O.OverloadedMethod QueueFreeFullMethodInfo Queue signature where
    overloadedMethod = queueFreeFull

instance O.OverloadedMethodInfo QueueFreeFullMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueFreeFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueFreeFull"
        })


#endif

-- method Queue::get_length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_get_length" g_queue_get_length :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO Word32

-- | Returns the number of items in /@queue@/.
-- 
-- /Since: 2.4/
queueGetLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m Word32
    -- ^ __Returns:__ the number of items in /@queue@/
queueGetLength queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_get_length queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueueGetLengthMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod QueueGetLengthMethodInfo Queue signature where
    overloadedMethod = queueGetLength

instance O.OverloadedMethodInfo QueueGetLengthMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueGetLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueGetLength"
        })


#endif

-- method Queue::index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to find" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_index" g_queue_index :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO Int32

-- | Returns the position of the first element in /@queue@/ which contains /@data@/.
-- 
-- /Since: 2.4/
queueIndex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Ptr ()
    -- ^ /@data@/: the data to find
    -> m Int32
    -- ^ __Returns:__ the position of the first element in /@queue@/ which
    --     contains /@data@/, or -1 if no element in /@queue@/ contains /@data@/
queueIndex queue data_ = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_index queue' data_
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueueIndexMethodInfo
instance (signature ~ (Ptr () -> m Int32), MonadIO m) => O.OverloadedMethod QueueIndexMethodInfo Queue signature where
    overloadedMethod = queueIndex

instance O.OverloadedMethodInfo QueueIndexMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueIndex"
        })


#endif

-- method Queue::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an uninitialized #GQueue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_init" g_queue_init :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO ()

-- | A statically-allocated t'GI.GLib.Structs.Queue.Queue' must be initialized with this function
-- before it can be used. Alternatively you can initialize it with
-- @/G_QUEUE_INIT/@. It is not necessary to initialize queues created with
-- @/g_queue_new()/@.
-- 
-- /Since: 2.14/
queueInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: an uninitialized t'GI.GLib.Structs.Queue.Queue'
    -> m ()
queueInit queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_queue_init queue'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueInitMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod QueueInitMethodInfo Queue signature where
    overloadedMethod = queueInit

instance O.OverloadedMethodInfo QueueInitMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueInit"
        })


#endif

-- method Queue::insert_sorted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to insert" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GCompareDataFunc used to compare elements in the queue. It is\n    called with two elements of the @queue and @user_data. It should\n    return 0 if the elements are equal, a negative value if the first\n    element comes before the second, and a positive value if the second\n    element comes before the first."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_insert_sorted" g_queue_insert_sorted :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Inserts /@data@/ into /@queue@/ using /@func@/ to determine the new position.
-- 
-- /Since: 2.4/
queueInsertSorted ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Ptr ()
    -- ^ /@data@/: the data to insert
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@func@/: the t'GI.GLib.Callbacks.CompareDataFunc' used to compare elements in the queue. It is
    --     called with two elements of the /@queue@/ and /@userData@/. It should
    --     return 0 if the elements are equal, a negative value if the first
    --     element comes before the second, and a positive value if the second
    --     element comes before the first.
    -> m ()
queueInsertSorted queue data_ func = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    func' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc func))
    let userData = nullPtr
    g_queue_insert_sorted queue' data_ func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueInsertSortedMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.CompareDataFunc -> m ()), MonadIO m) => O.OverloadedMethod QueueInsertSortedMethodInfo Queue signature where
    overloadedMethod = queueInsertSorted

instance O.OverloadedMethodInfo QueueInsertSortedMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueInsertSorted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueInsertSorted"
        })


#endif

-- method Queue::is_empty
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_is_empty" g_queue_is_empty :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO CInt

-- | Returns 'P.True' if the queue is empty.
queueIsEmpty ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the queue is empty
queueIsEmpty queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_is_empty queue'
    let result' = (/= 0) result
    touchManagedPtr queue
    return result'

#if defined(ENABLE_OVERLOADING)
data QueueIsEmptyMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod QueueIsEmptyMethodInfo Queue signature where
    overloadedMethod = queueIsEmpty

instance O.OverloadedMethodInfo QueueIsEmptyMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueIsEmpty",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueIsEmpty"
        })


#endif

-- method Queue::peek_head
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_peek_head" g_queue_peek_head :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO (Ptr ())

-- | Returns the first element of the queue.
queuePeekHead ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m (Ptr ())
    -- ^ __Returns:__ the data of the first element in the queue, or 'P.Nothing'
    --     if the queue is empty
queuePeekHead queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_peek_head queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueuePeekHeadMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod QueuePeekHeadMethodInfo Queue signature where
    overloadedMethod = queuePeekHead

instance O.OverloadedMethodInfo QueuePeekHeadMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePeekHead",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePeekHead"
        })


#endif

-- method Queue::peek_nth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the element"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_peek_nth" g_queue_peek_nth :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Word32 ->                               -- n : TBasicType TUInt
    IO (Ptr ())

-- | Returns the /@n@/\'th element of /@queue@/.
-- 
-- /Since: 2.4/
queuePeekNth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Word32
    -- ^ /@n@/: the position of the element
    -> m (Ptr ())
    -- ^ __Returns:__ the data for the /@n@/\'th element of /@queue@/,
    --     or 'P.Nothing' if /@n@/ is off the end of /@queue@/
queuePeekNth queue n = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_peek_nth queue' n
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueuePeekNthMethodInfo
instance (signature ~ (Word32 -> m (Ptr ())), MonadIO m) => O.OverloadedMethod QueuePeekNthMethodInfo Queue signature where
    overloadedMethod = queuePeekNth

instance O.OverloadedMethodInfo QueuePeekNthMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePeekNth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePeekNth"
        })


#endif

-- method Queue::peek_tail
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_peek_tail" g_queue_peek_tail :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO (Ptr ())

-- | Returns the last element of the queue.
queuePeekTail ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m (Ptr ())
    -- ^ __Returns:__ the data of the last element in the queue, or 'P.Nothing'
    --     if the queue is empty
queuePeekTail queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_peek_tail queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueuePeekTailMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod QueuePeekTailMethodInfo Queue signature where
    overloadedMethod = queuePeekTail

instance O.OverloadedMethodInfo QueuePeekTailMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePeekTail",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePeekTail"
        })


#endif

-- method Queue::pop_head
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_pop_head" g_queue_pop_head :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO (Ptr ())

-- | Removes the first element of the queue and returns its data.
queuePopHead ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m (Ptr ())
    -- ^ __Returns:__ the data of the first element in the queue, or 'P.Nothing'
    --     if the queue is empty
queuePopHead queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_pop_head queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueuePopHeadMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod QueuePopHeadMethodInfo Queue signature where
    overloadedMethod = queuePopHead

instance O.OverloadedMethodInfo QueuePopHeadMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePopHead",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePopHead"
        })


#endif

-- method Queue::pop_nth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the element"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_pop_nth" g_queue_pop_nth :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Word32 ->                               -- n : TBasicType TUInt
    IO (Ptr ())

-- | Removes the /@n@/\'th element of /@queue@/ and returns its data.
-- 
-- /Since: 2.4/
queuePopNth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Word32
    -- ^ /@n@/: the position of the element
    -> m (Ptr ())
    -- ^ __Returns:__ the element\'s data, or 'P.Nothing' if /@n@/ is off the end of /@queue@/
queuePopNth queue n = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_pop_nth queue' n
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueuePopNthMethodInfo
instance (signature ~ (Word32 -> m (Ptr ())), MonadIO m) => O.OverloadedMethod QueuePopNthMethodInfo Queue signature where
    overloadedMethod = queuePopNth

instance O.OverloadedMethodInfo QueuePopNthMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePopNth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePopNth"
        })


#endif

-- method Queue::pop_tail
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_pop_tail" g_queue_pop_tail :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO (Ptr ())

-- | Removes the last element of the queue and returns its data.
queuePopTail ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m (Ptr ())
    -- ^ __Returns:__ the data of the last element in the queue, or 'P.Nothing'
    --     if the queue is empty
queuePopTail queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_pop_tail queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueuePopTailMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod QueuePopTailMethodInfo Queue signature where
    overloadedMethod = queuePopTail

instance O.OverloadedMethodInfo QueuePopTailMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePopTail",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePopTail"
        })


#endif

-- method Queue::push_head
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data for the new element."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_push_head" g_queue_push_head :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Adds a new element at the head of the queue.
queuePushHead ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'.
    -> Ptr ()
    -- ^ /@data@/: the data for the new element.
    -> m ()
queuePushHead queue data_ = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_queue_push_head queue' data_
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueuePushHeadMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod QueuePushHeadMethodInfo Queue signature where
    overloadedMethod = queuePushHead

instance O.OverloadedMethodInfo QueuePushHeadMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePushHead",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePushHead"
        })


#endif

-- method Queue::push_nth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data for the new element"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the position to insert the new element. If @n is negative or\n    larger than the number of elements in the @queue, the element is\n    added to the end of the queue."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_push_nth" g_queue_push_nth :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Ptr () ->                               -- data : TBasicType TPtr
    Int32 ->                                -- n : TBasicType TInt
    IO ()

-- | Inserts a new element into /@queue@/ at the given position.
-- 
-- /Since: 2.4/
queuePushNth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Ptr ()
    -- ^ /@data@/: the data for the new element
    -> Int32
    -- ^ /@n@/: the position to insert the new element. If /@n@/ is negative or
    --     larger than the number of elements in the /@queue@/, the element is
    --     added to the end of the queue.
    -> m ()
queuePushNth queue data_ n = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_queue_push_nth queue' data_ n
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueuePushNthMethodInfo
instance (signature ~ (Ptr () -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod QueuePushNthMethodInfo Queue signature where
    overloadedMethod = queuePushNth

instance O.OverloadedMethodInfo QueuePushNthMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePushNth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePushNth"
        })


#endif

-- method Queue::push_tail
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data for the new element"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_push_tail" g_queue_push_tail :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Adds a new element at the tail of the queue.
queuePushTail ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Ptr ()
    -- ^ /@data@/: the data for the new element
    -> m ()
queuePushTail queue data_ = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_queue_push_tail queue' data_
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueuePushTailMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod QueuePushTailMethodInfo Queue signature where
    overloadedMethod = queuePushTail

instance O.OverloadedMethodInfo QueuePushTailMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queuePushTail",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queuePushTail"
        })


#endif

-- method Queue::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to remove" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_remove" g_queue_remove :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO CInt

-- | Removes the first element in /@queue@/ that contains /@data@/.
-- 
-- /Since: 2.4/
queueRemove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Ptr ()
    -- ^ /@data@/: the data to remove
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@data@/ was found and removed from /@queue@/
queueRemove queue data_ = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_remove queue' data_
    let result' = (/= 0) result
    touchManagedPtr queue
    return result'

#if defined(ENABLE_OVERLOADING)
data QueueRemoveMethodInfo
instance (signature ~ (Ptr () -> m Bool), MonadIO m) => O.OverloadedMethod QueueRemoveMethodInfo Queue signature where
    overloadedMethod = queueRemove

instance O.OverloadedMethodInfo QueueRemoveMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueRemove"
        })


#endif

-- method Queue::remove_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to remove" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_remove_all" g_queue_remove_all :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO Word32

-- | Remove all elements whose data equals /@data@/ from /@queue@/.
-- 
-- /Since: 2.4/
queueRemoveAll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> Ptr ()
    -- ^ /@data@/: the data to remove
    -> m Word32
    -- ^ __Returns:__ the number of elements removed from /@queue@/
queueRemoveAll queue data_ = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_queue_remove_all queue' data_
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data QueueRemoveAllMethodInfo
instance (signature ~ (Ptr () -> m Word32), MonadIO m) => O.OverloadedMethod QueueRemoveAllMethodInfo Queue signature where
    overloadedMethod = queueRemoveAll

instance O.OverloadedMethodInfo QueueRemoveAllMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueRemoveAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueRemoveAll"
        })


#endif

-- method Queue::reverse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_reverse" g_queue_reverse :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    IO ()

-- | Reverses the order of the items in /@queue@/.
-- 
-- /Since: 2.4/
queueReverse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> m ()
queueReverse queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_queue_reverse queue'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueReverseMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod QueueReverseMethodInfo Queue signature where
    overloadedMethod = queueReverse

instance O.OverloadedMethodInfo QueueReverseMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueReverse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueReverse"
        })


#endif

-- method Queue::sort
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType = TInterface Name { namespace = "GLib" , name = "Queue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "compare_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GCompareDataFunc used to sort @queue. This function\n    is passed two elements of the queue and should return 0 if they are\n    equal, a negative value if the first comes before the second, and\n    a positive value if the second comes before the first."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @compare_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_queue_sort" g_queue_sort :: 
    Ptr Queue ->                            -- queue : TInterface (Name {namespace = "GLib", name = "Queue"})
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- compare_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Sorts /@queue@/ using /@compareFunc@/.
-- 
-- /Since: 2.4/
queueSort ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Queue
    -- ^ /@queue@/: a t'GI.GLib.Structs.Queue.Queue'
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@compareFunc@/: the t'GI.GLib.Callbacks.CompareDataFunc' used to sort /@queue@/. This function
    --     is passed two elements of the queue and should return 0 if they are
    --     equal, a negative value if the first comes before the second, and
    --     a positive value if the second comes before the first.
    -> m ()
queueSort queue compareFunc = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    compareFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc compareFunc))
    let userData = nullPtr
    g_queue_sort queue' compareFunc' userData
    safeFreeFunPtr $ castFunPtrToPtr compareFunc'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data QueueSortMethodInfo
instance (signature ~ (GLib.Callbacks.CompareDataFunc -> m ()), MonadIO m) => O.OverloadedMethod QueueSortMethodInfo Queue signature where
    overloadedMethod = queueSort

instance O.OverloadedMethodInfo QueueSortMethodInfo Queue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Queue.queueSort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Queue.html#v:queueSort"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveQueueMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveQueueMethod "clear" o = QueueClearMethodInfo
    ResolveQueueMethod "clearFull" o = QueueClearFullMethodInfo
    ResolveQueueMethod "foreach" o = QueueForeachMethodInfo
    ResolveQueueMethod "free" o = QueueFreeMethodInfo
    ResolveQueueMethod "freeFull" o = QueueFreeFullMethodInfo
    ResolveQueueMethod "index" o = QueueIndexMethodInfo
    ResolveQueueMethod "init" o = QueueInitMethodInfo
    ResolveQueueMethod "insertSorted" o = QueueInsertSortedMethodInfo
    ResolveQueueMethod "isEmpty" o = QueueIsEmptyMethodInfo
    ResolveQueueMethod "peekHead" o = QueuePeekHeadMethodInfo
    ResolveQueueMethod "peekNth" o = QueuePeekNthMethodInfo
    ResolveQueueMethod "peekTail" o = QueuePeekTailMethodInfo
    ResolveQueueMethod "popHead" o = QueuePopHeadMethodInfo
    ResolveQueueMethod "popNth" o = QueuePopNthMethodInfo
    ResolveQueueMethod "popTail" o = QueuePopTailMethodInfo
    ResolveQueueMethod "pushHead" o = QueuePushHeadMethodInfo
    ResolveQueueMethod "pushNth" o = QueuePushNthMethodInfo
    ResolveQueueMethod "pushTail" o = QueuePushTailMethodInfo
    ResolveQueueMethod "remove" o = QueueRemoveMethodInfo
    ResolveQueueMethod "removeAll" o = QueueRemoveAllMethodInfo
    ResolveQueueMethod "reverse" o = QueueReverseMethodInfo
    ResolveQueueMethod "sort" o = QueueSortMethodInfo
    ResolveQueueMethod "getLength" o = QueueGetLengthMethodInfo
    ResolveQueueMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveQueueMethod t Queue, O.OverloadedMethod info Queue p) => OL.IsLabel t (Queue -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveQueueMethod t Queue, O.OverloadedMethod info Queue p, R.HasField t Queue p) => R.HasField t Queue p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveQueueMethod t Queue, O.OverloadedMethodInfo info Queue) => OL.IsLabel t (O.MethodProxy info Queue) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


