

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Callbacks
    ( 

 -- * Signals


-- ** PixbufDestroyNotify #signal:PixbufDestroyNotify#

    C_PixbufDestroyNotify                   ,
    PixbufDestroyNotify                     ,
    PixbufDestroyNotify_WithClosures        ,
    drop_closures_PixbufDestroyNotify       ,
    dynamic_PixbufDestroyNotify             ,
    genClosure_PixbufDestroyNotify          ,
    mk_PixbufDestroyNotify                  ,
    noPixbufDestroyNotify                   ,
    noPixbufDestroyNotify_WithClosures      ,
    wrap_PixbufDestroyNotify                ,


-- ** PixbufModuleFillInfoFunc #signal:PixbufModuleFillInfoFunc#

    C_PixbufModuleFillInfoFunc              ,
    PixbufModuleFillInfoFunc                ,
    dynamic_PixbufModuleFillInfoFunc        ,
    genClosure_PixbufModuleFillInfoFunc     ,
    mk_PixbufModuleFillInfoFunc             ,
    noPixbufModuleFillInfoFunc              ,
    wrap_PixbufModuleFillInfoFunc           ,


-- ** PixbufModuleFillVtableFunc #signal:PixbufModuleFillVtableFunc#

    C_PixbufModuleFillVtableFunc            ,
    PixbufModuleFillVtableFunc              ,
    dynamic_PixbufModuleFillVtableFunc      ,
    genClosure_PixbufModuleFillVtableFunc   ,
    mk_PixbufModuleFillVtableFunc           ,
    noPixbufModuleFillVtableFunc            ,
    wrap_PixbufModuleFillVtableFunc         ,


-- ** PixbufModuleIncrementLoadFunc #signal:PixbufModuleIncrementLoadFunc#

    C_PixbufModuleIncrementLoadFunc         ,
    PixbufModuleIncrementLoadFunc           ,
    dynamic_PixbufModuleIncrementLoadFunc   ,
    mk_PixbufModuleIncrementLoadFunc        ,
    noPixbufModuleIncrementLoadFunc         ,


-- ** PixbufModuleLoadAnimationFunc #signal:PixbufModuleLoadAnimationFunc#

    C_PixbufModuleLoadAnimationFunc         ,
    PixbufModuleLoadAnimationFunc           ,
    dynamic_PixbufModuleLoadAnimationFunc   ,
    mk_PixbufModuleLoadAnimationFunc        ,
    noPixbufModuleLoadAnimationFunc         ,


-- ** PixbufModuleLoadFunc #signal:PixbufModuleLoadFunc#

    C_PixbufModuleLoadFunc                  ,
    PixbufModuleLoadFunc                    ,
    dynamic_PixbufModuleLoadFunc            ,
    mk_PixbufModuleLoadFunc                 ,
    noPixbufModuleLoadFunc                  ,


-- ** PixbufModuleLoadXpmDataFunc #signal:PixbufModuleLoadXpmDataFunc#

    C_PixbufModuleLoadXpmDataFunc           ,
    PixbufModuleLoadXpmDataFunc             ,
    dynamic_PixbufModuleLoadXpmDataFunc     ,
    genClosure_PixbufModuleLoadXpmDataFunc  ,
    mk_PixbufModuleLoadXpmDataFunc          ,
    noPixbufModuleLoadXpmDataFunc           ,
    wrap_PixbufModuleLoadXpmDataFunc        ,


-- ** PixbufModulePreparedFunc #signal:PixbufModulePreparedFunc#

    C_PixbufModulePreparedFunc              ,
    PixbufModulePreparedFunc                ,
    PixbufModulePreparedFunc_WithClosures   ,
    drop_closures_PixbufModulePreparedFunc  ,
    dynamic_PixbufModulePreparedFunc        ,
    genClosure_PixbufModulePreparedFunc     ,
    mk_PixbufModulePreparedFunc             ,
    noPixbufModulePreparedFunc              ,
    noPixbufModulePreparedFunc_WithClosures ,
    wrap_PixbufModulePreparedFunc           ,


-- ** PixbufModuleSaveFunc #signal:PixbufModuleSaveFunc#

    C_PixbufModuleSaveFunc                  ,
    PixbufModuleSaveFunc                    ,
    dynamic_PixbufModuleSaveFunc            ,
    mk_PixbufModuleSaveFunc                 ,
    noPixbufModuleSaveFunc                  ,


-- ** PixbufModuleSaveOptionSupportedFunc #signal:PixbufModuleSaveOptionSupportedFunc#

    C_PixbufModuleSaveOptionSupportedFunc   ,
    PixbufModuleSaveOptionSupportedFunc     ,
    dynamic_PixbufModuleSaveOptionSupportedFunc,
    genClosure_PixbufModuleSaveOptionSupportedFunc,
    mk_PixbufModuleSaveOptionSupportedFunc  ,
    noPixbufModuleSaveOptionSupportedFunc   ,
    wrap_PixbufModuleSaveOptionSupportedFunc,


-- ** PixbufModuleSizeFunc #signal:PixbufModuleSizeFunc#

    C_PixbufModuleSizeFunc                  ,
    PixbufModuleSizeFunc                    ,
    PixbufModuleSizeFunc_WithClosures       ,
    drop_closures_PixbufModuleSizeFunc      ,
    dynamic_PixbufModuleSizeFunc            ,
    genClosure_PixbufModuleSizeFunc         ,
    mk_PixbufModuleSizeFunc                 ,
    noPixbufModuleSizeFunc                  ,
    noPixbufModuleSizeFunc_WithClosures     ,
    wrap_PixbufModuleSizeFunc               ,


-- ** PixbufModuleStopLoadFunc #signal:PixbufModuleStopLoadFunc#

    C_PixbufModuleStopLoadFunc              ,
    PixbufModuleStopLoadFunc                ,
    dynamic_PixbufModuleStopLoadFunc        ,
    mk_PixbufModuleStopLoadFunc             ,
    noPixbufModuleStopLoadFunc              ,


-- ** PixbufModuleUpdatedFunc #signal:PixbufModuleUpdatedFunc#

    C_PixbufModuleUpdatedFunc               ,
    PixbufModuleUpdatedFunc                 ,
    PixbufModuleUpdatedFunc_WithClosures    ,
    drop_closures_PixbufModuleUpdatedFunc   ,
    dynamic_PixbufModuleUpdatedFunc         ,
    genClosure_PixbufModuleUpdatedFunc      ,
    mk_PixbufModuleUpdatedFunc              ,
    noPixbufModuleUpdatedFunc               ,
    noPixbufModuleUpdatedFunc_WithClosures  ,
    wrap_PixbufModuleUpdatedFunc            ,


-- ** PixbufSaveFunc #signal:PixbufSaveFunc#

    C_PixbufSaveFunc                        ,
    PixbufSaveFunc                          ,
    PixbufSaveFunc_WithClosures             ,
    drop_closures_PixbufSaveFunc            ,
    dynamic_PixbufSaveFunc                  ,
    genClosure_PixbufSaveFunc               ,
    mk_PixbufSaveFunc                       ,
    noPixbufSaveFunc                        ,
    noPixbufSaveFunc_WithClosures           ,
    wrap_PixbufSaveFunc                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GModule.Structs.Module as GModule.Module
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GdkPixbuf.Enums as GdkPixbuf.Enums
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimation as GdkPixbuf.PixbufAnimation
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimationIter as GdkPixbuf.PixbufAnimationIter
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufFormat as GdkPixbuf.PixbufFormat
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModule as GdkPixbuf.PixbufModule
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModulePattern as GdkPixbuf.PixbufModulePattern
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#else
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimation as GdkPixbuf.PixbufAnimation
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufFormat as GdkPixbuf.PixbufFormat
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModule as GdkPixbuf.PixbufModule

#endif

-- callback PixbufSaveFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`TRUE` if successful, `FALSE` otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "buf"
          , argType = TCArray False (-1) 1 (TBasicType TUInt8)
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "bytes to be written."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "number of bytes in @buf."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A location to return an error."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data passed to gdk_pixbuf_save_to_callback()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Save functions used by [method@GdkPixbuf.Pixbuf.save_to_callback].\n\nThis function is called once for each block of bytes that is \"written\"\nby `gdk_pixbuf_save_to_callback()`.\n\nIf successful it should return `TRUE`; if an error occurs it should set\n`error` and return `FALSE`, in which case `gdk_pixbuf_save_to_callback()`\nwill fail with the same error."
        , sinceVersion = Just "2.4"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufSaveFunc =
    Ptr Word8 ->
    FCT.CSize ->
    Ptr (Ptr GError) ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "buf"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bytes to be written."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of bytes in @buf."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A location to return an error."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to gdk_pixbuf_save_to_callback()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of bytes in @buf."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufSaveFunc :: FunPtr C_PixbufSaveFunc -> C_PixbufSaveFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufSaveFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufSaveFunc
    -> ByteString
    -- ^ /@buf@/: bytes to be written.
    -> Ptr ()
    -- ^ /@data@/: user data passed to @/gdk_pixbuf_save_to_callback()/@.
    -> m ((Bool, GError))
    -- ^ __Returns:__ @TRUE@ if successful, @FALSE@ otherwise
dynamic_PixbufSaveFunc __funPtr buf data_ = liftIO $ do
    let count = fromIntegral $ B.length buf
    buf' <- packByteString buf
    error_ <- callocMem :: IO (Ptr (Ptr GError))
    result <- (__dynamic_C_PixbufSaveFunc __funPtr) buf' count error_ data_
    let result' = (/= 0) result
    error_' <- peek error_
    error_'' <- (wrapBoxed GError) error_'
    freeMem buf'
    freeMem error_
    return (result', error_'')

-- | Generate a function pointer callable from C code, from a `C_PixbufSaveFunc`.
foreign import ccall "wrapper"
    mk_PixbufSaveFunc :: C_PixbufSaveFunc -> IO (FunPtr C_PixbufSaveFunc)

-- | Save functions used by t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf'.@/save_to_callback/@().
-- 
-- This function is called once for each block of bytes that is \"written\"
-- by @gdk_pixbuf_save_to_callback()@.
-- 
-- If successful it should return @TRUE@; if an error occurs it should set
-- @error@ and return @FALSE@, in which case @gdk_pixbuf_save_to_callback()@
-- will fail with the same error.
-- 
-- /Since: 2.4/
type PixbufSaveFunc =
    ByteString
    -- ^ /@buf@/: bytes to be written.
    -> IO ((Bool, GError))
    -- ^ __Returns:__ @TRUE@ if successful, @FALSE@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufSaveFunc`@.
noPixbufSaveFunc :: Maybe PixbufSaveFunc
noPixbufSaveFunc = Nothing

-- | Save functions used by t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf'.@/save_to_callback/@().
-- 
-- This function is called once for each block of bytes that is \"written\"
-- by @gdk_pixbuf_save_to_callback()@.
-- 
-- If successful it should return @TRUE@; if an error occurs it should set
-- @error@ and return @FALSE@, in which case @gdk_pixbuf_save_to_callback()@
-- will fail with the same error.
-- 
-- /Since: 2.4/
type PixbufSaveFunc_WithClosures =
    ByteString
    -- ^ /@buf@/: bytes to be written.
    -> Ptr ()
    -- ^ /@data@/: user data passed to @/gdk_pixbuf_save_to_callback()/@.
    -> IO ((Bool, GError))
    -- ^ __Returns:__ @TRUE@ if successful, @FALSE@ otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufSaveFunc_WithClosures`@.
noPixbufSaveFunc_WithClosures :: Maybe PixbufSaveFunc_WithClosures
noPixbufSaveFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PixbufSaveFunc :: PixbufSaveFunc -> PixbufSaveFunc_WithClosures
drop_closures_PixbufSaveFunc _f buf _ = _f buf

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufSaveFunc :: MonadIO m => PixbufSaveFunc -> m (GClosure C_PixbufSaveFunc)
genClosure_PixbufSaveFunc cb = liftIO $ do
    let cb' = drop_closures_PixbufSaveFunc cb
    let cb'' = wrap_PixbufSaveFunc Nothing cb'
    mk_PixbufSaveFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufSaveFunc` into a `C_PixbufSaveFunc`.
wrap_PixbufSaveFunc :: 
    Maybe (Ptr (FunPtr C_PixbufSaveFunc)) ->
    PixbufSaveFunc_WithClosures ->
    C_PixbufSaveFunc
wrap_PixbufSaveFunc gi'funptrptr gi'cb buf count error_ data_ = do
    buf' <- (unpackByteStringWithLength count) buf
    (result, outerror_) <- gi'cb  buf' data_
    outerror_' <- B.ManagedPtr.disownBoxed outerror_
    poke error_ outerror_'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback PixbufModuleUpdatedFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pixbuf"
          , argType =
              TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GdkPixbuf that is currently being loaded."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the X origin of the updated area."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the Y origin of the updated area."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "width"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the width of the updated area."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "height"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the height of the updated area."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the loader." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of the function that gets called every time a region\nof @pixbuf is updated.\n\n#GdkPixbufLoader uses a function of this type to emit the\n\"<link linkend=\"GdkPixbufLoader-area-updated\">area_updated</link>\"\nsignal."
        , sinceVersion = Just "2.2"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleUpdatedFunc =
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->
    Int32 ->
    Int32 ->
    Int32 ->
    Int32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkPixbuf that is currently being loaded."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the X origin of the updated area."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the Y origin of the updated area."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width of the updated area."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the height of the updated area."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the loader." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleUpdatedFunc :: FunPtr C_PixbufModuleUpdatedFunc -> C_PixbufModuleUpdatedFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleUpdatedFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) =>
    FunPtr C_PixbufModuleUpdatedFunc
    -> a
    -- ^ /@pixbuf@/: the t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' that is currently being loaded.
    -> Int32
    -- ^ /@x@/: the X origin of the updated area.
    -> Int32
    -- ^ /@y@/: the Y origin of the updated area.
    -> Int32
    -- ^ /@width@/: the width of the updated area.
    -> Int32
    -- ^ /@height@/: the height of the updated area.
    -> Ptr ()
    -- ^ /@userData@/: the loader.
    -> m ()
dynamic_PixbufModuleUpdatedFunc __funPtr pixbuf x y width height userData = liftIO $ do
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    (__dynamic_C_PixbufModuleUpdatedFunc __funPtr) pixbuf' x y width height userData
    touchManagedPtr pixbuf
    return ()

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleUpdatedFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleUpdatedFunc :: C_PixbufModuleUpdatedFunc -> IO (FunPtr C_PixbufModuleUpdatedFunc)

-- | Defines the type of the function that gets called every time a region
-- of /@pixbuf@/ is updated.
-- 
-- t'GI.GdkPixbuf.Objects.PixbufLoader.PixbufLoader' uses a function of this type to emit the
-- \"\<link linkend=\"GdkPixbufLoader-area-updated\">area_updated\<\/link>\"
-- signal.
-- 
-- /Since: 2.2/
type PixbufModuleUpdatedFunc =
    GdkPixbuf.Pixbuf.Pixbuf
    -- ^ /@pixbuf@/: the t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' that is currently being loaded.
    -> Int32
    -- ^ /@x@/: the X origin of the updated area.
    -> Int32
    -- ^ /@y@/: the Y origin of the updated area.
    -> Int32
    -- ^ /@width@/: the width of the updated area.
    -> Int32
    -- ^ /@height@/: the height of the updated area.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleUpdatedFunc`@.
noPixbufModuleUpdatedFunc :: Maybe PixbufModuleUpdatedFunc
noPixbufModuleUpdatedFunc = Nothing

-- | Defines the type of the function that gets called every time a region
-- of /@pixbuf@/ is updated.
-- 
-- t'GI.GdkPixbuf.Objects.PixbufLoader.PixbufLoader' uses a function of this type to emit the
-- \"\<link linkend=\"GdkPixbufLoader-area-updated\">area_updated\<\/link>\"
-- signal.
-- 
-- /Since: 2.2/
type PixbufModuleUpdatedFunc_WithClosures =
    GdkPixbuf.Pixbuf.Pixbuf
    -- ^ /@pixbuf@/: the t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' that is currently being loaded.
    -> Int32
    -- ^ /@x@/: the X origin of the updated area.
    -> Int32
    -- ^ /@y@/: the Y origin of the updated area.
    -> Int32
    -- ^ /@width@/: the width of the updated area.
    -> Int32
    -- ^ /@height@/: the height of the updated area.
    -> Ptr ()
    -- ^ /@userData@/: the loader.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleUpdatedFunc_WithClosures`@.
noPixbufModuleUpdatedFunc_WithClosures :: Maybe PixbufModuleUpdatedFunc_WithClosures
noPixbufModuleUpdatedFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PixbufModuleUpdatedFunc :: PixbufModuleUpdatedFunc -> PixbufModuleUpdatedFunc_WithClosures
drop_closures_PixbufModuleUpdatedFunc _f pixbuf x y width height _ = _f pixbuf x y width height

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufModuleUpdatedFunc :: MonadIO m => PixbufModuleUpdatedFunc -> m (GClosure C_PixbufModuleUpdatedFunc)
genClosure_PixbufModuleUpdatedFunc cb = liftIO $ do
    let cb' = drop_closures_PixbufModuleUpdatedFunc cb
    let cb'' = wrap_PixbufModuleUpdatedFunc Nothing cb'
    mk_PixbufModuleUpdatedFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufModuleUpdatedFunc` into a `C_PixbufModuleUpdatedFunc`.
wrap_PixbufModuleUpdatedFunc :: 
    Maybe (Ptr (FunPtr C_PixbufModuleUpdatedFunc)) ->
    PixbufModuleUpdatedFunc_WithClosures ->
    C_PixbufModuleUpdatedFunc
wrap_PixbufModuleUpdatedFunc gi'funptrptr gi'cb pixbuf x y width height userData = do
    pixbuf' <- (newObject GdkPixbuf.Pixbuf.Pixbuf) pixbuf
    gi'cb  pixbuf' x y width height userData
    maybeReleaseFunPtr gi'funptrptr


-- callback PixbufModuleStopLoadFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "`TRUE` if the loading operation was successful"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "context"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the state object created by [callback@GdkPixbuf.PixbufModuleBeginLoadFunc]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Finalizes the image loading state.\n\nThis function is called on success and error states."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleStopLoadFunc =
    Ptr () ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "context"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the state object created by [callback@GdkPixbuf.PixbufModuleBeginLoadFunc]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleStopLoadFunc :: FunPtr C_PixbufModuleStopLoadFunc -> C_PixbufModuleStopLoadFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleStopLoadFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleStopLoadFunc
    -> Ptr ()
    -- ^ /@context@/: the state object created by [callback/@gdkPixbuf@/.PixbufModuleBeginLoadFunc]
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_PixbufModuleStopLoadFunc __funPtr context = liftIO $ do
    onException (do
        _ <- propagateGError $ (__dynamic_C_PixbufModuleStopLoadFunc __funPtr) context
        return ()
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleStopLoadFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleStopLoadFunc :: C_PixbufModuleStopLoadFunc -> IO (FunPtr C_PixbufModuleStopLoadFunc)

-- | Finalizes the image loading state.
-- 
-- This function is called on success and error states.
type PixbufModuleStopLoadFunc =
    Ptr ()
    -- ^ /@context@/: the state object created by [callback/@gdkPixbuf@/.PixbufModuleBeginLoadFunc]
    -> IO ()
    -- ^ __Returns:__ @TRUE@ if the loading operation was successful /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleStopLoadFunc`@.
noPixbufModuleStopLoadFunc :: Maybe PixbufModuleStopLoadFunc
noPixbufModuleStopLoadFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback PixbufModuleSizeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "width"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "pointer to a location containing the current image width"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "height"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "pointer to a location containing the current image height"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the loader." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of the function that gets called once the size\nof the loaded image is known.\n\nThe function is expected to set @width and @height to the desired\nsize to which the image should be scaled. If a module has no efficient\nway to achieve the desired scaling during the loading of the image, it may\neither ignore the size request, or only approximate it - gdk-pixbuf will\nthen perform the required scaling on the completely loaded image.\n\nIf the function sets @width or @height to zero, the module should interpret\nthis as a hint that it will be closed soon and shouldn't allocate further\nresources. This convention is used to implement gdk_pixbuf_get_file_info()\nefficiently."
        , sinceVersion = Just "2.2"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleSizeFunc =
    Int32 ->
    Int32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to a location containing the current image width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to a location containing the current image height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the loader." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleSizeFunc :: FunPtr C_PixbufModuleSizeFunc -> C_PixbufModuleSizeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleSizeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleSizeFunc
    -> Int32
    -- ^ /@width@/: pointer to a location containing the current image width
    -> Int32
    -- ^ /@height@/: pointer to a location containing the current image height
    -> Ptr ()
    -- ^ /@userData@/: the loader.
    -> m ()
dynamic_PixbufModuleSizeFunc __funPtr width height userData = liftIO $ do
    (__dynamic_C_PixbufModuleSizeFunc __funPtr) width height userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleSizeFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleSizeFunc :: C_PixbufModuleSizeFunc -> IO (FunPtr C_PixbufModuleSizeFunc)

-- | Defines the type of the function that gets called once the size
-- of the loaded image is known.
-- 
-- The function is expected to set /@width@/ and /@height@/ to the desired
-- size to which the image should be scaled. If a module has no efficient
-- way to achieve the desired scaling during the loading of the image, it may
-- either ignore the size request, or only approximate it - gdk-pixbuf will
-- then perform the required scaling on the completely loaded image.
-- 
-- If the function sets /@width@/ or /@height@/ to zero, the module should interpret
-- this as a hint that it will be closed soon and shouldn\'t allocate further
-- resources. This convention is used to implement 'GI.GdkPixbuf.Objects.Pixbuf.pixbufGetFileInfo'
-- efficiently.
-- 
-- /Since: 2.2/
type PixbufModuleSizeFunc =
    Int32
    -- ^ /@width@/: pointer to a location containing the current image width
    -> Int32
    -- ^ /@height@/: pointer to a location containing the current image height
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleSizeFunc`@.
noPixbufModuleSizeFunc :: Maybe PixbufModuleSizeFunc
noPixbufModuleSizeFunc = Nothing

-- | Defines the type of the function that gets called once the size
-- of the loaded image is known.
-- 
-- The function is expected to set /@width@/ and /@height@/ to the desired
-- size to which the image should be scaled. If a module has no efficient
-- way to achieve the desired scaling during the loading of the image, it may
-- either ignore the size request, or only approximate it - gdk-pixbuf will
-- then perform the required scaling on the completely loaded image.
-- 
-- If the function sets /@width@/ or /@height@/ to zero, the module should interpret
-- this as a hint that it will be closed soon and shouldn\'t allocate further
-- resources. This convention is used to implement 'GI.GdkPixbuf.Objects.Pixbuf.pixbufGetFileInfo'
-- efficiently.
-- 
-- /Since: 2.2/
type PixbufModuleSizeFunc_WithClosures =
    Int32
    -- ^ /@width@/: pointer to a location containing the current image width
    -> Int32
    -- ^ /@height@/: pointer to a location containing the current image height
    -> Ptr ()
    -- ^ /@userData@/: the loader.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleSizeFunc_WithClosures`@.
noPixbufModuleSizeFunc_WithClosures :: Maybe PixbufModuleSizeFunc_WithClosures
noPixbufModuleSizeFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PixbufModuleSizeFunc :: PixbufModuleSizeFunc -> PixbufModuleSizeFunc_WithClosures
drop_closures_PixbufModuleSizeFunc _f width height _ = _f width height

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufModuleSizeFunc :: MonadIO m => PixbufModuleSizeFunc -> m (GClosure C_PixbufModuleSizeFunc)
genClosure_PixbufModuleSizeFunc cb = liftIO $ do
    let cb' = drop_closures_PixbufModuleSizeFunc cb
    let cb'' = wrap_PixbufModuleSizeFunc Nothing cb'
    mk_PixbufModuleSizeFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufModuleSizeFunc` into a `C_PixbufModuleSizeFunc`.
wrap_PixbufModuleSizeFunc :: 
    Maybe (Ptr (FunPtr C_PixbufModuleSizeFunc)) ->
    PixbufModuleSizeFunc_WithClosures ->
    C_PixbufModuleSizeFunc
wrap_PixbufModuleSizeFunc gi'funptrptr gi'cb width height userData = do
    gi'cb  width height userData
    maybeReleaseFunPtr gi'funptrptr


-- callback PixbufModuleSaveOptionSupportedFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`TRUE` if the option is supported"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "option_key"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the option key to check"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Checks whether the given `option_key` is supported when saving."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleSaveOptionSupportedFunc =
    CString ->
    IO CInt

-- Args: [ Arg
--           { argCName = "option_key"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the option key to check"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleSaveOptionSupportedFunc :: FunPtr C_PixbufModuleSaveOptionSupportedFunc -> C_PixbufModuleSaveOptionSupportedFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleSaveOptionSupportedFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleSaveOptionSupportedFunc
    -> T.Text
    -- ^ /@optionKey@/: the option key to check
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the option is supported
dynamic_PixbufModuleSaveOptionSupportedFunc __funPtr optionKey = liftIO $ do
    optionKey' <- textToCString optionKey
    result <- (__dynamic_C_PixbufModuleSaveOptionSupportedFunc __funPtr) optionKey'
    let result' = (/= 0) result
    freeMem optionKey'
    return result'

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleSaveOptionSupportedFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleSaveOptionSupportedFunc :: C_PixbufModuleSaveOptionSupportedFunc -> IO (FunPtr C_PixbufModuleSaveOptionSupportedFunc)

-- | Checks whether the given @option_key@ is supported when saving.
type PixbufModuleSaveOptionSupportedFunc =
    T.Text
    -- ^ /@optionKey@/: the option key to check
    -> IO Bool
    -- ^ __Returns:__ @TRUE@ if the option is supported

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleSaveOptionSupportedFunc`@.
noPixbufModuleSaveOptionSupportedFunc :: Maybe PixbufModuleSaveOptionSupportedFunc
noPixbufModuleSaveOptionSupportedFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufModuleSaveOptionSupportedFunc :: MonadIO m => PixbufModuleSaveOptionSupportedFunc -> m (GClosure C_PixbufModuleSaveOptionSupportedFunc)
genClosure_PixbufModuleSaveOptionSupportedFunc cb = liftIO $ do
    let cb' = wrap_PixbufModuleSaveOptionSupportedFunc Nothing cb
    mk_PixbufModuleSaveOptionSupportedFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufModuleSaveOptionSupportedFunc` into a `C_PixbufModuleSaveOptionSupportedFunc`.
wrap_PixbufModuleSaveOptionSupportedFunc :: 
    Maybe (Ptr (FunPtr C_PixbufModuleSaveOptionSupportedFunc)) ->
    PixbufModuleSaveOptionSupportedFunc ->
    C_PixbufModuleSaveOptionSupportedFunc
wrap_PixbufModuleSaveOptionSupportedFunc gi'funptrptr gi'cb optionKey = do
    optionKey' <- cstringToText optionKey
    result <- gi'cb  optionKey'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback PixbufModuleSaveFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "`TRUE` on success; in case of failure, `FALSE` is returned and\n  the `error` is set"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "f"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the file stream into which the image should be saved"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pixbuf"
          , argType =
              TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the image to save" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "param_keys"
          , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "parameter keys to save"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "param_values"
          , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "parameter values to save"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Saves a `GdkPixbuf` into a standard C file stream.\n\nThe optional `param_keys` and `param_values` arrays contain the keys and\nvalues (in the same order) for attributes to be saved alongside the image\ndata."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleSaveFunc =
    Ptr () ->
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->
    Ptr CString ->
    Ptr CString ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "f"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the file stream into which the image should be saved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the image to save" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_keys"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "parameter keys to save"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "parameter values to save"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleSaveFunc :: FunPtr C_PixbufModuleSaveFunc -> C_PixbufModuleSaveFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleSaveFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) =>
    FunPtr C_PixbufModuleSaveFunc
    -> Ptr ()
    -- ^ /@f@/: the file stream into which the image should be saved
    -> a
    -- ^ /@pixbuf@/: the image to save
    -> Maybe ([T.Text])
    -- ^ /@paramKeys@/: parameter keys to save
    -> Maybe ([T.Text])
    -- ^ /@paramValues@/: parameter values to save
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_PixbufModuleSaveFunc __funPtr f pixbuf paramKeys paramValues = liftIO $ do
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    maybeParamKeys <- case paramKeys of
        Nothing -> return FP.nullPtr
        Just jParamKeys -> do
            jParamKeys' <- packZeroTerminatedUTF8CArray jParamKeys
            return jParamKeys'
    maybeParamValues <- case paramValues of
        Nothing -> return FP.nullPtr
        Just jParamValues -> do
            jParamValues' <- packZeroTerminatedUTF8CArray jParamValues
            return jParamValues'
    onException (do
        _ <- propagateGError $ (__dynamic_C_PixbufModuleSaveFunc __funPtr) f pixbuf' maybeParamKeys maybeParamValues
        touchManagedPtr pixbuf
        mapZeroTerminatedCArray freeMem maybeParamKeys
        freeMem maybeParamKeys
        mapZeroTerminatedCArray freeMem maybeParamValues
        freeMem maybeParamValues
        return ()
     ) (do
        mapZeroTerminatedCArray freeMem maybeParamKeys
        freeMem maybeParamKeys
        mapZeroTerminatedCArray freeMem maybeParamValues
        freeMem maybeParamValues
     )

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleSaveFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleSaveFunc :: C_PixbufModuleSaveFunc -> IO (FunPtr C_PixbufModuleSaveFunc)

-- | Saves a @GdkPixbuf@ into a standard C file stream.
-- 
-- The optional @param_keys@ and @param_values@ arrays contain the keys and
-- values (in the same order) for attributes to be saved alongside the image
-- data.
type PixbufModuleSaveFunc =
    Ptr ()
    -- ^ /@f@/: the file stream into which the image should be saved
    -> GdkPixbuf.Pixbuf.Pixbuf
    -- ^ /@pixbuf@/: the image to save
    -> Maybe [T.Text]
    -- ^ /@paramKeys@/: parameter keys to save
    -> Maybe [T.Text]
    -- ^ /@paramValues@/: parameter values to save
    -> IO ()
    -- ^ __Returns:__ @TRUE@ on success; in case of failure, @FALSE@ is returned and
    --   the @error@ is set /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleSaveFunc`@.
noPixbufModuleSaveFunc :: Maybe PixbufModuleSaveFunc
noPixbufModuleSaveFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback PixbufModulePreparedFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pixbuf"
          , argType =
              TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GdkPixbuf that is currently being loaded."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "anim"
          , argType =
              TInterface
                Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "if an animation is being loaded, the #GdkPixbufAnimation, else %NULL."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the loader." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of the function that gets called once the initial\nsetup of @pixbuf is done.\n\n#GdkPixbufLoader uses a function of this type to emit the\n\"<link linkend=\"GdkPixbufLoader-area-prepared\">area_prepared</link>\"\nsignal."
        , sinceVersion = Just "2.2"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModulePreparedFunc =
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->
    Ptr GdkPixbuf.PixbufAnimation.PixbufAnimation ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkPixbuf that is currently being loaded."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "anim"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if an animation is being loaded, the #GdkPixbufAnimation, else %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the loader." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModulePreparedFunc :: FunPtr C_PixbufModulePreparedFunc -> C_PixbufModulePreparedFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModulePreparedFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a, GdkPixbuf.PixbufAnimation.IsPixbufAnimation b) =>
    FunPtr C_PixbufModulePreparedFunc
    -> a
    -- ^ /@pixbuf@/: the t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' that is currently being loaded.
    -> b
    -- ^ /@anim@/: if an animation is being loaded, the t'GI.GdkPixbuf.Objects.PixbufAnimation.PixbufAnimation', else 'P.Nothing'.
    -> Ptr ()
    -- ^ /@userData@/: the loader.
    -> m ()
dynamic_PixbufModulePreparedFunc __funPtr pixbuf anim userData = liftIO $ do
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    anim' <- unsafeManagedPtrCastPtr anim
    (__dynamic_C_PixbufModulePreparedFunc __funPtr) pixbuf' anim' userData
    touchManagedPtr pixbuf
    touchManagedPtr anim
    return ()

-- | Generate a function pointer callable from C code, from a `C_PixbufModulePreparedFunc`.
foreign import ccall "wrapper"
    mk_PixbufModulePreparedFunc :: C_PixbufModulePreparedFunc -> IO (FunPtr C_PixbufModulePreparedFunc)

-- | Defines the type of the function that gets called once the initial
-- setup of /@pixbuf@/ is done.
-- 
-- t'GI.GdkPixbuf.Objects.PixbufLoader.PixbufLoader' uses a function of this type to emit the
-- \"\<link linkend=\"GdkPixbufLoader-area-prepared\">area_prepared\<\/link>\"
-- signal.
-- 
-- /Since: 2.2/
type PixbufModulePreparedFunc =
    GdkPixbuf.Pixbuf.Pixbuf
    -- ^ /@pixbuf@/: the t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' that is currently being loaded.
    -> GdkPixbuf.PixbufAnimation.PixbufAnimation
    -- ^ /@anim@/: if an animation is being loaded, the t'GI.GdkPixbuf.Objects.PixbufAnimation.PixbufAnimation', else 'P.Nothing'.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModulePreparedFunc`@.
noPixbufModulePreparedFunc :: Maybe PixbufModulePreparedFunc
noPixbufModulePreparedFunc = Nothing

-- | Defines the type of the function that gets called once the initial
-- setup of /@pixbuf@/ is done.
-- 
-- t'GI.GdkPixbuf.Objects.PixbufLoader.PixbufLoader' uses a function of this type to emit the
-- \"\<link linkend=\"GdkPixbufLoader-area-prepared\">area_prepared\<\/link>\"
-- signal.
-- 
-- /Since: 2.2/
type PixbufModulePreparedFunc_WithClosures =
    GdkPixbuf.Pixbuf.Pixbuf
    -- ^ /@pixbuf@/: the t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf' that is currently being loaded.
    -> GdkPixbuf.PixbufAnimation.PixbufAnimation
    -- ^ /@anim@/: if an animation is being loaded, the t'GI.GdkPixbuf.Objects.PixbufAnimation.PixbufAnimation', else 'P.Nothing'.
    -> Ptr ()
    -- ^ /@userData@/: the loader.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModulePreparedFunc_WithClosures`@.
noPixbufModulePreparedFunc_WithClosures :: Maybe PixbufModulePreparedFunc_WithClosures
noPixbufModulePreparedFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PixbufModulePreparedFunc :: PixbufModulePreparedFunc -> PixbufModulePreparedFunc_WithClosures
drop_closures_PixbufModulePreparedFunc _f pixbuf anim _ = _f pixbuf anim

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufModulePreparedFunc :: MonadIO m => PixbufModulePreparedFunc -> m (GClosure C_PixbufModulePreparedFunc)
genClosure_PixbufModulePreparedFunc cb = liftIO $ do
    let cb' = drop_closures_PixbufModulePreparedFunc cb
    let cb'' = wrap_PixbufModulePreparedFunc Nothing cb'
    mk_PixbufModulePreparedFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufModulePreparedFunc` into a `C_PixbufModulePreparedFunc`.
wrap_PixbufModulePreparedFunc :: 
    Maybe (Ptr (FunPtr C_PixbufModulePreparedFunc)) ->
    PixbufModulePreparedFunc_WithClosures ->
    C_PixbufModulePreparedFunc
wrap_PixbufModulePreparedFunc gi'funptrptr gi'cb pixbuf anim userData = do
    pixbuf' <- (newObject GdkPixbuf.Pixbuf.Pixbuf) pixbuf
    anim' <- (newObject GdkPixbuf.PixbufAnimation.PixbufAnimation) anim
    gi'cb  pixbuf' anim' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback PixbufModuleLoadXpmDataFunc
{- Callable
  { returnType =
      Just
        (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a newly created `GdkPixbuf` for the XPM data"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the XPM data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText = Just "Loads XPM data into a new `GdkPixbuf`."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleLoadXpmDataFunc =
    Ptr CString ->
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the XPM data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleLoadXpmDataFunc :: FunPtr C_PixbufModuleLoadXpmDataFunc -> C_PixbufModuleLoadXpmDataFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleLoadXpmDataFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleLoadXpmDataFunc
    -> [T.Text]
    -- ^ /@data@/: the XPM data
    -> m GdkPixbuf.Pixbuf.Pixbuf
    -- ^ __Returns:__ a newly created @GdkPixbuf@ for the XPM data
dynamic_PixbufModuleLoadXpmDataFunc __funPtr data_ = liftIO $ do
    data_' <- packZeroTerminatedUTF8CArray data_
    result <- (__dynamic_C_PixbufModuleLoadXpmDataFunc __funPtr) data_'
    checkUnexpectedReturnNULL "pixbufModuleLoadXpmDataFunc" result
    result' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result
    mapZeroTerminatedCArray freeMem data_'
    freeMem data_'
    return result'

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleLoadXpmDataFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleLoadXpmDataFunc :: C_PixbufModuleLoadXpmDataFunc -> IO (FunPtr C_PixbufModuleLoadXpmDataFunc)

-- | Loads XPM data into a new @GdkPixbuf@.
type PixbufModuleLoadXpmDataFunc =
    [T.Text]
    -- ^ /@data@/: the XPM data
    -> IO GdkPixbuf.Pixbuf.Pixbuf
    -- ^ __Returns:__ a newly created @GdkPixbuf@ for the XPM data

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleLoadXpmDataFunc`@.
noPixbufModuleLoadXpmDataFunc :: Maybe PixbufModuleLoadXpmDataFunc
noPixbufModuleLoadXpmDataFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufModuleLoadXpmDataFunc :: MonadIO m => PixbufModuleLoadXpmDataFunc -> m (GClosure C_PixbufModuleLoadXpmDataFunc)
genClosure_PixbufModuleLoadXpmDataFunc cb = liftIO $ do
    let cb' = wrap_PixbufModuleLoadXpmDataFunc Nothing cb
    mk_PixbufModuleLoadXpmDataFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufModuleLoadXpmDataFunc` into a `C_PixbufModuleLoadXpmDataFunc`.
wrap_PixbufModuleLoadXpmDataFunc :: 
    Maybe (Ptr (FunPtr C_PixbufModuleLoadXpmDataFunc)) ->
    PixbufModuleLoadXpmDataFunc ->
    C_PixbufModuleLoadXpmDataFunc
wrap_PixbufModuleLoadXpmDataFunc gi'funptrptr gi'cb data_ = do
    data_' <- unpackZeroTerminatedUTF8CArray data_
    result <- gi'cb  data_'
    maybeReleaseFunPtr gi'funptrptr
    result' <- B.ManagedPtr.disownObject result
    return result'


-- callback PixbufModuleLoadFunc
{- Callable
  { returnType =
      Just
        (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "a newly created `GdkPixbuf` for the contents of the file"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "f"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the file stream from which the image should be loaded"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Loads a file from a standard C file stream into a new `GdkPixbuf`.\n\nIn case of error, this function should return `NULL` and set the `error` argument."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleLoadFunc =
    Ptr () ->
    Ptr (Ptr GError) ->
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

-- Args: [ Arg
--           { argCName = "f"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the file stream from which the image should be loaded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleLoadFunc :: FunPtr C_PixbufModuleLoadFunc -> C_PixbufModuleLoadFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleLoadFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleLoadFunc
    -> Ptr ()
    -- ^ /@f@/: the file stream from which the image should be loaded
    -> m GdkPixbuf.Pixbuf.Pixbuf
    -- ^ __Returns:__ a newly created @GdkPixbuf@ for the contents of the file /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_PixbufModuleLoadFunc __funPtr f = liftIO $ do
    onException (do
        result <- propagateGError $ (__dynamic_C_PixbufModuleLoadFunc __funPtr) f
        checkUnexpectedReturnNULL "pixbufModuleLoadFunc" result
        result' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result
        return result'
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleLoadFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleLoadFunc :: C_PixbufModuleLoadFunc -> IO (FunPtr C_PixbufModuleLoadFunc)

-- | Loads a file from a standard C file stream into a new @GdkPixbuf@.
-- 
-- In case of error, this function should return @NULL@ and set the @error@ argument.
type PixbufModuleLoadFunc =
    Ptr ()
    -- ^ /@f@/: the file stream from which the image should be loaded
    -> IO GdkPixbuf.Pixbuf.Pixbuf
    -- ^ __Returns:__ a newly created @GdkPixbuf@ for the contents of the file /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleLoadFunc`@.
noPixbufModuleLoadFunc :: Maybe PixbufModuleLoadFunc
noPixbufModuleLoadFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback PixbufModuleLoadAnimationFunc
{- Callable
  { returnType =
      Just
        (TInterface
           Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "a newly created `GdkPixbufAnimation` for the contents of the file"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "f"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the file stream from which the image should be loaded"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Loads a file from a standard C file stream into a new `GdkPixbufAnimation`.\n\nIn case of error, this function should return `NULL` and set the `error` argument."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleLoadAnimationFunc =
    Ptr () ->
    Ptr (Ptr GError) ->
    IO (Ptr GdkPixbuf.PixbufAnimation.PixbufAnimation)

-- Args: [ Arg
--           { argCName = "f"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the file stream from which the image should be loaded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufAnimation" })
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleLoadAnimationFunc :: FunPtr C_PixbufModuleLoadAnimationFunc -> C_PixbufModuleLoadAnimationFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleLoadAnimationFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleLoadAnimationFunc
    -> Ptr ()
    -- ^ /@f@/: the file stream from which the image should be loaded
    -> m GdkPixbuf.PixbufAnimation.PixbufAnimation
    -- ^ __Returns:__ a newly created @GdkPixbufAnimation@ for the contents of the file /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_PixbufModuleLoadAnimationFunc __funPtr f = liftIO $ do
    onException (do
        result <- propagateGError $ (__dynamic_C_PixbufModuleLoadAnimationFunc __funPtr) f
        checkUnexpectedReturnNULL "pixbufModuleLoadAnimationFunc" result
        result' <- (wrapObject GdkPixbuf.PixbufAnimation.PixbufAnimation) result
        return result'
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleLoadAnimationFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleLoadAnimationFunc :: C_PixbufModuleLoadAnimationFunc -> IO (FunPtr C_PixbufModuleLoadAnimationFunc)

-- | Loads a file from a standard C file stream into a new @GdkPixbufAnimation@.
-- 
-- In case of error, this function should return @NULL@ and set the @error@ argument.
type PixbufModuleLoadAnimationFunc =
    Ptr ()
    -- ^ /@f@/: the file stream from which the image should be loaded
    -> IO GdkPixbuf.PixbufAnimation.PixbufAnimation
    -- ^ __Returns:__ a newly created @GdkPixbufAnimation@ for the contents of the file /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleLoadAnimationFunc`@.
noPixbufModuleLoadAnimationFunc :: Maybe PixbufModuleLoadAnimationFunc
noPixbufModuleLoadAnimationFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback PixbufModuleIncrementLoadFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "`TRUE` if the incremental load was successful"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "context"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the state object created by [callback@GdkPixbuf.PixbufModuleBeginLoadFunc]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "buf"
          , argType = TCArray False (-1) 2 (TBasicType TUInt8)
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the data to load" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "size"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the length of the data to load"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Incrementally loads a buffer into the image data."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleIncrementLoadFunc =
    Ptr () ->
    Ptr Word8 ->
    Word32 ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "context"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the state object created by [callback@GdkPixbuf.PixbufModuleBeginLoadFunc]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buf"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to load" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of the data to load"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "size"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of the data to load"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleIncrementLoadFunc :: FunPtr C_PixbufModuleIncrementLoadFunc -> C_PixbufModuleIncrementLoadFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleIncrementLoadFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleIncrementLoadFunc
    -> Ptr ()
    -- ^ /@context@/: the state object created by [callback/@gdkPixbuf@/.PixbufModuleBeginLoadFunc]
    -> ByteString
    -- ^ /@buf@/: the data to load
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_PixbufModuleIncrementLoadFunc __funPtr context buf = liftIO $ do
    let size = fromIntegral $ B.length buf
    buf' <- packByteString buf
    onException (do
        _ <- propagateGError $ (__dynamic_C_PixbufModuleIncrementLoadFunc __funPtr) context buf' size
        freeMem buf'
        return ()
     ) (do
        freeMem buf'
     )

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleIncrementLoadFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleIncrementLoadFunc :: C_PixbufModuleIncrementLoadFunc -> IO (FunPtr C_PixbufModuleIncrementLoadFunc)

-- | Incrementally loads a buffer into the image data.
type PixbufModuleIncrementLoadFunc =
    Ptr ()
    -- ^ /@context@/: the state object created by [callback/@gdkPixbuf@/.PixbufModuleBeginLoadFunc]
    -> ByteString
    -- ^ /@buf@/: the data to load
    -> IO ()
    -- ^ __Returns:__ @TRUE@ if the incremental load was successful /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleIncrementLoadFunc`@.
noPixbufModuleIncrementLoadFunc :: Maybe PixbufModuleIncrementLoadFunc
noPixbufModuleIncrementLoadFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback PixbufModuleFillVtableFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "module"
          , argType =
              TInterface Name { namespace = "GdkPixbuf" , name = "PixbufModule" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GdkPixbufModule."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of the function used to set the vtable of a\n#GdkPixbufModule when it is loaded."
        , sinceVersion = Just "2.2"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleFillVtableFunc =
    Ptr GdkPixbuf.PixbufModule.PixbufModule ->
    IO ()

-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufModule" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufModule."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleFillVtableFunc :: FunPtr C_PixbufModuleFillVtableFunc -> C_PixbufModuleFillVtableFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleFillVtableFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleFillVtableFunc
    -> GdkPixbuf.PixbufModule.PixbufModule
    -- ^ /@module@/: a t'GI.GdkPixbuf.Structs.PixbufModule.PixbufModule'.
    -> m ()
dynamic_PixbufModuleFillVtableFunc __funPtr module_ = liftIO $ do
    module_' <- unsafeManagedPtrGetPtr module_
    (__dynamic_C_PixbufModuleFillVtableFunc __funPtr) module_'
    touchManagedPtr module_
    return ()

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleFillVtableFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleFillVtableFunc :: C_PixbufModuleFillVtableFunc -> IO (FunPtr C_PixbufModuleFillVtableFunc)

-- | Defines the type of the function used to set the vtable of a
-- t'GI.GdkPixbuf.Structs.PixbufModule.PixbufModule' when it is loaded.
-- 
-- /Since: 2.2/
type PixbufModuleFillVtableFunc =
    GdkPixbuf.PixbufModule.PixbufModule
    -- ^ /@module@/: a t'GI.GdkPixbuf.Structs.PixbufModule.PixbufModule'.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleFillVtableFunc`@.
noPixbufModuleFillVtableFunc :: Maybe PixbufModuleFillVtableFunc
noPixbufModuleFillVtableFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufModuleFillVtableFunc :: MonadIO m => PixbufModuleFillVtableFunc -> m (GClosure C_PixbufModuleFillVtableFunc)
genClosure_PixbufModuleFillVtableFunc cb = liftIO $ do
    let cb' = wrap_PixbufModuleFillVtableFunc Nothing cb
    mk_PixbufModuleFillVtableFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufModuleFillVtableFunc` into a `C_PixbufModuleFillVtableFunc`.
wrap_PixbufModuleFillVtableFunc :: 
    Maybe (Ptr (FunPtr C_PixbufModuleFillVtableFunc)) ->
    PixbufModuleFillVtableFunc ->
    C_PixbufModuleFillVtableFunc
wrap_PixbufModuleFillVtableFunc gi'funptrptr gi'cb module_ = do
    module_' <- (newPtr GdkPixbuf.PixbufModule.PixbufModule) module_
    gi'cb  module_'
    maybeReleaseFunPtr gi'funptrptr


-- callback PixbufModuleFillInfoFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "info"
          , argType =
              TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GdkPixbufFormat."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of the function used to fill a\n#GdkPixbufFormat structure with information about a module."
        , sinceVersion = Just "2.2"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufModuleFillInfoFunc =
    Ptr GdkPixbuf.PixbufFormat.PixbufFormat ->
    IO ()

-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufFormat."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufModuleFillInfoFunc :: FunPtr C_PixbufModuleFillInfoFunc -> C_PixbufModuleFillInfoFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufModuleFillInfoFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufModuleFillInfoFunc
    -> GdkPixbuf.PixbufFormat.PixbufFormat
    -- ^ /@info@/: a t'GI.GdkPixbuf.Structs.PixbufFormat.PixbufFormat'.
    -> m ()
dynamic_PixbufModuleFillInfoFunc __funPtr info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    (__dynamic_C_PixbufModuleFillInfoFunc __funPtr) info'
    touchManagedPtr info
    return ()

-- | Generate a function pointer callable from C code, from a `C_PixbufModuleFillInfoFunc`.
foreign import ccall "wrapper"
    mk_PixbufModuleFillInfoFunc :: C_PixbufModuleFillInfoFunc -> IO (FunPtr C_PixbufModuleFillInfoFunc)

-- | Defines the type of the function used to fill a
-- t'GI.GdkPixbuf.Structs.PixbufFormat.PixbufFormat' structure with information about a module.
-- 
-- /Since: 2.2/
type PixbufModuleFillInfoFunc =
    GdkPixbuf.PixbufFormat.PixbufFormat
    -- ^ /@info@/: a t'GI.GdkPixbuf.Structs.PixbufFormat.PixbufFormat'.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufModuleFillInfoFunc`@.
noPixbufModuleFillInfoFunc :: Maybe PixbufModuleFillInfoFunc
noPixbufModuleFillInfoFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufModuleFillInfoFunc :: MonadIO m => PixbufModuleFillInfoFunc -> m (GClosure C_PixbufModuleFillInfoFunc)
genClosure_PixbufModuleFillInfoFunc cb = liftIO $ do
    let cb' = wrap_PixbufModuleFillInfoFunc Nothing cb
    mk_PixbufModuleFillInfoFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufModuleFillInfoFunc` into a `C_PixbufModuleFillInfoFunc`.
wrap_PixbufModuleFillInfoFunc :: 
    Maybe (Ptr (FunPtr C_PixbufModuleFillInfoFunc)) ->
    PixbufModuleFillInfoFunc ->
    C_PixbufModuleFillInfoFunc
wrap_PixbufModuleFillInfoFunc gi'funptrptr gi'cb info = do
    B.ManagedPtr.withTransient  info $ \info' -> do
        gi'cb  info'
        maybeReleaseFunPtr gi'funptrptr


-- callback PixbufDestroyNotify
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pixels"
          , argType = TCArray False (-1) (-1) (TBasicType TUInt8)
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The pixel array of the pixbuf\n  that is being finalized."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User closure data." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function of this type is responsible for freeing the pixel array\nof a pixbuf.\n\nThe gdk_pixbuf_new_from_data() function lets you pass in a pre-allocated\npixel array so that a pixbuf can be created from it; in this case you\nwill need to pass in a function of type `GdkPixbufDestroyNotify` so that\nthe pixel data can be freed when the pixbuf is finalized."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PixbufDestroyNotify =
    Ptr Word8 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "pixels"
--           , argType = TCArray False (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The pixel array of the pixbuf\n  that is being finalized."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User closure data." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PixbufDestroyNotify :: FunPtr C_PixbufDestroyNotify -> C_PixbufDestroyNotify

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PixbufDestroyNotify ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PixbufDestroyNotify
    -> Ptr Word8
    -- ^ /@pixels@/: The pixel array of the pixbuf
    --   that is being finalized.
    -> Ptr ()
    -- ^ /@data@/: User closure data.
    -> m ()
dynamic_PixbufDestroyNotify __funPtr pixels data_ = liftIO $ do
    (__dynamic_C_PixbufDestroyNotify __funPtr) pixels data_
    return ()

-- | Generate a function pointer callable from C code, from a `C_PixbufDestroyNotify`.
foreign import ccall "wrapper"
    mk_PixbufDestroyNotify :: C_PixbufDestroyNotify -> IO (FunPtr C_PixbufDestroyNotify)

-- | A function of this type is responsible for freeing the pixel array
-- of a pixbuf.
-- 
-- The 'GI.GdkPixbuf.Objects.Pixbuf.pixbufNewFromData' function lets you pass in a pre-allocated
-- pixel array so that a pixbuf can be created from it; in this case you
-- will need to pass in a function of type @GdkPixbufDestroyNotify@ so that
-- the pixel data can be freed when the pixbuf is finalized.
type PixbufDestroyNotify =
    Ptr Word8
    -- ^ /@pixels@/: The pixel array of the pixbuf
    --   that is being finalized.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufDestroyNotify`@.
noPixbufDestroyNotify :: Maybe PixbufDestroyNotify
noPixbufDestroyNotify = Nothing

-- | A function of this type is responsible for freeing the pixel array
-- of a pixbuf.
-- 
-- The 'GI.GdkPixbuf.Objects.Pixbuf.pixbufNewFromData' function lets you pass in a pre-allocated
-- pixel array so that a pixbuf can be created from it; in this case you
-- will need to pass in a function of type @GdkPixbufDestroyNotify@ so that
-- the pixel data can be freed when the pixbuf is finalized.
type PixbufDestroyNotify_WithClosures =
    Ptr Word8
    -- ^ /@pixels@/: The pixel array of the pixbuf
    --   that is being finalized.
    -> Ptr ()
    -- ^ /@data@/: User closure data.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PixbufDestroyNotify_WithClosures`@.
noPixbufDestroyNotify_WithClosures :: Maybe PixbufDestroyNotify_WithClosures
noPixbufDestroyNotify_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PixbufDestroyNotify :: PixbufDestroyNotify -> PixbufDestroyNotify_WithClosures
drop_closures_PixbufDestroyNotify _f pixels _ = _f pixels

-- | Wrap the callback into a `GClosure`.
genClosure_PixbufDestroyNotify :: MonadIO m => PixbufDestroyNotify -> m (GClosure C_PixbufDestroyNotify)
genClosure_PixbufDestroyNotify cb = liftIO $ do
    let cb' = drop_closures_PixbufDestroyNotify cb
    let cb'' = wrap_PixbufDestroyNotify Nothing cb'
    mk_PixbufDestroyNotify cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PixbufDestroyNotify` into a `C_PixbufDestroyNotify`.
wrap_PixbufDestroyNotify :: 
    Maybe (Ptr (FunPtr C_PixbufDestroyNotify)) ->
    PixbufDestroyNotify_WithClosures ->
    C_PixbufDestroyNotify
wrap_PixbufDestroyNotify gi'funptrptr gi'cb pixels data_ = do
    gi'cb  pixels data_
    maybeReleaseFunPtr gi'funptrptr



