/* This file is auto-generated; changes will not be preserved */

#include "config.h"

#include "gskgpubluropprivate.h"

#include "gskgpushaderopprivate.h"
#include "gskrectprivate.h"
#include <graphene.h>


typedef struct _GskGpuBlurInstance GskGpuBlurInstance;

struct _GskGpuBlurInstance {
  float rect[4];
  float blur_color[4];
  float tex_rect[4];
  float blur_direction[4];
};

static void
gsk_gpu_blur_op_print_instance (GskGpuShaderOp *shader,
                                gpointer        instance,
                                GString        *string)
{
  /* FIXME: Implement */
}

static inline void
gsk_gpu_blur_setup_vao (gsize offset)
{
  glEnableVertexAttribArray (0);
  glVertexAttribDivisor (0, 1);
  glVertexAttribPointer (0,
                         4,
                         GL_FLOAT,
                         GL_FALSE,
                         64,
                         GSIZE_TO_POINTER (offset + 0));
  glEnableVertexAttribArray (1);
  glVertexAttribDivisor (1, 1);
  glVertexAttribPointer (1,
                         4,
                         GL_FLOAT,
                         GL_FALSE,
                         64,
                         GSIZE_TO_POINTER (offset + 16));
  glEnableVertexAttribArray (2);
  glVertexAttribDivisor (2, 1);
  glVertexAttribPointer (2,
                         4,
                         GL_FLOAT,
                         GL_FALSE,
                         64,
                         GSIZE_TO_POINTER (offset + 32));
  glEnableVertexAttribArray (3);
  glVertexAttribDivisor (3, 1);
  glVertexAttribPointer (3,
                         2,
                         GL_FLOAT,
                         GL_FALSE,
                         64,
                         GSIZE_TO_POINTER (offset + 48));
}

static inline void
gsk_gpu_blur_setup_attrib_locations (GLuint program)
{
  glBindAttribLocation (program, 0, "in_rect");
  glBindAttribLocation (program, 1, "in_blur_color");
  glBindAttribLocation (program, 2, "in_tex_rect");
  glBindAttribLocation (program, 3, "in_blur_direction");
}

#ifdef GDK_RENDERING_VULKAN

static const VkPipelineVertexInputStateCreateInfo gsk_gpu_blur_info = {
  .sType = VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO,
  .vertexBindingDescriptionCount = 1,
  .pVertexBindingDescriptions = (VkVertexInputBindingDescription[1]) {
      {
        .binding = 0,
        .stride = 64,
        .inputRate = VK_VERTEX_INPUT_RATE_INSTANCE
      }
  },
  .vertexAttributeDescriptionCount = 4,
  .pVertexAttributeDescriptions = (VkVertexInputAttributeDescription[4]) {
      {
        .location = 0,
        .binding = 0,
        .format = VK_FORMAT_R32G32B32A32_SFLOAT,
        .offset = 0,
      },
      {
        .location = 1,
        .binding = 0,
        .format = VK_FORMAT_R32G32B32A32_SFLOAT,
        .offset = 16,
      },
      {
        .location = 2,
        .binding = 0,
        .format = VK_FORMAT_R32G32B32A32_SFLOAT,
        .offset = 32,
      },
      {
        .location = 3,
        .binding = 0,
        .format = VK_FORMAT_R32G32_SFLOAT,
        .offset = 48,
      },
  },
};

#endif /* GDK_RENDERING_VULKAN */

static const GskGpuShaderOpClass GSK_GPU_BLUR_OP_CLASS = {
  {
    GSK_GPU_OP_SIZE (GskGpuShaderOp),
    GSK_GPU_STAGE_SHADER,
    gsk_gpu_shader_op_finish,
    gsk_gpu_shader_op_print,
#ifdef GDK_RENDERING_VULKAN
    gsk_gpu_shader_op_vk_command,
#endif
    gsk_gpu_shader_op_gl_command
  },
  "gskgpublur",
  1,
  6,
  sizeof (GskGpuBlurInstance),
#ifdef GDK_RENDERING_VULKAN
  &gsk_gpu_blur_info,
#endif
  gsk_gpu_blur_op_print_instance,
  gsk_gpu_blur_setup_attrib_locations,
  gsk_gpu_blur_setup_vao
};

void
gsk_gpu_blur_op (GskGpuFrame            *frame,
                 GskGpuShaderClip        clip,
                 GdkColorState          *ccs,
                 GdkColorState          *acs,
                 float                   opacity,
                 const graphene_point_t *offset,
                 GskGpuImage            *image1,
                 GskGpuSampler           sampler1,
                 gboolean                variation_colorize,
                 const graphene_rect_t  *rect,
                 const GdkColor         *blur_color,
                 const graphene_rect_t  *tex_rect,
                 const graphene_vec2_t  *blur_direction)
{
  GskGpuBlurInstance *instance;

  gsk_gpu_shader_op_alloc (frame,
                           &GSK_GPU_BLUR_OP_CLASS,
                           ccs ? gsk_gpu_color_states_create (ccs, TRUE, acs, FALSE)
                               : gsk_gpu_color_states_create_equal (TRUE, FALSE),
                           ((variation_colorize & 1) << 0),
                           clip,
                           (GskGpuImage *[1]) { image1 },
                           (GskGpuSampler[1]) { sampler1 },
                           &instance);
  gsk_gpu_rect_to_float (rect, offset, instance->rect);
  gdk_color_to_float (blur_color, acs, instance->blur_color);  instance->blur_color[3] *= opacity;
  gsk_gpu_rect_to_float (tex_rect, offset, instance->tex_rect);
  graphene_vec2_to_float (blur_direction, instance->blur_direction);
}

