/*
 * Copyright 2020-2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, soapy, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_soapy_sink = R"doc(

Constructor Specific Documentation:

Return a shared_ptr to a new instance of soapy::sink.

To avoid accidental use of raw pointers, soapy::sink's constructor is in a private implementation class. soapy::sink::make is the public interface for creating new instances. 
Driver name can be any of \"uhd\", \"lime\", \"airspy\", \"rtlsdr\" or others

Args:
    device : the device driver and type
    type : output stream format
    nchan : number of channels
    dev_args : device specific arguments
    stream_args : stream arguments. Same for all enabled channels
    tune_args : list with tuning specific arguments, one entry for every enabled channel, or a single entry to apply to all
    other_settings : list with general settings, one entry for every enabled channel, or a single entry to apply to all. Supports also specific gain settings.)doc";


static const char* __doc_gr_soapy_sink_sink_0 = R"doc()doc";


static const char* __doc_gr_soapy_sink_sink_1 = R"doc()doc";


static const char* __doc_gr_soapy_sink_make = R"doc(

Constructor Specific Documentation:

Return a shared_ptr to a new instance of soapy::sink.

To avoid accidental use of raw pointers, soapy::sink's constructor is in a private implementation class. soapy::sink::make is the public interface for creating new instances. 
Driver name can be any of \"uhd\", \"lime\", \"airspy\", \"rtlsdr\" or others

Args:
    device : the device driver and type
    type : output stream format
    nchan : number of channels
    dev_args : device specific arguments
    stream_args : stream arguments. Same for all enabled channels
    tune_args : list with tuning specific arguments, one entry for every enabled channel, or a single entry to apply to all
    other_settings : list with general settings, one entry for every enabled channel, or a single entry to apply to all. Supports also specific gain settings.)doc";


static const char* __doc_gr_soapy_sink_set_length_tag_name = R"doc()doc";
