/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_mmse_interp_differentiator_ff = R"doc(Compute intermediate samples of the derivative of a signal between signal samples x(k*Ts).

This implements a Minimum Mean Squared Error interpolating differentiator with 8 taps. It is suitable for signals where the derivative of a signal has a bandwidth of interest in the range (-Fs/4, Fs/4), where Fs is the samples rate.


Although mu, the fractional delay, is specified as a float, in the range [0.0, 1.0], it is actually quantized. That is, mu is quantized in the differentiate method to 128th's of a sample.)doc";


static const char*
    __doc_gr_filter_mmse_interp_differentiator_ff_mmse_interp_differentiator_ff_0 =
        R"doc()doc";


static const char*
    __doc_gr_filter_mmse_interp_differentiator_ff_mmse_interp_differentiator_ff_1 =
        R"doc()doc";


static const char* __doc_gr_filter_mmse_interp_differentiator_ff_ntaps = R"doc()doc";


static const char* __doc_gr_filter_mmse_interp_differentiator_ff_nsteps = R"doc()doc";


static const char* __doc_gr_filter_mmse_interp_differentiator_ff_differentiate =
    R"doc()doc";
