/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_dc_blocker_ff = R"doc(a computationally efficient controllable DC blocker

This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


The theory behind this block can be found in the paper:

Constructor Specific Documentation:

Make a DC blocker block.

Args:
    D : (int) the length of the delay line
    long_form : (bool) whether to use long (true, default) or short form)doc";


static const char* __doc_gr_filter_dc_blocker_ff_dc_blocker_ff_0 = R"doc()doc";


static const char* __doc_gr_filter_dc_blocker_ff_dc_blocker_ff_1 = R"doc()doc";


static const char* __doc_gr_filter_dc_blocker_ff_make = R"doc(a computationally efficient controllable DC blocker

This block implements a computationally efficient DC blocker that produces a tighter notch filter around DC for a smaller group delay than an equivalent FIR filter or using a single pole IIR filter (though the IIR filter is computationally cheaper).


The block defaults to using a delay line of length 32 and the long form of the filter. Optionally, the delay line length can be changed to alter the width of the DC notch (longer lines will decrease the width).


The long form of the filter produces a nearly flat response outside of the notch but at the cost of a group delay of 2D-2.


The short form of the filter does not have as flat a response in the passband but has a group delay of only D-1 and is cheaper to compute.


The theory behind this block can be found in the paper:

Constructor Specific Documentation:

Make a DC blocker block.

Args:
    D : (int) the length of the delay line
    long_form : (bool) whether to use long (true, default) or short form)doc";


static const char* __doc_gr_filter_dc_blocker_ff_group_delay = R"doc()doc";
