/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_encode_ccsds_27_bb = R"doc(A rate 1/2, k=7 convolutional encoder for the CCSDS standard.

This block performs convolutional encoding using the CCSDS standard polynomial (\"Voyager\").


The input is an MSB first packed stream of bits.


The output is a stream of symbols 0 or 1 representing the encoded data.


As a rate 1/2 code, there will be 16 output symbols for every input byte.


This block is designed for continuous data streaming, not packetized data. There is no provision to \"flush\" the encoder.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_fec_encode_ccsds_27_bb_encode_ccsds_27_bb = R"doc()doc";


static const char* __doc_gr_fec_encode_ccsds_27_bb_make = R"doc(A rate 1/2, k=7 convolutional encoder for the CCSDS standard.

This block performs convolutional encoding using the CCSDS standard polynomial (\"Voyager\").


The input is an MSB first packed stream of bits.


The output is a stream of symbols 0 or 1 representing the encoded data.


As a rate 1/2 code, there will be 16 output symbols for every input byte.


This block is designed for continuous data streaming, not packetized data. There is no provision to \"flush\" the encoder.

Constructor Specific Documentation:

)doc";
