/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_symbol_inner_interleaver = R"doc(Symbol interleaver.

ETSI EN 300 744 Clause 4.3.4.2 
One block is 12 groups x 126 datawords = 1512 datawords.


Data Input format: 
000000I0I1 - QPSK. 
0000I0I1I2I3 - 16QAM. 
00I0I1I2I3I4I5 - 64QAM. 
Data Output format: 
000000Y0Y1 - QPSK. 
0000Y0Y1Y2Y3 - 16QAM. 
00Y0Y1Y2Y3Y4Y5 - 64QAM.

Constructor Specific Documentation:

Create a Symbol interleaver.

Args:
    ninput : length of input stream.
    transmission : transmission mode used
    direction : interleave or deinterleave.)doc";


static const char*
    __doc_gr_dtv_dvbt_symbol_inner_interleaver_dvbt_symbol_inner_interleaver =
        R"doc()doc";


static const char* __doc_gr_dtv_dvbt_symbol_inner_interleaver_make = R"doc(Symbol interleaver.

ETSI EN 300 744 Clause 4.3.4.2 
One block is 12 groups x 126 datawords = 1512 datawords.


Data Input format: 
000000I0I1 - QPSK. 
0000I0I1I2I3 - 16QAM. 
00I0I1I2I3I4I5 - 64QAM. 
Data Output format: 
000000Y0Y1 - QPSK. 
0000Y0Y1Y2Y3 - 16QAM. 
00Y0Y1Y2Y3Y4Y5 - 64QAM.

Constructor Specific Documentation:

Create a Symbol interleaver.

Args:
    ninput : length of input stream.
    transmission : transmission mode used
    direction : interleave or deinterleave.)doc";
