/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt2_p1insertion_cc = R"doc(Inserts a P1 symbol.

Input: OFDM T2 frame. 
Output: OFDM T2 frame with P1 symbol.

Constructor Specific Documentation:

Create a P1 symbol inserter.

Args:
    carriermode : number of carriers (normal or extended).
    fftsize : OFDM IFFT size.
    guardinterval : OFDM ISI guard interval.
    numdatasyms : number of OFDM symbols in a T2 frame.
    preamble : P1 symbol preamble format.
    showlevels : print peak IQ levels.
    vclip : set peak IQ level threshold.)doc";


static const char* __doc_gr_dtv_dvbt2_p1insertion_cc_dvbt2_p1insertion_cc = R"doc()doc";


static const char* __doc_gr_dtv_dvbt2_p1insertion_cc_make = R"doc(Inserts a P1 symbol.

Input: OFDM T2 frame. 
Output: OFDM T2 frame with P1 symbol.

Constructor Specific Documentation:

Create a P1 symbol inserter.

Args:
    carriermode : number of carriers (normal or extended).
    fftsize : OFDM IFFT size.
    guardinterval : OFDM ISI guard interval.
    numdatasyms : number of OFDM symbols in a T2 frame.
    preamble : P1 symbol preamble format.
    showlevels : print peak IQ levels.
    vclip : set peak IQ level threshold.)doc";
