/*
 * Copyright 2022 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_crc_append = R"doc(Calculates and appends a CRC to a PDU.

The CRC append block receives a PDU, calculates the CRC of the PDU data, appends it to the PDU, and sends that as its output. It can support any CRC whose size is a multiple of 8 bits between 8 and 64 bits.

Constructor Specific Documentation:

Build the CRC append block.

Args:
    num_bits : CRC size in bits (must be a multiple of 8)
    poly : CRC polynomial, in MSB-first notation
    initial_value : Initial register value
    final_xor : Final XOR value
    input_reflected : true if the input is LSB-first, false if not
    result_reflected : true if the output is LSB-first, false if not
    swap_endianness : true if the CRC is stored as little-endian in the PDU, false if not
    skip_header_bytes : gives the number of header byte to skip in the CRC calculation)doc";


static const char* __doc_gr_digital_crc_append_crc_append = R"doc()doc";


static const char* __doc_gr_digital_crc_append_make = R"doc(Calculates and appends a CRC to a PDU.

The CRC append block receives a PDU, calculates the CRC of the PDU data, appends it to the PDU, and sends that as its output. It can support any CRC whose size is a multiple of 8 bits between 8 and 64 bits.

Constructor Specific Documentation:

Build the CRC append block.

Args:
    num_bits : CRC size in bits (must be a multiple of 8)
    poly : CRC polynomial, in MSB-first notation
    initial_value : Initial register value
    final_xor : Final XOR value
    input_reflected : true if the input is LSB-first, false if not
    result_reflected : true if the output is LSB-first, false if not
    swap_endianness : true if the CRC is stored as little-endian in the PDU, false if not
    skip_header_bytes : gives the number of header byte to skip in the CRC calculation)doc";
