/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_file_meta_sink = R"doc(Write stream to file with meta-data headers.

These files represent data as binary information in between meta-data headers. The headers contain information about the type of data and properties of the data in the next segment of samples. The information includes:



Tags can be sent to the file to update the information, which will create a new header. Headers are found by searching from the first header (at position 0 in the file) and reading where the data segment starts plus the data segment size. Following will either be a new header or EOF.

Constructor Specific Documentation:

Create a meta-data file sink.

Args:
    itemsize : (size_t): Size of data type.
    filename : (string): Name of file to write data to.
    samp_rate : (double): Sample rate of data. If sample rate will be set by a tag, such as rx_tag from a UHD source, this is basically ignored.
    relative_rate : (double): Rate chance from source of sample rate tag to sink.
    type : (gr_file_types): Data type (int, float, etc.)
    complex : (bool): If data stream is complex
    max_segment_size : (size_t): Length of a single segment before the header is repeated (in items).
    extra_dict : a PMT dictionary of extra information.
    detached_header : (bool): Set to true to store the header info in a separate file (named filename.hdr))doc";


static const char* __doc_gr_blocks_file_meta_sink_file_meta_sink_0 = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_sink_file_meta_sink_1 = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_sink_make = R"doc(Write stream to file with meta-data headers.

These files represent data as binary information in between meta-data headers. The headers contain information about the type of data and properties of the data in the next segment of samples. The information includes:



Tags can be sent to the file to update the information, which will create a new header. Headers are found by searching from the first header (at position 0 in the file) and reading where the data segment starts plus the data segment size. Following will either be a new header or EOF.

Constructor Specific Documentation:

Create a meta-data file sink.

Args:
    itemsize : (size_t): Size of data type.
    filename : (string): Name of file to write data to.
    samp_rate : (double): Sample rate of data. If sample rate will be set by a tag, such as rx_tag from a UHD source, this is basically ignored.
    relative_rate : (double): Rate chance from source of sample rate tag to sink.
    type : (gr_file_types): Data type (int, float, etc.)
    complex : (bool): If data stream is complex
    max_segment_size : (size_t): Length of a single segment before the header is repeated (in items).
    extra_dict : a PMT dictionary of extra information.
    detached_header : (bool): Set to true to store the header info in a separate file (named filename.hdr))doc";


static const char* __doc_gr_blocks_file_meta_sink_open = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_sink_close = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_sink_do_update = R"doc()doc";


static const char* __doc_gr_blocks_file_meta_sink_set_unbuffered = R"doc()doc";
