/* graph.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from graph.vala, do not modify */

/* graph.vala
 *
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Markus Göllnitz <camelcasenick@bewares.it>
 */

#define _GNU_SOURCE

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gsk/gsk.h>
#include <adwaita.h>
#include <string.h>
#include <graphene-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_GRAPH_VIEW (usage_graph_view_get_type ())
#define USAGE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphView))
#define USAGE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))
#define USAGE_IS_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_IS_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))

typedef struct _UsageGraphView UsageGraphView;
typedef struct _UsageGraphViewClass UsageGraphViewClass;
typedef struct _UsageGraphViewPrivate UsageGraphViewPrivate;

#define USAGE_TYPE_GRAPH (usage_graph_get_type ())
#define USAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH, UsageGraph))
#define USAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH, UsageGraphClass))
#define USAGE_IS_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH))
#define USAGE_IS_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH))
#define USAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH, UsageGraphClass))

typedef struct _UsageGraph UsageGraph;
typedef struct _UsageGraphClass UsageGraphClass;
enum  {
	USAGE_GRAPH_VIEW_0_PROPERTY,
	USAGE_GRAPH_VIEW_OFFSET_X_PROPERTY,
	USAGE_GRAPH_VIEW_RANGE_X_PROPERTY,
	USAGE_GRAPH_VIEW_OFFSET_Y_PROPERTY,
	USAGE_GRAPH_VIEW_RANGE_Y_PROPERTY,
	USAGE_GRAPH_VIEW_NUM_PROPERTIES
};
static GParamSpec* usage_graph_view_properties[USAGE_GRAPH_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _UsageGraphPrivate UsageGraphPrivate;

#define USAGE_TYPE_GRAPH_POINT (usage_graph_point_get_type ())
typedef struct _UsageGraphPoint UsageGraphPoint;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _usage_graph_unref0(var) ((var == NULL) ? NULL : (var = (usage_graph_unref (var), NULL)))
#define _gsk_render_node_unref0(var) ((var == NULL) ? NULL : (var = (gsk_render_node_unref (var), NULL)))
#define _usage_graph_point_free0(var) ((var == NULL) ? NULL : (var = (usage_graph_point_free (var), NULL)))
typedef struct _UsageParamSpecGraph UsageParamSpecGraph;
enum  {
	USAGE_GRAPH_UPDATED_SIGNAL,
	USAGE_GRAPH_NUM_SIGNALS
};
static guint usage_graph_signals[USAGE_GRAPH_NUM_SIGNALS] = {0};

struct _UsageGraphView {
	GtkWidget parent_instance;
	UsageGraphViewPrivate * priv;
	gint64 _offset_x;
	gint64 _range_x;
	gint64 _offset_y;
	gint64 _range_y;
};

struct _UsageGraphViewClass {
	GtkWidgetClass parent_class;
	gint64 (*get_offset_x) (UsageGraphView* self);
	void (*set_offset_x) (UsageGraphView* self, gint64 value);
};

struct _UsageGraphViewPrivate {
	GeeArrayList* graphs;
};

struct _UsageGraphPoint {
	gint64 timestamp;
	gdouble level;
};

struct _UsageGraph {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UsageGraphPrivate * priv;
	GskRenderNode* render_node;
	GQueue* values;
	guint maximal_queue_length;
	GdkRGBA* color;
};

struct _UsageGraphClass {
	GTypeClass parent_class;
	void (*finalize) (UsageGraph *self);
};

struct _UsageParamSpecGraph {
	GParamSpec parent_instance;
};

static gint UsageGraphView_private_offset;
static gpointer usage_graph_view_parent_class = NULL;
static gpointer usage_graph_parent_class = NULL;

VALA_EXTERN GType usage_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphView, g_object_unref)
VALA_EXTERN gpointer usage_graph_ref (gpointer instance);
VALA_EXTERN void usage_graph_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_graph (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_graph (GValue* value,
                            gpointer v_object);
VALA_EXTERN void usage_value_take_graph (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_graph (const GValue* value);
VALA_EXTERN GType usage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraph, usage_graph_unref)
VALA_EXTERN gint64 usage_graph_view_get_offset_x (UsageGraphView* self);
VALA_EXTERN void usage_graph_view_set_offset_x (UsageGraphView* self,
                                    gint64 value);
VALA_EXTERN void usage_graph_view_add_graph (UsageGraphView* self,
                                 UsageGraph* graph);
static void _gtk_widget_queue_draw_usage_graph_updated (UsageGraph* _sender,
                                                 gpointer self);
VALA_EXTERN void usage_graph_view_remove_graph (UsageGraphView* self,
                                    UsageGraph* graph);
VALA_EXTERN UsageGraph* usage_graph_view_get_graph (UsageGraphView* self,
                                        gint i);
static void usage_graph_view_real_snapshot (GtkWidget* base,
                                     GtkSnapshot* snapshot);
VALA_EXTERN GType usage_graph_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageGraphPoint* usage_graph_point_dup (const UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_free (UsageGraphPoint* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN gint64 usage_graph_view_get_range_x (UsageGraphView* self);
VALA_EXTERN gint64 usage_graph_view_get_range_y (UsageGraphView* self);
VALA_EXTERN gint64 usage_graph_view_get_offset_y (UsageGraphView* self);
VALA_EXTERN UsageGraphView* usage_graph_view_new (void);
VALA_EXTERN UsageGraphView* usage_graph_view_construct (GType object_type);
VALA_EXTERN void usage_graph_view_set_range_x (UsageGraphView* self,
                                   gint64 value);
VALA_EXTERN void usage_graph_view_set_offset_y (UsageGraphView* self,
                                    gint64 value);
VALA_EXTERN void usage_graph_view_set_range_y (UsageGraphView* self,
                                   gint64 value);
static GObject * usage_graph_view_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void usage_graph_view_finalize (GObject * obj);
static GType usage_graph_view_get_type_once (void);
static void _vala_usage_graph_view_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_usage_graph_view_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _usage_graph_point_free0_ (gpointer var);
static inline void _g_queue_free__usage_graph_point_free0_ (GQueue* self);
VALA_EXTERN void usage_graph_push_point (UsageGraph* self,
                             UsageGraphPoint* point);
VALA_EXTERN UsageGraph* usage_graph_new (void);
VALA_EXTERN UsageGraph* usage_graph_construct (GType object_type);
static void usage_graph_finalize (UsageGraph * obj);
static GType usage_graph_get_type_once (void);
VALA_EXTERN void usage_graph_point_init (UsageGraphPoint *self,
                             gint64 timestamp,
                             gdouble level);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_graph_view_get_instance_private (UsageGraphView* self)
{
	return G_STRUCT_MEMBER_P (self, UsageGraphView_private_offset);
}

static void
_gtk_widget_queue_draw_usage_graph_updated (UsageGraph* _sender,
                                            gpointer self)
{
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
usage_graph_view_add_graph (UsageGraphView* self,
                            UsageGraph* graph)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (graph != NULL);
	_tmp0_ = self->priv->graphs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, graph);
	g_signal_connect_object (graph, "updated", (GCallback) _gtk_widget_queue_draw_usage_graph_updated, (GtkWidget*) self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
usage_graph_view_remove_graph (UsageGraphView* self,
                               UsageGraph* graph)
{
	GeeArrayList* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (graph != NULL);
	_tmp0_ = self->priv->graphs;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, graph);
	g_signal_parse_name ("updated", USAGE_TYPE_GRAPH, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (graph, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gtk_widget_queue_draw_usage_graph_updated, (GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

UsageGraph*
usage_graph_view_get_graph (UsageGraphView* self,
                            gint i)
{
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	UsageGraph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->graphs;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, i);
	result = (UsageGraph*) _tmp1_;
	return result;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
usage_graph_view_real_snapshot (GtkWidget* base,
                                GtkSnapshot* snapshot)
{
	UsageGraphView * self;
	gfloat thickness = 0.0F;
	gint view_width = 0;
	gint view_height = 0;
	self = (UsageGraphView*) base;
	g_return_if_fail (snapshot != NULL);
	thickness = 2.5f;
	view_width = gtk_widget_get_width ((GtkWidget*) self);
	view_height = (gint) llrintf (gtk_widget_get_height ((GtkWidget*) self) - thickness);
	{
		GeeArrayList* _graph_list = NULL;
		GeeArrayList* _tmp0_;
		gint _graph_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _graph_index = 0;
		_tmp0_ = self->priv->graphs;
		_graph_list = _tmp0_;
		_tmp1_ = _graph_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_graph_size = _tmp3_;
		_graph_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			UsageGraph* graph = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GdkRGBA color = {0};
			UsageGraph* _tmp8_;
			GdkRGBA* _tmp9_;
			GdkRGBA color_transparent = {0};
			GdkRGBA* _tmp14_;
			GdkRGBA* _tmp15_;
			GdkRGBA _tmp16_;
			GskColorStop* stops = NULL;
			GdkRGBA _tmp17_;
			GskColorStop _tmp18_ = {0};
			GdkRGBA _tmp19_;
			GskColorStop _tmp20_ = {0};
			GdkRGBA _tmp21_;
			GskColorStop _tmp22_ = {0};
			GdkRGBA _tmp23_;
			GskColorStop _tmp24_ = {0};
			GskColorStop* _tmp25_;
			gint stops_length1;
			gint _stops_size_;
			_graph_index = _graph_index + 1;
			_tmp4_ = _graph_index;
			_tmp5_ = _graph_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _graph_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _graph_index);
			graph = (UsageGraph*) _tmp7_;
			_tmp8_ = graph;
			_tmp9_ = _tmp8_->color;
			if (_tmp9_ != NULL) {
				UsageGraph* _tmp10_;
				GdkRGBA* _tmp11_;
				_tmp10_ = graph;
				_tmp11_ = _tmp10_->color;
				color = (GdkRGBA) (*_tmp11_);
			} else {
				AdwStyleManager* _tmp12_;
				GdkRGBA _tmp13_ = {0};
				_tmp12_ = adw_style_manager_get_default ();
				adw_accent_color_to_rgba (adw_style_manager_get_accent_color (_tmp12_), &_tmp13_);
				color = _tmp13_;
			}
			_tmp14_ = gdk_rgba_copy (&color);
			_tmp15_ = _tmp14_;
			_tmp16_ = *_tmp15_;
			__vala_GdkRGBA_free0 (_tmp15_);
			color_transparent = _tmp16_;
			color_transparent.alpha = (gfloat) 0;
			_tmp17_ = color_transparent;
			memset (&_tmp18_, 0, sizeof (GskColorStop));
			_tmp18_.offset = (gfloat) 0;
			_tmp18_.color = _tmp17_;
			_tmp19_ = color;
			memset (&_tmp20_, 0, sizeof (GskColorStop));
			_tmp20_.offset = 0.3f;
			_tmp20_.color = _tmp19_;
			_tmp21_ = color;
			memset (&_tmp22_, 0, sizeof (GskColorStop));
			_tmp22_.offset = 0.7f;
			_tmp22_.color = _tmp21_;
			_tmp23_ = color_transparent;
			memset (&_tmp24_, 0, sizeof (GskColorStop));
			_tmp24_.offset = (gfloat) 1;
			_tmp24_.color = _tmp23_;
			_tmp25_ = g_new0 (GskColorStop, 4);
			_tmp25_[0] = _tmp18_;
			_tmp25_[1] = _tmp20_;
			_tmp25_[2] = _tmp22_;
			_tmp25_[3] = _tmp24_;
			stops = _tmp25_;
			stops_length1 = 4;
			_stops_size_ = stops_length1;
			{
				guint n = 0U;
				n = (guint) 1;
				{
					gboolean _tmp26_ = FALSE;
					_tmp26_ = TRUE;
					while (TRUE) {
						UsageGraph* _tmp28_;
						GQueue* _tmp29_;
						UsageGraphPoint graph_point = {0};
						UsageGraph* _tmp30_;
						GQueue* _tmp31_;
						gconstpointer _tmp32_;
						UsageGraphPoint graph_point_next = {0};
						UsageGraph* _tmp33_;
						GQueue* _tmp34_;
						gconstpointer _tmp35_;
						gdouble delta_x = 0.0;
						UsageGraphPoint _tmp36_;
						UsageGraphPoint _tmp37_;
						gint64 _tmp38_;
						gint64 _tmp39_;
						gdouble delta_y = 0.0;
						UsageGraphPoint _tmp40_;
						UsageGraphPoint _tmp41_;
						gint64 _tmp42_;
						gint64 _tmp43_;
						gfloat x = 0.0F;
						UsageGraphPoint _tmp44_;
						gint64 _tmp45_;
						gint64 _tmp46_;
						gint64 _tmp47_;
						gint64 _tmp48_;
						gfloat y = 0.0F;
						gint64 _tmp49_;
						gint64 _tmp50_;
						gint64 _tmp51_;
						gint64 _tmp52_;
						UsageGraphPoint _tmp53_;
						gint64 _tmp54_;
						gint64 _tmp55_;
						gdouble angle = 0.0;
						gdouble sin_angle = 0.0;
						gdouble cos_angle = 0.0;
						gdouble _tmp56_ = 0.0;
						gdouble _tmp57_ = 0.0;
						graphene_rect_t bounds = {0};
						graphene_point_t start = {0};
						graphene_point_t end = {0};
						graphene_rect_t _tmp58_;
						graphene_point_t _tmp59_;
						graphene_point_t _tmp60_;
						GskColorStop* _tmp61_;
						gint _tmp61__length1;
						if (!_tmp26_) {
							guint _tmp27_;
							_tmp27_ = n;
							n = _tmp27_ + 1;
						}
						_tmp26_ = FALSE;
						_tmp28_ = graph;
						_tmp29_ = _tmp28_->values;
						if (!(n < g_queue_get_length (_tmp29_))) {
							break;
						}
						_tmp30_ = graph;
						_tmp31_ = _tmp30_->values;
						_tmp32_ = g_queue_peek_nth (_tmp31_, n);
						graph_point = *((UsageGraphPoint*) _tmp32_);
						_tmp33_ = graph;
						_tmp34_ = _tmp33_->values;
						_tmp35_ = g_queue_peek_nth (_tmp34_, n - 1);
						graph_point_next = *((UsageGraphPoint*) _tmp35_);
						_tmp36_ = graph_point_next;
						_tmp37_ = graph_point;
						_tmp38_ = usage_graph_view_get_range_x (self);
						_tmp39_ = _tmp38_;
						delta_x = (((gdouble) (_tmp36_.timestamp - _tmp37_.timestamp)) * view_width) / _tmp39_;
						_tmp40_ = graph_point_next;
						_tmp41_ = graph_point;
						_tmp42_ = usage_graph_view_get_range_y (self);
						_tmp43_ = _tmp42_;
						delta_y = ((_tmp40_.level - _tmp41_.level) * view_height) / _tmp43_;
						_tmp44_ = graph_point;
						_tmp45_ = usage_graph_view_get_offset_x (self);
						_tmp46_ = _tmp45_;
						_tmp47_ = usage_graph_view_get_range_x (self);
						_tmp48_ = _tmp47_;
						x = (((gfloat) (_tmp44_.timestamp - _tmp46_)) * view_width) / _tmp48_;
						_tmp49_ = usage_graph_view_get_offset_y (self);
						_tmp50_ = _tmp49_;
						_tmp51_ = usage_graph_view_get_range_y (self);
						_tmp52_ = _tmp51_;
						_tmp53_ = graph_point;
						_tmp54_ = usage_graph_view_get_range_y (self);
						_tmp55_ = _tmp54_;
						y = ((((_tmp50_ + _tmp52_) - ((gfloat) _tmp53_.level)) * view_height) / _tmp55_) + (thickness / 2);
						angle = atan2 (delta_y, delta_x);
						sincos (angle, &_tmp56_, &_tmp57_);
						sin_angle = _tmp56_;
						cos_angle = _tmp57_;
						memset (&bounds, 0, sizeof (graphene_rect_t));
						graphene_rect_init (&bounds, x, fminf (y, y - ((gfloat) delta_y)) - (thickness / 2), (gfloat) delta_x, fabsf ((gfloat) delta_y) + thickness);
						memset (&start, 0, sizeof (graphene_point_t));
						memset (&end, 0, sizeof (graphene_point_t));
						graphene_point_init (&start, x - ((thickness / 2) * ((gfloat) sin_angle)), y - ((thickness / 2) * ((gfloat) cos_angle)));
						graphene_point_init (&end, x + ((thickness / 2) * ((gfloat) sin_angle)), y + ((thickness / 2) * ((gfloat) cos_angle)));
						_tmp58_ = bounds;
						_tmp59_ = start;
						_tmp60_ = end;
						_tmp61_ = stops;
						_tmp61__length1 = stops_length1;
						gtk_snapshot_append_linear_gradient (snapshot, &_tmp58_, &_tmp59_, &_tmp60_, _tmp61_, (gsize) _tmp61__length1);
					}
				}
			}
			stops = (g_free (stops), NULL);
			_usage_graph_unref0 (graph);
		}
	}
}

UsageGraphView*
usage_graph_view_construct (GType object_type)
{
	UsageGraphView * self = NULL;
	self = (UsageGraphView*) g_object_new (object_type, NULL);
	return self;
}

UsageGraphView*
usage_graph_view_new (void)
{
	return usage_graph_view_construct (USAGE_TYPE_GRAPH_VIEW);
}

gint64
usage_graph_view_get_offset_x (UsageGraphView* self)
{
	UsageGraphViewClass* _klass_;
	g_return_val_if_fail (self != NULL, 0LL);
	_klass_ = USAGE_GRAPH_VIEW_GET_CLASS (self);
	if (_klass_->get_offset_x) {
		return _klass_->get_offset_x (self);
	}
	return -1LL;
}

static gint64
usage_graph_view_real_get_offset_x (UsageGraphView* base)
{
	gint64 result;
	UsageGraphView* self;
	self = base;
	result = self->_offset_x;
	return result;
}

void
usage_graph_view_set_offset_x (UsageGraphView* self,
                               gint64 value)
{
	UsageGraphViewClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = USAGE_GRAPH_VIEW_GET_CLASS (self);
	if (_klass_->set_offset_x) {
		_klass_->set_offset_x (self, value);
	}
}

static void
usage_graph_view_real_set_offset_x (UsageGraphView* base,
                                    gint64 value)
{
	UsageGraphView* self;
	self = base;
	self->_offset_x = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, usage_graph_view_properties[USAGE_GRAPH_VIEW_OFFSET_X_PROPERTY]);
}

gint64
usage_graph_view_get_range_x (UsageGraphView* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->_range_x;
	return result;
}

void
usage_graph_view_set_range_x (UsageGraphView* self,
                              gint64 value)
{
	g_return_if_fail (self != NULL);
	self->_range_x = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, usage_graph_view_properties[USAGE_GRAPH_VIEW_RANGE_X_PROPERTY]);
}

gint64
usage_graph_view_get_offset_y (UsageGraphView* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->_offset_y;
	return result;
}

void
usage_graph_view_set_offset_y (UsageGraphView* self,
                               gint64 value)
{
	g_return_if_fail (self != NULL);
	self->_offset_y = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, usage_graph_view_properties[USAGE_GRAPH_VIEW_OFFSET_Y_PROPERTY]);
}

gint64
usage_graph_view_get_range_y (UsageGraphView* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->_range_y;
	return result;
}

void
usage_graph_view_set_range_y (UsageGraphView* self,
                              gint64 value)
{
	g_return_if_fail (self != NULL);
	self->_range_y = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, usage_graph_view_properties[USAGE_GRAPH_VIEW_RANGE_Y_PROPERTY]);
}

static GObject *
usage_graph_view_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageGraphView * self;
	parent_class = G_OBJECT_CLASS (usage_graph_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_GRAPH_VIEW, UsageGraphView);
	gtk_widget_set_overflow ((GtkWidget*) self, GTK_OVERFLOW_HIDDEN);
	return obj;
}

static void
usage_graph_view_base_init (UsageGraphViewClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "rg-graph");
}

static void
usage_graph_view_class_init (UsageGraphViewClass * klass,
                             gpointer klass_data)
{
	usage_graph_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageGraphView_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) usage_graph_view_real_snapshot;
	USAGE_GRAPH_VIEW_CLASS (klass)->get_offset_x = (gint64 (*) (UsageGraphView*)) usage_graph_view_real_get_offset_x;
	USAGE_GRAPH_VIEW_CLASS (klass)->set_offset_x = (void (*) (UsageGraphView*, gint64)) usage_graph_view_real_set_offset_x;
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_graph_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_graph_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = usage_graph_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_graph_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_GRAPH_VIEW_OFFSET_X_PROPERTY, usage_graph_view_properties[USAGE_GRAPH_VIEW_OFFSET_X_PROPERTY] = g_param_spec_int64 ("offset-x", "offset-x", "offset-x", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_GRAPH_VIEW_RANGE_X_PROPERTY, usage_graph_view_properties[USAGE_GRAPH_VIEW_RANGE_X_PROPERTY] = g_param_spec_int64 ("range-x", "range-x", "range-x", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_GRAPH_VIEW_OFFSET_Y_PROPERTY, usage_graph_view_properties[USAGE_GRAPH_VIEW_OFFSET_Y_PROPERTY] = g_param_spec_int64 ("offset-y", "offset-y", "offset-y", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_GRAPH_VIEW_RANGE_Y_PROPERTY, usage_graph_view_properties[USAGE_GRAPH_VIEW_RANGE_Y_PROPERTY] = g_param_spec_int64 ("range-y", "range-y", "range-y", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
usage_graph_view_instance_init (UsageGraphView * self,
                                gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = usage_graph_view_get_instance_private (self);
	_tmp0_ = gee_array_list_new (USAGE_TYPE_GRAPH, (GBoxedCopyFunc) usage_graph_ref, (GDestroyNotify) usage_graph_unref, NULL, NULL, NULL);
	self->priv->graphs = _tmp0_;
	self->_offset_x = (gint64) 0;
	self->_range_x = (gint64) 1;
	self->_offset_y = (gint64) 0;
	self->_range_y = (gint64) 1;
}

static void
usage_graph_view_finalize (GObject * obj)
{
	UsageGraphView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_GRAPH_VIEW, UsageGraphView);
	_g_object_unref0 (self->priv->graphs);
	G_OBJECT_CLASS (usage_graph_view_parent_class)->finalize (obj);
}

static GType
usage_graph_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageGraphViewClass), (GBaseInitFunc) usage_graph_view_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_graph_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageGraphView), 0, (GInstanceInitFunc) usage_graph_view_instance_init, NULL };
	GType usage_graph_view_type_id;
	usage_graph_view_type_id = g_type_register_static (gtk_widget_get_type (), "UsageGraphView", &g_define_type_info, 0);
	UsageGraphView_private_offset = g_type_add_instance_private (usage_graph_view_type_id, sizeof (UsageGraphViewPrivate));
	return usage_graph_view_type_id;
}

GType
usage_graph_view_get_type (void)
{
	static volatile gsize usage_graph_view_type_id__once = 0;
	if (g_once_init_enter (&usage_graph_view_type_id__once)) {
		GType usage_graph_view_type_id;
		usage_graph_view_type_id = usage_graph_view_get_type_once ();
		g_once_init_leave (&usage_graph_view_type_id__once, usage_graph_view_type_id);
	}
	return usage_graph_view_type_id__once;
}

static void
_vala_usage_graph_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	UsageGraphView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_GRAPH_VIEW, UsageGraphView);
	switch (property_id) {
		case USAGE_GRAPH_VIEW_OFFSET_X_PROPERTY:
		g_value_set_int64 (value, usage_graph_view_get_offset_x (self));
		break;
		case USAGE_GRAPH_VIEW_RANGE_X_PROPERTY:
		g_value_set_int64 (value, usage_graph_view_get_range_x (self));
		break;
		case USAGE_GRAPH_VIEW_OFFSET_Y_PROPERTY:
		g_value_set_int64 (value, usage_graph_view_get_offset_y (self));
		break;
		case USAGE_GRAPH_VIEW_RANGE_Y_PROPERTY:
		g_value_set_int64 (value, usage_graph_view_get_range_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_graph_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	UsageGraphView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_GRAPH_VIEW, UsageGraphView);
	switch (property_id) {
		case USAGE_GRAPH_VIEW_OFFSET_X_PROPERTY:
		usage_graph_view_set_offset_x (self, g_value_get_int64 (value));
		break;
		case USAGE_GRAPH_VIEW_RANGE_X_PROPERTY:
		usage_graph_view_set_range_x (self, g_value_get_int64 (value));
		break;
		case USAGE_GRAPH_VIEW_OFFSET_Y_PROPERTY:
		usage_graph_view_set_offset_y (self, g_value_get_int64 (value));
		break;
		case USAGE_GRAPH_VIEW_RANGE_Y_PROPERTY:
		usage_graph_view_set_range_y (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_usage_graph_point_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (usage_graph_point_free (var), NULL));
}

static inline void
_g_queue_free__usage_graph_point_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _usage_graph_point_free0_);
}

static gpointer
_usage_graph_point_dup0 (gpointer self)
{
	return self ? usage_graph_point_dup (self) : NULL;
}

void
usage_graph_push_point (UsageGraph* self,
                        UsageGraphPoint* point)
{
	GQueue* _tmp0_;
	UsageGraphPoint _tmp1_;
	UsageGraphPoint* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (point != NULL);
	_tmp0_ = self->values;
	_tmp1_ = *point;
	_tmp2_ = _usage_graph_point_dup0 (&_tmp1_);
	g_queue_push_head (_tmp0_, _tmp2_);
	if (self->maximal_queue_length > ((guint) 0)) {
		while (TRUE) {
			GQueue* _tmp3_;
			GQueue* _tmp4_;
			gpointer _tmp5_;
			UsageGraphPoint* _tmp6_;
			_tmp3_ = self->values;
			if (!(g_queue_get_length (_tmp3_) > self->maximal_queue_length)) {
				break;
			}
			_tmp4_ = self->values;
			_tmp5_ = g_queue_pop_tail (_tmp4_);
			_tmp6_ = (UsageGraphPoint*) _tmp5_;
			_usage_graph_point_free0 (_tmp6_);
		}
	}
	g_signal_emit (self, usage_graph_signals[USAGE_GRAPH_UPDATED_SIGNAL], 0);
}

UsageGraph*
usage_graph_construct (GType object_type)
{
	UsageGraph* self = NULL;
	self = (UsageGraph*) g_type_create_instance (object_type);
	return self;
}

UsageGraph*
usage_graph_new (void)
{
	return usage_graph_construct (USAGE_TYPE_GRAPH);
}

static void
usage_value_graph_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
usage_value_graph_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		usage_graph_unref (value->data[0].v_pointer);
	}
}

static void
usage_value_graph_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = usage_graph_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
usage_value_graph_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
usage_value_graph_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UsageGraph * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = usage_graph_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
usage_value_graph_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	UsageGraph ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = usage_graph_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
usage_param_spec_graph (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	UsageParamSpecGraph* spec;
	g_return_val_if_fail (g_type_is_a (object_type, USAGE_TYPE_GRAPH), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
usage_value_get_graph (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_GRAPH), NULL);
	return value->data[0].v_pointer;
}

void
usage_value_set_graph (GValue* value,
                       gpointer v_object)
{
	UsageGraph * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_GRAPH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_GRAPH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		usage_graph_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_graph_unref (old);
	}
}

void
usage_value_take_graph (GValue* value,
                        gpointer v_object)
{
	UsageGraph * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_GRAPH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_GRAPH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_graph_unref (old);
	}
}

static void
usage_graph_class_init (UsageGraphClass * klass,
                        gpointer klass_data)
{
	usage_graph_parent_class = g_type_class_peek_parent (klass);
	((UsageGraphClass *) klass)->finalize = usage_graph_finalize;
	usage_graph_signals[USAGE_GRAPH_UPDATED_SIGNAL] = g_signal_new ("updated", USAGE_TYPE_GRAPH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
usage_graph_instance_init (UsageGraph * self,
                           gpointer klass)
{
	GQueue* _tmp0_;
	_tmp0_ = g_queue_new ();
	self->values = _tmp0_;
	self->maximal_queue_length = (guint) 0;
	self->color = NULL;
	self->ref_count = 1;
}

static void
usage_graph_finalize (UsageGraph * obj)
{
	UsageGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_GRAPH, UsageGraph);
	g_signal_handlers_destroy (self);
	_gsk_render_node_unref0 (self->render_node);
	(self->values == NULL) ? NULL : (self->values = (_g_queue_free__usage_graph_point_free0_ (self->values), NULL));
	__vala_GdkRGBA_free0 (self->color);
}

static GType
usage_graph_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { usage_value_graph_init, usage_value_graph_free_value, usage_value_graph_copy_value, usage_value_graph_peek_pointer, "p", usage_value_graph_collect_value, "p", usage_value_graph_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UsageGraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageGraph), 0, (GInstanceInitFunc) usage_graph_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType usage_graph_type_id;
	usage_graph_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UsageGraph", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return usage_graph_type_id;
}

GType
usage_graph_get_type (void)
{
	static volatile gsize usage_graph_type_id__once = 0;
	if (g_once_init_enter (&usage_graph_type_id__once)) {
		GType usage_graph_type_id;
		usage_graph_type_id = usage_graph_get_type_once ();
		g_once_init_leave (&usage_graph_type_id__once, usage_graph_type_id);
	}
	return usage_graph_type_id__once;
}

gpointer
usage_graph_ref (gpointer instance)
{
	UsageGraph * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
usage_graph_unref (gpointer instance)
{
	UsageGraph * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		USAGE_GRAPH_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
usage_graph_point_init (UsageGraphPoint *self,
                        gint64 timestamp,
                        gdouble level)
{
	memset (self, 0, sizeof (UsageGraphPoint));
	(*self).timestamp = timestamp;
	(*self).level = level;
}

UsageGraphPoint*
usage_graph_point_dup (const UsageGraphPoint* self)
{
	UsageGraphPoint* dup;
	dup = g_new0 (UsageGraphPoint, 1);
	memcpy (dup, self, sizeof (UsageGraphPoint));
	return dup;
}

void
usage_graph_point_free (UsageGraphPoint* self)
{
	g_free (self);
}

static GType
usage_graph_point_get_type_once (void)
{
	GType usage_graph_point_type_id;
	usage_graph_point_type_id = g_boxed_type_register_static ("UsageGraphPoint", (GBoxedCopyFunc) usage_graph_point_dup, (GBoxedFreeFunc) usage_graph_point_free);
	return usage_graph_point_type_id;
}

GType
usage_graph_point_get_type (void)
{
	static volatile gsize usage_graph_point_type_id__once = 0;
	if (g_once_init_enter (&usage_graph_point_type_id__once)) {
		GType usage_graph_point_type_id;
		usage_graph_point_type_id = usage_graph_point_get_type_once ();
		g_once_init_leave (&usage_graph_point_type_id__once, usage_graph_point_type_id);
	}
	return usage_graph_point_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

