/* gitg-diff-view-commit-details.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-view-commit-details.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgit2-glib/ggit.h>
#include <glib.h>
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS (gitg_diff_view_commit_details_get_type ())
#define GITG_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_IS_DIFF_VIEW_COMMIT_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS))
#define GITG_DIFF_VIEW_COMMIT_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetailsClass))

typedef struct _GitgDiffViewCommitDetails GitgDiffViewCommitDetails;
typedef struct _GitgDiffViewCommitDetailsClass GitgDiffViewCommitDetailsClass;
typedef struct _GitgDiffViewCommitDetailsPrivate GitgDiffViewCommitDetailsPrivate;
enum  {
	GITG_DIFF_VIEW_COMMIT_DETAILS_0_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDED_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDER_VISIBLE_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_DETAILS_COMMIT_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_DETAILS_PARENT_COMMIT_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_DETAILS_USE_GRAVATAR_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_DETAILS_REPOSITORY_PROPERTY,
	GITG_DIFF_VIEW_COMMIT_DETAILS_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block9Data Block9Data;

struct _GitgDiffViewCommitDetails {
	GtkGrid parent_instance;
	GitgDiffViewCommitDetailsPrivate * priv;
};

struct _GitgDiffViewCommitDetailsClass {
	GtkGridClass parent_class;
};

struct _GitgDiffViewCommitDetailsPrivate {
	GtkImage* d_image_avatar;
	GtkLabel* d_label_author;
	GtkLabel* d_label_author_date;
	GtkLabel* d_label_committer;
	GtkLabel* d_label_committer_date;
	GtkLabel* d_label_subject;
	GtkLabel* d_label_sha1;
	GtkGrid* d_grid_parents_container;
	GtkGrid* d_grid_parents;
	GtkExpander* d_expander_files;
	GtkLabel* d_label_expand_collapse_files;
	GSettings* d_settings;
	GCancellable* d_avatar_cancel;
	GgitCommit* d_commit;
	GgitCommit* d_parent_commit;
	gboolean d_use_gravatar;
	GitgRepository* _repository;
	gchar* d_datetime_format;
	GeeHashMap* d_parents_map;
	GRegex* regex_url;
	GgitConfig* _config;
	GRegex* regex_custom_links;
};

struct _Block6Data {
	int _ref_count_;
	GitgDiffViewCommitDetails* self;
	GtkRadioButton* button;
	GgitCommit* par;
};

struct _Block7Data {
	int _ref_count_;
	GitgDiffViewCommitDetails* self;
	gchar* _result_;
	gchar* subject_text;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	GgitConfig* conf;
};

struct _Block9Data {
	int _ref_count_;
	GitgDiffViewCommitDetails* self;
	GCancellable* cancel;
	GitgAvatarCache* cache;
};

static gint GitgDiffViewCommitDetails_private_offset;
static gpointer gitg_diff_view_commit_details_parent_class = NULL;

VALA_EXTERN GType gitg_diff_view_commit_details_get_type (void) G_GNUC_CONST ;
static void gitg_diff_view_commit_details_on_change_datetime (GitgDiffViewCommitDetails* self,
                                                       GSettings* settings,
                                                       const gchar* key);
static void gitg_diff_view_commit_details_set_datetime_format (GitgDiffViewCommitDetails* self,
                                                        const gchar* value);
static void gitg_diff_view_commit_details_real_dispose (GObject* base);
static void _gitg_diff_view_commit_details_on_change_datetime_g_settings_changed (GSettings* _sender,
                                                                           const gchar* key,
                                                                           gpointer self);
static gchar* gitg_diff_view_commit_details_author_to_markup (GitgDiffViewCommitDetails* self,
                                                       GgitSignature* author);
static void gitg_diff_view_commit_details_update (GitgDiffViewCommitDetails* self);
static guint __lambda45_ (GitgDiffViewCommitDetails* self,
                   GgitOId* oid);
static guint ___lambda45__gee_hash_data_func (gconstpointer v,
                                       gpointer self);
static gboolean __lambda46_ (GitgDiffViewCommitDetails* self,
                      GgitOId* o1,
                      GgitOId* o2);
static gboolean ___lambda46__gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static void _vala_GgitOId_free (GgitOId* self);
VALA_EXTERN GgitCommit* gitg_diff_view_commit_details_get_commit (GitgDiffViewCommitDetails* self);
static gchar* gitg_diff_view_commit_details_subject_to_markup (GitgDiffViewCommitDetails* self,
                                                        const gchar* subject_text);
static void gitg_diff_view_commit_details_update_datetime (GitgDiffViewCommitDetails* self);
VALA_EXTERN void gitg_diff_view_commit_details_set_parent_commit (GitgDiffViewCommitDetails* self,
                                                      GgitCommit* value);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _____lambda48_ (Block6Data* _data6_);
static void ______lambda48__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void gitg_diff_view_commit_details_update_avatar (GitgDiffViewCommitDetails* self);
static const gchar* gitg_diff_view_commit_details_get_datetime_format (GitgDiffViewCommitDetails* self);
static gchar* gitg_diff_view_commit_details_parse_links_on_subject (GitgDiffViewCommitDetails* self,
                                                             const gchar* subject_text);
static gchar* gitg_diff_view_commit_details_parse_smart_text (GitgDiffViewCommitDetails* self,
                                                       const gchar* subject_text);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
VALA_EXTERN GitgRepository* gitg_diff_view_commit_details_get_repository (GitgDiffViewCommitDetails* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gint ____lambda47_ (Block8Data* _data8_,
                    GMatchInfo* match_info,
                    const gchar* value);
static gint _____lambda47__ggit_config_match_callback (GMatchInfo* match_info,
                                                const gchar* value,
                                                gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda49_ (Block9Data* _data9_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda49__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean gitg_diff_view_commit_details_button_press_on_event_box_expand_collapse (GitgDiffViewCommitDetails* self,
                                                                                  GdkEventButton* event);
static gboolean _gitg_diff_view_commit_details_button_press_on_event_box_expand_collapse_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                                                 GdkEventButton* event,
                                                                                                                 gpointer self);
VALA_EXTERN GitgDiffViewCommitDetails* gitg_diff_view_commit_details_new (void);
VALA_EXTERN GitgDiffViewCommitDetails* gitg_diff_view_commit_details_construct (GType object_type);
VALA_EXTERN gboolean gitg_diff_view_commit_details_get_expanded (GitgDiffViewCommitDetails* self);
VALA_EXTERN void gitg_diff_view_commit_details_set_expanded (GitgDiffViewCommitDetails* self,
                                                 gboolean value);
VALA_EXTERN gboolean gitg_diff_view_commit_details_get_expander_visible (GitgDiffViewCommitDetails* self);
VALA_EXTERN void gitg_diff_view_commit_details_set_expander_visible (GitgDiffViewCommitDetails* self,
                                                         gboolean value);
VALA_EXTERN void gitg_diff_view_commit_details_set_commit (GitgDiffViewCommitDetails* self,
                                               GgitCommit* value);
VALA_EXTERN GgitCommit* gitg_diff_view_commit_details_get_parent_commit (GitgDiffViewCommitDetails* self);
VALA_EXTERN gboolean gitg_diff_view_commit_details_get_use_gravatar (GitgDiffViewCommitDetails* self);
VALA_EXTERN void gitg_diff_view_commit_details_set_use_gravatar (GitgDiffViewCommitDetails* self,
                                                     gboolean value);
VALA_EXTERN void gitg_diff_view_commit_details_set_repository (GitgDiffViewCommitDetails* self,
                                                   GitgRepository* value);
static GgitConfig* gitg_diff_view_commit_details_get_config (GitgDiffViewCommitDetails* self);
static void gitg_diff_view_commit_details_set_config (GitgDiffViewCommitDetails* self,
                                               GgitConfig* value);
static GObject * gitg_diff_view_commit_details_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _gitg_diff_view_commit_details___lambda50_ (GitgDiffViewCommitDetails* self);
static void __gitg_diff_view_commit_details___lambda50__g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void gitg_diff_view_commit_details_finalize (GObject * obj);
static GType gitg_diff_view_commit_details_get_type_once (void);
static void _vala_gitg_diff_view_commit_details_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_gitg_diff_view_commit_details_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;

static inline gpointer
gitg_diff_view_commit_details_get_instance_private (GitgDiffViewCommitDetails* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffViewCommitDetails_private_offset);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static void
gitg_diff_view_commit_details_on_change_datetime (GitgDiffViewCommitDetails* self,
                                                  GSettings* settings,
                                                  const gchar* key)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp1_ = g_settings_get_string (settings, "datetime-selection");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "custom") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_settings_get_string (settings, "custom-datetime");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_settings_get_string (settings, "predefined-datetime");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	gitg_diff_view_commit_details_set_datetime_format (self, _tmp0_);
	_g_free0 (_tmp0_);
}

static void
_gitg_diff_view_commit_details_on_change_datetime_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self)
{
	gitg_diff_view_commit_details_on_change_datetime ((GitgDiffViewCommitDetails*) self, _sender, key);
}

static void
gitg_diff_view_commit_details_real_dispose (GObject* base)
{
	GitgDiffViewCommitDetails * self;
	GSettings* _tmp0_;
	GCancellable* _tmp10_;
	self = (GitgDiffViewCommitDetails*) base;
	_tmp0_ = self->priv->d_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		guint _tmp2_;
		GQuark _tmp3_;
		GSettings* _tmp4_;
		guint _tmp5_;
		GQuark _tmp6_;
		GSettings* _tmp7_;
		guint _tmp8_;
		GQuark _tmp9_;
		_tmp1_ = self->priv->d_settings;
		g_signal_parse_name ("changed::datetime-selection", g_settings_get_type (), &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _gitg_diff_view_commit_details_on_change_datetime_g_settings_changed, self);
		_tmp4_ = self->priv->d_settings;
		g_signal_parse_name ("changed::custom-datetime", g_settings_get_type (), &_tmp5_, &_tmp6_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, _tmp6_, NULL, (GCallback) _gitg_diff_view_commit_details_on_change_datetime_g_settings_changed, self);
		_tmp7_ = self->priv->d_settings;
		g_signal_parse_name ("changed::predefined-datetime", g_settings_get_type (), &_tmp8_, &_tmp9_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _gitg_diff_view_commit_details_on_change_datetime_g_settings_changed, self);
		_g_object_unref0 (self->priv->d_settings);
		self->priv->d_settings = NULL;
	}
	_tmp10_ = self->priv->d_avatar_cancel;
	if (_tmp10_ != NULL) {
		GCancellable* _tmp11_;
		_tmp11_ = self->priv->d_avatar_cancel;
		g_cancellable_cancel (_tmp11_);
	}
	G_OBJECT_CLASS (gitg_diff_view_commit_details_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
}

static gchar*
gitg_diff_view_commit_details_author_to_markup (GitgDiffViewCommitDetails* self,
                                                GgitSignature* author)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* email = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (author != NULL, NULL);
	_tmp0_ = ggit_signature_get_name (author);
	_tmp1_ = g_markup_escape_text (_tmp0_, (gssize) -1);
	name = _tmp1_;
	_tmp2_ = ggit_signature_get_email (author);
	_tmp3_ = g_markup_escape_text (_tmp2_, (gssize) -1);
	email = _tmp3_;
	_tmp4_ = g_strdup_printf ("%s &lt;<a href=\"mailto:%s\">%s</a>&gt;", name, email, email);
	result = _tmp4_;
	_g_free0 (email);
	_g_free0 (name);
	return result;
}

static guint
__lambda45_ (GitgDiffViewCommitDetails* self,
             GgitOId* oid)
{
	guint result;
	g_return_val_if_fail (oid != NULL, 0U);
	result = ggit_oid_hash (oid);
	return result;
}

static guint
___lambda45__gee_hash_data_func (gconstpointer v,
                                 gpointer self)
{
	guint result;
	result = __lambda45_ ((GitgDiffViewCommitDetails*) self, (GgitOId*) v);
	return result;
}

static gboolean
__lambda46_ (GitgDiffViewCommitDetails* self,
             GgitOId* o1,
             GgitOId* o2)
{
	gboolean result;
	g_return_val_if_fail (o1 != NULL, FALSE);
	g_return_val_if_fail (o2 != NULL, FALSE);
	result = ggit_oid_equal (o1, o2);
	return result;
}

static gboolean
___lambda46__gee_equal_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gboolean result;
	result = __lambda46_ ((GitgDiffViewCommitDetails*) self, (GgitOId*) a, (GgitOId*) b);
	return result;
}

static GgitOId*
_vala_GgitOId_copy (GgitOId* self)
{
	return g_boxed_copy (ggit_oid_get_type (), self);
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GitgDiffViewCommitDetails* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->par);
		_g_object_unref0 (_data6_->button);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_____lambda48_ (Block6Data* _data6_)
{
	GitgDiffViewCommitDetails* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data6_->self;
	_tmp0_ = _data6_->button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GgitCommit* _tmp3_;
		_tmp3_ = _data6_->par;
		gitg_diff_view_commit_details_set_parent_commit (self, _tmp3_);
	}
}

static void
______lambda48__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                           gpointer self)
{
	_____lambda48_ (self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
gitg_diff_view_commit_details_update (GitgDiffViewCommitDetails* self)
{
	GeeHashMap* _tmp0_;
	GtkGrid* _tmp1_;
	GList* _tmp2_;
	GgitCommit* _tmp4_;
	GgitCommit* _tmp5_;
	GtkLabel* _tmp6_;
	GgitCommit* _tmp7_;
	GgitCommit* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkLabel* _tmp14_;
	GgitCommit* _tmp15_;
	GgitCommit* _tmp16_;
	GgitOId* _tmp17_;
	GgitOId* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GgitSignature* author = NULL;
	GgitCommit* _tmp21_;
	GgitCommit* _tmp22_;
	GgitSignature* _tmp23_;
	GtkLabel* _tmp24_;
	GgitSignature* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GgitSignature* committer = NULL;
	GgitCommit* _tmp28_;
	GgitCommit* _tmp29_;
	GgitSignature* _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	GgitSignature* _tmp33_;
	const gchar* _tmp34_;
	GgitSignature* _tmp35_;
	const gchar* _tmp36_;
	GgitCommitParents* parents = NULL;
	GgitCommit* _tmp54_;
	GgitCommit* _tmp55_;
	GgitCommitParents* _tmp56_;
	GgitCommit* _tmp57_ = NULL;
	GgitCommitParents* _tmp58_;
	guint _tmp59_;
	guint _tmp60_;
	GgitCommit* first_parent = NULL;
	GgitCommit* _tmp63_;
	GgitCommit* _tmp64_;
	GgitCommitParents* _tmp65_;
	guint _tmp66_;
	guint _tmp67_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (ggit_oid_get_type (), (GBoxedCopyFunc) _vala_GgitOId_copy, (GDestroyNotify) _vala_GgitOId_free, gtk_radio_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ___lambda45__gee_hash_data_func, g_object_ref (self), g_object_unref, ___lambda46__gee_equal_data_func, g_object_ref (self), g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_parents_map);
	self->priv->d_parents_map = _tmp0_;
	_tmp1_ = self->priv->d_grid_parents;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp2_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = child;
				gtk_widget_destroy (_tmp3_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp4_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = self->priv->d_label_subject;
	_tmp7_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = ggit_commit_get_subject (_tmp8_);
	_tmp10_ = g_markup_escape_text (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = gitg_diff_view_commit_details_subject_to_markup (self, _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_label_set_markup (_tmp6_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = self->priv->d_label_sha1;
	_tmp15_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = ggit_object_get_id ((GgitObject*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = ggit_oid_to_string (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_label_set_label (_tmp14_, _tmp20_);
	_g_free0 (_tmp20_);
	__vala_GgitOId_free0 (_tmp18_);
	_tmp21_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = ggit_commit_get_author (_tmp22_);
	author = _tmp23_;
	_tmp24_ = self->priv->d_label_author;
	_tmp25_ = author;
	_tmp26_ = gitg_diff_view_commit_details_author_to_markup (self, _tmp25_);
	_tmp27_ = _tmp26_;
	gtk_label_set_label (_tmp24_, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = ggit_commit_get_committer (_tmp29_);
	committer = _tmp30_;
	_tmp33_ = committer;
	_tmp34_ = ggit_signature_get_name (_tmp33_);
	_tmp35_ = author;
	_tmp36_ = ggit_signature_get_name (_tmp35_);
	if (g_strcmp0 (_tmp34_, _tmp36_) != 0) {
		_tmp32_ = TRUE;
	} else {
		GgitSignature* _tmp37_;
		const gchar* _tmp38_;
		GgitSignature* _tmp39_;
		const gchar* _tmp40_;
		_tmp37_ = committer;
		_tmp38_ = ggit_signature_get_email (_tmp37_);
		_tmp39_ = author;
		_tmp40_ = ggit_signature_get_email (_tmp39_);
		_tmp32_ = g_strcmp0 (_tmp38_, _tmp40_) != 0;
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		GgitSignature* _tmp41_;
		GDateTime* _tmp42_;
		GDateTime* _tmp43_;
		GgitSignature* _tmp44_;
		GDateTime* _tmp45_;
		GDateTime* _tmp46_;
		_tmp41_ = committer;
		_tmp42_ = ggit_signature_get_time (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = author;
		_tmp45_ = ggit_signature_get_time (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp31_ = g_date_time_compare (_tmp43_, _tmp46_) != 0;
		_g_date_time_unref0 (_tmp46_);
		_g_date_time_unref0 (_tmp43_);
	}
	if (_tmp31_) {
		GtkLabel* _tmp47_;
		GgitSignature* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp47_ = self->priv->d_label_committer;
		_tmp48_ = committer;
		_tmp49_ = gitg_diff_view_commit_details_author_to_markup (self, _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strdup_printf (_ ("Committed by %s"), _tmp50_);
		_tmp52_ = _tmp51_;
		gtk_label_set_label (_tmp47_, _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
	} else {
		GtkLabel* _tmp53_;
		_tmp53_ = self->priv->d_label_committer;
		gtk_label_set_label (_tmp53_, "");
	}
	gitg_diff_view_commit_details_update_datetime (self);
	_tmp54_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp55_ = _tmp54_;
	_tmp56_ = ggit_commit_get_parents (_tmp55_);
	parents = _tmp56_;
	_tmp58_ = parents;
	_tmp59_ = ggit_commit_parents_get_size (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_ == ((guint) 0)) {
		_g_object_unref0 (_tmp57_);
		_tmp57_ = NULL;
	} else {
		GgitCommitParents* _tmp61_;
		GgitCommit* _tmp62_;
		_tmp61_ = parents;
		_tmp62_ = ggit_commit_parents_get (_tmp61_, (guint) 0);
		_g_object_unref0 (_tmp57_);
		_tmp57_ = _tmp62_;
	}
	_tmp63_ = _g_object_ref0 (_tmp57_);
	first_parent = _tmp63_;
	_tmp64_ = first_parent;
	gitg_diff_view_commit_details_set_parent_commit (self, _tmp64_);
	_tmp65_ = parents;
	_tmp66_ = ggit_commit_parents_get_size (_tmp65_);
	_tmp67_ = _tmp66_;
	if (_tmp67_ > ((guint) 1)) {
		GtkGrid* _tmp68_;
		GSList* grp = NULL;
		GtkRadioButton* first = NULL;
		_tmp68_ = self->priv->d_grid_parents_container;
		gtk_widget_show ((GtkWidget*) _tmp68_);
		grp = NULL;
		first = NULL;
		{
			GgitCommitParents* _parent_list = NULL;
			GgitCommitParents* _tmp69_;
			guint _parent_size = 0U;
			GgitCommitParents* _tmp70_;
			guint _tmp71_;
			guint _tmp72_;
			gint _parent_index = 0;
			_tmp69_ = parents;
			_parent_list = _tmp69_;
			_tmp70_ = _parent_list;
			_tmp71_ = ggit_commit_parents_get_size (_tmp70_);
			_tmp72_ = _tmp71_;
			_parent_size = _tmp72_;
			_parent_index = -1;
			while (TRUE) {
				Block6Data* _data6_;
				gint _tmp73_;
				guint _tmp74_;
				GgitCommit* parent = NULL;
				GgitCommitParents* _tmp75_;
				GgitCommit* _tmp76_;
				gchar* pid = NULL;
				GgitCommit* _tmp77_;
				GgitOId* _tmp78_;
				GgitOId* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* psubj = NULL;
				GgitCommit* _tmp84_;
				const gchar* _tmp85_;
				gchar* _tmp86_;
				GSList* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				const gchar* _tmp90_;
				const gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				GtkRadioButton* _tmp94_;
				GtkRadioButton* _tmp95_;
				GtkRadioButton* _tmp96_;
				GtkRadioButton* _tmp99_;
				GtkRadioButton* _tmp100_;
				GeeHashMap* _tmp101_;
				GgitCommit* _tmp102_;
				GgitOId* _tmp103_;
				GgitOId* _tmp104_;
				GtkRadioButton* _tmp105_;
				GtkRadioButton* _tmp106_;
				GtkGrid* _tmp107_;
				GtkRadioButton* _tmp108_;
				GgitCommit* _tmp109_;
				GgitCommit* _tmp110_;
				GtkRadioButton* _tmp111_;
				_data6_ = g_slice_new0 (Block6Data);
				_data6_->_ref_count_ = 1;
				_data6_->self = g_object_ref (self);
				_parent_index = _parent_index + 1;
				_tmp73_ = _parent_index;
				_tmp74_ = _parent_size;
				if (!(((guint) _tmp73_) < _tmp74_)) {
					block6_data_unref (_data6_);
					_data6_ = NULL;
					break;
				}
				_tmp75_ = _parent_list;
				_tmp76_ = ggit_commit_parents_get (_tmp75_, (guint) _parent_index);
				parent = _tmp76_;
				_tmp77_ = parent;
				_tmp78_ = ggit_object_get_id ((GgitObject*) _tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ggit_oid_to_string (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = string_substring (_tmp81_, (glong) 0, (glong) 6);
				_tmp83_ = _tmp82_;
				_g_free0 (_tmp81_);
				__vala_GgitOId_free0 (_tmp79_);
				pid = _tmp83_;
				_tmp84_ = parent;
				_tmp85_ = ggit_commit_get_subject (_tmp84_);
				_tmp86_ = g_strdup (_tmp85_);
				psubj = _tmp86_;
				_tmp87_ = grp;
				_tmp88_ = pid;
				_tmp89_ = string_to_string (_tmp88_);
				_tmp90_ = psubj;
				_tmp91_ = string_to_string (_tmp90_);
				_tmp92_ = g_strconcat (_tmp89_, ": ", _tmp91_, NULL);
				_tmp93_ = _tmp92_;
				_tmp94_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp87_, _tmp93_);
				g_object_ref_sink (_tmp94_);
				_tmp95_ = _tmp94_;
				_g_free0 (_tmp93_);
				_data6_->button = _tmp95_;
				_tmp96_ = first;
				if (_tmp96_ == NULL) {
					GtkRadioButton* _tmp97_;
					GtkRadioButton* _tmp98_;
					_tmp97_ = _data6_->button;
					_tmp98_ = _g_object_ref0 (_tmp97_);
					_g_object_unref0 (first);
					first = _tmp98_;
				}
				_tmp99_ = _data6_->button;
				_tmp100_ = first;
				g_object_set (_tmp99_, "group", _tmp100_, NULL);
				_tmp101_ = self->priv->d_parents_map;
				_tmp102_ = parent;
				_tmp103_ = ggit_object_get_id ((GgitObject*) _tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = _data6_->button;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp101_, _tmp104_, _tmp105_);
				__vala_GgitOId_free0 (_tmp104_);
				_tmp106_ = _data6_->button;
				gtk_widget_show ((GtkWidget*) _tmp106_);
				_tmp107_ = self->priv->d_grid_parents;
				_tmp108_ = _data6_->button;
				gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp108_);
				_tmp109_ = parent;
				_tmp110_ = _g_object_ref0 (_tmp109_);
				_data6_->par = _tmp110_;
				_tmp111_ = _data6_->button;
				g_signal_connect_data ((GtkToggleButton*) _tmp111_, "toggled", (GCallback) ______lambda48__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
				_g_free0 (psubj);
				_g_free0 (pid);
				_g_object_unref0 (parent);
				block6_data_unref (_data6_);
				_data6_ = NULL;
			}
		}
		_g_object_unref0 (first);
		(grp == NULL) ? NULL : (grp = (_g_slist_free__g_object_unref0_ (grp), NULL));
	} else {
		GtkGrid* _tmp112_;
		_tmp112_ = self->priv->d_grid_parents_container;
		gtk_widget_hide ((GtkWidget*) _tmp112_);
	}
	gitg_diff_view_commit_details_update_avatar (self);
	_g_object_unref0 (first_parent);
	_g_object_unref0 (_tmp57_);
	_g_object_unref0 (parents);
	_g_object_unref0 (committer);
	_g_object_unref0 (author);
}

static void
gitg_diff_view_commit_details_update_datetime (GitgDiffViewCommitDetails* self)
{
	GgitCommit* _tmp0_;
	GgitCommit* _tmp1_;
	GgitSignature* author = NULL;
	GgitCommit* _tmp2_;
	GgitCommit* _tmp3_;
	GgitSignature* _tmp4_;
	GtkLabel* _tmp5_;
	GgitSignature* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GgitSignature* _tmp9_;
	GTimeZone* _tmp10_;
	GTimeZone* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GgitSignature* committer = NULL;
	GgitCommit* _tmp18_;
	GgitCommit* _tmp19_;
	GgitSignature* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GgitSignature* _tmp23_;
	const gchar* _tmp24_;
	GgitSignature* _tmp25_;
	const gchar* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = ggit_commit_get_author (_tmp3_);
	author = _tmp4_;
	_tmp5_ = self->priv->d_label_author_date;
	_tmp6_ = author;
	_tmp7_ = ggit_signature_get_time (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = author;
	_tmp10_ = ggit_signature_get_time_zone (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_date_time_to_timezone (_tmp8_, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gitg_diff_view_commit_details_get_datetime_format (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_date_time_format (_tmp13_, _tmp15_);
	_tmp17_ = _tmp16_;
	gtk_label_set_label (_tmp5_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_date_time_unref0 (_tmp13_);
	_g_time_zone_unref0 (_tmp11_);
	_g_date_time_unref0 (_tmp8_);
	_tmp18_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = ggit_commit_get_committer (_tmp19_);
	committer = _tmp20_;
	_tmp23_ = committer;
	_tmp24_ = ggit_signature_get_name (_tmp23_);
	_tmp25_ = author;
	_tmp26_ = ggit_signature_get_name (_tmp25_);
	if (g_strcmp0 (_tmp24_, _tmp26_) != 0) {
		_tmp22_ = TRUE;
	} else {
		GgitSignature* _tmp27_;
		const gchar* _tmp28_;
		GgitSignature* _tmp29_;
		const gchar* _tmp30_;
		_tmp27_ = committer;
		_tmp28_ = ggit_signature_get_email (_tmp27_);
		_tmp29_ = author;
		_tmp30_ = ggit_signature_get_email (_tmp29_);
		_tmp22_ = g_strcmp0 (_tmp28_, _tmp30_) != 0;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		GgitSignature* _tmp31_;
		GDateTime* _tmp32_;
		GDateTime* _tmp33_;
		GgitSignature* _tmp34_;
		GDateTime* _tmp35_;
		GDateTime* _tmp36_;
		_tmp31_ = committer;
		_tmp32_ = ggit_signature_get_time (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = author;
		_tmp35_ = ggit_signature_get_time (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp21_ = g_date_time_compare (_tmp33_, _tmp36_) != 0;
		_g_date_time_unref0 (_tmp36_);
		_g_date_time_unref0 (_tmp33_);
	}
	if (_tmp21_) {
		GtkLabel* _tmp37_;
		GgitSignature* _tmp38_;
		GDateTime* _tmp39_;
		GDateTime* _tmp40_;
		GgitSignature* _tmp41_;
		GTimeZone* _tmp42_;
		GTimeZone* _tmp43_;
		GDateTime* _tmp44_;
		GDateTime* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp37_ = self->priv->d_label_committer_date;
		_tmp38_ = committer;
		_tmp39_ = ggit_signature_get_time (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = committer;
		_tmp42_ = ggit_signature_get_time_zone (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_date_time_to_timezone (_tmp40_, _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = gitg_diff_view_commit_details_get_datetime_format (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_date_time_format (_tmp45_, _tmp47_);
		_tmp49_ = _tmp48_;
		gtk_label_set_label (_tmp37_, _tmp49_);
		_g_free0 (_tmp49_);
		_g_date_time_unref0 (_tmp45_);
		_g_time_zone_unref0 (_tmp43_);
		_g_date_time_unref0 (_tmp40_);
	} else {
		GtkLabel* _tmp50_;
		_tmp50_ = self->priv->d_label_committer_date;
		gtk_label_set_label (_tmp50_, "");
	}
	_g_object_unref0 (committer);
	_g_object_unref0 (author);
}

static gchar*
gitg_diff_view_commit_details_subject_to_markup (GitgDiffViewCommitDetails* self,
                                                 const gchar* subject_text)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subject_text != NULL, NULL);
	_tmp0_ = gitg_diff_view_commit_details_parse_links_on_subject (self, subject_text);
	result = _tmp0_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
gitg_diff_view_commit_details_parse_links_on_subject (GitgDiffViewCommitDetails* self,
                                                      const gchar* subject_text)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subject_text != NULL, NULL);
	_tmp0_ = g_strdup (subject_text);
	_result_ = _tmp0_;
	{
		GMatchInfo* matchInfo = NULL;
		GRegex* _tmp1_;
		GMatchInfo* _tmp2_ = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp1_ = self->priv->regex_url;
		g_regex_match (_tmp1_, subject_text, 0, &_tmp2_);
		_g_match_info_unref0 (matchInfo);
		matchInfo = _tmp2_;
		while (TRUE) {
			GMatchInfo* _tmp3_;
			gchar* text = NULL;
			GMatchInfo* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GMatchInfo* _tmp13_;
			_tmp3_ = matchInfo;
			if (!g_match_info_matches (_tmp3_)) {
				break;
			}
			_tmp4_ = matchInfo;
			_tmp5_ = g_match_info_fetch (_tmp4_, 0);
			text = _tmp5_;
			_tmp6_ = _result_;
			_tmp7_ = text;
			_tmp8_ = text;
			_tmp9_ = text;
			_tmp10_ = g_strdup_printf ("<a href=\"%s\">%s</a>", _tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = string_replace (_tmp6_, _tmp7_, _tmp11_);
			_g_free0 (_result_);
			_result_ = _tmp12_;
			_g_free0 (_tmp11_);
			_tmp13_ = matchInfo;
			g_match_info_next (_tmp13_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (text);
				_g_match_info_unref0 (matchInfo);
				goto __catch0_g_error;
			}
			_g_free0 (text);
		}
		_tmp14_ = _result_;
		_tmp15_ = gitg_diff_view_commit_details_parse_smart_text (self, _tmp14_);
		_g_free0 (_result_);
		_result_ = _tmp15_;
		_g_match_info_unref0 (matchInfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = _result_;
	return result;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GitgDiffViewCommitDetails* self;
		self = _data7_->self;
		_g_free0 (_data7_->_result_);
		_g_free0 (_data7_->subject_text);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GitgDiffViewCommitDetails* self;
		self = _data8_->_data7_->self;
		_g_object_unref0 (_data8_->conf);
		block7_data_unref (_data8_->_data7_);
		_data8_->_data7_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static gint
____lambda47_ (Block8Data* _data8_,
               GMatchInfo* match_info,
               const gchar* value)
{
	Block7Data* _data7_;
	GitgDiffViewCommitDetails* self;
	gchar* group = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* custom_link_regexp = NULL;
	gchar* _tmp3_;
	gchar* replacement_key = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	g_return_val_if_fail (match_info != NULL, 0);
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = g_match_info_fetch (match_info, 1);
	group = _tmp0_;
	_tmp1_ = group;
	g_debug ("gitg-diff-view-commit-details.vala:358: found custom-link group: %s", _tmp1_);
	if (value == NULL) {
		_tmp2_ = "es nulo";
	} else {
		_tmp2_ = "es vacio";
	}
	g_debug ("gitg-diff-view-commit-details.vala:359: %s", _tmp2_);
	_tmp3_ = g_strdup (value);
	custom_link_regexp = _tmp3_;
	_tmp4_ = group;
	_tmp5_ = g_strdup_printf ("gitg.custom-link.%s.replacement", _tmp4_);
	replacement_key = _tmp5_;
	{
		gchar* custom_link_replacement = NULL;
		GgitConfig* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GRegex* custom_regex = NULL;
		const gchar* _tmp10_;
		GRegex* _tmp11_;
		_tmp6_ = _data8_->conf;
		_tmp7_ = replacement_key;
		_tmp8_ = ggit_config_get_string (_tmp6_, _tmp7_, &_inner_error0_);
		_tmp9_ = g_strdup (_tmp8_);
		custom_link_replacement = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = custom_link_regexp;
		_tmp11_ = g_regex_new (_tmp10_, 0, 0, &_inner_error0_);
		custom_regex = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (custom_link_replacement);
			goto __catch0_g_error;
		}
		{
			GMatchInfo* matchInfo = NULL;
			GRegex* _tmp12_;
			GMatchInfo* _tmp13_ = NULL;
			_tmp12_ = custom_regex;
			g_regex_match (_tmp12_, _data7_->subject_text, 0, &_tmp13_);
			_g_match_info_unref0 (matchInfo);
			matchInfo = _tmp13_;
			while (TRUE) {
				GMatchInfo* _tmp14_;
				gchar* text = NULL;
				GMatchInfo* _tmp15_;
				gchar* _tmp16_;
				gchar* link = NULL;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GMatchInfo* _tmp38_;
				_tmp14_ = matchInfo;
				if (!g_match_info_matches (_tmp14_)) {
					break;
				}
				_tmp15_ = matchInfo;
				_tmp16_ = g_match_info_fetch (_tmp15_, 0);
				text = _tmp16_;
				_tmp17_ = text;
				_tmp18_ = g_strdup (_tmp17_);
				link = _tmp18_;
				_tmp19_ = link;
				g_debug ("gitg-diff-view-commit-details.vala:377: found: %s", _tmp19_);
				_tmp20_ = custom_link_replacement;
				if (_tmp20_ != NULL) {
					gchar* _tmp21_ = NULL;
					GRegex* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp22_ = custom_regex;
					_tmp23_ = link;
					_tmp24_ = text;
					_tmp25_ = strlen (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = custom_link_replacement;
					_tmp28_ = g_regex_replace (_tmp22_, _tmp23_, (gssize) _tmp26_, 0, _tmp27_, 0, &_inner_error0_);
					_tmp21_ = _tmp28_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (link);
						_g_free0 (text);
						_g_match_info_unref0 (matchInfo);
						goto __catch1_g_error;
					}
					_tmp29_ = _tmp21_;
					_tmp21_ = NULL;
					_g_free0 (link);
					link = _tmp29_;
					_g_free0 (_tmp21_);
				}
				_tmp30_ = _data7_->_result_;
				_tmp31_ = text;
				_tmp32_ = link;
				_tmp33_ = link;
				_tmp34_ = text;
				_tmp35_ = g_strdup_printf ("<a href=\"%s\" title=\"%s\">%s</a>", _tmp32_, _tmp33_, _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = string_replace (_tmp30_, _tmp31_, _tmp36_);
				_g_free0 (_data7_->_result_);
				_data7_->_result_ = _tmp37_;
				_g_free0 (_tmp36_);
				_tmp38_ = matchInfo;
				g_match_info_next (_tmp38_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (link);
					_g_free0 (text);
					_g_match_info_unref0 (matchInfo);
					goto __catch1_g_error;
				}
				_g_free0 (link);
				_g_free0 (text);
			}
			_g_match_info_unref0 (matchInfo);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (custom_regex);
			_g_free0 (custom_link_replacement);
			goto __catch0_g_error;
		}
		_g_regex_unref0 (custom_regex);
		_g_free0 (custom_link_replacement);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_warning ("gitg-diff-view-commit-details.vala:392: Cannot read git config: %s", _tmp40_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp41_ = -1;
		_g_free0 (replacement_key);
		_g_free0 (custom_link_regexp);
		_g_free0 (group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp41_;
	}
	result = 0;
	_g_free0 (replacement_key);
	_g_free0 (custom_link_regexp);
	_g_free0 (group);
	return result;
}

static gint
_____lambda47__ggit_config_match_callback (GMatchInfo* match_info,
                                           const gchar* value,
                                           gpointer self)
{
	gint result;
	result = ____lambda47_ (self, match_info, value);
	return result;
}

static gchar*
gitg_diff_view_commit_details_parse_smart_text (GitgDiffViewCommitDetails* self,
                                                const gchar* subject_text)
{
	Block7Data* _data7_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GitgRepository* _tmp2_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subject_text != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = g_strdup (subject_text);
	_g_free0 (_data7_->subject_text);
	_data7_->subject_text = _tmp0_;
	_tmp1_ = g_strdup (_data7_->subject_text);
	_data7_->_result_ = _tmp1_;
	_tmp2_ = self->priv->_repository;
	if (_tmp2_ != NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_data7_->subject_text);
		_g_free0 (_data7_->_result_);
		_data7_->_result_ = _tmp3_;
		{
			Block8Data* _data8_;
			GgitConfig* _tmp4_ = NULL;
			GitgRepository* _tmp5_;
			GgitConfig* _tmp6_;
			GgitConfig* _tmp7_;
			GgitConfig* _tmp8_;
			GRegex* _tmp9_;
			_data8_ = g_slice_new0 (Block8Data);
			_data8_->_ref_count_ = 1;
			_data8_->_data7_ = block7_data_ref (_data7_);
			_tmp5_ = self->priv->_repository;
			_tmp6_ = ggit_repository_get_config ((GgitRepository*) _tmp5_, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block8_data_unref (_data8_);
				_data8_ = NULL;
				goto __catch0_g_error;
			}
			_tmp7_ = ggit_config_snapshot (_tmp4_, &_inner_error0_);
			_data8_->conf = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				goto __catch0_g_error;
			}
			_tmp8_ = _data8_->conf;
			_tmp9_ = self->priv->regex_custom_links;
			ggit_config_match_foreach (_tmp8_, _tmp9_, _____lambda47__ggit_config_match_callback, _data8_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				goto __catch0_g_error;
			}
			_g_object_unref0 (_tmp4_);
			block8_data_unref (_data8_);
			_data8_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("gitg-diff-view-commit-details.vala:399: Cannot read git config: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block7_data_unref (_data7_);
			_data7_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = _data7_->_result_;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GitgDiffViewCommitDetails* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->cache);
		_g_object_unref0 (_data9_->cancel);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
___lambda49_ (Block9Data* _data9_,
              GObject* obj,
              GAsyncResult* res)
{
	GitgDiffViewCommitDetails* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	self = _data9_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data9_->cancel;
	if (!g_cancellable_is_cancelled (_tmp0_)) {
		GdkPixbuf* pixbuf = NULL;
		GitgAvatarCache* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp1_ = _data9_->cache;
		_tmp2_ = gitg_avatar_cache_load_finish (_tmp1_, res);
		pixbuf = _tmp2_;
		_tmp3_ = pixbuf;
		if (_tmp3_ != NULL) {
			GtkImage* _tmp4_;
			GdkPixbuf* _tmp5_;
			GtkImage* _tmp6_;
			GtkStyleContext* _tmp7_;
			_tmp4_ = self->priv->d_image_avatar;
			_tmp5_ = pixbuf;
			g_object_set (_tmp4_, "pixbuf", _tmp5_, NULL);
			_tmp6_ = self->priv->d_image_avatar;
			_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
			gtk_style_context_remove_class (_tmp7_, "dim-label");
		} else {
			GtkImage* _tmp8_;
			GtkImage* _tmp9_;
			GtkStyleContext* _tmp10_;
			_tmp8_ = self->priv->d_image_avatar;
			g_object_set (_tmp8_, "icon-name", "avatar-default-symbolic", NULL);
			_tmp9_ = self->priv->d_image_avatar;
			_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
			gtk_style_context_add_class (_tmp10_, "dim-label");
		}
		_g_object_unref0 (pixbuf);
	}
	_tmp11_ = _data9_->cancel;
	_tmp12_ = self->priv->d_avatar_cancel;
	if (_tmp11_ == _tmp12_) {
		_g_object_unref0 (self->priv->d_avatar_cancel);
		self->priv->d_avatar_cancel = NULL;
	}
}

static void
____lambda49__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda49_ (self, source_object, res);
	block9_data_unref (self);
}

static void
gitg_diff_view_commit_details_update_avatar (GitgDiffViewCommitDetails* self)
{
	GgitCommit* _tmp0_;
	GgitCommit* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_diff_view_commit_details_get_commit (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	if (self->priv->d_use_gravatar) {
		Block9Data* _data9_;
		GCancellable* _tmp2_;
		GCancellable* _tmp4_;
		GCancellable* _tmp5_;
		GCancellable* _tmp6_;
		GitgAvatarCache* _tmp7_;
		GitgAvatarCache* _tmp8_;
		GgitCommit* _tmp9_;
		GgitCommit* _tmp10_;
		GgitSignature* _tmp11_;
		GgitSignature* _tmp12_;
		const gchar* _tmp13_;
		GtkImage* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GCancellable* _tmp17_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->self = g_object_ref (self);
		_tmp2_ = self->priv->d_avatar_cancel;
		if (_tmp2_ != NULL) {
			GCancellable* _tmp3_;
			_tmp3_ = self->priv->d_avatar_cancel;
			g_cancellable_cancel (_tmp3_);
		}
		_tmp4_ = g_cancellable_new ();
		_g_object_unref0 (self->priv->d_avatar_cancel);
		self->priv->d_avatar_cancel = _tmp4_;
		_tmp5_ = self->priv->d_avatar_cancel;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_data9_->cancel = _tmp6_;
		_tmp7_ = gitg_avatar_cache_default ();
		_data9_->cache = _tmp7_;
		_tmp8_ = _data9_->cache;
		_tmp9_ = gitg_diff_view_commit_details_get_commit (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = ggit_commit_get_author (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = ggit_signature_get_email (_tmp12_);
		_tmp14_ = self->priv->d_image_avatar;
		_tmp15_ = gtk_image_get_pixel_size (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _data9_->cancel;
		gitg_avatar_cache_load (_tmp8_, _tmp13_, _tmp16_, _tmp17_, ____lambda49__gasync_ready_callback, block9_data_ref (_data9_));
		_g_object_unref0 (_tmp12_);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	} else {
		GtkImage* _tmp18_;
		GtkImage* _tmp19_;
		GtkStyleContext* _tmp20_;
		_tmp18_ = self->priv->d_image_avatar;
		g_object_set (_tmp18_, "icon-name", "avatar-default-symbolic", NULL);
		_tmp19_ = self->priv->d_image_avatar;
		_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
		gtk_style_context_add_class (_tmp20_, "dim-label");
	}
}

static gboolean
gitg_diff_view_commit_details_button_press_on_event_box_expand_collapse (GitgDiffViewCommitDetails* self,
                                                                         GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
		GtkExpander* _tmp0_;
		GtkExpander* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp0_ = self->priv->d_expander_files;
		_tmp1_ = self->priv->d_expander_files;
		_tmp2_ = gtk_expander_get_expanded (_tmp1_);
		_tmp3_ = _tmp2_;
		gtk_expander_set_expanded (_tmp0_, !_tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_gitg_diff_view_commit_details_button_press_on_event_box_expand_collapse_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                                        GdkEventButton* event,
                                                                                                        gpointer self)
{
	gboolean result;
	result = gitg_diff_view_commit_details_button_press_on_event_box_expand_collapse ((GitgDiffViewCommitDetails*) self, event);
	return result;
}

GitgDiffViewCommitDetails*
gitg_diff_view_commit_details_construct (GType object_type)
{
	GitgDiffViewCommitDetails * self = NULL;
	self = (GitgDiffViewCommitDetails*) g_object_new (object_type, NULL);
	return self;
}

GitgDiffViewCommitDetails*
gitg_diff_view_commit_details_new (void)
{
	return gitg_diff_view_commit_details_construct (GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS);
}

gboolean
gitg_diff_view_commit_details_get_expanded (GitgDiffViewCommitDetails* self)
{
	gboolean result;
	GtkExpander* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_expander_files;
	_tmp1_ = gtk_expander_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
gitg_diff_view_commit_details_set_expanded (GitgDiffViewCommitDetails* self,
                                            gboolean value)
{
	GtkExpander* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_expander_files;
	_tmp1_ = gtk_expander_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != value) {
		GtkExpander* _tmp3_;
		_tmp3_ = self->priv->d_expander_files;
		gtk_expander_set_expanded (_tmp3_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDED_PROPERTY]);
}

gboolean
gitg_diff_view_commit_details_get_expander_visible (GitgDiffViewCommitDetails* self)
{
	gboolean result;
	GtkExpander* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_expander_files;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
gitg_diff_view_commit_details_set_expander_visible (GitgDiffViewCommitDetails* self,
                                                    gboolean value)
{
	GtkExpander* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_expander_files;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	_tmp1_ = self->priv->d_label_expand_collapse_files;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDER_VISIBLE_PROPERTY]);
}

GgitCommit*
gitg_diff_view_commit_details_get_commit (GitgDiffViewCommitDetails* self)
{
	GgitCommit* result;
	GgitCommit* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_commit;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_commit_details_set_commit (GitgDiffViewCommitDetails* self,
                                          GgitCommit* value)
{
	GgitCommit* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_commit;
	if (_tmp0_ != value) {
		GgitCommit* _tmp1_;
		_tmp1_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->d_commit);
		self->priv->d_commit = _tmp1_;
		gitg_diff_view_commit_details_update (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_COMMIT_PROPERTY]);
}

GgitCommit*
gitg_diff_view_commit_details_get_parent_commit (GitgDiffViewCommitDetails* self)
{
	GgitCommit* result;
	GgitCommit* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_parent_commit;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_commit_details_set_parent_commit (GitgDiffViewCommitDetails* self,
                                                 GgitCommit* value)
{
	GgitCommit* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_parent_commit;
	if (_tmp0_ != value) {
		GgitCommit* _tmp1_;
		_tmp1_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->d_parent_commit);
		self->priv->d_parent_commit = _tmp1_;
		if (value != NULL) {
			GtkRadioButton* button = NULL;
			GeeHashMap* _tmp2_;
			GgitOId* _tmp3_;
			GgitOId* _tmp4_;
			gpointer _tmp5_;
			GtkRadioButton* _tmp6_;
			GtkRadioButton* _tmp7_;
			_tmp2_ = self->priv->d_parents_map;
			_tmp3_ = ggit_object_get_id ((GgitObject*) value);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp4_);
			_tmp6_ = (GtkRadioButton*) _tmp5_;
			__vala_GgitOId_free0 (_tmp4_);
			button = _tmp6_;
			_tmp7_ = button;
			if (_tmp7_ != NULL) {
				GtkRadioButton* _tmp8_;
				_tmp8_ = button;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp8_, TRUE);
			}
			_g_object_unref0 (button);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_PARENT_COMMIT_PROPERTY]);
}

gboolean
gitg_diff_view_commit_details_get_use_gravatar (GitgDiffViewCommitDetails* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_use_gravatar;
	return result;
}

void
gitg_diff_view_commit_details_set_use_gravatar (GitgDiffViewCommitDetails* self,
                                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_use_gravatar = value;
	gitg_diff_view_commit_details_update_avatar (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_USE_GRAVATAR_PROPERTY]);
}

GitgRepository*
gitg_diff_view_commit_details_get_repository (GitgDiffViewCommitDetails* self)
{
	GitgRepository* result;
	GitgRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_repository;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_commit_details_set_repository (GitgDiffViewCommitDetails* self,
                                              GitgRepository* value)
{
	GitgRepository* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_commit_details_get_repository (self);
	if (old_value != value) {
		GitgRepository* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_repository);
		self->priv->_repository = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_REPOSITORY_PROPERTY]);
	}
}

static const gchar*
gitg_diff_view_commit_details_get_datetime_format (GitgDiffViewCommitDetails* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_datetime_format;
	result = _tmp0_;
	return result;
}

static void
gitg_diff_view_commit_details_set_datetime_format (GitgDiffViewCommitDetails* self,
                                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->d_datetime_format);
	self->priv->d_datetime_format = _tmp0_;
	gitg_diff_view_commit_details_update_datetime (self);
}

static GgitConfig*
gitg_diff_view_commit_details_get_config (GitgDiffViewCommitDetails* self)
{
	GgitConfig* result;
	GgitConfig* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_config;
	result = _tmp0_;
	return result;
}

static void
gitg_diff_view_commit_details_set_config (GitgDiffViewCommitDetails* self,
                                          GgitConfig* value)
{
	GgitConfig* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_config);
	self->priv->_config = _tmp0_;
}

static void
_gitg_diff_view_commit_details___lambda50_ (GitgDiffViewCommitDetails* self)
{
	GtkExpander* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->d_expander_files;
	_tmp1_ = gtk_expander_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkLabel* _tmp3_;
		_tmp3_ = self->priv->d_label_expand_collapse_files;
		gtk_label_set_label (_tmp3_, _ ("Collapse all"));
	} else {
		GtkLabel* _tmp4_;
		_tmp4_ = self->priv->d_label_expand_collapse_files;
		gtk_label_set_label (_tmp4_, _ ("Expand all"));
	}
	g_object_notify ((GObject*) self, "expanded");
}

static void
__gitg_diff_view_commit_details___lambda50__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	_gitg_diff_view_commit_details___lambda50_ ((GitgDiffViewCommitDetails*) self);
}

static GObject *
gitg_diff_view_commit_details_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDiffViewCommitDetails * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GtkExpander* _tmp5_;
	parent_class = G_OBJECT_CLASS (gitg_diff_view_commit_details_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails);
	_tmp0_ = g_settings_new (APPLICATION_ID ".preferences.commit.message");
	_g_object_unref0 (self->priv->d_settings);
	self->priv->d_settings = _tmp0_;
	_tmp1_ = self->priv->d_settings;
	g_signal_connect_object (_tmp1_, "changed::datetime-selection", (GCallback) _gitg_diff_view_commit_details_on_change_datetime_g_settings_changed, self, 0);
	_tmp2_ = self->priv->d_settings;
	g_signal_connect_object (_tmp2_, "changed::custom-datetime", (GCallback) _gitg_diff_view_commit_details_on_change_datetime_g_settings_changed, self, 0);
	_tmp3_ = self->priv->d_settings;
	g_signal_connect_object (_tmp3_, "changed::predefined-datetime", (GCallback) _gitg_diff_view_commit_details_on_change_datetime_g_settings_changed, self, 0);
	_tmp4_ = self->priv->d_settings;
	gitg_diff_view_commit_details_on_change_datetime (self, _tmp4_, "");
	_tmp5_ = self->priv->d_expander_files;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::expanded", (GCallback) __gitg_diff_view_commit_details___lambda50__g_object_notify, self, 0);
	return obj;
}

static void
gitg_diff_view_commit_details_class_init (GitgDiffViewCommitDetailsClass * klass,
                                          gpointer klass_data)
{
	gitg_diff_view_commit_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffViewCommitDetails_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_diff_view_commit_details_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_commit_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_commit_details_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_diff_view_commit_details_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_commit_details_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDED_PROPERTY, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDER_VISIBLE_PROPERTY, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDER_VISIBLE_PROPERTY] = g_param_spec_boolean ("expander-visible", "expander-visible", "expander-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT_DETAILS_COMMIT_PROPERTY, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_COMMIT_PROPERTY] = g_param_spec_object ("commit", "commit", "commit", ggit_commit_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT_DETAILS_PARENT_COMMIT_PROPERTY, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_PARENT_COMMIT_PROPERTY] = g_param_spec_object ("parent-commit", "parent-commit", "parent-commit", ggit_commit_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT_DETAILS_USE_GRAVATAR_PROPERTY, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_USE_GRAVATAR_PROPERTY] = g_param_spec_boolean ("use-gravatar", "use-gravatar", "use-gravatar", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_COMMIT_DETAILS_REPOSITORY_PROPERTY, gitg_diff_view_commit_details_properties[GITG_DIFF_VIEW_COMMIT_DETAILS_REPOSITORY_PROPERTY] = g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view-commit-details.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_avatar", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_image_avatar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_author", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_label_author));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_author_date", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_label_author_date));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_committer", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_label_committer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_committer_date", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_label_committer_date));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_subject", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_label_subject));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_sha1", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_label_sha1));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_parents_container", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_grid_parents_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_parents", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_grid_parents));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "expander_files", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_expander_files));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_expand_collapse_files", FALSE, GitgDiffViewCommitDetails_private_offset + G_STRUCT_OFFSET (GitgDiffViewCommitDetailsPrivate, d_label_expand_collapse_files));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "button_press_on_event_box_expand_collapse", G_CALLBACK(_gitg_diff_view_commit_details_button_press_on_event_box_expand_collapse_gtk_widget_button_press_event));
}

static void
gitg_diff_view_commit_details_instance_init (GitgDiffViewCommitDetails * self,
                                             gpointer klass)
{
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	self->priv = gitg_diff_view_commit_details_get_instance_private (self);
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\w+:(\\/?\\/?)[^\\s]+", 0));
	self->priv->regex_url = _tmp0_;
	_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_1, "gitg\\.custom-link\\.(.+)\\.regex", 0));
	self->priv->regex_custom_links = _tmp1_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_diff_view_commit_details_finalize (GObject * obj)
{
	GitgDiffViewCommitDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails);
	_g_object_unref0 (self->priv->d_settings);
	_g_object_unref0 (self->priv->d_avatar_cancel);
	_g_object_unref0 (self->priv->d_commit);
	_g_object_unref0 (self->priv->d_parent_commit);
	_g_object_unref0 (self->priv->_repository);
	_g_free0 (self->priv->d_datetime_format);
	_g_object_unref0 (self->priv->d_parents_map);
	_g_regex_unref0 (self->priv->regex_url);
	_g_object_unref0 (self->priv->_config);
	_g_regex_unref0 (self->priv->regex_custom_links);
	G_OBJECT_CLASS (gitg_diff_view_commit_details_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_commit_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewCommitDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_commit_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffViewCommitDetails), 0, (GInstanceInitFunc) gitg_diff_view_commit_details_instance_init, NULL };
	GType gitg_diff_view_commit_details_type_id;
	gitg_diff_view_commit_details_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffViewCommitDetails", &g_define_type_info, 0);
	GitgDiffViewCommitDetails_private_offset = g_type_add_instance_private (gitg_diff_view_commit_details_type_id, sizeof (GitgDiffViewCommitDetailsPrivate));
	return gitg_diff_view_commit_details_type_id;
}

GType
gitg_diff_view_commit_details_get_type (void)
{
	static gsize gitg_diff_view_commit_details_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_commit_details_type_id__once)) {
		GType gitg_diff_view_commit_details_type_id;
		gitg_diff_view_commit_details_type_id = gitg_diff_view_commit_details_get_type_once ();
		g_once_init_leave (&gitg_diff_view_commit_details_type_id__once, gitg_diff_view_commit_details_type_id);
	}
	return gitg_diff_view_commit_details_type_id__once;
}

static void
_vala_gitg_diff_view_commit_details_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GitgDiffViewCommitDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails);
	switch (property_id) {
		case GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDED_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_commit_details_get_expanded (self));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDER_VISIBLE_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_commit_details_get_expander_visible (self));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_COMMIT_PROPERTY:
		g_value_set_object (value, gitg_diff_view_commit_details_get_commit (self));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_PARENT_COMMIT_PROPERTY:
		g_value_set_object (value, gitg_diff_view_commit_details_get_parent_commit (self));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_USE_GRAVATAR_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_commit_details_get_use_gravatar (self));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_REPOSITORY_PROPERTY:
		g_value_set_object (value, gitg_diff_view_commit_details_get_repository (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_view_commit_details_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GitgDiffViewCommitDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_COMMIT_DETAILS, GitgDiffViewCommitDetails);
	switch (property_id) {
		case GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDED_PROPERTY:
		gitg_diff_view_commit_details_set_expanded (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_EXPANDER_VISIBLE_PROPERTY:
		gitg_diff_view_commit_details_set_expander_visible (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_COMMIT_PROPERTY:
		gitg_diff_view_commit_details_set_commit (self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_PARENT_COMMIT_PROPERTY:
		gitg_diff_view_commit_details_set_parent_commit (self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_USE_GRAVATAR_PROPERTY:
		gitg_diff_view_commit_details_set_use_gravatar (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_COMMIT_DETAILS_REPOSITORY_PROPERTY:
		gitg_diff_view_commit_details_set_repository (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

