/* gitg-ext-message-id.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ext-message-id.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_EXT_MESSAGE_ID_0_PROPERTY,
	GITG_EXT_MESSAGE_ID_OBJECT_PATH_PROPERTY,
	GITG_EXT_MESSAGE_ID_METHOD_PROPERTY,
	GITG_EXT_MESSAGE_ID_ID_PROPERTY,
	GITG_EXT_MESSAGE_ID_NUM_PROPERTIES
};
static GParamSpec* gitg_ext_message_id_properties[GITG_EXT_MESSAGE_ID_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgExtMessageIdPrivate {
	gchar* _object_path;
	gchar* _method;
};

static gint GitgExtMessageId_private_offset;
static gpointer gitg_ext_message_id_parent_class = NULL;

static void gitg_ext_message_id_finalize (GObject * obj);
static GType gitg_ext_message_id_get_type_once (void);
static void _vala_gitg_ext_message_id_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gitg_ext_message_id_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
gitg_ext_message_id_get_instance_private (GitgExtMessageId* self)
{
	return G_STRUCT_MEMBER_P (self, GitgExtMessageId_private_offset);
}

/**
 * Message hash.
 *
 * Get a hash for the message identifier suitable for use in a hash table.
 * The hash is simply a string hash of the full id of the message identifier.
 *
 * @return the message identifier hash.
 *
 */
guint
gitg_ext_message_id_hash (GitgExtMessageId* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gitg_ext_message_id_get_id (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_hash (_tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
 * Compare two messages for equality.
 *
 * Compare two messages. Two message identifiers are equal when they have
 * the same object path and the same method name.
 *
 * @param other the message identifier to compare to.
 *
 * @return true if the message identifiers are equal, false otherwise.
 *
 */
gboolean
gitg_ext_message_id_equal (GitgExtMessageId* self,
                           GitgExtMessageId* other)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp0_ = gitg_ext_message_id_get_id (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gitg_ext_message_id_get_id (other);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp2_, _tmp5_) == 0;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

/**
 * Construct message identifier with object path and method.
 *
 * Create a new message identifier object with the given object path and
 * method name.
 *
 * @param object_path the object path
 * @param method the method name
 *
 * @return a new message identifier.
 *
 */
GitgExtMessageId*
gitg_ext_message_id_construct (GType object_type,
                               const gchar* object_path,
                               const gchar* method)
{
	GitgExtMessageId * self = NULL;
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (method != NULL, NULL);
	self = (GitgExtMessageId*) g_object_new (object_type, "object-path", object_path, "method", method, NULL);
	return self;
}

GitgExtMessageId*
gitg_ext_message_id_new (const gchar* object_path,
                         const gchar* method)
{
	return gitg_ext_message_id_construct (GITG_EXT_TYPE_MESSAGE_ID, object_path, method);
}

/**
 * Create a copy of the message identifier.
 *
 * Create an exact copy of the message identifier.
 *
 * @return a new message identifier.
 *
 */
GitgExtMessageId*
gitg_ext_message_id_copy (GitgExtMessageId* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GitgExtMessageId* _tmp2_;
	GitgExtMessageId* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object_path;
	_tmp1_ = self->priv->_method;
	_tmp2_ = gitg_ext_message_id_new (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * Check whether an object path is a valid path.
 *
 * Check whether the given path is a valid object path. A valid object path
 * starts with a forward slash, followed by at least one alpha character,
 * or underscore. Further valid characters include alphanumeric characters,
 * underscores or path separators (forward slash).
 *
 * Example: /path/to/object
 *
 * @return true if the specified path is valid, false otherwise
 *
 */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
gitg_ext_message_id_valid_object_path (const gchar* path)
{
	gint i = 0;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	if (path == NULL) {
		result = FALSE;
		return result;
	}
	if (string_get (path, (glong) 0) != '/') {
		result = FALSE;
		return result;
	}
	i = 0;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		gchar c = '\0';
		gint _tmp8_;
		_tmp0_ = strlen (path);
		_tmp1_ = _tmp0_;
		if (!(i < _tmp1_)) {
			break;
		}
		c = string_get (path, (glong) i);
		if (c == '/') {
			gint _tmp2_;
			gboolean _tmp3_ = FALSE;
			gint _tmp4_;
			gint _tmp5_;
			i = i + 1;
			_tmp2_ = i;
			_tmp4_ = strlen (path);
			_tmp5_ = _tmp4_;
			if (i == _tmp5_) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp6_ = FALSE;
				if (g_ascii_isalpha (c)) {
					_tmp6_ = TRUE;
				} else {
					_tmp6_ = c == '_';
				}
				_tmp3_ = !_tmp6_;
			}
			if (_tmp3_) {
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp7_ = FALSE;
			if (g_ascii_isalnum (c)) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = c == '_';
			}
			if (!_tmp7_) {
				result = FALSE;
				return result;
			}
		}
		i = i + 1;
		_tmp8_ = i;
	}
	result = TRUE;
	return result;
}

const gchar*
gitg_ext_message_id_get_object_path (GitgExtMessageId* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object_path;
	result = _tmp0_;
	return result;
}

void
gitg_ext_message_id_set_object_path (GitgExtMessageId* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_ext_message_id_get_object_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_object_path);
		self->priv->_object_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ext_message_id_properties[GITG_EXT_MESSAGE_ID_OBJECT_PATH_PROPERTY]);
	}
}

const gchar*
gitg_ext_message_id_get_method (GitgExtMessageId* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_method;
	result = _tmp0_;
	return result;
}

void
gitg_ext_message_id_set_method (GitgExtMessageId* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_ext_message_id_get_method (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_method);
		self->priv->_method = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ext_message_id_properties[GITG_EXT_MESSAGE_ID_METHOD_PROPERTY]);
	}
}

gchar*
gitg_ext_message_id_get_id (GitgExtMessageId* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object_path;
	_tmp1_ = g_strconcat (_tmp0_, ".", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_method;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

static void
gitg_ext_message_id_class_init (GitgExtMessageIdClass * klass,
                                gpointer klass_data)
{
	gitg_ext_message_id_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgExtMessageId_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_ext_message_id_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_ext_message_id_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_ext_message_id_finalize;
	/**
	 * Message object path.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_EXT_MESSAGE_ID_OBJECT_PATH_PROPERTY, gitg_ext_message_id_properties[GITG_EXT_MESSAGE_ID_OBJECT_PATH_PROPERTY] = g_param_spec_string ("object-path", "object-path", "object-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * Message method.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_EXT_MESSAGE_ID_METHOD_PROPERTY, gitg_ext_message_id_properties[GITG_EXT_MESSAGE_ID_METHOD_PROPERTY] = g_param_spec_string ("method", "method", "method", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * Full id of the message.
	 *
	 * Get the full id of the message identifier. The full id is simply
	 * <path>.<method>
	 *
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_EXT_MESSAGE_ID_ID_PROPERTY, gitg_ext_message_id_properties[GITG_EXT_MESSAGE_ID_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_ext_message_id_instance_init (GitgExtMessageId * self,
                                   gpointer klass)
{
	self->priv = gitg_ext_message_id_get_instance_private (self);
}

static void
gitg_ext_message_id_finalize (GObject * obj)
{
	GitgExtMessageId * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageId);
	_g_free0 (self->priv->_object_path);
	_g_free0 (self->priv->_method);
	G_OBJECT_CLASS (gitg_ext_message_id_parent_class)->finalize (obj);
}

/**
 * Message identifier object.
 *
 * The message identifier object is used to identify messages sent over the
 * MessageBus. The message identifier contains an object path and a method.
 * Both are simple strings and combined describe the location of a message as
 * a kind of method on an object.
 *
 * Valid object paths start with a forward slash and further path elements are
 * seperated by more forward slashes. The first element needs to start with
 * an alpha character (or underscore) while further characters can be
 * alpha numeric or underscores. An example of a valid path is:
 *
 * /path/to/object
 *
 * Method names on the other hand do not have any restrictions.
 *
 */
 G_GNUC_NO_INLINE static GType
gitg_ext_message_id_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgExtMessageIdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_message_id_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgExtMessageId), 0, (GInstanceInitFunc) gitg_ext_message_id_instance_init, NULL };
	GType gitg_ext_message_id_type_id;
	gitg_ext_message_id_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgExtMessageId", &g_define_type_info, 0);
	GitgExtMessageId_private_offset = g_type_add_instance_private (gitg_ext_message_id_type_id, sizeof (GitgExtMessageIdPrivate));
	return gitg_ext_message_id_type_id;
}

GType
gitg_ext_message_id_get_type (void)
{
	static gsize gitg_ext_message_id_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_message_id_type_id__once)) {
		GType gitg_ext_message_id_type_id;
		gitg_ext_message_id_type_id = gitg_ext_message_id_get_type_once ();
		g_once_init_leave (&gitg_ext_message_id_type_id__once, gitg_ext_message_id_type_id);
	}
	return gitg_ext_message_id_type_id__once;
}

static void
_vala_gitg_ext_message_id_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GitgExtMessageId * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageId);
	switch (property_id) {
		case GITG_EXT_MESSAGE_ID_OBJECT_PATH_PROPERTY:
		g_value_set_string (value, gitg_ext_message_id_get_object_path (self));
		break;
		case GITG_EXT_MESSAGE_ID_METHOD_PROPERTY:
		g_value_set_string (value, gitg_ext_message_id_get_method (self));
		break;
		case GITG_EXT_MESSAGE_ID_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_message_id_get_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_ext_message_id_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GitgExtMessageId * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_EXT_TYPE_MESSAGE_ID, GitgExtMessageId);
	switch (property_id) {
		case GITG_EXT_MESSAGE_ID_OBJECT_PATH_PROPERTY:
		gitg_ext_message_id_set_object_path (self, g_value_get_string (value));
		break;
		case GITG_EXT_MESSAGE_ID_METHOD_PROPERTY:
		gitg_ext_message_id_set_method (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

