/* gitg-author-details-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-author-details-dialog.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Sindhu S
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgit2-glib/ggit.h>
#include "config.h"
#include <glib/gi18n-lib.h>

#define GITG_AUTHOR_DETAILS_DIALOG_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_AUTHOR_DETAILS_DIALOG (gitg_author_details_dialog_get_type ())
#define GITG_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialog))
#define GITG_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))
#define GITG_IS_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_IS_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_AUTHOR_DETAILS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))

typedef struct _GitgAuthorDetailsDialog GitgAuthorDetailsDialog;
typedef struct _GitgAuthorDetailsDialogClass GitgAuthorDetailsDialogClass;
typedef struct _GitgAuthorDetailsDialogPrivate GitgAuthorDetailsDialogPrivate;
enum  {
	GITG_AUTHOR_DETAILS_DIALOG_0_PROPERTY,
	GITG_AUTHOR_DETAILS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* gitg_author_details_dialog_properties[GITG_AUTHOR_DETAILS_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _ggit_config_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_config_entry_unref (var), NULL)))
typedef struct _Block54Data Block54Data;

struct _GitgAuthorDetailsDialog {
	GtkDialog parent_instance;
	GitgAuthorDetailsDialogPrivate * priv;
};

struct _GitgAuthorDetailsDialogClass {
	GtkDialogClass parent_class;
};

struct _GitgAuthorDetailsDialogPrivate {
	GtkEntry* d_entry_name;
	GtkEntry* d_entry_email;
	GtkLabel* d_label_info;
	GtkCheckButton* d_checkbutton_override_global;
	gchar* d_repository_name;
	GgitConfig* d_config;
};

struct _Block54Data {
	int _ref_count_;
	GitgAuthorDetailsDialog* self;
	GtkMessageDialog* error_dialog;
};

static gint GitgAuthorDetailsDialog_private_offset;
static gpointer gitg_author_details_dialog_parent_class = NULL;

VALA_EXTERN GType gitg_author_details_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgAuthorDetailsDialog, g_object_unref)
VALA_EXTERN GitgAuthorDetailsDialog* gitg_author_details_dialog_new (GtkWindow* parent,
                                                         GgitConfig* config,
                                                         const gchar* repository_name);
VALA_EXTERN GitgAuthorDetailsDialog* gitg_author_details_dialog_construct (GType object_type,
                                                               GtkWindow* parent,
                                                               GgitConfig* config,
                                                               const gchar* repository_name);
VALA_EXTERN GType gitg_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgWindow, g_object_unref)
VALA_EXTERN GitgAuthorDetailsDialog* gitg_author_details_dialog_show_global (GitgWindow* window);
static void gitg_author_details_dialog_build_global (GitgAuthorDetailsDialog* self);
static gboolean gitg_author_details_dialog_config_is_local (GitgAuthorDetailsDialog* self,
                                                     const gchar* name);
static void gitg_author_details_dialog_build_repository (GitgAuthorDetailsDialog* self);
static void gitg_author_details_dialog_update_sensitivity (GitgAuthorDetailsDialog* self);
static void _gitg_author_details_dialog_update_sensitivity_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void gitg_author_details_dialog_update_entries (GitgAuthorDetailsDialog* self,
                                                GgitConfig* config);
static void gitg_author_details_dialog_real_show (GtkWidget* base);
static gchar* gitg_author_details_dialog_read_config_string (GitgAuthorDetailsDialog* self,
                                                      GgitConfig* config,
                                                      const gchar* name,
                                                      const gchar* defval);
static void gitg_author_details_dialog_delete_local_entries (GitgAuthorDetailsDialog* self);
static void gitg_author_details_dialog_real_response (GtkDialog* base,
                                               gint id);
static void gitg_author_details_dialog_show_config_error (GitgAuthorDetailsDialog* self,
                                                   const gchar* primary_message,
                                                   const gchar* secondary_message);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void __lambda159_ (Block54Data* _data54_,
                   GtkDialog* d,
                   gint id);
static void ___lambda159__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void gitg_author_details_dialog_finalize (GObject * obj);
static GType gitg_author_details_dialog_get_type_once (void);

static inline gpointer
gitg_author_details_dialog_get_instance_private (GitgAuthorDetailsDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GitgAuthorDetailsDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgAuthorDetailsDialog*
gitg_author_details_dialog_construct (GType object_type,
                                      GtkWindow* parent,
                                      GgitConfig* config,
                                      const gchar* repository_name)
{
	GitgAuthorDetailsDialog * self = NULL;
	gchar* _tmp0_;
	GgitConfig* _tmp1_;
	g_return_val_if_fail (config != NULL, NULL);
	self = (GitgAuthorDetailsDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	if (parent != NULL) {
		gtk_window_set_transient_for ((GtkWindow*) self, parent);
	}
	_tmp0_ = g_strdup (repository_name);
	_g_free0 (self->priv->d_repository_name);
	self->priv->d_repository_name = _tmp0_;
	_tmp1_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->d_config);
	self->priv->d_config = _tmp1_;
	return self;
}

GitgAuthorDetailsDialog*
gitg_author_details_dialog_new (GtkWindow* parent,
                                GgitConfig* config,
                                const gchar* repository_name)
{
	return gitg_author_details_dialog_construct (GITG_TYPE_AUTHOR_DETAILS_DIALOG, parent, config, repository_name);
}

GitgAuthorDetailsDialog*
gitg_author_details_dialog_show_global (GitgWindow* window)
{
	GgitConfig* global_config = NULL;
	GitgAuthorDetailsDialog* author_details = NULL;
	GgitConfig* _tmp5_;
	GitgAuthorDetailsDialog* _tmp6_;
	GitgAuthorDetailsDialog* _tmp7_;
	GError* _inner_error0_ = NULL;
	GitgAuthorDetailsDialog* result;
	g_return_val_if_fail (window != NULL, NULL);
	{
		GgitConfig* _tmp0_ = NULL;
		GgitConfig* _tmp1_;
		GgitConfig* _tmp2_;
		_tmp1_ = ggit_config_new_default (&_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (global_config);
		global_config = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gitg-author-details-dialog.vala:67: Error while loading config file: %" \
"s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (global_config);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (global_config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = global_config;
	_tmp6_ = gitg_author_details_dialog_new ((GtkWindow*) window, _tmp5_, NULL);
	g_object_ref_sink (_tmp6_);
	author_details = _tmp6_;
	_tmp7_ = author_details;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	result = author_details;
	_g_object_unref0 (global_config);
	return result;
}

static void
gitg_author_details_dialog_build_global (GitgAuthorDetailsDialog* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_window_set_title ((GtkWindow*) self, _ ("Author Details"));
	_tmp0_ = self->priv->d_label_info;
	gtk_label_set_label (_tmp0_, _ ("Enter default details used for all repositories:"));
	_tmp1_ = self->priv->d_label_info;
	gtk_widget_show ((GtkWidget*) _tmp1_);
}

static gboolean
gitg_author_details_dialog_config_is_local (GitgAuthorDetailsDialog* self,
                                            const gchar* name)
{
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		GgitConfigEntry* entry = NULL;
		GgitConfig* _tmp0_;
		GgitConfigEntry* _tmp1_;
		_tmp0_ = self->priv->d_config;
		_tmp1_ = ggit_config_get_entry (_tmp0_, name, &_inner_error0_);
		entry = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = ggit_config_entry_get_level (entry) == GGIT_CONFIG_LEVEL_LOCAL;
		_ggit_config_entry_unref0 (entry);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp2_;
}

static void
_gitg_author_details_dialog_update_sensitivity_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	gitg_author_details_dialog_update_sensitivity ((GitgAuthorDetailsDialog*) self);
}

static void
gitg_author_details_dialog_build_repository (GitgAuthorDetailsDialog* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkCheckButton* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GtkCheckButton* _tmp8_;
	GtkCheckButton* _tmp9_;
	GtkCheckButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_repository_name;
	_tmp1_ = g_strdup_printf ("%s — %s", _tmp0_, _ ("Author Details"));
	_tmp2_ = _tmp1_;
	gtk_window_set_title ((GtkWindow*) self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->d_checkbutton_override_global;
	_tmp4_ = self->priv->d_repository_name;
	_tmp5_ = g_strdup_printf (_ ("Override global details for repository “%s”:"), _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_button_set_label ((GtkButton*) _tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	if (gitg_author_details_dialog_config_is_local (self, "user.name")) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = gitg_author_details_dialog_config_is_local (self, "user.email");
	}
	_tmp8_ = self->priv->d_checkbutton_override_global;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp8_, _tmp7_);
	_tmp9_ = self->priv->d_checkbutton_override_global;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::active", (GCallback) _gitg_author_details_dialog_update_sensitivity_g_object_notify, self, 0);
	_tmp10_ = self->priv->d_checkbutton_override_global;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	gitg_author_details_dialog_update_sensitivity (self);
}

static void
gitg_author_details_dialog_update_sensitivity (GitgAuthorDetailsDialog* self)
{
	GtkEntry* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkEntry* _tmp4_;
	GtkCheckButton* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GgitConfig* config = NULL;
	GgitConfig* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_entry_name;
	_tmp1_ = self->priv->d_checkbutton_override_global;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_);
	_tmp4_ = self->priv->d_entry_email;
	_tmp5_ = self->priv->d_checkbutton_override_global;
	_tmp6_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, _tmp7_);
	config = NULL;
	{
		GtkCheckButton* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->d_checkbutton_override_global;
		_tmp9_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp8_);
		_tmp10_ = _tmp9_;
		if (!_tmp10_) {
			GgitConfig* _tmp11_ = NULL;
			GgitConfig* _tmp12_;
			GgitConfig* _tmp13_;
			GgitConfig* _tmp14_;
			_tmp12_ = self->priv->d_config;
			_tmp13_ = ggit_config_open_level (_tmp12_, GGIT_CONFIG_LEVEL_GLOBAL, &_inner_error0_);
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (config);
			config = _tmp14_;
			_g_object_unref0 (_tmp11_);
		} else {
			GgitConfig* _tmp15_;
			GgitConfig* _tmp16_;
			_tmp15_ = self->priv->d_config;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_g_object_unref0 (config);
			config = _tmp16_;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = config;
	if (_tmp17_ != NULL) {
		GgitConfig* _tmp18_;
		_tmp18_ = config;
		gitg_author_details_dialog_update_entries (self, _tmp18_);
	}
	_g_object_unref0 (config);
}

static void
gitg_author_details_dialog_real_show (GtkWidget* base)
{
	GitgAuthorDetailsDialog * self;
	const gchar* _tmp0_;
	GgitConfig* _tmp1_;
	self = (GitgAuthorDetailsDialog*) base;
	GTK_WIDGET_CLASS (gitg_author_details_dialog_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	_tmp0_ = self->priv->d_repository_name;
	if (_tmp0_ == NULL) {
		gitg_author_details_dialog_build_global (self);
	} else {
		gitg_author_details_dialog_build_repository (self);
	}
	_tmp1_ = self->priv->d_config;
	gitg_author_details_dialog_update_entries (self, _tmp1_);
}

static gchar*
gitg_author_details_dialog_read_config_string (GitgAuthorDetailsDialog* self,
                                               GgitConfig* config,
                                               const gchar* name,
                                               const gchar* defval)
{
	gchar* ret = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (config != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (defval != NULL, NULL);
	ret = NULL;
	{
		GgitConfig* _tmp0_ = NULL;
		GgitConfig* _tmp1_;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = ggit_config_snapshot (config, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = ggit_config_get_string (_tmp0_, name, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp4_ = g_strdup (_tmp2_);
		_g_free0 (ret);
		ret = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (ret);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = ret;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = ret;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = defval;
	}
	_tmp8_ = g_strdup (_tmp5_);
	result = _tmp8_;
	_g_free0 (ret);
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static void
gitg_author_details_dialog_update_entries (GitgAuthorDetailsDialog* self,
                                           GgitConfig* config)
{
	GtkEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkEntry* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	_tmp0_ = self->priv->d_entry_name;
	_tmp1_ = gitg_author_details_dialog_read_config_string (self, config, "user.name", "");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_chomp (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_entry_set_text (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = self->priv->d_entry_email;
	_tmp6_ = gitg_author_details_dialog_read_config_string (self, config, "user.email", "");
	_tmp7_ = _tmp6_;
	_tmp8_ = string_chomp (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_entry_set_text (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
}

static void
gitg_author_details_dialog_delete_local_entries (GitgAuthorDetailsDialog* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GgitConfigEntry* _tmp0_ = NULL;
		GgitConfig* _tmp1_;
		GgitConfigEntry* _tmp2_;
		_tmp1_ = self->priv->d_config;
		_tmp2_ = ggit_config_get_entry (_tmp1_, "user.name", &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (ggit_config_entry_get_level (_tmp0_) == GGIT_CONFIG_LEVEL_LOCAL) {
			GgitConfig* _tmp3_;
			_tmp3_ = self->priv->d_config;
			ggit_config_delete_entry (_tmp3_, "user.name", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_ggit_config_entry_unref0 (_tmp0_);
				goto __catch0_g_error;
			}
		}
		_ggit_config_entry_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GgitConfigEntry* _tmp4_ = NULL;
		GgitConfig* _tmp5_;
		GgitConfigEntry* _tmp6_;
		_tmp5_ = self->priv->d_config;
		_tmp6_ = ggit_config_get_entry (_tmp5_, "user.email", &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		if (ggit_config_entry_get_level (_tmp4_) == GGIT_CONFIG_LEVEL_LOCAL) {
			GgitConfig* _tmp7_;
			_tmp7_ = self->priv->d_config;
			ggit_config_delete_entry (_tmp7_, "user.email", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_ggit_config_entry_unref0 (_tmp4_);
				goto __catch1_g_error;
			}
		}
		_ggit_config_entry_unref0 (_tmp4_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
gitg_author_details_dialog_real_response (GtkDialog* base,
                                          gint id)
{
	GitgAuthorDetailsDialog * self;
	GError* _inner_error0_ = NULL;
	self = (GitgAuthorDetailsDialog*) base;
	if (id == ((gint) GTK_RESPONSE_OK)) {
		{
			const gchar* _tmp0_;
			_tmp0_ = self->priv->d_repository_name;
			if (_tmp0_ != NULL) {
				GtkCheckButton* _tmp1_;
				gboolean _tmp2_;
				gboolean _tmp3_;
				_tmp1_ = self->priv->d_checkbutton_override_global;
				_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
				_tmp3_ = _tmp2_;
				if (_tmp3_) {
					GgitConfig* _tmp4_;
					GtkEntry* _tmp5_;
					const gchar* _tmp6_;
					GgitConfig* _tmp7_;
					GtkEntry* _tmp8_;
					const gchar* _tmp9_;
					_tmp4_ = self->priv->d_config;
					_tmp5_ = self->priv->d_entry_name;
					_tmp6_ = gtk_entry_get_text (_tmp5_);
					ggit_config_set_string (_tmp4_, "user.name", _tmp6_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp7_ = self->priv->d_config;
					_tmp8_ = self->priv->d_entry_email;
					_tmp9_ = gtk_entry_get_text (_tmp8_);
					ggit_config_set_string (_tmp7_, "user.email", _tmp9_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				} else {
					gitg_author_details_dialog_delete_local_entries (self);
				}
			} else {
				GgitConfig* _tmp10_;
				GtkEntry* _tmp11_;
				const gchar* _tmp12_;
				GgitConfig* _tmp13_;
				GtkEntry* _tmp14_;
				const gchar* _tmp15_;
				_tmp10_ = self->priv->d_config;
				_tmp11_ = self->priv->d_entry_name;
				_tmp12_ = gtk_entry_get_text (_tmp11_);
				ggit_config_set_string (_tmp10_, "user.name", _tmp12_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp13_ = self->priv->d_config;
				_tmp14_ = self->priv->d_entry_email;
				_tmp15_ = gtk_entry_get_text (_tmp14_);
				ggit_config_set_string (_tmp13_, "user.email", _tmp15_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			gitg_author_details_dialog_show_config_error (self, _ ("Failed to set Git user config."), _tmp17_);
			gtk_widget_destroy ((GtkWidget*) self);
			_g_error_free0 (e);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		GitgAuthorDetailsDialog* self;
		self = _data54_->self;
		_g_object_unref0 (_data54_->error_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static void
__lambda159_ (Block54Data* _data54_,
              GtkDialog* d,
              gint id)
{
	GitgAuthorDetailsDialog* self;
	self = _data54_->self;
	g_return_if_fail (d != NULL);
	gtk_widget_destroy ((GtkWidget*) _data54_->error_dialog);
}

static void
___lambda159__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda159_ (self, _sender, response_id);
}

static void
gitg_author_details_dialog_show_config_error (GitgAuthorDetailsDialog* self,
                                              const gchar* primary_message,
                                              const gchar* secondary_message)
{
	Block54Data* _data54_;
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_message != NULL);
	g_return_if_fail (secondary_message != NULL);
	_data54_ = g_slice_new0 (Block54Data);
	_data54_->_ref_count_ = 1;
	_data54_->self = g_object_ref (self);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", primary_message);
	g_object_ref_sink (_tmp0_);
	_data54_->error_dialog = _tmp0_;
	g_object_set (_data54_->error_dialog, "secondary-text", secondary_message, NULL);
	g_signal_connect_data ((GtkDialog*) _data54_->error_dialog, "response", (GCallback) ___lambda159__gtk_dialog_response, block54_data_ref (_data54_), (GClosureNotify) block54_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data54_->error_dialog);
	block54_data_unref (_data54_);
	_data54_ = NULL;
}

static void
gitg_author_details_dialog_class_init (GitgAuthorDetailsDialogClass * klass,
                                       gpointer klass_data)
{
	gitg_author_details_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgAuthorDetailsDialog_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) gitg_author_details_dialog_real_show;
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog*, gint)) gitg_author_details_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = gitg_author_details_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-author-details-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry_name", FALSE, GitgAuthorDetailsDialog_private_offset + G_STRUCT_OFFSET (GitgAuthorDetailsDialogPrivate, d_entry_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry_email", FALSE, GitgAuthorDetailsDialog_private_offset + G_STRUCT_OFFSET (GitgAuthorDetailsDialogPrivate, d_entry_email));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_info", FALSE, GitgAuthorDetailsDialog_private_offset + G_STRUCT_OFFSET (GitgAuthorDetailsDialogPrivate, d_label_info));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "checkbutton_override_global", FALSE, GitgAuthorDetailsDialog_private_offset + G_STRUCT_OFFSET (GitgAuthorDetailsDialogPrivate, d_checkbutton_override_global));
}

static void
gitg_author_details_dialog_instance_init (GitgAuthorDetailsDialog * self,
                                          gpointer klass)
{
	self->priv = gitg_author_details_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_author_details_dialog_finalize (GObject * obj)
{
	GitgAuthorDetailsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialog);
	_g_free0 (self->priv->d_repository_name);
	_g_object_unref0 (self->priv->d_config);
	G_OBJECT_CLASS (gitg_author_details_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_author_details_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgAuthorDetailsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_author_details_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgAuthorDetailsDialog), 0, (GInstanceInitFunc) gitg_author_details_dialog_instance_init, NULL };
	GType gitg_author_details_dialog_type_id;
	gitg_author_details_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "GitgAuthorDetailsDialog", &g_define_type_info, 0);
	GitgAuthorDetailsDialog_private_offset = g_type_add_instance_private (gitg_author_details_dialog_type_id, sizeof (GitgAuthorDetailsDialogPrivate));
	return gitg_author_details_dialog_type_id;
}

GType
gitg_author_details_dialog_get_type (void)
{
	static gsize gitg_author_details_dialog_type_id__once = 0;
	if (g_once_init_enter (&gitg_author_details_dialog_type_id__once)) {
		GType gitg_author_details_dialog_type_id;
		gitg_author_details_dialog_type_id = gitg_author_details_dialog_get_type_once ();
		g_once_init_leave (&gitg_author_details_dialog_type_id__once, gitg_author_details_dialog_type_id);
	}
	return gitg_author_details_dialog_type_id__once;
}

