/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-genesys-usbhub-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_genesys_ts_version_to_string:
 * @val: value, e.g. %FU_GENESYS_TS_VERSION_BONDING
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_genesys_ts_version_to_string(FuGenesysTsVersion val)
{
    if (val == FU_GENESYS_TS_VERSION_DYNAMIC_9_BYTE)
        return "dynamic-9-byte";
    if (val == FU_GENESYS_TS_VERSION_BONDING)
        return "bonding";
    if (val == FU_GENESYS_TS_VERSION_BONDING_QC)
        return "bonding-qc";
    if (val == FU_GENESYS_TS_VERSION_VENDOR_SUPPORT)
        return "vendor-support";
    if (val == FU_GENESYS_TS_VERSION_MULTI_TOKEN)
        return "multi-token";
    if (val == FU_GENESYS_TS_VERSION_DYNAMIC_2ND)
        return "dynamic-2nd";
    if (val == FU_GENESYS_TS_VERSION_RESERVED)
        return "reserved";
    if (val == FU_GENESYS_TS_VERSION_DYNAMIC_13_BYTE)
        return "dynamic-13-byte";
    if (val == FU_GENESYS_TS_VERSION_BRAND_PROJECT)
        return "brand-project";
    return NULL;
}

/**
 * fu_genesys_fw_status_to_string:
 * @val: value, e.g. %FU_GENESYS_FW_STATUS_BANK1
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_genesys_fw_status_to_string(FuGenesysFwStatus val)
{
    if (val == FU_GENESYS_FW_STATUS_MASK)
        return "mask";
    if (val == FU_GENESYS_FW_STATUS_BANK1)
        return "bank1";
    if (val == FU_GENESYS_FW_STATUS_BANK2)
        return "bank2";
    return NULL;
}

/**
 * fu_genesys_vs_codesign_check_to_string:
 * @val: value, e.g. %FU_GENESYS_VS_CODESIGN_CHECK_SCALER
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_genesys_vs_codesign_check_to_string(FuGenesysVsCodesignCheck val)
{
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_UNSUPPORTED)
        return "unsupported";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_SCALER)
        return "scaler";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_FW)
        return "fw";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_MASTER)
        return "master";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_RESERVED)
        return "reserved";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_HW)
        return "hw";
    return NULL;
}

/**
 * fu_genesys_vs_hid_isp_to_string:
 * @val: value, e.g. %FU_GENESYS_VS_HID_ISP_SUPPORT
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_genesys_vs_hid_isp_to_string(FuGenesysVsHidIsp val)
{
    if (val == FU_GENESYS_VS_HID_ISP_UNSUPPORTED)
        return "unsupported";
    if (val == FU_GENESYS_VS_HID_ISP_SUPPORT)
        return "support";
    if (val == FU_GENESYS_VS_HID_ISP_CODESIGN_N_RESET)
        return "codesign-n-reset";
    return NULL;
}

/**
 * fu_genesys_fw_codesign_to_string:
 * @val: value, e.g. %FU_GENESYS_FW_CODESIGN_RSA
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_genesys_fw_codesign_to_string(FuGenesysFwCodesign val)
{
    if (val == FU_GENESYS_FW_CODESIGN_NONE)
        return "none";
    if (val == FU_GENESYS_FW_CODESIGN_RSA)
        return "rsa";
    if (val == FU_GENESYS_FW_CODESIGN_ECDSA)
        return "ecdsa";
    return NULL;
}

/**
 * fu_genesys_fw_type_to_string:
 * @val: value, e.g. %FU_GENESYS_FW_TYPE_DEV_BRIDGE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_genesys_fw_type_to_string(FuGenesysFwType val)
{
    if (val == FU_GENESYS_FW_TYPE_HUB)
        return "hub";
    if (val == FU_GENESYS_FW_TYPE_DEV_BRIDGE)
        return "dev-bridge";
    if (val == FU_GENESYS_FW_TYPE_PD)
        return "pd";
    if (val == FU_GENESYS_FW_TYPE_CODESIGN)
        return "codesign";
    if (val == FU_GENESYS_FW_TYPE_INSIDE_HUB_COUNT)
        return "inside-hub-count";
    if (val == FU_GENESYS_FW_TYPE_SCALER)
        return "scaler";
    return NULL;
}
/**
 * fu_struct_genesys_firmware_hdr_ref: (skip):
 **/
FuStructGenesysFirmwareHdr *
fu_struct_genesys_firmware_hdr_ref(FuStructGenesysFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_firmware_hdr_unref: (skip):
 **/
void
fu_struct_genesys_firmware_hdr_unref(FuStructGenesysFirmwareHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysFirmwareHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_firmware_hdr_new_internal: (skip):
 **/
static FuStructGenesysFirmwareHdr *
fu_struct_genesys_firmware_hdr_new_internal(void)
{
    FuStructGenesysFirmwareHdr *st = g_new0(FuStructGenesysFirmwareHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_firmware_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_genesys_firmware_hdr_get_magic(const FuStructGenesysFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 252, 4, NULL);
}

/* setters */
static gboolean
fu_struct_genesys_firmware_hdr_validate_internal(FuStructGenesysFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 252), "XROM", 4) != 0) {
        g_autofree gchar *str = fu_struct_genesys_firmware_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFirmwareHdr.magic was not valid, "
                    "expected 'XROM' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_genesys_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_genesys_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFirmwareHdr) st = fu_struct_genesys_firmware_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 256, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysFirmwareHdr failed read of 0x%x: ", (guint) 256);
        return FALSE;
    }
    if (st->buf->len != 256) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 256,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_genesys_firmware_hdr_validate_internal(st, error);
}
/**
 * fu_struct_genesys_dev_firmware_hdr_ref: (skip):
 **/
FuStructGenesysDevFirmwareHdr *
fu_struct_genesys_dev_firmware_hdr_ref(FuStructGenesysDevFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_dev_firmware_hdr_unref: (skip):
 **/
void
fu_struct_genesys_dev_firmware_hdr_unref(FuStructGenesysDevFirmwareHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysDevFirmwareHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_dev_firmware_hdr_new_internal: (skip):
 **/
static FuStructGenesysDevFirmwareHdr *
fu_struct_genesys_dev_firmware_hdr_new_internal(void)
{
    FuStructGenesysDevFirmwareHdr *st = g_new0(FuStructGenesysDevFirmwareHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_dev_firmware_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_genesys_dev_firmware_hdr_get_magic(const FuStructGenesysDevFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 252, 4, NULL);
}

/* setters */
static gboolean
fu_struct_genesys_dev_firmware_hdr_validate_internal(FuStructGenesysDevFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 252), "HOST", 4) != 0) {
        g_autofree gchar *str = fu_struct_genesys_dev_firmware_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysDevFirmwareHdr.magic was not valid, "
                    "expected 'HOST' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_genesys_dev_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_genesys_dev_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysDevFirmwareHdr) st = fu_struct_genesys_dev_firmware_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 256, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysDevFirmwareHdr failed read of 0x%x: ", (guint) 256);
        return FALSE;
    }
    if (st->buf->len != 256) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysDevFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 256,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_genesys_dev_firmware_hdr_validate_internal(st, error);
}
/**
 * fu_struct_genesys_pd_firmware_hdr_ref: (skip):
 **/
FuStructGenesysPdFirmwareHdr *
fu_struct_genesys_pd_firmware_hdr_ref(FuStructGenesysPdFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_pd_firmware_hdr_unref: (skip):
 **/
void
fu_struct_genesys_pd_firmware_hdr_unref(FuStructGenesysPdFirmwareHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysPdFirmwareHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_pd_firmware_hdr_new_internal: (skip):
 **/
static FuStructGenesysPdFirmwareHdr *
fu_struct_genesys_pd_firmware_hdr_new_internal(void)
{
    FuStructGenesysPdFirmwareHdr *st = g_new0(FuStructGenesysPdFirmwareHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_pd_firmware_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_genesys_pd_firmware_hdr_get_magic(const FuStructGenesysPdFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 252, 4, NULL);
}

/* setters */
static gboolean
fu_struct_genesys_pd_firmware_hdr_validate_internal(FuStructGenesysPdFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 252), "PRDY", 4) != 0) {
        g_autofree gchar *str = fu_struct_genesys_pd_firmware_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysPdFirmwareHdr.magic was not valid, "
                    "expected 'PRDY' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_genesys_pd_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_genesys_pd_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysPdFirmwareHdr) st = fu_struct_genesys_pd_firmware_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 256, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysPdFirmwareHdr failed read of 0x%x: ", (guint) 256);
        return FALSE;
    }
    if (st->buf->len != 256) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysPdFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 256,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_genesys_pd_firmware_hdr_validate_internal(st, error);
}
/**
 * fu_struct_genesys_ts_static_ref: (skip):
 **/
FuStructGenesysTsStatic *
fu_struct_genesys_ts_static_ref(FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_static_unref: (skip):
 **/
void
fu_struct_genesys_ts_static_unref(FuStructGenesysTsStatic *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsStatic refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_static_new_internal: (skip):
 **/
static FuStructGenesysTsStatic *
fu_struct_genesys_ts_static_new_internal(void)
{
    FuStructGenesysTsStatic *st = g_new0(FuStructGenesysTsStatic, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_static_get_tool_string_version: (skip):
 **/
FuGenesysTsVersion
fu_struct_genesys_ts_static_get_tool_string_version(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_code: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_code(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 4, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_hardware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_hardware(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_firmware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_firmware(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 6, 2, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_ic_type: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_ic_type(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 6, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_code: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_code(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 14, 4, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_hardware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_hardware(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 18, 1, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_firmware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_firmware(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 19, 2, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_ic_type: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_ic_type(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 21, 6, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_firmware_version: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_firmware_version(const FuStructGenesysTsStatic *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 27, 4, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_static_set_tool_string_version: (skip):
 **/
void
fu_struct_genesys_ts_static_set_tool_string_version(FuStructGenesysTsStatic *st, FuGenesysTsVersion value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_code: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_code(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 1, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.mask_project_code (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 1, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_hardware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_hardware(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 5, 0x0, 1);
        return TRUE;
    }
    len = strlen(value);
    if (len > 1) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.mask_project_hardware (0x%x bytes)",
                    value, (guint) len, (guint) 1);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 5, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_firmware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_firmware(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 6, 0x0, 2);
        return TRUE;
    }
    len = strlen(value);
    if (len > 2) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.mask_project_firmware (0x%x bytes)",
                    value, (guint) len, (guint) 2);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 6, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_ic_type: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_ic_type(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 8, 0x0, 6);
        return TRUE;
    }
    len = strlen(value);
    if (len > 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.mask_project_ic_type (0x%x bytes)",
                    value, (guint) len, (guint) 6);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_code: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_code(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 14, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.running_project_code (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 14, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_hardware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_hardware(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 18, 0x0, 1);
        return TRUE;
    }
    len = strlen(value);
    if (len > 1) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.running_project_hardware (0x%x bytes)",
                    value, (guint) len, (guint) 1);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 18, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_firmware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_firmware(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 19, 0x0, 2);
        return TRUE;
    }
    len = strlen(value);
    if (len > 2) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.running_project_firmware (0x%x bytes)",
                    value, (guint) len, (guint) 2);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 19, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_ic_type: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_ic_type(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 21, 0x0, 6);
        return TRUE;
    }
    len = strlen(value);
    if (len > 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.running_project_ic_type (0x%x bytes)",
                    value, (guint) len, (guint) 6);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 21, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_firmware_version: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_firmware_version(FuStructGenesysTsStatic *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 27, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsStatic.firmware_version (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 27, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_new: (skip):
 **/
FuStructGenesysTsStatic *
fu_struct_genesys_ts_static_new(void)
{
    FuStructGenesysTsStatic *st = fu_struct_genesys_ts_static_new_internal();
    st->buf = g_byte_array_sized_new(31);
    fu_byte_array_set_size(st->buf, 31, 0x0);
    return st;
}
/**
 * fu_struct_genesys_ts_static_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_static_to_string(const FuStructGenesysTsStatic *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsStatic:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_genesys_ts_version_to_string(fu_struct_genesys_ts_static_get_tool_string_version(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  tool_string_version: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_static_get_tool_string_version(st), tmp);
        } else {
            g_string_append_printf(str, "  tool_string_version: 0x%x\n", (guint) fu_struct_genesys_ts_static_get_tool_string_version(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_code(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_code: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_hardware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_hardware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_firmware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_firmware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_ic_type(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_ic_type: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_code(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_code: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_hardware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_hardware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_firmware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_firmware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_ic_type(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_ic_type: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_firmware_version(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  firmware_version: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_static_validate_internal(FuStructGenesysTsStatic *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_static_parse_internal(FuStructGenesysTsStatic *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_static_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_static_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_static_parse: (skip):
 **/
FuStructGenesysTsStatic *
fu_struct_genesys_ts_static_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsStatic) st = fu_struct_genesys_ts_static_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 31, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsStatic: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 31);
    if (!fu_struct_genesys_ts_static_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_static_parse_stream: (skip):
 **/
FuStructGenesysTsStatic *
fu_struct_genesys_ts_static_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsStatic) st = fu_struct_genesys_ts_static_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 31, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysTsStatic failed read of 0x%x: ", (guint) 31);
        return NULL;
    }
    if (st->buf->len != 31) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysTsStatic requested 0x%x and got 0x%x",
                    (guint) 31,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_genesys_ts_static_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_ref: (skip):
 **/
FuStructGenesysTsDynamicGl3523 *
fu_struct_genesys_ts_dynamic_gl3523_ref(FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_unref: (skip):
 **/
void
fu_struct_genesys_ts_dynamic_gl3523_unref(FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsDynamicGl3523 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_new_internal: (skip):
 **/
static FuStructGenesysTsDynamicGl3523 *
fu_struct_genesys_ts_dynamic_gl3523_new_internal(void)
{
    FuStructGenesysTsDynamicGl3523 *st = g_new0(FuStructGenesysTsDynamicGl3523, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_running_mode(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_ss_port_number(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_hs_port_number(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_ss_connection_status(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_hs_connection_status(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_fs_connection_status(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_ls_connection_status(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_charging(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_non_removable_port_status(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_bonding: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_bonding(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 9, 1, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl3523_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_dynamic_gl3523_to_string(const FuStructGenesysTsDynamicGl3523 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsDynamicGl3523:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_bonding(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  bonding: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_dynamic_gl3523_validate_internal(FuStructGenesysTsDynamicGl3523 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_dynamic_gl3523_parse_internal(FuStructGenesysTsDynamicGl3523 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_dynamic_gl3523_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_dynamic_gl3523_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_dynamic_gl3523_parse: (skip):
 **/
FuStructGenesysTsDynamicGl3523 *
fu_struct_genesys_ts_dynamic_gl3523_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsDynamicGl3523) st = fu_struct_genesys_ts_dynamic_gl3523_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsDynamicGl3523: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 10);
    if (!fu_struct_genesys_ts_dynamic_gl3523_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_ref: (skip):
 **/
FuStructGenesysTsDynamicGl3590 *
fu_struct_genesys_ts_dynamic_gl3590_ref(FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_unref: (skip):
 **/
void
fu_struct_genesys_ts_dynamic_gl3590_unref(FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsDynamicGl3590 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_new_internal: (skip):
 **/
static FuStructGenesysTsDynamicGl3590 *
fu_struct_genesys_ts_dynamic_gl3590_new_internal(void)
{
    FuStructGenesysTsDynamicGl3590 *st = g_new0(FuStructGenesysTsDynamicGl3590, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_running_mode(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_ss_port_number(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_hs_port_number(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_ss_connection_status(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_hs_connection_status(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_fs_connection_status(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_ls_connection_status(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_charging(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_non_removable_port_status(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_bonding: (skip):
 **/
guint8
fu_struct_genesys_ts_dynamic_gl3590_get_bonding(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl3590_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_dynamic_gl3590_to_string(const FuStructGenesysTsDynamicGl3590 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsDynamicGl3590:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    g_string_append_printf(str, "  bonding: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3590_get_bonding(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_dynamic_gl3590_validate_internal(FuStructGenesysTsDynamicGl3590 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_dynamic_gl3590_parse_internal(FuStructGenesysTsDynamicGl3590 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_dynamic_gl3590_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_dynamic_gl3590_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_dynamic_gl3590_parse: (skip):
 **/
FuStructGenesysTsDynamicGl3590 *
fu_struct_genesys_ts_dynamic_gl3590_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsDynamicGl3590) st = fu_struct_genesys_ts_dynamic_gl3590_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsDynamicGl3590: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 10);
    if (!fu_struct_genesys_ts_dynamic_gl3590_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_ref: (skip):
 **/
FuStructGenesysTsDynamicGl359030 *
fu_struct_genesys_ts_dynamic_gl359030_ref(FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_unref: (skip):
 **/
void
fu_struct_genesys_ts_dynamic_gl359030_unref(FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsDynamicGl359030 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_new_internal: (skip):
 **/
static FuStructGenesysTsDynamicGl359030 *
fu_struct_genesys_ts_dynamic_gl359030_new_internal(void)
{
    FuStructGenesysTsDynamicGl359030 *st = g_new0(FuStructGenesysTsDynamicGl359030, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_running_mode(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_ss_port_number(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_hs_port_number(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_ss_connection_status(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_hs_connection_status(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_fs_connection_status(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_ls_connection_status(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_charging(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_non_removable_port_status(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_bonding: (skip):
 **/
guint8
fu_struct_genesys_ts_dynamic_gl359030_get_bonding(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_version: (skip):
 **/
guint16
fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_version(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl359030_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_dynamic_gl359030_to_string(const FuStructGenesysTsDynamicGl359030 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsDynamicGl359030:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    g_string_append_printf(str, "  bonding: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl359030_get_bonding(st));
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  hub_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  hub_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(st));
        }
    }
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(st));
        }
    }
    g_string_append_printf(str, "  dev_fw_version: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_dynamic_gl359030_validate_internal(FuStructGenesysTsDynamicGl359030 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_dynamic_gl359030_parse_internal(FuStructGenesysTsDynamicGl359030 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_dynamic_gl359030_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_dynamic_gl359030_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_dynamic_gl359030_parse: (skip):
 **/
FuStructGenesysTsDynamicGl359030 *
fu_struct_genesys_ts_dynamic_gl359030_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsDynamicGl359030) st = fu_struct_genesys_ts_dynamic_gl359030_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 14, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsDynamicGl359030: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 14);
    if (!fu_struct_genesys_ts_dynamic_gl359030_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_ref: (skip):
 **/
FuStructGenesysTsDynamicGl3525 *
fu_struct_genesys_ts_dynamic_gl3525_ref(FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_unref: (skip):
 **/
void
fu_struct_genesys_ts_dynamic_gl3525_unref(FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsDynamicGl3525 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_new_internal: (skip):
 **/
static FuStructGenesysTsDynamicGl3525 *
fu_struct_genesys_ts_dynamic_gl3525_new_internal(void)
{
    FuStructGenesysTsDynamicGl3525 *st = g_new0(FuStructGenesysTsDynamicGl3525, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_running_mode(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_ss_port_number(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_hs_port_number(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_ss_connection_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_hs_connection_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_fs_connection_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_ls_connection_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_charging(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_non_removable_port_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_bonding: (skip):
 **/
guint8
fu_struct_genesys_ts_dynamic_gl3525_get_bonding(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_version: (skip):
 **/
guint16
fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_version(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[14];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_version: (skip):
 **/
guint16
fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_version(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 15, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl3525_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_dynamic_gl3525_to_string(const FuStructGenesysTsDynamicGl3525 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsDynamicGl3525:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    g_string_append_printf(str, "  bonding: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3525_get_bonding(st));
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  hub_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  hub_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(st));
        }
    }
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  pd_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  pd_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(st));
        }
    }
    g_string_append_printf(str, "  pd_fw_version: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_version(st));
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(st));
        }
    }
    g_string_append_printf(str, "  dev_fw_version: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_dynamic_gl3525_validate_internal(FuStructGenesysTsDynamicGl3525 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_dynamic_gl3525_parse_internal(FuStructGenesysTsDynamicGl3525 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_dynamic_gl3525_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_dynamic_gl3525_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_dynamic_gl3525_parse: (skip):
 **/
FuStructGenesysTsDynamicGl3525 *
fu_struct_genesys_ts_dynamic_gl3525_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsDynamicGl3525) st = fu_struct_genesys_ts_dynamic_gl3525_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 17, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsDynamicGl3525: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 17);
    if (!fu_struct_genesys_ts_dynamic_gl3525_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_firmware_info_ref: (skip):
 **/
FuStructGenesysTsFirmwareInfo *
fu_struct_genesys_ts_firmware_info_ref(FuStructGenesysTsFirmwareInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_firmware_info_unref: (skip):
 **/
void
fu_struct_genesys_ts_firmware_info_unref(FuStructGenesysTsFirmwareInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsFirmwareInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_firmware_info_new_internal: (skip):
 **/
static FuStructGenesysTsFirmwareInfo *
fu_struct_genesys_ts_firmware_info_new_internal(void)
{
    FuStructGenesysTsFirmwareInfo *st = g_new0(FuStructGenesysTsFirmwareInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_firmware_info_get_tool_version: (skip):
 **/
const guint8 *
fu_struct_genesys_ts_firmware_info_get_tool_version(const FuStructGenesysTsFirmwareInfo *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->buf->data + 0;
}
/**
 * fu_struct_genesys_ts_firmware_info_get_address_mode: (skip):
 **/
guint8
fu_struct_genesys_ts_firmware_info_get_address_mode(const FuStructGenesysTsFirmwareInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_genesys_ts_firmware_info_get_build_fw_time: (skip):
 **/
gchar *
fu_struct_genesys_ts_firmware_info_get_build_fw_time(const FuStructGenesysTsFirmwareInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 7, 12, NULL);
}
/**
 * fu_struct_genesys_ts_firmware_info_get_update_fw_time: (skip):
 **/
gchar *
fu_struct_genesys_ts_firmware_info_get_update_fw_time(const FuStructGenesysTsFirmwareInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 19, 12, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_firmware_info_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_firmware_info_to_string(const FuStructGenesysTsFirmwareInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsFirmwareInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_ts_firmware_info_get_tool_version(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  tool_version: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  address_mode: 0x%x\n",
                           (guint) fu_struct_genesys_ts_firmware_info_get_address_mode(st));
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_firmware_info_get_build_fw_time(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  build_fw_time: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_firmware_info_get_update_fw_time(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  update_fw_time: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_firmware_info_validate_internal(FuStructGenesysTsFirmwareInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_firmware_info_parse_internal(FuStructGenesysTsFirmwareInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_firmware_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_firmware_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_firmware_info_parse: (skip):
 **/
FuStructGenesysTsFirmwareInfo *
fu_struct_genesys_ts_firmware_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsFirmwareInfo) st = fu_struct_genesys_ts_firmware_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 31, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsFirmwareInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 31);
    if (!fu_struct_genesys_ts_firmware_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_vendor_support_ref: (skip):
 **/
FuStructGenesysTsVendorSupport *
fu_struct_genesys_ts_vendor_support_ref(FuStructGenesysTsVendorSupport *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_vendor_support_unref: (skip):
 **/
void
fu_struct_genesys_ts_vendor_support_unref(FuStructGenesysTsVendorSupport *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsVendorSupport refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_vendor_support_new_internal: (skip):
 **/
static FuStructGenesysTsVendorSupport *
fu_struct_genesys_ts_vendor_support_new_internal(void)
{
    FuStructGenesysTsVendorSupport *st = g_new0(FuStructGenesysTsVendorSupport, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_vendor_support_get_version: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_version(const FuStructGenesysTsVendorSupport *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 2, NULL);
}
/**
 * fu_struct_genesys_ts_vendor_support_get_reserved1: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_reserved1(const FuStructGenesysTsVendorSupport *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 2, 8, NULL);
}
/**
 * fu_struct_genesys_ts_vendor_support_get_codesign_check: (skip):
 **/
FuGenesysVsCodesignCheck
fu_struct_genesys_ts_vendor_support_get_codesign_check(const FuStructGenesysTsVendorSupport *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_genesys_ts_vendor_support_get_reserved2: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_reserved2(const FuStructGenesysTsVendorSupport *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 11, 4, NULL);
}
/**
 * fu_struct_genesys_ts_vendor_support_get_hid_isp: (skip):
 **/
FuGenesysVsHidIsp
fu_struct_genesys_ts_vendor_support_get_hid_isp(const FuStructGenesysTsVendorSupport *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[15];
}
/**
 * fu_struct_genesys_ts_vendor_support_get_reserved3: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_reserved3(const FuStructGenesysTsVendorSupport *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 16, 15, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_vendor_support_set_version: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_version(FuStructGenesysTsVendorSupport *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 2);
        return TRUE;
    }
    len = strlen(value);
    if (len > 2) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsVendorSupport.version (0x%x bytes)",
                    value, (guint) len, (guint) 2);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_set_reserved1: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_reserved1(FuStructGenesysTsVendorSupport *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 2, 0x0, 8);
        return TRUE;
    }
    len = strlen(value);
    if (len > 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsVendorSupport.reserved1 (0x%x bytes)",
                    value, (guint) len, (guint) 8);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_set_codesign_check: (skip):
 **/
void
fu_struct_genesys_ts_vendor_support_set_codesign_check(FuStructGenesysTsVendorSupport *st, FuGenesysVsCodesignCheck value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[10] = value;
}
/**
 * fu_struct_genesys_ts_vendor_support_set_reserved2: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_reserved2(FuStructGenesysTsVendorSupport *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 11, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsVendorSupport.reserved2 (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 11, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_set_hid_isp: (skip):
 **/
void
fu_struct_genesys_ts_vendor_support_set_hid_isp(FuStructGenesysTsVendorSupport *st, FuGenesysVsHidIsp value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[15] = value;
}
/**
 * fu_struct_genesys_ts_vendor_support_set_reserved3: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_reserved3(FuStructGenesysTsVendorSupport *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 16, 0x0, 15);
        return TRUE;
    }
    len = strlen(value);
    if (len > 15) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructGenesysTsVendorSupport.reserved3 (0x%x bytes)",
                    value, (guint) len, (guint) 15);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 16, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_new: (skip):
 **/
FuStructGenesysTsVendorSupport *
fu_struct_genesys_ts_vendor_support_new(void)
{
    FuStructGenesysTsVendorSupport *st = fu_struct_genesys_ts_vendor_support_new_internal();
    st->buf = g_byte_array_sized_new(31);
    fu_byte_array_set_size(st->buf, 31, 0x0);
    return st;
}
/**
 * fu_struct_genesys_ts_vendor_support_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_vendor_support_to_string(const FuStructGenesysTsVendorSupport *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsVendorSupport:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_version(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_reserved1(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  reserved1: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_genesys_vs_codesign_check_to_string(fu_struct_genesys_ts_vendor_support_get_codesign_check(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  codesign_check: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_vendor_support_get_codesign_check(st), tmp);
        } else {
            g_string_append_printf(str, "  codesign_check: 0x%x\n", (guint) fu_struct_genesys_ts_vendor_support_get_codesign_check(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_reserved2(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  reserved2: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_genesys_vs_hid_isp_to_string(fu_struct_genesys_ts_vendor_support_get_hid_isp(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  hid_isp: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_vendor_support_get_hid_isp(st), tmp);
        } else {
            g_string_append_printf(str, "  hid_isp: 0x%x\n", (guint) fu_struct_genesys_ts_vendor_support_get_hid_isp(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_reserved3(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  reserved3: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_vendor_support_validate_internal(FuStructGenesysTsVendorSupport *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_vendor_support_parse_internal(FuStructGenesysTsVendorSupport *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_vendor_support_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_vendor_support_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_vendor_support_parse: (skip):
 **/
FuStructGenesysTsVendorSupport *
fu_struct_genesys_ts_vendor_support_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsVendorSupport) st = fu_struct_genesys_ts_vendor_support_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 31, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsVendorSupport: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 31);
    if (!fu_struct_genesys_ts_vendor_support_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_brand_project_ref: (skip):
 **/
FuStructGenesysTsBrandProject *
fu_struct_genesys_ts_brand_project_ref(FuStructGenesysTsBrandProject *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_ts_brand_project_unref: (skip):
 **/
void
fu_struct_genesys_ts_brand_project_unref(FuStructGenesysTsBrandProject *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysTsBrandProject refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_ts_brand_project_new_internal: (skip):
 **/
static FuStructGenesysTsBrandProject *
fu_struct_genesys_ts_brand_project_new_internal(void)
{
    FuStructGenesysTsBrandProject *st = g_new0(FuStructGenesysTsBrandProject, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_ts_brand_project_get_project: (skip):
 **/
gchar *
fu_struct_genesys_ts_brand_project_get_project(const FuStructGenesysTsBrandProject *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 15, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_brand_project_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_ts_brand_project_to_string(const FuStructGenesysTsBrandProject *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysTsBrandProject:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_brand_project_get_project(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  project: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_ts_brand_project_validate_internal(FuStructGenesysTsBrandProject *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_genesys_ts_brand_project_parse_internal(FuStructGenesysTsBrandProject *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_ts_brand_project_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_ts_brand_project_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_ts_brand_project_parse: (skip):
 **/
FuStructGenesysTsBrandProject *
fu_struct_genesys_ts_brand_project_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysTsBrandProject) st = fu_struct_genesys_ts_brand_project_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 15, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysTsBrandProject: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 15);
    if (!fu_struct_genesys_ts_brand_project_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_ref: (skip):
 **/
FuStructGenesysFwCodesignInfoRsa *
fu_struct_genesys_fw_codesign_info_rsa_ref(FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_unref: (skip):
 **/
void
fu_struct_genesys_fw_codesign_info_rsa_unref(FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysFwCodesignInfoRsa refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_new_internal: (skip):
 **/
static FuStructGenesysFwCodesignInfoRsa *
fu_struct_genesys_fw_codesign_info_rsa_new_internal(void)
{
    FuStructGenesysFwCodesignInfoRsa *st = g_new0(FuStructGenesysFwCodesignInfoRsa, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_tag_n: (skip):
 **/
static guint32
fu_struct_genesys_fw_codesign_info_rsa_get_tag_n(const FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_text_n: (skip):
 **/
gchar *
fu_struct_genesys_fw_codesign_info_rsa_get_text_n(const FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 512, NULL);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_end_n: (skip):
 **/
static guint16
fu_struct_genesys_fw_codesign_info_rsa_get_end_n(const FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 516, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_tag_e: (skip):
 **/
static guint32
fu_struct_genesys_fw_codesign_info_rsa_get_tag_e(const FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 518, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_text_e: (skip):
 **/
gchar *
fu_struct_genesys_fw_codesign_info_rsa_get_text_e(const FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 522, 6, NULL);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_end_e: (skip):
 **/
static guint16
fu_struct_genesys_fw_codesign_info_rsa_get_end_e(const FuStructGenesysFwCodesignInfoRsa *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 528, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_signature: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_rsa_get_signature(const FuStructGenesysFwCodesignInfoRsa *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 256;
    return st->buf->data + 530;
}

/* setters */
/**
 * fu_struct_genesys_fw_codesign_info_rsa_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_codesign_info_rsa_to_string(const FuStructGenesysFwCodesignInfoRsa *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysFwCodesignInfoRsa:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_codesign_info_rsa_get_text_n(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_n: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_codesign_info_rsa_get_text_e(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_e: %s\n", tmp);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_rsa_get_signature(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  signature: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_fw_codesign_info_rsa_validate_internal(FuStructGenesysFwCodesignInfoRsa *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_genesys_fw_codesign_info_rsa_get_tag_n(st) != 0x4E203D20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwCodesignInfoRsa.tag_n was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x4E203D20,
                    (guint) fu_struct_genesys_fw_codesign_info_rsa_get_tag_n(st));
        return FALSE;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_end_n(st) != 0x0D0A) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwCodesignInfoRsa.end_n was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0D0A,
                    (guint) fu_struct_genesys_fw_codesign_info_rsa_get_end_n(st));
        return FALSE;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_tag_e(st) != 0x45203D20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwCodesignInfoRsa.tag_e was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x45203D20,
                    (guint) fu_struct_genesys_fw_codesign_info_rsa_get_tag_e(st));
        return FALSE;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_end_e(st) != 0x0D0A) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwCodesignInfoRsa.end_e was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0D0A,
                    (guint) fu_struct_genesys_fw_codesign_info_rsa_get_end_e(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_validate_stream: (skip):
 **/
gboolean
fu_struct_genesys_fw_codesign_info_rsa_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFwCodesignInfoRsa) st = fu_struct_genesys_fw_codesign_info_rsa_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 786, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysFwCodesignInfoRsa failed read of 0x%x: ", (guint) 786);
        return FALSE;
    }
    if (st->buf->len != 786) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysFwCodesignInfoRsa requested 0x%x and got 0x%x",
                    (guint) 786,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_genesys_fw_codesign_info_rsa_validate_internal(st, error);
}
static gboolean
fu_struct_genesys_fw_codesign_info_rsa_parse_internal(FuStructGenesysFwCodesignInfoRsa *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_fw_codesign_info_rsa_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_fw_codesign_info_rsa_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_parse_stream: (skip):
 **/
FuStructGenesysFwCodesignInfoRsa *
fu_struct_genesys_fw_codesign_info_rsa_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFwCodesignInfoRsa) st = fu_struct_genesys_fw_codesign_info_rsa_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 786, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysFwCodesignInfoRsa failed read of 0x%x: ", (guint) 786);
        return NULL;
    }
    if (st->buf->len != 786) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysFwCodesignInfoRsa requested 0x%x and got 0x%x",
                    (guint) 786,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_genesys_fw_codesign_info_rsa_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_ref: (skip):
 **/
FuStructGenesysFwRsaPublicKeyText *
fu_struct_genesys_fw_rsa_public_key_text_ref(FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_unref: (skip):
 **/
void
fu_struct_genesys_fw_rsa_public_key_text_unref(FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysFwRsaPublicKeyText refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_new_internal: (skip):
 **/
static FuStructGenesysFwRsaPublicKeyText *
fu_struct_genesys_fw_rsa_public_key_text_new_internal(void)
{
    FuStructGenesysFwRsaPublicKeyText *st = g_new0(FuStructGenesysFwRsaPublicKeyText, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_tag_n: (skip):
 **/
static guint32
fu_struct_genesys_fw_rsa_public_key_text_get_tag_n(const FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_text_n: (skip):
 **/
gchar *
fu_struct_genesys_fw_rsa_public_key_text_get_text_n(const FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 512, NULL);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_end_n: (skip):
 **/
static guint16
fu_struct_genesys_fw_rsa_public_key_text_get_end_n(const FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 516, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_tag_e: (skip):
 **/
static guint32
fu_struct_genesys_fw_rsa_public_key_text_get_tag_e(const FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 518, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_text_e: (skip):
 **/
gchar *
fu_struct_genesys_fw_rsa_public_key_text_get_text_e(const FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 522, 6, NULL);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_end_e: (skip):
 **/
static guint16
fu_struct_genesys_fw_rsa_public_key_text_get_end_e(const FuStructGenesysFwRsaPublicKeyText *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 528, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_genesys_fw_rsa_public_key_text_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_rsa_public_key_text_to_string(const FuStructGenesysFwRsaPublicKeyText *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysFwRsaPublicKeyText:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_rsa_public_key_text_get_text_n(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_n: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_rsa_public_key_text_get_text_e(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_e: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_fw_rsa_public_key_text_validate_internal(FuStructGenesysFwRsaPublicKeyText *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_genesys_fw_rsa_public_key_text_get_tag_n(st) != 0x4E203D20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwRsaPublicKeyText.tag_n was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x4E203D20,
                    (guint) fu_struct_genesys_fw_rsa_public_key_text_get_tag_n(st));
        return FALSE;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_end_n(st) != 0x0D0A) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwRsaPublicKeyText.end_n was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0D0A,
                    (guint) fu_struct_genesys_fw_rsa_public_key_text_get_end_n(st));
        return FALSE;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_tag_e(st) != 0x45203D20) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwRsaPublicKeyText.tag_e was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x45203D20,
                    (guint) fu_struct_genesys_fw_rsa_public_key_text_get_tag_e(st));
        return FALSE;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_end_e(st) != 0x0D0A) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructGenesysFwRsaPublicKeyText.end_e was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0D0A,
                    (guint) fu_struct_genesys_fw_rsa_public_key_text_get_end_e(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_validate: (skip):
 **/
gboolean
fu_struct_genesys_fw_rsa_public_key_text_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructGenesysFwRsaPublicKeyText st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 530, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysFwRsaPublicKeyText: ");
        return FALSE;
    }
    if (!fu_struct_genesys_fw_rsa_public_key_text_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
static gboolean
fu_struct_genesys_fw_rsa_public_key_text_parse_internal(FuStructGenesysFwRsaPublicKeyText *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_fw_rsa_public_key_text_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_fw_rsa_public_key_text_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_fw_rsa_public_key_text_parse: (skip):
 **/
FuStructGenesysFwRsaPublicKeyText *
fu_struct_genesys_fw_rsa_public_key_text_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFwRsaPublicKeyText) st = fu_struct_genesys_fw_rsa_public_key_text_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 530, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysFwRsaPublicKeyText: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 530);
    if (!fu_struct_genesys_fw_rsa_public_key_text_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_ref: (skip):
 **/
FuStructGenesysFwCodesignInfoEcdsa *
fu_struct_genesys_fw_codesign_info_ecdsa_ref(FuStructGenesysFwCodesignInfoEcdsa *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_unref: (skip):
 **/
void
fu_struct_genesys_fw_codesign_info_ecdsa_unref(FuStructGenesysFwCodesignInfoEcdsa *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysFwCodesignInfoEcdsa refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_new_internal: (skip):
 **/
static FuStructGenesysFwCodesignInfoEcdsa *
fu_struct_genesys_fw_codesign_info_ecdsa_new_internal(void)
{
    FuStructGenesysFwCodesignInfoEcdsa *st = g_new0(FuStructGenesysFwCodesignInfoEcdsa, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_get_hash: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_ecdsa_get_hash(const FuStructGenesysFwCodesignInfoEcdsa *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 32;
    return st->buf->data + 0;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_get_key: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_ecdsa_get_key(const FuStructGenesysFwCodesignInfoEcdsa *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 64;
    return st->buf->data + 32;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_get_signature: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_ecdsa_get_signature(const FuStructGenesysFwCodesignInfoEcdsa *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 64;
    return st->buf->data + 96;
}

/* setters */
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_codesign_info_ecdsa_to_string(const FuStructGenesysFwCodesignInfoEcdsa *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysFwCodesignInfoEcdsa:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_ecdsa_get_hash(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  hash: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_ecdsa_get_key(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  key: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_ecdsa_get_signature(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  signature: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_fw_codesign_info_ecdsa_validate_internal(FuStructGenesysFwCodesignInfoEcdsa *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_validate: (skip):
 **/
gboolean
fu_struct_genesys_fw_codesign_info_ecdsa_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructGenesysFwCodesignInfoEcdsa st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 160, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysFwCodesignInfoEcdsa: ");
        return FALSE;
    }
    if (!fu_struct_genesys_fw_codesign_info_ecdsa_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_validate_stream: (skip):
 **/
gboolean
fu_struct_genesys_fw_codesign_info_ecdsa_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFwCodesignInfoEcdsa) st = fu_struct_genesys_fw_codesign_info_ecdsa_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 160, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysFwCodesignInfoEcdsa failed read of 0x%x: ", (guint) 160);
        return FALSE;
    }
    if (st->buf->len != 160) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysFwCodesignInfoEcdsa requested 0x%x and got 0x%x",
                    (guint) 160,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_genesys_fw_codesign_info_ecdsa_validate_internal(st, error);
}
static gboolean
fu_struct_genesys_fw_codesign_info_ecdsa_parse_internal(FuStructGenesysFwCodesignInfoEcdsa *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_fw_codesign_info_ecdsa_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_fw_codesign_info_ecdsa_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_parse: (skip):
 **/
FuStructGenesysFwCodesignInfoEcdsa *
fu_struct_genesys_fw_codesign_info_ecdsa_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFwCodesignInfoEcdsa) st = fu_struct_genesys_fw_codesign_info_ecdsa_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 160, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysFwCodesignInfoEcdsa: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 160);
    if (!fu_struct_genesys_fw_codesign_info_ecdsa_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_parse_stream: (skip):
 **/
FuStructGenesysFwCodesignInfoEcdsa *
fu_struct_genesys_fw_codesign_info_ecdsa_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFwCodesignInfoEcdsa) st = fu_struct_genesys_fw_codesign_info_ecdsa_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 160, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructGenesysFwCodesignInfoEcdsa failed read of 0x%x: ", (guint) 160);
        return NULL;
    }
    if (st->buf->len != 160) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructGenesysFwCodesignInfoEcdsa requested 0x%x and got 0x%x",
                    (guint) 160,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_genesys_fw_codesign_info_ecdsa_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_ecdsa_public_key_ref: (skip):
 **/
FuStructGenesysFwEcdsaPublicKey *
fu_struct_genesys_fw_ecdsa_public_key_ref(FuStructGenesysFwEcdsaPublicKey *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_genesys_fw_ecdsa_public_key_unref: (skip):
 **/
void
fu_struct_genesys_fw_ecdsa_public_key_unref(FuStructGenesysFwEcdsaPublicKey *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructGenesysFwEcdsaPublicKey refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_genesys_fw_ecdsa_public_key_new_internal: (skip):
 **/
static FuStructGenesysFwEcdsaPublicKey *
fu_struct_genesys_fw_ecdsa_public_key_new_internal(void)
{
    FuStructGenesysFwEcdsaPublicKey *st = g_new0(FuStructGenesysFwEcdsaPublicKey, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_genesys_fw_ecdsa_public_key_get_key: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_ecdsa_public_key_get_key(const FuStructGenesysFwEcdsaPublicKey *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 64;
    return st->buf->data + 0;
}

/* setters */
/**
 * fu_struct_genesys_fw_ecdsa_public_key_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_ecdsa_public_key_to_string(const FuStructGenesysFwEcdsaPublicKey *st)
{
    g_autoptr(GString) str = g_string_new("FuStructGenesysFwEcdsaPublicKey:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_ecdsa_public_key_get_key(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  key: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_genesys_fw_ecdsa_public_key_validate_internal(FuStructGenesysFwEcdsaPublicKey *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_genesys_fw_ecdsa_public_key_validate: (skip):
 **/
gboolean
fu_struct_genesys_fw_ecdsa_public_key_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructGenesysFwEcdsaPublicKey st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysFwEcdsaPublicKey: ");
        return FALSE;
    }
    if (!fu_struct_genesys_fw_ecdsa_public_key_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
static gboolean
fu_struct_genesys_fw_ecdsa_public_key_parse_internal(FuStructGenesysFwEcdsaPublicKey *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_genesys_fw_ecdsa_public_key_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_genesys_fw_ecdsa_public_key_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_genesys_fw_ecdsa_public_key_parse: (skip):
 **/
FuStructGenesysFwEcdsaPublicKey *
fu_struct_genesys_fw_ecdsa_public_key_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructGenesysFwEcdsaPublicKey) st = fu_struct_genesys_fw_ecdsa_public_key_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructGenesysFwEcdsaPublicKey: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 64);
    if (!fu_struct_genesys_fw_ecdsa_public_key_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
